## Description

*Replace this paragraph with a description of what this PR is doing. If you're modifying existing behavior, describe the existing behavior, how this PR is changing it, and what motivated the change. If you're changing visual properties, consider including before/after screenshots (and runnable code snippets to reproduce them).*

## Related Issues

*Replace this paragraph with a list of issues related to this PR from our [issue database]. Indicate, which of these issues are resolved or fixed by this PR. There should be at least one issue listed here.*

## Tests

I added the following tests:

*Replace this with a list of the tests that you added as part of this PR. A change in behaviour with no test covering it
will likely get reverted accidentally sooner or later. PRs must include tests for all changed/updated/fixed behaviors. See [Test Coverage].*

## Checklist

Before you create this PR confirm that it meets all requirements listed below by checking the relevant checkboxes (`[x]`). This will ensure a smooth and quick review process.

- [ ] I read the [Contributor Guide] and followed the process outlined there for submitting PRs.
- [ ] I signed the [CLA].
- [ ] I read and followed the [Flutter Style Guide], including [Features we expect every widget to implement].
- [ ] I read the [Tree Hygiene] wiki page, which explains my responsibilities.
- [ ] I updated/added relevant documentation (doc comments with `///`).
- [ ] All existing and new tests are passing.
- [ ] The analyzer (`flutter analyze --flutter-repo`) does not report any problems on my PR.
- [ ] I am willing to follow-up on review comments in a timely manner.

## Breaking Change

Did any tests fail when you ran them? Please read [Handling breaking changes].

- [ ] No, no existing tests failed, so this is *not* a breaking change.
- [ ] Yes, this is a breaking change. *If not, delete the remainder of this section.*
   - [ ] I wrote a design doc: https://flutter.dev/go/template *Replace this with a link to your design doc's short link*
   - [ ] I got input from the developer relations team, specifically from: *Replace with the names of who gave advice*
   - [ ] I wrote a migration guide: *Replace with a link to your migration guide*

<!-- Links -->
[issue database]: https://github.com/flutter/flutter/issues
[Contributor Guide]: https://github.com/flutter/flutter/wiki/Tree-hygiene#overview
[Test Coverage]: https://github.com/flutter/flutter/wiki/Test-coverage-for-package%3Aflutter
[Flutter Style Guide]: https://github.com/flutter/flutter/wiki/Style-guide-for-Flutter-repo
[Features we expect every widget to implement]: https://github.com/flutter/flutter/wiki/Style-guide-for-Flutter-repo#features-we-expect-every-widget-to-implement
[CLA]: https://cla.developers.google.com/
[Tree Hygiene]: https://github.com/flutter/flutter/wiki/Tree-hygiene
[Handling breaking changes]: https://github.com/flutter/flutter/wiki/Tree-hygiene#handling-breaking-changes
