/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Insets;
import android.graphics.Rect;
import android.os.Build;
import android.os.LocaleList;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.PointerIcon;
import android.view.View;
import android.view.ViewStructure;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.autofill.AutofillValue;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import io.flutter.Log;
import io.flutter.embedding.android.AndroidKeyProcessor;
import io.flutter.embedding.android.AndroidTouchProcessor;
import io.flutter.embedding.android.FlutterSurfaceView;
import io.flutter.embedding.android.FlutterTextureView;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.renderer.FlutterRenderer;
import io.flutter.embedding.engine.renderer.FlutterUiDisplayListener;
import io.flutter.embedding.engine.renderer.RenderSurface;
import io.flutter.embedding.engine.systemchannels.SettingsChannel;
import io.flutter.plugin.editing.TextInputPlugin;
import io.flutter.plugin.mouse.MouseCursorPlugin;
import io.flutter.view.AccessibilityBridge;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class FlutterView
extends FrameLayout
implements MouseCursorPlugin.MouseCursorViewDelegate {
    private static final String TAG = "FlutterView";
    @Nullable
    private FlutterSurfaceView flutterSurfaceView;
    @Nullable
    private FlutterTextureView flutterTextureView;
    @Nullable
    private RenderSurface renderSurface;
    private final Set<FlutterUiDisplayListener> flutterUiDisplayListeners = new HashSet<FlutterUiDisplayListener>();
    private boolean isFlutterUiDisplayed;
    @Nullable
    private FlutterEngine flutterEngine;
    @NonNull
    private final Set<FlutterEngineAttachmentListener> flutterEngineAttachmentListeners = new HashSet<FlutterEngineAttachmentListener>();
    @Nullable
    private MouseCursorPlugin mouseCursorPlugin;
    @Nullable
    private TextInputPlugin textInputPlugin;
    @Nullable
    private AndroidKeyProcessor androidKeyProcessor;
    @Nullable
    private AndroidTouchProcessor androidTouchProcessor;
    @Nullable
    private AccessibilityBridge accessibilityBridge;
    private final FlutterRenderer.ViewportMetrics viewportMetrics = new FlutterRenderer.ViewportMetrics();
    private final AccessibilityBridge.OnAccessibilityChangeListener onAccessibilityChangeListener = new AccessibilityBridge.OnAccessibilityChangeListener(){

        @Override
        public void onAccessibilityChanged(boolean isAccessibilityEnabled, boolean isTouchExplorationEnabled) {
            FlutterView.this.resetWillNotDraw(isAccessibilityEnabled, isTouchExplorationEnabled);
        }
    };
    private final FlutterUiDisplayListener flutterUiDisplayListener = new FlutterUiDisplayListener(){

        @Override
        public void onFlutterUiDisplayed() {
            FlutterView.this.isFlutterUiDisplayed = true;
            for (FlutterUiDisplayListener listener : FlutterView.this.flutterUiDisplayListeners) {
                listener.onFlutterUiDisplayed();
            }
        }

        @Override
        public void onFlutterUiNoLongerDisplayed() {
            FlutterView.this.isFlutterUiDisplayed = false;
            for (FlutterUiDisplayListener listener : FlutterView.this.flutterUiDisplayListeners) {
                listener.onFlutterUiNoLongerDisplayed();
            }
        }
    };

    public FlutterView(@NonNull Context context) {
        this(context, null, new FlutterSurfaceView(context));
    }

    @Deprecated
    public FlutterView(@NonNull Context context, @NonNull RenderMode renderMode) {
        super(context, null);
        if (renderMode == RenderMode.surface) {
            this.flutterSurfaceView = new FlutterSurfaceView(context);
            this.renderSurface = this.flutterSurfaceView;
        } else {
            this.flutterTextureView = new FlutterTextureView(context);
            this.renderSurface = this.flutterTextureView;
        }
        this.init();
    }

    @Deprecated
    public FlutterView(@NonNull Context context, @NonNull TransparencyMode transparencyMode) {
        this(context, null, new FlutterSurfaceView(context, transparencyMode == TransparencyMode.transparent));
    }

    public FlutterView(@NonNull Context context, @NonNull FlutterSurfaceView flutterSurfaceView) {
        this(context, null, flutterSurfaceView);
    }

    public FlutterView(@NonNull Context context, @NonNull FlutterTextureView flutterTextureView) {
        this(context, null, flutterTextureView);
    }

    public FlutterView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, new FlutterSurfaceView(context));
    }

    @Deprecated
    public FlutterView(@NonNull Context context, @NonNull RenderMode renderMode, @NonNull TransparencyMode transparencyMode) {
        super(context, null);
        if (renderMode == RenderMode.surface) {
            this.flutterSurfaceView = new FlutterSurfaceView(context, transparencyMode == TransparencyMode.transparent);
            this.renderSurface = this.flutterSurfaceView;
        } else {
            this.flutterTextureView = new FlutterTextureView(context);
            this.renderSurface = this.flutterTextureView;
        }
        this.init();
    }

    private FlutterView(@NonNull Context context, @Nullable AttributeSet attrs, @NonNull FlutterSurfaceView flutterSurfaceView) {
        super(context, attrs);
        this.flutterSurfaceView = flutterSurfaceView;
        this.renderSurface = flutterSurfaceView;
        this.init();
    }

    private FlutterView(@NonNull Context context, @Nullable AttributeSet attrs, @NonNull FlutterTextureView flutterTextureView) {
        super(context, attrs);
        this.flutterTextureView = flutterTextureView;
        this.renderSurface = flutterTextureView;
        this.init();
    }

    private void init() {
        Log.v(TAG, "Initializing FlutterView");
        if (this.flutterSurfaceView != null) {
            Log.v(TAG, "Internally using a FlutterSurfaceView.");
            this.addView((View)this.flutterSurfaceView);
        } else {
            Log.v(TAG, "Internally using a FlutterTextureView.");
            this.addView((View)this.flutterTextureView);
        }
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        if (Build.VERSION.SDK_INT >= 26) {
            this.setImportantForAutofill(4);
        }
    }

    public boolean hasRenderedFirstFrame() {
        return this.isFlutterUiDisplayed;
    }

    public void addOnFirstFrameRenderedListener(@NonNull FlutterUiDisplayListener listener) {
        this.flutterUiDisplayListeners.add(listener);
    }

    public void removeOnFirstFrameRenderedListener(@NonNull FlutterUiDisplayListener listener) {
        this.flutterUiDisplayListeners.remove(listener);
    }

    protected void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.flutterEngine != null) {
            Log.v(TAG, "Configuration changed. Sending locales and user settings to Flutter.");
            this.sendLocalesToFlutter(newConfig);
            this.sendUserSettingsToFlutter();
        }
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        super.onSizeChanged(width, height, oldWidth, oldHeight);
        Log.v(TAG, "Size changed. Sending Flutter new viewport metrics. FlutterView was " + oldWidth + " x " + oldHeight + ", it is now " + width + " x " + height);
        this.viewportMetrics.width = width;
        this.viewportMetrics.height = height;
        this.sendViewportMetricsToFlutter();
    }

    private ZeroSides calculateShouldZeroSides() {
        Context context = this.getContext();
        int orientation = context.getResources().getConfiguration().orientation;
        int rotation = ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getRotation();
        if (orientation == 2) {
            if (rotation == 1) {
                return ZeroSides.RIGHT;
            }
            if (rotation == 3) {
                return Build.VERSION.SDK_INT >= 23 ? ZeroSides.LEFT : ZeroSides.RIGHT;
            }
            if (rotation == 0 || rotation == 2) {
                return ZeroSides.BOTH;
            }
        }
        return ZeroSides.NONE;
    }

    @TargetApi(value=20)
    @RequiresApi(value=20)
    private int guessBottomKeyboardInset(WindowInsets insets) {
        int screenHeight = this.getRootView().getHeight();
        double keyboardHeightRatioHeuristic = 0.18;
        if ((double)insets.getSystemWindowInsetBottom() < (double)screenHeight * 0.18) {
            return 0;
        }
        return insets.getSystemWindowInsetBottom();
    }

    @TargetApi(value=20)
    @RequiresApi(value=20)
    @SuppressLint(value={"InlinedApi", "NewApi"})
    @NonNull
    public final WindowInsets onApplyWindowInsets(@NonNull WindowInsets insets) {
        WindowInsets newInsets = super.onApplyWindowInsets(insets);
        boolean statusBarHidden = (4 & this.getWindowSystemUiVisibility()) != 0;
        boolean navigationBarHidden = (2 & this.getWindowSystemUiVisibility()) != 0;
        ZeroSides zeroSides = ZeroSides.NONE;
        if (navigationBarHidden) {
            zeroSides = this.calculateShouldZeroSides();
        }
        this.viewportMetrics.paddingTop = statusBarHidden ? 0 : insets.getSystemWindowInsetTop();
        this.viewportMetrics.paddingRight = zeroSides == ZeroSides.RIGHT || zeroSides == ZeroSides.BOTH ? 0 : insets.getSystemWindowInsetRight();
        this.viewportMetrics.paddingBottom = 0;
        this.viewportMetrics.paddingLeft = zeroSides == ZeroSides.LEFT || zeroSides == ZeroSides.BOTH ? 0 : insets.getSystemWindowInsetLeft();
        this.viewportMetrics.viewInsetTop = 0;
        this.viewportMetrics.viewInsetRight = 0;
        this.viewportMetrics.viewInsetBottom = navigationBarHidden ? this.guessBottomKeyboardInset(insets) : insets.getSystemWindowInsetBottom();
        this.viewportMetrics.viewInsetLeft = 0;
        if (Build.VERSION.SDK_INT >= 29) {
            Insets systemGestureInsets = insets.getSystemGestureInsets();
            this.viewportMetrics.systemGestureInsetTop = systemGestureInsets.top;
            this.viewportMetrics.systemGestureInsetRight = systemGestureInsets.right;
            this.viewportMetrics.systemGestureInsetBottom = systemGestureInsets.bottom;
            this.viewportMetrics.systemGestureInsetLeft = systemGestureInsets.left;
        }
        Log.v(TAG, "Updating window insets (onApplyWindowInsets()):\nStatus bar insets: Top: " + this.viewportMetrics.paddingTop + ", Left: " + this.viewportMetrics.paddingLeft + ", Right: " + this.viewportMetrics.paddingRight + "\nKeyboard insets: Bottom: " + this.viewportMetrics.viewInsetBottom + ", Left: " + this.viewportMetrics.viewInsetLeft + ", Right: " + this.viewportMetrics.viewInsetRight + "System Gesture Insets - Left: " + this.viewportMetrics.systemGestureInsetLeft + ", Top: " + this.viewportMetrics.systemGestureInsetTop + ", Right: " + this.viewportMetrics.systemGestureInsetRight + ", Bottom: " + this.viewportMetrics.viewInsetBottom);
        this.sendViewportMetricsToFlutter();
        return newInsets;
    }

    protected boolean fitSystemWindows(@NonNull Rect insets) {
        if (Build.VERSION.SDK_INT <= 19) {
            this.viewportMetrics.paddingTop = insets.top;
            this.viewportMetrics.paddingRight = insets.right;
            this.viewportMetrics.paddingBottom = 0;
            this.viewportMetrics.paddingLeft = insets.left;
            this.viewportMetrics.viewInsetTop = 0;
            this.viewportMetrics.viewInsetRight = 0;
            this.viewportMetrics.viewInsetBottom = insets.bottom;
            this.viewportMetrics.viewInsetLeft = 0;
            Log.v(TAG, "Updating window insets (fitSystemWindows()):\nStatus bar insets: Top: " + this.viewportMetrics.paddingTop + ", Left: " + this.viewportMetrics.paddingLeft + ", Right: " + this.viewportMetrics.paddingRight + "\nKeyboard insets: Bottom: " + this.viewportMetrics.viewInsetBottom + ", Left: " + this.viewportMetrics.viewInsetLeft + ", Right: " + this.viewportMetrics.viewInsetRight);
            this.sendViewportMetricsToFlutter();
            return true;
        }
        return super.fitSystemWindows(insets);
    }

    @Nullable
    public InputConnection onCreateInputConnection(@NonNull EditorInfo outAttrs) {
        if (!this.isAttachedToFlutterEngine()) {
            return super.onCreateInputConnection(outAttrs);
        }
        return this.textInputPlugin.createInputConnection((View)this, outAttrs);
    }

    public boolean checkInputConnectionProxy(View view) {
        return this.flutterEngine != null ? this.flutterEngine.getPlatformViewsController().checkInputConnectionProxy(view) : super.checkInputConnectionProxy(view);
    }

    public boolean onKeyUp(int keyCode, @NonNull KeyEvent event) {
        if (!this.isAttachedToFlutterEngine()) {
            return super.onKeyUp(keyCode, event);
        }
        this.androidKeyProcessor.onKeyUp(event);
        return super.onKeyUp(keyCode, event);
    }

    public boolean onKeyDown(int keyCode, @NonNull KeyEvent event) {
        if (!this.isAttachedToFlutterEngine()) {
            return super.onKeyDown(keyCode, event);
        }
        this.androidKeyProcessor.onKeyDown(event);
        return super.onKeyDown(keyCode, event);
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (!this.isAttachedToFlutterEngine()) {
            return super.onTouchEvent(event);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.requestUnbufferedDispatch(event);
        }
        return this.androidTouchProcessor.onTouchEvent(event);
    }

    public boolean onGenericMotionEvent(@NonNull MotionEvent event) {
        boolean handled = this.isAttachedToFlutterEngine() && this.androidTouchProcessor.onGenericMotionEvent(event);
        return handled ? true : super.onGenericMotionEvent(event);
    }

    public boolean onHoverEvent(@NonNull MotionEvent event) {
        if (!this.isAttachedToFlutterEngine()) {
            return super.onHoverEvent(event);
        }
        boolean handled = this.accessibilityBridge.onAccessibilityHoverEvent(event);
        if (!handled) {
            // empty if block
        }
        return handled;
    }

    @Nullable
    public AccessibilityNodeProvider getAccessibilityNodeProvider() {
        if (this.accessibilityBridge != null && this.accessibilityBridge.isAccessibilityEnabled()) {
            return this.accessibilityBridge;
        }
        return null;
    }

    private void resetWillNotDraw(boolean isAccessibilityEnabled, boolean isTouchExplorationEnabled) {
        if (!this.flutterEngine.getRenderer().isSoftwareRenderingEnabled()) {
            this.setWillNotDraw(!isAccessibilityEnabled && !isTouchExplorationEnabled);
        } else {
            this.setWillNotDraw(false);
        }
    }

    @Override
    @TargetApi(value=24)
    @RequiresApi(value=24)
    @NonNull
    public PointerIcon getSystemPointerIcon(int type) {
        return PointerIcon.getSystemIcon((Context)this.getContext(), (int)type);
    }

    public void attachToFlutterEngine(@NonNull FlutterEngine flutterEngine) {
        Log.v(TAG, "Attaching to a FlutterEngine: " + flutterEngine);
        if (this.isAttachedToFlutterEngine()) {
            if (flutterEngine == this.flutterEngine) {
                Log.v(TAG, "Already attached to this engine. Doing nothing.");
                return;
            }
            Log.v(TAG, "Currently attached to a different engine. Detaching and then attaching to new engine.");
            this.detachFromFlutterEngine();
        }
        this.flutterEngine = flutterEngine;
        FlutterRenderer flutterRenderer = this.flutterEngine.getRenderer();
        this.isFlutterUiDisplayed = flutterRenderer.isDisplayingFlutterUi();
        this.renderSurface.attachToRenderer(flutterRenderer);
        flutterRenderer.addIsDisplayingFlutterUiListener(this.flutterUiDisplayListener);
        if (Build.VERSION.SDK_INT >= 24) {
            this.mouseCursorPlugin = new MouseCursorPlugin(this, this.flutterEngine.getMouseCursorChannel());
        }
        this.textInputPlugin = new TextInputPlugin((View)this, this.flutterEngine.getTextInputChannel(), this.flutterEngine.getPlatformViewsController());
        this.androidKeyProcessor = new AndroidKeyProcessor(this.flutterEngine.getKeyEventChannel(), this.textInputPlugin);
        this.androidTouchProcessor = new AndroidTouchProcessor(this.flutterEngine.getRenderer());
        this.accessibilityBridge = new AccessibilityBridge((View)this, flutterEngine.getAccessibilityChannel(), (AccessibilityManager)this.getContext().getSystemService("accessibility"), this.getContext().getContentResolver(), this.flutterEngine.getPlatformViewsController());
        this.accessibilityBridge.setOnAccessibilityChangeListener(this.onAccessibilityChangeListener);
        this.resetWillNotDraw(this.accessibilityBridge.isAccessibilityEnabled(), this.accessibilityBridge.isTouchExplorationEnabled());
        this.flutterEngine.getPlatformViewsController().attachAccessibilityBridge(this.accessibilityBridge);
        this.textInputPlugin.getInputMethodManager().restartInput((View)this);
        this.sendUserSettingsToFlutter();
        this.sendLocalesToFlutter(this.getResources().getConfiguration());
        this.sendViewportMetricsToFlutter();
        flutterEngine.getPlatformViewsController().attachToView((View)this);
        for (FlutterEngineAttachmentListener listener : this.flutterEngineAttachmentListeners) {
            listener.onFlutterEngineAttachedToFlutterView(flutterEngine);
        }
        if (this.isFlutterUiDisplayed) {
            this.flutterUiDisplayListener.onFlutterUiDisplayed();
        }
    }

    public void detachFromFlutterEngine() {
        Log.v(TAG, "Detaching from a FlutterEngine: " + this.flutterEngine);
        if (!this.isAttachedToFlutterEngine()) {
            Log.v(TAG, "Not attached to an engine. Doing nothing.");
            return;
        }
        for (FlutterEngineAttachmentListener listener : this.flutterEngineAttachmentListeners) {
            listener.onFlutterEngineDetachedFromFlutterView();
        }
        this.flutterEngine.getPlatformViewsController().detachFromView();
        this.flutterEngine.getPlatformViewsController().detachAccessibiltyBridge();
        this.accessibilityBridge.release();
        this.accessibilityBridge = null;
        this.textInputPlugin.getInputMethodManager().restartInput((View)this);
        this.textInputPlugin.destroy();
        FlutterRenderer flutterRenderer = this.flutterEngine.getRenderer();
        this.isFlutterUiDisplayed = false;
        flutterRenderer.removeIsDisplayingFlutterUiListener(this.flutterUiDisplayListener);
        flutterRenderer.stopRenderingToSurface();
        flutterRenderer.setSemanticsEnabled(false);
        this.renderSurface.detachFromRenderer();
        this.flutterEngine = null;
    }

    @VisibleForTesting
    public boolean isAttachedToFlutterEngine() {
        return this.flutterEngine != null && this.flutterEngine.getRenderer() == this.renderSurface.getAttachedRenderer();
    }

    @VisibleForTesting
    @Nullable
    public FlutterEngine getAttachedFlutterEngine() {
        return this.flutterEngine;
    }

    @VisibleForTesting
    public void addFlutterEngineAttachmentListener(@NonNull FlutterEngineAttachmentListener listener) {
        this.flutterEngineAttachmentListeners.add(listener);
    }

    @VisibleForTesting
    public void removeFlutterEngineAttachmentListener(@NonNull FlutterEngineAttachmentListener listener) {
        this.flutterEngineAttachmentListeners.remove(listener);
    }

    private void sendLocalesToFlutter(@NonNull Configuration config) {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        if (Build.VERSION.SDK_INT >= 24) {
            LocaleList localeList = config.getLocales();
            int localeCount = localeList.size();
            for (int index = 0; index < localeCount; ++index) {
                Locale locale = localeList.get(index);
                locales.add(locale);
            }
        } else {
            locales.add(config.locale);
        }
        Locale platformResolvedLocale = null;
        if (Build.VERSION.SDK_INT >= 26) {
            ArrayList<Locale.LanguageRange> languageRanges = new ArrayList<Locale.LanguageRange>();
            LocaleList localeList = config.getLocales();
            int localeCount = localeList.size();
            for (int index = 0; index < localeCount; ++index) {
                Locale locale = localeList.get(index);
                languageRanges.add(new Locale.LanguageRange(locale.toLanguageTag()));
            }
            platformResolvedLocale = Locale.lookup(languageRanges, Arrays.asList(Locale.getAvailableLocales()));
        }
        this.flutterEngine.getLocalizationChannel().sendLocales(locales, platformResolvedLocale);
    }

    @VisibleForTesting
    void sendUserSettingsToFlutter() {
        boolean isNightModeOn = (this.getResources().getConfiguration().uiMode & 0x30) == 32;
        SettingsChannel.PlatformBrightness brightness = isNightModeOn ? SettingsChannel.PlatformBrightness.dark : SettingsChannel.PlatformBrightness.light;
        this.flutterEngine.getSettingsChannel().startMessage().setTextScaleFactor(this.getResources().getConfiguration().fontScale).setUse24HourFormat(DateFormat.is24HourFormat((Context)this.getContext())).setPlatformBrightness(brightness).send();
    }

    private void sendViewportMetricsToFlutter() {
        if (!this.isAttachedToFlutterEngine()) {
            Log.w(TAG, "Tried to send viewport metrics from Android to Flutter but this FlutterView was not attached to a FlutterEngine.");
            return;
        }
        this.viewportMetrics.devicePixelRatio = this.getResources().getDisplayMetrics().density;
        this.flutterEngine.getRenderer().setViewportMetrics(this.viewportMetrics);
    }

    public void onProvideAutofillVirtualStructure(ViewStructure structure, int flags) {
        super.onProvideAutofillVirtualStructure(structure, flags);
        this.textInputPlugin.onProvideAutofillVirtualStructure(structure, flags);
    }

    public void autofill(SparseArray<AutofillValue> values) {
        this.textInputPlugin.autofill(values);
    }

    @VisibleForTesting
    public static interface FlutterEngineAttachmentListener {
        public void onFlutterEngineAttachedToFlutterView(@NonNull FlutterEngine var1);

        public void onFlutterEngineDetachedFromFlutterView();
    }

    @Deprecated
    public static enum TransparencyMode {
        opaque,
        transparent;

    }

    @Deprecated
    public static enum RenderMode {
        surface,
        texture;

    }

    private static enum ZeroSides {
        NONE,
        LEFT,
        RIGHT,
        BOTH;

    }
}

