/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.loader;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.loader.ResourceExtractor;
import io.flutter.util.PathUtils;
import io.flutter.view.VsyncWaiter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class FlutterLoader {
    private static final String TAG = "FlutterLoader";
    private static final String AOT_SHARED_LIBRARY_NAME = "aot-shared-library-name";
    private static final String SNAPSHOT_ASSET_PATH_KEY = "snapshot-asset-path";
    private static final String VM_SNAPSHOT_DATA_KEY = "vm-snapshot-data";
    private static final String ISOLATE_SNAPSHOT_DATA_KEY = "isolate-snapshot-data";
    private static final String FLUTTER_ASSETS_DIR_KEY = "flutter-assets-dir";
    private static final String PUBLIC_AOT_SHARED_LIBRARY_NAME = FlutterLoader.class.getName() + '.' + "aot-shared-library-name";
    private static final String PUBLIC_VM_SNAPSHOT_DATA_KEY = FlutterLoader.class.getName() + '.' + "vm-snapshot-data";
    private static final String PUBLIC_ISOLATE_SNAPSHOT_DATA_KEY = FlutterLoader.class.getName() + '.' + "isolate-snapshot-data";
    private static final String PUBLIC_FLUTTER_ASSETS_DIR_KEY = FlutterLoader.class.getName() + '.' + "flutter-assets-dir";
    private static final String DEFAULT_AOT_SHARED_LIBRARY_NAME = "libapp.so";
    private static final String DEFAULT_VM_SNAPSHOT_DATA = "vm_snapshot_data";
    private static final String DEFAULT_ISOLATE_SNAPSHOT_DATA = "isolate_snapshot_data";
    private static final String DEFAULT_LIBRARY = "libflutter.so";
    private static final String DEFAULT_KERNEL_BLOB = "kernel_blob.bin";
    private static final String DEFAULT_FLUTTER_ASSETS_DIR = "flutter_assets";
    private String aotSharedLibraryName = "libapp.so";
    private String vmSnapshotData = "vm_snapshot_data";
    private String isolateSnapshotData = "isolate_snapshot_data";
    private String flutterAssetsDir = "flutter_assets";
    private static FlutterLoader instance;
    private boolean initialized = false;
    @Nullable
    private Settings settings;
    private long initStartTimestampMillis;
    @Nullable
    Future<InitResult> initResultFuture;

    @NonNull
    public static FlutterLoader getInstance() {
        if (instance == null) {
            instance = new FlutterLoader();
        }
        return instance;
    }

    public void startInitialization(@NonNull Context applicationContext) {
        this.startInitialization(applicationContext, new Settings());
    }

    public void startInitialization(@NonNull Context applicationContext, @NonNull Settings settings) {
        if (this.settings != null) {
            return;
        }
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("startInitialization must be called on the main thread");
        }
        final Context appContext = applicationContext.getApplicationContext();
        this.settings = settings;
        this.initStartTimestampMillis = SystemClock.uptimeMillis();
        this.initConfig(appContext);
        VsyncWaiter.getInstance((WindowManager)appContext.getSystemService("window")).init();
        Callable<InitResult> initTask = new Callable<InitResult>(){

            @Override
            public InitResult call() {
                ResourceExtractor resourceExtractor = FlutterLoader.this.initResources(appContext);
                System.loadLibrary("flutter");
                Executors.newSingleThreadExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        FlutterJNI.nativePrefetchDefaultFontManager();
                    }
                });
                if (resourceExtractor != null) {
                    resourceExtractor.waitForCompletion();
                }
                return new InitResult(PathUtils.getFilesDir(appContext), PathUtils.getCacheDirectory(appContext), PathUtils.getDataDirectory(appContext));
            }
        };
        this.initResultFuture = Executors.newSingleThreadExecutor().submit(initTask);
    }

    public void ensureInitializationComplete(@NonNull Context applicationContext, @Nullable String[] args) {
        if (this.initialized) {
            return;
        }
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("ensureInitializationComplete must be called on the main thread");
        }
        if (this.settings == null) {
            throw new IllegalStateException("ensureInitializationComplete must be called after startInitialization");
        }
        try {
            boolean use_embedded_view;
            InitResult result = this.initResultFuture.get();
            ArrayList<String> shellArgs = new ArrayList<String>();
            shellArgs.add("--icu-symbol-prefix=_binary_icudtl_dat");
            ApplicationInfo applicationInfo = this.getApplicationInfo(applicationContext);
            shellArgs.add("--icu-native-lib-path=" + applicationInfo.nativeLibraryDir + File.separator + DEFAULT_LIBRARY);
            if (args != null) {
                Collections.addAll(shellArgs, args);
            }
            String kernelPath = null;
            shellArgs.add("--aot-shared-library-name=" + this.aotSharedLibraryName);
            shellArgs.add("--aot-shared-library-name=" + applicationInfo.nativeLibraryDir + File.separator + this.aotSharedLibraryName);
            shellArgs.add("--cache-dir-path=" + result.engineCachesPath);
            if (this.settings.getLogTag() != null) {
                shellArgs.add("--log-tag=" + this.settings.getLogTag());
            }
            long initTimeMillis = SystemClock.uptimeMillis() - this.initStartTimestampMillis;
            Bundle bundle = applicationInfo.metaData;
            if (bundle != null && (use_embedded_view = bundle.getBoolean("io.flutter.embedded_views_preview"))) {
                shellArgs.add("--use-embedded-view");
            }
            FlutterJNI.nativeInit(applicationContext, shellArgs.toArray(new String[0]), kernelPath, result.appStoragePath, result.engineCachesPath, initTimeMillis);
            this.initialized = true;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Flutter initialization failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void ensureInitializationCompleteAsync(final @NonNull Context applicationContext, final @Nullable String[] args, final @NonNull Handler callbackHandler, final @NonNull Runnable callback) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("ensureInitializationComplete must be called on the main thread");
        }
        if (this.settings == null) {
            throw new IllegalStateException("ensureInitializationComplete must be called after startInitialization");
        }
        if (this.initialized) {
            callbackHandler.post(callback);
            return;
        }
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    InitResult result = FlutterLoader.this.initResultFuture.get();
                }
                catch (Exception e) {
                    Log.e((String)FlutterLoader.TAG, (String)"Flutter initialization failed.", (Throwable)e);
                    throw new RuntimeException(e);
                }
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        FlutterLoader.this.ensureInitializationComplete(applicationContext.getApplicationContext(), args);
                        callbackHandler.post(callback);
                    }
                });
            }
        });
    }

    @NonNull
    private ApplicationInfo getApplicationInfo(@NonNull Context applicationContext) {
        try {
            return applicationContext.getPackageManager().getApplicationInfo(applicationContext.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void initConfig(@NonNull Context applicationContext) {
        Bundle metadata = this.getApplicationInfo((Context)applicationContext).metaData;
        if (metadata == null) {
            return;
        }
        this.aotSharedLibraryName = metadata.getString(PUBLIC_AOT_SHARED_LIBRARY_NAME, DEFAULT_AOT_SHARED_LIBRARY_NAME);
        this.flutterAssetsDir = metadata.getString(PUBLIC_FLUTTER_ASSETS_DIR_KEY, DEFAULT_FLUTTER_ASSETS_DIR);
        this.vmSnapshotData = metadata.getString(PUBLIC_VM_SNAPSHOT_DATA_KEY, DEFAULT_VM_SNAPSHOT_DATA);
        this.isolateSnapshotData = metadata.getString(PUBLIC_ISOLATE_SNAPSHOT_DATA_KEY, DEFAULT_ISOLATE_SNAPSHOT_DATA);
    }

    private ResourceExtractor initResources(@NonNull Context applicationContext) {
        ResourceExtractor resourceExtractor = null;
        return resourceExtractor;
    }

    @NonNull
    public String findAppBundlePath() {
        return this.flutterAssetsDir;
    }

    @NonNull
    public String getLookupKeyForAsset(@NonNull String asset) {
        return this.fullAssetPathFrom(asset);
    }

    @NonNull
    public String getLookupKeyForAsset(@NonNull String asset, @NonNull String packageName) {
        return this.getLookupKeyForAsset("packages" + File.separator + packageName + File.separator + asset);
    }

    @NonNull
    private String fullAssetPathFrom(@NonNull String filePath) {
        return this.flutterAssetsDir + File.separator + filePath;
    }

    public static class Settings {
        private String logTag;

        @Nullable
        public String getLogTag() {
            return this.logTag;
        }

        public void setLogTag(String tag) {
            this.logTag = tag;
        }
    }

    private static class InitResult {
        final String appStoragePath;
        final String engineCachesPath;
        final String dataDirPath;

        private InitResult(String appStoragePath, String engineCachesPath, String dataDirPath) {
            this.appStoragePath = appStoragePath;
            this.engineCachesPath = engineCachesPath;
            this.dataDirPath = dataDirPath;
        }
    }
}

