/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.editing;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.graphics.Insets;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewStructure;
import android.view.WindowInsets;
import android.view.WindowInsetsAnimation;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillManager;
import android.view.autofill.AutofillValue;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.view.inputmethod.InputMethodSubtype;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import io.flutter.embedding.engine.systemchannels.TextInputChannel;
import io.flutter.plugin.editing.InputConnectionAdaptor;
import io.flutter.plugin.platform.PlatformViewsController;
import java.util.HashMap;
import java.util.List;

public class TextInputPlugin {
    @NonNull
    private final View mView;
    @NonNull
    private final InputMethodManager mImm;
    @NonNull
    private final AutofillManager afm;
    @NonNull
    private final TextInputChannel textInputChannel;
    @NonNull
    private InputTarget inputTarget = new InputTarget(InputTarget.Type.NO_TARGET, 0);
    @Nullable
    private TextInputChannel.Configuration configuration;
    @Nullable
    private SparseArray<TextInputChannel.Configuration> mAutofillConfigurations;
    @Nullable
    private Editable mEditable;
    private boolean mRestartInputPending;
    @Nullable
    private InputConnection lastInputConnection;
    @NonNull
    private PlatformViewsController platformViewsController;
    @Nullable
    private Rect lastClientRect;
    private final boolean restartAlwaysRequired;
    private ImeSyncDeferringInsetsCallback imeSyncCallback;
    private boolean isInputConnectionLocked;

    @SuppressLint(value={"NewApi"})
    public TextInputPlugin(View view, @NonNull TextInputChannel textInputChannel, @NonNull PlatformViewsController platformViewsController) {
        this.mView = view;
        this.mImm = (InputMethodManager)view.getContext().getSystemService("input_method");
        this.afm = Build.VERSION.SDK_INT >= 26 ? (AutofillManager)view.getContext().getSystemService(AutofillManager.class) : null;
        if (Build.VERSION.SDK_INT >= 30) {
            int mask = 0;
            if ((2 & this.mView.getWindowSystemUiVisibility()) == 0) {
                mask |= WindowInsets.Type.navigationBars();
            }
            if ((4 & this.mView.getWindowSystemUiVisibility()) == 0) {
                mask |= WindowInsets.Type.statusBars();
            }
            this.imeSyncCallback = new ImeSyncDeferringInsetsCallback(view, mask, WindowInsets.Type.ime());
            this.mView.setWindowInsetsAnimationCallback((WindowInsetsAnimation.Callback)this.imeSyncCallback);
            this.mView.setOnApplyWindowInsetsListener((View.OnApplyWindowInsetsListener)this.imeSyncCallback);
        }
        this.textInputChannel = textInputChannel;
        textInputChannel.setTextInputMethodHandler(new TextInputChannel.TextInputMethodHandler(){

            @Override
            public void show() {
                TextInputPlugin.this.showTextInput(TextInputPlugin.this.mView);
            }

            @Override
            public void hide() {
                TextInputPlugin.this.hideTextInput(TextInputPlugin.this.mView);
            }

            @Override
            public void requestAutofill() {
                TextInputPlugin.this.notifyViewEntered();
            }

            @Override
            public void finishAutofillContext(boolean shouldSave) {
                if (Build.VERSION.SDK_INT < 26 || TextInputPlugin.this.afm == null) {
                    return;
                }
                if (shouldSave) {
                    TextInputPlugin.this.afm.commit();
                } else {
                    TextInputPlugin.this.afm.cancel();
                }
            }

            @Override
            public void setClient(int textInputClientId, TextInputChannel.Configuration configuration) {
                TextInputPlugin.this.setTextInputClient(textInputClientId, configuration);
            }

            @Override
            public void setPlatformViewClient(int platformViewId) {
                TextInputPlugin.this.setPlatformViewTextInputClient(platformViewId);
            }

            @Override
            public void setEditingState(TextInputChannel.TextEditState editingState) {
                TextInputPlugin.this.setTextInputEditingState(TextInputPlugin.this.mView, editingState);
            }

            @Override
            public void setEditableSizeAndTransform(double width, double height, double[] transform) {
                TextInputPlugin.this.saveEditableSizeAndTransform(width, height, transform);
            }

            @Override
            public void clearClient() {
                TextInputPlugin.this.clearTextInputClient();
            }

            @Override
            public void sendAppPrivateCommand(String action, Bundle data) {
                TextInputPlugin.this.sendTextInputAppPrivateCommand(action, data);
            }
        });
        textInputChannel.requestExistingInputState();
        this.platformViewsController = platformViewsController;
        this.platformViewsController.attachTextInputPlugin(this);
        this.restartAlwaysRequired = this.isRestartAlwaysRequired();
    }

    @NonNull
    public InputMethodManager getInputMethodManager() {
        return this.mImm;
    }

    @VisibleForTesting
    Editable getEditable() {
        return this.mEditable;
    }

    @VisibleForTesting
    ImeSyncDeferringInsetsCallback getImeSyncCallback() {
        return this.imeSyncCallback;
    }

    public void lockPlatformViewInputConnection() {
        if (this.inputTarget.type == InputTarget.Type.PLATFORM_VIEW) {
            this.isInputConnectionLocked = true;
        }
    }

    public void unlockPlatformViewInputConnection() {
        this.isInputConnectionLocked = false;
    }

    @SuppressLint(value={"NewApi"})
    public void destroy() {
        this.platformViewsController.detachTextInputPlugin();
        this.textInputChannel.setTextInputMethodHandler(null);
        if (Build.VERSION.SDK_INT >= 30) {
            this.mView.setWindowInsetsAnimationCallback(null);
            this.mView.setOnApplyWindowInsetsListener(null);
        }
    }

    private static int inputTypeFromTextInputType(TextInputChannel.InputType type, boolean obscureText, boolean autocorrect, boolean enableSuggestions, TextInputChannel.TextCapitalization textCapitalization) {
        if (type.type == TextInputChannel.TextInputType.DATETIME) {
            return 4;
        }
        if (type.type == TextInputChannel.TextInputType.NUMBER) {
            int textType = 2;
            if (type.isSigned) {
                textType |= 0x1000;
            }
            if (type.isDecimal) {
                textType |= 0x2000;
            }
            return textType;
        }
        if (type.type == TextInputChannel.TextInputType.PHONE) {
            return 3;
        }
        int textType = 1;
        if (type.type == TextInputChannel.TextInputType.MULTILINE) {
            textType |= 0x20000;
        } else if (type.type == TextInputChannel.TextInputType.EMAIL_ADDRESS) {
            textType |= 0x20;
        } else if (type.type == TextInputChannel.TextInputType.URL) {
            textType |= 0x10;
        } else if (type.type == TextInputChannel.TextInputType.VISIBLE_PASSWORD) {
            textType |= 0x90;
        } else if (type.type == TextInputChannel.TextInputType.NAME) {
            textType |= 0x60;
        } else if (type.type == TextInputChannel.TextInputType.POSTAL_ADDRESS) {
            textType |= 0x70;
        }
        if (obscureText) {
            textType |= 0x80000;
            textType |= 0x80;
        } else {
            if (autocorrect) {
                textType |= 0x8000;
            }
            if (!enableSuggestions) {
                textType |= 0x80000;
            }
        }
        if (textCapitalization == TextInputChannel.TextCapitalization.CHARACTERS) {
            textType |= 0x1000;
        } else if (textCapitalization == TextInputChannel.TextCapitalization.WORDS) {
            textType |= 0x2000;
        } else if (textCapitalization == TextInputChannel.TextCapitalization.SENTENCES) {
            textType |= 0x4000;
        }
        return textType;
    }

    public InputConnection createInputConnection(View view, EditorInfo outAttrs) {
        if (this.inputTarget.type == InputTarget.Type.NO_TARGET) {
            this.lastInputConnection = null;
            return null;
        }
        if (this.inputTarget.type == InputTarget.Type.PLATFORM_VIEW) {
            if (this.isInputConnectionLocked) {
                return this.lastInputConnection;
            }
            this.lastInputConnection = this.platformViewsController.getPlatformViewById(this.inputTarget.id).onCreateInputConnection(outAttrs);
            return this.lastInputConnection;
        }
        outAttrs.inputType = TextInputPlugin.inputTypeFromTextInputType(this.configuration.inputType, this.configuration.obscureText, this.configuration.autocorrect, this.configuration.enableSuggestions, this.configuration.textCapitalization);
        outAttrs.imeOptions = 0x2000000;
        int enterAction = this.configuration.inputAction == null ? ((0x20000 & outAttrs.inputType) != 0 ? 1 : 6) : this.configuration.inputAction;
        if (this.configuration.actionLabel != null) {
            outAttrs.actionLabel = this.configuration.actionLabel;
            outAttrs.actionId = enterAction;
        }
        outAttrs.imeOptions |= enterAction;
        InputConnectionAdaptor connection = new InputConnectionAdaptor(view, this.inputTarget.id, this.textInputChannel, this.mEditable, outAttrs);
        outAttrs.initialSelStart = Selection.getSelectionStart((CharSequence)this.mEditable);
        outAttrs.initialSelEnd = Selection.getSelectionEnd((CharSequence)this.mEditable);
        this.lastInputConnection = connection;
        return this.lastInputConnection;
    }

    @Nullable
    public InputConnection getLastInputConnection() {
        return this.lastInputConnection;
    }

    public void clearPlatformViewClient(int platformViewId) {
        if (this.inputTarget.type == InputTarget.Type.PLATFORM_VIEW && this.inputTarget.id == platformViewId) {
            this.inputTarget = new InputTarget(InputTarget.Type.NO_TARGET, 0);
            this.hideTextInput(this.mView);
            this.mImm.restartInput(this.mView);
            this.mRestartInputPending = false;
        }
    }

    public void sendTextInputAppPrivateCommand(String action, Bundle data) {
        this.mImm.sendAppPrivateCommand(this.mView, action, data);
    }

    private void showTextInput(View view) {
        view.requestFocus();
        this.mImm.showSoftInput(view, 0);
    }

    private void hideTextInput(View view) {
        this.notifyViewExited();
        this.mImm.hideSoftInputFromWindow(view.getApplicationWindowToken(), 0);
    }

    private void notifyViewEntered() {
        if (Build.VERSION.SDK_INT < 26 || this.afm == null || !this.needsAutofill()) {
            return;
        }
        String triggerIdentifier = this.configuration.autofill.uniqueIdentifier;
        int[] offset = new int[2];
        this.mView.getLocationOnScreen(offset);
        Rect rect = new Rect(this.lastClientRect);
        rect.offset(offset[0], offset[1]);
        this.afm.notifyViewEntered(this.mView, triggerIdentifier.hashCode(), rect);
    }

    private void notifyViewExited() {
        if (Build.VERSION.SDK_INT < 26 || this.afm == null || this.configuration == null || this.configuration.autofill == null) {
            return;
        }
        String triggerIdentifier = this.configuration.autofill.uniqueIdentifier;
        this.afm.notifyViewExited(this.mView, triggerIdentifier.hashCode());
    }

    private void notifyValueChanged(String newValue) {
        if (Build.VERSION.SDK_INT < 26 || this.afm == null || !this.needsAutofill()) {
            return;
        }
        String triggerIdentifier = this.configuration.autofill.uniqueIdentifier;
        this.afm.notifyValueChanged(this.mView, triggerIdentifier.hashCode(), AutofillValue.forText((CharSequence)newValue));
    }

    @VisibleForTesting
    void setTextInputClient(int client, TextInputChannel.Configuration configuration) {
        this.inputTarget = new InputTarget(InputTarget.Type.FRAMEWORK_CLIENT, client);
        this.updateAutofillConfigurationIfNeeded(configuration);
        this.mEditable = Editable.Factory.getInstance().newEditable((CharSequence)"");
        this.mRestartInputPending = true;
        this.unlockPlatformViewInputConnection();
        this.lastClientRect = null;
    }

    private void setPlatformViewTextInputClient(int platformViewId) {
        this.mView.requestFocus();
        this.inputTarget = new InputTarget(InputTarget.Type.PLATFORM_VIEW, platformViewId);
        this.mImm.restartInput(this.mView);
        this.mRestartInputPending = false;
    }

    private void applyStateToSelection(TextInputChannel.TextEditState state) {
        int selStart = state.selectionStart;
        int selEnd = state.selectionEnd;
        if (selStart >= 0 && selStart <= this.mEditable.length() && selEnd >= 0 && selEnd <= this.mEditable.length()) {
            Selection.setSelection((Spannable)this.mEditable, (int)selStart, (int)selEnd);
        } else {
            Selection.removeSelection((Spannable)this.mEditable);
        }
    }

    @VisibleForTesting
    void setTextInputEditingState(View view, TextInputChannel.TextEditState state) {
        if (!state.text.equals(this.mEditable.toString())) {
            this.mEditable.replace(0, this.mEditable.length(), (CharSequence)state.text);
        }
        this.notifyValueChanged(this.mEditable.toString());
        this.applyStateToSelection(state);
        InputConnection connection = this.getLastInputConnection();
        if (connection != null && connection instanceof InputConnectionAdaptor) {
            ((InputConnectionAdaptor)connection).markDirty();
        }
        if (!this.restartAlwaysRequired && !this.mRestartInputPending) {
            this.mImm.updateSelection(this.mView, Math.max(Selection.getSelectionStart((CharSequence)this.mEditable), 0), Math.max(Selection.getSelectionEnd((CharSequence)this.mEditable), 0), BaseInputConnection.getComposingSpanStart((Spannable)this.mEditable), BaseInputConnection.getComposingSpanEnd((Spannable)this.mEditable));
        } else {
            this.mImm.restartInput(view);
            this.mRestartInputPending = false;
        }
    }

    private void saveEditableSizeAndTransform(double width, double height, final double[] matrix) {
        final double[] minMax = new double[4];
        final boolean isAffine = matrix[3] == 0.0 && matrix[7] == 0.0 && matrix[15] == 1.0;
        minMax[0] = minMax[1] = matrix[12] / matrix[15];
        minMax[2] = minMax[3] = matrix[13] / matrix[15];
        MinMax finder = new MinMax(){

            @Override
            public void inspect(double x, double y) {
                double w = isAffine ? 1.0 : 1.0 / (matrix[3] * x + matrix[7] * y + matrix[15]);
                double tx = (matrix[0] * x + matrix[4] * y + matrix[12]) * w;
                double ty = (matrix[1] * x + matrix[5] * y + matrix[13]) * w;
                if (tx < minMax[0]) {
                    minMax[0] = tx;
                } else if (tx > minMax[1]) {
                    minMax[1] = tx;
                }
                if (ty < minMax[2]) {
                    minMax[2] = ty;
                } else if (ty > minMax[3]) {
                    minMax[3] = ty;
                }
            }
        };
        finder.inspect(width, 0.0);
        finder.inspect(width, height);
        finder.inspect(0.0, height);
        Float density = Float.valueOf(this.mView.getContext().getResources().getDisplayMetrics().density);
        this.lastClientRect = new Rect((int)(minMax[0] * (double)density.floatValue()), (int)(minMax[2] * (double)density.floatValue()), (int)Math.ceil(minMax[1] * (double)density.floatValue()), (int)Math.ceil(minMax[3] * (double)density.floatValue()));
    }

    private void updateAutofillConfigurationIfNeeded(TextInputChannel.Configuration configuration) {
        this.notifyViewExited();
        this.configuration = configuration;
        TextInputChannel.Configuration[] configurations = configuration.fields;
        if (configuration.autofill == null) {
            this.mAutofillConfigurations = null;
            return;
        }
        this.mAutofillConfigurations = new SparseArray();
        if (configurations == null) {
            this.mAutofillConfigurations.put(configuration.autofill.uniqueIdentifier.hashCode(), (Object)configuration);
        } else {
            for (TextInputChannel.Configuration config : configurations) {
                TextInputChannel.Configuration.Autofill autofill = config.autofill;
                if (autofill == null) continue;
                this.mAutofillConfigurations.put(autofill.uniqueIdentifier.hashCode(), (Object)config);
            }
        }
    }

    private boolean needsAutofill() {
        return this.mAutofillConfigurations != null;
    }

    public void onProvideAutofillVirtualStructure(ViewStructure structure, int flags) {
        if (Build.VERSION.SDK_INT < 26 || !this.needsAutofill()) {
            return;
        }
        String triggerIdentifier = this.configuration.autofill.uniqueIdentifier;
        AutofillId parentId = structure.getAutofillId();
        for (int i = 0; i < this.mAutofillConfigurations.size(); ++i) {
            int autofillId = this.mAutofillConfigurations.keyAt(i);
            TextInputChannel.Configuration config = (TextInputChannel.Configuration)this.mAutofillConfigurations.valueAt(i);
            TextInputChannel.Configuration.Autofill autofill = config.autofill;
            if (autofill == null) continue;
            structure.addChildCount(1);
            ViewStructure child = structure.newChild(i);
            child.setAutofillId(parentId, autofillId);
            child.setAutofillValue(AutofillValue.forText((CharSequence)autofill.editState.text));
            child.setAutofillHints(autofill.hints);
            child.setAutofillType(1);
            child.setVisibility(0);
            if (triggerIdentifier.hashCode() == autofillId && this.lastClientRect != null) {
                child.setDimens(this.lastClientRect.left, this.lastClientRect.top, 0, 0, this.lastClientRect.width(), this.lastClientRect.height());
                continue;
            }
            child.setDimens(0, 0, 0, 0, 1, 1);
        }
    }

    public void autofill(SparseArray<AutofillValue> values) {
        if (Build.VERSION.SDK_INT < 26) {
            return;
        }
        TextInputChannel.Configuration.Autofill currentAutofill = this.configuration.autofill;
        if (currentAutofill == null) {
            return;
        }
        HashMap<String, TextInputChannel.TextEditState> editingValues = new HashMap<String, TextInputChannel.TextEditState>();
        for (int i = 0; i < values.size(); ++i) {
            int virtualId = values.keyAt(i);
            TextInputChannel.Configuration config = (TextInputChannel.Configuration)this.mAutofillConfigurations.get(virtualId);
            if (config == null || config.autofill == null) continue;
            TextInputChannel.Configuration.Autofill autofill = config.autofill;
            String value = ((AutofillValue)values.valueAt(i)).getTextValue().toString();
            TextInputChannel.TextEditState newState = new TextInputChannel.TextEditState(value, value.length(), value.length());
            if (autofill.uniqueIdentifier.equals(currentAutofill.uniqueIdentifier)) {
                this.setTextInputEditingState(this.mView, newState);
            }
            editingValues.put(autofill.uniqueIdentifier, newState);
        }
        this.textInputChannel.updateEditingStateWithTag(this.inputTarget.id, editingValues);
    }

    @SuppressLint(value={"NewApi"})
    private boolean isRestartAlwaysRequired() {
        InputMethodSubtype subtype = this.mImm.getCurrentInputMethodSubtype();
        if (subtype == null || Build.VERSION.SDK_INT < 21 || !Build.MANUFACTURER.equals("samsung")) {
            return false;
        }
        String keyboardName = Settings.Secure.getString((ContentResolver)this.mView.getContext().getContentResolver(), (String)"default_input_method");
        return keyboardName.contains("Samsung");
    }

    private void clearTextInputClient() {
        if (this.inputTarget.type == InputTarget.Type.PLATFORM_VIEW) {
            return;
        }
        this.inputTarget = new InputTarget(InputTarget.Type.NO_TARGET, 0);
        this.unlockPlatformViewInputConnection();
        this.notifyViewExited();
        this.lastClientRect = null;
    }

    private static class InputTarget {
        @NonNull
        Type type;
        int id;

        public InputTarget(@NonNull Type type, int id2) {
            this.type = type;
            this.id = id2;
        }

        static enum Type {
            NO_TARGET,
            FRAMEWORK_CLIENT,
            PLATFORM_VIEW;

        }
    }

    private static interface MinMax {
        public void inspect(double var1, double var3);
    }

    @VisibleForTesting
    @TargetApi(value=30)
    @RequiresApi(value=30)
    @SuppressLint(value={"NewApi", "Override"})
    class ImeSyncDeferringInsetsCallback
    extends WindowInsetsAnimation.Callback
    implements View.OnApplyWindowInsetsListener {
        private int overlayInsetTypes;
        private int deferredInsetTypes;
        private View view;
        private WindowInsets lastWindowInsets;
        private boolean started;

        ImeSyncDeferringInsetsCallback(View view, int overlayInsetTypes, int deferredInsetTypes) {
            super(1);
            this.started = false;
            this.overlayInsetTypes = overlayInsetTypes;
            this.deferredInsetTypes = deferredInsetTypes;
            this.view = view;
        }

        public WindowInsets onApplyWindowInsets(View view, WindowInsets windowInsets) {
            this.view = view;
            if (this.started) {
                return WindowInsets.CONSUMED;
            }
            this.lastWindowInsets = windowInsets;
            return view.onApplyWindowInsets(windowInsets);
        }

        public WindowInsetsAnimation.Bounds onStart(WindowInsetsAnimation animation, WindowInsetsAnimation.Bounds bounds) {
            if ((animation.getTypeMask() & this.deferredInsetTypes) != 0) {
                this.started = true;
            }
            return bounds;
        }

        public WindowInsets onProgress(WindowInsets insets, List<WindowInsetsAnimation> runningAnimations) {
            if (!this.started) {
                return insets;
            }
            boolean matching = false;
            for (WindowInsetsAnimation animation : runningAnimations) {
                if ((animation.getTypeMask() & this.deferredInsetTypes) == 0) continue;
                matching = true;
            }
            if (!matching) {
                return insets;
            }
            WindowInsets.Builder builder = new WindowInsets.Builder(this.lastWindowInsets);
            Insets newImeInsets = Insets.of((int)0, (int)0, (int)0, (int)Math.max(insets.getInsets((int)this.deferredInsetTypes).bottom - insets.getInsets((int)this.overlayInsetTypes).bottom, 0));
            builder.setInsets(this.deferredInsetTypes, newImeInsets);
            this.view.onApplyWindowInsets(builder.build());
            return insets;
        }

        public void onEnd(WindowInsetsAnimation animation) {
            if (this.started && (animation.getTypeMask() & this.deferredInsetTypes) != 0) {
                this.started = false;
                if (this.lastWindowInsets != null && this.view != null) {
                    this.view.dispatchApplyWindowInsets(this.lastWindowInsets);
                }
            }
        }
    }
}

