/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.platform;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.Window;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.embedding.engine.systemchannels.PlatformChannel;
import java.util.List;

public class PlatformPlugin {
    public static final int DEFAULT_SYSTEM_UI = 1280;
    private final Activity activity;
    private final PlatformChannel platformChannel;
    private PlatformChannel.SystemChromeStyle currentTheme;
    private int mEnabledOverlays;
    @VisibleForTesting
    final PlatformChannel.PlatformMessageHandler mPlatformMessageHandler = new PlatformChannel.PlatformMessageHandler(){

        @Override
        public void playSystemSound(@NonNull PlatformChannel.SoundType soundType) {
            PlatformPlugin.this.playSystemSound(soundType);
        }

        @Override
        public void vibrateHapticFeedback(@NonNull PlatformChannel.HapticFeedbackType feedbackType) {
            PlatformPlugin.this.vibrateHapticFeedback(feedbackType);
        }

        @Override
        public void setPreferredOrientations(int androidOrientation) {
            PlatformPlugin.this.setSystemChromePreferredOrientations(androidOrientation);
        }

        @Override
        public void setApplicationSwitcherDescription(@NonNull PlatformChannel.AppSwitcherDescription description) {
            PlatformPlugin.this.setSystemChromeApplicationSwitcherDescription(description);
        }

        @Override
        public void showSystemOverlays(@NonNull List<PlatformChannel.SystemUiOverlay> overlays) {
            PlatformPlugin.this.setSystemChromeEnabledSystemUIOverlays(overlays);
        }

        @Override
        public void restoreSystemUiOverlays() {
            PlatformPlugin.this.restoreSystemChromeSystemUIOverlays();
        }

        @Override
        public void setSystemUiOverlayStyle(@NonNull PlatformChannel.SystemChromeStyle systemUiOverlayStyle) {
            PlatformPlugin.this.setSystemChromeSystemUIOverlayStyle(systemUiOverlayStyle);
        }

        @Override
        public void popSystemNavigator() {
            PlatformPlugin.this.popSystemNavigator();
        }

        @Override
        public CharSequence getClipboardData(@Nullable PlatformChannel.ClipboardContentFormat format) {
            return PlatformPlugin.this.getClipboardData(format);
        }

        @Override
        public void setClipboardData(@NonNull String text) {
            PlatformPlugin.this.setClipboardData(text);
        }

        @Override
        public boolean clipboardHasStrings() {
            CharSequence data = PlatformPlugin.this.getClipboardData(PlatformChannel.ClipboardContentFormat.PLAIN_TEXT);
            return data != null && data.length() > 0;
        }
    };

    public PlatformPlugin(Activity activity, PlatformChannel platformChannel) {
        this.activity = activity;
        this.platformChannel = platformChannel;
        this.platformChannel.setPlatformMessageHandler(this.mPlatformMessageHandler);
        this.mEnabledOverlays = 1280;
    }

    public void destroy() {
        this.platformChannel.setPlatformMessageHandler(null);
    }

    private void playSystemSound(PlatformChannel.SoundType soundType) {
        if (soundType == PlatformChannel.SoundType.CLICK) {
            View view = this.activity.getWindow().getDecorView();
            view.playSoundEffect(0);
        }
    }

    @VisibleForTesting
    void vibrateHapticFeedback(PlatformChannel.HapticFeedbackType feedbackType) {
        View view = this.activity.getWindow().getDecorView();
        switch (feedbackType) {
            case STANDARD: {
                view.performHapticFeedback(0);
                break;
            }
            case LIGHT_IMPACT: {
                view.performHapticFeedback(1);
                break;
            }
            case MEDIUM_IMPACT: {
                view.performHapticFeedback(3);
                break;
            }
            case HEAVY_IMPACT: {
                if (Build.VERSION.SDK_INT < 23) break;
                view.performHapticFeedback(6);
                break;
            }
            case SELECTION_CLICK: {
                if (Build.VERSION.SDK_INT < 21) break;
                view.performHapticFeedback(4);
            }
        }
    }

    private void setSystemChromePreferredOrientations(int androidOrientation) {
        this.activity.setRequestedOrientation(androidOrientation);
    }

    private void setSystemChromeApplicationSwitcherDescription(PlatformChannel.AppSwitcherDescription description) {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        if (Build.VERSION.SDK_INT < 28 && Build.VERSION.SDK_INT > 21) {
            this.activity.setTaskDescription(new ActivityManager.TaskDescription(description.label, null, description.color));
        }
        if (Build.VERSION.SDK_INT >= 28) {
            ActivityManager.TaskDescription taskDescription = new ActivityManager.TaskDescription(description.label, 0, description.color);
            this.activity.setTaskDescription(taskDescription);
        }
    }

    private void setSystemChromeEnabledSystemUIOverlays(List<PlatformChannel.SystemUiOverlay> overlaysToShow) {
        int enabledOverlays = 1798;
        if (overlaysToShow.size() == 0 && Build.VERSION.SDK_INT >= 19) {
            enabledOverlays |= 0x1000;
        }
        block4: for (int i = 0; i < overlaysToShow.size(); ++i) {
            PlatformChannel.SystemUiOverlay overlayToShow = overlaysToShow.get(i);
            switch (overlayToShow) {
                case TOP_OVERLAYS: {
                    enabledOverlays &= 0xFFFFFFFB;
                    continue block4;
                }
                case BOTTOM_OVERLAYS: {
                    enabledOverlays &= 0xFFFFFDFF;
                    enabledOverlays &= 0xFFFFFFFD;
                }
            }
        }
        this.mEnabledOverlays = enabledOverlays;
        this.updateSystemUiOverlays();
    }

    public void updateSystemUiOverlays() {
        this.activity.getWindow().getDecorView().setSystemUiVisibility(this.mEnabledOverlays);
        if (this.currentTheme != null) {
            this.setSystemChromeSystemUIOverlayStyle(this.currentTheme);
        }
    }

    private void restoreSystemChromeSystemUIOverlays() {
        this.updateSystemUiOverlays();
    }

    private void setSystemChromeSystemUIOverlayStyle(PlatformChannel.SystemChromeStyle systemChromeStyle) {
        Window window = this.activity.getWindow();
        View view = window.getDecorView();
        int flags = view.getSystemUiVisibility();
        if (Build.VERSION.SDK_INT >= 26) {
            if (systemChromeStyle.systemNavigationBarIconBrightness != null) {
                switch (systemChromeStyle.systemNavigationBarIconBrightness) {
                    case DARK: {
                        flags |= 0x10;
                        break;
                    }
                    case LIGHT: {
                        flags &= 0xFFFFFFEF;
                    }
                }
            }
            if (systemChromeStyle.systemNavigationBarColor != null) {
                window.setNavigationBarColor(systemChromeStyle.systemNavigationBarColor.intValue());
            }
        }
        if (Build.VERSION.SDK_INT >= 23) {
            if (systemChromeStyle.statusBarIconBrightness != null) {
                switch (systemChromeStyle.statusBarIconBrightness) {
                    case DARK: {
                        flags |= 0x2000;
                        break;
                    }
                    case LIGHT: {
                        flags &= 0xFFFFDFFF;
                    }
                }
            }
            if (systemChromeStyle.statusBarColor != null) {
                window.setStatusBarColor(systemChromeStyle.statusBarColor.intValue());
            }
        }
        if (systemChromeStyle.systemNavigationBarDividerColor != null) {
            // empty if block
        }
        view.setSystemUiVisibility(flags);
        this.currentTheme = systemChromeStyle;
    }

    private void popSystemNavigator() {
        this.activity.finish();
    }

    private CharSequence getClipboardData(PlatformChannel.ClipboardContentFormat format) {
        ClipboardManager clipboard = (ClipboardManager)this.activity.getSystemService("clipboard");
        ClipData clip = clipboard.getPrimaryClip();
        if (clip == null) {
            return null;
        }
        if (format == null || format == PlatformChannel.ClipboardContentFormat.PLAIN_TEXT) {
            return clip.getItemAt(0).coerceToText((Context)this.activity);
        }
        return null;
    }

    private void setClipboardData(String text) {
        ClipboardManager clipboard = (ClipboardManager)this.activity.getSystemService("clipboard");
        ClipData clip = ClipData.newPlainText((CharSequence)"text label?", (CharSequence)text);
        clipboard.setPrimaryClip(clip);
    }
}

