/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.editing;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.graphics.Insets;
import android.view.View;
import android.view.WindowInsets;
import android.view.WindowInsetsAnimation;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import java.util.List;

@VisibleForTesting
@TargetApi(value=30)
@RequiresApi(value=30)
@SuppressLint(value={"NewApi", "Override"})
@Keep
class ImeSyncDeferringInsetsCallback
extends WindowInsetsAnimation.Callback
implements View.OnApplyWindowInsetsListener {
    private int overlayInsetTypes;
    private int deferredInsetTypes;
    private View view;
    private WindowInsets lastWindowInsets;
    private boolean animating = false;
    private boolean needsSave = false;

    ImeSyncDeferringInsetsCallback(@NonNull View view, int overlayInsetTypes, int deferredInsetTypes) {
        super(1);
        this.overlayInsetTypes = overlayInsetTypes;
        this.deferredInsetTypes = deferredInsetTypes;
        this.view = view;
    }

    void install() {
        this.view.setWindowInsetsAnimationCallback((WindowInsetsAnimation.Callback)this);
        this.view.setOnApplyWindowInsetsListener((View.OnApplyWindowInsetsListener)this);
    }

    void remove() {
        this.view.setWindowInsetsAnimationCallback(null);
        this.view.setOnApplyWindowInsetsListener(null);
    }

    public WindowInsets onApplyWindowInsets(View view, WindowInsets windowInsets) {
        this.view = view;
        if (this.needsSave) {
            this.lastWindowInsets = windowInsets;
            this.needsSave = false;
        }
        if (this.animating) {
            return WindowInsets.CONSUMED;
        }
        return view.onApplyWindowInsets(windowInsets);
    }

    public void onPrepare(WindowInsetsAnimation animation) {
        if ((animation.getTypeMask() & this.deferredInsetTypes) != 0) {
            this.animating = true;
            this.needsSave = true;
        }
    }

    public WindowInsets onProgress(WindowInsets insets, List<WindowInsetsAnimation> runningAnimations) {
        if (!this.animating || this.needsSave) {
            return insets;
        }
        boolean matching = false;
        for (WindowInsetsAnimation animation : runningAnimations) {
            if ((animation.getTypeMask() & this.deferredInsetTypes) == 0) continue;
            matching = true;
        }
        if (!matching) {
            return insets;
        }
        WindowInsets.Builder builder = new WindowInsets.Builder(this.lastWindowInsets);
        Insets newImeInsets = Insets.of((int)0, (int)0, (int)0, (int)Math.max(insets.getInsets((int)this.deferredInsetTypes).bottom - insets.getInsets((int)this.overlayInsetTypes).bottom, 0));
        builder.setInsets(this.deferredInsetTypes, newImeInsets);
        this.view.onApplyWindowInsets(builder.build());
        return insets;
    }

    public void onEnd(WindowInsetsAnimation animation) {
        if (this.animating && (animation.getTypeMask() & this.deferredInsetTypes) != 0) {
            this.animating = false;
            if (this.lastWindowInsets != null && this.view != null) {
                this.view.dispatchApplyWindowInsets(this.lastWindowInsets);
            }
        }
    }
}

