/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.Log;
import io.flutter.embedding.engine.systemchannels.KeyEventChannel;
import io.flutter.plugin.editing.TextInputPlugin;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;

public class AndroidKeyProcessor {
    private static final String TAG = "AndroidKeyProcessor";
    private static long eventIdSerial = 0L;
    @NonNull
    private final KeyEventChannel keyEventChannel;
    @NonNull
    private final TextInputPlugin textInputPlugin;
    private int combiningCharacter;
    @NonNull
    private EventResponder eventResponder;

    public AndroidKeyProcessor(@NonNull View view, @NonNull KeyEventChannel keyEventChannel, @NonNull TextInputPlugin textInputPlugin) {
        this.keyEventChannel = keyEventChannel;
        this.textInputPlugin = textInputPlugin;
        this.eventResponder = new EventResponder(view);
        this.keyEventChannel.setEventResponseHandler(this.eventResponder);
    }

    public void destroy() {
        this.keyEventChannel.setEventResponseHandler(null);
    }

    public boolean onKeyUp(@NonNull KeyEvent keyEvent) {
        if (this.eventResponder.dispatchingKeyEvent) {
            return false;
        }
        Character complexCharacter = this.applyCombiningCharacterToBaseCharacter(keyEvent.getUnicodeChar());
        KeyEventChannel.FlutterKeyEvent flutterEvent = new KeyEventChannel.FlutterKeyEvent(keyEvent, complexCharacter, eventIdSerial++);
        this.keyEventChannel.keyUp(flutterEvent);
        this.eventResponder.addEvent(flutterEvent.eventId, keyEvent);
        return true;
    }

    public boolean onKeyDown(@NonNull KeyEvent keyEvent) {
        if (this.eventResponder.dispatchingKeyEvent) {
            return false;
        }
        if (this.textInputPlugin.getLastInputConnection() != null && this.textInputPlugin.getInputMethodManager().isAcceptingText() && this.textInputPlugin.getLastInputConnection().sendKeyEvent(keyEvent)) {
            return true;
        }
        Character complexCharacter = this.applyCombiningCharacterToBaseCharacter(keyEvent.getUnicodeChar());
        KeyEventChannel.FlutterKeyEvent flutterEvent = new KeyEventChannel.FlutterKeyEvent(keyEvent, complexCharacter, eventIdSerial++);
        this.keyEventChannel.keyDown(flutterEvent);
        this.eventResponder.addEvent(flutterEvent.eventId, keyEvent);
        return true;
    }

    @Nullable
    private Character applyCombiningCharacterToBaseCharacter(int newCharacterCodePoint) {
        boolean isNewCodePointACombiningCharacter;
        if (newCharacterCodePoint == 0) {
            return null;
        }
        char complexCharacter = (char)newCharacterCodePoint;
        boolean bl = isNewCodePointACombiningCharacter = (newCharacterCodePoint & Integer.MIN_VALUE) != 0;
        if (isNewCodePointACombiningCharacter) {
            int plainCodePoint = newCharacterCodePoint & Integer.MAX_VALUE;
            this.combiningCharacter = this.combiningCharacter != 0 ? KeyCharacterMap.getDeadChar((int)this.combiningCharacter, (int)plainCodePoint) : plainCodePoint;
        } else if (this.combiningCharacter != 0) {
            int combinedChar = KeyCharacterMap.getDeadChar((int)this.combiningCharacter, (int)newCharacterCodePoint);
            if (combinedChar > 0) {
                complexCharacter = (char)combinedChar;
            }
            this.combiningCharacter = 0;
        }
        return Character.valueOf(complexCharacter);
    }

    private static class EventResponder
    implements KeyEventChannel.EventResponseHandler {
        private static final long MAX_PENDING_EVENTS = 1000L;
        final Deque<Map.Entry<Long, KeyEvent>> pendingEvents = new ArrayDeque<Map.Entry<Long, KeyEvent>>();
        @NonNull
        private final View view;
        boolean dispatchingKeyEvent = false;

        public EventResponder(@NonNull View view) {
            this.view = view;
        }

        private KeyEvent removePendingEvent(long id2) {
            if (this.pendingEvents.getFirst().getKey() != id2) {
                throw new AssertionError((Object)("Event response received out of order. Should have seen event " + this.pendingEvents.getFirst().getKey() + " first. Instead, received " + id2));
            }
            return this.pendingEvents.removeFirst().getValue();
        }

        @Override
        public void onKeyEventHandled(long id2) {
            this.removePendingEvent(id2);
        }

        @Override
        public void onKeyEventNotHandled(long id2) {
            this.dispatchKeyEvent(this.removePendingEvent(id2));
        }

        public void addEvent(long id2, @NonNull KeyEvent event) {
            if (this.pendingEvents.size() > 0 && this.pendingEvents.getFirst().getKey() >= id2) {
                throw new AssertionError((Object)("New events must have ids greater than the most recent pending event. New id " + id2 + " is less than or equal to the last event id of " + this.pendingEvents.getFirst().getKey()));
            }
            this.pendingEvents.addLast(new AbstractMap.SimpleImmutableEntry<Long, KeyEvent>(id2, event));
            if ((long)this.pendingEvents.size() > 1000L) {
                Log.e(AndroidKeyProcessor.TAG, "There are " + this.pendingEvents.size() + " keyboard events that have not yet received a response. Are responses being sent?");
            }
        }

        public void dispatchKeyEvent(KeyEvent event) {
            if (this.view != null) {
                this.dispatchingKeyEvent = true;
                this.view.getRootView().dispatchKeyEvent(event);
                this.dispatchingKeyEvent = false;
            }
        }
    }
}

