/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.loader;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.FlutterInjector;
import io.flutter.Log;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.loader.ApplicationInfoLoader;
import io.flutter.embedding.engine.loader.FlutterApplicationInfo;
import io.flutter.embedding.engine.loader.ResourceExtractor;
import io.flutter.util.PathUtils;
import io.flutter.view.VsyncWaiter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class FlutterLoader {
    private static final String TAG = "FlutterLoader";
    static final String AOT_SHARED_LIBRARY_NAME = "aot-shared-library-name";
    static final String SNAPSHOT_ASSET_PATH_KEY = "snapshot-asset-path";
    static final String VM_SNAPSHOT_DATA_KEY = "vm-snapshot-data";
    static final String ISOLATE_SNAPSHOT_DATA_KEY = "isolate-snapshot-data";
    static final String FLUTTER_ASSETS_DIR_KEY = "flutter-assets-dir";
    private static final String DEFAULT_LIBRARY = "libflutter.so";
    private static final String DEFAULT_KERNEL_BLOB = "kernel_blob.bin";
    private static FlutterLoader instance;
    private boolean initialized = false;
    @Nullable
    private Settings settings;
    private long initStartTimestampMillis;
    private FlutterApplicationInfo flutterApplicationInfo;
    @Nullable
    Future<InitResult> initResultFuture;

    @Deprecated
    @NonNull
    public static FlutterLoader getInstance() {
        if (instance == null) {
            instance = new FlutterLoader();
        }
        return instance;
    }

    public void startInitialization(@NonNull Context applicationContext) {
        this.startInitialization(applicationContext, new Settings());
    }

    public void startInitialization(@NonNull Context applicationContext, @NonNull Settings settings) {
        if (this.settings != null) {
            return;
        }
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("startInitialization must be called on the main thread");
        }
        final Context appContext = applicationContext.getApplicationContext();
        this.settings = settings;
        this.initStartTimestampMillis = SystemClock.uptimeMillis();
        this.flutterApplicationInfo = ApplicationInfoLoader.load(appContext);
        VsyncWaiter.getInstance((WindowManager)appContext.getSystemService("window")).init();
        Callable<InitResult> initTask = new Callable<InitResult>(){

            @Override
            public InitResult call() {
                ResourceExtractor resourceExtractor = FlutterLoader.this.initResources(appContext);
                if (FlutterInjector.instance().shouldLoadNative()) {
                    System.loadLibrary("flutter");
                }
                Executors.newSingleThreadExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        FlutterJNI.nativePrefetchDefaultFontManager();
                    }
                });
                if (resourceExtractor != null) {
                    resourceExtractor.waitForCompletion();
                }
                return new InitResult(PathUtils.getFilesDir(appContext), PathUtils.getCacheDirectory(appContext), PathUtils.getDataDirectory(appContext));
            }
        };
        this.initResultFuture = Executors.newSingleThreadExecutor().submit(initTask);
    }

    public void ensureInitializationComplete(@NonNull Context applicationContext, @Nullable String[] args) {
        if (this.initialized) {
            return;
        }
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("ensureInitializationComplete must be called on the main thread");
        }
        if (this.settings == null) {
            throw new IllegalStateException("ensureInitializationComplete must be called after startInitialization");
        }
        try {
            InitResult result = this.initResultFuture.get();
            ArrayList<String> shellArgs = new ArrayList<String>();
            shellArgs.add("--icu-symbol-prefix=_binary_icudtl_dat");
            shellArgs.add("--icu-native-lib-path=" + this.flutterApplicationInfo.nativeLibraryDir + File.separator + DEFAULT_LIBRARY);
            if (args != null) {
                Collections.addAll(shellArgs, args);
            }
            String kernelPath = null;
            String snapshotAssetPath = result.dataDirPath + File.separator + this.flutterApplicationInfo.flutterAssetsDir;
            kernelPath = snapshotAssetPath + File.separator + DEFAULT_KERNEL_BLOB;
            shellArgs.add("--snapshot-asset-path=" + snapshotAssetPath);
            shellArgs.add("--vm-snapshot-data=" + this.flutterApplicationInfo.vmSnapshotData);
            shellArgs.add("--isolate-snapshot-data=" + this.flutterApplicationInfo.isolateSnapshotData);
            shellArgs.add("--cache-dir-path=" + result.engineCachesPath);
            if (!this.flutterApplicationInfo.clearTextPermitted) {
                shellArgs.add("--disallow-insecure-connections");
            }
            if (this.flutterApplicationInfo.domainNetworkPolicy != null) {
                shellArgs.add("--domain-network-policy=" + this.flutterApplicationInfo.domainNetworkPolicy);
            }
            if (this.settings.getLogTag() != null) {
                shellArgs.add("--log-tag=" + this.settings.getLogTag());
            }
            long initTimeMillis = SystemClock.uptimeMillis() - this.initStartTimestampMillis;
            if (FlutterInjector.instance().shouldLoadNative()) {
                FlutterJNI.nativeInit(applicationContext, shellArgs.toArray(new String[0]), kernelPath, result.appStoragePath, result.engineCachesPath, initTimeMillis);
            }
            this.initialized = true;
        }
        catch (Exception e) {
            Log.e(TAG, "Flutter initialization failed.", e);
            throw new RuntimeException(e);
        }
    }

    public void ensureInitializationCompleteAsync(final @NonNull Context applicationContext, final @Nullable String[] args, final @NonNull Handler callbackHandler, final @NonNull Runnable callback) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("ensureInitializationComplete must be called on the main thread");
        }
        if (this.settings == null) {
            throw new IllegalStateException("ensureInitializationComplete must be called after startInitialization");
        }
        if (this.initialized) {
            callbackHandler.post(callback);
            return;
        }
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    InitResult result = FlutterLoader.this.initResultFuture.get();
                }
                catch (Exception e) {
                    Log.e(FlutterLoader.TAG, "Flutter initialization failed.", e);
                    throw new RuntimeException(e);
                }
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        FlutterLoader.this.ensureInitializationComplete(applicationContext.getApplicationContext(), args);
                        callbackHandler.post(callback);
                    }
                });
            }
        });
    }

    public boolean initialized() {
        return this.initialized;
    }

    private ResourceExtractor initResources(@NonNull Context applicationContext) {
        ResourceExtractor resourceExtractor = null;
        String dataDirPath = PathUtils.getDataDirectory(applicationContext);
        String packageName = applicationContext.getPackageName();
        PackageManager packageManager = applicationContext.getPackageManager();
        AssetManager assetManager = applicationContext.getResources().getAssets();
        resourceExtractor = new ResourceExtractor(dataDirPath, packageName, packageManager, assetManager);
        resourceExtractor.addResource(this.fullAssetPathFrom(this.flutterApplicationInfo.vmSnapshotData)).addResource(this.fullAssetPathFrom(this.flutterApplicationInfo.isolateSnapshotData)).addResource(this.fullAssetPathFrom(DEFAULT_KERNEL_BLOB));
        resourceExtractor.start();
        return resourceExtractor;
    }

    @NonNull
    public String findAppBundlePath() {
        return this.flutterApplicationInfo.flutterAssetsDir;
    }

    @NonNull
    public String getLookupKeyForAsset(@NonNull String asset) {
        return this.fullAssetPathFrom(asset);
    }

    @NonNull
    public String getLookupKeyForAsset(@NonNull String asset, @NonNull String packageName) {
        return this.getLookupKeyForAsset("packages" + File.separator + packageName + File.separator + asset);
    }

    @NonNull
    private String fullAssetPathFrom(@NonNull String filePath) {
        return this.flutterApplicationInfo.flutterAssetsDir + File.separator + filePath;
    }

    public static class Settings {
        private String logTag;

        @Nullable
        public String getLogTag() {
            return this.logTag;
        }

        public void setLogTag(String tag) {
            this.logTag = tag;
        }
    }

    private static class InitResult {
        final String appStoragePath;
        final String engineCachesPath;
        final String dataDirPath;

        private InitResult(String appStoragePath, String engineCachesPath, String dataDirPath) {
            this.appStoragePath = appStoragePath;
            this.engineCachesPath = engineCachesPath;
            this.dataDirPath = dataDirPath;
        }
    }
}

