import FlutterMacOS

public class IntegrationTestPlugin: NSObject, FlutterPlugin {

  public static func register(with registrar: FlutterPluginRegistrar) {
    let channel = FlutterMethodChannel(
      name: "plugins.flutter.io/integration_test",
      binaryMessenger: registrar.messenger)

    let instance = IntegrationTestPlugin()
    registrar.addMethodCallDelegate(instance, channel: channel)
  }

  public func handle(_ call: FlutterMethodCall, result: @escaping FlutterResult) {
    switch call.method {
    case "allTestsFinished":
      result(nil)
    default:
      result(FlutterMethodNotImplemented)
    }
  }
}
