// Copyright 2014 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file has been automatically generated. Please do not edit it manually.
// To regenerate run (omit --overwrite to print to console instead of the file):
// dart --enable-asserts dev/tools/localization/bin/gen_date_localizations.dart --overwrite

/// The subset of date symbols supported by the intl package which are also
/// supported by flutter_localizations.
const Map<String, dynamic> dateSymbols = <String, dynamic>{
  'af': <String, dynamic>{
    'NAME': 'af',
    'ERAS': <dynamic>[
      'v.C.',
      'n.C.',
    ],
    'ERANAMES': <dynamic>[
      'voor Christus',
      'na Christus',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'Januarie',
      'Februarie',
      'Maart',
      'April',
      'Mei',
      'Junie',
      'Julie',
      'Augustus',
      'September',
      'Oktober',
      'November',
      'Desember',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'Januarie',
      'Februarie',
      'Maart',
      'April',
      'Mei',
      'Junie',
      'Julie',
      'Augustus',
      'September',
      'Oktober',
      'November',
      'Desember',
    ],
    'SHORTMONTHS': <dynamic>[
      'Jan.',
      'Feb.',
      'Mrt.',
      'Apr.',
      'Mei',
      'Jun.',
      'Jul.',
      'Aug.',
      'Sep.',
      'Okt.',
      'Nov.',
      'Des.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'Jan.',
      'Feb.',
      'Mrt.',
      'Apr.',
      'Mei',
      'Jun.',
      'Jul.',
      'Aug.',
      'Sep.',
      'Okt.',
      'Nov.',
      'Des.',
    ],
    'WEEKDAYS': <dynamic>[
      'Sondag',
      'Maandag',
      'Dinsdag',
      'Woensdag',
      'Donderdag',
      'Vrydag',
      'Saterdag',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'Sondag',
      'Maandag',
      'Dinsdag',
      'Woensdag',
      'Donderdag',
      'Vrydag',
      'Saterdag',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'So.',
      'Ma.',
      'Di.',
      'Wo.',
      'Do.',
      'Vr.',
      'Sa.',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'So.',
      'Ma.',
      'Di.',
      'Wo.',
      'Do.',
      'Vr.',
      'Sa.',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'D',
      'W',
      'D',
      'V',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'D',
      'W',
      'D',
      'V',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      'K1',
      'K2',
      'K3',
      'K4',
    ],
    'QUARTERS': <dynamic>[
      '1ste kwartaal',
      '2de kwartaal',
      '3de kwartaal',
      '4de kwartaal',
    ],
    'AMPMS': <dynamic>[
      'vm.',
      'nm.',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE dd MMMM y',
      'dd MMMM y',
      'dd MMM y',
      'y-MM-dd',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'am': <String, dynamic>{
    'NAME': 'am',
    'ERAS': <dynamic>[
      'ዓ/ዓ',
      'ዓ/ም',
    ],
    'ERANAMES': <dynamic>[
      'ዓመተ ዓለም',
      'ዓመተ ምሕረት',
    ],
    'NARROWMONTHS': <dynamic>[
      'ጃ',
      'ፌ',
      'ማ',
      'ኤ',
      'ሜ',
      'ጁ',
      'ጁ',
      'ኦ',
      'ሴ',
      'ኦ',
      'ኖ',
      'ዲ',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'ጃ',
      'ፌ',
      'ማ',
      'ኤ',
      'ሜ',
      'ጁ',
      'ጁ',
      'ኦ',
      'ሴ',
      'ኦ',
      'ኖ',
      'ዲ',
    ],
    'MONTHS': <dynamic>[
      'ጃንዩወሪ',
      'ፌብሩወሪ',
      'ማርች',
      'ኤፕሪል',
      'ሜይ',
      'ጁን',
      'ጁላይ',
      'ኦገስት',
      'ሴፕቴምበር',
      'ኦክቶበር',
      'ኖቬምበር',
      'ዲሴምበር',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'ጃንዩወሪ',
      'ፌብሩወሪ',
      'ማርች',
      'ኤፕሪል',
      'ሜይ',
      'ጁን',
      'ጁላይ',
      'ኦገስት',
      'ሴፕቴምበር',
      'ኦክቶበር',
      'ኖቬምበር',
      'ዲሴምበር',
    ],
    'SHORTMONTHS': <dynamic>[
      'ጃንዩ',
      'ፌብሩ',
      'ማርች',
      'ኤፕሪ',
      'ሜይ',
      'ጁን',
      'ጁላይ',
      'ኦገስ',
      'ሴፕቴ',
      'ኦክቶ',
      'ኖቬም',
      'ዲሴም',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'ጃንዩ',
      'ፌብሩ',
      'ማርች',
      'ኤፕሪ',
      'ሜይ',
      'ጁን',
      'ጁላይ',
      'ኦገስ',
      'ሴፕቴ',
      'ኦክቶ',
      'ኖቬም',
      'ዲሴም',
    ],
    'WEEKDAYS': <dynamic>[
      'እሑድ',
      'ሰኞ',
      'ማክሰኞ',
      'ረቡዕ',
      'ሐሙስ',
      'ዓርብ',
      'ቅዳሜ',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'እሑድ',
      'ሰኞ',
      'ማክሰኞ',
      'ረቡዕ',
      'ሐሙስ',
      'ዓርብ',
      'ቅዳሜ',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'እሑድ',
      'ሰኞ',
      'ማክሰ',
      'ረቡዕ',
      'ሐሙስ',
      'ዓርብ',
      'ቅዳሜ',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'እሑድ',
      'ሰኞ',
      'ማክሰ',
      'ረቡዕ',
      'ሐሙስ',
      'ዓርብ',
      'ቅዳሜ',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'እ',
      'ሰ',
      'ማ',
      'ረ',
      'ሐ',
      'ዓ',
      'ቅ',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'እ',
      'ሰ',
      'ማ',
      'ረ',
      'ሐ',
      'ዓ',
      'ቅ',
    ],
    'SHORTQUARTERS': <dynamic>[
      'ሩብ1',
      'ሩብ2',
      'ሩብ3',
      'ሩብ4',
    ],
    'QUARTERS': <dynamic>[
      '1ኛው ሩብ',
      '2ኛው ሩብ',
      '3ኛው ሩብ',
      '4ኛው ሩብ',
    ],
    'AMPMS': <dynamic>[
      'ጥዋት',
      'ከሰዓት',
    ],
    'DATEFORMATS': <dynamic>[
      'y MMMM d, EEEE',
      'd MMMM y',
      'd MMM y',
      'dd/MM/y',
    ],
    'TIMEFORMATS': <dynamic>[
      'h:mm:ss a zzzz',
      'h:mm:ss a z',
      'h:mm:ss a',
      'h:mm a',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'ar': <String, dynamic>{
    'NAME': 'ar',
    'ERAS': <dynamic>[
      'ق.م',
      'م',
    ],
    'ERANAMES': <dynamic>[
      'قبل الميلاد',
      'ميلادي',
    ],
    'NARROWMONTHS': <dynamic>[
      'ي',
      'ف',
      'م',
      'أ',
      'و',
      'ن',
      'ل',
      'غ',
      'س',
      'ك',
      'ب',
      'د',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'ي',
      'ف',
      'م',
      'أ',
      'و',
      'ن',
      'ل',
      'غ',
      'س',
      'ك',
      'ب',
      'د',
    ],
    'MONTHS': <dynamic>[
      'يناير',
      'فبراير',
      'مارس',
      'أبريل',
      'مايو',
      'يونيو',
      'يوليو',
      'أغسطس',
      'سبتمبر',
      'أكتوبر',
      'نوفمبر',
      'ديسمبر',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'يناير',
      'فبراير',
      'مارس',
      'أبريل',
      'مايو',
      'يونيو',
      'يوليو',
      'أغسطس',
      'سبتمبر',
      'أكتوبر',
      'نوفمبر',
      'ديسمبر',
    ],
    'SHORTMONTHS': <dynamic>[
      'يناير',
      'فبراير',
      'مارس',
      'أبريل',
      'مايو',
      'يونيو',
      'يوليو',
      'أغسطس',
      'سبتمبر',
      'أكتوبر',
      'نوفمبر',
      'ديسمبر',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'يناير',
      'فبراير',
      'مارس',
      'أبريل',
      'مايو',
      'يونيو',
      'يوليو',
      'أغسطس',
      'سبتمبر',
      'أكتوبر',
      'نوفمبر',
      'ديسمبر',
    ],
    'WEEKDAYS': <dynamic>[
      'الأحد',
      'الاثنين',
      'الثلاثاء',
      'الأربعاء',
      'الخميس',
      'الجمعة',
      'السبت',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'الأحد',
      'الاثنين',
      'الثلاثاء',
      'الأربعاء',
      'الخميس',
      'الجمعة',
      'السبت',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'الأحد',
      'الاثنين',
      'الثلاثاء',
      'الأربعاء',
      'الخميس',
      'الجمعة',
      'السبت',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'الأحد',
      'الاثنين',
      'الثلاثاء',
      'الأربعاء',
      'الخميس',
      'الجمعة',
      'السبت',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'ح',
      'ن',
      'ث',
      'ر',
      'خ',
      'ج',
      'س',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'ح',
      'ن',
      'ث',
      'ر',
      'خ',
      'ج',
      'س',
    ],
    'SHORTQUARTERS': <dynamic>[
      'الربع الأول',
      'الربع الثاني',
      'الربع الثالث',
      'الربع الرابع',
    ],
    'QUARTERS': <dynamic>[
      'الربع الأول',
      'الربع الثاني',
      'الربع الثالث',
      'الربع الرابع',
    ],
    'AMPMS': <dynamic>[
      'ص',
      'م',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE، d MMMM y',
      'd MMMM y',
      'dd‏/MM‏/y',
      'd‏/M‏/y',
    ],
    'TIMEFORMATS': <dynamic>[
      'h:mm:ss a zzzz',
      'h:mm:ss a z',
      'h:mm:ss a',
      'h:mm a',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 5,
    'WEEKENDRANGE': <dynamic>[
      4,
      5,
    ],
    'FIRSTWEEKCUTOFFDAY': 4,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
    'ZERODIGIT': '٠',
  },
  'az': <String, dynamic>{
    'NAME': 'az',
    'ERAS': <dynamic>[
      'e.ə.',
      'y.e.',
    ],
    'ERANAMES': <dynamic>[
      'eramızdan əvvəl',
      'yeni era',
    ],
    'NARROWMONTHS': <dynamic>[
      '1',
      '2',
      '3',
      '4',
      '5',
      '6',
      '7',
      '8',
      '9',
      '10',
      '11',
      '12',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      '1',
      '2',
      '3',
      '4',
      '5',
      '6',
      '7',
      '8',
      '9',
      '10',
      '11',
      '12',
    ],
    'MONTHS': <dynamic>[
      'yanvar',
      'fevral',
      'mart',
      'aprel',
      'may',
      'iyun',
      'iyul',
      'avqust',
      'sentyabr',
      'oktyabr',
      'noyabr',
      'dekabr',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'Yanvar',
      'Fevral',
      'Mart',
      'Aprel',
      'May',
      'İyun',
      'İyul',
      'Avqust',
      'Sentyabr',
      'Oktyabr',
      'Noyabr',
      'Dekabr',
    ],
    'SHORTMONTHS': <dynamic>[
      'yan',
      'fev',
      'mar',
      'apr',
      'may',
      'iyn',
      'iyl',
      'avq',
      'sen',
      'okt',
      'noy',
      'dek',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'yan',
      'fev',
      'mar',
      'apr',
      'may',
      'iyn',
      'iyl',
      'avq',
      'sen',
      'okt',
      'noy',
      'dek',
    ],
    'WEEKDAYS': <dynamic>[
      'bazar',
      'bazar ertəsi',
      'çərşənbə axşamı',
      'çərşənbə',
      'cümə axşamı',
      'cümə',
      'şənbə',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'bazar',
      'bazar ertəsi',
      'çərşənbə axşamı',
      'çərşənbə',
      'cümə axşamı',
      'cümə',
      'şənbə',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'B.',
      'B.E.',
      'Ç.A.',
      'Ç.',
      'C.A.',
      'C.',
      'Ş.',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'B.',
      'B.E.',
      'Ç.A.',
      'Ç.',
      'C.A.',
      'C.',
      'Ş.',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      '7',
      '1',
      '2',
      '3',
      '4',
      '5',
      '6',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      '7',
      '1',
      '2',
      '3',
      '4',
      '5',
      '6',
    ],
    'SHORTQUARTERS': <dynamic>[
      '1-ci kv.',
      '2-ci kv.',
      '3-cü kv.',
      '4-cü kv.',
    ],
    'QUARTERS': <dynamic>[
      '1-ci kvartal',
      '2-ci kvartal',
      '3-cü kvartal',
      '4-cü kvartal',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'd MMMM y, EEEE',
      'd MMMM y',
      'd MMM y',
      'dd.MM.yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'be': <String, dynamic>{
    'NAME': 'be',
    'ERAS': <dynamic>[
      'да н.э.',
      'н.э.',
    ],
    'ERANAMES': <dynamic>[
      'да нараджэння Хрыстова',
      'ад нараджэння Хрыстова',
    ],
    'NARROWMONTHS': <dynamic>[
      'с',
      'л',
      'с',
      'к',
      'м',
      'ч',
      'л',
      'ж',
      'в',
      'к',
      'л',
      'с',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'с',
      'л',
      'с',
      'к',
      'м',
      'ч',
      'л',
      'ж',
      'в',
      'к',
      'л',
      'с',
    ],
    'MONTHS': <dynamic>[
      'студзеня',
      'лютага',
      'сакавіка',
      'красавіка',
      'мая',
      'чэрвеня',
      'ліпеня',
      'жніўня',
      'верасня',
      'кастрычніка',
      'лістапада',
      'снежня',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'студзень',
      'люты',
      'сакавік',
      'красавік',
      'май',
      'чэрвень',
      'ліпень',
      'жнівень',
      'верасень',
      'кастрычнік',
      'лістапад',
      'снежань',
    ],
    'SHORTMONTHS': <dynamic>[
      'сту',
      'лют',
      'сак',
      'кра',
      'мая',
      'чэр',
      'ліп',
      'жні',
      'вер',
      'кас',
      'ліс',
      'сне',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'сту',
      'лют',
      'сак',
      'кра',
      'май',
      'чэр',
      'ліп',
      'жні',
      'вер',
      'кас',
      'ліс',
      'сне',
    ],
    'WEEKDAYS': <dynamic>[
      'нядзеля',
      'панядзелак',
      'аўторак',
      'серада',
      'чацвер',
      'пятніца',
      'субота',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'нядзеля',
      'панядзелак',
      'аўторак',
      'серада',
      'чацвер',
      'пятніца',
      'субота',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'нд',
      'пн',
      'аў',
      'ср',
      'чц',
      'пт',
      'сб',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'нд',
      'пн',
      'аў',
      'ср',
      'чц',
      'пт',
      'сб',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'н',
      'п',
      'а',
      'с',
      'ч',
      'п',
      'с',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'н',
      'п',
      'а',
      'с',
      'ч',
      'п',
      'с',
    ],
    'SHORTQUARTERS': <dynamic>[
      '1-шы кв.',
      '2-гі кв.',
      '3-ці кв.',
      '4-ты кв.',
    ],
    'QUARTERS': <dynamic>[
      '1-шы квартал',
      '2-гі квартал',
      '3-ці квартал',
      '4-ты квартал',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d MMMM y \'г\'.',
      'd MMMM y \'г\'.',
      'd.MM.y',
      'd.MM.yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss, zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      '{1} \'у\' {0}',
      '{1} \'у\' {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'bg': <String, dynamic>{
    'NAME': 'bg',
    'ERAS': <dynamic>[
      'пр.Хр.',
      'сл.Хр.',
    ],
    'ERANAMES': <dynamic>[
      'преди Христа',
      'след Христа',
    ],
    'NARROWMONTHS': <dynamic>[
      'я',
      'ф',
      'м',
      'а',
      'м',
      'ю',
      'ю',
      'а',
      'с',
      'о',
      'н',
      'д',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'я',
      'ф',
      'м',
      'а',
      'м',
      'ю',
      'ю',
      'а',
      'с',
      'о',
      'н',
      'д',
    ],
    'MONTHS': <dynamic>[
      'януари',
      'февруари',
      'март',
      'април',
      'май',
      'юни',
      'юли',
      'август',
      'септември',
      'октомври',
      'ноември',
      'декември',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'януари',
      'февруари',
      'март',
      'април',
      'май',
      'юни',
      'юли',
      'август',
      'септември',
      'октомври',
      'ноември',
      'декември',
    ],
    'SHORTMONTHS': <dynamic>[
      'яну',
      'фев',
      'март',
      'апр',
      'май',
      'юни',
      'юли',
      'авг',
      'сеп',
      'окт',
      'ное',
      'дек',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'яну',
      'фев',
      'март',
      'апр',
      'май',
      'юни',
      'юли',
      'авг',
      'сеп',
      'окт',
      'ное',
      'дек',
    ],
    'WEEKDAYS': <dynamic>[
      'неделя',
      'понеделник',
      'вторник',
      'сряда',
      'четвъртък',
      'петък',
      'събота',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'неделя',
      'понеделник',
      'вторник',
      'сряда',
      'четвъртък',
      'петък',
      'събота',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'нд',
      'пн',
      'вт',
      'ср',
      'чт',
      'пт',
      'сб',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'нд',
      'пн',
      'вт',
      'ср',
      'чт',
      'пт',
      'сб',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'н',
      'п',
      'в',
      'с',
      'ч',
      'п',
      'с',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'н',
      'п',
      'в',
      'с',
      'ч',
      'п',
      'с',
    ],
    'SHORTQUARTERS': <dynamic>[
      '1. трим.',
      '2. трим.',
      '3. трим.',
      '4. трим.',
    ],
    'QUARTERS': <dynamic>[
      '1. тримесечие',
      '2. тримесечие',
      '3. тримесечие',
      '4. тримесечие',
    ],
    'AMPMS': <dynamic>[
      'пр.об.',
      'сл.об.',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d MMMM y \'г\'.',
      'd MMMM y \'г\'.',
      'd.MM.y \'г\'.',
      'd.MM.yy \'г\'.',
    ],
    'TIMEFORMATS': <dynamic>[
      'H:mm:ss \'ч\'. zzzz',
      'H:mm:ss \'ч\'. z',
      'H:mm:ss \'ч\'.',
      'H:mm \'ч\'.',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      '{1}, {0}',
      '{1}, {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'bn': <String, dynamic>{
    'NAME': 'bn',
    'ERAS': <dynamic>[
      'খ্রিস্টপূর্ব',
      'খৃষ্টাব্দ',
    ],
    'ERANAMES': <dynamic>[
      'খ্রিস্টপূর্ব',
      'খ্রীষ্টাব্দ',
    ],
    'NARROWMONTHS': <dynamic>[
      'জা',
      'ফে',
      'মা',
      'এ',
      'মে',
      'জুন',
      'জু',
      'আ',
      'সে',
      'অ',
      'ন',
      'ডি',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'জা',
      'ফে',
      'মা',
      'এ',
      'মে',
      'জুন',
      'জু',
      'আ',
      'সে',
      'অ',
      'ন',
      'ডি',
    ],
    'MONTHS': <dynamic>[
      'জানুয়ারী',
      'ফেব্রুয়ারী',
      'মার্চ',
      'এপ্রিল',
      'মে',
      'জুন',
      'জুলাই',
      'আগস্ট',
      'সেপ্টেম্বর',
      'অক্টোবর',
      'নভেম্বর',
      'ডিসেম্বর',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'জানুয়ারী',
      'ফেব্রুয়ারী',
      'মার্চ',
      'এপ্রিল',
      'মে',
      'জুন',
      'জুলাই',
      'আগস্ট',
      'সেপ্টেম্বর',
      'অক্টোবর',
      'নভেম্বর',
      'ডিসেম্বর',
    ],
    'SHORTMONTHS': <dynamic>[
      'জানু',
      'ফেব',
      'মার্চ',
      'এপ্রিল',
      'মে',
      'জুন',
      'জুলাই',
      'আগস্ট',
      'সেপ্টেম্বর',
      'অক্টোবর',
      'নভেম্বর',
      'ডিসেম্বর',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'জানুয়ারী',
      'ফেব্রুয়ারী',
      'মার্চ',
      'এপ্রিল',
      'মে',
      'জুন',
      'জুলাই',
      'আগস্ট',
      'সেপ্টেম্বর',
      'অক্টোবর',
      'নভেম্বর',
      'ডিসেম্বর',
    ],
    'WEEKDAYS': <dynamic>[
      'রবিবার',
      'সোমবার',
      'মঙ্গলবার',
      'বুধবার',
      'বৃহস্পতিবার',
      'শুক্রবার',
      'শনিবার',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'রবিবার',
      'সোমবার',
      'মঙ্গলবার',
      'বুধবার',
      'বৃহস্পতিবার',
      'শুক্রবার',
      'শনিবার',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'রবি',
      'সোম',
      'মঙ্গল',
      'বুধ',
      'বৃহস্পতি',
      'শুক্র',
      'শনি',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'রবি',
      'সোম',
      'মঙ্গল',
      'বুধ',
      'বৃহস্পতি',
      'শুক্র',
      'শনি',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'র',
      'সো',
      'ম',
      'বু',
      'বৃ',
      'শু',
      'শ',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'র',
      'সো',
      'ম',
      'বু',
      'বৃ',
      'শু',
      'শ',
    ],
    'SHORTQUARTERS': <dynamic>[
      'ত্রৈমাসিক',
      'দ্বিতীয় ত্রৈমাসিক',
      'তৃতীয় ত্রৈমাসিক',
      'চতুর্থ ত্রৈমাসিক',
    ],
    'QUARTERS': <dynamic>[
      'ত্রৈমাসিক',
      'দ্বিতীয় ত্রৈমাসিক',
      'তৃতীয় ত্রৈমাসিক',
      'চতুর্থ ত্রৈমাসিক',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d MMMM, y',
      'd MMMM, y',
      'd MMM, y',
      'd/M/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'h:mm:ss a zzzz',
      'h:mm:ss a z',
      'h:mm:ss a',
      'h:mm a',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
    'ZERODIGIT': '০',
  },
  'bs': <String, dynamic>{
    'NAME': 'bs',
    'ERAS': <dynamic>[
      'p. n. e.',
      'n. e.',
    ],
    'ERANAMES': <dynamic>[
      'prije nove ere',
      'nove ere',
    ],
    'NARROWMONTHS': <dynamic>[
      'j',
      'f',
      'm',
      'a',
      'm',
      'j',
      'j',
      'a',
      's',
      'o',
      'n',
      'd',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'j',
      'f',
      'm',
      'a',
      'm',
      'j',
      'j',
      'a',
      's',
      'o',
      'n',
      'd',
    ],
    'MONTHS': <dynamic>[
      'januar',
      'februar',
      'mart',
      'april',
      'maj',
      'juni',
      'juli',
      'august',
      'septembar',
      'oktobar',
      'novembar',
      'decembar',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'januar',
      'februar',
      'mart',
      'april',
      'maj',
      'juni',
      'juli',
      'august',
      'septembar',
      'oktobar',
      'novembar',
      'decembar',
    ],
    'SHORTMONTHS': <dynamic>[
      'jan',
      'feb',
      'mar',
      'apr',
      'maj',
      'jun',
      'jul',
      'aug',
      'sep',
      'okt',
      'nov',
      'dec',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'jan',
      'feb',
      'mar',
      'apr',
      'maj',
      'jun',
      'jul',
      'aug',
      'sep',
      'okt',
      'nov',
      'dec',
    ],
    'WEEKDAYS': <dynamic>[
      'nedjelja',
      'ponedjeljak',
      'utorak',
      'srijeda',
      'četvrtak',
      'petak',
      'subota',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'nedjelja',
      'ponedjeljak',
      'utorak',
      'srijeda',
      'četvrtak',
      'petak',
      'subota',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'ned',
      'pon',
      'uto',
      'sri',
      'čet',
      'pet',
      'sub',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'ned',
      'pon',
      'uto',
      'sri',
      'čet',
      'pet',
      'sub',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'N',
      'P',
      'U',
      'S',
      'Č',
      'P',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'n',
      'p',
      'u',
      's',
      'č',
      'p',
      's',
    ],
    'SHORTQUARTERS': <dynamic>[
      'KV1',
      'KV2',
      'KV3',
      'KV4',
    ],
    'QUARTERS': <dynamic>[
      'Prvi kvartal',
      'Drugi kvartal',
      'Treći kvartal',
      'Četvrti kvartal',
    ],
    'AMPMS': <dynamic>[
      'prijepodne',
      'popodne',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d. MMMM y.',
      'd. MMMM y.',
      'd. MMM y.',
      'd. M. y.',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      '{1} \'u\' {0}',
      '{1} \'u\' {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'ca': <String, dynamic>{
    'NAME': 'ca',
    'ERAS': <dynamic>[
      'aC',
      'dC',
    ],
    'ERANAMES': <dynamic>[
      'abans de Crist',
      'després de Crist',
    ],
    'NARROWMONTHS': <dynamic>[
      'GN',
      'FB',
      'MÇ',
      'AB',
      'MG',
      'JN',
      'JL',
      'AG',
      'ST',
      'OC',
      'NV',
      'DS',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'GN',
      'FB',
      'MÇ',
      'AB',
      'MG',
      'JN',
      'JL',
      'AG',
      'ST',
      'OC',
      'NV',
      'DS',
    ],
    'MONTHS': <dynamic>[
      'de gener',
      'de febrer',
      'de març',
      'd’abril',
      'de maig',
      'de juny',
      'de juliol',
      'd’agost',
      'de setembre',
      'd’octubre',
      'de novembre',
      'de desembre',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'gener',
      'febrer',
      'març',
      'abril',
      'maig',
      'juny',
      'juliol',
      'agost',
      'setembre',
      'octubre',
      'novembre',
      'desembre',
    ],
    'SHORTMONTHS': <dynamic>[
      'de gen.',
      'de febr.',
      'de març',
      'd’abr.',
      'de maig',
      'de juny',
      'de jul.',
      'd’ag.',
      'de set.',
      'd’oct.',
      'de nov.',
      'de des.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'gen.',
      'febr.',
      'març',
      'abr.',
      'maig',
      'juny',
      'jul.',
      'ag.',
      'set.',
      'oct.',
      'nov.',
      'des.',
    ],
    'WEEKDAYS': <dynamic>[
      'diumenge',
      'dilluns',
      'dimarts',
      'dimecres',
      'dijous',
      'divendres',
      'dissabte',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'diumenge',
      'dilluns',
      'dimarts',
      'dimecres',
      'dijous',
      'divendres',
      'dissabte',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'dg.',
      'dl.',
      'dt.',
      'dc.',
      'dj.',
      'dv.',
      'ds.',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'dg.',
      'dl.',
      'dt.',
      'dc.',
      'dj.',
      'dv.',
      'ds.',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'dg',
      'dl',
      'dt',
      'dc',
      'dj',
      'dv',
      'ds',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'dg',
      'dl',
      'dt',
      'dc',
      'dj',
      'dv',
      'ds',
    ],
    'SHORTQUARTERS': <dynamic>[
      '1T',
      '2T',
      '3T',
      '4T',
    ],
    'QUARTERS': <dynamic>[
      '1r trimestre',
      '2n trimestre',
      '3r trimestre',
      '4t trimestre',
    ],
    'AMPMS': <dynamic>[
      'a. m.',
      'p. m.',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d MMMM \'de\' y',
      'd MMMM \'de\' y',
      'd MMM y',
      'd/M/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'H:mm:ss zzzz',
      'H:mm:ss z',
      'H:mm:ss',
      'H:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      '{1} \'a\' \'les\' {0}',
      '{1} \'a\' \'les\' {0}',
      '{1}, {0}',
      '{1} {0}',
    ],
  },
  'cs': <String, dynamic>{
    'NAME': 'cs',
    'ERAS': <dynamic>[
      'př. n. l.',
      'n. l.',
    ],
    'ERANAMES': <dynamic>[
      'před naším letopočtem',
      'našeho letopočtu',
    ],
    'NARROWMONTHS': <dynamic>[
      '1',
      '2',
      '3',
      '4',
      '5',
      '6',
      '7',
      '8',
      '9',
      '10',
      '11',
      '12',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      '1',
      '2',
      '3',
      '4',
      '5',
      '6',
      '7',
      '8',
      '9',
      '10',
      '11',
      '12',
    ],
    'MONTHS': <dynamic>[
      'ledna',
      'února',
      'března',
      'dubna',
      'května',
      'června',
      'července',
      'srpna',
      'září',
      'října',
      'listopadu',
      'prosince',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'leden',
      'únor',
      'březen',
      'duben',
      'květen',
      'červen',
      'červenec',
      'srpen',
      'září',
      'říjen',
      'listopad',
      'prosinec',
    ],
    'SHORTMONTHS': <dynamic>[
      'led',
      'úno',
      'bře',
      'dub',
      'kvě',
      'čvn',
      'čvc',
      'srp',
      'zář',
      'říj',
      'lis',
      'pro',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'led',
      'úno',
      'bře',
      'dub',
      'kvě',
      'čvn',
      'čvc',
      'srp',
      'zář',
      'říj',
      'lis',
      'pro',
    ],
    'WEEKDAYS': <dynamic>[
      'neděle',
      'pondělí',
      'úterý',
      'středa',
      'čtvrtek',
      'pátek',
      'sobota',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'neděle',
      'pondělí',
      'úterý',
      'středa',
      'čtvrtek',
      'pátek',
      'sobota',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'ne',
      'po',
      'út',
      'st',
      'čt',
      'pá',
      'so',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'ne',
      'po',
      'út',
      'st',
      'čt',
      'pá',
      'so',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'N',
      'P',
      'Ú',
      'S',
      'Č',
      'P',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'N',
      'P',
      'Ú',
      'S',
      'Č',
      'P',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      'Q1',
      'Q2',
      'Q3',
      'Q4',
    ],
    'QUARTERS': <dynamic>[
      '1. čtvrtletí',
      '2. čtvrtletí',
      '3. čtvrtletí',
      '4. čtvrtletí',
    ],
    'AMPMS': <dynamic>[
      'dop.',
      'odp.',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE d. MMMM y',
      'd. MMMM y',
      'd. M. y',
      'dd.MM.yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'H:mm:ss zzzz',
      'H:mm:ss z',
      'H:mm:ss',
      'H:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'da': <String, dynamic>{
    'NAME': 'da',
    'ERAS': <dynamic>[
      'f.Kr.',
      'e.Kr.',
    ],
    'ERANAMES': <dynamic>[
      'f.Kr.',
      'e.Kr.',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'januar',
      'februar',
      'marts',
      'april',
      'maj',
      'juni',
      'juli',
      'august',
      'september',
      'oktober',
      'november',
      'december',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'januar',
      'februar',
      'marts',
      'april',
      'maj',
      'juni',
      'juli',
      'august',
      'september',
      'oktober',
      'november',
      'december',
    ],
    'SHORTMONTHS': <dynamic>[
      'jan.',
      'feb.',
      'mar.',
      'apr.',
      'maj',
      'jun.',
      'jul.',
      'aug.',
      'sep.',
      'okt.',
      'nov.',
      'dec.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'jan.',
      'feb.',
      'mar.',
      'apr.',
      'maj',
      'jun.',
      'jul.',
      'aug.',
      'sep.',
      'okt.',
      'nov.',
      'dec.',
    ],
    'WEEKDAYS': <dynamic>[
      'søndag',
      'mandag',
      'tirsdag',
      'onsdag',
      'torsdag',
      'fredag',
      'lørdag',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'søndag',
      'mandag',
      'tirsdag',
      'onsdag',
      'torsdag',
      'fredag',
      'lørdag',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'søn.',
      'man.',
      'tir.',
      'ons.',
      'tor.',
      'fre.',
      'lør.',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'søn',
      'man',
      'tir',
      'ons',
      'tor',
      'fre',
      'lør',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'O',
      'T',
      'F',
      'L',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'O',
      'T',
      'F',
      'L',
    ],
    'SHORTQUARTERS': <dynamic>[
      '1. kvt.',
      '2. kvt.',
      '3. kvt.',
      '4. kvt.',
    ],
    'QUARTERS': <dynamic>[
      '1. kvartal',
      '2. kvartal',
      '3. kvartal',
      '4. kvartal',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE \'den\' d. MMMM y',
      'd. MMMM y',
      'd. MMM y',
      'dd.MM.y',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH.mm.ss zzzz',
      'HH.mm.ss z',
      'HH.mm.ss',
      'HH.mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      '{1} \'kl\'. {0}',
      '{1} \'kl\'. {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'de': <String, dynamic>{
    'NAME': 'de',
    'ERAS': <dynamic>[
      'v. Chr.',
      'n. Chr.',
    ],
    'ERANAMES': <dynamic>[
      'v. Chr.',
      'n. Chr.',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'Januar',
      'Februar',
      'März',
      'April',
      'Mai',
      'Juni',
      'Juli',
      'August',
      'September',
      'Oktober',
      'November',
      'Dezember',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'Januar',
      'Februar',
      'März',
      'April',
      'Mai',
      'Juni',
      'Juli',
      'August',
      'September',
      'Oktober',
      'November',
      'Dezember',
    ],
    'SHORTMONTHS': <dynamic>[
      'Jan.',
      'Feb.',
      'März',
      'Apr.',
      'Mai',
      'Juni',
      'Juli',
      'Aug.',
      'Sept.',
      'Okt.',
      'Nov.',
      'Dez.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'Jan',
      'Feb',
      'Mär',
      'Apr',
      'Mai',
      'Jun',
      'Jul',
      'Aug',
      'Sep',
      'Okt',
      'Nov',
      'Dez',
    ],
    'WEEKDAYS': <dynamic>[
      'Sonntag',
      'Montag',
      'Dienstag',
      'Mittwoch',
      'Donnerstag',
      'Freitag',
      'Samstag',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'Sonntag',
      'Montag',
      'Dienstag',
      'Mittwoch',
      'Donnerstag',
      'Freitag',
      'Samstag',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'So.',
      'Mo.',
      'Di.',
      'Mi.',
      'Do.',
      'Fr.',
      'Sa.',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'So',
      'Mo',
      'Di',
      'Mi',
      'Do',
      'Fr',
      'Sa',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'D',
      'M',
      'D',
      'F',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'D',
      'M',
      'D',
      'F',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      'Q1',
      'Q2',
      'Q3',
      'Q4',
    ],
    'QUARTERS': <dynamic>[
      '1. Quartal',
      '2. Quartal',
      '3. Quartal',
      '4. Quartal',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d. MMMM y',
      'd. MMMM y',
      'dd.MM.y',
      'dd.MM.yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      '{1} \'um\' {0}',
      '{1} \'um\' {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'de_CH': <String, dynamic>{
    'NAME': 'de_CH',
    'ERAS': <dynamic>[
      'v. Chr.',
      'n. Chr.',
    ],
    'ERANAMES': <dynamic>[
      'v. Chr.',
      'n. Chr.',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'Januar',
      'Februar',
      'März',
      'April',
      'Mai',
      'Juni',
      'Juli',
      'August',
      'September',
      'Oktober',
      'November',
      'Dezember',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'Januar',
      'Februar',
      'März',
      'April',
      'Mai',
      'Juni',
      'Juli',
      'August',
      'September',
      'Oktober',
      'November',
      'Dezember',
    ],
    'SHORTMONTHS': <dynamic>[
      'Jan.',
      'Feb.',
      'März',
      'Apr.',
      'Mai',
      'Juni',
      'Juli',
      'Aug.',
      'Sept.',
      'Okt.',
      'Nov.',
      'Dez.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'Jan',
      'Feb',
      'Mär',
      'Apr',
      'Mai',
      'Jun',
      'Jul',
      'Aug',
      'Sep',
      'Okt',
      'Nov',
      'Dez',
    ],
    'WEEKDAYS': <dynamic>[
      'Sonntag',
      'Montag',
      'Dienstag',
      'Mittwoch',
      'Donnerstag',
      'Freitag',
      'Samstag',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'Sonntag',
      'Montag',
      'Dienstag',
      'Mittwoch',
      'Donnerstag',
      'Freitag',
      'Samstag',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'So.',
      'Mo.',
      'Di.',
      'Mi.',
      'Do.',
      'Fr.',
      'Sa.',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'So',
      'Mo',
      'Di',
      'Mi',
      'Do',
      'Fr',
      'Sa',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'D',
      'M',
      'D',
      'F',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'D',
      'M',
      'D',
      'F',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      'Q1',
      'Q2',
      'Q3',
      'Q4',
    ],
    'QUARTERS': <dynamic>[
      '1. Quartal',
      '2. Quartal',
      '3. Quartal',
      '4. Quartal',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d. MMMM y',
      'd. MMMM y',
      'dd.MM.y',
      'dd.MM.yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      '{1} \'um\' {0}',
      '{1} \'um\' {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'el': <String, dynamic>{
    'NAME': 'el',
    'ERAS': <dynamic>[
      'π.Χ.',
      'μ.Χ.',
    ],
    'ERANAMES': <dynamic>[
      'προ Χριστού',
      'μετά Χριστόν',
    ],
    'NARROWMONTHS': <dynamic>[
      'Ι',
      'Φ',
      'Μ',
      'Α',
      'Μ',
      'Ι',
      'Ι',
      'Α',
      'Σ',
      'Ο',
      'Ν',
      'Δ',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'Ι',
      'Φ',
      'Μ',
      'Α',
      'Μ',
      'Ι',
      'Ι',
      'Α',
      'Σ',
      'Ο',
      'Ν',
      'Δ',
    ],
    'MONTHS': <dynamic>[
      'Ιανουαρίου',
      'Φεβρουαρίου',
      'Μαρτίου',
      'Απριλίου',
      'Μαΐου',
      'Ιουνίου',
      'Ιουλίου',
      'Αυγούστου',
      'Σεπτεμβρίου',
      'Οκτωβρίου',
      'Νοεμβρίου',
      'Δεκεμβρίου',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'Ιανουάριος',
      'Φεβρουάριος',
      'Μάρτιος',
      'Απρίλιος',
      'Μάιος',
      'Ιούνιος',
      'Ιούλιος',
      'Αύγουστος',
      'Σεπτέμβριος',
      'Οκτώβριος',
      'Νοέμβριος',
      'Δεκέμβριος',
    ],
    'SHORTMONTHS': <dynamic>[
      'Ιαν',
      'Φεβ',
      'Μαρ',
      'Απρ',
      'Μαΐ',
      'Ιουν',
      'Ιουλ',
      'Αυγ',
      'Σεπ',
      'Οκτ',
      'Νοε',
      'Δεκ',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'Ιαν',
      'Φεβ',
      'Μάρ',
      'Απρ',
      'Μάι',
      'Ιούν',
      'Ιούλ',
      'Αύγ',
      'Σεπ',
      'Οκτ',
      'Νοέ',
      'Δεκ',
    ],
    'WEEKDAYS': <dynamic>[
      'Κυριακή',
      'Δευτέρα',
      'Τρίτη',
      'Τετάρτη',
      'Πέμπτη',
      'Παρασκευή',
      'Σάββατο',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'Κυριακή',
      'Δευτέρα',
      'Τρίτη',
      'Τετάρτη',
      'Πέμπτη',
      'Παρασκευή',
      'Σάββατο',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'Κυρ',
      'Δευ',
      'Τρί',
      'Τετ',
      'Πέμ',
      'Παρ',
      'Σάβ',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'Κυρ',
      'Δευ',
      'Τρί',
      'Τετ',
      'Πέμ',
      'Παρ',
      'Σάβ',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'Κ',
      'Δ',
      'Τ',
      'Τ',
      'Π',
      'Π',
      'Σ',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'Κ',
      'Δ',
      'Τ',
      'Τ',
      'Π',
      'Π',
      'Σ',
    ],
    'SHORTQUARTERS': <dynamic>[
      'Τ1',
      'Τ2',
      'Τ3',
      'Τ4',
    ],
    'QUARTERS': <dynamic>[
      '1ο τρίμηνο',
      '2ο τρίμηνο',
      '3ο τρίμηνο',
      '4ο τρίμηνο',
    ],
    'AMPMS': <dynamic>[
      'π.μ.',
      'μ.μ.',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d MMMM y',
      'd MMMM y',
      'd MMM y',
      'd/M/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'h:mm:ss a zzzz',
      'h:mm:ss a z',
      'h:mm:ss a',
      'h:mm a',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      '{1} - {0}',
      '{1} - {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'en': <String, dynamic>{
    'NAME': 'en',
    'ERAS': <dynamic>[
      'BC',
      'AD',
    ],
    'ERANAMES': <dynamic>[
      'Before Christ',
      'Anno Domini',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'January',
      'February',
      'March',
      'April',
      'May',
      'June',
      'July',
      'August',
      'September',
      'October',
      'November',
      'December',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'January',
      'February',
      'March',
      'April',
      'May',
      'June',
      'July',
      'August',
      'September',
      'October',
      'November',
      'December',
    ],
    'SHORTMONTHS': <dynamic>[
      'Jan',
      'Feb',
      'Mar',
      'Apr',
      'May',
      'Jun',
      'Jul',
      'Aug',
      'Sep',
      'Oct',
      'Nov',
      'Dec',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'Jan',
      'Feb',
      'Mar',
      'Apr',
      'May',
      'Jun',
      'Jul',
      'Aug',
      'Sep',
      'Oct',
      'Nov',
      'Dec',
    ],
    'WEEKDAYS': <dynamic>[
      'Sunday',
      'Monday',
      'Tuesday',
      'Wednesday',
      'Thursday',
      'Friday',
      'Saturday',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'Sunday',
      'Monday',
      'Tuesday',
      'Wednesday',
      'Thursday',
      'Friday',
      'Saturday',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'Sun',
      'Mon',
      'Tue',
      'Wed',
      'Thu',
      'Fri',
      'Sat',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'Sun',
      'Mon',
      'Tue',
      'Wed',
      'Thu',
      'Fri',
      'Sat',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'W',
      'T',
      'F',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'W',
      'T',
      'F',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      'Q1',
      'Q2',
      'Q3',
      'Q4',
    ],
    'QUARTERS': <dynamic>[
      '1st quarter',
      '2nd quarter',
      '3rd quarter',
      '4th quarter',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, MMMM d, y',
      'MMMM d, y',
      'MMM d, y',
      'M/d/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'h:mm:ss a zzzz',
      'h:mm:ss a z',
      'h:mm:ss a',
      'h:mm a',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} \'at\' {0}',
      '{1} \'at\' {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'en_AU': <String, dynamic>{
    'NAME': 'en_AU',
    'ERAS': <dynamic>[
      'BC',
      'AD',
    ],
    'ERANAMES': <dynamic>[
      'Before Christ',
      'Anno Domini',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'January',
      'February',
      'March',
      'April',
      'May',
      'June',
      'July',
      'August',
      'September',
      'October',
      'November',
      'December',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'January',
      'February',
      'March',
      'April',
      'May',
      'June',
      'July',
      'August',
      'September',
      'October',
      'November',
      'December',
    ],
    'SHORTMONTHS': <dynamic>[
      'Jan',
      'Feb',
      'Mar',
      'Apr',
      'May',
      'Jun',
      'Jul',
      'Aug',
      'Sep',
      'Oct',
      'Nov',
      'Dec',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'Jan',
      'Feb',
      'Mar',
      'Apr',
      'May',
      'Jun',
      'Jul',
      'Aug',
      'Sep',
      'Oct',
      'Nov',
      'Dec',
    ],
    'WEEKDAYS': <dynamic>[
      'Sunday',
      'Monday',
      'Tuesday',
      'Wednesday',
      'Thursday',
      'Friday',
      'Saturday',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'Sunday',
      'Monday',
      'Tuesday',
      'Wednesday',
      'Thursday',
      'Friday',
      'Saturday',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'Sun',
      'Mon',
      'Tue',
      'Wed',
      'Thu',
      'Fri',
      'Sat',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'Sun',
      'Mon',
      'Tue',
      'Wed',
      'Thu',
      'Fri',
      'Sat',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'Su.',
      'M.',
      'Tu.',
      'W.',
      'Th.',
      'F.',
      'Sa.',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'Su.',
      'M.',
      'Tu.',
      'W.',
      'Th.',
      'F.',
      'Sa.',
    ],
    'SHORTQUARTERS': <dynamic>[
      'Q1',
      'Q2',
      'Q3',
      'Q4',
    ],
    'QUARTERS': <dynamic>[
      '1st quarter',
      '2nd quarter',
      '3rd quarter',
      '4th quarter',
    ],
    'AMPMS': <dynamic>[
      'am',
      'pm',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d MMMM y',
      'd MMMM y',
      'd MMM y',
      'd/M/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'h:mm:ss a zzzz',
      'h:mm:ss a z',
      'h:mm:ss a',
      'h:mm a',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} \'at\' {0}',
      '{1} \'at\' {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'en_CA': <String, dynamic>{
    'NAME': 'en_CA',
    'ERAS': <dynamic>[
      'BC',
      'AD',
    ],
    'ERANAMES': <dynamic>[
      'Before Christ',
      'Anno Domini',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'January',
      'February',
      'March',
      'April',
      'May',
      'June',
      'July',
      'August',
      'September',
      'October',
      'November',
      'December',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'January',
      'February',
      'March',
      'April',
      'May',
      'June',
      'July',
      'August',
      'September',
      'October',
      'November',
      'December',
    ],
    'SHORTMONTHS': <dynamic>[
      'Jan.',
      'Feb.',
      'Mar.',
      'Apr.',
      'May',
      'Jun.',
      'Jul.',
      'Aug.',
      'Sep.',
      'Oct.',
      'Nov.',
      'Dec.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'Jan.',
      'Feb.',
      'Mar.',
      'Apr.',
      'May',
      'Jun.',
      'Jul.',
      'Aug.',
      'Sep.',
      'Oct.',
      'Nov.',
      'Dec.',
    ],
    'WEEKDAYS': <dynamic>[
      'Sunday',
      'Monday',
      'Tuesday',
      'Wednesday',
      'Thursday',
      'Friday',
      'Saturday',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'Sunday',
      'Monday',
      'Tuesday',
      'Wednesday',
      'Thursday',
      'Friday',
      'Saturday',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'Sun.',
      'Mon.',
      'Tue.',
      'Wed.',
      'Thu.',
      'Fri.',
      'Sat.',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'Sun.',
      'Mon.',
      'Tue.',
      'Wed.',
      'Thu.',
      'Fri.',
      'Sat.',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'W',
      'T',
      'F',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'W',
      'T',
      'F',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      'Q1',
      'Q2',
      'Q3',
      'Q4',
    ],
    'QUARTERS': <dynamic>[
      '1st quarter',
      '2nd quarter',
      '3rd quarter',
      '4th quarter',
    ],
    'AMPMS': <dynamic>[
      'a.m.',
      'p.m.',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, MMMM d, y',
      'MMMM d, y',
      'MMM d, y',
      'y-MM-dd',
    ],
    'TIMEFORMATS': <dynamic>[
      'h:mm:ss a zzzz',
      'h:mm:ss a z',
      'h:mm:ss a',
      'h:mm a',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} \'at\' {0}',
      '{1} \'at\' {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'en_GB': <String, dynamic>{
    'NAME': 'en_GB',
    'ERAS': <dynamic>[
      'BC',
      'AD',
    ],
    'ERANAMES': <dynamic>[
      'Before Christ',
      'Anno Domini',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'January',
      'February',
      'March',
      'April',
      'May',
      'June',
      'July',
      'August',
      'September',
      'October',
      'November',
      'December',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'January',
      'February',
      'March',
      'April',
      'May',
      'June',
      'July',
      'August',
      'September',
      'October',
      'November',
      'December',
    ],
    'SHORTMONTHS': <dynamic>[
      'Jan',
      'Feb',
      'Mar',
      'Apr',
      'May',
      'Jun',
      'Jul',
      'Aug',
      'Sep',
      'Oct',
      'Nov',
      'Dec',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'Jan',
      'Feb',
      'Mar',
      'Apr',
      'May',
      'Jun',
      'Jul',
      'Aug',
      'Sep',
      'Oct',
      'Nov',
      'Dec',
    ],
    'WEEKDAYS': <dynamic>[
      'Sunday',
      'Monday',
      'Tuesday',
      'Wednesday',
      'Thursday',
      'Friday',
      'Saturday',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'Sunday',
      'Monday',
      'Tuesday',
      'Wednesday',
      'Thursday',
      'Friday',
      'Saturday',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'Sun',
      'Mon',
      'Tue',
      'Wed',
      'Thu',
      'Fri',
      'Sat',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'Sun',
      'Mon',
      'Tue',
      'Wed',
      'Thu',
      'Fri',
      'Sat',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'W',
      'T',
      'F',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'W',
      'T',
      'F',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      'Q1',
      'Q2',
      'Q3',
      'Q4',
    ],
    'QUARTERS': <dynamic>[
      '1st quarter',
      '2nd quarter',
      '3rd quarter',
      '4th quarter',
    ],
    'AMPMS': <dynamic>[
      'am',
      'pm',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d MMMM y',
      'd MMMM y',
      'd MMM y',
      'dd/MM/y',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      '{1} \'at\' {0}',
      '{1} \'at\' {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'en_IE': <String, dynamic>{
    'NAME': 'en_IE',
    'ERAS': <dynamic>[
      'BC',
      'AD',
    ],
    'ERANAMES': <dynamic>[
      'Before Christ',
      'Anno Domini',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'January',
      'February',
      'March',
      'April',
      'May',
      'June',
      'July',
      'August',
      'September',
      'October',
      'November',
      'December',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'January',
      'February',
      'March',
      'April',
      'May',
      'June',
      'July',
      'August',
      'September',
      'October',
      'November',
      'December',
    ],
    'SHORTMONTHS': <dynamic>[
      'Jan',
      'Feb',
      'Mar',
      'Apr',
      'May',
      'Jun',
      'Jul',
      'Aug',
      'Sep',
      'Oct',
      'Nov',
      'Dec',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'Jan',
      'Feb',
      'Mar',
      'Apr',
      'May',
      'Jun',
      'Jul',
      'Aug',
      'Sep',
      'Oct',
      'Nov',
      'Dec',
    ],
    'WEEKDAYS': <dynamic>[
      'Sunday',
      'Monday',
      'Tuesday',
      'Wednesday',
      'Thursday',
      'Friday',
      'Saturday',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'Sunday',
      'Monday',
      'Tuesday',
      'Wednesday',
      'Thursday',
      'Friday',
      'Saturday',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'Sun',
      'Mon',
      'Tue',
      'Wed',
      'Thu',
      'Fri',
      'Sat',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'Sun',
      'Mon',
      'Tue',
      'Wed',
      'Thu',
      'Fri',
      'Sat',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'W',
      'T',
      'F',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'W',
      'T',
      'F',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      'Q1',
      'Q2',
      'Q3',
      'Q4',
    ],
    'QUARTERS': <dynamic>[
      '1st quarter',
      '2nd quarter',
      '3rd quarter',
      '4th quarter',
    ],
    'AMPMS': <dynamic>[
      'a.m.',
      'p.m.',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE d MMMM y',
      'd MMMM y',
      'd MMM y',
      'dd/MM/y',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      '{1} \'at\' {0}',
      '{1} \'at\' {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'en_IN': <String, dynamic>{
    'NAME': 'en_IN',
    'ERAS': <dynamic>[
      'BC',
      'AD',
    ],
    'ERANAMES': <dynamic>[
      'Before Christ',
      'Anno Domini',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'January',
      'February',
      'March',
      'April',
      'May',
      'June',
      'July',
      'August',
      'September',
      'October',
      'November',
      'December',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'January',
      'February',
      'March',
      'April',
      'May',
      'June',
      'July',
      'August',
      'September',
      'October',
      'November',
      'December',
    ],
    'SHORTMONTHS': <dynamic>[
      'Jan',
      'Feb',
      'Mar',
      'Apr',
      'May',
      'Jun',
      'Jul',
      'Aug',
      'Sep',
      'Oct',
      'Nov',
      'Dec',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'Jan',
      'Feb',
      'Mar',
      'Apr',
      'May',
      'Jun',
      'Jul',
      'Aug',
      'Sep',
      'Oct',
      'Nov',
      'Dec',
    ],
    'WEEKDAYS': <dynamic>[
      'Sunday',
      'Monday',
      'Tuesday',
      'Wednesday',
      'Thursday',
      'Friday',
      'Saturday',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'Sunday',
      'Monday',
      'Tuesday',
      'Wednesday',
      'Thursday',
      'Friday',
      'Saturday',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'Sun',
      'Mon',
      'Tue',
      'Wed',
      'Thu',
      'Fri',
      'Sat',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'Sun',
      'Mon',
      'Tue',
      'Wed',
      'Thu',
      'Fri',
      'Sat',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'W',
      'T',
      'F',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'W',
      'T',
      'F',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      'Q1',
      'Q2',
      'Q3',
      'Q4',
    ],
    'QUARTERS': <dynamic>[
      '1st quarter',
      '2nd quarter',
      '3rd quarter',
      '4th quarter',
    ],
    'AMPMS': <dynamic>[
      'am',
      'pm',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d MMMM, y',
      'd MMMM y',
      'dd-MMM-y',
      'dd/MM/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'h:mm:ss a zzzz',
      'h:mm:ss a z',
      'h:mm:ss a',
      'h:mm a',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      6,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} \'at\' {0}',
      '{1} \'at\' {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'en_SG': <String, dynamic>{
    'NAME': 'en_SG',
    'ERAS': <dynamic>[
      'BC',
      'AD',
    ],
    'ERANAMES': <dynamic>[
      'Before Christ',
      'Anno Domini',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'January',
      'February',
      'March',
      'April',
      'May',
      'June',
      'July',
      'August',
      'September',
      'October',
      'November',
      'December',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'January',
      'February',
      'March',
      'April',
      'May',
      'June',
      'July',
      'August',
      'September',
      'October',
      'November',
      'December',
    ],
    'SHORTMONTHS': <dynamic>[
      'Jan',
      'Feb',
      'Mar',
      'Apr',
      'May',
      'Jun',
      'Jul',
      'Aug',
      'Sep',
      'Oct',
      'Nov',
      'Dec',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'Jan',
      'Feb',
      'Mar',
      'Apr',
      'May',
      'Jun',
      'Jul',
      'Aug',
      'Sep',
      'Oct',
      'Nov',
      'Dec',
    ],
    'WEEKDAYS': <dynamic>[
      'Sunday',
      'Monday',
      'Tuesday',
      'Wednesday',
      'Thursday',
      'Friday',
      'Saturday',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'Sunday',
      'Monday',
      'Tuesday',
      'Wednesday',
      'Thursday',
      'Friday',
      'Saturday',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'Sun',
      'Mon',
      'Tue',
      'Wed',
      'Thu',
      'Fri',
      'Sat',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'Sun',
      'Mon',
      'Tue',
      'Wed',
      'Thu',
      'Fri',
      'Sat',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'W',
      'T',
      'F',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'W',
      'T',
      'F',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      'Q1',
      'Q2',
      'Q3',
      'Q4',
    ],
    'QUARTERS': <dynamic>[
      '1st quarter',
      '2nd quarter',
      '3rd quarter',
      '4th quarter',
    ],
    'AMPMS': <dynamic>[
      'am',
      'pm',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d MMMM y',
      'd MMMM y',
      'd MMM y',
      'd/M/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'h:mm:ss a zzzz',
      'h:mm:ss a z',
      'h:mm:ss a',
      'h:mm a',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} \'at\' {0}',
      '{1} \'at\' {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'en_US': <String, dynamic>{
    'NAME': 'en_US',
    'ERAS': <dynamic>[
      'BC',
      'AD',
    ],
    'ERANAMES': <dynamic>[
      'Before Christ',
      'Anno Domini',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'January',
      'February',
      'March',
      'April',
      'May',
      'June',
      'July',
      'August',
      'September',
      'October',
      'November',
      'December',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'January',
      'February',
      'March',
      'April',
      'May',
      'June',
      'July',
      'August',
      'September',
      'October',
      'November',
      'December',
    ],
    'SHORTMONTHS': <dynamic>[
      'Jan',
      'Feb',
      'Mar',
      'Apr',
      'May',
      'Jun',
      'Jul',
      'Aug',
      'Sep',
      'Oct',
      'Nov',
      'Dec',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'Jan',
      'Feb',
      'Mar',
      'Apr',
      'May',
      'Jun',
      'Jul',
      'Aug',
      'Sep',
      'Oct',
      'Nov',
      'Dec',
    ],
    'WEEKDAYS': <dynamic>[
      'Sunday',
      'Monday',
      'Tuesday',
      'Wednesday',
      'Thursday',
      'Friday',
      'Saturday',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'Sunday',
      'Monday',
      'Tuesday',
      'Wednesday',
      'Thursday',
      'Friday',
      'Saturday',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'Sun',
      'Mon',
      'Tue',
      'Wed',
      'Thu',
      'Fri',
      'Sat',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'Sun',
      'Mon',
      'Tue',
      'Wed',
      'Thu',
      'Fri',
      'Sat',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'W',
      'T',
      'F',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'W',
      'T',
      'F',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      'Q1',
      'Q2',
      'Q3',
      'Q4',
    ],
    'QUARTERS': <dynamic>[
      '1st quarter',
      '2nd quarter',
      '3rd quarter',
      '4th quarter',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, MMMM d, y',
      'MMMM d, y',
      'MMM d, y',
      'M/d/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'h:mm:ss a zzzz',
      'h:mm:ss a z',
      'h:mm:ss a',
      'h:mm a',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} \'at\' {0}',
      '{1} \'at\' {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'en_ZA': <String, dynamic>{
    'NAME': 'en_ZA',
    'ERAS': <dynamic>[
      'BC',
      'AD',
    ],
    'ERANAMES': <dynamic>[
      'Before Christ',
      'Anno Domini',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'January',
      'February',
      'March',
      'April',
      'May',
      'June',
      'July',
      'August',
      'September',
      'October',
      'November',
      'December',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'January',
      'February',
      'March',
      'April',
      'May',
      'June',
      'July',
      'August',
      'September',
      'October',
      'November',
      'December',
    ],
    'SHORTMONTHS': <dynamic>[
      'Jan',
      'Feb',
      'Mar',
      'Apr',
      'May',
      'Jun',
      'Jul',
      'Aug',
      'Sep',
      'Oct',
      'Nov',
      'Dec',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'Jan',
      'Feb',
      'Mar',
      'Apr',
      'May',
      'Jun',
      'Jul',
      'Aug',
      'Sep',
      'Oct',
      'Nov',
      'Dec',
    ],
    'WEEKDAYS': <dynamic>[
      'Sunday',
      'Monday',
      'Tuesday',
      'Wednesday',
      'Thursday',
      'Friday',
      'Saturday',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'Sunday',
      'Monday',
      'Tuesday',
      'Wednesday',
      'Thursday',
      'Friday',
      'Saturday',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'Sun',
      'Mon',
      'Tue',
      'Wed',
      'Thu',
      'Fri',
      'Sat',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'Sun',
      'Mon',
      'Tue',
      'Wed',
      'Thu',
      'Fri',
      'Sat',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'W',
      'T',
      'F',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'W',
      'T',
      'F',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      'Q1',
      'Q2',
      'Q3',
      'Q4',
    ],
    'QUARTERS': <dynamic>[
      '1st quarter',
      '2nd quarter',
      '3rd quarter',
      '4th quarter',
    ],
    'AMPMS': <dynamic>[
      'am',
      'pm',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, dd MMMM y',
      'dd MMMM y',
      'dd MMM y',
      'y/MM/dd',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} \'at\' {0}',
      '{1} \'at\' {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'es': <String, dynamic>{
    'NAME': 'es',
    'ERAS': <dynamic>[
      'a. C.',
      'd. C.',
    ],
    'ERANAMES': <dynamic>[
      'antes de Cristo',
      'después de Cristo',
    ],
    'NARROWMONTHS': <dynamic>[
      'E',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'E',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'enero',
      'febrero',
      'marzo',
      'abril',
      'mayo',
      'junio',
      'julio',
      'agosto',
      'septiembre',
      'octubre',
      'noviembre',
      'diciembre',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'enero',
      'febrero',
      'marzo',
      'abril',
      'mayo',
      'junio',
      'julio',
      'agosto',
      'septiembre',
      'octubre',
      'noviembre',
      'diciembre',
    ],
    'SHORTMONTHS': <dynamic>[
      'ene.',
      'feb.',
      'mar.',
      'abr.',
      'may.',
      'jun.',
      'jul.',
      'ago.',
      'sept.',
      'oct.',
      'nov.',
      'dic.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'ene.',
      'feb.',
      'mar.',
      'abr.',
      'may.',
      'jun.',
      'jul.',
      'ago.',
      'sept.',
      'oct.',
      'nov.',
      'dic.',
    ],
    'WEEKDAYS': <dynamic>[
      'domingo',
      'lunes',
      'martes',
      'miércoles',
      'jueves',
      'viernes',
      'sábado',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'domingo',
      'lunes',
      'martes',
      'miércoles',
      'jueves',
      'viernes',
      'sábado',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'dom.',
      'lun.',
      'mar.',
      'mié.',
      'jue.',
      'vie.',
      'sáb.',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'dom.',
      'lun.',
      'mar.',
      'mié.',
      'jue.',
      'vie.',
      'sáb.',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'D',
      'L',
      'M',
      'X',
      'J',
      'V',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'D',
      'L',
      'M',
      'X',
      'J',
      'V',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      'T1',
      'T2',
      'T3',
      'T4',
    ],
    'QUARTERS': <dynamic>[
      '1.er trimestre',
      '2.º trimestre',
      '3.er trimestre',
      '4.º trimestre',
    ],
    'AMPMS': <dynamic>[
      'a. m.',
      'p. m.',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d \'de\' MMMM \'de\' y',
      'd \'de\' MMMM \'de\' y',
      'd MMM y',
      'd/M/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'H:mm:ss (zzzz)',
      'H:mm:ss z',
      'H:mm:ss',
      'H:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      '{1}, {0}',
      '{1}, {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'es_419': <String, dynamic>{
    'NAME': 'es_419',
    'ERAS': <dynamic>[
      'a. C.',
      'd. C.',
    ],
    'ERANAMES': <dynamic>[
      'antes de Cristo',
      'después de Cristo',
    ],
    'NARROWMONTHS': <dynamic>[
      'E',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'E',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'enero',
      'febrero',
      'marzo',
      'abril',
      'mayo',
      'junio',
      'julio',
      'agosto',
      'septiembre',
      'octubre',
      'noviembre',
      'diciembre',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'enero',
      'febrero',
      'marzo',
      'abril',
      'mayo',
      'junio',
      'julio',
      'agosto',
      'septiembre',
      'octubre',
      'noviembre',
      'diciembre',
    ],
    'SHORTMONTHS': <dynamic>[
      'ene.',
      'feb.',
      'mar.',
      'abr.',
      'may.',
      'jun.',
      'jul.',
      'ago.',
      'sep.',
      'oct.',
      'nov.',
      'dic.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'ene.',
      'feb.',
      'mar.',
      'abr.',
      'may.',
      'jun.',
      'jul.',
      'ago.',
      'sep.',
      'oct.',
      'nov.',
      'dic.',
    ],
    'WEEKDAYS': <dynamic>[
      'domingo',
      'lunes',
      'martes',
      'miércoles',
      'jueves',
      'viernes',
      'sábado',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'domingo',
      'lunes',
      'martes',
      'miércoles',
      'jueves',
      'viernes',
      'sábado',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'dom.',
      'lun.',
      'mar.',
      'mié.',
      'jue.',
      'vie.',
      'sáb.',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'dom.',
      'lun.',
      'mar.',
      'mié.',
      'jue.',
      'vie.',
      'sáb.',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'd',
      'l',
      'm',
      'm',
      'j',
      'v',
      's',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'D',
      'L',
      'M',
      'M',
      'J',
      'V',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      'T1',
      'T2',
      'T3',
      'T4',
    ],
    'QUARTERS': <dynamic>[
      '1.º trimestre',
      '2.º trimestre',
      '3.º trimestre',
      '4.º trimestre',
    ],
    'AMPMS': <dynamic>[
      'a.m.',
      'p.m.',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d \'de\' MMMM \'de\' y',
      'd \'de\' MMMM \'de\' y',
      'd MMM y',
      'd/M/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      '{1}, {0}',
      '{1}, {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'es_MX': <String, dynamic>{
    'NAME': 'es_MX',
    'ERAS': <dynamic>[
      'a. C.',
      'd. C.',
    ],
    'ERANAMES': <dynamic>[
      'antes de Cristo',
      'después de Cristo',
    ],
    'NARROWMONTHS': <dynamic>[
      'E',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'E',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'enero',
      'febrero',
      'marzo',
      'abril',
      'mayo',
      'junio',
      'julio',
      'agosto',
      'septiembre',
      'octubre',
      'noviembre',
      'diciembre',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'enero',
      'febrero',
      'marzo',
      'abril',
      'mayo',
      'junio',
      'julio',
      'agosto',
      'septiembre',
      'octubre',
      'noviembre',
      'diciembre',
    ],
    'SHORTMONTHS': <dynamic>[
      'ene.',
      'feb.',
      'mar.',
      'abr.',
      'may.',
      'jun.',
      'jul.',
      'ago.',
      'sep.',
      'oct.',
      'nov.',
      'dic.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'ene.',
      'feb.',
      'mar.',
      'abr.',
      'may.',
      'jun.',
      'jul.',
      'ago.',
      'sep.',
      'oct.',
      'nov.',
      'dic.',
    ],
    'WEEKDAYS': <dynamic>[
      'domingo',
      'lunes',
      'martes',
      'miércoles',
      'jueves',
      'viernes',
      'sábado',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'domingo',
      'lunes',
      'martes',
      'miércoles',
      'jueves',
      'viernes',
      'sábado',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'dom.',
      'lun.',
      'mar.',
      'mié.',
      'jue.',
      'vie.',
      'sáb.',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'dom.',
      'lun.',
      'mar.',
      'mié.',
      'jue.',
      'vie.',
      'sáb.',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'D',
      'L',
      'M',
      'M',
      'J',
      'V',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'D',
      'L',
      'M',
      'M',
      'J',
      'V',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      '1er. trim.',
      '2º. trim.',
      '3er. trim.',
      '4º trim.',
    ],
    'QUARTERS': <dynamic>[
      '1.er trimestre',
      '2º. trimestre',
      '3.er trimestre',
      '4o. trimestre',
    ],
    'AMPMS': <dynamic>[
      'a. m.',
      'p. m.',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d \'de\' MMMM \'de\' y',
      'd \'de\' MMMM \'de\' y',
      'd MMM y',
      'dd/MM/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'H:mm:ss zzzz',
      'H:mm:ss z',
      'H:mm:ss',
      'H:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1}, {0}',
      '{1}, {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'es_US': <String, dynamic>{
    'NAME': 'es_US',
    'ERAS': <dynamic>[
      'a. C.',
      'd. C.',
    ],
    'ERANAMES': <dynamic>[
      'antes de Cristo',
      'después de Cristo',
    ],
    'NARROWMONTHS': <dynamic>[
      'E',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'E',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'enero',
      'febrero',
      'marzo',
      'abril',
      'mayo',
      'junio',
      'julio',
      'agosto',
      'septiembre',
      'octubre',
      'noviembre',
      'diciembre',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'enero',
      'febrero',
      'marzo',
      'abril',
      'mayo',
      'junio',
      'julio',
      'agosto',
      'septiembre',
      'octubre',
      'noviembre',
      'diciembre',
    ],
    'SHORTMONTHS': <dynamic>[
      'ene.',
      'feb.',
      'mar.',
      'abr.',
      'may.',
      'jun.',
      'jul.',
      'ago.',
      'sep.',
      'oct.',
      'nov.',
      'dic.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'ene.',
      'feb.',
      'mar.',
      'abr.',
      'may.',
      'jun.',
      'jul.',
      'ago.',
      'sep.',
      'oct.',
      'nov.',
      'dic.',
    ],
    'WEEKDAYS': <dynamic>[
      'domingo',
      'lunes',
      'martes',
      'miércoles',
      'jueves',
      'viernes',
      'sábado',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'domingo',
      'lunes',
      'martes',
      'miércoles',
      'jueves',
      'viernes',
      'sábado',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'dom.',
      'lun.',
      'mar.',
      'mié.',
      'jue.',
      'vie.',
      'sáb.',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'dom.',
      'lun.',
      'mar.',
      'mié.',
      'jue.',
      'vie.',
      'sáb.',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'D',
      'L',
      'M',
      'M',
      'J',
      'V',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'D',
      'L',
      'M',
      'M',
      'J',
      'V',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      'T1',
      'T2',
      'T3',
      'T4',
    ],
    'QUARTERS': <dynamic>[
      '1.er trimestre',
      '2.º trimestre',
      '3.er trimestre',
      '4.º trimestre',
    ],
    'AMPMS': <dynamic>[
      'a. m.',
      'p. m.',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d \'de\' MMMM \'de\' y',
      'd \'de\' MMMM \'de\' y',
      'd MMM y',
      'd/M/y',
    ],
    'TIMEFORMATS': <dynamic>[
      'h:mm:ss a zzzz',
      'h:mm:ss a z',
      'h:mm:ss a',
      'h:mm a',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1}, {0}',
      '{1}, {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'et': <String, dynamic>{
    'NAME': 'et',
    'ERAS': <dynamic>[
      'eKr',
      'pKr',
    ],
    'ERANAMES': <dynamic>[
      'enne Kristust',
      'pärast Kristust',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'V',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'V',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'jaanuar',
      'veebruar',
      'märts',
      'aprill',
      'mai',
      'juuni',
      'juuli',
      'august',
      'september',
      'oktoober',
      'november',
      'detsember',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'jaanuar',
      'veebruar',
      'märts',
      'aprill',
      'mai',
      'juuni',
      'juuli',
      'august',
      'september',
      'oktoober',
      'november',
      'detsember',
    ],
    'SHORTMONTHS': <dynamic>[
      'jaan',
      'veebr',
      'märts',
      'apr',
      'mai',
      'juuni',
      'juuli',
      'aug',
      'sept',
      'okt',
      'nov',
      'dets',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'jaan',
      'veebr',
      'märts',
      'apr',
      'mai',
      'juuni',
      'juuli',
      'aug',
      'sept',
      'okt',
      'nov',
      'dets',
    ],
    'WEEKDAYS': <dynamic>[
      'pühapäev',
      'esmaspäev',
      'teisipäev',
      'kolmapäev',
      'neljapäev',
      'reede',
      'laupäev',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'pühapäev',
      'esmaspäev',
      'teisipäev',
      'kolmapäev',
      'neljapäev',
      'reede',
      'laupäev',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'P',
      'E',
      'T',
      'K',
      'N',
      'R',
      'L',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'P',
      'E',
      'T',
      'K',
      'N',
      'R',
      'L',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'P',
      'E',
      'T',
      'K',
      'N',
      'R',
      'L',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'P',
      'E',
      'T',
      'K',
      'N',
      'R',
      'L',
    ],
    'SHORTQUARTERS': <dynamic>[
      'K1',
      'K2',
      'K3',
      'K4',
    ],
    'QUARTERS': <dynamic>[
      '1. kvartal',
      '2. kvartal',
      '3. kvartal',
      '4. kvartal',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d. MMMM y',
      'd. MMMM y',
      'd. MMM y',
      'dd.MM.yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'eu': <String, dynamic>{
    'NAME': 'eu',
    'ERAS': <dynamic>[
      'K.a.',
      'K.o.',
    ],
    'ERANAMES': <dynamic>[
      'K.a.',
      'Kristo ondoren',
    ],
    'NARROWMONTHS': <dynamic>[
      'U',
      'O',
      'M',
      'A',
      'M',
      'E',
      'U',
      'A',
      'I',
      'U',
      'A',
      'A',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'U',
      'O',
      'M',
      'A',
      'M',
      'E',
      'U',
      'A',
      'I',
      'U',
      'A',
      'A',
    ],
    'MONTHS': <dynamic>[
      'urtarrila',
      'otsaila',
      'martxoa',
      'apirila',
      'maiatza',
      'ekaina',
      'uztaila',
      'abuztua',
      'iraila',
      'urria',
      'azaroa',
      'abendua',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'urtarrila',
      'otsaila',
      'martxoa',
      'apirila',
      'maiatza',
      'ekaina',
      'uztaila',
      'abuztua',
      'iraila',
      'urria',
      'azaroa',
      'abendua',
    ],
    'SHORTMONTHS': <dynamic>[
      'urt.',
      'ots.',
      'mar.',
      'api.',
      'mai.',
      'eka.',
      'uzt.',
      'abu.',
      'ira.',
      'urr.',
      'aza.',
      'abe.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'urt.',
      'ots.',
      'mar.',
      'api.',
      'mai.',
      'eka.',
      'uzt.',
      'abu.',
      'ira.',
      'urr.',
      'aza.',
      'abe.',
    ],
    'WEEKDAYS': <dynamic>[
      'igandea',
      'astelehena',
      'asteartea',
      'asteazkena',
      'osteguna',
      'ostirala',
      'larunbata',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'igandea',
      'astelehena',
      'asteartea',
      'asteazkena',
      'osteguna',
      'ostirala',
      'larunbata',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'ig.',
      'al.',
      'ar.',
      'az.',
      'og.',
      'or.',
      'lr.',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'ig.',
      'al.',
      'ar.',
      'az.',
      'og.',
      'or.',
      'lr.',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'I',
      'A',
      'A',
      'A',
      'O',
      'O',
      'L',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'I',
      'A',
      'A',
      'A',
      'O',
      'O',
      'L',
    ],
    'SHORTQUARTERS': <dynamic>[
      '1Hh',
      '2Hh',
      '3Hh',
      '4Hh',
    ],
    'QUARTERS': <dynamic>[
      '1. hiruhilekoa',
      '2. hiruhilekoa',
      '3. hiruhilekoa',
      '4. hiruhilekoa',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'y(\'e\')\'ko\' MMMM\'ren\' d(\'a\'), EEEE',
      'y(\'e\')\'ko\' MMMM\'ren\' d(\'a\')',
      'y(\'e\')\'ko\' MMM d(\'a\')',
      'yy/M/d',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss (zzzz)',
      'HH:mm:ss (z)',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'fa': <String, dynamic>{
    'NAME': 'fa',
    'ERAS': <dynamic>[
      'ق.م.',
      'م.',
    ],
    'ERANAMES': <dynamic>[
      'قبل از میلاد',
      'میلادی',
    ],
    'NARROWMONTHS': <dynamic>[
      'ژ',
      'ف',
      'م',
      'آ',
      'م',
      'ژ',
      'ژ',
      'ا',
      'س',
      'ا',
      'ن',
      'د',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'ژ',
      'ف',
      'م',
      'آ',
      'م',
      'ژ',
      'ژ',
      'ا',
      'س',
      'ا',
      'ن',
      'د',
    ],
    'MONTHS': <dynamic>[
      'ژانویهٔ',
      'فوریهٔ',
      'مارس',
      'آوریل',
      'مهٔ',
      'ژوئن',
      'ژوئیهٔ',
      'اوت',
      'سپتامبر',
      'اکتبر',
      'نوامبر',
      'دسامبر',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'ژانویه',
      'فوریه',
      'مارس',
      'آوریل',
      'مه',
      'ژوئن',
      'ژوئیه',
      'اوت',
      'سپتامبر',
      'اکتبر',
      'نوامبر',
      'دسامبر',
    ],
    'SHORTMONTHS': <dynamic>[
      'ژانویهٔ',
      'فوریهٔ',
      'مارس',
      'آوریل',
      'مهٔ',
      'ژوئن',
      'ژوئیهٔ',
      'اوت',
      'سپتامبر',
      'اکتبر',
      'نوامبر',
      'دسامبر',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'ژانویه',
      'فوریه',
      'مارس',
      'آوریل',
      'مه',
      'ژوئن',
      'ژوئیه',
      'اوت',
      'سپتامبر',
      'اکتبر',
      'نوامبر',
      'دسامبر',
    ],
    'WEEKDAYS': <dynamic>[
      'یکشنبه',
      'دوشنبه',
      'سه‌شنبه',
      'چهارشنبه',
      'پنجشنبه',
      'جمعه',
      'شنبه',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'یکشنبه',
      'دوشنبه',
      'سه‌شنبه',
      'چهارشنبه',
      'پنجشنبه',
      'جمعه',
      'شنبه',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'یکشنبه',
      'دوشنبه',
      'سه‌شنبه',
      'چهارشنبه',
      'پنجشنبه',
      'جمعه',
      'شنبه',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'یکشنبه',
      'دوشنبه',
      'سه‌شنبه',
      'چهارشنبه',
      'پنجشنبه',
      'جمعه',
      'شنبه',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'ی',
      'د',
      'س',
      'چ',
      'پ',
      'ج',
      'ش',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'ی',
      'د',
      'س',
      'چ',
      'پ',
      'ج',
      'ش',
    ],
    'SHORTQUARTERS': <dynamic>[
      'س‌م۱',
      'س‌م۲',
      'س‌م۳',
      'س‌م۴',
    ],
    'QUARTERS': <dynamic>[
      'سه‌ماههٔ اول',
      'سه‌ماههٔ دوم',
      'سه‌ماههٔ سوم',
      'سه‌ماههٔ چهارم',
    ],
    'AMPMS': <dynamic>[
      'قبل‌ازظهر',
      'بعدازظهر',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE d MMMM y',
      'd MMMM y',
      'd MMM y',
      'y/M/d',
    ],
    'TIMEFORMATS': <dynamic>[
      'H:mm:ss (zzzz)',
      'H:mm:ss (z)',
      'H:mm:ss',
      'H:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 5,
    'WEEKENDRANGE': <dynamic>[
      4,
      4,
    ],
    'FIRSTWEEKCUTOFFDAY': 4,
    'DATETIMEFORMATS': <dynamic>[
      '{1}، ساعت {0}',
      '{1}، ساعت {0}',
      '{1}،‏ {0}',
      '{1}،‏ {0}',
    ],
    'ZERODIGIT': '۰',
  },
  'fi': <String, dynamic>{
    'NAME': 'fi',
    'ERAS': <dynamic>[
      'eKr.',
      'jKr.',
    ],
    'ERANAMES': <dynamic>[
      'ennen Kristuksen syntymää',
      'jälkeen Kristuksen syntymän',
    ],
    'NARROWMONTHS': <dynamic>[
      'T',
      'H',
      'M',
      'H',
      'T',
      'K',
      'H',
      'E',
      'S',
      'L',
      'M',
      'J',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'T',
      'H',
      'M',
      'H',
      'T',
      'K',
      'H',
      'E',
      'S',
      'L',
      'M',
      'J',
    ],
    'MONTHS': <dynamic>[
      'tammikuuta',
      'helmikuuta',
      'maaliskuuta',
      'huhtikuuta',
      'toukokuuta',
      'kesäkuuta',
      'heinäkuuta',
      'elokuuta',
      'syyskuuta',
      'lokakuuta',
      'marraskuuta',
      'joulukuuta',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'tammikuu',
      'helmikuu',
      'maaliskuu',
      'huhtikuu',
      'toukokuu',
      'kesäkuu',
      'heinäkuu',
      'elokuu',
      'syyskuu',
      'lokakuu',
      'marraskuu',
      'joulukuu',
    ],
    'SHORTMONTHS': <dynamic>[
      'tammik.',
      'helmik.',
      'maalisk.',
      'huhtik.',
      'toukok.',
      'kesäk.',
      'heinäk.',
      'elok.',
      'syysk.',
      'lokak.',
      'marrask.',
      'jouluk.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'tammi',
      'helmi',
      'maalis',
      'huhti',
      'touko',
      'kesä',
      'heinä',
      'elo',
      'syys',
      'loka',
      'marras',
      'joulu',
    ],
    'WEEKDAYS': <dynamic>[
      'sunnuntaina',
      'maanantaina',
      'tiistaina',
      'keskiviikkona',
      'torstaina',
      'perjantaina',
      'lauantaina',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'sunnuntai',
      'maanantai',
      'tiistai',
      'keskiviikko',
      'torstai',
      'perjantai',
      'lauantai',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'su',
      'ma',
      'ti',
      'ke',
      'to',
      'pe',
      'la',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'su',
      'ma',
      'ti',
      'ke',
      'to',
      'pe',
      'la',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'K',
      'T',
      'P',
      'L',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'K',
      'T',
      'P',
      'L',
    ],
    'SHORTQUARTERS': <dynamic>[
      '1. nelj.',
      '2. nelj.',
      '3. nelj.',
      '4. nelj.',
    ],
    'QUARTERS': <dynamic>[
      '1. neljännes',
      '2. neljännes',
      '3. neljännes',
      '4. neljännes',
    ],
    'AMPMS': <dynamic>[
      'ap.',
      'ip.',
    ],
    'DATEFORMATS': <dynamic>[
      'cccc d. MMMM y',
      'd. MMMM y',
      'd.M.y',
      'd.M.y',
    ],
    'TIMEFORMATS': <dynamic>[
      'H.mm.ss zzzz',
      'H.mm.ss z',
      'H.mm.ss',
      'H.mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      '{1} \'klo\' {0}',
      '{1} \'klo\' {0}',
      '{1} \'klo\' {0}',
      '{1} {0}',
    ],
  },
  'fil': <String, dynamic>{
    'NAME': 'fil',
    'ERAS': <dynamic>[
      'BC',
      'AD',
    ],
    'ERANAMES': <dynamic>[
      'Before Christ',
      'Anno Domini',
    ],
    'NARROWMONTHS': <dynamic>[
      'Ene',
      'Peb',
      'Mar',
      'Abr',
      'May',
      'Hun',
      'Hul',
      'Ago',
      'Set',
      'Okt',
      'Nob',
      'Dis',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'E',
      'P',
      'M',
      'A',
      'M',
      'Hun',
      'Hul',
      'Ago',
      'Set',
      'Okt',
      'Nob',
      'Dis',
    ],
    'MONTHS': <dynamic>[
      'Enero',
      'Pebrero',
      'Marso',
      'Abril',
      'Mayo',
      'Hunyo',
      'Hulyo',
      'Agosto',
      'Setyembre',
      'Oktubre',
      'Nobyembre',
      'Disyembre',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'Enero',
      'Pebrero',
      'Marso',
      'Abril',
      'Mayo',
      'Hunyo',
      'Hulyo',
      'Agosto',
      'Setyembre',
      'Oktubre',
      'Nobyembre',
      'Disyembre',
    ],
    'SHORTMONTHS': <dynamic>[
      'Ene',
      'Peb',
      'Mar',
      'Abr',
      'May',
      'Hun',
      'Hul',
      'Ago',
      'Set',
      'Okt',
      'Nob',
      'Dis',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'Ene',
      'Peb',
      'Mar',
      'Abr',
      'May',
      'Hun',
      'Hul',
      'Ago',
      'Set',
      'Okt',
      'Nob',
      'Dis',
    ],
    'WEEKDAYS': <dynamic>[
      'Linggo',
      'Lunes',
      'Martes',
      'Miyerkules',
      'Huwebes',
      'Biyernes',
      'Sabado',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'Linggo',
      'Lunes',
      'Martes',
      'Miyerkules',
      'Huwebes',
      'Biyernes',
      'Sabado',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'Lin',
      'Lun',
      'Mar',
      'Miy',
      'Huw',
      'Biy',
      'Sab',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'Lin',
      'Lun',
      'Mar',
      'Miy',
      'Huw',
      'Biy',
      'Sab',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'Lin',
      'Lun',
      'Mar',
      'Miy',
      'Huw',
      'Biy',
      'Sab',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'Lin',
      'Lun',
      'Mar',
      'Miy',
      'Huw',
      'Biy',
      'Sab',
    ],
    'SHORTQUARTERS': <dynamic>[
      'Q1',
      'Q2',
      'Q3',
      'Q4',
    ],
    'QUARTERS': <dynamic>[
      'ika-1 quarter',
      'ika-2 quarter',
      'ika-3 quarter',
      'ika-4 na quarter',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, MMMM d, y',
      'MMMM d, y',
      'MMM d, y',
      'M/d/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'h:mm:ss a zzzz',
      'h:mm:ss a z',
      'h:mm:ss a',
      'h:mm a',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} \'nang\' {0}',
      '{1} \'nang\' {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'fr': <String, dynamic>{
    'NAME': 'fr',
    'ERAS': <dynamic>[
      'av. J.-C.',
      'ap. J.-C.',
    ],
    'ERANAMES': <dynamic>[
      'avant Jésus-Christ',
      'après Jésus-Christ',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'janvier',
      'février',
      'mars',
      'avril',
      'mai',
      'juin',
      'juillet',
      'août',
      'septembre',
      'octobre',
      'novembre',
      'décembre',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'janvier',
      'février',
      'mars',
      'avril',
      'mai',
      'juin',
      'juillet',
      'août',
      'septembre',
      'octobre',
      'novembre',
      'décembre',
    ],
    'SHORTMONTHS': <dynamic>[
      'janv.',
      'févr.',
      'mars',
      'avr.',
      'mai',
      'juin',
      'juil.',
      'août',
      'sept.',
      'oct.',
      'nov.',
      'déc.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'janv.',
      'févr.',
      'mars',
      'avr.',
      'mai',
      'juin',
      'juil.',
      'août',
      'sept.',
      'oct.',
      'nov.',
      'déc.',
    ],
    'WEEKDAYS': <dynamic>[
      'dimanche',
      'lundi',
      'mardi',
      'mercredi',
      'jeudi',
      'vendredi',
      'samedi',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'dimanche',
      'lundi',
      'mardi',
      'mercredi',
      'jeudi',
      'vendredi',
      'samedi',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'dim.',
      'lun.',
      'mar.',
      'mer.',
      'jeu.',
      'ven.',
      'sam.',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'dim.',
      'lun.',
      'mar.',
      'mer.',
      'jeu.',
      'ven.',
      'sam.',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'D',
      'L',
      'M',
      'M',
      'J',
      'V',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'D',
      'L',
      'M',
      'M',
      'J',
      'V',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      'T1',
      'T2',
      'T3',
      'T4',
    ],
    'QUARTERS': <dynamic>[
      '1er trimestre',
      '2e trimestre',
      '3e trimestre',
      '4e trimestre',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE d MMMM y',
      'd MMMM y',
      'd MMM y',
      'dd/MM/y',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      '{1} \'à\' {0}',
      '{1} \'à\' {0}',
      '{1} \'à\' {0}',
      '{1} {0}',
    ],
  },
  'fr_CA': <String, dynamic>{
    'NAME': 'fr_CA',
    'ERAS': <dynamic>[
      'av. J.-C.',
      'ap. J.-C.',
    ],
    'ERANAMES': <dynamic>[
      'avant Jésus-Christ',
      'après Jésus-Christ',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'janvier',
      'février',
      'mars',
      'avril',
      'mai',
      'juin',
      'juillet',
      'août',
      'septembre',
      'octobre',
      'novembre',
      'décembre',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'janvier',
      'février',
      'mars',
      'avril',
      'mai',
      'juin',
      'juillet',
      'août',
      'septembre',
      'octobre',
      'novembre',
      'décembre',
    ],
    'SHORTMONTHS': <dynamic>[
      'janv.',
      'févr.',
      'mars',
      'avr.',
      'mai',
      'juin',
      'juill.',
      'août',
      'sept.',
      'oct.',
      'nov.',
      'déc.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'janv.',
      'févr.',
      'mars',
      'avr.',
      'mai',
      'juin',
      'juill.',
      'août',
      'sept.',
      'oct.',
      'nov.',
      'déc.',
    ],
    'WEEKDAYS': <dynamic>[
      'dimanche',
      'lundi',
      'mardi',
      'mercredi',
      'jeudi',
      'vendredi',
      'samedi',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'dimanche',
      'lundi',
      'mardi',
      'mercredi',
      'jeudi',
      'vendredi',
      'samedi',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'dim.',
      'lun.',
      'mar.',
      'mer.',
      'jeu.',
      'ven.',
      'sam.',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'dim.',
      'lun.',
      'mar.',
      'mer.',
      'jeu.',
      'ven.',
      'sam.',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'D',
      'L',
      'M',
      'M',
      'J',
      'V',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'D',
      'L',
      'M',
      'M',
      'J',
      'V',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      'T1',
      'T2',
      'T3',
      'T4',
    ],
    'QUARTERS': <dynamic>[
      '1er trimestre',
      '2e trimestre',
      '3e trimestre',
      '4e trimestre',
    ],
    'AMPMS': <dynamic>[
      'a.m.',
      'p.m.',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE d MMMM y',
      'd MMMM y',
      'd MMM y',
      'yy-MM-dd',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH \'h\' mm \'min\' ss \'s\' zzzz',
      'HH \'h\' mm \'min\' ss \'s\' z',
      'HH \'h\' mm \'min\' ss \'s\'',
      'HH \'h\' mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} \'à\' {0}',
      '{1} \'à\' {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'gl': <String, dynamic>{
    'NAME': 'gl',
    'ERAS': <dynamic>[
      'a.C.',
      'd.C.',
    ],
    'ERANAMES': <dynamic>[
      'antes de Cristo',
      'despois de Cristo',
    ],
    'NARROWMONTHS': <dynamic>[
      'x.',
      'f.',
      'm.',
      'a.',
      'm.',
      'x.',
      'x.',
      'a.',
      's.',
      'o.',
      'n.',
      'd.',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'X',
      'F',
      'M',
      'A',
      'M',
      'X',
      'X',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'xaneiro',
      'febreiro',
      'marzo',
      'abril',
      'maio',
      'xuño',
      'xullo',
      'agosto',
      'setembro',
      'outubro',
      'novembro',
      'decembro',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'Xaneiro',
      'Febreiro',
      'Marzo',
      'Abril',
      'Maio',
      'Xuño',
      'Xullo',
      'Agosto',
      'Setembro',
      'Outubro',
      'Novembro',
      'Decembro',
    ],
    'SHORTMONTHS': <dynamic>[
      'xan.',
      'feb.',
      'mar.',
      'abr.',
      'maio',
      'xuño',
      'xul.',
      'ago.',
      'set.',
      'out.',
      'nov.',
      'dec.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'Xan.',
      'Feb.',
      'Mar.',
      'Abr.',
      'Maio',
      'Xuño',
      'Xul.',
      'Ago.',
      'Set.',
      'Out.',
      'Nov.',
      'Dec.',
    ],
    'WEEKDAYS': <dynamic>[
      'domingo',
      'luns',
      'martes',
      'mércores',
      'xoves',
      'venres',
      'sábado',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'Domingo',
      'Luns',
      'Martes',
      'Mércores',
      'Xoves',
      'Venres',
      'Sábado',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'dom.',
      'luns',
      'mar.',
      'mér.',
      'xov.',
      'ven.',
      'sáb.',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'Dom.',
      'Luns',
      'Mar.',
      'Mér.',
      'Xov.',
      'Ven.',
      'Sáb.',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'd.',
      'l.',
      'm.',
      'm.',
      'x.',
      'v.',
      's.',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'D',
      'L',
      'M',
      'M',
      'X',
      'V',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      'T1',
      'T2',
      'T3',
      'T4',
    ],
    'QUARTERS': <dynamic>[
      '1.º trimestre',
      '2.º trimestre',
      '3.º trimestre',
      '4.º trimestre',
    ],
    'AMPMS': <dynamic>[
      'a.m.',
      'p.m.',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d \'de\' MMMM \'de\' y',
      'd \'de\' MMMM \'de\' y',
      'd \'de\' MMM \'de\' y',
      'dd/MM/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      '{0} \'do\' {1}',
      '{0} \'do\' {1}',
      '{0}, {1}',
      '{0}, {1}',
    ],
  },
  'gsw': <String, dynamic>{
    'NAME': 'gsw',
    'ERAS': <dynamic>[
      'v. Chr.',
      'n. Chr.',
    ],
    'ERANAMES': <dynamic>[
      'v. Chr.',
      'n. Chr.',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'Januar',
      'Februar',
      'März',
      'April',
      'Mai',
      'Juni',
      'Juli',
      'Auguscht',
      'Septämber',
      'Oktoober',
      'Novämber',
      'Dezämber',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'Januar',
      'Februar',
      'März',
      'April',
      'Mai',
      'Juni',
      'Juli',
      'Auguscht',
      'Septämber',
      'Oktoober',
      'Novämber',
      'Dezämber',
    ],
    'SHORTMONTHS': <dynamic>[
      'Jan',
      'Feb',
      'Mär',
      'Apr',
      'Mai',
      'Jun',
      'Jul',
      'Aug',
      'Sep',
      'Okt',
      'Nov',
      'Dez',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'Jan',
      'Feb',
      'Mär',
      'Apr',
      'Mai',
      'Jun',
      'Jul',
      'Aug',
      'Sep',
      'Okt',
      'Nov',
      'Dez',
    ],
    'WEEKDAYS': <dynamic>[
      'Sunntig',
      'Määntig',
      'Ziischtig',
      'Mittwuch',
      'Dunschtig',
      'Friitig',
      'Samschtig',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'Sunntig',
      'Määntig',
      'Ziischtig',
      'Mittwuch',
      'Dunschtig',
      'Friitig',
      'Samschtig',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'Su.',
      'Mä.',
      'Zi.',
      'Mi.',
      'Du.',
      'Fr.',
      'Sa.',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'Su.',
      'Mä.',
      'Zi.',
      'Mi.',
      'Du.',
      'Fr.',
      'Sa.',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'D',
      'M',
      'D',
      'F',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'D',
      'M',
      'D',
      'F',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      'Q1',
      'Q2',
      'Q3',
      'Q4',
    ],
    'QUARTERS': <dynamic>[
      '1. Quartal',
      '2. Quartal',
      '3. Quartal',
      '4. Quartal',
    ],
    'AMPMS': <dynamic>[
      'am Vormittag',
      'am Namittag',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d. MMMM y',
      'd. MMMM y',
      'dd.MM.y',
      'dd.MM.yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'gu': <String, dynamic>{
    'NAME': 'gu',
    'ERAS': <dynamic>[
      'ઈ.સ.પૂર્વે',
      'ઈ.સ.',
    ],
    'ERANAMES': <dynamic>[
      'ઈસવીસન પૂર્વે',
      'ઇસવીસન',
    ],
    'NARROWMONTHS': <dynamic>[
      'જા',
      'ફે',
      'મા',
      'એ',
      'મે',
      'જૂ',
      'જુ',
      'ઑ',
      'સ',
      'ઑ',
      'ન',
      'ડિ',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'જા',
      'ફે',
      'મા',
      'એ',
      'મે',
      'જૂ',
      'જુ',
      'ઑ',
      'સ',
      'ઑ',
      'ન',
      'ડિ',
    ],
    'MONTHS': <dynamic>[
      'જાન્યુઆરી',
      'ફેબ્રુઆરી',
      'માર્ચ',
      'એપ્રિલ',
      'મે',
      'જૂન',
      'જુલાઈ',
      'ઑગસ્ટ',
      'સપ્ટેમ્બર',
      'ઑક્ટોબર',
      'નવેમ્બર',
      'ડિસેમ્બર',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'જાન્યુઆરી',
      'ફેબ્રુઆરી',
      'માર્ચ',
      'એપ્રિલ',
      'મે',
      'જૂન',
      'જુલાઈ',
      'ઑગસ્ટ',
      'સપ્ટેમ્બર',
      'ઑક્ટોબર',
      'નવેમ્બર',
      'ડિસેમ્બર',
    ],
    'SHORTMONTHS': <dynamic>[
      'જાન્યુ',
      'ફેબ્રુ',
      'માર્ચ',
      'એપ્રિલ',
      'મે',
      'જૂન',
      'જુલાઈ',
      'ઑગસ્ટ',
      'સપ્ટે',
      'ઑક્ટો',
      'નવે',
      'ડિસે',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'જાન્યુ',
      'ફેબ્રુ',
      'માર્ચ',
      'એપ્રિલ',
      'મે',
      'જૂન',
      'જુલાઈ',
      'ઑગસ્ટ',
      'સપ્ટે',
      'ઑક્ટો',
      'નવે',
      'ડિસે',
    ],
    'WEEKDAYS': <dynamic>[
      'રવિવાર',
      'સોમવાર',
      'મંગળવાર',
      'બુધવાર',
      'ગુરુવાર',
      'શુક્રવાર',
      'શનિવાર',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'રવિવાર',
      'સોમવાર',
      'મંગળવાર',
      'બુધવાર',
      'ગુરુવાર',
      'શુક્રવાર',
      'શનિવાર',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'રવિ',
      'સોમ',
      'મંગળ',
      'બુધ',
      'ગુરુ',
      'શુક્ર',
      'શનિ',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'રવિ',
      'સોમ',
      'મંગળ',
      'બુધ',
      'ગુરુ',
      'શુક્ર',
      'શનિ',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'ર',
      'સો',
      'મં',
      'બુ',
      'ગુ',
      'શુ',
      'શ',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'ર',
      'સો',
      'મં',
      'બુ',
      'ગુ',
      'શુ',
      'શ',
    ],
    'SHORTQUARTERS': <dynamic>[
      'Q1',
      'Q2',
      'Q3',
      'Q4',
    ],
    'QUARTERS': <dynamic>[
      '1લો ત્રિમાસ',
      '2જો ત્રિમાસ',
      '3જો ત્રિમાસ',
      '4થો ત્રિમાસ',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d MMMM, y',
      'd MMMM, y',
      'd MMM, y',
      'd/M/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'hh:mm:ss a zzzz',
      'hh:mm:ss a z',
      'hh:mm:ss a',
      'hh:mm a',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      6,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} એ {0} વાગ્યે',
      '{1} એ {0} વાગ્યે',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'he': <String, dynamic>{
    'NAME': 'he',
    'ERAS': <dynamic>[
      'לפנה״ס',
      'לספירה',
    ],
    'ERANAMES': <dynamic>[
      'לפני הספירה',
      'לספירה',
    ],
    'NARROWMONTHS': <dynamic>[
      '1',
      '2',
      '3',
      '4',
      '5',
      '6',
      '7',
      '8',
      '9',
      '10',
      '11',
      '12',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      '1',
      '2',
      '3',
      '4',
      '5',
      '6',
      '7',
      '8',
      '9',
      '10',
      '11',
      '12',
    ],
    'MONTHS': <dynamic>[
      'ינואר',
      'פברואר',
      'מרץ',
      'אפריל',
      'מאי',
      'יוני',
      'יולי',
      'אוגוסט',
      'ספטמבר',
      'אוקטובר',
      'נובמבר',
      'דצמבר',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'ינואר',
      'פברואר',
      'מרץ',
      'אפריל',
      'מאי',
      'יוני',
      'יולי',
      'אוגוסט',
      'ספטמבר',
      'אוקטובר',
      'נובמבר',
      'דצמבר',
    ],
    'SHORTMONTHS': <dynamic>[
      'ינו׳',
      'פבר׳',
      'מרץ',
      'אפר׳',
      'מאי',
      'יוני',
      'יולי',
      'אוג׳',
      'ספט׳',
      'אוק׳',
      'נוב׳',
      'דצמ׳',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'ינו׳',
      'פבר׳',
      'מרץ',
      'אפר׳',
      'מאי',
      'יוני',
      'יולי',
      'אוג׳',
      'ספט׳',
      'אוק׳',
      'נוב׳',
      'דצמ׳',
    ],
    'WEEKDAYS': <dynamic>[
      'יום ראשון',
      'יום שני',
      'יום שלישי',
      'יום רביעי',
      'יום חמישי',
      'יום שישי',
      'יום שבת',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'יום ראשון',
      'יום שני',
      'יום שלישי',
      'יום רביעי',
      'יום חמישי',
      'יום שישי',
      'יום שבת',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'יום א׳',
      'יום ב׳',
      'יום ג׳',
      'יום ד׳',
      'יום ה׳',
      'יום ו׳',
      'שבת',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'יום א׳',
      'יום ב׳',
      'יום ג׳',
      'יום ד׳',
      'יום ה׳',
      'יום ו׳',
      'שבת',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'א׳',
      'ב׳',
      'ג׳',
      'ד׳',
      'ה׳',
      'ו׳',
      'ש׳',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'א׳',
      'ב׳',
      'ג׳',
      'ד׳',
      'ה׳',
      'ו׳',
      'ש׳',
    ],
    'SHORTQUARTERS': <dynamic>[
      'Q1',
      'Q2',
      'Q3',
      'Q4',
    ],
    'QUARTERS': <dynamic>[
      'רבעון 1',
      'רבעון 2',
      'רבעון 3',
      'רבעון 4',
    ],
    'AMPMS': <dynamic>[
      'לפנה״צ',
      'אחה״צ',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d בMMMM y',
      'd בMMMM y',
      'd בMMM y',
      'd.M.y',
    ],
    'TIMEFORMATS': <dynamic>[
      'H:mm:ss zzzz',
      'H:mm:ss z',
      'H:mm:ss',
      'H:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      4,
      5,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} בשעה {0}',
      '{1} בשעה {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'hi': <String, dynamic>{
    'NAME': 'hi',
    'ERAS': <dynamic>[
      'ईसा-पूर्व',
      'ईस्वी',
    ],
    'ERANAMES': <dynamic>[
      'ईसा-पूर्व',
      'ईसवी सन',
    ],
    'NARROWMONTHS': <dynamic>[
      'ज',
      'फ़',
      'मा',
      'अ',
      'म',
      'जू',
      'जु',
      'अ',
      'सि',
      'अ',
      'न',
      'दि',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'ज',
      'फ़',
      'मा',
      'अ',
      'म',
      'जू',
      'जु',
      'अ',
      'सि',
      'अ',
      'न',
      'दि',
    ],
    'MONTHS': <dynamic>[
      'जनवरी',
      'फ़रवरी',
      'मार्च',
      'अप्रैल',
      'मई',
      'जून',
      'जुलाई',
      'अगस्त',
      'सितंबर',
      'अक्तूबर',
      'नवंबर',
      'दिसंबर',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'जनवरी',
      'फ़रवरी',
      'मार्च',
      'अप्रैल',
      'मई',
      'जून',
      'जुलाई',
      'अगस्त',
      'सितंबर',
      'अक्तूबर',
      'नवंबर',
      'दिसंबर',
    ],
    'SHORTMONTHS': <dynamic>[
      'जन॰',
      'फ़र॰',
      'मार्च',
      'अप्रैल',
      'मई',
      'जून',
      'जुल॰',
      'अग॰',
      'सित॰',
      'अक्तू॰',
      'नव॰',
      'दिस॰',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'जन॰',
      'फ़र॰',
      'मार्च',
      'अप्रैल',
      'मई',
      'जून',
      'जुल॰',
      'अग॰',
      'सित॰',
      'अक्तू॰',
      'नव॰',
      'दिस॰',
    ],
    'WEEKDAYS': <dynamic>[
      'रविवार',
      'सोमवार',
      'मंगलवार',
      'बुधवार',
      'गुरुवार',
      'शुक्रवार',
      'शनिवार',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'रविवार',
      'सोमवार',
      'मंगलवार',
      'बुधवार',
      'गुरुवार',
      'शुक्रवार',
      'शनिवार',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'रवि',
      'सोम',
      'मंगल',
      'बुध',
      'गुरु',
      'शुक्र',
      'शनि',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'रवि',
      'सोम',
      'मंगल',
      'बुध',
      'गुरु',
      'शुक्र',
      'शनि',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'र',
      'सो',
      'मं',
      'बु',
      'गु',
      'शु',
      'श',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'र',
      'सो',
      'मं',
      'बु',
      'गु',
      'शु',
      'श',
    ],
    'SHORTQUARTERS': <dynamic>[
      'ति1',
      'ति2',
      'ति3',
      'ति4',
    ],
    'QUARTERS': <dynamic>[
      'पहली तिमाही',
      'दूसरी तिमाही',
      'तीसरी तिमाही',
      'चौथी तिमाही',
    ],
    'AMPMS': <dynamic>[
      'am',
      'pm',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d MMMM y',
      'd MMMM y',
      'd MMM y',
      'd/M/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'h:mm:ss a zzzz',
      'h:mm:ss a z',
      'h:mm:ss a',
      'h:mm a',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      6,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} को {0}',
      '{1} को {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'hr': <String, dynamic>{
    'NAME': 'hr',
    'ERAS': <dynamic>[
      'pr. Kr.',
      'po. Kr.',
    ],
    'ERANAMES': <dynamic>[
      'prije Krista',
      'poslije Krista',
    ],
    'NARROWMONTHS': <dynamic>[
      '1.',
      '2.',
      '3.',
      '4.',
      '5.',
      '6.',
      '7.',
      '8.',
      '9.',
      '10.',
      '11.',
      '12.',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      '1.',
      '2.',
      '3.',
      '4.',
      '5.',
      '6.',
      '7.',
      '8.',
      '9.',
      '10.',
      '11.',
      '12.',
    ],
    'MONTHS': <dynamic>[
      'siječnja',
      'veljače',
      'ožujka',
      'travnja',
      'svibnja',
      'lipnja',
      'srpnja',
      'kolovoza',
      'rujna',
      'listopada',
      'studenoga',
      'prosinca',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'siječanj',
      'veljača',
      'ožujak',
      'travanj',
      'svibanj',
      'lipanj',
      'srpanj',
      'kolovoz',
      'rujan',
      'listopad',
      'studeni',
      'prosinac',
    ],
    'SHORTMONTHS': <dynamic>[
      'sij',
      'velj',
      'ožu',
      'tra',
      'svi',
      'lip',
      'srp',
      'kol',
      'ruj',
      'lis',
      'stu',
      'pro',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'sij',
      'velj',
      'ožu',
      'tra',
      'svi',
      'lip',
      'srp',
      'kol',
      'ruj',
      'lis',
      'stu',
      'pro',
    ],
    'WEEKDAYS': <dynamic>[
      'nedjelja',
      'ponedjeljak',
      'utorak',
      'srijeda',
      'četvrtak',
      'petak',
      'subota',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'nedjelja',
      'ponedjeljak',
      'utorak',
      'srijeda',
      'četvrtak',
      'petak',
      'subota',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'ned',
      'pon',
      'uto',
      'sri',
      'čet',
      'pet',
      'sub',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'ned',
      'pon',
      'uto',
      'sri',
      'čet',
      'pet',
      'sub',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'N',
      'P',
      'U',
      'S',
      'Č',
      'P',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'n',
      'p',
      'u',
      's',
      'č',
      'p',
      's',
    ],
    'SHORTQUARTERS': <dynamic>[
      '1kv',
      '2kv',
      '3kv',
      '4kv',
    ],
    'QUARTERS': <dynamic>[
      '1. kvartal',
      '2. kvartal',
      '3. kvartal',
      '4. kvartal',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d. MMMM y.',
      'd. MMMM y.',
      'd. MMM y.',
      'dd. MM. y.',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss (zzzz)',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      '{1} \'u\' {0}',
      '{1} \'u\' {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'hu': <String, dynamic>{
    'NAME': 'hu',
    'ERAS': <dynamic>[
      'i. e.',
      'i. sz.',
    ],
    'ERANAMES': <dynamic>[
      'Krisztus előtt',
      'időszámításunk szerint',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'Á',
      'M',
      'J',
      'J',
      'A',
      'Sz',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'Á',
      'M',
      'J',
      'J',
      'A',
      'Sz',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'január',
      'február',
      'március',
      'április',
      'május',
      'június',
      'július',
      'augusztus',
      'szeptember',
      'október',
      'november',
      'december',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'január',
      'február',
      'március',
      'április',
      'május',
      'június',
      'július',
      'augusztus',
      'szeptember',
      'október',
      'november',
      'december',
    ],
    'SHORTMONTHS': <dynamic>[
      'jan.',
      'febr.',
      'márc.',
      'ápr.',
      'máj.',
      'jún.',
      'júl.',
      'aug.',
      'szept.',
      'okt.',
      'nov.',
      'dec.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'jan.',
      'febr.',
      'márc.',
      'ápr.',
      'máj.',
      'jún.',
      'júl.',
      'aug.',
      'szept.',
      'okt.',
      'nov.',
      'dec.',
    ],
    'WEEKDAYS': <dynamic>[
      'vasárnap',
      'hétfő',
      'kedd',
      'szerda',
      'csütörtök',
      'péntek',
      'szombat',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'vasárnap',
      'hétfő',
      'kedd',
      'szerda',
      'csütörtök',
      'péntek',
      'szombat',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'V',
      'H',
      'K',
      'Sze',
      'Cs',
      'P',
      'Szo',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'V',
      'H',
      'K',
      'Sze',
      'Cs',
      'P',
      'Szo',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'V',
      'H',
      'K',
      'Sz',
      'Cs',
      'P',
      'Sz',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'V',
      'H',
      'K',
      'Sz',
      'Cs',
      'P',
      'Sz',
    ],
    'SHORTQUARTERS': <dynamic>[
      'I. n.év',
      'II. n.év',
      'III. n.év',
      'IV. n.év',
    ],
    'QUARTERS': <dynamic>[
      'I. negyedév',
      'II. negyedév',
      'III. negyedév',
      'IV. negyedév',
    ],
    'AMPMS': <dynamic>[
      'de.',
      'du.',
    ],
    'DATEFORMATS': <dynamic>[
      'y. MMMM d., EEEE',
      'y. MMMM d.',
      'y. MMM d.',
      'y. MM. dd.',
    ],
    'TIMEFORMATS': <dynamic>[
      'H:mm:ss zzzz',
      'H:mm:ss z',
      'H:mm:ss',
      'H:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'hy': <String, dynamic>{
    'NAME': 'hy',
    'ERAS': <dynamic>[
      'մ.թ.ա.',
      'մ.թ.',
    ],
    'ERANAMES': <dynamic>[
      'Քրիստոսից առաջ',
      'Քրիստոսից հետո',
    ],
    'NARROWMONTHS': <dynamic>[
      'Հ',
      'Փ',
      'Մ',
      'Ա',
      'Մ',
      'Հ',
      'Հ',
      'Օ',
      'Ս',
      'Հ',
      'Ն',
      'Դ',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'Հ',
      'Փ',
      'Մ',
      'Ա',
      'Մ',
      'Հ',
      'Հ',
      'Օ',
      'Ս',
      'Հ',
      'Ն',
      'Դ',
    ],
    'MONTHS': <dynamic>[
      'հունվարի',
      'փետրվարի',
      'մարտի',
      'ապրիլի',
      'մայիսի',
      'հունիսի',
      'հուլիսի',
      'օգոստոսի',
      'սեպտեմբերի',
      'հոկտեմբերի',
      'նոյեմբերի',
      'դեկտեմբերի',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'հունվար',
      'փետրվար',
      'մարտ',
      'ապրիլ',
      'մայիս',
      'հունիս',
      'հուլիս',
      'օգոստոս',
      'սեպտեմբեր',
      'հոկտեմբեր',
      'նոյեմբեր',
      'դեկտեմբեր',
    ],
    'SHORTMONTHS': <dynamic>[
      'հնվ',
      'փտվ',
      'մրտ',
      'ապր',
      'մյս',
      'հնս',
      'հլս',
      'օգս',
      'սեպ',
      'հոկ',
      'նոյ',
      'դեկ',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'հնվ',
      'փտվ',
      'մրտ',
      'ապր',
      'մյս',
      'հնս',
      'հլս',
      'օգս',
      'սեպ',
      'հոկ',
      'նոյ',
      'դեկ',
    ],
    'WEEKDAYS': <dynamic>[
      'կիրակի',
      'երկուշաբթի',
      'երեքշաբթի',
      'չորեքշաբթի',
      'հինգշաբթի',
      'ուրբաթ',
      'շաբաթ',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'կիրակի',
      'երկուշաբթի',
      'երեքշաբթի',
      'չորեքշաբթի',
      'հինգշաբթի',
      'ուրբաթ',
      'շաբաթ',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'կիր',
      'երկ',
      'երք',
      'չրք',
      'հնգ',
      'ուր',
      'շբթ',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'կիր',
      'երկ',
      'երք',
      'չրք',
      'հնգ',
      'ուր',
      'շբթ',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'Կ',
      'Ե',
      'Ե',
      'Չ',
      'Հ',
      'Ո',
      'Շ',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'Կ',
      'Ե',
      'Ե',
      'Չ',
      'Հ',
      'Ո',
      'Շ',
    ],
    'SHORTQUARTERS': <dynamic>[
      '1-ին եռմս.',
      '2-րդ եռմս.',
      '3-րդ եռմս.',
      '4-րդ եռմս.',
    ],
    'QUARTERS': <dynamic>[
      '1-ին եռամսյակ',
      '2-րդ եռամսյակ',
      '3-րդ եռամսյակ',
      '4-րդ եռամսյակ',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'y թ. MMMM d, EEEE',
      'dd MMMM, y թ.',
      'dd MMM, y թ.',
      'dd.MM.yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      '{1}, {0}',
      '{1}, {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'id': <String, dynamic>{
    'NAME': 'id',
    'ERAS': <dynamic>[
      'SM',
      'M',
    ],
    'ERANAMES': <dynamic>[
      'Sebelum Masehi',
      'Masehi',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'Januari',
      'Februari',
      'Maret',
      'April',
      'Mei',
      'Juni',
      'Juli',
      'Agustus',
      'September',
      'Oktober',
      'November',
      'Desember',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'Januari',
      'Februari',
      'Maret',
      'April',
      'Mei',
      'Juni',
      'Juli',
      'Agustus',
      'September',
      'Oktober',
      'November',
      'Desember',
    ],
    'SHORTMONTHS': <dynamic>[
      'Jan',
      'Feb',
      'Mar',
      'Apr',
      'Mei',
      'Jun',
      'Jul',
      'Agu',
      'Sep',
      'Okt',
      'Nov',
      'Des',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'Jan',
      'Feb',
      'Mar',
      'Apr',
      'Mei',
      'Jun',
      'Jul',
      'Agu',
      'Sep',
      'Okt',
      'Nov',
      'Des',
    ],
    'WEEKDAYS': <dynamic>[
      'Minggu',
      'Senin',
      'Selasa',
      'Rabu',
      'Kamis',
      'Jumat',
      'Sabtu',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'Minggu',
      'Senin',
      'Selasa',
      'Rabu',
      'Kamis',
      'Jumat',
      'Sabtu',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'Min',
      'Sen',
      'Sel',
      'Rab',
      'Kam',
      'Jum',
      'Sab',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'Min',
      'Sen',
      'Sel',
      'Rab',
      'Kam',
      'Jum',
      'Sab',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'M',
      'S',
      'S',
      'R',
      'K',
      'J',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'M',
      'S',
      'S',
      'R',
      'K',
      'J',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      'K1',
      'K2',
      'K3',
      'K4',
    ],
    'QUARTERS': <dynamic>[
      'Kuartal ke-1',
      'Kuartal ke-2',
      'Kuartal ke-3',
      'Kuartal ke-4',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, dd MMMM y',
      'd MMMM y',
      'd MMM y',
      'dd/MM/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH.mm.ss zzzz',
      'HH.mm.ss z',
      'HH.mm.ss',
      'HH.mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'is': <String, dynamic>{
    'NAME': 'is',
    'ERAS': <dynamic>[
      'f.Kr.',
      'e.Kr.',
    ],
    'ERANAMES': <dynamic>[
      'fyrir Krist',
      'eftir Krist',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'Á',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'Á',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'janúar',
      'febrúar',
      'mars',
      'apríl',
      'maí',
      'júní',
      'júlí',
      'ágúst',
      'september',
      'október',
      'nóvember',
      'desember',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'janúar',
      'febrúar',
      'mars',
      'apríl',
      'maí',
      'júní',
      'júlí',
      'ágúst',
      'september',
      'október',
      'nóvember',
      'desember',
    ],
    'SHORTMONTHS': <dynamic>[
      'jan.',
      'feb.',
      'mar.',
      'apr.',
      'maí',
      'jún.',
      'júl.',
      'ágú.',
      'sep.',
      'okt.',
      'nóv.',
      'des.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'jan.',
      'feb.',
      'mar.',
      'apr.',
      'maí',
      'jún.',
      'júl.',
      'ágú.',
      'sep.',
      'okt.',
      'nóv.',
      'des.',
    ],
    'WEEKDAYS': <dynamic>[
      'sunnudagur',
      'mánudagur',
      'þriðjudagur',
      'miðvikudagur',
      'fimmtudagur',
      'föstudagur',
      'laugardagur',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'sunnudagur',
      'mánudagur',
      'þriðjudagur',
      'miðvikudagur',
      'fimmtudagur',
      'föstudagur',
      'laugardagur',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'sun.',
      'mán.',
      'þri.',
      'mið.',
      'fim.',
      'fös.',
      'lau.',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'sun.',
      'mán.',
      'þri.',
      'mið.',
      'fim.',
      'fös.',
      'lau.',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'Þ',
      'M',
      'F',
      'F',
      'L',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'Þ',
      'M',
      'F',
      'F',
      'L',
    ],
    'SHORTQUARTERS': <dynamic>[
      'F1',
      'F2',
      'F3',
      'F4',
    ],
    'QUARTERS': <dynamic>[
      '1. fjórðungur',
      '2. fjórðungur',
      '3. fjórðungur',
      '4. fjórðungur',
    ],
    'AMPMS': <dynamic>[
      'f.h.',
      'e.h.',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d. MMMM y',
      'd. MMMM y',
      'd. MMM y',
      'd.M.y',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      '{1} \'kl\'. {0}',
      '{1} \'kl\'. {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'it': <String, dynamic>{
    'NAME': 'it',
    'ERAS': <dynamic>[
      'a.C.',
      'd.C.',
    ],
    'ERANAMES': <dynamic>[
      'avanti Cristo',
      'dopo Cristo',
    ],
    'NARROWMONTHS': <dynamic>[
      'G',
      'F',
      'M',
      'A',
      'M',
      'G',
      'L',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'G',
      'F',
      'M',
      'A',
      'M',
      'G',
      'L',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'gennaio',
      'febbraio',
      'marzo',
      'aprile',
      'maggio',
      'giugno',
      'luglio',
      'agosto',
      'settembre',
      'ottobre',
      'novembre',
      'dicembre',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'gennaio',
      'febbraio',
      'marzo',
      'aprile',
      'maggio',
      'giugno',
      'luglio',
      'agosto',
      'settembre',
      'ottobre',
      'novembre',
      'dicembre',
    ],
    'SHORTMONTHS': <dynamic>[
      'gen',
      'feb',
      'mar',
      'apr',
      'mag',
      'giu',
      'lug',
      'ago',
      'set',
      'ott',
      'nov',
      'dic',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'gen',
      'feb',
      'mar',
      'apr',
      'mag',
      'giu',
      'lug',
      'ago',
      'set',
      'ott',
      'nov',
      'dic',
    ],
    'WEEKDAYS': <dynamic>[
      'domenica',
      'lunedì',
      'martedì',
      'mercoledì',
      'giovedì',
      'venerdì',
      'sabato',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'domenica',
      'lunedì',
      'martedì',
      'mercoledì',
      'giovedì',
      'venerdì',
      'sabato',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'dom',
      'lun',
      'mar',
      'mer',
      'gio',
      'ven',
      'sab',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'dom',
      'lun',
      'mar',
      'mer',
      'gio',
      'ven',
      'sab',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'D',
      'L',
      'M',
      'M',
      'G',
      'V',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'D',
      'L',
      'M',
      'M',
      'G',
      'V',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      'T1',
      'T2',
      'T3',
      'T4',
    ],
    'QUARTERS': <dynamic>[
      '1º trimestre',
      '2º trimestre',
      '3º trimestre',
      '4º trimestre',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE d MMMM y',
      'd MMMM y',
      'd MMM y',
      'dd/MM/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'ja': <String, dynamic>{
    'NAME': 'ja',
    'ERAS': <dynamic>[
      '紀元前',
      '西暦',
    ],
    'ERANAMES': <dynamic>[
      '紀元前',
      '西暦',
    ],
    'NARROWMONTHS': <dynamic>[
      '1',
      '2',
      '3',
      '4',
      '5',
      '6',
      '7',
      '8',
      '9',
      '10',
      '11',
      '12',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      '1',
      '2',
      '3',
      '4',
      '5',
      '6',
      '7',
      '8',
      '9',
      '10',
      '11',
      '12',
    ],
    'MONTHS': <dynamic>[
      '1月',
      '2月',
      '3月',
      '4月',
      '5月',
      '6月',
      '7月',
      '8月',
      '9月',
      '10月',
      '11月',
      '12月',
    ],
    'STANDALONEMONTHS': <dynamic>[
      '1月',
      '2月',
      '3月',
      '4月',
      '5月',
      '6月',
      '7月',
      '8月',
      '9月',
      '10月',
      '11月',
      '12月',
    ],
    'SHORTMONTHS': <dynamic>[
      '1月',
      '2月',
      '3月',
      '4月',
      '5月',
      '6月',
      '7月',
      '8月',
      '9月',
      '10月',
      '11月',
      '12月',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      '1月',
      '2月',
      '3月',
      '4月',
      '5月',
      '6月',
      '7月',
      '8月',
      '9月',
      '10月',
      '11月',
      '12月',
    ],
    'WEEKDAYS': <dynamic>[
      '日曜日',
      '月曜日',
      '火曜日',
      '水曜日',
      '木曜日',
      '金曜日',
      '土曜日',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      '日曜日',
      '月曜日',
      '火曜日',
      '水曜日',
      '木曜日',
      '金曜日',
      '土曜日',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      '日',
      '月',
      '火',
      '水',
      '木',
      '金',
      '土',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      '日',
      '月',
      '火',
      '水',
      '木',
      '金',
      '土',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      '日',
      '月',
      '火',
      '水',
      '木',
      '金',
      '土',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      '日',
      '月',
      '火',
      '水',
      '木',
      '金',
      '土',
    ],
    'SHORTQUARTERS': <dynamic>[
      'Q1',
      'Q2',
      'Q3',
      'Q4',
    ],
    'QUARTERS': <dynamic>[
      '第1四半期',
      '第2四半期',
      '第3四半期',
      '第4四半期',
    ],
    'AMPMS': <dynamic>[
      '午前',
      '午後',
    ],
    'DATEFORMATS': <dynamic>[
      'y年M月d日EEEE',
      'y年M月d日',
      'y/MM/dd',
      'y/MM/dd',
    ],
    'TIMEFORMATS': <dynamic>[
      'H時mm分ss秒 zzzz',
      'H:mm:ss z',
      'H:mm:ss',
      'H:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'ka': <String, dynamic>{
    'NAME': 'ka',
    'ERAS': <dynamic>[
      'ძვ. წ.',
      'ახ. წ.',
    ],
    'ERANAMES': <dynamic>[
      'ძველი წელთაღრიცხვით',
      'ახალი წელთაღრიცხვით',
    ],
    'NARROWMONTHS': <dynamic>[
      'ი',
      'თ',
      'მ',
      'ა',
      'მ',
      'ი',
      'ი',
      'ა',
      'ს',
      'ო',
      'ნ',
      'დ',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'ი',
      'თ',
      'მ',
      'ა',
      'მ',
      'ი',
      'ი',
      'ა',
      'ს',
      'ო',
      'ნ',
      'დ',
    ],
    'MONTHS': <dynamic>[
      'იანვარი',
      'თებერვალი',
      'მარტი',
      'აპრილი',
      'მაისი',
      'ივნისი',
      'ივლისი',
      'აგვისტო',
      'სექტემბერი',
      'ოქტომბერი',
      'ნოემბერი',
      'დეკემბერი',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'იანვარი',
      'თებერვალი',
      'მარტი',
      'აპრილი',
      'მაისი',
      'ივნისი',
      'ივლისი',
      'აგვისტო',
      'სექტემბერი',
      'ოქტომბერი',
      'ნოემბერი',
      'დეკემბერი',
    ],
    'SHORTMONTHS': <dynamic>[
      'იან',
      'თებ',
      'მარ',
      'აპრ',
      'მაი',
      'ივნ',
      'ივლ',
      'აგვ',
      'სექ',
      'ოქტ',
      'ნოე',
      'დეკ',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'იან',
      'თებ',
      'მარ',
      'აპრ',
      'მაი',
      'ივნ',
      'ივლ',
      'აგვ',
      'სექ',
      'ოქტ',
      'ნოე',
      'დეკ',
    ],
    'WEEKDAYS': <dynamic>[
      'კვირა',
      'ორშაბათი',
      'სამშაბათი',
      'ოთხშაბათი',
      'ხუთშაბათი',
      'პარასკევი',
      'შაბათი',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'კვირა',
      'ორშაბათი',
      'სამშაბათი',
      'ოთხშაბათი',
      'ხუთშაბათი',
      'პარასკევი',
      'შაბათი',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'კვი',
      'ორშ',
      'სამ',
      'ოთხ',
      'ხუთ',
      'პარ',
      'შაბ',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'კვი',
      'ორშ',
      'სამ',
      'ოთხ',
      'ხუთ',
      'პარ',
      'შაბ',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'კ',
      'ო',
      'ს',
      'ო',
      'ხ',
      'პ',
      'შ',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'კ',
      'ო',
      'ს',
      'ო',
      'ხ',
      'პ',
      'შ',
    ],
    'SHORTQUARTERS': <dynamic>[
      'I კვ.',
      'II კვ.',
      'III კვ.',
      'IV კვ.',
    ],
    'QUARTERS': <dynamic>[
      'I კვარტალი',
      'II კვარტალი',
      'III კვარტალი',
      'IV კვარტალი',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, dd MMMM, y',
      'd MMMM, y',
      'd MMM. y',
      'dd.MM.yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      '{1}, {0}',
      '{1}, {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'kk': <String, dynamic>{
    'NAME': 'kk',
    'ERAS': <dynamic>[
      'б.з.д.',
      'б.з.',
    ],
    'ERANAMES': <dynamic>[
      'Біздің заманымызға дейін',
      'біздің заманымыз',
    ],
    'NARROWMONTHS': <dynamic>[
      'Қ',
      'А',
      'Н',
      'С',
      'М',
      'М',
      'Ш',
      'Т',
      'Қ',
      'Қ',
      'Қ',
      'Ж',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'Қ',
      'А',
      'Н',
      'С',
      'М',
      'М',
      'Ш',
      'Т',
      'Қ',
      'Қ',
      'Қ',
      'Ж',
    ],
    'MONTHS': <dynamic>[
      'қаңтар',
      'ақпан',
      'наурыз',
      'сәуір',
      'мамыр',
      'маусым',
      'шілде',
      'тамыз',
      'қыркүйек',
      'қазан',
      'қараша',
      'желтоқсан',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'Қаңтар',
      'Ақпан',
      'Наурыз',
      'Сәуір',
      'Мамыр',
      'Маусым',
      'Шілде',
      'Тамыз',
      'Қыркүйек',
      'Қазан',
      'Қараша',
      'Желтоқсан',
    ],
    'SHORTMONTHS': <dynamic>[
      'қаң.',
      'ақп.',
      'нау.',
      'сәу.',
      'мам.',
      'мау.',
      'шіл.',
      'там.',
      'қыр.',
      'қаз.',
      'қар.',
      'жел.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'қаң.',
      'ақп.',
      'нау.',
      'сәу.',
      'мам.',
      'мау.',
      'шіл.',
      'там.',
      'қыр.',
      'қаз.',
      'қар.',
      'жел.',
    ],
    'WEEKDAYS': <dynamic>[
      'жексенбі',
      'дүйсенбі',
      'сейсенбі',
      'сәрсенбі',
      'бейсенбі',
      'жұма',
      'сенбі',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'жексенбі',
      'дүйсенбі',
      'сейсенбі',
      'сәрсенбі',
      'бейсенбі',
      'жұма',
      'сенбі',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'жс',
      'дс',
      'сс',
      'ср',
      'бс',
      'жм',
      'сб',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'жс',
      'дс',
      'сс',
      'ср',
      'бс',
      'жм',
      'сб',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'Ж',
      'Д',
      'С',
      'С',
      'Б',
      'Ж',
      'С',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'Ж',
      'Д',
      'С',
      'С',
      'Б',
      'Ж',
      'С',
    ],
    'SHORTQUARTERS': <dynamic>[
      'І тқс.',
      'ІІ тқс.',
      'ІІІ тқс.',
      'IV тқс.',
    ],
    'QUARTERS': <dynamic>[
      'І тоқсан',
      'ІІ тоқсан',
      'ІІІ тоқсан',
      'IV тоқсан',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'y \'ж\'. d MMMM, EEEE',
      'y \'ж\'. d MMMM',
      'y \'ж\'. dd MMM',
      'dd.MM.yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      '{1}, {0}',
      '{1}, {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'km': <String, dynamic>{
    'NAME': 'km',
    'ERAS': <dynamic>[
      'មុន គ.ស.',
      'គ.ស.',
    ],
    'ERANAMES': <dynamic>[
      'មុន​គ្រិស្តសករាជ',
      'គ្រិស្តសករាជ',
    ],
    'NARROWMONTHS': <dynamic>[
      'ម',
      'ក',
      'ម',
      'ម',
      'ឧ',
      'ម',
      'ក',
      'ស',
      'ក',
      'ត',
      'វ',
      'ធ',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'ម',
      'ក',
      'ម',
      'ម',
      'ឧ',
      'ម',
      'ក',
      'ស',
      'ក',
      'ត',
      'វ',
      'ធ',
    ],
    'MONTHS': <dynamic>[
      'មករា',
      'កុម្ភៈ',
      'មីនា',
      'មេសា',
      'ឧសភា',
      'មិថុនា',
      'កក្កដា',
      'សីហា',
      'កញ្ញា',
      'តុលា',
      'វិច្ឆិកា',
      'ធ្នូ',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'មករា',
      'កុម្ភៈ',
      'មីនា',
      'មេសា',
      'ឧសភា',
      'មិថុនា',
      'កក្កដា',
      'សីហា',
      'កញ្ញា',
      'តុលា',
      'វិច្ឆិកា',
      'ធ្នូ',
    ],
    'SHORTMONTHS': <dynamic>[
      'មករា',
      'កុម្ភៈ',
      'មីនា',
      'មេសា',
      'ឧសភា',
      'មិថុនា',
      'កក្កដា',
      'សីហា',
      'កញ្ញា',
      'តុលា',
      'វិច្ឆិកា',
      'ធ្នូ',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'មករា',
      'កុម្ភៈ',
      'មីនា',
      'មេសា',
      'ឧសភា',
      'មិថុនា',
      'កក្កដា',
      'សីហា',
      'កញ្ញា',
      'តុលា',
      'វិច្ឆិកា',
      'ធ្នូ',
    ],
    'WEEKDAYS': <dynamic>[
      'អាទិត្យ',
      'ច័ន្ទ',
      'អង្គារ',
      'ពុធ',
      'ព្រហស្បតិ៍',
      'សុក្រ',
      'សៅរ៍',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'អាទិត្យ',
      'ចន្ទ',
      'អង្គារ',
      'ពុធ',
      'ព្រហស្បតិ៍',
      'សុក្រ',
      'សៅរ៍',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'អាទិត្យ',
      'ចន្ទ',
      'អង្គារ',
      'ពុធ',
      'ព្រហ',
      'សុក្រ',
      'សៅរ៍',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'អាទិត្យ',
      'ចន្ទ',
      'អង្គារ',
      'ពុធ',
      'ព្រហ',
      'សុក្រ',
      'សៅរ៍',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'អ',
      'ច',
      'អ',
      'ព',
      'ព',
      'ស',
      'ស',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'អ',
      'ច',
      'អ',
      'ព',
      'ព',
      'ស',
      'ស',
    ],
    'SHORTQUARTERS': <dynamic>[
      'ត្រីមាសទី 1',
      'ត្រីមាសទី 2',
      'ត្រីមាសទី 3',
      'ត្រីមាសទី 4',
    ],
    'QUARTERS': <dynamic>[
      'ត្រីមាសទី 1',
      'ត្រីមាសទី 2',
      'ត្រីមាសទី 3',
      'ត្រីមាសទី 4',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE d MMMM y',
      'd MMMM y',
      'd MMM y',
      'd/M/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'h:mm:ss a zzzz',
      'h:mm:ss a z',
      'h:mm:ss a',
      'h:mm a',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} នៅ​ម៉ោង {0}',
      '{1} នៅ​ម៉ោង {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'kn': <String, dynamic>{
    'NAME': 'kn',
    'ERAS': <dynamic>[
      '\u{c95}\u{ccd}\u{cb0}\u{cbf}\u{2e}\u{caa}\u{cc2}',
      '\u{c95}\u{ccd}\u{cb0}\u{cbf}\u{2e}\u{cb6}',
    ],
    'ERANAMES': <dynamic>[
      '\u{c95}\u{ccd}\u{cb0}\u{cbf}\u{cb8}\u{ccd}\u{ca4}\u{20}\u{caa}\u{cc2}\u{cb0}\u{ccd}\u{cb5}',
      '\u{c95}\u{ccd}\u{cb0}\u{cbf}\u{cb8}\u{ccd}\u{ca4}\u{20}\u{cb6}\u{c95}',
    ],
    'NARROWMONTHS': <dynamic>[
      '\u{c9c}',
      '\u{cab}\u{cc6}',
      '\u{cae}\u{cbe}',
      '\u{c8f}',
      '\u{cae}\u{cc7}',
      '\u{c9c}\u{cc2}',
      '\u{c9c}\u{cc1}',
      '\u{c86}',
      '\u{cb8}\u{cc6}',
      '\u{c85}',
      '\u{ca8}',
      '\u{ca1}\u{cbf}',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      '\u{c9c}',
      '\u{cab}\u{cc6}',
      '\u{cae}\u{cbe}',
      '\u{c8f}',
      '\u{cae}\u{cc7}',
      '\u{c9c}\u{cc2}',
      '\u{c9c}\u{cc1}',
      '\u{c86}',
      '\u{cb8}\u{cc6}',
      '\u{c85}',
      '\u{ca8}',
      '\u{ca1}\u{cbf}',
    ],
    'MONTHS': <dynamic>[
      '\u{c9c}\u{ca8}\u{cb5}\u{cb0}\u{cbf}',
      '\u{cab}\u{cc6}\u{cac}\u{ccd}\u{cb0}\u{cb5}\u{cb0}\u{cbf}',
      '\u{cae}\u{cbe}\u{cb0}\u{ccd}\u{c9a}\u{ccd}',
      '\u{c8f}\u{caa}\u{ccd}\u{cb0}\u{cbf}\u{cb2}\u{ccd}',
      '\u{cae}\u{cc7}',
      '\u{c9c}\u{cc2}\u{ca8}\u{ccd}',
      '\u{c9c}\u{cc1}\u{cb2}\u{cc8}',
      '\u{c86}\u{c97}\u{cb8}\u{ccd}\u{c9f}\u{ccd}',
      '\u{cb8}\u{cc6}\u{caa}\u{ccd}\u{c9f}\u{cc6}\u{c82}\u{cac}\u{cb0}\u{ccd}',
      '\u{c85}\u{c95}\u{ccd}\u{c9f}\u{ccb}\u{cac}\u{cb0}\u{ccd}',
      '\u{ca8}\u{cb5}\u{cc6}\u{c82}\u{cac}\u{cb0}\u{ccd}',
      '\u{ca1}\u{cbf}\u{cb8}\u{cc6}\u{c82}\u{cac}\u{cb0}\u{ccd}',
    ],
    'STANDALONEMONTHS': <dynamic>[
      '\u{c9c}\u{ca8}\u{cb5}\u{cb0}\u{cbf}',
      '\u{cab}\u{cc6}\u{cac}\u{ccd}\u{cb0}\u{cb5}\u{cb0}\u{cbf}',
      '\u{cae}\u{cbe}\u{cb0}\u{ccd}\u{c9a}\u{ccd}',
      '\u{c8f}\u{caa}\u{ccd}\u{cb0}\u{cbf}\u{cb2}\u{ccd}',
      '\u{cae}\u{cc7}',
      '\u{c9c}\u{cc2}\u{ca8}\u{ccd}',
      '\u{c9c}\u{cc1}\u{cb2}\u{cc8}',
      '\u{c86}\u{c97}\u{cb8}\u{ccd}\u{c9f}\u{ccd}',
      '\u{cb8}\u{cc6}\u{caa}\u{ccd}\u{c9f}\u{cc6}\u{c82}\u{cac}\u{cb0}\u{ccd}',
      '\u{c85}\u{c95}\u{ccd}\u{c9f}\u{ccb}\u{cac}\u{cb0}\u{ccd}',
      '\u{ca8}\u{cb5}\u{cc6}\u{c82}\u{cac}\u{cb0}\u{ccd}',
      '\u{ca1}\u{cbf}\u{cb8}\u{cc6}\u{c82}\u{cac}\u{cb0}\u{ccd}',
    ],
    'SHORTMONTHS': <dynamic>[
      '\u{c9c}\u{ca8}\u{cb5}\u{cb0}\u{cbf}',
      '\u{cab}\u{cc6}\u{cac}\u{ccd}\u{cb0}\u{cb5}\u{cb0}\u{cbf}',
      '\u{cae}\u{cbe}\u{cb0}\u{ccd}\u{c9a}\u{ccd}',
      '\u{c8f}\u{caa}\u{ccd}\u{cb0}\u{cbf}',
      '\u{cae}\u{cc7}',
      '\u{c9c}\u{cc2}\u{ca8}\u{ccd}',
      '\u{c9c}\u{cc1}\u{cb2}\u{cc8}',
      '\u{c86}\u{c97}',
      '\u{cb8}\u{cc6}\u{caa}\u{ccd}\u{c9f}\u{cc6}\u{c82}',
      '\u{c85}\u{c95}\u{ccd}\u{c9f}\u{ccb}',
      '\u{ca8}\u{cb5}\u{cc6}\u{c82}',
      '\u{ca1}\u{cbf}\u{cb8}\u{cc6}\u{c82}',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      '\u{c9c}\u{ca8}',
      '\u{cab}\u{cc6}\u{cac}\u{ccd}\u{cb0}',
      '\u{cae}\u{cbe}\u{cb0}\u{ccd}\u{c9a}\u{ccd}',
      '\u{c8f}\u{caa}\u{ccd}\u{cb0}\u{cbf}',
      '\u{cae}\u{cc7}',
      '\u{c9c}\u{cc2}\u{ca8}\u{ccd}',
      '\u{c9c}\u{cc1}\u{cb2}\u{cc8}',
      '\u{c86}\u{c97}',
      '\u{cb8}\u{cc6}\u{caa}\u{ccd}\u{c9f}\u{cc6}\u{c82}',
      '\u{c85}\u{c95}\u{ccd}\u{c9f}\u{ccb}',
      '\u{ca8}\u{cb5}\u{cc6}\u{c82}',
      '\u{ca1}\u{cbf}\u{cb8}\u{cc6}\u{c82}',
    ],
    'WEEKDAYS': <dynamic>[
      '\u{cad}\u{cbe}\u{ca8}\u{cc1}\u{cb5}\u{cbe}\u{cb0}',
      '\u{cb8}\u{ccb}\u{cae}\u{cb5}\u{cbe}\u{cb0}',
      '\u{cae}\u{c82}\u{c97}\u{cb3}\u{cb5}\u{cbe}\u{cb0}',
      '\u{cac}\u{cc1}\u{ca7}\u{cb5}\u{cbe}\u{cb0}',
      '\u{c97}\u{cc1}\u{cb0}\u{cc1}\u{cb5}\u{cbe}\u{cb0}',
      '\u{cb6}\u{cc1}\u{c95}\u{ccd}\u{cb0}\u{cb5}\u{cbe}\u{cb0}',
      '\u{cb6}\u{ca8}\u{cbf}\u{cb5}\u{cbe}\u{cb0}',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      '\u{cad}\u{cbe}\u{ca8}\u{cc1}\u{cb5}\u{cbe}\u{cb0}',
      '\u{cb8}\u{ccb}\u{cae}\u{cb5}\u{cbe}\u{cb0}',
      '\u{cae}\u{c82}\u{c97}\u{cb3}\u{cb5}\u{cbe}\u{cb0}',
      '\u{cac}\u{cc1}\u{ca7}\u{cb5}\u{cbe}\u{cb0}',
      '\u{c97}\u{cc1}\u{cb0}\u{cc1}\u{cb5}\u{cbe}\u{cb0}',
      '\u{cb6}\u{cc1}\u{c95}\u{ccd}\u{cb0}\u{cb5}\u{cbe}\u{cb0}',
      '\u{cb6}\u{ca8}\u{cbf}\u{cb5}\u{cbe}\u{cb0}',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      '\u{cad}\u{cbe}\u{ca8}\u{cc1}',
      '\u{cb8}\u{ccb}\u{cae}',
      '\u{cae}\u{c82}\u{c97}\u{cb3}',
      '\u{cac}\u{cc1}\u{ca7}',
      '\u{c97}\u{cc1}\u{cb0}\u{cc1}',
      '\u{cb6}\u{cc1}\u{c95}\u{ccd}\u{cb0}',
      '\u{cb6}\u{ca8}\u{cbf}',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      '\u{cad}\u{cbe}\u{ca8}\u{cc1}',
      '\u{cb8}\u{ccb}\u{cae}',
      '\u{cae}\u{c82}\u{c97}\u{cb3}',
      '\u{cac}\u{cc1}\u{ca7}',
      '\u{c97}\u{cc1}\u{cb0}\u{cc1}',
      '\u{cb6}\u{cc1}\u{c95}\u{ccd}\u{cb0}',
      '\u{cb6}\u{ca8}\u{cbf}',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      '\u{cad}\u{cbe}',
      '\u{cb8}\u{ccb}',
      '\u{cae}\u{c82}',
      '\u{cac}\u{cc1}',
      '\u{c97}\u{cc1}',
      '\u{cb6}\u{cc1}',
      '\u{cb6}',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      '\u{cad}\u{cbe}',
      '\u{cb8}\u{ccb}',
      '\u{cae}\u{c82}',
      '\u{cac}\u{cc1}',
      '\u{c97}\u{cc1}',
      '\u{cb6}\u{cc1}',
      '\u{cb6}',
    ],
    'SHORTQUARTERS': <dynamic>[
      '\u{ca4}\u{ccd}\u{cb0}\u{cc8}\u{20}\u{31}',
      '\u{ca4}\u{ccd}\u{cb0}\u{cc8}\u{20}\u{32}',
      '\u{ca4}\u{ccd}\u{cb0}\u{cc8}\u{20}\u{33}',
      '\u{ca4}\u{ccd}\u{cb0}\u{cc8}\u{20}\u{34}',
    ],
    'QUARTERS': <dynamic>[
      '\u{31}\u{ca8}\u{cc7}\u{20}\u{ca4}\u{ccd}\u{cb0}\u{cc8}\u{cae}\u{cbe}\u{cb8}\u{cbf}\u{c95}',
      '\u{32}\u{ca8}\u{cc7}\u{20}\u{ca4}\u{ccd}\u{cb0}\u{cc8}\u{cae}\u{cbe}\u{cb8}\u{cbf}\u{c95}',
      '\u{33}\u{ca8}\u{cc7}\u{20}\u{ca4}\u{ccd}\u{cb0}\u{cc8}\u{cae}\u{cbe}\u{cb8}\u{cbf}\u{c95}',
      '\u{34}\u{ca8}\u{cc7}\u{20}\u{ca4}\u{ccd}\u{cb0}\u{cc8}\u{cae}\u{cbe}\u{cb8}\u{cbf}\u{c95}',
    ],
    'AMPMS': <dynamic>[
      '\u{caa}\u{cc2}\u{cb0}\u{ccd}\u{cb5}\u{cbe}\u{cb9}\u{ccd}\u{ca8}',
      '\u{c85}\u{caa}\u{cb0}\u{cbe}\u{cb9}\u{ccd}\u{ca8}',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, MMMM d, y',
      'MMMM d, y',
      'MMM d, y',
      'd/M/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'hh:mm:ss a zzzz',
      'hh:mm:ss a z',
      'hh:mm:ss a',
      'hh:mm a',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      6,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'ko': <String, dynamic>{
    'NAME': 'ko',
    'ERAS': <dynamic>[
      'BC',
      'AD',
    ],
    'ERANAMES': <dynamic>[
      '기원전',
      '서기',
    ],
    'NARROWMONTHS': <dynamic>[
      '1월',
      '2월',
      '3월',
      '4월',
      '5월',
      '6월',
      '7월',
      '8월',
      '9월',
      '10월',
      '11월',
      '12월',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      '1월',
      '2월',
      '3월',
      '4월',
      '5월',
      '6월',
      '7월',
      '8월',
      '9월',
      '10월',
      '11월',
      '12월',
    ],
    'MONTHS': <dynamic>[
      '1월',
      '2월',
      '3월',
      '4월',
      '5월',
      '6월',
      '7월',
      '8월',
      '9월',
      '10월',
      '11월',
      '12월',
    ],
    'STANDALONEMONTHS': <dynamic>[
      '1월',
      '2월',
      '3월',
      '4월',
      '5월',
      '6월',
      '7월',
      '8월',
      '9월',
      '10월',
      '11월',
      '12월',
    ],
    'SHORTMONTHS': <dynamic>[
      '1월',
      '2월',
      '3월',
      '4월',
      '5월',
      '6월',
      '7월',
      '8월',
      '9월',
      '10월',
      '11월',
      '12월',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      '1월',
      '2월',
      '3월',
      '4월',
      '5월',
      '6월',
      '7월',
      '8월',
      '9월',
      '10월',
      '11월',
      '12월',
    ],
    'WEEKDAYS': <dynamic>[
      '일요일',
      '월요일',
      '화요일',
      '수요일',
      '목요일',
      '금요일',
      '토요일',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      '일요일',
      '월요일',
      '화요일',
      '수요일',
      '목요일',
      '금요일',
      '토요일',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      '일',
      '월',
      '화',
      '수',
      '목',
      '금',
      '토',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      '일',
      '월',
      '화',
      '수',
      '목',
      '금',
      '토',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      '일',
      '월',
      '화',
      '수',
      '목',
      '금',
      '토',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      '일',
      '월',
      '화',
      '수',
      '목',
      '금',
      '토',
    ],
    'SHORTQUARTERS': <dynamic>[
      '1분기',
      '2분기',
      '3분기',
      '4분기',
    ],
    'QUARTERS': <dynamic>[
      '제 1/4분기',
      '제 2/4분기',
      '제 3/4분기',
      '제 4/4분기',
    ],
    'AMPMS': <dynamic>[
      '오전',
      '오후',
    ],
    'DATEFORMATS': <dynamic>[
      'y년 M월 d일 EEEE',
      'y년 M월 d일',
      'y. M. d.',
      'yy. M. d.',
    ],
    'TIMEFORMATS': <dynamic>[
      'a h시 m분 s초 zzzz',
      'a h시 m분 s초 z',
      'a h:mm:ss',
      'a h:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'ky': <String, dynamic>{
    'NAME': 'ky',
    'ERAS': <dynamic>[
      'б.з.ч.',
      'б.з.',
    ],
    'ERANAMES': <dynamic>[
      'биздин заманга чейин',
      'биздин заман',
    ],
    'NARROWMONTHS': <dynamic>[
      'Я',
      'Ф',
      'М',
      'А',
      'М',
      'И',
      'И',
      'А',
      'С',
      'О',
      'Н',
      'Д',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'Я',
      'Ф',
      'М',
      'А',
      'М',
      'И',
      'И',
      'А',
      'С',
      'О',
      'Н',
      'Д',
    ],
    'MONTHS': <dynamic>[
      'январь',
      'февраль',
      'март',
      'апрель',
      'май',
      'июнь',
      'июль',
      'август',
      'сентябрь',
      'октябрь',
      'ноябрь',
      'декабрь',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'Январь',
      'Февраль',
      'Март',
      'Апрель',
      'Май',
      'Июнь',
      'Июль',
      'Август',
      'Сентябрь',
      'Октябрь',
      'Ноябрь',
      'Декабрь',
    ],
    'SHORTMONTHS': <dynamic>[
      'янв.',
      'фев.',
      'мар.',
      'апр.',
      'май',
      'июн.',
      'июл.',
      'авг.',
      'сен.',
      'окт.',
      'ноя.',
      'дек.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'Янв',
      'Фев',
      'Мар',
      'Апр',
      'Май',
      'Июн',
      'Июл',
      'Авг',
      'Сен',
      'Окт',
      'Ноя',
      'Дек',
    ],
    'WEEKDAYS': <dynamic>[
      'жекшемби',
      'дүйшөмбү',
      'шейшемби',
      'шаршемби',
      'бейшемби',
      'жума',
      'ишемби',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'жекшемби',
      'дүйшөмбү',
      'шейшемби',
      'шаршемби',
      'бейшемби',
      'жума',
      'ишемби',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'жек.',
      'дүй.',
      'шейш.',
      'шарш.',
      'бейш.',
      'жума',
      'ишм.',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'жек.',
      'дүй.',
      'шейш.',
      'шарш.',
      'бейш.',
      'жума',
      'ишм.',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'Ж',
      'Д',
      'Ш',
      'Ш',
      'Б',
      'Ж',
      'И',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'Ж',
      'Д',
      'Ш',
      'Ш',
      'Б',
      'Ж',
      'И',
    ],
    'SHORTQUARTERS': <dynamic>[
      '1-чей.',
      '2-чей.',
      '3-чей.',
      '4-чей.',
    ],
    'QUARTERS': <dynamic>[
      '1-чейрек',
      '2-чейрек',
      '3-чейрек',
      '4-чейрек',
    ],
    'AMPMS': <dynamic>[
      'таңкы',
      'түштөн кийинки',
    ],
    'DATEFORMATS': <dynamic>[
      'y-\'ж\'., d-MMMM, EEEE',
      'y-\'ж\'., d-MMMM',
      'y-\'ж\'., d-MMM',
      'd/M/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'lo': <String, dynamic>{
    'NAME': 'lo',
    'ERAS': <dynamic>[
      'ກ່ອນ ຄ.ສ.',
      'ຄ.ສ.',
    ],
    'ERANAMES': <dynamic>[
      'ກ່ອນຄຣິດສັກກະລາດ',
      'ຄຣິດສັກກະລາດ',
    ],
    'NARROWMONTHS': <dynamic>[
      '1',
      '2',
      '3',
      '4',
      '5',
      '6',
      '7',
      '8',
      '9',
      '10',
      '11',
      '12',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      '1',
      '2',
      '3',
      '4',
      '5',
      '6',
      '7',
      '8',
      '9',
      '10',
      '11',
      '12',
    ],
    'MONTHS': <dynamic>[
      'ມັງກອນ',
      'ກຸມພາ',
      'ມີນາ',
      'ເມສາ',
      'ພຶດສະພາ',
      'ມິຖຸນາ',
      'ກໍລະກົດ',
      'ສິງຫາ',
      'ກັນຍາ',
      'ຕຸລາ',
      'ພະຈິກ',
      'ທັນວາ',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'ມັງກອນ',
      'ກຸມພາ',
      'ມີນາ',
      'ເມສາ',
      'ພຶດສະພາ',
      'ມິຖຸນາ',
      'ກໍລະກົດ',
      'ສິງຫາ',
      'ກັນຍາ',
      'ຕຸລາ',
      'ພະຈິກ',
      'ທັນວາ',
    ],
    'SHORTMONTHS': <dynamic>[
      'ມ.ກ.',
      'ກ.ພ.',
      'ມ.ນ.',
      'ມ.ສ.',
      'ພ.ພ.',
      'ມິ.ຖ.',
      'ກ.ລ.',
      'ສ.ຫ.',
      'ກ.ຍ.',
      'ຕ.ລ.',
      'ພ.ຈ.',
      'ທ.ວ.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'ມ.ກ.',
      'ກ.ພ.',
      'ມ.ນ.',
      'ມ.ສ.',
      'ພ.ພ.',
      'ມິ.ຖ.',
      'ກ.ລ.',
      'ສ.ຫ.',
      'ກ.ຍ.',
      'ຕ.ລ.',
      'ພ.ຈ.',
      'ທ.ວ.',
    ],
    'WEEKDAYS': <dynamic>[
      'ວັນອາທິດ',
      'ວັນຈັນ',
      'ວັນອັງຄານ',
      'ວັນພຸດ',
      'ວັນພະຫັດ',
      'ວັນສຸກ',
      'ວັນເສົາ',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'ວັນອາທິດ',
      'ວັນຈັນ',
      'ວັນອັງຄານ',
      'ວັນພຸດ',
      'ວັນພະຫັດ',
      'ວັນສຸກ',
      'ວັນເສົາ',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'ອາທິດ',
      'ຈັນ',
      'ອັງຄານ',
      'ພຸດ',
      'ພະຫັດ',
      'ສຸກ',
      'ເສົາ',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'ອາທິດ',
      'ຈັນ',
      'ອັງຄານ',
      'ພຸດ',
      'ພະຫັດ',
      'ສຸກ',
      'ເສົາ',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'ອາ',
      'ຈ',
      'ອ',
      'ພ',
      'ພຫ',
      'ສຸ',
      'ສ',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'ອາ',
      'ຈ',
      'ອ',
      'ພ',
      'ພຫ',
      'ສຸ',
      'ສ',
    ],
    'SHORTQUARTERS': <dynamic>[
      'ຕມ1',
      'ຕມ2',
      'ຕມ3',
      'ຕມ4',
    ],
    'QUARTERS': <dynamic>[
      'ໄຕຣມາດ 1',
      'ໄຕຣມາດ 2',
      'ໄຕຣມາດ 3',
      'ໄຕຣມາດ 4',
    ],
    'AMPMS': <dynamic>[
      'ກ່ອນທ່ຽງ',
      'ຫຼັງທ່ຽງ',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE ທີ d MMMM G y',
      'd MMMM y',
      'd MMM y',
      'd/M/y',
    ],
    'TIMEFORMATS': <dynamic>[
      'H ໂມງ m ນາທີ ss ວິນາທີ zzzz',
      'H ໂມງ m ນາທີ ss ວິນາທີ z',
      'H:mm:ss',
      'H:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1}, {0}',
      '{1}, {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'lt': <String, dynamic>{
    'NAME': 'lt',
    'ERAS': <dynamic>[
      'pr. Kr.',
      'po Kr.',
    ],
    'ERANAMES': <dynamic>[
      'prieš Kristų',
      'po Kristaus',
    ],
    'NARROWMONTHS': <dynamic>[
      'S',
      'V',
      'K',
      'B',
      'G',
      'B',
      'L',
      'R',
      'R',
      'S',
      'L',
      'G',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'S',
      'V',
      'K',
      'B',
      'G',
      'B',
      'L',
      'R',
      'R',
      'S',
      'L',
      'G',
    ],
    'MONTHS': <dynamic>[
      'sausio',
      'vasario',
      'kovo',
      'balandžio',
      'gegužės',
      'birželio',
      'liepos',
      'rugpjūčio',
      'rugsėjo',
      'spalio',
      'lapkričio',
      'gruodžio',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'sausis',
      'vasaris',
      'kovas',
      'balandis',
      'gegužė',
      'birželis',
      'liepa',
      'rugpjūtis',
      'rugsėjis',
      'spalis',
      'lapkritis',
      'gruodis',
    ],
    'SHORTMONTHS': <dynamic>[
      'saus.',
      'vas.',
      'kov.',
      'bal.',
      'geg.',
      'birž.',
      'liep.',
      'rugp.',
      'rugs.',
      'spal.',
      'lapkr.',
      'gruod.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'saus.',
      'vas.',
      'kov.',
      'bal.',
      'geg.',
      'birž.',
      'liep.',
      'rugp.',
      'rugs.',
      'spal.',
      'lapkr.',
      'gruod.',
    ],
    'WEEKDAYS': <dynamic>[
      'sekmadienis',
      'pirmadienis',
      'antradienis',
      'trečiadienis',
      'ketvirtadienis',
      'penktadienis',
      'šeštadienis',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'sekmadienis',
      'pirmadienis',
      'antradienis',
      'trečiadienis',
      'ketvirtadienis',
      'penktadienis',
      'šeštadienis',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'sk',
      'pr',
      'an',
      'tr',
      'kt',
      'pn',
      'št',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'sk',
      'pr',
      'an',
      'tr',
      'kt',
      'pn',
      'št',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'S',
      'P',
      'A',
      'T',
      'K',
      'P',
      'Š',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'S',
      'P',
      'A',
      'T',
      'K',
      'P',
      'Š',
    ],
    'SHORTQUARTERS': <dynamic>[
      'I k.',
      'II k.',
      'III k.',
      'IV k.',
    ],
    'QUARTERS': <dynamic>[
      'I ketvirtis',
      'II ketvirtis',
      'III ketvirtis',
      'IV ketvirtis',
    ],
    'AMPMS': <dynamic>[
      'priešpiet',
      'popiet',
    ],
    'DATEFORMATS': <dynamic>[
      'y \'m\'. MMMM d \'d\'., EEEE',
      'y \'m\'. MMMM d \'d\'.',
      'y-MM-dd',
      'y-MM-dd',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'lv': <String, dynamic>{
    'NAME': 'lv',
    'ERAS': <dynamic>[
      'p.m.ē.',
      'm.ē.',
    ],
    'ERANAMES': <dynamic>[
      'pirms mūsu ēras',
      'mūsu ērā',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'janvāris',
      'februāris',
      'marts',
      'aprīlis',
      'maijs',
      'jūnijs',
      'jūlijs',
      'augusts',
      'septembris',
      'oktobris',
      'novembris',
      'decembris',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'janvāris',
      'februāris',
      'marts',
      'aprīlis',
      'maijs',
      'jūnijs',
      'jūlijs',
      'augusts',
      'septembris',
      'oktobris',
      'novembris',
      'decembris',
    ],
    'SHORTMONTHS': <dynamic>[
      'janv.',
      'febr.',
      'marts',
      'apr.',
      'maijs',
      'jūn.',
      'jūl.',
      'aug.',
      'sept.',
      'okt.',
      'nov.',
      'dec.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'janv.',
      'febr.',
      'marts',
      'apr.',
      'maijs',
      'jūn.',
      'jūl.',
      'aug.',
      'sept.',
      'okt.',
      'nov.',
      'dec.',
    ],
    'WEEKDAYS': <dynamic>[
      'svētdiena',
      'pirmdiena',
      'otrdiena',
      'trešdiena',
      'ceturtdiena',
      'piektdiena',
      'sestdiena',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'Svētdiena',
      'Pirmdiena',
      'Otrdiena',
      'Trešdiena',
      'Ceturtdiena',
      'Piektdiena',
      'Sestdiena',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'svētd.',
      'pirmd.',
      'otrd.',
      'trešd.',
      'ceturtd.',
      'piektd.',
      'sestd.',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'Svētd.',
      'Pirmd.',
      'Otrd.',
      'Trešd.',
      'Ceturtd.',
      'Piektd.',
      'Sestd.',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'S',
      'P',
      'O',
      'T',
      'C',
      'P',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'S',
      'P',
      'O',
      'T',
      'C',
      'P',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      '1. cet.',
      '2. cet.',
      '3. cet.',
      '4. cet.',
    ],
    'QUARTERS': <dynamic>[
      '1. ceturksnis',
      '2. ceturksnis',
      '3. ceturksnis',
      '4. ceturksnis',
    ],
    'AMPMS': <dynamic>[
      'priekšpusdienā',
      'pēcpusdienā',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, y. \'gada\' d. MMMM',
      'y. \'gada\' d. MMMM',
      'y. \'gada\' d. MMM',
      'dd.MM.yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'mk': <String, dynamic>{
    'NAME': 'mk',
    'ERAS': <dynamic>[
      'пр.н.е.',
      'н.е.',
    ],
    'ERANAMES': <dynamic>[
      'пред нашата ера',
      'од нашата ера',
    ],
    'NARROWMONTHS': <dynamic>[
      'ј',
      'ф',
      'м',
      'а',
      'м',
      'ј',
      'ј',
      'а',
      'с',
      'о',
      'н',
      'д',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'ј',
      'ф',
      'м',
      'а',
      'м',
      'ј',
      'ј',
      'а',
      'с',
      'о',
      'н',
      'д',
    ],
    'MONTHS': <dynamic>[
      'јануари',
      'февруари',
      'март',
      'април',
      'мај',
      'јуни',
      'јули',
      'август',
      'септември',
      'октомври',
      'ноември',
      'декември',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'јануари',
      'февруари',
      'март',
      'април',
      'мај',
      'јуни',
      'јули',
      'август',
      'септември',
      'октомври',
      'ноември',
      'декември',
    ],
    'SHORTMONTHS': <dynamic>[
      'јан.',
      'фев.',
      'мар.',
      'апр.',
      'мај',
      'јун.',
      'јул.',
      'авг.',
      'септ.',
      'окт.',
      'ноем.',
      'дек.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'јан.',
      'фев.',
      'мар.',
      'апр.',
      'мај',
      'јун.',
      'јул.',
      'авг.',
      'септ.',
      'окт.',
      'ноем.',
      'дек.',
    ],
    'WEEKDAYS': <dynamic>[
      'недела',
      'понеделник',
      'вторник',
      'среда',
      'четврток',
      'петок',
      'сабота',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'недела',
      'понеделник',
      'вторник',
      'среда',
      'четврток',
      'петок',
      'сабота',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'нед.',
      'пон.',
      'вт.',
      'сре.',
      'чет.',
      'пет.',
      'саб.',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'нед.',
      'пон.',
      'вто.',
      'сре.',
      'чет.',
      'пет.',
      'саб.',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'н',
      'п',
      'в',
      'с',
      'ч',
      'п',
      'с',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'н',
      'п',
      'в',
      'с',
      'ч',
      'п',
      'с',
    ],
    'SHORTQUARTERS': <dynamic>[
      'јан-мар',
      'апр-јун',
      'јул-сеп',
      'окт-дек',
    ],
    'QUARTERS': <dynamic>[
      'прво тромесечје',
      'второ тромесечје',
      'трето тромесечје',
      'четврто тромесечје',
    ],
    'AMPMS': <dynamic>[
      'претпладне',
      'попладне',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, dd MMMM y',
      'dd MMMM y',
      'dd.M.y',
      'dd.M.yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'ml': <String, dynamic>{
    'NAME': 'ml',
    'ERAS': <dynamic>[
      'ക്രി.മു.',
      'എഡി',
    ],
    'ERANAMES': <dynamic>[
      'ക്രിസ്‌തുവിന് മുമ്പ്',
      'ആന്നോ ഡൊമിനി',
    ],
    'NARROWMONTHS': <dynamic>[
      'ജ',
      'ഫെ',
      'മാ',
      'ഏ',
      'മെ',
      'ജൂൺ',
      'ജൂ',
      'ഓ',
      'സെ',
      'ഒ',
      'ന',
      'ഡി',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'ജ',
      'ഫെ',
      'മാ',
      'ഏ',
      'മെ',
      'ജൂൺ',
      'ജൂ',
      'ഓ',
      'സെ',
      'ഒ',
      'ന',
      'ഡി',
    ],
    'MONTHS': <dynamic>[
      'ജനുവരി',
      'ഫെബ്രുവരി',
      'മാർച്ച്',
      'ഏപ്രിൽ',
      'മേയ്',
      'ജൂൺ',
      'ജൂലൈ',
      'ഓഗസ്റ്റ്',
      'സെപ്റ്റംബർ',
      'ഒക്‌ടോബർ',
      'നവംബർ',
      'ഡിസംബർ',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'ജനുവരി',
      'ഫെബ്രുവരി',
      'മാർച്ച്',
      'ഏപ്രിൽ',
      'മേയ്',
      'ജൂൺ',
      'ജൂലൈ',
      'ഓഗസ്റ്റ്',
      'സെപ്റ്റംബർ',
      'ഒക്‌ടോബർ',
      'നവംബർ',
      'ഡിസംബർ',
    ],
    'SHORTMONTHS': <dynamic>[
      'ജനു',
      'ഫെബ്രു',
      'മാർ',
      'ഏപ്രി',
      'മേയ്',
      'ജൂൺ',
      'ജൂലൈ',
      'ഓഗ',
      'സെപ്റ്റം',
      'ഒക്ടോ',
      'നവം',
      'ഡിസം',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'ജനു',
      'ഫെബ്രു',
      'മാർ',
      'ഏപ്രി',
      'മേയ്',
      'ജൂൺ',
      'ജൂലൈ',
      'ഓഗ',
      'സെപ്റ്റം',
      'ഒക്ടോ',
      'നവം',
      'ഡിസം',
    ],
    'WEEKDAYS': <dynamic>[
      'ഞായറാഴ്‌ച',
      'തിങ്കളാഴ്‌ച',
      'ചൊവ്വാഴ്ച',
      'ബുധനാഴ്‌ച',
      'വ്യാഴാഴ്‌ച',
      'വെള്ളിയാഴ്‌ച',
      'ശനിയാഴ്‌ച',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'ഞായറാഴ്‌ച',
      'തിങ്കളാഴ്‌ച',
      'ചൊവ്വാഴ്‌ച',
      'ബുധനാഴ്‌ച',
      'വ്യാഴാഴ്‌ച',
      'വെള്ളിയാഴ്‌ച',
      'ശനിയാഴ്‌ച',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'ഞായർ',
      'തിങ്കൾ',
      'ചൊവ്വ',
      'ബുധൻ',
      'വ്യാഴം',
      'വെള്ളി',
      'ശനി',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'ഞായർ',
      'തിങ്കൾ',
      'ചൊവ്വ',
      'ബുധൻ',
      'വ്യാഴം',
      'വെള്ളി',
      'ശനി',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'ഞ',
      'തി',
      'ചൊ',
      'ബു',
      'വ്യാ',
      'വെ',
      'ശ',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'ഞാ',
      'തി',
      'ചൊ',
      'ബു',
      'വ്യാ',
      'വെ',
      'ശ',
    ],
    'SHORTQUARTERS': <dynamic>[
      'ഒന്നാം പാദം',
      'രണ്ടാം പാദം',
      'മൂന്നാം പാദം',
      'നാലാം പാദം',
    ],
    'QUARTERS': <dynamic>[
      'ഒന്നാം പാദം',
      'രണ്ടാം പാദം',
      'മൂന്നാം പാദം',
      'നാലാം പാദം',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'y, MMMM d, EEEE',
      'y, MMMM d',
      'y, MMM d',
      'd/M/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'h:mm:ss a zzzz',
      'h:mm:ss a z',
      'h:mm:ss a',
      'h:mm a',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      6,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'mn': <String, dynamic>{
    'NAME': 'mn',
    'ERAS': <dynamic>[
      'МЭӨ',
      'МЭ',
    ],
    'ERANAMES': <dynamic>[
      'манай эриний өмнөх',
      'манай эриний',
    ],
    'NARROWMONTHS': <dynamic>[
      'I',
      'II',
      'III',
      'IV',
      'V',
      'VI',
      'VII',
      'VIII',
      'IX',
      'X',
      'XI',
      'XII',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'I',
      'II',
      'III',
      'IV',
      'V',
      'VI',
      'VII',
      'VIII',
      'IX',
      'X',
      'XI',
      'XII',
    ],
    'MONTHS': <dynamic>[
      'нэгдүгээр сар',
      'хоёрдугаар сар',
      'гуравдугаар сар',
      'дөрөвдүгээр сар',
      'тавдугаар сар',
      'зургаадугаар сар',
      'долоодугаар сар',
      'наймдугаар сар',
      'есдүгээр сар',
      'аравдугаар сар',
      'арван нэгдүгээр сар',
      'арван хоёрдугаар сар',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'Нэгдүгээр сар',
      'Хоёрдугаар сар',
      'Гуравдугаар сар',
      'Дөрөвдүгээр сар',
      'Тавдугаар сар',
      'Зургаадугаар сар',
      'Долоодугаар сар',
      'Наймдугаар сар',
      'Есдүгээр сар',
      'Аравдугаар сар',
      'Арван нэгдүгээр сар',
      'Арван хоёрдугаар сар',
    ],
    'SHORTMONTHS': <dynamic>[
      '1-р сар',
      '2-р сар',
      '3-р сар',
      '4-р сар',
      '5-р сар',
      '6-р сар',
      '7-р сар',
      '8-р сар',
      '9-р сар',
      '10-р сар',
      '11-р сар',
      '12-р сар',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      '1-р сар',
      '2-р сар',
      '3-р сар',
      '4-р сар',
      '5-р сар',
      '6-р сар',
      '7-р сар',
      '8-р сар',
      '9-р сар',
      '10-р сар',
      '11-р сар',
      '12-р сар',
    ],
    'WEEKDAYS': <dynamic>[
      'ням',
      'даваа',
      'мягмар',
      'лхагва',
      'пүрэв',
      'баасан',
      'бямба',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'Ням',
      'Даваа',
      'Мягмар',
      'Лхагва',
      'Пүрэв',
      'Баасан',
      'Бямба',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'Ня',
      'Да',
      'Мя',
      'Лх',
      'Пү',
      'Ба',
      'Бя',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'Ня',
      'Да',
      'Мя',
      'Лх',
      'Пү',
      'Ба',
      'Бя',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'Ня',
      'Да',
      'Мя',
      'Лх',
      'Пү',
      'Ба',
      'Бя',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'Ня',
      'Да',
      'Мя',
      'Лх',
      'Пү',
      'Ба',
      'Бя',
    ],
    'SHORTQUARTERS': <dynamic>[
      'I улирал',
      'II улирал',
      'III улирал',
      'IV улирал',
    ],
    'QUARTERS': <dynamic>[
      '1-р улирал',
      '2-р улирал',
      '3-р улирал',
      '4-р улирал',
    ],
    'AMPMS': <dynamic>[
      'ү.ө.',
      'ү.х.',
    ],
    'DATEFORMATS': <dynamic>[
      'y.MM.dd, EEEE',
      'y.MM.dd',
      'y \'оны\' MMM\'ын\' d',
      'y.MM.dd',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss (zzzz)',
      'HH:mm:ss (z)',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'mr': <String, dynamic>{
    'NAME': 'mr',
    'ERAS': <dynamic>[
      'इ. स. पू.',
      'इ. स.',
    ],
    'ERANAMES': <dynamic>[
      'ईसवीसनपूर्व',
      'ईसवीसन',
    ],
    'NARROWMONTHS': <dynamic>[
      'जा',
      'फे',
      'मा',
      'ए',
      'मे',
      'जू',
      'जु',
      'ऑ',
      'स',
      'ऑ',
      'नो',
      'डि',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'जा',
      'फे',
      'मा',
      'ए',
      'मे',
      'जू',
      'जु',
      'ऑ',
      'स',
      'ऑ',
      'नो',
      'डि',
    ],
    'MONTHS': <dynamic>[
      'जानेवारी',
      'फेब्रुवारी',
      'मार्च',
      'एप्रिल',
      'मे',
      'जून',
      'जुलै',
      'ऑगस्ट',
      'सप्टेंबर',
      'ऑक्टोबर',
      'नोव्हेंबर',
      'डिसेंबर',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'जानेवारी',
      'फेब्रुवारी',
      'मार्च',
      'एप्रिल',
      'मे',
      'जून',
      'जुलै',
      'ऑगस्ट',
      'सप्टेंबर',
      'ऑक्टोबर',
      'नोव्हेंबर',
      'डिसेंबर',
    ],
    'SHORTMONTHS': <dynamic>[
      'जाने',
      'फेब्रु',
      'मार्च',
      'एप्रि',
      'मे',
      'जून',
      'जुलै',
      'ऑग',
      'सप्टें',
      'ऑक्टो',
      'नोव्हें',
      'डिसें',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'जाने',
      'फेब्रु',
      'मार्च',
      'एप्रि',
      'मे',
      'जून',
      'जुलै',
      'ऑग',
      'सप्टें',
      'ऑक्टो',
      'नोव्हें',
      'डिसें',
    ],
    'WEEKDAYS': <dynamic>[
      'रविवार',
      'सोमवार',
      'मंगळवार',
      'बुधवार',
      'गुरुवार',
      'शुक्रवार',
      'शनिवार',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'रविवार',
      'सोमवार',
      'मंगळवार',
      'बुधवार',
      'गुरुवार',
      'शुक्रवार',
      'शनिवार',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'रवि',
      'सोम',
      'मंगळ',
      'बुध',
      'गुरु',
      'शुक्र',
      'शनि',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'रवि',
      'सोम',
      'मंगळ',
      'बुध',
      'गुरु',
      'शुक्र',
      'शनि',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'र',
      'सो',
      'मं',
      'बु',
      'गु',
      'शु',
      'श',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'र',
      'सो',
      'मं',
      'बु',
      'गु',
      'शु',
      'श',
    ],
    'SHORTQUARTERS': <dynamic>[
      'ति१',
      'ति२',
      'ति३',
      'ति४',
    ],
    'QUARTERS': <dynamic>[
      'प्रथम तिमाही',
      'द्वितीय तिमाही',
      'तृतीय तिमाही',
      'चतुर्थ तिमाही',
    ],
    'AMPMS': <dynamic>[
      'म.पू.',
      'म.उ.',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d MMMM, y',
      'd MMMM, y',
      'd MMM, y',
      'd/M/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'h:mm:ss a zzzz',
      'h:mm:ss a z',
      'h:mm:ss a',
      'h:mm a',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      6,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} रोजी {0}',
      '{1} रोजी {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
    'ZERODIGIT': '०',
  },
  'ms': <String, dynamic>{
    'NAME': 'ms',
    'ERAS': <dynamic>[
      'S.M.',
      'TM',
    ],
    'ERANAMES': <dynamic>[
      'S.M.',
      'TM',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'O',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'O',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'Januari',
      'Februari',
      'Mac',
      'April',
      'Mei',
      'Jun',
      'Julai',
      'Ogos',
      'September',
      'Oktober',
      'November',
      'Disember',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'Januari',
      'Februari',
      'Mac',
      'April',
      'Mei',
      'Jun',
      'Julai',
      'Ogos',
      'September',
      'Oktober',
      'November',
      'Disember',
    ],
    'SHORTMONTHS': <dynamic>[
      'Jan',
      'Feb',
      'Mac',
      'Apr',
      'Mei',
      'Jun',
      'Jul',
      'Ogo',
      'Sep',
      'Okt',
      'Nov',
      'Dis',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'Jan',
      'Feb',
      'Mac',
      'Apr',
      'Mei',
      'Jun',
      'Jul',
      'Ogo',
      'Sep',
      'Okt',
      'Nov',
      'Dis',
    ],
    'WEEKDAYS': <dynamic>[
      'Ahad',
      'Isnin',
      'Selasa',
      'Rabu',
      'Khamis',
      'Jumaat',
      'Sabtu',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'Ahad',
      'Isnin',
      'Selasa',
      'Rabu',
      'Khamis',
      'Jumaat',
      'Sabtu',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'Ahd',
      'Isn',
      'Sel',
      'Rab',
      'Kha',
      'Jum',
      'Sab',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'Ahd',
      'Isn',
      'Sel',
      'Rab',
      'Kha',
      'Jum',
      'Sab',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'A',
      'I',
      'S',
      'R',
      'K',
      'J',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'A',
      'I',
      'S',
      'R',
      'K',
      'J',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      'S1',
      'S2',
      'S3',
      'S4',
    ],
    'QUARTERS': <dynamic>[
      'Suku pertama',
      'Suku Ke-2',
      'Suku Ke-3',
      'Suku Ke-4',
    ],
    'AMPMS': <dynamic>[
      'PG',
      'PTG',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d MMMM y',
      'd MMMM y',
      'd MMM y',
      'd/MM/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'h:mm:ss a zzzz',
      'h:mm:ss a z',
      'h:mm:ss a',
      'h:mm a',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'my': <String, dynamic>{
    'NAME': 'my',
    'ERAS': <dynamic>[
      'ဘီစီ',
      'အဒေီ',
    ],
    'ERANAMES': <dynamic>[
      'ခရစ်တော် မပေါ်မီနှစ်',
      'ခရစ်နှစ်',
    ],
    'NARROWMONTHS': <dynamic>[
      'ဇ',
      'ဖ',
      'မ',
      'ဧ',
      'မ',
      'ဇ',
      'ဇ',
      'ဩ',
      'စ',
      'အ',
      'န',
      'ဒ',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'ဇ',
      'ဖ',
      'မ',
      'ဧ',
      'မ',
      'ဇ',
      'ဇ',
      'ဩ',
      'စ',
      'အ',
      'န',
      'ဒ',
    ],
    'MONTHS': <dynamic>[
      'ဇန်နဝါရီ',
      'ဖေဖော်ဝါရီ',
      'မတ်',
      'ဧပြီ',
      'မေ',
      'ဇွန်',
      'ဇူလိုင်',
      'ဩဂုတ်',
      'စက်တင်ဘာ',
      'အောက်တိုဘာ',
      'နိုဝင်ဘာ',
      'ဒီဇင်ဘာ',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'ဇန်နဝါရီ',
      'ဖေဖော်ဝါရီ',
      'မတ်',
      'ဧပြီ',
      'မေ',
      'ဇွန်',
      'ဇူလိုင်',
      'ဩဂုတ်',
      'စက်တင်ဘာ',
      'အောက်တိုဘာ',
      'နိုဝင်ဘာ',
      'ဒီဇင်ဘာ',
    ],
    'SHORTMONTHS': <dynamic>[
      'ဇန်',
      'ဖေ',
      'မတ်',
      'ဧ',
      'မေ',
      'ဇွန်',
      'ဇူ',
      'ဩ',
      'စက်',
      'အောက်',
      'နို',
      'ဒီ',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'ဇန်',
      'ဖေ',
      'မတ်',
      'ဧ',
      'မေ',
      'ဇွန်',
      'ဇူ',
      'ဩ',
      'စက်',
      'အောက်',
      'နို',
      'ဒီ',
    ],
    'WEEKDAYS': <dynamic>[
      'တနင်္ဂနွေ',
      'တနင်္လာ',
      'အင်္ဂါ',
      'ဗုဒ္ဓဟူး',
      'ကြာသပတေး',
      'သောကြာ',
      'စနေ',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'တနင်္ဂနွေ',
      'တနင်္လာ',
      'အင်္ဂါ',
      'ဗုဒ္ဓဟူး',
      'ကြာသပတေး',
      'သောကြာ',
      'စနေ',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'တနင်္ဂနွေ',
      'တနင်္လာ',
      'အင်္ဂါ',
      'ဗုဒ္ဓဟူး',
      'ကြာသပတေး',
      'သောကြာ',
      'စနေ',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'တနင်္ဂနွေ',
      'တနင်္လာ',
      'အင်္ဂါ',
      'ဗုဒ္ဓဟူး',
      'ကြာသပတေး',
      'သောကြာ',
      'စနေ',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'တ',
      'တ',
      'အ',
      'ဗ',
      'က',
      'သ',
      'စ',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'တ',
      'တ',
      'အ',
      'ဗ',
      'က',
      'သ',
      'စ',
    ],
    'SHORTQUARTERS': <dynamic>[
      'ပထမ သုံးလပတ်',
      'ဒုတိယ သုံးလပတ်',
      'တတိယ သုံးလပတ်',
      'စတုတ္ထ သုံးလပတ်',
    ],
    'QUARTERS': <dynamic>[
      'ပထမ သုံးလပတ်',
      'ဒုတိယ သုံးလပတ်',
      'တတိယ သုံးလပတ်',
      'စတုတ္ထ သုံးလပတ်',
    ],
    'AMPMS': <dynamic>[
      'နံနက်',
      'ညနေ',
    ],
    'DATEFORMATS': <dynamic>[
      'y၊ MMMM d၊ EEEE',
      'y၊ d MMMM',
      'y၊ MMM d',
      'dd-MM-yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'zzzz HH:mm:ss',
      'z HH:mm:ss',
      'B HH:mm:ss',
      'B H:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
    'ZERODIGIT': '၀',
  },
  'nb': <String, dynamic>{
    'NAME': 'nb',
    'ERAS': <dynamic>[
      'f.Kr.',
      'e.Kr.',
    ],
    'ERANAMES': <dynamic>[
      'før Kristus',
      'etter Kristus',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'januar',
      'februar',
      'mars',
      'april',
      'mai',
      'juni',
      'juli',
      'august',
      'september',
      'oktober',
      'november',
      'desember',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'januar',
      'februar',
      'mars',
      'april',
      'mai',
      'juni',
      'juli',
      'august',
      'september',
      'oktober',
      'november',
      'desember',
    ],
    'SHORTMONTHS': <dynamic>[
      'jan.',
      'feb.',
      'mar.',
      'apr.',
      'mai',
      'jun.',
      'jul.',
      'aug.',
      'sep.',
      'okt.',
      'nov.',
      'des.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'jan',
      'feb',
      'mar',
      'apr',
      'mai',
      'jun',
      'jul',
      'aug',
      'sep',
      'okt',
      'nov',
      'des',
    ],
    'WEEKDAYS': <dynamic>[
      'søndag',
      'mandag',
      'tirsdag',
      'onsdag',
      'torsdag',
      'fredag',
      'lørdag',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'søndag',
      'mandag',
      'tirsdag',
      'onsdag',
      'torsdag',
      'fredag',
      'lørdag',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'søn.',
      'man.',
      'tir.',
      'ons.',
      'tor.',
      'fre.',
      'lør.',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'søn.',
      'man.',
      'tir.',
      'ons.',
      'tor.',
      'fre.',
      'lør.',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'O',
      'T',
      'F',
      'L',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'O',
      'T',
      'F',
      'L',
    ],
    'SHORTQUARTERS': <dynamic>[
      'K1',
      'K2',
      'K3',
      'K4',
    ],
    'QUARTERS': <dynamic>[
      '1. kvartal',
      '2. kvartal',
      '3. kvartal',
      '4. kvartal',
    ],
    'AMPMS': <dynamic>[
      'a.m.',
      'p.m.',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE d. MMMM y',
      'd. MMMM y',
      'd. MMM y',
      'dd.MM.y',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} \'kl\'. {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'ne': <String, dynamic>{
    'NAME': 'ne',
    'ERAS': <dynamic>[
      'ईसा पूर्व',
      'सन्',
    ],
    'ERANAMES': <dynamic>[
      'ईसा पूर्व',
      'सन्',
    ],
    'NARROWMONTHS': <dynamic>[
      'जन',
      'फेब',
      'मार्च',
      'अप्र',
      'मे',
      'जुन',
      'जुल',
      'अग',
      'सेप',
      'अक्टो',
      'नोभे',
      'डिसे',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'जन',
      'फेेब',
      'मार्च',
      'अप्र',
      'मे',
      'जुन',
      'जुल',
      'अग',
      'सेप',
      'अक्टो',
      'नोभे',
      'डिसे',
    ],
    'MONTHS': <dynamic>[
      'जनवरी',
      'फेब्रुअरी',
      'मार्च',
      'अप्रिल',
      'मे',
      'जुन',
      'जुलाई',
      'अगस्ट',
      'सेप्टेम्बर',
      'अक्टोबर',
      'नोभेम्बर',
      'डिसेम्बर',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'जनवरी',
      'फेब्रुअरी',
      'मार्च',
      'अप्रिल',
      'मे',
      'जुन',
      'जुलाई',
      'अगस्ट',
      'सेप्टेम्बर',
      'अक्टोबर',
      'नोभेम्बर',
      'डिसेम्बर',
    ],
    'SHORTMONTHS': <dynamic>[
      'जनवरी',
      'फेब्रुअरी',
      'मार्च',
      'अप्रिल',
      'मे',
      'जुन',
      'जुलाई',
      'अगस्ट',
      'सेप्टेम्बर',
      'अक्टोबर',
      'नोभेम्बर',
      'डिसेम्बर',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'जनवरी',
      'फेब्रुअरी',
      'मार्च',
      'अप्रिल',
      'मे',
      'जुन',
      'जुलाई',
      'अगस्ट',
      'सेप्टेम्बर',
      'अक्टोबर',
      'नोभेम्बर',
      'डिसेम्बर',
    ],
    'WEEKDAYS': <dynamic>[
      'आइतबार',
      'सोमबार',
      'मङ्गलबार',
      'बुधबार',
      'बिहिबार',
      'शुक्रबार',
      'शनिबार',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'आइतबार',
      'सोमबार',
      'मङ्गलबार',
      'बुधबार',
      'बिहिबार',
      'शुक्रबार',
      'शनिबार',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'आइत',
      'सोम',
      'मङ्गल',
      'बुध',
      'बिहि',
      'शुक्र',
      'शनि',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'आइत',
      'सोम',
      'मङ्गल',
      'बुध',
      'बिहि',
      'शुक्र',
      'शनि',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'आ',
      'सो',
      'म',
      'बु',
      'बि',
      'शु',
      'श',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'आ',
      'सो',
      'म',
      'बु',
      'बि',
      'शु',
      'श',
    ],
    'SHORTQUARTERS': <dynamic>[
      'पहिलो सत्र',
      'दोस्रो सत्र',
      'तेस्रो सत्र',
      'चौथो सत्र',
    ],
    'QUARTERS': <dynamic>[
      'पहिलो सत्र',
      'दोस्रो सत्र',
      'तेस्रो सत्र',
      'चौथो सत्र',
    ],
    'AMPMS': <dynamic>[
      'पूर्वाह्न',
      'अपराह्न',
    ],
    'DATEFORMATS': <dynamic>[
      'y MMMM d, EEEE',
      'y MMMM d',
      'y MMM d',
      'yy/M/d',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
    'ZERODIGIT': '०',
  },
  'nl': <String, dynamic>{
    'NAME': 'nl',
    'ERAS': <dynamic>[
      'v.Chr.',
      'n.Chr.',
    ],
    'ERANAMES': <dynamic>[
      'voor Christus',
      'na Christus',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'januari',
      'februari',
      'maart',
      'april',
      'mei',
      'juni',
      'juli',
      'augustus',
      'september',
      'oktober',
      'november',
      'december',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'januari',
      'februari',
      'maart',
      'april',
      'mei',
      'juni',
      'juli',
      'augustus',
      'september',
      'oktober',
      'november',
      'december',
    ],
    'SHORTMONTHS': <dynamic>[
      'jan.',
      'feb.',
      'mrt.',
      'apr.',
      'mei',
      'jun.',
      'jul.',
      'aug.',
      'sep.',
      'okt.',
      'nov.',
      'dec.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'jan.',
      'feb.',
      'mrt.',
      'apr.',
      'mei',
      'jun.',
      'jul.',
      'aug.',
      'sep.',
      'okt.',
      'nov.',
      'dec.',
    ],
    'WEEKDAYS': <dynamic>[
      'zondag',
      'maandag',
      'dinsdag',
      'woensdag',
      'donderdag',
      'vrijdag',
      'zaterdag',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'zondag',
      'maandag',
      'dinsdag',
      'woensdag',
      'donderdag',
      'vrijdag',
      'zaterdag',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'zo',
      'ma',
      'di',
      'wo',
      'do',
      'vr',
      'za',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'zo',
      'ma',
      'di',
      'wo',
      'do',
      'vr',
      'za',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'Z',
      'M',
      'D',
      'W',
      'D',
      'V',
      'Z',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'Z',
      'M',
      'D',
      'W',
      'D',
      'V',
      'Z',
    ],
    'SHORTQUARTERS': <dynamic>[
      'K1',
      'K2',
      'K3',
      'K4',
    ],
    'QUARTERS': <dynamic>[
      '1e kwartaal',
      '2e kwartaal',
      '3e kwartaal',
      '4e kwartaal',
    ],
    'AMPMS': <dynamic>[
      'a.m.',
      'p.m.',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE d MMMM y',
      'd MMMM y',
      'd MMM y',
      'dd-MM-y',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      '{1} \'om\' {0}',
      '{1} \'om\' {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'no': <String, dynamic>{
    'NAME': 'no',
    'ERAS': <dynamic>[
      'f.Kr.',
      'e.Kr.',
    ],
    'ERANAMES': <dynamic>[
      'før Kristus',
      'etter Kristus',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'januar',
      'februar',
      'mars',
      'april',
      'mai',
      'juni',
      'juli',
      'august',
      'september',
      'oktober',
      'november',
      'desember',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'januar',
      'februar',
      'mars',
      'april',
      'mai',
      'juni',
      'juli',
      'august',
      'september',
      'oktober',
      'november',
      'desember',
    ],
    'SHORTMONTHS': <dynamic>[
      'jan.',
      'feb.',
      'mar.',
      'apr.',
      'mai',
      'jun.',
      'jul.',
      'aug.',
      'sep.',
      'okt.',
      'nov.',
      'des.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'jan',
      'feb',
      'mar',
      'apr',
      'mai',
      'jun',
      'jul',
      'aug',
      'sep',
      'okt',
      'nov',
      'des',
    ],
    'WEEKDAYS': <dynamic>[
      'søndag',
      'mandag',
      'tirsdag',
      'onsdag',
      'torsdag',
      'fredag',
      'lørdag',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'søndag',
      'mandag',
      'tirsdag',
      'onsdag',
      'torsdag',
      'fredag',
      'lørdag',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'søn.',
      'man.',
      'tir.',
      'ons.',
      'tor.',
      'fre.',
      'lør.',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'søn.',
      'man.',
      'tir.',
      'ons.',
      'tor.',
      'fre.',
      'lør.',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'O',
      'T',
      'F',
      'L',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'O',
      'T',
      'F',
      'L',
    ],
    'SHORTQUARTERS': <dynamic>[
      'K1',
      'K2',
      'K3',
      'K4',
    ],
    'QUARTERS': <dynamic>[
      '1. kvartal',
      '2. kvartal',
      '3. kvartal',
      '4. kvartal',
    ],
    'AMPMS': <dynamic>[
      'a.m.',
      'p.m.',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE d. MMMM y',
      'd. MMMM y',
      'd. MMM y',
      'dd.MM.y',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} \'kl\'. {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'or': <String, dynamic>{
    'NAME': 'or',
    'ERAS': <dynamic>[
      'BC',
      'AD',
    ],
    'ERANAMES': <dynamic>[
      'ଖ୍ରୀଷ୍ଟପୂର୍ବ',
      'ଖ୍ରୀଷ୍ଟାବ୍ଦ',
    ],
    'NARROWMONTHS': <dynamic>[
      'ଜା',
      'ଫେ',
      'ମା',
      'ଅ',
      'ମଇ',
      'ଜୁ',
      'ଜୁ',
      'ଅ',
      'ସେ',
      'ଅ',
      'ନ',
      'ଡି',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'ଜା',
      'ଫେ',
      'ମା',
      'ଅ',
      'ମଇ',
      'ଜୁ',
      'ଜୁ',
      'ଅ',
      'ସେ',
      'ଅ',
      'ନ',
      'ଡି',
    ],
    'MONTHS': <dynamic>[
      'ଜାନୁଆରୀ',
      'ଫେବୃଆରୀ',
      'ମାର୍ଚ୍ଚ',
      'ଅପ୍ରେଲ',
      'ମଇ',
      'ଜୁନ',
      'ଜୁଲାଇ',
      'ଅଗଷ୍ଟ',
      'ସେପ୍ଟେମ୍ବର',
      'ଅକ୍ଟୋବର',
      'ନଭେମ୍ବର',
      'ଡିସେମ୍ବର',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'ଜାନୁଆରୀ',
      'ଫେବୃଆରୀ',
      'ମାର୍ଚ୍ଚ',
      'ଅପ୍ରେଲ',
      'ମଇ',
      'ଜୁନ',
      'ଜୁଲାଇ',
      'ଅଗଷ୍ଟ',
      'ସେପ୍ଟେମ୍ବର',
      'ଅକ୍ଟୋବର',
      'ନଭେମ୍ବର',
      'ଡିସେମ୍ବର',
    ],
    'SHORTMONTHS': <dynamic>[
      'ଜାନୁଆରୀ',
      'ଫେବୃଆରୀ',
      'ମାର୍ଚ୍ଚ',
      'ଅପ୍ରେଲ',
      'ମଇ',
      'ଜୁନ',
      'ଜୁଲାଇ',
      'ଅଗଷ୍ଟ',
      'ସେପ୍ଟେମ୍ବର',
      'ଅକ୍ଟୋବର',
      'ନଭେମ୍ବର',
      'ଡିସେମ୍ବର',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'ଜାନୁଆରୀ',
      'ଫେବୃଆରୀ',
      'ମାର୍ଚ୍ଚ',
      'ଅପ୍ରେଲ',
      'ମଇ',
      'ଜୁନ',
      'ଜୁଲାଇ',
      'ଅଗଷ୍ଟ',
      'ସେପ୍ଟେମ୍ବର',
      'ଅକ୍ଟୋବର',
      'ନଭେମ୍ବର',
      'ଡିସେମ୍ବର',
    ],
    'WEEKDAYS': <dynamic>[
      'ରବିବାର',
      'ସୋମବାର',
      'ମଙ୍ଗଳବାର',
      'ବୁଧବାର',
      'ଗୁରୁବାର',
      'ଶୁକ୍ରବାର',
      'ଶନିବାର',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'ରବିବାର',
      'ସୋମବାର',
      'ମଙ୍ଗଳବାର',
      'ବୁଧବାର',
      'ଗୁରୁବାର',
      'ଶୁକ୍ରବାର',
      'ଶନିବାର',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'ରବି',
      'ସୋମ',
      'ମଙ୍ଗଳ',
      'ବୁଧ',
      'ଗୁରୁ',
      'ଶୁକ୍ର',
      'ଶନି',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'ରବି',
      'ସୋମ',
      'ମଙ୍ଗଳ',
      'ବୁଧ',
      'ଗୁରୁ',
      'ଶୁକ୍ର',
      'ଶନି',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'ର',
      'ସୋ',
      'ମ',
      'ବୁ',
      'ଗୁ',
      'ଶୁ',
      'ଶ',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'ର',
      'ସୋ',
      'ମ',
      'ବୁ',
      'ଗୁ',
      'ଶୁ',
      'ଶ',
    ],
    'SHORTQUARTERS': <dynamic>[
      '1ମ ତ୍ରୟମାସ',
      '2ୟ ତ୍ରୟମାସ',
      '3ୟ ତ୍ରୟମାସ',
      '4ର୍ଥ ତ୍ରୟମାସ',
    ],
    'QUARTERS': <dynamic>[
      '1ମ ତ୍ରୟମାସ',
      '2ୟ ତ୍ରୟମାସ',
      '3ୟ ତ୍ରୟମାସ',
      '4ର୍ଥ ତ୍ରୟମାସ',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, MMMM d, y',
      'MMMM d, y',
      'MMM d, y',
      'M/d/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'h:mm:ss a zzzz',
      'h:mm:ss a z',
      'h:mm:ss a',
      'h:mm a',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      6,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{0} ଠାରେ {1}',
      '{0} ଠାରେ {1}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'pa': <String, dynamic>{
    'NAME': 'pa',
    'ERAS': <dynamic>[
      'ਈ. ਪੂ.',
      'ਸੰਨ',
    ],
    'ERANAMES': <dynamic>[
      'ਈਸਵੀ ਪੂਰਵ',
      'ਈਸਵੀ ਸੰਨ',
    ],
    'NARROWMONTHS': <dynamic>[
      'ਜ',
      'ਫ਼',
      'ਮਾ',
      'ਅ',
      'ਮ',
      'ਜੂ',
      'ਜੁ',
      'ਅ',
      'ਸ',
      'ਅ',
      'ਨ',
      'ਦ',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'ਜ',
      'ਫ਼',
      'ਮਾ',
      'ਅ',
      'ਮ',
      'ਜੂ',
      'ਜੁ',
      'ਅ',
      'ਸ',
      'ਅ',
      'ਨ',
      'ਦ',
    ],
    'MONTHS': <dynamic>[
      'ਜਨਵਰੀ',
      'ਫ਼ਰਵਰੀ',
      'ਮਾਰਚ',
      'ਅਪ੍ਰੈਲ',
      'ਮਈ',
      'ਜੂਨ',
      'ਜੁਲਾਈ',
      'ਅਗਸਤ',
      'ਸਤੰਬਰ',
      'ਅਕਤੂਬਰ',
      'ਨਵੰਬਰ',
      'ਦਸੰਬਰ',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'ਜਨਵਰੀ',
      'ਫ਼ਰਵਰੀ',
      'ਮਾਰਚ',
      'ਅਪ੍ਰੈਲ',
      'ਮਈ',
      'ਜੂਨ',
      'ਜੁਲਾਈ',
      'ਅਗਸਤ',
      'ਸਤੰਬਰ',
      'ਅਕਤੂਬਰ',
      'ਨਵੰਬਰ',
      'ਦਸੰਬਰ',
    ],
    'SHORTMONTHS': <dynamic>[
      'ਜਨ',
      'ਫ਼ਰ',
      'ਮਾਰਚ',
      'ਅਪ੍ਰੈ',
      'ਮਈ',
      'ਜੂਨ',
      'ਜੁਲਾ',
      'ਅਗ',
      'ਸਤੰ',
      'ਅਕਤੂ',
      'ਨਵੰ',
      'ਦਸੰ',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'ਜਨ',
      'ਫ਼ਰ',
      'ਮਾਰਚ',
      'ਅਪ੍ਰੈ',
      'ਮਈ',
      'ਜੂਨ',
      'ਜੁਲਾ',
      'ਅਗ',
      'ਸਤੰ',
      'ਅਕਤੂ',
      'ਨਵੰ',
      'ਦਸੰ',
    ],
    'WEEKDAYS': <dynamic>[
      'ਐਤਵਾਰ',
      'ਸੋਮਵਾਰ',
      'ਮੰਗਲਵਾਰ',
      'ਬੁੱਧਵਾਰ',
      'ਵੀਰਵਾਰ',
      'ਸ਼ੁੱਕਰਵਾਰ',
      'ਸ਼ਨਿੱਚਰਵਾਰ',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'ਐਤਵਾਰ',
      'ਸੋਮਵਾਰ',
      'ਮੰਗਲਵਾਰ',
      'ਬੁੱਧਵਾਰ',
      'ਵੀਰਵਾਰ',
      'ਸ਼ੁੱਕਰਵਾਰ',
      'ਸ਼ਨਿੱਚਰਵਾਰ',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'ਐਤ',
      'ਸੋਮ',
      'ਮੰਗਲ',
      'ਬੁੱਧ',
      'ਵੀਰ',
      'ਸ਼ੁੱਕਰ',
      'ਸ਼ਨਿੱਚਰ',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'ਐਤ',
      'ਸੋਮ',
      'ਮੰਗਲ',
      'ਬੁੱਧ',
      'ਵੀਰ',
      'ਸ਼ੁੱਕਰ',
      'ਸ਼ਨਿੱਚਰ',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'ਐ',
      'ਸੋ',
      'ਮੰ',
      'ਬੁੱ',
      'ਵੀ',
      'ਸ਼ੁੱ',
      'ਸ਼',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'ਐ',
      'ਸੋ',
      'ਮੰ',
      'ਬੁੱ',
      'ਵੀ',
      'ਸ਼ੁੱ',
      'ਸ਼',
    ],
    'SHORTQUARTERS': <dynamic>[
      'ਤਿਮਾਹੀ1',
      'ਤਿਮਾਹੀ2',
      'ਤਿਮਾਹੀ3',
      'ਤਿਮਾਹੀ4',
    ],
    'QUARTERS': <dynamic>[
      'ਪਹਿਲੀ ਤਿਮਾਹੀ',
      'ਦੂਜੀ ਤਿਮਾਹੀ',
      'ਤੀਜੀ ਤਿਮਾਹੀ',
      'ਚੌਥੀ ਤਿਮਾਹੀ',
    ],
    'AMPMS': <dynamic>[
      'ਪੂ.ਦੁ.',
      'ਬਾ.ਦੁ.',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d MMMM y',
      'd MMMM y',
      'd MMM y',
      'd/M/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'h:mm:ss a zzzz',
      'h:mm:ss a z',
      'h:mm:ss a',
      'h:mm a',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      6,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'pl': <String, dynamic>{
    'NAME': 'pl',
    'ERAS': <dynamic>[
      'p.n.e.',
      'n.e.',
    ],
    'ERANAMES': <dynamic>[
      'przed naszą erą',
      'naszej ery',
    ],
    'NARROWMONTHS': <dynamic>[
      's',
      'l',
      'm',
      'k',
      'm',
      'c',
      'l',
      's',
      'w',
      'p',
      'l',
      'g',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'S',
      'L',
      'M',
      'K',
      'M',
      'C',
      'L',
      'S',
      'W',
      'P',
      'L',
      'G',
    ],
    'MONTHS': <dynamic>[
      'stycznia',
      'lutego',
      'marca',
      'kwietnia',
      'maja',
      'czerwca',
      'lipca',
      'sierpnia',
      'września',
      'października',
      'listopada',
      'grudnia',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'styczeń',
      'luty',
      'marzec',
      'kwiecień',
      'maj',
      'czerwiec',
      'lipiec',
      'sierpień',
      'wrzesień',
      'październik',
      'listopad',
      'grudzień',
    ],
    'SHORTMONTHS': <dynamic>[
      'sty',
      'lut',
      'mar',
      'kwi',
      'maj',
      'cze',
      'lip',
      'sie',
      'wrz',
      'paź',
      'lis',
      'gru',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'sty',
      'lut',
      'mar',
      'kwi',
      'maj',
      'cze',
      'lip',
      'sie',
      'wrz',
      'paź',
      'lis',
      'gru',
    ],
    'WEEKDAYS': <dynamic>[
      'niedziela',
      'poniedziałek',
      'wtorek',
      'środa',
      'czwartek',
      'piątek',
      'sobota',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'niedziela',
      'poniedziałek',
      'wtorek',
      'środa',
      'czwartek',
      'piątek',
      'sobota',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'niedz.',
      'pon.',
      'wt.',
      'śr.',
      'czw.',
      'pt.',
      'sob.',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'niedz.',
      'pon.',
      'wt.',
      'śr.',
      'czw.',
      'pt.',
      'sob.',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'n',
      'p',
      'w',
      'ś',
      'c',
      'p',
      's',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'N',
      'P',
      'W',
      'Ś',
      'C',
      'P',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      'I kw.',
      'II kw.',
      'III kw.',
      'IV kw.',
    ],
    'QUARTERS': <dynamic>[
      'I kwartał',
      'II kwartał',
      'III kwartał',
      'IV kwartał',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d MMMM y',
      'd MMMM y',
      'd MMM y',
      'dd.MM.y',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'ps': <String, dynamic>{
    'NAME': 'ps',
    'ERAS': <dynamic>[
      'له میلاد وړاندې',
      'م.',
    ],
    'ERANAMES': <dynamic>[
      'له میلاد څخه وړاندې',
      'له میلاد څخه وروسته',
    ],
    'NARROWMONTHS': <dynamic>[
      'ج',
      'ف',
      'م',
      'ا',
      'م',
      'ج',
      'ج',
      'ا',
      'س',
      'ا',
      'ن',
      'د',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      '1',
      '2',
      '3',
      '4',
      '5',
      '6',
      '7',
      '8',
      '9',
      '10',
      '11',
      '12',
    ],
    'MONTHS': <dynamic>[
      'جنوري',
      'فبروري',
      'مارچ',
      'اپریل',
      'مۍ',
      'جون',
      'جولای',
      'اگست',
      'سېپتمبر',
      'اکتوبر',
      'نومبر',
      'دسمبر',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'جنوري',
      'فېبروري',
      'مارچ',
      'اپریل',
      'مۍ',
      'جون',
      'جولای',
      'اگست',
      'سپتمبر',
      'اکتوبر',
      'نومبر',
      'دسمبر',
    ],
    'SHORTMONTHS': <dynamic>[
      'جنوري',
      'فبروري',
      'مارچ',
      'اپریل',
      'مۍ',
      'جون',
      'جولای',
      'اگست',
      'سېپتمبر',
      'اکتوبر',
      'نومبر',
      'دسمبر',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'جنوري',
      'فبروري',
      'مارچ',
      'اپریل',
      'مۍ',
      'جون',
      'جولای',
      'اگست',
      'سپتمبر',
      'اکتوبر',
      'نومبر',
      'دسمبر',
    ],
    'WEEKDAYS': <dynamic>[
      'يونۍ',
      'دونۍ',
      'درېنۍ',
      'څلرنۍ',
      'پينځنۍ',
      'جمعه',
      'اونۍ',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'يونۍ',
      'دونۍ',
      'درېنۍ',
      'څلرنۍ',
      'پينځنۍ',
      'جمعه',
      'اونۍ',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'يونۍ',
      'دونۍ',
      'درېنۍ',
      'څلرنۍ',
      'پينځنۍ',
      'جمعه',
      'اونۍ',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'يونۍ',
      'دونۍ',
      'درېنۍ',
      'څلرنۍ',
      'پينځنۍ',
      'جمعه',
      'اونۍ',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'W',
      'T',
      'F',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'W',
      'T',
      'F',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      'لومړۍ ربعه',
      '۲مه ربعه',
      '۳مه ربعه',
      '۴مه ربعه',
    ],
    'QUARTERS': <dynamic>[
      'لومړۍ ربعه',
      '۲مه ربعه',
      '۳مه ربعه',
      '۴مه ربعه',
    ],
    'AMPMS': <dynamic>[
      'غ.م.',
      'غ.و.',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE د y د MMMM d',
      'د y د MMMM d',
      'y MMM d',
      'y/M/d',
    ],
    'TIMEFORMATS': <dynamic>[
      'H:mm:ss (zzzz)',
      'H:mm:ss (z)',
      'H:mm:ss',
      'H:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 5,
    'WEEKENDRANGE': <dynamic>[
      3,
      4,
    ],
    'FIRSTWEEKCUTOFFDAY': 4,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
    'ZERODIGIT': '۰',
  },
  'pt': <String, dynamic>{
    'NAME': 'pt',
    'ERAS': <dynamic>[
      'a.C.',
      'd.C.',
    ],
    'ERANAMES': <dynamic>[
      'antes de Cristo',
      'depois de Cristo',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'janeiro',
      'fevereiro',
      'março',
      'abril',
      'maio',
      'junho',
      'julho',
      'agosto',
      'setembro',
      'outubro',
      'novembro',
      'dezembro',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'janeiro',
      'fevereiro',
      'março',
      'abril',
      'maio',
      'junho',
      'julho',
      'agosto',
      'setembro',
      'outubro',
      'novembro',
      'dezembro',
    ],
    'SHORTMONTHS': <dynamic>[
      'jan',
      'fev',
      'mar',
      'abr',
      'mai',
      'jun',
      'jul',
      'ago',
      'set',
      'out',
      'nov',
      'dez',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'jan',
      'fev',
      'mar',
      'abr',
      'mai',
      'jun',
      'jul',
      'ago',
      'set',
      'out',
      'nov',
      'dez',
    ],
    'WEEKDAYS': <dynamic>[
      'domingo',
      'segunda-feira',
      'terça-feira',
      'quarta-feira',
      'quinta-feira',
      'sexta-feira',
      'sábado',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'domingo',
      'segunda-feira',
      'terça-feira',
      'quarta-feira',
      'quinta-feira',
      'sexta-feira',
      'sábado',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'dom',
      'seg',
      'ter',
      'qua',
      'qui',
      'sex',
      'sáb',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'dom',
      'seg',
      'ter',
      'qua',
      'qui',
      'sex',
      'sáb',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'D',
      'S',
      'T',
      'Q',
      'Q',
      'S',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'D',
      'S',
      'T',
      'Q',
      'Q',
      'S',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      'T1',
      'T2',
      'T3',
      'T4',
    ],
    'QUARTERS': <dynamic>[
      '1º trimestre',
      '2º trimestre',
      '3º trimestre',
      '4º trimestre',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d \'de\' MMMM \'de\' y',
      'd \'de\' MMMM \'de\' y',
      'd \'de\' MMM \'de\' y',
      'dd/MM/y',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'pt_PT': <String, dynamic>{
    'NAME': 'pt_PT',
    'ERAS': <dynamic>[
      'a.C.',
      'd.C.',
    ],
    'ERANAMES': <dynamic>[
      'antes de Cristo',
      'depois de Cristo',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'janeiro',
      'fevereiro',
      'março',
      'abril',
      'maio',
      'junho',
      'julho',
      'agosto',
      'setembro',
      'outubro',
      'novembro',
      'dezembro',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'janeiro',
      'fevereiro',
      'março',
      'abril',
      'maio',
      'junho',
      'julho',
      'agosto',
      'setembro',
      'outubro',
      'novembro',
      'dezembro',
    ],
    'SHORTMONTHS': <dynamic>[
      'jan',
      'fev',
      'mar',
      'abr',
      'mai',
      'jun',
      'jul',
      'ago',
      'set',
      'out',
      'nov',
      'dez',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'jan',
      'fev',
      'mar',
      'abr',
      'mai',
      'jun',
      'jul',
      'ago',
      'set',
      'out',
      'nov',
      'dez',
    ],
    'WEEKDAYS': <dynamic>[
      'domingo',
      'segunda-feira',
      'terça-feira',
      'quarta-feira',
      'quinta-feira',
      'sexta-feira',
      'sábado',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'domingo',
      'segunda-feira',
      'terça-feira',
      'quarta-feira',
      'quinta-feira',
      'sexta-feira',
      'sábado',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'domingo',
      'segunda',
      'terça',
      'quarta',
      'quinta',
      'sexta',
      'sábado',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'domingo',
      'segunda',
      'terça',
      'quarta',
      'quinta',
      'sexta',
      'sábado',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'D',
      'S',
      'T',
      'Q',
      'Q',
      'S',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'D',
      'S',
      'T',
      'Q',
      'Q',
      'S',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      'T1',
      'T2',
      'T3',
      'T4',
    ],
    'QUARTERS': <dynamic>[
      '1.º trimestre',
      '2.º trimestre',
      '3.º trimestre',
      '4.º trimestre',
    ],
    'AMPMS': <dynamic>[
      'da manhã',
      'da tarde',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d \'de\' MMMM \'de\' y',
      'd \'de\' MMMM \'de\' y',
      'dd/MM/y',
      'dd/MM/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 2,
    'DATETIMEFORMATS': <dynamic>[
      '{1} \'às\' {0}',
      '{1} \'às\' {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'ro': <String, dynamic>{
    'NAME': 'ro',
    'ERAS': <dynamic>[
      'î.Hr.',
      'd.Hr.',
    ],
    'ERANAMES': <dynamic>[
      'înainte de Hristos',
      'după Hristos',
    ],
    'NARROWMONTHS': <dynamic>[
      'I',
      'F',
      'M',
      'A',
      'M',
      'I',
      'I',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'I',
      'F',
      'M',
      'A',
      'M',
      'I',
      'I',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'ianuarie',
      'februarie',
      'martie',
      'aprilie',
      'mai',
      'iunie',
      'iulie',
      'august',
      'septembrie',
      'octombrie',
      'noiembrie',
      'decembrie',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'ianuarie',
      'februarie',
      'martie',
      'aprilie',
      'mai',
      'iunie',
      'iulie',
      'august',
      'septembrie',
      'octombrie',
      'noiembrie',
      'decembrie',
    ],
    'SHORTMONTHS': <dynamic>[
      'ian.',
      'feb.',
      'mar.',
      'apr.',
      'mai',
      'iun.',
      'iul.',
      'aug.',
      'sept.',
      'oct.',
      'nov.',
      'dec.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'ian.',
      'feb.',
      'mar.',
      'apr.',
      'mai',
      'iun.',
      'iul.',
      'aug.',
      'sept.',
      'oct.',
      'nov.',
      'dec.',
    ],
    'WEEKDAYS': <dynamic>[
      'duminică',
      'luni',
      'marți',
      'miercuri',
      'joi',
      'vineri',
      'sâmbătă',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'duminică',
      'luni',
      'marți',
      'miercuri',
      'joi',
      'vineri',
      'sâmbătă',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'dum.',
      'lun.',
      'mar.',
      'mie.',
      'joi',
      'vin.',
      'sâm.',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'dum.',
      'lun.',
      'mar.',
      'mie.',
      'joi',
      'vin.',
      'sâm.',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'D',
      'L',
      'M',
      'M',
      'J',
      'V',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'D',
      'L',
      'M',
      'M',
      'J',
      'V',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      'trim. I',
      'trim. II',
      'trim. III',
      'trim. IV',
    ],
    'QUARTERS': <dynamic>[
      'trimestrul I',
      'trimestrul al II-lea',
      'trimestrul al III-lea',
      'trimestrul al IV-lea',
    ],
    'AMPMS': <dynamic>[
      'a.m.',
      'p.m.',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d MMMM y',
      'd MMMM y',
      'd MMM y',
      'dd.MM.y',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      '{1}, {0}',
      '{1}, {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'ru': <String, dynamic>{
    'NAME': 'ru',
    'ERAS': <dynamic>[
      'до н. э.',
      'н. э.',
    ],
    'ERANAMES': <dynamic>[
      'до Рождества Христова',
      'от Рождества Христова',
    ],
    'NARROWMONTHS': <dynamic>[
      'Я',
      'Ф',
      'М',
      'А',
      'М',
      'И',
      'И',
      'А',
      'С',
      'О',
      'Н',
      'Д',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'Я',
      'Ф',
      'М',
      'А',
      'М',
      'И',
      'И',
      'А',
      'С',
      'О',
      'Н',
      'Д',
    ],
    'MONTHS': <dynamic>[
      'января',
      'февраля',
      'марта',
      'апреля',
      'мая',
      'июня',
      'июля',
      'августа',
      'сентября',
      'октября',
      'ноября',
      'декабря',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'январь',
      'февраль',
      'март',
      'апрель',
      'май',
      'июнь',
      'июль',
      'август',
      'сентябрь',
      'октябрь',
      'ноябрь',
      'декабрь',
    ],
    'SHORTMONTHS': <dynamic>[
      'янв.',
      'февр.',
      'мар.',
      'апр.',
      'мая',
      'июн.',
      'июл.',
      'авг.',
      'сент.',
      'окт.',
      'нояб.',
      'дек.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'янв.',
      'февр.',
      'март',
      'апр.',
      'май',
      'июнь',
      'июль',
      'авг.',
      'сент.',
      'окт.',
      'нояб.',
      'дек.',
    ],
    'WEEKDAYS': <dynamic>[
      'воскресенье',
      'понедельник',
      'вторник',
      'среда',
      'четверг',
      'пятница',
      'суббота',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'воскресенье',
      'понедельник',
      'вторник',
      'среда',
      'четверг',
      'пятница',
      'суббота',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'вс',
      'пн',
      'вт',
      'ср',
      'чт',
      'пт',
      'сб',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'вс',
      'пн',
      'вт',
      'ср',
      'чт',
      'пт',
      'сб',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'вс',
      'пн',
      'вт',
      'ср',
      'чт',
      'пт',
      'сб',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'В',
      'П',
      'В',
      'С',
      'Ч',
      'П',
      'С',
    ],
    'SHORTQUARTERS': <dynamic>[
      '1-й кв.',
      '2-й кв.',
      '3-й кв.',
      '4-й кв.',
    ],
    'QUARTERS': <dynamic>[
      '1-й квартал',
      '2-й квартал',
      '3-й квартал',
      '4-й квартал',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d MMMM y \'г\'.',
      'd MMMM y \'г\'.',
      'd MMM y \'г\'.',
      'dd.MM.y',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      '{1}, {0}',
      '{1}, {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'si': <String, dynamic>{
    'NAME': 'si',
    'ERAS': <dynamic>[
      'ක්‍රි.පූ.',
      'ක්‍රි.ව.',
    ],
    'ERANAMES': <dynamic>[
      'ක්‍රිස්තු පූර්ව',
      'ක්‍රිස්තු වර්ෂ',
    ],
    'NARROWMONTHS': <dynamic>[
      'ජ',
      'පෙ',
      'මා',
      'අ',
      'මැ',
      'ජූ',
      'ජූ',
      'අ',
      'සැ',
      'ඔ',
      'නෙ',
      'දෙ',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'ජ',
      'පෙ',
      'මා',
      'අ',
      'මැ',
      'ජූ',
      'ජූ',
      'අ',
      'සැ',
      'ඔ',
      'නෙ',
      'දෙ',
    ],
    'MONTHS': <dynamic>[
      'ජනවාරි',
      'පෙබරවාරි',
      'මාර්තු',
      'අප්‍රේල්',
      'මැයි',
      'ජූනි',
      'ජූලි',
      'අගෝස්තු',
      'සැප්තැම්බර්',
      'ඔක්තෝබර්',
      'නොවැම්බර්',
      'දෙසැම්බර්',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'ජනවාරි',
      'පෙබරවාරි',
      'මාර්තු',
      'අප්‍රේල්',
      'මැයි',
      'ජූනි',
      'ජූලි',
      'අගෝස්තු',
      'සැප්තැම්බර්',
      'ඔක්තෝබර්',
      'නොවැම්බර්',
      'දෙසැම්බර්',
    ],
    'SHORTMONTHS': <dynamic>[
      'ජන',
      'පෙබ',
      'මාර්තු',
      'අප්‍රේල්',
      'මැයි',
      'ජූනි',
      'ජූලි',
      'අගෝ',
      'සැප්',
      'ඔක්',
      'නොවැ',
      'දෙසැ',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'ජන',
      'පෙබ',
      'මාර්',
      'අප්‍රේල්',
      'මැයි',
      'ජූනි',
      'ජූලි',
      'අගෝ',
      'සැප්',
      'ඔක්',
      'නොවැ',
      'දෙසැ',
    ],
    'WEEKDAYS': <dynamic>[
      'ඉරිදා',
      'සඳුදා',
      'අඟහරුවාදා',
      'බදාදා',
      'බ්‍රහස්පතින්දා',
      'සිකුරාදා',
      'සෙනසුරාදා',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'ඉරිදා',
      'සඳුදා',
      'අඟහරුවාදා',
      'බදාදා',
      'බ්‍රහස්පතින්දා',
      'සිකුරාදා',
      'සෙනසුරාදා',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'ඉරිදා',
      'සඳුදා',
      'අඟහ',
      'බදාදා',
      'බ්‍රහස්',
      'සිකු',
      'සෙන',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'ඉරිදා',
      'සඳුදා',
      'අඟහ',
      'බදාදා',
      'බ්‍රහස්',
      'සිකු',
      'සෙන',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'ඉ',
      'ස',
      'අ',
      'බ',
      'බ්‍ර',
      'සි',
      'සෙ',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'ඉ',
      'ස',
      'අ',
      'බ',
      'බ්‍ර',
      'සි',
      'සෙ',
    ],
    'SHORTQUARTERS': <dynamic>[
      'කාර්:1',
      'කාර්:2',
      'කාර්:3',
      'කාර්:4',
    ],
    'QUARTERS': <dynamic>[
      '1 වන කාර්තුව',
      '2 වන කාර්තුව',
      '3 වන කාර්තුව',
      '4 වන කාර්තුව',
    ],
    'AMPMS': <dynamic>[
      'පෙ.ව.',
      'ප.ව.',
    ],
    'DATEFORMATS': <dynamic>[
      'y MMMM d, EEEE',
      'y MMMM d',
      'y MMM d',
      'y-MM-dd',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH.mm.ss zzzz',
      'HH.mm.ss z',
      'HH.mm.ss',
      'HH.mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'sk': <String, dynamic>{
    'NAME': 'sk',
    'ERAS': <dynamic>[
      'pred Kr.',
      'po Kr.',
    ],
    'ERANAMES': <dynamic>[
      'pred Kristom',
      'po Kristovi',
    ],
    'NARROWMONTHS': <dynamic>[
      'j',
      'f',
      'm',
      'a',
      'm',
      'j',
      'j',
      'a',
      's',
      'o',
      'n',
      'd',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'j',
      'f',
      'm',
      'a',
      'm',
      'j',
      'j',
      'a',
      's',
      'o',
      'n',
      'd',
    ],
    'MONTHS': <dynamic>[
      'januára',
      'februára',
      'marca',
      'apríla',
      'mája',
      'júna',
      'júla',
      'augusta',
      'septembra',
      'októbra',
      'novembra',
      'decembra',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'január',
      'február',
      'marec',
      'apríl',
      'máj',
      'jún',
      'júl',
      'august',
      'september',
      'október',
      'november',
      'december',
    ],
    'SHORTMONTHS': <dynamic>[
      'jan',
      'feb',
      'mar',
      'apr',
      'máj',
      'jún',
      'júl',
      'aug',
      'sep',
      'okt',
      'nov',
      'dec',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'jan',
      'feb',
      'mar',
      'apr',
      'máj',
      'jún',
      'júl',
      'aug',
      'sep',
      'okt',
      'nov',
      'dec',
    ],
    'WEEKDAYS': <dynamic>[
      'nedeľa',
      'pondelok',
      'utorok',
      'streda',
      'štvrtok',
      'piatok',
      'sobota',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'nedeľa',
      'pondelok',
      'utorok',
      'streda',
      'štvrtok',
      'piatok',
      'sobota',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'ne',
      'po',
      'ut',
      'st',
      'št',
      'pi',
      'so',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'ne',
      'po',
      'ut',
      'st',
      'št',
      'pi',
      'so',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'n',
      'p',
      'u',
      's',
      'š',
      'p',
      's',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'n',
      'p',
      'u',
      's',
      'š',
      'p',
      's',
    ],
    'SHORTQUARTERS': <dynamic>[
      'Q1',
      'Q2',
      'Q3',
      'Q4',
    ],
    'QUARTERS': <dynamic>[
      '1. štvrťrok',
      '2. štvrťrok',
      '3. štvrťrok',
      '4. štvrťrok',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE d. MMMM y',
      'd. MMMM y',
      'd. M. y',
      'd. M. y',
    ],
    'TIMEFORMATS': <dynamic>[
      'H:mm:ss zzzz',
      'H:mm:ss z',
      'H:mm:ss',
      'H:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      '{1}, {0}',
      '{1}, {0}',
      '{1}, {0}',
      '{1} {0}',
    ],
  },
  'sl': <String, dynamic>{
    'NAME': 'sl',
    'ERAS': <dynamic>[
      'pr. Kr.',
      'po Kr.',
    ],
    'ERANAMES': <dynamic>[
      'pred Kristusom',
      'po Kristusu',
    ],
    'NARROWMONTHS': <dynamic>[
      'j',
      'f',
      'm',
      'a',
      'm',
      'j',
      'j',
      'a',
      's',
      'o',
      'n',
      'd',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'j',
      'f',
      'm',
      'a',
      'm',
      'j',
      'j',
      'a',
      's',
      'o',
      'n',
      'd',
    ],
    'MONTHS': <dynamic>[
      'januar',
      'februar',
      'marec',
      'april',
      'maj',
      'junij',
      'julij',
      'avgust',
      'september',
      'oktober',
      'november',
      'december',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'januar',
      'februar',
      'marec',
      'april',
      'maj',
      'junij',
      'julij',
      'avgust',
      'september',
      'oktober',
      'november',
      'december',
    ],
    'SHORTMONTHS': <dynamic>[
      'jan.',
      'feb.',
      'mar.',
      'apr.',
      'maj',
      'jun.',
      'jul.',
      'avg.',
      'sep.',
      'okt.',
      'nov.',
      'dec.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'jan.',
      'feb.',
      'mar.',
      'apr.',
      'maj',
      'jun.',
      'jul.',
      'avg.',
      'sep.',
      'okt.',
      'nov.',
      'dec.',
    ],
    'WEEKDAYS': <dynamic>[
      'nedelja',
      'ponedeljek',
      'torek',
      'sreda',
      'četrtek',
      'petek',
      'sobota',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'nedelja',
      'ponedeljek',
      'torek',
      'sreda',
      'četrtek',
      'petek',
      'sobota',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'ned.',
      'pon.',
      'tor.',
      'sre.',
      'čet.',
      'pet.',
      'sob.',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'ned.',
      'pon.',
      'tor.',
      'sre.',
      'čet.',
      'pet.',
      'sob.',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'n',
      'p',
      't',
      's',
      'č',
      'p',
      's',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'n',
      'p',
      't',
      's',
      'č',
      'p',
      's',
    ],
    'SHORTQUARTERS': <dynamic>[
      '1. čet.',
      '2. čet.',
      '3. čet.',
      '4. čet.',
    ],
    'QUARTERS': <dynamic>[
      '1. četrtletje',
      '2. četrtletje',
      '3. četrtletje',
      '4. četrtletje',
    ],
    'AMPMS': <dynamic>[
      'dop.',
      'pop.',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, dd. MMMM y',
      'dd. MMMM y',
      'd. MMM y',
      'd. MM. yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'sq': <String, dynamic>{
    'NAME': 'sq',
    'ERAS': <dynamic>[
      'p.K.',
      'mb.K.',
    ],
    'ERANAMES': <dynamic>[
      'para Krishtit',
      'mbas Krishtit',
    ],
    'NARROWMONTHS': <dynamic>[
      'j',
      'sh',
      'm',
      'p',
      'm',
      'q',
      'k',
      'g',
      'sh',
      't',
      'n',
      'dh',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'j',
      'sh',
      'm',
      'p',
      'm',
      'q',
      'k',
      'g',
      'sh',
      't',
      'n',
      'dh',
    ],
    'MONTHS': <dynamic>[
      'janar',
      'shkurt',
      'mars',
      'prill',
      'maj',
      'qershor',
      'korrik',
      'gusht',
      'shtator',
      'tetor',
      'nëntor',
      'dhjetor',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'janar',
      'shkurt',
      'mars',
      'prill',
      'maj',
      'qershor',
      'korrik',
      'gusht',
      'shtator',
      'tetor',
      'nëntor',
      'dhjetor',
    ],
    'SHORTMONTHS': <dynamic>[
      'jan',
      'shk',
      'mar',
      'pri',
      'maj',
      'qer',
      'korr',
      'gush',
      'sht',
      'tet',
      'nën',
      'dhj',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'jan',
      'shk',
      'mar',
      'pri',
      'maj',
      'qer',
      'korr',
      'gush',
      'sht',
      'tet',
      'nën',
      'dhj',
    ],
    'WEEKDAYS': <dynamic>[
      'e diel',
      'e hënë',
      'e martë',
      'e mërkurë',
      'e enjte',
      'e premte',
      'e shtunë',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'e diel',
      'e hënë',
      'e martë',
      'e mërkurë',
      'e enjte',
      'e premte',
      'e shtunë',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'Die',
      'Hën',
      'Mar',
      'Mër',
      'Enj',
      'Pre',
      'Sht',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'die',
      'hën',
      'mar',
      'mër',
      'enj',
      'pre',
      'sht',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'd',
      'h',
      'm',
      'm',
      'e',
      'p',
      'sh',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'd',
      'h',
      'm',
      'm',
      'e',
      'p',
      'sh',
    ],
    'SHORTQUARTERS': <dynamic>[
      'tremujori I',
      'tremujori II',
      'tremujori III',
      'tremujori IV',
    ],
    'QUARTERS': <dynamic>[
      'tremujori i parë',
      'tremujori i dytë',
      'tremujori i tretë',
      'tremujori i katërt',
    ],
    'AMPMS': <dynamic>[
      'e paradites',
      'e pasdites',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d MMMM y',
      'd MMMM y',
      'd MMM y',
      'd.M.yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'h:mm:ss a, zzzz',
      'h:mm:ss a, z',
      'h:mm:ss a',
      'h:mm a',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      '{1} \'në\' {0}',
      '{1} \'në\' {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'sr': <String, dynamic>{
    'NAME': 'sr',
    'ERAS': <dynamic>[
      'п. н. е.',
      'н. е.',
    ],
    'ERANAMES': <dynamic>[
      'пре нове ере',
      'нове ере',
    ],
    'NARROWMONTHS': <dynamic>[
      'ј',
      'ф',
      'м',
      'а',
      'м',
      'ј',
      'ј',
      'а',
      'с',
      'о',
      'н',
      'д',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'ј',
      'ф',
      'м',
      'а',
      'м',
      'ј',
      'ј',
      'а',
      'с',
      'о',
      'н',
      'д',
    ],
    'MONTHS': <dynamic>[
      'јануар',
      'фебруар',
      'март',
      'април',
      'мај',
      'јун',
      'јул',
      'август',
      'септембар',
      'октобар',
      'новембар',
      'децембар',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'јануар',
      'фебруар',
      'март',
      'април',
      'мај',
      'јун',
      'јул',
      'август',
      'септембар',
      'октобар',
      'новембар',
      'децембар',
    ],
    'SHORTMONTHS': <dynamic>[
      'јан',
      'феб',
      'мар',
      'апр',
      'мај',
      'јун',
      'јул',
      'авг',
      'сеп',
      'окт',
      'нов',
      'дец',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'јан',
      'феб',
      'мар',
      'апр',
      'мај',
      'јун',
      'јул',
      'авг',
      'сеп',
      'окт',
      'нов',
      'дец',
    ],
    'WEEKDAYS': <dynamic>[
      'недеља',
      'понедељак',
      'уторак',
      'среда',
      'четвртак',
      'петак',
      'субота',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'недеља',
      'понедељак',
      'уторак',
      'среда',
      'четвртак',
      'петак',
      'субота',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'нед',
      'пон',
      'уто',
      'сре',
      'чет',
      'пет',
      'суб',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'нед',
      'пон',
      'уто',
      'сре',
      'чет',
      'пет',
      'суб',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'н',
      'п',
      'у',
      'с',
      'ч',
      'п',
      'с',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'н',
      'п',
      'у',
      'с',
      'ч',
      'п',
      'с',
    ],
    'SHORTQUARTERS': <dynamic>[
      'К1',
      'К2',
      'К3',
      'К4',
    ],
    'QUARTERS': <dynamic>[
      'први квартал',
      'други квартал',
      'трећи квартал',
      'четврти квартал',
    ],
    'AMPMS': <dynamic>[
      'пре подне',
      'по подне',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, dd. MMMM y.',
      'dd. MMMM y.',
      'dd.MM.y.',
      'd.M.yy.',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'sr_Latn': <String, dynamic>{
    'NAME': 'sr_Latn',
    'ERAS': <dynamic>[
      'p. n. e.',
      'n. e.',
    ],
    'ERANAMES': <dynamic>[
      'pre nove ere',
      'nove ere',
    ],
    'NARROWMONTHS': <dynamic>[
      'j',
      'f',
      'm',
      'a',
      'm',
      'j',
      'j',
      'a',
      's',
      'o',
      'n',
      'd',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'j',
      'f',
      'm',
      'a',
      'm',
      'j',
      'j',
      'a',
      's',
      'o',
      'n',
      'd',
    ],
    'MONTHS': <dynamic>[
      'januar',
      'februar',
      'mart',
      'april',
      'maj',
      'jun',
      'jul',
      'avgust',
      'septembar',
      'oktobar',
      'novembar',
      'decembar',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'januar',
      'februar',
      'mart',
      'april',
      'maj',
      'jun',
      'jul',
      'avgust',
      'septembar',
      'oktobar',
      'novembar',
      'decembar',
    ],
    'SHORTMONTHS': <dynamic>[
      'jan',
      'feb',
      'mar',
      'apr',
      'maj',
      'jun',
      'jul',
      'avg',
      'sep',
      'okt',
      'nov',
      'dec',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'jan',
      'feb',
      'mar',
      'apr',
      'maj',
      'jun',
      'jul',
      'avg',
      'sep',
      'okt',
      'nov',
      'dec',
    ],
    'WEEKDAYS': <dynamic>[
      'nedelja',
      'ponedeljak',
      'utorak',
      'sreda',
      'četvrtak',
      'petak',
      'subota',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'nedelja',
      'ponedeljak',
      'utorak',
      'sreda',
      'četvrtak',
      'petak',
      'subota',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'ned',
      'pon',
      'uto',
      'sre',
      'čet',
      'pet',
      'sub',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'ned',
      'pon',
      'uto',
      'sre',
      'čet',
      'pet',
      'sub',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'n',
      'p',
      'u',
      's',
      'č',
      'p',
      's',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'n',
      'p',
      'u',
      's',
      'č',
      'p',
      's',
    ],
    'SHORTQUARTERS': <dynamic>[
      'K1',
      'K2',
      'K3',
      'K4',
    ],
    'QUARTERS': <dynamic>[
      'prvi kvartal',
      'drugi kvartal',
      'treći kvartal',
      'četvrti kvartal',
    ],
    'AMPMS': <dynamic>[
      'pre podne',
      'po podne',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, dd. MMMM y.',
      'dd. MMMM y.',
      'dd.MM.y.',
      'd.M.yy.',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'sv': <String, dynamic>{
    'NAME': 'sv',
    'ERAS': <dynamic>[
      'f.Kr.',
      'e.Kr.',
    ],
    'ERANAMES': <dynamic>[
      'före Kristus',
      'efter Kristus',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'januari',
      'februari',
      'mars',
      'april',
      'maj',
      'juni',
      'juli',
      'augusti',
      'september',
      'oktober',
      'november',
      'december',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'januari',
      'februari',
      'mars',
      'april',
      'maj',
      'juni',
      'juli',
      'augusti',
      'september',
      'oktober',
      'november',
      'december',
    ],
    'SHORTMONTHS': <dynamic>[
      'jan.',
      'feb.',
      'mars',
      'apr.',
      'maj',
      'juni',
      'juli',
      'aug.',
      'sep.',
      'okt.',
      'nov.',
      'dec.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'jan.',
      'feb.',
      'mars',
      'apr.',
      'maj',
      'juni',
      'juli',
      'aug.',
      'sep.',
      'okt.',
      'nov.',
      'dec.',
    ],
    'WEEKDAYS': <dynamic>[
      'söndag',
      'måndag',
      'tisdag',
      'onsdag',
      'torsdag',
      'fredag',
      'lördag',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'söndag',
      'måndag',
      'tisdag',
      'onsdag',
      'torsdag',
      'fredag',
      'lördag',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'sön',
      'mån',
      'tis',
      'ons',
      'tors',
      'fre',
      'lör',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'sön',
      'mån',
      'tis',
      'ons',
      'tors',
      'fre',
      'lör',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'O',
      'T',
      'F',
      'L',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'O',
      'T',
      'F',
      'L',
    ],
    'SHORTQUARTERS': <dynamic>[
      'K1',
      'K2',
      'K3',
      'K4',
    ],
    'QUARTERS': <dynamic>[
      '1:a kvartalet',
      '2:a kvartalet',
      '3:e kvartalet',
      '4:e kvartalet',
    ],
    'AMPMS': <dynamic>[
      'fm',
      'em',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE d MMMM y',
      'd MMMM y',
      'd MMM y',
      'y-MM-dd',
    ],
    'TIMEFORMATS': <dynamic>[
      '\'kl\'. HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 3,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'sw': <String, dynamic>{
    'NAME': 'sw',
    'ERAS': <dynamic>[
      'KK',
      'BK',
    ],
    'ERANAMES': <dynamic>[
      'Kabla ya Kristo',
      'Baada ya Kristo',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'Januari',
      'Februari',
      'Machi',
      'Aprili',
      'Mei',
      'Juni',
      'Julai',
      'Agosti',
      'Septemba',
      'Oktoba',
      'Novemba',
      'Desemba',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'Januari',
      'Februari',
      'Machi',
      'Aprili',
      'Mei',
      'Juni',
      'Julai',
      'Agosti',
      'Septemba',
      'Oktoba',
      'Novemba',
      'Desemba',
    ],
    'SHORTMONTHS': <dynamic>[
      'Jan',
      'Feb',
      'Mac',
      'Apr',
      'Mei',
      'Jun',
      'Jul',
      'Ago',
      'Sep',
      'Okt',
      'Nov',
      'Des',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'Jan',
      'Feb',
      'Mac',
      'Apr',
      'Mei',
      'Jun',
      'Jul',
      'Ago',
      'Sep',
      'Okt',
      'Nov',
      'Des',
    ],
    'WEEKDAYS': <dynamic>[
      'Jumapili',
      'Jumatatu',
      'Jumanne',
      'Jumatano',
      'Alhamisi',
      'Ijumaa',
      'Jumamosi',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'Jumapili',
      'Jumatatu',
      'Jumanne',
      'Jumatano',
      'Alhamisi',
      'Ijumaa',
      'Jumamosi',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'Jumapili',
      'Jumatatu',
      'Jumanne',
      'Jumatano',
      'Alhamisi',
      'Ijumaa',
      'Jumamosi',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'Jumapili',
      'Jumatatu',
      'Jumanne',
      'Jumatano',
      'Alhamisi',
      'Ijumaa',
      'Jumamosi',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'W',
      'T',
      'F',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'W',
      'T',
      'F',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      'Robo ya 1',
      'Robo ya 2',
      'Robo ya 3',
      'Robo ya 4',
    ],
    'QUARTERS': <dynamic>[
      'Robo ya 1',
      'Robo ya 2',
      'Robo ya 3',
      'Robo ya 4',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d MMMM y',
      'd MMMM y',
      'd MMM y',
      'dd/MM/y',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'ta': <String, dynamic>{
    'NAME': 'ta',
    'ERAS': <dynamic>[
      'கி.மு.',
      'கி.பி.',
    ],
    'ERANAMES': <dynamic>[
      'கிறிஸ்துவுக்கு முன்',
      'அன்னோ டோமினி',
    ],
    'NARROWMONTHS': <dynamic>[
      'ஜ',
      'பி',
      'மா',
      'ஏ',
      'மே',
      'ஜூ',
      'ஜூ',
      'ஆ',
      'செ',
      'அ',
      'ந',
      'டி',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'ஜ',
      'பி',
      'மா',
      'ஏ',
      'மே',
      'ஜூ',
      'ஜூ',
      'ஆ',
      'செ',
      'அ',
      'ந',
      'டி',
    ],
    'MONTHS': <dynamic>[
      'ஜனவரி',
      'பிப்ரவரி',
      'மார்ச்',
      'ஏப்ரல்',
      'மே',
      'ஜூன்',
      'ஜூலை',
      'ஆகஸ்ட்',
      'செப்டம்பர்',
      'அக்டோபர்',
      'நவம்பர்',
      'டிசம்பர்',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'ஜனவரி',
      'பிப்ரவரி',
      'மார்ச்',
      'ஏப்ரல்',
      'மே',
      'ஜூன்',
      'ஜூலை',
      'ஆகஸ்ட்',
      'செப்டம்பர்',
      'அக்டோபர்',
      'நவம்பர்',
      'டிசம்பர்',
    ],
    'SHORTMONTHS': <dynamic>[
      'ஜன.',
      'பிப்.',
      'மார்.',
      'ஏப்.',
      'மே',
      'ஜூன்',
      'ஜூலை',
      'ஆக.',
      'செப்.',
      'அக்.',
      'நவ.',
      'டிச.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'ஜன.',
      'பிப்.',
      'மார்.',
      'ஏப்.',
      'மே',
      'ஜூன்',
      'ஜூலை',
      'ஆக.',
      'செப்.',
      'அக்.',
      'நவ.',
      'டிச.',
    ],
    'WEEKDAYS': <dynamic>[
      'ஞாயிறு',
      'திங்கள்',
      'செவ்வாய்',
      'புதன்',
      'வியாழன்',
      'வெள்ளி',
      'சனி',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'ஞாயிறு',
      'திங்கள்',
      'செவ்வாய்',
      'புதன்',
      'வியாழன்',
      'வெள்ளி',
      'சனி',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'ஞாயி.',
      'திங்.',
      'செவ்.',
      'புத.',
      'வியா.',
      'வெள்.',
      'சனி',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'ஞாயி.',
      'திங்.',
      'செவ்.',
      'புத.',
      'வியா.',
      'வெள்.',
      'சனி',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'ஞா',
      'தி',
      'செ',
      'பு',
      'வி',
      'வெ',
      'ச',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'ஞா',
      'தி',
      'செ',
      'பு',
      'வி',
      'வெ',
      'ச',
    ],
    'SHORTQUARTERS': <dynamic>[
      'காலா.1',
      'காலா.2',
      'காலா.3',
      'காலா.4',
    ],
    'QUARTERS': <dynamic>[
      'ஒன்றாம் காலாண்டு',
      'இரண்டாம் காலாண்டு',
      'மூன்றாம் காலாண்டு',
      'நான்காம் காலாண்டு',
    ],
    'AMPMS': <dynamic>[
      'முற்பகல்',
      'பிற்பகல்',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d MMMM, y',
      'd MMMM, y',
      'd MMM, y',
      'd/M/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'a h:mm:ss zzzz',
      'a h:mm:ss z',
      'a h:mm:ss',
      'a h:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      6,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} ’அன்று’ {0}',
      '{1} ’அன்று’ {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'te': <String, dynamic>{
    'NAME': 'te',
    'ERAS': <dynamic>[
      'క్రీపూ',
      'క్రీశ',
    ],
    'ERANAMES': <dynamic>[
      'క్రీస్తు పూర్వం',
      'క్రీస్తు శకం',
    ],
    'NARROWMONTHS': <dynamic>[
      'జ',
      'ఫి',
      'మా',
      'ఏ',
      'మే',
      'జూ',
      'జు',
      'ఆ',
      'సె',
      'అ',
      'న',
      'డి',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'జ',
      'ఫి',
      'మా',
      'ఏ',
      'మే',
      'జూ',
      'జు',
      'ఆ',
      'సె',
      'అ',
      'న',
      'డి',
    ],
    'MONTHS': <dynamic>[
      'జనవరి',
      'ఫిబ్రవరి',
      'మార్చి',
      'ఏప్రిల్',
      'మే',
      'జూన్',
      'జులై',
      'ఆగస్టు',
      'సెప్టెంబర్',
      'అక్టోబర్',
      'నవంబర్',
      'డిసెంబర్',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'జనవరి',
      'ఫిబ్రవరి',
      'మార్చి',
      'ఏప్రిల్',
      'మే',
      'జూన్',
      'జులై',
      'ఆగస్టు',
      'సెప్టెంబర్',
      'అక్టోబర్',
      'నవంబర్',
      'డిసెంబర్',
    ],
    'SHORTMONTHS': <dynamic>[
      'జన',
      'ఫిబ్ర',
      'మార్చి',
      'ఏప్రి',
      'మే',
      'జూన్',
      'జులై',
      'ఆగ',
      'సెప్టెం',
      'అక్టో',
      'నవం',
      'డిసెం',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'జన',
      'ఫిబ్ర',
      'మార్చి',
      'ఏప్రి',
      'మే',
      'జూన్',
      'జులై',
      'ఆగ',
      'సెప్టెం',
      'అక్టో',
      'నవం',
      'డిసెం',
    ],
    'WEEKDAYS': <dynamic>[
      'ఆదివారం',
      'సోమవారం',
      'మంగళవారం',
      'బుధవారం',
      'గురువారం',
      'శుక్రవారం',
      'శనివారం',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'ఆదివారం',
      'సోమవారం',
      'మంగళవారం',
      'బుధవారం',
      'గురువారం',
      'శుక్రవారం',
      'శనివారం',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'ఆది',
      'సోమ',
      'మంగళ',
      'బుధ',
      'గురు',
      'శుక్ర',
      'శని',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'ఆది',
      'సోమ',
      'మంగళ',
      'బుధ',
      'గురు',
      'శుక్ర',
      'శని',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'ఆ',
      'సో',
      'మ',
      'బు',
      'గు',
      'శు',
      'శ',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'ఆ',
      'సో',
      'మ',
      'బు',
      'గు',
      'శు',
      'శ',
    ],
    'SHORTQUARTERS': <dynamic>[
      'త్రై1',
      'త్రై2',
      'త్రై3',
      'త్రై4',
    ],
    'QUARTERS': <dynamic>[
      '1వ త్రైమాసికం',
      '2వ త్రైమాసికం',
      '3వ త్రైమాసికం',
      '4వ త్రైమాసికం',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'd, MMMM y, EEEE',
      'd MMMM, y',
      'd MMM, y',
      'dd-MM-yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'h:mm:ss a zzzz',
      'h:mm:ss a z',
      'h:mm:ss a',
      'h:mm a',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      6,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}కి',
      '{1} {0}కి',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'th': <String, dynamic>{
    'NAME': 'th',
    'ERAS': <dynamic>[
      'ก่อน ค.ศ.',
      'ค.ศ.',
    ],
    'ERANAMES': <dynamic>[
      'ปีก่อนคริสตกาล',
      'คริสต์ศักราช',
    ],
    'NARROWMONTHS': <dynamic>[
      'ม.ค.',
      'ก.พ.',
      'มี.ค.',
      'เม.ย.',
      'พ.ค.',
      'มิ.ย.',
      'ก.ค.',
      'ส.ค.',
      'ก.ย.',
      'ต.ค.',
      'พ.ย.',
      'ธ.ค.',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'ม.ค.',
      'ก.พ.',
      'มี.ค.',
      'เม.ย.',
      'พ.ค.',
      'มิ.ย.',
      'ก.ค.',
      'ส.ค.',
      'ก.ย.',
      'ต.ค.',
      'พ.ย.',
      'ธ.ค.',
    ],
    'MONTHS': <dynamic>[
      'มกราคม',
      'กุมภาพันธ์',
      'มีนาคม',
      'เมษายน',
      'พฤษภาคม',
      'มิถุนายน',
      'กรกฎาคม',
      'สิงหาคม',
      'กันยายน',
      'ตุลาคม',
      'พฤศจิกายน',
      'ธันวาคม',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'มกราคม',
      'กุมภาพันธ์',
      'มีนาคม',
      'เมษายน',
      'พฤษภาคม',
      'มิถุนายน',
      'กรกฎาคม',
      'สิงหาคม',
      'กันยายน',
      'ตุลาคม',
      'พฤศจิกายน',
      'ธันวาคม',
    ],
    'SHORTMONTHS': <dynamic>[
      'ม.ค.',
      'ก.พ.',
      'มี.ค.',
      'เม.ย.',
      'พ.ค.',
      'มิ.ย.',
      'ก.ค.',
      'ส.ค.',
      'ก.ย.',
      'ต.ค.',
      'พ.ย.',
      'ธ.ค.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'ม.ค.',
      'ก.พ.',
      'มี.ค.',
      'เม.ย.',
      'พ.ค.',
      'มิ.ย.',
      'ก.ค.',
      'ส.ค.',
      'ก.ย.',
      'ต.ค.',
      'พ.ย.',
      'ธ.ค.',
    ],
    'WEEKDAYS': <dynamic>[
      'วันอาทิตย์',
      'วันจันทร์',
      'วันอังคาร',
      'วันพุธ',
      'วันพฤหัสบดี',
      'วันศุกร์',
      'วันเสาร์',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'วันอาทิตย์',
      'วันจันทร์',
      'วันอังคาร',
      'วันพุธ',
      'วันพฤหัสบดี',
      'วันศุกร์',
      'วันเสาร์',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'อา.',
      'จ.',
      'อ.',
      'พ.',
      'พฤ.',
      'ศ.',
      'ส.',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'อา.',
      'จ.',
      'อ.',
      'พ.',
      'พฤ.',
      'ศ.',
      'ส.',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'อา',
      'จ',
      'อ',
      'พ',
      'พฤ',
      'ศ',
      'ส',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'อา',
      'จ',
      'อ',
      'พ',
      'พฤ',
      'ศ',
      'ส',
    ],
    'SHORTQUARTERS': <dynamic>[
      'ไตรมาส 1',
      'ไตรมาส 2',
      'ไตรมาส 3',
      'ไตรมาส 4',
    ],
    'QUARTERS': <dynamic>[
      'ไตรมาส 1',
      'ไตรมาส 2',
      'ไตรมาส 3',
      'ไตรมาส 4',
    ],
    'AMPMS': <dynamic>[
      'ก่อนเที่ยง',
      'หลังเที่ยง',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEEที่ d MMMM G y',
      'd MMMM G y',
      'd MMM y',
      'd/M/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'H นาฬิกา mm นาที ss วินาที zzzz',
      'H นาฬิกา mm นาที ss วินาที z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'tl': <String, dynamic>{
    'NAME': 'tl',
    'ERAS': <dynamic>[
      'BC',
      'AD',
    ],
    'ERANAMES': <dynamic>[
      'Before Christ',
      'Anno Domini',
    ],
    'NARROWMONTHS': <dynamic>[
      'Ene',
      'Peb',
      'Mar',
      'Abr',
      'May',
      'Hun',
      'Hul',
      'Ago',
      'Set',
      'Okt',
      'Nob',
      'Dis',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'E',
      'P',
      'M',
      'A',
      'M',
      'Hun',
      'Hul',
      'Ago',
      'Set',
      'Okt',
      'Nob',
      'Dis',
    ],
    'MONTHS': <dynamic>[
      'Enero',
      'Pebrero',
      'Marso',
      'Abril',
      'Mayo',
      'Hunyo',
      'Hulyo',
      'Agosto',
      'Setyembre',
      'Oktubre',
      'Nobyembre',
      'Disyembre',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'Enero',
      'Pebrero',
      'Marso',
      'Abril',
      'Mayo',
      'Hunyo',
      'Hulyo',
      'Agosto',
      'Setyembre',
      'Oktubre',
      'Nobyembre',
      'Disyembre',
    ],
    'SHORTMONTHS': <dynamic>[
      'Ene',
      'Peb',
      'Mar',
      'Abr',
      'May',
      'Hun',
      'Hul',
      'Ago',
      'Set',
      'Okt',
      'Nob',
      'Dis',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'Ene',
      'Peb',
      'Mar',
      'Abr',
      'May',
      'Hun',
      'Hul',
      'Ago',
      'Set',
      'Okt',
      'Nob',
      'Dis',
    ],
    'WEEKDAYS': <dynamic>[
      'Linggo',
      'Lunes',
      'Martes',
      'Miyerkules',
      'Huwebes',
      'Biyernes',
      'Sabado',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'Linggo',
      'Lunes',
      'Martes',
      'Miyerkules',
      'Huwebes',
      'Biyernes',
      'Sabado',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'Lin',
      'Lun',
      'Mar',
      'Miy',
      'Huw',
      'Biy',
      'Sab',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'Lin',
      'Lun',
      'Mar',
      'Miy',
      'Huw',
      'Biy',
      'Sab',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'Lin',
      'Lun',
      'Mar',
      'Miy',
      'Huw',
      'Biy',
      'Sab',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'Lin',
      'Lun',
      'Mar',
      'Miy',
      'Huw',
      'Biy',
      'Sab',
    ],
    'SHORTQUARTERS': <dynamic>[
      'Q1',
      'Q2',
      'Q3',
      'Q4',
    ],
    'QUARTERS': <dynamic>[
      'ika-1 quarter',
      'ika-2 quarter',
      'ika-3 quarter',
      'ika-4 na quarter',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, MMMM d, y',
      'MMMM d, y',
      'MMM d, y',
      'M/d/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'h:mm:ss a zzzz',
      'h:mm:ss a z',
      'h:mm:ss a',
      'h:mm a',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} \'nang\' {0}',
      '{1} \'nang\' {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'tr': <String, dynamic>{
    'NAME': 'tr',
    'ERAS': <dynamic>[
      'MÖ',
      'MS',
    ],
    'ERANAMES': <dynamic>[
      'Milattan Önce',
      'Milattan Sonra',
    ],
    'NARROWMONTHS': <dynamic>[
      'O',
      'Ş',
      'M',
      'N',
      'M',
      'H',
      'T',
      'A',
      'E',
      'E',
      'K',
      'A',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'O',
      'Ş',
      'M',
      'N',
      'M',
      'H',
      'T',
      'A',
      'E',
      'E',
      'K',
      'A',
    ],
    'MONTHS': <dynamic>[
      'Ocak',
      'Şubat',
      'Mart',
      'Nisan',
      'Mayıs',
      'Haziran',
      'Temmuz',
      'Ağustos',
      'Eylül',
      'Ekim',
      'Kasım',
      'Aralık',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'Ocak',
      'Şubat',
      'Mart',
      'Nisan',
      'Mayıs',
      'Haziran',
      'Temmuz',
      'Ağustos',
      'Eylül',
      'Ekim',
      'Kasım',
      'Aralık',
    ],
    'SHORTMONTHS': <dynamic>[
      'Oca',
      'Şub',
      'Mar',
      'Nis',
      'May',
      'Haz',
      'Tem',
      'Ağu',
      'Eyl',
      'Eki',
      'Kas',
      'Ara',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'Oca',
      'Şub',
      'Mar',
      'Nis',
      'May',
      'Haz',
      'Tem',
      'Ağu',
      'Eyl',
      'Eki',
      'Kas',
      'Ara',
    ],
    'WEEKDAYS': <dynamic>[
      'Pazar',
      'Pazartesi',
      'Salı',
      'Çarşamba',
      'Perşembe',
      'Cuma',
      'Cumartesi',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'Pazar',
      'Pazartesi',
      'Salı',
      'Çarşamba',
      'Perşembe',
      'Cuma',
      'Cumartesi',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'Paz',
      'Pzt',
      'Sal',
      'Çar',
      'Per',
      'Cum',
      'Cmt',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'Paz',
      'Pzt',
      'Sal',
      'Çar',
      'Per',
      'Cum',
      'Cmt',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'P',
      'P',
      'S',
      'Ç',
      'P',
      'C',
      'C',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'P',
      'P',
      'S',
      'Ç',
      'P',
      'C',
      'C',
    ],
    'SHORTQUARTERS': <dynamic>[
      'Ç1',
      'Ç2',
      'Ç3',
      'Ç4',
    ],
    'QUARTERS': <dynamic>[
      '1. çeyrek',
      '2. çeyrek',
      '3. çeyrek',
      '4. çeyrek',
    ],
    'AMPMS': <dynamic>[
      'ÖÖ',
      'ÖS',
    ],
    'DATEFORMATS': <dynamic>[
      'd MMMM y EEEE',
      'd MMMM y',
      'd MMM y',
      'd.MM.y',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'uk': <String, dynamic>{
    'NAME': 'uk',
    'ERAS': <dynamic>[
      'до н. е.',
      'н. е.',
    ],
    'ERANAMES': <dynamic>[
      'до нашої ери',
      'нашої ери',
    ],
    'NARROWMONTHS': <dynamic>[
      'с',
      'л',
      'б',
      'к',
      'т',
      'ч',
      'л',
      'с',
      'в',
      'ж',
      'л',
      'г',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'С',
      'Л',
      'Б',
      'К',
      'Т',
      'Ч',
      'Л',
      'С',
      'В',
      'Ж',
      'Л',
      'Г',
    ],
    'MONTHS': <dynamic>[
      'січня',
      'лютого',
      'березня',
      'квітня',
      'травня',
      'червня',
      'липня',
      'серпня',
      'вересня',
      'жовтня',
      'листопада',
      'грудня',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'січень',
      'лютий',
      'березень',
      'квітень',
      'травень',
      'червень',
      'липень',
      'серпень',
      'вересень',
      'жовтень',
      'листопад',
      'грудень',
    ],
    'SHORTMONTHS': <dynamic>[
      'січ.',
      'лют.',
      'бер.',
      'квіт.',
      'трав.',
      'черв.',
      'лип.',
      'серп.',
      'вер.',
      'жовт.',
      'лист.',
      'груд.',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'січ',
      'лют',
      'бер',
      'кві',
      'тра',
      'чер',
      'лип',
      'сер',
      'вер',
      'жов',
      'лис',
      'гру',
    ],
    'WEEKDAYS': <dynamic>[
      'неділя',
      'понеділок',
      'вівторок',
      'середа',
      'четвер',
      'пʼятниця',
      'субота',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'неділя',
      'понеділок',
      'вівторок',
      'середа',
      'четвер',
      'пʼятниця',
      'субота',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'нд',
      'пн',
      'вт',
      'ср',
      'чт',
      'пт',
      'сб',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'нд',
      'пн',
      'вт',
      'ср',
      'чт',
      'пт',
      'сб',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'Н',
      'П',
      'В',
      'С',
      'Ч',
      'П',
      'С',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'Н',
      'П',
      'В',
      'С',
      'Ч',
      'П',
      'С',
    ],
    'SHORTQUARTERS': <dynamic>[
      '1-й кв.',
      '2-й кв.',
      '3-й кв.',
      '4-й кв.',
    ],
    'QUARTERS': <dynamic>[
      '1-й квартал',
      '2-й квартал',
      '3-й квартал',
      '4-й квартал',
    ],
    'AMPMS': <dynamic>[
      'дп',
      'пп',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d MMMM y \'р\'.',
      'd MMMM y \'р\'.',
      'd MMM y \'р\'.',
      'dd.MM.yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      '{1} \'о\' {0}',
      '{1} \'о\' {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'ur': <String, dynamic>{
    'NAME': 'ur',
    'ERAS': <dynamic>[
      'قبل مسیح',
      'عیسوی',
    ],
    'ERANAMES': <dynamic>[
      'قبل مسیح',
      'عیسوی',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'جنوری',
      'فروری',
      'مارچ',
      'اپریل',
      'مئی',
      'جون',
      'جولائی',
      'اگست',
      'ستمبر',
      'اکتوبر',
      'نومبر',
      'دسمبر',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'جنوری',
      'فروری',
      'مارچ',
      'اپریل',
      'مئی',
      'جون',
      'جولائی',
      'اگست',
      'ستمبر',
      'اکتوبر',
      'نومبر',
      'دسمبر',
    ],
    'SHORTMONTHS': <dynamic>[
      'جنوری',
      'فروری',
      'مارچ',
      'اپریل',
      'مئی',
      'جون',
      'جولائی',
      'اگست',
      'ستمبر',
      'اکتوبر',
      'نومبر',
      'دسمبر',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'جنوری',
      'فروری',
      'مارچ',
      'اپریل',
      'مئی',
      'جون',
      'جولائی',
      'اگست',
      'ستمبر',
      'اکتوبر',
      'نومبر',
      'دسمبر',
    ],
    'WEEKDAYS': <dynamic>[
      'اتوار',
      'پیر',
      'منگل',
      'بدھ',
      'جمعرات',
      'جمعہ',
      'ہفتہ',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'اتوار',
      'پیر',
      'منگل',
      'بدھ',
      'جمعرات',
      'جمعہ',
      'ہفتہ',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'اتوار',
      'پیر',
      'منگل',
      'بدھ',
      'جمعرات',
      'جمعہ',
      'ہفتہ',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'اتوار',
      'پیر',
      'منگل',
      'بدھ',
      'جمعرات',
      'جمعہ',
      'ہفتہ',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'W',
      'T',
      'F',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'T',
      'W',
      'T',
      'F',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      'پہلی سہ ماہی',
      'دوسری سہ ماہی',
      'تیسری سہ ماہی',
      'چوتهی سہ ماہی',
    ],
    'QUARTERS': <dynamic>[
      'پہلی سہ ماہی',
      'دوسری سہ ماہی',
      'تیسری سہ ماہی',
      'چوتهی سہ ماہی',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE، d MMMM، y',
      'd MMMM، y',
      'd MMM، y',
      'd/M/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'h:mm:ss a zzzz',
      'h:mm:ss a z',
      'h:mm:ss a',
      'h:mm a',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'uz': <String, dynamic>{
    'NAME': 'uz',
    'ERAS': <dynamic>[
      'm.a.',
      'milodiy',
    ],
    'ERANAMES': <dynamic>[
      'miloddan avvalgi',
      'milodiy',
    ],
    'NARROWMONTHS': <dynamic>[
      'Y',
      'F',
      'M',
      'A',
      'M',
      'I',
      'I',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'Y',
      'F',
      'M',
      'A',
      'M',
      'I',
      'I',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'yanvar',
      'fevral',
      'mart',
      'aprel',
      'may',
      'iyun',
      'iyul',
      'avgust',
      'sentabr',
      'oktabr',
      'noyabr',
      'dekabr',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'Yanvar',
      'Fevral',
      'Mart',
      'Aprel',
      'May',
      'Iyun',
      'Iyul',
      'Avgust',
      'Sentabr',
      'Oktabr',
      'Noyabr',
      'Dekabr',
    ],
    'SHORTMONTHS': <dynamic>[
      'yan',
      'fev',
      'mar',
      'apr',
      'may',
      'iyn',
      'iyl',
      'avg',
      'sen',
      'okt',
      'noy',
      'dek',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'Yan',
      'Fev',
      'Mar',
      'Apr',
      'May',
      'Iyn',
      'Iyl',
      'Avg',
      'Sen',
      'Okt',
      'Noy',
      'Dek',
    ],
    'WEEKDAYS': <dynamic>[
      'yakshanba',
      'dushanba',
      'seshanba',
      'chorshanba',
      'payshanba',
      'juma',
      'shanba',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'yakshanba',
      'dushanba',
      'seshanba',
      'chorshanba',
      'payshanba',
      'juma',
      'shanba',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'Yak',
      'Dush',
      'Sesh',
      'Chor',
      'Pay',
      'Jum',
      'Shan',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'Yak',
      'Dush',
      'Sesh',
      'Chor',
      'Pay',
      'Jum',
      'Shan',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'Y',
      'D',
      'S',
      'C',
      'P',
      'J',
      'S',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'Y',
      'D',
      'S',
      'C',
      'P',
      'J',
      'S',
    ],
    'SHORTQUARTERS': <dynamic>[
      '1-ch',
      '2-ch',
      '3-ch',
      '4-ch',
    ],
    'QUARTERS': <dynamic>[
      '1-chorak',
      '2-chorak',
      '3-chorak',
      '4-chorak',
    ],
    'AMPMS': <dynamic>[
      'TO',
      'TK',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d-MMMM, y',
      'd-MMMM, y',
      'd-MMM, y',
      'dd/MM/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'H:mm:ss (zzzz)',
      'H:mm:ss (z)',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      '{1}, {0}',
      '{1}, {0}',
      '{1}, {0}',
      '{1}, {0}',
    ],
  },
  'vi': <String, dynamic>{
    'NAME': 'vi',
    'ERAS': <dynamic>[
      'Trước CN',
      'sau CN',
    ],
    'ERANAMES': <dynamic>[
      'Trước CN',
      'sau CN',
    ],
    'NARROWMONTHS': <dynamic>[
      '1',
      '2',
      '3',
      '4',
      '5',
      '6',
      '7',
      '8',
      '9',
      '10',
      '11',
      '12',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      '1',
      '2',
      '3',
      '4',
      '5',
      '6',
      '7',
      '8',
      '9',
      '10',
      '11',
      '12',
    ],
    'MONTHS': <dynamic>[
      'tháng 1',
      'tháng 2',
      'tháng 3',
      'tháng 4',
      'tháng 5',
      'tháng 6',
      'tháng 7',
      'tháng 8',
      'tháng 9',
      'tháng 10',
      'tháng 11',
      'tháng 12',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'Tháng 1',
      'Tháng 2',
      'Tháng 3',
      'Tháng 4',
      'Tháng 5',
      'Tháng 6',
      'Tháng 7',
      'Tháng 8',
      'Tháng 9',
      'Tháng 10',
      'Tháng 11',
      'Tháng 12',
    ],
    'SHORTMONTHS': <dynamic>[
      'thg 1',
      'thg 2',
      'thg 3',
      'thg 4',
      'thg 5',
      'thg 6',
      'thg 7',
      'thg 8',
      'thg 9',
      'thg 10',
      'thg 11',
      'thg 12',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'Thg 1',
      'Thg 2',
      'Thg 3',
      'Thg 4',
      'Thg 5',
      'Thg 6',
      'Thg 7',
      'Thg 8',
      'Thg 9',
      'Thg 10',
      'Thg 11',
      'Thg 12',
    ],
    'WEEKDAYS': <dynamic>[
      'Chủ Nhật',
      'Thứ Hai',
      'Thứ Ba',
      'Thứ Tư',
      'Thứ Năm',
      'Thứ Sáu',
      'Thứ Bảy',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'Chủ Nhật',
      'Thứ Hai',
      'Thứ Ba',
      'Thứ Tư',
      'Thứ Năm',
      'Thứ Sáu',
      'Thứ Bảy',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'CN',
      'Th 2',
      'Th 3',
      'Th 4',
      'Th 5',
      'Th 6',
      'Th 7',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'CN',
      'Th 2',
      'Th 3',
      'Th 4',
      'Th 5',
      'Th 6',
      'Th 7',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'CN',
      'T2',
      'T3',
      'T4',
      'T5',
      'T6',
      'T7',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'CN',
      'T2',
      'T3',
      'T4',
      'T5',
      'T6',
      'T7',
    ],
    'SHORTQUARTERS': <dynamic>[
      'Q1',
      'Q2',
      'Q3',
      'Q4',
    ],
    'QUARTERS': <dynamic>[
      'Quý 1',
      'Quý 2',
      'Quý 3',
      'Quý 4',
    ],
    'AMPMS': <dynamic>[
      'SA',
      'CH',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, d MMMM, y',
      'd MMMM, y',
      'd MMM, y',
      'dd/MM/y',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 0,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 6,
    'DATETIMEFORMATS': <dynamic>[
      '{0} {1}',
      '{0} {1}',
      '{0}, {1}',
      '{0}, {1}',
    ],
  },
  'zh': <String, dynamic>{
    'NAME': 'zh',
    'ERAS': <dynamic>[
      '公元前',
      '公元',
    ],
    'ERANAMES': <dynamic>[
      '公元前',
      '公元',
    ],
    'NARROWMONTHS': <dynamic>[
      '1',
      '2',
      '3',
      '4',
      '5',
      '6',
      '7',
      '8',
      '9',
      '10',
      '11',
      '12',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      '1',
      '2',
      '3',
      '4',
      '5',
      '6',
      '7',
      '8',
      '9',
      '10',
      '11',
      '12',
    ],
    'MONTHS': <dynamic>[
      '一月',
      '二月',
      '三月',
      '四月',
      '五月',
      '六月',
      '七月',
      '八月',
      '九月',
      '十月',
      '十一月',
      '十二月',
    ],
    'STANDALONEMONTHS': <dynamic>[
      '一月',
      '二月',
      '三月',
      '四月',
      '五月',
      '六月',
      '七月',
      '八月',
      '九月',
      '十月',
      '十一月',
      '十二月',
    ],
    'SHORTMONTHS': <dynamic>[
      '1月',
      '2月',
      '3月',
      '4月',
      '5月',
      '6月',
      '7月',
      '8月',
      '9月',
      '10月',
      '11月',
      '12月',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      '1月',
      '2月',
      '3月',
      '4月',
      '5月',
      '6月',
      '7月',
      '8月',
      '9月',
      '10月',
      '11月',
      '12月',
    ],
    'WEEKDAYS': <dynamic>[
      '星期日',
      '星期一',
      '星期二',
      '星期三',
      '星期四',
      '星期五',
      '星期六',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      '星期日',
      '星期一',
      '星期二',
      '星期三',
      '星期四',
      '星期五',
      '星期六',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      '周日',
      '周一',
      '周二',
      '周三',
      '周四',
      '周五',
      '周六',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      '周日',
      '周一',
      '周二',
      '周三',
      '周四',
      '周五',
      '周六',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      '日',
      '一',
      '二',
      '三',
      '四',
      '五',
      '六',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      '日',
      '一',
      '二',
      '三',
      '四',
      '五',
      '六',
    ],
    'SHORTQUARTERS': <dynamic>[
      '1季度',
      '2季度',
      '3季度',
      '4季度',
    ],
    'QUARTERS': <dynamic>[
      '第一季度',
      '第二季度',
      '第三季度',
      '第四季度',
    ],
    'AMPMS': <dynamic>[
      '上午',
      '下午',
    ],
    'DATEFORMATS': <dynamic>[
      'y年M月d日EEEE',
      'y年M月d日',
      'y年M月d日',
      'y/M/d',
    ],
    'TIMEFORMATS': <dynamic>[
      'zzzz ah:mm:ss',
      'z ah:mm:ss',
      'ah:mm:ss',
      'ah:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'zh_HK': <String, dynamic>{
    'NAME': 'zh_HK',
    'ERAS': <dynamic>[
      '公元前',
      '公元',
    ],
    'ERANAMES': <dynamic>[
      '公元前',
      '公元',
    ],
    'NARROWMONTHS': <dynamic>[
      '1',
      '2',
      '3',
      '4',
      '5',
      '6',
      '7',
      '8',
      '9',
      '10',
      '11',
      '12',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      '1',
      '2',
      '3',
      '4',
      '5',
      '6',
      '7',
      '8',
      '9',
      '10',
      '11',
      '12',
    ],
    'MONTHS': <dynamic>[
      '1月',
      '2月',
      '3月',
      '4月',
      '5月',
      '6月',
      '7月',
      '8月',
      '9月',
      '10月',
      '11月',
      '12月',
    ],
    'STANDALONEMONTHS': <dynamic>[
      '1月',
      '2月',
      '3月',
      '4月',
      '5月',
      '6月',
      '7月',
      '8月',
      '9月',
      '10月',
      '11月',
      '12月',
    ],
    'SHORTMONTHS': <dynamic>[
      '1月',
      '2月',
      '3月',
      '4月',
      '5月',
      '6月',
      '7月',
      '8月',
      '9月',
      '10月',
      '11月',
      '12月',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      '1月',
      '2月',
      '3月',
      '4月',
      '5月',
      '6月',
      '7月',
      '8月',
      '9月',
      '10月',
      '11月',
      '12月',
    ],
    'WEEKDAYS': <dynamic>[
      '星期日',
      '星期一',
      '星期二',
      '星期三',
      '星期四',
      '星期五',
      '星期六',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      '星期日',
      '星期一',
      '星期二',
      '星期三',
      '星期四',
      '星期五',
      '星期六',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      '週日',
      '週一',
      '週二',
      '週三',
      '週四',
      '週五',
      '週六',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      '週日',
      '週一',
      '週二',
      '週三',
      '週四',
      '週五',
      '週六',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      '日',
      '一',
      '二',
      '三',
      '四',
      '五',
      '六',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      '日',
      '一',
      '二',
      '三',
      '四',
      '五',
      '六',
    ],
    'SHORTQUARTERS': <dynamic>[
      'Q1',
      'Q2',
      'Q3',
      'Q4',
    ],
    'QUARTERS': <dynamic>[
      '第1季',
      '第2季',
      '第3季',
      '第4季',
    ],
    'AMPMS': <dynamic>[
      '上午',
      '下午',
    ],
    'DATEFORMATS': <dynamic>[
      'y年M月d日EEEE',
      'y年M月d日',
      'y年M月d日',
      'd/M/y',
    ],
    'TIMEFORMATS': <dynamic>[
      'ah:mm:ss [zzzz]',
      'ah:mm:ss [z]',
      'ah:mm:ss',
      'ah:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'zh_TW': <String, dynamic>{
    'NAME': 'zh_TW',
    'ERAS': <dynamic>[
      '西元前',
      '西元',
    ],
    'ERANAMES': <dynamic>[
      '西元前',
      '西元',
    ],
    'NARROWMONTHS': <dynamic>[
      '1',
      '2',
      '3',
      '4',
      '5',
      '6',
      '7',
      '8',
      '9',
      '10',
      '11',
      '12',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      '1',
      '2',
      '3',
      '4',
      '5',
      '6',
      '7',
      '8',
      '9',
      '10',
      '11',
      '12',
    ],
    'MONTHS': <dynamic>[
      '1月',
      '2月',
      '3月',
      '4月',
      '5月',
      '6月',
      '7月',
      '8月',
      '9月',
      '10月',
      '11月',
      '12月',
    ],
    'STANDALONEMONTHS': <dynamic>[
      '1月',
      '2月',
      '3月',
      '4月',
      '5月',
      '6月',
      '7月',
      '8月',
      '9月',
      '10月',
      '11月',
      '12月',
    ],
    'SHORTMONTHS': <dynamic>[
      '1月',
      '2月',
      '3月',
      '4月',
      '5月',
      '6月',
      '7月',
      '8月',
      '9月',
      '10月',
      '11月',
      '12月',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      '1月',
      '2月',
      '3月',
      '4月',
      '5月',
      '6月',
      '7月',
      '8月',
      '9月',
      '10月',
      '11月',
      '12月',
    ],
    'WEEKDAYS': <dynamic>[
      '星期日',
      '星期一',
      '星期二',
      '星期三',
      '星期四',
      '星期五',
      '星期六',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      '星期日',
      '星期一',
      '星期二',
      '星期三',
      '星期四',
      '星期五',
      '星期六',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      '週日',
      '週一',
      '週二',
      '週三',
      '週四',
      '週五',
      '週六',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      '週日',
      '週一',
      '週二',
      '週三',
      '週四',
      '週五',
      '週六',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      '日',
      '一',
      '二',
      '三',
      '四',
      '五',
      '六',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      '日',
      '一',
      '二',
      '三',
      '四',
      '五',
      '六',
    ],
    'SHORTQUARTERS': <dynamic>[
      '第1季',
      '第2季',
      '第3季',
      '第4季',
    ],
    'QUARTERS': <dynamic>[
      '第1季',
      '第2季',
      '第3季',
      '第4季',
    ],
    'AMPMS': <dynamic>[
      '上午',
      '下午',
    ],
    'DATEFORMATS': <dynamic>[
      'y年M月d日 EEEE',
      'y年M月d日',
      'y年M月d日',
      'y/M/d',
    ],
    'TIMEFORMATS': <dynamic>[
      'ah:mm:ss [zzzz]',
      'ah:mm:ss [z]',
      'ah:mm:ss',
      'ah:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
  'zu': <String, dynamic>{
    'NAME': 'zu',
    'ERAS': <dynamic>[
      'BC',
      'AD',
    ],
    'ERANAMES': <dynamic>[
      'BC',
      'AD',
    ],
    'NARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'E',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'STANDALONENARROWMONTHS': <dynamic>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    'MONTHS': <dynamic>[
      'Januwari',
      'Februwari',
      'Mashi',
      'Ephreli',
      'Meyi',
      'Juni',
      'Julayi',
      'Agasti',
      'Septhemba',
      'Okthoba',
      'Novemba',
      'Disemba',
    ],
    'STANDALONEMONTHS': <dynamic>[
      'Januwari',
      'Februwari',
      'Mashi',
      'Ephreli',
      'Meyi',
      'Juni',
      'Julayi',
      'Agasti',
      'Septhemba',
      'Okthoba',
      'Novemba',
      'Disemba',
    ],
    'SHORTMONTHS': <dynamic>[
      'Jan',
      'Feb',
      'Mas',
      'Eph',
      'Mey',
      'Jun',
      'Jul',
      'Aga',
      'Sep',
      'Okt',
      'Nov',
      'Dis',
    ],
    'STANDALONESHORTMONTHS': <dynamic>[
      'Jan',
      'Feb',
      'Mas',
      'Eph',
      'Mey',
      'Jun',
      'Jul',
      'Aga',
      'Sep',
      'Okt',
      'Nov',
      'Dis',
    ],
    'WEEKDAYS': <dynamic>[
      'ISonto',
      'UMsombuluko',
      'ULwesibili',
      'ULwesithathu',
      'ULwesine',
      'ULwesihlanu',
      'UMgqibelo',
    ],
    'STANDALONEWEEKDAYS': <dynamic>[
      'ISonto',
      'UMsombuluko',
      'ULwesibili',
      'ULwesithathu',
      'ULwesine',
      'ULwesihlanu',
      'UMgqibelo',
    ],
    'SHORTWEEKDAYS': <dynamic>[
      'Son',
      'Mso',
      'Bil',
      'Tha',
      'Sin',
      'Hla',
      'Mgq',
    ],
    'STANDALONESHORTWEEKDAYS': <dynamic>[
      'Son',
      'Mso',
      'Bil',
      'Tha',
      'Sin',
      'Hla',
      'Mgq',
    ],
    'NARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'B',
      'T',
      'S',
      'H',
      'M',
    ],
    'STANDALONENARROWWEEKDAYS': <dynamic>[
      'S',
      'M',
      'B',
      'T',
      'S',
      'H',
      'M',
    ],
    'SHORTQUARTERS': <dynamic>[
      'Q1',
      'Q2',
      'Q3',
      'Q4',
    ],
    'QUARTERS': <dynamic>[
      'ikota yesi-1',
      'ikota yesi-2',
      'ikota yesi-3',
      'ikota yesi-4',
    ],
    'AMPMS': <dynamic>[
      'AM',
      'PM',
    ],
    'DATEFORMATS': <dynamic>[
      'EEEE, MMMM d, y',
      'MMMM d, y',
      'MMM d, y',
      'M/d/yy',
    ],
    'TIMEFORMATS': <dynamic>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    'AVAILABLEFORMATS': null,
    'FIRSTDAYOFWEEK': 6,
    'WEEKENDRANGE': <dynamic>[
      5,
      6,
    ],
    'FIRSTWEEKCUTOFFDAY': 5,
    'DATETIMEFORMATS': <dynamic>[
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
      '{1} {0}',
    ],
  },
};

/// The subset of date patterns supported by the intl package which are also
/// supported by flutter_localizations.
const Map<String, Map<String, String>> datePatterns =
    <String, Map<String, String>>{
  'af': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'dd-MM',
    'MEd': 'EEE d/M',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'MM-y',
    'yMd': 'y-MM-dd',
    'yMEd': 'EEE y-MM-dd',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'EEE d MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM y',
    'yMMMMEEEEd': 'EEEE d MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'am': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'M/d',
    'MEd': 'EEE፣ M/d',
    'MMM': 'LLL',
    'MMMd': 'MMM d',
    'MMMEd': 'EEE፣ MMM d',
    'MMMM': 'LLLL',
    'MMMMd': 'MMMM d',
    'MMMMEEEEd': 'EEEE፣ MMMM d',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'd/M/y',
    'yMEd': 'EEE፣ d/M/y',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'EEE፣ MMM d y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM y',
    'yMMMMEEEEd': 'y MMMM d, EEEE',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'H',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'h a',
    'jm': 'h:mm a',
    'jms': 'h:mm:ss a',
    'jmv': 'h:mm a v',
    'jmz': 'h:mm a z',
    'jz': 'h a z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'ar': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd/‏M',
    'MEd': 'EEE، d/M',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE، d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE، d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M‏/y',
    'yMd': 'd‏/M‏/y',
    'yMEd': 'EEE، d/‏M/‏y',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'EEE، d MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM y',
    'yMMMMEEEEd': 'EEEE، d MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'h a',
    'jm': 'h:mm a',
    'jms': 'h:mm:ss a',
    'jmv': 'h:mm a v',
    'jmz': 'h:mm a z',
    'jz': 'h a z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'az': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'dd.MM',
    'MEd': 'dd.MM, EEE',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'd MMM, EEE',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'd MMMM, EEEE',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'MM.y',
    'yMd': 'dd.MM.y',
    'yMEd': 'dd.MM.y, EEE',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'd MMM y, EEE',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM y',
    'yMMMMEEEEd': 'd MMMM y, EEEE',
    'yQQQ': 'y QQQ',
    'yQQQQ': 'y QQQQ',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'be': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd.M',
    'MEd': 'EEE, d.M',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE, d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE, d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M.y',
    'yMd': 'd.M.y',
    'yMEd': 'EEE, d.M.y',
    'yMMM': 'LLL y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'EEE, d MMM y',
    'yMMMM': 'LLLL y',
    'yMMMMd': 'd MMMM y \'г\'.',
    'yMMMMEEEEd': 'EEEE, d MMMM y \'г\'.',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm.ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'bg': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd.MM',
    'MEd': 'EEE, d.MM',
    'MMM': 'MM',
    'MMMd': 'd.MM',
    'MMMEd': 'EEE, d.MM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE, d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y \'г\'.',
    'yM': 'MM.y \'г\'.',
    'yMd': 'd.MM.y \'г\'.',
    'yMEd': 'EEE, d.MM.y \'г\'.',
    'yMMM': 'MM.y \'г\'.',
    'yMMMd': 'd.MM.y \'г\'.',
    'yMMMEd': 'EEE, d.MM.y \'г\'.',
    'yMMMM': 'MMMM y \'г\'.',
    'yMMMMd': 'd MMMM y \'г\'.',
    'yMMMMEEEEd': 'EEEE, d MMMM y \'г\'.',
    'yQQQ': 'QQQ y \'г\'.',
    'yQQQQ': 'QQQQ y \'г\'.',
    'H': 'H \'ч\'.',
    'Hm': 'H:mm \'ч\'.',
    'Hms': 'H:mm:ss \'ч\'.',
    'j': 'H \'ч\'.',
    'jm': 'H:mm \'ч\'.',
    'jms': 'H:mm:ss \'ч\'.',
    'jmv': 'HH:mm \'ч\'. v',
    'jmz': 'HH:mm \'ч\'. z',
    'jz': 'H \'ч\'. z',
    'm': 'm',
    'ms': 'm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'bn': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd/M',
    'MEd': 'EEE, d-M',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'd/M/y',
    'yMEd': 'EEE, d/M/y',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM, y',
    'yMMMEd': 'EEE, d MMM, y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM, y',
    'yMMMMEEEEd': 'EEEE, d MMMM, y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'h a',
    'jm': 'h:mm a',
    'jms': 'h:mm:ss a',
    'jmv': 'h:mm a v',
    'jmz': 'h:mm a z',
    'jz': 'h a z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'bs': <String, String>{
    'd': 'd.',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd.M.',
    'MEd': 'EEE, d.M.',
    'MMM': 'LLL',
    'MMMd': 'd. MMM',
    'MMMEd': 'EEE, d. MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd. MMMM',
    'MMMMEEEEd': 'EEEE, d. MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y.',
    'yM': 'MM/y',
    'yMd': 'd.M.y.',
    'yMEd': 'EEE, d.M.y.',
    'yMMM': 'MMM y.',
    'yMMMd': 'd. MMM y.',
    'yMMMEd': 'EEE, d. MMM y.',
    'yMMMM': 'LLLL y.',
    'yMMMMd': 'd. MMMM y.',
    'yMMMMEEEEd': 'EEEE, d. MMMM y.',
    'yQQQ': 'QQQ y.',
    'yQQQQ': 'QQQQ y.',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm (v)',
    'jmz': 'HH:mm (z)',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'ca': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd/M',
    'MEd': 'EEE d/M',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE, d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE, d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'd/M/y',
    'yMEd': 'EEE, d/M/y',
    'yMMM': 'LLL \'de\' y',
    'yMMMd': 'd MMM \'de\' y',
    'yMMMEd': 'EEE, d MMM y',
    'yMMMM': 'LLLL \'de\' y',
    'yMMMMd': 'd MMMM \'de\' y',
    'yMMMMEEEEd': 'EEEE, d MMMM \'de\' y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'H',
    'Hm': 'H:mm',
    'Hms': 'H:mm:ss',
    'j': 'H',
    'jm': 'H:mm',
    'jms': 'H:mm:ss',
    'jmv': 'H:mm v',
    'jmz': 'H:mm z',
    'jz': 'H z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'cs': <String, String>{
    'd': 'd.',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd. M.',
    'MEd': 'EEE d. M.',
    'MMM': 'LLL',
    'MMMd': 'd. M.',
    'MMMEd': 'EEE d. M.',
    'MMMM': 'LLLL',
    'MMMMd': 'd. MMMM',
    'MMMMEEEEd': 'EEEE d. MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'd. M. y',
    'yMEd': 'EEE d. M. y',
    'yMMM': 'LLLL y',
    'yMMMd': 'd. M. y',
    'yMMMEd': 'EEE d. M. y',
    'yMMMM': 'LLLL y',
    'yMMMMd': 'd. MMMM y',
    'yMMMMEEEEd': 'EEEE d. MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'H',
    'Hm': 'H:mm',
    'Hms': 'H:mm:ss',
    'j': 'H',
    'jm': 'H:mm',
    'jms': 'H:mm:ss',
    'jmv': 'H:mm v',
    'jmz': 'H:mm z',
    'jz': 'H z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'da': <String, String>{
    'd': 'd.',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'MMM',
    'LLLL': 'MMMM',
    'M': 'M',
    'Md': 'd.M',
    'MEd': 'EEE d.M',
    'MMM': 'MMM',
    'MMMd': 'd. MMM',
    'MMMEd': 'EEE d. MMM',
    'MMMM': 'MMMM',
    'MMMMd': 'd. MMMM',
    'MMMMEEEEd': 'EEEE d. MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M.y',
    'yMd': 'd.M.y',
    'yMEd': 'EEE d.M.y',
    'yMMM': 'MMM y',
    'yMMMd': 'd. MMM y',
    'yMMMEd': 'EEE d. MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd. MMMM y',
    'yMMMMEEEEd': 'EEEE \'den\' d. MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH.mm',
    'Hms': 'HH.mm.ss',
    'j': 'HH',
    'jm': 'HH.mm',
    'jms': 'HH.mm.ss',
    'jmv': 'HH.mm v',
    'jmz': 'HH.mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm.ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'de': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd.M.',
    'MEd': 'EEE, d.M.',
    'MMM': 'LLL',
    'MMMd': 'd. MMM',
    'MMMEd': 'EEE, d. MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd. MMMM',
    'MMMMEEEEd': 'EEEE, d. MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M.y',
    'yMd': 'd.M.y',
    'yMEd': 'EEE, d.M.y',
    'yMMM': 'MMM y',
    'yMMMd': 'd. MMM y',
    'yMMMEd': 'EEE, d. MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd. MMMM y',
    'yMMMMEEEEd': 'EEEE, d. MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH \'Uhr\'',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH \'Uhr\'',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH \'Uhr\' z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'de_CH': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd.M.',
    'MEd': 'EEE, d.M.',
    'MMM': 'LLL',
    'MMMd': 'd. MMM',
    'MMMEd': 'EEE, d. MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd. MMMM',
    'MMMMEEEEd': 'EEEE, d. MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M.y',
    'yMd': 'd.M.y',
    'yMEd': 'EEE, d.M.y',
    'yMMM': 'MMM y',
    'yMMMd': 'd. MMM y',
    'yMMMEd': 'EEE, d. MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd. MMMM y',
    'yMMMMEEEEd': 'EEEE, d. MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH \'Uhr\'',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH \'Uhr\'',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH \'Uhr\' z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'el': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'MMM',
    'LLLL': 'MMMM',
    'M': 'L',
    'Md': 'd/M',
    'MEd': 'EEE, d/M',
    'MMM': 'MMM',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE, d MMM',
    'MMMM': 'MMMM',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE, d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'd/M/y',
    'yMEd': 'EEE, d/M/y',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'EEE, d MMM y',
    'yMMMM': 'LLLL y',
    'yMMMMd': 'd MMMM y',
    'yMMMMEEEEd': 'EEEE, d MMMM y',
    'yQQQ': 'y QQQ',
    'yQQQQ': 'y QQQQ',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'h a',
    'jm': 'h:mm a',
    'jms': 'h:mm:ss a',
    'jmv': 'h:mm a v',
    'jmz': 'h:mm a z',
    'jz': 'h a z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'en': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'M/d',
    'MEd': 'EEE, M/d',
    'MMM': 'LLL',
    'MMMd': 'MMM d',
    'MMMEd': 'EEE, MMM d',
    'MMMM': 'LLLL',
    'MMMMd': 'MMMM d',
    'MMMMEEEEd': 'EEEE, MMMM d',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'M/d/y',
    'yMEd': 'EEE, M/d/y',
    'yMMM': 'MMM y',
    'yMMMd': 'MMM d, y',
    'yMMMEd': 'EEE, MMM d, y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'MMMM d, y',
    'yMMMMEEEEd': 'EEEE, MMMM d, y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'h a',
    'jm': 'h:mm a',
    'jms': 'h:mm:ss a',
    'jmv': 'h:mm a v',
    'jmz': 'h:mm a z',
    'jz': 'h a z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'en_AU': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd/M',
    'MEd': 'EEE, d/M',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE, d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE, d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'MM/y',
    'yMd': 'dd/MM/y',
    'yMEd': 'EEE, dd/MM/y',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'EEE, d MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM y',
    'yMMMMEEEEd': 'EEEE, d MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'h a',
    'jm': 'h:mm a',
    'jms': 'h:mm:ss a',
    'jmv': 'h:mm a v',
    'jmz': 'h:mm a z',
    'jz': 'h a z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'en_CA': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'MM-dd',
    'MEd': 'EEE, MM-dd',
    'MMM': 'LLL',
    'MMMd': 'MMM d',
    'MMMEd': 'EEE, MMM d',
    'MMMM': 'LLLL',
    'MMMMd': 'MMMM d',
    'MMMMEEEEd': 'EEEE, MMMM d',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'y-MM',
    'yMd': 'y-MM-dd',
    'yMEd': 'EEE, y-MM-dd',
    'yMMM': 'MMM y',
    'yMMMd': 'MMM d, y',
    'yMMMEd': 'EEE, MMM d, y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'MMMM d, y',
    'yMMMMEEEEd': 'EEEE, MMMM d, y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'h a',
    'jm': 'h:mm a',
    'jms': 'h:mm:ss a',
    'jmv': 'h:mm a v',
    'jmz': 'h:mm a z',
    'jz': 'h a z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'en_GB': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'dd/MM',
    'MEd': 'EEE, dd/MM',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE, d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE, d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'MM/y',
    'yMd': 'dd/MM/y',
    'yMEd': 'EEE, dd/MM/y',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'EEE, d MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM y',
    'yMMMMEEEEd': 'EEEE, d MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'en_IE': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd/M',
    'MEd': 'EEE, d/M',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE, d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE, d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'MM/y',
    'yMd': 'd/M/y',
    'yMEd': 'EEE, d/M/y',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'EEE d MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM y',
    'yMMMMEEEEd': 'EEEE d MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'en_IN': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'dd/MM',
    'MEd': 'EEE, dd/MM',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE, d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE, d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'MM/y',
    'yMd': 'd/M/y',
    'yMEd': 'EEE, d/M/y',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'EEE, d MMM, y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM y',
    'yMMMMEEEEd': 'EEEE, d MMMM, y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'h a',
    'jm': 'h:mm a',
    'jms': 'h:mm:ss a',
    'jmv': 'h:mm a v',
    'jmz': 'h:mm a z',
    'jz': 'h a z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'en_SG': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'dd/MM',
    'MEd': 'EEE, dd/MM',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE, d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE, d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'MM/y',
    'yMd': 'dd/MM/y',
    'yMEd': 'EEE, dd/MM/y',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'EEE, d MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM y',
    'yMMMMEEEEd': 'EEEE, d MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'h a',
    'jm': 'h:mm a',
    'jms': 'h:mm:ss a',
    'jmv': 'h:mm a v',
    'jmz': 'h:mm a z',
    'jz': 'h a z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'en_US': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'M/d',
    'MEd': 'EEE, M/d',
    'MMM': 'LLL',
    'MMMd': 'MMM d',
    'MMMEd': 'EEE, MMM d',
    'MMMM': 'LLLL',
    'MMMMd': 'MMMM d',
    'MMMMEEEEd': 'EEEE, MMMM d',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'M/d/y',
    'yMEd': 'EEE, M/d/y',
    'yMMM': 'MMM y',
    'yMMMd': 'MMM d, y',
    'yMMMEd': 'EEE, MMM d, y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'MMMM d, y',
    'yMMMMEEEEd': 'EEEE, MMMM d, y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'h a',
    'jm': 'h:mm a',
    'jms': 'h:mm:ss a',
    'jmv': 'h:mm a v',
    'jmz': 'h:mm a z',
    'jz': 'h a z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'en_ZA': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'MM/dd',
    'MEd': 'EEE, MM/dd',
    'MMM': 'LLL',
    'MMMd': 'dd MMM',
    'MMMEd': 'EEE, dd MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE, dd MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'MM/y',
    'yMd': 'y/MM/dd',
    'yMEd': 'EEE, y/MM/dd',
    'yMMM': 'MMM y',
    'yMMMd': 'dd MMM y',
    'yMMMEd': 'EEE, dd MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM y',
    'yMMMMEEEEd': 'EEEE, d MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'es': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd/M',
    'MEd': 'EEE, d/M',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE, d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd \'de\' MMMM',
    'MMMMEEEEd': 'EEEE, d \'de\' MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'd/M/y',
    'yMEd': 'EEE, d/M/y',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'EEE, d MMM y',
    'yMMMM': 'MMMM \'de\' y',
    'yMMMMd': 'd \'de\' MMMM \'de\' y',
    'yMMMMEEEEd': 'EEEE, d \'de\' MMMM \'de\' y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ \'de\' y',
    'H': 'H',
    'Hm': 'H:mm',
    'Hms': 'H:mm:ss',
    'j': 'H',
    'jm': 'H:mm',
    'jms': 'H:mm:ss',
    'jmv': 'H:mm v',
    'jmz': 'H:mm z',
    'jz': 'H z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'es_419': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd/M',
    'MEd': 'EEE, d/M',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE, d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd \'de\' MMMM',
    'MMMMEEEEd': 'EEEE, d \'de\' MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'd/M/y',
    'yMEd': 'EEE d/M/y',
    'yMMM': 'MMMM \'de\' y',
    'yMMMd': 'd \'de\' MMMM \'de\' y',
    'yMMMEd': 'EEE, d \'de\' MMM \'de\' y',
    'yMMMM': 'MMMM \'de\' y',
    'yMMMMd': 'd \'de\' MMMM \'de\' y',
    'yMMMMEEEEd': 'EEEE, d \'de\' MMMM \'de\' y',
    'yQQQ': 'QQQ \'de\' y',
    'yQQQQ': 'QQQQ \'de\' y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'H:mm v',
    'jmz': 'H:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'es_MX': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd/M',
    'MEd': 'EEE, d/M',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE d \'de\' MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd \'de\' MMMM',
    'MMMMEEEEd': 'EEEE, d \'de\' MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'd/M/y',
    'yMEd': 'EEE, d/M/y',
    'yMMM': 'MMMM \'de\' y',
    'yMMMd': 'd \'de\' MMMM \'de\' y',
    'yMMMEd': 'EEE, d \'de\' MMMM \'de\' y',
    'yMMMM': 'MMMM \'de\' y',
    'yMMMMd': 'd \'de\' MMMM \'de\' y',
    'yMMMMEEEEd': 'EEEE, d \'de\' MMMM \'de\' y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ \'de\' y',
    'H': 'HH',
    'Hm': 'H:mm',
    'Hms': 'H:mm:ss',
    'j': 'HH',
    'jm': 'H:mm',
    'jms': 'H:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'es_US': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd/M',
    'MEd': 'EEE, d/M',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE, d \'de\' MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd \'de\' MMMM',
    'MMMMEEEEd': 'EEEE, d \'de\' MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'd/M/y',
    'yMEd': 'EEE, d/M/y',
    'yMMM': 'MMMM \'de\' y',
    'yMMMd': 'd \'de\' MMMM \'de\' y',
    'yMMMEd': 'EEE, d \'de\' MMMM \'de\' y',
    'yMMMM': 'MMMM \'de\' y',
    'yMMMMd': 'd \'de\' MMMM \'de\' y',
    'yMMMMEEEEd': 'EEEE, d \'de\' MMMM \'de\' y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ \'de\' y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'h a',
    'jm': 'h:mm a',
    'jms': 'h:mm:ss a',
    'jmv': 'h:mm a v',
    'jmz': 'h:mm a z',
    'jz': 'h a z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'et': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'MMMM',
    'LLLL': 'MMMM',
    'M': 'M',
    'Md': 'd.M',
    'MEd': 'EEE, d.M',
    'MMM': 'MMMM',
    'MMMd': 'd. MMM',
    'MMMEd': 'EEE, d. MMM',
    'MMMM': 'MMMM',
    'MMMMd': 'd. MMMM',
    'MMMMEEEEd': 'EEEE, d. MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M.y',
    'yMd': 'd.M.y',
    'yMEd': 'EEE, d.M.y',
    'yMMM': 'MMM y',
    'yMMMd': 'd. MMM y',
    'yMMMEd': 'EEE, d. MMMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd. MMMM y',
    'yMMMMEEEEd': 'EEEE, d. MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'eu': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'M/d',
    'MEd': 'M/d, EEE',
    'MMM': 'LLL',
    'MMMd': 'MMM d',
    'MMMEd': 'MMM d, EEE',
    'MMMM': 'LLLL',
    'MMMMd': 'MMMM d',
    'MMMMEEEEd': 'MMMM d, EEEE',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'y/M',
    'yMd': 'y/M/d',
    'yMEd': 'y/M/d, EEE',
    'yMMM': 'y MMM',
    'yMMMd': 'y MMM d',
    'yMMMEd': 'y MMM d, EEE',
    'yMMMM': 'y(\'e\')\'ko\' MMMM',
    'yMMMMd': 'y(\'e\')\'ko\' MMMM\'ren\' d',
    'yMMMMEEEEd': 'y(\'e\')\'ko\' MMMM\'ren\' d(\'a\'), EEEE',
    'yQQQ': 'y(\'e\')\'ko\' QQQ',
    'yQQQQ': 'y(\'e\')\'ko\' QQQQ',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH (z)',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'fa': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'M/d',
    'MEd': 'EEE M/d',
    'MMM': 'LLL',
    'MMMd': 'd LLL',
    'MMMEd': 'EEE d LLL',
    'MMMM': 'LLLL',
    'MMMMd': 'd LLLL',
    'MMMMEEEEd': 'EEEE d LLLL',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'y/M',
    'yMd': 'y/M/d',
    'yMEd': 'EEE y/M/d',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'EEE d MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM y',
    'yMMMMEEEEd': 'EEEE d MMMM y',
    'yQQQ': 'QQQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'H',
    'Hm': 'H:mm',
    'Hms': 'H:mm:ss',
    'j': 'H',
    'jm': 'H:mm',
    'jms': 'H:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm (z)',
    'jz': 'H (z)',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'fi': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd.M.',
    'MEd': 'EEE d.M.',
    'MMM': 'LLL',
    'MMMd': 'd. MMM',
    'MMMEd': 'ccc d. MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd. MMMM',
    'MMMMEEEEd': 'cccc d. MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'L.y',
    'yMd': 'd.M.y',
    'yMEd': 'EEE d.M.y',
    'yMMM': 'LLL y',
    'yMMMd': 'd. MMM y',
    'yMMMEd': 'EEE d. MMM y',
    'yMMMM': 'LLLL y',
    'yMMMMd': 'd. MMMM y',
    'yMMMMEEEEd': 'EEEE d. MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'H',
    'Hm': 'H.mm',
    'Hms': 'H.mm.ss',
    'j': 'H',
    'jm': 'H.mm',
    'jms': 'H.mm.ss',
    'jmv': 'H.mm v',
    'jmz': 'H.mm z',
    'jz': 'H z',
    'm': 'm',
    'ms': 'm.ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'fil': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'M/d',
    'MEd': 'EEE, M/d',
    'MMM': 'LLL',
    'MMMd': 'MMM d',
    'MMMEd': 'EEE, MMM d',
    'MMMM': 'LLLL',
    'MMMMd': 'MMMM d',
    'MMMMEEEEd': 'EEEE, MMMM d',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'M/d/y',
    'yMEd': 'EEE, M/d/y',
    'yMMM': 'MMM y',
    'yMMMd': 'MMM d, y',
    'yMMMEd': 'EEE, MMM d, y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'MMMM d, y',
    'yMMMMEEEEd': 'EEEE, MMMM d, y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'h a',
    'jm': 'h:mm a',
    'jms': 'h:mm:ss a',
    'jmv': 'h:mm a v',
    'jmz': 'h:mm a z',
    'jz': 'h a z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'fr': <String, String>{
    'd': 'd',
    'E': 'EEE',
    'EEEE': 'EEEE',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'dd/MM',
    'MEd': 'EEE dd/MM',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'MM/y',
    'yMd': 'dd/MM/y',
    'yMEd': 'EEE dd/MM/y',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'EEE d MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM y',
    'yMMMMEEEEd': 'EEEE d MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH \'h\'',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH \'h\'',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH \'h\' z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'fr_CA': <String, String>{
    'd': 'd',
    'E': 'EEE',
    'EEEE': 'EEEE',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'M-d',
    'MEd': 'EEE M-d',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'y-MM',
    'yMd': 'y-MM-dd',
    'yMEd': 'EEE y-MM-dd',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'EEE d MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM y',
    'yMMMMEEEEd': 'EEEE d MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH \'h\'',
    'Hm': 'HH \'h\' mm',
    'Hms': 'HH \'h\' mm \'min\' ss \'s\'',
    'j': 'HH \'h\'',
    'jm': 'HH \'h\' mm',
    'jms': 'HH \'h\' mm \'min\' ss \'s\'',
    'jmv': 'HH \'h\' mm v',
    'jmz': 'HH \'h\' mm z',
    'jz': 'HH \'h\' z',
    'm': 'm',
    'ms': 'mm \'min\' ss \'s\'',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'gl': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd/M',
    'MEd': 'EEE, d/M',
    'MMM': 'LLL',
    'MMMd': 'd \'de\' MMM',
    'MMMEd': 'EEE, d \'de\' MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd \'de\' MMMM',
    'MMMMEEEEd': 'EEEE, d \'de\' MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'd/M/y',
    'yMEd': 'EEE, d/M/y',
    'yMMM': 'MMM \'de\' y',
    'yMMMd': 'd/MM/y',
    'yMMMEd': 'EEE, d/MM/y',
    'yMMMM': 'MMMM \'de\' y',
    'yMMMMd': 'd \'de\' MMMM \'de\' y',
    'yMMMMEEEEd': 'EEEE, d \'de\' MMMM \'de\' y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ \'de\' y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'gsw': <String, String>{
    'd': 'd',
    'E': 'EEE',
    'EEEE': 'EEEE',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd.M.',
    'MEd': 'EEE, d.M.',
    'MMM': 'LLL',
    'MMMd': 'd. MMM',
    'MMMEd': 'EEE d. MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd. MMMM',
    'MMMMEEEEd': 'EEEE d. MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'y-M',
    'yMd': 'd.M.y',
    'yMEd': 'EEE, y-M-d',
    'yMMM': 'MMM y',
    'yMMMd': 'y MMM d',
    'yMMMEd': 'EEE, d. MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd. MMMM y',
    'yMMMMEEEEd': 'EEEE, d. MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'H',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'H',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'H z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'gu': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd/M',
    'MEd': 'EEE, d/M',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE, d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE, d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'd/M/y',
    'yMEd': 'EEE, d/M/y',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM, y',
    'yMMMEd': 'EEE, d MMM, y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM, y',
    'yMMMMEEEEd': 'EEEE, d MMMM, y',
    'yQQQ': 'y QQQ',
    'yQQQQ': 'y QQQQ',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'h a',
    'jm': 'h:mm a',
    'jms': 'h:mm:ss a',
    'jmv': 'h:mm a v',
    'jmz': 'h:mm a z',
    'jz': 'h a z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'he': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd.M',
    'MEd': 'EEE, d.M',
    'MMM': 'LLL',
    'MMMd': 'd בMMM',
    'MMMEd': 'EEE, d בMMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd בMMMM',
    'MMMMEEEEd': 'EEEE, d בMMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M.y',
    'yMd': 'd.M.y',
    'yMEd': 'EEE, d.M.y',
    'yMMM': 'MMM y',
    'yMMMd': 'd בMMM y',
    'yMMMEd': 'EEE, d בMMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd בMMMM y',
    'yMMMMEEEEd': 'EEEE, d בMMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'H',
    'Hm': 'H:mm',
    'Hms': 'H:mm:ss',
    'j': 'H',
    'jm': 'H:mm',
    'jms': 'H:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'H z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'hi': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd/M',
    'MEd': 'EEE, d/M',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE, d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE, d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'd/M/y',
    'yMEd': 'EEE, d/M/y',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'EEE, d MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM y',
    'yMMMMEEEEd': 'EEEE, d MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'h a',
    'jm': 'h:mm a',
    'jms': 'h:mm:ss a',
    'jmv': 'h:mm a v',
    'jmz': 'h:mm a z',
    'jz': 'h a z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'hr': <String, String>{
    'd': 'd.',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L.',
    'Md': 'dd. MM.',
    'MEd': 'EEE, dd. MM.',
    'MMM': 'LLL',
    'MMMd': 'd. MMM',
    'MMMEd': 'EEE, d. MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd. MMMM',
    'MMMMEEEEd': 'EEEE, d. MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y.',
    'yM': 'MM. y.',
    'yMd': 'dd. MM. y.',
    'yMEd': 'EEE, dd. MM. y.',
    'yMMM': 'LLL y.',
    'yMMMd': 'd. MMM y.',
    'yMMMEd': 'EEE, d. MMM y.',
    'yMMMM': 'LLLL y.',
    'yMMMMd': 'd. MMMM y.',
    'yMMMMEEEEd': 'EEEE, d. MMMM y.',
    'yQQQ': 'QQQ y.',
    'yQQQQ': 'QQQQ y.',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH (z)',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'hu': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'M. d.',
    'MEd': 'M. d., EEE',
    'MMM': 'LLL',
    'MMMd': 'MMM d.',
    'MMMEd': 'MMM d., EEE',
    'MMMM': 'LLLL',
    'MMMMd': 'MMMM d.',
    'MMMMEEEEd': 'MMMM d., EEEE',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y.',
    'yM': 'y. M.',
    'yMd': 'y. MM. dd.',
    'yMEd': 'y. MM. dd., EEE',
    'yMMM': 'y. MMM',
    'yMMMd': 'y. MMM d.',
    'yMMMEd': 'y. MMM d., EEE',
    'yMMMM': 'y. MMMM',
    'yMMMMd': 'y. MMMM d.',
    'yMMMMEEEEd': 'y. MMMM d., EEEE',
    'yQQQ': 'y. QQQ',
    'yQQQQ': 'y. QQQQ',
    'H': 'H',
    'Hm': 'H:mm',
    'Hms': 'H:mm:ss',
    'j': 'H',
    'jm': 'H:mm',
    'jms': 'H:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'H z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'hy': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'dd.MM',
    'MEd': 'dd.MM, EEE',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'd MMM, EEE',
    'MMMM': 'LLLL',
    'MMMMd': 'MMMM d',
    'MMMMEEEEd': 'd MMMM, EEEE',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'MM.y',
    'yMd': 'dd.MM.y',
    'yMEd': 'd.MM.y թ., EEE',
    'yMMM': 'y թ. LLL',
    'yMMMd': 'd MMM, y թ.',
    'yMMMEd': 'y թ. MMM d, EEE',
    'yMMMM': 'y թ․ LLLL',
    'yMMMMd': 'd MMMM, y թ.',
    'yMMMMEEEEd': 'y թ. MMMM d, EEEE',
    'yQQQ': 'y թ. QQQ',
    'yQQQQ': 'y թ. QQQQ',
    'H': 'H',
    'Hm': 'H:mm',
    'Hms': 'H:mm:ss',
    'j': 'H',
    'jm': 'H:mm',
    'jms': 'H:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'H z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'id': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd/M',
    'MEd': 'EEE, d/M',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE, d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE, d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'd/M/y',
    'yMEd': 'EEE, d/M/y',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'EEE, d MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM y',
    'yMMMMEEEEd': 'EEEE, d MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH.mm',
    'Hms': 'HH.mm.ss',
    'j': 'HH',
    'jm': 'HH.mm',
    'jms': 'HH.mm.ss',
    'jmv': 'HH.mm v',
    'jmz': 'HH.mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm.ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'is': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd.M.',
    'MEd': 'EEE, d.M.',
    'MMM': 'LLL',
    'MMMd': 'd. MMM',
    'MMMEd': 'EEE, d. MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd. MMMM',
    'MMMMEEEEd': 'EEEE, d. MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M. y',
    'yMd': 'd.M.y',
    'yMEd': 'EEE, d.M.y',
    'yMMM': 'MMM y',
    'yMMMd': 'd. MMM y',
    'yMMMEd': 'EEE, d. MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd. MMMM y',
    'yMMMMEEEEd': 'EEEE, d. MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'v – HH:mm',
    'jmz': 'z – HH:mm',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'it': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd/M',
    'MEd': 'EEE d/M',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'd/M/y',
    'yMEd': 'EEE d/M/y',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'EEE d MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM y',
    'yMMMMEEEEd': 'EEEE d MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'ja': <String, String>{
    'd': 'd日',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'M月',
    'LLLL': 'M月',
    'M': 'M月',
    'Md': 'M/d',
    'MEd': 'M/d(EEE)',
    'MMM': 'M月',
    'MMMd': 'M月d日',
    'MMMEd': 'M月d日(EEE)',
    'MMMM': 'M月',
    'MMMMd': 'M月d日',
    'MMMMEEEEd': 'M月d日EEEE',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y年',
    'yM': 'y/M',
    'yMd': 'y/M/d',
    'yMEd': 'y/M/d(EEE)',
    'yMMM': 'y年M月',
    'yMMMd': 'y年M月d日',
    'yMMMEd': 'y年M月d日(EEE)',
    'yMMMM': 'y年M月',
    'yMMMMd': 'y年M月d日',
    'yMMMMEEEEd': 'y年M月d日EEEE',
    'yQQQ': 'y/QQQ',
    'yQQQQ': 'y年QQQQ',
    'H': 'H時',
    'Hm': 'H:mm',
    'Hms': 'H:mm:ss',
    'j': 'H時',
    'jm': 'H:mm',
    'jms': 'H:mm:ss',
    'jmv': 'H:mm v',
    'jmz': 'H:mm z',
    'jz': 'H時 z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'ka': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd.M',
    'MEd': 'EEE, d.M',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE, d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE, d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M.y',
    'yMd': 'd.M.y',
    'yMEd': 'EEE, d.M.y',
    'yMMM': 'MMM. y',
    'yMMMd': 'd MMM. y',
    'yMMMEd': 'EEE, d MMM. y',
    'yMMMM': 'MMMM, y',
    'yMMMMd': 'd MMMM, y',
    'yMMMMEEEEd': 'EEEE, d MMMM, y',
    'yQQQ': 'QQQ, y',
    'yQQQQ': 'QQQQ, y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'kk': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'dd.MM',
    'MEd': 'dd.MM, EEE',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'd MMM, EEE',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'd MMMM, EEEE',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'MM.y',
    'yMd': 'dd.MM.y',
    'yMEd': 'dd.MM.y, EEE',
    'yMMM': 'y \'ж\'. MMM',
    'yMMMd': 'y \'ж\'. d MMM',
    'yMMMEd': 'y \'ж\'. d MMM, EEE',
    'yMMMM': 'y \'ж\'. MMMM',
    'yMMMMd': 'y \'ж\'. d MMMM',
    'yMMMMEEEEd': 'y \'ж\'. d MMMM, EEEE',
    'yQQQ': 'y \'ж\'. QQQ',
    'yQQQQ': 'y \'ж\'. QQQQ',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'km': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd/M',
    'MEd': 'EEE d/M',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'MMMM d',
    'MMMMEEEEd': 'EEEE d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'd/M/y',
    'yMEd': 'EEE d/M/y',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'EEE d MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM y',
    'yMMMMEEEEd': 'EEEE d MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'h a',
    'jm': 'h:mm a',
    'jms': 'h:mm:ss a',
    'jmv': 'h:mm a v',
    'jmz': 'h:mm a z',
    'jz': 'h a z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'kn': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd/M',
    'MEd': 'd/M, EEE',
    'MMM': 'LLL',
    'MMMd': 'MMM d',
    'MMMEd': 'EEE, d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE, d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'd/M/y',
    'yMEd': 'EEE, M/d/y',
    'yMMM': 'MMM y',
    'yMMMd': 'MMM d,y',
    'yMMMEd': 'EEE, MMM d, y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'MMMM d, y',
    'yMMMMEEEEd': 'EEEE, MMMM d, y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'h a',
    'jm': 'h:mm a',
    'jms': 'h:mm:ss a',
    'jmv': 'h:mm a v',
    'jmz': 'h:mm a z',
    'jz': 'h a z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'ko': <String, String>{
    'd': 'd일',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'M월',
    'Md': 'M. d.',
    'MEd': 'M. d. (EEE)',
    'MMM': 'LLL',
    'MMMd': 'MMM d일',
    'MMMEd': 'MMM d일 (EEE)',
    'MMMM': 'LLLL',
    'MMMMd': 'MMMM d일',
    'MMMMEEEEd': 'MMMM d일 EEEE',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y년',
    'yM': 'y. M.',
    'yMd': 'y. M. d.',
    'yMEd': 'y. M. d. (EEE)',
    'yMMM': 'y년 MMM',
    'yMMMd': 'y년 MMM d일',
    'yMMMEd': 'y년 MMM d일 (EEE)',
    'yMMMM': 'y년 MMMM',
    'yMMMMd': 'y년 MMMM d일',
    'yMMMMEEEEd': 'y년 MMMM d일 EEEE',
    'yQQQ': 'y년 QQQ',
    'yQQQQ': 'y년 QQQQ',
    'H': 'H시',
    'Hm': 'HH:mm',
    'Hms': 'H시 m분 s초',
    'j': 'a h시',
    'jm': 'a h:mm',
    'jms': 'a h:mm:ss',
    'jmv': 'a h:mm v',
    'jmz': 'a h:mm z',
    'jz': 'a h시 z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'ky': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'dd-MM',
    'MEd': 'dd-MM, EEE',
    'MMM': 'LLL',
    'MMMd': 'd-MMM',
    'MMMEd': 'd-MMM, EEE',
    'MMMM': 'LLLL',
    'MMMMd': 'd-MMMM',
    'MMMMEEEEd': 'd-MMMM, EEEE',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'y-MM',
    'yMd': 'y-dd-MM',
    'yMEd': 'y-dd-MM, EEE',
    'yMMM': 'y-\'ж\'. MMM',
    'yMMMd': 'y-\'ж\'. d-MMM',
    'yMMMEd': 'y-\'ж\'. d-MMM, EEE',
    'yMMMM': 'y-\'ж\'., MMMM',
    'yMMMMd': 'y-\'ж\'., d-MMMM',
    'yMMMMEEEEd': 'y-\'ж\'., d-MMMM, EEEE',
    'yQQQ': 'y-\'ж\'., QQQ',
    'yQQQQ': 'y-\'ж\'., QQQQ',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'lo': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd/M',
    'MEd': 'EEE, d/M',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'MMMM d',
    'MMMMEEEEd': 'EEEE d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'd/M/y',
    'yMEd': 'EEE, d/M/y',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'EEE, d MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM y',
    'yMMMMEEEEd': 'EEEE, d MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'lt': <String, String>{
    'd': 'dd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'MM',
    'Md': 'MM-d',
    'MEd': 'MM-dd, EEE',
    'MMM': 'MM',
    'MMMd': 'MM-dd',
    'MMMEd': 'MM-dd, EEE',
    'MMMM': 'LLLL',
    'MMMMd': 'MMMM d \'d\'.',
    'MMMMEEEEd': 'MMMM d \'d\'., EEEE',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'y-MM',
    'yMd': 'y-MM-dd',
    'yMEd': 'y-MM-dd, EEE',
    'yMMM': 'y-MM',
    'yMMMd': 'y-MM-dd',
    'yMMMEd': 'y-MM-dd, EEE',
    'yMMMM': 'y \'m\'. LLLL',
    'yMMMMd': 'y \'m\'. MMMM d \'d\'.',
    'yMMMMEEEEd': 'y \'m\'. MMMM d \'d\'., EEEE',
    'yQQQ': 'y QQQ',
    'yQQQQ': 'y QQQQ',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm; v',
    'jmz': 'HH:mm; z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'lv': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'dd.MM.',
    'MEd': 'EEE, dd.MM.',
    'MMM': 'LLL',
    'MMMd': 'd. MMM',
    'MMMEd': 'EEE, d. MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd. MMMM',
    'MMMMEEEEd': 'EEEE, d. MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y. \'g\'.',
    'yM': 'MM.y.',
    'yMd': 'y.MM.d.',
    'yMEd': 'EEE, d.M.y.',
    'yMMM': 'y. \'g\'. MMM',
    'yMMMd': 'y. \'g\'. d. MMM',
    'yMMMEd': 'EEE, y. \'g\'. d. MMM',
    'yMMMM': 'y. \'g\'. MMMM',
    'yMMMMd': 'y. \'gada\' d. MMMM',
    'yMMMMEEEEd': 'EEEE, y. \'gada\' d. MMMM',
    'yQQQ': 'y. \'g\'. QQQ',
    'yQQQQ': 'y. \'g\'. QQQQ',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'mk': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd.M',
    'MEd': 'EEE, d.M',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE, d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE, d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M.y',
    'yMd': 'd.M.y',
    'yMEd': 'EEE, d.M.y',
    'yMMM': 'MMM y \'г\'.',
    'yMMMd': 'd MMM y \'г\'.',
    'yMMMEd': 'EEE, d MMM y \'г\'.',
    'yMMMM': 'MMMM y \'г\'.',
    'yMMMMd': 'd MMMM y',
    'yMMMMEEEEd': 'EEEE, d MMMM y',
    'yQQQ': 'QQQ y \'г\'.',
    'yQQQQ': 'QQQQ y \'г\'.',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'ml': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd/M',
    'MEd': 'd/M, EEE',
    'MMM': 'LLL',
    'MMMd': 'MMM d',
    'MMMEd': 'MMM d, EEE',
    'MMMM': 'LLLL',
    'MMMMd': 'MMMM d',
    'MMMMEEEEd': 'MMMM d, EEEE',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'y-MM',
    'yMd': 'd/M/y',
    'yMEd': 'd-M-y, EEE',
    'yMMM': 'y MMM',
    'yMMMd': 'y MMM d',
    'yMMMEd': 'y MMM d, EEE',
    'yMMMM': 'y MMMM',
    'yMMMMd': 'y, MMMM d',
    'yMMMMEEEEd': 'y, MMMM d, EEEE',
    'yQQQ': 'y QQQ',
    'yQQQQ': 'y QQQQ',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'h a',
    'jm': 'h:mm a',
    'jms': 'h:mm:ss a',
    'jmv': 'h:mm a v',
    'jmz': 'h:mm a z',
    'jz': 'h a z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'mn': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'LLLLL',
    'Md': 'MMMMM/dd',
    'MEd': 'MMMMM/dd. EEE',
    'MMM': 'LLL',
    'MMMd': 'MMM\'ын\' d',
    'MMMEd': 'MMM\'ын\' d. EEE',
    'MMMM': 'LLLL',
    'MMMMd': 'MMMM\'ын\' d',
    'MMMMEEEEd': 'MMMM\'ын\' d. EEEE',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'y MMMMM',
    'yMd': 'y.MM.dd',
    'yMEd': 'y.MM.dd. EEE',
    'yMMM': 'y \'оны\' MMM',
    'yMMMd': 'y \'оны\' MMM\'ын\' d',
    'yMMMEd': 'y \'оны\' MMM\'ын\' d. EEE',
    'yMMMM': 'y \'оны\' MMMM',
    'yMMMMd': 'y \'оны\' MMMM\'ын\' d',
    'yMMMMEEEEd': 'y \'оны\' MMMM\'ын\' d. EEEE',
    'yQQQ': 'y \'оны\' QQQ',
    'yQQQQ': 'y \'оны\' QQQQ',
    'H': 'HH \'ц\'',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH \'ц\'',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm (v)',
    'jmz': 'HH:mm (z)',
    'jz': 'HH \'ц\' (z)',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'mr': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd/M',
    'MEd': 'EEE, d/M',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE, d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE, d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'd/M/y',
    'yMEd': 'EEE, d/M/y',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM, y',
    'yMMMEd': 'EEE, d, MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM, y',
    'yMMMMEEEEd': 'EEEE, d MMMM, y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'H:mm',
    'Hms': 'H:mm:ss',
    'j': 'h a',
    'jm': 'h:mm a',
    'jms': 'h:mm:ss a',
    'jmv': 'h:mm a v',
    'jmz': 'h:mm a z',
    'jz': 'h a z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'ms': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd-M',
    'MEd': 'EEE, d-M',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE, d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE, d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M-y',
    'yMd': 'd/M/y',
    'yMEd': 'EEE, d/M/y',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'EEE, d MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM y',
    'yMMMMEEEEd': 'EEEE, d MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'h a',
    'jm': 'h:mm a',
    'jms': 'h:mm:ss a',
    'jmv': 'h:mm a v',
    'jmz': 'h:mm a z',
    'jz': 'h a z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'my': <String, String>{
    'd': 'd',
    'E': 'cccနေ့',
    'EEEE': 'ccccနေ့',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd/M',
    'MEd': 'd/M၊ EEE',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'MMM d၊ EEE',
    'MMMM': 'LLLL',
    'MMMMd': 'MMMM d',
    'MMMMEEEEd': 'MMMM d ရက် EEEEနေ့',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'dd-MM-y',
    'yMEd': 'd/M/y၊ EEE',
    'yMMM': 'MMM y',
    'yMMMd': 'y၊ MMM d',
    'yMMMEd': 'y၊ MMM d၊ EEE',
    'yMMMM': 'y MMMM',
    'yMMMMd': 'y၊ d MMMM',
    'yMMMMEEEEd': 'y၊ MMMM d၊ EEEE',
    'yQQQ': 'y QQQ',
    'yQQQQ': 'y QQQQ',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'v HH:mm',
    'jmz': 'z HH:mm',
    'jz': 'z HH',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'nb': <String, String>{
    'd': 'd.',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L.',
    'Md': 'd.M.',
    'MEd': 'EEE d.M.',
    'MMM': 'LLL',
    'MMMd': 'd. MMM',
    'MMMEd': 'EEE d. MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd. MMMM',
    'MMMMEEEEd': 'EEEE d. MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M.y',
    'yMd': 'd.M.y',
    'yMEd': 'EEE d.MM.y',
    'yMMM': 'MMM y',
    'yMMMd': 'd. MMM y',
    'yMMMEd': 'EEE d. MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd. MMMM y',
    'yMMMMEEEEd': 'EEEE d. MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'ne': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'MM-dd',
    'MEd': 'MM-dd, EEE',
    'MMM': 'LLL',
    'MMMd': 'MMM d',
    'MMMEd': 'MMM d, EEE',
    'MMMM': 'LLLL',
    'MMMMd': 'MMMM d',
    'MMMMEEEEd': 'MMMM d, EEEE',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'y-MM',
    'yMd': 'y-MM-dd',
    'yMEd': 'y-MM-dd, EEE',
    'yMMM': 'y MMM',
    'yMMMd': 'y MMM d',
    'yMMMEd': 'y MMM d, EEE',
    'yMMMM': 'y MMMM',
    'yMMMMd': 'y MMMM d',
    'yMMMMEEEEd': 'y MMMM d, EEEE',
    'yQQQ': 'y QQQ',
    'yQQQQ': 'y QQQQ',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'nl': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd-M',
    'MEd': 'EEE d-M',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M-y',
    'yMd': 'd-M-y',
    'yMEd': 'EEE d-M-y',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'EEE d MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM y',
    'yMMMMEEEEd': 'EEEE d MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'no': <String, String>{
    'd': 'd.',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L.',
    'Md': 'd.M.',
    'MEd': 'EEE d.M.',
    'MMM': 'LLL',
    'MMMd': 'd. MMM',
    'MMMEd': 'EEE d. MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd. MMMM',
    'MMMMEEEEd': 'EEEE d. MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M.y',
    'yMd': 'd.M.y',
    'yMEd': 'EEE d.MM.y',
    'yMMM': 'MMM y',
    'yMMMd': 'd. MMM y',
    'yMMMEd': 'EEE d. MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd. MMMM y',
    'yMMMMEEEEd': 'EEEE d. MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'or': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'M/d',
    'MEd': 'EEE, M/d',
    'MMM': 'LLL',
    'MMMd': 'MMM d',
    'MMMEd': 'EEE, MMM d',
    'MMMM': 'LLLL',
    'MMMMd': 'MMMM d',
    'MMMMEEEEd': 'EEEE, MMMM d',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'M/d/y',
    'yMEd': 'EEE, M/d/y',
    'yMMM': 'MMM y',
    'yMMMd': 'MMM d, y',
    'yMMMEd': 'EEE, MMM d, y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'MMMM d, y',
    'yMMMMEEEEd': 'EEEE, MMMM d, y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'h a',
    'jm': 'h:mm a',
    'jms': 'h:mm:ss a',
    'jmv': 'h:mm a v',
    'jmz': 'h:mm a z',
    'jz': 'h a z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'pa': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd/M',
    'MEd': 'EEE, dd-MM.',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE, d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'MMMM d',
    'MMMMEEEEd': 'EEEE, d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'd/M/y',
    'yMEd': 'EEE, d/M/y',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'EEE, d MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM y',
    'yMMMMEEEEd': 'EEEE, d MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'h a',
    'jm': 'h:mm a',
    'jms': 'h:mm:ss a',
    'jmv': 'h:mm a v',
    'jmz': 'h:mm a z',
    'jz': 'h a z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'pl': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd.MM',
    'MEd': 'EEE, d.MM',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE, d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE, d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'MM.y',
    'yMd': 'd.MM.y',
    'yMEd': 'EEE, d.MM.y',
    'yMMM': 'LLL y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'EEE, d MMM y',
    'yMMMM': 'LLLL y',
    'yMMMMd': 'd MMMM y',
    'yMMMMEEEEd': 'EEEE, d MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'ps': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'MM-dd',
    'MEd': 'MM-dd, EEE',
    'MMM': 'LLL',
    'MMMd': 'MMM d',
    'MMMEd': 'MMM d, EEE',
    'MMMM': 'LLLL',
    'MMMMd': 'MMMM d',
    'MMMMEEEEd': 'MMMM d, EEEE',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'y-MM',
    'yMd': 'y-MM-dd',
    'yMEd': 'y-MM-dd, EEE',
    'yMMM': 'y MMM',
    'yMMMd': 'y MMM d',
    'yMMMEd': 'y MMM d, EEE',
    'yMMMM': 'y MMMM',
    'yMMMMd': 'د y د MMMM d',
    'yMMMMEEEEd': 'EEEE د y د MMMM d',
    'yQQQ': 'y QQQ',
    'yQQQQ': 'y QQQQ',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH (z)',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'pt': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd/M',
    'MEd': 'EEE, dd/MM',
    'MMM': 'LLL',
    'MMMd': 'd \'de\' MMM',
    'MMMEd': 'EEE, d \'de\' MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd \'de\' MMMM',
    'MMMMEEEEd': 'EEEE, d \'de\' MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'MM/y',
    'yMd': 'dd/MM/y',
    'yMEd': 'EEE, dd/MM/y',
    'yMMM': 'MMM \'de\' y',
    'yMMMd': 'd \'de\' MMM \'de\' y',
    'yMMMEd': 'EEE, d \'de\' MMM \'de\' y',
    'yMMMM': 'MMMM \'de\' y',
    'yMMMMd': 'd \'de\' MMMM \'de\' y',
    'yMMMMEEEEd': 'EEEE, d \'de\' MMMM \'de\' y',
    'yQQQ': 'QQQ \'de\' y',
    'yQQQQ': 'QQQQ \'de\' y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'pt_PT': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'dd/MM',
    'MEd': 'EEE, dd/MM',
    'MMM': 'LLL',
    'MMMd': 'd/MM',
    'MMMEd': 'EEE, d/MM',
    'MMMM': 'LLLL',
    'MMMMd': 'd \'de\' MMMM',
    'MMMMEEEEd': 'cccc, d \'de\' MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'MM/y',
    'yMd': 'dd/MM/y',
    'yMEd': 'EEE, dd/MM/y',
    'yMMM': 'MM/y',
    'yMMMd': 'd/MM/y',
    'yMMMEd': 'EEE, d/MM/y',
    'yMMMM': 'MMMM \'de\' y',
    'yMMMMd': 'd \'de\' MMMM \'de\' y',
    'yMMMMEEEEd': 'EEEE, d \'de\' MMMM \'de\' y',
    'yQQQ': 'QQQQ \'de\' y',
    'yQQQQ': 'QQQQ \'de\' y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'ro': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'dd.MM',
    'MEd': 'EEE, dd.MM',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE, d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE, d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'MM.y',
    'yMd': 'dd.MM.y',
    'yMEd': 'EEE, dd.MM.y',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'EEE, d MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM y',
    'yMMMMEEEEd': 'EEEE, d MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'ru': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'dd.MM',
    'MEd': 'EEE, dd.MM',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'ccc, d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'cccc, d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'MM.y',
    'yMd': 'dd.MM.y',
    'yMEd': 'ccc, dd.MM.y \'г\'.',
    'yMMM': 'LLL y \'г\'.',
    'yMMMd': 'd MMM y \'г\'.',
    'yMMMEd': 'EEE, d MMM y \'г\'.',
    'yMMMM': 'LLLL y \'г\'.',
    'yMMMMd': 'd MMMM y \'г\'.',
    'yMMMMEEEEd': 'EEEE, d MMMM y \'г\'.',
    'yQQQ': 'QQQ y \'г\'.',
    'yQQQQ': 'QQQQ y \'г\'.',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'si': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'M-d',
    'MEd': 'M-d, EEE',
    'MMM': 'LLL',
    'MMMd': 'MMM d',
    'MMMEd': 'MMM d EEE',
    'MMMM': 'LLLL',
    'MMMMd': 'MMMM d',
    'MMMMEEEEd': 'MMMM d EEEE',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'y-M',
    'yMd': 'y-M-d',
    'yMEd': 'y-M-d, EEE',
    'yMMM': 'y MMM',
    'yMMMd': 'y MMM d',
    'yMMMEd': 'y MMM d, EEE',
    'yMMMM': 'y MMMM',
    'yMMMMd': 'y MMMM d',
    'yMMMMEEEEd': 'y MMMM d, EEEE',
    'yQQQ': 'y QQQ',
    'yQQQQ': 'y QQQQ',
    'H': 'HH',
    'Hm': 'HH.mm',
    'Hms': 'HH.mm.ss',
    'j': 'HH',
    'jm': 'HH.mm',
    'jms': 'HH.mm.ss',
    'jmv': 'HH.mm v',
    'jmz': 'HH.mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm.ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'sk': <String, String>{
    'd': 'd.',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L.',
    'Md': 'd. M.',
    'MEd': 'EEE d. M.',
    'MMM': 'LLL',
    'MMMd': 'd. M.',
    'MMMEd': 'EEE d. M.',
    'MMMM': 'LLLL',
    'MMMMd': 'd. MMMM',
    'MMMMEEEEd': 'EEEE d. MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'd. M. y',
    'yMEd': 'EEE d. M. y',
    'yMMM': 'M/y',
    'yMMMd': 'd. M. y',
    'yMMMEd': 'EEE d. M. y',
    'yMMMM': 'LLLL y',
    'yMMMMd': 'd. MMMM y',
    'yMMMMEEEEd': 'EEEE d. MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'H',
    'Hm': 'H:mm',
    'Hms': 'H:mm:ss',
    'j': 'H',
    'jm': 'H:mm',
    'jms': 'H:mm:ss',
    'jmv': 'H:mm v',
    'jmz': 'H:mm z',
    'jz': 'H z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'sl': <String, String>{
    'd': 'd.',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd. M.',
    'MEd': 'EEE, d. M.',
    'MMM': 'LLL',
    'MMMd': 'd. MMM',
    'MMMEd': 'EEE, d. MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd. MMMM',
    'MMMMEEEEd': 'EEEE, d. MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'd. M. y',
    'yMEd': 'EEE, d. M. y',
    'yMMM': 'MMM y',
    'yMMMd': 'd. MMM y',
    'yMMMEd': 'EEE, d. MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd. MMMM y',
    'yMMMMEEEEd': 'EEEE, d. MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH\'h\'',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH\'h\'',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH\'h\' z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'sq': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd.M',
    'MEd': 'EEE, d.M',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE, d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE, d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M.y',
    'yMd': 'd.M.y',
    'yMEd': 'EEE, d.M.y',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'EEE, d MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM y',
    'yMMMMEEEEd': 'EEEE, d MMMM y',
    'yQQQ': 'QQQ, y',
    'yQQQQ': 'QQQQ, y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'h a',
    'jm': 'h:mm a',
    'jms': 'h:mm:ss a',
    'jmv': 'h:mm a, v',
    'jmz': 'h:mm a, z',
    'jz': 'h a, z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'sr': <String, String>{
    'd': 'd',
    'E': 'EEE',
    'EEEE': 'EEEE',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd.M.',
    'MEd': 'EEE, d.M.',
    'MMM': 'LLL',
    'MMMd': 'd. MMM',
    'MMMEd': 'EEE d. MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd. MMMM',
    'MMMMEEEEd': 'EEEE, d. MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y.',
    'yM': 'M.y.',
    'yMd': 'd.M.y.',
    'yMEd': 'EEE, d.M.y.',
    'yMMM': 'MMM y.',
    'yMMMd': 'd. MMM y.',
    'yMMMEd': 'EEE, d. MMM y.',
    'yMMMM': 'MMMM y.',
    'yMMMMd': 'd. MMMM y.',
    'yMMMMEEEEd': 'EEEE, d. MMMM y.',
    'yQQQ': 'QQQ y.',
    'yQQQQ': 'QQQQ y.',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'sr_Latn': <String, String>{
    'd': 'd',
    'E': 'EEE',
    'EEEE': 'EEEE',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd.M.',
    'MEd': 'EEE, d.M.',
    'MMM': 'LLL',
    'MMMd': 'd. MMM',
    'MMMEd': 'EEE d. MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd. MMMM',
    'MMMMEEEEd': 'EEEE, d. MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y.',
    'yM': 'M.y.',
    'yMd': 'd.M.y.',
    'yMEd': 'EEE, d.M.y.',
    'yMMM': 'MMM y.',
    'yMMMd': 'd. MMM y.',
    'yMMMEd': 'EEE, d. MMM y.',
    'yMMMM': 'MMMM y.',
    'yMMMMd': 'd. MMMM y.',
    'yMMMMEEEEd': 'EEEE, d. MMMM y.',
    'yQQQ': 'QQQ y.',
    'yQQQQ': 'QQQQ y.',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'sv': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd/M',
    'MEd': 'EEE d/M',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'y-MM',
    'yMd': 'y-MM-dd',
    'yMEd': 'EEE, y-MM-dd',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'EEE d MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM y',
    'yMMMMEEEEd': 'EEEE d MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'sw': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd/M',
    'MEd': 'EEE, d/M',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE, d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE, d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'd/M/y',
    'yMEd': 'EEE, d/M/y',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'EEE, MMM d, y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM y',
    'yMMMMEEEEd': 'EEEE, d MMMM y',
    'yQQQ': 'y QQQ',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'ta': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd/M',
    'MEd': 'dd-MM, EEE',
    'MMM': 'LLL',
    'MMMd': 'MMM d',
    'MMMEd': 'MMM d, EEE',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'MMMM d, EEEE',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'd/M/y',
    'yMEd': 'EEE, d/M/y',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM, y',
    'yMMMEd': 'EEE, d MMM, y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM, y',
    'yMMMMEEEEd': 'EEEE, d MMMM, y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'a h',
    'jm': 'a h:mm',
    'jms': 'a h:mm:ss',
    'jmv': 'a h:mm v',
    'jmz': 'a h:mm z',
    'jz': 'a h z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'te': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd/M',
    'MEd': 'd/M, EEE',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'd MMM, EEE',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'd MMMM, EEEE',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'd/M/y',
    'yMEd': 'd/M/y, EEE',
    'yMMM': 'MMM y',
    'yMMMd': 'd, MMM y',
    'yMMMEd': 'd MMM, y, EEE',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM, y',
    'yMMMMEEEEd': 'd, MMMM y, EEEE',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'h a',
    'jm': 'h:mm a',
    'jms': 'h:mm:ss a',
    'jmv': 'h:mm a v',
    'jmz': 'h:mm a z',
    'jz': 'h a z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'th': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd/M',
    'MEd': 'EEE d/M',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEEที่ d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'd/M/y',
    'yMEd': 'EEE d/M/y',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'EEE d MMM y',
    'yMMMM': 'MMMM G y',
    'yMMMMd': 'd MMMM G y',
    'yMMMMEEEEd': 'EEEEที่ d MMMM G y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ G y',
    'H': 'HH',
    'Hm': 'HH:mm น.',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm น.',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'tl': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'M/d',
    'MEd': 'EEE, M/d',
    'MMM': 'LLL',
    'MMMd': 'MMM d',
    'MMMEd': 'EEE, MMM d',
    'MMMM': 'LLLL',
    'MMMMd': 'MMMM d',
    'MMMMEEEEd': 'EEEE, MMMM d',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'M/d/y',
    'yMEd': 'EEE, M/d/y',
    'yMMM': 'MMM y',
    'yMMMd': 'MMM d, y',
    'yMMMEd': 'EEE, MMM d, y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'MMMM d, y',
    'yMMMMEEEEd': 'EEEE, MMMM d, y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'h a',
    'jm': 'h:mm a',
    'jms': 'h:mm:ss a',
    'jmv': 'h:mm a v',
    'jmz': 'h:mm a z',
    'jz': 'h a z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'tr': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd/M',
    'MEd': 'd/MM EEE',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'd MMMM EEE',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'd MMMM EEEE',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'MM/y',
    'yMd': 'dd.MM.y',
    'yMEd': 'd.M.y EEE',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'd MMM y EEE',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM y',
    'yMMMMEEEEd': 'd MMMM y EEEE',
    'yQQQ': 'y QQQ',
    'yQQQQ': 'y QQQQ',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'uk': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'LL',
    'Md': 'dd.MM',
    'MEd': 'EEE, dd.MM',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE, d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE, d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'MM.y',
    'yMd': 'dd.MM.y',
    'yMEd': 'EEE, dd.MM.y',
    'yMMM': 'LLL y',
    'yMMMd': 'd MMM y',
    'yMMMEd': 'EEE, d MMM y',
    'yMMMM': 'LLLL y',
    'yMMMMd': 'd MMMM y \'р\'.',
    'yMMMMEEEEd': 'EEEE, d MMMM y \'р\'.',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y \'р\'.',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'ur': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'd/M',
    'MEd': 'EEE، d/M',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE، d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE، d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'd/M/y',
    'yMEd': 'EEE، d/M/y',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM، y',
    'yMMMEd': 'EEE، d MMM، y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd MMMM، y',
    'yMMMMEEEEd': 'EEEE، d MMMM، y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'h a',
    'jm': 'h:mm a',
    'jms': 'h:mm:ss a',
    'jmv': 'h:mm a v',
    'jmz': 'h:mm a z',
    'jz': 'h a z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'uz': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'LL',
    'Md': 'dd/MM',
    'MEd': 'EEE, dd/MM',
    'MMM': 'LLL',
    'MMMd': 'd-MMM',
    'MMMEd': 'EEE, d-MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd-MMMM',
    'MMMMEEEEd': 'EEEE, d-MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'MM.y',
    'yMd': 'dd/MM/y',
    'yMEd': 'EEE, dd/MM/y',
    'yMMM': 'MMM, y',
    'yMMMd': 'd-MMM, y',
    'yMMMEd': 'EEE, d-MMM, y',
    'yMMMM': 'MMMM, y',
    'yMMMMd': 'd-MMMM, y',
    'yMMMMEEEEd': 'EEEE, d-MMMM, y',
    'yQQQ': 'y, QQQ',
    'yQQQQ': 'y, QQQQ',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm (v)',
    'jmz': 'HH:mm (z)',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'vi': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'dd/M',
    'MEd': 'EEE, dd/M',
    'MMM': 'LLL',
    'MMMd': 'd MMM',
    'MMMEd': 'EEE, d MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd MMMM',
    'MMMMEEEEd': 'EEEE, d MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'd/M/y',
    'yMEd': 'EEE, dd/M/y',
    'yMMM': 'MMM y',
    'yMMMd': 'd MMM, y',
    'yMMMEd': 'EEE, d MMM, y',
    'yMMMM': 'MMMM \'năm\' y',
    'yMMMMd': 'd MMMM, y',
    'yMMMMEEEEd': 'EEEE, d MMMM, y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ \'năm\' y',
    'H': 'HH',
    'Hm': 'H:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'H:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'zh': <String, String>{
    'd': 'd日',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'M月',
    'Md': 'M/d',
    'MEd': 'M/dEEE',
    'MMM': 'LLL',
    'MMMd': 'M月d日',
    'MMMEd': 'M月d日EEE',
    'MMMM': 'LLLL',
    'MMMMd': 'M月d日',
    'MMMMEEEEd': 'M月d日EEEE',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y年',
    'yM': 'y年M月',
    'yMd': 'y/M/d',
    'yMEd': 'y/M/dEEE',
    'yMMM': 'y年M月',
    'yMMMd': 'y年M月d日',
    'yMMMEd': 'y年M月d日EEE',
    'yMMMM': 'y年M月',
    'yMMMMd': 'y年M月d日',
    'yMMMMEEEEd': 'y年M月d日EEEE',
    'yQQQ': 'y年第Q季度',
    'yQQQQ': 'y年第Q季度',
    'H': 'H时',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'ah时',
    'jm': 'ah:mm',
    'jms': 'ah:mm:ss',
    'jmv': 'v ah:mm',
    'jmz': 'z ah:mm',
    'jz': 'zah时',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'zh_HK': <String, String>{
    'd': 'd日',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'M月',
    'Md': 'd/M',
    'MEd': 'd/M（EEE）',
    'MMM': 'LLL',
    'MMMd': 'M月d日',
    'MMMEd': 'M月d日EEE',
    'MMMM': 'LLLL',
    'MMMMd': 'M月d日',
    'MMMMEEEEd': 'M月d日EEEE',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y年',
    'yM': 'M/y',
    'yMd': 'd/M/y',
    'yMEd': 'd/M/y（EEE）',
    'yMMM': 'y年M月',
    'yMMMd': 'y年M月d日',
    'yMMMEd': 'y年M月d日EEE',
    'yMMMM': 'y年M月',
    'yMMMMd': 'y年M月d日',
    'yMMMMEEEEd': 'y年M月d日EEEE',
    'yQQQ': 'y年QQQ',
    'yQQQQ': 'y年QQQQ',
    'H': 'H時',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'ah時',
    'jm': 'ah:mm',
    'jms': 'ah:mm:ss',
    'jmv': 'ah:mm [v]',
    'jmz': 'ah:mm [z]',
    'jz': 'ah時 z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'zh_TW': <String, String>{
    'd': 'd日',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'M月',
    'Md': 'M/d',
    'MEd': 'M/d（EEE）',
    'MMM': 'LLL',
    'MMMd': 'M月d日',
    'MMMEd': 'M月d日 EEE',
    'MMMM': 'LLLL',
    'MMMMd': 'M月d日',
    'MMMMEEEEd': 'M月d日 EEEE',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y年',
    'yM': 'y/M',
    'yMd': 'y/M/d',
    'yMEd': 'y/M/d（EEE）',
    'yMMM': 'y年M月',
    'yMMMd': 'y年M月d日',
    'yMMMEd': 'y年M月d日 EEE',
    'yMMMM': 'y年M月',
    'yMMMMd': 'y年M月d日',
    'yMMMMEEEEd': 'y年M月d日 EEEE',
    'yQQQ': 'y年QQQ',
    'yQQQQ': 'y年QQQQ',
    'H': 'H時',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'ah時',
    'jm': 'ah:mm',
    'jms': 'ah:mm:ss',
    'jmv': 'ah:mm [v]',
    'jmz': 'ah:mm [z]',
    'jz': 'ah時 z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
  'zu': <String, String>{
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'MM-dd',
    'MEd': 'MM-dd, EEE',
    'MMM': 'LLL',
    'MMMd': 'MMM d',
    'MMMEd': 'EEE, MMM d',
    'MMMM': 'LLLL',
    'MMMMd': 'MMMM d',
    'MMMMEEEEd': 'EEEE, MMMM d',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'y-MM',
    'yMd': 'y-MM-dd',
    'yMEd': 'y-MM-dd, EEE',
    'yMMM': 'MMM y',
    'yMMMd': 'MMM d, y',
    'yMMMEd': 'EEE, MMM d, y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'MMMM d, y',
    'yMMMMEEEEd': 'EEEE, MMMM d, y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  },
};
