/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.FlutterInjector;
import io.flutter.Log;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.embedding.engine.deferredcomponents.DeferredComponentManager;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.StandardMethodCodec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeferredComponentChannel {
    private static final String TAG = "DeferredComponentChannel";
    @NonNull
    private final MethodChannel channel;
    @Nullable
    private DeferredComponentManager deferredComponentManager;
    @NonNull
    private Map<String, List<MethodChannel.Result>> moduleNameToResults;
    @NonNull
    @VisibleForTesting
    final MethodChannel.MethodCallHandler parsingMethodHandler = new MethodChannel.MethodCallHandler(){

        @Override
        public void onMethodCall(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            if (DeferredComponentChannel.this.deferredComponentManager == null) {
                return;
            }
            String method = call.method;
            Map args = (Map)call.arguments();
            Log.v(DeferredComponentChannel.TAG, "Received '" + method + "' message.");
            int loadingUnitId = (Integer)args.get("loadingUnitId");
            String moduleName = (String)args.get("moduleName");
            switch (method) {
                case "installDeferredComponent": {
                    DeferredComponentChannel.this.deferredComponentManager.installDeferredComponent(loadingUnitId, moduleName);
                    if (!DeferredComponentChannel.this.moduleNameToResults.containsKey(moduleName)) {
                        DeferredComponentChannel.this.moduleNameToResults.put(moduleName, new ArrayList());
                    }
                    ((List)DeferredComponentChannel.this.moduleNameToResults.get(moduleName)).add(result);
                    break;
                }
                case "getDeferredComponentInstallState": {
                    result.success(DeferredComponentChannel.this.deferredComponentManager.getDeferredComponentInstallState(loadingUnitId, moduleName));
                    break;
                }
                case "uninstallDeferredComponent": {
                    DeferredComponentChannel.this.deferredComponentManager.uninstallDeferredComponent(loadingUnitId, moduleName);
                    result.success(null);
                    break;
                }
                default: {
                    result.notImplemented();
                }
            }
        }
    };

    public DeferredComponentChannel(@NonNull DartExecutor dartExecutor) {
        this.channel = new MethodChannel(dartExecutor, "flutter/deferredcomponent", StandardMethodCodec.INSTANCE);
        this.channel.setMethodCallHandler(this.parsingMethodHandler);
        this.deferredComponentManager = FlutterInjector.instance().deferredComponentManager();
        this.moduleNameToResults = new HashMap<String, List<MethodChannel.Result>>();
    }

    @VisibleForTesting
    public void setDeferredComponentManager(@Nullable DeferredComponentManager deferredComponentManager) {
        this.deferredComponentManager = deferredComponentManager;
    }

    public void completeInstallSuccess(String moduleName) {
        if (this.moduleNameToResults.containsKey(moduleName)) {
            for (MethodChannel.Result result : this.moduleNameToResults.get(moduleName)) {
                result.success(null);
            }
            this.moduleNameToResults.get(moduleName).clear();
        }
    }

    public void completeInstallError(String moduleName, String errorMessage) {
        if (this.moduleNameToResults.containsKey(moduleName)) {
            for (MethodChannel.Result result : this.moduleNameToResults.get(moduleName)) {
                result.error("DeferredComponent Install failure", errorMessage, null);
            }
            this.moduleNameToResults.get(moduleName).clear();
        }
    }
}

