/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.Log;
import io.flutter.embedding.engine.systemchannels.KeyEventChannel;
import io.flutter.plugin.editing.TextInputPlugin;
import java.util.ArrayDeque;
import java.util.Deque;

public class AndroidKeyProcessor {
    private static final String TAG = "AndroidKeyProcessor";
    @NonNull
    private final KeyEventChannel keyEventChannel;
    @NonNull
    private final TextInputPlugin textInputPlugin;
    private int combiningCharacter;
    @NonNull
    private EventResponder eventResponder;

    public AndroidKeyProcessor(@NonNull View view, @NonNull KeyEventChannel keyEventChannel, @NonNull TextInputPlugin textInputPlugin) {
        this.keyEventChannel = keyEventChannel;
        this.textInputPlugin = textInputPlugin;
        textInputPlugin.setKeyEventProcessor(this);
        this.eventResponder = new EventResponder(view, textInputPlugin);
        this.keyEventChannel.setEventResponseHandler(this.eventResponder);
    }

    public void destroy() {
        this.keyEventChannel.setEventResponseHandler(null);
    }

    public boolean onKeyEvent(@NonNull KeyEvent keyEvent) {
        int action = keyEvent.getAction();
        if (action != 0 && action != 1) {
            return false;
        }
        if (this.isPendingEvent(keyEvent)) {
            this.eventResponder.removePendingEvent(keyEvent);
            return false;
        }
        Character complexCharacter = this.applyCombiningCharacterToBaseCharacter(keyEvent.getUnicodeChar());
        KeyEventChannel.FlutterKeyEvent flutterEvent = new KeyEventChannel.FlutterKeyEvent(keyEvent, complexCharacter);
        this.eventResponder.addEvent(keyEvent);
        if (action == 0) {
            this.keyEventChannel.keyDown(flutterEvent);
        } else {
            this.keyEventChannel.keyUp(flutterEvent);
        }
        return true;
    }

    public boolean isPendingEvent(@NonNull KeyEvent event) {
        return this.eventResponder.findPendingEvent(event) != null;
    }

    @Nullable
    private Character applyCombiningCharacterToBaseCharacter(int newCharacterCodePoint) {
        boolean isNewCodePointACombiningCharacter;
        if (newCharacterCodePoint == 0) {
            return null;
        }
        char complexCharacter = (char)newCharacterCodePoint;
        boolean bl = isNewCodePointACombiningCharacter = (newCharacterCodePoint & Integer.MIN_VALUE) != 0;
        if (isNewCodePointACombiningCharacter) {
            int plainCodePoint = newCharacterCodePoint & Integer.MAX_VALUE;
            this.combiningCharacter = this.combiningCharacter != 0 ? KeyCharacterMap.getDeadChar((int)this.combiningCharacter, (int)plainCodePoint) : plainCodePoint;
        } else if (this.combiningCharacter != 0) {
            int combinedChar = KeyCharacterMap.getDeadChar((int)this.combiningCharacter, (int)newCharacterCodePoint);
            if (combinedChar > 0) {
                complexCharacter = (char)combinedChar;
            }
            this.combiningCharacter = 0;
        }
        return Character.valueOf(complexCharacter);
    }

    private static class EventResponder
    implements KeyEventChannel.EventResponseHandler {
        private static final long MAX_PENDING_EVENTS = 1000L;
        final Deque<KeyEvent> pendingEvents = new ArrayDeque<KeyEvent>();
        @NonNull
        private final View view;
        @NonNull
        private final TextInputPlugin textInputPlugin;

        public EventResponder(@NonNull View view, @NonNull TextInputPlugin textInputPlugin) {
            this.view = view;
            this.textInputPlugin = textInputPlugin;
        }

        private void removePendingEvent(KeyEvent event) {
            this.pendingEvents.remove(event);
        }

        private KeyEvent findPendingEvent(KeyEvent event) {
            for (KeyEvent item : this.pendingEvents) {
                if (item != event) continue;
                return item;
            }
            return null;
        }

        @Override
        public void onKeyEventHandled(KeyEvent event) {
            this.removePendingEvent(event);
        }

        @Override
        public void onKeyEventNotHandled(KeyEvent event) {
            this.redispatchKeyEvent(this.findPendingEvent(event));
        }

        public void addEvent(@NonNull KeyEvent event) {
            this.pendingEvents.addLast(event);
            if ((long)this.pendingEvents.size() > 1000L) {
                Log.e(AndroidKeyProcessor.TAG, "There are " + this.pendingEvents.size() + " keyboard events that have not yet received a response. Are responses being sent?");
            }
        }

        private void redispatchKeyEvent(KeyEvent event) {
            if (this.textInputPlugin.getInputMethodManager().isAcceptingText() && this.textInputPlugin.getLastInputConnection() != null && this.textInputPlugin.getLastInputConnection().sendKeyEvent(event)) {
                this.removePendingEvent(event);
                return;
            }
            if (this.view != null) {
                this.view.getRootView().dispatchKeyEvent(event);
            }
        }
    }
}

