/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.common;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import io.flutter.Log;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.FlutterException;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodCodec;
import io.flutter.plugin.common.StandardMethodCodec;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;

public class MethodChannel {
    private static final String TAG = "MethodChannel#";
    private final BinaryMessenger messenger;
    private final String name;
    private final MethodCodec codec;
    private final BinaryMessenger.TaskQueue taskQueue;

    public MethodChannel(BinaryMessenger messenger, String name) {
        this(messenger, name, StandardMethodCodec.INSTANCE);
    }

    public MethodChannel(BinaryMessenger messenger, String name, MethodCodec codec) {
        this(messenger, name, codec, null);
    }

    public MethodChannel(BinaryMessenger messenger, String name, MethodCodec codec, @Nullable BinaryMessenger.TaskQueue taskQueue) {
        this.messenger = messenger;
        this.name = name;
        this.codec = codec;
        this.taskQueue = taskQueue;
    }

    @UiThread
    public void invokeMethod(@NonNull String method, @Nullable Object arguments) {
        this.invokeMethod(method, arguments, null);
    }

    @UiThread
    public void invokeMethod(String method, @Nullable Object arguments, @Nullable Result callback) {
        this.messenger.send(this.name, this.codec.encodeMethodCall(new MethodCall(method, arguments)), callback == null ? null : new IncomingResultHandler(callback));
    }

    @UiThread
    public void setMethodCallHandler(@Nullable MethodCallHandler handler) {
        if (this.taskQueue != null) {
            this.messenger.setMessageHandler(this.name, handler == null ? null : new IncomingMethodCallHandler(handler), this.taskQueue);
        } else {
            this.messenger.setMessageHandler(this.name, handler == null ? null : new IncomingMethodCallHandler(handler));
        }
    }

    public void resizeChannelBuffer(int newSize) {
        BasicMessageChannel.resizeChannelBuffer(this.messenger, this.name, newSize);
    }

    private final class IncomingMethodCallHandler
    implements BinaryMessenger.BinaryMessageHandler {
        private final MethodCallHandler handler;

        IncomingMethodCallHandler(MethodCallHandler handler) {
            this.handler = handler;
        }

        @Override
        @UiThread
        public void onMessage(ByteBuffer message, final BinaryMessenger.BinaryReply reply) {
            MethodCall call = MethodChannel.this.codec.decodeMethodCall(message);
            try {
                this.handler.onMethodCall(call, new Result(){

                    @Override
                    public void success(Object result) {
                        reply.reply(MethodChannel.this.codec.encodeSuccessEnvelope(result));
                    }

                    @Override
                    public void error(String errorCode, String errorMessage, Object errorDetails) {
                        reply.reply(MethodChannel.this.codec.encodeErrorEnvelope(errorCode, errorMessage, errorDetails));
                    }

                    @Override
                    public void notImplemented() {
                        reply.reply(null);
                    }
                });
            }
            catch (RuntimeException e) {
                Log.e(MethodChannel.TAG + MethodChannel.this.name, "Failed to handle method call", e);
                reply.reply(MethodChannel.this.codec.encodeErrorEnvelopeWithStacktrace("error", e.getMessage(), null, this.getStackTrace(e)));
            }
        }

        private String getStackTrace(Exception e) {
            StringWriter result = new StringWriter();
            e.printStackTrace(new PrintWriter(result));
            return ((Object)result).toString();
        }
    }

    private final class IncomingResultHandler
    implements BinaryMessenger.BinaryReply {
        private final Result callback;

        IncomingResultHandler(Result callback) {
            this.callback = callback;
        }

        @Override
        @UiThread
        public void reply(ByteBuffer reply) {
            try {
                if (reply == null) {
                    this.callback.notImplemented();
                } else {
                    try {
                        this.callback.success(MethodChannel.this.codec.decodeEnvelope(reply));
                    }
                    catch (FlutterException e) {
                        this.callback.error(e.code, e.getMessage(), e.details);
                    }
                }
            }
            catch (RuntimeException e) {
                Log.e(MethodChannel.TAG + MethodChannel.this.name, "Failed to handle method call result", e);
            }
        }
    }

    public static interface Result {
        public void success(@Nullable Object var1);

        public void error(String var1, @Nullable String var2, @Nullable Object var3);

        public void notImplemented();
    }

    public static interface MethodCallHandler {
        @UiThread
        public void onMethodCall(@NonNull MethodCall var1, @NonNull Result var2);
    }
}

