# native_stack_traces

This package provides libraries and a utility for decoding non-symbolic
stack traces generated by an AOT-compiled Dart application.

## Converting stack traces

In some modes of AOT compilation, information on mapping execution points to
source locations is no longer stored in the Dart image. Instead, this
information is translated to separately stored debugging information.
This debugging information can then be stripped from the application
before shipping.

However, there is a drawback. Stack traces generated by such an application no
longer includes file, function, and line number information (i.e., symbolic
stack traces). Instead, stack trace frames simply include program counter
information. Thus, to find the source information for these frames, we must use
the debugging information. This means either keeping the original unstripped
application, or saving the debugging information into a separate file.

Given this debugging information, the libraries in this package can turn
non-symbolic stack traces back into symbolic stack traces. In addition, this
package includes a command line tool `decode` whose output is the same as its
input except that non-symbolic stack traces are translated.

### Using `decode`

Take the following Dart code, which we put in `throws.dart`. The inlining
pragmas are here just to ensure that `bar` is inlined into `foo` and that `foo`
is _not_ inlined into `bar`, to illustrate how inlined code is handled in the
translated output.

```dart
@pragma('vm:prefer-inline')
bar() => throw Null;

@pragma('vm:never-inline')
foo() => bar();

main() => foo();
```

Now we run the following commands:

```bash
# Make sure that we have the native_stack_traces package.
$ dart pub global activate native_stack_traces

# We compile the example program, removing the source location information
# from the snapshot and saving the debugging information into throws.debug.
$ dart compile exe -S throws.debug throws.dart

# Run the program, saving the error output to throws.err.
$ ./throws.exe 2>throws.err

# Using the saved debugging information, we can translate the stack trace
# contained in throws.err to its symbolic form.
$ dart pub global run native_stack_traces:decode translate -d throws.debug -i throws.err
```

## Features and bugs

Please file feature requests and bugs at the [issue tracker][tracker].

[tracker]: https://github.com/dart-lang/sdk/issues
