/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import androidx.annotation.NonNull;
import io.flutter.embedding.android.KeyboardManager;
import io.flutter.embedding.engine.systemchannels.KeyEventChannel;

public class KeyChannelResponder
implements KeyboardManager.Responder {
    private static final String TAG = "KeyChannelResponder";
    @NonNull
    private final KeyEventChannel keyEventChannel;
    private int combiningCharacter;

    public KeyChannelResponder(@NonNull KeyEventChannel keyEventChannel) {
        this.keyEventChannel = keyEventChannel;
    }

    Character applyCombiningCharacterToBaseCharacter(int newCharacterCodePoint) {
        boolean isNewCodePointACombiningCharacter;
        char complexCharacter = (char)newCharacterCodePoint;
        boolean bl = isNewCodePointACombiningCharacter = (newCharacterCodePoint & Integer.MIN_VALUE) != 0;
        if (isNewCodePointACombiningCharacter) {
            int plainCodePoint = newCharacterCodePoint & Integer.MAX_VALUE;
            this.combiningCharacter = this.combiningCharacter != 0 ? KeyCharacterMap.getDeadChar((int)this.combiningCharacter, (int)plainCodePoint) : plainCodePoint;
        } else if (this.combiningCharacter != 0) {
            int combinedChar = KeyCharacterMap.getDeadChar((int)this.combiningCharacter, (int)newCharacterCodePoint);
            if (combinedChar > 0) {
                complexCharacter = (char)combinedChar;
            }
            this.combiningCharacter = 0;
        }
        return Character.valueOf(complexCharacter);
    }

    @Override
    public void handleEvent(@NonNull KeyEvent keyEvent, @NonNull KeyboardManager.Responder.OnKeyEventHandledCallback onKeyEventHandledCallback) {
        int action = keyEvent.getAction();
        if (action != 0 && action != 1) {
            onKeyEventHandledCallback.onKeyEventHandled(false);
            return;
        }
        Character complexCharacter = this.applyCombiningCharacterToBaseCharacter(keyEvent.getUnicodeChar());
        KeyEventChannel.FlutterKeyEvent flutterEvent = new KeyEventChannel.FlutterKeyEvent(keyEvent, complexCharacter);
        boolean isKeyUp = action != 0;
        this.keyEventChannel.sendFlutterKeyEvent(flutterEvent, isKeyUp, isEventHandled -> onKeyEventHandledCallback.onKeyEventHandled(isEventHandled));
    }
}

