/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.renderer;

import android.graphics.SurfaceTexture;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;

@Keep
public class SurfaceTextureWrapper {
    private SurfaceTexture surfaceTexture;
    private boolean released;
    private boolean attached;

    public SurfaceTextureWrapper(@NonNull SurfaceTexture surfaceTexture) {
        this.surfaceTexture = surfaceTexture;
        this.released = false;
    }

    @NonNull
    public SurfaceTexture surfaceTexture() {
        return this.surfaceTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTexImage() {
        SurfaceTextureWrapper surfaceTextureWrapper = this;
        synchronized (surfaceTextureWrapper) {
            if (!this.released) {
                this.surfaceTexture.updateTexImage();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        SurfaceTextureWrapper surfaceTextureWrapper = this;
        synchronized (surfaceTextureWrapper) {
            if (!this.released) {
                this.surfaceTexture.release();
                this.released = true;
                this.attached = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachToGLContext(int texName) {
        SurfaceTextureWrapper surfaceTextureWrapper = this;
        synchronized (surfaceTextureWrapper) {
            if (this.released) {
                return;
            }
            if (this.attached) {
                this.surfaceTexture.detachFromGLContext();
            }
            this.surfaceTexture.attachToGLContext(texName);
            this.attached = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachFromGLContext() {
        SurfaceTextureWrapper surfaceTextureWrapper = this;
        synchronized (surfaceTextureWrapper) {
            if (this.attached && !this.released) {
                this.surfaceTexture.detachFromGLContext();
                this.attached = false;
            }
        }
    }

    public void getTransformMatrix(@NonNull float[] mtx) {
        this.surfaceTexture.getTransformMatrix(mtx);
    }
}

