/*
 * Copyright (c) 2015, the Dart project authors.
 *
 * Licensed under the Eclipse Public License v1.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package org.dartlang.vm.service.element;

// This file is generated by the script: pkg/vm_service/tool/generate.dart in dart-lang/sdk.

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

/**
 * The {@link Stack} class represents the various components of a Dart stack trace for a given
 * isolate.
 */
@SuppressWarnings({"WeakerAccess", "unused"})
public class Stack extends Response {

  public Stack(JsonObject json) {
    super(json);
  }

  /**
   * A list of frames representing the asynchronous path. Comparable to `awaiterFrames`, if
   * provided, although some frames may be different.
   *
   * Can return <code>null</code>.
   */
  public ElementList<Frame> getAsyncCausalFrames() {
    if (json.get("asyncCausalFrames") == null) return null;
    
    return new ElementList<Frame>(json.get("asyncCausalFrames").getAsJsonArray()) {
      @Override
      protected Frame basicGet(JsonArray array, int index) {
        return new Frame(array.get(index).getAsJsonObject());
      }
    };
  }

  /**
   * A list of frames representing the asynchronous path. Comparable to `asyncCausalFrames`, if
   * provided, although some frames may be different.
   *
   * Can return <code>null</code>.
   */
  public ElementList<Frame> getAwaiterFrames() {
    if (json.get("awaiterFrames") == null) return null;
    
    return new ElementList<Frame>(json.get("awaiterFrames").getAsJsonArray()) {
      @Override
      protected Frame basicGet(JsonArray array, int index) {
        return new Frame(array.get(index).getAsJsonObject());
      }
    };
  }

  /**
   * A list of frames that make up the synchronous stack, rooted at the message loop (i.e., the
   * frames since the last asynchronous gap or the isolate's entrypoint).
   */
  public ElementList<Frame> getFrames() {
    return new ElementList<Frame>(json.get("frames").getAsJsonArray()) {
      @Override
      protected Frame basicGet(JsonArray array, int index) {
        return new Frame(array.get(index).getAsJsonObject());
      }
    };
  }

  /**
   * A list of messages in the isolate's message queue.
   */
  public ElementList<Message> getMessages() {
    return new ElementList<Message>(json.get("messages").getAsJsonArray()) {
      @Override
      protected Message basicGet(JsonArray array, int index) {
        return new Message(array.get(index).getAsJsonObject());
      }
    };
  }

  /**
   * Specifies whether or not this stack is complete or has been artificially truncated.
   */
  public boolean getTruncated() {
    return getAsBoolean("truncated");
  }
}
