/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import android.annotation.TargetApi;
import android.hardware.display.DisplayManager;
import android.view.Choreographer;
import android.view.Display;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import io.flutter.embedding.engine.FlutterJNI;
import java.util.Objects;

public class VsyncWaiter {
    private static VsyncWaiter instance;
    private static DisplayListener listener;
    private long refreshPeriodNanos = -1L;
    private FlutterJNI flutterJNI;
    private final FlutterJNI.AsyncWaitForVsyncDelegate asyncWaitForVsyncDelegate = new FlutterJNI.AsyncWaitForVsyncDelegate(){

        @Override
        public void asyncWaitForVsync(final long cookie) {
            Choreographer.getInstance().postFrameCallback(new Choreographer.FrameCallback(){

                public void doFrame(long frameTimeNanos) {
                    long delay = System.nanoTime() - frameTimeNanos;
                    if (delay < 0L) {
                        delay = 0L;
                    }
                    VsyncWaiter.this.flutterJNI.onVsync(delay, VsyncWaiter.this.refreshPeriodNanos, cookie);
                }
            });
        }
    };

    @NonNull
    public static VsyncWaiter getInstance(float fps, @NonNull FlutterJNI flutterJNI) {
        if (instance == null) {
            instance = new VsyncWaiter(flutterJNI);
        }
        flutterJNI.setRefreshRateFPS(fps);
        VsyncWaiter.instance.refreshPeriodNanos = (long)(1.0E9 / (double)fps);
        return instance;
    }

    @TargetApi(value=17)
    @NonNull
    public static VsyncWaiter getInstance(@NonNull DisplayManager displayManager, @NonNull FlutterJNI flutterJNI) {
        if (instance == null) {
            instance = new VsyncWaiter(flutterJNI);
        }
        if (listener == null) {
            VsyncWaiter vsyncWaiter = instance;
            Objects.requireNonNull(vsyncWaiter);
            listener = vsyncWaiter.new DisplayListener(displayManager);
            listener.register();
        }
        if (VsyncWaiter.instance.refreshPeriodNanos == -1L) {
            Display primaryDisplay = displayManager.getDisplay(0);
            float fps = primaryDisplay.getRefreshRate();
            VsyncWaiter.instance.refreshPeriodNanos = (long)(1.0E9 / (double)fps);
            flutterJNI.setRefreshRateFPS(fps);
        }
        return instance;
    }

    @VisibleForTesting
    public static void reset() {
        instance = null;
        listener = null;
    }

    private VsyncWaiter(@NonNull FlutterJNI flutterJNI) {
        this.flutterJNI = flutterJNI;
    }

    public void init() {
        this.flutterJNI.setAsyncWaitForVsyncDelegate(this.asyncWaitForVsyncDelegate);
    }

    @TargetApi(value=17)
    class DisplayListener
    implements DisplayManager.DisplayListener {
        private DisplayManager displayManager;

        DisplayListener(DisplayManager displayManager) {
            this.displayManager = displayManager;
        }

        void register() {
            this.displayManager.registerDisplayListener((DisplayManager.DisplayListener)this, null);
        }

        public void onDisplayAdded(int displayId) {
        }

        public void onDisplayRemoved(int displayId) {
        }

        public void onDisplayChanged(int displayId) {
            if (displayId == 0) {
                Display primaryDisplay = this.displayManager.getDisplay(0);
                float fps = primaryDisplay.getRefreshRate();
                VsyncWaiter.this.refreshPeriodNanos = (long)(1.0E9 / (double)fps);
                VsyncWaiter.this.flutterJNI.setRefreshRateFPS(fps);
            }
        }
    }
}

