/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.app.Activity;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.activity.OnBackPressedCallback;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import io.flutter.Log;
import io.flutter.embedding.android.ExclusiveAppComponent;
import io.flutter.embedding.android.FlutterActivityAndFragmentDelegate;
import io.flutter.embedding.android.FlutterEngineConfigurator;
import io.flutter.embedding.android.FlutterEngineProvider;
import io.flutter.embedding.android.FlutterSurfaceView;
import io.flutter.embedding.android.FlutterTextureView;
import io.flutter.embedding.android.RenderMode;
import io.flutter.embedding.android.SplashScreen;
import io.flutter.embedding.android.SplashScreenProvider;
import io.flutter.embedding.android.TransparencyMode;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.FlutterShellArgs;
import io.flutter.embedding.engine.renderer.FlutterUiDisplayListener;
import io.flutter.plugin.platform.PlatformPlugin;
import io.flutter.util.ViewUtils;
import java.util.ArrayList;
import java.util.List;

public class FlutterFragment
extends Fragment
implements FlutterActivityAndFragmentDelegate.Host,
ComponentCallbacks2 {
    public static final int FLUTTER_VIEW_ID = ViewUtils.generateViewId(61938);
    private static final String TAG = "FlutterFragment";
    protected static final String ARG_DART_ENTRYPOINT = "dart_entrypoint";
    protected static final String ARG_DART_ENTRYPOINT_URI = "dart_entrypoint_uri";
    protected static final String ARG_DART_ENTRYPOINT_ARGS = "dart_entrypoint_args";
    protected static final String ARG_INITIAL_ROUTE = "initial_route";
    protected static final String ARG_HANDLE_DEEPLINKING = "handle_deeplinking";
    protected static final String ARG_APP_BUNDLE_PATH = "app_bundle_path";
    protected static final String ARG_SHOULD_DELAY_FIRST_ANDROID_VIEW_DRAW = "should_delay_first_android_view_draw";
    protected static final String ARG_FLUTTER_INITIALIZATION_ARGS = "initialization_args";
    protected static final String ARG_FLUTTERVIEW_RENDER_MODE = "flutterview_render_mode";
    protected static final String ARG_FLUTTERVIEW_TRANSPARENCY_MODE = "flutterview_transparency_mode";
    protected static final String ARG_SHOULD_ATTACH_ENGINE_TO_ACTIVITY = "should_attach_engine_to_activity";
    protected static final String ARG_CACHED_ENGINE_ID = "cached_engine_id";
    protected static final String ARG_DESTROY_ENGINE_WITH_FRAGMENT = "destroy_engine_with_fragment";
    protected static final String ARG_ENABLE_STATE_RESTORATION = "enable_state_restoration";
    protected static final String ARG_SHOULD_AUTOMATICALLY_HANDLE_ON_BACK_PRESSED = "should_automatically_handle_on_back_pressed";
    @VisibleForTesting
    @Nullable
    FlutterActivityAndFragmentDelegate delegate;
    private final OnBackPressedCallback onBackPressedCallback = new OnBackPressedCallback(true){

        public void handleOnBackPressed() {
            FlutterFragment.this.onBackPressed();
        }
    };

    @NonNull
    public static FlutterFragment createDefault() {
        return new NewEngineFragmentBuilder().build();
    }

    @NonNull
    public static NewEngineFragmentBuilder withNewEngine() {
        return new NewEngineFragmentBuilder();
    }

    @NonNull
    public static CachedEngineFragmentBuilder withCachedEngine(@NonNull String engineId) {
        return new CachedEngineFragmentBuilder(engineId);
    }

    public FlutterFragment() {
        this.setArguments(new Bundle());
    }

    @VisibleForTesting
    void setDelegate(@NonNull FlutterActivityAndFragmentDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public ExclusiveAppComponent<Activity> getExclusiveAppComponent() {
        return this.delegate;
    }

    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        this.delegate = new FlutterActivityAndFragmentDelegate(this);
        this.delegate.onAttach(context);
        if (this.getArguments().getBoolean(ARG_SHOULD_AUTOMATICALLY_HANDLE_ON_BACK_PRESSED, false)) {
            this.requireActivity().getOnBackPressedDispatcher().addCallback((LifecycleOwner)this, this.onBackPressedCallback);
        }
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.delegate.onRestoreInstanceState(savedInstanceState);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return this.delegate.onCreateView(inflater, container, savedInstanceState, FLUTTER_VIEW_ID, this.shouldDelayFirstAndroidViewDraw());
    }

    public void onStart() {
        super.onStart();
        if (this.stillAttachedForEvent("onStart")) {
            this.delegate.onStart();
        }
    }

    public void onResume() {
        super.onResume();
        if (this.stillAttachedForEvent("onResume")) {
            this.delegate.onResume();
        }
    }

    @ActivityCallThrough
    public void onPostResume() {
        if (this.stillAttachedForEvent("onPostResume")) {
            this.delegate.onPostResume();
        }
    }

    public void onPause() {
        super.onPause();
        if (this.stillAttachedForEvent("onPause")) {
            this.delegate.onPause();
        }
    }

    public void onStop() {
        super.onStop();
        if (this.stillAttachedForEvent("onStop")) {
            this.delegate.onStop();
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.stillAttachedForEvent("onDestroyView")) {
            this.delegate.onDestroyView();
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.stillAttachedForEvent("onSaveInstanceState")) {
            this.delegate.onSaveInstanceState(outState);
        }
    }

    @Override
    public void detachFromFlutterEngine() {
        Log.w(TAG, "FlutterFragment " + this + " connection to the engine " + this.getFlutterEngine() + " evicted by another attaching activity");
        if (this.delegate != null) {
            this.delegate.onDestroyView();
            this.delegate.onDetach();
        }
    }

    public void onDetach() {
        super.onDetach();
        if (this.delegate != null) {
            this.delegate.onDetach();
            this.delegate.release();
            this.delegate = null;
        } else {
            Log.v(TAG, "FlutterFragment " + this + " onDetach called after release.");
        }
    }

    @ActivityCallThrough
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (this.stillAttachedForEvent("onRequestPermissionsResult")) {
            this.delegate.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    @ActivityCallThrough
    public void onNewIntent(@NonNull Intent intent) {
        if (this.stillAttachedForEvent("onNewIntent")) {
            this.delegate.onNewIntent(intent);
        }
    }

    @ActivityCallThrough
    public void onBackPressed() {
        if (this.stillAttachedForEvent("onBackPressed")) {
            this.delegate.onBackPressed();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.stillAttachedForEvent("onActivityResult")) {
            this.delegate.onActivityResult(requestCode, resultCode, data);
        }
    }

    @ActivityCallThrough
    public void onUserLeaveHint() {
        if (this.stillAttachedForEvent("onUserLeaveHint")) {
            this.delegate.onUserLeaveHint();
        }
    }

    public void onTrimMemory(int level) {
        if (this.stillAttachedForEvent("onTrimMemory")) {
            this.delegate.onTrimMemory(level);
        }
    }

    public void onLowMemory() {
        super.onLowMemory();
        if (this.stillAttachedForEvent("onLowMemory")) {
            this.delegate.onLowMemory();
        }
    }

    @Override
    @NonNull
    public FlutterShellArgs getFlutterShellArgs() {
        String[] flutterShellArgsArray = this.getArguments().getStringArray(ARG_FLUTTER_INITIALIZATION_ARGS);
        return new FlutterShellArgs(flutterShellArgsArray != null ? flutterShellArgsArray : new String[]{});
    }

    @Override
    @Nullable
    public String getCachedEngineId() {
        return this.getArguments().getString(ARG_CACHED_ENGINE_ID, null);
    }

    boolean isFlutterEngineInjected() {
        return this.delegate.isFlutterEngineFromHost();
    }

    @Override
    public boolean shouldDestroyEngineWithHost() {
        boolean explicitDestructionRequested = this.getArguments().getBoolean(ARG_DESTROY_ENGINE_WITH_FRAGMENT, false);
        if (this.getCachedEngineId() != null || this.delegate.isFlutterEngineFromHost()) {
            return explicitDestructionRequested;
        }
        return this.getArguments().getBoolean(ARG_DESTROY_ENGINE_WITH_FRAGMENT, true);
    }

    @Override
    @NonNull
    public String getDartEntrypointFunctionName() {
        return this.getArguments().getString(ARG_DART_ENTRYPOINT, "main");
    }

    @Override
    @Nullable
    public List<String> getDartEntrypointArgs() {
        return this.getArguments().getStringArrayList(ARG_DART_ENTRYPOINT_ARGS);
    }

    @Override
    @Nullable
    public String getDartEntrypointLibraryUri() {
        return this.getArguments().getString(ARG_DART_ENTRYPOINT_URI);
    }

    @Override
    @NonNull
    public String getAppBundlePath() {
        return this.getArguments().getString(ARG_APP_BUNDLE_PATH);
    }

    @Override
    @Nullable
    public String getInitialRoute() {
        return this.getArguments().getString(ARG_INITIAL_ROUTE);
    }

    @Override
    @NonNull
    public RenderMode getRenderMode() {
        String renderModeName = this.getArguments().getString(ARG_FLUTTERVIEW_RENDER_MODE, RenderMode.surface.name());
        return RenderMode.valueOf(renderModeName);
    }

    @Override
    @NonNull
    public TransparencyMode getTransparencyMode() {
        String transparencyModeName = this.getArguments().getString(ARG_FLUTTERVIEW_TRANSPARENCY_MODE, TransparencyMode.transparent.name());
        return TransparencyMode.valueOf(transparencyModeName);
    }

    @Override
    @Nullable
    public SplashScreen provideSplashScreen() {
        FragmentActivity parentActivity = this.getActivity();
        if (parentActivity instanceof SplashScreenProvider) {
            SplashScreenProvider splashScreenProvider = (SplashScreenProvider)parentActivity;
            return splashScreenProvider.provideSplashScreen();
        }
        return null;
    }

    @Override
    @Nullable
    public FlutterEngine provideFlutterEngine(@NonNull Context context) {
        FlutterEngine flutterEngine = null;
        FragmentActivity attachedActivity = this.getActivity();
        if (attachedActivity instanceof FlutterEngineProvider) {
            Log.v(TAG, "Deferring to attached Activity to provide a FlutterEngine.");
            FlutterEngineProvider flutterEngineProvider = (FlutterEngineProvider)attachedActivity;
            flutterEngine = flutterEngineProvider.provideFlutterEngine(this.getContext());
        }
        return flutterEngine;
    }

    @Nullable
    public FlutterEngine getFlutterEngine() {
        return this.delegate.getFlutterEngine();
    }

    @Override
    @Nullable
    public PlatformPlugin providePlatformPlugin(@Nullable Activity activity, @NonNull FlutterEngine flutterEngine) {
        if (activity != null) {
            return new PlatformPlugin((Activity)this.getActivity(), flutterEngine.getPlatformChannel(), this);
        }
        return null;
    }

    @Override
    public void configureFlutterEngine(@NonNull FlutterEngine flutterEngine) {
        FragmentActivity attachedActivity = this.getActivity();
        if (attachedActivity instanceof FlutterEngineConfigurator) {
            ((FlutterEngineConfigurator)attachedActivity).configureFlutterEngine(flutterEngine);
        }
    }

    @Override
    public void cleanUpFlutterEngine(@NonNull FlutterEngine flutterEngine) {
        FragmentActivity attachedActivity = this.getActivity();
        if (attachedActivity instanceof FlutterEngineConfigurator) {
            ((FlutterEngineConfigurator)attachedActivity).cleanUpFlutterEngine(flutterEngine);
        }
    }

    @Override
    public boolean shouldAttachEngineToActivity() {
        return this.getArguments().getBoolean(ARG_SHOULD_ATTACH_ENGINE_TO_ACTIVITY);
    }

    @Override
    public boolean shouldHandleDeeplinking() {
        return this.getArguments().getBoolean(ARG_HANDLE_DEEPLINKING);
    }

    @Override
    public void onFlutterSurfaceViewCreated(@NonNull FlutterSurfaceView flutterSurfaceView) {
    }

    @Override
    public void onFlutterTextureViewCreated(@NonNull FlutterTextureView flutterTextureView) {
    }

    @Override
    public void onFlutterUiDisplayed() {
        FragmentActivity attachedActivity = this.getActivity();
        if (attachedActivity instanceof FlutterUiDisplayListener) {
            ((FlutterUiDisplayListener)attachedActivity).onFlutterUiDisplayed();
        }
    }

    @Override
    public void onFlutterUiNoLongerDisplayed() {
        FragmentActivity attachedActivity = this.getActivity();
        if (attachedActivity instanceof FlutterUiDisplayListener) {
            ((FlutterUiDisplayListener)attachedActivity).onFlutterUiNoLongerDisplayed();
        }
    }

    @Override
    public boolean shouldRestoreAndSaveState() {
        if (this.getArguments().containsKey(ARG_ENABLE_STATE_RESTORATION)) {
            return this.getArguments().getBoolean(ARG_ENABLE_STATE_RESTORATION);
        }
        return this.getCachedEngineId() == null;
    }

    @Override
    public void updateSystemUiOverlays() {
        if (this.delegate != null) {
            this.delegate.updateSystemUiOverlays();
        }
    }

    @Override
    public boolean shouldDispatchAppLifecycleState() {
        return true;
    }

    @Override
    public boolean popSystemNavigator() {
        FragmentActivity activity;
        if (this.getArguments().getBoolean(ARG_SHOULD_AUTOMATICALLY_HANDLE_ON_BACK_PRESSED, false) && (activity = this.getActivity()) != null) {
            this.onBackPressedCallback.setEnabled(false);
            activity.getOnBackPressedDispatcher().onBackPressed();
            this.onBackPressedCallback.setEnabled(true);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    @NonNull
    boolean shouldDelayFirstAndroidViewDraw() {
        return this.getArguments().getBoolean(ARG_SHOULD_DELAY_FIRST_ANDROID_VIEW_DRAW);
    }

    private boolean stillAttachedForEvent(String event) {
        if (this.delegate == null) {
            Log.w(TAG, "FlutterFragment " + this.hashCode() + " " + event + " called after release.");
            return false;
        }
        if (!this.delegate.isAttached()) {
            Log.w(TAG, "FlutterFragment " + this.hashCode() + " " + event + " called after detach.");
            return false;
        }
        return true;
    }

    static @interface ActivityCallThrough {
    }

    public static class CachedEngineFragmentBuilder {
        private final Class<? extends FlutterFragment> fragmentClass;
        private final String engineId;
        private boolean destroyEngineWithFragment = false;
        private boolean handleDeeplinking = false;
        private RenderMode renderMode = RenderMode.surface;
        private TransparencyMode transparencyMode = TransparencyMode.transparent;
        private boolean shouldAttachEngineToActivity = true;
        private boolean shouldAutomaticallyHandleOnBackPressed = false;
        private boolean shouldDelayFirstAndroidViewDraw = false;

        private CachedEngineFragmentBuilder(@NonNull String engineId) {
            this(FlutterFragment.class, engineId);
        }

        public CachedEngineFragmentBuilder(@NonNull Class<? extends FlutterFragment> subclass, @NonNull String engineId) {
            this.fragmentClass = subclass;
            this.engineId = engineId;
        }

        @NonNull
        public CachedEngineFragmentBuilder destroyEngineWithFragment(boolean destroyEngineWithFragment) {
            this.destroyEngineWithFragment = destroyEngineWithFragment;
            return this;
        }

        @NonNull
        public CachedEngineFragmentBuilder renderMode(@NonNull RenderMode renderMode) {
            this.renderMode = renderMode;
            return this;
        }

        @NonNull
        public CachedEngineFragmentBuilder transparencyMode(@NonNull TransparencyMode transparencyMode) {
            this.transparencyMode = transparencyMode;
            return this;
        }

        @NonNull
        public CachedEngineFragmentBuilder handleDeeplinking(@NonNull Boolean handleDeeplinking) {
            this.handleDeeplinking = handleDeeplinking;
            return this;
        }

        @NonNull
        public CachedEngineFragmentBuilder shouldAttachEngineToActivity(boolean shouldAttachEngineToActivity) {
            this.shouldAttachEngineToActivity = shouldAttachEngineToActivity;
            return this;
        }

        @NonNull
        public CachedEngineFragmentBuilder shouldAutomaticallyHandleOnBackPressed(boolean shouldAutomaticallyHandleOnBackPressed) {
            this.shouldAutomaticallyHandleOnBackPressed = shouldAutomaticallyHandleOnBackPressed;
            return this;
        }

        @NonNull
        public CachedEngineFragmentBuilder shouldDelayFirstAndroidViewDraw(@NonNull boolean shouldDelayFirstAndroidViewDraw) {
            this.shouldDelayFirstAndroidViewDraw = shouldDelayFirstAndroidViewDraw;
            return this;
        }

        @NonNull
        protected Bundle createArgs() {
            Bundle args = new Bundle();
            args.putString(FlutterFragment.ARG_CACHED_ENGINE_ID, this.engineId);
            args.putBoolean(FlutterFragment.ARG_DESTROY_ENGINE_WITH_FRAGMENT, this.destroyEngineWithFragment);
            args.putBoolean(FlutterFragment.ARG_HANDLE_DEEPLINKING, this.handleDeeplinking);
            args.putString(FlutterFragment.ARG_FLUTTERVIEW_RENDER_MODE, this.renderMode != null ? this.renderMode.name() : RenderMode.surface.name());
            args.putString(FlutterFragment.ARG_FLUTTERVIEW_TRANSPARENCY_MODE, this.transparencyMode != null ? this.transparencyMode.name() : TransparencyMode.transparent.name());
            args.putBoolean(FlutterFragment.ARG_SHOULD_ATTACH_ENGINE_TO_ACTIVITY, this.shouldAttachEngineToActivity);
            args.putBoolean(FlutterFragment.ARG_SHOULD_AUTOMATICALLY_HANDLE_ON_BACK_PRESSED, this.shouldAutomaticallyHandleOnBackPressed);
            args.putBoolean(FlutterFragment.ARG_SHOULD_DELAY_FIRST_ANDROID_VIEW_DRAW, this.shouldDelayFirstAndroidViewDraw);
            return args;
        }

        @NonNull
        public <T extends FlutterFragment> T build() {
            try {
                FlutterFragment frag = this.fragmentClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (frag == null) {
                    throw new RuntimeException("The FlutterFragment subclass sent in the constructor (" + this.fragmentClass.getCanonicalName() + ") does not match the expected return type.");
                }
                Bundle args = this.createArgs();
                frag.setArguments(args);
                return (T)frag;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate FlutterFragment subclass (" + this.fragmentClass.getName() + ")", e);
            }
        }
    }

    public static class NewEngineFragmentBuilder {
        private final Class<? extends FlutterFragment> fragmentClass;
        private String dartEntrypoint = "main";
        private String dartLibraryUri = null;
        private List<String> dartEntrypointArgs;
        private String initialRoute = "/";
        private boolean handleDeeplinking = false;
        private String appBundlePath = null;
        private FlutterShellArgs shellArgs = null;
        private RenderMode renderMode = RenderMode.surface;
        private TransparencyMode transparencyMode = TransparencyMode.transparent;
        private boolean shouldAttachEngineToActivity = true;
        private boolean shouldAutomaticallyHandleOnBackPressed = false;
        private boolean shouldDelayFirstAndroidViewDraw = false;

        public NewEngineFragmentBuilder() {
            this.fragmentClass = FlutterFragment.class;
        }

        public NewEngineFragmentBuilder(@NonNull Class<? extends FlutterFragment> subclass) {
            this.fragmentClass = subclass;
        }

        @NonNull
        public NewEngineFragmentBuilder dartEntrypoint(@NonNull String dartEntrypoint) {
            this.dartEntrypoint = dartEntrypoint;
            return this;
        }

        @NonNull
        public NewEngineFragmentBuilder dartLibraryUri(@NonNull String dartLibraryUri) {
            this.dartLibraryUri = dartLibraryUri;
            return this;
        }

        @NonNull
        public NewEngineFragmentBuilder dartEntrypointArgs(@NonNull List<String> dartEntrypointArgs) {
            this.dartEntrypointArgs = dartEntrypointArgs;
            return this;
        }

        @NonNull
        public NewEngineFragmentBuilder initialRoute(@NonNull String initialRoute) {
            this.initialRoute = initialRoute;
            return this;
        }

        @NonNull
        public NewEngineFragmentBuilder handleDeeplinking(@NonNull Boolean handleDeeplinking) {
            this.handleDeeplinking = handleDeeplinking;
            return this;
        }

        @NonNull
        public NewEngineFragmentBuilder appBundlePath(@NonNull String appBundlePath) {
            this.appBundlePath = appBundlePath;
            return this;
        }

        @NonNull
        public NewEngineFragmentBuilder flutterShellArgs(@NonNull FlutterShellArgs shellArgs) {
            this.shellArgs = shellArgs;
            return this;
        }

        @NonNull
        public NewEngineFragmentBuilder renderMode(@NonNull RenderMode renderMode) {
            this.renderMode = renderMode;
            return this;
        }

        @NonNull
        public NewEngineFragmentBuilder transparencyMode(@NonNull TransparencyMode transparencyMode) {
            this.transparencyMode = transparencyMode;
            return this;
        }

        @NonNull
        public NewEngineFragmentBuilder shouldAttachEngineToActivity(boolean shouldAttachEngineToActivity) {
            this.shouldAttachEngineToActivity = shouldAttachEngineToActivity;
            return this;
        }

        @NonNull
        public NewEngineFragmentBuilder shouldAutomaticallyHandleOnBackPressed(boolean shouldAutomaticallyHandleOnBackPressed) {
            this.shouldAutomaticallyHandleOnBackPressed = shouldAutomaticallyHandleOnBackPressed;
            return this;
        }

        @NonNull
        public NewEngineFragmentBuilder shouldDelayFirstAndroidViewDraw(boolean shouldDelayFirstAndroidViewDraw) {
            this.shouldDelayFirstAndroidViewDraw = shouldDelayFirstAndroidViewDraw;
            return this;
        }

        @NonNull
        protected Bundle createArgs() {
            Bundle args = new Bundle();
            args.putString(FlutterFragment.ARG_INITIAL_ROUTE, this.initialRoute);
            args.putBoolean(FlutterFragment.ARG_HANDLE_DEEPLINKING, this.handleDeeplinking);
            args.putString(FlutterFragment.ARG_APP_BUNDLE_PATH, this.appBundlePath);
            args.putString(FlutterFragment.ARG_DART_ENTRYPOINT, this.dartEntrypoint);
            args.putString(FlutterFragment.ARG_DART_ENTRYPOINT_URI, this.dartLibraryUri);
            args.putStringArrayList(FlutterFragment.ARG_DART_ENTRYPOINT_ARGS, (ArrayList)(this.dartEntrypointArgs != null ? new ArrayList<String>(this.dartEntrypointArgs) : null));
            if (null != this.shellArgs) {
                args.putStringArray(FlutterFragment.ARG_FLUTTER_INITIALIZATION_ARGS, this.shellArgs.toArray());
            }
            args.putString(FlutterFragment.ARG_FLUTTERVIEW_RENDER_MODE, this.renderMode != null ? this.renderMode.name() : RenderMode.surface.name());
            args.putString(FlutterFragment.ARG_FLUTTERVIEW_TRANSPARENCY_MODE, this.transparencyMode != null ? this.transparencyMode.name() : TransparencyMode.transparent.name());
            args.putBoolean(FlutterFragment.ARG_SHOULD_ATTACH_ENGINE_TO_ACTIVITY, this.shouldAttachEngineToActivity);
            args.putBoolean(FlutterFragment.ARG_DESTROY_ENGINE_WITH_FRAGMENT, true);
            args.putBoolean(FlutterFragment.ARG_SHOULD_AUTOMATICALLY_HANDLE_ON_BACK_PRESSED, this.shouldAutomaticallyHandleOnBackPressed);
            args.putBoolean(FlutterFragment.ARG_SHOULD_DELAY_FIRST_ANDROID_VIEW_DRAW, this.shouldDelayFirstAndroidViewDraw);
            return args;
        }

        @NonNull
        public <T extends FlutterFragment> T build() {
            try {
                FlutterFragment frag = this.fragmentClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (frag == null) {
                    throw new RuntimeException("The FlutterFragment subclass sent in the constructor (" + this.fragmentClass.getCanonicalName() + ") does not match the expected return type.");
                }
                Bundle args = this.createArgs();
                frag.setArguments(args);
                return (T)frag;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate FlutterFragment subclass (" + this.fragmentClass.getName() + ")", e);
            }
        }
    }
}

