// Copyright (c) 2020, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

// Standard constants exposed by the Win32 API.

// *** NOTE: This file contains constants that we have chosen not to document,
// mostly because their function is obvious, or because they are documented in
// the public Microsoft Windows documentation online.
//
// This file (only) is excluded from dartdoc in `dartdoc_options.yaml`. By
// keeping non-documented constants in a separate file, we save ourselves the
// need to add the /// @nodoc modifier to every single constant in this file.

// Contributors are invited and encouraged to submit comments for these
// constants from the open source Microsoft documentation, such as
// https://github.com/MicrosoftDocs/win32. Please move documented constants to
// `constants.dart` as appropriate to ensure they are picked up by `dartdoc`.

// ignore_for_file: camel_case_types, constant_identifier_names

import 'dart:ffi';

import 'package:ffi/ffi.dart';

import 'constants.dart';
import 'macros.dart';

// -----------------------------------------------------------------------------
// Error constants
// -----------------------------------------------------------------------------
const ERROR_SEM_OWNER_DIED = 105;
const ERROR_SEM_USER_LIMIT = 106;
const ERROR_DISK_CHANGE = 107;
const ERROR_DRIVE_LOCKED = 108;
const ERROR_BROKEN_PIPE = 109;
const ERROR_OPEN_FAILED = 110;
const ERROR_BUFFER_OVERFLOW = 111;
const ERROR_DISK_FULL = 112;
const ERROR_NO_MORE_SEARCH_HANDLES = 113;
const ERROR_INVALID_TARGET_HANDLE = 114;
const ERROR_INVALID_CATEGORY = 117;
const ERROR_INVALID_VERIFY_SWITCH = 118;
const ERROR_BAD_DRIVER_LEVEL = 119;
const ERROR_CALL_NOT_IMPLEMENTED = 120;
const ERROR_SEM_TIMEOUT = 121;
const ERROR_INSUFFICIENT_BUFFER = 122;
const ERROR_INVALID_NAME = 123;
const ERROR_INVALID_LEVEL = 124;
const ERROR_NO_VOLUME_LABEL = 125;
const ERROR_MOD_NOT_FOUND = 126;
const ERROR_PROC_NOT_FOUND = 127;
const ERROR_WAIT_NO_CHILDREN = 128;
const ERROR_CHILD_NOT_COMPLETE = 129;
const ERROR_DIRECT_ACCESS_HANDLE = 130;
const ERROR_NEGATIVE_SEEK = 131;
const ERROR_SEEK_ON_DEVICE = 132;
const ERROR_IS_JOIN_TARGET = 133;
const ERROR_IS_JOINED = 134;
const ERROR_IS_SUBSTED = 135;
const ERROR_NOT_JOINED = 136;
const ERROR_NOT_SUBSTED = 137;
const ERROR_JOIN_TO_JOIN = 138;
const ERROR_SUBST_TO_SUBST = 139;
const ERROR_JOIN_TO_SUBST = 140;
const ERROR_SUBST_TO_JOIN = 141;
const ERROR_BUSY_DRIVE = 142;
const ERROR_SAME_DRIVE = 143;
const ERROR_DIR_NOT_ROOT = 144;
const ERROR_DIR_NOT_EMPTY = 145;
const ERROR_IS_SUBST_PATH = 146;
const ERROR_IS_JOIN_PATH = 147;
const ERROR_PATH_BUSY = 148;
const ERROR_IS_SUBST_TARGET = 149;
const ERROR_SYSTEM_TRACE = 150;
const ERROR_INVALID_EVENT_COUNT = 151;
const ERROR_TOO_MANY_MUXWAITERS = 152;
const ERROR_INVALID_LIST_FORMAT = 153;
const ERROR_LABEL_TOO_LONG = 154;
const ERROR_TOO_MANY_TCBS = 155;
const ERROR_SIGNAL_REFUSED = 156;
const ERROR_DISCARDED = 157;
const ERROR_NOT_LOCKED = 158;
const ERROR_BAD_THREADID_ADDR = 159;
const ERROR_BAD_ARGUMENTS = 160;
const ERROR_BAD_PATHNAME = 161;
const ERROR_SIGNAL_PENDING = 162;
const ERROR_MAX_THRDS_REACHED = 164;
const ERROR_LOCK_FAILED = 167;
const ERROR_BUSY = 170;
const ERROR_DEVICE_SUPPORT_IN_PROGRESS = 171;
const ERROR_CANCEL_VIOLATION = 173;
const ERROR_ATOMIC_LOCKS_NOT_SUPPORTED = 174;
const ERROR_INVALID_SEGMENT_NUMBER = 180;
const ERROR_INVALID_ORDINAL = 182;
const ERROR_ALREADY_EXISTS = 183;
const ERROR_INVALID_FLAG_NUMBER = 186;
const ERROR_SEM_NOT_FOUND = 187;
const ERROR_INVALID_STARTING_CODESEG = 188;
const ERROR_INVALID_STACKSEG = 189;
const ERROR_INVALID_MODULETYPE = 190;
const ERROR_INVALID_EXE_SIGNATURE = 191;
const ERROR_EXE_MARKED_INVALID = 192;
const ERROR_BAD_EXE_FORMAT = 193;
const ERROR_ITERATED_DATA_EXCEEDS_64k = 194;
const ERROR_INVALID_MINALLOCSIZE = 195;
const ERROR_DYNLINK_FROM_INVALID_RING = 196;
const ERROR_IOPL_NOT_ENABLED = 197;
const ERROR_INVALID_SEGDPL = 198;
const ERROR_AUTODATASEG_EXCEEDS_64k = 199;
const ERROR_MORE_DATA = 234;
const ERROR_NO_MORE_ITEMS = 259;
const ERROR_INVALID_FLAGS = 1004;
const ERROR_CANCELLED = 1223;
const ERROR_NOT_FOUND = 1168;
const ERROR_REVISION_MISMATCH = 1306;
const ERROR_NO_SUCH_LOGON_SESSION = 1312;
const ERROR_BAD_USERNAME = 2202;

const APPMODEL_ERROR_NO_PACKAGE = 15700;
const APPMODEL_ERROR_PACKAGE_RUNTIME_CORRUPT = 15701;
const APPMODEL_ERROR_PACKAGE_IDENTITY_CORRUPT = 15702;
const APPMODEL_ERROR_NO_APPLICATION = 15703;
const APPMODEL_ERROR_DYNAMIC_PROPERTY_READ_FAILED = 15704;
const APPMODEL_ERROR_DYNAMIC_PROPERTY_INVALID = 15705;
const APPMODEL_ERROR_PACKAGE_NOT_AVAILABLE = 15706;
const APPMODEL_ERROR_NO_MUTABLE_DIRECTORY = 15707;

// -----------------------------------------------------------------------------
// HID constants
// -----------------------------------------------------------------------------
const HID_USAGE_PAGE_UNDEFINED = 0x00;
const HID_USAGE_PAGE_GENERIC = 0x01;
const HID_USAGE_PAGE_SIMULATION = 0x02;
const HID_USAGE_PAGE_VR = 0x03;
const HID_USAGE_PAGE_SPORT = 0x04;
const HID_USAGE_PAGE_GAME = 0x05;
const HID_USAGE_PAGE_GENERIC_DEVICE = 0x06;
const HID_USAGE_PAGE_KEYBOARD = 0x07;
const HID_USAGE_PAGE_LED = 0x08;
const HID_USAGE_PAGE_BUTTON = 0x09;
const HID_USAGE_PAGE_ORDINAL = 0x0A;
const HID_USAGE_PAGE_TELEPHONY = 0x0B;
const HID_USAGE_PAGE_CONSUMER = 0x0C;
const HID_USAGE_PAGE_DIGITIZER = 0x0D;
const HID_USAGE_PAGE_HAPTICS = 0x0E;
const HID_USAGE_PAGE_PID = 0x0F;
const HID_USAGE_PAGE_UNICODE = 0x10;
const HID_USAGE_PAGE_ALPHANUMERIC = 0x14;
const HID_USAGE_PAGE_SENSOR = 0x20;
const HID_USAGE_PAGE_LIGHTING_ILLUMINATION = 0x59;
const HID_USAGE_PAGE_BARCODE_SCANNER = 0x8C;
const HID_USAGE_PAGE_WEIGHING_DEVICE = 0x8D;
const HID_USAGE_PAGE_MAGNETIC_STRIPE_READER = 0x8E;
const HID_USAGE_PAGE_CAMERA_CONTROL = 0x90;
const HID_USAGE_PAGE_ARCADE = 0x91;

const HID_USAGE_GENERIC_POINTER = 0x01;
const HID_USAGE_GENERIC_MOUSE = 0x02;
const HID_USAGE_GENERIC_JOYSTICK = 0x04;
const HID_USAGE_GENERIC_GAMEPAD = 0x05;
const HID_USAGE_GENERIC_KEYBOARD = 0x06;
const HID_USAGE_GENERIC_KEYPAD = 0x07;
const HID_USAGE_GENERIC_MULTI_AXIS_CONTROLLER = 0x08;
const HID_USAGE_GENERIC_TABLET_PC_SYSTEM_CTL = 0x09;
const HID_USAGE_GENERIC_PORTABLE_DEVICE_CONTROL = 0x0D;
const HID_USAGE_GENERIC_INTERACTIVE_CONTROL = 0x0E;
const HID_USAGE_GENERIC_COUNTED_BUFFER = 0x3A;
const HID_USAGE_GENERIC_SYSTEM_CTL = 0x80;
const HID_USAGE_GENERIC_X = 0x30;
const HID_USAGE_GENERIC_Y = 0x31;
const HID_USAGE_GENERIC_Z = 0x32;
const HID_USAGE_GENERIC_RX = 0x33;
const HID_USAGE_GENERIC_RY = 0x34;
const HID_USAGE_GENERIC_RZ = 0x35;
const HID_USAGE_GENERIC_SLIDER = 0x36;
const HID_USAGE_GENERIC_DIAL = 0x37;
const HID_USAGE_GENERIC_WHEEL = 0x38;
const HID_USAGE_GENERIC_HATSWITCH = 0x39;
const HID_USAGE_GENERIC_BYTE_COUNT = 0x3B;
const HID_USAGE_GENERIC_MOTION_WAKEUP = 0x3C;
const HID_USAGE_GENERIC_START = 0x3D;
const HID_USAGE_GENERIC_SELECT = 0x3E;
const HID_USAGE_GENERIC_VX = 0x40;
const HID_USAGE_GENERIC_VY = 0x41;
const HID_USAGE_GENERIC_VZ = 0x42;
const HID_USAGE_GENERIC_VBRX = 0x43;
const HID_USAGE_GENERIC_VBRY = 0x44;
const HID_USAGE_GENERIC_VBRZ = 0x45;
const HID_USAGE_GENERIC_VNO = 0x46;
const HID_USAGE_GENERIC_FEATURE_NOTIFICATION = 0x47;
const HID_USAGE_GENERIC_RESOLUTION_MULTIPLIER = 0x48;
const HID_USAGE_GENERIC_SYSCTL_POWER = 0x81;
const HID_USAGE_GENERIC_SYSCTL_SLEEP = 0x82;
const HID_USAGE_GENERIC_SYSCTL_WAKE = 0x83;
const HID_USAGE_GENERIC_SYSCTL_CONTEXT_MENU = 0x84;
const HID_USAGE_GENERIC_SYSCTL_MAIN_MENU = 0x85;
const HID_USAGE_GENERIC_SYSCTL_APP_MENU = 0x86;
const HID_USAGE_GENERIC_SYSCTL_HELP_MENU = 0x87;
const HID_USAGE_GENERIC_SYSCTL_MENU_EXIT = 0x88;
const HID_USAGE_GENERIC_SYSCTL_MENU_SELECT = 0x89;
const HID_USAGE_GENERIC_SYSCTL_MENU_RIGHT = 0x8A;
const HID_USAGE_GENERIC_SYSCTL_MENU_LEFT = 0x8B;
const HID_USAGE_GENERIC_SYSCTL_MENU_UP = 0x8C;
const HID_USAGE_GENERIC_SYSCTL_MENU_DOWN = 0x8D;
const HID_USAGE_GENERIC_SYSCTL_COLD_RESTART = 0x8E;
const HID_USAGE_GENERIC_SYSCTL_WARM_RESTART = 0x8F;
const HID_USAGE_GENERIC_DPAD_UP = 0x90;
const HID_USAGE_GENERIC_DPAD_DOWN = 0x91;
const HID_USAGE_GENERIC_DPAD_RIGHT = 0x92;
const HID_USAGE_GENERIC_DPAD_LEFT = 0x93;
const HID_USAGE_GENERIC_SYSCTL_FN = 0x97;
const HID_USAGE_GENERIC_SYSCTL_FN_LOCK = 0x98;
const HID_USAGE_GENERIC_SYSCTL_FN_LOCK_INDICATOR = 0x99;
const HID_USAGE_GENERIC_SYSCTL_DISMISS_NOTIFICATION = 0x9A;
const HID_USAGE_GENERIC_SYSCTL_DOCK = 0xA0;
const HID_USAGE_GENERIC_SYSCTL_UNDOCK = 0xA1;
const HID_USAGE_GENERIC_SYSCTL_SETUP = 0xA2;
const HID_USAGE_GENERIC_SYSCTL_SYS_BREAK = 0xA3;
const HID_USAGE_GENERIC_SYSCTL_SYS_DBG_BREAK = 0xA4;
const HID_USAGE_GENERIC_SYSCTL_APP_BREAK = 0xA5;
const HID_USAGE_GENERIC_SYSCTL_APP_DBG_BREAK = 0xA6;
const HID_USAGE_GENERIC_SYSCTL_MUTE = 0xA7;
const HID_USAGE_GENERIC_SYSCTL_HIBERNATE = 0xA8;
const HID_USAGE_GENERIC_SYSCTL_DISP_INVERT = 0xB0;
const HID_USAGE_GENERIC_SYSCTL_DISP_INTERNAL = 0xB1;
const HID_USAGE_GENERIC_SYSCTL_DISP_EXTERNAL = 0xB2;
const HID_USAGE_GENERIC_SYSCTL_DISP_BOTH = 0xB3;
const HID_USAGE_GENERIC_SYSCTL_DISP_DUAL = 0xB4;
const HID_USAGE_GENERIC_SYSCTL_DISP_TOGGLE = 0xB5;
const HID_USAGE_GENERIC_SYSCTL_DISP_SWAP = 0xB6;
const HID_USAGE_GENERIC_SYSCTL_DISP_AUTOSCALE = 0xB7;
const HID_USAGE_GENERIC_SYSTEM_DISPLAY_ROTATION_LOCK_BUTTON = 0xC9;
const HID_USAGE_GENERIC_SYSTEM_DISPLAY_ROTATION_LOCK_SLIDER_SWITCH = 0xCA;
const HID_USAGE_GENERIC_CONTROL_ENABLE = 0xCB;

const HID_USAGE_KEYBOARD_NOEVENT = 0x00;
const HID_USAGE_KEYBOARD_ROLLOVER = 0x01;
const HID_USAGE_KEYBOARD_POSTFAIL = 0x02;
const HID_USAGE_KEYBOARD_UNDEFINED = 0x03;
const HID_USAGE_KEYBOARD_aA = 0x04;
const HID_USAGE_KEYBOARD_zZ = 0x1D;
const HID_USAGE_KEYBOARD_ONE = 0x1E;
const HID_USAGE_KEYBOARD_ZERO = 0x27;
const HID_USAGE_KEYBOARD_LCTRL = 0xE0;
const HID_USAGE_KEYBOARD_LSHFT = 0xE1;
const HID_USAGE_KEYBOARD_LALT = 0xE2;
const HID_USAGE_KEYBOARD_LGUI = 0xE3;
const HID_USAGE_KEYBOARD_RCTRL = 0xE4;
const HID_USAGE_KEYBOARD_RSHFT = 0xE5;
const HID_USAGE_KEYBOARD_RALT = 0xE6;
const HID_USAGE_KEYBOARD_RGUI = 0xE7;
const HID_USAGE_KEYBOARD_SCROLL_LOCK = 0x47;
const HID_USAGE_KEYBOARD_NUM_LOCK = 0x53;
const HID_USAGE_KEYBOARD_CAPS_LOCK = 0x39;
const HID_USAGE_KEYBOARD_F1 = 0x3A;
const HID_USAGE_KEYBOARD_F2 = 0x3B;
const HID_USAGE_KEYBOARD_F3 = 0x3C;
const HID_USAGE_KEYBOARD_F4 = 0x3D;
const HID_USAGE_KEYBOARD_F5 = 0x3E;
const HID_USAGE_KEYBOARD_F6 = 0x3F;
const HID_USAGE_KEYBOARD_F7 = 0x40;
const HID_USAGE_KEYBOARD_F8 = 0x41;
const HID_USAGE_KEYBOARD_F9 = 0x42;
const HID_USAGE_KEYBOARD_F10 = 0x43;
const HID_USAGE_KEYBOARD_F11 = 0x44;
const HID_USAGE_KEYBOARD_F12 = 0x45;
const HID_USAGE_KEYBOARD_F13 = 0x68;
const HID_USAGE_KEYBOARD_F14 = 0x69;
const HID_USAGE_KEYBOARD_F15 = 0x6A;
const HID_USAGE_KEYBOARD_F16 = 0x6B;
const HID_USAGE_KEYBOARD_F17 = 0x6C;
const HID_USAGE_KEYBOARD_F18 = 0x6D;
const HID_USAGE_KEYBOARD_F19 = 0x6E;
const HID_USAGE_KEYBOARD_F20 = 0x6F;
const HID_USAGE_KEYBOARD_F21 = 0x70;
const HID_USAGE_KEYBOARD_F22 = 0x71;
const HID_USAGE_KEYBOARD_F23 = 0x72;
const HID_USAGE_KEYBOARD_F24 = 0x73;
const HID_USAGE_KEYBOARD_RETURN = 0x28;
const HID_USAGE_KEYBOARD_ESCAPE = 0x29;
const HID_USAGE_KEYBOARD_DELETE = 0x2A;
const HID_USAGE_KEYBOARD_PRINT_SCREEN = 0x46;
const HID_USAGE_KEYBOARD_DELETE_FORWARD = 0x4C;

// -----------------------------------------------------------------------------
// WindowMessage constants
// -----------------------------------------------------------------------------
const WM_CTLCOLORMSGBOX = 0x0132;
const WM_CTLCOLOREDIT = 0x0133;
const WM_CTLCOLORLISTBOX = 0x0134;
const WM_CTLCOLORBTN = 0x0135;
const WM_CTLCOLORDLG = 0x0136;
const WM_CTLCOLORSCROLLBAR = 0x0137;
const WM_CTLCOLORSTATIC = 0x0138;
const MN_GETHMENU = 0x01E1;
const FVIRTKEY = TRUE;
const FNOINVERT = 0x02;
const FSHIFT = 0x04;
const FCONTROL = 0x08;
const FALT = 0x10;
const LF_FACESIZE = 32;
const LF_FULLFACESIZE = 64;
const HWND_DESKTOP = 0;

// -----------------------------------------------------------------------------
// System-wide parameters
// -----------------------------------------------------------------------------
const SPI_GETSHOWSOUNDS = 0x0038;
const SPI_SETSHOWSOUNDS = 0x0039;
const SPI_GETSTICKYKEYS = 0x003A;
const SPI_SETSTICKYKEYS = 0x003B;
const SPI_GETACCESSTIMEOUT = 0x003C;
const SPI_SETACCESSTIMEOUT = 0x003D;
const SPI_GETSERIALKEYS = 0x003E;
const SPI_SETSERIALKEYS = 0x003F;
const SPI_GETSOUNDSENTRY = 0x0040;
const SPI_SETSOUNDSENTRY = 0x0041;
const SPI_GETSNAPTODEFBUTTON = 0x005F;
const SPI_SETSNAPTODEFBUTTON = 0x0060;
const SPI_GETMOUSEHOVERWIDTH = 0x0062;
const SPI_SETMOUSEHOVERWIDTH = 0x0063;
const SPI_GETMOUSEHOVERHEIGHT = 0x0064;
const SPI_SETMOUSEHOVERHEIGHT = 0x0065;
const SPI_GETMOUSEHOVERTIME = 0x0066;
const SPI_SETMOUSEHOVERTIME = 0x0067;
const SPI_GETWHEELSCROLLLINES = 0x0068;
const SPI_SETWHEELSCROLLLINES = 0x0069;
const SPI_GETMENUSHOWDELAY = 0x006A;
const SPI_SETMENUSHOWDELAY = 0x006B;
const SPI_GETWHEELSCROLLCHARS = 0x006C;
const SPI_SETWHEELSCROLLCHARS = 0x006D;
const SPI_GETSHOWIMEUI = 0x006E;
const SPI_SETSHOWIMEUI = 0x006F;
const SPI_GETMOUSESPEED = 0x0070;
const SPI_SETMOUSESPEED = 0x0071;
const SPI_GETSCREENSAVERRUNNING = 0x0072;
const SPI_GETDESKWALLPAPER = 0x0073;
const SPI_GETAUDIODESCRIPTION = 0x0074;
const SPI_SETAUDIODESCRIPTION = 0x0075;
const SPI_GETSCREENSAVESECURE = 0x0076;
const SPI_SETSCREENSAVESECURE = 0x0077;
const SPI_GETHUNGAPPTIMEOUT = 0x0078;
const SPI_SETHUNGAPPTIMEOUT = 0x0079;
const SPI_GETWAITTOKILLTIMEOUT = 0x007A;
const SPI_SETWAITTOKILLTIMEOUT = 0x007B;
const SPI_GETWAITTOKILLSERVICETIMEOUT = 0x007C;
const SPI_SETWAITTOKILLSERVICETIMEOUT = 0x007D;
const SPI_GETMOUSEDOCKTHRESHOLD = 0x007E;
const SPI_SETMOUSEDOCKTHRESHOLD = 0x007F;
const SPI_GETPENDOCKTHRESHOLD = 0x0080;
const SPI_SETPENDOCKTHRESHOLD = 0x0081;
const SPI_GETWINARRANGING = 0x0082;
const SPI_SETWINARRANGING = 0x0083;
const SPI_GETMOUSEDRAGOUTTHRESHOLD = 0x0084;
const SPI_SETMOUSEDRAGOUTTHRESHOLD = 0x0085;
const SPI_GETPENDRAGOUTTHRESHOLD = 0x0086;
const SPI_SETPENDRAGOUTTHRESHOLD = 0x0087;
const SPI_GETMOUSESIDEMOVETHRESHOLD = 0x0088;
const SPI_SETMOUSESIDEMOVETHRESHOLD = 0x0089;
const SPI_GETPENSIDEMOVETHRESHOLD = 0x008A;
const SPI_SETPENSIDEMOVETHRESHOLD = 0x008B;
const SPI_GETDRAGFROMMAXIMIZE = 0x008C;
const SPI_SETDRAGFROMMAXIMIZE = 0x008D;
const SPI_GETSNAPSIZING = 0x008E;
const SPI_SETSNAPSIZING = 0x008F;
const SPI_GETDOCKMOVING = 0x0090;
const SPI_SETDOCKMOVING = 0x0091;

// Menu flags
const MF_INSERT = 0x00000000;
const MF_CHANGE = 0x00000080;
const MF_APPEND = 0x00000100;
const MF_DELETE = 0x00000200;
const MF_REMOVE = 0x00001000;
const MF_USECHECKBITMAPS = 0x00000200;
const MF_DEFAULT = 0x00001000;
const MF_SYSMENU = 0x00002000;
const MF_HELP = 0x00004000;
const MF_RIGHTJUSTIFY = 0x00004000;
const MF_MOUSESELECT = 0x00008000;
const MF_END = 0x00000080;

const ANSI_CHARSET = 0;
const DEFAULT_CHARSET = 1;
const SYMBOL_CHARSET = 2;
const SHIFTJIS_CHARSET = 128;
const HANGEUL_CHARSET = 129;
const HANGUL_CHARSET = 129;
const GB2312_CHARSET = 134;
const CHINESEBIG5_CHARSET = 136;
const OEM_CHARSET = 255;
const JOHAB_CHARSET = 130;
const HEBREW_CHARSET = 177;
const ARABIC_CHARSET = 178;
const GREEK_CHARSET = 161;
const TURKISH_CHARSET = 162;
const VIETNAMESE_CHARSET = 163;
const THAI_CHARSET = 222;
const EASTEUROPE_CHARSET = 238;
const RUSSIAN_CHARSET = 204;

// Common Dialog window strings
const LBSELCHSTRING = 'commdlg_LBSelChangedNotify';
const SHAREVISTRING = 'commdlg_ShareViolation';
const FILEOKSTRING = 'commdlg_FileNameOK';
const COLOROKSTRING = 'commdlg_ColorOK';
const SETRGBSTRING = 'commdlg_SetRGBColor';
const HELPMSGSTRING = 'commdlg_help';
const FINDMSGSTRING = 'commdlg_FindReplace';

// Stock logical objects
const WHITE_BRUSH = 0;
const LTGRAY_BRUSH = 1;
const GRAY_BRUSH = 2;
const DKGRAY_BRUSH = 3;
const BLACK_BRUSH = 4;
const NULL_BRUSH = 5;
const HOLLOW_BRUSH = NULL_BRUSH;
const WHITE_PEN = 6;
const BLACK_PEN = 7;
const NULL_PEN = 8;
const OEM_FIXED_FONT = 10;
const ANSI_FIXED_FONT = 11;
const ANSI_VAR_FONT = 12;
const SYSTEM_FONT = 13;
const DEVICE_DEFAULT_FONT = 14;
const DEFAULT_PALETTE = 15;
const SYSTEM_FIXED_FONT = 16;

// Background modes
const TRANSPARENT = 1;
const OPAQUE = 2;
const BKMODE_LAST = 2;

// DIB color table identifiers
const DIB_RGB_COLORS = 0;
const DIB_PAL_COLORS = 1;

// GetDeviceCaps capabilities
const DT_PLOTTER = 0;
const DT_RASDISPLAY = 1;
const DT_RASPRINTER = 2;
const DT_RASCAMERA = 3;
const DT_CHARSTREAM = 4;
const DT_METAFILE = 5;
const DT_DISPFILE = 6;
const CC_NONE = 0;
const CC_CIRCLES = 1;
const CC_PIE = 2;
const CC_CHORD = 4;
const CC_ELLIPSES = 8;
const CC_WIDE = 16;
const CC_STYLED = 32;
const CC_WIDESTYLED = 64;
const CC_INTERIORS = 128;
const CC_ROUNDRECT = 256;
const LC_NONE = 0;
const LC_POLYLINE = 2;
const LC_MARKER = 4;
const LC_POLYMARKER = 8;
const LC_WIDE = 16;
const LC_STYLED = 32;
const LC_WIDESTYLED = 64;
const LC_INTERIORS = 128;
const PC_NONE = 0;
const PC_POLYGON = 1;
const PC_RECTANGLE = 2;
const PC_WINDPOLYGON = 4;
const PC_TRAPEZOID = 4;
const PC_SCANLINE = 8;
const PC_WIDE = 16;
const PC_STYLED = 32;
const PC_WIDESTYLED = 64;
const PC_INTERIORS = 128;
const PC_POLYPOLYGON = 256;
const PC_PATHS = 512;
const CP_NONE = 0;
const CP_RECTANGLE = 1;
const CP_REGION = 2;
const TC_OP_CHARACTER = 0x00000001;
const TC_OP_STROKE = 0x00000002;
const TC_CP_STROKE = 0x00000004;
const TC_CR_90 = 0x00000008;
const TC_CR_ANY = 0x00000010;
const TC_SF_X_YINDEP = 0x00000020;
const TC_SA_DOUBLE = 0x00000040;
const TC_SA_INTEGER = 0x00000080;
const TC_SA_CONTIN = 0x00000100;
const TC_EA_DOUBLE = 0x00000200;
const TC_IA_ABLE = 0x00000400;
const TC_UA_ABLE = 0x00000800;
const TC_SO_ABLE = 0x00001000;
const TC_RA_ABLE = 0x00002000;
const TC_VA_ABLE = 0x00004000;
const TC_RESERVED = 0x00008000;
const TC_SCROLLBLT = 0x00010000;
const RC_NONE = 0;
const RC_BITBLT = 1;
const RC_BANDING = 2;
const RC_SCALING = 4;
const RC_BITMAP64 = 8;
const RC_GDI20_OUTPUT = 0x0010;
const RC_GDI20_STATE = 0x0020;
const RC_SAVEBITMAP = 0x0040;
const RC_DI_BITMAP = 0x0080;
const RC_PALETTE = 0x0100;
const RC_DIBTODEV = 0x0200;
const RC_BIGFONT = 0x0400;
const RC_STRETCHBLT = 0x0800;
const RC_FLOODFILL = 0x1000;
const RC_STRETCHDIB = 0x2000;
const RC_OP_DX_OUTPUT = 0x4000;
const RC_DEVBITS = 0x8000;
const SB_NONE = 0x00000000;
const SB_CONST_ALPHA = 0x00000001;
const SB_PIXEL_ALPHA = 0x00000002;
const SB_PREMULT_ALPHA = 0x00000004;
const SB_GRAD_RECT = 0x00000010;
const SB_GRAD_TRI = 0x00000020;
const CM_NONE = 0x00000000;
const CM_DEVICE_ICM = 0x00000001;
const CM_GAMMA_RAMP = 0x00000002;
const CM_CMYK_COLOR = 0x00000004;

/* Ternary raster operations */
const SRCCOPY = 0x00CC0020;
const SRCPAINT = 0x00EE0086;
const SRCAND = 0x008800C6;
const SRCINVERT = 0x00660046;
const SRCERASE = 0x00440328;
const NOTSRCCOPY = 0x00330008;
const NOTSRCERASE = 0x001100A6;
const MERGECOPY = 0x00C000CA;
const MERGEPAINT = 0x00BB0226;
const PATCOPY = 0x00F00021;
const PATPAINT = 0x00FB0A09;
const PATINVERT = 0x005A0049;
const DSTINVERT = 0x00550009;
const BLACKNESS = 0x00000042;
const WHITENESS = 0x00FF0062;
const NOMIRRORBITMAP = 0x80000000;
const CAPTUREBLT = 0x40000000;

// Dialog box command IDs
const IDOK = 1;
const IDCANCEL = 2;
const IDABORT = 3;
const IDRETRY = 4;
const IDIGNORE = 5;
const IDYES = 6;
const IDNO = 7;
const IDCLOSE = 8;
const IDHELP = 9;
const IDTRYAGAIN = 10;
const IDCONTINUE = 11;
const IDTIMEOUT = 32000;

// Virtual keys
const VK_LBUTTON = 0x01;
const VK_RBUTTON = 0x02;
const VK_CANCEL = 0x03;
const VK_MBUTTON = 0x04;
const VK_XBUTTON1 = 0x05;
const VK_XBUTTON2 = 0x06;
const VK_BACK = 0x08;
const VK_TAB = 0x09;
const VK_CLEAR = 0x0C;
const VK_RETURN = 0x0D;
const VK_SHIFT = 0x10;
const VK_CONTROL = 0x11;
const VK_MENU = 0x12;
const VK_PAUSE = 0x13;
const VK_CAPITAL = 0x14;
const VK_KANA = 0x15;
const VK_HANGEUL = 0x15;
const VK_HANGUL = 0x15;
const VK_JUNJA = 0x17;
const VK_FINAL = 0x18;
const VK_HANJA = 0x19;
const VK_KANJI = 0x19;
const VK_ESCAPE = 0x1B;
const VK_CONVERT = 0x1C;
const VK_NONCONVERT = 0x1D;
const VK_ACCEPT = 0x1E;
const VK_MODECHANGE = 0x1F;
const VK_SPACE = 0x20;
const VK_PRIOR = 0x21;
const VK_NEXT = 0x22;
const VK_END = 0x23;
const VK_HOME = 0x24;
const VK_LEFT = 0x25;
const VK_UP = 0x26;
const VK_RIGHT = 0x27;
const VK_DOWN = 0x28;
const VK_SELECT = 0x29;
const VK_PRINT = 0x2A;
const VK_EXECUTE = 0x2B;
const VK_SNAPSHOT = 0x2C;
const VK_INSERT = 0x2D;
const VK_DELETE = 0x2E;
const VK_HELP = 0x2F;
const VK_LWIN = 0x5B;
const VK_RWIN = 0x5C;
const VK_APPS = 0x5D;
const VK_SLEEP = 0x5F;
const VK_NUMPAD0 = 0x60;
const VK_NUMPAD1 = 0x61;
const VK_NUMPAD2 = 0x62;
const VK_NUMPAD3 = 0x63;
const VK_NUMPAD4 = 0x64;
const VK_NUMPAD5 = 0x65;
const VK_NUMPAD6 = 0x66;
const VK_NUMPAD7 = 0x67;
const VK_NUMPAD8 = 0x68;
const VK_NUMPAD9 = 0x69;
const VK_MULTIPLY = 0x6A;
const VK_ADD = 0x6B;
const VK_SEPARATOR = 0x6C;
const VK_SUBTRACT = 0x6D;
const VK_DECIMAL = 0x6E;
const VK_DIVIDE = 0x6F;
const VK_F1 = 0x70;
const VK_F2 = 0x71;
const VK_F3 = 0x72;
const VK_F4 = 0x73;
const VK_F5 = 0x74;
const VK_F6 = 0x75;
const VK_F7 = 0x76;
const VK_F8 = 0x77;
const VK_F9 = 0x78;
const VK_F10 = 0x79;
const VK_F11 = 0x7A;
const VK_F12 = 0x7B;
const VK_F13 = 0x7C;
const VK_F14 = 0x7D;
const VK_F15 = 0x7E;
const VK_F16 = 0x7F;
const VK_F17 = 0x80;
const VK_F18 = 0x81;
const VK_F19 = 0x82;
const VK_F20 = 0x83;
const VK_F21 = 0x84;
const VK_F22 = 0x85;
const VK_F23 = 0x86;
const VK_F24 = 0x87;
const VK_NUMLOCK = 0x90;
const VK_SCROLL = 0x91;
const VK_LSHIFT = 0xA0;
const VK_RSHIFT = 0xA1;
const VK_LCONTROL = 0xA2;
const VK_RCONTROL = 0xA3;
const VK_LMENU = 0xA4;
const VK_RMENU = 0xA5;
const VK_BROWSER_BACK = 0xA6;
const VK_BROWSER_FORWARD = 0xA7;
const VK_BROWSER_REFRESH = 0xA8;
const VK_BROWSER_STOP = 0xA9;
const VK_BROWSER_SEARCH = 0xAA;
const VK_BROWSER_FAVORITES = 0xAB;
const VK_BROWSER_HOME = 0xAC;
const VK_VOLUME_MUTE = 0xAD;
const VK_VOLUME_DOWN = 0xAE;
const VK_VOLUME_UP = 0xAF;
const VK_MEDIA_NEXT_TRACK = 0xB0;
const VK_MEDIA_PREV_TRACK = 0xB1;
const VK_MEDIA_STOP = 0xB2;
const VK_MEDIA_PLAY_PAUSE = 0xB3;
const VK_LAUNCH_MAIL = 0xB4;
const VK_LAUNCH_MEDIA_SELECT = 0xB5;
const VK_LAUNCH_APP1 = 0xB6;
const VK_LAUNCH_APP2 = 0xB7;
const VK_OEM_1 = 0xBA;
const VK_OEM_PLUS = 0xBB;
const VK_OEM_COMMA = 0xBC;
const VK_OEM_MINUS = 0xBD;
const VK_OEM_PERIOD = 0xBE;
const VK_OEM_2 = 0xBF;
const VK_OEM_3 = 0xC0;
const VK_OEM_4 = 0xDB;
const VK_OEM_5 = 0xDC;
const VK_OEM_6 = 0xDD;
const VK_OEM_7 = 0xDE;
const VK_OEM_8 = 0xDF;
const VK_OEM_AX = 0xE1;
const VK_OEM_102 = 0xE2;
const VK_ICO_HELP = 0xE3;
const VK_ICO_00 = 0xE4;
const VK_PROCESSKEY = 0xE5;
const VK_ICO_CLEAR = 0xE6;
const VK_PACKET = 0xE7;

// Hook codes
const HC_ACTION = 0;

// Input types
const INPUT_MOUSE = 0;
const INPUT_KEYBOARD = 1;
const INPUT_HARDWARE = 2;

// Keyboard and mouse events
const KEYEVENTF_EXTENDEDKEY = 0x0001;
const KEYEVENTF_KEYUP = 0x0002;
const KEYEVENTF_UNICODE = 0x0004;
const KEYEVENTF_SCANCODE = 0x0008;
const MOUSEEVENTF_MOVE = 0x0001;
const MOUSEEVENTF_LEFTDOWN = 0x0002;
const MOUSEEVENTF_LEFTUP = 0x0004;
const MOUSEEVENTF_RIGHTDOWN = 0x0008;
const MOUSEEVENTF_RIGHTUP = 0x0010;
const MOUSEEVENTF_MIDDLEDOWN = 0x0020;
const MOUSEEVENTF_MIDDLEUP = 0x0040;
const MOUSEEVENTF_XDOWN = 0x0080;
const MOUSEEVENTF_XUP = 0x0100;
const MOUSEEVENTF_WHEEL = 0x0800;
const MOUSEEVENTF_HWHEEL = 0x01000;
const MOUSEEVENTF_MOVE_NOCOALESCE = 0x2000;
const MOUSEEVENTF_VIRTUALDESK = 0x4000;
const MOUSEEVENTF_ABSOLUTE = 0x8000;

// Classic Folder IDs
const CSIDL_DESKTOP = 0x0000;
const CSIDL_INTERNET = 0x0001;
const CSIDL_PROGRAMS = 0x0002;
const CSIDL_CONTROLS = 0x0003;
const CSIDL_PRINTERS = 0x0004;
const CSIDL_PERSONAL = 0x0005;
const CSIDL_FAVORITES = 0x0006;
const CSIDL_STARTUP = 0x0007;
const CSIDL_RECENT = 0x0008;
const CSIDL_SENDTO = 0x0009;
const CSIDL_BITBUCKET = 0x000a;
const CSIDL_STARTMENU = 0x000b;
const CSIDL_MYDOCUMENTS = CSIDL_PERSONAL;
const CSIDL_MYMUSIC = 0x000d;
const CSIDL_MYVIDEO = 0x000e;
const CSIDL_DESKTOPDIRECTORY = 0x0010;
const CSIDL_DRIVES = 0x0011;
const CSIDL_NETWORK = 0x0012;
const CSIDL_NETHOOD = 0x0013;
const CSIDL_FONTS = 0x0014;
const CSIDL_TEMPLATES = 0x0015;
const CSIDL_COMMON_STARTMENU = 0x0016;
const CSIDL_COMMON_PROGRAMS = 0X0017;
const CSIDL_COMMON_STARTUP = 0x0018;
const CSIDL_COMMON_DESKTOPDIRECTORY = 0x0019;
const CSIDL_APPDATA = 0x001a;
const CSIDL_PRINTHOOD = 0x001b;
const CSIDL_LOCAL_APPDATA = 0x001c;
const CSIDL_ALTSTARTUP = 0x001d;
const CSIDL_COMMON_ALTSTARTUP = 0x001e;
const CSIDL_COMMON_FAVORITES = 0x001f;
const CSIDL_INTERNET_CACHE = 0x0020;
const CSIDL_COOKIES = 0x0021;
const CSIDL_HISTORY = 0x0022;
const CSIDL_COMMON_APPDATA = 0x0023;
const CSIDL_WINDOWS = 0x0024;
const CSIDL_SYSTEM = 0x0025;
const CSIDL_PROGRAM_FILES = 0x0026;
const CSIDL_MYPICTURES = 0x0027;
const CSIDL_PROFILE = 0x0028;
const CSIDL_SYSTEMX86 = 0x0029;
const CSIDL_PROGRAM_FILESX86 = 0x002a;
const CSIDL_PROGRAM_FILES_COMMON = 0x002b;
const CSIDL_PROGRAM_FILES_COMMONX86 = 0x002c;
const CSIDL_COMMON_TEMPLATES = 0x002d;
const CSIDL_COMMON_DOCUMENTS = 0x002e;
const CSIDL_COMMON_ADMINTOOLS = 0x002f;
const CSIDL_ADMINTOOLS = 0x0030;
const CSIDL_CONNECTIONS = 0x0031;
const CSIDL_COMMON_MUSIC = 0x0035;
const CSIDL_COMMON_PICTURES = 0x0036;
const CSIDL_COMMON_VIDEO = 0x0037;
const CSIDL_RESOURCES = 0x0038;
const CSIDL_RESOURCES_LOCALIZED = 0x0039;
const CSIDL_COMMON_OEM_LINKS = 0x003a;
const CSIDL_CDBURN_AREA = 0x003b;
const CSIDL_COMPUTERSNEARME = 0x003d;
const CSIDL_FLAG_CREATE = 0x8000;
const CSIDL_FLAG_DONT_VERIFY = 0x4000;
const CSIDL_FLAG_DONT_UNEXPAND = 0x2000;
const CSIDL_FLAG_NO_ALIAS = 0x1000;
const CSIDL_FLAG_PER_USER_INIT = 0x0800;
const CSIDL_FLAG_MASK = 0xFF00;

// Version info constants
const FILE_VER_GET_LOCALISED = 0x01;
const FILE_VER_GET_NEUTRAL = 0x02;
const FILE_VER_GET_PREFETCHED = 0x04;
const VFFF_ISSHAREDFILE = 0x0001;
const VIFF_FORCEINSTALL = 0x0001;
const VIFF_DONTDELETEOLD = 0x0002;

// Process constants
const PROCESS_TERMINATE = 0x0001;
const PROCESS_CREATE_THREAD = 0x0002;
const PROCESS_SET_SESSIONID = 0x0004;
const PROCESS_VM_OPERATION = 0x0008;
const PROCESS_VM_READ = 0x0010;
const PROCESS_VM_WRITE = 0x0020;
const PROCESS_DUP_HANDLE = 0x0040;
const PROCESS_CREATE_PROCESS = 0x0080;
const PROCESS_SET_QUOTA = 0x0100;
const PROCESS_SET_INFORMATION = 0x0200;
const PROCESS_QUERY_INFORMATION = 0x0400;
const PROCESS_SUSPEND_RESUME = 0x0800;
const PROCESS_QUERY_LIMITED_INFORMATION = 0x1000;
const PROCESS_SET_LIMITED_INFORMATION = 0x2000;
const PROCESS_ALL_ACCESS = STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0xFFFF;
const PROC_THREAD_ATTRIBUTE_NUMBER = 0x0000FFFF;
const PROC_THREAD_ATTRIBUTE_THREAD = 0x00010000;
const PROC_THREAD_ATTRIBUTE_INPUT = 0x00020000;
const PROC_THREAD_ATTRIBUTE_ADDITIVE = 0x00040000;
const PROC_THREAD_ATTRIBUTE_PSEUDOCONSOLE =
    (PROC_THREAD_ATTRIBUTE_NUM.ProcThreadAttributePseudoConsole &
            PROC_THREAD_ATTRIBUTE_NUMBER) |
        PROC_THREAD_ATTRIBUTE_INPUT;

/// {@category Enum}
class PROC_THREAD_ATTRIBUTE_NUM {
  static const ProcThreadAttributeParentProcess = 0;
  static const ProcThreadAttributeHandleList = 2;
  static const ProcThreadAttributeGroupAffinity = 3;
  static const ProcThreadAttributePreferredNode = 4;
  static const ProcThreadAttributeIdealProcessor = 5;
  static const ProcThreadAttributeUmsThread = 6;
  static const ProcThreadAttributeMitigationPolicy = 7;
  static const ProcThreadAttributeSecurityCapabilities = 9;
  static const ProcThreadAttributeJobList = 13;
  static const ProcThreadAttributeChildProcessPolicy = 14;
  static const ProcThreadAttributeAllApplicationPackagesPolicy = 15;
  static const ProcThreadAttributeWin32kFilter = 16;
  static const ProcThreadAttributeSafeOpenPromptOriginClaim = 17;
  static const ProcThreadAttributeDesktopAppPolicy = 18;
  static const ProcThreadAttributePseudoConsole = 22;
}

// Common Control send messages
const UDM_SETRANGE = WM_USER + 101;
const UDM_GETRANGE = WM_USER + 102;
const UDM_SETPOS = WM_USER + 103;
const UDM_GETPOS = WM_USER + 104;
const UDM_SETBUDDY = WM_USER + 105;
const UDM_GETBUDDY = WM_USER + 106;
const UDM_SETACCEL = WM_USER + 107;
const UDM_GETACCEL = WM_USER + 108;
const UDM_SETBASE = WM_USER + 109;
const UDM_GETBASE = WM_USER + 110;
const UDM_SETRANGE32 = WM_USER + 111;
const UDM_GETRANGE32 = WM_USER + 112;
const UDM_SETUNICODEFORMAT = CCM_SETUNICODEFORMAT;
const UDM_GETUNICODEFORMAT = CCM_GETUNICODEFORMAT;
const UDM_SETPOS32 = WM_USER + 113;
const UDM_GETPOS32 = WM_USER + 114;
const CCM_FIRST = 0x2000;
const CCM_SETUNICODEFORMAT = CCM_FIRST + 5;
const CCM_GETUNICODEFORMAT = CCM_FIRST + 6;

// Version constants
const VER_MINORVERSION = 0x0000001;
const VER_MAJORVERSION = 0x0000002;
const VER_BUILDNUMBER = 0x0000004;
const VER_PLATFORMID = 0x0000008;
const VER_SERVICEPACKMINOR = 0x0000010;
const VER_SERVICEPACKMAJOR = 0x0000020;
const VER_SUITENAME = 0x0000040;
const VER_PRODUCT_TYPE = 0x0000080;

const VER_NT_WORKSTATION = 0x0000001;
const VER_NT_DOMAIN_CONTROLLER = 0x0000002;
const VER_NT_SERVER = 0x0000003;

// Process dwCreationFlags info
const DEBUG_PROCESS = 0x00000001;
const DEBUG_ONLY_THIS_PROCESS = 0x00000002;
const CREATE_SUSPENDED = 0x00000004;
const DETACHED_PROCESS = 0x00000008;
const CREATE_NEW_CONSOLE = 0x00000010;
const NORMAL_PRIORITY_CLASS = 0x00000020;
const IDLE_PRIORITY_CLASS = 0x00000040;
const HIGH_PRIORITY_CLASS = 0x00000080;
const REALTIME_PRIORITY_CLASS = 0x00000100;
const CREATE_NEW_PROCESS_GROUP = 0x00000200;
const CREATE_UNICODE_ENVIRONMENT = 0x00000400;
const CREATE_SEPARATE_WOW_VDM = 0x00000800;
const CREATE_SHARED_WOW_VDM = 0x00001000;
const CREATE_FORCEDOS = 0x00002000;
const BELOW_NORMAL_PRIORITY_CLASS = 0x00004000;
const ABOVE_NORMAL_PRIORITY_CLASS = 0x00008000;
const INHERIT_PARENT_AFFINITY = 0x00010000;
const INHERIT_CALLER_PRIORITY = 0x00020000;
const CREATE_PROTECTED_PROCESS = 0x00040000;
const EXTENDED_STARTUPINFO_PRESENT = 0x00080000;
const PROCESS_MODE_BACKGROUND_BEGIN = 0x00100000;
const PROCESS_MODE_BACKGROUND_END = 0x00200000;
const CREATE_SECURE_PROCESS = 0x00400000;
const CREATE_BREAKAWAY_FROM_JOB = 0x01000000;
const CREATE_PRESERVE_CODE_AUTHZ_LEVEL = 0x02000000;
const CREATE_DEFAULT_ERROR_MODE = 0x04000000;
const CREATE_NO_WINDOW = 0x08000000;
const PROFILE_USER = 0x10000000;
const PROFILE_KERNEL = 0x20000000;
const PROFILE_SERVER = 0x40000000;
const CREATE_IGNORE_SYSTEM_DEFAULT = 0x80000000;

// Registry keys
const HKEY_CLASSES_ROOT = 0x80000000;
const HKEY_CURRENT_USER = 0x80000001;
const HKEY_LOCAL_MACHINE = 0x80000002;
const HKEY_USERS = 0x80000003;
const HKEY_PERFORMANCE_DATA = 0x80000004;
const HKEY_PERFORMANCE_TEXT = 0x80000050;
const HKEY_PERFORMANCE_NLSTEXT = 0x80000060;
const HKEY_CURRENT_CONFIG = 0x80000005;
const HKEY_DYN_DATA = 0x80000006;
const HKEY_CURRENT_USER_LOCAL_SETTINGS = 0x80000007;
const RRF_RT_REG_NONE = 0x00000001;
const RRF_RT_REG_SZ = 0x00000002;
const RRF_RT_REG_EXPAND_SZ = 0x00000004;
const RRF_RT_REG_BINARY = 0x00000008;
const RRF_RT_REG_DWORD = 0x00000010;
const RRF_RT_REG_MULTI_SZ = 0x00000020;
const RRF_RT_REG_QWORD = 0x00000040;
const RRF_RT_DWORD = RRF_RT_REG_BINARY | RRF_RT_REG_DWORD;
const RRF_RT_QWORD = RRF_RT_REG_BINARY | RRF_RT_REG_QWORD;
const RRF_RT_ANY = 0x0000ffff;
const RRF_SUBKEY_WOW6464KEY = 0x00010000;
const RRF_SUBKEY_WOW6432KEY = 0x00020000;
const RRF_WOW64_MASK = 0x00030000;
const RRF_NOEXPAND = 0x10000000;
const RRF_ZEROONFAILURE = 0x20000000;
const REG_NONE = 0;
const REG_SZ = 1;
const REG_EXPAND_SZ = 2;
const REG_BINARY = 3;
const REG_DWORD = 4;
const REG_DWORD_LITTLE_ENDIAN = 4;
const REG_DWORD_BIG_ENDIAN = 5;
const REG_LINK = 6;
const REG_MULTI_SZ = 7;
const REG_RESOURCE_LIST = 8;
const REG_FULL_RESOURCE_DESCRIPTOR = 9;
const REG_RESOURCE_REQUIREMENTS_LIST = 10;
const REG_QWORD = 11;
const REG_QWORD_LITTLE_ENDIAN = 11;
const KEY_QUERY_VALUE = 0x0001;
const KEY_SET_VALUE = 0x0002;
const KEY_CREATE_SUB_KEY = 0x0004;
const KEY_ENUMERATE_SUB_KEYS = 0x0008;
const KEY_NOTIFY = 0x0010;
const KEY_CREATE_LINK = 0x0020;
const KEY_WOW64_32KEY = 0x0200;
const KEY_WOW64_64KEY = 0x0100;
const KEY_WOW64_RES = 0x0300;
const KEY_READ = (STANDARD_RIGHTS_READ |
        KEY_QUERY_VALUE |
        KEY_ENUMERATE_SUB_KEYS |
        KEY_NOTIFY) &
    (~SYNCHRONIZE);
const KEY_WRITE = (STANDARD_RIGHTS_WRITE | KEY_SET_VALUE | KEY_CREATE_SUB_KEY) &
    (~SYNCHRONIZE);
const KEY_EXECUTE = KEY_READ & (~SYNCHRONIZE);
const KEY_ALL_ACCESS = (STANDARD_RIGHTS_ALL |
        KEY_QUERY_VALUE |
        KEY_SET_VALUE |
        KEY_CREATE_SUB_KEY |
        KEY_ENUMERATE_SUB_KEYS |
        KEY_NOTIFY |
        KEY_CREATE_LINK) &
    (~SYNCHRONIZE);

// -----------------------------------------------------------------------------
// Gamepad constants
// -----------------------------------------------------------------------------

const XINPUT_DEVTYPE_GAMEPAD = 0x01;
const XINPUT_DEVSUBTYPE_UNKNOWN = 0x00;
const XINPUT_DEVSUBTYPE_GAMEPAD = 0x01;
const XINPUT_DEVSUBTYPE_WHEEL = 0x02;
const XINPUT_DEVSUBTYPE_ARCADE_STICK = 0x03;
const XINPUT_DEVSUBTYPE_FLIGHT_STICK = 0x04;
const XINPUT_DEVSUBTYPE_DANCE_PAD = 0x05;
const XINPUT_DEVSUBTYPE_GUITAR = 0x06;
const XINPUT_DEVSUBTYPE_GUITAR_ALTERNATE = 0x07;
const XINPUT_DEVSUBTYPE_DRUM_KIT = 0x08;
const XINPUT_DEVSUBTYPE_GUITAR_BASS = 0x0B;
const XINPUT_DEVSUBTYPE_ARCADE_PAD = 0x13;
const XINPUT_CAPS_VOICE_SUPPORTED = 0x0004;
const XINPUT_CAPS_FFB_SUPPORTED = 0x0001;
const XINPUT_CAPS_WIRELESS = 0x0002;
const XINPUT_CAPS_PMD_SUPPORTED = 0x0008;
const XINPUT_CAPS_NO_NAVIGATION = 0x0010;

const XINPUT_GAMEPAD_DPAD_UP = 0x0001;
const XINPUT_GAMEPAD_DPAD_DOWN = 0x0002;
const XINPUT_GAMEPAD_DPAD_LEFT = 0x0004;
const XINPUT_GAMEPAD_DPAD_RIGHT = 0x0008;
const XINPUT_GAMEPAD_START = 0x0010;
const XINPUT_GAMEPAD_BACK = 0x0020;
const XINPUT_GAMEPAD_LEFT_THUMB = 0x0040;
const XINPUT_GAMEPAD_RIGHT_THUMB = 0x0080;
const XINPUT_GAMEPAD_LEFT_SHOULDER = 0x0100;
const XINPUT_GAMEPAD_RIGHT_SHOULDER = 0x0200;
const XINPUT_GAMEPAD_A = 0x1000;
const XINPUT_GAMEPAD_B = 0x2000;
const XINPUT_GAMEPAD_X = 0x4000;
const XINPUT_GAMEPAD_Y = 0x8000;

const XINPUT_GAMEPAD_LEFT_THUMB_DEADZONE = 7849;
const XINPUT_GAMEPAD_RIGHT_THUMB_DEADZONE = 8689;
const XINPUT_GAMEPAD_TRIGGER_THRESHOLD = 30;

const XINPUT_FLAG_GAMEPAD = 0x00000001;

const BATTERY_DEVTYPE_GAMEPAD = 0x00;
const BATTERY_DEVTYPE_HEADSET = 0x01;

const BATTERY_TYPE_DISCONNECTED = 0x00;
const BATTERY_TYPE_WIRED = 0x01;
const BATTERY_TYPE_ALKALINE = 0x02;
const BATTERY_TYPE_NIMH = 0x03;
const BATTERY_TYPE_UNKNOWN = 0xFF;

const BATTERY_LEVEL_EMPTY = 0x00;
const BATTERY_LEVEL_LOW = 0x01;
const BATTERY_LEVEL_MEDIUM = 0x02;
const BATTERY_LEVEL_FULL = 0x03;

const XUSER_MAX_COUNT = 4;

const VK_PAD_A = 0x5800;
const VK_PAD_B = 0x5801;
const VK_PAD_X = 0x5802;
const VK_PAD_Y = 0x5803;
const VK_PAD_RSHOULDER = 0x5804;
const VK_PAD_LSHOULDER = 0x5805;
const VK_PAD_LTRIGGER = 0x5806;
const VK_PAD_RTRIGGER = 0x5807;

const VK_PAD_DPAD_UP = 0x5810;
const VK_PAD_DPAD_DOWN = 0x5811;
const VK_PAD_DPAD_LEFT = 0x5812;
const VK_PAD_DPAD_RIGHT = 0x5813;
const VK_PAD_START = 0x5814;
const VK_PAD_BACK = 0x5815;
const VK_PAD_LTHUMB_PRESS = 0x5816;
const VK_PAD_RTHUMB_PRESS = 0x5817;

const VK_PAD_LTHUMB_UP = 0x5820;
const VK_PAD_LTHUMB_DOWN = 0x5821;
const VK_PAD_LTHUMB_RIGHT = 0x5822;
const VK_PAD_LTHUMB_LEFT = 0x5823;
const VK_PAD_LTHUMB_UPLEFT = 0x5824;
const VK_PAD_LTHUMB_UPRIGHT = 0x5825;
const VK_PAD_LTHUMB_DOWNRIGHT = 0x5826;
const VK_PAD_LTHUMB_DOWNLEFT = 0x5827;

const VK_PAD_RTHUMB_UP = 0x5830;
const VK_PAD_RTHUMB_DOWN = 0x5831;
const VK_PAD_RTHUMB_RIGHT = 0x5832;
const VK_PAD_RTHUMB_LEFT = 0x5833;
const VK_PAD_RTHUMB_UPLEFT = 0x5834;
const VK_PAD_RTHUMB_UPRIGHT = 0x5835;
const VK_PAD_RTHUMB_DOWNRIGHT = 0x5836;
const VK_PAD_RTHUMB_DOWNLEFT = 0x5837;

const XINPUT_KEYSTROKE_KEYDOWN = 0x0001;
const XINPUT_KEYSTROKE_KEYUP = 0x0002;
const XINPUT_KEYSTROKE_REPEAT = 0x0004;

// -----------------------------------------------------------------------------
// Console constants
// -----------------------------------------------------------------------------

// Handles
const INVALID_HANDLE_VALUE = -1;
const ATTACH_PARENT_PROCESS = -1;
const FOREGROUND_BLUE = 0x0001;
const FOREGROUND_GREEN = 0x0002;
const FOREGROUND_RED = 0x0004;
const FOREGROUND_INTENSITY = 0x0008;
const BACKGROUND_BLUE = 0x0010;
const BACKGROUND_GREEN = 0x0020;
const BACKGROUND_RED = 0x0040;
const BACKGROUND_INTENSITY = 0x0080;

// -----------------------------------------------------------------------------
// Monitor APIs
// -----------------------------------------------------------------------------

const MC_CAPS_NONE = 0x00000000;
const MC_CAPS_MONITOR_TECHNOLOGY_TYPE = 0x00000001;
const MC_CAPS_BRIGHTNESS = 0x00000002;
const MC_CAPS_CONTRAST = 0x00000004;
const MC_CAPS_COLOR_TEMPERATURE = 0x00000008;
const MC_CAPS_RED_GREEN_BLUE_GAIN = 0x00000010;
const MC_CAPS_RED_GREEN_BLUE_DRIVE = 0x00000020;
const MC_CAPS_DEGAUSS = 0x00000040;
const MC_CAPS_DISPLAY_AREA_POSITION = 0x00000080;
const MC_CAPS_DISPLAY_AREA_SIZE = 0x00000100;
const MC_CAPS_RESTORE_FACTORY_DEFAULTS = 0x00000400;
const MC_CAPS_RESTORE_FACTORY_COLOR_DEFAULTS = 0x00000800;
const MC_RESTORE_FACTORY_DEFAULTS_ENABLES_MONITOR_SETTINGS = 0x00001000;
const MC_SUPPORTED_COLOR_TEMPERATURE_NONE = 0x00000000;
const MC_SUPPORTED_COLOR_TEMPERATURE_4000K = 0x00000001;
const MC_SUPPORTED_COLOR_TEMPERATURE_5000K = 0x00000002;
const MC_SUPPORTED_COLOR_TEMPERATURE_6500K = 0x00000004;
const MC_SUPPORTED_COLOR_TEMPERATURE_7500K = 0x00000008;
const MC_SUPPORTED_COLOR_TEMPERATURE_8200K = 0x00000010;
const MC_SUPPORTED_COLOR_TEMPERATURE_9300K = 0x00000020;
const MC_SUPPORTED_COLOR_TEMPERATURE_10000K = 0x00000040;
const MC_SUPPORTED_COLOR_TEMPERATURE_11500K = 0x00000080;

// *** COM CONSTANTS ***
final CO_E_NOTINITIALIZED = 0x800401F0.toSigned(32);
final CO_E_ALREADYINITIALIZED = 0x800401F1.toSigned(32);
final CO_E_CANTDETERMINECLASS = 0x800401F2.toSigned(32);
final CO_E_CLASSSTRING = 0x800401F3.toSigned(32);
final CO_E_IIDSTRING = 0x800401F4.toSigned(32);
final CO_E_APPNOTFOUND = 0x800401F5.toSigned(32);
final CO_E_APPSINGLEUSE = 0x800401F6.toSigned(32);
final CO_E_ERRORINAPP = 0x800401F7.toSigned(32);
final CO_E_DLLNOTFOUND = 0x800401F8.toSigned(32);
final CO_E_ERRORINDLL = 0x800401F9.toSigned(32);
final CO_E_WRONGOSFORAPP = 0x800401FA.toSigned(32);
final CO_E_OBJNOTREG = 0x800401FB.toSigned(32);
final CO_E_OBJISREG = 0x800401FC.toSigned(32);
final CO_E_OBJNOTCONNECTED = 0x800401FD.toSigned(32);
final CO_E_APPDIDNTREG = 0x800401FE.toSigned(32);
final CLASS_E_NOAGGREGATION = 0x80040110.toSigned(32);
final CLASS_E_CLASSNOTAVAILABLE = 0x80040111.toSigned(32);
final CLASS_E_NOTLICENSED = 0x80040112.toSigned(32);
final RPC_E_CHANGED_MODE = 0x80010106.toSigned(32);
final RPC_E_TOO_LATE = 0x80010119.toSigned(32);
final REGDB_E_CLASSNOTREG = 0x80040154.toSigned(32);
final REGDB_E_IIDNOTREG = 0x80040155.toSigned(32);

// Smartcard errors
final SCARD_S_SUCCESS = NO_ERROR;
final SCARD_E_CANCELLED = 0x80100002.toSigned(32);
final SCARD_E_INVALID_HANDLE = 0x80100003.toSigned(32);
final SCARD_E_INVALID_PARAMETER = 0x80100004.toSigned(32);
final SCARD_E_INVALID_TARGET = 0x80100005.toSigned(32);
final SCARD_E_NO_MEMORY = 0x80100006.toSigned(32);
final SCARD_F_WAITED_TOO_LONG = 0x80100007.toSigned(32);
final SCARD_E_INSUFFICIENT_BUFFER = 0x80100008.toSigned(32);
final SCARD_E_UNKNOWN_READER = 0x80100009.toSigned(32);
final SCARD_E_TIMEOUT = 0x8010000A.toSigned(32);
final SCARD_E_SHARING_VIOLATION = 0x8010000B.toSigned(32);
final SCARD_E_NO_SMARTCARD = 0x8010000C.toSigned(32);
final SCARD_E_UNKNOWN_CARD = 0x8010000D.toSigned(32);
final SCARD_E_CANT_DISPOSE = 0x8010000E.toSigned(32);
final SCARD_E_PROTO_MISMATCH = 0x8010000F.toSigned(32);
final SCARD_E_NOT_READY = 0x80100010.toSigned(32);
final SCARD_E_INVALID_VALUE = 0x80100011.toSigned(32);
final SCARD_E_SYSTEM_CANCELLED = 0x80100012.toSigned(32);
final SCARD_F_COMM_ERROR = 0x80100013.toSigned(32);
final SCARD_F_UNKNOWN_ERROR = 0x80100014.toSigned(32);
final SCARD_E_INVALID_ATR = 0x80100015.toSigned(32);
final SCARD_E_NOT_TRANSACTED = 0x80100016.toSigned(32);
final SCARD_E_READER_UNAVAILABLE = 0x80100017.toSigned(32);
final SCARD_P_SHUTDOWN = 0x80100018.toSigned(32);
final SCARD_E_PCI_TOO_SMALL = 0x80100019.toSigned(32);
final SCARD_E_READER_UNSUPPORTED = 0x8010001A.toSigned(32);
final SCARD_E_DUPLICATE_READER = 0x8010001B.toSigned(32);
final SCARD_E_CARD_UNSUPPORTED = 0x8010001C.toSigned(32);
final SCARD_E_NO_SERVICE = 0x8010001D.toSigned(32);
final SCARD_E_SERVICE_STOPPED = 0x8010001E.toSigned(32);
final SCARD_E_UNEXPECTED = 0x8010001F.toSigned(32);
final SCARD_E_ICC_INSTALLATION = 0x80100020.toSigned(32);
final SCARD_E_ICC_CREATEORDER = 0x80100021.toSigned(32);
final SCARD_E_UNSUPPORTED_FEATURE = 0x80100022.toSigned(32);
final SCARD_E_DIR_NOT_FOUND = 0x80100023.toSigned(32);
final SCARD_E_FILE_NOT_FOUND = 0x80100024.toSigned(32);
final SCARD_E_NO_DIR = 0x80100025.toSigned(32);
final SCARD_E_NO_FILE = 0x80100026.toSigned(32);
final SCARD_E_NO_ACCESS = 0x80100027.toSigned(32);
final SCARD_E_WRITE_TOO_MANY = 0x80100028.toSigned(32);
final SCARD_E_BAD_SEEK = 0x80100029.toSigned(32);
final SCARD_E_INVALID_CHV = 0x8010002A.toSigned(32);
final SCARD_E_UNKNOWN_RES_MNG = 0x8010002B.toSigned(32);
final SCARD_E_NO_SUCH_CERTIFICATE = 0x8010002C.toSigned(32);
final SCARD_E_CERTIFICATE_UNAVAILABLE = 0x8010002D.toSigned(32);
final SCARD_E_NO_READERS_AVAILABLE = 0x8010002E.toSigned(32);
final SCARD_E_COMM_DATA_LOST = 0x8010002F.toSigned(32);
final SCARD_E_NO_KEY_CONTAINER = 0x80100030.toSigned(32);
final SCARD_E_SERVER_TOO_BUSY = 0x80100031.toSigned(32);
final SCARD_E_PIN_CACHE_EXPIRED = 0x80100032.toSigned(32);
final SCARD_E_NO_PIN_CACHE = 0x80100033.toSigned(32);
final SCARD_E_READ_ONLY_CARD = 0x80100034.toSigned(32);
final SCARD_W_UNSUPPORTED_CARD = 0x80100065.toSigned(32);
final SCARD_W_UNRESPONSIVE_CARD = 0x80100066.toSigned(32);
final SCARD_W_UNPOWERED_CARD = 0x80100067.toSigned(32);
final SCARD_W_RESET_CARD = 0x80100068.toSigned(32);
final SCARD_W_REMOVED_CARD = 0x80100069.toSigned(32);
final SCARD_W_SECURITY_VIOLATION = 0x8010006A.toSigned(32);
final SCARD_W_WRONG_CHV = 0x8010006B.toSigned(32);
final SCARD_W_CHV_BLOCKED = 0x8010006C.toSigned(32);
final SCARD_W_EOF = 0x8010006D.toSigned(32);
final SCARD_W_CANCELLED_BY_USER = 0x8010006E.toSigned(32);
final SCARD_W_CARD_NOT_AUTHENTICATED = 0x8010006F.toSigned(32);
final SCARD_W_CACHE_ITEM_NOT_FOUND = 0x80100070.toSigned(32);
final SCARD_W_CACHE_ITEM_STALE = 0x80100071.toSigned(32);
final SCARD_W_CACHE_ITEM_TOO_BIG = 0x80100072.toSigned(32);

const COINITBASE_MULTITHREADED = 0x0;
const COINIT_APARTMENTTHREADED = 0x2;
const COINIT_MULTITHREADED = COINITBASE_MULTITHREADED;
const COINIT_DISABLE_OLE1DDE = 0x4;
const COINIT_SPEED_OVER_MEMORY = 0x8;
const CLSCTX_INPROC_SERVER16 = 0x8;
const CLSCTX_INPROC_HANDLER16 = 0x20;
const CLSCTX_RESERVED1 = 0x40;
const CLSCTX_RESERVED2 = 0x80;
const CLSCTX_RESERVED3 = 0x100;
const CLSCTX_RESERVED4 = 0x200;
const CLSCTX_NO_CODE_DOWNLOAD = 0x400;
const CLSCTX_RESERVED5 = 0x800;
const CLSCTX_NO_CUSTOM_MARSHAL = 0x1000;
const CLSCTX_ENABLE_CODE_DOWNLOAD = 0x2000;
const CLSCTX_NO_FAILURE_LOG = 0x4000;
const CLSCTX_DISABLE_AAA = 0x8000;
const CLSCTX_ENABLE_AAA = 0x10000;
const CLSCTX_FROM_DEFAULT_CONTEXT = 0x20000;
const CLSCTX_ACTIVATE_X86_SERVER = 0x40000;
const CLSCTX_ACTIVATE_32_BIT_SERVER = CLSCTX_ACTIVATE_X86_SERVER;
const CLSCTX_ACTIVATE_64_BIT_SERVER = 0x80000;
const CLSCTX_ENABLE_CLOAKING = 0x100000;
const CLSCTX_APPCONTAINER = 0x400000;
const CLSCTX_ACTIVATE_AAA_AS_IU = 0x800000;
const CLSCTX_RESERVED6 = 0x1000000;
const CLSCTX_ACTIVATE_ARM32_SERVER = 0x2000000;
const CLSCTX_PS_DLL = 0x80000000;

// RPC authentication
const RPC_C_AUTHN_LEVEL_DEFAULT = 0;
const RPC_C_AUTHN_LEVEL_NONE = 1;
const RPC_C_AUTHN_LEVEL_CONNECT = 2;
const RPC_C_AUTHN_LEVEL_CALL = 3;
const RPC_C_AUTHN_LEVEL_PKT = 4;
const RPC_C_AUTHN_LEVEL_PKT_INTEGRITY = 5;
const RPC_C_AUTHN_LEVEL_PKT_PRIVACY = 6;
const RPC_C_IMP_LEVEL_DEFAULT = 0;
const RPC_C_IMP_LEVEL_ANONYMOUS = 1;
const RPC_C_IMP_LEVEL_IDENTIFY = 2;
const RPC_C_IMP_LEVEL_IMPERSONATE = 3;
const RPC_C_IMP_LEVEL_DELEGATE = 4;
const RPC_C_AUTHN_NONE = 0;
const RPC_C_AUTHN_DCE_PRIVATE = 1;
const RPC_C_AUTHN_DCE_PUBLIC = 2;
const RPC_C_AUTHN_DEC_PUBLIC = 4;
const RPC_C_AUTHN_GSS_NEGOTIATE = 9;
const RPC_C_AUTHN_WINNT = 10;
const RPC_C_AUTHN_GSS_SCHANNEL = 14;
const RPC_C_AUTHN_GSS_KERBEROS = 16;
const RPC_C_AUTHN_DPA = 17;
const RPC_C_AUTHN_MSN = 18;
const RPC_C_AUTHZ_NONE = 0;
const RPC_C_AUTHZ_NAME = 1;
const RPC_C_AUTHZ_DCE = 2;
const RPC_C_AUTHZ_DEFAULT = 0xffffffff;

// Known folder flags
const KF_FLAG_DEFAULT = 0x00000000;
const KF_FLAG_FORCE_APP_DATA_REDIRECTION = 0x00080000;
const KF_FLAG_RETURN_FILTER_REDIRECTION_TARGET = 0x00040000;
const KF_FLAG_FORCE_PACKAGE_REDIRECTION = 0x00020000;
const KF_FLAG_NO_PACKAGE_REDIRECTION = 0x00010000;
const KF_FLAG_FORCE_APPCONTAINER_REDIRECTION = 0x00020000;
const KF_FLAG_NO_APPCONTAINER_REDIRECTION = 0x00010000;
const KF_FLAG_CREATE = 0x00008000;
const KF_FLAG_DONT_VERIFY = 0x00004000;
const KF_FLAG_DONT_UNEXPAND = 0x00002000;
const KF_FLAG_NO_ALIAS = 0x00001000;
const KF_FLAG_INIT = 0x00000800;
const KF_FLAG_DEFAULT_PATH = 0x00000400;
const KF_FLAG_NOT_PARENT_RELATIVE = 0x00000200;
const KF_FLAG_SIMPLE_IDLIST = 0x00000100;
const KF_FLAG_ALIAS_ONLY = 0x80000000;

// Init common controls bitflag
const ICC_LISTVIEW_CLASSES = 0x00000001;
const ICC_TREEVIEW_CLASSES = 0x00000002;
const ICC_BAR_CLASSES = 0x00000004;
const ICC_TAB_CLASSES = 0x00000008;
const ICC_UPDOWN_CLASS = 0x00000010;
const ICC_PROGRESS_CLASS = 0x00000020;
const ICC_HOTKEY_CLASS = 0x00000040;
const ICC_ANIMATE_CLASS = 0x00000080;
const ICC_WIN95_CLASSES = 0x000000FF;
const ICC_DATE_CLASSES = 0x00000100;
const ICC_USEREX_CLASSES = 0x00000200;
const ICC_COOL_CLASSES = 0x00000400;
const ICC_INTERNET_CLASSES = 0x00000800;
const ICC_PAGESCROLLER_CLASS = 0x00001000;
const ICC_NATIVEFNTCTL_CLASS = 0x00002000;
const ICC_STANDARD_CLASSES = 0x00004000;
const ICC_LINK_CLASS = 0x00008000;

// File access types
const FILE_READ_DATA = 0x0001;
const FILE_LIST_DIRECTORY = 0x0001;
const FILE_WRITE_DATA = 0x0002;
const FILE_ADD_FILE = 0x0002;
const FILE_APPEND_DATA = 0x0004;
const FILE_ADD_SUBDIRECTORY = 0x0004;
const FILE_CREATE_PIPE_INSTANCE = 0x0004;
const FILE_READ_EA = 0x0008;
const FILE_WRITE_EA = 0x0010;
const FILE_EXECUTE = 0x0020;
const FILE_TRAVERSE = 0x0020;
const FILE_DELETE_CHILD = 0x0040;
const FILE_READ_ATTRIBUTES = 0x0080;
const FILE_WRITE_ATTRIBUTES = 0x0100;
const FILE_ALL_ACCESS = STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0x1FF;

const FILE_GENERIC_READ = STANDARD_RIGHTS_READ |
    FILE_READ_DATA |
    FILE_READ_ATTRIBUTES |
    FILE_READ_EA |
    SYNCHRONIZE;

const FILE_GENERIC_WRITE = STANDARD_RIGHTS_WRITE |
    FILE_WRITE_DATA |
    FILE_WRITE_ATTRIBUTES |
    FILE_WRITE_EA |
    FILE_APPEND_DATA |
    SYNCHRONIZE;

const FILE_GENERIC_EXECUTE =
    STANDARD_RIGHTS_EXECUTE | FILE_READ_ATTRIBUTES | FILE_EXECUTE | SYNCHRONIZE;

const FILE_SHARE_READ = 0x00000001;
const FILE_SHARE_WRITE = 0x00000002;
const FILE_SHARE_DELETE = 0x00000004;
const FILE_ATTRIBUTE_READONLY = 0x00000001;
const FILE_ATTRIBUTE_HIDDEN = 0x00000002;
const FILE_ATTRIBUTE_SYSTEM = 0x00000004;
const FILE_ATTRIBUTE_DIRECTORY = 0x00000010;
const FILE_ATTRIBUTE_ARCHIVE = 0x00000020;
const FILE_ATTRIBUTE_DEVICE = 0x00000040;
const FILE_ATTRIBUTE_NORMAL = 0x00000080;
const FILE_ATTRIBUTE_TEMPORARY = 0x00000100;
const FILE_ATTRIBUTE_SPARSE_FILE = 0x00000200;
const FILE_ATTRIBUTE_REPARSE_POINT = 0x00000400;
const FILE_ATTRIBUTE_COMPRESSED = 0x00000800;
const FILE_ATTRIBUTE_OFFLINE = 0x00001000;
const FILE_ATTRIBUTE_NOT_CONTENT_INDEXED = 0x00002000;
const FILE_ATTRIBUTE_ENCRYPTED = 0x00004000;
const FILE_ATTRIBUTE_INTEGRITY_STREAM = 0x00008000;
const FILE_ATTRIBUTE_VIRTUAL = 0x00010000;
const FILE_ATTRIBUTE_NO_SCRUB_DATA = 0x00020000;
const FILE_ATTRIBUTE_EA = 0x00040000;
const FILE_ATTRIBUTE_PINNED = 0x00080000;
const FILE_ATTRIBUTE_UNPINNED = 0x00100000;
const FILE_ATTRIBUTE_RECALL_ON_OPEN = 0x00040000;
const FILE_ATTRIBUTE_RECALL_ON_DATA_ACCESS = 0x00400000;
const TREE_CONNECT_ATTRIBUTE_PRIVACY = 0x00004000;
const TREE_CONNECT_ATTRIBUTE_INTEGRITY = 0x00008000;
const TREE_CONNECT_ATTRIBUTE_GLOBAL = 0x00000004;
const TREE_CONNECT_ATTRIBUTE_PINNED = 0x00000002;
const FILE_ATTRIBUTE_STRICTLY_SEQUENTIAL = 0x20000000;
const FILE_NOTIFY_CHANGE_FILE_NAME = 0x00000001;
const FILE_NOTIFY_CHANGE_DIR_NAME = 0x00000002;
const FILE_NOTIFY_CHANGE_ATTRIBUTES = 0x00000004;
const FILE_NOTIFY_CHANGE_SIZE = 0x00000008;
const FILE_NOTIFY_CHANGE_LAST_WRITE = 0x00000010;
const FILE_NOTIFY_CHANGE_LAST_ACCESS = 0x00000020;
const FILE_NOTIFY_CHANGE_CREATION = 0x00000040;
const FILE_NOTIFY_CHANGE_SECURITY = 0x00000100;
const FILE_ACTION_ADDED = 0x00000001;
const FILE_ACTION_REMOVED = 0x00000002;
const FILE_ACTION_MODIFIED = 0x00000003;
const FILE_ACTION_RENAMED_OLD_NAME = 0x00000004;
const FILE_ACTION_RENAMED_NEW_NAME = 0x00000005;
const MAILSLOT_NO_MESSAGE = -1;
const MAILSLOT_WAIT_FOREVER = -1;
const FILE_CASE_SENSITIVE_SEARCH = 0x00000001;
const FILE_CASE_PRESERVED_NAMES = 0x00000002;
const FILE_UNICODE_ON_DISK = 0x00000004;
const FILE_PERSISTENT_ACLS = 0x00000008;
const FILE_FILE_COMPRESSION = 0x00000010;
const FILE_VOLUME_QUOTAS = 0x00000020;
const FILE_SUPPORTS_SPARSE_FILES = 0x00000040;
const FILE_SUPPORTS_REPARSE_POINTS = 0x00000080;
const FILE_SUPPORTS_REMOTE_STORAGE = 0x00000100;
const FILE_RETURNS_CLEANUP_RESULT_INFO = 0x00000200;
const FILE_SUPPORTS_POSIX_UNLINK_RENAME = 0x00000400;
const FILE_VOLUME_IS_COMPRESSED = 0x00008000;
const FILE_SUPPORTS_OBJECT_IDS = 0x00010000;
const FILE_SUPPORTS_ENCRYPTION = 0x00020000;
const FILE_NAMED_STREAMS = 0x00040000;
const FILE_READ_ONLY_VOLUME = 0x00080000;
const FILE_SEQUENTIAL_WRITE_ONCE = 0x00100000;
const FILE_SUPPORTS_TRANSACTIONS = 0x00200000;
const FILE_SUPPORTS_HARD_LINKS = 0x00400000;
const FILE_SUPPORTS_EXTENDED_ATTRIBUTES = 0x00800000;
const FILE_SUPPORTS_OPEN_BY_FILE_ID = 0x01000000;
const FILE_SUPPORTS_USN_JOURNAL = 0x02000000;
const FILE_SUPPORTS_INTEGRITY_STREAMS = 0x04000000;
const FILE_SUPPORTS_BLOCK_REFCOUNTING = 0x08000000;
const FILE_SUPPORTS_SPARSE_VDL = 0x10000000;
const FILE_DAX_VOLUME = 0x20000000;
const FILE_SUPPORTS_GHOSTING = 0x40000000;

// Task dialog icons.
//
// In the Windows header files, these are defined in the following format:
//   #define TD_WARNING_ICON         MAKEINTRESOURCEW(-1)
final TD_WARNING_ICON = Pointer<Utf16>.fromAddress(0xFFFF);
final TD_ERROR_ICON = Pointer<Utf16>.fromAddress(0xFFFE);
final TD_INFORMATION_ICON = Pointer<Utf16>.fromAddress(0xFFFD);
final TD_SHIELD_ICON = Pointer<Utf16>.fromAddress(0xFFFC);

/// {@category Enum}
class TASKDIALOG_FLAGS {
  static const int TDF_ENABLE_HYPERLINKS = 0x0001;
  static const int TDF_USE_HICON_MAIN = 0x0002;
  static const int TDF_USE_HICON_FOOTER = 0x0004;
  static const int TDF_ALLOW_DIALOG_CANCELLATION = 0x0008;
  static const int TDF_USE_COMMAND_LINKS = 0x0010;
  static const int TDF_USE_COMMAND_LINKS_NO_ICON = 0x0020;
  static const int TDF_EXPAND_FOOTER_AREA = 0x0040;
  static const int TDF_EXPANDED_BY_DEFAULT = 0x0080;
  static const int TDF_VERIFICATION_FLAG_CHECKED = 0x0100;
  static const int TDF_SHOW_PROGRESS_BAR = 0x0200;
  static const int TDF_SHOW_MARQUEE_PROGRESS_BAR = 0x0400;
  static const int TDF_CALLBACK_TIMER = 0x0800;
  static const int TDF_POSITION_RELATIVE_TO_WINDOW = 0x1000;
  static const int TDF_RTL_LAYOUT = 0x2000;
  static const int TDF_NO_DEFAULT_RADIO_BUTTON = 0x4000;
  static const int TDF_CAN_BE_MINIMIZED = 0x8000;
  static const int TDF_NO_SET_FOREGROUND = 0x00010000;
  static const int TDF_SIZE_TO_CONTENT = 0x01000000;
}

/// {@category Enum}
class TASKDIALOG_COMMON_BUTTON_FLAGS {
  static const int TDCBF_OK_BUTTON = 0x0001;
  static const int TDCBF_YES_BUTTON = 0x0002;
  static const int TDCBF_NO_BUTTON = 0x0004;
  static const int TDCBF_CANCEL_BUTTON = 0x0008;
  static const int TDCBF_RETRY_BUTTON = 0x0010;
  static const int TDCBF_CLOSE_BUTTON = 0x0020;
}

// Multimedia constants
const _MMSYSERR_BASE = 0;
const MMSYSERR_NOERROR = 0;
const MMSYSERR_ERROR = _MMSYSERR_BASE + 1;
const MMSYSERR_BADDEVICEID = _MMSYSERR_BASE + 2;
const MMSYSERR_NOTENABLED = _MMSYSERR_BASE + 3;
const MMSYSERR_ALLOCATED = _MMSYSERR_BASE + 4;
const MMSYSERR_INVALHANDLE = _MMSYSERR_BASE + 5;
const MMSYSERR_NODRIVER = _MMSYSERR_BASE + 6;
const MMSYSERR_NOMEM = _MMSYSERR_BASE + 7;
const MMSYSERR_NOTSUPPORTED = _MMSYSERR_BASE + 8;
const MMSYSERR_BADERRNUM = _MMSYSERR_BASE + 9;
const MMSYSERR_INVALFLAG = _MMSYSERR_BASE + 10;
const MMSYSERR_INVALPARAM = _MMSYSERR_BASE + 11;
const MMSYSERR_HANDLEBUSY = _MMSYSERR_BASE + 12;
const MMSYSERR_INVALIDALIAS = _MMSYSERR_BASE + 13;
const MMSYSERR_BADDB = _MMSYSERR_BASE + 14;
const MMSYSERR_KEYNOTFOUND = _MMSYSERR_BASE + 15;
const MMSYSERR_READERROR = _MMSYSERR_BASE + 16;
const MMSYSERR_WRITEERROR = _MMSYSERR_BASE + 17;
const MMSYSERR_DELETEERROR = _MMSYSERR_BASE + 18;
const MMSYSERR_VALNOTFOUND = _MMSYSERR_BASE + 19;
const MMSYSERR_NODRIVERCB = _MMSYSERR_BASE + 20;
const MMSYSERR_MOREDATA = _MMSYSERR_BASE + 21;
const MMSYSERR_LASTERROR = _MMSYSERR_BASE + 21;

const SHERB_NOCONFIRMATION = 0x00000001;
const SHERB_NOPROGRESSUI = 0x00000002;
const SHERB_NOSOUND = 0x00000004;

// Folder IDs
const FOLDERID_NetworkFolder = '{D20BEEC4-5CA8-4905-AE3B-BF251EA09B53}';
const FOLDERID_ComputerFolder = '{0AC0837C-BBF8-452A-850D-79D08E667CA7}';
const FOLDERID_InternetFolder = '{4D9F7874-4E0C-4904-967B-40B0D20C3E4B}';
const FOLDERID_ControlPanelFolder = '{82A74AEB-AEB4-465C-A014-D097EE346D63}';
const FOLDERID_PrintersFolder = '{76FC4E2D-D6AD-4519-A663-37BD56068185}';
const FOLDERID_SyncManagerFolder = '{43668BF8-C14E-49B2-97C9-747784D784B7}';
const FOLDERID_SyncSetupFolder = '{0F214138-B1D3-4a90-BBA9-27CBC0C5389A}';
const FOLDERID_ConflictFolder = '{4bfefb45-347d-4006-a5be-ac0cb0567192}';
const FOLDERID_SyncResultsFolder = '{289a9a43-be44-4057-a41b-587a76d7e7f9}';
const FOLDERID_RecycleBinFolder = '{B7534046-3ECB-4C18-BE4E-64CD4CB7D6AC}';
const FOLDERID_ConnectionsFolder = '{6F0CD92B-2E97-45D1-88FF-B0D186B8DEDD}';
const FOLDERID_Fonts = '{FD228CB7-AE11-4AE3-864C-16F3910AB8FE}';
const FOLDERID_Desktop = '{B4BFCC3A-DB2C-424C-B029-7FE99A87C641}';
const FOLDERID_Startup = '{B97D20BB-F46A-4C97-BA10-5E3608430854}';
const FOLDERID_Programs = '{A77F5D77-2E2B-44C3-A6A2-ABA601054A51}';
const FOLDERID_StartMenu = '{625B53C3-AB48-4EC1-BA1F-A1EF4146FC19}';
const FOLDERID_Recent = '{AE50C081-EBD2-438A-8655-8A092E34987A}';
const FOLDERID_SendTo = '{8983036C-27C0-404B-8F08-102D10DCFD74}';
const FOLDERID_Documents = '{FDD39AD0-238F-46AF-ADB4-6C85480369C7}';
const FOLDERID_Favorites = '{1777F761-68AD-4D8A-87BD-30B759FA33DD}';
const FOLDERID_NetHood = '{C5ABBF53-E17F-4121-8900-86626FC2C973}';
const FOLDERID_PrintHood = '{9274BD8D-CFD1-41C3-B35E-B13F55A758F4}';
const FOLDERID_Templates = '{A63293E8-664E-48DB-A079-DF759E0509F7}';
const FOLDERID_CommonStartup = '{82A5EA35-D9CD-47C5-9629-E15D2F714E6E}';
const FOLDERID_CommonPrograms = '{0139D44E-6AFE-49F2-8690-3DAFCAE6FFB8}';
const FOLDERID_CommonStartMenu = '{A4115719-D62E-491D-AA7C-E74B8BE3B067}';
const FOLDERID_PublicDesktop = '{C4AA340D-F20F-4863-AFEF-F87EF2E6BA25}';
const FOLDERID_ProgramData = '{62AB5D82-FDC1-4DC3-A9DD-070D1D495D97}';
const FOLDERID_CommonTemplates = '{B94237E7-57AC-4347-9151-B08C6C32D1F7}';
const FOLDERID_PublicDocuments = '{ED4824AF-DCE4-45A8-81E2-FC7965083634}';
const FOLDERID_RoamingAppData = '{3EB685DB-65F9-4CF6-A03A-E3EF65729F3D}';
const FOLDERID_LocalAppData = '{F1B32785-6FBA-4FCF-9D55-7B8E7F157091}';
const FOLDERID_LocalAppDataLow = '{A520A1A4-1780-4FF6-BD18-167343C5AF16}';
const FOLDERID_InternetCache = '{352481E8-33BE-4251-BA85-6007CAEDCF9D}';
const FOLDERID_Cookies = '{2B0F765D-C0E9-4171-908E-08A611B84FF6}';
const FOLDERID_History = '{D9DC8A3B-B784-432E-A781-5A1130A75963}';
const FOLDERID_System = '{1AC14E77-02E7-4E5D-B744-2EB1AE5198B7}';
const FOLDERID_SystemX86 = '{D65231B0-B2F1-4857-A4CE-A8E7C6EA7D27}';
const FOLDERID_Windows = '{F38BF404-1D43-42F2-9305-67DE0B28FC23}';
const FOLDERID_Profile = '{5E6C858F-0E22-4760-9AFE-EA3317B67173}';
const FOLDERID_Pictures = '{33E28130-4E1E-4676-835A-98395C3BC3BB}';
const FOLDERID_ProgramFilesX86 = '{7C5A40EF-A0FB-4BFC-874A-C0F2E0B9FA8E}';
const FOLDERID_ProgramFilesCommonX86 = '{DE974D24-D9C6-4D3E-BF91-F4455120B917}';
const FOLDERID_ProgramFilesX64 = '{6D809377-6AF0-444b-8957-A3773F02200E}';
const FOLDERID_ProgramFilesCommonX64 = '{6365D5A7-0F0D-45e5-87F6-0DA56B6A4F7D}';
const FOLDERID_ProgramFiles = '{905e63b6-c1bf-494e-b29c-65b732d3d21a}';
const FOLDERID_ProgramFilesCommon = '{F7F1ED05-9F6D-47A2-AAAE-29D317C6F066}';
const FOLDERID_UserProgramFiles = '{5cd7aee2-2219-4a67-b85d-6c9ce15660cb}';
const FOLDERID_UserProgramFilesCommon =
    '{bcbd3057-ca5c-4622-b42d-bc56db0ae516}';
const FOLDERID_AdminTools = '{724EF170-A42D-4FEF-9F26-B60E846FBA4F}';
const FOLDERID_CommonAdminTools = '{D0384E7D-BAC3-4797-8F14-CBA229B392B5}';
const FOLDERID_Music = '{4BD8D571-6D19-48D3-BE97-422220080E43}';
const FOLDERID_Videos = '{18989B1D-99B5-455B-841C-AB7C74E4DDFC}';
const FOLDERID_Ringtones = '{C870044B-F49E-4126-A9C3-B52A1FF411E8}';
const FOLDERID_PublicPictures = '{B6EBFB86-6907-413C-9AF7-4FC2ABF07CC5}';
const FOLDERID_PublicMusic = '{3214FAB5-9757-4298-BB61-92A9DEAA44FF}';
const FOLDERID_PublicVideos = '{2400183A-6185-49FB-A2D8-4A392A602BA3}';
const FOLDERID_PublicRingtones = '{E555AB60-153B-4D17-9F04-A5FE99FC15EC}';
const FOLDERID_ResourceDir = '{8AD10C31-2ADB-4296-A8F7-E4701232C972}';
const FOLDERID_LocalizedResourcesDir = '{2A00375E-224C-49DE-B8D1-440DF7EF3DDC}';
const FOLDERID_CommonOEMLinks = '{C1BAE2D0-10DF-4334-BEDD-7AA20B227A9D}';
const FOLDERID_CDBurning = '{9E52AB10-F80D-49DF-ACB8-4330F5687855}';
const FOLDERID_UserProfiles = '{0762D272-C50A-4BB0-A382-697DCD729B80}';
const FOLDERID_Playlists = '{DE92C1C7-837F-4F69-A3BB-86E631204A23}';
const FOLDERID_SamplePlaylists = '{15CA69B3-30EE-49C1-ACE1-6B5EC372AFB5}';
const FOLDERID_SampleMusic = '{B250C668-F57D-4EE1-A63C-290EE7D1AA1F}';
const FOLDERID_SamplePictures = '{C4900540-2379-4C75-844B-64E6FAF8716B}';
const FOLDERID_SampleVideos = '{859EAD94-2E85-48AD-A71A-0969CB56A6CD}';
const FOLDERID_PhotoAlbums = '{69D2CF90-FC33-4FB7-9A0C-EBB0F0FCB43C}';
const FOLDERID_Public = '{DFDF76A2-C82A-4D63-906A-5644AC457385}';
const FOLDERID_ChangeRemovePrograms = '{df7266ac-9274-4867-8d55-3bd661de872d}';
const FOLDERID_AppUpdates = '{a305ce99-f527-492b-8b1a-7e76fa98d6e4}';
const FOLDERID_AddNewPrograms = '{de61d971-5ebc-4f02-a3a9-6c82895e5c04}';
const FOLDERID_Downloads = '{374DE290-123F-4565-9164-39C4925E467B}';
const FOLDERID_PublicDownloads = '{3D644C9B-1FB8-4f30-9B45-F670235F79C0}';
const FOLDERID_SavedSearches = '{7d1d3a04-debb-4115-95cf-2f29da2920da}';
const FOLDERID_QuickLaunch = '{52a4f021-7b75-48a9-9f6b-4b87a210bc8f}';
const FOLDERID_Contacts = '{56784854-C6CB-462b-8169-88E350ACB882}';
const FOLDERID_SidebarParts = '{A75D362E-50FC-4fb7-AC2C-A8BEAA314493}';
const FOLDERID_SidebarDefaultParts = '{7B396E54-9EC5-4300-BE0A-2482EBAE1A26}';
const FOLDERID_PublicGameTasks = '{DEBF2536-E1A8-4c59-B6A2-414586476AEA}';
const FOLDERID_GameTasks = '{054FAE61-4DD8-4787-80B6-090220C4B700}';
const FOLDERID_SavedGames = '{4C5C32FF-BB9D-43b0-B5B4-2D72E54EAAA4}';
const FOLDERID_Games = '{CAC52C1A-B53D-4edc-92D7-6B2E8AC19434}';
const FOLDERID_SEARCH_MAPI = '{98ec0e18-2098-4d44-8644-66979315a281}';
const FOLDERID_SEARCH_CSC = '{ee32e446-31ca-4aba-814f-a5ebd2fd6d5e}';
const FOLDERID_Links = '{bfb9d5e0-c6a9-404c-b2b2-ae6db6af4968}';
const FOLDERID_UsersFiles = '{f3ce0f7c-4901-4acc-8648-d5d44b04ef8f}';
const FOLDERID_UsersLibraries = '{A302545D-DEFF-464b-ABE8-61C8648D939B}';
const FOLDERID_SearchHome = '{190337d1-b8ca-4121-a639-6d472d16972a}';
const FOLDERID_OriginalImages = '{2C36C0AA-5812-4b87-BFD0-4CD0DFB19B39}';
const FOLDERID_DocumentsLibrary = '{7b0db17d-9cd2-4a93-9733-46cc89022e7c}';
const FOLDERID_MusicLibrary = '{2112AB0A-C86A-4ffe-A368-0DE96E47012E}';
const FOLDERID_PicturesLibrary = '{A990AE9F-A03B-4e80-94BC-9912D7504104}';
const FOLDERID_VideosLibrary = '{491E922F-5643-4af4-A7EB-4E7A138D8174}';
const FOLDERID_RecordedTVLibrary = '{1A6FDBA2-F42D-4358-A798-B74D745926C5}';
const FOLDERID_HomeGroup = '{52528A6B-B9E3-4add-B60D-588C2DBA842D}';
const FOLDERID_HomeGroupCurrentUser = '{9B74B6A3-0DFD-4f11-9E78-5F7800F2E772}';
const FOLDERID_DeviceMetadataStore = '{5CE4A5E9-E4EB-479D-B89F-130C02886155}';
const FOLDERID_Libraries = '{1B3EA5DC-B587-4786-B4EF-BD1DC332AEAE}';
const FOLDERID_PublicLibraries = '{48daf80b-e6cf-4f4e-b800-0e69d84ee384}';
const FOLDERID_UserPinned = '{9e3995ab-1f9c-4f13-b827-48b24b6c7174}';
const FOLDERID_ImplicitAppShortcuts = '{bcb5256f-79f6-4cee-b725-dc34e402fd46}';
const FOLDERID_AccountPictures = '{008ca0b1-55b4-4c56-b8a8-4de4b299d3be}';
const FOLDERID_PublicUserTiles = '{0482af6c-08f1-4c34-8c90-e17ec98b1e17}';
const FOLDERID_AppsFolder = '{1e87508d-89c2-42f0-8a7e-645a0f50ca58}';
const FOLDERID_StartMenuAllPrograms = '{F26305EF-6948-40B9-B255-81453D09C785}';
const FOLDERID_CommonStartMenuPlaces = '{A440879F-87A0-4F7D-B700-0207B966194A}';
const FOLDERID_ApplicationShortcuts = '{A3918781-E5F2-4890-B3D9-A7E54332328C}';
const FOLDERID_RoamingTiles = '{00BCFC5A-ED94-4e48-96A1-3F6217F21990}';
const FOLDERID_RoamedTileImages = '{AAA8D5A5-F1D6-4259-BAA8-78E7EF60835E}';
const FOLDERID_Screenshots = '{b7bede81-df94-4682-a7d8-57a52620b86f}';
const FOLDERID_CameraRoll = '{AB5FB87B-7CE2-4F83-915D-550846C9537B}';
const FOLDERID_SkyDrive = '{A52BBA46-E9E1-435f-B3D9-28DAA648C0F6}';
const FOLDERID_OneDrive = '{A52BBA46-E9E1-435f-B3D9-28DAA648C0F6}';
const FOLDERID_SkyDriveDocuments = '{24D89E24-2F19-4534-9DDE-6A6671FBB8FE}';
const FOLDERID_SkyDrivePictures = '{339719B5-8C47-4894-94C2-D8F77ADD44A6}';
const FOLDERID_SkyDriveMusic = '{C3F2459E-80D6-45DC-BFEF-1F769F2BE730}';
const FOLDERID_SkyDriveCameraRoll = '{767E6811-49CB-4273-87C2-20F355E1085B}';
const FOLDERID_SearchHistory = '{0D4C3DB6-03A3-462F-A0E6-08924C41B5D4}';
const FOLDERID_SearchTemplates = '{7E636BFE-DFA9-4D5E-B456-D7B39851D8A9}';
const FOLDERID_CameraRollLibrary = '{2B20DF75-1EDA-4039-8097-38798227D5B7}';
const FOLDERID_SavedPictures = '{3B193882-D3AD-4eab-965A-69829D1FB59F}';
const FOLDERID_SavedPicturesLibrary = '{E25B5812-BE88-4bd9-94B0-29233477B6C3}';
const FOLDERID_RetailDemo = '{12D4C69E-24AD-4923-BE19-31321C43A767}';
const FOLDERID_Device = '{1C2AC1DC-4358-4B6C-9733-AF21156576F0}';
const FOLDERID_DevelopmentFiles = '{DBE8E08E-3053-4BBC-B183-2A7B2B191E59}';
const FOLDERID_Objects3D = '{31C0DD25-9439-4F12-BF41-7FF4EDA38722}';
const FOLDERID_AppCaptures = '{EDC0FE71-98D8-4F4A-B920-C8DC133CB165}';
const FOLDERID_LocalDocuments = '{f42ee2d3-909f-4907-8871-4c22fc0bf756}';
const FOLDERID_LocalPictures = '0ddd015d-b06c-45d5-8c4c-f59713854639 }';
const FOLDERID_LocalVideos = '{35286a68-3c57-41a1-bbb1-0eae73d76c95}';
const FOLDERID_LocalMusic = '{a0c69a99-21c8-4671-8703-7934162fcf1d}';
const FOLDERID_LocalDownloads = '{7d83ee9b-2244-4e70-b1f5-5393042af1e4}';
const FOLDERID_RecordedCalls = '{2f8b40c2-83ed-48ee-b383-a1f157ec6f9a}';
const FOLDERID_AllAppMods = '{7ad67899-66af-43ba-9156-6aad42e6c596}';
const FOLDERID_CurrentAppMods = '{3db40b20-2a30-4dbe-917e-771dd21dd099}';
const FOLDERID_AppDataDesktop = '{B2C5E279-7ADD-439F-B28C-C41FE1BBF672}';
const FOLDERID_AppDataDocuments = '{7BE16610-1F7F-44AC-BFF0-83E15F2FFCA1}';
const FOLDERID_AppDataFavorites = '{7CFBEFBC-DE1F-45AA-B843-A542AC536CC9}';
const FOLDERID_AppDataProgramData = '{559D40A3-A036-40FA-AF61-84CB430A4D34}';

// *** Kernel constants ***

// memory management
const PAGE_NOACCESS = 0x01;
const PAGE_READONLY = 0x02;
const PAGE_READWRITE = 0x04;
const PAGE_WRITECOPY = 0x08;
const PAGE_EXECUTE = 0x10;
const PAGE_EXECUTE_READ = 0x20;
const PAGE_EXECUTE_READWRITE = 0x40;
const PAGE_EXECUTE_WRITECOPY = 0x80;
const PAGE_GUARD = 0x100;
const PAGE_NOCACHE = 0x200;
const PAGE_WRITECOMBINE = 0x400;
const PAGE_GRAPHICS_NOACCESS = 0x0800;
const PAGE_GRAPHICS_READONLY = 0x1000;
const PAGE_GRAPHICS_READWRITE = 0x2000;
const PAGE_GRAPHICS_EXECUTE = 0x4000;
const PAGE_GRAPHICS_EXECUTE_READ = 0x8000;
const PAGE_GRAPHICS_EXECUTE_READWRITE = 0x10000;
const PAGE_GRAPHICS_COHERENT = 0x20000;
const PAGE_ENCLAVE_THREAD_CONTROL = 0x80000000;
const PAGE_REVERT_TO_FILE_MAP = 0x80000000;
const PAGE_TARGETS_NO_UPDATE = 0x40000000;
const PAGE_TARGETS_INVALID = 0x40000000;
const PAGE_ENCLAVE_UNVALIDATED = 0x20000000;
const PAGE_ENCLAVE_DECOMMIT = 0x10000000;

// Memory constants
const MEM_ROTATE = 0x00800000;
const MEM_DIFFERENT_IMAGE_BASE_OK = 0x00800000;
const MEM_4MB_PAGES = 0x80000000;
const MEM_64K_PAGES = MEM_LARGE_PAGES | MEM_PHYSICAL;

// Processor architectures
const PROCESSOR_ARCHITECTURE_INTEL = 0;
const PROCESSOR_ARCHITECTURE_MIPS = 1;
const PROCESSOR_ARCHITECTURE_ALPHA = 2;
const PROCESSOR_ARCHITECTURE_PPC = 3;
const PROCESSOR_ARCHITECTURE_SHX = 4;
const PROCESSOR_ARCHITECTURE_ARM = 5;
const PROCESSOR_ARCHITECTURE_IA64 = 6;
const PROCESSOR_ARCHITECTURE_ALPHA64 = 7;
const PROCESSOR_ARCHITECTURE_MSIL = 8;
const PROCESSOR_ARCHITECTURE_AMD64 = 9;
const PROCESSOR_ARCHITECTURE_IA32_ON_WIN64 = 10;
const PROCESSOR_ARCHITECTURE_NEUTRAL = 11;
const PROCESSOR_ARCHITECTURE_ARM64 = 12;
const PROCESSOR_ARCHITECTURE_ARM32_ON_WIN64 = 13;
const PROCESSOR_ARCHITECTURE_IA32_ON_ARM64 = 14;
const PROCESSOR_ARCHITECTURE_UNKNOWN = 0xFFFF;

// Machine architectures
const IMAGE_FILE_MACHINE_UNKNOWN = 0;
const IMAGE_FILE_MACHINE_TARGET_HOST = 0x0001;
const IMAGE_FILE_MACHINE_I386 = 0x014c;
const IMAGE_FILE_MACHINE_R3000 = 0x0162;
const IMAGE_FILE_MACHINE_R4000 = 0x0166;
const IMAGE_FILE_MACHINE_R10000 = 0x0168;
const IMAGE_FILE_MACHINE_WCEMIPSV2 = 0x0169;
const IMAGE_FILE_MACHINE_ALPHA = 0x0184;
const IMAGE_FILE_MACHINE_SH3 = 0x01a2;
const IMAGE_FILE_MACHINE_SH3DSP = 0x01a3;
const IMAGE_FILE_MACHINE_SH3E = 0x01a4;
const IMAGE_FILE_MACHINE_SH4 = 0x01a6;
const IMAGE_FILE_MACHINE_SH5 = 0x01a8;
const IMAGE_FILE_MACHINE_ARM = 0x01c0;
const IMAGE_FILE_MACHINE_THUMB = 0x01c2;
const IMAGE_FILE_MACHINE_ARMNT = 0x01c4;
const IMAGE_FILE_MACHINE_AM33 = 0x01d3;
const IMAGE_FILE_MACHINE_POWERPC = 0x01F0;
const IMAGE_FILE_MACHINE_POWERPCFP = 0x01f1;
const IMAGE_FILE_MACHINE_IA64 = 0x0200;
const IMAGE_FILE_MACHINE_MIPS16 = 0x0266;
const IMAGE_FILE_MACHINE_ALPHA64 = 0x0284;
const IMAGE_FILE_MACHINE_MIPSFPU = 0x0366;
const IMAGE_FILE_MACHINE_MIPSFPU16 = 0x0466;
const IMAGE_FILE_MACHINE_AXP64 = IMAGE_FILE_MACHINE_ALPHA64;
const IMAGE_FILE_MACHINE_TRICORE = 0x0520;
const IMAGE_FILE_MACHINE_CEF = 0x0CEF;
const IMAGE_FILE_MACHINE_EBC = 0x0EBC;
const IMAGE_FILE_MACHINE_AMD64 = 0x8664;
const IMAGE_FILE_MACHINE_M32R = 0x9041;
const IMAGE_FILE_MACHINE_ARM64 = 0xAA64;
const IMAGE_FILE_MACHINE_CEE = 0xC0EE;

// DISPID constants
const DISPID_UNKNOWN = -1;
const DISPID_VALUE = 0;
const DISPID_PROPERTYPUT = -3;
const DISPID_NEWENUM = -4;
const DISPID_EVALUATE = -5;
const DISPID_CONSTRUCTOR = -6;
const DISPID_DESTRUCTOR = -7;
const DISPID_COLLECT = -8;

// Bluetooth constants
const BLUETOOTH_MAX_NAME_SIZE = 248;
const BLUETOOTH_MAX_PASSKEY_SIZE = 16;
const BLUETOOTH_MAX_PASSKEY_BUFFER_SIZE = BLUETOOTH_MAX_PASSKEY_SIZE + 1;
const BLUETOOTH_MAX_SERVICE_NAME_SIZE = 256;
const BLUETOOTH_DEVICE_NAME_SIZE = 256;
const BTH_MAX_PIN_SIZE = 16;
const BTH_LINK_KEY_LENGTH = 16;

/// {@category Enum}
class POWER_INFORMATION_LEVEL {
  static const SystemPowerPolicyAc = 0;
  static const SystemPowerPolicyDc = 1;
  static const VerifySystemPolicyAc = 2;
  static const VerifySystemPolicyDc = 3;
  static const SystemPowerCapabilities = 4;
  static const SystemBatteryState = 5;
  static const SystemPowerStateHandler = 6;
  static const ProcessorStateHandler = 7;
  static const SystemPowerPolicyCurrent = 8;
  static const AdministratorPowerPolicy = 9;
  static const SystemReserveHiberFile = 10;
  static const ProcessorInformation = 11;
  static const SystemPowerInformation = 12;
  static const ProcessorStateHandler2 = 13;
  static const LastWakeTime = 14;
  static const LastSleepTime = 15;
  static const SystemExecutionState = 16;
  static const SystemPowerStateNotifyHandler = 17;
  static const ProcessorPowerPolicyAc = 18;
  static const ProcessorPowerPolicyDc = 19;
  static const VerifyProcessorPowerPolicyAc = 20;
  static const VerifyProcessorPowerPolicyDc = 21;
  static const ProcessorPowerPolicyCurrent = 22;
  static const SystemPowerStateLogging = 23;
  static const SystemPowerLoggingEntry = 24;
  static const SetPowerSettingValue = 25;
  static const NotifyUserPowerSetting = 26;
  static const PowerInformationLevelUnused0 = 27;
  static const SystemMonitorHiberBootPowerOff = 28;
  static const SystemVideoState = 29;
  static const TraceApplicationPowerMessage = 30;
  static const TraceApplicationPowerMessageEnd = 31;
  static const ProcessorPerfStates = 32;
  static const ProcessorIdleStates = 33;
  static const ProcessorCap = 34;
  static const SystemWakeSource = 35;
  static const SystemHiberFileInformation = 36;
  static const TraceServicePowerMessage = 37;
  static const ProcessorLoad = 38;
  static const PowerShutdownNotification = 39;
  static const MonitorCapabilities = 40;
  static const SessionPowerInit = 41;
  static const SessionDisplayState = 42;
  static const PowerRequestCreate = 43;
  static const PowerRequestAction = 44;
  static const GetPowerRequestList = 45;
  static const ProcessorInformationEx = 46;
  static const NotifyUserModeLegacyPowerEvent = 47;
  static const GroupPark = 48;
  static const ProcessorIdleDomains = 49;
  static const WakeTimerList = 50;
  static const SystemHiberFileSize = 51;
  static const ProcessorIdleStatesHv = 52;
  static const ProcessorPerfStatesHv = 53;
  static const ProcessorPerfCapHv = 54;
  static const ProcessorSetIdle = 55;
  static const LogicalProcessorIdling = 56;
  static const UserPresence = 57;
  static const PowerSettingNotificationName = 58;
  static const GetPowerSettingValue = 59;
  static const IdleResiliency = 60;
  static const SessionRITState = 61;
  static const SessionConnectNotification = 62;
  static const SessionPowerCleanup = 63;
  static const SessionLockState = 64;
  static const SystemHiberbootState = 65;
  static const PlatformInformation = 66;
  static const PdcInvocation = 67;
  static const MonitorInvocation = 68;
  static const FirmwareTableInformationRegistered = 69;
  static const SetShutdownSelectedTime = 70;
  static const SuspendResumeInvocation = 71;
  static const PlmPowerRequestCreate = 72;
  static const ScreenOff = 73;
  static const CsDeviceNotification = 74;
  static const PlatformRole = 75;
  static const LastResumePerformance = 76;
  static const DisplayBurst = 77;
  static const ExitLatencySamplingPercentage = 78;
  static const RegisterSpmPowerSettings = 79;
  static const PlatformIdleStates = 80;
  static const ProcessorIdleVeto = 81;
  static const PlatformIdleVeto = 82;
  static const SystemBatteryStatePrecise = 83;
  static const ThermalEvent = 84;
  static const PowerRequestActionInternal = 85;
  static const BatteryDeviceState = 86;
  static const PowerInformationInternal = 87;
  static const ThermalStandby = 88;
  static const SystemHiberFileType = 89;
  static const PhysicalPowerButtonPress = 90;
  static const QueryPotentialDripsConstraint = 91;
  static const EnergyTrackerCreate = 92;
  static const EnergyTrackerQuery = 93;
  static const UpdateBlackBoxRecorder = 94;
  static const SessionAllowExternalDmaDevices = 95;
  static const PowerInformationLevelMaximum = 96;
}

/// {@category Enum}
class FFFP_MODE {
  static const FFFP_EXACTMATCH = 0;
  static const FFFP_NEARESTPARENTMATCH = FFFP_EXACTMATCH + 1;
}

/// {@category Enum}
class FDAP {
  static const FDAP_BOTTOM = 0;
  static const FDAP_TOP = 1;
}

/// {@category Enum}
class KF_CATEGORY {
  static const KF_CATEGORY_VIRTUAL = 1;
  static const KF_CATEGORY_FIXED = 2;
  static const KF_CATEGORY_COMMON = 3;
  static const KF_CATEGORY_PERUSER = 4;
}

/// {@category Enum}
class KF_DEFINITION_FLAGS {
  static const KFDF_LOCAL_REDIRECT_ONLY = 0x2;
  static const KFDF_ROAMABLE = 0x4;
  static const KFDF_PRECREATE = 0x8;
  static const KFDF_STREAM = 0x10;
  static const KFDF_PUBLISHEXPANDEDPATH = 0x20;
  static const KFDF_NO_REDIRECT_UI = 0x4;
}

/// {@category Enum}
class KF_REDIRECT_FLAGS {
  static const KF_REDIRECT_USER_EXCLUSIVE = 0x1;
  static const KF_REDIRECT_COPY_SOURCE_DACL = 0x2;
  static const KF_REDIRECT_OWNER_USER = 0x4;
  static const KF_REDIRECT_SET_OWNER_EXPLICIT = 0x8;
  static const KF_REDIRECT_CHECK_ONLY = 0x10;
  static const KF_REDIRECT_WITH_UI = 0x20;
  static const KF_REDIRECT_UNPIN = 0x40;
  static const KF_REDIRECT_PIN = 0x80;
  static const KF_REDIRECT_COPY_CONTENTS = 0x200;
  static const KF_REDIRECT_DEL_SOURCE_CONTENTS = 0x400;
  static const KF_REDIRECT_EXCLUDE_ALL_KNOWN_SUBFOLDERS = 0x800;
}

/// Specifies a type of computer name.
///
/// {@category Enum}
class COMPUTER_NAME_FORMAT {
  static const ComputerNameNetBIOS = 0;
  static const ComputerNameDnsHostname = 1;
  static const ComputerNameDnsDomain = 2;
  static const ComputerNameDnsFullyQualified = 3;
  static const ComputerNamePhysicalNetBIOS = 4;
  static const ComputerNamePhysicalDnsHostname = 5;
  static const ComputerNamePhysicalDnsDomain = 6;
  static const ComputerNamePhysicalDnsFullyQualified = 7;
  static const ComputerNameMax = 8;
}

/// {@category Enum}
class KF_REDIRECTION_CAPABILITIES {
  static const KF_REDIRECTION_CAPABILITIES_ALLOW_ALL = 0xff;
  static const KF_REDIRECTION_CAPABILITIES_REDIRECTABLE = 0x1;
  static const KF_REDIRECTION_CAPABILITIES_DENY_ALL = 0xfff00;
  static const KF_REDIRECTION_CAPABILITIES_DENY_POLICY_REDIRECTED = 0x100;
  static const KF_REDIRECTION_CAPABILITIES_DENY_POLICY = 0x200;
  static const KF_REDIRECTION_CAPABILITIES_DENY_PERMISSIONS = 0x400;
}

/// {@category Enum}
class SIGDN {
  static const SIGDN_NORMALDISPLAY = 0;
  static const SIGDN_PARENTRELATIVEPARSING = 0x80018001;
  static const SIGDN_DESKTOPABSOLUTEPARSING = 0x80028000;
  static const SIGDN_PARENTRELATIVEEDITING = 0x80031001;
  static const SIGDN_DESKTOPABSOLUTEEDITING = 0x8004c000;
  static const SIGDN_FILESYSPATH = 0x80058000;
  static const SIGDN_URL = 0x80068000;
  static const SIGDN_PARENTRELATIVEFORADDRESSBAR = 0x8007c001;
  static const SIGDN_PARENTRELATIVE = 0x80080001;
  static const SIGDN_PARENTRELATIVEFORUI = 0x8009400;
}

/// {@category Enum}
class EOLE_AUTHENTICATION_CAPABILITIES {
  static const EOAC_NONE = 0;
  static const EOAC_MUTUAL_AUTH = 0x1;
  static const EOAC_STATIC_CLOAKING = 0x20;
  static const EOAC_DYNAMIC_CLOAKING = 0x40;
  static const EOAC_ANY_AUTHORITY = 0x80;
  static const EOAC_MAKE_FULLSIC = 0x100;
  static const EOAC_DEFAULT = 0x800;
  static const EOAC_SECURE_REFS = 0x2;
  static const EOAC_ACCESS_CONTROL = 0x4;
  static const EOAC_APPID = 0x8;
  static const EOAC_DYNAMIC = 0x10;
  static const EOAC_REQUIRE_FULLSIC = 0x200;
  static const EOAC_AUTO_IMPERSONATE = 0x400;
  static const EOAC_DISABLE_AAA = 0x1000;
  static const EOAC_NO_CUSTOM_MARSHAL = 0x2000;
  static const EOAC_RESERVED1 = 0x4000;
}

/// {@category Enum}
class WBEM_GENERIC_FLAG_TYPE {
  static const WBEM_FLAG_RETURN_IMMEDIATELY = 0x10;
  static const WBEM_FLAG_RETURN_WBEM_COMPLETE = 0;
  static const WBEM_FLAG_BIDIRECTIONAL = 0;
  static const WBEM_FLAG_FORWARD_ONLY = 0x20;
  static const WBEM_FLAG_NO_ERROR_OBJECT = 0x40;
  static const WBEM_FLAG_RETURN_ERROR_OBJECT = 0;
  static const WBEM_FLAG_SEND_STATUS = 0x80;
  static const WBEM_FLAG_DONT_SEND_STATUS = 0;
  static const WBEM_FLAG_ENSURE_LOCATABLE = 0x100;
  static const WBEM_FLAG_DIRECT_READ = 0x200;
  static const WBEM_FLAG_SEND_ONLY_SELECTED = 0;
  static const WBEM_RETURN_WHEN_COMPLETE = 0;
  static const WBEM_RETURN_IMMEDIATELY = 0x10;
  static const WBEM_MASK_RESERVED_FLAGS = 0x1f000;
  static const WBEM_FLAG_USE_AMENDED_QUALIFIERS = 0x20000;
  static const WBEM_FLAG_STRONG_VALIDATION = 0x100000;
}

/// {@category Enum}
class WBEM_TIMEOUT_TYPE {
  static const WBEM_NO_WAIT = 0;
  static const WBEM_INFINITE = 0xffffffff;
}

/// {@category Enum}
class NLM_CONNECTIVITY {
  static const NLM_CONNECTIVITY_DISCONNECTED = 0;
  static const NLM_CONNECTIVITY_IPV4_NOTRAFFIC = 0x1;
  static const NLM_CONNECTIVITY_IPV6_NOTRAFFIC = 0x2;
  static const NLM_CONNECTIVITY_IPV4_SUBNET = 0x10;
  static const NLM_CONNECTIVITY_IPV4_LOCALNETWORK = 0x20;
  static const NLM_CONNECTIVITY_IPV4_INTERNET = 0x40;
  static const NLM_CONNECTIVITY_IPV6_SUBNET = 0x100;
  static const NLM_CONNECTIVITY_IPV6_LOCALNETWORK = 0x200;
  static const NLM_CONNECTIVITY_IPV6_INTERNET = 0x400;
}

/// {@category Enum}
class NLM_ENUM_NETWORK {
  static const NLM_ENUM_NETWORK_CONNECTED = 0x1;
  static const NLM_ENUM_NETWORK_DISCONNECTED = 0x2;
  static const NLM_ENUM_NETWORK_ALL = 0x3;
}

const PRODUCT_UNDEFINED = 0x00000000;
const PRODUCT_ULTIMATE = 0x00000001;
const PRODUCT_HOME_BASIC = 0x00000002;
const PRODUCT_HOME_PREMIUM = 0x00000003;
const PRODUCT_ENTERPRISE = 0x00000004;
const PRODUCT_HOME_BASIC_N = 0x00000005;
const PRODUCT_BUSINESS = 0x00000006;
const PRODUCT_STANDARD_SERVER = 0x00000007;
const PRODUCT_DATACENTER_SERVER = 0x00000008;
const PRODUCT_SMALLBUSINESS_SERVER = 0x00000009;
const PRODUCT_ENTERPRISE_SERVER = 0x0000000A;
const PRODUCT_STARTER = 0x0000000B;
const PRODUCT_DATACENTER_SERVER_CORE = 0x0000000C;
const PRODUCT_STANDARD_SERVER_CORE = 0x0000000D;
const PRODUCT_ENTERPRISE_SERVER_CORE = 0x0000000E;
const PRODUCT_ENTERPRISE_SERVER_IA64 = 0x0000000F;
const PRODUCT_BUSINESS_N = 0x00000010;
const PRODUCT_WEB_SERVER = 0x00000011;
const PRODUCT_CLUSTER_SERVER = 0x00000012;
const PRODUCT_HOME_SERVER = 0x00000013;
const PRODUCT_STORAGE_EXPRESS_SERVER = 0x00000014;
const PRODUCT_STORAGE_STANDARD_SERVER = 0x00000015;
const PRODUCT_STORAGE_WORKGROUP_SERVER = 0x00000016;
const PRODUCT_STORAGE_ENTERPRISE_SERVER = 0x00000017;
const PRODUCT_SERVER_FOR_SMALLBUSINESS = 0x00000018;
const PRODUCT_SMALLBUSINESS_SERVER_PREMIUM = 0x00000019;
const PRODUCT_HOME_PREMIUM_N = 0x0000001A;
const PRODUCT_ENTERPRISE_N = 0x0000001B;
const PRODUCT_ULTIMATE_N = 0x0000001C;
const PRODUCT_WEB_SERVER_CORE = 0x0000001D;
const PRODUCT_MEDIUMBUSINESS_SERVER_MANAGEMENT = 0x0000001E;
const PRODUCT_MEDIUMBUSINESS_SERVER_SECURITY = 0x0000001F;
const PRODUCT_MEDIUMBUSINESS_SERVER_MESSAGING = 0x00000020;
const PRODUCT_SERVER_FOUNDATION = 0x00000021;
const PRODUCT_HOME_PREMIUM_SERVER = 0x00000022;
const PRODUCT_SERVER_FOR_SMALLBUSINESS_V = 0x00000023;
const PRODUCT_STANDARD_SERVER_V = 0x00000024;
const PRODUCT_DATACENTER_SERVER_V = 0x00000025;
const PRODUCT_ENTERPRISE_SERVER_V = 0x00000026;
const PRODUCT_DATACENTER_SERVER_CORE_V = 0x00000027;
const PRODUCT_STANDARD_SERVER_CORE_V = 0x00000028;
const PRODUCT_ENTERPRISE_SERVER_CORE_V = 0x00000029;
const PRODUCT_HYPERV = 0x0000002A;
const PRODUCT_STORAGE_EXPRESS_SERVER_CORE = 0x0000002B;
const PRODUCT_STORAGE_STANDARD_SERVER_CORE = 0x0000002C;
const PRODUCT_STORAGE_WORKGROUP_SERVER_CORE = 0x0000002D;
const PRODUCT_STORAGE_ENTERPRISE_SERVER_CORE = 0x0000002E;
const PRODUCT_STARTER_N = 0x0000002F;
const PRODUCT_PROFESSIONAL = 0x00000030;
const PRODUCT_PROFESSIONAL_N = 0x00000031;
const PRODUCT_SB_SOLUTION_SERVER = 0x00000032;
const PRODUCT_SERVER_FOR_SB_SOLUTIONS = 0x00000033;
const PRODUCT_STANDARD_SERVER_SOLUTIONS = 0x00000034;
const PRODUCT_STANDARD_SERVER_SOLUTIONS_CORE = 0x00000035;
const PRODUCT_SB_SOLUTION_SERVER_EM = 0x00000036;
const PRODUCT_SERVER_FOR_SB_SOLUTIONS_EM = 0x00000037;
const PRODUCT_SOLUTION_EMBEDDEDSERVER = 0x00000038;
const PRODUCT_SOLUTION_EMBEDDEDSERVER_CORE = 0x00000039;
const PRODUCT_PROFESSIONAL_EMBEDDED = 0x0000003A;
const PRODUCT_ESSENTIALBUSINESS_SERVER_MGMT = 0x0000003B;
const PRODUCT_ESSENTIALBUSINESS_SERVER_ADDL = 0x0000003C;
const PRODUCT_ESSENTIALBUSINESS_SERVER_MGMTSVC = 0x0000003D;
const PRODUCT_ESSENTIALBUSINESS_SERVER_ADDLSVC = 0x0000003E;
const PRODUCT_SMALLBUSINESS_SERVER_PREMIUM_CORE = 0x0000003F;
const PRODUCT_CLUSTER_SERVER_V = 0x00000040;
const PRODUCT_EMBEDDED = 0x00000041;
const PRODUCT_STARTER_E = 0x00000042;
const PRODUCT_HOME_BASIC_E = 0x00000043;
const PRODUCT_HOME_PREMIUM_E = 0x00000044;
const PRODUCT_PROFESSIONAL_E = 0x00000045;
const PRODUCT_ENTERPRISE_E = 0x00000046;
const PRODUCT_ULTIMATE_E = 0x00000047;
const PRODUCT_ENTERPRISE_EVALUATION = 0x00000048;
const PRODUCT_MULTIPOINT_STANDARD_SERVER = 0x0000004C;
const PRODUCT_MULTIPOINT_PREMIUM_SERVER = 0x0000004D;
const PRODUCT_STANDARD_EVALUATION_SERVER = 0x0000004F;
const PRODUCT_DATACENTER_EVALUATION_SERVER = 0x00000050;
const PRODUCT_ENTERPRISE_N_EVALUATION = 0x00000054;
const PRODUCT_EMBEDDED_AUTOMOTIVE = 0x00000055;
const PRODUCT_EMBEDDED_INDUSTRY_A = 0x00000056;
const PRODUCT_THINPC = 0x00000057;
const PRODUCT_EMBEDDED_A = 0x00000058;
const PRODUCT_EMBEDDED_INDUSTRY = 0x00000059;
const PRODUCT_EMBEDDED_E = 0x0000005A;
const PRODUCT_EMBEDDED_INDUSTRY_E = 0x0000005B;
const PRODUCT_EMBEDDED_INDUSTRY_A_E = 0x0000005C;
const PRODUCT_STORAGE_WORKGROUP_EVALUATION_SERVER = 0x0000005F;
const PRODUCT_STORAGE_STANDARD_EVALUATION_SERVER = 0x00000060;
const PRODUCT_CORE_ARM = 0x00000061;
const PRODUCT_CORE_N = 0x00000062;
const PRODUCT_CORE_COUNTRYSPECIFIC = 0x00000063;
const PRODUCT_CORE_SINGLELANGUAGE = 0x00000064;
const PRODUCT_CORE = 0x00000065;
const PRODUCT_PROFESSIONAL_WMC = 0x00000067;
const PRODUCT_EMBEDDED_INDUSTRY_EVAL = 0x00000069;
const PRODUCT_EMBEDDED_INDUSTRY_E_EVAL = 0x0000006A;
const PRODUCT_EMBEDDED_EVAL = 0x0000006B;
const PRODUCT_EMBEDDED_E_EVAL = 0x0000006C;
const PRODUCT_NANO_SERVER = 0x0000006D;
const PRODUCT_CLOUD_STORAGE_SERVER = 0x0000006E;
const PRODUCT_CORE_CONNECTED = 0x0000006F;
const PRODUCT_PROFESSIONAL_STUDENT = 0x00000070;
const PRODUCT_CORE_CONNECTED_N = 0x00000071;
const PRODUCT_PROFESSIONAL_STUDENT_N = 0x00000072;
const PRODUCT_CORE_CONNECTED_SINGLELANGUAGE = 0x00000073;
const PRODUCT_CORE_CONNECTED_COUNTRYSPECIFIC = 0x00000074;
const PRODUCT_CONNECTED_CAR = 0x00000075;
const PRODUCT_INDUSTRY_HANDHELD = 0x00000076;
const PRODUCT_PPI_PRO = 0x00000077;
const PRODUCT_ARM64_SERVER = 0x00000078;
const PRODUCT_EDUCATION = 0x00000079;
const PRODUCT_EDUCATION_N = 0x0000007A;
const PRODUCT_IOTUAP = 0x0000007B;
const PRODUCT_CLOUD_HOST_INFRASTRUCTURE_SERVER = 0x0000007C;
const PRODUCT_ENTERPRISE_S = 0x0000007D;
const PRODUCT_ENTERPRISE_S_N = 0x0000007E;
const PRODUCT_PROFESSIONAL_S = 0x0000007F;
const PRODUCT_PROFESSIONAL_S_N = 0x00000080;
const PRODUCT_ENTERPRISE_S_EVALUATION = 0x00000081;
const PRODUCT_ENTERPRISE_S_N_EVALUATION = 0x00000082;
const PRODUCT_HOLOGRAPHIC = 0x00000087;
const PRODUCT_HOLOGRAPHIC_BUSINESS = 0x00000088;
const PRODUCT_PRO_SINGLE_LANGUAGE = 0x0000008A;
const PRODUCT_PRO_CHINA = 0x0000008B;
const PRODUCT_ENTERPRISE_SUBSCRIPTION = 0x0000008C;
const PRODUCT_ENTERPRISE_SUBSCRIPTION_N = 0x0000008D;
const PRODUCT_DATACENTER_NANO_SERVER = 0x0000008F;
const PRODUCT_STANDARD_NANO_SERVER = 0x00000090;
const PRODUCT_DATACENTER_A_SERVER_CORE = 0x00000091;
const PRODUCT_STANDARD_A_SERVER_CORE = 0x00000092;
const PRODUCT_DATACENTER_WS_SERVER_CORE = 0x00000093;
const PRODUCT_STANDARD_WS_SERVER_CORE = 0x00000094;
const PRODUCT_UTILITY_VM = 0x00000095;
const PRODUCT_DATACENTER_EVALUATION_SERVER_CORE = 0x0000009F;
const PRODUCT_STANDARD_EVALUATION_SERVER_CORE = 0x000000A0;
const PRODUCT_PRO_WORKSTATION = 0x000000A1;
const PRODUCT_PRO_WORKSTATION_N = 0x000000A2;
const PRODUCT_PRO_FOR_EDUCATION = 0x000000A4;
const PRODUCT_PRO_FOR_EDUCATION_N = 0x000000A5;
const PRODUCT_AZURE_SERVER_CORE = 0x000000A8;
const PRODUCT_AZURE_NANO_SERVER = 0x000000A9;
const PRODUCT_ENTERPRISEG = 0x000000AB;
const PRODUCT_ENTERPRISEGN = 0x000000AC;
const PRODUCT_SERVERRDSH = 0x000000AF;
const PRODUCT_CLOUD = 0x000000B2;
const PRODUCT_CLOUDN = 0x000000B3;
const PRODUCT_HUBOS = 0x000000B4;
const PRODUCT_ONECOREUPDATEOS = 0x000000B6;
const PRODUCT_CLOUDE = 0x000000B7;
const PRODUCT_ANDROMEDA = 0x000000B8;
const PRODUCT_IOTOS = 0x000000B9;
const PRODUCT_CLOUDEN = 0x000000BA;
const PRODUCT_IOTEDGEOS = 0x000000BB;
const PRODUCT_IOTENTERPRISE = 0x000000BC;
const PRODUCT_LITE = 0x000000BD;
const PRODUCT_IOTENTERPRISES = 0x000000BF;
const PRODUCT_XBOX_SYSTEMOS = 0x000000C0;
const PRODUCT_XBOX_NATIVEOS = 0x000000C1;
const PRODUCT_XBOX_GAMEOS = 0x000000C2;
const PRODUCT_XBOX_ERAOS = 0x000000C3;
const PRODUCT_XBOX_DURANGOHOSTOS = 0x000000C4;
const PRODUCT_XBOX_SCARLETTHOSTOS = 0x000000C5;
const PRODUCT_UNLICENSED = 0xABCDABCD;
const CRED_PRESERVE_CREDENTIAL_BLOB = 0x1;
const CRED_FLAGS_PROMPT_NOW = 0x2;
const CRED_FLAGS_USERNAME_TARGET = 0x4;
const CRED_TYPE_GENERIC = 0x1;
const CRED_TYPE_DOMAIN_PASSWORD = 0x2;
const CRED_TYPE_DOMAIN_CERTIFICATE = 0x3;
const CRED_TYPE_DOMAIN_VISIBLE_PASSWORD = 0x4;
const CRED_TYPE_GENERIC_CERTIFICATE = 0x5;
const CRED_TYPE_DOMAIN_EXTENDED = 0x6;
const CRED_TYPE_MAXIMUM = 0x7;
const CRED_TYPE_MAXIMUM_EX = CRED_TYPE_MAXIMUM + 1000;
const CRED_PERSIST_SESSION = 0x1;
const CRED_PERSIST_LOCAL_MACHINE = 0x2;
const CRED_PERSIST_ENTERPRISE = 0x3;
const LIST_MODULES_32BIT = 0x01;
const LIST_MODULES_64BIT = 0x02;
const LIST_MODULES_ALL = 0x03;
const LIST_MODULES_DEFAULT = 0x0;

// -----------------------------------------------------------------------------
// Multimedia constants
// -----------------------------------------------------------------------------
const MCI_OPEN = 0x0803;
const MCI_CLOSE = 0x0804;
const MCI_ESCAPE = 0x0805;
const MCI_PLAY = 0x0806;
const MCI_SEEK = 0x0807;
const MCI_STOP = 0x0808;
const MCI_PAUSE = 0x0809;
const MCI_INFO = 0x080A;
const MCI_GETDEVCAPS = 0x080B;
const MCI_SPIN = 0x080C;
const MCI_SET = 0x080D;
const MCI_STEP = 0x080E;
const MCI_RECORD = 0x080F;
const MCI_SYSINFO = 0x0810;
const MCI_BREAK = 0x0811;
const MCI_SAVE = 0x0813;
const MCI_STATUS = 0x0814;
const MCI_CUE = 0x0830;
const MCI_REALIZE = 0x0840;
const MCI_WINDOW = 0x0841;
const MCI_PUT = 0x0842;
const MCI_WHERE = 0x0843;
const MCI_FREEZE = 0x0844;
const MCI_UNFREEZE = 0x0845;
const MCI_LOAD = 0x0850;
const MCI_CUT = 0x0851;
const MCI_COPY = 0x0852;
const MCI_PASTE = 0x0853;
const MCI_UPDATE = 0x0854;
const MCI_RESUME = 0x0855;
const MCI_DELETE = 0x0856;
const MCI_NOTIFY = 0x00000001;
const MCI_WAIT = 0x00000002;
const MCI_FROM = 0x00000004;
const MCI_TO = 0x00000008;
const MCI_TRACK = 0x00000010;
const MCI_OPEN_SHAREABLE = 0x00000100;
const MCI_OPEN_ELEMENT = 0x00000200;
const MCI_OPEN_ALIAS = 0x00000400;
const MCI_OPEN_ELEMENT_ID = 0x00000800;
const MCI_OPEN_TYPE_ID = 0x00001000;
const MCI_OPEN_TYPE = 0x00002000;
const MCI_SEEK_TO_START = 0x00000100;
const MCI_SEEK_TO_END = 0x00000200;
const MCI_STATUS_ITEM = 0x00000100;
const MCI_STATUS_START = 0x00000200;
const MCI_STATUS_LENGTH = 0x00000001;
const MCI_STATUS_POSITION = 0x00000002;
const MCI_STATUS_NUMBER_OF_TRACKS = 0x00000003;
const MCI_STATUS_MODE = 0x00000004;
const MCI_STATUS_MEDIA_PRESENT = 0x00000005;
const MCI_STATUS_TIME_FORMAT = 0x00000006;
const MCI_STATUS_READY = 0x00000007;
const MCI_STATUS_CURRENT_TRACK = 0x00000008;
const MCI_INFO_PRODUCT = 0x00000100;
const MCI_INFO_FILE = 0x00000200;
const MCI_INFO_MEDIA_UPC = 0x00000400;
const MCI_INFO_MEDIA_IDENTITY = 0x00000800;
const MCI_INFO_NAME = 0x00001000;
const MCI_INFO_COPYRIGHT = 0x00002000;
const MCI_SEQ_STATUS_TEMPO = 0x00004002;
const MCI_SEQ_STATUS_PORT = 0x00004003;
const MCI_SEQ_STATUS_SLAVE = 0x00004007;
const MCI_SEQ_STATUS_MASTER = 0x00004008;
const MCI_SEQ_STATUS_OFFSET = 0x00004009;
const MCI_SEQ_STATUS_DIVTYPE = 0x0000400A;
const MCI_SEQ_STATUS_NAME = 0x0000400B;
const MCI_SEQ_STATUS_COPYRIGHT = 0x0000400C;
const MCIERR_BASE = 256;
const MCIERR_INVALID_DEVICE_ID = MCIERR_BASE + 1;
const MCIERR_UNRECOGNIZED_KEYWORD = MCIERR_BASE + 3;
const MCIERR_UNRECOGNIZED_COMMAND = MCIERR_BASE + 5;
const MCIERR_HARDWARE = MCIERR_BASE + 6;
const MCIERR_INVALID_DEVICE_NAME = MCIERR_BASE + 7;
const MCIERR_OUT_OF_MEMORY = MCIERR_BASE + 8;
const MCIERR_DEVICE_OPEN = MCIERR_BASE + 9;
const MCIERR_CANNOT_LOAD_DRIVER = MCIERR_BASE + 10;
const MCIERR_MISSING_COMMAND_STRING = MCIERR_BASE + 11;
const MCIERR_PARAM_OVERFLOW = MCIERR_BASE + 12;
const MCIERR_MISSING_STRING_ARGUMENT = MCIERR_BASE + 13;
const MCIERR_BAD_INTEGER = MCIERR_BASE + 14;
const MCIERR_PARSER_INTERNAL = MCIERR_BASE + 15;
const MCIERR_DRIVER_INTERNAL = MCIERR_BASE + 16;
const MCIERR_MISSING_PARAMETER = MCIERR_BASE + 17;
const MCIERR_UNSUPPORTED_FUNCTION = MCIERR_BASE + 18;
const MCIERR_FILE_NOT_FOUND = MCIERR_BASE + 19;
const MCIERR_DEVICE_NOT_READY = MCIERR_BASE + 20;
const MCIERR_INTERNAL = MCIERR_BASE + 21;
const MCIERR_DRIVER = MCIERR_BASE + 22;
const MCIERR_CANNOT_USE_ALL = MCIERR_BASE + 23;
const MCIERR_MULTIPLE = MCIERR_BASE + 24;
const MCIERR_EXTENSION_NOT_FOUND = MCIERR_BASE + 25;
const MCIERR_OUTOFRANGE = MCIERR_BASE + 26;
const MCIERR_FLAGS_NOT_COMPATIBLE = MCIERR_BASE + 28;
const MCIERR_FILE_NOT_SAVED = MCIERR_BASE + 30;
const MCIERR_DEVICE_TYPE_REQUIRED = MCIERR_BASE + 31;
const MCIERR_DEVICE_LOCKED = MCIERR_BASE + 32;
const MCIERR_DUPLICATE_ALIAS = MCIERR_BASE + 33;
const MCIERR_BAD_CONSTANT = MCIERR_BASE + 34;
const MCIERR_MUST_USE_SHAREABLE = MCIERR_BASE + 35;
const MCIERR_MISSING_DEVICE_NAME = MCIERR_BASE + 36;
const MCIERR_BAD_TIME_FORMAT = MCIERR_BASE + 37;
const MCIERR_NO_CLOSING_QUOTE = MCIERR_BASE + 38;
const MCIERR_DUPLICATE_FLAGS = MCIERR_BASE + 39;
const MCIERR_INVALID_FILE = MCIERR_BASE + 40;
const MCIERR_NULL_PARAMETER_BLOCK = MCIERR_BASE + 41;
const MCIERR_UNNAMED_RESOURCE = MCIERR_BASE + 42;
const MCIERR_NEW_REQUIRES_ALIAS = MCIERR_BASE + 43;
const MCIERR_NOTIFY_ON_AUTO_OPEN = MCIERR_BASE + 44;
const MCIERR_NO_ELEMENT_ALLOWED = MCIERR_BASE + 45;
const MCIERR_NONAPPLICABLE_FUNCTION = MCIERR_BASE + 46;
const MCIERR_ILLEGAL_FOR_AUTO_OPEN = MCIERR_BASE + 47;
const MCIERR_FILENAME_REQUIRED = MCIERR_BASE + 48;
const MCIERR_EXTRA_CHARACTERS = MCIERR_BASE + 49;
const MCIERR_DEVICE_NOT_INSTALLED = MCIERR_BASE + 50;
const MCIERR_GET_CD = MCIERR_BASE + 51;
const MCIERR_SET_CD = MCIERR_BASE + 52;
const MCIERR_SET_DRIVE = MCIERR_BASE + 53;
const MCIERR_DEVICE_LENGTH = MCIERR_BASE + 54;
const MCIERR_DEVICE_ORD_LENGTH = MCIERR_BASE + 55;
const MCIERR_NO_INTEGER = MCIERR_BASE + 56;
const MCIERR_WAVE_OUTPUTSINUSE = MCIERR_BASE + 64;
const MCIERR_WAVE_SETOUTPUTINUSE = MCIERR_BASE + 65;
const MCIERR_WAVE_INPUTSINUSE = MCIERR_BASE + 66;
const MCIERR_WAVE_SETINPUTINUSE = MCIERR_BASE + 67;
const MCIERR_WAVE_OUTPUTUNSPECIFIED = MCIERR_BASE + 68;
const MCIERR_WAVE_INPUTUNSPECIFIED = MCIERR_BASE + 69;
const MCIERR_WAVE_OUTPUTSUNSUITABLE = MCIERR_BASE + 70;
const MCIERR_WAVE_SETOUTPUTUNSUITABLE = MCIERR_BASE + 71;
const MCIERR_WAVE_INPUTSUNSUITABLE = MCIERR_BASE + 72;
const MCIERR_WAVE_SETINPUTUNSUITABLE = MCIERR_BASE + 73;
const MCIERR_SEQ_DIV_INCOMPATIBLE = MCIERR_BASE + 80;
const MCIERR_SEQ_PORT_INUSE = MCIERR_BASE + 81;
const MCIERR_SEQ_PORT_NONEXISTENT = MCIERR_BASE + 82;
const MCIERR_SEQ_PORT_MAPNODEVICE = MCIERR_BASE + 83;
const MCIERR_SEQ_PORT_MISCERROR = MCIERR_BASE + 84;
const MCIERR_SEQ_TIMER = MCIERR_BASE + 85;
const MCIERR_SEQ_PORTUNSPECIFIED = MCIERR_BASE + 86;
const MCIERR_SEQ_NOMIDIPRESENT = MCIERR_BASE + 87;
const MCIERR_NO_WINDOW = MCIERR_BASE + 90;
const MCIERR_CREATEWINDOW = MCIERR_BASE + 91;
const MCIERR_FILE_READ = MCIERR_BASE + 92;
const MCIERR_FILE_WRITE = MCIERR_BASE + 93;
const MCIERR_NO_IDENTITY = MCIERR_BASE + 94;
const MCIERR_CUSTOM_DRIVER_BASE = MCIERR_BASE + 256;
const MIDI_MAPPER = -1;

// IOCTL codes

const FILE_DEVICE_BEEP = 0x00000001;
const FILE_DEVICE_CD_ROM = 0x00000002;
const FILE_DEVICE_CD_ROM_FILE_SYSTEM = 0x00000003;
const FILE_DEVICE_CONTROLLER = 0x00000004;
const FILE_DEVICE_DATALINK = 0x00000005;
const FILE_DEVICE_DFS = 0x00000006;
const FILE_DEVICE_DISK = 0x00000007;
const FILE_DEVICE_DISK_FILE_SYSTEM = 0x00000008;
const FILE_DEVICE_FILE_SYSTEM = 0x00000009;
const FILE_DEVICE_INPORT_PORT = 0x0000000a;
const FILE_DEVICE_KEYBOARD = 0x0000000b;
const FILE_DEVICE_MAILSLOT = 0x0000000c;
const FILE_DEVICE_MIDI_IN = 0x0000000d;
const FILE_DEVICE_MIDI_OUT = 0x0000000e;
const FILE_DEVICE_MOUSE = 0x0000000f;
const FILE_DEVICE_MULTI_UNC_PROVIDER = 0x00000010;
const FILE_DEVICE_NAMED_PIPE = 0x00000011;
const FILE_DEVICE_NETWORK = 0x00000012;
const FILE_DEVICE_NETWORK_BROWSER = 0x00000013;
const FILE_DEVICE_NETWORK_FILE_SYSTEM = 0x00000014;
const FILE_DEVICE_NULL = 0x00000015;
const FILE_DEVICE_PARALLEL_PORT = 0x00000016;
const FILE_DEVICE_PHYSICAL_NETCARD = 0x00000017;
const FILE_DEVICE_PRINTER = 0x00000018;
const FILE_DEVICE_SCANNER = 0x00000019;
const FILE_DEVICE_SERIAL_MOUSE_PORT = 0x0000001a;
const FILE_DEVICE_SERIAL_PORT = 0x0000001b;
const FILE_DEVICE_SCREEN = 0x0000001c;
const FILE_DEVICE_SOUND = 0x0000001d;
const FILE_DEVICE_STREAMS = 0x0000001e;
const FILE_DEVICE_TAPE = 0x0000001f;
const FILE_DEVICE_TAPE_FILE_SYSTEM = 0x00000020;
const FILE_DEVICE_TRANSPORT = 0x00000021;
const FILE_DEVICE_UNKNOWN = 0x00000022;
const FILE_DEVICE_VIDEO = 0x00000023;
const FILE_DEVICE_VIRTUAL_DISK = 0x00000024;
const FILE_DEVICE_WAVE_IN = 0x00000025;
const FILE_DEVICE_WAVE_OUT = 0x00000026;
const FILE_DEVICE_8042_PORT = 0x00000027;
const FILE_DEVICE_NETWORK_REDIRECTOR = 0x00000028;
const FILE_DEVICE_BATTERY = 0x00000029;
const FILE_DEVICE_BUS_EXTENDER = 0x0000002a;
const FILE_DEVICE_MODEM = 0x0000002b;
const FILE_DEVICE_VDM = 0x0000002c;
const FILE_DEVICE_MASS_STORAGE = 0x0000002d;
const FILE_DEVICE_SMB = 0x0000002e;
const FILE_DEVICE_KS = 0x0000002f;
const FILE_DEVICE_CHANGER = 0x00000030;
const FILE_DEVICE_SMARTCARD = 0x00000031;
const FILE_DEVICE_ACPI = 0x00000032;
const FILE_DEVICE_DVD = 0x00000033;
const FILE_DEVICE_FULLSCREEN_VIDEO = 0x00000034;
const FILE_DEVICE_DFS_FILE_SYSTEM = 0x00000035;
const FILE_DEVICE_DFS_VOLUME = 0x00000036;
const FILE_DEVICE_SERENUM = 0x00000037;
const FILE_DEVICE_TERMSRV = 0x00000038;
const FILE_DEVICE_KSEC = 0x00000039;
const FILE_DEVICE_FIPS = 0x0000003A;
const FILE_DEVICE_INFINIBAND = 0x0000003B;
const FILE_DEVICE_VMBUS = 0x0000003E;
const FILE_DEVICE_CRYPT_PROVIDER = 0x0000003F;
const FILE_DEVICE_WPD = 0x00000040;
const FILE_DEVICE_BLUETOOTH = 0x00000041;
const FILE_DEVICE_MT_COMPOSITE = 0x00000042;
const FILE_DEVICE_MT_TRANSPORT = 0x00000043;
const FILE_DEVICE_BIOMETRIC = 0x00000044;
const FILE_DEVICE_PMI = 0x00000045;
const FILE_DEVICE_EHSTOR = 0x00000046;
const FILE_DEVICE_DEVAPI = 0x00000047;
const FILE_DEVICE_GPIO = 0x00000048;
const FILE_DEVICE_USBEX = 0x00000049;
const FILE_DEVICE_CONSOLE = 0x00000050;
const FILE_DEVICE_NFP = 0x00000051;
const FILE_DEVICE_SYSENV = 0x00000052;
const FILE_DEVICE_VIRTUAL_BLOCK = 0x00000053;
const FILE_DEVICE_POINT_OF_SERVICE = 0x00000054;
const FILE_DEVICE_STORAGE_REPLICATION = 0x00000055;
const FILE_DEVICE_TRUST_ENV = 0x00000056;
const FILE_DEVICE_UCM = 0x00000057;
const FILE_DEVICE_UCMTCPCI = 0x00000058;
const FILE_DEVICE_PERSISTENT_MEMORY = 0x00000059;
const FILE_DEVICE_NVDIMM = 0x0000005a;
const FILE_DEVICE_HOLOGRAPHIC = 0x0000005b;
const FILE_DEVICE_SDFXHCI = 0x0000005c;
const FILE_DEVICE_UCMUCSI = 0x0000005d;

const METHOD_BUFFERED = 0;
const METHOD_IN_DIRECT = 1;
const METHOD_OUT_DIRECT = 2;
const METHOD_NEITHER = 3;

const FILE_ANY_ACCESS = 0;
const FILE_SPECIAL_ACCESS = FILE_ANY_ACCESS;
const FILE_READ_ACCESS = 0x0001;
const FILE_WRITE_ACCESS = 0x0002;

final IOCTL_DISK_BASE = FILE_DEVICE_DISK;
final IOCTL_DISK_GET_DRIVE_GEOMETRY =
    CTL_CODE(IOCTL_DISK_BASE, 0x0000, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_DISK_GET_PARTITION_INFO =
    CTL_CODE(IOCTL_DISK_BASE, 0x0001, METHOD_BUFFERED, FILE_READ_ACCESS);
final IOCTL_DISK_SET_PARTITION_INFO = CTL_CODE(IOCTL_DISK_BASE, 0x0002,
    METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final IOCTL_DISK_GET_DRIVE_LAYOUT =
    CTL_CODE(IOCTL_DISK_BASE, 0x0003, METHOD_BUFFERED, FILE_READ_ACCESS);
final IOCTL_DISK_SET_DRIVE_LAYOUT = CTL_CODE(IOCTL_DISK_BASE, 0x0004,
    METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final IOCTL_DISK_VERIFY =
    CTL_CODE(IOCTL_DISK_BASE, 0x0005, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_DISK_FORMAT_TRACKS = CTL_CODE(IOCTL_DISK_BASE, 0x0006,
    METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final IOCTL_DISK_REASSIGN_BLOCKS = CTL_CODE(IOCTL_DISK_BASE, 0x0007,
    METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final IOCTL_DISK_PERFORMANCE =
    CTL_CODE(IOCTL_DISK_BASE, 0x0008, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_DISK_IS_WRITABLE =
    CTL_CODE(IOCTL_DISK_BASE, 0x0009, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_DISK_LOGGING =
    CTL_CODE(IOCTL_DISK_BASE, 0x000a, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_DISK_FORMAT_TRACKS_EX = CTL_CODE(IOCTL_DISK_BASE, 0x000b,
    METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final IOCTL_DISK_HISTOGRAM_STRUCTURE =
    CTL_CODE(IOCTL_DISK_BASE, 0x000c, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_DISK_HISTOGRAM_DATA =
    CTL_CODE(IOCTL_DISK_BASE, 0x000d, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_DISK_HISTOGRAM_RESET =
    CTL_CODE(IOCTL_DISK_BASE, 0x000e, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_DISK_REQUEST_STRUCTURE =
    CTL_CODE(IOCTL_DISK_BASE, 0x000f, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_DISK_REQUEST_DATA =
    CTL_CODE(IOCTL_DISK_BASE, 0x0010, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_DISK_PERFORMANCE_OFF =
    CTL_CODE(IOCTL_DISK_BASE, 0x0018, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_DISK_CONTROLLER_NUMBER =
    CTL_CODE(IOCTL_DISK_BASE, 0x0011, METHOD_BUFFERED, FILE_ANY_ACCESS);
final SMART_GET_VERSION =
    CTL_CODE(IOCTL_DISK_BASE, 0x0020, METHOD_BUFFERED, FILE_READ_ACCESS);
final SMART_SEND_DRIVE_COMMAND = CTL_CODE(IOCTL_DISK_BASE, 0x0021,
    METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final SMART_RCV_DRIVE_DATA = CTL_CODE(IOCTL_DISK_BASE, 0x0022, METHOD_BUFFERED,
    FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final IOCTL_DISK_GET_PARTITION_INFO_EX =
    CTL_CODE(IOCTL_DISK_BASE, 0x0012, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_DISK_SET_PARTITION_INFO_EX = CTL_CODE(IOCTL_DISK_BASE, 0x0013,
    METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final IOCTL_DISK_GET_DRIVE_LAYOUT_EX =
    CTL_CODE(IOCTL_DISK_BASE, 0x0014, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_DISK_SET_DRIVE_LAYOUT_EX = CTL_CODE(IOCTL_DISK_BASE, 0x0015,
    METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final IOCTL_DISK_CREATE_DISK = CTL_CODE(IOCTL_DISK_BASE, 0x0016,
    METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final IOCTL_DISK_GET_LENGTH_INFO =
    CTL_CODE(IOCTL_DISK_BASE, 0x0017, METHOD_BUFFERED, FILE_READ_ACCESS);
final IOCTL_DISK_GET_DRIVE_GEOMETRY_EX =
    CTL_CODE(IOCTL_DISK_BASE, 0x0028, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_DISK_REASSIGN_BLOCKS_EX = CTL_CODE(IOCTL_DISK_BASE, 0x0029,
    METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final IOCTL_DISK_UPDATE_DRIVE_SIZE = CTL_CODE(IOCTL_DISK_BASE, 0x0032,
    METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final IOCTL_DISK_GROW_PARTITION = CTL_CODE(IOCTL_DISK_BASE, 0x0034,
    METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final IOCTL_DISK_GET_CACHE_INFORMATION =
    CTL_CODE(IOCTL_DISK_BASE, 0x0035, METHOD_BUFFERED, FILE_READ_ACCESS);
final IOCTL_DISK_SET_CACHE_INFORMATION = CTL_CODE(IOCTL_DISK_BASE, 0x0036,
    METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final OBSOLETE_DISK_GET_WRITE_CACHE_STATE =
    CTL_CODE(IOCTL_DISK_BASE, 0x0037, METHOD_BUFFERED, FILE_READ_ACCESS);
final IOCTL_DISK_DELETE_DRIVE_LAYOUT = CTL_CODE(IOCTL_DISK_BASE, 0x0040,
    METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final IOCTL_DISK_UPDATE_PROPERTIES =
    CTL_CODE(IOCTL_DISK_BASE, 0x0050, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_DISK_FORMAT_DRIVE = CTL_CODE(IOCTL_DISK_BASE, 0x00f3,
    METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final IOCTL_DISK_SENSE_DEVICE =
    CTL_CODE(IOCTL_DISK_BASE, 0x00f8, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_DISK_CHECK_VERIFY =
    CTL_CODE(IOCTL_DISK_BASE, 0x0200, METHOD_BUFFERED, FILE_READ_ACCESS);
final IOCTL_DISK_MEDIA_REMOVAL =
    CTL_CODE(IOCTL_DISK_BASE, 0x0201, METHOD_BUFFERED, FILE_READ_ACCESS);
final IOCTL_DISK_EJECT_MEDIA =
    CTL_CODE(IOCTL_DISK_BASE, 0x0202, METHOD_BUFFERED, FILE_READ_ACCESS);
final IOCTL_DISK_LOAD_MEDIA =
    CTL_CODE(IOCTL_DISK_BASE, 0x0203, METHOD_BUFFERED, FILE_READ_ACCESS);
final IOCTL_DISK_RESERVE =
    CTL_CODE(IOCTL_DISK_BASE, 0x0204, METHOD_BUFFERED, FILE_READ_ACCESS);
final IOCTL_DISK_RELEASE =
    CTL_CODE(IOCTL_DISK_BASE, 0x0205, METHOD_BUFFERED, FILE_READ_ACCESS);
final IOCTL_DISK_FIND_NEW_DEVICES =
    CTL_CODE(IOCTL_DISK_BASE, 0x0206, METHOD_BUFFERED, FILE_READ_ACCESS);
final IOCTL_DISK_GET_MEDIA_TYPES =
    CTL_CODE(IOCTL_DISK_BASE, 0x0300, METHOD_BUFFERED, FILE_ANY_ACCESS);

final FSCTL_REQUEST_OPLOCK_LEVEL_1 =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 0, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_REQUEST_OPLOCK_LEVEL_2 =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 1, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_REQUEST_BATCH_OPLOCK =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 2, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_OPLOCK_BREAK_ACKNOWLEDGE =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 3, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_OPBATCH_ACK_CLOSE_PENDING =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 4, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_OPLOCK_BREAK_NOTIFY =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 5, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_LOCK_VOLUME =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 6, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_UNLOCK_VOLUME =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 7, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_DISMOUNT_VOLUME =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 8, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_IS_VOLUME_MOUNTED =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 10, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_IS_PATHNAME_VALID =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 11, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_MARK_VOLUME_DIRTY =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 12, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_QUERY_RETRIEVAL_POINTERS =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 14, METHOD_NEITHER, FILE_ANY_ACCESS);
final FSCTL_GET_COMPRESSION =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 15, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_SET_COMPRESSION = CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 16,
    METHOD_BUFFERED, FILE_READ_DATA | FILE_WRITE_DATA);
final FSCTL_SET_BOOTLOADER_ACCESSED =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 19, METHOD_NEITHER, FILE_ANY_ACCESS);
final FSCTL_MARK_AS_SYSTEM_HIVE = FSCTL_SET_BOOTLOADER_ACCESSED;
final FSCTL_OPLOCK_BREAK_ACK_NO_2 =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 20, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_INVALIDATE_VOLUMES =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 21, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_QUERY_FAT_BPB =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 22, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_REQUEST_FILTER_OPLOCK =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 23, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_FILESYSTEM_GET_STATISTICS =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 24, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_GET_NTFS_VOLUME_DATA =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 25, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_GET_NTFS_FILE_RECORD =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 26, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_GET_VOLUME_BITMAP =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 27, METHOD_NEITHER, FILE_ANY_ACCESS);
final FSCTL_GET_RETRIEVAL_POINTERS =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 28, METHOD_NEITHER, FILE_ANY_ACCESS);
final FSCTL_MOVE_FILE =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 29, METHOD_BUFFERED, FILE_SPECIAL_ACCESS);
final FSCTL_IS_VOLUME_DIRTY =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 30, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_ALLOW_EXTENDED_DASD_IO =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 32, METHOD_NEITHER, FILE_ANY_ACCESS);
final FSCTL_FIND_FILES_BY_SID =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 35, METHOD_NEITHER, FILE_ANY_ACCESS);
final FSCTL_SET_OBJECT_ID =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 38, METHOD_BUFFERED, FILE_SPECIAL_ACCESS);
final FSCTL_GET_OBJECT_ID =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 39, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_DELETE_OBJECT_ID =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 40, METHOD_BUFFERED, FILE_SPECIAL_ACCESS);
final FSCTL_SET_REPARSE_POINT =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 41, METHOD_BUFFERED, FILE_SPECIAL_ACCESS);
final FSCTL_GET_REPARSE_POINT =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 42, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_DELETE_REPARSE_POINT =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 43, METHOD_BUFFERED, FILE_SPECIAL_ACCESS);
final FSCTL_ENUM_USN_DATA =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 44, METHOD_NEITHER, FILE_ANY_ACCESS);
final FSCTL_SECURITY_ID_CHECK =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 45, METHOD_NEITHER, FILE_READ_DATA);
final FSCTL_READ_USN_JOURNAL =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 46, METHOD_NEITHER, FILE_ANY_ACCESS);
final FSCTL_SET_OBJECT_ID_EXTENDED =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 47, METHOD_BUFFERED, FILE_SPECIAL_ACCESS);
final FSCTL_CREATE_OR_GET_OBJECT_ID =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 48, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_SET_SPARSE =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 49, METHOD_BUFFERED, FILE_SPECIAL_ACCESS);
final FSCTL_SET_ZERO_DATA =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 50, METHOD_BUFFERED, FILE_WRITE_DATA);
final FSCTL_QUERY_ALLOCATED_RANGES =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 51, METHOD_NEITHER, FILE_READ_DATA);
final FSCTL_ENABLE_UPGRADE =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 52, METHOD_BUFFERED, FILE_WRITE_DATA);
final FSCTL_SET_ENCRYPTION =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 53, METHOD_NEITHER, FILE_ANY_ACCESS);
final FSCTL_ENCRYPTION_FSCTL_IO =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 54, METHOD_NEITHER, FILE_ANY_ACCESS);
final FSCTL_WRITE_RAW_ENCRYPTED =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 55, METHOD_NEITHER, FILE_SPECIAL_ACCESS);
final FSCTL_READ_RAW_ENCRYPTED =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 56, METHOD_NEITHER, FILE_SPECIAL_ACCESS);
final FSCTL_CREATE_USN_JOURNAL =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 57, METHOD_NEITHER, FILE_ANY_ACCESS);
final FSCTL_READ_FILE_USN_DATA =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 58, METHOD_NEITHER, FILE_ANY_ACCESS);
final FSCTL_WRITE_USN_CLOSE_RECORD =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 59, METHOD_NEITHER, FILE_ANY_ACCESS);
final FSCTL_EXTEND_VOLUME =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 60, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_QUERY_USN_JOURNAL =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 61, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_DELETE_USN_JOURNAL =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 62, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_MARK_HANDLE =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 63, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_SIS_COPYFILE =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 64, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_SIS_LINK_FILES = CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 65,
    METHOD_BUFFERED, FILE_READ_DATA | FILE_WRITE_DATA);
final FSCTL_RECALL_FILE =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 69, METHOD_NEITHER, FILE_ANY_ACCESS);
final FSCTL_READ_FROM_PLEX =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 71, METHOD_OUT_DIRECT, FILE_READ_DATA);
final FSCTL_FILE_PREFETCH =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 72, METHOD_BUFFERED, FILE_SPECIAL_ACCESS);
final FSCTL_MAKE_MEDIA_COMPATIBLE =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 76, METHOD_BUFFERED, FILE_WRITE_DATA);
final FSCTL_SET_DEFECT_MANAGEMENT =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 77, METHOD_BUFFERED, FILE_WRITE_DATA);
final FSCTL_QUERY_SPARING_INFO =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 78, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_QUERY_ON_DISK_VOLUME_INFO =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 79, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_SET_VOLUME_COMPRESSION_STATE =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 80, METHOD_BUFFERED, FILE_SPECIAL_ACCESS);
final FSCTL_TXFS_MODIFY_RM =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 81, METHOD_BUFFERED, FILE_WRITE_DATA);
final FSCTL_TXFS_QUERY_RM_INFORMATION =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 82, METHOD_BUFFERED, FILE_READ_DATA);
final FSCTL_TXFS_ROLLFORWARD_REDO =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 84, METHOD_BUFFERED, FILE_WRITE_DATA);
final FSCTL_TXFS_ROLLFORWARD_UNDO =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 85, METHOD_BUFFERED, FILE_WRITE_DATA);
final FSCTL_TXFS_START_RM =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 86, METHOD_BUFFERED, FILE_WRITE_DATA);
final FSCTL_TXFS_SHUTDOWN_RM =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 87, METHOD_BUFFERED, FILE_WRITE_DATA);
final FSCTL_TXFS_READ_BACKUP_INFORMATION =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 88, METHOD_BUFFERED, FILE_READ_DATA);
final FSCTL_TXFS_WRITE_BACKUP_INFORMATION =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 89, METHOD_BUFFERED, FILE_WRITE_DATA);
final FSCTL_TXFS_CREATE_SECONDARY_RM =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 90, METHOD_BUFFERED, FILE_WRITE_DATA);
final FSCTL_TXFS_GET_METADATA_INFO =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 91, METHOD_BUFFERED, FILE_READ_DATA);
final FSCTL_TXFS_GET_TRANSACTED_VERSION =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 92, METHOD_BUFFERED, FILE_READ_DATA);
final FSCTL_TXFS_SAVEPOINT_INFORMATION =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 94, METHOD_BUFFERED, FILE_WRITE_DATA);
final FSCTL_TXFS_CREATE_MINIVERSION =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 95, METHOD_BUFFERED, FILE_WRITE_DATA);
final FSCTL_TXFS_TRANSACTION_ACTIVE =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 99, METHOD_BUFFERED, FILE_READ_DATA);
final FSCTL_SET_ZERO_ON_DEALLOCATION = CTL_CODE(
    FILE_DEVICE_FILE_SYSTEM, 101, METHOD_BUFFERED, FILE_SPECIAL_ACCESS);
final FSCTL_SET_REPAIR =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 102, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_GET_REPAIR =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 103, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_WAIT_FOR_REPAIR =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 104, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_INITIATE_REPAIR =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 106, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_CSC_INTERNAL =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 107, METHOD_NEITHER, FILE_ANY_ACCESS);
final FSCTL_SHRINK_VOLUME = CTL_CODE(
    FILE_DEVICE_FILE_SYSTEM, 108, METHOD_BUFFERED, FILE_SPECIAL_ACCESS);
final FSCTL_SET_SHORT_NAME_BEHAVIOR =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 109, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_DFSR_SET_GHOST_HANDLE_STATE =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 110, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_TXFS_LIST_TRANSACTION_LOCKED_FILES =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 120, METHOD_BUFFERED, FILE_READ_DATA);
final FSCTL_TXFS_LIST_TRANSACTIONS =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 121, METHOD_BUFFERED, FILE_READ_DATA);
final FSCTL_QUERY_PAGEFILE_ENCRYPTION =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 122, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_RESET_VOLUME_ALLOCATION_HINTS =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 123, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_QUERY_DEPENDENT_VOLUME =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 124, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_SD_GLOBAL_CHANGE =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 125, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_TXFS_READ_BACKUP_INFORMATION2 =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 126, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_LOOKUP_STREAM_FROM_CLUSTER =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 127, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_TXFS_WRITE_BACKUP_INFORMATION2 =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 128, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_FILE_TYPE_NOTIFICATION =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 129, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_FILE_LEVEL_TRIM =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 130, METHOD_BUFFERED, FILE_WRITE_DATA);
final FSCTL_GET_BOOT_AREA_INFO =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 140, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_GET_RETRIEVAL_POINTER_BASE =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 141, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_SET_PERSISTENT_VOLUME_STATE =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 142, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_QUERY_PERSISTENT_VOLUME_STATE =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 143, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_REQUEST_OPLOCK =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 144, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_CSV_TUNNEL_REQUEST =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 145, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_IS_CSV_FILE =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 146, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_QUERY_FILE_SYSTEM_RECOGNITION =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 147, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_CSV_GET_VOLUME_PATH_NAME =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 148, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_CSV_GET_VOLUME_NAME_FOR_VOLUME_MOUNT_POINT =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 149, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_CSV_GET_VOLUME_PATH_NAMES_FOR_VOLUME_NAME =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 150, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_IS_FILE_ON_CSV_VOLUME =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 151, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_CORRUPTION_HANDLING =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 152, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_OFFLOAD_READ =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 153, METHOD_BUFFERED, FILE_READ_ACCESS);
final FSCTL_OFFLOAD_WRITE =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 154, METHOD_BUFFERED, FILE_WRITE_ACCESS);
final FSCTL_CSV_INTERNAL =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 155, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_SET_PURGE_FAILURE_MODE =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 156, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_QUERY_FILE_LAYOUT =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 157, METHOD_NEITHER, FILE_ANY_ACCESS);
final FSCTL_IS_VOLUME_OWNED_BYCSVFS =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 158, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_GET_INTEGRITY_INFORMATION =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 159, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_SET_INTEGRITY_INFORMATION = CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 160,
    METHOD_BUFFERED, FILE_READ_DATA | FILE_WRITE_DATA);
final FSCTL_QUERY_FILE_REGIONS =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 161, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_RKF_INTERNAL =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 171, METHOD_NEITHER, FILE_ANY_ACCESS);
final FSCTL_SCRUB_DATA =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 172, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_REPAIR_COPIES = CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 173,
    METHOD_BUFFERED, FILE_READ_DATA | FILE_WRITE_DATA);
final FSCTL_DISABLE_LOCAL_BUFFERING =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 174, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_CSV_MGMT_LOCK =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 175, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_CSV_QUERY_DOWN_LEVEL_FILE_SYSTEM_CHARACTERISTICS =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 176, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_ADVANCE_FILE_ID =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 177, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_CSV_SYNC_TUNNEL_REQUEST =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 178, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_CSV_QUERY_VETO_FILE_DIRECT_IO =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 179, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_WRITE_USN_REASON =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 180, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_CSV_CONTROL =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 181, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_GET_REFS_VOLUME_DATA =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 182, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_CSV_H_BREAKING_SYNC_TUNNEL_REQUEST =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 185, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_QUERY_STORAGE_CLASSES =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 187, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_QUERY_REGION_INFO =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 188, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_USN_TRACK_MODIFIED_RANGES =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 189, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_QUERY_SHARED_VIRTUAL_DISK_SUPPORT =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 192, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_SVHDX_SYNC_TUNNEL_REQUEST =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 193, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_SVHDX_SET_INITIATOR_INFORMATION =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 194, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_SET_EXTERNAL_BACKING = CTL_CODE(
    FILE_DEVICE_FILE_SYSTEM, 195, METHOD_BUFFERED, FILE_SPECIAL_ACCESS);
final FSCTL_GET_EXTERNAL_BACKING =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 196, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_DELETE_EXTERNAL_BACKING = CTL_CODE(
    FILE_DEVICE_FILE_SYSTEM, 197, METHOD_BUFFERED, FILE_SPECIAL_ACCESS);
final FSCTL_ENUM_EXTERNAL_BACKING =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 198, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_ENUM_OVERLAY =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 199, METHOD_NEITHER, FILE_ANY_ACCESS);
final FSCTL_ADD_OVERLAY =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 204, METHOD_BUFFERED, FILE_WRITE_DATA);
final FSCTL_REMOVE_OVERLAY =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 205, METHOD_BUFFERED, FILE_WRITE_DATA);
final FSCTL_UPDATE_OVERLAY =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 206, METHOD_BUFFERED, FILE_WRITE_DATA);
final FSCTL_SHUFFLE_FILE = CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 208,
    METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final FSCTL_DUPLICATE_EXTENTS_TO_FILE =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 209, METHOD_BUFFERED, FILE_WRITE_DATA);
final FSCTL_SPARSE_OVERALLOCATE = CTL_CODE(
    FILE_DEVICE_FILE_SYSTEM, 211, METHOD_BUFFERED, FILE_SPECIAL_ACCESS);
final FSCTL_STORAGE_QOS_CONTROL =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 212, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_INITIATE_FILE_METADATA_OPTIMIZATION = CTL_CODE(
    FILE_DEVICE_FILE_SYSTEM, 215, METHOD_BUFFERED, FILE_SPECIAL_ACCESS);
final FSCTL_QUERY_FILE_METADATA_OPTIMIZATION = CTL_CODE(
    FILE_DEVICE_FILE_SYSTEM, 216, METHOD_BUFFERED, FILE_SPECIAL_ACCESS);
final FSCTL_SVHDX_ASYNC_TUNNEL_REQUEST =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 217, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_GET_WOF_VERSION =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 218, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_HCS_SYNC_TUNNEL_REQUEST =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 219, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_HCS_ASYNC_TUNNEL_REQUEST =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 220, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_QUERY_EXTENT_READ_CACHE_INFO =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 221, METHOD_NEITHER, FILE_ANY_ACCESS);
final FSCTL_QUERY_REFS_VOLUME_COUNTER_INFO =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 222, METHOD_NEITHER, FILE_ANY_ACCESS);
final FSCTL_CLEAN_VOLUME_METADATA =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 223, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_SET_INTEGRITY_INFORMATION_EX =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 224, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_SUSPEND_OVERLAY =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 225, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_VIRTUAL_STORAGE_QUERY_PROPERTY =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 226, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_FILESYSTEM_GET_STATISTICS_EX =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 227, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_QUERY_VOLUME_CONTAINER_STATE =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 228, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_SET_LAYER_ROOT =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 229, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_QUERY_DIRECT_ACCESS_EXTENTS =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 230, METHOD_NEITHER, FILE_ANY_ACCESS);
final FSCTL_NOTIFY_STORAGE_SPACE_ALLOCATION =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 231, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_SSDI_STORAGE_REQUEST =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 232, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_QUERY_DIRECT_IMAGE_ORIGINAL_BASE =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 233, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_READ_UNPRIVILEGED_USN_JOURNAL =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 234, METHOD_NEITHER, FILE_ANY_ACCESS);
final FSCTL_GHOST_FILE_EXTENTS =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 235, METHOD_BUFFERED, FILE_WRITE_ACCESS);
final FSCTL_QUERY_GHOSTED_FILE_EXTENTS =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 236, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_UNMAP_SPACE =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 237, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_HCS_SYNC_NO_WRITE_TUNNEL_REQUEST =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 238, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_STREAMS_QUERY_PARAMETERS =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 241, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_STREAMS_ASSOCIATE_ID =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 242, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_STREAMS_QUERY_ID =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 243, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_GET_RETRIEVAL_POINTERS_AND_REFCOUNT =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 244, METHOD_NEITHER, FILE_ANY_ACCESS);
final FSCTL_QUERY_VOLUME_NUMA_INFO =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 245, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_REFS_DEALLOCATE_RANGES =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 246, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_QUERY_REFS_SMR_VOLUME_INFO =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 247, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_SET_REFS_SMR_VOLUME_GC_PARAMETERS =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 248, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_SET_REFS_FILE_STRICTLY_SEQUENTIAL =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 249, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_DUPLICATE_EXTENTS_TO_FILE_EX =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 250, METHOD_BUFFERED, FILE_WRITE_DATA);
final FSCTL_QUERY_BAD_RANGES =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 251, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_SET_DAX_ALLOC_ALIGNMENT_HINT =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 252, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_DELETE_CORRUPTED_REFS_CONTAINER =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 253, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_SCRUB_UNDISCOVERABLE_ID =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 254, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_NOTIFY_DATA_CHANGE =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 255, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_START_VIRTUALIZATION_INSTANCE_EX =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 256, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_ENCRYPTION_KEY_CONTROL =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 257, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_VIRTUAL_STORAGE_SET_BEHAVIOR =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 258, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_SET_REPARSE_POINT_EX = CTL_CODE(
    FILE_DEVICE_FILE_SYSTEM, 259, METHOD_BUFFERED, FILE_SPECIAL_ACCESS);
final FSCTL_REARRANGE_FILE = CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 264,
    METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final FSCTL_VIRTUAL_STORAGE_PASSTHROUGH =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 265, METHOD_BUFFERED, FILE_ANY_ACCESS);
final FSCTL_GET_RETRIEVAL_POINTER_COUNT =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 266, METHOD_NEITHER, FILE_ANY_ACCESS);
final FSCTL_ENABLE_PER_IO_FLAGS =
    CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 267, METHOD_BUFFERED, FILE_ANY_ACCESS);

final IOCTL_STORAGE_BASE = FILE_DEVICE_MASS_STORAGE;

final IOCTL_STORAGE_CHECK_VERIFY =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0200, METHOD_BUFFERED, FILE_READ_ACCESS);
final IOCTL_STORAGE_CHECK_VERIFY2 =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0200, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_STORAGE_MEDIA_REMOVAL =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0201, METHOD_BUFFERED, FILE_READ_ACCESS);
final IOCTL_STORAGE_EJECT_MEDIA =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0202, METHOD_BUFFERED, FILE_READ_ACCESS);
final IOCTL_STORAGE_LOAD_MEDIA =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0203, METHOD_BUFFERED, FILE_READ_ACCESS);
final IOCTL_STORAGE_LOAD_MEDIA2 =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0203, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_STORAGE_RESERVE =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0204, METHOD_BUFFERED, FILE_READ_ACCESS);
final IOCTL_STORAGE_RELEASE =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0205, METHOD_BUFFERED, FILE_READ_ACCESS);
final IOCTL_STORAGE_FIND_NEW_DEVICES =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0206, METHOD_BUFFERED, FILE_READ_ACCESS);
final IOCTL_STORAGE_EJECTION_CONTROL =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0250, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_STORAGE_MCN_CONTROL =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0251, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_STORAGE_GET_MEDIA_TYPES =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0300, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_STORAGE_GET_MEDIA_TYPES_EX =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0301, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_STORAGE_GET_MEDIA_SERIAL_NUMBER =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0304, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_STORAGE_GET_HOTPLUG_INFO =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0305, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_STORAGE_SET_HOTPLUG_INFO = CTL_CODE(IOCTL_STORAGE_BASE, 0x0306,
    METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final IOCTL_STORAGE_RESET_BUS =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0400, METHOD_BUFFERED, FILE_READ_ACCESS);
final IOCTL_STORAGE_RESET_DEVICE =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0401, METHOD_BUFFERED, FILE_READ_ACCESS);
final IOCTL_STORAGE_BREAK_RESERVATION =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0405, METHOD_BUFFERED, FILE_READ_ACCESS);
final IOCTL_STORAGE_PERSISTENT_RESERVE_IN =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0406, METHOD_BUFFERED, FILE_READ_ACCESS);
final IOCTL_STORAGE_PERSISTENT_RESERVE_OUT = CTL_CODE(IOCTL_STORAGE_BASE,
    0x0407, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final IOCTL_STORAGE_GET_DEVICE_NUMBER =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0420, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_STORAGE_GET_DEVICE_NUMBER_EX =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0421, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_STORAGE_PREDICT_FAILURE =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0440, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_STORAGE_FAILURE_PREDICTION_CONFIG =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0441, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_STORAGE_GET_COUNTERS =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x442, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_STORAGE_READ_CAPACITY =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0450, METHOD_BUFFERED, FILE_READ_ACCESS);
final IOCTL_STORAGE_GET_DEVICE_TELEMETRY = CTL_CODE(IOCTL_STORAGE_BASE, 0x0470,
    METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final IOCTL_STORAGE_DEVICE_TELEMETRY_NOTIFY = CTL_CODE(IOCTL_STORAGE_BASE,
    0x0471, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final IOCTL_STORAGE_DEVICE_TELEMETRY_QUERY_CAPS = CTL_CODE(IOCTL_STORAGE_BASE,
    0x0472, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final IOCTL_STORAGE_GET_DEVICE_TELEMETRY_RAW = CTL_CODE(IOCTL_STORAGE_BASE,
    0x0473, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final IOCTL_STORAGE_SET_TEMPERATURE_THRESHOLD = CTL_CODE(IOCTL_STORAGE_BASE,
    0x0480, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final IOCTL_STORAGE_PROTOCOL_COMMAND = CTL_CODE(IOCTL_STORAGE_BASE, 0x04F0,
    METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final IOCTL_STORAGE_QUERY_PROPERTY =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0500, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_STORAGE_MANAGE_DATA_SET_ATTRIBUTES =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0501, METHOD_BUFFERED, FILE_WRITE_ACCESS);
final IOCTL_STORAGE_GET_LB_PROVISIONING_MAP_RESOURCES =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0502, METHOD_BUFFERED, FILE_READ_ACCESS);
final IOCTL_STORAGE_SET_PROPERTY =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0503, METHOD_BUFFERED, FILE_WRITE_ACCESS);
final IOCTL_STORAGE_REINITIALIZE_MEDIA =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0590, METHOD_BUFFERED, FILE_WRITE_ACCESS);
final IOCTL_STORAGE_GET_BC_PROPERTIES =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0600, METHOD_BUFFERED, FILE_READ_ACCESS);
final IOCTL_STORAGE_ALLOCATE_BC_STREAM = CTL_CODE(IOCTL_STORAGE_BASE, 0x0601,
    METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final IOCTL_STORAGE_FREE_BC_STREAM = CTL_CODE(IOCTL_STORAGE_BASE, 0x0602,
    METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final IOCTL_STORAGE_CHECK_PRIORITY_HINT_SUPPORT =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0620, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_STORAGE_START_DATA_INTEGRITY_CHECK = CTL_CODE(IOCTL_STORAGE_BASE,
    0x0621, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final IOCTL_STORAGE_STOP_DATA_INTEGRITY_CHECK = CTL_CODE(IOCTL_STORAGE_BASE,
    0x0622, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final OBSOLETE_IOCTL_STORAGE_RESET_BUS = CTL_CODE(IOCTL_STORAGE_BASE, 0x0400,
    METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final OBSOLETE_IOCTL_STORAGE_RESET_DEVICE = CTL_CODE(IOCTL_STORAGE_BASE, 0x0401,
    METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final IOCTL_STORAGE_FIRMWARE_GET_INFO =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0700, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_STORAGE_FIRMWARE_DOWNLOAD = CTL_CODE(IOCTL_STORAGE_BASE, 0x0701,
    METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final IOCTL_STORAGE_FIRMWARE_ACTIVATE = CTL_CODE(IOCTL_STORAGE_BASE, 0x0702,
    METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final IOCTL_STORAGE_ENABLE_IDLE_POWER =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0720, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_STORAGE_GET_IDLE_POWERUP_REASON =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0721, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_STORAGE_POWER_ACTIVE =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0722, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_STORAGE_POWER_IDLE =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0723, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_STORAGE_EVENT_NOTIFICATION =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0724, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_STORAGE_DEVICE_POWER_CAP =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0725, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_STORAGE_RPMB_COMMAND =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0726, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_STORAGE_ATTRIBUTE_MANAGEMENT = CTL_CODE(IOCTL_STORAGE_BASE, 0x0727,
    METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS);
final IOCTL_STORAGE_DIAGNOSTIC =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0728, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_STORAGE_GET_PHYSICAL_ELEMENT_STATUS =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0729, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_STORAGE_REMOVE_ELEMENT_AND_TRUNCATE =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0730, METHOD_BUFFERED, FILE_ANY_ACCESS);
final IOCTL_STORAGE_GET_DEVICE_INTERNAL_LOG =
    CTL_CODE(IOCTL_STORAGE_BASE, 0x0731, METHOD_BUFFERED, FILE_ANY_ACCESS);
