v3.0.3

* [Experimental] Fixed UuidValue to properly check things are valid. (Thanks @FlorianUlivi)
* [Experimental] Added new constructors `fromByteList` and `fromList` to `UuidValue`
* [Experimental] Added `==` operator override and hashcode override. (Thanks @giorgiofran for suggestion)
* Added `parseAsByteList` to offer a direct output to `Uint8List`
* [Experimental][BREAKING CHANGE] Change `toBytes` in `UuidValue` to return `Uint8List` instead of `List<int>`
* [Experimental][BREAKING CHANGE] `isValidUuid` function signature has changed, now takes 2 optional parameters `fromString` and `fromList` that will do the appropriate validation on different sources.

v3.0.2

* [Experimental] Add flags to UuidValue constructor and parse to disable validation of the UUID, primarily to allow Microsoft GUIDs to not break things.

v3.0.1

* Fix RNG to not need shuffling and improve performance/memory usage (Thanks @julemand101)

v3.0.0

* Release nullsafety version 

v3.0.0-nullsafety.1

* [BREAKING CHANGE] Changed `parse()` to throw a FormatException instead of returning NIL uuids or partially handled UUIDs.
* Changed `Uuid` constructor to be constant, and adjusted all the code accordingly.
* New `isValidUUID` function for validating UUIDs.
* [BREAKING CHANGE] `parse` and `unparse` are now static functions.
* [Exprimental] Object version of the UUID instead of a string or list of bytes.

v3.0.0-nullsafety.0

* Migrate package to null-safety, increase minimum SDK version to 2.12 (Thanks @simolus3)

v2.2.1 & v2.2.2

* Update pedantic analyzer options, fix linting issues, and increase SDK minimium to 2.2 to support set literals

v2.2.0

* fix v1 clock high to properly ignore c and d variants. (fixes #47)
* update example

v2.1.0

* Shuffle mathRNG bytes so that they don't generate duplicates. Will affect codes generated by a static seed.

v2.0.4

* Remove new keyword where not needed. (forgot to rerun before releasing 2.0.3)

v2.0.3

* Do some analyzer fixes and formatting/renaming.

v2.0.2

* Merge fix for time precision loss in V1 time based UUIDs.

v2.0.1

* Fix regression where CryptoRNG was default, moved back to MathRNG
* Added ability to set RNG globally to skip having to set it in every function call
* Allows you to set the v1 clock sequence, nodeID, and seed bytes to use cryptoRNG separately from globalRNG.

v2.0.0

* Fixup the API to split out Buffer and Non-buffer usages.
* Switch to build in Random.secure() and remove custom AES implementation.
* Less dependencies.
* Docs
* Cleanup

v1.0.3

* Fix SDK constraints to allow Dart 2.0 stable.

v1.0.2

* Fix constants breaking in Dart 1.x, need to be backwards compatible. 

v1.0.1

* Fix constants to match Dart 2.0 spec

v1.0.0

* Cleanup and prep for dart 2.0
* Has been stable for a long time, upgrading to 1.0 version

v0.5.3

* Merged pull request to support crypto 2.0.0
* Support convert 2.0.0

v0.5.2

* Merged pull request to upgrade crypto library to 1.0.0.

v0.5.1

* Merged pull request for various updates and cleanup.

v0.5.0

* Reverted back to custom AES implementation. Moved RNG methods to UuidUtil (import 'package:uuid/uuid_util.dart')
* Fixed a potential bug with custom RNG method passing and added more ways to pass in custom RNG functions.
* Cleaned up and refactored some stuff. Using only v1 is only 67kb of js, Using only v4 is 97kb. Using crypt v4 is 118kb. Using both v1 and non-crypto v4 is 126kb.
* Default RNG for v4 is now the mathRNG function. If you wish to use cryptoRNG, import UuidUtil and pass in cryptoRNG.
* Updated README.md with more examples and usages.
* Updated Tests.

v0.4.1

* Changed initCipher location so that if you ever only use v1 UUIDs, you will get a very small Dart2JS output compared to v4 or v5 that do load it.

v0.4.0

* Use Cipher base.dart, as I don't need entropy generators, and this allows me to merge client/server together again
  and fix many issues this caused.

v0.3.2

* Fix import/library bug.

v0.3.1

* Update pubspec to allow installation of the latest Cipher 0.7.

v0.3.0

* Updated to latest Cipher at 0.6.0. This created a breaking change in the imports. Please make sure you update your code.
* Fixed problem when creating v4 UUIDs too fast, it would create duplicate UUIDs.

v0.2.2

* Pegging cipher to 0.4.0 temporarily for browser support

v0.2.1

* Using new version of cipher.

v0.2.0

* Dart 1.0 Readiness
* Switched from custom AES to [cipher](https://github.com/izaera/cipher) package AES.

v0.1.6

* Adjusting usage of constants.
* Fixing tests.

v0.1.5

* Stupid typo on import.

v0.1.4

* Fixing Crypto package move.

v0.1.3

* Fixing language changes.

v0.1.2

* Fix change of charCodes to codeUnits

v0.1.1

* Fixing syntax for upcoming breaking changes.

v0.1.0

* Cleanup, changes, and prep for M3.

v0.0.9

* Minor fix with a const RegExp
* Made sure everything builds on latest dart.
* Fixed pubspec to now import unittest from pub instead of sdk.

v0.0.8

* Changed to the new optional paramater syntaxes and usages.
* Adjusted tests for the new function call style due to parameter change.
* Fixed Import/Source/Library statements to the new format.

v0.0.7

* Made changes requested by the Google team to get my package up on pub.dartlang.org

v0.0.6

* Fixed up some code to make it possibly faster and using better Dart practices.
* Cleaned up some documentation.

v0.0.5

* Added Initial AES for Dart (untested if it actually works/matches other AES encryptors)
* Use AES cipher to create crypto strong bytes.

v0.0.4

* Issue wasn't Math.Random() but a bad reseed by me.
* Cleaned up for new Pub layout.

v0.0.3

* Added UUIDv5
* Fixed UUIDv4 bugs
* Added more unit tests
* Found bug in dart's Math.Random(), reported, waiting for fix to fix my code.

v0.0.2

* Initial tests
* Fixed some parser bugs.

v0.0.1

* Initial Release
* No tests
