/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.deferredcomponents;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.os.Build;
import android.os.Bundle;
import android.util.SparseArray;
import android.util.SparseIntArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.play.core.splitinstall.SplitInstallException;
import com.google.android.play.core.splitinstall.SplitInstallManager;
import com.google.android.play.core.splitinstall.SplitInstallManagerFactory;
import com.google.android.play.core.splitinstall.SplitInstallRequest;
import com.google.android.play.core.splitinstall.SplitInstallSessionState;
import com.google.android.play.core.splitinstall.SplitInstallStateUpdatedListener;
import io.flutter.Log;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.deferredcomponents.DeferredComponentManager;
import io.flutter.embedding.engine.loader.ApplicationInfoLoader;
import io.flutter.embedding.engine.loader.FlutterApplicationInfo;
import io.flutter.embedding.engine.systemchannels.DeferredComponentChannel;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class PlayStoreDeferredComponentManager
implements DeferredComponentManager {
    private static final String TAG = "PlayStoreDeferredComponentManager";
    public static final String MAPPING_KEY = DeferredComponentManager.class.getName() + ".loadingUnitMapping";
    @NonNull
    private SplitInstallManager splitInstallManager;
    @Nullable
    private FlutterJNI flutterJNI;
    @Nullable
    private DeferredComponentChannel channel;
    @NonNull
    private Context context;
    @NonNull
    private FlutterApplicationInfo flutterApplicationInfo;
    @NonNull
    private SparseArray<String> sessionIdToName;
    @NonNull
    private SparseIntArray sessionIdToLoadingUnitId;
    @NonNull
    private SparseArray<String> sessionIdToState;
    @NonNull
    private Map<String, Integer> nameToSessionId;
    @NonNull
    protected SparseArray<String> loadingUnitIdToComponentNames;
    @NonNull
    protected SparseArray<String> loadingUnitIdToSharedLibraryNames;
    private FeatureInstallStateUpdatedListener listener;

    public PlayStoreDeferredComponentManager(@NonNull Context context, @Nullable FlutterJNI flutterJNI) {
        this.context = context;
        this.flutterJNI = flutterJNI;
        this.flutterApplicationInfo = ApplicationInfoLoader.load(context);
        this.splitInstallManager = SplitInstallManagerFactory.create((Context)context);
        this.listener = new FeatureInstallStateUpdatedListener();
        this.splitInstallManager.registerListener((SplitInstallStateUpdatedListener)this.listener);
        this.sessionIdToName = new SparseArray();
        this.sessionIdToLoadingUnitId = new SparseIntArray();
        this.sessionIdToState = new SparseArray();
        this.nameToSessionId = new HashMap<String, Integer>();
        this.loadingUnitIdToComponentNames = new SparseArray();
        this.loadingUnitIdToSharedLibraryNames = new SparseArray();
        this.initLoadingUnitMappingToComponentNames();
    }

    @Override
    public void setJNI(@NonNull FlutterJNI flutterJNI) {
        this.flutterJNI = flutterJNI;
    }

    private boolean verifyJNI() {
        if (this.flutterJNI == null) {
            Log.e(TAG, "No FlutterJNI provided. `setJNI` must be called on the DeferredComponentManager before attempting to load dart libraries or invoking with platform channels.");
            return false;
        }
        return true;
    }

    @Override
    public void setDeferredComponentChannel(DeferredComponentChannel channel) {
        this.channel = channel;
    }

    @NonNull
    private ApplicationInfo getApplicationInfo() {
        try {
            return this.context.getPackageManager().getApplicationInfo(this.context.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void initLoadingUnitMappingToComponentNames() {
        Bundle metaData;
        String mappingKey = DeferredComponentManager.class.getName() + ".loadingUnitMapping";
        ApplicationInfo applicationInfo = this.getApplicationInfo();
        if (applicationInfo != null && (metaData = applicationInfo.metaData) != null) {
            String rawMappingString = metaData.getString(MAPPING_KEY, null);
            if (rawMappingString == null) {
                Log.e(TAG, "No loading unit to dynamic feature module name found. Ensure '" + MAPPING_KEY + "' is defined in the base module's AndroidManifest.");
            } else {
                for (String entry : rawMappingString.split(",")) {
                    String[] splitEntry = entry.split(":", -1);
                    int loadingUnitId = Integer.parseInt(splitEntry[0]);
                    this.loadingUnitIdToComponentNames.put(loadingUnitId, (Object)splitEntry[1]);
                    if (splitEntry.length <= 2) continue;
                    this.loadingUnitIdToSharedLibraryNames.put(loadingUnitId, (Object)splitEntry[2]);
                }
            }
        }
    }

    @Override
    public void installDeferredComponent(int loadingUnitId, String componentName) {
        String resolvedComponentName;
        String string = resolvedComponentName = componentName != null ? componentName : (String)this.loadingUnitIdToComponentNames.get(loadingUnitId);
        if (resolvedComponentName == null) {
            Log.e(TAG, "Deferred component name was null and could not be resolved from loading unit id.");
            return;
        }
        if (resolvedComponentName.equals("") && loadingUnitId > 0) {
            this.loadDartLibrary(loadingUnitId, resolvedComponentName);
            return;
        }
        SplitInstallRequest request = SplitInstallRequest.newBuilder().addModule(resolvedComponentName).build();
        this.splitInstallManager.startInstall(request).addOnSuccessListener(sessionId -> {
            this.sessionIdToName.put(sessionId.intValue(), (Object)resolvedComponentName);
            this.sessionIdToLoadingUnitId.put(sessionId.intValue(), loadingUnitId);
            if (this.nameToSessionId.containsKey(resolvedComponentName)) {
                this.sessionIdToState.remove(this.nameToSessionId.get(resolvedComponentName).intValue());
            }
            this.nameToSessionId.put(resolvedComponentName, (Integer)sessionId);
            this.sessionIdToState.put(sessionId.intValue(), (Object)"Requested");
        }).addOnFailureListener(exception -> {
            switch (((SplitInstallException)exception).getErrorCode()) {
                case -6: {
                    this.flutterJNI.deferredComponentInstallFailure(loadingUnitId, String.format("Install of deferred component module \"%s\" failed with a network error", componentName), true);
                    break;
                }
                case -2: {
                    this.flutterJNI.deferredComponentInstallFailure(loadingUnitId, String.format("Install of deferred component module \"%s\" failed as it is unavailable", componentName), false);
                    break;
                }
                default: {
                    this.flutterJNI.deferredComponentInstallFailure(loadingUnitId, String.format("Install of deferred component module \"%s\" failed with error %d: %s", componentName, ((SplitInstallException)exception).getErrorCode(), ((SplitInstallException)exception).getMessage()), false);
                }
            }
        });
    }

    @Override
    public String getDeferredComponentInstallState(int loadingUnitId, String componentName) {
        String resolvedComponentName;
        String string = resolvedComponentName = componentName != null ? componentName : (String)this.loadingUnitIdToComponentNames.get(loadingUnitId);
        if (resolvedComponentName == null) {
            Log.e(TAG, "Deferred component name was null and could not be resolved from loading unit id.");
            return "unknown";
        }
        if (!this.nameToSessionId.containsKey(resolvedComponentName)) {
            if (this.splitInstallManager.getInstalledModules().contains(resolvedComponentName)) {
                return "installedPendingLoad";
            }
            return "unknown";
        }
        int sessionId = this.nameToSessionId.get(resolvedComponentName);
        return (String)this.sessionIdToState.get(sessionId);
    }

    @Override
    public void loadAssets(int loadingUnitId, String componentName) {
        if (!this.verifyJNI()) {
            return;
        }
        try {
            this.context = this.context.createPackageContext(this.context.getPackageName(), 0);
            AssetManager assetManager = this.context.getAssets();
            this.flutterJNI.updateJavaAssetManager(assetManager, this.flutterApplicationInfo.flutterAssetsDir);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void loadDartLibrary(int loadingUnitId, String componentName) {
        if (!this.verifyJNI()) {
            return;
        }
        if (loadingUnitId < 0) {
            return;
        }
        String aotSharedLibraryName = (String)this.loadingUnitIdToSharedLibraryNames.get(loadingUnitId);
        if (aotSharedLibraryName == null) {
            aotSharedLibraryName = this.flutterApplicationInfo.aotSharedLibraryName + "-" + loadingUnitId + ".part.so";
        }
        String abi = Build.VERSION.SDK_INT >= 21 ? Build.SUPPORTED_ABIS[0] : Build.CPU_ABI;
        String pathAbi = abi.replace("-", "_");
        ArrayList<String> apkPaths = new ArrayList<String>();
        ArrayList<String> soPaths = new ArrayList<String>();
        LinkedList<Object> searchFiles = new LinkedList<Object>();
        searchFiles.add(this.context.getFilesDir());
        while (!searchFiles.isEmpty()) {
            File file = (File)searchFiles.remove();
            if (file != null && file.isDirectory()) {
                for (File f : file.listFiles()) {
                    searchFiles.add(f);
                }
                continue;
            }
            String name = file.getName();
            if (name.endsWith(".apk") && name.startsWith(componentName) && name.contains(pathAbi)) {
                apkPaths.add(file.getAbsolutePath());
                continue;
            }
            if (!name.equals(aotSharedLibraryName)) continue;
            soPaths.add(file.getAbsolutePath());
        }
        ArrayList<String> searchPaths = new ArrayList<String>();
        searchPaths.add(aotSharedLibraryName);
        for (String path : apkPaths) {
            searchPaths.add(path + "!lib/" + abi + "/" + aotSharedLibraryName);
        }
        for (String path : soPaths) {
            searchPaths.add(path);
        }
        this.flutterJNI.loadDartDeferredLibrary(loadingUnitId, searchPaths.toArray(new String[apkPaths.size()]));
    }

    @Override
    public boolean uninstallDeferredComponent(int loadingUnitId, String componentName) {
        String resolvedComponentName;
        String string = resolvedComponentName = componentName != null ? componentName : (String)this.loadingUnitIdToComponentNames.get(loadingUnitId);
        if (resolvedComponentName == null) {
            Log.e(TAG, "Deferred component name was null and could not be resolved from loading unit id.");
            return false;
        }
        ArrayList<String> modulesToUninstall = new ArrayList<String>();
        modulesToUninstall.add(resolvedComponentName);
        this.splitInstallManager.deferredUninstall(modulesToUninstall);
        if (this.nameToSessionId.get(resolvedComponentName) != null) {
            this.sessionIdToState.delete(this.nameToSessionId.get(resolvedComponentName).intValue());
        }
        return true;
    }

    @Override
    public void destroy() {
        this.splitInstallManager.unregisterListener((SplitInstallStateUpdatedListener)this.listener);
        this.channel = null;
        this.flutterJNI = null;
    }

    private class FeatureInstallStateUpdatedListener
    implements SplitInstallStateUpdatedListener {
        private FeatureInstallStateUpdatedListener() {
        }

        @SuppressLint(value={"DefaultLocale"})
        public void onStateUpdate(SplitInstallSessionState state) {
            int sessionId = state.sessionId();
            if (PlayStoreDeferredComponentManager.this.sessionIdToName.get(sessionId) != null) {
                switch (state.status()) {
                    case 6: {
                        Log.e(PlayStoreDeferredComponentManager.TAG, String.format("Module \"%s\" (sessionId %d) install failed with: %s", PlayStoreDeferredComponentManager.this.sessionIdToName.get(sessionId), sessionId, state.errorCode()));
                        PlayStoreDeferredComponentManager.this.flutterJNI.deferredComponentInstallFailure(PlayStoreDeferredComponentManager.this.sessionIdToLoadingUnitId.get(sessionId), "Module install failed with " + state.errorCode(), true);
                        if (PlayStoreDeferredComponentManager.this.channel != null) {
                            PlayStoreDeferredComponentManager.this.channel.completeInstallError((String)PlayStoreDeferredComponentManager.this.sessionIdToName.get(sessionId), "Android Deferred Component failed to install.");
                        }
                        PlayStoreDeferredComponentManager.this.sessionIdToName.delete(sessionId);
                        PlayStoreDeferredComponentManager.this.sessionIdToLoadingUnitId.delete(sessionId);
                        PlayStoreDeferredComponentManager.this.sessionIdToState.put(sessionId, (Object)"failed");
                        break;
                    }
                    case 5: {
                        Log.d(PlayStoreDeferredComponentManager.TAG, String.format("Module \"%s\" (sessionId %d) install successfully.", PlayStoreDeferredComponentManager.this.sessionIdToName.get(sessionId), sessionId));
                        PlayStoreDeferredComponentManager.this.loadAssets(PlayStoreDeferredComponentManager.this.sessionIdToLoadingUnitId.get(sessionId), (String)PlayStoreDeferredComponentManager.this.sessionIdToName.get(sessionId));
                        if (PlayStoreDeferredComponentManager.this.sessionIdToLoadingUnitId.get(sessionId) > 0) {
                            PlayStoreDeferredComponentManager.this.loadDartLibrary(PlayStoreDeferredComponentManager.this.sessionIdToLoadingUnitId.get(sessionId), (String)PlayStoreDeferredComponentManager.this.sessionIdToName.get(sessionId));
                        }
                        if (PlayStoreDeferredComponentManager.this.channel != null) {
                            PlayStoreDeferredComponentManager.this.channel.completeInstallSuccess((String)PlayStoreDeferredComponentManager.this.sessionIdToName.get(sessionId));
                        }
                        PlayStoreDeferredComponentManager.this.sessionIdToName.delete(sessionId);
                        PlayStoreDeferredComponentManager.this.sessionIdToLoadingUnitId.delete(sessionId);
                        PlayStoreDeferredComponentManager.this.sessionIdToState.put(sessionId, (Object)"installed");
                        break;
                    }
                    case 7: {
                        Log.d(PlayStoreDeferredComponentManager.TAG, String.format("Module \"%s\" (sessionId %d) install canceled.", PlayStoreDeferredComponentManager.this.sessionIdToName.get(sessionId), sessionId));
                        if (PlayStoreDeferredComponentManager.this.channel != null) {
                            PlayStoreDeferredComponentManager.this.channel.completeInstallError((String)PlayStoreDeferredComponentManager.this.sessionIdToName.get(sessionId), "Android Deferred Component installation canceled.");
                        }
                        PlayStoreDeferredComponentManager.this.sessionIdToName.delete(sessionId);
                        PlayStoreDeferredComponentManager.this.sessionIdToLoadingUnitId.delete(sessionId);
                        PlayStoreDeferredComponentManager.this.sessionIdToState.put(sessionId, (Object)"cancelled");
                        break;
                    }
                    case 9: {
                        Log.d(PlayStoreDeferredComponentManager.TAG, String.format("Module \"%s\" (sessionId %d) install canceling.", PlayStoreDeferredComponentManager.this.sessionIdToName.get(sessionId), sessionId));
                        PlayStoreDeferredComponentManager.this.sessionIdToState.put(sessionId, (Object)"canceling");
                        break;
                    }
                    case 1: {
                        Log.d(PlayStoreDeferredComponentManager.TAG, String.format("Module \"%s\" (sessionId %d) install pending.", PlayStoreDeferredComponentManager.this.sessionIdToName.get(sessionId), sessionId));
                        PlayStoreDeferredComponentManager.this.sessionIdToState.put(sessionId, (Object)"pending");
                        break;
                    }
                    case 8: {
                        Log.d(PlayStoreDeferredComponentManager.TAG, String.format("Module \"%s\" (sessionId %d) install requires user confirmation.", PlayStoreDeferredComponentManager.this.sessionIdToName.get(sessionId), sessionId));
                        PlayStoreDeferredComponentManager.this.sessionIdToState.put(sessionId, (Object)"requiresUserConfirmation");
                        break;
                    }
                    case 2: {
                        Log.d(PlayStoreDeferredComponentManager.TAG, String.format("Module \"%s\" (sessionId %d) downloading.", PlayStoreDeferredComponentManager.this.sessionIdToName.get(sessionId), sessionId));
                        PlayStoreDeferredComponentManager.this.sessionIdToState.put(sessionId, (Object)"downloading");
                        break;
                    }
                    case 3: {
                        Log.d(PlayStoreDeferredComponentManager.TAG, String.format("Module \"%s\" (sessionId %d) downloaded.", PlayStoreDeferredComponentManager.this.sessionIdToName.get(sessionId), sessionId));
                        PlayStoreDeferredComponentManager.this.sessionIdToState.put(sessionId, (Object)"downloaded");
                        break;
                    }
                    case 4: {
                        Log.d(PlayStoreDeferredComponentManager.TAG, String.format("Module \"%s\" (sessionId %d) installing.", PlayStoreDeferredComponentManager.this.sessionIdToName.get(sessionId), sessionId));
                        PlayStoreDeferredComponentManager.this.sessionIdToState.put(sessionId, (Object)"installing");
                        break;
                    }
                    default: {
                        Log.d(PlayStoreDeferredComponentManager.TAG, "Unknown status: " + state.status());
                    }
                }
            }
        }
    }
}

