/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.common;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONUtil {
    private JSONUtil() {
    }

    public static Object unwrap(Object o) {
        if (JSONObject.NULL.equals(o) || o == null) {
            return null;
        }
        if (o instanceof Boolean || o instanceof Byte || o instanceof Character || o instanceof Double || o instanceof Float || o instanceof Integer || o instanceof Long || o instanceof Short || o instanceof String) {
            return o;
        }
        try {
            if (o instanceof JSONArray) {
                ArrayList<Object> list = new ArrayList<Object>();
                JSONArray array = (JSONArray)o;
                for (int i = 0; i < array.length(); ++i) {
                    list.add(JSONUtil.unwrap(array.get(i)));
                }
                return list;
            }
            if (o instanceof JSONObject) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                JSONObject jsonObject = (JSONObject)o;
                Iterator keyIterator = jsonObject.keys();
                while (keyIterator.hasNext()) {
                    String key = (String)keyIterator.next();
                    map.put(key, JSONUtil.unwrap(jsonObject.get(key)));
                }
                return map;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Object wrap(Object o) {
        if (o == null) {
            return JSONObject.NULL;
        }
        if (o instanceof JSONArray || o instanceof JSONObject) {
            return o;
        }
        if (o.equals(JSONObject.NULL)) {
            return o;
        }
        try {
            if (o instanceof Collection) {
                JSONArray result = new JSONArray();
                for (Object e : (Collection)o) {
                    result.put(JSONUtil.wrap(e));
                }
                return result;
            }
            if (o.getClass().isArray()) {
                JSONArray result = new JSONArray();
                int length = Array.getLength(o);
                for (int i = 0; i < length; ++i) {
                    result.put(JSONUtil.wrap(Array.get(o, i)));
                }
                return result;
            }
            if (o instanceof Map) {
                JSONObject result = new JSONObject();
                for (Map.Entry entry : ((Map)o).entrySet()) {
                    result.put((String)entry.getKey(), JSONUtil.wrap(entry.getValue()));
                }
                return result;
            }
            if (o instanceof Boolean || o instanceof Byte || o instanceof Character || o instanceof Double || o instanceof Float || o instanceof Integer || o instanceof Long || o instanceof Short || o instanceof String) {
                return o;
            }
            if (o.getClass().getPackage().getName().startsWith("java.")) {
                return o.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

