/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import android.os.Build;
import android.view.InputDevice;
import android.view.KeyEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.Log;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.JSONMessageCodec;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class KeyEventChannel {
    private static final String TAG = "KeyEventChannel";
    @NonNull
    public final BasicMessageChannel<Object> channel;

    public KeyEventChannel(@NonNull BinaryMessenger binaryMessenger) {
        this.channel = new BasicMessageChannel<Object>(binaryMessenger, "flutter/keyevent", JSONMessageCodec.INSTANCE);
    }

    public void sendFlutterKeyEvent(@NonNull FlutterKeyEvent keyEvent, boolean isKeyUp, @NonNull EventResponseHandler responseHandler) {
        this.channel.send(this.encodeKeyEvent(keyEvent, isKeyUp), KeyEventChannel.createReplyHandler(responseHandler));
    }

    private Map<String, Object> encodeKeyEvent(@NonNull FlutterKeyEvent keyEvent, boolean isKeyUp) {
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("type", isKeyUp ? "keyup" : "keydown");
        message.put("keymap", "android");
        message.put("flags", keyEvent.event.getFlags());
        message.put("plainCodePoint", keyEvent.event.getUnicodeChar(0));
        message.put("codePoint", keyEvent.event.getUnicodeChar());
        message.put("keyCode", keyEvent.event.getKeyCode());
        message.put("scanCode", keyEvent.event.getScanCode());
        message.put("metaState", keyEvent.event.getMetaState());
        if (keyEvent.complexCharacter != null) {
            message.put("character", keyEvent.complexCharacter.toString());
        }
        message.put("source", keyEvent.event.getSource());
        InputDevice device = InputDevice.getDevice((int)keyEvent.event.getDeviceId());
        int vendorId = 0;
        int productId = 0;
        if (device != null && Build.VERSION.SDK_INT >= 19) {
            vendorId = device.getVendorId();
            productId = device.getProductId();
        }
        message.put("vendorId", vendorId);
        message.put("productId", productId);
        message.put("deviceId", keyEvent.event.getDeviceId());
        message.put("repeatCount", keyEvent.event.getRepeatCount());
        return message;
    }

    private static BasicMessageChannel.Reply<Object> createReplyHandler(@NonNull EventResponseHandler responseHandler) {
        return message -> {
            boolean isEventHandled = false;
            try {
                if (message != null) {
                    JSONObject annotatedEvent = (JSONObject)message;
                    isEventHandled = annotatedEvent.getBoolean("handled");
                }
            }
            catch (JSONException e) {
                Log.e(TAG, "Unable to unpack JSON message: " + (Object)((Object)e));
            }
            responseHandler.onFrameworkResponse(isEventHandled);
        };
    }

    public static class FlutterKeyEvent {
        public final KeyEvent event;
        @Nullable
        public final Character complexCharacter;

        public FlutterKeyEvent(@NonNull KeyEvent androidKeyEvent) {
            this(androidKeyEvent, null);
        }

        public FlutterKeyEvent(@NonNull KeyEvent androidKeyEvent, @Nullable Character complexCharacter) {
            this.event = androidKeyEvent;
            this.complexCharacter = complexCharacter;
        }
    }

    public static interface EventResponseHandler {
        public void onFrameworkResponse(boolean var1);
    }
}

