/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.platform;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import io.flutter.Log;
import io.flutter.embedding.android.AndroidTouchProcessor;
import io.flutter.embedding.android.FlutterImageView;
import io.flutter.embedding.android.FlutterView;
import io.flutter.embedding.android.MotionEventTracker;
import io.flutter.embedding.engine.FlutterOverlaySurface;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.embedding.engine.mutatorsstack.FlutterMutatorView;
import io.flutter.embedding.engine.mutatorsstack.FlutterMutatorsStack;
import io.flutter.embedding.engine.renderer.FlutterRenderer;
import io.flutter.embedding.engine.systemchannels.PlatformViewsChannel;
import io.flutter.plugin.editing.TextInputPlugin;
import io.flutter.plugin.platform.AccessibilityEventsDelegate;
import io.flutter.plugin.platform.PlatformView;
import io.flutter.plugin.platform.PlatformViewFactory;
import io.flutter.plugin.platform.PlatformViewRegistry;
import io.flutter.plugin.platform.PlatformViewRegistryImpl;
import io.flutter.plugin.platform.PlatformViewsAccessibilityDelegate;
import io.flutter.plugin.platform.VirtualDisplayController;
import io.flutter.view.AccessibilityBridge;
import io.flutter.view.TextureRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class PlatformViewsController
implements PlatformViewsAccessibilityDelegate {
    private static final String TAG = "PlatformViewsController";
    private final PlatformViewRegistryImpl registry;
    private AndroidTouchProcessor androidTouchProcessor;
    private Context context;
    private View flutterView;
    private TextureRegistry textureRegistry;
    private TextInputPlugin textInputPlugin;
    private PlatformViewsChannel platformViewsChannel;
    private final AccessibilityEventsDelegate accessibilityEventsDelegate;
    @VisibleForTesting
    final HashMap<Integer, VirtualDisplayController> vdControllers;
    private final HashMap<Context, View> contextToPlatformView;
    private final SparseArray<PlatformView> platformViews;
    private final SparseArray<FlutterMutatorView> platformViewParent;
    private final SparseArray<FlutterImageView> overlayLayerViews;
    private int nextOverlayLayerId = 0;
    private boolean flutterViewConvertedToImageView = false;
    private boolean synchronizeToNativeViewHierarchy = true;
    private HashSet<Integer> currentFrameUsedOverlayLayerIds;
    private HashSet<Integer> currentFrameUsedPlatformViewIds;
    private final MotionEventTracker motionEventTracker;
    private final PlatformViewsChannel.PlatformViewsHandler channelHandler = new PlatformViewsChannel.PlatformViewsHandler(){

        @Override
        public void createAndroidViewForPlatformView(@NonNull PlatformViewsChannel.PlatformViewCreationRequest request) {
            this.ensureValidAndroidVersion(19);
            if (!PlatformViewsController.validateDirection(request.direction)) {
                throw new IllegalStateException("Trying to create a view with unknown direction value: " + request.direction + "(view id: " + request.viewId + ")");
            }
            PlatformViewFactory factory = PlatformViewsController.this.registry.getFactory(request.viewType);
            if (factory == null) {
                throw new IllegalStateException("Trying to create a platform view of unregistered type: " + request.viewType);
            }
            Object createParams = null;
            if (request.params != null) {
                createParams = factory.getCreateArgsCodec().decodeMessage(request.params);
            }
            PlatformView platformView = factory.create(PlatformViewsController.this.context, request.viewId, createParams);
            PlatformViewsController.this.platformViews.put(request.viewId, (Object)platformView);
        }

        @Override
        public void disposeAndroidViewForPlatformView(int viewId) {
            PlatformView platformView = (PlatformView)PlatformViewsController.this.platformViews.get(viewId);
            FlutterMutatorView parentView = (FlutterMutatorView)((Object)PlatformViewsController.this.platformViewParent.get(viewId));
            if (platformView != null) {
                if (parentView != null) {
                    parentView.removeView(platformView.getView());
                }
                PlatformViewsController.this.platformViews.remove(viewId);
                platformView.dispose();
            }
            if (parentView != null) {
                ((ViewGroup)parentView.getParent()).removeView((View)parentView);
                PlatformViewsController.this.platformViewParent.remove(viewId);
            }
        }

        @Override
        @TargetApi(value=17)
        public long createVirtualDisplayForPlatformView(@NonNull PlatformViewsChannel.PlatformViewCreationRequest request) {
            this.ensureValidAndroidVersion(20);
            if (!PlatformViewsController.validateDirection(request.direction)) {
                throw new IllegalStateException("Trying to create a view with unknown direction value: " + request.direction + "(view id: " + request.viewId + ")");
            }
            if (PlatformViewsController.this.vdControllers.containsKey(request.viewId)) {
                throw new IllegalStateException("Trying to create an already created platform view, view id: " + request.viewId);
            }
            PlatformViewFactory viewFactory = PlatformViewsController.this.registry.getFactory(request.viewType);
            if (viewFactory == null) {
                throw new IllegalStateException("Trying to create a platform view of unregistered type: " + request.viewType);
            }
            Object createParams = null;
            if (request.params != null) {
                createParams = viewFactory.getCreateArgsCodec().decodeMessage(request.params);
            }
            int physicalWidth = PlatformViewsController.this.toPhysicalPixels(request.logicalWidth);
            int physicalHeight = PlatformViewsController.this.toPhysicalPixels(request.logicalHeight);
            PlatformViewsController.this.validateVirtualDisplayDimensions(physicalWidth, physicalHeight);
            TextureRegistry.SurfaceTextureEntry textureEntry = PlatformViewsController.this.textureRegistry.createSurfaceTexture();
            VirtualDisplayController vdController = VirtualDisplayController.create(PlatformViewsController.this.context, PlatformViewsController.this.accessibilityEventsDelegate, viewFactory, textureEntry, physicalWidth, physicalHeight, request.viewId, createParams, (view, hasFocus) -> {
                if (hasFocus) {
                    PlatformViewsController.this.platformViewsChannel.invokeViewFocused(request.viewId);
                }
            });
            if (vdController == null) {
                throw new IllegalStateException("Failed creating virtual display for a " + request.viewType + " with id: " + request.viewId);
            }
            if (PlatformViewsController.this.flutterView != null) {
                vdController.onFlutterViewAttached(PlatformViewsController.this.flutterView);
            }
            PlatformViewsController.this.vdControllers.put(request.viewId, vdController);
            View platformView = vdController.getView();
            platformView.setLayoutDirection(request.direction);
            PlatformViewsController.this.contextToPlatformView.put(platformView.getContext(), platformView);
            return textureEntry.id();
        }

        @Override
        public void disposeVirtualDisplayForPlatformView(int viewId) {
            this.ensureValidAndroidVersion(20);
            VirtualDisplayController vdController = PlatformViewsController.this.vdControllers.get(viewId);
            if (vdController == null) {
                throw new IllegalStateException("Trying to dispose a platform view with unknown id: " + viewId);
            }
            if (PlatformViewsController.this.textInputPlugin != null) {
                PlatformViewsController.this.textInputPlugin.clearPlatformViewClient(viewId);
            }
            PlatformViewsController.this.contextToPlatformView.remove(vdController.getView().getContext());
            vdController.dispose();
            PlatformViewsController.this.vdControllers.remove(viewId);
        }

        @Override
        public void resizePlatformView(@NonNull PlatformViewsChannel.PlatformViewResizeRequest request, final @NonNull Runnable onComplete) {
            this.ensureValidAndroidVersion(20);
            final VirtualDisplayController vdController = PlatformViewsController.this.vdControllers.get(request.viewId);
            if (vdController == null) {
                throw new IllegalStateException("Trying to resize a platform view with unknown id: " + request.viewId);
            }
            int physicalWidth = PlatformViewsController.this.toPhysicalPixels(request.newLogicalWidth);
            int physicalHeight = PlatformViewsController.this.toPhysicalPixels(request.newLogicalHeight);
            PlatformViewsController.this.validateVirtualDisplayDimensions(physicalWidth, physicalHeight);
            PlatformViewsController.this.lockInputConnection(vdController);
            vdController.resize(physicalWidth, physicalHeight, new Runnable(){

                @Override
                public void run() {
                    PlatformViewsController.this.unlockInputConnection(vdController);
                    onComplete.run();
                }
            });
        }

        @Override
        public void onTouch(@NonNull PlatformViewsChannel.PlatformViewTouch touch) {
            int viewId = touch.viewId;
            float density = ((PlatformViewsController)PlatformViewsController.this).context.getResources().getDisplayMetrics().density;
            this.ensureValidAndroidVersion(20);
            if (PlatformViewsController.this.vdControllers.containsKey(viewId)) {
                MotionEvent event = PlatformViewsController.this.toMotionEvent(density, touch, true);
                PlatformViewsController.this.vdControllers.get(touch.viewId).dispatchTouchEvent(event);
            } else if (PlatformViewsController.this.platformViews.get(viewId) != null) {
                MotionEvent event = PlatformViewsController.this.toMotionEvent(density, touch, false);
                View view = ((PlatformView)PlatformViewsController.this.platformViews.get(touch.viewId)).getView();
                if (view != null) {
                    view.dispatchTouchEvent(event);
                }
            } else {
                throw new IllegalStateException("Sending touch to an unknown view with id: " + viewId);
            }
        }

        @Override
        @TargetApi(value=17)
        public void setDirection(int viewId, int direction) {
            if (!PlatformViewsController.validateDirection(direction)) {
                throw new IllegalStateException("Trying to set unknown direction value: " + direction + "(view id: " + viewId + ")");
            }
            this.ensureValidAndroidVersion(20);
            View view = PlatformViewsController.this.vdControllers.get(viewId).getView();
            if (view == null) {
                throw new IllegalStateException("Sending touch to an unknown view with id: " + direction);
            }
            view.setLayoutDirection(direction);
        }

        @Override
        public void clearFocus(int viewId) {
            PlatformView platformView = (PlatformView)PlatformViewsController.this.platformViews.get(viewId);
            if (platformView != null) {
                platformView.getView().clearFocus();
                return;
            }
            this.ensureValidAndroidVersion(20);
            View view = PlatformViewsController.this.vdControllers.get(viewId).getView();
            view.clearFocus();
        }

        private void ensureValidAndroidVersion(int minSdkVersion) {
            if (Build.VERSION.SDK_INT < minSdkVersion) {
                throw new IllegalStateException("Trying to use platform views with API " + Build.VERSION.SDK_INT + ", required API level is: " + minSdkVersion);
            }
        }

        @Override
        public void synchronizeToNativeViewHierarchy(boolean yes) {
            PlatformViewsController.this.synchronizeToNativeViewHierarchy = yes;
        }
    };

    @VisibleForTesting
    public MotionEvent toMotionEvent(float density, PlatformViewsChannel.PlatformViewTouch touch, boolean usingVirtualDiplays) {
        MotionEventTracker.MotionEventId motionEventId = MotionEventTracker.MotionEventId.from(touch.motionEventId);
        MotionEvent trackedEvent = this.motionEventTracker.pop(motionEventId);
        MotionEvent.PointerProperties[] pointerProperties = PlatformViewsController.parsePointerPropertiesList(touch.rawPointerPropertiesList).toArray(new MotionEvent.PointerProperties[touch.pointerCount]);
        MotionEvent.PointerCoords[] pointerCoords = PlatformViewsController.parsePointerCoordsList(touch.rawPointerCoords, density).toArray(new MotionEvent.PointerCoords[touch.pointerCount]);
        if (!usingVirtualDiplays && trackedEvent != null) {
            return MotionEvent.obtain((long)trackedEvent.getDownTime(), (long)trackedEvent.getEventTime(), (int)trackedEvent.getAction(), (int)touch.pointerCount, (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])pointerCoords, (int)trackedEvent.getMetaState(), (int)trackedEvent.getButtonState(), (float)trackedEvent.getXPrecision(), (float)trackedEvent.getYPrecision(), (int)trackedEvent.getDeviceId(), (int)trackedEvent.getEdgeFlags(), (int)trackedEvent.getSource(), (int)trackedEvent.getFlags());
        }
        return MotionEvent.obtain((long)touch.downTime.longValue(), (long)touch.eventTime.longValue(), (int)touch.action, (int)touch.pointerCount, (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])pointerCoords, (int)touch.metaState, (int)touch.buttonState, (float)touch.xPrecision, (float)touch.yPrecision, (int)touch.deviceId, (int)touch.edgeFlags, (int)touch.source, (int)touch.flags);
    }

    public PlatformViewsController() {
        this.registry = new PlatformViewRegistryImpl();
        this.vdControllers = new HashMap();
        this.accessibilityEventsDelegate = new AccessibilityEventsDelegate();
        this.contextToPlatformView = new HashMap();
        this.overlayLayerViews = new SparseArray();
        this.currentFrameUsedOverlayLayerIds = new HashSet();
        this.currentFrameUsedPlatformViewIds = new HashSet();
        this.platformViews = new SparseArray();
        this.platformViewParent = new SparseArray();
        this.motionEventTracker = MotionEventTracker.getInstance();
    }

    public void attach(Context context, TextureRegistry textureRegistry, @NonNull DartExecutor dartExecutor) {
        if (this.context != null) {
            throw new AssertionError((Object)"A PlatformViewsController can only be attached to a single output target.\nattach was called while the PlatformViewsController was already attached.");
        }
        this.context = context;
        this.textureRegistry = textureRegistry;
        this.platformViewsChannel = new PlatformViewsChannel(dartExecutor);
        this.platformViewsChannel.setPlatformViewsHandler(this.channelHandler);
    }

    @UiThread
    public void detach() {
        if (this.platformViewsChannel != null) {
            this.platformViewsChannel.setPlatformViewsHandler(null);
        }
        this.destroyOverlaySurfaces();
        this.platformViewsChannel = null;
        this.context = null;
        this.textureRegistry = null;
    }

    public void attachToView(@NonNull View flutterView) {
        this.flutterView = flutterView;
        for (VirtualDisplayController controller : this.vdControllers.values()) {
            controller.onFlutterViewAttached(flutterView);
        }
    }

    public void detachFromView() {
        this.destroyOverlaySurfaces();
        this.flutterView = null;
        for (VirtualDisplayController controller : this.vdControllers.values()) {
            controller.onFlutterViewDetached();
        }
    }

    @Override
    public void attachAccessibilityBridge(AccessibilityBridge accessibilityBridge) {
        this.accessibilityEventsDelegate.setAccessibilityBridge(accessibilityBridge);
    }

    @Override
    public void detachAccessibiltyBridge() {
        this.accessibilityEventsDelegate.setAccessibilityBridge(null);
    }

    public void attachTextInputPlugin(TextInputPlugin textInputPlugin) {
        this.textInputPlugin = textInputPlugin;
    }

    public void detachTextInputPlugin() {
        this.textInputPlugin = null;
    }

    public boolean checkInputConnectionProxy(@Nullable View view) {
        if (view == null) {
            return false;
        }
        if (!this.contextToPlatformView.containsKey(view.getContext())) {
            return false;
        }
        View platformView = this.contextToPlatformView.get(view.getContext());
        if (platformView == view) {
            return true;
        }
        return platformView.checkInputConnectionProxy(view);
    }

    public PlatformViewRegistry getRegistry() {
        return this.registry;
    }

    public void onAttachedToJNI() {
    }

    public void onDetachedFromJNI() {
        this.flushAllViews();
    }

    public void onPreEngineRestart() {
        this.flushAllViews();
    }

    @Override
    public View getPlatformViewById(Integer id) {
        if (this.platformViews.get(id.intValue()) != null) {
            return ((PlatformView)this.platformViews.get(id.intValue())).getView();
        }
        VirtualDisplayController controller = this.vdControllers.get(id);
        if (controller == null) {
            return null;
        }
        return controller.getView();
    }

    @Override
    public boolean usesVirtualDisplay(Integer id) {
        return this.vdControllers.containsKey(id);
    }

    private void lockInputConnection(@NonNull VirtualDisplayController controller) {
        if (this.textInputPlugin == null) {
            return;
        }
        this.textInputPlugin.lockPlatformViewInputConnection();
        controller.onInputConnectionLocked();
    }

    private void unlockInputConnection(@NonNull VirtualDisplayController controller) {
        if (this.textInputPlugin == null) {
            return;
        }
        this.textInputPlugin.unlockPlatformViewInputConnection();
        controller.onInputConnectionUnlocked();
    }

    private static boolean validateDirection(int direction) {
        return direction == 0 || direction == 1;
    }

    private static List<MotionEvent.PointerProperties> parsePointerPropertiesList(Object rawPropertiesList) {
        List rawProperties = (List)rawPropertiesList;
        ArrayList<MotionEvent.PointerProperties> pointerProperties = new ArrayList<MotionEvent.PointerProperties>();
        for (Object o : rawProperties) {
            pointerProperties.add(PlatformViewsController.parsePointerProperties(o));
        }
        return pointerProperties;
    }

    private static MotionEvent.PointerProperties parsePointerProperties(Object rawProperties) {
        List propertiesList = (List)rawProperties;
        MotionEvent.PointerProperties properties = new MotionEvent.PointerProperties();
        properties.id = (Integer)propertiesList.get(0);
        properties.toolType = (Integer)propertiesList.get(1);
        return properties;
    }

    private static List<MotionEvent.PointerCoords> parsePointerCoordsList(Object rawCoordsList, float density) {
        List rawCoords = (List)rawCoordsList;
        ArrayList<MotionEvent.PointerCoords> pointerCoords = new ArrayList<MotionEvent.PointerCoords>();
        for (Object o : rawCoords) {
            pointerCoords.add(PlatformViewsController.parsePointerCoords(o, density));
        }
        return pointerCoords;
    }

    private static MotionEvent.PointerCoords parsePointerCoords(Object rawCoords, float density) {
        List coordsList = (List)rawCoords;
        MotionEvent.PointerCoords coords = new MotionEvent.PointerCoords();
        coords.orientation = (float)((Double)coordsList.get(0)).doubleValue();
        coords.pressure = (float)((Double)coordsList.get(1)).doubleValue();
        coords.size = (float)((Double)coordsList.get(2)).doubleValue();
        coords.toolMajor = (float)((Double)coordsList.get(3)).doubleValue() * density;
        coords.toolMinor = (float)((Double)coordsList.get(4)).doubleValue() * density;
        coords.touchMajor = (float)((Double)coordsList.get(5)).doubleValue() * density;
        coords.touchMinor = (float)((Double)coordsList.get(6)).doubleValue() * density;
        coords.x = (float)((Double)coordsList.get(7)).doubleValue() * density;
        coords.y = (float)((Double)coordsList.get(8)).doubleValue() * density;
        return coords;
    }

    private void validateVirtualDisplayDimensions(int width, int height) {
        DisplayMetrics metrics = this.context.getResources().getDisplayMetrics();
        if (height > metrics.heightPixels || width > metrics.widthPixels) {
            String message = "Creating a virtual display of size: [" + width + ", " + height + "] may result in problems(https://github.com/flutter/flutter/issues/2897).It is larger than the device screen size: [" + metrics.widthPixels + ", " + metrics.heightPixels + "].";
            Log.w(TAG, message);
        }
    }

    private float getDisplayDensity() {
        return this.context.getResources().getDisplayMetrics().density;
    }

    private int toPhysicalPixels(double logicalPixels) {
        return (int)Math.round(logicalPixels * (double)this.getDisplayDensity());
    }

    private void flushAllViews() {
        for (VirtualDisplayController controller : this.vdControllers.values()) {
            controller.dispose();
        }
        this.vdControllers.clear();
        while (this.platformViews.size() > 0) {
            this.channelHandler.disposeAndroidViewForPlatformView(this.platformViews.keyAt(0));
        }
    }

    private void initializeRootImageViewIfNeeded() {
        if (this.synchronizeToNativeViewHierarchy && !this.flutterViewConvertedToImageView) {
            ((FlutterView)this.flutterView).convertToImageView();
            this.flutterViewConvertedToImageView = true;
        }
    }

    @VisibleForTesting
    void initializePlatformViewIfNeeded(int viewId) {
        PlatformView platformView = (PlatformView)this.platformViews.get(viewId);
        if (platformView == null) {
            throw new IllegalStateException("Platform view hasn't been initialized from the platform view channel.");
        }
        if (this.platformViewParent.get(viewId) != null) {
            return;
        }
        if (platformView.getView() == null) {
            throw new IllegalStateException("PlatformView#getView() returned null, but an Android view reference was expected.");
        }
        if (platformView.getView().getParent() != null) {
            throw new IllegalStateException("The Android view returned from PlatformView#getView() was already added to a parent view.");
        }
        FlutterMutatorView parentView = new FlutterMutatorView(this.context, this.context.getResources().getDisplayMetrics().density, this.androidTouchProcessor);
        parentView.addOnFocusChangeListener((view, hasFocus) -> {
            if (hasFocus) {
                this.platformViewsChannel.invokeViewFocused(viewId);
            } else {
                this.textInputPlugin.clearPlatformViewClient(viewId);
            }
        });
        this.platformViewParent.put(viewId, (Object)parentView);
        parentView.addView(platformView.getView());
        ((FlutterView)this.flutterView).addView((View)parentView);
    }

    public void attachToFlutterRenderer(FlutterRenderer flutterRenderer) {
        this.androidTouchProcessor = new AndroidTouchProcessor(flutterRenderer, true);
    }

    public void onDisplayPlatformView(int viewId, int x, int y, int width, int height, int viewWidth, int viewHeight, FlutterMutatorsStack mutatorsStack) {
        this.initializeRootImageViewIfNeeded();
        this.initializePlatformViewIfNeeded(viewId);
        FlutterMutatorView parentView = (FlutterMutatorView)((Object)this.platformViewParent.get(viewId));
        parentView.readyToDisplay(mutatorsStack, x, y, width, height);
        parentView.setVisibility(0);
        parentView.bringToFront();
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(viewWidth, viewHeight);
        View view = ((PlatformView)this.platformViews.get(viewId)).getView();
        if (view != null) {
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            view.bringToFront();
        }
        this.currentFrameUsedPlatformViewIds.add(viewId);
    }

    public void onDisplayOverlaySurface(int id, int x, int y, int width, int height) {
        if (this.overlayLayerViews.get(id) == null) {
            throw new IllegalStateException("The overlay surface (id:" + id + ") doesn't exist");
        }
        this.initializeRootImageViewIfNeeded();
        FlutterImageView overlayView = (FlutterImageView)this.overlayLayerViews.get(id);
        if (overlayView.getParent() == null) {
            ((FlutterView)this.flutterView).addView(overlayView);
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(width, height);
        layoutParams.leftMargin = x;
        layoutParams.topMargin = y;
        overlayView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        overlayView.setVisibility(0);
        overlayView.bringToFront();
        this.currentFrameUsedOverlayLayerIds.add(id);
    }

    public void onBeginFrame() {
        this.currentFrameUsedOverlayLayerIds.clear();
        this.currentFrameUsedPlatformViewIds.clear();
    }

    public void onEndFrame() {
        FlutterView view = (FlutterView)this.flutterView;
        if (this.flutterViewConvertedToImageView && this.currentFrameUsedPlatformViewIds.isEmpty()) {
            this.flutterViewConvertedToImageView = false;
            view.revertImageView(() -> this.finishFrame(false));
            return;
        }
        boolean isFrameRenderedUsingImageReaders = this.flutterViewConvertedToImageView && view.acquireLatestImageViewFrame();
        this.finishFrame(isFrameRenderedUsingImageReaders);
    }

    private void finishFrame(boolean isFrameRenderedUsingImageReaders) {
        int i;
        for (i = 0; i < this.overlayLayerViews.size(); ++i) {
            int overlayId = this.overlayLayerViews.keyAt(i);
            FlutterImageView overlayView = (FlutterImageView)this.overlayLayerViews.valueAt(i);
            if (this.currentFrameUsedOverlayLayerIds.contains(overlayId)) {
                ((FlutterView)this.flutterView).attachOverlaySurfaceToRender(overlayView);
                boolean didAcquireOverlaySurfaceImage = overlayView.acquireLatestImage();
                isFrameRenderedUsingImageReaders &= didAcquireOverlaySurfaceImage;
                continue;
            }
            if (!this.flutterViewConvertedToImageView) {
                overlayView.detachFromRenderer();
            }
            overlayView.setVisibility(8);
        }
        for (i = 0; i < this.platformViewParent.size(); ++i) {
            int viewId = this.platformViewParent.keyAt(i);
            View parentView = (View)this.platformViewParent.get(viewId);
            if (this.currentFrameUsedPlatformViewIds.contains(viewId) && (isFrameRenderedUsingImageReaders || !this.synchronizeToNativeViewHierarchy)) {
                parentView.setVisibility(0);
                continue;
            }
            parentView.setVisibility(8);
        }
    }

    @VisibleForTesting
    @TargetApi(value=19)
    public FlutterOverlaySurface createOverlaySurface(@NonNull FlutterImageView imageView) {
        int id = this.nextOverlayLayerId++;
        this.overlayLayerViews.put(id, (Object)imageView);
        return new FlutterOverlaySurface(id, imageView.getSurface());
    }

    @TargetApi(value=19)
    public FlutterOverlaySurface createOverlaySurface() {
        return this.createOverlaySurface(new FlutterImageView(this.flutterView.getContext(), this.flutterView.getWidth(), this.flutterView.getHeight(), FlutterImageView.SurfaceKind.overlay));
    }

    public void destroyOverlaySurfaces() {
        for (int i = 0; i < this.overlayLayerViews.size(); ++i) {
            int overlayId = this.overlayLayerViews.keyAt(i);
            FlutterImageView overlayView = (FlutterImageView)this.overlayLayerViews.valueAt(i);
            overlayView.detachFromRenderer();
            if (this.flutterView == null) continue;
            ((FlutterView)this.flutterView).removeView(overlayView);
        }
        this.overlayLayerViews.clear();
    }
}

