/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Looper;
import android.view.Surface;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import io.flutter.Log;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.FlutterOverlaySurface;
import io.flutter.embedding.engine.dart.PlatformMessageHandler;
import io.flutter.embedding.engine.deferredcomponents.DeferredComponentManager;
import io.flutter.embedding.engine.mutatorsstack.FlutterMutatorsStack;
import io.flutter.embedding.engine.renderer.FlutterUiDisplayListener;
import io.flutter.embedding.engine.renderer.SurfaceTextureWrapper;
import io.flutter.plugin.common.StandardMessageCodec;
import io.flutter.plugin.localization.LocalizationPlugin;
import io.flutter.plugin.platform.PlatformViewsController;
import io.flutter.util.Preconditions;
import io.flutter.view.AccessibilityBridge;
import io.flutter.view.FlutterCallbackInformation;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

@Keep
public class FlutterJNI {
    private static final String TAG = "FlutterJNI";
    private static boolean loadLibraryCalled = false;
    private static boolean prefetchDefaultFontManagerCalled = false;
    private static boolean initCalled = false;
    @Nullable
    private static AsyncWaitForVsyncDelegate asyncWaitForVsyncDelegate;
    private static float refreshRateFPS;
    @Nullable
    private static String observatoryUri;
    private static boolean setRefreshRateFPSCalled;
    @Nullable
    private Long nativeShellHolderId;
    @Nullable
    private AccessibilityDelegate accessibilityDelegate;
    @Nullable
    private PlatformMessageHandler platformMessageHandler;
    @Nullable
    private LocalizationPlugin localizationPlugin;
    @Nullable
    private PlatformViewsController platformViewsController;
    @Nullable
    private DeferredComponentManager deferredComponentManager;
    @NonNull
    private final Set<FlutterEngine.EngineLifecycleListener> engineLifecycleListeners = new CopyOnWriteArraySet<FlutterEngine.EngineLifecycleListener>();
    @NonNull
    private final Set<FlutterUiDisplayListener> flutterUiDisplayListeners = new CopyOnWriteArraySet<FlutterUiDisplayListener>();
    @NonNull
    private final Looper mainLooper = Looper.getMainLooper();

    public void loadLibrary() {
        if (loadLibraryCalled) {
            Log.w(TAG, "FlutterJNI.loadLibrary called more than once");
        }
        System.loadLibrary("flutter");
        loadLibraryCalled = true;
    }

    public void prefetchDefaultFontManager() {
        if (prefetchDefaultFontManagerCalled) {
            Log.w(TAG, "FlutterJNI.prefetchDefaultFontManager called more than once");
        }
        FlutterJNI.nativePrefetchDefaultFontManager();
        prefetchDefaultFontManagerCalled = true;
    }

    public void init(@NonNull Context context, @NonNull String[] args, @Nullable String bundlePath, @NonNull String appStoragePath, @NonNull String engineCachesPath, long initTimeMillis) {
        if (initCalled) {
            Log.w(TAG, "FlutterJNI.init called more than once");
        }
        FlutterJNI.nativeInit(context, args, bundlePath, appStoragePath, engineCachesPath, initTimeMillis);
        initCalled = true;
    }

    @Deprecated
    public static native void nativeInit(@NonNull Context var0, @NonNull String[] var1, @Nullable String var2, @NonNull String var3, @NonNull String var4, long var5);

    @Deprecated
    public static native void nativePrefetchDefaultFontManager();

    private native boolean nativeGetIsSoftwareRenderingEnabled();

    @UiThread
    public boolean getIsSoftwareRenderingEnabled() {
        return this.nativeGetIsSoftwareRenderingEnabled();
    }

    @Nullable
    public static String getObservatoryUri() {
        return observatoryUri;
    }

    public static void setRefreshRateFPS(float refreshRateFPS) {
        if (setRefreshRateFPSCalled) {
            Log.w(TAG, "FlutterJNI.setRefreshRateFPS called more than once");
        }
        FlutterJNI.refreshRateFPS = refreshRateFPS;
        setRefreshRateFPSCalled = true;
    }

    public static void setAsyncWaitForVsyncDelegate(@Nullable AsyncWaitForVsyncDelegate delegate) {
        asyncWaitForVsyncDelegate = delegate;
    }

    private static void asyncWaitForVsync(long cookie) {
        if (asyncWaitForVsyncDelegate == null) {
            throw new IllegalStateException("An AsyncWaitForVsyncDelegate must be registered with FlutterJNI before asyncWaitForVsync() is invoked.");
        }
        asyncWaitForVsyncDelegate.asyncWaitForVsync(cookie);
    }

    public static native void nativeOnVsync(long var0, long var2, long var4);

    @NonNull
    public static native FlutterCallbackInformation nativeLookupCallbackInformation(long var0);

    public native boolean nativeFlutterTextUtilsIsEmoji(int var1);

    public native boolean nativeFlutterTextUtilsIsEmojiModifier(int var1);

    public native boolean nativeFlutterTextUtilsIsEmojiModifierBase(int var1);

    public native boolean nativeFlutterTextUtilsIsVariationSelector(int var1);

    public native boolean nativeFlutterTextUtilsIsRegionalIndicator(int var1);

    public boolean isAttached() {
        return this.nativeShellHolderId != null;
    }

    @UiThread
    public void attachToNative(boolean isBackgroundView) {
        this.ensureRunningOnMainThread();
        this.ensureNotAttachedToNative();
        this.nativeShellHolderId = this.performNativeAttach(this, isBackgroundView);
    }

    @VisibleForTesting
    public long performNativeAttach(@NonNull FlutterJNI flutterJNI, boolean isBackgroundView) {
        return this.nativeAttach(flutterJNI, isBackgroundView);
    }

    private native long nativeAttach(@NonNull FlutterJNI var1, boolean var2);

    @UiThread
    @NonNull
    public FlutterJNI spawn(@Nullable String entrypointFunctionName, @Nullable String pathToEntrypointFunction) {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        FlutterJNI spawnedJNI = this.nativeSpawn(this.nativeShellHolderId, entrypointFunctionName, pathToEntrypointFunction);
        Preconditions.checkState(spawnedJNI.nativeShellHolderId != null && spawnedJNI.nativeShellHolderId != 0L, "Failed to spawn new JNI connected shell from existing shell.");
        return spawnedJNI;
    }

    private native FlutterJNI nativeSpawn(long var1, @Nullable String var3, @Nullable String var4);

    @UiThread
    public void detachFromNativeAndReleaseResources() {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeDestroy(this.nativeShellHolderId);
        this.nativeShellHolderId = null;
    }

    private native void nativeDestroy(long var1);

    private void ensureNotAttachedToNative() {
        if (this.nativeShellHolderId != null) {
            throw new RuntimeException("Cannot execute operation because FlutterJNI is attached to native.");
        }
    }

    private void ensureAttachedToNative() {
        if (this.nativeShellHolderId == null) {
            throw new RuntimeException("Cannot execute operation because FlutterJNI is not attached to native.");
        }
    }

    @UiThread
    public void addIsDisplayingFlutterUiListener(@NonNull FlutterUiDisplayListener listener) {
        this.ensureRunningOnMainThread();
        this.flutterUiDisplayListeners.add(listener);
    }

    @UiThread
    public void removeIsDisplayingFlutterUiListener(@NonNull FlutterUiDisplayListener listener) {
        this.ensureRunningOnMainThread();
        this.flutterUiDisplayListeners.remove(listener);
    }

    @VisibleForTesting
    @UiThread
    public void onFirstFrame() {
        this.ensureRunningOnMainThread();
        for (FlutterUiDisplayListener listener : this.flutterUiDisplayListeners) {
            listener.onFlutterUiDisplayed();
        }
    }

    @VisibleForTesting
    @UiThread
    void onRenderingStopped() {
        this.ensureRunningOnMainThread();
        for (FlutterUiDisplayListener listener : this.flutterUiDisplayListeners) {
            listener.onFlutterUiNoLongerDisplayed();
        }
    }

    @UiThread
    public void onSurfaceCreated(@NonNull Surface surface) {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeSurfaceCreated(this.nativeShellHolderId, surface);
    }

    private native void nativeSurfaceCreated(long var1, @NonNull Surface var3);

    @UiThread
    public void onSurfaceWindowChanged(@NonNull Surface surface) {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeSurfaceWindowChanged(this.nativeShellHolderId, surface);
    }

    private native void nativeSurfaceWindowChanged(long var1, @NonNull Surface var3);

    @UiThread
    public void onSurfaceChanged(int width, int height) {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeSurfaceChanged(this.nativeShellHolderId, width, height);
    }

    private native void nativeSurfaceChanged(long var1, int var3, int var4);

    @UiThread
    public void onSurfaceDestroyed() {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.onRenderingStopped();
        this.nativeSurfaceDestroyed(this.nativeShellHolderId);
    }

    private native void nativeSurfaceDestroyed(long var1);

    @UiThread
    public void setViewportMetrics(float devicePixelRatio, int physicalWidth, int physicalHeight, int physicalPaddingTop, int physicalPaddingRight, int physicalPaddingBottom, int physicalPaddingLeft, int physicalViewInsetTop, int physicalViewInsetRight, int physicalViewInsetBottom, int physicalViewInsetLeft, int systemGestureInsetTop, int systemGestureInsetRight, int systemGestureInsetBottom, int systemGestureInsetLeft) {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeSetViewportMetrics(this.nativeShellHolderId, devicePixelRatio, physicalWidth, physicalHeight, physicalPaddingTop, physicalPaddingRight, physicalPaddingBottom, physicalPaddingLeft, physicalViewInsetTop, physicalViewInsetRight, physicalViewInsetBottom, physicalViewInsetLeft, systemGestureInsetTop, systemGestureInsetRight, systemGestureInsetBottom, systemGestureInsetLeft);
    }

    private native void nativeSetViewportMetrics(long var1, float var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17);

    @UiThread
    public void dispatchPointerDataPacket(@NonNull ByteBuffer buffer, int position) {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeDispatchPointerDataPacket(this.nativeShellHolderId, buffer, position);
    }

    private native void nativeDispatchPointerDataPacket(long var1, @NonNull ByteBuffer var3, int var4);

    @UiThread
    public void setPlatformViewsController(@NonNull PlatformViewsController platformViewsController) {
        this.ensureRunningOnMainThread();
        this.platformViewsController = platformViewsController;
    }

    @UiThread
    public void setAccessibilityDelegate(@Nullable AccessibilityDelegate accessibilityDelegate) {
        this.ensureRunningOnMainThread();
        this.accessibilityDelegate = accessibilityDelegate;
    }

    @UiThread
    private void updateSemantics(@NonNull ByteBuffer buffer, @NonNull String[] strings, @NonNull ByteBuffer[] stringAttributeArgs) {
        this.ensureRunningOnMainThread();
        if (this.accessibilityDelegate != null) {
            this.accessibilityDelegate.updateSemantics(buffer, strings, stringAttributeArgs);
        }
    }

    @UiThread
    private void updateCustomAccessibilityActions(@NonNull ByteBuffer buffer, @NonNull String[] strings) {
        this.ensureRunningOnMainThread();
        if (this.accessibilityDelegate != null) {
            this.accessibilityDelegate.updateCustomAccessibilityActions(buffer, strings);
        }
    }

    public void dispatchSemanticsAction(int id, @NonNull AccessibilityBridge.Action action) {
        this.dispatchSemanticsAction(id, action, null);
    }

    public void dispatchSemanticsAction(int id, @NonNull AccessibilityBridge.Action action, @Nullable Object args) {
        this.ensureAttachedToNative();
        ByteBuffer encodedArgs = null;
        int position = 0;
        if (args != null) {
            encodedArgs = StandardMessageCodec.INSTANCE.encodeMessage(args);
            position = encodedArgs.position();
        }
        this.dispatchSemanticsAction(id, action.value, encodedArgs, position);
    }

    @UiThread
    public void dispatchSemanticsAction(int id, int action, @Nullable ByteBuffer args, int argsPosition) {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeDispatchSemanticsAction(this.nativeShellHolderId, id, action, args, argsPosition);
    }

    private native void nativeDispatchSemanticsAction(long var1, int var3, int var4, @Nullable ByteBuffer var5, int var6);

    @UiThread
    public void setSemanticsEnabled(boolean enabled) {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeSetSemanticsEnabled(this.nativeShellHolderId, enabled);
    }

    private native void nativeSetSemanticsEnabled(long var1, boolean var3);

    @UiThread
    public void setAccessibilityFeatures(int flags) {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeSetAccessibilityFeatures(this.nativeShellHolderId, flags);
    }

    private native void nativeSetAccessibilityFeatures(long var1, int var3);

    @UiThread
    public void registerTexture(long textureId, @NonNull SurfaceTextureWrapper textureWrapper) {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeRegisterTexture(this.nativeShellHolderId, textureId, textureWrapper);
    }

    private native void nativeRegisterTexture(long var1, long var3, @NonNull SurfaceTextureWrapper var5);

    @UiThread
    public void markTextureFrameAvailable(long textureId) {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeMarkTextureFrameAvailable(this.nativeShellHolderId, textureId);
    }

    private native void nativeMarkTextureFrameAvailable(long var1, long var3);

    @UiThread
    public void unregisterTexture(long textureId) {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeUnregisterTexture(this.nativeShellHolderId, textureId);
    }

    private native void nativeUnregisterTexture(long var1, long var3);

    @UiThread
    public void runBundleAndSnapshotFromLibrary(@NonNull String bundlePath, @Nullable String entrypointFunctionName, @Nullable String pathToEntrypointFunction, @NonNull AssetManager assetManager) {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeRunBundleAndSnapshotFromLibrary(this.nativeShellHolderId, bundlePath, entrypointFunctionName, pathToEntrypointFunction, assetManager);
    }

    private native void nativeRunBundleAndSnapshotFromLibrary(long var1, @NonNull String var3, @Nullable String var4, @Nullable String var5, @NonNull AssetManager var6);

    @UiThread
    public void setPlatformMessageHandler(@Nullable PlatformMessageHandler platformMessageHandler) {
        this.ensureRunningOnMainThread();
        this.platformMessageHandler = platformMessageHandler;
    }

    @VisibleForTesting
    public void handlePlatformMessage(@NonNull String channel, ByteBuffer message, int replyId) {
        if (this.platformMessageHandler != null) {
            this.platformMessageHandler.handleMessageFromDart(channel, message, replyId);
        }
    }

    private void handlePlatformMessageResponse(int replyId, ByteBuffer reply) {
        if (this.platformMessageHandler != null) {
            this.platformMessageHandler.handlePlatformMessageResponse(replyId, reply);
        }
    }

    @UiThread
    public void dispatchEmptyPlatformMessage(@NonNull String channel, int responseId) {
        this.ensureRunningOnMainThread();
        if (this.isAttached()) {
            this.nativeDispatchEmptyPlatformMessage(this.nativeShellHolderId, channel, responseId);
        } else {
            Log.w(TAG, "Tried to send a platform message to Flutter, but FlutterJNI was detached from native C++. Could not send. Channel: " + channel + ". Response ID: " + responseId);
        }
    }

    private native void nativeDispatchEmptyPlatformMessage(long var1, @NonNull String var3, int var4);

    @UiThread
    public void dispatchPlatformMessage(@NonNull String channel, @Nullable ByteBuffer message, int position, int responseId) {
        this.ensureRunningOnMainThread();
        if (this.isAttached()) {
            this.nativeDispatchPlatformMessage(this.nativeShellHolderId, channel, message, position, responseId);
        } else {
            Log.w(TAG, "Tried to send a platform message to Flutter, but FlutterJNI was detached from native C++. Could not send. Channel: " + channel + ". Response ID: " + responseId);
        }
    }

    private native void nativeDispatchPlatformMessage(long var1, @NonNull String var3, @Nullable ByteBuffer var4, int var5, int var6);

    @UiThread
    public void invokePlatformMessageEmptyResponseCallback(int responseId) {
        this.ensureRunningOnMainThread();
        if (this.isAttached()) {
            this.nativeInvokePlatformMessageEmptyResponseCallback(this.nativeShellHolderId, responseId);
        } else {
            Log.w(TAG, "Tried to send a platform message response, but FlutterJNI was detached from native C++. Could not send. Response ID: " + responseId);
        }
    }

    private native void nativeInvokePlatformMessageEmptyResponseCallback(long var1, int var3);

    @UiThread
    public void invokePlatformMessageResponseCallback(int responseId, @NonNull ByteBuffer message, int position) {
        this.ensureRunningOnMainThread();
        if (!message.isDirect()) {
            throw new IllegalArgumentException("Expected a direct ByteBuffer.");
        }
        if (this.isAttached()) {
            this.nativeInvokePlatformMessageResponseCallback(this.nativeShellHolderId, responseId, message, position);
        } else {
            Log.w(TAG, "Tried to send a platform message response, but FlutterJNI was detached from native C++. Could not send. Response ID: " + responseId);
        }
    }

    private native void nativeInvokePlatformMessageResponseCallback(long var1, int var3, @Nullable ByteBuffer var4, int var5);

    @UiThread
    public void addEngineLifecycleListener(@NonNull FlutterEngine.EngineLifecycleListener engineLifecycleListener) {
        this.ensureRunningOnMainThread();
        this.engineLifecycleListeners.add(engineLifecycleListener);
    }

    @UiThread
    public void removeEngineLifecycleListener(@NonNull FlutterEngine.EngineLifecycleListener engineLifecycleListener) {
        this.ensureRunningOnMainThread();
        this.engineLifecycleListeners.remove(engineLifecycleListener);
    }

    private void onPreEngineRestart() {
        for (FlutterEngine.EngineLifecycleListener listener : this.engineLifecycleListeners) {
            listener.onPreEngineRestart();
        }
    }

    @UiThread
    public void onDisplayOverlaySurface(int id, int x, int y, int width, int height) {
        this.ensureRunningOnMainThread();
        if (this.platformViewsController == null) {
            throw new RuntimeException("platformViewsController must be set before attempting to position an overlay surface");
        }
        this.platformViewsController.onDisplayOverlaySurface(id, x, y, width, height);
    }

    @UiThread
    public void onBeginFrame() {
        this.ensureRunningOnMainThread();
        if (this.platformViewsController == null) {
            throw new RuntimeException("platformViewsController must be set before attempting to begin the frame");
        }
        this.platformViewsController.onBeginFrame();
    }

    @UiThread
    public void onEndFrame() {
        this.ensureRunningOnMainThread();
        if (this.platformViewsController == null) {
            throw new RuntimeException("platformViewsController must be set before attempting to end the frame");
        }
        this.platformViewsController.onEndFrame();
    }

    @UiThread
    public FlutterOverlaySurface createOverlaySurface() {
        this.ensureRunningOnMainThread();
        if (this.platformViewsController == null) {
            throw new RuntimeException("platformViewsController must be set before attempting to position an overlay surface");
        }
        return this.platformViewsController.createOverlaySurface();
    }

    @UiThread
    public void destroyOverlaySurfaces() {
        this.ensureRunningOnMainThread();
        if (this.platformViewsController == null) {
            throw new RuntimeException("platformViewsController must be set before attempting to destroy an overlay surface");
        }
        this.platformViewsController.destroyOverlaySurfaces();
    }

    @UiThread
    public void setLocalizationPlugin(@Nullable LocalizationPlugin localizationPlugin) {
        this.ensureRunningOnMainThread();
        this.localizationPlugin = localizationPlugin;
    }

    @VisibleForTesting
    String[] computePlatformResolvedLocale(@NonNull String[] strings) {
        if (this.localizationPlugin == null) {
            return new String[0];
        }
        ArrayList<Locale> supportedLocales = new ArrayList<Locale>();
        int localeDataLength = 3;
        for (int i = 0; i < strings.length; i += 3) {
            String languageCode = strings[i + 0];
            String countryCode = strings[i + 1];
            String scriptCode = strings[i + 2];
            if (Build.VERSION.SDK_INT >= 21) {
                Locale.Builder localeBuilder = new Locale.Builder();
                if (!languageCode.isEmpty()) {
                    localeBuilder.setLanguage(languageCode);
                }
                if (!countryCode.isEmpty()) {
                    localeBuilder.setRegion(countryCode);
                }
                if (!scriptCode.isEmpty()) {
                    localeBuilder.setScript(scriptCode);
                }
                supportedLocales.add(localeBuilder.build());
                continue;
            }
            supportedLocales.add(new Locale(languageCode, countryCode));
        }
        Locale result = this.localizationPlugin.resolveNativeLocale(supportedLocales);
        if (result == null) {
            return new String[0];
        }
        String[] output = new String[]{result.getLanguage(), result.getCountry(), Build.VERSION.SDK_INT >= 21 ? result.getScript() : ""};
        return output;
    }

    @UiThread
    public void setDeferredComponentManager(@Nullable DeferredComponentManager deferredComponentManager) {
        this.ensureRunningOnMainThread();
        this.deferredComponentManager = deferredComponentManager;
        if (deferredComponentManager != null) {
            deferredComponentManager.setJNI(this);
        }
    }

    @UiThread
    public void requestDartDeferredLibrary(int loadingUnitId) {
        if (this.deferredComponentManager != null) {
            this.deferredComponentManager.installDeferredComponent(loadingUnitId, null);
        } else {
            Log.e(TAG, "No DeferredComponentManager found. Android setup must be completed before using split AOT deferred components.");
        }
    }

    @UiThread
    public void loadDartDeferredLibrary(int loadingUnitId, @NonNull String[] searchPaths) {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeLoadDartDeferredLibrary(this.nativeShellHolderId, loadingUnitId, searchPaths);
    }

    private native void nativeLoadDartDeferredLibrary(long var1, int var3, @NonNull String[] var4);

    @UiThread
    public void updateJavaAssetManager(@NonNull AssetManager assetManager, @NonNull String assetBundlePath) {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeUpdateJavaAssetManager(this.nativeShellHolderId, assetManager, assetBundlePath);
    }

    private native void nativeUpdateJavaAssetManager(long var1, @NonNull AssetManager var3, @NonNull String var4);

    @UiThread
    public void deferredComponentInstallFailure(int loadingUnitId, @NonNull String error, boolean isTransient) {
        this.ensureRunningOnMainThread();
        this.nativeDeferredComponentInstallFailure(loadingUnitId, error, isTransient);
    }

    private native void nativeDeferredComponentInstallFailure(int var1, @NonNull String var2, boolean var3);

    @UiThread
    public void onDisplayPlatformView(int viewId, int x, int y, int width, int height, int viewWidth, int viewHeight, FlutterMutatorsStack mutatorsStack) {
        this.ensureRunningOnMainThread();
        if (this.platformViewsController == null) {
            throw new RuntimeException("platformViewsController must be set before attempting to position a platform view");
        }
        this.platformViewsController.onDisplayPlatformView(viewId, x, y, width, height, viewWidth, viewHeight, mutatorsStack);
    }

    @UiThread
    public Bitmap getBitmap() {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        return this.nativeGetBitmap(this.nativeShellHolderId);
    }

    private native Bitmap nativeGetBitmap(long var1);

    @UiThread
    public void notifyLowMemoryWarning() {
        this.ensureRunningOnMainThread();
        this.ensureAttachedToNative();
        this.nativeNotifyLowMemoryWarning(this.nativeShellHolderId);
    }

    private native void nativeNotifyLowMemoryWarning(long var1);

    private void ensureRunningOnMainThread() {
        if (Looper.myLooper() != this.mainLooper) {
            throw new RuntimeException("Methods marked with @UiThread must be executed on the main thread. Current thread: " + Thread.currentThread().getName());
        }
    }

    static {
        refreshRateFPS = 0.0f;
        setRefreshRateFPSCalled = false;
    }

    public static class Factory {
        public FlutterJNI provideFlutterJNI() {
            return new FlutterJNI();
        }
    }

    public static interface AsyncWaitForVsyncDelegate {
        public void asyncWaitForVsync(long var1);
    }

    public static interface AccessibilityDelegate {
        public void updateCustomAccessibilityActions(@NonNull ByteBuffer var1, @NonNull String[] var2);

        public void updateSemantics(@NonNull ByteBuffer var1, @NonNull String[] var2, @NonNull ByteBuffer[] var3);
    }
}

