  // These are supplemental key data to be added to those that Chromium
  // defines.

  // ============================================================
  // Printable keys
  // ============================================================

  //          Key                       Enum                Unicode code point
  DOM_KEY_UNI("Space",                  SPACE,                  ' '),
  DOM_KEY_UNI("Exclamation",            EXCLAMATION,            '!'),
  DOM_KEY_UNI("NumberSign",             NUMBER_SIGN,            '#'),
  DOM_KEY_UNI("Dollar",                 DOLLAR,                 '$'),
  DOM_KEY_UNI("Percent",                PERCENT,                '%'),
  DOM_KEY_UNI("Ampersand",              AMPERSAND,              '&'),
  DOM_KEY_UNI("QuoteSingle",            QUOTE_SINGLE,           0x0027),
  DOM_KEY_UNI("Quote",                  QUOTE,                  '"')",
  DOM_KEY_UNI("ParenthesisLeft",        PARENTHESIS_LEFT,       '('),
  DOM_KEY_UNI("ParenthesisRight",       PARENTHESIS_RIGHT,      ')'),
  DOM_KEY_UNI("Asterisk",               ASTERISK,               '*'),
  DOM_KEY_UNI("Add",                    ADD,                    '+'),
  DOM_KEY_UNI("Comma",                  COMMA,                  ','),
  DOM_KEY_UNI("Minus",                  MINUS,                  '-'),
  DOM_KEY_UNI("Period",                 PERIOD,                 '.'),
  DOM_KEY_UNI("Slash",                  SLASH,                  '/'),
  DOM_KEY_UNI("Digit0",                 DIGIT0,                 '0'),
  DOM_KEY_UNI("Digit1",                 DIGIT1,                 '1'),
  DOM_KEY_UNI("Digit2",                 DIGIT2,                 '2'),
  DOM_KEY_UNI("Digit3",                 DIGIT3,                 '3'),
  DOM_KEY_UNI("Digit4",                 DIGIT4,                 '4'),
  DOM_KEY_UNI("Digit5",                 DIGIT5,                 '5'),
  DOM_KEY_UNI("Digit6",                 DIGIT6,                 '6'),
  DOM_KEY_UNI("Digit7",                 DIGIT7,                 '7'),
  DOM_KEY_UNI("Digit8",                 DIGIT8,                 '8'),
  DOM_KEY_UNI("Digit9",                 DIGIT9,                 '9'),
  DOM_KEY_UNI("Colon",                  COLON,                  ':'),
  DOM_KEY_UNI("Semicolon",              SEMICOLON,              ';'),
  DOM_KEY_UNI("Less",                   LESS,                   '<'),
  DOM_KEY_UNI("Equal",                  EQUAL,                  '='),
  DOM_KEY_UNI("Greater",                GREATER,                '>'),
  DOM_KEY_UNI("Question",               QUESTION,               '?'),
  DOM_KEY_UNI("At",                     AT,                     '@'),
  DOM_KEY_UNI("BracketLeft",            BRACKET_LEFT,           '['),
  DOM_KEY_UNI("Backslash",              BACKSLASH,              0x005c),
  DOM_KEY_UNI("BracketRight",           BRACKET_RIGHT,          ']'),
  DOM_KEY_UNI("Caret",                  CARET,                  '^'),
  DOM_KEY_UNI("Backquote",              BACKQUOTE,              '`'),
  DOM_KEY_UNI("Underscore",             UNDERSCORE,             '_'),
  DOM_KEY_UNI("KeyA",                   KEY_A,                  'a'),
  DOM_KEY_UNI("KeyB",                   KEY_B,                  'b'),
  DOM_KEY_UNI("KeyC",                   KEY_C,                  'c'),
  DOM_KEY_UNI("KeyD",                   KEY_D,                  'd'),
  DOM_KEY_UNI("KeyE",                   KEY_E,                  'e'),
  DOM_KEY_UNI("KeyF",                   KEY_F,                  'f'),
  DOM_KEY_UNI("KeyG",                   KEY_G,                  'g'),
  DOM_KEY_UNI("KeyH",                   KEY_H,                  'h'),
  DOM_KEY_UNI("KeyI",                   KEY_I,                  'i'),
  DOM_KEY_UNI("KeyJ",                   KEY_J,                  'j'),
  DOM_KEY_UNI("KeyK",                   KEY_K,                  'k'),
  DOM_KEY_UNI("KeyL",                   KEY_L,                  'l'),
  DOM_KEY_UNI("KeyM",                   KEY_M,                  'm'),
  DOM_KEY_UNI("KeyN",                   KEY_N,                  'n'),
  DOM_KEY_UNI("KeyO",                   KEY_O,                  'o'),
  DOM_KEY_UNI("KeyP",                   KEY_P,                  'p'),
  DOM_KEY_UNI("KeyQ",                   KEY_Q,                  'q'),
  DOM_KEY_UNI("KeyR",                   KEY_R,                  'r'),
  DOM_KEY_UNI("KeyS",                   KEY_S,                  's'),
  DOM_KEY_UNI("KeyT",                   KEY_T,                  't'),
  DOM_KEY_UNI("KeyU",                   KEY_U,                  'u'),
  DOM_KEY_UNI("KeyV",                   KEY_V,                  'v'),
  DOM_KEY_UNI("KeyW",                   KEY_W,                  'w'),
  DOM_KEY_UNI("KeyX",                   KEY_X,                  'x'),
  DOM_KEY_UNI("KeyY",                   KEY_Y,                  'y'),
  DOM_KEY_UNI("KeyZ",                   KEY_Z,                  'z'),
  DOM_KEY_UNI("BraceLeft",              BRACE_LEFT,             '{'),
  DOM_KEY_UNI("BraceRight",             BRACE_RIGHT,            '}'),
  DOM_KEY_UNI("Tilde",                  TILDE,                  '~'),
  DOM_KEY_UNI("Bar",                    BAR,                    '|'),


  // ============================================================
  // Game controller buttons
  // ============================================================

  // Since the web doesn't have game controller buttons defined in the
  // same way, these map USB HID codes for game controller buttons to
  // Android/Linux button names.
  //          Key                       Enum                    Value
  DOM_KEY_MAP("GameButton1",            GAME_BUTTON_1,               0x05ff01),
  DOM_KEY_MAP("GameButton2",            GAME_BUTTON_2,               0x05ff02),
  DOM_KEY_MAP("GameButton3",            GAME_BUTTON_3,               0x05ff03),
  DOM_KEY_MAP("GameButton4",            GAME_BUTTON_4,               0x05ff04),
  DOM_KEY_MAP("GameButton5",            GAME_BUTTON_5,               0x05ff05),
  DOM_KEY_MAP("GameButton6",            GAME_BUTTON_6,               0x05ff06),
  DOM_KEY_MAP("GameButton7",            GAME_BUTTON_7,               0x05ff07),
  DOM_KEY_MAP("GameButton8",            GAME_BUTTON_8,               0x05ff08),
  DOM_KEY_MAP("GameButton9",            GAME_BUTTON_9,               0x05ff09),
  DOM_KEY_MAP("GameButton10",           GAME_BUTTON_10,              0x05ff0a),
  DOM_KEY_MAP("GameButton11",           GAME_BUTTON_11,              0x05ff0b),
  DOM_KEY_MAP("GameButton12",           GAME_BUTTON_12,              0x05ff0c),
  DOM_KEY_MAP("GameButton13",           GAME_BUTTON_13,              0x05ff0d),
  DOM_KEY_MAP("GameButton14",           GAME_BUTTON_14,              0x05ff0e),
  DOM_KEY_MAP("GameButton15",           GAME_BUTTON_15,              0x05ff0f),
  DOM_KEY_MAP("GameButton16",           GAME_BUTTON_16,              0x05ff10),
  DOM_KEY_MAP("GameButtonA",            GAME_BUTTON_A,               0x05ff11),
  DOM_KEY_MAP("GameButtonB",            GAME_BUTTON_B,               0x05ff12),
  DOM_KEY_MAP("GameButtonC",            GAME_BUTTON_C,               0x05ff13),
  DOM_KEY_MAP("GameButtonLeft1",        GAME_BUTTON_L1,              0x05ff14),
  DOM_KEY_MAP("GameButtonLeft2",        GAME_BUTTON_L2,              0x05ff15),
  DOM_KEY_MAP("GameButtonMode",         GAME_BUTTON_MODE,            0x05ff16),
  DOM_KEY_MAP("GameButtonRight1",       GAME_BUTTON_R1,              0x05ff17),
  DOM_KEY_MAP("GameButtonRight2",       GAME_BUTTON_R2,              0x05ff18),
  DOM_KEY_MAP("GameButtonSelect",       GAME_BUTTON_SELECT,          0x05ff19),
  DOM_KEY_MAP("GameButtonStart",        GAME_BUTTON_START,           0x05ff1a),
  DOM_KEY_MAP("GameButtonThumbLeft",    GAME_BUTTON_THUMBL,          0x05ff1b),
  DOM_KEY_MAP("GameButtonThumbRight",   GAME_BUTTON_THUMBR,          0x05ff1c),
  DOM_KEY_MAP("GameButtonX",            GAME_BUTTON_X,               0x05ff1d),
  DOM_KEY_MAP("GameButtonY",            GAME_BUTTON_Y,               0x05ff1e),
  DOM_KEY_MAP("GameButtonZ",            GAME_BUTTON_Z,               0x05ff1f),


  // ============================================================
  // Other buttons
  // ============================================================

  //          Key                       Enum                    Value
  DOM_KEY_MAP("None",                   NONE,                   0x0),
  DOM_KEY_MAP("Suspend",                SUSPEND,                0x100000014),
  DOM_KEY_MAP("Resume",                 RESUME,                 0x100000015),
  DOM_KEY_MAP("Sleep",                  SLEEP,                  0x100010082),
  DOM_KEY_MAP("IntlBackslash",          INTL_BACKSLASH,         0x100070064),
  DOM_KEY_MAP("IntlRo",                 INTL_RO,                0x100070087),
  DOM_KEY_MAP("IntlYen",                INTL_YEN,               0x100070089),
  DOM_KEY_MAP("Lang1",                  LANG1,                  0x100070090),
  DOM_KEY_MAP("Lang2",                  LANG2,                  0x100070091),
  DOM_KEY_MAP("Lang3",                  LANG3,                  0x100070092),
  DOM_KEY_MAP("Lang4",                  LANG4,                  0x100070093),
  DOM_KEY_MAP("Lang5",                  LANG5,                  0x100070094),
  DOM_KEY_MAP("Abort",                  ABORT,                  0x10007009b),
