/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.FlutterInjector;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.embedding.engine.loader.FlutterLoader;
import java.util.ArrayList;
import java.util.List;

public class FlutterEngineGroup {
    @VisibleForTesting
    final List<FlutterEngine> activeEngines = new ArrayList<FlutterEngine>();

    public FlutterEngineGroup(@NonNull Context context) {
        this(context, null);
    }

    public FlutterEngineGroup(@NonNull Context context, @Nullable String[] dartVmArgs) {
        FlutterLoader loader = FlutterInjector.instance().flutterLoader();
        if (!loader.initialized()) {
            loader.startInitialization(context.getApplicationContext());
            loader.ensureInitializationComplete(context, dartVmArgs);
        }
    }

    public FlutterEngine createAndRunDefaultEngine(@NonNull Context context) {
        return this.createAndRunEngine(context, null);
    }

    public FlutterEngine createAndRunEngine(@NonNull Context context, @Nullable DartExecutor.DartEntrypoint dartEntrypoint) {
        FlutterEngine engine = null;
        if (dartEntrypoint == null) {
            dartEntrypoint = DartExecutor.DartEntrypoint.createDefault();
        }
        if (this.activeEngines.size() == 0) {
            engine = this.createEngine(context);
            engine.getDartExecutor().executeDartEntrypoint(dartEntrypoint);
        } else {
            engine = this.activeEngines.get(0).spawn(context, dartEntrypoint);
        }
        this.activeEngines.add(engine);
        final FlutterEngine engineToCleanUpOnDestroy = engine;
        engine.addEngineLifecycleListener(new FlutterEngine.EngineLifecycleListener(){

            @Override
            public void onPreEngineRestart() {
            }

            @Override
            public void onEngineWillDestroy() {
                FlutterEngineGroup.this.activeEngines.remove(engineToCleanUpOnDestroy);
            }
        });
        return engine;
    }

    @VisibleForTesting
    FlutterEngine createEngine(Context context) {
        return new FlutterEngine(context);
    }
}

