/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Insets;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.os.Handler;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.DisplayCutout;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.PointerIcon;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewStructure;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.autofill.AutofillValue;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.UiThread;
import io.flutter.Log;
import io.flutter.app.FlutterPluginRegistry;
import io.flutter.embedding.android.AndroidTouchProcessor;
import io.flutter.embedding.android.KeyChannelResponder;
import io.flutter.embedding.android.KeyboardManager;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.embedding.engine.renderer.FlutterRenderer;
import io.flutter.embedding.engine.renderer.SurfaceTextureWrapper;
import io.flutter.embedding.engine.systemchannels.AccessibilityChannel;
import io.flutter.embedding.engine.systemchannels.KeyEventChannel;
import io.flutter.embedding.engine.systemchannels.LifecycleChannel;
import io.flutter.embedding.engine.systemchannels.LocalizationChannel;
import io.flutter.embedding.engine.systemchannels.MouseCursorChannel;
import io.flutter.embedding.engine.systemchannels.NavigationChannel;
import io.flutter.embedding.engine.systemchannels.PlatformChannel;
import io.flutter.embedding.engine.systemchannels.SettingsChannel;
import io.flutter.embedding.engine.systemchannels.SystemChannel;
import io.flutter.embedding.engine.systemchannels.TextInputChannel;
import io.flutter.plugin.common.ActivityLifecycleListener;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.editing.TextInputPlugin;
import io.flutter.plugin.localization.LocalizationPlugin;
import io.flutter.plugin.mouse.MouseCursorPlugin;
import io.flutter.plugin.platform.PlatformPlugin;
import io.flutter.plugin.platform.PlatformViewsController;
import io.flutter.util.ViewUtils;
import io.flutter.view.AccessibilityBridge;
import io.flutter.view.FlutterMain;
import io.flutter.view.FlutterNativeView;
import io.flutter.view.FlutterRunArguments;
import io.flutter.view.TextureRegistry;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

@Deprecated
public class FlutterView
extends SurfaceView
implements BinaryMessenger,
TextureRegistry,
MouseCursorPlugin.MouseCursorViewDelegate {
    private static final String TAG = "FlutterView";
    private final DartExecutor dartExecutor;
    private final FlutterRenderer flutterRenderer;
    private final NavigationChannel navigationChannel;
    private final KeyEventChannel keyEventChannel;
    private final LifecycleChannel lifecycleChannel;
    private final LocalizationChannel localizationChannel;
    private final PlatformChannel platformChannel;
    private final SettingsChannel settingsChannel;
    private final SystemChannel systemChannel;
    private final InputMethodManager mImm;
    private final TextInputPlugin mTextInputPlugin;
    private final LocalizationPlugin mLocalizationPlugin;
    private final MouseCursorPlugin mMouseCursorPlugin;
    private final KeyboardManager mKeyboardManager;
    private final AndroidTouchProcessor androidTouchProcessor;
    private AccessibilityBridge mAccessibilityNodeProvider;
    private final SurfaceHolder.Callback mSurfaceCallback;
    private final ViewportMetrics mMetrics;
    private final List<ActivityLifecycleListener> mActivityLifecycleListeners;
    private final List<FirstFrameListener> mFirstFrameListeners;
    private final AtomicLong nextTextureId = new AtomicLong(0L);
    private FlutterNativeView mNativeView;
    private boolean mIsSoftwareRenderingEnabled = false;
    private boolean didRenderFirstFrame = false;
    private final AccessibilityBridge.OnAccessibilityChangeListener onAccessibilityChangeListener = new AccessibilityBridge.OnAccessibilityChangeListener(){

        @Override
        public void onAccessibilityChanged(boolean isAccessibilityEnabled, boolean isTouchExplorationEnabled) {
            FlutterView.this.resetWillNotDraw(isAccessibilityEnabled, isTouchExplorationEnabled);
        }
    };

    public FlutterView(Context context) {
        this(context, null);
    }

    public FlutterView(Context context, AttributeSet attrs) {
        this(context, attrs, null);
    }

    public FlutterView(Context context, AttributeSet attrs, FlutterNativeView nativeView) {
        super(context, attrs);
        Activity activity = ViewUtils.getActivity(this.getContext());
        if (activity == null) {
            throw new IllegalArgumentException("Bad context");
        }
        this.mNativeView = nativeView == null ? new FlutterNativeView(activity.getApplicationContext()) : nativeView;
        this.dartExecutor = this.mNativeView.getDartExecutor();
        this.flutterRenderer = new FlutterRenderer(this.mNativeView.getFlutterJNI());
        this.mIsSoftwareRenderingEnabled = this.mNativeView.getFlutterJNI().getIsSoftwareRenderingEnabled();
        this.mMetrics = new ViewportMetrics();
        this.mMetrics.devicePixelRatio = context.getResources().getDisplayMetrics().density;
        this.mMetrics.physicalTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.mNativeView.attachViewAndActivity(this, activity);
        this.mSurfaceCallback = new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder holder) {
                FlutterView.this.assertAttached();
                FlutterView.this.mNativeView.getFlutterJNI().onSurfaceCreated(holder.getSurface());
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                FlutterView.this.assertAttached();
                FlutterView.this.mNativeView.getFlutterJNI().onSurfaceChanged(width, height);
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
                FlutterView.this.assertAttached();
                FlutterView.this.mNativeView.getFlutterJNI().onSurfaceDestroyed();
            }
        };
        this.getHolder().addCallback(this.mSurfaceCallback);
        this.mActivityLifecycleListeners = new ArrayList<ActivityLifecycleListener>();
        this.mFirstFrameListeners = new ArrayList<FirstFrameListener>();
        this.navigationChannel = new NavigationChannel(this.dartExecutor);
        this.keyEventChannel = new KeyEventChannel(this.dartExecutor);
        this.lifecycleChannel = new LifecycleChannel(this.dartExecutor);
        this.localizationChannel = new LocalizationChannel(this.dartExecutor);
        this.platformChannel = new PlatformChannel(this.dartExecutor);
        this.systemChannel = new SystemChannel(this.dartExecutor);
        this.settingsChannel = new SettingsChannel(this.dartExecutor);
        final PlatformPlugin platformPlugin = new PlatformPlugin(activity, this.platformChannel);
        this.addActivityLifecycleListener(new ActivityLifecycleListener(){

            @Override
            public void onPostResume() {
                platformPlugin.updateSystemUiOverlays();
            }
        });
        this.mImm = (InputMethodManager)this.getContext().getSystemService("input_method");
        PlatformViewsController platformViewsController = this.mNativeView.getPluginRegistry().getPlatformViewsController();
        this.mTextInputPlugin = new TextInputPlugin((View)this, new TextInputChannel(this.dartExecutor), platformViewsController);
        this.mKeyboardManager = new KeyboardManager((View)this, this.mTextInputPlugin, new KeyChannelResponder[]{new KeyChannelResponder(this.keyEventChannel)});
        this.mMouseCursorPlugin = Build.VERSION.SDK_INT >= 24 ? new MouseCursorPlugin(this, new MouseCursorChannel(this.dartExecutor)) : null;
        this.mLocalizationPlugin = new LocalizationPlugin(context, this.localizationChannel);
        this.androidTouchProcessor = new AndroidTouchProcessor(this.flutterRenderer, false);
        platformViewsController.attachToFlutterRenderer(this.flutterRenderer);
        this.mNativeView.getPluginRegistry().getPlatformViewsController().attachTextInputPlugin(this.mTextInputPlugin);
        this.mNativeView.getFlutterJNI().setLocalizationPlugin(this.mLocalizationPlugin);
        this.mLocalizationPlugin.sendLocalesToFlutter(this.getResources().getConfiguration());
        this.sendUserPlatformSettingsToDart();
    }

    @NonNull
    public DartExecutor getDartExecutor() {
        return this.dartExecutor;
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        Log.e(TAG, "dispatchKeyEvent: " + event.toString());
        if (event.getAction() == 0 && event.getRepeatCount() == 0) {
            this.getKeyDispatcherState().startTracking(event, (Object)this);
        } else if (event.getAction() == 1) {
            this.getKeyDispatcherState().handleUpEvent(event);
        }
        return this.isAttached() && this.mKeyboardManager.handleEvent(event) || super.dispatchKeyEvent(event);
    }

    public FlutterNativeView getFlutterNativeView() {
        return this.mNativeView;
    }

    public FlutterPluginRegistry getPluginRegistry() {
        return this.mNativeView.getPluginRegistry();
    }

    public String getLookupKeyForAsset(String asset) {
        return FlutterMain.getLookupKeyForAsset(asset);
    }

    public String getLookupKeyForAsset(String asset, String packageName) {
        return FlutterMain.getLookupKeyForAsset(asset, packageName);
    }

    public void addActivityLifecycleListener(ActivityLifecycleListener listener) {
        this.mActivityLifecycleListeners.add(listener);
    }

    public void onStart() {
        this.lifecycleChannel.appIsInactive();
    }

    public void onPause() {
        this.lifecycleChannel.appIsInactive();
    }

    public void onPostResume() {
        for (ActivityLifecycleListener listener : this.mActivityLifecycleListeners) {
            listener.onPostResume();
        }
        this.lifecycleChannel.appIsResumed();
    }

    public void onStop() {
        this.lifecycleChannel.appIsPaused();
    }

    public void onMemoryPressure() {
        this.mNativeView.getFlutterJNI().notifyLowMemoryWarning();
        this.systemChannel.sendMemoryPressureWarning();
    }

    public boolean hasRenderedFirstFrame() {
        return this.didRenderFirstFrame;
    }

    public void addFirstFrameListener(FirstFrameListener listener) {
        this.mFirstFrameListeners.add(listener);
    }

    public void removeFirstFrameListener(FirstFrameListener listener) {
        this.mFirstFrameListeners.remove(listener);
    }

    @Deprecated
    public void enableTransparentBackground() {
        Log.w(TAG, "FlutterView in the v1 embedding is always a SurfaceView and will cover accessibility highlights when transparent. Consider migrating to the v2 Android embedding. https://github.com/flutter/flutter/wiki/Upgrading-pre-1.12-Android-projects");
        this.setZOrderOnTop(true);
        this.getHolder().setFormat(-2);
    }

    public void disableTransparentBackground() {
        this.setZOrderOnTop(false);
        this.getHolder().setFormat(-1);
    }

    public void setInitialRoute(String route) {
        this.navigationChannel.setInitialRoute(route);
    }

    public void pushRoute(String route) {
        this.navigationChannel.pushRoute(route);
    }

    public void popRoute() {
        this.navigationChannel.popRoute();
    }

    private void sendUserPlatformSettingsToDart() {
        boolean isNightModeOn = (this.getResources().getConfiguration().uiMode & 0x30) == 32;
        SettingsChannel.PlatformBrightness brightness = isNightModeOn ? SettingsChannel.PlatformBrightness.dark : SettingsChannel.PlatformBrightness.light;
        this.settingsChannel.startMessage().setTextScaleFactor(this.getResources().getConfiguration().fontScale).setUse24HourFormat(DateFormat.is24HourFormat((Context)this.getContext())).setPlatformBrightness(brightness).send();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mLocalizationPlugin.sendLocalesToFlutter(newConfig);
        this.sendUserPlatformSettingsToDart();
    }

    float getDevicePixelRatio() {
        return this.mMetrics.devicePixelRatio;
    }

    public FlutterNativeView detach() {
        if (!this.isAttached()) {
            return null;
        }
        this.getHolder().removeCallback(this.mSurfaceCallback);
        this.mNativeView.detachFromFlutterView();
        FlutterNativeView view = this.mNativeView;
        this.mNativeView = null;
        return view;
    }

    public void destroy() {
        if (!this.isAttached()) {
            return;
        }
        this.getHolder().removeCallback(this.mSurfaceCallback);
        this.releaseAccessibilityNodeProvider();
        this.mNativeView.destroy();
        this.mNativeView = null;
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        return this.mTextInputPlugin.createInputConnection((View)this, this.mKeyboardManager, outAttrs);
    }

    public boolean checkInputConnectionProxy(View view) {
        return this.mNativeView.getPluginRegistry().getPlatformViewsController().checkInputConnectionProxy(view);
    }

    public void onProvideAutofillVirtualStructure(ViewStructure structure, int flags) {
        super.onProvideAutofillVirtualStructure(structure, flags);
        this.mTextInputPlugin.onProvideAutofillVirtualStructure(structure, flags);
    }

    public void autofill(SparseArray<AutofillValue> values) {
        this.mTextInputPlugin.autofill(values);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isAttached()) {
            return super.onTouchEvent(event);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.requestUnbufferedDispatch(event);
        }
        return this.androidTouchProcessor.onTouchEvent(event);
    }

    public boolean onHoverEvent(MotionEvent event) {
        if (!this.isAttached()) {
            return super.onHoverEvent(event);
        }
        boolean handled = this.mAccessibilityNodeProvider.onAccessibilityHoverEvent(event);
        if (!handled) {
            // empty if block
        }
        return handled;
    }

    public boolean onGenericMotionEvent(MotionEvent event) {
        boolean handled = this.isAttached() && this.androidTouchProcessor.onGenericMotionEvent(event);
        return handled ? true : super.onGenericMotionEvent(event);
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        this.mMetrics.physicalWidth = width;
        this.mMetrics.physicalHeight = height;
        this.updateViewportMetrics();
        super.onSizeChanged(width, height, oldWidth, oldHeight);
    }

    private ZeroSides calculateShouldZeroSides() {
        Context context = this.getContext();
        int orientation = context.getResources().getConfiguration().orientation;
        int rotation = ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getRotation();
        if (orientation == 2) {
            if (rotation == 1) {
                return ZeroSides.RIGHT;
            }
            if (rotation == 3) {
                return Build.VERSION.SDK_INT >= 23 ? ZeroSides.LEFT : ZeroSides.RIGHT;
            }
            if (rotation == 0 || rotation == 2) {
                return ZeroSides.BOTH;
            }
        }
        return ZeroSides.NONE;
    }

    @TargetApi(value=20)
    @RequiresApi(value=20)
    private int guessBottomKeyboardInset(WindowInsets insets) {
        int screenHeight = this.getRootView().getHeight();
        double keyboardHeightRatioHeuristic = 0.18;
        if ((double)insets.getSystemWindowInsetBottom() < (double)screenHeight * 0.18) {
            return 0;
        }
        return insets.getSystemWindowInsetBottom();
    }

    @TargetApi(value=20)
    @RequiresApi(value=20)
    @SuppressLint(value={"InlinedApi", "NewApi"})
    public final WindowInsets onApplyWindowInsets(WindowInsets insets) {
        boolean navigationBarVisible;
        if (Build.VERSION.SDK_INT == 29) {
            Insets systemGestureInsets = insets.getSystemGestureInsets();
            this.mMetrics.systemGestureInsetTop = systemGestureInsets.top;
            this.mMetrics.systemGestureInsetRight = systemGestureInsets.right;
            this.mMetrics.systemGestureInsetBottom = systemGestureInsets.bottom;
            this.mMetrics.systemGestureInsetLeft = systemGestureInsets.left;
        }
        boolean statusBarVisible = (4 & this.getWindowSystemUiVisibility()) == 0;
        boolean bl = navigationBarVisible = (2 & this.getWindowSystemUiVisibility()) == 0;
        if (Build.VERSION.SDK_INT >= 30) {
            int mask = 0;
            if (navigationBarVisible) {
                mask |= WindowInsets.Type.navigationBars();
            }
            if (statusBarVisible) {
                mask |= WindowInsets.Type.statusBars();
            }
            Insets uiInsets = insets.getInsets(mask);
            this.mMetrics.physicalViewPaddingTop = uiInsets.top;
            this.mMetrics.physicalViewPaddingRight = uiInsets.right;
            this.mMetrics.physicalViewPaddingBottom = uiInsets.bottom;
            this.mMetrics.physicalViewPaddingLeft = uiInsets.left;
            Insets imeInsets = insets.getInsets(WindowInsets.Type.ime());
            this.mMetrics.physicalViewInsetTop = imeInsets.top;
            this.mMetrics.physicalViewInsetRight = imeInsets.right;
            this.mMetrics.physicalViewInsetBottom = imeInsets.bottom;
            this.mMetrics.physicalViewInsetLeft = imeInsets.left;
            Insets systemGestureInsets = insets.getInsets(WindowInsets.Type.systemGestures());
            this.mMetrics.systemGestureInsetTop = systemGestureInsets.top;
            this.mMetrics.systemGestureInsetRight = systemGestureInsets.right;
            this.mMetrics.systemGestureInsetBottom = systemGestureInsets.bottom;
            this.mMetrics.systemGestureInsetLeft = systemGestureInsets.left;
            DisplayCutout cutout = insets.getDisplayCutout();
            if (cutout != null) {
                Insets waterfallInsets = cutout.getWaterfallInsets();
                this.mMetrics.physicalViewPaddingTop = Math.max(Math.max(this.mMetrics.physicalViewPaddingTop, waterfallInsets.top), cutout.getSafeInsetTop());
                this.mMetrics.physicalViewPaddingRight = Math.max(Math.max(this.mMetrics.physicalViewPaddingRight, waterfallInsets.right), cutout.getSafeInsetRight());
                this.mMetrics.physicalViewPaddingBottom = Math.max(Math.max(this.mMetrics.physicalViewPaddingBottom, waterfallInsets.bottom), cutout.getSafeInsetBottom());
                this.mMetrics.physicalViewPaddingLeft = Math.max(Math.max(this.mMetrics.physicalViewPaddingLeft, waterfallInsets.left), cutout.getSafeInsetLeft());
            }
        } else {
            ZeroSides zeroSides = ZeroSides.NONE;
            if (!navigationBarVisible) {
                zeroSides = this.calculateShouldZeroSides();
            }
            this.mMetrics.physicalViewPaddingTop = statusBarVisible ? insets.getSystemWindowInsetTop() : 0;
            this.mMetrics.physicalViewPaddingRight = zeroSides == ZeroSides.RIGHT || zeroSides == ZeroSides.BOTH ? 0 : insets.getSystemWindowInsetRight();
            this.mMetrics.physicalViewPaddingBottom = navigationBarVisible && this.guessBottomKeyboardInset(insets) == 0 ? insets.getSystemWindowInsetBottom() : 0;
            this.mMetrics.physicalViewPaddingLeft = zeroSides == ZeroSides.LEFT || zeroSides == ZeroSides.BOTH ? 0 : insets.getSystemWindowInsetLeft();
            this.mMetrics.physicalViewInsetTop = 0;
            this.mMetrics.physicalViewInsetRight = 0;
            this.mMetrics.physicalViewInsetBottom = this.guessBottomKeyboardInset(insets);
            this.mMetrics.physicalViewInsetLeft = 0;
        }
        this.updateViewportMetrics();
        return super.onApplyWindowInsets(insets);
    }

    protected boolean fitSystemWindows(Rect insets) {
        if (Build.VERSION.SDK_INT <= 19) {
            this.mMetrics.physicalViewPaddingTop = insets.top;
            this.mMetrics.physicalViewPaddingRight = insets.right;
            this.mMetrics.physicalViewPaddingBottom = 0;
            this.mMetrics.physicalViewPaddingLeft = insets.left;
            this.mMetrics.physicalViewInsetTop = 0;
            this.mMetrics.physicalViewInsetRight = 0;
            this.mMetrics.physicalViewInsetBottom = insets.bottom;
            this.mMetrics.physicalViewInsetLeft = 0;
            this.updateViewportMetrics();
            return true;
        }
        return super.fitSystemWindows(insets);
    }

    private boolean isAttached() {
        return this.mNativeView != null && this.mNativeView.isAttached();
    }

    void assertAttached() {
        if (!this.isAttached()) {
            throw new AssertionError((Object)"Platform view is not attached");
        }
    }

    private void preRun() {
        this.resetAccessibilityTree();
    }

    void resetAccessibilityTree() {
        if (this.mAccessibilityNodeProvider != null) {
            this.mAccessibilityNodeProvider.reset();
        }
    }

    private void postRun() {
    }

    public void runFromBundle(FlutterRunArguments args) {
        this.assertAttached();
        this.preRun();
        this.mNativeView.runFromBundle(args);
        this.postRun();
    }

    public Bitmap getBitmap() {
        this.assertAttached();
        return this.mNativeView.getFlutterJNI().getBitmap();
    }

    private void updateViewportMetrics() {
        if (!this.isAttached()) {
            return;
        }
        this.mNativeView.getFlutterJNI().setViewportMetrics(this.mMetrics.devicePixelRatio, this.mMetrics.physicalWidth, this.mMetrics.physicalHeight, this.mMetrics.physicalViewPaddingTop, this.mMetrics.physicalViewPaddingRight, this.mMetrics.physicalViewPaddingBottom, this.mMetrics.physicalViewPaddingLeft, this.mMetrics.physicalViewInsetTop, this.mMetrics.physicalViewInsetRight, this.mMetrics.physicalViewInsetBottom, this.mMetrics.physicalViewInsetLeft, this.mMetrics.systemGestureInsetTop, this.mMetrics.systemGestureInsetRight, this.mMetrics.systemGestureInsetBottom, this.mMetrics.systemGestureInsetLeft, this.mMetrics.physicalTouchSlop);
    }

    public void onFirstFrame() {
        this.didRenderFirstFrame = true;
        ArrayList<FirstFrameListener> listeners = new ArrayList<FirstFrameListener>(this.mFirstFrameListeners);
        for (FirstFrameListener listener : listeners) {
            listener.onFirstFrame();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        PlatformViewsController platformViewsController = this.getPluginRegistry().getPlatformViewsController();
        this.mAccessibilityNodeProvider = new AccessibilityBridge((View)this, new AccessibilityChannel(this.dartExecutor, this.getFlutterNativeView().getFlutterJNI()), (AccessibilityManager)this.getContext().getSystemService("accessibility"), this.getContext().getContentResolver(), platformViewsController);
        this.mAccessibilityNodeProvider.setOnAccessibilityChangeListener(this.onAccessibilityChangeListener);
        this.resetWillNotDraw(this.mAccessibilityNodeProvider.isAccessibilityEnabled(), this.mAccessibilityNodeProvider.isTouchExplorationEnabled());
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.releaseAccessibilityNodeProvider();
    }

    private void resetWillNotDraw(boolean isAccessibilityEnabled, boolean isTouchExplorationEnabled) {
        if (!this.mIsSoftwareRenderingEnabled) {
            this.setWillNotDraw(!isAccessibilityEnabled && !isTouchExplorationEnabled);
        } else {
            this.setWillNotDraw(false);
        }
    }

    public AccessibilityNodeProvider getAccessibilityNodeProvider() {
        if (this.mAccessibilityNodeProvider != null && this.mAccessibilityNodeProvider.isAccessibilityEnabled()) {
            return this.mAccessibilityNodeProvider;
        }
        return null;
    }

    private void releaseAccessibilityNodeProvider() {
        if (this.mAccessibilityNodeProvider != null) {
            this.mAccessibilityNodeProvider.release();
            this.mAccessibilityNodeProvider = null;
        }
    }

    @Override
    @TargetApi(value=24)
    @RequiresApi(value=24)
    @NonNull
    public PointerIcon getSystemPointerIcon(int type) {
        return PointerIcon.getSystemIcon((Context)this.getContext(), (int)type);
    }

    @Override
    @UiThread
    public void send(String channel, ByteBuffer message) {
        this.send(channel, message, null);
    }

    @Override
    @UiThread
    public void send(String channel, ByteBuffer message, BinaryMessenger.BinaryReply callback) {
        if (!this.isAttached()) {
            Log.d(TAG, "FlutterView.send called on a detached view, channel=" + channel);
            return;
        }
        this.mNativeView.send(channel, message, callback);
    }

    @Override
    @UiThread
    public void setMessageHandler(String channel, BinaryMessenger.BinaryMessageHandler handler) {
        this.mNativeView.setMessageHandler(channel, handler);
    }

    @Override
    public TextureRegistry.SurfaceTextureEntry createSurfaceTexture() {
        SurfaceTexture surfaceTexture = new SurfaceTexture(0);
        return this.registerSurfaceTexture(surfaceTexture);
    }

    @Override
    public TextureRegistry.SurfaceTextureEntry registerSurfaceTexture(@NonNull SurfaceTexture surfaceTexture) {
        surfaceTexture.detachFromGLContext();
        SurfaceTextureRegistryEntry entry = new SurfaceTextureRegistryEntry(this.nextTextureId.getAndIncrement(), surfaceTexture);
        this.mNativeView.getFlutterJNI().registerTexture(entry.id(), entry.textureWrapper());
        return entry;
    }

    final class SurfaceTextureRegistryEntry
    implements TextureRegistry.SurfaceTextureEntry {
        private final long id;
        private final SurfaceTextureWrapper textureWrapper;
        private boolean released;
        private SurfaceTexture.OnFrameAvailableListener onFrameListener = new SurfaceTexture.OnFrameAvailableListener(){

            public void onFrameAvailable(SurfaceTexture texture) {
                if (SurfaceTextureRegistryEntry.this.released || FlutterView.this.mNativeView == null) {
                    return;
                }
                FlutterView.this.mNativeView.getFlutterJNI().markTextureFrameAvailable(SurfaceTextureRegistryEntry.this.id);
            }
        };

        SurfaceTextureRegistryEntry(long id, SurfaceTexture surfaceTexture) {
            this.id = id;
            this.textureWrapper = new SurfaceTextureWrapper(surfaceTexture);
            if (Build.VERSION.SDK_INT >= 21) {
                this.surfaceTexture().setOnFrameAvailableListener(this.onFrameListener, new Handler());
            } else {
                this.surfaceTexture().setOnFrameAvailableListener(this.onFrameListener);
            }
        }

        public SurfaceTextureWrapper textureWrapper() {
            return this.textureWrapper;
        }

        @Override
        public SurfaceTexture surfaceTexture() {
            return this.textureWrapper.surfaceTexture();
        }

        @Override
        public long id() {
            return this.id;
        }

        @Override
        public void release() {
            if (this.released) {
                return;
            }
            this.released = true;
            this.surfaceTexture().setOnFrameAvailableListener(null);
            this.textureWrapper.release();
            FlutterView.this.mNativeView.getFlutterJNI().unregisterTexture(this.id);
        }
    }

    public static interface FirstFrameListener {
        public void onFirstFrame();
    }

    private static enum ZeroSides {
        NONE,
        LEFT,
        RIGHT,
        BOTH;

    }

    static final class ViewportMetrics {
        float devicePixelRatio = 1.0f;
        int physicalWidth = 0;
        int physicalHeight = 0;
        int physicalViewPaddingTop = 0;
        int physicalViewPaddingRight = 0;
        int physicalViewPaddingBottom = 0;
        int physicalViewPaddingLeft = 0;
        int physicalViewInsetTop = 0;
        int physicalViewInsetRight = 0;
        int physicalViewInsetBottom = 0;
        int physicalViewInsetLeft = 0;
        int systemGestureInsetTop = 0;
        int systemGestureInsetRight = 0;
        int systemGestureInsetBottom = 0;
        int systemGestureInsetLeft = 0;
        int physicalTouchSlop = -1;

        ViewportMetrics() {
        }
    }

    public static interface Provider {
        public FlutterView getFlutterView();
    }
}

