/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import android.view.Choreographer;
import androidx.annotation.NonNull;
import io.flutter.embedding.engine.FlutterJNI;

public class VsyncWaiter {
    private static VsyncWaiter instance;
    private final float fps;
    private final FlutterJNI.AsyncWaitForVsyncDelegate asyncWaitForVsyncDelegate = new FlutterJNI.AsyncWaitForVsyncDelegate(){

        @Override
        public void asyncWaitForVsync(final long cookie) {
            Choreographer.getInstance().postFrameCallback(new Choreographer.FrameCallback(){

                public void doFrame(long frameTimeNanos) {
                    long refreshPeriodNanos = (long)(1.0E9 / (double)VsyncWaiter.this.fps);
                    FlutterJNI.nativeOnVsync(frameTimeNanos, frameTimeNanos + refreshPeriodNanos, cookie);
                }
            });
        }
    };

    @NonNull
    public static VsyncWaiter getInstance(float fps) {
        if (instance == null) {
            instance = new VsyncWaiter(fps);
        }
        return instance;
    }

    private VsyncWaiter(float fps) {
        this.fps = fps;
    }

    public void init() {
        FlutterJNI.setAsyncWaitForVsyncDelegate(this.asyncWaitForVsyncDelegate);
        FlutterJNI.setRefreshRateFPS(this.fps);
    }
}

