/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.dart;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.tracing.Trace;
import io.flutter.Log;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.dart.PlatformMessageHandler;
import io.flutter.embedding.engine.dart.PlatformTaskQueue;
import io.flutter.plugin.common.BinaryMessenger;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;

class DartMessenger
implements BinaryMessenger,
PlatformMessageHandler {
    private static final String TAG = "DartMessenger";
    @NonNull
    private final FlutterJNI flutterJNI;
    @NonNull
    private final ConcurrentHashMap<String, HandlerInfo> messageHandlers;
    @NonNull
    private final Map<Integer, BinaryMessenger.BinaryReply> pendingReplies;
    private int nextReplyId = 1;
    @NonNull
    private final DartMessengerTaskQueue platformTaskQueue = new PlatformTaskQueue();
    @NonNull
    private WeakHashMap<BinaryMessenger.TaskQueue, DartMessengerTaskQueue> createdTaskQueues;
    @NonNull
    private TaskQueueFactory taskQueueFactory;

    DartMessenger(@NonNull FlutterJNI flutterJNI, @NonNull TaskQueueFactory taskQueueFactory) {
        this.flutterJNI = flutterJNI;
        this.messageHandlers = new ConcurrentHashMap();
        this.pendingReplies = new HashMap<Integer, BinaryMessenger.BinaryReply>();
        this.createdTaskQueues = new WeakHashMap();
        this.taskQueueFactory = taskQueueFactory;
    }

    DartMessenger(@NonNull FlutterJNI flutterJNI) {
        this(flutterJNI, new DefaultTaskQueueFactory());
    }

    @Override
    public BinaryMessenger.TaskQueue makeBackgroundTaskQueue() {
        DartMessengerTaskQueue taskQueue = this.taskQueueFactory.makeBackgroundTaskQueue();
        TaskQueueToken token = new TaskQueueToken();
        this.createdTaskQueues.put(token, taskQueue);
        return token;
    }

    @Override
    public void setMessageHandler(@NonNull String channel, @Nullable BinaryMessenger.BinaryMessageHandler handler) {
        this.setMessageHandler(channel, handler, null);
    }

    @Override
    public void setMessageHandler(@NonNull String channel, @Nullable BinaryMessenger.BinaryMessageHandler handler, @Nullable BinaryMessenger.TaskQueue taskQueue) {
        if (handler == null) {
            Log.v(TAG, "Removing handler for channel '" + channel + "'");
            this.messageHandlers.remove(channel);
        } else {
            DartMessengerTaskQueue dartMessengerTaskQueue = null;
            if (taskQueue != null && (dartMessengerTaskQueue = this.createdTaskQueues.get(taskQueue)) == null) {
                throw new IllegalArgumentException("Unrecognized TaskQueue, use BinaryMessenger to create your TaskQueue (ex makeBackgroundTaskQueue).");
            }
            Log.v(TAG, "Setting handler for channel '" + channel + "'");
            this.messageHandlers.put(channel, new HandlerInfo(handler, dartMessengerTaskQueue));
        }
    }

    @Override
    @UiThread
    public void send(@NonNull String channel, @NonNull ByteBuffer message) {
        Log.v(TAG, "Sending message over channel '" + channel + "'");
        this.send(channel, message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(@NonNull String channel, @Nullable ByteBuffer message, @Nullable BinaryMessenger.BinaryReply callback) {
        Trace.beginSection((String)("DartMessenger#send on " + channel));
        Log.v(TAG, "Sending message with callback over channel '" + channel + "'");
        try {
            int replyId = this.nextReplyId++;
            if (callback != null) {
                this.pendingReplies.put(replyId, callback);
            }
            if (message == null) {
                this.flutterJNI.dispatchEmptyPlatformMessage(channel, replyId);
            } else {
                this.flutterJNI.dispatchPlatformMessage(channel, message, message.position(), replyId);
            }
        }
        finally {
            Trace.endSection();
        }
    }

    private void invokeHandler(@Nullable HandlerInfo handlerInfo, @Nullable ByteBuffer message, int replyId) {
        if (handlerInfo != null) {
            try {
                Log.v(TAG, "Deferring to registered handler to process message.");
                handlerInfo.handler.onMessage(message, new Reply(this.flutterJNI, replyId));
            }
            catch (Exception ex) {
                Log.e(TAG, "Uncaught exception in binary message listener", ex);
                this.flutterJNI.invokePlatformMessageEmptyResponseCallback(replyId);
            }
            catch (Error err) {
                DartMessenger.handleError(err);
            }
        } else {
            Log.v(TAG, "No registered handler for message. Responding to Dart with empty reply message.");
            this.flutterJNI.invokePlatformMessageEmptyResponseCallback(replyId);
        }
    }

    @Override
    public void handleMessageFromDart(@NonNull String channel, @Nullable ByteBuffer message, int replyId, long messageData) {
        Log.v(TAG, "Received message from Dart over channel '" + channel + "'");
        HandlerInfo handlerInfo = this.messageHandlers.get(channel);
        DartMessengerTaskQueue taskQueue = handlerInfo != null ? handlerInfo.taskQueue : null;
        Runnable myRunnable = () -> {
            Trace.beginSection((String)("DartMessenger#handleMessageFromDart on " + channel));
            try {
                this.invokeHandler(handlerInfo, message, replyId);
                if (message != null && message.isDirect()) {
                    message.limit(0);
                }
            }
            finally {
                this.flutterJNI.cleanupMessageData(messageData);
                Trace.endSection();
            }
        };
        DartMessengerTaskQueue nonnullTaskQueue = taskQueue == null ? this.platformTaskQueue : taskQueue;
        nonnullTaskQueue.dispatch(myRunnable);
    }

    @Override
    public void handlePlatformMessageResponse(int replyId, @Nullable ByteBuffer reply) {
        Log.v(TAG, "Received message reply from Dart.");
        BinaryMessenger.BinaryReply callback = this.pendingReplies.remove(replyId);
        if (callback != null) {
            try {
                Log.v(TAG, "Invoking registered callback for reply from Dart.");
                callback.reply(reply);
                if (reply != null && reply.isDirect()) {
                    reply.limit(0);
                }
            }
            catch (Exception ex) {
                Log.e(TAG, "Uncaught exception in binary message reply handler", ex);
            }
            catch (Error err) {
                DartMessenger.handleError(err);
            }
        }
    }

    @UiThread
    public int getPendingChannelResponseCount() {
        return this.pendingReplies.size();
    }

    private static void handleError(Error err) {
        Thread currentThread = Thread.currentThread();
        if (currentThread.getUncaughtExceptionHandler() == null) {
            throw err;
        }
        currentThread.getUncaughtExceptionHandler().uncaughtException(currentThread, err);
    }

    static class Reply
    implements BinaryMessenger.BinaryReply {
        @NonNull
        private final FlutterJNI flutterJNI;
        private final int replyId;
        private final AtomicBoolean done = new AtomicBoolean(false);

        Reply(@NonNull FlutterJNI flutterJNI, int replyId) {
            this.flutterJNI = flutterJNI;
            this.replyId = replyId;
        }

        @Override
        public void reply(@Nullable ByteBuffer reply) {
            if (this.done.getAndSet(true)) {
                throw new IllegalStateException("Reply already submitted");
            }
            if (reply == null) {
                this.flutterJNI.invokePlatformMessageEmptyResponseCallback(this.replyId);
            } else {
                this.flutterJNI.invokePlatformMessageResponseCallback(this.replyId, reply, reply.position());
            }
        }
    }

    private static class DefaultTaskQueue
    implements DartMessengerTaskQueue {
        @NonNull
        private final ExecutorService executor;

        DefaultTaskQueue() {
            ThreadFactory threadFactory = runnable -> new Thread(runnable, "DartMessenger.DefaultTaskQueue");
            this.executor = Executors.newSingleThreadExecutor(threadFactory);
        }

        @Override
        public void dispatch(@NonNull Runnable runnable) {
            this.executor.execute(runnable);
        }
    }

    private static class HandlerInfo {
        @NonNull
        public final BinaryMessenger.BinaryMessageHandler handler;
        @Nullable
        public final DartMessengerTaskQueue taskQueue;

        HandlerInfo(@NonNull BinaryMessenger.BinaryMessageHandler handler, @Nullable DartMessengerTaskQueue taskQueue) {
            this.handler = handler;
            this.taskQueue = taskQueue;
        }
    }

    private static class DefaultTaskQueueFactory
    implements TaskQueueFactory {
        private DefaultTaskQueueFactory() {
        }

        @Override
        public DartMessengerTaskQueue makeBackgroundTaskQueue() {
            return new DefaultTaskQueue();
        }
    }

    static interface TaskQueueFactory {
        public DartMessengerTaskQueue makeBackgroundTaskQueue();
    }

    static interface DartMessengerTaskQueue {
        public void dispatch(@NonNull Runnable var1);
    }

    private static class TaskQueueToken
    implements BinaryMessenger.TaskQueue {
        private TaskQueueToken() {
        }
    }
}

