@TestOn('windows')

import 'dart:io';

import 'package:test/test.dart';
import 'package:winmd/winmd.dart';

import '../../tool/projection/interface.dart';

void main() {
  test('Windows Runtime golden', () {
    const type = 'Windows.Foundation.IAsyncInfo';
    final typeDef = MetadataStore.getMetadataForType(type)!;
    final dartClass = InterfaceProjection(typeDef).toString();

    File('test/tool/goldens/IAsyncInfo.comparison')
        .writeAsStringSync(dartClass);
    final golden =
        File('test/tool/goldens/IAsyncInfo.golden').readAsStringSync();
    expect(dartClass, equalsIgnoringWhitespace(golden));
  }, skip: 'Ignoring WinRT tests for now.');

  test('COM golden', () {
    const typeToGenerate =
        'Windows.Win32.Networking.NetworkListManager.INetwork';
    final scope = MetadataStore.getWin32Scope();
    final typeDef = scope.findTypeDef(typeToGenerate)!;

    final dartClass = InterfaceProjection(typeDef).toString();

    File('test/tool/goldens/INetwork.comparison').writeAsStringSync(dartClass);
    final golden = File('test/tool/goldens/INetwork.golden').readAsStringSync();

    expect(dartClass, equalsIgnoringWhitespace(golden));
  });
}
