// Copyright 2014 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file has been automatically generated. Please do not edit it manually.
// To regenerate the file, use:
// dart dev/tools/localization/bin/gen_localizations.dart --overwrite

import 'dart:collection';

import 'package:flutter/material.dart';
import 'package:intl/intl.dart' as intl;

import '../material_localizations.dart';

// The classes defined here encode all of the translations found in the
// `flutter_localizations/lib/src/l10n/*.arb` files.
//
// These classes are constructed by the [getMaterialTranslation] method at the
// bottom of this file, and used by the [_MaterialLocalizationsDelegate.load]
// method defined in `flutter_localizations/lib/src/material_localizations.dart`.

/// The translations for Afrikaans (`af`).
class MaterialLocalizationAf extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Afrikaans.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationAf({
    String localeName = 'af',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Meer oor $applicationName';

  @override
  String get alertDialogLabel => 'Opletberig';

  @override
  String get anteMeridiemAbbreviation => 'vm.';

  @override
  String get backButtonTooltip => 'Terug';

  @override
  String get calendarModeButtonLabel => 'Skakel oor na kalender';

  @override
  String get cancelButtonLabel => 'KANSELLEER';

  @override
  String get closeButtonLabel => 'MAAK TOE';

  @override
  String get closeButtonTooltip => 'Maak toe';

  @override
  String get collapsedIconTapHint => 'Vou uit';

  @override
  String get continueButtonLabel => 'GAAN VOORT';

  @override
  String get copyButtonLabel => 'Kopieer';

  @override
  String get cutButtonLabel => 'Knip';

  @override
  String get dateHelpText => 'dd-mm-jjjj';

  @override
  String get dateInputLabel => 'Voer datum in';

  @override
  String get dateOutOfRangeLabel => 'Buite reeks.';

  @override
  String get datePickerHelpText => 'KIES DATUM';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Einddatum $fullDate';

  @override
  String get dateRangeEndLabel => 'Einddatum';

  @override
  String get dateRangePickerHelpText => 'KIES REEKS';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Begindatum $fullDate';

  @override
  String get dateRangeStartLabel => 'Begindatum';

  @override
  String get dateSeparator => '-';

  @override
  String get deleteButtonTooltip => 'Vee uit';

  @override
  String get dialModeButtonLabel => 'Skakel oor na wyserplaatkiesermodus';

  @override
  String get dialogLabel => 'Dialoog';

  @override
  String get drawerLabel => 'Navigasiekieslys';

  @override
  String get expandedIconTapHint => 'Vou in';

  @override
  String get firstPageTooltip => 'Eerste bladsy';

  @override
  String get hideAccountsLabel => 'Versteek rekeninge';

  @override
  String get inputDateModeButtonLabel => 'Skakel oor na invoer';

  @override
  String get inputTimeModeButtonLabel => 'Skakel oor na teksinvoermodus';

  @override
  String get invalidDateFormatLabel => 'Ongeldige formaat.';

  @override
  String get invalidDateRangeLabel => 'Ongeldige reeks.';

  @override
  String get invalidTimeLabel => "Voer 'n geldige tyd in";

  @override
  String get lastPageTooltip => 'Laaste bladsy';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 lisensie';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount lisensies';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Lisensies';

  @override
  String get modalBarrierDismissLabel => 'Maak toe';

  @override
  String get moreButtonTooltip => 'Nog';

  @override
  String get nextMonthTooltip => 'Volgende maand';

  @override
  String get nextPageTooltip => 'Volgende bladsy';

  @override
  String get okButtonLabel => 'OK';

  @override
  String get openAppDrawerTooltip => 'Maak navigasiekieslys oop';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow van $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow van ongeveer $rowCount';

  @override
  String get pasteButtonLabel => 'Plak';

  @override
  String get popupMenuLabel => 'Opspringkieslys';

  @override
  String get postMeridiemAbbreviation => 'nm.';

  @override
  String get previousMonthTooltip => 'Vorige maand';

  @override
  String get previousPageTooltip => 'Vorige bladsy';

  @override
  String get refreshIndicatorSemanticLabel => 'Herlaai';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 karakter oor';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount karakters oor';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => 'Skuif af';

  @override
  String get reorderItemLeft => 'Skuif na links';

  @override
  String get reorderItemRight => 'Skuif na regs';

  @override
  String get reorderItemToEnd => 'Skuif na die einde';

  @override
  String get reorderItemToStart => 'Skuif na die begin';

  @override
  String get reorderItemUp => 'Skuif op';

  @override
  String get rowsPerPageTitle => 'Rye per bladsy:';

  @override
  String get saveButtonLabel => 'STOOR';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Soek';

  @override
  String get selectAllButtonLabel => 'Kies alles';

  @override
  String get selectYearSemanticsLabel => 'Kies jaar';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 item is gekies';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount items is gekies';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Wys rekeninge';

  @override
  String get showMenuTooltip => 'Wys kieslys';

  @override
  String get signedInLabel => 'Aangemeld';

  @override
  String get tabLabelRaw => r'Oortjie $tabIndex van $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => 'KIES TYD';

  @override
  String get timePickerHourLabel => 'Uur';

  @override
  String get timePickerHourModeAnnouncement => 'Kies ure';

  @override
  String get timePickerInputHelpText => 'VOER TYD IN';

  @override
  String get timePickerMinuteLabel => 'Minuut';

  @override
  String get timePickerMinuteModeAnnouncement => 'Kies minute';

  @override
  String get unspecifiedDate => 'Datum';

  @override
  String get unspecifiedDateRange => 'Datumreeks';

  @override
  String get viewLicensesButtonLabel => 'BEKYK LISENSIES';
}

/// The translations for Amharic (`am`).
class MaterialLocalizationAm extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Amharic.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationAm({
    String localeName = 'am',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'ስለ $applicationName';

  @override
  String get alertDialogLabel => 'ማንቂያ';

  @override
  String get anteMeridiemAbbreviation => 'ጥዋት';

  @override
  String get backButtonTooltip => 'ተመለስ';

  @override
  String get calendarModeButtonLabel => 'ወደ የቀን መቁጠሪያ ቀይር';

  @override
  String get cancelButtonLabel => 'ይቅር';

  @override
  String get closeButtonLabel => 'ዝጋ';

  @override
  String get closeButtonTooltip => 'ዝጋ';

  @override
  String get collapsedIconTapHint => 'ዘርጋ';

  @override
  String get continueButtonLabel => 'ቀጥል';

  @override
  String get copyButtonLabel => 'ቅዳ';

  @override
  String get cutButtonLabel => 'ቁረጥ';

  @override
  String get dateHelpText => 'ወወ/ቀቀ/ዓዓዓዓ';

  @override
  String get dateInputLabel => 'ቀን ያስገቡ';

  @override
  String get dateOutOfRangeLabel => 'ከክልል ውጪ።';

  @override
  String get datePickerHelpText => 'ቀን ይምረጡ';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'የማብቂያ ቀን $fullDate';

  @override
  String get dateRangeEndLabel => 'የመጨረሻ ቀን';

  @override
  String get dateRangePickerHelpText => 'ክልል ይምረጡ';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'የመጀመሪያ ቀን $fullDate';

  @override
  String get dateRangeStartLabel => 'የመጀመሪያ ቀን';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'ሰርዝ';

  @override
  String get dialModeButtonLabel => 'ወደ መደወያ መራጭ ሁነታ ቀይር';

  @override
  String get dialogLabel => 'መገናኛ';

  @override
  String get drawerLabel => 'የዳሰሳ ምናሌ';

  @override
  String get expandedIconTapHint => 'ሰብስብ';

  @override
  String get firstPageTooltip => 'የመጀመሪያው ገጽ';

  @override
  String get hideAccountsLabel => 'መለያዎችን ደብቅ';

  @override
  String get inputDateModeButtonLabel => 'ወደ ግቤት ቀይር';

  @override
  String get inputTimeModeButtonLabel => 'ወደ ጽሑፍ ግቤት ሁነታ ቀይር';

  @override
  String get invalidDateFormatLabel => 'ልክ ያልሆነ ቅርጸት።';

  @override
  String get invalidDateRangeLabel => 'ልክ ያልኾነ ክልል።';

  @override
  String get invalidTimeLabel => 'የሚሠራ ሰዓት ያስገቡ';

  @override
  String get lastPageTooltip => 'የመጨረሻው ገጽ';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 ፈቃድ';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount ፈቃዶች';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'ፈቃዶች';

  @override
  String get modalBarrierDismissLabel => 'አሰናብት';

  @override
  String get moreButtonTooltip => 'ተጨማሪ';

  @override
  String get nextMonthTooltip => 'ቀጣይ ወር';

  @override
  String get nextPageTooltip => 'ቀጣይ ገጽ';

  @override
  String get okButtonLabel => 'እሺ';

  @override
  String get openAppDrawerTooltip => 'የዳሰሳ ምናሌን ክፈት';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow ከ$rowCount ውስጥ';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow ከ$rowCount ያህል ውስጥ';

  @override
  String get pasteButtonLabel => 'ለጥፍ';

  @override
  String get popupMenuLabel => 'የብቅ-ባይ ምናሌ';

  @override
  String get postMeridiemAbbreviation => 'ከሰዓት';

  @override
  String get previousMonthTooltip => 'ቀዳሚ ወር';

  @override
  String get previousPageTooltip => 'ቀዳሚ ገጽ';

  @override
  String get refreshIndicatorSemanticLabel => 'አድስ';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 ቁምፊ ይቀራል';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount ቁምፊዎች ይቀራሉ';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => 'ወደ ታች ውሰድ';

  @override
  String get reorderItemLeft => 'ወደ ግራ ውሰድ';

  @override
  String get reorderItemRight => 'ወደ ቀኝ ውሰድ';

  @override
  String get reorderItemToEnd => 'ወደ መጨረሻ ውሰድ';

  @override
  String get reorderItemToStart => 'ወደ መጀመሪያ ውሰድ';

  @override
  String get reorderItemUp => 'ወደ ላይ ውሰድ';

  @override
  String get rowsPerPageTitle => 'ረድፎች በገጽ፦';

  @override
  String get saveButtonLabel => 'አስቀምጥ';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'ይፈልጉ';

  @override
  String get selectAllButtonLabel => 'ሁሉንም ምረጥ';

  @override
  String get selectYearSemanticsLabel => 'ዓመት ይምረጡ';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 ንጥል ተመርጧል';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount ንጥሎች ተመርጠዋል';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'መለያዎችን አሳይ';

  @override
  String get showMenuTooltip => 'ምናሌን አሳይ';

  @override
  String get signedInLabel => 'በመለያ ገብቷል';

  @override
  String get tabLabelRaw => r'ትር $tabIndex ከ$tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => 'ጊዜ ይምረጡ';

  @override
  String get timePickerHourLabel => 'ሰዓት';

  @override
  String get timePickerHourModeAnnouncement => 'ሰዓታትን ምረጥ';

  @override
  String get timePickerInputHelpText => 'ሰዓት ያስገቡ';

  @override
  String get timePickerMinuteLabel => 'ደቂቃ';

  @override
  String get timePickerMinuteModeAnnouncement => 'ደቂቃዎችን ይምረጡ';

  @override
  String get unspecifiedDate => 'ቀን';

  @override
  String get unspecifiedDateRange => 'የቀኖች ርዝመት';

  @override
  String get viewLicensesButtonLabel => 'ፈቃዶችን ይመልከቱ';
}

/// The translations for Arabic (`ar`).
class MaterialLocalizationAr extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Arabic.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationAr({
    String localeName = 'ar',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'لمحة عن "$applicationName"';

  @override
  String get alertDialogLabel => 'تنبيه';

  @override
  String get anteMeridiemAbbreviation => 'ص';

  @override
  String get backButtonTooltip => 'رجوع';

  @override
  String get calendarModeButtonLabel => 'التبديل إلى التقويم';

  @override
  String get cancelButtonLabel => 'إلغاء';

  @override
  String get closeButtonLabel => 'إغلاق';

  @override
  String get closeButtonTooltip => 'إغلاق';

  @override
  String get collapsedIconTapHint => 'توسيع';

  @override
  String get continueButtonLabel => 'متابعة';

  @override
  String get copyButtonLabel => 'نسخ';

  @override
  String get cutButtonLabel => 'قص';

  @override
  String get dateHelpText => 'yyyy/mm/dd';

  @override
  String get dateInputLabel => 'إدخال التاريخ';

  @override
  String get dateOutOfRangeLabel => 'التاريخ خارج النطاق.';

  @override
  String get datePickerHelpText => 'اختيار التاريخ';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'تاريخ الانتهاء $fullDate';

  @override
  String get dateRangeEndLabel => 'تاريخ الانتهاء';

  @override
  String get dateRangePickerHelpText => 'اختيار النطاق';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'تاريخ البدء $fullDate';

  @override
  String get dateRangeStartLabel => 'تاريخ البدء';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'حذف';

  @override
  String get dialModeButtonLabel => 'التبديل إلى وضع "منتقي قُرص الساعة"';

  @override
  String get dialogLabel => 'مربع حوار';

  @override
  String get drawerLabel => 'قائمة تنقل';

  @override
  String get expandedIconTapHint => 'تصغير';

  @override
  String get firstPageTooltip => 'الصفحة الأولى';

  @override
  String get hideAccountsLabel => 'إخفاء الحسابات';

  @override
  String get inputDateModeButtonLabel => 'التبديل إلى الإدخال';

  @override
  String get inputTimeModeButtonLabel => 'التبديل إلى وضع "إدخال النص"';

  @override
  String get invalidDateFormatLabel => 'التنسيق غير صالح.';

  @override
  String get invalidDateRangeLabel => 'النطاق غير صالح.';

  @override
  String get invalidTimeLabel => 'يُرجى إدخال وقت صالح.';

  @override
  String get lastPageTooltip => 'الصفحة الأخيرة';

  @override
  String? get licensesPackageDetailTextFew => r'$licenseCount تراخيص';

  @override
  String? get licensesPackageDetailTextMany => r'$licenseCount ترخيصًا';

  @override
  String? get licensesPackageDetailTextOne => 'ترخيص واحد';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount ترخيص';

  @override
  String? get licensesPackageDetailTextTwo => r'ترخيصان ($licenseCount)';

  @override
  String? get licensesPackageDetailTextZero => 'ما مِن تراخيص';

  @override
  String get licensesPageTitle => 'التراخيص';

  @override
  String get modalBarrierDismissLabel => 'رفض';

  @override
  String get moreButtonTooltip => 'المزيد';

  @override
  String get nextMonthTooltip => 'الشهر التالي';

  @override
  String get nextPageTooltip => 'الصفحة التالية';

  @override
  String get okButtonLabel => 'حسنًا';

  @override
  String get openAppDrawerTooltip => 'فتح قائمة التنقل';

  @override
  String get pageRowsInfoTitleRaw => r'من $firstRow إلى $lastRow من إجمالي $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'من $firstRow إلى $lastRow من إجمالي $rowCount تقريبًا';

  @override
  String get pasteButtonLabel => 'لصق';

  @override
  String get popupMenuLabel => 'قائمة منبثقة';

  @override
  String get postMeridiemAbbreviation => 'م';

  @override
  String get previousMonthTooltip => 'الشهر السابق';

  @override
  String get previousPageTooltip => 'الصفحة السابقة';

  @override
  String get refreshIndicatorSemanticLabel => 'إعادة تحميل';

  @override
  String? get remainingTextFieldCharacterCountFew => r'$remainingCount أحرف متبقية';

  @override
  String? get remainingTextFieldCharacterCountMany => r'$remainingCount حرفًا متبقيًا';

  @override
  String? get remainingTextFieldCharacterCountOne => 'حرف واحد متبقٍ';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount حرف متبقٍ';

  @override
  String? get remainingTextFieldCharacterCountTwo => r'حرفان ($remainingCount) متبقيان';

  @override
  String? get remainingTextFieldCharacterCountZero => 'لا أحرف متبقية';

  @override
  String get reorderItemDown => 'نقل لأسفل';

  @override
  String get reorderItemLeft => 'نقل لليمين';

  @override
  String get reorderItemRight => 'نقل لليسار';

  @override
  String get reorderItemToEnd => 'نقل إلى نهاية القائمة';

  @override
  String get reorderItemToStart => 'نقل إلى بداية القائمة';

  @override
  String get reorderItemUp => 'نقل لأعلى';

  @override
  String get rowsPerPageTitle => 'عدد الصفوف في الصفحة:';

  @override
  String get saveButtonLabel => 'حفظ';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.tall;

  @override
  String get searchFieldLabel => 'بحث';

  @override
  String get selectAllButtonLabel => 'اختيار الكل';

  @override
  String get selectYearSemanticsLabel => 'اختيار العام';

  @override
  String? get selectedRowCountTitleFew => r'تم اختيار $selectedRowCount عنصر';

  @override
  String? get selectedRowCountTitleMany => r'تم اختيار $selectedRowCount عنصرًا';

  @override
  String? get selectedRowCountTitleOne => 'تم اختيار عنصر واحد';

  @override
  String get selectedRowCountTitleOther => r'تم اختيار $selectedRowCount عنصر';

  @override
  String? get selectedRowCountTitleTwo => r'تم اختيار عنصرين ($selectedRowCount)';

  @override
  String? get selectedRowCountTitleZero => 'لم يتم اختيار أي عنصر';

  @override
  String get showAccountsLabel => 'إظهار الحسابات';

  @override
  String get showMenuTooltip => 'عرض القائمة';

  @override
  String get signedInLabel => 'تم تسجيل الدخول';

  @override
  String get tabLabelRaw => r'علامة التبويب $tabIndex من $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.h_colon_mm_space_a;

  @override
  String get timePickerDialHelpText => 'اختيار الوقت';

  @override
  String get timePickerHourLabel => 'ساعة';

  @override
  String get timePickerHourModeAnnouncement => 'اختيار الساعات';

  @override
  String get timePickerInputHelpText => 'إدخال الوقت';

  @override
  String get timePickerMinuteLabel => 'دقيقة';

  @override
  String get timePickerMinuteModeAnnouncement => 'اختيار الدقائق';

  @override
  String get unspecifiedDate => 'التاريخ';

  @override
  String get unspecifiedDateRange => 'النطاق الزمني';

  @override
  String get viewLicensesButtonLabel => 'الاطّلاع على التراخيص';
}

/// The translations for Assamese (`as`).
class MaterialLocalizationAs extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Assamese.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationAs({
    String localeName = 'as',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationNameৰ বিষয়ে';

  @override
  String get alertDialogLabel => 'সতৰ্কবাৰ্তা';

  @override
  String get anteMeridiemAbbreviation => 'পূৰ্বাহ্ন';

  @override
  String get backButtonTooltip => 'উভতি যাওক';

  @override
  String get calendarModeButtonLabel => 'কেলেণ্ডাৰলৈ সলনি কৰক';

  @override
  String get cancelButtonLabel => 'বাতিল কৰক';

  @override
  String get closeButtonLabel => 'বন্ধ কৰক';

  @override
  String get closeButtonTooltip => 'বন্ধ কৰক';

  @override
  String get collapsedIconTapHint => 'বিস্তাৰ কৰক';

  @override
  String get continueButtonLabel => 'অব্যাহত ৰাখক';

  @override
  String get copyButtonLabel => 'প্ৰতিলিপি কৰক';

  @override
  String get cutButtonLabel => 'কাট কৰক';

  @override
  String get dateHelpText => 'mm/dd/yyyy';

  @override
  String get dateInputLabel => 'তাৰিখটো দিয়ক';

  @override
  String get dateOutOfRangeLabel => 'সীমাৰ বাহিৰত।';

  @override
  String get datePickerHelpText => 'তাৰিখ বাছনি কৰক';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'সমাপ্তিৰ তাৰিখ $fullDate';

  @override
  String get dateRangeEndLabel => 'সমাপ্তিৰ তাৰিখ';

  @override
  String get dateRangePickerHelpText => 'পৰিসৰ বাছনি কৰক';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'আৰম্ভণিৰ তাৰিখ $fullDate';

  @override
  String get dateRangeStartLabel => 'আৰম্ভণিৰ তাৰিখ';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'মচক';

  @override
  String get dialModeButtonLabel => 'ডায়েল বাছনিকৰ্তাৰ ম’ডলৈ সলনি কৰক';

  @override
  String get dialogLabel => "ডায়ল'গ";

  @override
  String get drawerLabel => 'নেভিগেশ্বন মেনু';

  @override
  String get expandedIconTapHint => 'সংকোচন কৰক';

  @override
  String get firstPageTooltip => 'প্রথম পৃষ্ঠা';

  @override
  String get hideAccountsLabel => 'একাউণ্টসমূহ লুকুৱাওক';

  @override
  String get inputDateModeButtonLabel => 'ইনপুটলৈ সলনি কৰক';

  @override
  String get inputTimeModeButtonLabel => 'পাঠ ইনপুটৰ ম’ডলৈ সলনি কৰক';

  @override
  String get invalidDateFormatLabel => 'অমান্য ফৰ্মেট।';

  @override
  String get invalidDateRangeLabel => 'অমান্য পৰিসৰ।';

  @override
  String get invalidTimeLabel => 'এটা মান্য সময় দিয়ক';

  @override
  String get lastPageTooltip => 'অন্তিম পৃষ্ঠা';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '১ খন অনুজ্ঞাপত্ৰ';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount খন অনুজ্ঞাপত্ৰ';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'অনুজ্ঞাপত্ৰসমূহ';

  @override
  String get modalBarrierDismissLabel => 'অগ্ৰাহ্য কৰক';

  @override
  String get moreButtonTooltip => 'অধিক';

  @override
  String get nextMonthTooltip => 'পৰৱৰ্তী মাহ';

  @override
  String get nextPageTooltip => 'পৰৱৰ্তী পৃষ্ঠা';

  @override
  String get okButtonLabel => 'ঠিক আছে';

  @override
  String get openAppDrawerTooltip => 'নেভিগেশ্বন মেনু খোলক';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCountৰ $firstRow–$lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$rowCountৰ $firstRow–$lastRow';

  @override
  String get pasteButtonLabel => "পে'ষ্ট কৰক";

  @override
  String get popupMenuLabel => "প'পআপ মেনু";

  @override
  String get postMeridiemAbbreviation => 'অপৰাহ্ন';

  @override
  String get previousMonthTooltip => 'পূৰ্বৱৰ্তী মাহ';

  @override
  String get previousPageTooltip => 'পূৰ্বৱৰ্তী পৃষ্ঠা';

  @override
  String get refreshIndicatorSemanticLabel => 'ৰিফ্ৰেশ্ব কৰক';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '১টা বর্ণ বাকী আছে';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCountটা বর্ণ বাকী আছে';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => 'তললৈ স্থানান্তৰ কৰক';

  @override
  String get reorderItemLeft => 'বাওঁফাললৈ স্থানান্তৰ কৰক';

  @override
  String get reorderItemRight => 'সোঁফাললৈ স্থানান্তৰ কৰক';

  @override
  String get reorderItemToEnd => 'শেষলৈ স্থানান্তৰ কৰক';

  @override
  String get reorderItemToStart => 'আৰম্ভণিলৈ স্থানান্তৰ কৰক';

  @override
  String get reorderItemUp => 'ওপৰলৈ নিয়ক';

  @override
  String get rowsPerPageTitle => 'প্ৰতিটো পৃষ্ঠাত থকা শাৰী:';

  @override
  String get saveButtonLabel => 'ছেভ কৰক';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'সন্ধান কৰক';

  @override
  String get selectAllButtonLabel => 'সকলো বাছনি কৰক';

  @override
  String get selectYearSemanticsLabel => 'বছৰ বাছনি কৰক';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => "১টা বস্তু বাছনি কৰা হ'ল";

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCountটা বস্তু বাছনি কৰা হ’ল';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'একাউণ্টসমূহ দেখুৱাওক';

  @override
  String get showMenuTooltip => 'মেনুখন দেখুৱাওক';

  @override
  String get signedInLabel => 'ছাইন ইন কৰা হ’ল';

  @override
  String get tabLabelRaw => r'$tabCountৰ $tabIndexটা টেব';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => 'সময় বাছনি কৰক';

  @override
  String get timePickerHourLabel => 'ঘণ্টা';

  @override
  String get timePickerHourModeAnnouncement => 'সময় বাছনি কৰক';

  @override
  String get timePickerInputHelpText => 'সময় দিয়ক';

  @override
  String get timePickerMinuteLabel => 'মিনিট';

  @override
  String get timePickerMinuteModeAnnouncement => 'মিনিট বাছনি কৰক';

  @override
  String get unspecifiedDate => 'তাৰিখ';

  @override
  String get unspecifiedDateRange => 'তাৰিখৰ পৰিসৰ';

  @override
  String get viewLicensesButtonLabel => 'অনুজ্ঞাপত্ৰসমূহ চাওক';
}

/// The translations for Azerbaijani (`az`).
class MaterialLocalizationAz extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Azerbaijani.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationAz({
    String localeName = 'az',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName haqqında';

  @override
  String get alertDialogLabel => 'Bildiriş';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'Geri';

  @override
  String get calendarModeButtonLabel => 'Təqvimə keçin';

  @override
  String get cancelButtonLabel => 'LƏĞV EDİN';

  @override
  String get closeButtonLabel => 'BAĞLAYIN';

  @override
  String get closeButtonTooltip => 'Bağlayın';

  @override
  String get collapsedIconTapHint => 'Genişləndirin';

  @override
  String get continueButtonLabel => 'DAVAM EDİN';

  @override
  String get copyButtonLabel => 'Kopyalayın';

  @override
  String get cutButtonLabel => 'Kəsin';

  @override
  String get dateHelpText => 'aa.gg.iiii';

  @override
  String get dateInputLabel => 'Tarix daxil edin';

  @override
  String get dateOutOfRangeLabel => 'Aralıqdan kənar.';

  @override
  String get datePickerHelpText => 'TARİX SEÇİN';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Bitmə tarixi: $fullDate';

  @override
  String get dateRangeEndLabel => 'Bitmə tarixi';

  @override
  String get dateRangePickerHelpText => 'ARALIQ SEÇİN';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Başlama tarixi: $fullDate';

  @override
  String get dateRangeStartLabel => 'Başlama tarixi';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'Silin';

  @override
  String get dialModeButtonLabel => 'Yığım seçici rejiminə keçin';

  @override
  String get dialogLabel => 'Dialoq';

  @override
  String get drawerLabel => 'Naviqasiya menyusu';

  @override
  String get expandedIconTapHint => 'Yığcamlaşdırın';

  @override
  String get firstPageTooltip => 'Birinci səhifə';

  @override
  String get hideAccountsLabel => 'Hesabları gizlədin';

  @override
  String get inputDateModeButtonLabel => 'Daxiletməyə keçin';

  @override
  String get inputTimeModeButtonLabel => 'Mətn daxiletmə rejiminə keçin';

  @override
  String get invalidDateFormatLabel => 'Yanlış format.';

  @override
  String get invalidDateRangeLabel => 'Yanlış aralıq.';

  @override
  String get invalidTimeLabel => 'Düzgün vaxt daxil edin';

  @override
  String get lastPageTooltip => 'Son səhifə';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 lisenziya';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount lisenziya';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Lisenziyalar';

  @override
  String get modalBarrierDismissLabel => 'İmtina edin';

  @override
  String get moreButtonTooltip => 'Daha çox';

  @override
  String get nextMonthTooltip => 'Növbəti ay';

  @override
  String get nextPageTooltip => 'Növbəti səhifə';

  @override
  String get okButtonLabel => 'OK';

  @override
  String get openAppDrawerTooltip => 'Naviqasiya menyusunu açın';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow/$rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow/ təxminən $rowCount';

  @override
  String get pasteButtonLabel => 'Yerləşdirin';

  @override
  String get popupMenuLabel => 'Popap menyusu';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'Keçən ay';

  @override
  String get previousPageTooltip => 'Əvvəlki səhifə';

  @override
  String get refreshIndicatorSemanticLabel => 'Yeniləyin';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 simvol qalır';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount simvol qalır';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => 'Aşağı köçürün';

  @override
  String get reorderItemLeft => 'Sola köçürün';

  @override
  String get reorderItemRight => 'Sağa köçürün';

  @override
  String get reorderItemToEnd => 'Sona köçürün';

  @override
  String get reorderItemToStart => 'Əvvələ köçürün';

  @override
  String get reorderItemUp => 'Yuxarı köçürün';

  @override
  String get rowsPerPageTitle => 'Hər səhifə üzrə sıra:';

  @override
  String get saveButtonLabel => 'YADDA SAXLAYIN';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Axtarın';

  @override
  String get selectAllButtonLabel => 'Hamısını seçin';

  @override
  String get selectYearSemanticsLabel => 'İl seçin';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 element seçildi';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount element seçildi';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Hesabları göstərin';

  @override
  String get showMenuTooltip => 'Menyunu göstərin';

  @override
  String get signedInLabel => 'Daxil olundu';

  @override
  String get tabLabelRaw => r'$tabIndex/$tabCount tab';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => 'VAXT SEÇİN';

  @override
  String get timePickerHourLabel => 'Saat';

  @override
  String get timePickerHourModeAnnouncement => 'Saat seçin';

  @override
  String get timePickerInputHelpText => 'VAXTI DAXİL EDİN';

  @override
  String get timePickerMinuteLabel => 'Dəqiqə';

  @override
  String get timePickerMinuteModeAnnouncement => 'Dəqiqə seçin';

  @override
  String get unspecifiedDate => 'Tarix';

  @override
  String get unspecifiedDateRange => 'Tarix aralığı';

  @override
  String get viewLicensesButtonLabel => 'LİSENZİYALARA BAXIN';
}

/// The translations for Belarusian (`be`).
class MaterialLocalizationBe extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Belarusian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationBe({
    String localeName = 'be',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Інфармацыя пра праграму "$applicationName"';

  @override
  String get alertDialogLabel => 'Абвестка';

  @override
  String get anteMeridiemAbbreviation => 'раніцы';

  @override
  String get backButtonTooltip => 'Назад';

  @override
  String get calendarModeButtonLabel => 'Пераключыцца на каляндар';

  @override
  String get cancelButtonLabel => 'СКАСАВАЦЬ';

  @override
  String get closeButtonLabel => 'ЗАКРЫЦЬ';

  @override
  String get closeButtonTooltip => 'Закрыць';

  @override
  String get collapsedIconTapHint => 'Разгарнуць';

  @override
  String get continueButtonLabel => 'ПРАЦЯГНУЦЬ';

  @override
  String get copyButtonLabel => 'Капіраваць';

  @override
  String get cutButtonLabel => 'Выразаць';

  @override
  String get dateHelpText => 'дд.мм.гггг';

  @override
  String get dateInputLabel => 'Увядзіце дату';

  @override
  String get dateOutOfRangeLabel => 'Па-за межамі дыяпазону.';

  @override
  String get datePickerHelpText => 'ВЫБАР ДАТЫ';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Дата заканчэння: $fullDate';

  @override
  String get dateRangeEndLabel => 'Дата заканчэння';

  @override
  String get dateRangePickerHelpText => 'ВЫБАР ДЫЯПАЗОНУ';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Дата пачатку: $fullDate';

  @override
  String get dateRangeStartLabel => 'Дата пачатку';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'Выдаліць';

  @override
  String get dialModeButtonLabel => 'Пераход у рэжым выбару часу';

  @override
  String get dialogLabel => 'Дыялогавае акно';

  @override
  String get drawerLabel => 'Меню навігацыі';

  @override
  String get expandedIconTapHint => 'Згарнуць';

  @override
  String get firstPageTooltip => 'На першую старонку';

  @override
  String get hideAccountsLabel => 'Схаваць уліковыя запісы';

  @override
  String get inputDateModeButtonLabel => 'Пераключыцца на ўвод тэксту';

  @override
  String get inputTimeModeButtonLabel => 'Пераход у рэжым уводу тэксту';

  @override
  String get invalidDateFormatLabel => 'Няправільны фармат.';

  @override
  String get invalidDateRangeLabel => 'Няправільны дыяпазон.';

  @override
  String get invalidTimeLabel => 'Увядзіце дапушчальны час';

  @override
  String get lastPageTooltip => 'На апошнюю старонку';

  @override
  String? get licensesPackageDetailTextFew => r'$licenseCount ліцэнзіі';

  @override
  String? get licensesPackageDetailTextMany => r'$licenseCount ліцэнзій';

  @override
  String? get licensesPackageDetailTextOne => '1 ліцэнзія';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount ліцэнзіі';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Ліцэнзіі';

  @override
  String get modalBarrierDismissLabel => 'Адхіліць';

  @override
  String get moreButtonTooltip => 'Яшчэ';

  @override
  String get nextMonthTooltip => 'Наступны месяц';

  @override
  String get nextPageTooltip => 'Наступная старонка';

  @override
  String get okButtonLabel => 'ОК';

  @override
  String get openAppDrawerTooltip => 'Адкрыць меню навігацыі';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow з $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow з прыблізна $rowCount';

  @override
  String get pasteButtonLabel => 'Уставіць';

  @override
  String get popupMenuLabel => 'Меню ўсплывальнага акна';

  @override
  String get postMeridiemAbbreviation => 'вечара';

  @override
  String get previousMonthTooltip => 'Папярэдні месяц';

  @override
  String get previousPageTooltip => 'Папярэдняя старонка';

  @override
  String get refreshIndicatorSemanticLabel => 'Абнавіць';

  @override
  String? get remainingTextFieldCharacterCountFew => r'Засталося $remainingCount сімвалы';

  @override
  String? get remainingTextFieldCharacterCountMany => r'Засталося $remainingCount сімвалаў';

  @override
  String? get remainingTextFieldCharacterCountOne => 'Застаўся 1 сімвал';

  @override
  String get remainingTextFieldCharacterCountOther => r'Засталося $remainingCount сімвала';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => 'Перамясціць уніз';

  @override
  String get reorderItemLeft => 'Перамясціць улева';

  @override
  String get reorderItemRight => 'Перамясціць управа';

  @override
  String get reorderItemToEnd => 'Перамясціць у канец';

  @override
  String get reorderItemToStart => 'Перамясціць у пачатак';

  @override
  String get reorderItemUp => 'Перамясціць уверх';

  @override
  String get rowsPerPageTitle => 'Радкоў на старонку:';

  @override
  String get saveButtonLabel => 'ЗАХАВАЦЬ';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Пошук';

  @override
  String get selectAllButtonLabel => 'Выбраць усе';

  @override
  String get selectYearSemanticsLabel => 'Выберыце год';

  @override
  String? get selectedRowCountTitleFew => r'Выбрана $selectedRowCount элементы';

  @override
  String? get selectedRowCountTitleMany => r'Выбрана $selectedRowCount элементаў';

  @override
  String? get selectedRowCountTitleOne => 'Выбраны 1 элемент';

  @override
  String get selectedRowCountTitleOther => r'Выбрана $selectedRowCount элемента';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Паказаць уліковыя запісы';

  @override
  String get showMenuTooltip => 'Паказаць меню';

  @override
  String get signedInLabel => 'Уваход выкананы';

  @override
  String get tabLabelRaw => r'Укладка $tabIndex з $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => 'ВЫБЕРЫЦЕ ЧАС';

  @override
  String get timePickerHourLabel => 'Гадзіна';

  @override
  String get timePickerHourModeAnnouncement => 'Выберыце гадзіны';

  @override
  String get timePickerInputHelpText => 'УВЯДЗІЦЕ ЧАС';

  @override
  String get timePickerMinuteLabel => 'Хвіліна';

  @override
  String get timePickerMinuteModeAnnouncement => 'Выберыце хвіліны';

  @override
  String get unspecifiedDate => 'Дата';

  @override
  String get unspecifiedDateRange => 'Дыяпазон дат';

  @override
  String get viewLicensesButtonLabel => 'ПАКАЗАЦЬ ЛІЦЭНЗІІ';
}

/// The translations for Bulgarian (`bg`).
class MaterialLocalizationBg extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Bulgarian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationBg({
    String localeName = 'bg',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Всичко за $applicationName';

  @override
  String get alertDialogLabel => 'Сигнал';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'Назад';

  @override
  String get calendarModeButtonLabel => 'Превключване към календара';

  @override
  String get cancelButtonLabel => 'ОТКАЗ';

  @override
  String get closeButtonLabel => 'ЗАТВАРЯНЕ';

  @override
  String get closeButtonTooltip => 'Затваряне';

  @override
  String get collapsedIconTapHint => 'Разгъване';

  @override
  String get continueButtonLabel => 'НАПРЕД';

  @override
  String get copyButtonLabel => 'Копиране';

  @override
  String get cutButtonLabel => 'Изрязване';

  @override
  String get dateHelpText => 'дд.мм.гггг';

  @override
  String get dateInputLabel => 'Въвеждане на дата';

  @override
  String get dateOutOfRangeLabel => 'Извън валидния период от време.';

  @override
  String get datePickerHelpText => 'ИЗБИРАНЕ НА ДАТА';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Крайна дата: $fullDate';

  @override
  String get dateRangeEndLabel => 'Крайна дата';

  @override
  String get dateRangePickerHelpText => 'ИЗБИРАНЕ НА ПЕРИОД ОТ ВРЕМЕ';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Начална дата: $fullDate';

  @override
  String get dateRangeStartLabel => 'Начална дата';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'Изтриване';

  @override
  String get dialModeButtonLabel => 'Превключване към режим за избор на циферблат';

  @override
  String get dialogLabel => 'Диалогов прозорец';

  @override
  String get drawerLabel => 'Меню за навигация';

  @override
  String get expandedIconTapHint => 'Свиване';

  @override
  String get firstPageTooltip => 'Първа страница';

  @override
  String get hideAccountsLabel => 'Скриване на профилите';

  @override
  String get inputDateModeButtonLabel => 'Превключване към въвеждане';

  @override
  String get inputTimeModeButtonLabel => 'Превключване към режим за въвеждане на текст';

  @override
  String get invalidDateFormatLabel => 'Невалиден формат.';

  @override
  String get invalidDateRangeLabel => 'Невалиден период от време.';

  @override
  String get invalidTimeLabel => 'Въведете валиден час';

  @override
  String get lastPageTooltip => 'Последна страница';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 лиценз';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount лиценза';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Лицензи';

  @override
  String get modalBarrierDismissLabel => 'Отхвърляне';

  @override
  String get moreButtonTooltip => 'Още';

  @override
  String get nextMonthTooltip => 'Следващият месец';

  @override
  String get nextPageTooltip => 'Следващата страница';

  @override
  String get okButtonLabel => 'OK';

  @override
  String get openAppDrawerTooltip => 'Отваряне на менюто за навигация';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow – $lastRow от $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow – $lastRow от около $rowCount';

  @override
  String get pasteButtonLabel => 'Поставяне';

  @override
  String get popupMenuLabel => 'Изскачащо меню';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'Предишният месец';

  @override
  String get previousPageTooltip => 'Предишната страница';

  @override
  String get refreshIndicatorSemanticLabel => 'Опресняване';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => 'Остава 1 знак';

  @override
  String get remainingTextFieldCharacterCountOther => r'Остават $remainingCount знака';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Преместване надолу';

  @override
  String get reorderItemLeft => 'Преместване наляво';

  @override
  String get reorderItemRight => 'Преместване надясно';

  @override
  String get reorderItemToEnd => 'Преместване в края';

  @override
  String get reorderItemToStart => 'Преместване в началото';

  @override
  String get reorderItemUp => 'Преместване нагоре';

  @override
  String get rowsPerPageTitle => 'Редове на страница:';

  @override
  String get saveButtonLabel => 'ЗАПАЗВАНЕ';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Търсене';

  @override
  String get selectAllButtonLabel => 'Избиране на всички';

  @override
  String get selectYearSemanticsLabel => 'Избиране на година';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => 'Избран е 1 елемент';

  @override
  String get selectedRowCountTitleOther => r'Избрани са $selectedRowCount елемента';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Показване на профилите';

  @override
  String get showMenuTooltip => 'Показване на менюто';

  @override
  String get signedInLabel => 'В профила си сте';

  @override
  String get tabLabelRaw => r'Раздел $tabIndex от $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'ИЗБЕРЕТЕ ЧАС';

  @override
  String get timePickerHourLabel => 'Час';

  @override
  String get timePickerHourModeAnnouncement => 'Избиране на часове';

  @override
  String get timePickerInputHelpText => 'ВЪВЕДЕТЕ ЧАС';

  @override
  String get timePickerMinuteLabel => 'Минута';

  @override
  String get timePickerMinuteModeAnnouncement => 'Избиране на минути';

  @override
  String get unspecifiedDate => 'Дата';

  @override
  String get unspecifiedDateRange => 'Период от време';

  @override
  String get viewLicensesButtonLabel => 'ПРЕГЛЕД НА ЛИЦЕНЗИТЕ';
}

/// The translations for Bengali Bangla (`bn`).
class MaterialLocalizationBn extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Bengali Bangla.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationBn({
    String localeName = 'bn',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName সম্পর্কে';

  @override
  String get alertDialogLabel => 'সতর্কতা';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'ফিরে যান';

  @override
  String get calendarModeButtonLabel => 'ক্যালেন্ডার মোডে বদল করুন';

  @override
  String get cancelButtonLabel => 'বাতিল করুন';

  @override
  String get closeButtonLabel => 'বন্ধ করুন';

  @override
  String get closeButtonTooltip => 'বন্ধ করুন';

  @override
  String get collapsedIconTapHint => 'বড় করুন';

  @override
  String get continueButtonLabel => 'চালিয়ে যান';

  @override
  String get copyButtonLabel => 'কপি করুন';

  @override
  String get cutButtonLabel => 'কাট করুন';

  @override
  String get dateHelpText => 'dd/mm/yyyy';

  @override
  String get dateInputLabel => 'তারিখ লিখুন';

  @override
  String get dateOutOfRangeLabel => 'তারিখের ব্যাপ্তির বাইরে।';

  @override
  String get datePickerHelpText => 'তারিখ বেছে নিন';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'শেষ হওয়ার তারিখ $fullDate';

  @override
  String get dateRangeEndLabel => 'শেষ হওয়ার তারিখ';

  @override
  String get dateRangePickerHelpText => 'তারিখের ব্যাপ্তি বেছে নিন';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'শুরুর তারিখ $fullDate';

  @override
  String get dateRangeStartLabel => 'শুরুর তারিখ';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'মুছে দিন';

  @override
  String get dialModeButtonLabel => 'ডায়াল বেছে নেওয়ার মোডে পাল্টান';

  @override
  String get dialogLabel => 'ডায়ালগ';

  @override
  String get drawerLabel => 'নেভিগেশান মেনু';

  @override
  String get expandedIconTapHint => 'আড়াল করুন';

  @override
  String get firstPageTooltip => 'প্রথম পৃষ্ঠা';

  @override
  String get hideAccountsLabel => 'অ্যাকাউন্টগুলি লুকান';

  @override
  String get inputDateModeButtonLabel => 'ইনপুট মোডে বদল করুন';

  @override
  String get inputTimeModeButtonLabel => 'টেক্সট ইনপুট মোডে পাল্টান';

  @override
  String get invalidDateFormatLabel => 'ভুল ফর্ম্যাট।';

  @override
  String get invalidDateRangeLabel => 'তারিখ সঠিক নয়।';

  @override
  String get invalidTimeLabel => 'সঠিক সময় লিখুন';

  @override
  String get lastPageTooltip => 'শেষ পৃষ্ঠা';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '১টি লাইসেন্স';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCountটি লাইসেন্স';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'লাইসেন্স';

  @override
  String get modalBarrierDismissLabel => 'খারিজ করুন';

  @override
  String get moreButtonTooltip => 'আরও';

  @override
  String get nextMonthTooltip => 'পরের মাস';

  @override
  String get nextPageTooltip => 'পরের পৃষ্ঠা';

  @override
  String get okButtonLabel => 'ঠিক আছে';

  @override
  String get openAppDrawerTooltip => 'নেভিগেশন মেনু খুলুন';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCountটির মধ্যে $firstRow-$lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'প্রায় $rowCountটির মধ্যে $firstRow-$lastRow নম্বর';

  @override
  String get pasteButtonLabel => 'পেস্ট করুন';

  @override
  String get popupMenuLabel => 'পপ-আপ মেনু';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'আগের মাস';

  @override
  String get previousPageTooltip => 'আগের পৃষ্ঠা';

  @override
  String get refreshIndicatorSemanticLabel => 'রিফ্রেশ করুন';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => 'আর ১টি অক্ষর লেখা যাবে';

  @override
  String get remainingTextFieldCharacterCountOther => r'আর $remainingCountটি অক্ষর লেখা যাবে';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => 'নিচের দিকে সরান';

  @override
  String get reorderItemLeft => 'বাঁদিকে সরান';

  @override
  String get reorderItemRight => 'ডানদিকে সরান';

  @override
  String get reorderItemToEnd => 'একদম শেষের দিকে যান';

  @override
  String get reorderItemToStart => 'চালু করতে সরান';

  @override
  String get reorderItemUp => 'উপরের দিকে সরান';

  @override
  String get rowsPerPageTitle => 'প্রতি পৃষ্ঠায় সারির সংখ্যা:';

  @override
  String get saveButtonLabel => 'সেভ করুন';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.tall;

  @override
  String get searchFieldLabel => 'খুঁজুন';

  @override
  String get selectAllButtonLabel => 'সব বেছে নিন';

  @override
  String get selectYearSemanticsLabel => 'বছর বেছে নিন';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '১টি আইটেম বেছে নেওয়া হয়েছে';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCountটি আইটেম বেছে নেওয়া হয়েছে';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'অ্যাকাউন্টগুলি দেখান';

  @override
  String get showMenuTooltip => 'মেনু দেখান';

  @override
  String get signedInLabel => 'সাইন-ইন করা হয়েছে';

  @override
  String get tabLabelRaw => r'$tabCount-এর মধ্যে $tabIndexটি ট্যাব';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => 'সময় বেছে নিন';

  @override
  String get timePickerHourLabel => 'ঘণ্টা';

  @override
  String get timePickerHourModeAnnouncement => 'ঘণ্টা বেছে নিন';

  @override
  String get timePickerInputHelpText => 'সময় লিখুন';

  @override
  String get timePickerMinuteLabel => 'মিনিট';

  @override
  String get timePickerMinuteModeAnnouncement => 'মিনিট বেছে নিন';

  @override
  String get unspecifiedDate => 'তারিখ';

  @override
  String get unspecifiedDateRange => 'তারিখের ব্যাপ্তি';

  @override
  String get viewLicensesButtonLabel => 'লাইসেন্স দেখুন';
}

/// The translations for Bosnian (`bs`).
class MaterialLocalizationBs extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Bosnian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationBs({
    String localeName = 'bs',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'O aplikaciji $applicationName';

  @override
  String get alertDialogLabel => 'Upozorenje';

  @override
  String get anteMeridiemAbbreviation => 'prijepodne';

  @override
  String get backButtonTooltip => 'Nazad';

  @override
  String get calendarModeButtonLabel => 'Prebacite na kalendar';

  @override
  String get cancelButtonLabel => 'OTKAŽI';

  @override
  String get closeButtonLabel => 'ZATVORI';

  @override
  String get closeButtonTooltip => 'Zatvaranje';

  @override
  String get collapsedIconTapHint => 'Proširi';

  @override
  String get continueButtonLabel => 'NASTAVI';

  @override
  String get copyButtonLabel => 'Kopiraj';

  @override
  String get cutButtonLabel => 'Izreži';

  @override
  String get dateHelpText => 'dd. mm. gggg.';

  @override
  String get dateInputLabel => 'Unesite datum';

  @override
  String get dateOutOfRangeLabel => 'Izvan raspona.';

  @override
  String get datePickerHelpText => 'ODABERITE DATUM';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Datum završetka: $fullDate';

  @override
  String get dateRangeEndLabel => 'Datum završetka';

  @override
  String get dateRangePickerHelpText => 'ODABERITE RASPON';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Datum početka: $fullDate';

  @override
  String get dateRangeStartLabel => 'Datum početka';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'Brisanje';

  @override
  String get dialModeButtonLabel => 'Prebacivanje na način rada alata za biranje';

  @override
  String get dialogLabel => 'Dijaloški okvir';

  @override
  String get drawerLabel => 'Meni za navigaciju';

  @override
  String get expandedIconTapHint => 'Suzi';

  @override
  String get firstPageTooltip => 'Prva stranica';

  @override
  String get hideAccountsLabel => 'Sakrij račune';

  @override
  String get inputDateModeButtonLabel => 'Prebacite na unos teksta';

  @override
  String get inputTimeModeButtonLabel => 'Prebacivanje na način rada unosa teksta';

  @override
  String get invalidDateFormatLabel => 'Nevažeći format.';

  @override
  String get invalidDateRangeLabel => 'Nevažeći raspon.';

  @override
  String get invalidTimeLabel => 'Unesite ispravno vrijeme';

  @override
  String get lastPageTooltip => 'Posljednja stranica';

  @override
  String? get licensesPackageDetailTextFew => r'$licenseCount licence';

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 licenca';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licenci';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Licence';

  @override
  String get modalBarrierDismissLabel => 'Odbaci';

  @override
  String get moreButtonTooltip => 'Više';

  @override
  String get nextMonthTooltip => 'Sljedeći mjesec';

  @override
  String get nextPageTooltip => 'Sljedeća stranica';

  @override
  String get okButtonLabel => 'Uredu';

  @override
  String get openAppDrawerTooltip => 'Otvorite meni za navigaciju';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow od $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow od oko $rowCount';

  @override
  String get pasteButtonLabel => 'Zalijepi';

  @override
  String get popupMenuLabel => 'Skočni meni';

  @override
  String get postMeridiemAbbreviation => 'poslijepodne';

  @override
  String get previousMonthTooltip => 'Prethodni mjesec';

  @override
  String get previousPageTooltip => 'Prethodna stranica';

  @override
  String get refreshIndicatorSemanticLabel => 'Osvježi';

  @override
  String? get remainingTextFieldCharacterCountFew => r'Još $remainingCount znaka';

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => 'Još jedan znak';

  @override
  String get remainingTextFieldCharacterCountOther => r'Još $remainingCount znakova';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Pomjeri nadolje';

  @override
  String get reorderItemLeft => 'Pomjeri lijevo';

  @override
  String get reorderItemRight => 'Pomjeri desno';

  @override
  String get reorderItemToEnd => 'Pomjerite na kraj';

  @override
  String get reorderItemToStart => 'Pomjerite na početak';

  @override
  String get reorderItemUp => 'Pomjeri nagore';

  @override
  String get rowsPerPageTitle => 'Broj redova po stranici:';

  @override
  String get saveButtonLabel => 'SAČUVAJ';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Pretražite';

  @override
  String get selectAllButtonLabel => 'Odaberi sve';

  @override
  String get selectYearSemanticsLabel => 'Odaberite godinu';

  @override
  String? get selectedRowCountTitleFew => r'Odabrane su $selectedRowCount stavke';

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => 'Odabrana je jedna stavka';

  @override
  String get selectedRowCountTitleOther => r'Odabrano je $selectedRowCount stavki';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Prikaži račune';

  @override
  String get showMenuTooltip => 'Prikaži meni';

  @override
  String get signedInLabel => 'Prijavljeni ste';

  @override
  String get tabLabelRaw => r'$tabIndex. kartica od $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'ODABERITE VRIJEME';

  @override
  String get timePickerHourLabel => 'Sat';

  @override
  String get timePickerHourModeAnnouncement => 'Odaberite sat';

  @override
  String get timePickerInputHelpText => 'UNESITE VRIJEME';

  @override
  String get timePickerMinuteLabel => 'Minuta';

  @override
  String get timePickerMinuteModeAnnouncement => 'Odaberite minute';

  @override
  String get unspecifiedDate => 'Datum';

  @override
  String get unspecifiedDateRange => 'Raspon datuma';

  @override
  String get viewLicensesButtonLabel => 'PRIKAŽI LICENCE';
}

/// The translations for Catalan Valencian (`ca`).
class MaterialLocalizationCa extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Catalan Valencian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationCa({
    String localeName = 'ca',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Sobre $applicationName';

  @override
  String get alertDialogLabel => 'Alerta';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'Enrere';

  @override
  String get calendarModeButtonLabel => 'Canvia al calendari';

  @override
  String get cancelButtonLabel => 'CANCEL·LA';

  @override
  String get closeButtonLabel => 'TANCA';

  @override
  String get closeButtonTooltip => 'Tanca';

  @override
  String get collapsedIconTapHint => 'Desplega';

  @override
  String get continueButtonLabel => 'CONTINUA';

  @override
  String get copyButtonLabel => 'Copia';

  @override
  String get cutButtonLabel => 'Retalla';

  @override
  String get dateHelpText => 'mm/dd/aaaa';

  @override
  String get dateInputLabel => 'Introdueix una data';

  @override
  String get dateOutOfRangeLabel => "Fora de l'abast.";

  @override
  String get datePickerHelpText => 'SELECCIONA LA DATA';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Data de finalització $fullDate';

  @override
  String get dateRangeEndLabel => 'Data de finalització';

  @override
  String get dateRangePickerHelpText => "SELECCIONA L'INTERVAL";

  @override
  String get dateRangeStartDateSemanticLabelRaw => r"Data d'inici $fullDate";

  @override
  String get dateRangeStartLabel => "Data d'inici";

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'Suprimeix';

  @override
  String get dialModeButtonLabel => 'Canvia al mode de selector de dial';

  @override
  String get dialogLabel => 'Diàleg';

  @override
  String get drawerLabel => 'Menú de navegació';

  @override
  String get expandedIconTapHint => 'Replega';

  @override
  String get firstPageTooltip => 'Primera pàgina';

  @override
  String get hideAccountsLabel => 'Amaga els comptes';

  @override
  String get inputDateModeButtonLabel => 'Canvia a introducció de text';

  @override
  String get inputTimeModeButtonLabel => "Canvia al mode d'introducció de text";

  @override
  String get invalidDateFormatLabel => 'El format no és vàlid.';

  @override
  String get invalidDateRangeLabel => "L'interval no és vàlid.";

  @override
  String get invalidTimeLabel => 'Introdueix una hora vàlida';

  @override
  String get lastPageTooltip => 'Darrera pàgina';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 llicència';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount llicències';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Llicències';

  @override
  String get modalBarrierDismissLabel => 'Ignora';

  @override
  String get moreButtonTooltip => 'Més';

  @override
  String get nextMonthTooltip => 'Mes següent';

  @override
  String get nextPageTooltip => 'Pàgina següent';

  @override
  String get okButtonLabel => "D'ACORD";

  @override
  String get openAppDrawerTooltip => 'Obre el menú de navegació';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow-$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r"$firstRow-$lastRow d'aproximadament $rowCount";

  @override
  String get pasteButtonLabel => 'Enganxa';

  @override
  String get popupMenuLabel => 'Menú emergent';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'Mes anterior';

  @override
  String get previousPageTooltip => 'Pàgina anterior';

  @override
  String get refreshIndicatorSemanticLabel => 'Actualitza';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => 'Queda 1 caràcter';

  @override
  String get remainingTextFieldCharacterCountOther => r'Queden $remainingCount caràcters';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Mou avall';

  @override
  String get reorderItemLeft => "Mou cap a l'esquerra";

  @override
  String get reorderItemRight => 'Mou cap a la dreta';

  @override
  String get reorderItemToEnd => 'Mou al final';

  @override
  String get reorderItemToStart => 'Mou al principi';

  @override
  String get reorderItemUp => 'Mou amunt';

  @override
  String get rowsPerPageTitle => 'Files per pàgina:';

  @override
  String get saveButtonLabel => 'DESA';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Cerca';

  @override
  String get selectAllButtonLabel => 'Selecciona-ho tot';

  @override
  String get selectYearSemanticsLabel => 'Selecciona un any';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => "S'ha seleccionat 1 element";

  @override
  String get selectedRowCountTitleOther => r"S'han seleccionat $selectedRowCount elements";

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Mostra els comptes';

  @override
  String get showMenuTooltip => 'Mostra el menú';

  @override
  String get signedInLabel => 'Sessió iniciada';

  @override
  String get tabLabelRaw => r'Pestanya $tabIndex de $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => "SELECCIONA L'HORA";

  @override
  String get timePickerHourLabel => 'Hora';

  @override
  String get timePickerHourModeAnnouncement => 'Selecciona les hores';

  @override
  String get timePickerInputHelpText => "INTRODUEIX L'HORA";

  @override
  String get timePickerMinuteLabel => 'Minut';

  @override
  String get timePickerMinuteModeAnnouncement => 'Selecciona els minuts';

  @override
  String get unspecifiedDate => 'Data';

  @override
  String get unspecifiedDateRange => 'Interval de dates';

  @override
  String get viewLicensesButtonLabel => 'MOSTRA LES LLICÈNCIES';
}

/// The translations for Czech (`cs`).
class MaterialLocalizationCs extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Czech.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationCs({
    String localeName = 'cs',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'O aplikaci $applicationName';

  @override
  String get alertDialogLabel => 'Upozornění';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'Zpět';

  @override
  String get calendarModeButtonLabel => 'Přepnout na kalendář';

  @override
  String get cancelButtonLabel => 'ZRUŠIT';

  @override
  String get closeButtonLabel => 'ZAVŘÍT';

  @override
  String get closeButtonTooltip => 'Zavřít';

  @override
  String get collapsedIconTapHint => 'Rozbalit';

  @override
  String get continueButtonLabel => 'POKRAČOVAT';

  @override
  String get copyButtonLabel => 'Kopírovat';

  @override
  String get cutButtonLabel => 'Vyjmout';

  @override
  String get dateHelpText => 'mm.dd.rrrr';

  @override
  String get dateInputLabel => 'Zadejte datum';

  @override
  String get dateOutOfRangeLabel => 'Mimo rozsah.';

  @override
  String get datePickerHelpText => 'VYBERTE DATUM';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Datum ukončení $fullDate';

  @override
  String get dateRangeEndLabel => 'Datum ukončení';

  @override
  String get dateRangePickerHelpText => 'VYBERTE ROZSAH';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Datum zahájení $fullDate';

  @override
  String get dateRangeStartLabel => 'Datum zahájení';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'Smazat';

  @override
  String get dialModeButtonLabel => 'Přepnout na režim výběru času';

  @override
  String get dialogLabel => 'Dialogové okno';

  @override
  String get drawerLabel => 'Navigační nabídka';

  @override
  String get expandedIconTapHint => 'Sbalit';

  @override
  String get firstPageTooltip => 'První stránka';

  @override
  String get hideAccountsLabel => 'Skrýt účty';

  @override
  String get inputDateModeButtonLabel => 'Přepnout na zadávání';

  @override
  String get inputTimeModeButtonLabel => 'Přepnout na režim zadávání textu';

  @override
  String get invalidDateFormatLabel => 'Neplatný formát.';

  @override
  String get invalidDateRangeLabel => 'Neplatný rozsah.';

  @override
  String get invalidTimeLabel => 'Zadejte platný čas';

  @override
  String get lastPageTooltip => 'Poslední stránka';

  @override
  String? get licensesPackageDetailTextFew => r'$licenseCount licence';

  @override
  String? get licensesPackageDetailTextMany => r'$licenseCount licence';

  @override
  String? get licensesPackageDetailTextOne => '1 licence';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licencí';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Licence';

  @override
  String get modalBarrierDismissLabel => 'Zavřít';

  @override
  String get moreButtonTooltip => 'Více';

  @override
  String get nextMonthTooltip => 'Další měsíc';

  @override
  String get nextPageTooltip => 'Další stránka';

  @override
  String get okButtonLabel => 'OK';

  @override
  String get openAppDrawerTooltip => 'Otevřít navigační nabídku';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow z $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow z asi $rowCount';

  @override
  String get pasteButtonLabel => 'Vložit';

  @override
  String get popupMenuLabel => 'Vyskakovací nabídka';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'Předchozí měsíc';

  @override
  String get previousPageTooltip => 'Předchozí stránka';

  @override
  String get refreshIndicatorSemanticLabel => 'Obnovit';

  @override
  String? get remainingTextFieldCharacterCountFew => r'Zbývají $remainingCount znaky';

  @override
  String? get remainingTextFieldCharacterCountMany => r'Zbývá $remainingCount znaku';

  @override
  String? get remainingTextFieldCharacterCountOne => 'Zbývá 1 znak';

  @override
  String get remainingTextFieldCharacterCountOther => r'Zbývá $remainingCount znaků';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Přesunout dolů';

  @override
  String get reorderItemLeft => 'Přesunout doleva';

  @override
  String get reorderItemRight => 'Přesunout doprava';

  @override
  String get reorderItemToEnd => 'Přesunout na konec';

  @override
  String get reorderItemToStart => 'Přesunout na začátek';

  @override
  String get reorderItemUp => 'Přesunout nahoru';

  @override
  String get rowsPerPageTitle => 'Počet řádků na stránku:';

  @override
  String get saveButtonLabel => 'ULOŽIT';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Hledat';

  @override
  String get selectAllButtonLabel => 'Vybrat vše';

  @override
  String get selectYearSemanticsLabel => 'Vyberte rok';

  @override
  String? get selectedRowCountTitleFew => r'Jsou vybrány $selectedRowCount položky';

  @override
  String? get selectedRowCountTitleMany => r'Je vybráno $selectedRowCount položky';

  @override
  String? get selectedRowCountTitleOne => 'Je vybrána 1 položka';

  @override
  String get selectedRowCountTitleOther => r'Je vybráno $selectedRowCount položek';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Zobrazit účty';

  @override
  String get showMenuTooltip => 'Zobrazit nabídku';

  @override
  String get signedInLabel => 'Uživatel přihlášen';

  @override
  String get tabLabelRaw => r'Karta $tabIndex z $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'VYBERTE ČAS';

  @override
  String get timePickerHourLabel => 'Hodina';

  @override
  String get timePickerHourModeAnnouncement => 'Vyberte hodiny';

  @override
  String get timePickerInputHelpText => 'ZADEJTE ČAS';

  @override
  String get timePickerMinuteLabel => 'Minuta';

  @override
  String get timePickerMinuteModeAnnouncement => 'Vyberte minuty';

  @override
  String get unspecifiedDate => 'Datum';

  @override
  String get unspecifiedDateRange => 'Období';

  @override
  String get viewLicensesButtonLabel => 'ZOBRAZIT LICENCE';
}

/// The translations for Danish (`da`).
class MaterialLocalizationDa extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Danish.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationDa({
    String localeName = 'da',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Om $applicationName';

  @override
  String get alertDialogLabel => 'Underretning';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'Tilbage';

  @override
  String get calendarModeButtonLabel => 'Skift til kalender';

  @override
  String get cancelButtonLabel => 'ANNULLER';

  @override
  String get closeButtonLabel => 'LUK';

  @override
  String get closeButtonTooltip => 'Luk';

  @override
  String get collapsedIconTapHint => 'Udvid';

  @override
  String get continueButtonLabel => 'FORTSÆT';

  @override
  String get copyButtonLabel => 'Kopiér';

  @override
  String get cutButtonLabel => 'Klip';

  @override
  String get dateHelpText => 'dd/mm/åååå';

  @override
  String get dateInputLabel => 'Angiv en dato';

  @override
  String get dateOutOfRangeLabel => 'Uden for rækkevidde.';

  @override
  String get datePickerHelpText => 'VÆLG DATO';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Slutdato $fullDate';

  @override
  String get dateRangeEndLabel => 'Slutdato';

  @override
  String get dateRangePickerHelpText => 'VÆLG OMRÅDE';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Startdato $fullDate';

  @override
  String get dateRangeStartLabel => 'Startdato';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'Slet';

  @override
  String get dialModeButtonLabel => 'Skift til urskivevælger';

  @override
  String get dialogLabel => 'Dialogboks';

  @override
  String get drawerLabel => 'Navigationsmenu';

  @override
  String get expandedIconTapHint => 'Skjul';

  @override
  String get firstPageTooltip => 'Første side';

  @override
  String get hideAccountsLabel => 'Skjul konti';

  @override
  String get inputDateModeButtonLabel => 'Skift til input';

  @override
  String get inputTimeModeButtonLabel => 'Skift til indtastning';

  @override
  String get invalidDateFormatLabel => 'Ugyldigt format.';

  @override
  String get invalidDateRangeLabel => 'Ugyldigt interval.';

  @override
  String get invalidTimeLabel => 'Angiv et gyldigt tidspunkt';

  @override
  String get lastPageTooltip => 'Sidste side';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 licens';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licenser';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Licenser';

  @override
  String get modalBarrierDismissLabel => 'Afvis';

  @override
  String get moreButtonTooltip => 'Mere';

  @override
  String get nextMonthTooltip => 'Næste måned';

  @override
  String get nextPageTooltip => 'Næste side';

  @override
  String get okButtonLabel => 'OK';

  @override
  String get openAppDrawerTooltip => 'Åbn navigationsmenuen';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow-$lastRow af $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow-$lastRow af ca. $rowCount';

  @override
  String get pasteButtonLabel => 'Indsæt';

  @override
  String get popupMenuLabel => 'Pop op-menu';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'Forrige måned';

  @override
  String get previousPageTooltip => 'Forrige side';

  @override
  String get refreshIndicatorSemanticLabel => 'Opdater';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => 'Ét tegn tilbage';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount tegn tilbage';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Flyt ned';

  @override
  String get reorderItemLeft => 'Flyt til venstre';

  @override
  String get reorderItemRight => 'Flyt til højre';

  @override
  String get reorderItemToEnd => 'Flyt til sidst på listen';

  @override
  String get reorderItemToStart => 'Flyt til først på listen';

  @override
  String get reorderItemUp => 'Flyt op';

  @override
  String get rowsPerPageTitle => 'Rækker pr. side:';

  @override
  String get saveButtonLabel => 'GEM';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Søg';

  @override
  String get selectAllButtonLabel => 'Markér alt';

  @override
  String get selectYearSemanticsLabel => 'Vælg år';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 element er valgt';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount elementer er valgt';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Vis konti';

  @override
  String get showMenuTooltip => 'Vis menu';

  @override
  String get signedInLabel => 'Logget ind';

  @override
  String get tabLabelRaw => r'Fane $tabIndex af $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'VÆLG TIDSPUNKT';

  @override
  String get timePickerHourLabel => 'Time';

  @override
  String get timePickerHourModeAnnouncement => 'Vælg timer';

  @override
  String get timePickerInputHelpText => 'ANGIV TIDSPUNKT';

  @override
  String get timePickerMinuteLabel => 'Minut';

  @override
  String get timePickerMinuteModeAnnouncement => 'Vælg minutter';

  @override
  String get unspecifiedDate => 'Dato';

  @override
  String get unspecifiedDateRange => 'Datointerval';

  @override
  String get viewLicensesButtonLabel => 'SE LICENSER';
}

/// The translations for German (`de`).
class MaterialLocalizationDe extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for German.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationDe({
    String localeName = 'de',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Über $applicationName';

  @override
  String get alertDialogLabel => 'Benachrichtigung';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'Zurück';

  @override
  String get calendarModeButtonLabel => 'Zum Kalender wechseln';

  @override
  String get cancelButtonLabel => 'ABBRECHEN';

  @override
  String get closeButtonLabel => 'SCHLIEẞEN';

  @override
  String get closeButtonTooltip => 'Schließen';

  @override
  String get collapsedIconTapHint => 'Maximieren';

  @override
  String get continueButtonLabel => 'WEITER';

  @override
  String get copyButtonLabel => 'Kopieren';

  @override
  String get cutButtonLabel => 'Ausschneiden';

  @override
  String get dateHelpText => 'tt.mm.jjjj';

  @override
  String get dateInputLabel => 'Datum eingeben';

  @override
  String get dateOutOfRangeLabel => 'Außerhalb des Zeitraums.';

  @override
  String get datePickerHelpText => 'DATUM AUSWÄHLEN';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Enddatum $fullDate';

  @override
  String get dateRangeEndLabel => 'Enddatum';

  @override
  String get dateRangePickerHelpText => 'ZEITRAUM AUSWÄHLEN';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Startdatum $fullDate';

  @override
  String get dateRangeStartLabel => 'Startdatum';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'Löschen';

  @override
  String get dialModeButtonLabel => 'Zur Uhrzeitauswahl wechseln';

  @override
  String get dialogLabel => 'Dialogfeld';

  @override
  String get drawerLabel => 'Navigationsmenü';

  @override
  String get expandedIconTapHint => 'Minimieren';

  @override
  String get firstPageTooltip => 'Erste Seite';

  @override
  String get hideAccountsLabel => 'Konten ausblenden';

  @override
  String get inputDateModeButtonLabel => 'Zur Texteingabe wechseln';

  @override
  String get inputTimeModeButtonLabel => 'Zum Texteingabemodus wechseln';

  @override
  String get invalidDateFormatLabel => 'Ungültiges Format.';

  @override
  String get invalidDateRangeLabel => 'Ungültiger Zeitraum.';

  @override
  String get invalidTimeLabel => 'Geben Sie eine gültige Uhrzeit ein';

  @override
  String get lastPageTooltip => 'Letzte Seite';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 Lizenz';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount Lizenzen';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Lizenzen';

  @override
  String get modalBarrierDismissLabel => 'Schließen';

  @override
  String get moreButtonTooltip => 'Mehr';

  @override
  String get nextMonthTooltip => 'Nächster Monat';

  @override
  String get nextPageTooltip => 'Nächste Seite';

  @override
  String get okButtonLabel => 'OK';

  @override
  String get openAppDrawerTooltip => 'Navigationsmenü öffnen';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow von $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow von etwa $rowCount';

  @override
  String get pasteButtonLabel => 'Einsetzen';

  @override
  String get popupMenuLabel => 'Pop-up-Menü';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'Vorheriger Monat';

  @override
  String get previousPageTooltip => 'Vorherige Seite';

  @override
  String get refreshIndicatorSemanticLabel => 'Aktualisieren';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => 'Noch 1 Zeichen';

  @override
  String get remainingTextFieldCharacterCountOther => r'Noch $remainingCount Zeichen';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Nach unten verschieben';

  @override
  String get reorderItemLeft => 'Nach links verschieben';

  @override
  String get reorderItemRight => 'Nach rechts verschieben';

  @override
  String get reorderItemToEnd => 'An das Ende verschieben';

  @override
  String get reorderItemToStart => 'An den Anfang verschieben';

  @override
  String get reorderItemUp => 'Nach oben verschieben';

  @override
  String get rowsPerPageTitle => 'Zeilen pro Seite:';

  @override
  String get saveButtonLabel => 'SPEICHERN';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Suchen';

  @override
  String get selectAllButtonLabel => 'Alle auswählen';

  @override
  String get selectYearSemanticsLabel => 'Jahr auswählen';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 Element ausgewählt';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount Elemente ausgewählt';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => 'Keine Objekte ausgewählt';

  @override
  String get showAccountsLabel => 'Konten anzeigen';

  @override
  String get showMenuTooltip => 'Menü anzeigen';

  @override
  String get signedInLabel => 'Angemeldet';

  @override
  String get tabLabelRaw => r'Tab $tabIndex von $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'UHRZEIT AUSWÄHLEN';

  @override
  String get timePickerHourLabel => 'Stunde';

  @override
  String get timePickerHourModeAnnouncement => 'Stunden auswählen';

  @override
  String get timePickerInputHelpText => 'ZEIT EINGEBEN';

  @override
  String get timePickerMinuteLabel => 'Minute';

  @override
  String get timePickerMinuteModeAnnouncement => 'Minuten auswählen';

  @override
  String get unspecifiedDate => 'Datum';

  @override
  String get unspecifiedDateRange => 'Zeitraum';

  @override
  String get viewLicensesButtonLabel => 'LIZENZEN ANZEIGEN';
}

/// The translations for German, as used in Switzerland (`de_CH`).
class MaterialLocalizationDeCh extends MaterialLocalizationDe {
  /// Create an instance of the translation bundle for German, as used in Switzerland.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationDeCh({
    String localeName = 'de_CH',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get invalidTimeLabel => 'Gib eine gültige Uhrzeit ein';

  @override
  String get dateOutOfRangeLabel => 'Ausserhalb des Zeitraums.';

  @override
  String get closeButtonTooltip => 'Schliessen';

  @override
  String get firstPageTooltip => 'First page';

  @override
  String get lastPageTooltip => 'Last page';

  @override
  String get modalBarrierDismissLabel => 'Schliessen';
}

/// The translations for Modern Greek (`el`).
class MaterialLocalizationEl extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Modern Greek.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEl({
    String localeName = 'el',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Σχετικά με την εφαρμογή $applicationName';

  @override
  String get alertDialogLabel => 'Ειδοποίηση';

  @override
  String get anteMeridiemAbbreviation => 'π.μ.';

  @override
  String get backButtonTooltip => 'Πίσω';

  @override
  String get calendarModeButtonLabel => 'Εναλλαγή σε ημερολόγιο';

  @override
  String get cancelButtonLabel => 'ΑΚΥΡΩΣΗ';

  @override
  String get closeButtonLabel => 'ΚΛΕΙΣΙΜΟ';

  @override
  String get closeButtonTooltip => 'Κλείσιμο';

  @override
  String get collapsedIconTapHint => 'Ανάπτυξη';

  @override
  String get continueButtonLabel => 'ΣΥΝΕΧΕΙΑ';

  @override
  String get copyButtonLabel => 'Αντιγραφή';

  @override
  String get cutButtonLabel => 'Αποκοπή';

  @override
  String get dateHelpText => 'μμ/ηη/εεεε';

  @override
  String get dateInputLabel => 'Εισαγωγή ημερομηνίας';

  @override
  String get dateOutOfRangeLabel => 'Εκτός εύρους τιμών.';

  @override
  String get datePickerHelpText => 'ΕΠΙΛΟΓΗ ΗΜΕΡΟΜΗΝΙΑΣ';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Ημερομηνία λήξης $fullDate';

  @override
  String get dateRangeEndLabel => 'Ημερομηνία λήξης';

  @override
  String get dateRangePickerHelpText => 'ΕΠΙΛΟΓΗ ΕΥΡΟΥΣ';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Ημερομηνία έναρξης $fullDate';

  @override
  String get dateRangeStartLabel => 'Ημερομηνία έναρξης';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'Διαγραφή';

  @override
  String get dialModeButtonLabel => 'Εναλλαγή στη λειτουργία επιλογέα κλήσης';

  @override
  String get dialogLabel => 'Παράθυρο διαλόγου';

  @override
  String get drawerLabel => 'Μενού πλοήγησης';

  @override
  String get expandedIconTapHint => 'Σύμπτυξη';

  @override
  String get firstPageTooltip => 'Πρώτη σελίδα';

  @override
  String get hideAccountsLabel => 'Απόκρυψη λογαριασμών';

  @override
  String get inputDateModeButtonLabel => 'Εναλλαγή σε καταχώριση';

  @override
  String get inputTimeModeButtonLabel => 'Εναλλαγή στη λειτουργία εισαγωγής κειμένου';

  @override
  String get invalidDateFormatLabel => 'Μη έγκυρη μορφή.';

  @override
  String get invalidDateRangeLabel => 'Μη έγκυρο εύρος.';

  @override
  String get invalidTimeLabel => 'Εισαγάγετε μια έγκυρη ώρα';

  @override
  String get lastPageTooltip => 'Τελευταία σελίδα';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 άδεια';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount άδειες';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Άδειες';

  @override
  String get modalBarrierDismissLabel => 'Παράβλεψη';

  @override
  String get moreButtonTooltip => 'Περισσότερα';

  @override
  String get nextMonthTooltip => 'Επόμενος μήνας';

  @override
  String get nextPageTooltip => 'Επόμενη σελίδα';

  @override
  String get okButtonLabel => 'ΟΚ';

  @override
  String get openAppDrawerTooltip => 'Άνοιγμα μενού πλοήγησης';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow-$lastRow από $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow-$lastRow από περίπου $rowCount';

  @override
  String get pasteButtonLabel => 'Επικόλληση';

  @override
  String get popupMenuLabel => 'Αναδυόμενο μενού';

  @override
  String get postMeridiemAbbreviation => 'μ.μ.';

  @override
  String get previousMonthTooltip => 'Προηγούμενος μήνας';

  @override
  String get previousPageTooltip => 'Προηγούμενη σελίδα';

  @override
  String get refreshIndicatorSemanticLabel => 'Ανανέωση';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => 'απομένει 1 χαρακτήρας';

  @override
  String get remainingTextFieldCharacterCountOther => r'απομένουν $remainingCount χαρακτήρες';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Μετακίνηση προς τα κάτω';

  @override
  String get reorderItemLeft => 'Μετακίνηση αριστερά';

  @override
  String get reorderItemRight => 'Μετακίνηση δεξιά';

  @override
  String get reorderItemToEnd => 'Μετακίνηση στο τέλος';

  @override
  String get reorderItemToStart => 'Μετακίνηση στην αρχή';

  @override
  String get reorderItemUp => 'Μετακίνηση προς τα πάνω';

  @override
  String get rowsPerPageTitle => 'Σειρές ανά σελίδα:';

  @override
  String get saveButtonLabel => 'ΑΠΟΘΗΚΕΥΣΗ';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Αναζήτηση';

  @override
  String get selectAllButtonLabel => 'Επιλογή όλων';

  @override
  String get selectYearSemanticsLabel => 'Επιλογή έτους';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => 'Επιλέχθηκε 1 στοιχείο';

  @override
  String get selectedRowCountTitleOther => r'Επιλέχθηκαν $selectedRowCount στοιχεία';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Εμφάνιση λογαριασμών';

  @override
  String get showMenuTooltip => 'Εμφάνιση μενού';

  @override
  String get signedInLabel => 'Σε σύνδεση';

  @override
  String get tabLabelRaw => r'Καρτέλα $tabIndex από $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'ΕΠΙΛΟΓΗ ΩΡΑΣ';

  @override
  String get timePickerHourLabel => 'Ώρα';

  @override
  String get timePickerHourModeAnnouncement => 'Επιλογή ωρών';

  @override
  String get timePickerInputHelpText => 'ΕΙΣΑΓΩΓΗ ΩΡΑΣ';

  @override
  String get timePickerMinuteLabel => 'Λεπτό';

  @override
  String get timePickerMinuteModeAnnouncement => 'Επιλογή λεπτών';

  @override
  String get unspecifiedDate => 'Ημερομηνία';

  @override
  String get unspecifiedDateRange => 'Εύρος ημερομηνιών';

  @override
  String get viewLicensesButtonLabel => 'ΠΡΟΒΟΛΗ ΑΔΕΙΩΝ';
}

/// The translations for English (`en`).
class MaterialLocalizationEn extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for English.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEn({
    String localeName = 'en',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'About $applicationName';

  @override
  String get alertDialogLabel => 'Alert';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'Back';

  @override
  String get calendarModeButtonLabel => 'Switch to calendar';

  @override
  String get cancelButtonLabel => 'CANCEL';

  @override
  String get closeButtonLabel => 'CLOSE';

  @override
  String get closeButtonTooltip => 'Close';

  @override
  String get collapsedIconTapHint => 'Expand';

  @override
  String get continueButtonLabel => 'CONTINUE';

  @override
  String get copyButtonLabel => 'Copy';

  @override
  String get cutButtonLabel => 'Cut';

  @override
  String get dateHelpText => 'mm/dd/yyyy';

  @override
  String get dateInputLabel => 'Enter Date';

  @override
  String get dateOutOfRangeLabel => 'Out of range.';

  @override
  String get datePickerHelpText => 'SELECT DATE';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'End date $fullDate';

  @override
  String get dateRangeEndLabel => 'End Date';

  @override
  String get dateRangePickerHelpText => 'SELECT RANGE';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Start date $fullDate';

  @override
  String get dateRangeStartLabel => 'Start Date';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'Delete';

  @override
  String get dialModeButtonLabel => 'Switch to dial picker mode';

  @override
  String get dialogLabel => 'Dialog';

  @override
  String get drawerLabel => 'Navigation menu';

  @override
  String get expandedIconTapHint => 'Collapse';

  @override
  String get firstPageTooltip => 'First page';

  @override
  String get hideAccountsLabel => 'Hide accounts';

  @override
  String get inputDateModeButtonLabel => 'Switch to input';

  @override
  String get inputTimeModeButtonLabel => 'Switch to text input mode';

  @override
  String get invalidDateFormatLabel => 'Invalid format.';

  @override
  String get invalidDateRangeLabel => 'Invalid range.';

  @override
  String get invalidTimeLabel => 'Enter a valid time';

  @override
  String get lastPageTooltip => 'Last page';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 license';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licenses';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Licenses';

  @override
  String get modalBarrierDismissLabel => 'Dismiss';

  @override
  String get moreButtonTooltip => 'More';

  @override
  String get nextMonthTooltip => 'Next month';

  @override
  String get nextPageTooltip => 'Next page';

  @override
  String get okButtonLabel => 'OK';

  @override
  String get openAppDrawerTooltip => 'Open navigation menu';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow of $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow of about $rowCount';

  @override
  String get pasteButtonLabel => 'Paste';

  @override
  String get popupMenuLabel => 'Popup menu';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'Previous month';

  @override
  String get previousPageTooltip => 'Previous page';

  @override
  String get refreshIndicatorSemanticLabel => 'Refresh';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 character remaining';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount characters remaining';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'No characters remaining';

  @override
  String get reorderItemDown => 'Move down';

  @override
  String get reorderItemLeft => 'Move left';

  @override
  String get reorderItemRight => 'Move right';

  @override
  String get reorderItemToEnd => 'Move to the end';

  @override
  String get reorderItemToStart => 'Move to the start';

  @override
  String get reorderItemUp => 'Move up';

  @override
  String get rowsPerPageTitle => 'Rows per page:';

  @override
  String get saveButtonLabel => 'SAVE';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Search';

  @override
  String get selectAllButtonLabel => 'Select all';

  @override
  String get selectYearSemanticsLabel => 'Select year';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 item selected';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount items selected';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => 'No items selected';

  @override
  String get showAccountsLabel => 'Show accounts';

  @override
  String get showMenuTooltip => 'Show menu';

  @override
  String get signedInLabel => 'Signed in';

  @override
  String get tabLabelRaw => r'Tab $tabIndex of $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.h_colon_mm_space_a;

  @override
  String get timePickerDialHelpText => 'SELECT TIME';

  @override
  String get timePickerHourLabel => 'Hour';

  @override
  String get timePickerHourModeAnnouncement => 'Select hours';

  @override
  String get timePickerInputHelpText => 'ENTER TIME';

  @override
  String get timePickerMinuteLabel => 'Minute';

  @override
  String get timePickerMinuteModeAnnouncement => 'Select minutes';

  @override
  String get unspecifiedDate => 'Date';

  @override
  String get unspecifiedDateRange => 'Date Range';

  @override
  String get viewLicensesButtonLabel => 'VIEW LICENSES';
}

/// The translations for English, as used in Australia (`en_AU`).
class MaterialLocalizationEnAu extends MaterialLocalizationEn {
  /// Create an instance of the translation bundle for English, as used in Australia.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEnAu({
    String localeName = 'en_AU',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get dateInputLabel => 'Enter date';

  @override
  String get dateRangeEndLabel => 'End date';

  @override
  String get dateRangeStartLabel => 'Start date';

  @override
  String get unspecifiedDateRange => 'Date range';

  @override
  String get licensesPageTitle => 'Licences';

  @override
  String? get licensesPackageDetailTextZero => 'No licences';

  @override
  String? get licensesPackageDetailTextOne => '1 licence';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licences';

  @override
  String get viewLicensesButtonLabel => 'VIEW LICENCES';

  @override
  String get popupMenuLabel => 'Pop-up menu';

  @override
  String get dialogLabel => 'Dialogue';

  @override
  String get reorderItemLeft => 'Move to the left';

  @override
  String get reorderItemRight => 'Move to the right';
}

/// The translations for English, as used in Canada (`en_CA`).
class MaterialLocalizationEnCa extends MaterialLocalizationEn {
  /// Create an instance of the translation bundle for English, as used in Canada.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEnCa({
    String localeName = 'en_CA',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get dateInputLabel => 'Enter date';

  @override
  String get dateRangeEndLabel => 'End date';

  @override
  String get dateRangeStartLabel => 'Start date';

  @override
  String get unspecifiedDateRange => 'Date range';

  @override
  String get licensesPageTitle => 'Licences';

  @override
  String? get licensesPackageDetailTextZero => 'No licences';

  @override
  String? get licensesPackageDetailTextOne => '1 licence';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licences';

  @override
  String get viewLicensesButtonLabel => 'VIEW LICENCES';

  @override
  String get popupMenuLabel => 'Pop-up menu';

  @override
  String get dialogLabel => 'Dialogue';

  @override
  String get reorderItemLeft => 'Move to the left';

  @override
  String get reorderItemRight => 'Move to the right';
}

/// The translations for English, as used in the United Kingdom (`en_GB`).
class MaterialLocalizationEnGb extends MaterialLocalizationEn {
  /// Create an instance of the translation bundle for English, as used in the United Kingdom.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEnGb({
    String localeName = 'en_GB',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get dateInputLabel => 'Enter date';

  @override
  String get dateRangeEndLabel => 'End date';

  @override
  String get dateRangeStartLabel => 'Start date';

  @override
  String get unspecifiedDateRange => 'Date range';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get viewLicensesButtonLabel => 'VIEW LICENCES';

  @override
  String get licensesPageTitle => 'Licences';

  @override
  String? get licensesPackageDetailTextZero => 'No licences';

  @override
  String? get licensesPackageDetailTextOne => '1 licence';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licences';

  @override
  String get popupMenuLabel => 'Pop-up menu';

  @override
  String get dialogLabel => 'Dialogue';

  @override
  String get reorderItemLeft => 'Move to the left';

  @override
  String get reorderItemRight => 'Move to the right';
}

/// The translations for English, as used in Ireland (`en_IE`).
class MaterialLocalizationEnIe extends MaterialLocalizationEn {
  /// Create an instance of the translation bundle for English, as used in Ireland.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEnIe({
    String localeName = 'en_IE',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get dateInputLabel => 'Enter date';

  @override
  String get dateRangeEndLabel => 'End date';

  @override
  String get dateRangeStartLabel => 'Start date';

  @override
  String get unspecifiedDateRange => 'Date range';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get viewLicensesButtonLabel => 'VIEW LICENCES';

  @override
  String get licensesPageTitle => 'Licences';

  @override
  String? get licensesPackageDetailTextZero => 'No licences';

  @override
  String? get licensesPackageDetailTextOne => '1 licence';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licences';

  @override
  String get popupMenuLabel => 'Pop-up menu';

  @override
  String get dialogLabel => 'Dialogue';

  @override
  String get reorderItemLeft => 'Move to the left';

  @override
  String get reorderItemRight => 'Move to the right';
}

/// The translations for English, as used in India (`en_IN`).
class MaterialLocalizationEnIn extends MaterialLocalizationEn {
  /// Create an instance of the translation bundle for English, as used in India.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEnIn({
    String localeName = 'en_IN',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get dateInputLabel => 'Enter date';

  @override
  String get dateRangeEndLabel => 'End date';

  @override
  String get dateRangeStartLabel => 'Start date';

  @override
  String get unspecifiedDateRange => 'Date range';

  @override
  String get licensesPageTitle => 'Licences';

  @override
  String? get licensesPackageDetailTextZero => 'No licences';

  @override
  String? get licensesPackageDetailTextOne => '1 licence';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licences';

  @override
  String get viewLicensesButtonLabel => 'VIEW LICENCES';

  @override
  String get popupMenuLabel => 'Pop-up menu';

  @override
  String get dialogLabel => 'Dialogue';

  @override
  String get reorderItemLeft => 'Move to the left';

  @override
  String get reorderItemRight => 'Move to the right';
}

/// The translations for English, as used in New Zealand (`en_NZ`).
class MaterialLocalizationEnNz extends MaterialLocalizationEn {
  /// Create an instance of the translation bundle for English, as used in New Zealand.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEnNz({
    String localeName = 'en_NZ',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get dateInputLabel => 'Enter date';

  @override
  String get dateRangeEndLabel => 'End date';

  @override
  String get dateRangeStartLabel => 'Start date';

  @override
  String get unspecifiedDateRange => 'Date range';

  @override
  String get licensesPageTitle => 'Licences';

  @override
  String? get licensesPackageDetailTextZero => 'No licences';

  @override
  String? get licensesPackageDetailTextOne => '1 licence';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licences';

  @override
  String get viewLicensesButtonLabel => 'VIEW LICENCES';

  @override
  String get popupMenuLabel => 'Pop-up menu';

  @override
  String get dialogLabel => 'Dialogue';

  @override
  String get reorderItemLeft => 'Move to the left';

  @override
  String get reorderItemRight => 'Move to the right';
}

/// The translations for English, as used in Singapore (`en_SG`).
class MaterialLocalizationEnSg extends MaterialLocalizationEn {
  /// Create an instance of the translation bundle for English, as used in Singapore.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEnSg({
    String localeName = 'en_SG',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get dateInputLabel => 'Enter date';

  @override
  String get dateRangeEndLabel => 'End date';

  @override
  String get dateRangeStartLabel => 'Start date';

  @override
  String get unspecifiedDateRange => 'Date range';

  @override
  String get licensesPageTitle => 'Licences';

  @override
  String? get licensesPackageDetailTextZero => 'No licences';

  @override
  String? get licensesPackageDetailTextOne => '1 licence';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licences';

  @override
  String get viewLicensesButtonLabel => 'VIEW LICENCES';

  @override
  String get popupMenuLabel => 'Pop-up menu';

  @override
  String get dialogLabel => 'Dialogue';

  @override
  String get reorderItemLeft => 'Move to the left';

  @override
  String get reorderItemRight => 'Move to the right';
}

/// The translations for English, as used in South Africa (`en_ZA`).
class MaterialLocalizationEnZa extends MaterialLocalizationEn {
  /// Create an instance of the translation bundle for English, as used in South Africa.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEnZa({
    String localeName = 'en_ZA',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get dateInputLabel => 'Enter date';

  @override
  String get dateRangeEndLabel => 'End date';

  @override
  String get dateRangeStartLabel => 'Start date';

  @override
  String get unspecifiedDateRange => 'Date range';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get viewLicensesButtonLabel => 'VIEW LICENCES';

  @override
  String get licensesPageTitle => 'Licences';

  @override
  String? get licensesPackageDetailTextZero => 'No licences';

  @override
  String? get licensesPackageDetailTextOne => '1 licence';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licences';

  @override
  String get popupMenuLabel => 'Pop-up menu';

  @override
  String get dialogLabel => 'Dialogue';

  @override
  String get reorderItemLeft => 'Move to the left';

  @override
  String get reorderItemRight => 'Move to the right';
}

/// The translations for Spanish Castilian (`es`).
class MaterialLocalizationEs extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Spanish Castilian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEs({
    String localeName = 'es',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Sobre $applicationName';

  @override
  String get alertDialogLabel => 'Alerta';

  @override
  String get anteMeridiemAbbreviation => 'a. m.';

  @override
  String get backButtonTooltip => 'Atrás';

  @override
  String get calendarModeButtonLabel => 'Cambiar a calendario';

  @override
  String get cancelButtonLabel => 'CANCELAR';

  @override
  String get closeButtonLabel => 'CERRAR';

  @override
  String get closeButtonTooltip => 'Cerrar';

  @override
  String get collapsedIconTapHint => 'Mostrar';

  @override
  String get continueButtonLabel => 'CONTINUAR';

  @override
  String get copyButtonLabel => 'Copiar';

  @override
  String get cutButtonLabel => 'Cortar';

  @override
  String get dateHelpText => 'mm/dd/aaaa';

  @override
  String get dateInputLabel => 'Introduce una fecha';

  @override
  String get dateOutOfRangeLabel => 'Fuera del periodo válido.';

  @override
  String get datePickerHelpText => 'SELECCIONAR FECHA';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Fecha de finalización $fullDate';

  @override
  String get dateRangeEndLabel => 'Fecha de finalización';

  @override
  String get dateRangePickerHelpText => 'SELECCIONAR PERIODO';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Fecha de inicio $fullDate';

  @override
  String get dateRangeStartLabel => 'Fecha de inicio';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'Eliminar';

  @override
  String get dialModeButtonLabel => 'Cambiar al modo de selección de hora';

  @override
  String get dialogLabel => 'Cuadro de diálogo';

  @override
  String get drawerLabel => 'Menú de navegación';

  @override
  String get expandedIconTapHint => 'Ocultar';

  @override
  String get firstPageTooltip => 'Primera página';

  @override
  String get hideAccountsLabel => 'Ocultar cuentas';

  @override
  String get inputDateModeButtonLabel => 'Cambiar a cuadro de texto';

  @override
  String get inputTimeModeButtonLabel => 'Cambiar al modo de introducción de texto';

  @override
  String get invalidDateFormatLabel => 'Formato no válido.';

  @override
  String get invalidDateRangeLabel => 'Periodo no válido.';

  @override
  String get invalidTimeLabel => 'Indica una hora válida';

  @override
  String get lastPageTooltip => 'Última página';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 licencia';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licencias';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Licencias';

  @override
  String get modalBarrierDismissLabel => 'Cerrar';

  @override
  String get moreButtonTooltip => 'Más';

  @override
  String get nextMonthTooltip => 'Mes siguiente';

  @override
  String get nextPageTooltip => 'Página siguiente';

  @override
  String get okButtonLabel => 'ACEPTAR';

  @override
  String get openAppDrawerTooltip => 'Abrir el menú de navegación';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow‑$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow‑$lastRow de aproximadamente $rowCount';

  @override
  String get pasteButtonLabel => 'Pegar';

  @override
  String get popupMenuLabel => 'Menú emergente';

  @override
  String get postMeridiemAbbreviation => 'p. m.';

  @override
  String get previousMonthTooltip => 'Mes anterior';

  @override
  String get previousPageTooltip => 'Página anterior';

  @override
  String get refreshIndicatorSemanticLabel => 'Actualizar';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => 'Queda 1 carácter.';

  @override
  String get remainingTextFieldCharacterCountOther => r'Quedan $remainingCount caracteres';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Mover hacia abajo';

  @override
  String get reorderItemLeft => 'Mover hacia la izquierda';

  @override
  String get reorderItemRight => 'Mover hacia la derecha';

  @override
  String get reorderItemToEnd => 'Mover al final';

  @override
  String get reorderItemToStart => 'Mover al principio';

  @override
  String get reorderItemUp => 'Mover hacia arriba';

  @override
  String get rowsPerPageTitle => 'Filas por página:';

  @override
  String get saveButtonLabel => 'GUARDAR';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Buscar';

  @override
  String get selectAllButtonLabel => 'Seleccionar todo';

  @override
  String get selectYearSemanticsLabel => 'Seleccionar año';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 elemento seleccionado';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount elementos seleccionados';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => 'No se han seleccionado elementos';

  @override
  String get showAccountsLabel => 'Mostrar cuentas';

  @override
  String get showMenuTooltip => 'Mostrar menú';

  @override
  String get signedInLabel => 'Sesión iniciada';

  @override
  String get tabLabelRaw => r'Pestaña $tabIndex de $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => 'SELECCIONAR HORA';

  @override
  String get timePickerHourLabel => 'Hora';

  @override
  String get timePickerHourModeAnnouncement => 'Seleccionar horas';

  @override
  String get timePickerInputHelpText => 'INTRODUCIR HORA';

  @override
  String get timePickerMinuteLabel => 'Minuto';

  @override
  String get timePickerMinuteModeAnnouncement => 'Seleccionar minutos';

  @override
  String get unspecifiedDate => 'Fecha';

  @override
  String get unspecifiedDateRange => 'Periodo';

  @override
  String get viewLicensesButtonLabel => 'VER LICENCIAS';
}

/// The translations for Spanish Castilian, as used in Latin America and the Caribbean (`es_419`).
class MaterialLocalizationEs419 extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Latin America and the Caribbean.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEs419({
    String localeName = 'es_419',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String? get licensesPackageDetailTextOne => '1 licencia';

  @override
  String get timePickerInputHelpText => 'INGRESAR HORA';

  @override
  String get invalidTimeLabel => 'Ingresa una hora válida';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licencias';

  @override
  String get inputTimeModeButtonLabel => 'Cambiar al modo de entrada de texto';

  @override
  String get dateInputLabel => 'Ingresar fecha';

  @override
  String get calendarModeButtonLabel => 'Cambiar al calendario';

  @override
  String get dateRangePickerHelpText => 'SELECCIONAR PERÍODO';

  @override
  String get dateOutOfRangeLabel => 'Fuera de rango';

  @override
  String get invalidDateRangeLabel => 'El rango no es válido.';

  @override
  String get invalidDateFormatLabel => 'El formato no es válido.';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Fecha de finalización: $fullDate';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Fecha de inicio: $fullDate';

  @override
  String get inputDateModeButtonLabel => 'Cambiar a modo de entrada';

  @override
  String get unspecifiedDateRange => 'Período';

  @override
  String get dateHelpText => 'dd/mm/aaaa';

  @override
  String get modalBarrierDismissLabel => 'Descartar';

  @override
  String get signedInLabel => 'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => 'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => 'Borrar';

  @override
  String get nextMonthTooltip => 'Próximo mes';

  @override
  String get nextPageTooltip => 'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String? get selectedRowCountTitleOne => 'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => 'a.m.';

  @override
  String get postMeridiemAbbreviation => 'p.m.';

  @override
  String get dialogLabel => 'Diálogo';

  @override
  String get reorderItemToStart => 'Mover al inicio';

  @override
  String get expandedIconTapHint => 'Contraer';

  @override
  String get collapsedIconTapHint => 'Expandir';
}

/// The translations for Spanish Castilian, as used in Argentina (`es_AR`).
class MaterialLocalizationEsAr extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Argentina.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsAr({
    String localeName = 'es_AR',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String? get licensesPackageDetailTextOne => '1 licencia';

  @override
  String get timePickerInputHelpText => 'INGRESAR HORA';

  @override
  String get invalidTimeLabel => 'Ingresa una hora válida';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licencias';

  @override
  String get inputTimeModeButtonLabel => 'Cambiar al modo de entrada de texto';

  @override
  String get dateInputLabel => 'Ingresar fecha';

  @override
  String get calendarModeButtonLabel => 'Cambiar al calendario';

  @override
  String get dateRangePickerHelpText => 'SELECCIONAR PERÍODO';

  @override
  String get dateOutOfRangeLabel => 'Fuera de rango';

  @override
  String get invalidDateRangeLabel => 'El rango no es válido.';

  @override
  String get invalidDateFormatLabel => 'El formato no es válido.';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Fecha de finalización: $fullDate';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Fecha de inicio: $fullDate';

  @override
  String get inputDateModeButtonLabel => 'Cambiar a modo de entrada';

  @override
  String get unspecifiedDateRange => 'Período';

  @override
  String get dateHelpText => 'dd/mm/aaaa';

  @override
  String get modalBarrierDismissLabel => 'Descartar';

  @override
  String get signedInLabel => 'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => 'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => 'Borrar';

  @override
  String get nextMonthTooltip => 'Próximo mes';

  @override
  String get nextPageTooltip => 'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String? get selectedRowCountTitleOne => 'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => 'a.m.';

  @override
  String get postMeridiemAbbreviation => 'p.m.';

  @override
  String get dialogLabel => 'Diálogo';

  @override
  String get reorderItemToStart => 'Mover al inicio';

  @override
  String get expandedIconTapHint => 'Contraer';

  @override
  String get collapsedIconTapHint => 'Expandir';
}

/// The translations for Spanish Castilian, as used in Bolivia (`es_BO`).
class MaterialLocalizationEsBo extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Bolivia.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsBo({
    String localeName = 'es_BO',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String? get licensesPackageDetailTextOne => '1 licencia';

  @override
  String get timePickerInputHelpText => 'INGRESAR HORA';

  @override
  String get invalidTimeLabel => 'Ingresa una hora válida';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licencias';

  @override
  String get inputTimeModeButtonLabel => 'Cambiar al modo de entrada de texto';

  @override
  String get dateInputLabel => 'Ingresar fecha';

  @override
  String get calendarModeButtonLabel => 'Cambiar al calendario';

  @override
  String get dateRangePickerHelpText => 'SELECCIONAR PERÍODO';

  @override
  String get dateOutOfRangeLabel => 'Fuera de rango';

  @override
  String get invalidDateRangeLabel => 'El rango no es válido.';

  @override
  String get invalidDateFormatLabel => 'El formato no es válido.';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Fecha de finalización: $fullDate';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Fecha de inicio: $fullDate';

  @override
  String get inputDateModeButtonLabel => 'Cambiar a modo de entrada';

  @override
  String get unspecifiedDateRange => 'Período';

  @override
  String get dateHelpText => 'dd/mm/aaaa';

  @override
  String get reorderItemToStart => 'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => 'Descartar';

  @override
  String get signedInLabel => 'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => 'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => 'Borrar';

  @override
  String get nextMonthTooltip => 'Próximo mes';

  @override
  String get nextPageTooltip => 'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String? get selectedRowCountTitleOne => 'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => 'a.m.';

  @override
  String get postMeridiemAbbreviation => 'p.m.';

  @override
  String get dialogLabel => 'Diálogo';

  @override
  String get expandedIconTapHint => 'Contraer';

  @override
  String get collapsedIconTapHint => 'Expandir';
}

/// The translations for Spanish Castilian, as used in Chile (`es_CL`).
class MaterialLocalizationEsCl extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Chile.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsCl({
    String localeName = 'es_CL',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String? get licensesPackageDetailTextOne => '1 licencia';

  @override
  String get timePickerInputHelpText => 'INGRESAR HORA';

  @override
  String get invalidTimeLabel => 'Ingresa una hora válida';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licencias';

  @override
  String get inputTimeModeButtonLabel => 'Cambiar al modo de entrada de texto';

  @override
  String get dateInputLabel => 'Ingresar fecha';

  @override
  String get calendarModeButtonLabel => 'Cambiar al calendario';

  @override
  String get dateRangePickerHelpText => 'SELECCIONAR PERÍODO';

  @override
  String get dateOutOfRangeLabel => 'Fuera de rango';

  @override
  String get invalidDateRangeLabel => 'El rango no es válido.';

  @override
  String get invalidDateFormatLabel => 'El formato no es válido.';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Fecha de finalización: $fullDate';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Fecha de inicio: $fullDate';

  @override
  String get inputDateModeButtonLabel => 'Cambiar a modo de entrada';

  @override
  String get unspecifiedDateRange => 'Período';

  @override
  String get dateHelpText => 'dd/mm/aaaa';

  @override
  String get reorderItemToStart => 'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => 'Descartar';

  @override
  String get signedInLabel => 'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => 'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => 'Borrar';

  @override
  String get nextMonthTooltip => 'Próximo mes';

  @override
  String get nextPageTooltip => 'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String? get selectedRowCountTitleOne => 'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => 'a.m.';

  @override
  String get postMeridiemAbbreviation => 'p.m.';

  @override
  String get dialogLabel => 'Diálogo';

  @override
  String get expandedIconTapHint => 'Contraer';

  @override
  String get collapsedIconTapHint => 'Expandir';
}

/// The translations for Spanish Castilian, as used in Colombia (`es_CO`).
class MaterialLocalizationEsCo extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Colombia.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsCo({
    String localeName = 'es_CO',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String? get licensesPackageDetailTextOne => '1 licencia';

  @override
  String get timePickerInputHelpText => 'INGRESAR HORA';

  @override
  String get invalidTimeLabel => 'Ingresa una hora válida';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licencias';

  @override
  String get inputTimeModeButtonLabel => 'Cambiar al modo de entrada de texto';

  @override
  String get dateInputLabel => 'Ingresar fecha';

  @override
  String get calendarModeButtonLabel => 'Cambiar al calendario';

  @override
  String get dateRangePickerHelpText => 'SELECCIONAR PERÍODO';

  @override
  String get dateOutOfRangeLabel => 'Fuera de rango';

  @override
  String get invalidDateRangeLabel => 'El rango no es válido.';

  @override
  String get invalidDateFormatLabel => 'El formato no es válido.';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Fecha de finalización: $fullDate';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Fecha de inicio: $fullDate';

  @override
  String get inputDateModeButtonLabel => 'Cambiar a modo de entrada';

  @override
  String get unspecifiedDateRange => 'Período';

  @override
  String get dateHelpText => 'dd/mm/aaaa';

  @override
  String get reorderItemToStart => 'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => 'Descartar';

  @override
  String get signedInLabel => 'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => 'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => 'Borrar';

  @override
  String get nextMonthTooltip => 'Próximo mes';

  @override
  String get nextPageTooltip => 'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String? get selectedRowCountTitleOne => 'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => 'a.m.';

  @override
  String get postMeridiemAbbreviation => 'p.m.';

  @override
  String get dialogLabel => 'Diálogo';

  @override
  String get expandedIconTapHint => 'Contraer';

  @override
  String get collapsedIconTapHint => 'Expandir';
}

/// The translations for Spanish Castilian, as used in Costa Rica (`es_CR`).
class MaterialLocalizationEsCr extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Costa Rica.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsCr({
    String localeName = 'es_CR',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String? get licensesPackageDetailTextOne => '1 licencia';

  @override
  String get timePickerInputHelpText => 'INGRESAR HORA';

  @override
  String get invalidTimeLabel => 'Ingresa una hora válida';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licencias';

  @override
  String get inputTimeModeButtonLabel => 'Cambiar al modo de entrada de texto';

  @override
  String get dateInputLabel => 'Ingresar fecha';

  @override
  String get calendarModeButtonLabel => 'Cambiar al calendario';

  @override
  String get dateRangePickerHelpText => 'SELECCIONAR PERÍODO';

  @override
  String get dateOutOfRangeLabel => 'Fuera de rango';

  @override
  String get invalidDateRangeLabel => 'El rango no es válido.';

  @override
  String get invalidDateFormatLabel => 'El formato no es válido.';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Fecha de finalización: $fullDate';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Fecha de inicio: $fullDate';

  @override
  String get inputDateModeButtonLabel => 'Cambiar a modo de entrada';

  @override
  String get unspecifiedDateRange => 'Período';

  @override
  String get dateHelpText => 'dd/mm/aaaa';

  @override
  String get reorderItemToStart => 'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => 'Descartar';

  @override
  String get signedInLabel => 'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => 'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => 'Borrar';

  @override
  String get nextMonthTooltip => 'Próximo mes';

  @override
  String get nextPageTooltip => 'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String? get selectedRowCountTitleOne => 'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => 'a.m.';

  @override
  String get postMeridiemAbbreviation => 'p.m.';

  @override
  String get dialogLabel => 'Diálogo';

  @override
  String get expandedIconTapHint => 'Contraer';

  @override
  String get collapsedIconTapHint => 'Expandir';
}

/// The translations for Spanish Castilian, as used in the Dominican Republic (`es_DO`).
class MaterialLocalizationEsDo extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in the Dominican Republic.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsDo({
    String localeName = 'es_DO',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String? get licensesPackageDetailTextOne => '1 licencia';

  @override
  String get timePickerInputHelpText => 'INGRESAR HORA';

  @override
  String get invalidTimeLabel => 'Ingresa una hora válida';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licencias';

  @override
  String get inputTimeModeButtonLabel => 'Cambiar al modo de entrada de texto';

  @override
  String get dateInputLabel => 'Ingresar fecha';

  @override
  String get calendarModeButtonLabel => 'Cambiar al calendario';

  @override
  String get dateRangePickerHelpText => 'SELECCIONAR PERÍODO';

  @override
  String get dateOutOfRangeLabel => 'Fuera de rango';

  @override
  String get invalidDateRangeLabel => 'El rango no es válido.';

  @override
  String get invalidDateFormatLabel => 'El formato no es válido.';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Fecha de finalización: $fullDate';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Fecha de inicio: $fullDate';

  @override
  String get inputDateModeButtonLabel => 'Cambiar a modo de entrada';

  @override
  String get unspecifiedDateRange => 'Período';

  @override
  String get dateHelpText => 'dd/mm/aaaa';

  @override
  String get reorderItemToStart => 'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => 'Descartar';

  @override
  String get signedInLabel => 'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => 'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => 'Borrar';

  @override
  String get nextMonthTooltip => 'Próximo mes';

  @override
  String get nextPageTooltip => 'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String? get selectedRowCountTitleOne => 'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => 'a.m.';

  @override
  String get postMeridiemAbbreviation => 'p.m.';

  @override
  String get dialogLabel => 'Diálogo';

  @override
  String get expandedIconTapHint => 'Contraer';

  @override
  String get collapsedIconTapHint => 'Expandir';
}

/// The translations for Spanish Castilian, as used in Ecuador (`es_EC`).
class MaterialLocalizationEsEc extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Ecuador.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsEc({
    String localeName = 'es_EC',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String? get licensesPackageDetailTextOne => '1 licencia';

  @override
  String get timePickerInputHelpText => 'INGRESAR HORA';

  @override
  String get invalidTimeLabel => 'Ingresa una hora válida';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licencias';

  @override
  String get inputTimeModeButtonLabel => 'Cambiar al modo de entrada de texto';

  @override
  String get dateInputLabel => 'Ingresar fecha';

  @override
  String get calendarModeButtonLabel => 'Cambiar al calendario';

  @override
  String get dateRangePickerHelpText => 'SELECCIONAR PERÍODO';

  @override
  String get dateOutOfRangeLabel => 'Fuera de rango';

  @override
  String get invalidDateRangeLabel => 'El rango no es válido.';

  @override
  String get invalidDateFormatLabel => 'El formato no es válido.';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Fecha de finalización: $fullDate';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Fecha de inicio: $fullDate';

  @override
  String get inputDateModeButtonLabel => 'Cambiar a modo de entrada';

  @override
  String get unspecifiedDateRange => 'Período';

  @override
  String get dateHelpText => 'dd/mm/aaaa';

  @override
  String get reorderItemToStart => 'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => 'Descartar';

  @override
  String get signedInLabel => 'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => 'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => 'Borrar';

  @override
  String get nextMonthTooltip => 'Próximo mes';

  @override
  String get nextPageTooltip => 'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String? get selectedRowCountTitleOne => 'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => 'a.m.';

  @override
  String get postMeridiemAbbreviation => 'p.m.';

  @override
  String get dialogLabel => 'Diálogo';

  @override
  String get expandedIconTapHint => 'Contraer';

  @override
  String get collapsedIconTapHint => 'Expandir';
}

/// The translations for Spanish Castilian, as used in Guatemala (`es_GT`).
class MaterialLocalizationEsGt extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Guatemala.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsGt({
    String localeName = 'es_GT',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String? get licensesPackageDetailTextOne => '1 licencia';

  @override
  String get timePickerInputHelpText => 'INGRESAR HORA';

  @override
  String get invalidTimeLabel => 'Ingresa una hora válida';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licencias';

  @override
  String get inputTimeModeButtonLabel => 'Cambiar al modo de entrada de texto';

  @override
  String get dateInputLabel => 'Ingresar fecha';

  @override
  String get calendarModeButtonLabel => 'Cambiar al calendario';

  @override
  String get dateRangePickerHelpText => 'SELECCIONAR PERÍODO';

  @override
  String get dateOutOfRangeLabel => 'Fuera de rango';

  @override
  String get invalidDateRangeLabel => 'El rango no es válido.';

  @override
  String get invalidDateFormatLabel => 'El formato no es válido.';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Fecha de finalización: $fullDate';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Fecha de inicio: $fullDate';

  @override
  String get inputDateModeButtonLabel => 'Cambiar a modo de entrada';

  @override
  String get unspecifiedDateRange => 'Período';

  @override
  String get dateHelpText => 'dd/mm/aaaa';

  @override
  String get reorderItemToStart => 'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => 'Descartar';

  @override
  String get signedInLabel => 'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => 'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => 'Borrar';

  @override
  String get nextMonthTooltip => 'Próximo mes';

  @override
  String get nextPageTooltip => 'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String? get selectedRowCountTitleOne => 'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => 'a.m.';

  @override
  String get postMeridiemAbbreviation => 'p.m.';

  @override
  String get dialogLabel => 'Diálogo';

  @override
  String get expandedIconTapHint => 'Contraer';

  @override
  String get collapsedIconTapHint => 'Expandir';
}

/// The translations for Spanish Castilian, as used in Honduras (`es_HN`).
class MaterialLocalizationEsHn extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Honduras.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsHn({
    String localeName = 'es_HN',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String? get licensesPackageDetailTextOne => '1 licencia';

  @override
  String get timePickerInputHelpText => 'INGRESAR HORA';

  @override
  String get invalidTimeLabel => 'Ingresa una hora válida';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licencias';

  @override
  String get inputTimeModeButtonLabel => 'Cambiar al modo de entrada de texto';

  @override
  String get dateInputLabel => 'Ingresar fecha';

  @override
  String get calendarModeButtonLabel => 'Cambiar al calendario';

  @override
  String get dateRangePickerHelpText => 'SELECCIONAR PERÍODO';

  @override
  String get dateOutOfRangeLabel => 'Fuera de rango';

  @override
  String get invalidDateRangeLabel => 'El rango no es válido.';

  @override
  String get invalidDateFormatLabel => 'El formato no es válido.';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Fecha de finalización: $fullDate';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Fecha de inicio: $fullDate';

  @override
  String get inputDateModeButtonLabel => 'Cambiar a modo de entrada';

  @override
  String get unspecifiedDateRange => 'Período';

  @override
  String get dateHelpText => 'dd/mm/aaaa';

  @override
  String get reorderItemToStart => 'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => 'Descartar';

  @override
  String get signedInLabel => 'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => 'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => 'Borrar';

  @override
  String get nextMonthTooltip => 'Próximo mes';

  @override
  String get nextPageTooltip => 'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String? get selectedRowCountTitleOne => 'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => 'a.m.';

  @override
  String get postMeridiemAbbreviation => 'p.m.';

  @override
  String get dialogLabel => 'Diálogo';

  @override
  String get expandedIconTapHint => 'Contraer';

  @override
  String get collapsedIconTapHint => 'Expandir';
}

/// The translations for Spanish Castilian, as used in Mexico (`es_MX`).
class MaterialLocalizationEsMx extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Mexico.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsMx({
    String localeName = 'es_MX',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String? get licensesPackageDetailTextOne => '1 licencia';

  @override
  String get timePickerInputHelpText => 'INGRESAR HORA';

  @override
  String get invalidTimeLabel => 'Ingresa una hora válida';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licencias';

  @override
  String get inputTimeModeButtonLabel => 'Cambiar al modo de entrada de texto';

  @override
  String get dateInputLabel => 'Ingresar fecha';

  @override
  String get calendarModeButtonLabel => 'Cambiar al calendario';

  @override
  String get dateRangePickerHelpText => 'SELECCIONAR PERÍODO';

  @override
  String get dateOutOfRangeLabel => 'Fuera de rango';

  @override
  String get invalidDateRangeLabel => 'El rango no es válido.';

  @override
  String get invalidDateFormatLabel => 'El formato no es válido.';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Fecha de finalización: $fullDate';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Fecha de inicio: $fullDate';

  @override
  String get inputDateModeButtonLabel => 'Cambiar a modo de entrada';

  @override
  String get unspecifiedDateRange => 'Período';

  @override
  String get dateHelpText => 'dd/mm/aaaa';

  @override
  String get reorderItemToStart => 'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => 'Descartar';

  @override
  String get signedInLabel => 'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => 'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => 'Borrar';

  @override
  String get nextMonthTooltip => 'Próximo mes';

  @override
  String get nextPageTooltip => 'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String? get selectedRowCountTitleOne => 'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => 'a.m.';

  @override
  String get postMeridiemAbbreviation => 'p.m.';

  @override
  String get dialogLabel => 'Diálogo';

  @override
  String get expandedIconTapHint => 'Contraer';

  @override
  String get collapsedIconTapHint => 'Expandir';
}

/// The translations for Spanish Castilian, as used in Nicaragua (`es_NI`).
class MaterialLocalizationEsNi extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Nicaragua.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsNi({
    String localeName = 'es_NI',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String? get licensesPackageDetailTextOne => '1 licencia';

  @override
  String get timePickerInputHelpText => 'INGRESAR HORA';

  @override
  String get invalidTimeLabel => 'Ingresa una hora válida';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licencias';

  @override
  String get inputTimeModeButtonLabel => 'Cambiar al modo de entrada de texto';

  @override
  String get dateInputLabel => 'Ingresar fecha';

  @override
  String get calendarModeButtonLabel => 'Cambiar al calendario';

  @override
  String get dateRangePickerHelpText => 'SELECCIONAR PERÍODO';

  @override
  String get dateOutOfRangeLabel => 'Fuera de rango';

  @override
  String get invalidDateRangeLabel => 'El rango no es válido.';

  @override
  String get invalidDateFormatLabel => 'El formato no es válido.';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Fecha de finalización: $fullDate';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Fecha de inicio: $fullDate';

  @override
  String get inputDateModeButtonLabel => 'Cambiar a modo de entrada';

  @override
  String get unspecifiedDateRange => 'Período';

  @override
  String get dateHelpText => 'dd/mm/aaaa';

  @override
  String get reorderItemToStart => 'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => 'Descartar';

  @override
  String get signedInLabel => 'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => 'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => 'Borrar';

  @override
  String get nextMonthTooltip => 'Próximo mes';

  @override
  String get nextPageTooltip => 'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String? get selectedRowCountTitleOne => 'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => 'a.m.';

  @override
  String get postMeridiemAbbreviation => 'p.m.';

  @override
  String get dialogLabel => 'Diálogo';

  @override
  String get expandedIconTapHint => 'Contraer';

  @override
  String get collapsedIconTapHint => 'Expandir';
}

/// The translations for Spanish Castilian, as used in Panama (`es_PA`).
class MaterialLocalizationEsPa extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Panama.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsPa({
    String localeName = 'es_PA',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String? get licensesPackageDetailTextOne => '1 licencia';

  @override
  String get timePickerInputHelpText => 'INGRESAR HORA';

  @override
  String get invalidTimeLabel => 'Ingresa una hora válida';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licencias';

  @override
  String get inputTimeModeButtonLabel => 'Cambiar al modo de entrada de texto';

  @override
  String get dateInputLabel => 'Ingresar fecha';

  @override
  String get calendarModeButtonLabel => 'Cambiar al calendario';

  @override
  String get dateRangePickerHelpText => 'SELECCIONAR PERÍODO';

  @override
  String get dateOutOfRangeLabel => 'Fuera de rango';

  @override
  String get invalidDateRangeLabel => 'El rango no es válido.';

  @override
  String get invalidDateFormatLabel => 'El formato no es válido.';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Fecha de finalización: $fullDate';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Fecha de inicio: $fullDate';

  @override
  String get inputDateModeButtonLabel => 'Cambiar a modo de entrada';

  @override
  String get unspecifiedDateRange => 'Período';

  @override
  String get dateHelpText => 'dd/mm/aaaa';

  @override
  String get reorderItemToStart => 'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => 'Descartar';

  @override
  String get signedInLabel => 'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => 'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => 'Borrar';

  @override
  String get nextMonthTooltip => 'Próximo mes';

  @override
  String get nextPageTooltip => 'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String? get selectedRowCountTitleOne => 'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => 'a.m.';

  @override
  String get postMeridiemAbbreviation => 'p.m.';

  @override
  String get dialogLabel => 'Diálogo';

  @override
  String get expandedIconTapHint => 'Contraer';

  @override
  String get collapsedIconTapHint => 'Expandir';
}

/// The translations for Spanish Castilian, as used in Peru (`es_PE`).
class MaterialLocalizationEsPe extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Peru.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsPe({
    String localeName = 'es_PE',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String? get licensesPackageDetailTextOne => '1 licencia';

  @override
  String get timePickerInputHelpText => 'INGRESAR HORA';

  @override
  String get invalidTimeLabel => 'Ingresa una hora válida';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licencias';

  @override
  String get inputTimeModeButtonLabel => 'Cambiar al modo de entrada de texto';

  @override
  String get dateInputLabel => 'Ingresar fecha';

  @override
  String get calendarModeButtonLabel => 'Cambiar al calendario';

  @override
  String get dateRangePickerHelpText => 'SELECCIONAR PERÍODO';

  @override
  String get dateOutOfRangeLabel => 'Fuera de rango';

  @override
  String get invalidDateRangeLabel => 'El rango no es válido.';

  @override
  String get invalidDateFormatLabel => 'El formato no es válido.';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Fecha de finalización: $fullDate';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Fecha de inicio: $fullDate';

  @override
  String get inputDateModeButtonLabel => 'Cambiar a modo de entrada';

  @override
  String get unspecifiedDateRange => 'Período';

  @override
  String get dateHelpText => 'dd/mm/aaaa';

  @override
  String get reorderItemToStart => 'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => 'Descartar';

  @override
  String get signedInLabel => 'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => 'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => 'Borrar';

  @override
  String get nextMonthTooltip => 'Próximo mes';

  @override
  String get nextPageTooltip => 'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String? get selectedRowCountTitleOne => 'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => 'a.m.';

  @override
  String get postMeridiemAbbreviation => 'p.m.';

  @override
  String get dialogLabel => 'Diálogo';

  @override
  String get expandedIconTapHint => 'Contraer';

  @override
  String get collapsedIconTapHint => 'Expandir';
}

/// The translations for Spanish Castilian, as used in Puerto Rico (`es_PR`).
class MaterialLocalizationEsPr extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Puerto Rico.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsPr({
    String localeName = 'es_PR',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String? get licensesPackageDetailTextOne => '1 licencia';

  @override
  String get timePickerInputHelpText => 'INGRESAR HORA';

  @override
  String get invalidTimeLabel => 'Ingresa una hora válida';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licencias';

  @override
  String get inputTimeModeButtonLabel => 'Cambiar al modo de entrada de texto';

  @override
  String get dateInputLabel => 'Ingresar fecha';

  @override
  String get calendarModeButtonLabel => 'Cambiar al calendario';

  @override
  String get dateRangePickerHelpText => 'SELECCIONAR PERÍODO';

  @override
  String get dateOutOfRangeLabel => 'Fuera de rango';

  @override
  String get invalidDateRangeLabel => 'El rango no es válido.';

  @override
  String get invalidDateFormatLabel => 'El formato no es válido.';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Fecha de finalización: $fullDate';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Fecha de inicio: $fullDate';

  @override
  String get inputDateModeButtonLabel => 'Cambiar a modo de entrada';

  @override
  String get unspecifiedDateRange => 'Período';

  @override
  String get dateHelpText => 'dd/mm/aaaa';

  @override
  String get reorderItemToStart => 'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => 'Descartar';

  @override
  String get signedInLabel => 'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => 'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => 'Borrar';

  @override
  String get nextMonthTooltip => 'Próximo mes';

  @override
  String get nextPageTooltip => 'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String? get selectedRowCountTitleOne => 'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => 'a.m.';

  @override
  String get postMeridiemAbbreviation => 'p.m.';

  @override
  String get dialogLabel => 'Diálogo';

  @override
  String get expandedIconTapHint => 'Contraer';

  @override
  String get collapsedIconTapHint => 'Expandir';
}

/// The translations for Spanish Castilian, as used in Paraguay (`es_PY`).
class MaterialLocalizationEsPy extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Paraguay.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsPy({
    String localeName = 'es_PY',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String? get licensesPackageDetailTextOne => '1 licencia';

  @override
  String get timePickerInputHelpText => 'INGRESAR HORA';

  @override
  String get invalidTimeLabel => 'Ingresa una hora válida';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licencias';

  @override
  String get inputTimeModeButtonLabel => 'Cambiar al modo de entrada de texto';

  @override
  String get dateInputLabel => 'Ingresar fecha';

  @override
  String get calendarModeButtonLabel => 'Cambiar al calendario';

  @override
  String get dateRangePickerHelpText => 'SELECCIONAR PERÍODO';

  @override
  String get dateOutOfRangeLabel => 'Fuera de rango';

  @override
  String get invalidDateRangeLabel => 'El rango no es válido.';

  @override
  String get invalidDateFormatLabel => 'El formato no es válido.';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Fecha de finalización: $fullDate';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Fecha de inicio: $fullDate';

  @override
  String get inputDateModeButtonLabel => 'Cambiar a modo de entrada';

  @override
  String get unspecifiedDateRange => 'Período';

  @override
  String get dateHelpText => 'dd/mm/aaaa';

  @override
  String get reorderItemToStart => 'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => 'Descartar';

  @override
  String get signedInLabel => 'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => 'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => 'Borrar';

  @override
  String get nextMonthTooltip => 'Próximo mes';

  @override
  String get nextPageTooltip => 'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String? get selectedRowCountTitleOne => 'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => 'a.m.';

  @override
  String get postMeridiemAbbreviation => 'p.m.';

  @override
  String get dialogLabel => 'Diálogo';

  @override
  String get expandedIconTapHint => 'Contraer';

  @override
  String get collapsedIconTapHint => 'Expandir';
}

/// The translations for Spanish Castilian, as used in El Salvador (`es_SV`).
class MaterialLocalizationEsSv extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in El Salvador.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsSv({
    String localeName = 'es_SV',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String? get licensesPackageDetailTextOne => '1 licencia';

  @override
  String get timePickerInputHelpText => 'INGRESAR HORA';

  @override
  String get invalidTimeLabel => 'Ingresa una hora válida';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licencias';

  @override
  String get inputTimeModeButtonLabel => 'Cambiar al modo de entrada de texto';

  @override
  String get dateInputLabel => 'Ingresar fecha';

  @override
  String get calendarModeButtonLabel => 'Cambiar al calendario';

  @override
  String get dateRangePickerHelpText => 'SELECCIONAR PERÍODO';

  @override
  String get dateOutOfRangeLabel => 'Fuera de rango';

  @override
  String get invalidDateRangeLabel => 'El rango no es válido.';

  @override
  String get invalidDateFormatLabel => 'El formato no es válido.';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Fecha de finalización: $fullDate';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Fecha de inicio: $fullDate';

  @override
  String get inputDateModeButtonLabel => 'Cambiar a modo de entrada';

  @override
  String get unspecifiedDateRange => 'Período';

  @override
  String get dateHelpText => 'dd/mm/aaaa';

  @override
  String get reorderItemToStart => 'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => 'Descartar';

  @override
  String get signedInLabel => 'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => 'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => 'Borrar';

  @override
  String get nextMonthTooltip => 'Próximo mes';

  @override
  String get nextPageTooltip => 'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String? get selectedRowCountTitleOne => 'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => 'a.m.';

  @override
  String get postMeridiemAbbreviation => 'p.m.';

  @override
  String get dialogLabel => 'Diálogo';

  @override
  String get expandedIconTapHint => 'Contraer';

  @override
  String get collapsedIconTapHint => 'Expandir';
}

/// The translations for Spanish Castilian, as used in the United States (`es_US`).
class MaterialLocalizationEsUs extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in the United States.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsUs({
    String localeName = 'es_US',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String? get licensesPackageDetailTextOne => '1 licencia';

  @override
  String get timePickerInputHelpText => 'INGRESAR HORA';

  @override
  String get invalidTimeLabel => 'Ingresa una hora válida';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licencias';

  @override
  String get inputTimeModeButtonLabel => 'Cambiar al modo de entrada de texto';

  @override
  String get dateInputLabel => 'Ingresar fecha';

  @override
  String get calendarModeButtonLabel => 'Cambiar al calendario';

  @override
  String get dateRangePickerHelpText => 'SELECCIONAR PERÍODO';

  @override
  String get dateOutOfRangeLabel => 'Fuera de rango';

  @override
  String get invalidDateRangeLabel => 'El rango no es válido.';

  @override
  String get invalidDateFormatLabel => 'El formato no es válido.';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Fecha de finalización: $fullDate';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Fecha de inicio: $fullDate';

  @override
  String get inputDateModeButtonLabel => 'Cambiar a modo de entrada';

  @override
  String get unspecifiedDateRange => 'Período';

  @override
  String get dateHelpText => 'dd/mm/aaaa';

  @override
  String get reorderItemToStart => 'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => 'Descartar';

  @override
  String get signedInLabel => 'Cuenta con la que accediste';

  @override
  String get deleteButtonTooltip => 'Borrar';

  @override
  String get nextMonthTooltip => 'Próximo mes';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get nextPageTooltip => 'Próxima página';

  @override
  String get openAppDrawerTooltip => 'Abrir menú de navegación';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String? get selectedRowCountTitleOne => 'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.h_colon_mm_space_a;

  @override
  String get anteMeridiemAbbreviation => 'a.m.';

  @override
  String get postMeridiemAbbreviation => 'p.m.';

  @override
  String get dialogLabel => 'Diálogo';

  @override
  String get expandedIconTapHint => 'Contraer';

  @override
  String get collapsedIconTapHint => 'Expandir';
}

/// The translations for Spanish Castilian, as used in Uruguay (`es_UY`).
class MaterialLocalizationEsUy extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Uruguay.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsUy({
    String localeName = 'es_UY',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String? get licensesPackageDetailTextOne => '1 licencia';

  @override
  String get timePickerInputHelpText => 'INGRESAR HORA';

  @override
  String get invalidTimeLabel => 'Ingresa una hora válida';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licencias';

  @override
  String get inputTimeModeButtonLabel => 'Cambiar al modo de entrada de texto';

  @override
  String get dateInputLabel => 'Ingresar fecha';

  @override
  String get calendarModeButtonLabel => 'Cambiar al calendario';

  @override
  String get dateRangePickerHelpText => 'SELECCIONAR PERÍODO';

  @override
  String get dateOutOfRangeLabel => 'Fuera de rango';

  @override
  String get invalidDateRangeLabel => 'El rango no es válido.';

  @override
  String get invalidDateFormatLabel => 'El formato no es válido.';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Fecha de finalización: $fullDate';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Fecha de inicio: $fullDate';

  @override
  String get inputDateModeButtonLabel => 'Cambiar a modo de entrada';

  @override
  String get unspecifiedDateRange => 'Período';

  @override
  String get dateHelpText => 'dd/mm/aaaa';

  @override
  String get reorderItemToStart => 'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => 'Descartar';

  @override
  String get signedInLabel => 'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => 'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => 'Borrar';

  @override
  String get nextMonthTooltip => 'Próximo mes';

  @override
  String get nextPageTooltip => 'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String? get selectedRowCountTitleOne => 'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => 'a.m.';

  @override
  String get postMeridiemAbbreviation => 'p.m.';

  @override
  String get dialogLabel => 'Diálogo';

  @override
  String get expandedIconTapHint => 'Contraer';

  @override
  String get collapsedIconTapHint => 'Expandir';
}

/// The translations for Spanish Castilian, as used in Venezuela (`es_VE`).
class MaterialLocalizationEsVe extends MaterialLocalizationEs {
  /// Create an instance of the translation bundle for Spanish Castilian, as used in Venezuela.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEsVe({
    String localeName = 'es_VE',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String? get licensesPackageDetailTextOne => '1 licencia';

  @override
  String get timePickerInputHelpText => 'INGRESAR HORA';

  @override
  String get invalidTimeLabel => 'Ingresa una hora válida';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licencias';

  @override
  String get inputTimeModeButtonLabel => 'Cambiar al modo de entrada de texto';

  @override
  String get dateInputLabel => 'Ingresar fecha';

  @override
  String get calendarModeButtonLabel => 'Cambiar al calendario';

  @override
  String get dateRangePickerHelpText => 'SELECCIONAR PERÍODO';

  @override
  String get dateOutOfRangeLabel => 'Fuera de rango';

  @override
  String get invalidDateRangeLabel => 'El rango no es válido.';

  @override
  String get invalidDateFormatLabel => 'El formato no es válido.';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Fecha de finalización: $fullDate';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Fecha de inicio: $fullDate';

  @override
  String get inputDateModeButtonLabel => 'Cambiar a modo de entrada';

  @override
  String get unspecifiedDateRange => 'Período';

  @override
  String get dateHelpText => 'dd/mm/aaaa';

  @override
  String get reorderItemToStart => 'Mover al inicio';

  @override
  String get modalBarrierDismissLabel => 'Descartar';

  @override
  String get signedInLabel => 'Cuenta con la que accediste';

  @override
  String get openAppDrawerTooltip => 'Abrir menú de navegación';

  @override
  String get deleteButtonTooltip => 'Borrar';

  @override
  String get nextMonthTooltip => 'Próximo mes';

  @override
  String get nextPageTooltip => 'Próxima página';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow de aproximadamente $rowCount';

  @override
  String? get selectedRowCountTitleOne => 'Se seleccionó 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Se seleccionaron $selectedRowCount elementos';

  @override
  String get anteMeridiemAbbreviation => 'a.m.';

  @override
  String get postMeridiemAbbreviation => 'p.m.';

  @override
  String get dialogLabel => 'Diálogo';

  @override
  String get expandedIconTapHint => 'Contraer';

  @override
  String get collapsedIconTapHint => 'Expandir';
}

/// The translations for Estonian (`et`).
class MaterialLocalizationEt extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Estonian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEt({
    String localeName = 'et',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Teave rakenduse $applicationName kohta';

  @override
  String get alertDialogLabel => 'Märguanne';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'Tagasi';

  @override
  String get calendarModeButtonLabel => 'Kalendrile lülitumine';

  @override
  String get cancelButtonLabel => 'TÜHISTA';

  @override
  String get closeButtonLabel => 'SULE';

  @override
  String get closeButtonTooltip => 'Sule';

  @override
  String get collapsedIconTapHint => 'Laienda';

  @override
  String get continueButtonLabel => 'JÄTKA';

  @override
  String get copyButtonLabel => 'Kopeeri';

  @override
  String get cutButtonLabel => 'Lõika';

  @override
  String get dateHelpText => 'pp.kk.aaaa';

  @override
  String get dateInputLabel => 'Sisestage kuupäev';

  @override
  String get dateOutOfRangeLabel => 'Vahemikust väljas.';

  @override
  String get datePickerHelpText => 'VALIGE KUUPÄEV';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Lõppkuupäev: $fullDate';

  @override
  String get dateRangeEndLabel => 'Lõppkuupäev';

  @override
  String get dateRangePickerHelpText => 'VALIGE VAHEMIK';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Alguskuupäev: $fullDate';

  @override
  String get dateRangeStartLabel => 'Alguskuupäev';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'Kustuta';

  @override
  String get dialModeButtonLabel => 'Lülitumine valikuketta režiimile';

  @override
  String get dialogLabel => 'Dialoog';

  @override
  String get drawerLabel => 'Navigeerimismenüü';

  @override
  String get expandedIconTapHint => 'Ahenda';

  @override
  String get firstPageTooltip => 'Esimene leht';

  @override
  String get hideAccountsLabel => 'Peida kontod';

  @override
  String get inputDateModeButtonLabel => 'Sisestusrežiimile lülitumine';

  @override
  String get inputTimeModeButtonLabel => 'Lülitumine tekstisisestusrežiimile';

  @override
  String get invalidDateFormatLabel => 'Sobimatu vorming.';

  @override
  String get invalidDateRangeLabel => 'Sobimatu vahemik.';

  @override
  String get invalidTimeLabel => 'Sisestage sobiv kellaaeg';

  @override
  String get lastPageTooltip => 'Viimane leht';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 litsents';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount litsentsi';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Litsentsid';

  @override
  String get modalBarrierDismissLabel => 'Loobu';

  @override
  String get moreButtonTooltip => 'Rohkem';

  @override
  String get nextMonthTooltip => 'Järgmine kuu';

  @override
  String get nextPageTooltip => 'Järgmine leht';

  @override
  String get okButtonLabel => 'OK';

  @override
  String get openAppDrawerTooltip => 'Ava navigeerimismenüü';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow $rowCount-st';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow umbes $rowCount-st';

  @override
  String get pasteButtonLabel => 'Kleebi';

  @override
  String get popupMenuLabel => 'Hüpikmenüü';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'Eelmine kuu';

  @override
  String get previousPageTooltip => 'Eelmine leht';

  @override
  String get refreshIndicatorSemanticLabel => 'Värskendamine';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => 'Jäänud on 1 tähemärk';

  @override
  String get remainingTextFieldCharacterCountOther => r'Jäänud on $remainingCount tähemärki';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Teisalda alla';

  @override
  String get reorderItemLeft => 'Teisalda vasakule';

  @override
  String get reorderItemRight => 'Teisalda paremale';

  @override
  String get reorderItemToEnd => 'Teisalda lõppu';

  @override
  String get reorderItemToStart => 'Teisalda algusesse';

  @override
  String get reorderItemUp => 'Teisalda üles';

  @override
  String get rowsPerPageTitle => 'Ridu lehe kohta:';

  @override
  String get saveButtonLabel => 'SALVESTA';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Otsing';

  @override
  String get selectAllButtonLabel => 'Vali kõik';

  @override
  String get selectYearSemanticsLabel => 'Valige aasta';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => 'Valitud on 1 üksus';

  @override
  String get selectedRowCountTitleOther => r'Valitud on $selectedRowCount üksust';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Kuva kontod';

  @override
  String get showMenuTooltip => 'Kuva menüü';

  @override
  String get signedInLabel => 'Sisse logitud';

  @override
  String get tabLabelRaw => r'$tabIndex. vahekaart $tabCount-st';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'VALIGE AEG';

  @override
  String get timePickerHourLabel => 'Tund';

  @override
  String get timePickerHourModeAnnouncement => 'Tundide valimine';

  @override
  String get timePickerInputHelpText => 'SISESTAGE AEG';

  @override
  String get timePickerMinuteLabel => 'Minut';

  @override
  String get timePickerMinuteModeAnnouncement => 'Minutite valimine';

  @override
  String get unspecifiedDate => 'Kuupäev';

  @override
  String get unspecifiedDateRange => 'Kuupäevavahemik';

  @override
  String get viewLicensesButtonLabel => 'KUVA LITSENTSID';
}

/// The translations for Basque (`eu`).
class MaterialLocalizationEu extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Basque.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationEu({
    String localeName = 'eu',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName aplikazioari buruz';

  @override
  String get alertDialogLabel => 'Alerta';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'Atzera';

  @override
  String get calendarModeButtonLabel => 'Aldatu egutegiaren modura';

  @override
  String get cancelButtonLabel => 'UTZI';

  @override
  String get closeButtonLabel => 'ITXI';

  @override
  String get closeButtonTooltip => 'Itxi';

  @override
  String get collapsedIconTapHint => 'Zabaldu';

  @override
  String get continueButtonLabel => 'EGIN AURRERA';

  @override
  String get copyButtonLabel => 'Kopiatu';

  @override
  String get cutButtonLabel => 'Ebaki';

  @override
  String get dateHelpText => 'uuuu/hh/ee';

  @override
  String get dateInputLabel => 'Idatzi data';

  @override
  String get dateOutOfRangeLabel => 'Barrutitik kanpo.';

  @override
  String get datePickerHelpText => 'HAUTATU DATA';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Amaiera-data: $fullDate';

  @override
  String get dateRangeEndLabel => 'Amaiera-data';

  @override
  String get dateRangePickerHelpText => 'HAUTATU BARRUTIA';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Hasiera-data: $fullDate';

  @override
  String get dateRangeStartLabel => 'Hasiera-data';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'Ezabatu';

  @override
  String get dialModeButtonLabel => 'Aldatu esfera hautatzeko modura';

  @override
  String get dialogLabel => 'Leihoa';

  @override
  String get drawerLabel => 'Nabigazio-menua';

  @override
  String get expandedIconTapHint => 'Tolestu';

  @override
  String get firstPageTooltip => 'Lehenengo orria';

  @override
  String get hideAccountsLabel => 'Ezkutatu kontuak';

  @override
  String get inputDateModeButtonLabel => 'Aldatu datak aukeratzeko modura';

  @override
  String get inputTimeModeButtonLabel => 'Aldatu testua idazteko modura';

  @override
  String get invalidDateFormatLabel => 'Formatuak ez du balio.';

  @override
  String get invalidDateRangeLabel => 'Tarteak ez du balio.';

  @override
  String get invalidTimeLabel => 'Idatzi balio duen ordu bat';

  @override
  String get lastPageTooltip => 'Azken orria';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 lizentzia';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount lizentzia';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Lizentziak';

  @override
  String get modalBarrierDismissLabel => 'Baztertu';

  @override
  String get moreButtonTooltip => 'Gehiago';

  @override
  String get nextMonthTooltip => 'Hurrengo hilabetea';

  @override
  String get nextPageTooltip => 'Hurrengo orria';

  @override
  String get okButtonLabel => 'Ados';

  @override
  String get openAppDrawerTooltip => 'Ireki nabigazio-menua';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow - $lastRow / $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow - $lastRow / $rowCount';

  @override
  String get pasteButtonLabel => 'Itsatsi';

  @override
  String get popupMenuLabel => 'Menu gainerakorra';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'Aurreko hilabetea';

  @override
  String get previousPageTooltip => 'Aurreko orria';

  @override
  String get refreshIndicatorSemanticLabel => 'Freskatu';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 karaktere geratzen da';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount karaktere geratzen dira';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => 'Eraman behera';

  @override
  String get reorderItemLeft => 'Eraman ezkerrera';

  @override
  String get reorderItemRight => 'Eraman eskuinera';

  @override
  String get reorderItemToEnd => 'Eraman amaierara';

  @override
  String get reorderItemToStart => 'Eraman hasierara';

  @override
  String get reorderItemUp => 'Eraman gora';

  @override
  String get rowsPerPageTitle => 'Errenkadak orriko:';

  @override
  String get saveButtonLabel => 'GORDE';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Bilatu';

  @override
  String get selectAllButtonLabel => 'Hautatu guztiak';

  @override
  String get selectYearSemanticsLabel => 'Hautatu urtea';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 elementu hautatu da';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount elementu hautatu dira';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Erakutsi kontuak';

  @override
  String get showMenuTooltip => 'Erakutsi menua';

  @override
  String get signedInLabel => 'Hasi da saioa';

  @override
  String get tabLabelRaw => r'$tabIndex/$tabCount fitxa';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => 'HAUTATU ORDUA';

  @override
  String get timePickerHourLabel => 'Ordua';

  @override
  String get timePickerHourModeAnnouncement => 'Hautatu orduak';

  @override
  String get timePickerInputHelpText => 'IDATZI ORDUA';

  @override
  String get timePickerMinuteLabel => 'Minutua';

  @override
  String get timePickerMinuteModeAnnouncement => 'Hautatu minutuak';

  @override
  String get unspecifiedDate => 'Data';

  @override
  String get unspecifiedDateRange => 'Data tartea';

  @override
  String get viewLicensesButtonLabel => 'IKUSI LIZENTZIAK';
}

/// The translations for Persian (`fa`).
class MaterialLocalizationFa extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Persian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationFa({
    String localeName = 'fa',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'درباره $applicationName';

  @override
  String get alertDialogLabel => 'هشدار';

  @override
  String get anteMeridiemAbbreviation => 'ق.ظ.';

  @override
  String get backButtonTooltip => 'برگشت';

  @override
  String get calendarModeButtonLabel => 'رفتن به تقویم';

  @override
  String get cancelButtonLabel => 'لغو';

  @override
  String get closeButtonLabel => 'بستن';

  @override
  String get closeButtonTooltip => 'بستن';

  @override
  String get collapsedIconTapHint => 'بزرگ کردن';

  @override
  String get continueButtonLabel => 'ادامه';

  @override
  String get copyButtonLabel => 'کپی';

  @override
  String get cutButtonLabel => 'برش';

  @override
  String get dateHelpText => 'روز/ماه/سال';

  @override
  String get dateInputLabel => 'تاریخ را وارد کنید';

  @override
  String get dateOutOfRangeLabel => 'خارج از محدوده.';

  @override
  String get datePickerHelpText => 'انتخاب تاریخ';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'تاریخ پایان $fullDate';

  @override
  String get dateRangeEndLabel => 'تاریخ پایان';

  @override
  String get dateRangePickerHelpText => 'انتخاب محدوده';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'تاریخ شروع $fullDate';

  @override
  String get dateRangeStartLabel => 'تاریخ شروع';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'حذف';

  @override
  String get dialModeButtonLabel => 'رفتن به حالت انتخابگر صفحه ساعت';

  @override
  String get dialogLabel => 'کادر گفتگو';

  @override
  String get drawerLabel => 'منوی پیمایش';

  @override
  String get expandedIconTapHint => 'کوچک کردن';

  @override
  String get firstPageTooltip => 'صفحه اول';

  @override
  String get hideAccountsLabel => 'پنهان کردن حساب‌ها';

  @override
  String get inputDateModeButtonLabel => 'رفتن به ورودی';

  @override
  String get inputTimeModeButtonLabel => 'رفتن به حالت ورودی نوشتاری';

  @override
  String get invalidDateFormatLabel => 'قالب نامعتبر است.';

  @override
  String get invalidDateRangeLabel => 'محدوده نامعتبر است.';

  @override
  String get invalidTimeLabel => 'زمان معتبری وارد کنید';

  @override
  String get lastPageTooltip => 'صفحه آخر';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '۱ پروانه';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount پروانه';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'مجوزها';

  @override
  String get modalBarrierDismissLabel => 'نپذیرفتن';

  @override
  String get moreButtonTooltip => 'بیشتر';

  @override
  String get nextMonthTooltip => 'ماه بعد';

  @override
  String get nextPageTooltip => 'صفحه بعد';

  @override
  String get okButtonLabel => 'تأیید';

  @override
  String get openAppDrawerTooltip => 'باز کردن منوی پیمایش';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow از $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow از حدود $rowCount';

  @override
  String get pasteButtonLabel => 'جای‌گذاری';

  @override
  String get popupMenuLabel => 'منوی بازشو';

  @override
  String get postMeridiemAbbreviation => 'ب.ظ.';

  @override
  String get previousMonthTooltip => 'ماه قبل';

  @override
  String get previousPageTooltip => 'صفحه قبل';

  @override
  String get refreshIndicatorSemanticLabel => 'بازخوانی';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '۱ نویسه باقی مانده است';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount نویسه باقی مانده است';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'انتقال به پایین';

  @override
  String get reorderItemLeft => 'انتقال به راست';

  @override
  String get reorderItemRight => 'انتقال به چپ';

  @override
  String get reorderItemToEnd => 'انتقال به انتها';

  @override
  String get reorderItemToStart => 'انتقال به ابتدا';

  @override
  String get reorderItemUp => 'انتقال به بالا';

  @override
  String get rowsPerPageTitle => 'ردیف در هر صفحه:';

  @override
  String get saveButtonLabel => 'ذخیره';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.tall;

  @override
  String get searchFieldLabel => 'جستجو';

  @override
  String get selectAllButtonLabel => 'انتخاب همه';

  @override
  String get selectYearSemanticsLabel => 'انتخاب سال';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '۱ مورد انتخاب شد';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount مورد انتخاب شدند';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'نشان دادن حساب‌ها';

  @override
  String get showMenuTooltip => 'نمایش منو';

  @override
  String get signedInLabel => 'واردشده به سیستم';

  @override
  String get tabLabelRaw => r'برگه $tabIndex از $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => 'انتخاب زمان';

  @override
  String get timePickerHourLabel => 'ساعت';

  @override
  String get timePickerHourModeAnnouncement => 'انتخاب ساعت';

  @override
  String get timePickerInputHelpText => 'زمان را وارد کنید';

  @override
  String get timePickerMinuteLabel => 'دقیقه';

  @override
  String get timePickerMinuteModeAnnouncement => 'انتخاب دقیقه';

  @override
  String get unspecifiedDate => 'تاریخ';

  @override
  String get unspecifiedDateRange => 'محدوده تاریخ';

  @override
  String get viewLicensesButtonLabel => 'مشاهده مجوزها';
}

/// The translations for Finnish (`fi`).
class MaterialLocalizationFi extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Finnish.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationFi({
    String localeName = 'fi',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Tietoja: $applicationName';

  @override
  String get alertDialogLabel => 'Ilmoitus';

  @override
  String get anteMeridiemAbbreviation => 'ap';

  @override
  String get backButtonTooltip => 'Takaisin';

  @override
  String get calendarModeButtonLabel => 'Vaihda kalenteriin';

  @override
  String get cancelButtonLabel => 'PERUUTA';

  @override
  String get closeButtonLabel => 'SULJE';

  @override
  String get closeButtonTooltip => 'Sulje';

  @override
  String get collapsedIconTapHint => 'Laajenna';

  @override
  String get continueButtonLabel => 'JATKA';

  @override
  String get copyButtonLabel => 'Kopioi';

  @override
  String get cutButtonLabel => 'Leikkaa';

  @override
  String get dateHelpText => 'pp/kk/vvvv';

  @override
  String get dateInputLabel => 'Lisää päivämäärä';

  @override
  String get dateOutOfRangeLabel => 'Päivämäärä ei kelpaa';

  @override
  String get datePickerHelpText => 'VALITSE PÄIVÄMÄÄRÄ';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Päättymispäivä $fullDate';

  @override
  String get dateRangeEndLabel => 'Päättymispäivä';

  @override
  String get dateRangePickerHelpText => 'VALITSE PÄIVÄMÄÄRÄVÄLI';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Alkamispäivä $fullDate';

  @override
  String get dateRangeStartLabel => 'Alkamispäivä';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'Poista';

  @override
  String get dialModeButtonLabel => 'Valitse kellotauluvalitsin';

  @override
  String get dialogLabel => 'Valintaikkuna';

  @override
  String get drawerLabel => 'Navigointivalikko';

  @override
  String get expandedIconTapHint => 'Tiivistä';

  @override
  String get firstPageTooltip => 'Ensimmäinen sivu';

  @override
  String get hideAccountsLabel => 'Piilota tilit';

  @override
  String get inputDateModeButtonLabel => 'Vaihda tekstinsyöttöön';

  @override
  String get inputTimeModeButtonLabel => 'Valitse syöttötavaksi teksti';

  @override
  String get invalidDateFormatLabel => 'Virheellinen muoto';

  @override
  String get invalidDateRangeLabel => 'Virheellinen päivämääräväli';

  @override
  String get invalidTimeLabel => 'Lisää kelvollinen aika';

  @override
  String get lastPageTooltip => 'Viimeinen sivu';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 lisenssi';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount lisenssiä';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Lisenssit';

  @override
  String get modalBarrierDismissLabel => 'Ohita';

  @override
  String get moreButtonTooltip => 'Lisää';

  @override
  String get nextMonthTooltip => 'Seuraava kuukausi';

  @override
  String get nextPageTooltip => 'Seuraava sivu';

  @override
  String get okButtonLabel => 'OK';

  @override
  String get openAppDrawerTooltip => 'Avaa navigointivalikko';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow/$rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow/~$rowCount';

  @override
  String get pasteButtonLabel => 'Liitä';

  @override
  String get popupMenuLabel => 'Ponnahdusvalikko';

  @override
  String get postMeridiemAbbreviation => 'ip';

  @override
  String get previousMonthTooltip => 'Edellinen kuukausi';

  @override
  String get previousPageTooltip => 'Edellinen sivu';

  @override
  String get refreshIndicatorSemanticLabel => 'Päivitys';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 merkki jäljellä';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount merkkiä jäljellä';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Siirrä alas';

  @override
  String get reorderItemLeft => 'Siirrä vasemmalle';

  @override
  String get reorderItemRight => 'Siirrä oikealle';

  @override
  String get reorderItemToEnd => 'Siirrä loppuun';

  @override
  String get reorderItemToStart => 'Siirrä alkuun';

  @override
  String get reorderItemUp => 'Siirrä ylös';

  @override
  String get rowsPerPageTitle => 'Riviä/sivu:';

  @override
  String get saveButtonLabel => 'TALLENNA';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Haku';

  @override
  String get selectAllButtonLabel => 'Valitse kaikki';

  @override
  String get selectYearSemanticsLabel => 'Valitse vuosi';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 kohde valittu';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount kohdetta valittu';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Näytä tilit';

  @override
  String get showMenuTooltip => 'Näytä valikko';

  @override
  String get signedInLabel => 'Kirjautunut sisään';

  @override
  String get tabLabelRaw => r'Välilehti $tabIndex/$tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'VALITSE AIKA';

  @override
  String get timePickerHourLabel => 'Tunti';

  @override
  String get timePickerHourModeAnnouncement => 'Valitse tunnit';

  @override
  String get timePickerInputHelpText => 'LISÄÄ AIKA';

  @override
  String get timePickerMinuteLabel => 'Minuutti';

  @override
  String get timePickerMinuteModeAnnouncement => 'Valitse minuutit';

  @override
  String get unspecifiedDate => 'Päivämäärä';

  @override
  String get unspecifiedDateRange => 'Ajanjakso';

  @override
  String get viewLicensesButtonLabel => 'NÄYTÄ KÄYTTÖOIKEUDET';
}

/// The translations for Filipino Pilipino (`fil`).
class MaterialLocalizationFil extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Filipino Pilipino.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationFil({
    String localeName = 'fil',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Tungkol sa $applicationName';

  @override
  String get alertDialogLabel => 'Alerto';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'Bumalik';

  @override
  String get calendarModeButtonLabel => 'Lumipat sa kalendaryo';

  @override
  String get cancelButtonLabel => 'KANSELAHIN';

  @override
  String get closeButtonLabel => 'ISARA';

  @override
  String get closeButtonTooltip => 'Isara';

  @override
  String get collapsedIconTapHint => 'I-expand';

  @override
  String get continueButtonLabel => 'MAGPATULOY';

  @override
  String get copyButtonLabel => 'Kopyahin';

  @override
  String get cutButtonLabel => 'I-cut';

  @override
  String get dateHelpText => 'mm/dd/yyyy';

  @override
  String get dateInputLabel => 'Ilagay ang Petsa';

  @override
  String get dateOutOfRangeLabel => 'Wala sa hanay.';

  @override
  String get datePickerHelpText => 'PUMILI NG PETSA';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Petsa ng pagtatapos $fullDate';

  @override
  String get dateRangeEndLabel => 'Petsa ng Pagtatapos';

  @override
  String get dateRangePickerHelpText => 'PUMILI NG HANAY';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Petsa ng pagsisimula $fullDate';

  @override
  String get dateRangeStartLabel => 'Petsa ng Pagsisimula';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'I-delete';

  @override
  String get dialModeButtonLabel => 'Lumipat sa dial picker mode';

  @override
  String get dialogLabel => 'Dialog';

  @override
  String get drawerLabel => 'Menu ng navigation';

  @override
  String get expandedIconTapHint => 'I-collapse';

  @override
  String get firstPageTooltip => 'Unang page';

  @override
  String get hideAccountsLabel => 'Itago ang mga account';

  @override
  String get inputDateModeButtonLabel => 'Lumipat sa input';

  @override
  String get inputTimeModeButtonLabel => 'Lumipat sa text input mode';

  @override
  String get invalidDateFormatLabel => 'Invalid ang format.';

  @override
  String get invalidDateRangeLabel => 'Invalid ang hanay.';

  @override
  String get invalidTimeLabel => 'Maglagay ng valid na oras';

  @override
  String get lastPageTooltip => 'Huling page';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 lisensya';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount na lisensya';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Mga Lisensya';

  @override
  String get modalBarrierDismissLabel => 'I-dismiss';

  @override
  String get moreButtonTooltip => 'Higit Pa';

  @override
  String get nextMonthTooltip => 'Susunod na buwan';

  @override
  String get nextPageTooltip => 'Susunod na page';

  @override
  String get okButtonLabel => 'OK';

  @override
  String get openAppDrawerTooltip => 'Buksan ang menu ng navigation';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow ng $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow ng humigit kumulang $rowCount';

  @override
  String get pasteButtonLabel => 'I-paste';

  @override
  String get popupMenuLabel => 'Popup na menu';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'Nakaraang buwan';

  @override
  String get previousPageTooltip => 'Nakaraang page';

  @override
  String get refreshIndicatorSemanticLabel => 'Nagre-refresh';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 character ang natitira';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount na character ang natitira';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Ilipat pababa';

  @override
  String get reorderItemLeft => 'Ilipat pakaliwa';

  @override
  String get reorderItemRight => 'Ilipat pakanan';

  @override
  String get reorderItemToEnd => 'Ilipat sa dulo';

  @override
  String get reorderItemToStart => 'Ilipat sa simula';

  @override
  String get reorderItemUp => 'Ilipat pataas';

  @override
  String get rowsPerPageTitle => 'Mga row bawat page:';

  @override
  String get saveButtonLabel => 'I-SAVE';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Maghanap';

  @override
  String get selectAllButtonLabel => 'Piliin lahat';

  @override
  String get selectYearSemanticsLabel => 'Pumili ng taon';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 item ang napili';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount na item ang napili';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Ipakita ang mga account';

  @override
  String get showMenuTooltip => 'Ipakita ang menu';

  @override
  String get signedInLabel => 'Naka-sign in';

  @override
  String get tabLabelRaw => r'Tab $tabIndex ng $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'PUMILI NG ORAS';

  @override
  String get timePickerHourLabel => 'Oras';

  @override
  String get timePickerHourModeAnnouncement => 'Pumili ng mga oras';

  @override
  String get timePickerInputHelpText => 'MAGLAGAY NG ORAS';

  @override
  String get timePickerMinuteLabel => 'Minuto';

  @override
  String get timePickerMinuteModeAnnouncement => 'Pumili ng mga minuto';

  @override
  String get unspecifiedDate => 'Petsa';

  @override
  String get unspecifiedDateRange => 'Hanay ng Petsa';

  @override
  String get viewLicensesButtonLabel => 'TINGNAN ANG MGA LISENSYA';
}

/// The translations for French (`fr`).
class MaterialLocalizationFr extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for French.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationFr({
    String localeName = 'fr',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'À propos de $applicationName';

  @override
  String get alertDialogLabel => 'Alerte';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'Retour';

  @override
  String get calendarModeButtonLabel => "Passer à l'agenda";

  @override
  String get cancelButtonLabel => 'ANNULER';

  @override
  String get closeButtonLabel => 'FERMER';

  @override
  String get closeButtonTooltip => 'Fermer';

  @override
  String get collapsedIconTapHint => 'Développer';

  @override
  String get continueButtonLabel => 'CONTINUER';

  @override
  String get copyButtonLabel => 'Copier';

  @override
  String get cutButtonLabel => 'Couper';

  @override
  String get dateHelpText => 'jj/mm/aaaa';

  @override
  String get dateInputLabel => 'Saisir une date';

  @override
  String get dateOutOfRangeLabel => 'Hors de portée.';

  @override
  String get datePickerHelpText => 'SÉLECTIONNER UNE DATE';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Date de fin : $fullDate';

  @override
  String get dateRangeEndLabel => 'Date de fin';

  @override
  String get dateRangePickerHelpText => 'SÉLECTIONNER UNE PLAGE';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Date de début : $fullDate';

  @override
  String get dateRangeStartLabel => 'Date de début';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'Supprimer';

  @override
  String get dialModeButtonLabel => 'Passer au mode de sélection via le cadran';

  @override
  String get dialogLabel => 'Boîte de dialogue';

  @override
  String get drawerLabel => 'Menu de navigation';

  @override
  String get expandedIconTapHint => 'Réduire';

  @override
  String get firstPageTooltip => 'Première page';

  @override
  String get hideAccountsLabel => 'Masquer les comptes';

  @override
  String get inputDateModeButtonLabel => 'Passer à la saisie';

  @override
  String get inputTimeModeButtonLabel => 'Passer au mode de saisie au format texte';

  @override
  String get invalidDateFormatLabel => 'Format non valide.';

  @override
  String get invalidDateRangeLabel => 'Plage non valide.';

  @override
  String get invalidTimeLabel => 'Veuillez indiquer une heure valide';

  @override
  String get lastPageTooltip => 'Dernière page';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 licence';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licences';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Licences';

  @override
  String get modalBarrierDismissLabel => 'Ignorer';

  @override
  String get moreButtonTooltip => 'Plus';

  @override
  String get nextMonthTooltip => 'Mois suivant';

  @override
  String get nextPageTooltip => 'Page suivante';

  @override
  String get okButtonLabel => 'OK';

  @override
  String get openAppDrawerTooltip => 'Ouvrir le menu de navigation';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow – $lastRow sur $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow – $lastRow sur environ $rowCount';

  @override
  String get pasteButtonLabel => 'Coller';

  @override
  String get popupMenuLabel => 'Menu contextuel';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'Mois précédent';

  @override
  String get previousPageTooltip => 'Page précédente';

  @override
  String get refreshIndicatorSemanticLabel => 'Actualiser';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 caractère restant';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount caractères restants';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Déplacer vers le bas';

  @override
  String get reorderItemLeft => 'Déplacer vers la gauche';

  @override
  String get reorderItemRight => 'Déplacer vers la droite';

  @override
  String get reorderItemToEnd => 'Déplacer vers la fin';

  @override
  String get reorderItemToStart => 'Déplacer vers le début';

  @override
  String get reorderItemUp => 'Déplacer vers le haut';

  @override
  String get rowsPerPageTitle => 'Lignes par page :';

  @override
  String get saveButtonLabel => 'ENREGISTRER';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Rechercher';

  @override
  String get selectAllButtonLabel => 'Tout sélectionner';

  @override
  String get selectYearSemanticsLabel => 'Sélectionner une année';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 élément sélectionné';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount éléments sélectionnés';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => 'Aucun élément sélectionné';

  @override
  String get showAccountsLabel => 'Afficher les comptes';

  @override
  String get showMenuTooltip => 'Afficher le menu';

  @override
  String get signedInLabel => 'Connecté';

  @override
  String get tabLabelRaw => r'Onglet $tabIndex sur $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'SÉLECTIONNER UNE HEURE';

  @override
  String get timePickerHourLabel => 'Heure';

  @override
  String get timePickerHourModeAnnouncement => 'Sélectionner une heure';

  @override
  String get timePickerInputHelpText => 'SAISIR UNE HEURE';

  @override
  String get timePickerMinuteLabel => 'Minute';

  @override
  String get timePickerMinuteModeAnnouncement => 'Sélectionner des minutes';

  @override
  String get unspecifiedDate => 'Date';

  @override
  String get unspecifiedDateRange => 'Plage de dates';

  @override
  String get viewLicensesButtonLabel => 'AFFICHER LES LICENCES';
}

/// The translations for French, as used in Canada (`fr_CA`).
class MaterialLocalizationFrCa extends MaterialLocalizationFr {
  /// Create an instance of the translation bundle for French, as used in Canada.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationFrCa({
    String localeName = 'fr_CA',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get invalidTimeLabel => 'Entrez une heure valide';

  @override
  String get timePickerDialHelpText => "SÉLECTIONNER L'HEURE";

  @override
  String get timePickerInputHelpText => "ENTRER L'HEURE";

  @override
  String get timePickerMinuteLabel => 'Minutes';

  @override
  String get dialModeButtonLabel => 'Passer au mode de sélection du cadran';

  @override
  String get inputTimeModeButtonLabel => "Passer au mode d'entrée Texte";

  @override
  String get dateRangePickerHelpText => 'SÉLECTIONNER LA PLAGE';

  @override
  String get datePickerHelpText => 'SÉLECTIONNER LA DATE';

  @override
  String get invalidDateRangeLabel => 'Plage incorrecte.';

  @override
  String get invalidDateFormatLabel => 'Format incorrect';

  @override
  String get inputDateModeButtonLabel => "Passer à l'entrée";

  @override
  String get dateInputLabel => 'Entrer une date';

  @override
  String get unspecifiedDateRange => 'Période';

  @override
  String get dateHelpText => 'jj-mm-aaaa';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow à $lastRow sur $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow à $lastRow sur environ $rowCount';

  @override
  String get tabLabelRaw => r'Onglet $tabIndex sur $tabCount';

  @override
  String get anteMeridiemAbbreviation => 'am';

  @override
  String get postMeridiemAbbreviation => 'pm';

  @override
  String get timePickerHourModeAnnouncement => 'Sélectionnez les heures';

  @override
  String get timePickerMinuteModeAnnouncement => 'Sélectionnez les minutes';

  @override
  String get reorderItemToStart => 'Déplacer au début';

  @override
  String get reorderItemToEnd => 'Déplacer à la fin';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.frenchCanadian;
}

/// The translations for Galician (`gl`).
class MaterialLocalizationGl extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Galician.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationGl({
    String localeName = 'gl',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Acerca de: $applicationName';

  @override
  String get alertDialogLabel => 'Alerta';

  @override
  String get anteMeridiemAbbreviation => 'a.m.';

  @override
  String get backButtonTooltip => 'Atrás';

  @override
  String get calendarModeButtonLabel => 'Cambiar ao modo de calendario';

  @override
  String get cancelButtonLabel => 'CANCELAR';

  @override
  String get closeButtonLabel => 'PECHAR';

  @override
  String get closeButtonTooltip => 'Pechar';

  @override
  String get collapsedIconTapHint => 'Despregar';

  @override
  String get continueButtonLabel => 'CONTINUAR';

  @override
  String get copyButtonLabel => 'Copiar';

  @override
  String get cutButtonLabel => 'Cortar';

  @override
  String get dateHelpText => 'mm/dd/aaaa';

  @override
  String get dateInputLabel => 'Introduce a data';

  @override
  String get dateOutOfRangeLabel => 'A data está fóra do intervalo.';

  @override
  String get datePickerHelpText => 'SELECCIONAR UNHA DATA';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Data de finalización: $fullDate';

  @override
  String get dateRangeEndLabel => 'Data de finalización';

  @override
  String get dateRangePickerHelpText => 'SELECCIONAR UN INTERVALO DE DATAS';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Data de inicio: $fullDate';

  @override
  String get dateRangeStartLabel => 'Data de inicio';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'Eliminar';

  @override
  String get dialModeButtonLabel => 'Cambiar a modo de selector en esfera';

  @override
  String get dialogLabel => 'Cadro de diálogo';

  @override
  String get drawerLabel => 'Menú de navegación';

  @override
  String get expandedIconTapHint => 'Contraer';

  @override
  String get firstPageTooltip => 'Primeira páxina';

  @override
  String get hideAccountsLabel => 'Ocultar contas';

  @override
  String get inputDateModeButtonLabel => 'Cambiar ao modo de introdución de texto';

  @override
  String get inputTimeModeButtonLabel => 'Cambiar ao modo de escritura dos números';

  @override
  String get invalidDateFormatLabel => 'O formato non é válido.';

  @override
  String get invalidDateRangeLabel => 'O intervalo de datas non é válido.';

  @override
  String get invalidTimeLabel => 'Escribe unha hora válida';

  @override
  String get lastPageTooltip => 'Última páxina';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 licenza';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licenzas';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Licenzas';

  @override
  String get modalBarrierDismissLabel => 'Ignorar';

  @override
  String get moreButtonTooltip => 'Máis';

  @override
  String get nextMonthTooltip => 'Mes seguinte';

  @override
  String get nextPageTooltip => 'Páxina seguinte';

  @override
  String get okButtonLabel => 'Aceptar';

  @override
  String get openAppDrawerTooltip => 'Abrir menú de navegación';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow-$lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow-$lastRow de aproximadamente $rowCount';

  @override
  String get pasteButtonLabel => 'Pegar';

  @override
  String get popupMenuLabel => 'Menú emerxente';

  @override
  String get postMeridiemAbbreviation => 'p.m.';

  @override
  String get previousMonthTooltip => 'Mes anterior';

  @override
  String get previousPageTooltip => 'Páxina anterior';

  @override
  String get refreshIndicatorSemanticLabel => 'Actualizar';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 carácter restante';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount caracteres restantes';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Mover cara abaixo';

  @override
  String get reorderItemLeft => 'Mover cara á esquerda';

  @override
  String get reorderItemRight => 'Mover cara á dereita';

  @override
  String get reorderItemToEnd => 'Mover ao final';

  @override
  String get reorderItemToStart => 'Mover ao inicio';

  @override
  String get reorderItemUp => 'Mover cara arriba';

  @override
  String get rowsPerPageTitle => 'Filas por páxina:';

  @override
  String get saveButtonLabel => 'GARDAR';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Buscar';

  @override
  String get selectAllButtonLabel => 'Seleccionar todo';

  @override
  String get selectYearSemanticsLabel => 'Seleccionar ano';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => 'Seleccionouse 1 elemento';

  @override
  String get selectedRowCountTitleOther => r'Seleccionáronse $selectedRowCount elementos';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => 'Non se seleccionaron elementos';

  @override
  String get showAccountsLabel => 'Mostrar contas';

  @override
  String get showMenuTooltip => 'Mostrar menú';

  @override
  String get signedInLabel => 'Sesión iniciada';

  @override
  String get tabLabelRaw => r'Pestana $tabIndex de $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => 'SELECCIONA A HORA';

  @override
  String get timePickerHourLabel => 'Hora';

  @override
  String get timePickerHourModeAnnouncement => 'Seleccionar horas';

  @override
  String get timePickerInputHelpText => 'INDICA A HORA';

  @override
  String get timePickerMinuteLabel => 'Minuto';

  @override
  String get timePickerMinuteModeAnnouncement => 'Seleccionar minutos';

  @override
  String get unspecifiedDate => 'Data';

  @override
  String get unspecifiedDateRange => 'Intervalo de datas';

  @override
  String get viewLicensesButtonLabel => 'VER LICENZAS';
}

/// The translations for Swiss German Alemannic Alsatian (`gsw`).
class MaterialLocalizationGsw extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Swiss German Alemannic Alsatian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationGsw({
    String localeName = 'gsw',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Über $applicationName';

  @override
  String get alertDialogLabel => 'Benachrichtigung';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'Zurück';

  @override
  String get calendarModeButtonLabel => 'Zum Kalender wechseln';

  @override
  String get cancelButtonLabel => 'ABBRECHEN';

  @override
  String get closeButtonLabel => 'SCHLIEẞEN';

  @override
  String get closeButtonTooltip => 'Schließen';

  @override
  String get collapsedIconTapHint => 'Maximieren';

  @override
  String get continueButtonLabel => 'WEITER';

  @override
  String get copyButtonLabel => 'Kopieren';

  @override
  String get cutButtonLabel => 'Ausschneiden';

  @override
  String get dateHelpText => 'tt.mm.jjjj';

  @override
  String get dateInputLabel => 'Datum eingeben';

  @override
  String get dateOutOfRangeLabel => 'Außerhalb des Zeitraums.';

  @override
  String get datePickerHelpText => 'DATUM AUSWÄHLEN';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Enddatum $fullDate';

  @override
  String get dateRangeEndLabel => 'Enddatum';

  @override
  String get dateRangePickerHelpText => 'ZEITRAUM AUSWÄHLEN';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Startdatum $fullDate';

  @override
  String get dateRangeStartLabel => 'Startdatum';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'Löschen';

  @override
  String get dialModeButtonLabel => 'Zur Uhrzeitauswahl wechseln';

  @override
  String get dialogLabel => 'Dialogfeld';

  @override
  String get drawerLabel => 'Navigationsmenü';

  @override
  String get expandedIconTapHint => 'Minimieren';

  @override
  String get firstPageTooltip => 'Erste Seite';

  @override
  String get hideAccountsLabel => 'Konten ausblenden';

  @override
  String get inputDateModeButtonLabel => 'Zur Texteingabe wechseln';

  @override
  String get inputTimeModeButtonLabel => 'Zum Texteingabemodus wechseln';

  @override
  String get invalidDateFormatLabel => 'Ungültiges Format.';

  @override
  String get invalidDateRangeLabel => 'Ungültiger Zeitraum.';

  @override
  String get invalidTimeLabel => 'Geben Sie eine gültige Uhrzeit ein';

  @override
  String get lastPageTooltip => 'Letzte Seite';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 Lizenz';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount Lizenzen';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Lizenzen';

  @override
  String get modalBarrierDismissLabel => 'Schließen';

  @override
  String get moreButtonTooltip => 'Mehr';

  @override
  String get nextMonthTooltip => 'Nächster Monat';

  @override
  String get nextPageTooltip => 'Nächste Seite';

  @override
  String get okButtonLabel => 'OK';

  @override
  String get openAppDrawerTooltip => 'Navigationsmenü öffnen';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow von $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow von etwa $rowCount';

  @override
  String get pasteButtonLabel => 'Einsetzen';

  @override
  String get popupMenuLabel => 'Pop-up-Menü';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'Vorheriger Monat';

  @override
  String get previousPageTooltip => 'Vorherige Seite';

  @override
  String get refreshIndicatorSemanticLabel => 'Aktualisieren';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => 'Noch 1 Zeichen';

  @override
  String get remainingTextFieldCharacterCountOther => r'Noch $remainingCount Zeichen';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Nach unten verschieben';

  @override
  String get reorderItemLeft => 'Nach links verschieben';

  @override
  String get reorderItemRight => 'Nach rechts verschieben';

  @override
  String get reorderItemToEnd => 'An das Ende verschieben';

  @override
  String get reorderItemToStart => 'An den Anfang verschieben';

  @override
  String get reorderItemUp => 'Nach oben verschieben';

  @override
  String get rowsPerPageTitle => 'Zeilen pro Seite:';

  @override
  String get saveButtonLabel => 'SPEICHERN';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Suchen';

  @override
  String get selectAllButtonLabel => 'Alle auswählen';

  @override
  String get selectYearSemanticsLabel => 'Jahr auswählen';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 Element ausgewählt';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount Elemente ausgewählt';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Konten anzeigen';

  @override
  String get showMenuTooltip => 'Menü anzeigen';

  @override
  String get signedInLabel => 'Angemeldet';

  @override
  String get tabLabelRaw => r'Tab $tabIndex von $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'UHRZEIT AUSWÄHLEN';

  @override
  String get timePickerHourLabel => 'Stunde';

  @override
  String get timePickerHourModeAnnouncement => 'Stunden auswählen';

  @override
  String get timePickerInputHelpText => 'ZEIT EINGEBEN';

  @override
  String get timePickerMinuteLabel => 'Minute';

  @override
  String get timePickerMinuteModeAnnouncement => 'Minuten auswählen';

  @override
  String get unspecifiedDate => 'Datum';

  @override
  String get unspecifiedDateRange => 'Zeitraum';

  @override
  String get viewLicensesButtonLabel => 'LIZENZEN ANZEIGEN';
}

/// The translations for Gujarati (`gu`).
class MaterialLocalizationGu extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Gujarati.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationGu({
    String localeName = 'gu',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName વિશે';

  @override
  String get alertDialogLabel => 'અલર્ટ';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'પાછળ';

  @override
  String get calendarModeButtonLabel => 'કૅલેન્ડર મોડ પર સ્વિચ કરો';

  @override
  String get cancelButtonLabel => 'રદ કરો';

  @override
  String get closeButtonLabel => 'બંધ કરો';

  @override
  String get closeButtonTooltip => 'બંધ કરો';

  @override
  String get collapsedIconTapHint => 'વિસ્તૃત કરો';

  @override
  String get continueButtonLabel => 'ચાલુ રાખો';

  @override
  String get copyButtonLabel => 'કૉપિ કરો';

  @override
  String get cutButtonLabel => 'કાપો';

  @override
  String get dateHelpText => 'dd/mm/yyyy';

  @override
  String get dateInputLabel => 'તારીખ દાખલ કરો';

  @override
  String get dateOutOfRangeLabel => 'રેંજમાં નથી.';

  @override
  String get datePickerHelpText => 'તારીખ પસંદ કરો';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'સમાપ્તિની તારીખ $fullDate';

  @override
  String get dateRangeEndLabel => 'સમાપ્તિની તારીખ';

  @override
  String get dateRangePickerHelpText => 'રેંજ પસંદ કરો';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'શરૂ કરવાની તારીખ $fullDate';

  @override
  String get dateRangeStartLabel => 'શરૂ કરવાની તારીખ';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'ડિલીટ કરો';

  @override
  String get dialModeButtonLabel => 'ડાયલ પિકર મોડ પર સ્વિચ કરો';

  @override
  String get dialogLabel => 'સંવાદ';

  @override
  String get drawerLabel => 'નૅવિગેશન મેનૂ';

  @override
  String get expandedIconTapHint => 'સંકુચિત કરો';

  @override
  String get firstPageTooltip => 'પહેલું પેજ';

  @override
  String get hideAccountsLabel => 'એકાઉન્ટ છુપાવો';

  @override
  String get inputDateModeButtonLabel => 'ઇનપુટ મોડ પર સ્વિચ કરો';

  @override
  String get inputTimeModeButtonLabel => 'ટેક્સ્ટ ઇનપુટ મોડ પર સ્વિચ કરો';

  @override
  String get invalidDateFormatLabel => 'અમાન્ય ફોર્મેટ.';

  @override
  String get invalidDateRangeLabel => 'અમાન્ય રેંજ.';

  @override
  String get invalidTimeLabel => 'માન્ય સમય દાખલ કરો';

  @override
  String get lastPageTooltip => 'છેલ્લું પેજ';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 લાઇસન્સ';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount લાઇસન્સ';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'લાઇસન્સ';

  @override
  String get modalBarrierDismissLabel => 'છોડી દો';

  @override
  String get moreButtonTooltip => 'વધુ';

  @override
  String get nextMonthTooltip => 'આગલો મહિનો';

  @override
  String get nextPageTooltip => 'આગલું પેજ';

  @override
  String get okButtonLabel => 'ઓકે';

  @override
  String get openAppDrawerTooltip => 'નૅવિગેશન મેનૂ ખોલો';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCountમાંથી $firstRow–$lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'આશરે $rowCountમાંથી $firstRow–$lastRow';

  @override
  String get pasteButtonLabel => 'પેસ્ટ કરો';

  @override
  String get popupMenuLabel => 'પૉપઅપ મેનૂ';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'પાછલો મહિનો';

  @override
  String get previousPageTooltip => 'પાછલું પેજ';

  @override
  String get refreshIndicatorSemanticLabel => 'રિફ્રેશ કરો';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 અક્ષર બાકી';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount અક્ષર બાકી';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => 'નીચે ખસેડો';

  @override
  String get reorderItemLeft => 'ડાબે ખસેડો';

  @override
  String get reorderItemRight => 'જમણે ખસેડો';

  @override
  String get reorderItemToEnd => 'અંતમાં ખસેડો';

  @override
  String get reorderItemToStart => 'પ્રારંભમાં ખસેડો';

  @override
  String get reorderItemUp => 'ઉપર ખસેડો';

  @override
  String get rowsPerPageTitle => 'પેજ દીઠ પંક્તિઓ:';

  @override
  String get saveButtonLabel => 'સાચવો';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.tall;

  @override
  String get searchFieldLabel => 'શોધો';

  @override
  String get selectAllButtonLabel => 'બધા પસંદ કરો';

  @override
  String get selectYearSemanticsLabel => 'વર્ષ પસંદ કરો';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 આઇટમ પસંદ કરી';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount આઇટમ પસંદ કરી';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'એકાઉન્ટ બતાવો';

  @override
  String get showMenuTooltip => 'મેનૂ બતાવો';

  @override
  String get signedInLabel => 'આમાં સાઇન ઇન કર્યું છે';

  @override
  String get tabLabelRaw => r'$tabCountમાંથી $tabIndex ટૅબ';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => 'સમય પસંદ કરો';

  @override
  String get timePickerHourLabel => 'કલાક';

  @override
  String get timePickerHourModeAnnouncement => 'કલાક પસંદ કરો';

  @override
  String get timePickerInputHelpText => 'સમય દાખલ કરો';

  @override
  String get timePickerMinuteLabel => 'મિનિટ';

  @override
  String get timePickerMinuteModeAnnouncement => 'મિનિટ પસંદ કરો';

  @override
  String get unspecifiedDate => 'તારીખ';

  @override
  String get unspecifiedDateRange => 'તારીખ રેંજ';

  @override
  String get viewLicensesButtonLabel => 'લાઇસન્સ જુઓ';
}

/// The translations for Hebrew (`he`).
class MaterialLocalizationHe extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Hebrew.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationHe({
    String localeName = 'he',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'מידע על $applicationName';

  @override
  String get alertDialogLabel => 'התראה';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'הקודם';

  @override
  String get calendarModeButtonLabel => 'מעבר למצב היומן';

  @override
  String get cancelButtonLabel => 'ביטול';

  @override
  String get closeButtonLabel => 'סגירה';

  @override
  String get closeButtonTooltip => 'סגירה';

  @override
  String get collapsedIconTapHint => 'הרחבה';

  @override
  String get continueButtonLabel => 'המשך';

  @override
  String get copyButtonLabel => 'העתקה';

  @override
  String get cutButtonLabel => 'גזירה';

  @override
  String get dateHelpText => 'dd.mm.yyyy';

  @override
  String get dateInputLabel => 'יש להזין תאריך';

  @override
  String get dateOutOfRangeLabel => 'מחוץ לטווח.';

  @override
  String get datePickerHelpText => 'בחירת תאריך';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'תאריך סיום: $fullDate';

  @override
  String get dateRangeEndLabel => 'תאריך סיום';

  @override
  String get dateRangePickerHelpText => 'בחירת טווח';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'תאריך התחלה: $fullDate';

  @override
  String get dateRangeStartLabel => 'תאריך התחלה';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'מחיקה';

  @override
  String get dialModeButtonLabel => 'מעבר לבחירה באמצעות חוגה';

  @override
  String get dialogLabel => 'תיבת דו-שיח';

  @override
  String get drawerLabel => 'תפריט ניווט';

  @override
  String get expandedIconTapHint => 'כיווץ';

  @override
  String get firstPageTooltip => 'לדף הראשון';

  @override
  String get hideAccountsLabel => 'הסתרת החשבונות';

  @override
  String get inputDateModeButtonLabel => 'מעבר למצב הקלט';

  @override
  String get inputTimeModeButtonLabel => 'מעבר להזנת טקסט';

  @override
  String get invalidDateFormatLabel => 'פורמט לא חוקי.';

  @override
  String get invalidDateRangeLabel => 'טווח לא תקף.';

  @override
  String get invalidTimeLabel => 'יש להזין שעה תקינה';

  @override
  String get lastPageTooltip => 'לדף האחרון';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => r'$licenseCount רישיונות';

  @override
  String? get licensesPackageDetailTextOne => 'רישיון אחד';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount רישיונות';

  @override
  String? get licensesPackageDetailTextTwo => r'$licenseCount רישיונות';

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'רישיונות';

  @override
  String get modalBarrierDismissLabel => 'סגירה';

  @override
  String get moreButtonTooltip => 'עוד';

  @override
  String get nextMonthTooltip => 'החודש הבא';

  @override
  String get nextPageTooltip => 'הדף הבא';

  @override
  String get okButtonLabel => 'אישור';

  @override
  String get openAppDrawerTooltip => 'פתיחה של תפריט הניווט';

  @override
  String get pageRowsInfoTitleRaw => r'$lastRow–$firstRow מתוך $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$lastRow–$firstRow מתוך כ-$rowCount';

  @override
  String get pasteButtonLabel => 'הדבקה';

  @override
  String get popupMenuLabel => 'תפריט קופץ';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'החודש הקודם';

  @override
  String get previousPageTooltip => 'הדף הקודם';

  @override
  String get refreshIndicatorSemanticLabel => 'רענון';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => r'נותרו $remainingCount תווים';

  @override
  String? get remainingTextFieldCharacterCountOne => 'נותר תו אחד';

  @override
  String get remainingTextFieldCharacterCountOther => r'נותרו $remainingCount תווים';

  @override
  String? get remainingTextFieldCharacterCountTwo => r'נותרו $remainingCount תווים';

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'העברה למטה';

  @override
  String get reorderItemLeft => 'העברה שמאלה';

  @override
  String get reorderItemRight => 'העברה ימינה';

  @override
  String get reorderItemToEnd => 'העברה לסוף';

  @override
  String get reorderItemToStart => 'העברה להתחלה';

  @override
  String get reorderItemUp => 'העברה למעלה';

  @override
  String get rowsPerPageTitle => 'שורות בכל דף:';

  @override
  String get saveButtonLabel => 'שמירה';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'חיפוש';

  @override
  String get selectAllButtonLabel => 'בחירת הכול';

  @override
  String get selectYearSemanticsLabel => 'בחירת שנה';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => r'$selectedRowCount פריטים נבחרו';

  @override
  String? get selectedRowCountTitleOne => 'פריט אחד נבחר';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount פריטים נבחרו';

  @override
  String? get selectedRowCountTitleTwo => r'$selectedRowCount פריטים נבחרו';

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'הצגת החשבונות';

  @override
  String get showMenuTooltip => 'הצגת התפריט';

  @override
  String get signedInLabel => 'מחובר';

  @override
  String get tabLabelRaw => r'כרטיסייה $tabIndex מתוך $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => 'בחירת שעה';

  @override
  String get timePickerHourLabel => 'שעה';

  @override
  String get timePickerHourModeAnnouncement => 'בחירת שעות';

  @override
  String get timePickerInputHelpText => 'הזנת שעה';

  @override
  String get timePickerMinuteLabel => 'דקות';

  @override
  String get timePickerMinuteModeAnnouncement => 'בחירת דקות';

  @override
  String get unspecifiedDate => 'תאריך';

  @override
  String get unspecifiedDateRange => 'טווח תאריכים';

  @override
  String get viewLicensesButtonLabel => 'הצגת הרישיונות';
}

/// The translations for Hindi (`hi`).
class MaterialLocalizationHi extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Hindi.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationHi({
    String localeName = 'hi',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName के बारे में जानकारी';

  @override
  String get alertDialogLabel => 'अलर्ट';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'वापस जाएं';

  @override
  String get calendarModeButtonLabel => 'कैलेंडर पर जाएं';

  @override
  String get cancelButtonLabel => 'रद्द करें';

  @override
  String get closeButtonLabel => 'बंद करें';

  @override
  String get closeButtonTooltip => 'बंद करें';

  @override
  String get collapsedIconTapHint => 'बड़ा करें';

  @override
  String get continueButtonLabel => 'जारी रखें';

  @override
  String get copyButtonLabel => 'कॉपी करें';

  @override
  String get cutButtonLabel => 'काटें';

  @override
  String get dateHelpText => 'dd/mm/yyyy';

  @override
  String get dateInputLabel => 'तारीख डालें';

  @override
  String get dateOutOfRangeLabel => 'सीमा से ज़्यादा.';

  @override
  String get datePickerHelpText => 'तारीख चुनें';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'खत्म होने की तारीख $fullDate';

  @override
  String get dateRangeEndLabel => 'खत्म होने की तारीख';

  @override
  String get dateRangePickerHelpText => 'सीमा चुनें';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'शुरू होने की तारीख $fullDate';

  @override
  String get dateRangeStartLabel => 'शुरू होने की तारीख';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'मिटाएं';

  @override
  String get dialModeButtonLabel => 'डायल पिकर मोड पर स्विच करें';

  @override
  String get dialogLabel => 'संवाद';

  @override
  String get drawerLabel => 'नेविगेशन मेन्यू';

  @override
  String get expandedIconTapHint => 'छोटा करें';

  @override
  String get firstPageTooltip => 'पहला पेज';

  @override
  String get hideAccountsLabel => 'खाते छिपाएं';

  @override
  String get inputDateModeButtonLabel => 'इनपुट पर जाएं';

  @override
  String get inputTimeModeButtonLabel => 'टेक्स्ट के इनपुट मोड पर स्विच करें';

  @override
  String get invalidDateFormatLabel => 'अमान्य फ़ॉर्मैट.';

  @override
  String get invalidDateRangeLabel => 'तारीख की अमान्य सीमा.';

  @override
  String get invalidTimeLabel => 'मान्य समय डालें';

  @override
  String get lastPageTooltip => 'आखिरी पेज';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 लाइसेंस';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount लाइसेंस';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'लाइसेंस';

  @override
  String get modalBarrierDismissLabel => 'खारिज करें';

  @override
  String get moreButtonTooltip => 'ज़्यादा';

  @override
  String get nextMonthTooltip => 'अगला महीना';

  @override
  String get nextPageTooltip => 'अगला पेज';

  @override
  String get okButtonLabel => 'ठीक है';

  @override
  String get openAppDrawerTooltip => 'नेविगेशन मेन्यू खोलें';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCount का $firstRow–$lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$rowCount में से करीब $firstRow–$lastRow';

  @override
  String get pasteButtonLabel => 'चिपकाएं';

  @override
  String get popupMenuLabel => 'पॉपअप मेन्यू';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'पिछला महीना';

  @override
  String get previousPageTooltip => 'पिछला पेज';

  @override
  String get refreshIndicatorSemanticLabel => 'रीफ़्रेश करें';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => 'एक वर्ण आैर डाला जा सकता है';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount वर्ण आैर डाले जा सकते हैं';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'नीचे ले जाएं';

  @override
  String get reorderItemLeft => 'बाएं ले जाएं';

  @override
  String get reorderItemRight => 'दाएं ले जाएं';

  @override
  String get reorderItemToEnd => 'आखिर में ले जाएं';

  @override
  String get reorderItemToStart => 'शुरुआत पर ले जाएं';

  @override
  String get reorderItemUp => 'ऊपर ले जाएं';

  @override
  String get rowsPerPageTitle => 'हर पेज में पंक्तियों की संख्या:';

  @override
  String get saveButtonLabel => 'सेव करें';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.dense;

  @override
  String get searchFieldLabel => 'खोजें';

  @override
  String get selectAllButtonLabel => 'सभी को चुनें';

  @override
  String get selectYearSemanticsLabel => 'साल चुनें';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 चीज़ चुनी गई';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount चीज़ें चुनी गईं';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'खाते दिखाएं';

  @override
  String get showMenuTooltip => 'मेन्यू दिखाएं';

  @override
  String get signedInLabel => 'साइन इन किया हुआ है';

  @override
  String get tabLabelRaw => r'$tabCount का टैब $tabIndex';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.a_space_h_colon_mm;

  @override
  String get timePickerDialHelpText => 'समय क्षेत्र चुनें';

  @override
  String get timePickerHourLabel => 'घंटा';

  @override
  String get timePickerHourModeAnnouncement => 'घंटे के हिसाब से समय चुनें';

  @override
  String get timePickerInputHelpText => 'समय डालें';

  @override
  String get timePickerMinuteLabel => 'मिनट';

  @override
  String get timePickerMinuteModeAnnouncement => 'मिनट के हिसाब से समय चुनें';

  @override
  String get unspecifiedDate => 'तारीख';

  @override
  String get unspecifiedDateRange => 'तारीख की सीमा';

  @override
  String get viewLicensesButtonLabel => 'लाइसेंस देखें';
}

/// The translations for Croatian (`hr`).
class MaterialLocalizationHr extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Croatian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationHr({
    String localeName = 'hr',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'O aplikaciji $applicationName';

  @override
  String get alertDialogLabel => 'Upozorenje';

  @override
  String get anteMeridiemAbbreviation => 'prijepodne';

  @override
  String get backButtonTooltip => 'Natrag';

  @override
  String get calendarModeButtonLabel => 'Prijeđite na kalendar';

  @override
  String get cancelButtonLabel => 'ODUSTANI';

  @override
  String get closeButtonLabel => 'ZATVORI';

  @override
  String get closeButtonTooltip => 'Zatvaranje';

  @override
  String get collapsedIconTapHint => 'Proširi';

  @override
  String get continueButtonLabel => 'NASTAVI';

  @override
  String get copyButtonLabel => 'Kopiraj';

  @override
  String get cutButtonLabel => 'Izreži';

  @override
  String get dateHelpText => 'dd. mm. gggg.';

  @override
  String get dateInputLabel => 'Unesite datum';

  @override
  String get dateOutOfRangeLabel => 'Izvan raspona.';

  @override
  String get datePickerHelpText => 'ODABERITE DATUM';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Datum završetka $fullDate';

  @override
  String get dateRangeEndLabel => 'Datum završetka';

  @override
  String get dateRangePickerHelpText => 'ODABERITE RASPON';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Datum početka $fullDate';

  @override
  String get dateRangeStartLabel => 'Datum početka';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'Brisanje';

  @override
  String get dialModeButtonLabel => 'Prijelaz na način alata za odabir biranja';

  @override
  String get dialogLabel => 'Dijalog';

  @override
  String get drawerLabel => 'Navigacijski izbornik';

  @override
  String get expandedIconTapHint => 'Sažmi';

  @override
  String get firstPageTooltip => 'Prva stranica';

  @override
  String get hideAccountsLabel => 'Sakrijte račune';

  @override
  String get inputDateModeButtonLabel => 'Prijeđite na unos';

  @override
  String get inputTimeModeButtonLabel => 'Prijelaz na način unosa teksta';

  @override
  String get invalidDateFormatLabel => 'Format nije važeći.';

  @override
  String get invalidDateRangeLabel => 'Raspon nije važeći.';

  @override
  String get invalidTimeLabel => 'Unesite važeće vrijeme';

  @override
  String get lastPageTooltip => 'Posljednja stranica';

  @override
  String? get licensesPackageDetailTextFew => r'$licenseCount licence';

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 licenca';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licenci';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Licence';

  @override
  String get modalBarrierDismissLabel => 'Odbaci';

  @override
  String get moreButtonTooltip => 'Više';

  @override
  String get nextMonthTooltip => 'Sljedeći mjesec';

  @override
  String get nextPageTooltip => 'Sljedeća stranica';

  @override
  String get okButtonLabel => 'U REDU';

  @override
  String get openAppDrawerTooltip => 'Otvaranje izbornika za navigaciju';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow – $lastRow od $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow – $lastRow od otprilike $rowCount';

  @override
  String get pasteButtonLabel => 'Zalijepi';

  @override
  String get popupMenuLabel => 'Skočni izbornik';

  @override
  String get postMeridiemAbbreviation => 'popodne';

  @override
  String get previousMonthTooltip => 'Prethodni mjesec';

  @override
  String get previousPageTooltip => 'Prethodna stranica';

  @override
  String get refreshIndicatorSemanticLabel => 'Osvježi';

  @override
  String? get remainingTextFieldCharacterCountFew => r'Preostala su $remainingCount znaka';

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => 'Preostao je 1 znak';

  @override
  String get remainingTextFieldCharacterCountOther => r'Preostalo je $remainingCount znakova';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Pomakni prema dolje';

  @override
  String get reorderItemLeft => 'Pomakni ulijevo';

  @override
  String get reorderItemRight => 'Pomakni udesno';

  @override
  String get reorderItemToEnd => 'Premjesti na kraj';

  @override
  String get reorderItemToStart => 'Premjesti na početak';

  @override
  String get reorderItemUp => 'Pomakni prema gore';

  @override
  String get rowsPerPageTitle => 'Redaka po stranici:';

  @override
  String get saveButtonLabel => 'SPREMI';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Pretražite';

  @override
  String get selectAllButtonLabel => 'Odaberi sve';

  @override
  String get selectYearSemanticsLabel => 'Odaberite godinu';

  @override
  String? get selectedRowCountTitleFew => r'Odabrane su $selectedRowCount stavke';

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => 'Odabrana je jedna stavka';

  @override
  String get selectedRowCountTitleOther => r'Odabrano je $selectedRowCount stavki';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Prikažite račune';

  @override
  String get showMenuTooltip => 'Prikaz izbornika';

  @override
  String get signedInLabel => 'Prijavljeni korisnik';

  @override
  String get tabLabelRaw => r'Kartica $tabIndex od $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'ODABERITE VRIJEME';

  @override
  String get timePickerHourLabel => 'Sat';

  @override
  String get timePickerHourModeAnnouncement => 'Odaberite sate';

  @override
  String get timePickerInputHelpText => 'UNESITE VRIJEME';

  @override
  String get timePickerMinuteLabel => 'Minuta';

  @override
  String get timePickerMinuteModeAnnouncement => 'Odaberite minute';

  @override
  String get unspecifiedDate => 'Datum';

  @override
  String get unspecifiedDateRange => 'Datumski raspon';

  @override
  String get viewLicensesButtonLabel => 'PRIKAŽI LICENCE';
}

/// The translations for Hungarian (`hu`).
class MaterialLocalizationHu extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Hungarian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationHu({
    String localeName = 'hu',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'A(z) $applicationName névjegye';

  @override
  String get alertDialogLabel => 'Értesítés';

  @override
  String get anteMeridiemAbbreviation => 'de.';

  @override
  String get backButtonTooltip => 'Vissza';

  @override
  String get calendarModeButtonLabel => 'Váltás naptárra';

  @override
  String get cancelButtonLabel => 'MÉGSE';

  @override
  String get closeButtonLabel => 'BEZÁRÁS';

  @override
  String get closeButtonTooltip => 'Bezárás';

  @override
  String get collapsedIconTapHint => 'Kibontás';

  @override
  String get continueButtonLabel => 'TOVÁBB';

  @override
  String get copyButtonLabel => 'Másolás';

  @override
  String get cutButtonLabel => 'Kivágás';

  @override
  String get dateHelpText => 'éééé. hh. nn.';

  @override
  String get dateInputLabel => 'Adja meg a dátumot';

  @override
  String get dateOutOfRangeLabel => 'Tartományon kívül.';

  @override
  String get datePickerHelpText => 'DÁTUM KIVÁLASZTÁSA';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Befejezés dátuma: $fullDate';

  @override
  String get dateRangeEndLabel => 'Befejezés dátuma';

  @override
  String get dateRangePickerHelpText => 'TARTOMÁNY KIJELÖLÉSE';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Kezdés dátuma: $fullDate';

  @override
  String get dateRangeStartLabel => 'Kezdés dátuma';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'Törlés';

  @override
  String get dialModeButtonLabel => 'Váltás időpontválasztó módra';

  @override
  String get dialogLabel => 'Párbeszédablak';

  @override
  String get drawerLabel => 'Navigációs menü';

  @override
  String get expandedIconTapHint => 'Összecsukás';

  @override
  String get firstPageTooltip => 'Első oldal';

  @override
  String get hideAccountsLabel => 'Fiókok elrejtése';

  @override
  String get inputDateModeButtonLabel => 'Váltás bevitelre';

  @override
  String get inputTimeModeButtonLabel => 'Váltás szövegbeviteli módra';

  @override
  String get invalidDateFormatLabel => 'Érvénytelen formátum.';

  @override
  String get invalidDateRangeLabel => 'Érvénytelen tartomány.';

  @override
  String get invalidTimeLabel => 'Érvényes formátumban adja meg az időt';

  @override
  String get lastPageTooltip => 'Utolsó oldal';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 licenc';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licenc';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Licencek';

  @override
  String get modalBarrierDismissLabel => 'Elvetés';

  @override
  String get moreButtonTooltip => 'Több';

  @override
  String get nextMonthTooltip => 'Következő hónap';

  @override
  String get nextPageTooltip => 'Következő oldal';

  @override
  String get okButtonLabel => 'OK';

  @override
  String get openAppDrawerTooltip => 'Navigációs menü megnyitása';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCount/$firstRow–$lastRow.';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'Körülbelül $rowCount/$firstRow–$lastRow.';

  @override
  String get pasteButtonLabel => 'Beillesztés';

  @override
  String get popupMenuLabel => 'Előugró menü';

  @override
  String get postMeridiemAbbreviation => 'du.';

  @override
  String get previousMonthTooltip => 'Előző hónap';

  @override
  String get previousPageTooltip => 'Előző oldal';

  @override
  String get refreshIndicatorSemanticLabel => 'Frissítés';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 karakter maradt';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount karakter maradt';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Áthelyezés lefelé';

  @override
  String get reorderItemLeft => 'Áthelyezés balra';

  @override
  String get reorderItemRight => 'Áthelyezés jobbra';

  @override
  String get reorderItemToEnd => 'Áthelyezés a végére';

  @override
  String get reorderItemToStart => 'Áthelyezés az elejére';

  @override
  String get reorderItemUp => 'Áthelyezés felfelé';

  @override
  String get rowsPerPageTitle => 'Oldalankénti sorszám:';

  @override
  String get saveButtonLabel => 'MENTÉS';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Keresés';

  @override
  String get selectAllButtonLabel => 'Összes kijelölése';

  @override
  String get selectYearSemanticsLabel => 'Válassza ki az évet';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 elem kiválasztva';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount elem kiválasztva';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Fiókok megjelenítése';

  @override
  String get showMenuTooltip => 'Menü megjelenítése';

  @override
  String get signedInLabel => 'Bejelentkezve';

  @override
  String get tabLabelRaw => r'$tabCount/$tabIndex. lap';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'IDŐPONT KIVÁLASZTÁSA';

  @override
  String get timePickerHourLabel => 'Óra';

  @override
  String get timePickerHourModeAnnouncement => 'Óra kiválasztása';

  @override
  String get timePickerInputHelpText => 'IDŐPONT MEGADÁSA';

  @override
  String get timePickerMinuteLabel => 'Perc';

  @override
  String get timePickerMinuteModeAnnouncement => 'Perc kiválasztása';

  @override
  String get unspecifiedDate => 'Dátum';

  @override
  String get unspecifiedDateRange => 'Dátumtartomány';

  @override
  String get viewLicensesButtonLabel => 'LICENCEK MEGTEKINTÉSE';
}

/// The translations for Armenian (`hy`).
class MaterialLocalizationHy extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Armenian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationHy({
    String localeName = 'hy',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName հավելվածի մասին';

  @override
  String get alertDialogLabel => 'Ծանուցում';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'Հետ';

  @override
  String get calendarModeButtonLabel => 'Անցնել օրացույցին';

  @override
  String get cancelButtonLabel => 'ՉԵՂԱՐԿԵԼ';

  @override
  String get closeButtonLabel => 'ՓԱԿԵԼ';

  @override
  String get closeButtonTooltip => 'Փակել';

  @override
  String get collapsedIconTapHint => 'Ծավալել';

  @override
  String get continueButtonLabel => 'ՇԱՐՈՒՆԱԿԵԼ';

  @override
  String get copyButtonLabel => 'Պատճենել';

  @override
  String get cutButtonLabel => 'Կտրել';

  @override
  String get dateHelpText => 'օօ.աա.տտտտ';

  @override
  String get dateInputLabel => 'Մուտքագրել ամսաթիվ';

  @override
  String get dateOutOfRangeLabel => 'Թույլատրելի ընդգրկույթից դուրս է։';

  @override
  String get datePickerHelpText => 'ԸՆՏՐԵԼ ԱՄՍԱԹԻՎ';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Ավարտի ամսաթիվը՝ $fullDate';

  @override
  String get dateRangeEndLabel => 'Ավարտի ամսաթիվը';

  @override
  String get dateRangePickerHelpText => 'ԸՆՏՐԵԼ ԺԱՄԱՆԱԿԱՀԱՏՎԱԾ';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Մեկնարկի ամսաթիվը՝ $fullDate';

  @override
  String get dateRangeStartLabel => 'Մեկնարկի ամսաթիվը';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'Ջնջել';

  @override
  String get dialModeButtonLabel => 'Անցնել թվերի ընտրման ռեժիմին';

  @override
  String get dialogLabel => 'Երկխոսության պատուհան';

  @override
  String get drawerLabel => 'Նավիգացիայի ընտրացանկ';

  @override
  String get expandedIconTapHint => 'Ծալել';

  @override
  String get firstPageTooltip => 'Առաջին էջ';

  @override
  String get hideAccountsLabel => 'Թաքցնել հաշիվները';

  @override
  String get inputDateModeButtonLabel => 'Անցնել ներածման ռեժիմին';

  @override
  String get inputTimeModeButtonLabel => 'Անցնել տեքստի մուտքագրման ռեժիմին';

  @override
  String get invalidDateFormatLabel => 'Ձևաչափն անվավեր է։';

  @override
  String get invalidDateRangeLabel => 'Ժամանակահատվածն անվավեր է:';

  @override
  String get invalidTimeLabel => 'Մուտքագրեք վավեր ժամ';

  @override
  String get lastPageTooltip => 'Վերջին էջ';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 լիցենզիա';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount լիցենզիա';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Արտոնագրեր';

  @override
  String get modalBarrierDismissLabel => 'Փակել';

  @override
  String get moreButtonTooltip => 'Այլ';

  @override
  String get nextMonthTooltip => 'Հաջորդ ամիս';

  @override
  String get nextPageTooltip => 'Հաջորդ էջ';

  @override
  String get okButtonLabel => 'Եղավ';

  @override
  String get openAppDrawerTooltip => 'Բացել նավիգացիայի ընտրացանկը';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow $rowCount-ից';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow մոտավորապես $rowCount-ից';

  @override
  String get pasteButtonLabel => 'Տեղադրել';

  @override
  String get popupMenuLabel => 'Ելնող ընտրացանկ';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'Նախորդ ամիս';

  @override
  String get previousPageTooltip => 'Նախորդ էջ';

  @override
  String get refreshIndicatorSemanticLabel => 'Թարմացնել';

  @override
  String? get remainingTextFieldCharacterCountFew => r'Մնաց $remainingCount նիշ';

  @override
  String? get remainingTextFieldCharacterCountMany => r'Մնաց $remainingCount նիշ';

  @override
  String? get remainingTextFieldCharacterCountOne => 'Մնացել է 1 նիշ';

  @override
  String get remainingTextFieldCharacterCountOther => r'Մնացել է $remainingCount նիշ';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'Նիշի հնարավորություն չկա';

  @override
  String get reorderItemDown => 'Տեղափոխել ներքև';

  @override
  String get reorderItemLeft => 'Տեղափոխել ձախ';

  @override
  String get reorderItemRight => 'Տեղափոխել աջ';

  @override
  String get reorderItemToEnd => 'Տեղափոխել վերջ';

  @override
  String get reorderItemToStart => 'Տեղափոխել սկիզբ';

  @override
  String get reorderItemUp => 'Տեղափոխել վերև';

  @override
  String get rowsPerPageTitle => 'Մեկ էջի տողերը՝';

  @override
  String get saveButtonLabel => 'ՊԱՀԵԼ';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Որոնել';

  @override
  String get selectAllButtonLabel => 'Նշել բոլորը';

  @override
  String get selectYearSemanticsLabel => 'Ընտրել տարին';

  @override
  String? get selectedRowCountTitleFew => r'Ընտրված է $selectedRowCount օբյեկտ';

  @override
  String? get selectedRowCountTitleMany => r'Ընտրված է $selectedRowCount օբյեկտ';

  @override
  String? get selectedRowCountTitleOne => 'Ընտրվել է 1 տարր';

  @override
  String get selectedRowCountTitleOther => r'Ընտրվել է $selectedRowCount տարր';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => 'Տողերը ընտրված չեն';

  @override
  String get showAccountsLabel => 'Ցույց տալ հաշիվները';

  @override
  String get showMenuTooltip => 'Ցույց տալ ընտրացանկը';

  @override
  String get signedInLabel => 'Դուք մուտք եք գործել';

  @override
  String get tabLabelRaw => r'Ներդիր $tabIndex՝ $tabCount-ից';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => 'ԸՆՏՐԵՔ ԺԱՄԸ';

  @override
  String get timePickerHourLabel => 'Ժամ';

  @override
  String get timePickerHourModeAnnouncement => 'Ընտրեք ժամը';

  @override
  String get timePickerInputHelpText => 'ՄՈՒՏՔԱԳՐԵՔ ԺԱՄԸ';

  @override
  String get timePickerMinuteLabel => 'Րոպե';

  @override
  String get timePickerMinuteModeAnnouncement => 'Ընտրեք րոպեները';

  @override
  String get unspecifiedDate => 'Ամսաթիվ';

  @override
  String get unspecifiedDateRange => 'Ժամանակահատված';

  @override
  String get viewLicensesButtonLabel => 'ԴԻՏԵԼ ԱՐՏՈՆԱԳՐԵՐԸ';
}

/// The translations for Indonesian (`id`).
class MaterialLocalizationId extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Indonesian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationId({
    String localeName = 'id',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Tentang $applicationName';

  @override
  String get alertDialogLabel => 'Notifikasi';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'Kembali';

  @override
  String get calendarModeButtonLabel => 'Beralih ke kalender';

  @override
  String get cancelButtonLabel => 'BATAL';

  @override
  String get closeButtonLabel => 'TUTUP';

  @override
  String get closeButtonTooltip => 'Tutup';

  @override
  String get collapsedIconTapHint => 'Luaskan';

  @override
  String get continueButtonLabel => 'LANJUTKAN';

  @override
  String get copyButtonLabel => 'Salin';

  @override
  String get cutButtonLabel => 'Potong';

  @override
  String get dateHelpText => 'hh/bb/tttt';

  @override
  String get dateInputLabel => 'Masukkan Tanggal';

  @override
  String get dateOutOfRangeLabel => 'Di luar rentang.';

  @override
  String get datePickerHelpText => 'PILIH TANGGAL';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Tanggal akhir $fullDate';

  @override
  String get dateRangeEndLabel => 'Tanggal Akhir';

  @override
  String get dateRangePickerHelpText => 'PILIH RENTANG';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Tanggal mulai $fullDate';

  @override
  String get dateRangeStartLabel => 'Tanggal Mulai';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'Hapus';

  @override
  String get dialModeButtonLabel => 'Beralih ke mode tampilan jam';

  @override
  String get dialogLabel => 'Dialog';

  @override
  String get drawerLabel => 'Menu navigasi';

  @override
  String get expandedIconTapHint => 'Ciutkan';

  @override
  String get firstPageTooltip => 'Halaman pertama';

  @override
  String get hideAccountsLabel => 'Sembunyikan akun';

  @override
  String get inputDateModeButtonLabel => 'Beralih ke masukan';

  @override
  String get inputTimeModeButtonLabel => 'Beralih ke mode input teks';

  @override
  String get invalidDateFormatLabel => 'Format tidak valid.';

  @override
  String get invalidDateRangeLabel => 'Rentang tidak valid.';

  @override
  String get invalidTimeLabel => 'Masukkan waktu yang valid';

  @override
  String get lastPageTooltip => 'Halaman terakhir';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 lisensi';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount lisensi';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Lisensi';

  @override
  String get modalBarrierDismissLabel => 'Tutup';

  @override
  String get moreButtonTooltip => 'Lainnya';

  @override
  String get nextMonthTooltip => 'Bulan berikutnya';

  @override
  String get nextPageTooltip => 'Halaman berikutnya';

  @override
  String get okButtonLabel => 'OKE';

  @override
  String get openAppDrawerTooltip => 'Buka menu navigasi';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow dari $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow dari kira-kira $rowCount';

  @override
  String get pasteButtonLabel => 'Tempel';

  @override
  String get popupMenuLabel => 'Menu pop-up';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'Bulan sebelumnya';

  @override
  String get previousPageTooltip => 'Halaman sebelumnya';

  @override
  String get refreshIndicatorSemanticLabel => 'Memuat ulang';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => 'Sisa 1 karakter';

  @override
  String get remainingTextFieldCharacterCountOther => r'Sisa $remainingCount karakter';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Turunkan';

  @override
  String get reorderItemLeft => 'Pindahkan ke kiri';

  @override
  String get reorderItemRight => 'Pindahkan ke kanan';

  @override
  String get reorderItemToEnd => 'Pindahkan ke akhir';

  @override
  String get reorderItemToStart => 'Pindahkan ke awal';

  @override
  String get reorderItemUp => 'Naikkan';

  @override
  String get rowsPerPageTitle => 'Baris per halaman:';

  @override
  String get saveButtonLabel => 'SIMPAN';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Telusuri';

  @override
  String get selectAllButtonLabel => 'Pilih semua';

  @override
  String get selectYearSemanticsLabel => 'Pilih tahun';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 item dipilih';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount item dipilih';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Tampilkan akun';

  @override
  String get showMenuTooltip => 'Tampilkan menu';

  @override
  String get signedInLabel => 'Telah login';

  @override
  String get tabLabelRaw => r'Tab $tabIndex dari $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'PILIH WAKTU';

  @override
  String get timePickerHourLabel => 'Jam';

  @override
  String get timePickerHourModeAnnouncement => 'Pilih jam';

  @override
  String get timePickerInputHelpText => 'MASUKKAN WAKTU';

  @override
  String get timePickerMinuteLabel => 'Menit';

  @override
  String get timePickerMinuteModeAnnouncement => 'Pilih menit';

  @override
  String get unspecifiedDate => 'Tanggal';

  @override
  String get unspecifiedDateRange => 'Rentang tanggal';

  @override
  String get viewLicensesButtonLabel => 'LIHAT LISENSI';
}

/// The translations for Icelandic (`is`).
class MaterialLocalizationIs extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Icelandic.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationIs({
    String localeName = 'is',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Um $applicationName';

  @override
  String get alertDialogLabel => 'Tilkynning';

  @override
  String get anteMeridiemAbbreviation => 'f.h.';

  @override
  String get backButtonTooltip => 'Til baka';

  @override
  String get calendarModeButtonLabel => 'Skipta yfir í dagatal';

  @override
  String get cancelButtonLabel => 'HÆTTA';

  @override
  String get closeButtonLabel => 'LOKA';

  @override
  String get closeButtonTooltip => 'Loka';

  @override
  String get collapsedIconTapHint => 'Stækka';

  @override
  String get continueButtonLabel => 'HALDA ÁFRAM';

  @override
  String get copyButtonLabel => 'Afrita';

  @override
  String get cutButtonLabel => 'Klippa';

  @override
  String get dateHelpText => 'dd.mm.áááá';

  @override
  String get dateInputLabel => 'Slá inn dagsetningu';

  @override
  String get dateOutOfRangeLabel => 'Utan sviðs.';

  @override
  String get datePickerHelpText => 'VELJA DAGSETNINGU';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Lokadagur $fullDate';

  @override
  String get dateRangeEndLabel => 'Lokadagur';

  @override
  String get dateRangePickerHelpText => 'VELJA SVIÐ';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Upphafsdagur $fullDate';

  @override
  String get dateRangeStartLabel => 'Upphafsdagur';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'Eyða';

  @override
  String get dialModeButtonLabel => 'Skiptu yfir í skífuval';

  @override
  String get dialogLabel => 'Gluggi';

  @override
  String get drawerLabel => 'Yfirlitsvalmynd';

  @override
  String get expandedIconTapHint => 'Draga saman';

  @override
  String get firstPageTooltip => 'Fyrsta síða';

  @override
  String get hideAccountsLabel => 'Fela reikninga';

  @override
  String get inputDateModeButtonLabel => 'Skipta yfir í innslátt';

  @override
  String get inputTimeModeButtonLabel => 'Skiptu yfir í textainnslátt';

  @override
  String get invalidDateFormatLabel => 'Ógilt snið.';

  @override
  String get invalidDateRangeLabel => 'Ógilt svið.';

  @override
  String get invalidTimeLabel => 'Færðu inn gildan tíma';

  @override
  String get lastPageTooltip => 'Síðasta síða';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 leyfi';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount leyfi';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Leyfi';

  @override
  String get modalBarrierDismissLabel => 'Hunsa';

  @override
  String get moreButtonTooltip => 'Meira';

  @override
  String get nextMonthTooltip => 'Næsti mánuður';

  @override
  String get nextPageTooltip => 'Næsta síða';

  @override
  String get okButtonLabel => 'Í lagi';

  @override
  String get openAppDrawerTooltip => 'Opna yfirlitsvalmynd';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow – $lastRow af $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow – $lastRow af um það bil $rowCount';

  @override
  String get pasteButtonLabel => 'Líma';

  @override
  String get popupMenuLabel => 'Sprettivalmynd';

  @override
  String get postMeridiemAbbreviation => 'e.h.';

  @override
  String get previousMonthTooltip => 'Fyrri mánuður';

  @override
  String get previousPageTooltip => 'Fyrri síða';

  @override
  String get refreshIndicatorSemanticLabel => 'Endurnýja';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 stafur eftir';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount stafir eftir';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => 'Færa niður';

  @override
  String get reorderItemLeft => 'Færa til vinstri';

  @override
  String get reorderItemRight => 'Færa til hægri';

  @override
  String get reorderItemToEnd => 'Færa aftast';

  @override
  String get reorderItemToStart => 'Færa fremst';

  @override
  String get reorderItemUp => 'Færa upp';

  @override
  String get rowsPerPageTitle => 'Línur á síðu:';

  @override
  String get saveButtonLabel => 'VISTA';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Leit';

  @override
  String get selectAllButtonLabel => 'Velja allt';

  @override
  String get selectYearSemanticsLabel => 'Velja ár';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 atriði valið';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount atriði valin';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Sýna reikninga';

  @override
  String get showMenuTooltip => 'Sýna valmynd';

  @override
  String get signedInLabel => 'Innskráð(ur)';

  @override
  String get tabLabelRaw => r'Flipi $tabIndex af $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => 'VELJA TÍMA';

  @override
  String get timePickerHourLabel => 'Klukkustund';

  @override
  String get timePickerHourModeAnnouncement => 'Velja klukkustundir';

  @override
  String get timePickerInputHelpText => 'FÆRA INN TÍMA';

  @override
  String get timePickerMinuteLabel => 'Mínúta';

  @override
  String get timePickerMinuteModeAnnouncement => 'Velja mínútur';

  @override
  String get unspecifiedDate => 'Dagsetning';

  @override
  String get unspecifiedDateRange => 'Tímabil';

  @override
  String get viewLicensesButtonLabel => 'SKOÐA LEYFI';
}

/// The translations for Italian (`it`).
class MaterialLocalizationIt extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Italian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationIt({
    String localeName = 'it',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Informazioni su $applicationName';

  @override
  String get alertDialogLabel => 'Avviso';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'Indietro';

  @override
  String get calendarModeButtonLabel => 'Passa al calendario';

  @override
  String get cancelButtonLabel => 'ANNULLA';

  @override
  String get closeButtonLabel => 'CHIUDI';

  @override
  String get closeButtonTooltip => 'Chiudi';

  @override
  String get collapsedIconTapHint => 'Espandi';

  @override
  String get continueButtonLabel => 'CONTINUA';

  @override
  String get copyButtonLabel => 'Copia';

  @override
  String get cutButtonLabel => 'Taglia';

  @override
  String get dateHelpText => 'mm/gg/aaaa';

  @override
  String get dateInputLabel => 'Inserisci data';

  @override
  String get dateOutOfRangeLabel => 'Fuori intervallo.';

  @override
  String get datePickerHelpText => 'SELEZIONA DATA';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Data di fine $fullDate';

  @override
  String get dateRangeEndLabel => 'Data di fine';

  @override
  String get dateRangePickerHelpText => 'SELEZIONA INTERVALLO';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Data di inizio $fullDate';

  @override
  String get dateRangeStartLabel => 'Data di inizio';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'Elimina';

  @override
  String get dialModeButtonLabel => 'Passa alla modalità selettore del quadrante';

  @override
  String get dialogLabel => 'Finestra di dialogo';

  @override
  String get drawerLabel => 'Menu di navigazione';

  @override
  String get expandedIconTapHint => 'Comprimi';

  @override
  String get firstPageTooltip => 'Prima pagina';

  @override
  String get hideAccountsLabel => 'Nascondi account';

  @override
  String get inputDateModeButtonLabel => 'Passa alla modalità di immissione';

  @override
  String get inputTimeModeButtonLabel => 'Passa alla modalità immissione testo';

  @override
  String get invalidDateFormatLabel => 'Formato non valido.';

  @override
  String get invalidDateRangeLabel => 'Intervallo non valido.';

  @override
  String get invalidTimeLabel => 'Inserisci un orario valido';

  @override
  String get lastPageTooltip => 'Ultima pagina';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 licenza';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licenze';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Licenze';

  @override
  String get modalBarrierDismissLabel => 'Ignora';

  @override
  String get moreButtonTooltip => 'Altro';

  @override
  String get nextMonthTooltip => 'Mese successivo';

  @override
  String get nextPageTooltip => 'Pagina successiva';

  @override
  String get okButtonLabel => 'OK';

  @override
  String get openAppDrawerTooltip => 'Apri il menu di navigazione';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow-$lastRow di $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow-$lastRow di circa $rowCount';

  @override
  String get pasteButtonLabel => 'Incolla';

  @override
  String get popupMenuLabel => 'Menu popup';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'Mese precedente';

  @override
  String get previousPageTooltip => 'Pagina precedente';

  @override
  String get refreshIndicatorSemanticLabel => 'Aggiorna';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 carattere rimanente';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount caratteri rimanenti';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Sposta giù';

  @override
  String get reorderItemLeft => 'Sposta a sinistra';

  @override
  String get reorderItemRight => 'Sposta a destra';

  @override
  String get reorderItemToEnd => 'Sposta alla fine';

  @override
  String get reorderItemToStart => "Sposta all'inizio";

  @override
  String get reorderItemUp => 'Sposta su';

  @override
  String get rowsPerPageTitle => 'Righe per pagina:';

  @override
  String get saveButtonLabel => 'SALVA';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Cerca';

  @override
  String get selectAllButtonLabel => 'Seleziona tutto';

  @override
  String get selectYearSemanticsLabel => 'Seleziona anno';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 elemento selezionato';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount elementi selezionati';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Mostra account';

  @override
  String get showMenuTooltip => 'Mostra il menu';

  @override
  String get signedInLabel => 'Connesso';

  @override
  String get tabLabelRaw => r'Scheda $tabIndex di $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => "SELEZIONA L'ORA";

  @override
  String get timePickerHourLabel => 'Ora';

  @override
  String get timePickerHourModeAnnouncement => 'Seleziona le ore';

  @override
  String get timePickerInputHelpText => "INSERISCI L'ORA";

  @override
  String get timePickerMinuteLabel => 'Minuto';

  @override
  String get timePickerMinuteModeAnnouncement => 'Seleziona i minuti';

  @override
  String get unspecifiedDate => 'Data';

  @override
  String get unspecifiedDateRange => 'Intervallo di date';

  @override
  String get viewLicensesButtonLabel => 'VISUALIZZA LICENZE';
}

/// The translations for Japanese (`ja`).
class MaterialLocalizationJa extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Japanese.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationJa({
    String localeName = 'ja',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName について';

  @override
  String get alertDialogLabel => '通知';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => '戻る';

  @override
  String get calendarModeButtonLabel => 'カレンダーに切り替え';

  @override
  String get cancelButtonLabel => 'キャンセル';

  @override
  String get closeButtonLabel => '閉じる';

  @override
  String get closeButtonTooltip => '閉じる';

  @override
  String get collapsedIconTapHint => '展開';

  @override
  String get continueButtonLabel => '続行';

  @override
  String get copyButtonLabel => 'コピー';

  @override
  String get cutButtonLabel => '切り取り';

  @override
  String get dateHelpText => 'yyyy/mm/dd';

  @override
  String get dateInputLabel => '日付を入力';

  @override
  String get dateOutOfRangeLabel => '範囲外です。';

  @override
  String get datePickerHelpText => '日付の選択';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'終了日 $fullDate';

  @override
  String get dateRangeEndLabel => '終了日';

  @override
  String get dateRangePickerHelpText => '期間の選択';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'開始日 $fullDate';

  @override
  String get dateRangeStartLabel => '開始日';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => '削除';

  @override
  String get dialModeButtonLabel => 'ダイヤル選択ツール モードに切り替えます';

  @override
  String get dialogLabel => 'ダイアログ';

  @override
  String get drawerLabel => 'ナビゲーション メニュー';

  @override
  String get expandedIconTapHint => '折りたたむ';

  @override
  String get firstPageTooltip => '最初のページ';

  @override
  String get hideAccountsLabel => 'アカウントを非表示';

  @override
  String get inputDateModeButtonLabel => '入力に切り替え';

  @override
  String get inputTimeModeButtonLabel => 'テキスト入力モードに切り替えます';

  @override
  String get invalidDateFormatLabel => '形式が無効です。';

  @override
  String get invalidDateRangeLabel => '範囲が無効です。';

  @override
  String get invalidTimeLabel => '有効な時刻を入力してください';

  @override
  String get lastPageTooltip => '最後のページ';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => 'ライセンス: 1 件';

  @override
  String get licensesPackageDetailTextOther => r'ライセンス: $licenseCount 件';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'ライセンス';

  @override
  String get modalBarrierDismissLabel => '閉じる';

  @override
  String get moreButtonTooltip => 'その他';

  @override
  String get nextMonthTooltip => '来月';

  @override
  String get nextPageTooltip => '次のページ';

  @override
  String get okButtonLabel => 'OK';

  @override
  String get openAppDrawerTooltip => 'ナビゲーション メニューを開く';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow - $lastRow 行（合計 $rowCount 行）';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow – $lastRow 行（合計約 $rowCount 行）';

  @override
  String get pasteButtonLabel => '貼り付け';

  @override
  String get popupMenuLabel => 'ポップアップ メニュー';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => '前月';

  @override
  String get previousPageTooltip => '前のページ';

  @override
  String get refreshIndicatorSemanticLabel => '更新';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '残り 1 文字（半角相当）';

  @override
  String get remainingTextFieldCharacterCountOther => r'残り $remainingCount 文字（半角相当）';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => '下に移動';

  @override
  String get reorderItemLeft => '左に移動';

  @override
  String get reorderItemRight => '右に移動';

  @override
  String get reorderItemToEnd => '最後に移動';

  @override
  String get reorderItemToStart => '先頭に移動';

  @override
  String get reorderItemUp => '上に移動';

  @override
  String get rowsPerPageTitle => 'ページあたりの行数:';

  @override
  String get saveButtonLabel => '保存';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.dense;

  @override
  String get searchFieldLabel => '検索';

  @override
  String get selectAllButtonLabel => 'すべて選択';

  @override
  String get selectYearSemanticsLabel => '年を選択';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 件のアイテムを選択中';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount 件のアイテムを選択中';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'アカウントを表示';

  @override
  String get showMenuTooltip => 'メニューを表示';

  @override
  String get signedInLabel => 'ログイン中';

  @override
  String get tabLabelRaw => r'タブ: $tabIndex/$tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => '時刻の選択';

  @override
  String get timePickerHourLabel => '時';

  @override
  String get timePickerHourModeAnnouncement => '時間を選択';

  @override
  String get timePickerInputHelpText => '時刻の入力';

  @override
  String get timePickerMinuteLabel => '分';

  @override
  String get timePickerMinuteModeAnnouncement => '分を選択';

  @override
  String get unspecifiedDate => '日付';

  @override
  String get unspecifiedDateRange => '期間';

  @override
  String get viewLicensesButtonLabel => 'ライセンスを表示';
}

/// The translations for Georgian (`ka`).
class MaterialLocalizationKa extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Georgian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationKa({
    String localeName = 'ka',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName-ის შესახებ';

  @override
  String get alertDialogLabel => 'გაფრთხილება';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'უკან';

  @override
  String get calendarModeButtonLabel => 'კალენდარზე გადართვა';

  @override
  String get cancelButtonLabel => 'გაუქმება';

  @override
  String get closeButtonLabel => 'დახურვა';

  @override
  String get closeButtonTooltip => 'დახურვა';

  @override
  String get collapsedIconTapHint => 'გაშლა';

  @override
  String get continueButtonLabel => 'გაგრძელება';

  @override
  String get copyButtonLabel => 'კოპირება';

  @override
  String get cutButtonLabel => 'ამოჭრა';

  @override
  String get dateHelpText => 'დდ.თთ.წწწწ';

  @override
  String get dateInputLabel => 'შეიყვანეთ თარიღი';

  @override
  String get dateOutOfRangeLabel => 'დიაპაზონს მიღმაა.';

  @override
  String get datePickerHelpText => 'აირჩიეთ თარიღი';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'დასრულების თარიღია $fullDate';

  @override
  String get dateRangeEndLabel => 'დასრულების თარიღი';

  @override
  String get dateRangePickerHelpText => 'აირჩიეთ დიაპაზონი';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'დაწყების თარიღია $fullDate';

  @override
  String get dateRangeStartLabel => 'დაწყების თარიღი';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'წაშლა';

  @override
  String get dialModeButtonLabel => 'ციფერბლატის რეჟიმზე გადართვა';

  @override
  String get dialogLabel => 'დიალოგი';

  @override
  String get drawerLabel => 'ნავიგაციის მენიუ';

  @override
  String get expandedIconTapHint => 'ჩაკეცვა';

  @override
  String get firstPageTooltip => 'პირველი გვერდი';

  @override
  String get hideAccountsLabel => 'ანგარიშების დამალვა';

  @override
  String get inputDateModeButtonLabel => 'შეყვანაზე გადართვა';

  @override
  String get inputTimeModeButtonLabel => 'ტექსტის შეყვანის რეჟიმზე გადართვა';

  @override
  String get invalidDateFormatLabel => 'ფორმატი არასწორია.';

  @override
  String get invalidDateRangeLabel => 'დიაპაზონი არასწორია.';

  @override
  String get invalidTimeLabel => 'შეიყვანეთ სწორი დრო';

  @override
  String get lastPageTooltip => 'ბოლო გვერდი';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 ლიცენზია';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount ლიცენზია';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'ლიცენზიები';

  @override
  String get modalBarrierDismissLabel => 'დახურვა';

  @override
  String get moreButtonTooltip => 'მეტი';

  @override
  String get nextMonthTooltip => 'შემდეგი თვე';

  @override
  String get nextPageTooltip => 'შემდეგი გვერდი';

  @override
  String get okButtonLabel => 'კარგი';

  @override
  String get openAppDrawerTooltip => 'სანავიგაციო მენიუს გახსნა';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow-$lastRow / $rowCount-დან';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow-$lastRow / დაახლოებით $rowCount-დან';

  @override
  String get pasteButtonLabel => 'ჩასმა';

  @override
  String get popupMenuLabel => 'ამომხტარი მენიუ';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'წინა თვე';

  @override
  String get previousPageTooltip => 'წინა გვერდი';

  @override
  String get refreshIndicatorSemanticLabel => 'განახლება';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => 'დარჩა 1 სიმბოლო';

  @override
  String get remainingTextFieldCharacterCountOther => r'დარჩა $remainingCount სიმბოლო';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => 'ქვემოთ გადატანა';

  @override
  String get reorderItemLeft => 'მარცხნივ გადატანა';

  @override
  String get reorderItemRight => 'მარჯვნივ გადატანა';

  @override
  String get reorderItemToEnd => 'ბოლოში გადატანა';

  @override
  String get reorderItemToStart => 'დასაწყისში გადატანა';

  @override
  String get reorderItemUp => 'ზემოთ გადატანა';

  @override
  String get rowsPerPageTitle => 'მწკრივი გვერდზე:';

  @override
  String get saveButtonLabel => 'შენახვა';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'ძიება';

  @override
  String get selectAllButtonLabel => 'ყველას არჩევა';

  @override
  String get selectYearSemanticsLabel => 'აირჩიეთ წელი';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => 'არჩეულია 1 ერთეული';

  @override
  String get selectedRowCountTitleOther => r'არჩეულია $selectedRowCount ერთეული';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'ანგარიშების ჩვენება';

  @override
  String get showMenuTooltip => 'მენიუს ჩვენება';

  @override
  String get signedInLabel => 'შესული';

  @override
  String get tabLabelRaw => r'ჩანართი $tabIndex / $tabCount-დან';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => 'აირჩიეთ დრო';

  @override
  String get timePickerHourLabel => 'საათი';

  @override
  String get timePickerHourModeAnnouncement => 'აირჩიეთ საათები';

  @override
  String get timePickerInputHelpText => 'შეიყვანეთ დრო';

  @override
  String get timePickerMinuteLabel => 'წუთი';

  @override
  String get timePickerMinuteModeAnnouncement => 'აირჩიეთ წუთები';

  @override
  String get unspecifiedDate => 'თარიღი';

  @override
  String get unspecifiedDateRange => 'თარიღების დიაპაზონი';

  @override
  String get viewLicensesButtonLabel => 'ლიცენზიების ნახვა';
}

/// The translations for Kazakh (`kk`).
class MaterialLocalizationKk extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Kazakh.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationKk({
    String localeName = 'kk',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName туралы';

  @override
  String get alertDialogLabel => 'Дабыл';

  @override
  String get anteMeridiemAbbreviation => 'түстен кейін';

  @override
  String get backButtonTooltip => 'Артқа';

  @override
  String get calendarModeButtonLabel => 'Күнтізбеге ауысу';

  @override
  String get cancelButtonLabel => 'БАС ТАРТУ';

  @override
  String get closeButtonLabel => 'ЖАБУ';

  @override
  String get closeButtonTooltip => 'Жабу';

  @override
  String get collapsedIconTapHint => 'Жаю';

  @override
  String get continueButtonLabel => 'ЖАЛҒАСТЫРУ';

  @override
  String get copyButtonLabel => 'Көшіру';

  @override
  String get cutButtonLabel => 'Қию';

  @override
  String get dateHelpText => 'кк.аа.жжжж';

  @override
  String get dateInputLabel => 'Күнді енгізу';

  @override
  String get dateOutOfRangeLabel => 'Ауқымнан тыc.';

  @override
  String get datePickerHelpText => 'КҮНДІ ТАҢДАУ';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Аяқталу күні $fullDate';

  @override
  String get dateRangeEndLabel => 'Аяқталу күні';

  @override
  String get dateRangePickerHelpText => 'АУҚЫМДЫ ТАҢДАУ';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Басталу күні $fullDate';

  @override
  String get dateRangeStartLabel => 'Басталу күні';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'Жою';

  @override
  String get dialModeButtonLabel => 'Таңдау режиміне ауысу';

  @override
  String get dialogLabel => 'Диалогтық терезе';

  @override
  String get drawerLabel => 'Навигация мәзірі';

  @override
  String get expandedIconTapHint => 'Жию';

  @override
  String get firstPageTooltip => 'Бірінші бет';

  @override
  String get hideAccountsLabel => 'Есептік жазбаларды жасыру';

  @override
  String get inputDateModeButtonLabel => 'Мәтін енгізуге ауысу';

  @override
  String get inputTimeModeButtonLabel => 'Мәтін енгізу режиміне ауысу';

  @override
  String get invalidDateFormatLabel => 'Формат жарамсыз.';

  @override
  String get invalidDateRangeLabel => 'Ауқым жарамсыз.';

  @override
  String get invalidTimeLabel => 'Жарамды уақыт мәліметін енгізіңіз.';

  @override
  String get lastPageTooltip => 'Соңғы бет';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 лицензия';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount лицензия';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Лицензиялар';

  @override
  String get modalBarrierDismissLabel => 'Жабу';

  @override
  String get moreButtonTooltip => 'Жаю';

  @override
  String get nextMonthTooltip => 'Келесі ай';

  @override
  String get nextPageTooltip => 'Келесі бет';

  @override
  String get okButtonLabel => 'Иә';

  @override
  String get openAppDrawerTooltip => 'Навигация мәзірін ашу';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCount ішінен $firstRow–$lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'Шамамен $rowCount ішінен $firstRow–$lastRow';

  @override
  String get pasteButtonLabel => 'Қою';

  @override
  String get popupMenuLabel => 'Қалқымалы терезе мәзірі';

  @override
  String get postMeridiemAbbreviation => 'түстен кейін';

  @override
  String get previousMonthTooltip => 'Өткен ай';

  @override
  String get previousPageTooltip => 'Алдыңғы бет';

  @override
  String get refreshIndicatorSemanticLabel => 'Жаңарту';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 таңба қалды.';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount таңба қалды.';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'Таңбалар қалмады';

  @override
  String get reorderItemDown => 'Төменге жылжыту';

  @override
  String get reorderItemLeft => 'Солға жылжыту';

  @override
  String get reorderItemRight => 'Оңға жылжыту';

  @override
  String get reorderItemToEnd => 'Соңына өту';

  @override
  String get reorderItemToStart => 'Басына өту';

  @override
  String get reorderItemUp => 'Жоғарыға жылжыту';

  @override
  String get rowsPerPageTitle => 'Әр беттегі жолдар саны:';

  @override
  String get saveButtonLabel => 'САҚТАУ';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Іздеу';

  @override
  String get selectAllButtonLabel => 'Барлығын таңдау';

  @override
  String get selectYearSemanticsLabel => 'Жылды таңдау';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 элемент таңдалды.';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount элемент таңдалды.';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => 'Тармақ таңдалмаған';

  @override
  String get showAccountsLabel => 'Есептік жазбаларды көрсету';

  @override
  String get showMenuTooltip => 'Мәзірді көрсету';

  @override
  String get signedInLabel => 'Есептік жазбаға кірген';

  @override
  String get tabLabelRaw => r'$tabCount/$tabIndex қойынды';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => 'УАҚЫТТЫ ТАҢДАҢЫЗ';

  @override
  String get timePickerHourLabel => 'Сағат';

  @override
  String get timePickerHourModeAnnouncement => 'Сағаттарды таңдаңыз';

  @override
  String get timePickerInputHelpText => 'УАҚЫТТЫ ЕНГІЗІҢІЗ';

  @override
  String get timePickerMinuteLabel => 'Mинут';

  @override
  String get timePickerMinuteModeAnnouncement => 'Минуттарды таңдаңыз';

  @override
  String get unspecifiedDate => 'Күн';

  @override
  String get unspecifiedDateRange => 'Күндер ауқымы';

  @override
  String get viewLicensesButtonLabel => 'ЛИЦЕНЗИЯЛАРДЫ КӨРУ';
}

/// The translations for Khmer Central Khmer (`km`).
class MaterialLocalizationKm extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Khmer Central Khmer.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationKm({
    String localeName = 'km',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'អំពី $applicationName';

  @override
  String get alertDialogLabel => 'ជូនដំណឹង';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'ថយក្រោយ';

  @override
  String get calendarModeButtonLabel => 'ប្ដូរទៅ​ប្រតិទិន';

  @override
  String get cancelButtonLabel => 'បោះបង់';

  @override
  String get closeButtonLabel => 'បិទ';

  @override
  String get closeButtonTooltip => 'បិទ';

  @override
  String get collapsedIconTapHint => 'ពង្រីក';

  @override
  String get continueButtonLabel => 'បន្ត';

  @override
  String get copyButtonLabel => 'ចម្លង';

  @override
  String get cutButtonLabel => 'កាត់';

  @override
  String get dateHelpText => 'ថ្ងៃ/ខែ/ឆ្នាំ';

  @override
  String get dateInputLabel => 'បញ្ចូល​កាលបរិច្ឆេទ';

  @override
  String get dateOutOfRangeLabel => 'ក្រៅចន្លោះ។';

  @override
  String get datePickerHelpText => 'ជ្រើសរើស​កាល​បរិច្ឆេទ';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'កាលបរិច្ឆេទ​បញ្ចប់ $fullDate';

  @override
  String get dateRangeEndLabel => 'កាលបរិច្ឆេទ​បញ្ចប់';

  @override
  String get dateRangePickerHelpText => 'ជ្រើស​រើស​ចន្លោះ';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'កាលបរិច្ឆេទ​ចាប់ផ្ដើម $fullDate';

  @override
  String get dateRangeStartLabel => 'កាលបរិច្ឆេទ​ចាប់ផ្ដើម';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'លុប';

  @override
  String get dialModeButtonLabel => 'ប្ដូរទៅមុខងារផ្ទាំង​ជ្រើសរើសលេខ';

  @override
  String get dialogLabel => 'ប្រអប់';

  @override
  String get drawerLabel => 'ម៉ឺនុយរុករក';

  @override
  String get expandedIconTapHint => 'បង្រួម';

  @override
  String get firstPageTooltip => 'ទំព័រ​ដំបូង';

  @override
  String get hideAccountsLabel => 'លាក់គណនី';

  @override
  String get inputDateModeButtonLabel => 'ប្ដូរទៅ​ការបញ្ចូល';

  @override
  String get inputTimeModeButtonLabel => 'ប្ដូរទៅ​មុខងារ​បញ្ចូល​អក្សរ';

  @override
  String get invalidDateFormatLabel => 'ទម្រង់មិន​ត្រឹមត្រូវទេ។';

  @override
  String get invalidDateRangeLabel => 'ចន្លោះ​មិនត្រឹមត្រូវទេ។';

  @override
  String get invalidTimeLabel => 'បញ្ចូលពេលវេលា​ដែល​ត្រឹមត្រូវ';

  @override
  String get lastPageTooltip => 'ទំព័រ​ចុង​ក្រោយ';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => 'អាជ្ញាបណ្ណ 1';

  @override
  String get licensesPackageDetailTextOther => r'អាជ្ញាបណ្ណ $licenseCount';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'អាជ្ញាបណ្ណ';

  @override
  String get modalBarrierDismissLabel => 'ច្រាន​ចោល';

  @override
  String get moreButtonTooltip => 'ច្រើន​ទៀត';

  @override
  String get nextMonthTooltip => 'ខែ​​ក្រោយ';

  @override
  String get nextPageTooltip => 'ទំព័របន្ទាប់';

  @override
  String get okButtonLabel => 'យល់ព្រម';

  @override
  String get openAppDrawerTooltip => 'បើក​ម៉ឺនុយរុករក';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow ក្នុង​ចំណោម​ $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow ក្នុង​ចំណោម​ប្រហែល $rowCount';

  @override
  String get pasteButtonLabel => 'ដាក់​ចូល';

  @override
  String get popupMenuLabel => '​ម៉ឺនុយ​លោត​ឡើង';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'ខែមុន';

  @override
  String get previousPageTooltip => 'ទំព័រមុន';

  @override
  String get refreshIndicatorSemanticLabel => 'ផ្ទុកឡើងវិញ';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => 'នៅសល់​ 1 តួ​ទៀត';

  @override
  String get remainingTextFieldCharacterCountOther => r'នៅសល់ $remainingCount តួ​ទៀត';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'ផ្លាស់ទី​ចុះ​ក្រោម';

  @override
  String get reorderItemLeft => 'ផ្លាស់ទី​ទៅ​ឆ្វេង';

  @override
  String get reorderItemRight => 'ផ្លាស់ទីទៅ​ស្តាំ';

  @override
  String get reorderItemToEnd => 'ផ្លាស់ទីទៅ​ចំណុចបញ្ចប់';

  @override
  String get reorderItemToStart => 'ផ្លាស់ទីទៅ​ចំណុច​ចាប់ផ្ដើម';

  @override
  String get reorderItemUp => 'ផ្លាស់ទី​ឡើង​លើ';

  @override
  String get rowsPerPageTitle => 'ជួរ​ដេក​ក្នុង​មួយ​ទំព័រ៖';

  @override
  String get saveButtonLabel => 'រក្សាទុក';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.dense;

  @override
  String get searchFieldLabel => 'ស្វែងរក';

  @override
  String get selectAllButtonLabel => 'ជ្រើសរើស​ទាំងអស់';

  @override
  String get selectYearSemanticsLabel => 'ជ្រើសរើសឆ្នាំ';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => 'បាន​ជ្រើស​រើស​ធាតុ 1';

  @override
  String get selectedRowCountTitleOther => r'បាន​ជ្រើស​រើស​ធាតុ $selectedRowCount';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'បង្ហាញគណនី';

  @override
  String get showMenuTooltip => 'បង្ហាញ​ម៉ឺនុយ';

  @override
  String get signedInLabel => 'បានចូល​គណនី';

  @override
  String get tabLabelRaw => r'ផ្ទាំង $tabIndex ក្នុង​ចំណោម​ $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.h_colon_mm_space_a;

  @override
  String get timePickerDialHelpText => 'ជ្រើសរើស​ពេលវេលា';

  @override
  String get timePickerHourLabel => 'ម៉ោង';

  @override
  String get timePickerHourModeAnnouncement => 'ជ្រើសរើស​ម៉ោង';

  @override
  String get timePickerInputHelpText => 'បញ្ចូលពេលវេលា';

  @override
  String get timePickerMinuteLabel => 'នាទី​';

  @override
  String get timePickerMinuteModeAnnouncement => 'ជ្រើសរើស​នាទី';

  @override
  String get unspecifiedDate => 'កាលបរិច្ឆេទ';

  @override
  String get unspecifiedDateRange => 'ចន្លោះ​កាលបរិច្ឆេទ';

  @override
  String get viewLicensesButtonLabel => 'មើលអាជ្ញាបណ្ណ';
}

/// The translations for Kannada (`kn`).
class MaterialLocalizationKn extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Kannada.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationKn({
    String localeName = 'kn',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => '\u{24}\u{61}\u{70}\u{70}\u{6c}\u{69}\u{63}\u{61}\u{74}\u{69}\u{6f}\u{6e}\u{4e}\u{61}\u{6d}\u{65}\u{20}\u{cac}\u{c97}\u{ccd}\u{c97}\u{cc6}';

  @override
  String get alertDialogLabel => '\u{c8e}\u{c9a}\u{ccd}\u{c9a}\u{cb0}\u{cbf}\u{c95}\u{cc6}';

  @override
  String get anteMeridiemAbbreviation => '\u{cac}\u{cc6}\u{cb3}\u{cbf}\u{c97}\u{ccd}\u{c97}\u{cc6}';

  @override
  String get backButtonTooltip => '\u{cb9}\u{cbf}\u{c82}\u{ca4}\u{cbf}\u{cb0}\u{cc1}\u{c97}\u{cbf}';

  @override
  String get calendarModeButtonLabel => '\u{c95}\u{ccd}\u{caf}\u{cbe}\u{cb2}\u{cc6}\u{c82}\u{ca1}\u{cb0}\u{ccd}\u{200c}\u{c97}\u{cc6}\u{20}\u{cac}\u{ca6}\u{cb2}\u{cbf}\u{cb8}\u{cbf}';

  @override
  String get cancelButtonLabel => '\u{cb0}\u{ca6}\u{ccd}\u{ca6}\u{cc1}\u{cae}\u{cbe}\u{ca1}\u{cbf}';

  @override
  String get closeButtonLabel => '\u{cae}\u{cc1}\u{c9a}\u{ccd}\u{c9a}\u{cbf}\u{cb0}\u{cbf}';

  @override
  String get closeButtonTooltip => '\u{cae}\u{cc1}\u{c9a}\u{ccd}\u{c9a}\u{cbf}\u{cb0}\u{cbf}';

  @override
  String get collapsedIconTapHint => '\u{cb5}\u{cbf}\u{cb8}\u{ccd}\u{ca4}\u{cb0}\u{cbf}\u{cb8}\u{cbf}';

  @override
  String get continueButtonLabel => '\u{cae}\u{cc1}\u{c82}\u{ca6}\u{cc1}\u{cb5}\u{cb0}\u{cbf}\u{cb8}\u{cbf}';

  @override
  String get copyButtonLabel => '\u{ca8}\u{c95}\u{cb2}\u{cbf}\u{cb8}\u{cbf}';

  @override
  String get cutButtonLabel => '\u{c95}\u{ca4}\u{ccd}\u{ca4}\u{cb0}\u{cbf}\u{cb8}\u{cbf}';

  @override
  String get dateHelpText => 'mm/dd/yyyy';

  @override
  String get dateInputLabel => '\u{ca6}\u{cbf}\u{ca8}\u{cbe}\u{c82}\u{c95}\u{20}\u{ca8}\u{cae}\u{cc2}\u{ca6}\u{cbf}\u{cb8}\u{cbf}';

  @override
  String get dateOutOfRangeLabel => '\u{cb5}\u{ccd}\u{caf}\u{cbe}\u{caa}\u{ccd}\u{ca4}\u{cbf}\u{caf}\u{20}\u{cb9}\u{cca}\u{cb0}\u{c97}\u{cbf}\u{ca6}\u{cc6}';

  @override
  String get datePickerHelpText => '\u{ca6}\u{cbf}\u{ca8}\u{cbe}\u{c82}\u{c95}\u{cb5}\u{ca8}\u{ccd}\u{ca8}\u{cc1}\u{20}\u{c86}\u{caf}\u{ccd}\u{c95}\u{cc6}\u{cae}\u{cbe}\u{ca1}\u{cbf}';

  @override
  String get dateRangeEndDateSemanticLabelRaw => '\u{cae}\u{cc1}\u{c95}\u{ccd}\u{ca4}\u{cbe}\u{caf}\u{20}\u{ca6}\u{cbf}\u{ca8}\u{cbe}\u{c82}\u{c95}\u{20}\u{24}\u{66}\u{75}\u{6c}\u{6c}\u{44}\u{61}\u{74}\u{65}';

  @override
  String get dateRangeEndLabel => '\u{c85}\u{c82}\u{ca4}\u{cbf}\u{cae}\u{20}\u{ca6}\u{cbf}\u{ca8}\u{cbe}\u{c82}\u{c95}';

  @override
  String get dateRangePickerHelpText => '\u{cb6}\u{ccd}\u{cb0}\u{cc7}\u{ca3}\u{cbf}\u{caf}\u{ca8}\u{ccd}\u{ca8}\u{cc1}\u{20}\u{c86}\u{caf}\u{ccd}\u{c95}\u{cc6}\u{cae}\u{cbe}\u{ca1}\u{cbf}';

  @override
  String get dateRangeStartDateSemanticLabelRaw => '\u{caa}\u{ccd}\u{cb0}\u{cbe}\u{cb0}\u{c82}\u{cad}\u{20}\u{ca6}\u{cbf}\u{ca8}\u{cbe}\u{c82}\u{c95}\u{20}\u{24}\u{66}\u{75}\u{6c}\u{6c}\u{44}\u{61}\u{74}\u{65}';

  @override
  String get dateRangeStartLabel => '\u{caa}\u{ccd}\u{cb0}\u{cbe}\u{cb0}\u{c82}\u{cad}\u{20}\u{ca6}\u{cbf}\u{ca8}\u{cbe}\u{c82}\u{c95}';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => '\u{c85}\u{cb3}\u{cbf}\u{cb8}\u{cbf}';

  @override
  String get dialModeButtonLabel => '\u{ca1}\u{caf}\u{cb2}\u{ccd}\u{20}\u{caa}\u{cbf}\u{c95}\u{cb0}\u{ccd}\u{200c}\u{20}\u{cae}\u{ccb}\u{ca1}\u{ccd}\u{200c}\u{c97}\u{cc6}\u{20}\u{cac}\u{ca6}\u{cb2}\u{cbe}\u{caf}\u{cbf}\u{cb8}\u{cbf}';

  @override
  String get dialogLabel => '\u{ca1}\u{cc8}\u{cb2}\u{cbe}\u{c97}\u{ccd}';

  @override
  String get drawerLabel => '\u{ca8}\u{ccd}\u{caf}\u{cbe}\u{cb5}\u{cbf}\u{c97}\u{cc7}\u{cb6}\u{ca8}\u{ccd}\u{200c}\u{20}\u{cae}\u{cc6}\u{ca8}\u{cc1}';

  @override
  String get expandedIconTapHint => '\u{c95}\u{cc1}\u{c97}\u{ccd}\u{c97}\u{cbf}\u{cb8}\u{cbf}';

  @override
  String get firstPageTooltip => '\u{cae}\u{cca}\u{ca6}\u{cb2}\u{20}\u{caa}\u{cc1}\u{c9f}';

  @override
  String get hideAccountsLabel => '\u{c96}\u{cbe}\u{ca4}\u{cc6}\u{c97}\u{cb3}\u{ca8}\u{ccd}\u{ca8}\u{cc1}\u{20}\u{cae}\u{cb0}\u{cc6}\u{cae}\u{cbe}\u{ca1}\u{cbf}';

  @override
  String get inputDateModeButtonLabel => '\u{c87}\u{ca8}\u{ccd}\u{200c}\u{caa}\u{cc1}\u{c9f}\u{ccd}\u{200c}\u{c97}\u{cc6}\u{20}\u{cac}\u{ca6}\u{cb2}\u{cbf}\u{cb8}\u{cbf}';

  @override
  String get inputTimeModeButtonLabel => '\u{caa}\u{ca0}\u{ccd}\u{caf}\u{20}\u{c87}\u{ca8}\u{ccd}\u{200c}\u{caa}\u{cc1}\u{c9f}\u{ccd}\u{20}\u{cae}\u{ccb}\u{ca1}\u{ccd}\u{200c}\u{c97}\u{cc6}\u{20}\u{cac}\u{ca6}\u{cb2}\u{cbe}\u{caf}\u{cbf}\u{cb8}\u{cbf}';

  @override
  String get invalidDateFormatLabel => '\u{c85}\u{cae}\u{cbe}\u{ca8}\u{ccd}\u{caf}\u{cb5}\u{cbe}\u{ca6}\u{20}\u{cab}\u{cbe}\u{cb0}\u{ccd}\u{cae}\u{ccd}\u{caf}\u{cbe}\u{c9f}\u{ccd}\u{2e}';

  @override
  String get invalidDateRangeLabel => '\u{c85}\u{cae}\u{cbe}\u{ca8}\u{ccd}\u{caf}\u{20}\u{cb6}\u{ccd}\u{cb0}\u{cc7}\u{ca3}\u{cbf}\u{2e}';

  @override
  String get invalidTimeLabel => '\u{cae}\u{cbe}\u{ca8}\u{ccd}\u{caf}\u{cb5}\u{cbe}\u{ca6}\u{20}\u{cb8}\u{cae}\u{caf}\u{cb5}\u{ca8}\u{ccd}\u{ca8}\u{cc1}\u{20}\u{ca8}\u{cae}\u{cc2}\u{ca6}\u{cbf}\u{cb8}\u{cbf}';

  @override
  String get lastPageTooltip => '\u{c95}\u{cca}\u{ca8}\u{cc6}\u{caf}\u{20}\u{caa}\u{cc1}\u{c9f}';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '\u{31}\u{20}\u{caa}\u{cb0}\u{cb5}\u{cbe}\u{ca8}\u{c97}\u{cbf}';

  @override
  String get licensesPackageDetailTextOther => '\u{24}\u{6c}\u{69}\u{63}\u{65}\u{6e}\u{73}\u{65}\u{43}\u{6f}\u{75}\u{6e}\u{74}\u{20}\u{caa}\u{cb0}\u{cb5}\u{cbe}\u{ca8}\u{c97}\u{cbf}\u{c97}\u{cb3}\u{cc1}';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => '\u{caa}\u{cb0}\u{cb5}\u{cbe}\u{ca8}\u{c97}\u{cbf}\u{c97}\u{cb3}\u{cc1}';

  @override
  String get modalBarrierDismissLabel => '\u{cb5}\u{c9c}\u{cbe}\u{c97}\u{cca}\u{cb3}\u{cbf}\u{cb8}\u{cbf}';

  @override
  String get moreButtonTooltip => '\u{c87}\u{ca8}\u{ccd}\u{ca8}\u{cb7}\u{ccd}\u{c9f}\u{cc1}';

  @override
  String get nextMonthTooltip => '\u{cae}\u{cc1}\u{c82}\u{ca6}\u{cbf}\u{ca8}\u{20}\u{ca4}\u{cbf}\u{c82}\u{c97}\u{cb3}\u{cc1}';

  @override
  String get nextPageTooltip => '\u{cae}\u{cc1}\u{c82}\u{ca6}\u{cbf}\u{ca8}\u{20}\u{caa}\u{cc1}\u{c9f}';

  @override
  String get okButtonLabel => '\u{cb8}\u{cb0}\u{cbf}';

  @override
  String get openAppDrawerTooltip => '\u{ca8}\u{ccd}\u{caf}\u{cbe}\u{cb5}\u{cbf}\u{c97}\u{cc7}\u{cb6}\u{ca8}\u{ccd}\u{200c}\u{20}\u{cae}\u{cc6}\u{ca8}\u{cc1}\u{20}\u{ca4}\u{cc6}\u{cb0}\u{cc6}\u{caf}\u{cbf}\u{cb0}\u{cbf}';

  @override
  String get pageRowsInfoTitleRaw => '\u{24}\u{72}\u{6f}\u{77}\u{43}\u{6f}\u{75}\u{6e}\u{74}\u{20}\u{cb0}\u{cb2}\u{ccd}\u{cb2}\u{cbf}\u{20}\u{24}\u{66}\u{69}\u{72}\u{73}\u{74}\u{52}\u{6f}\u{77}\u{2013}\u{24}\u{6c}\u{61}\u{73}\u{74}\u{52}\u{6f}\u{77}';

  @override
  String get pageRowsInfoTitleApproximateRaw => '\u{24}\u{72}\u{6f}\u{77}\u{43}\u{6f}\u{75}\u{6e}\u{74}\u{20}\u{cb0}\u{cb2}\u{ccd}\u{cb2}\u{cbf}\u{20}\u{24}\u{66}\u{69}\u{72}\u{73}\u{74}\u{52}\u{6f}\u{77}\u{2013}\u{24}\u{6c}\u{61}\u{73}\u{74}\u{52}\u{6f}\u{77}';

  @override
  String get pasteButtonLabel => '\u{c85}\u{c82}\u{c9f}\u{cbf}\u{cb8}\u{cbf}';

  @override
  String get popupMenuLabel => '\u{caa}\u{cbe}\u{caa}\u{ccd}\u{c85}\u{caa}\u{ccd}\u{20}\u{cae}\u{cc6}\u{ca8}\u{cc1}';

  @override
  String get postMeridiemAbbreviation => '\u{cb8}\u{c82}\u{c9c}\u{cc6}';

  @override
  String get previousMonthTooltip => '\u{cb9}\u{cbf}\u{c82}\u{ca6}\u{cbf}\u{ca8}\u{20}\u{ca4}\u{cbf}\u{c82}\u{c97}\u{cb3}\u{cc1}';

  @override
  String get previousPageTooltip => '\u{cb9}\u{cbf}\u{c82}\u{ca6}\u{cbf}\u{ca8}\u{20}\u{caa}\u{cc1}\u{c9f}';

  @override
  String get refreshIndicatorSemanticLabel => '\u{cb0}\u{cbf}\u{cab}\u{ccd}\u{cb0}\u{cc6}\u{cb6}\u{ccd}\u{20}\u{cae}\u{cbe}\u{ca1}\u{cbf}';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '\u{31}\u{20}\u{c85}\u{c95}\u{ccd}\u{cb7}\u{cb0}\u{20}\u{c89}\u{cb3}\u{cbf}\u{ca6}\u{cbf}\u{ca6}\u{cc6}';

  @override
  String get remainingTextFieldCharacterCountOther => '\u{24}\u{72}\u{65}\u{6d}\u{61}\u{69}\u{6e}\u{69}\u{6e}\u{67}\u{43}\u{6f}\u{75}\u{6e}\u{74}\u{20}\u{c85}\u{c95}\u{ccd}\u{cb7}\u{cb0}\u{c97}\u{cb3}\u{cc1}\u{20}\u{c89}\u{cb3}\u{cbf}\u{ca6}\u{cbf}\u{cb5}\u{cc6}';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => '\u{c95}\u{cc6}\u{cb3}\u{c97}\u{cc6}\u{20}\u{cb8}\u{cb0}\u{cbf}\u{cb8}\u{cbf}';

  @override
  String get reorderItemLeft => '\u{c8e}\u{ca1}\u{c95}\u{ccd}\u{c95}\u{cc6}\u{20}\u{cb8}\u{cb0}\u{cbf}\u{cb8}\u{cbf}';

  @override
  String get reorderItemRight => '\u{cac}\u{cb2}\u{c95}\u{ccd}\u{c95}\u{cc6}\u{20}\u{cb8}\u{cb0}\u{cbf}\u{cb8}\u{cbf}';

  @override
  String get reorderItemToEnd => '\u{c95}\u{cca}\u{ca8}\u{cc6}\u{c97}\u{cc6}\u{20}\u{cb8}\u{cb0}\u{cbf}\u{cb8}\u{cbf}';

  @override
  String get reorderItemToStart => '\u{caa}\u{ccd}\u{cb0}\u{cbe}\u{cb0}\u{c82}\u{cad}\u{c95}\u{ccd}\u{c95}\u{cc6}\u{20}\u{cb8}\u{cb0}\u{cbf}\u{cb8}\u{cbf}';

  @override
  String get reorderItemUp => '\u{cae}\u{cc7}\u{cb2}\u{cc6}\u{20}\u{cb8}\u{cb0}\u{cbf}\u{cb8}\u{cbf}';

  @override
  String get rowsPerPageTitle => '\u{caa}\u{ccd}\u{cb0}\u{ca4}\u{cbf}\u{20}\u{caa}\u{cc1}\u{c9f}\u{c95}\u{ccd}\u{c95}\u{cc6}\u{20}\u{cb8}\u{cbe}\u{cb2}\u{cc1}\u{c97}\u{cb3}\u{cc1}\u{3a}';

  @override
  String get saveButtonLabel => '\u{c89}\u{cb3}\u{cbf}\u{cb8}\u{cbf}';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.tall;

  @override
  String get searchFieldLabel => '\u{cb9}\u{cc1}\u{ca1}\u{cc1}\u{c95}\u{cbf}';

  @override
  String get selectAllButtonLabel => '\u{c8e}\u{cb2}\u{ccd}\u{cb2}\u{cb5}\u{ca8}\u{ccd}\u{ca8}\u{cc2}\u{20}\u{c86}\u{caf}\u{ccd}\u{c95}\u{cc6}\u{20}\u{cae}\u{cbe}\u{ca1}\u{cbf}';

  @override
  String get selectYearSemanticsLabel => '\u{cb5}\u{cb0}\u{ccd}\u{cb7}\u{cb5}\u{ca8}\u{ccd}\u{ca8}\u{cc1}\u{20}\u{c86}\u{caf}\u{ccd}\u{c95}\u{cc6}\u{cae}\u{cbe}\u{ca1}\u{cbf}';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '\u{31}\u{20}\u{c90}\u{c9f}\u{c82}\u{20}\u{c86}\u{caf}\u{ccd}\u{c95}\u{cc6}\u{20}\u{cae}\u{cbe}\u{ca1}\u{cb2}\u{cbe}\u{c97}\u{cbf}\u{ca6}\u{cc6}';

  @override
  String get selectedRowCountTitleOther => '\u{24}\u{73}\u{65}\u{6c}\u{65}\u{63}\u{74}\u{65}\u{64}\u{52}\u{6f}\u{77}\u{43}\u{6f}\u{75}\u{6e}\u{74}\u{20}\u{c90}\u{c9f}\u{c82}\u{c97}\u{cb3}\u{ca8}\u{ccd}\u{ca8}\u{cc1}\u{20}\u{c86}\u{caf}\u{ccd}\u{c95}\u{cc6}\u{20}\u{cae}\u{cbe}\u{ca1}\u{cb2}\u{cbe}\u{c97}\u{cbf}\u{ca6}\u{cc6}';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => '\u{c96}\u{cbe}\u{ca4}\u{cc6}\u{c97}\u{cb3}\u{ca8}\u{ccd}\u{ca8}\u{cc1}\u{20}\u{ca4}\u{ccb}\u{cb0}\u{cbf}\u{cb8}\u{cbf}';

  @override
  String get showMenuTooltip => '\u{cae}\u{cc6}\u{ca8}\u{cc1}\u{20}\u{ca4}\u{ccb}\u{cb0}\u{cbf}\u{cb8}\u{cbf}';

  @override
  String get signedInLabel => '\u{cb8}\u{cc8}\u{ca8}\u{ccd}\u{20}\u{c87}\u{ca8}\u{ccd}\u{20}\u{cae}\u{cbe}\u{ca1}\u{cb2}\u{cbe}\u{c97}\u{cbf}\u{ca6}\u{cc6}';

  @override
  String get tabLabelRaw => '\u{24}\u{74}\u{61}\u{62}\u{43}\u{6f}\u{75}\u{6e}\u{74}\u{20}\u{cb0}\u{cb2}\u{ccd}\u{cb2}\u{cbf}\u{ca8}\u{20}\u{24}\u{74}\u{61}\u{62}\u{49}\u{6e}\u{64}\u{65}\u{78}\u{20}\u{c9f}\u{ccd}\u{caf}\u{cbe}\u{cac}\u{ccd}';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => '\u{cb8}\u{cae}\u{caf}\u{cb5}\u{ca8}\u{ccd}\u{ca8}\u{cc1}\u{20}\u{c86}\u{caf}\u{ccd}\u{c95}\u{cc6}\u{cae}\u{cbe}\u{ca1}\u{cbf}';

  @override
  String get timePickerHourLabel => '\u{c97}\u{c82}\u{c9f}\u{cc6}';

  @override
  String get timePickerHourModeAnnouncement => '\u{c97}\u{c82}\u{c9f}\u{cc6}\u{c97}\u{cb3}\u{ca8}\u{ccd}\u{ca8}\u{cc1}\u{20}\u{c86}\u{caf}\u{ccd}\u{c95}\u{cc6}\u{cae}\u{cbe}\u{ca1}\u{cbf}';

  @override
  String get timePickerInputHelpText => '\u{cb8}\u{cae}\u{caf}\u{cb5}\u{ca8}\u{ccd}\u{ca8}\u{cc1}\u{20}\u{ca8}\u{cae}\u{cc2}\u{ca6}\u{cbf}\u{cb8}\u{cbf}';

  @override
  String get timePickerMinuteLabel => '\u{ca8}\u{cbf}\u{cae}\u{cbf}\u{cb7}';

  @override
  String get timePickerMinuteModeAnnouncement => '\u{ca8}\u{cbf}\u{cae}\u{cbf}\u{cb7}\u{c97}\u{cb3}\u{ca8}\u{ccd}\u{ca8}\u{cc1}\u{20}\u{c86}\u{caf}\u{ccd}\u{c95}\u{cc6}\u{cae}\u{cbe}\u{ca1}\u{cbf}';

  @override
  String get unspecifiedDate => '\u{ca6}\u{cbf}\u{ca8}\u{cbe}\u{c82}\u{c95}';

  @override
  String get unspecifiedDateRange => '\u{ca6}\u{cbf}\u{ca8}\u{cbe}\u{c82}\u{c95}\u{20}\u{cb5}\u{ccd}\u{caf}\u{cbe}\u{caa}\u{ccd}\u{ca4}\u{cbf}';

  @override
  String get viewLicensesButtonLabel => '\u{caa}\u{cb0}\u{cb5}\u{cbe}\u{ca8}\u{c97}\u{cbf}\u{c97}\u{cb3}\u{ca8}\u{ccd}\u{ca8}\u{cc1}\u{20}\u{cb5}\u{cbf}\u{cd5}\u{c95}\u{ccd}\u{cb7}\u{cbf}\u{cb8}\u{cbf}';
}

/// The translations for Korean (`ko`).
class MaterialLocalizationKo extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Korean.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationKo({
    String localeName = 'ko',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName 정보';

  @override
  String get alertDialogLabel => '알림';

  @override
  String get anteMeridiemAbbreviation => '오전';

  @override
  String get backButtonTooltip => '뒤로';

  @override
  String get calendarModeButtonLabel => '캘린더 모드로 전환';

  @override
  String get cancelButtonLabel => '취소';

  @override
  String get closeButtonLabel => '닫기';

  @override
  String get closeButtonTooltip => '닫기';

  @override
  String get collapsedIconTapHint => '펼치기';

  @override
  String get continueButtonLabel => '계속';

  @override
  String get copyButtonLabel => '복사';

  @override
  String get cutButtonLabel => '잘라냄';

  @override
  String get dateHelpText => 'yyyy.mm.dd';

  @override
  String get dateInputLabel => '날짜 입력';

  @override
  String get dateOutOfRangeLabel => '범위를 벗어났습니다.';

  @override
  String get datePickerHelpText => '날짜 선택';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'종료일 $fullDate';

  @override
  String get dateRangeEndLabel => '종료일';

  @override
  String get dateRangePickerHelpText => '범위 선택';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'시작일 $fullDate';

  @override
  String get dateRangeStartLabel => '시작일';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => '삭제';

  @override
  String get dialModeButtonLabel => '다이얼 선택 모드로 전환';

  @override
  String get dialogLabel => '대화상자';

  @override
  String get drawerLabel => '탐색 메뉴';

  @override
  String get expandedIconTapHint => '접기';

  @override
  String get firstPageTooltip => '첫 페이지';

  @override
  String get hideAccountsLabel => '계정 숨기기';

  @override
  String get inputDateModeButtonLabel => '입력 모드로 전환';

  @override
  String get inputTimeModeButtonLabel => '텍스트 입력 모드로 전환';

  @override
  String get invalidDateFormatLabel => '형식이 잘못되었습니다.';

  @override
  String get invalidDateRangeLabel => '날짜 범위가 잘못되었습니다.';

  @override
  String get invalidTimeLabel => '유효한 시간을 입력하세요.';

  @override
  String get lastPageTooltip => '마지막 페이지';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '라이선스 1개';

  @override
  String get licensesPackageDetailTextOther => r'라이선스 $licenseCount개';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => '라이선스';

  @override
  String get modalBarrierDismissLabel => '닫기';

  @override
  String get moreButtonTooltip => '더보기';

  @override
  String get nextMonthTooltip => '다음 달';

  @override
  String get nextPageTooltip => '다음 페이지';

  @override
  String get okButtonLabel => '확인';

  @override
  String get openAppDrawerTooltip => '탐색 메뉴 열기';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCount행 중 $firstRow~$lastRow행';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'약 $rowCount행 중 $firstRow~$lastRow행';

  @override
  String get pasteButtonLabel => '붙여넣기';

  @override
  String get popupMenuLabel => '팝업 메뉴';

  @override
  String get postMeridiemAbbreviation => '오후';

  @override
  String get previousMonthTooltip => '지난달';

  @override
  String get previousPageTooltip => '이전 페이지';

  @override
  String get refreshIndicatorSemanticLabel => '새로고침';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1자 남음';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount자 남음';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => '아래로 이동';

  @override
  String get reorderItemLeft => '왼쪽으로 이동';

  @override
  String get reorderItemRight => '오른쪽으로 이동';

  @override
  String get reorderItemToEnd => '끝으로 이동';

  @override
  String get reorderItemToStart => '시작으로 이동';

  @override
  String get reorderItemUp => '위로 이동';

  @override
  String get rowsPerPageTitle => '페이지당 행 수:';

  @override
  String get saveButtonLabel => '저장';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.dense;

  @override
  String get searchFieldLabel => '검색';

  @override
  String get selectAllButtonLabel => '전체 선택';

  @override
  String get selectYearSemanticsLabel => '연도 선택';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '항목 1개 선택됨';

  @override
  String get selectedRowCountTitleOther => r'항목 $selectedRowCount개 선택됨';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => '계정 표시';

  @override
  String get showMenuTooltip => '메뉴 표시';

  @override
  String get signedInLabel => '로그인됨';

  @override
  String get tabLabelRaw => r'탭 $tabCount개 중 $tabIndex번째';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.a_space_h_colon_mm;

  @override
  String get timePickerDialHelpText => '시간 선택';

  @override
  String get timePickerHourLabel => '시간';

  @override
  String get timePickerHourModeAnnouncement => '시간 선택';

  @override
  String get timePickerInputHelpText => '시간 입력';

  @override
  String get timePickerMinuteLabel => '분';

  @override
  String get timePickerMinuteModeAnnouncement => '분 선택';

  @override
  String get unspecifiedDate => '날짜';

  @override
  String get unspecifiedDateRange => '기간';

  @override
  String get viewLicensesButtonLabel => '라이선스 보기';
}

/// The translations for Kirghiz Kyrgyz (`ky`).
class MaterialLocalizationKy extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Kirghiz Kyrgyz.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationKy({
    String localeName = 'ky',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName каналы жөнүндө';

  @override
  String get alertDialogLabel => 'Эскертүү';

  @override
  String get anteMeridiemAbbreviation => 'түшкө чейин';

  @override
  String get backButtonTooltip => 'Артка';

  @override
  String get calendarModeButtonLabel => 'Жылнаамага которулуңуз';

  @override
  String get cancelButtonLabel => 'ЖОККО ЧЫГАРУУ';

  @override
  String get closeButtonLabel => 'ЖАБУУ';

  @override
  String get closeButtonTooltip => 'Жабуу';

  @override
  String get collapsedIconTapHint => 'Жайып көрсөтүү';

  @override
  String get continueButtonLabel => 'УЛАНТУУ';

  @override
  String get copyButtonLabel => 'Көчүрүү';

  @override
  String get cutButtonLabel => 'Кесүү';

  @override
  String get dateHelpText => 'кк.аа.жжжж';

  @override
  String get dateInputLabel => 'Күндү киргизүү';

  @override
  String get dateOutOfRangeLabel => 'Аракет чегинен тышкары.';

  @override
  String get datePickerHelpText => 'КҮНДҮ ТАНДОО';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Аяктоо күнү $fullDate';

  @override
  String get dateRangeEndLabel => 'Аяктоо күнү';

  @override
  String get dateRangePickerHelpText => 'ДИАПАЗОНДУ ТАНДОО';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Баштоо күнү $fullDate';

  @override
  String get dateRangeStartLabel => 'Баштоо күнү';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'Жок кылуу';

  @override
  String get dialModeButtonLabel => 'Терүүнү тандагыч режимине которулуу';

  @override
  String get dialogLabel => 'Диалог';

  @override
  String get drawerLabel => 'Чабыттоо менюсу';

  @override
  String get expandedIconTapHint => 'Жыйыштыруу';

  @override
  String get firstPageTooltip => 'Биринчи бет';

  @override
  String get hideAccountsLabel => 'Аккаунттарды жашыруу';

  @override
  String get inputDateModeButtonLabel => 'Терип киргизүү режимине которулуңуз';

  @override
  String get inputTimeModeButtonLabel => 'Текст киргизүү режимине которулуу';

  @override
  String get invalidDateFormatLabel => 'Жараксыз формат.';

  @override
  String get invalidDateRangeLabel => 'Жараксыз диапазон.';

  @override
  String get invalidTimeLabel => 'Убакытты туура көрсөтүңүз';

  @override
  String get lastPageTooltip => 'Акыркы бет';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 уруксаттама';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount уруксаттама';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Уруксаттамалар';

  @override
  String get modalBarrierDismissLabel => 'Жабуу';

  @override
  String get moreButtonTooltip => 'Дагы';

  @override
  String get nextMonthTooltip => 'Кийинки ай';

  @override
  String get nextPageTooltip => 'Кийинки бет';

  @override
  String get okButtonLabel => 'Макул';

  @override
  String get openAppDrawerTooltip => 'Чабыттоо менюсун ачуу';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCount ичинен $firstRow–$lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'Болжол менен $rowCount ичинен $firstRow–$lastRow';

  @override
  String get pasteButtonLabel => 'Чаптоо';

  @override
  String get popupMenuLabel => 'Калкып чыгуучу меню';

  @override
  String get postMeridiemAbbreviation => 'түштөн кийин';

  @override
  String get previousMonthTooltip => 'Мурунку ай';

  @override
  String get previousPageTooltip => 'Мурунку бет';

  @override
  String get refreshIndicatorSemanticLabel => 'Жаңыртуу';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 белги калды';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount белги калды';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => 'Төмөн жылдыруу';

  @override
  String get reorderItemLeft => 'Солго жылдыруу';

  @override
  String get reorderItemRight => 'Оңго жылдыруу';

  @override
  String get reorderItemToEnd => 'Аягына жылдыруу';

  @override
  String get reorderItemToStart => 'Башына жылдыруу';

  @override
  String get reorderItemUp => 'Жогору жылдыруу';

  @override
  String get rowsPerPageTitle => 'Бир бетте көрсөтүлүүчү саптардын саны:';

  @override
  String get saveButtonLabel => 'САКТОО';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Издөө';

  @override
  String get selectAllButtonLabel => 'Баарын тандоо';

  @override
  String get selectYearSemanticsLabel => 'Жылды тандоо';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 нерсе тандалды';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount нерсе тандалды';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Аккаунттарды көрсөтүү';

  @override
  String get showMenuTooltip => 'Менюну көрсөтүү';

  @override
  String get signedInLabel => 'Аккаунтуңузга кирдиңиз';

  @override
  String get tabLabelRaw => r'$tabCount кыналма ичинен $tabIndex';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => 'УБАКЫТ ТАНДОО';

  @override
  String get timePickerHourLabel => 'Саат';

  @override
  String get timePickerHourModeAnnouncement => 'Саатты тандаңыз';

  @override
  String get timePickerInputHelpText => 'УБАКЫТ КИРГИЗҮҮ';

  @override
  String get timePickerMinuteLabel => 'Мүнөт';

  @override
  String get timePickerMinuteModeAnnouncement => 'Мүнөттөрдү тандаңыз';

  @override
  String get unspecifiedDate => 'Күн';

  @override
  String get unspecifiedDateRange => 'Даталар диапазону';

  @override
  String get viewLicensesButtonLabel => 'УРУКСАТТАМАЛАРДЫ КӨРҮҮ';
}

/// The translations for Lao (`lo`).
class MaterialLocalizationLo extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Lao.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationLo({
    String localeName = 'lo',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'ກ່ຽວກັບ $applicationName';

  @override
  String get alertDialogLabel => 'ການເຕືອນ';

  @override
  String get anteMeridiemAbbreviation => 'ກ່ອນທ່ຽງ';

  @override
  String get backButtonTooltip => 'ກັບຄືນ';

  @override
  String get calendarModeButtonLabel => 'ສະຫຼັບໄປປະຕິທິນ';

  @override
  String get cancelButtonLabel => 'ຍົກເລີກ';

  @override
  String get closeButtonLabel => 'ປິດ';

  @override
  String get closeButtonTooltip => 'ປິດ';

  @override
  String get collapsedIconTapHint => 'ຂະຫຍາຍ';

  @override
  String get continueButtonLabel => 'ສືບຕໍ່';

  @override
  String get copyButtonLabel => 'ສຳເນົາ';

  @override
  String get cutButtonLabel => 'ຕັດ';

  @override
  String get dateHelpText => 'ດດ/ວວ/ປປປປ';

  @override
  String get dateInputLabel => 'ໃສ່ວັນທີ';

  @override
  String get dateOutOfRangeLabel => 'ຢູ່ນອກໄລຍະ.';

  @override
  String get datePickerHelpText => 'ເລືອກວັນທີ';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'ວັນທີສິ້ນສຸດ $fullDate';

  @override
  String get dateRangeEndLabel => 'ວັນທີສິ້ນສຸດ';

  @override
  String get dateRangePickerHelpText => 'ເລືອກໄລຍະ';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'ວັນທີເລີ່ມຕົ້ນ $fullDate';

  @override
  String get dateRangeStartLabel => 'ວັນທີເລີ່ມຕົ້ນ';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'ລຶບ';

  @override
  String get dialModeButtonLabel => 'ສະຫຼັບໄປໃຊ້ໂໝດເລືອກຕົວເລກ';

  @override
  String get dialogLabel => 'ຂໍ້ຄວາມ';

  @override
  String get drawerLabel => 'ເມນູນຳທາງ';

  @override
  String get expandedIconTapHint => 'ຫຍໍ້ເຂົ້າ';

  @override
  String get firstPageTooltip => 'ໜ້າທຳອິດ';

  @override
  String get hideAccountsLabel => 'ເຊື່ອງບັນຊີ';

  @override
  String get inputDateModeButtonLabel => 'ສະຫຼັບໄປການປ້ອນຂໍ້ມູນ';

  @override
  String get inputTimeModeButtonLabel => 'ສະຫຼັບໄປໃຊ້ໂໝດປ້ອນຂໍ້ຄວາມ';

  @override
  String get invalidDateFormatLabel => 'ຮູບແບບບໍ່ຖືກຕ້ອງ.';

  @override
  String get invalidDateRangeLabel => 'ໄລຍະບໍ່ຖືກຕ້ອງ.';

  @override
  String get invalidTimeLabel => 'ລະບຸເວລາທີ່ຖືກຕ້ອງ';

  @override
  String get lastPageTooltip => 'ໜ້າສຸດທ້າຍ';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 ໃບອະນຸຍາດ';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount ໃບອະນຸຍາດ';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'ໃບອະນຸຍາດ';

  @override
  String get modalBarrierDismissLabel => 'ປິດໄວ້';

  @override
  String get moreButtonTooltip => 'ເພີ່ມເຕີມ';

  @override
  String get nextMonthTooltip => 'ເດືອນໜ້າ';

  @override
  String get nextPageTooltip => 'ໜ້າຕໍ່ໄປ';

  @override
  String get okButtonLabel => 'ຕົກລົງ';

  @override
  String get openAppDrawerTooltip => 'ເປີດເມນູການນຳທາງ';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow ຈາກທັງໝົດ $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow ຈາກປະມານ $rowCount';

  @override
  String get pasteButtonLabel => 'ວາງ';

  @override
  String get popupMenuLabel => 'ເມນູປັອບອັບ';

  @override
  String get postMeridiemAbbreviation => 'ຫຼັງທ່ຽງ';

  @override
  String get previousMonthTooltip => 'ເດືອນແລ້ວ';

  @override
  String get previousPageTooltip => 'ໜ້າກ່ອນໜ້າ';

  @override
  String get refreshIndicatorSemanticLabel => 'ໂຫຼດຄືນໃໝ່';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => 'ຍັງອີກ 1 ຕົວອັກສອນ';

  @override
  String get remainingTextFieldCharacterCountOther => r'ຍັງອີກ $remainingCount ຕົວອັກສອນ';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => 'ຍ້າຍລົງ';

  @override
  String get reorderItemLeft => 'ຍ້າຍໄປຊ້າຍ';

  @override
  String get reorderItemRight => 'ຍ້າຍໄປຂວາ';

  @override
  String get reorderItemToEnd => 'ຍ້າຍໄປສິ້ນສຸດ';

  @override
  String get reorderItemToStart => 'ຍ້າຍໄປເລີ່ມຕົ້ນ';

  @override
  String get reorderItemUp => 'ຍ້າຍຂຶ້ນ';

  @override
  String get rowsPerPageTitle => 'ແຖວຕໍ່ໜ້າ:';

  @override
  String get saveButtonLabel => 'ບັນທຶກ';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.tall;

  @override
  String get searchFieldLabel => 'ຊອກຫາ';

  @override
  String get selectAllButtonLabel => 'ເລືອກທັງໝົດ';

  @override
  String get selectYearSemanticsLabel => 'ເລືອກ​ປີ';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => 'ເລືອກ 1 ລາຍການແລ້ວ';

  @override
  String get selectedRowCountTitleOther => r'ເລືອກ $selectedRowCount ລາຍການແລ້ວ';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'ສະແດງບັນຊີ';

  @override
  String get showMenuTooltip => 'ສະແດງເມນູ';

  @override
  String get signedInLabel => 'ເຂົ້າສູ່ລະບົບແລ້ວ';

  @override
  String get tabLabelRaw => r'ແຖບທີ $tabIndex ຈາກທັງໝົດ $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => 'ເລືອກເວລາ';

  @override
  String get timePickerHourLabel => 'ຊົ່ວໂມງ';

  @override
  String get timePickerHourModeAnnouncement => 'ເລືອກໂມງ';

  @override
  String get timePickerInputHelpText => 'ລະບຸເວລາ';

  @override
  String get timePickerMinuteLabel => 'ນາທີ';

  @override
  String get timePickerMinuteModeAnnouncement => 'ເລືອກນາທີ';

  @override
  String get unspecifiedDate => 'ວັນທີ';

  @override
  String get unspecifiedDateRange => 'ຊ່ວງວັນທີ';

  @override
  String get viewLicensesButtonLabel => 'ເບິ່ງໃບອະນຸຍາດ';
}

/// The translations for Lithuanian (`lt`).
class MaterialLocalizationLt extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Lithuanian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationLt({
    String localeName = 'lt',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Apie „$applicationName“';

  @override
  String get alertDialogLabel => 'Įspėjimas';

  @override
  String get anteMeridiemAbbreviation => 'priešpiet';

  @override
  String get backButtonTooltip => 'Atgal';

  @override
  String get calendarModeButtonLabel => 'Perjungti į kalendorių';

  @override
  String get cancelButtonLabel => 'ATŠAUKTI';

  @override
  String get closeButtonLabel => 'UŽDARYTI';

  @override
  String get closeButtonTooltip => 'Uždaryti';

  @override
  String get collapsedIconTapHint => 'Išskleisti';

  @override
  String get continueButtonLabel => 'TĘSTI';

  @override
  String get copyButtonLabel => 'Kopijuoti';

  @override
  String get cutButtonLabel => 'Iškirpti';

  @override
  String get dateHelpText => 'yyyy/mm/dd/';

  @override
  String get dateInputLabel => 'Įveskite datą';

  @override
  String get dateOutOfRangeLabel => 'Nepatenka į diapazoną.';

  @override
  String get datePickerHelpText => 'PASIRINKITE DATĄ';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Pabaigos data: $fullDate';

  @override
  String get dateRangeEndLabel => 'Pabaigos data';

  @override
  String get dateRangePickerHelpText => 'PASIRINKITE DIAPAZONĄ';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Pradžios data: $fullDate';

  @override
  String get dateRangeStartLabel => 'Pradžios data';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'Ištrinti';

  @override
  String get dialModeButtonLabel => 'Perjungti į ciferblato parinkiklio režimą';

  @override
  String get dialogLabel => 'Dialogo langas';

  @override
  String get drawerLabel => 'Naršymo meniu';

  @override
  String get expandedIconTapHint => 'Sutraukti';

  @override
  String get firstPageTooltip => 'Pirmas puslapis';

  @override
  String get hideAccountsLabel => 'Slėpti paskyras';

  @override
  String get inputDateModeButtonLabel => 'Perjungti į įvestį';

  @override
  String get inputTimeModeButtonLabel => 'Perjungti į teksto įvesties režimą';

  @override
  String get invalidDateFormatLabel => 'Netinkamas formatas.';

  @override
  String get invalidDateRangeLabel => 'Netinkamas diapazonas.';

  @override
  String get invalidTimeLabel => 'Įveskite tinkamą laiką';

  @override
  String get lastPageTooltip => 'Paskutinis puslapis';

  @override
  String? get licensesPackageDetailTextFew => r'$licenseCount licencijos';

  @override
  String? get licensesPackageDetailTextMany => r'$licenseCount licencijos';

  @override
  String? get licensesPackageDetailTextOne => '1 licencija';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licencijų';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Licencijos';

  @override
  String get modalBarrierDismissLabel => 'Atsisakyti';

  @override
  String get moreButtonTooltip => 'Daugiau';

  @override
  String get nextMonthTooltip => 'Kitas mėnuo';

  @override
  String get nextPageTooltip => 'Kitas puslapis';

  @override
  String get okButtonLabel => 'GERAI';

  @override
  String get openAppDrawerTooltip => 'Atidaryti naršymo meniu';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow iš $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow iš maždaug $rowCount';

  @override
  String get pasteButtonLabel => 'Įklijuoti';

  @override
  String get popupMenuLabel => 'Iššokantysis meniu';

  @override
  String get postMeridiemAbbreviation => 'popiet';

  @override
  String get previousMonthTooltip => 'Ankstesnis mėnuo';

  @override
  String get previousPageTooltip => 'Ankstesnis puslapis';

  @override
  String get refreshIndicatorSemanticLabel => 'Atnaujinti';

  @override
  String? get remainingTextFieldCharacterCountFew => r'Liko $remainingCount simboliai';

  @override
  String? get remainingTextFieldCharacterCountMany => r'Liko $remainingCount simbolio';

  @override
  String? get remainingTextFieldCharacterCountOne => 'Liko 1 simbolis';

  @override
  String get remainingTextFieldCharacterCountOther => r'Liko $remainingCount simbolių';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Perkelti žemyn';

  @override
  String get reorderItemLeft => 'Perkelti kairėn';

  @override
  String get reorderItemRight => 'Perkelti dešinėn';

  @override
  String get reorderItemToEnd => 'Perkelti į pabaigą';

  @override
  String get reorderItemToStart => 'Perkelti į pradžią';

  @override
  String get reorderItemUp => 'Perkelti aukštyn';

  @override
  String get rowsPerPageTitle => 'Eilučių puslapyje:';

  @override
  String get saveButtonLabel => 'IŠSAUGOTI';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Paieška';

  @override
  String get selectAllButtonLabel => 'Pasirinkti viską';

  @override
  String get selectYearSemanticsLabel => 'Pasirinkite metus';

  @override
  String? get selectedRowCountTitleFew => r'Pasirinkti $selectedRowCount elementai';

  @override
  String? get selectedRowCountTitleMany => r'Pasirinkta $selectedRowCount elemento';

  @override
  String? get selectedRowCountTitleOne => 'Pasirinktas 1 elementas';

  @override
  String get selectedRowCountTitleOther => r'Pasirinkta $selectedRowCount elementų';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Rodyti paskyras';

  @override
  String get showMenuTooltip => 'Rodyti meniu';

  @override
  String get signedInLabel => 'Prisijungta';

  @override
  String get tabLabelRaw => r'$tabIndex skirtukas iš $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'PASIRINKITE LAIKĄ';

  @override
  String get timePickerHourLabel => 'Valandos';

  @override
  String get timePickerHourModeAnnouncement => 'Pasirinkite valandas';

  @override
  String get timePickerInputHelpText => 'ĮVESKITE LAIKĄ';

  @override
  String get timePickerMinuteLabel => 'Minutės';

  @override
  String get timePickerMinuteModeAnnouncement => 'Pasirinkite minutes';

  @override
  String get unspecifiedDate => 'Data';

  @override
  String get unspecifiedDateRange => 'Dienų seka';

  @override
  String get viewLicensesButtonLabel => 'PERŽIŪRĖTI LICENCIJAS';
}

/// The translations for Latvian (`lv`).
class MaterialLocalizationLv extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Latvian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationLv({
    String localeName = 'lv',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Par $applicationName';

  @override
  String get alertDialogLabel => 'Brīdinājums';

  @override
  String get anteMeridiemAbbreviation => 'priekšpusdienā';

  @override
  String get backButtonTooltip => 'Atpakaļ';

  @override
  String get calendarModeButtonLabel => 'Pārslēgties uz kalendāru';

  @override
  String get cancelButtonLabel => 'ATCELT';

  @override
  String get closeButtonLabel => 'AIZVĒRT';

  @override
  String get closeButtonTooltip => 'Aizvērt';

  @override
  String get collapsedIconTapHint => 'Izvērst';

  @override
  String get continueButtonLabel => 'TURPINĀT';

  @override
  String get copyButtonLabel => 'Kopēt';

  @override
  String get cutButtonLabel => 'Izgriezt';

  @override
  String get dateHelpText => 'dd/mm/gggg';

  @override
  String get dateInputLabel => 'Ievadiet datumu';

  @override
  String get dateOutOfRangeLabel => 'Ārpus diapazona.';

  @override
  String get datePickerHelpText => 'ATLASIET DATUMU';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Beigu datums: $fullDate';

  @override
  String get dateRangeEndLabel => 'Beigu datums';

  @override
  String get dateRangePickerHelpText => 'ATLASIET DIAPAZONU';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Sākuma datums: $fullDate';

  @override
  String get dateRangeStartLabel => 'Sākuma datums';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'Dzēst';

  @override
  String get dialModeButtonLabel => 'Pārslēgties uz ciparnīcas atlasītāja režīmu';

  @override
  String get dialogLabel => 'Dialoglodziņš';

  @override
  String get drawerLabel => 'Navigācijas izvēlne';

  @override
  String get expandedIconTapHint => 'Sakļaut';

  @override
  String get firstPageTooltip => 'Pirmā lapa';

  @override
  String get hideAccountsLabel => 'Slēpt kontus';

  @override
  String get inputDateModeButtonLabel => 'Pārslēgties uz ievadi';

  @override
  String get inputTimeModeButtonLabel => 'Pārslēgties uz teksta ievades režīmu';

  @override
  String get invalidDateFormatLabel => 'Nederīgs formāts.';

  @override
  String get invalidDateRangeLabel => 'Nederīgs diapazons.';

  @override
  String get invalidTimeLabel => 'Ievadiet derīgu laiku.';

  @override
  String get lastPageTooltip => 'Pēdējā lapa';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 licence';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licences';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'Nav licenču';

  @override
  String get licensesPageTitle => 'Licences';

  @override
  String get modalBarrierDismissLabel => 'Nerādīt';

  @override
  String get moreButtonTooltip => 'Vairāk';

  @override
  String get nextMonthTooltip => 'Nākamais mēnesis';

  @override
  String get nextPageTooltip => 'Nākamā lapa';

  @override
  String get okButtonLabel => 'LABI';

  @override
  String get openAppDrawerTooltip => 'Atvērt navigācijas izvēlni';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow.–$lastRow. no $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow.–$lastRow. no aptuveni $rowCount';

  @override
  String get pasteButtonLabel => 'Ielīmēt';

  @override
  String get popupMenuLabel => 'Uznirstošā izvēlne';

  @override
  String get postMeridiemAbbreviation => 'pēcpusdienā';

  @override
  String get previousMonthTooltip => 'Iepriekšējais mēnesis';

  @override
  String get previousPageTooltip => 'Iepriekšējā lapa';

  @override
  String get refreshIndicatorSemanticLabel => 'Atsvaidzināt';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => 'Atlikusi 1 rakstzīme.';

  @override
  String get remainingTextFieldCharacterCountOther => r'Atlikušas $remainingCount rakstzīmes.';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'Nav atlikusi neviena rakstzīme.';

  @override
  String get reorderItemDown => 'Pārvietot uz leju';

  @override
  String get reorderItemLeft => 'Pārvietot pa kreisi';

  @override
  String get reorderItemRight => 'Pārvietot pa labi';

  @override
  String get reorderItemToEnd => 'Pārvietot uz beigām';

  @override
  String get reorderItemToStart => 'Pārvietot uz sākumu';

  @override
  String get reorderItemUp => 'Pārvietot uz augšu';

  @override
  String get rowsPerPageTitle => 'Rindas lapā:';

  @override
  String get saveButtonLabel => 'SAGLABĀT';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Meklēt';

  @override
  String get selectAllButtonLabel => 'Atlasīt visu';

  @override
  String get selectYearSemanticsLabel => 'Atlasiet gadu';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => 'Atlasīts 1 vienums';

  @override
  String get selectedRowCountTitleOther => r'Atlasīti $selectedRowCount vienumi';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => 'Nav atlasītu vienumu';

  @override
  String get showAccountsLabel => 'Rādīt kontus';

  @override
  String get showMenuTooltip => 'Rādīt izvēlni';

  @override
  String get signedInLabel => 'Esat pierakstījies';

  @override
  String get tabLabelRaw => r'$tabIndex. cilne no $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'ATLASIET LAIKU';

  @override
  String get timePickerHourLabel => 'Stunda';

  @override
  String get timePickerHourModeAnnouncement => 'Atlasiet stundas';

  @override
  String get timePickerInputHelpText => 'IEVADIET LAIKU';

  @override
  String get timePickerMinuteLabel => 'Minūte';

  @override
  String get timePickerMinuteModeAnnouncement => 'Atlasiet minūtes';

  @override
  String get unspecifiedDate => 'Datums';

  @override
  String get unspecifiedDateRange => 'Datumu diapazons';

  @override
  String get viewLicensesButtonLabel => 'SKATĪT LICENCES';
}

/// The translations for Macedonian (`mk`).
class MaterialLocalizationMk extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Macedonian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationMk({
    String localeName = 'mk',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'За $applicationName';

  @override
  String get alertDialogLabel => 'Предупредување';

  @override
  String get anteMeridiemAbbreviation => 'ПРЕТПЛАДНЕ';

  @override
  String get backButtonTooltip => 'Назад';

  @override
  String get calendarModeButtonLabel => 'Префрли на календар';

  @override
  String get cancelButtonLabel => 'ОТКАЖИ';

  @override
  String get closeButtonLabel => 'ЗАТВОРИ';

  @override
  String get closeButtonTooltip => 'Затвори';

  @override
  String get collapsedIconTapHint => 'Прошири';

  @override
  String get continueButtonLabel => 'ПРОДОЛЖИ';

  @override
  String get copyButtonLabel => 'Копирај';

  @override
  String get cutButtonLabel => 'Исечи';

  @override
  String get dateHelpText => 'dd.mm.yyyy';

  @override
  String get dateInputLabel => 'Внесете датум';

  @override
  String get dateOutOfRangeLabel => 'Надвор од опсег.';

  @override
  String get datePickerHelpText => 'ИЗБЕРЕТЕ ДАТУМ';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Краен датум $fullDate';

  @override
  String get dateRangeEndLabel => 'Краен датум';

  @override
  String get dateRangePickerHelpText => 'ИЗБЕРЕТЕ ОПСЕГ';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Датум на започнување $fullDate';

  @override
  String get dateRangeStartLabel => 'Датум на започнување';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'Избриши';

  @override
  String get dialModeButtonLabel => 'Префрлете се на режим на избирач';

  @override
  String get dialogLabel => 'Дијалог';

  @override
  String get drawerLabel => 'Мени за навигација';

  @override
  String get expandedIconTapHint => 'Собери';

  @override
  String get firstPageTooltip => 'Прва страница';

  @override
  String get hideAccountsLabel => 'Сокриј сметки';

  @override
  String get inputDateModeButtonLabel => 'Префрли на внесување';

  @override
  String get inputTimeModeButtonLabel => 'Префрлете се на режим за внесување текст';

  @override
  String get invalidDateFormatLabel => 'Неважечки формат.';

  @override
  String get invalidDateRangeLabel => 'Погрешен опсег.';

  @override
  String get invalidTimeLabel => 'Внесете важечко време';

  @override
  String get lastPageTooltip => 'Последна страница';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 лиценца';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount лиценци';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Лиценци';

  @override
  String get modalBarrierDismissLabel => 'Отфрли';

  @override
  String get moreButtonTooltip => 'Уште';

  @override
  String get nextMonthTooltip => 'Следниот месец';

  @override
  String get nextPageTooltip => 'Следна страница';

  @override
  String get okButtonLabel => 'Во ред';

  @override
  String get openAppDrawerTooltip => 'Отворете го менито за навигација';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow - $lastRow од $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow - $lastRow од приближно $rowCount';

  @override
  String get pasteButtonLabel => 'Залепи';

  @override
  String get popupMenuLabel => 'Скокачко мени';

  @override
  String get postMeridiemAbbreviation => 'ПОПЛАДНЕ';

  @override
  String get previousMonthTooltip => 'Претходниот месец';

  @override
  String get previousPageTooltip => 'Претходна страница';

  @override
  String get refreshIndicatorSemanticLabel => 'Освежи';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => 'Преостанува уште 1 знак';

  @override
  String get remainingTextFieldCharacterCountOther => r'Преостануваат уште $remainingCount знаци';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => 'Преместете надолу';

  @override
  String get reorderItemLeft => 'Преместете налево';

  @override
  String get reorderItemRight => 'Преместете надесно';

  @override
  String get reorderItemToEnd => 'Преместете на крајот';

  @override
  String get reorderItemToStart => 'Преместете на почеток';

  @override
  String get reorderItemUp => 'Преместете нагоре';

  @override
  String get rowsPerPageTitle => 'Редови на страница:';

  @override
  String get saveButtonLabel => 'ЗАЧУВАЈ';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Пребарувајте';

  @override
  String get selectAllButtonLabel => 'Избери ги сите';

  @override
  String get selectYearSemanticsLabel => 'Изберете година';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => 'Избрана е 1 ставка';

  @override
  String get selectedRowCountTitleOther => r'Избрани се $selectedRowCount ставки';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Прикажи сметки';

  @override
  String get showMenuTooltip => 'Прикажи мени';

  @override
  String get signedInLabel => 'Најавени сте';

  @override
  String get tabLabelRaw => r'Картичка $tabIndex од $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => 'ИЗБЕРЕТЕ ВРЕМЕ';

  @override
  String get timePickerHourLabel => 'Час';

  @override
  String get timePickerHourModeAnnouncement => 'Изберете часови';

  @override
  String get timePickerInputHelpText => 'ВНЕСЕТЕ ВРЕМЕ';

  @override
  String get timePickerMinuteLabel => 'Минута';

  @override
  String get timePickerMinuteModeAnnouncement => 'Изберете минути';

  @override
  String get unspecifiedDate => 'Датум';

  @override
  String get unspecifiedDateRange => 'Временски период';

  @override
  String get viewLicensesButtonLabel => 'ПРИКАЖИ ЛИЦЕНЦИ';
}

/// The translations for Malayalam (`ml`).
class MaterialLocalizationMl extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Malayalam.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationMl({
    String localeName = 'ml',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName എന്നതിനെക്കുറിച്ച്';

  @override
  String get alertDialogLabel => 'മുന്നറിയിപ്പ്';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'മടങ്ങുക';

  @override
  String get calendarModeButtonLabel => 'കലണ്ടറിലേക്ക് മാറുക';

  @override
  String get cancelButtonLabel => 'റദ്ദാക്കുക';

  @override
  String get closeButtonLabel => 'അടയ്‌ക്കുക';

  @override
  String get closeButtonTooltip => 'അടയ്‌ക്കുക';

  @override
  String get collapsedIconTapHint => 'വികസിപ്പിക്കുക';

  @override
  String get continueButtonLabel => 'തുടരുക';

  @override
  String get copyButtonLabel => 'പകർത്തുക';

  @override
  String get cutButtonLabel => 'മുറിക്കുക';

  @override
  String get dateHelpText => 'mm/dd/yyyy';

  @override
  String get dateInputLabel => 'തീയതി നൽകുക';

  @override
  String get dateOutOfRangeLabel => 'സാധുവായ ശ്രേണിക്ക് പുറത്താണ്.';

  @override
  String get datePickerHelpText => 'തീയതി തിരഞ്ഞെടുക്കുക';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'അവസാനിക്കുന്ന തീയതി $fullDate';

  @override
  String get dateRangeEndLabel => 'അവസാനിക്കുന്ന തീയതി';

  @override
  String get dateRangePickerHelpText => 'ശ്രേണി തിരഞ്ഞെടുക്കുക';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'ആരംഭിക്കുന്ന തീയതി $fullDate';

  @override
  String get dateRangeStartLabel => 'ആരംഭിക്കുന്ന തീയതി';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'ഇല്ലാതാക്കുക';

  @override
  String get dialModeButtonLabel => 'ഡയൽ പിക്കർ മോഡിലേക്ക് മാറുക';

  @override
  String get dialogLabel => 'ഡയലോഗ്';

  @override
  String get drawerLabel => 'നാവിഗേഷൻ മെനു';

  @override
  String get expandedIconTapHint => 'ചുരുക്കുക';

  @override
  String get firstPageTooltip => 'ആദ്യ പേജ്';

  @override
  String get hideAccountsLabel => 'അക്കൗണ്ടുകൾ മറയ്‌ക്കുക';

  @override
  String get inputDateModeButtonLabel => 'ഇൻപുട്ടിലേക്ക് മാറുക';

  @override
  String get inputTimeModeButtonLabel => 'ടെക്‌സ്‌റ്റ് ഇൻപുട്ട് മോഡിലേക്ക് മാറുക';

  @override
  String get invalidDateFormatLabel => 'തെറ്റായ ഫോർമാറ്റ്.';

  @override
  String get invalidDateRangeLabel => 'തെറ്റായ ശ്രേണി.';

  @override
  String get invalidTimeLabel => 'സാധുവായ സമയം നൽകുക';

  @override
  String get lastPageTooltip => 'അവസാന പേജ്';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => 'ഒരു ലൈസൻസ്';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount ലൈസൻസുകൾ';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'ലൈസൻസുകൾ';

  @override
  String get modalBarrierDismissLabel => 'നിരസിക്കുക';

  @override
  String get moreButtonTooltip => 'കൂടുതൽ';

  @override
  String get nextMonthTooltip => 'അടുത്ത മാസം';

  @override
  String get nextPageTooltip => 'അടുത്ത പേജ്';

  @override
  String get okButtonLabel => 'ശരി';

  @override
  String get openAppDrawerTooltip => 'നാവിഗേഷൻ മെനു തുറക്കുക';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCount-ൽ $firstRow –$lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'ഏകദേശം $rowCount-ൽ $firstRow –$lastRow';

  @override
  String get pasteButtonLabel => 'ഒട്ടിക്കുക';

  @override
  String get popupMenuLabel => 'പോപ്പ് അപ്പ് മെനു';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'മുമ്പത്തെ മാസം';

  @override
  String get previousPageTooltip => 'മുമ്പത്തെ പേജ്';

  @override
  String get refreshIndicatorSemanticLabel => 'പുതുക്കിയെടുക്കുക';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => 'ഒരു പ്രതീകം ശേഷിക്കുന്നു';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount പ്രതീകങ്ങൾ ശേഷിക്കുന്നു';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => 'താഴോട്ട് നീക്കുക';

  @override
  String get reorderItemLeft => 'ഇടത്തോട്ട് നീക്കുക';

  @override
  String get reorderItemRight => 'വലത്തോട്ട് നീക്കുക';

  @override
  String get reorderItemToEnd => 'അവസാന ഭാഗത്തേക്ക് പോവുക';

  @override
  String get reorderItemToStart => 'തുടക്കത്തിലേക്ക് പോവുക';

  @override
  String get reorderItemUp => 'മുകളിലോട്ട് നീക്കുക';

  @override
  String get rowsPerPageTitle => 'ഓരോ പേജിലുമുള്ള വരികൾ:';

  @override
  String get saveButtonLabel => 'സംരക്ഷിക്കുക';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.tall;

  @override
  String get searchFieldLabel => 'തിരയുക';

  @override
  String get selectAllButtonLabel => 'എല്ലാം തിരഞ്ഞെടുക്കുക';

  @override
  String get selectYearSemanticsLabel => 'വർഷം തിരഞ്ഞെടുക്കുക';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => 'ഒരു ഇനം തിരഞ്ഞെടുത്തു';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount ഇനങ്ങൾ തിരഞ്ഞെടുത്തു';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'അക്കൗണ്ടുകൾ കാണിക്കുക';

  @override
  String get showMenuTooltip => 'മെനു കാണിക്കുക';

  @override
  String get signedInLabel => 'സൈൻ ഇൻ ചെയ്‌തു';

  @override
  String get tabLabelRaw => r'$tabCount-ൽ $tabIndex';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => 'സമയം തിരഞ്ഞെടുക്കുക';

  @override
  String get timePickerHourLabel => 'മണിക്കൂർ';

  @override
  String get timePickerHourModeAnnouncement => 'മണിക്കൂർ തിരഞ്ഞെടുക്കുക';

  @override
  String get timePickerInputHelpText => 'സമയം നൽകുക';

  @override
  String get timePickerMinuteLabel => 'മിനിറ്റ്';

  @override
  String get timePickerMinuteModeAnnouncement => 'മിനിറ്റ് തിരഞ്ഞെടുക്കുക';

  @override
  String get unspecifiedDate => 'തീയതി';

  @override
  String get unspecifiedDateRange => 'തീയതി ശ്രേണി';

  @override
  String get viewLicensesButtonLabel => 'ലൈസൻസുകൾ കാണുക';
}

/// The translations for Mongolian (`mn`).
class MaterialLocalizationMn extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Mongolian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationMn({
    String localeName = 'mn',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName-н тухай';

  @override
  String get alertDialogLabel => 'Сэрэмжлүүлэг';

  @override
  String get anteMeridiemAbbreviation => 'ӨГЛӨӨ';

  @override
  String get backButtonTooltip => 'Буцах';

  @override
  String get calendarModeButtonLabel => 'Календарь луу сэлгэх';

  @override
  String get cancelButtonLabel => 'БОЛИХ';

  @override
  String get closeButtonLabel => 'ХААХ';

  @override
  String get closeButtonTooltip => 'Хаах';

  @override
  String get collapsedIconTapHint => 'Дэлгэх';

  @override
  String get continueButtonLabel => 'ҮРГЭЛЖЛҮҮЛЭХ';

  @override
  String get copyButtonLabel => 'Хуулах';

  @override
  String get cutButtonLabel => 'Таслах';

  @override
  String get dateHelpText => 'жжжж.сс.өө';

  @override
  String get dateInputLabel => 'Огноо оруулах';

  @override
  String get dateOutOfRangeLabel => 'Интервалаас гадуур байна.';

  @override
  String get datePickerHelpText => 'ОГНОО СОНГОХ';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Дуусах огноо $fullDate';

  @override
  String get dateRangeEndLabel => 'Дуусах огноо';

  @override
  String get dateRangePickerHelpText => 'ИНТЕРВАЛ СОНГОХ';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Эхлэх огноо $fullDate';

  @override
  String get dateRangeStartLabel => 'Эхлэх огноо';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'Устгах';

  @override
  String get dialModeButtonLabel => 'Цаг сонгогч горим руу сэлгэх';

  @override
  String get dialogLabel => 'Харилцах цонх';

  @override
  String get drawerLabel => 'Навигацын цэс';

  @override
  String get expandedIconTapHint => 'Буулгах';

  @override
  String get firstPageTooltip => 'Эхний хуудас';

  @override
  String get hideAccountsLabel => 'Бүртгэлүүдийг нуух';

  @override
  String get inputDateModeButtonLabel => 'Оролт руу сэлгэх';

  @override
  String get inputTimeModeButtonLabel => 'Текст оруулах горим руу сэлгэх';

  @override
  String get invalidDateFormatLabel => 'Буруу формат байна.';

  @override
  String get invalidDateRangeLabel => 'Буруу интервал байна.';

  @override
  String get invalidTimeLabel => 'Цагийг зөв оруулна уу';

  @override
  String get lastPageTooltip => 'Сүүлийн хуудас';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 лиценз';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount лиценз';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Лиценз';

  @override
  String get modalBarrierDismissLabel => 'Үл хэрэгсэх';

  @override
  String get moreButtonTooltip => 'Бусад';

  @override
  String get nextMonthTooltip => 'Дараах сар';

  @override
  String get nextPageTooltip => 'Дараах хуудас';

  @override
  String get okButtonLabel => 'OK';

  @override
  String get openAppDrawerTooltip => 'Навигацын цэсийг нээх';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCount-н $firstRow–$lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'Ойролцоогоор $rowCount-н $firstRow–$lastRow';

  @override
  String get pasteButtonLabel => 'Буулгах';

  @override
  String get popupMenuLabel => 'Попап цэс';

  @override
  String get postMeridiemAbbreviation => 'ОРОЙ';

  @override
  String get previousMonthTooltip => 'Өмнөх сар';

  @override
  String get previousPageTooltip => 'Өмнөх хуудас';

  @override
  String get refreshIndicatorSemanticLabel => 'Сэргээх';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 тэмдэгт үлдсэн';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount тэмдэгт үлдсэн';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'No characters remaining';

  @override
  String get reorderItemDown => 'Доош зөөх';

  @override
  String get reorderItemLeft => 'Зүүн тийш зөөх';

  @override
  String get reorderItemRight => 'Баруун тийш зөөх';

  @override
  String get reorderItemToEnd => 'Төгсгөл рүү зөөх';

  @override
  String get reorderItemToStart => 'Эхлэл рүү зөөх';

  @override
  String get reorderItemUp => 'Дээш зөөх';

  @override
  String get rowsPerPageTitle => 'Хуудсан дахь мөрийн тоо:';

  @override
  String get saveButtonLabel => 'ХАДГАЛАХ';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Хайх';

  @override
  String get selectAllButtonLabel => 'Бүгдийг сонгох';

  @override
  String get selectYearSemanticsLabel => 'Жил сонгох';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 зүйл сонгосон';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount зүйл сонгосон';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => 'Бичлэг сонгоогүй байна';

  @override
  String get showAccountsLabel => 'Бүртгэлүүдийг харуулах';

  @override
  String get showMenuTooltip => 'Цэсийг харуулах';

  @override
  String get signedInLabel => 'Нэвтэрсэн';

  @override
  String get tabLabelRaw => r'$tabCount-н $tabIndex-р таб';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'ЦАГ СОНГОХ';

  @override
  String get timePickerHourLabel => 'Цаг';

  @override
  String get timePickerHourModeAnnouncement => 'Цаг сонгоно уу';

  @override
  String get timePickerInputHelpText => 'ЦАГ ОРУУЛАХ';

  @override
  String get timePickerMinuteLabel => 'Минут';

  @override
  String get timePickerMinuteModeAnnouncement => 'Минут сонгоно уу';

  @override
  String get unspecifiedDate => 'Огноо';

  @override
  String get unspecifiedDateRange => 'Хугацааны интервал';

  @override
  String get viewLicensesButtonLabel => 'ЛИЦЕНЗИЙГ ХАРАХ';
}

/// The translations for Marathi (`mr`).
class MaterialLocalizationMr extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Marathi.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationMr({
    String localeName = 'mr',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName बद्दल';

  @override
  String get alertDialogLabel => 'सूचना';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'मागे';

  @override
  String get calendarModeButtonLabel => 'कॅलेंडरवर स्विच करा';

  @override
  String get cancelButtonLabel => 'रद्द करा';

  @override
  String get closeButtonLabel => 'बंद करा';

  @override
  String get closeButtonTooltip => 'बंद करा';

  @override
  String get collapsedIconTapHint => 'विस्तार करा';

  @override
  String get continueButtonLabel => 'सुरू ठेवा';

  @override
  String get copyButtonLabel => 'कॉपी करा';

  @override
  String get cutButtonLabel => 'कट करा';

  @override
  String get dateHelpText => 'dd/mm/yyyy';

  @override
  String get dateInputLabel => 'तारीख एंटर करा';

  @override
  String get dateOutOfRangeLabel => 'श्रेणीच्या बाहेर आहे.';

  @override
  String get datePickerHelpText => 'तारीख निवडा';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'संपण्याची तारीख $fullDate';

  @override
  String get dateRangeEndLabel => 'संपण्याची तारीख';

  @override
  String get dateRangePickerHelpText => 'श्रेणी निवडा';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'सुरू होण्याची तारीख $fullDate';

  @override
  String get dateRangeStartLabel => 'सुरू होण्याची तारीख';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'हटवा';

  @override
  String get dialModeButtonLabel => 'डायल पिकर मोडवर स्विच करा';

  @override
  String get dialogLabel => 'डायलॉग';

  @override
  String get drawerLabel => 'नेव्हिगेशन मेनू';

  @override
  String get expandedIconTapHint => 'कोलॅप्स करा';

  @override
  String get firstPageTooltip => 'पहिले पेज';

  @override
  String get hideAccountsLabel => 'खाती लपवा';

  @override
  String get inputDateModeButtonLabel => 'इनपुटवर स्विच करा';

  @override
  String get inputTimeModeButtonLabel => 'मजकूर इनपुट मोडवर स्विच करा';

  @override
  String get invalidDateFormatLabel => 'फॉरमॅट चुकीचा आहे.';

  @override
  String get invalidDateRangeLabel => 'श्रेणी चुकीची आहे.';

  @override
  String get invalidTimeLabel => 'योग्य वेळ एंटर करा';

  @override
  String get lastPageTooltip => 'शेवटचे पेज';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => 'एक परवाना';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount परवाने';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'परवाने';

  @override
  String get modalBarrierDismissLabel => 'डिसमिस करा';

  @override
  String get moreButtonTooltip => 'आणखी';

  @override
  String get nextMonthTooltip => 'पुढील महिना';

  @override
  String get nextPageTooltip => 'पुढील पेज';

  @override
  String get okButtonLabel => 'ओके';

  @override
  String get openAppDrawerTooltip => 'नेव्हिगेशन मेनू उघडा';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCount पैकी $firstRow–$lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$rowCount च्या बद्दल $firstRow–$lastRow';

  @override
  String get pasteButtonLabel => 'पेस्ट करा';

  @override
  String get popupMenuLabel => 'पॉपअप मेनू';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'मागील महिना';

  @override
  String get previousPageTooltip => 'मागील पेज';

  @override
  String get refreshIndicatorSemanticLabel => 'रिफ्रेश करा';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => 'एक वर्ण शिल्लक';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount वर्ण शिल्लक';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'कोणतेही वर्ण शिल्लक नाहीत';

  @override
  String get reorderItemDown => 'खाली हलवा';

  @override
  String get reorderItemLeft => 'डावीकडे हलवा';

  @override
  String get reorderItemRight => 'उजवीकडे हलवा';

  @override
  String get reorderItemToEnd => 'शेवटाकडे हलवा';

  @override
  String get reorderItemToStart => 'सुरुवातीला हलवा';

  @override
  String get reorderItemUp => 'वर हलवा';

  @override
  String get rowsPerPageTitle => 'प्रति पेज पंक्ती:';

  @override
  String get saveButtonLabel => 'सेव्ह करा';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.dense;

  @override
  String get searchFieldLabel => 'शोध';

  @override
  String get selectAllButtonLabel => 'सर्व निवडा';

  @override
  String get selectYearSemanticsLabel => 'वर्ष निवडा';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => 'एक आयटम निवडला';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount आयटम निवडले';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => 'कोणतेही आयटम निवडलेले नाहीत';

  @override
  String get showAccountsLabel => 'खाती दर्शवा';

  @override
  String get showMenuTooltip => 'मेनू दाखवा';

  @override
  String get signedInLabel => 'साइन इन केले आहे';

  @override
  String get tabLabelRaw => r'$tabCount पैकी $tabIndex टॅब';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.h_colon_mm_space_a;

  @override
  String get timePickerDialHelpText => 'वेळ निवडा';

  @override
  String get timePickerHourLabel => 'तास';

  @override
  String get timePickerHourModeAnnouncement => 'तास निवडा';

  @override
  String get timePickerInputHelpText => 'वेळ एंटर करा';

  @override
  String get timePickerMinuteLabel => 'मिनिट';

  @override
  String get timePickerMinuteModeAnnouncement => 'मिनिटे निवडा';

  @override
  String get unspecifiedDate => 'तारीख';

  @override
  String get unspecifiedDateRange => 'तारीख श्रेणी';

  @override
  String get viewLicensesButtonLabel => 'परवाने पहा';
}

/// The translations for Malay (`ms`).
class MaterialLocalizationMs extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Malay.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationMs({
    String localeName = 'ms',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Perihal $applicationName';

  @override
  String get alertDialogLabel => 'Makluman';

  @override
  String get anteMeridiemAbbreviation => 'PG';

  @override
  String get backButtonTooltip => 'Kembali';

  @override
  String get calendarModeButtonLabel => 'Tukar kepada kalendar';

  @override
  String get cancelButtonLabel => 'BATAL';

  @override
  String get closeButtonLabel => 'TUTUP';

  @override
  String get closeButtonTooltip => 'Tutup';

  @override
  String get collapsedIconTapHint => 'Kembangkan';

  @override
  String get continueButtonLabel => 'TERUSKAN';

  @override
  String get copyButtonLabel => 'Salin';

  @override
  String get cutButtonLabel => 'Potong';

  @override
  String get dateHelpText => 'bb/hh/tttt';

  @override
  String get dateInputLabel => 'Masukkan Tarikh';

  @override
  String get dateOutOfRangeLabel => 'Di luar julat.';

  @override
  String get datePickerHelpText => 'PILIH TARIKH';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Tarikh tamat ialah $fullDate';

  @override
  String get dateRangeEndLabel => 'Tarikh Tamat';

  @override
  String get dateRangePickerHelpText => 'PILIH JULAT';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Tarikh mula ialah $fullDate';

  @override
  String get dateRangeStartLabel => 'Tarikh Mula';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'Padam';

  @override
  String get dialModeButtonLabel => 'Beralih kepada mod pemilih dail';

  @override
  String get dialogLabel => 'Dialog';

  @override
  String get drawerLabel => 'Menu navigasi';

  @override
  String get expandedIconTapHint => 'Runtuhkan';

  @override
  String get firstPageTooltip => 'Halaman pertama';

  @override
  String get hideAccountsLabel => 'Sembunyikan akaun';

  @override
  String get inputDateModeButtonLabel => 'Tukar kepada input';

  @override
  String get inputTimeModeButtonLabel => 'Beralih kepada mod input teks';

  @override
  String get invalidDateFormatLabel => 'Format tidak sah.';

  @override
  String get invalidDateRangeLabel => 'Julat tidak sah.';

  @override
  String get invalidTimeLabel => 'Masukkan masa yang sah';

  @override
  String get lastPageTooltip => 'Halaman terakhir';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 lesen';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount lesen';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Lesen';

  @override
  String get modalBarrierDismissLabel => 'Tolak';

  @override
  String get moreButtonTooltip => 'Lagi';

  @override
  String get nextMonthTooltip => 'Bulan depan';

  @override
  String get nextPageTooltip => 'Halaman seterusnya';

  @override
  String get okButtonLabel => 'OK';

  @override
  String get openAppDrawerTooltip => 'Buka menu navigasi';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow dari $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow dari kira-kira $rowCount';

  @override
  String get pasteButtonLabel => 'Tampal';

  @override
  String get popupMenuLabel => 'Menu pop timbul';

  @override
  String get postMeridiemAbbreviation => 'PTG';

  @override
  String get previousMonthTooltip => 'Bulan sebelumnya';

  @override
  String get previousPageTooltip => 'Halaman sebelumnya';

  @override
  String get refreshIndicatorSemanticLabel => 'Muat semula';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 aksara lagi';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount aksara lagi';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Alih ke bawah';

  @override
  String get reorderItemLeft => 'Alih ke kiri';

  @override
  String get reorderItemRight => 'Alih ke kanan';

  @override
  String get reorderItemToEnd => 'Alih ke penghujung';

  @override
  String get reorderItemToStart => 'Alih ke permulaan';

  @override
  String get reorderItemUp => 'Alih ke atas';

  @override
  String get rowsPerPageTitle => 'Baris setiap halaman:';

  @override
  String get saveButtonLabel => 'SIMPAN';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Cari';

  @override
  String get selectAllButtonLabel => 'Pilih semua';

  @override
  String get selectYearSemanticsLabel => 'Pilih tahun';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 item dipilih';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount item dipilih';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => 'Tiada item dipilih';

  @override
  String get showAccountsLabel => 'Tunjukkan akaun';

  @override
  String get showMenuTooltip => 'Tunjukkan menu';

  @override
  String get signedInLabel => 'Dilog masuk';

  @override
  String get tabLabelRaw => r'Tab $tabIndex dari $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.h_colon_mm_space_a;

  @override
  String get timePickerDialHelpText => 'PILIH MASA';

  @override
  String get timePickerHourLabel => 'Jam';

  @override
  String get timePickerHourModeAnnouncement => 'Pilih jam';

  @override
  String get timePickerInputHelpText => 'MASUKKAN MASA';

  @override
  String get timePickerMinuteLabel => 'Minit';

  @override
  String get timePickerMinuteModeAnnouncement => 'Pilih minit';

  @override
  String get unspecifiedDate => 'Tarikh';

  @override
  String get unspecifiedDateRange => 'Julat Tarikh';

  @override
  String get viewLicensesButtonLabel => 'LIHAT LESEN';
}

/// The translations for Burmese (`my`).
class MaterialLocalizationMy extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Burmese.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationMy({
    String localeName = 'my',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName အကြောင်း';

  @override
  String get alertDialogLabel => 'သတိပေးချက်';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'နောက်သို့';

  @override
  String get calendarModeButtonLabel => 'ပြက္ခဒိန်သို့ ပြောင်းရန်';

  @override
  String get cancelButtonLabel => 'မလုပ်တော့';

  @override
  String get closeButtonLabel => 'ပိတ်ရန်';

  @override
  String get closeButtonTooltip => 'ပိတ်ရန်';

  @override
  String get collapsedIconTapHint => 'ချဲ့ရန်';

  @override
  String get continueButtonLabel => 'ရှေ့ဆက်ရန်';

  @override
  String get copyButtonLabel => 'မိတ္တူကူးရန်';

  @override
  String get cutButtonLabel => 'ဖြတ်ယူရန်';

  @override
  String get dateHelpText => 'dd-mm-yyyy';

  @override
  String get dateInputLabel => 'ရက်စွဲ ထည့်ရန်';

  @override
  String get dateOutOfRangeLabel => 'အပိုင်းအခြား ပြင်ပတွင်ဖြစ်နေသည်။';

  @override
  String get datePickerHelpText => 'ရက်စွဲရွေးပါ';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'ပြီးဆုံးရက်စွဲ $fullDate';

  @override
  String get dateRangeEndLabel => 'ပြီးဆုံးရက်စွဲ';

  @override
  String get dateRangePickerHelpText => 'အပိုင်းအခြား ရွေးရန်';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'စတင်သည့် ရက်စွဲ $fullDate';

  @override
  String get dateRangeStartLabel => 'စတင်သည့် ရက်စွဲ';

  @override
  String get dateSeparator => '-';

  @override
  String get deleteButtonTooltip => 'ဖျက်ရန်';

  @override
  String get dialModeButtonLabel => 'နံပါတ်ရွေးချယ်ခြင်းမုဒ်သို့ ပြောင်းရန်';

  @override
  String get dialogLabel => 'ဒိုင်ယာလော့';

  @override
  String get drawerLabel => 'လမ်းညွှန် မီနူး';

  @override
  String get expandedIconTapHint => 'လျှော့ပြရန်';

  @override
  String get firstPageTooltip => 'ပထမ စာမျက်နှာ';

  @override
  String get hideAccountsLabel => 'အကောင့်များကို ဝှက်ရန်';

  @override
  String get inputDateModeButtonLabel => 'ထည့်သွင်းမှုသို့ ပြောင်းရန်';

  @override
  String get inputTimeModeButtonLabel => 'စာသား ထည့်သွင်းမှုမုဒ်သို့ ပြောင်းရန်';

  @override
  String get invalidDateFormatLabel => 'ဖော်မက် မမှန်ကန်ပါ။';

  @override
  String get invalidDateRangeLabel => 'အပိုင်းအခြား မမှန်ပါ။';

  @override
  String get invalidTimeLabel => 'မှန်ကန်သည့်အချိန် ထည့်ပါ';

  @override
  String get lastPageTooltip => 'နောက်ဆုံး စာမျက်နှာ';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => 'လိုင်စင် 1 ခု';

  @override
  String get licensesPackageDetailTextOther => r'လိုင်စင် $licenseCount ခု';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'လိုင်စင်များ';

  @override
  String get modalBarrierDismissLabel => 'ပယ်ရန်';

  @override
  String get moreButtonTooltip => 'နောက်ထပ်';

  @override
  String get nextMonthTooltip => 'နောက်လ';

  @override
  String get nextPageTooltip => 'နောက်စာမျက်နှာ';

  @override
  String get okButtonLabel => 'OK';

  @override
  String get openAppDrawerTooltip => 'လမ်းညွှန်မီနူးကို ဖွင့်ရန်';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCount အနက် $firstRow–$lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$rowCount ခန့်မှ $firstRow–$lastRow';

  @override
  String get pasteButtonLabel => 'ကူးထည့်ရန်';

  @override
  String get popupMenuLabel => 'ပေါ့ပ်အပ်မီနူး';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'ယခင်လ';

  @override
  String get previousPageTooltip => 'ယခင်စာမျက်နှာ';

  @override
  String get refreshIndicatorSemanticLabel => 'ပြန်လည်စတင်ရန်';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => 'အက္ခရာ ၁ လုံးကျန်သည်';

  @override
  String get remainingTextFieldCharacterCountOther => r'အက္ခရာ $remainingCount လုံးကျန်သည်';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => 'အောက်သို့ရွှေ့ရန်';

  @override
  String get reorderItemLeft => 'ဘယ်ဘက်သို့ရွှေ့ရန်';

  @override
  String get reorderItemRight => 'ညာဘက်သို့ရွှေ့ရန်';

  @override
  String get reorderItemToEnd => 'အဆုံးသို့ ‌ရွှေ့ရန်';

  @override
  String get reorderItemToStart => 'အစသို့ ရွှေ့ရန်';

  @override
  String get reorderItemUp => 'အပေါ်သို့ ရွှေ့ရန်';

  @override
  String get rowsPerPageTitle => 'စာတစ်မျက်နှာပါ လိုင်းအရေအတွက်−';

  @override
  String get saveButtonLabel => 'သိမ်းရန်';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.tall;

  @override
  String get searchFieldLabel => 'ရှာဖွေရန်';

  @override
  String get selectAllButtonLabel => 'အားလုံး ရွေးရန်';

  @override
  String get selectYearSemanticsLabel => 'ခုနှစ် ရွေးရန်';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '၁ ခု ရွေးထားသည်';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount ခု ရွေးထားသည်';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'အကောင့်များကို ပြရန်';

  @override
  String get showMenuTooltip => 'မီနူး ပြရန်';

  @override
  String get signedInLabel => 'လက်မှတ်ထိုး ဝင်ထားသည်';

  @override
  String get tabLabelRaw => r'တဘ် $tabCount အနက် $tabIndex ခု';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => 'အချိန်ရွေးရန်';

  @override
  String get timePickerHourLabel => 'နာရီ';

  @override
  String get timePickerHourModeAnnouncement => 'နာရီကို ရွေးပါ';

  @override
  String get timePickerInputHelpText => 'အချိန်ထည့်ရန်';

  @override
  String get timePickerMinuteLabel => 'မိနစ်';

  @override
  String get timePickerMinuteModeAnnouncement => 'မိနစ်ကို ရွေးပါ';

  @override
  String get unspecifiedDate => 'ရက်စွဲ';

  @override
  String get unspecifiedDateRange => 'ရက်အပိုင်းအခြား';

  @override
  String get viewLicensesButtonLabel => 'လိုင်စင်များကို ကြည့်ရန်';
}

/// The translations for Norwegian Bokmål (`nb`).
class MaterialLocalizationNb extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Norwegian Bokmål.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationNb({
    String localeName = 'nb',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Om $applicationName';

  @override
  String get alertDialogLabel => 'Varsel';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'Tilbake';

  @override
  String get calendarModeButtonLabel => 'Bytt til kalender';

  @override
  String get cancelButtonLabel => 'AVBRYT';

  @override
  String get closeButtonLabel => 'LUKK';

  @override
  String get closeButtonTooltip => 'Lukk';

  @override
  String get collapsedIconTapHint => 'Vis';

  @override
  String get continueButtonLabel => 'FORTSETT';

  @override
  String get copyButtonLabel => 'Kopiér';

  @override
  String get cutButtonLabel => 'Klipp ut';

  @override
  String get dateHelpText => 'dd.mm.åååå';

  @override
  String get dateInputLabel => 'Skriv inn datoen';

  @override
  String get dateOutOfRangeLabel => 'Utenfor perioden.';

  @override
  String get datePickerHelpText => 'VELG DATOEN';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Sluttdato $fullDate';

  @override
  String get dateRangeEndLabel => 'Sluttdato';

  @override
  String get dateRangePickerHelpText => 'VELG PERIODEN';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Startdato $fullDate';

  @override
  String get dateRangeStartLabel => 'Startdato';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'Slett';

  @override
  String get dialModeButtonLabel => 'Bytt til modus for valg fra urskive';

  @override
  String get dialogLabel => 'Dialogboks';

  @override
  String get drawerLabel => 'Navigasjonsmeny';

  @override
  String get expandedIconTapHint => 'Skjul';

  @override
  String get firstPageTooltip => 'Første side';

  @override
  String get hideAccountsLabel => 'Skjul kontoer';

  @override
  String get inputDateModeButtonLabel => 'Bytt til innskriving';

  @override
  String get inputTimeModeButtonLabel => 'Bytt til tekstinndatamodus';

  @override
  String get invalidDateFormatLabel => 'Ugyldig format.';

  @override
  String get invalidDateRangeLabel => 'Ugyldig periode.';

  @override
  String get invalidTimeLabel => 'Angi et gyldig klokkeslett';

  @override
  String get lastPageTooltip => 'Siste side';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 lisens';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount lisenser';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => null;

  @override
  String get licensesPageTitle => 'Lisenser';

  @override
  String get modalBarrierDismissLabel => 'Avvis';

  @override
  String get moreButtonTooltip => 'Mer';

  @override
  String get nextMonthTooltip => 'Neste måned';

  @override
  String get nextPageTooltip => 'Neste side';

  @override
  String get okButtonLabel => 'OK';

  @override
  String get openAppDrawerTooltip => 'Åpne navigasjonsmenyen';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow av $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow av omtrent $rowCount';

  @override
  String get pasteButtonLabel => 'Lim inn';

  @override
  String get popupMenuLabel => 'Forgrunnsmeny';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'Forrige måned';

  @override
  String get previousPageTooltip => 'Forrige side';

  @override
  String get refreshIndicatorSemanticLabel => 'Laster inn på nytt';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 tegn gjenstår';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount tegn gjenstår';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => 'Flytt ned';

  @override
  String get reorderItemLeft => 'Flytt til venstre';

  @override
  String get reorderItemRight => 'Flytt til høyre';

  @override
  String get reorderItemToEnd => 'Flytt til slutten';

  @override
  String get reorderItemToStart => 'Flytt til starten';

  @override
  String get reorderItemUp => 'Flytt opp';

  @override
  String get rowsPerPageTitle => 'Rader per side:';

  @override
  String get saveButtonLabel => 'LAGRE';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Søk';

  @override
  String get selectAllButtonLabel => 'Velg alle';

  @override
  String get selectYearSemanticsLabel => 'Velg året';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 element er valgt';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount elementer er valgt';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Vis kontoer';

  @override
  String get showMenuTooltip => 'Vis meny';

  @override
  String get signedInLabel => 'Pålogget';

  @override
  String get tabLabelRaw => r'Fane $tabIndex av $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'VELG KLOKKESLETT';

  @override
  String get timePickerHourLabel => 'Time';

  @override
  String get timePickerHourModeAnnouncement => 'Angi timer';

  @override
  String get timePickerInputHelpText => 'ANGI ET KLOKKESLETT';

  @override
  String get timePickerMinuteLabel => 'Minutt';

  @override
  String get timePickerMinuteModeAnnouncement => 'Angi minutter';

  @override
  String get unspecifiedDate => 'Dato';

  @override
  String get unspecifiedDateRange => 'Datoperiode';

  @override
  String get viewLicensesButtonLabel => 'SE LISENSER';
}

/// The translations for Nepali (`ne`).
class MaterialLocalizationNe extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Nepali.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationNe({
    String localeName = 'ne',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName बारे';

  @override
  String get alertDialogLabel => 'अलर्ट';

  @override
  String get anteMeridiemAbbreviation => 'पूर्वाह्न';

  @override
  String get backButtonTooltip => 'पछाडि जानुहोस्';

  @override
  String get calendarModeButtonLabel => 'पात्रो मोड प्रयोग गर्नुहोस्';

  @override
  String get cancelButtonLabel => 'रद्द गर्नुहोस्';

  @override
  String get closeButtonLabel => 'बन्द गर्नुहोस्';

  @override
  String get closeButtonTooltip => 'बन्द गर्नुहोस्';

  @override
  String get collapsedIconTapHint => 'विस्तार गर्नुहोस्';

  @override
  String get continueButtonLabel => 'जारी राख्नुहोस्';

  @override
  String get copyButtonLabel => 'प्रतिलिपि गर्नुहोस्';

  @override
  String get cutButtonLabel => 'काट्नुहोस्';

  @override
  String get dateHelpText => 'yyyy/mm/dd';

  @override
  String get dateInputLabel => 'मिति प्रविष्टि गर्नुहोस्';

  @override
  String get dateOutOfRangeLabel => 'दायराभन्दा बाहिर';

  @override
  String get datePickerHelpText => 'मिति चयन गर्नुहोस्';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'समाप्त हुने मिति $fullDate';

  @override
  String get dateRangeEndLabel => 'समाप्त हुने मिति';

  @override
  String get dateRangePickerHelpText => 'दायरा चयन गर्नुहोस्';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'सुरु हुने मिति $fullDate';

  @override
  String get dateRangeStartLabel => 'सुरु हुने मिति';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'मेट्नुहोस्';

  @override
  String get dialModeButtonLabel => 'डायल चयनकर्ता मोड प्रयोग गर्नुहोस्';

  @override
  String get dialogLabel => 'संवाद';

  @override
  String get drawerLabel => 'नेभिगेसन मेनु';

  @override
  String get expandedIconTapHint => 'संक्षिप्त गर्नुहोस्';

  @override
  String get firstPageTooltip => 'प्रथम पेज';

  @override
  String get hideAccountsLabel => 'खाताहरू लुकाउनुहोस्';

  @override
  String get inputDateModeButtonLabel => 'इनपुट मोड प्रयोग गर्नुहोस्';

  @override
  String get inputTimeModeButtonLabel => 'पाठ इनपुट मोड प्रयोग गर्नुहोस्';

  @override
  String get invalidDateFormatLabel => 'अवैध ढाँचा।';

  @override
  String get invalidDateRangeLabel => 'अवैध दायरा।';

  @override
  String get invalidTimeLabel => 'वैध समय प्रविष्टि गर्नुहोस्';

  @override
  String get lastPageTooltip => 'अन्तिम पेज';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => 'एउटा इजाजतपत्र';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount वटा इजाजतपत्र';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'इजाजतपत्रहरू';

  @override
  String get modalBarrierDismissLabel => 'खारेज गर्नुहोस्';

  @override
  String get moreButtonTooltip => 'थप';

  @override
  String get nextMonthTooltip => 'अर्को महिना';

  @override
  String get nextPageTooltip => 'अर्को पृष्ठ';

  @override
  String get okButtonLabel => 'ठिक छ';

  @override
  String get openAppDrawerTooltip => 'नेभिगेसन मेनु खोल्नुहोस्';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCount मध्ये $firstRow–$lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'लगभग $rowCount को $firstRow–$lastRow';

  @override
  String get pasteButtonLabel => 'टाँस्नुहोस्';

  @override
  String get popupMenuLabel => 'पपअप मेनु';

  @override
  String get postMeridiemAbbreviation => 'अपराह्न';

  @override
  String get previousMonthTooltip => 'अघिल्लो महिना';

  @override
  String get previousPageTooltip => 'अघिल्लो पृष्ठ';

  @override
  String get refreshIndicatorSemanticLabel => 'पुनः ताजा गर्नुहोस्';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '१ वर्ण बाँकी';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount वर्णहरू बाँकी';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => 'तल सार्नुहोस्';

  @override
  String get reorderItemLeft => 'बायाँ सार्नुहोस्';

  @override
  String get reorderItemRight => 'दायाँ सार्नुहोस्';

  @override
  String get reorderItemToEnd => 'अन्त्यमा जानुहोस्';

  @override
  String get reorderItemToStart => 'सुरुमा सार्नुहोस्';

  @override
  String get reorderItemUp => 'माथि सार्नुहोस्';

  @override
  String get rowsPerPageTitle => 'प्रत्येक पृष्ठमा रहेका पङ्क्तिहरूको सङ्ख्या:';

  @override
  String get saveButtonLabel => 'सेभ गर्नुहोस्';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.tall;

  @override
  String get searchFieldLabel => 'खोज्नुहोस्';

  @override
  String get selectAllButtonLabel => 'सबै बटनहरू चयन गर्नुहोस्';

  @override
  String get selectYearSemanticsLabel => 'वर्ष छान्नुहोस्';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '१ वस्तु चयन गरियो';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount वस्तुहरू चयन गरिए';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'खाताहरू देखाउनुहोस्';

  @override
  String get showMenuTooltip => 'मेनु देखाउनुहोस्';

  @override
  String get signedInLabel => 'साइन इन गरियो';

  @override
  String get tabLabelRaw => r'$tabCount मध्ये $tabIndex ट्याब';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => 'समय चयन गर्नुहोस्';

  @override
  String get timePickerHourLabel => 'घन्टा';

  @override
  String get timePickerHourModeAnnouncement => 'घन्टा चयन गर्नुहोस्';

  @override
  String get timePickerInputHelpText => 'समय प्रविष्टि गर्नुहोस्';

  @override
  String get timePickerMinuteLabel => 'मिनेट';

  @override
  String get timePickerMinuteModeAnnouncement => 'मिनेट चयन गर्नुहोस्';

  @override
  String get unspecifiedDate => 'मिति';

  @override
  String get unspecifiedDateRange => 'मितिको दायरा';

  @override
  String get viewLicensesButtonLabel => 'इजाजतपत्रहरू हेर्नुहोस्';
}

/// The translations for Dutch Flemish (`nl`).
class MaterialLocalizationNl extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Dutch Flemish.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationNl({
    String localeName = 'nl',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Over $applicationName';

  @override
  String get alertDialogLabel => 'Melding';

  @override
  String get anteMeridiemAbbreviation => 'am';

  @override
  String get backButtonTooltip => 'Terug';

  @override
  String get calendarModeButtonLabel => 'Overschakelen naar kalender';

  @override
  String get cancelButtonLabel => 'ANNULEREN';

  @override
  String get closeButtonLabel => 'SLUITEN';

  @override
  String get closeButtonTooltip => 'Sluiten';

  @override
  String get collapsedIconTapHint => 'Uitvouwen';

  @override
  String get continueButtonLabel => 'DOORGAAN';

  @override
  String get copyButtonLabel => 'Kopiëren';

  @override
  String get cutButtonLabel => 'Knippen';

  @override
  String get dateHelpText => 'dd-mm-jjjj';

  @override
  String get dateInputLabel => 'Datum opgeven';

  @override
  String get dateOutOfRangeLabel => 'Buiten bereik.';

  @override
  String get datePickerHelpText => 'DATUM SELECTEREN';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Einddatum $fullDate';

  @override
  String get dateRangeEndLabel => 'Einddatum';

  @override
  String get dateRangePickerHelpText => 'PERIODE SELECTEREN';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Startdatum $fullDate';

  @override
  String get dateRangeStartLabel => 'Startdatum';

  @override
  String get dateSeparator => '-';

  @override
  String get deleteButtonTooltip => 'Verwijderen';

  @override
  String get dialModeButtonLabel => 'Overschakelen naar klok';

  @override
  String get dialogLabel => 'Dialoogvenster';

  @override
  String get drawerLabel => 'Navigatiemenu';

  @override
  String get expandedIconTapHint => 'Samenvouwen';

  @override
  String get firstPageTooltip => 'Eerste pagina';

  @override
  String get hideAccountsLabel => 'Accounts verbergen';

  @override
  String get inputDateModeButtonLabel => 'Overschakelen naar invoer';

  @override
  String get inputTimeModeButtonLabel => 'Overschakelen naar tekstinvoer';

  @override
  String get invalidDateFormatLabel => 'Ongeldige indeling.';

  @override
  String get invalidDateRangeLabel => 'Ongeldige periode.';

  @override
  String get invalidTimeLabel => 'Geef een geldige tijd op';

  @override
  String get lastPageTooltip => 'Laatste pagina';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 licentie';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licenties';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Licenties';

  @override
  String get modalBarrierDismissLabel => 'Sluiten';

  @override
  String get moreButtonTooltip => 'Meer';

  @override
  String get nextMonthTooltip => 'Volgende maand';

  @override
  String get nextPageTooltip => 'Volgende pagina';

  @override
  String get okButtonLabel => 'OK';

  @override
  String get openAppDrawerTooltip => 'Navigatiemenu openen';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow-$lastRow van $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow-$lastRow van ongeveer $rowCount';

  @override
  String get pasteButtonLabel => 'Plakken';

  @override
  String get popupMenuLabel => 'Pop-upmenu';

  @override
  String get postMeridiemAbbreviation => 'pm';

  @override
  String get previousMonthTooltip => 'Vorige maand';

  @override
  String get previousPageTooltip => 'Vorige pagina';

  @override
  String get refreshIndicatorSemanticLabel => 'Vernieuwen';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 teken resterend';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount tekens resterend';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Omlaag verplaatsen';

  @override
  String get reorderItemLeft => 'Naar links verplaatsen';

  @override
  String get reorderItemRight => 'Naar rechts verplaatsen';

  @override
  String get reorderItemToEnd => 'Naar het einde verplaatsen';

  @override
  String get reorderItemToStart => 'Naar het begin verplaatsen';

  @override
  String get reorderItemUp => 'Omhoog verplaatsen';

  @override
  String get rowsPerPageTitle => 'Rijen per pagina:';

  @override
  String get saveButtonLabel => 'OPSLAAN';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Zoeken';

  @override
  String get selectAllButtonLabel => 'Alles selecteren';

  @override
  String get selectYearSemanticsLabel => 'Jaar selecteren';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 item geselecteerd';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount items geselecteerd';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Accounts weergeven';

  @override
  String get showMenuTooltip => 'Menu weergeven';

  @override
  String get signedInLabel => 'Ingelogd';

  @override
  String get tabLabelRaw => r'Tabblad $tabIndex van $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'TIJD SELECTEREN';

  @override
  String get timePickerHourLabel => 'Uur';

  @override
  String get timePickerHourModeAnnouncement => 'Uren selecteren';

  @override
  String get timePickerInputHelpText => 'TIJD OPGEVEN';

  @override
  String get timePickerMinuteLabel => 'Minuut';

  @override
  String get timePickerMinuteModeAnnouncement => 'Minuten selecteren';

  @override
  String get unspecifiedDate => 'Datum';

  @override
  String get unspecifiedDateRange => 'Periode';

  @override
  String get viewLicensesButtonLabel => 'LICENTIES BEKIJKEN';
}

/// The translations for Norwegian (`no`).
class MaterialLocalizationNo extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Norwegian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationNo({
    String localeName = 'no',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Om $applicationName';

  @override
  String get alertDialogLabel => 'Varsel';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'Tilbake';

  @override
  String get calendarModeButtonLabel => 'Bytt til kalender';

  @override
  String get cancelButtonLabel => 'AVBRYT';

  @override
  String get closeButtonLabel => 'LUKK';

  @override
  String get closeButtonTooltip => 'Lukk';

  @override
  String get collapsedIconTapHint => 'Vis';

  @override
  String get continueButtonLabel => 'FORTSETT';

  @override
  String get copyButtonLabel => 'Kopiér';

  @override
  String get cutButtonLabel => 'Klipp ut';

  @override
  String get dateHelpText => 'dd.mm.åååå';

  @override
  String get dateInputLabel => 'Skriv inn datoen';

  @override
  String get dateOutOfRangeLabel => 'Utenfor perioden.';

  @override
  String get datePickerHelpText => 'VELG DATOEN';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Sluttdato $fullDate';

  @override
  String get dateRangeEndLabel => 'Sluttdato';

  @override
  String get dateRangePickerHelpText => 'VELG PERIODEN';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Startdato $fullDate';

  @override
  String get dateRangeStartLabel => 'Startdato';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'Slett';

  @override
  String get dialModeButtonLabel => 'Bytt til modus for valg fra urskive';

  @override
  String get dialogLabel => 'Dialogboks';

  @override
  String get drawerLabel => 'Navigasjonsmeny';

  @override
  String get expandedIconTapHint => 'Skjul';

  @override
  String get firstPageTooltip => 'Første side';

  @override
  String get hideAccountsLabel => 'Skjul kontoer';

  @override
  String get inputDateModeButtonLabel => 'Bytt til innskriving';

  @override
  String get inputTimeModeButtonLabel => 'Bytt til tekstinndatamodus';

  @override
  String get invalidDateFormatLabel => 'Ugyldig format.';

  @override
  String get invalidDateRangeLabel => 'Ugyldig periode.';

  @override
  String get invalidTimeLabel => 'Angi et gyldig klokkeslett';

  @override
  String get lastPageTooltip => 'Siste side';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 lisens';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount lisenser';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => null;

  @override
  String get licensesPageTitle => 'Lisenser';

  @override
  String get modalBarrierDismissLabel => 'Avvis';

  @override
  String get moreButtonTooltip => 'Mer';

  @override
  String get nextMonthTooltip => 'Neste måned';

  @override
  String get nextPageTooltip => 'Neste side';

  @override
  String get okButtonLabel => 'OK';

  @override
  String get openAppDrawerTooltip => 'Åpne navigasjonsmenyen';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow av $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow av omtrent $rowCount';

  @override
  String get pasteButtonLabel => 'Lim inn';

  @override
  String get popupMenuLabel => 'Forgrunnsmeny';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'Forrige måned';

  @override
  String get previousPageTooltip => 'Forrige side';

  @override
  String get refreshIndicatorSemanticLabel => 'Laster inn på nytt';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 tegn gjenstår';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount tegn gjenstår';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => 'Flytt ned';

  @override
  String get reorderItemLeft => 'Flytt til venstre';

  @override
  String get reorderItemRight => 'Flytt til høyre';

  @override
  String get reorderItemToEnd => 'Flytt til slutten';

  @override
  String get reorderItemToStart => 'Flytt til starten';

  @override
  String get reorderItemUp => 'Flytt opp';

  @override
  String get rowsPerPageTitle => 'Rader per side:';

  @override
  String get saveButtonLabel => 'LAGRE';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Søk';

  @override
  String get selectAllButtonLabel => 'Velg alle';

  @override
  String get selectYearSemanticsLabel => 'Velg året';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 element er valgt';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount elementer er valgt';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Vis kontoer';

  @override
  String get showMenuTooltip => 'Vis meny';

  @override
  String get signedInLabel => 'Pålogget';

  @override
  String get tabLabelRaw => r'Fane $tabIndex av $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'VELG KLOKKESLETT';

  @override
  String get timePickerHourLabel => 'Time';

  @override
  String get timePickerHourModeAnnouncement => 'Angi timer';

  @override
  String get timePickerInputHelpText => 'ANGI ET KLOKKESLETT';

  @override
  String get timePickerMinuteLabel => 'Minutt';

  @override
  String get timePickerMinuteModeAnnouncement => 'Angi minutter';

  @override
  String get unspecifiedDate => 'Dato';

  @override
  String get unspecifiedDateRange => 'Datoperiode';

  @override
  String get viewLicensesButtonLabel => 'SE LISENSER';
}

/// The translations for Oriya (`or`).
class MaterialLocalizationOr extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Oriya.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationOr({
    String localeName = 'or',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName ବିଷୟରେ';

  @override
  String get alertDialogLabel => 'ଆଲର୍ଟ';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'ପଛକୁ ଫେରନ୍ତୁ';

  @override
  String get calendarModeButtonLabel => 'କ୍ୟାଲେଣ୍ଡରକୁ ସ୍ୱିଚ୍ କରନ୍ତୁ';

  @override
  String get cancelButtonLabel => 'ବାତିଲ୍ କରନ୍ତୁ';

  @override
  String get closeButtonLabel => 'ବନ୍ଦ କରନ୍ତୁ';

  @override
  String get closeButtonTooltip => 'ବନ୍ଦ କରନ୍ତୁ';

  @override
  String get collapsedIconTapHint => 'ପ୍ରସାରିତ କରନ୍ତୁ';

  @override
  String get continueButtonLabel => 'ଜାରି ରଖନ୍ତୁ';

  @override
  String get copyButtonLabel => 'କପି କରନ୍ତୁ';

  @override
  String get cutButtonLabel => 'କଟ୍ କରନ୍ତୁ';

  @override
  String get dateHelpText => 'mm/dd/yyyy';

  @override
  String get dateInputLabel => 'ତାରିଖ ଲେଖନ୍ତୁ';

  @override
  String get dateOutOfRangeLabel => 'ସୀମା ବାହାରେ।';

  @override
  String get datePickerHelpText => 'ତାରିଖ ଚୟନ କରନ୍ତୁ';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'ଶେଷ ତାରିଖ $fullDate';

  @override
  String get dateRangeEndLabel => 'ଶେଷ ତାରିଖ';

  @override
  String get dateRangePickerHelpText => 'ସୀମା ଚୟନ କରନ୍ତୁ';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'ଆରମ୍ଭ ତାରିଖ $fullDate';

  @override
  String get dateRangeStartLabel => 'ଆରମ୍ଭ ତାରିଖ';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'ଡିଲିଟ୍ କରନ୍ତୁ';

  @override
  String get dialModeButtonLabel => 'ଡାଏଲ୍ ପିକର୍ ମୋଡକୁ ସ୍ୱିଚ୍ କରନ୍ତୁ';

  @override
  String get dialogLabel => 'ଡାୟଲଗ୍';

  @override
  String get drawerLabel => 'ନେଭିଗେସନ୍ ମେନୁ';

  @override
  String get expandedIconTapHint => 'ସଙ୍କୁଚିତ କରନ୍ତୁ';

  @override
  String get firstPageTooltip => 'ପ୍ରଥମ ପୃଷ୍ଠା';

  @override
  String get hideAccountsLabel => 'ଆକାଉଣ୍ଟଗୁଡ଼ିକୁ ଲୁଚାନ୍ତୁ';

  @override
  String get inputDateModeButtonLabel => 'ଇନପୁଟକୁ ସ୍ୱିଚ୍ କରନ୍ତୁ';

  @override
  String get inputTimeModeButtonLabel => 'ଟେକ୍ସଟ୍ ଇନପୁଟ୍ ମୋଡକୁ ସ୍ୱିଚ୍ କରନ୍ତୁ';

  @override
  String get invalidDateFormatLabel => 'ଅବୈଧ ଫର୍ମାଟ୍।';

  @override
  String get invalidDateRangeLabel => 'ଅବୈଧ ସୀମା।';

  @override
  String get invalidTimeLabel => 'ଏକ ବୈଧ ସମୟ ଲେଖନ୍ତୁ';

  @override
  String get lastPageTooltip => 'ଶେଷ ପୃଷ୍ଠା';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1ଟି ଲାଇସେନ୍ସ';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCountଟି ଲାଇସେନ୍ସ';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'ଲାଇସେନ୍ସଗୁଡ଼କ';

  @override
  String get modalBarrierDismissLabel => 'ଖାରଜ କରନ୍ତୁ';

  @override
  String get moreButtonTooltip => 'ଅଧିକ';

  @override
  String get nextMonthTooltip => 'ପରବର୍ତ୍ତୀ ମାସ';

  @override
  String get nextPageTooltip => 'ପରବର୍ତ୍ତୀ ପେଜ୍';

  @override
  String get okButtonLabel => 'ଠିକ୍ ଅଛି';

  @override
  String get openAppDrawerTooltip => 'ନାଭିଗେସନ୍ ମେନୁ ଖୋଲନ୍ତୁ';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCountର $firstRow–$lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'ପାଖାପାଖି $rowCountର $firstRow–$lastRow';

  @override
  String get pasteButtonLabel => 'ପେଷ୍ଟ କରନ୍ତୁ';

  @override
  String get popupMenuLabel => 'ପପ୍-ଅପ୍ ମେନୁ';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'ପୂର୍ବ ମାସ';

  @override
  String get previousPageTooltip => 'ପୂର୍ବବର୍ତ୍ତୀ ପେଜ୍';

  @override
  String get refreshIndicatorSemanticLabel => 'ରିଫ୍ରେସ୍ କରନ୍ତୁ';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1ଟି ଅକ୍ଷର ବାକି ଅଛି';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCountଟି ଅକ୍ଷର ବାକି ଅଛି';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => 'ତଳକୁ ଯାଆନ୍ତୁ';

  @override
  String get reorderItemLeft => 'ବାମକୁ ଯାଆନ୍ତୁ';

  @override
  String get reorderItemRight => 'ଡାହାଣକୁ ଯାଆନ୍ତୁ';

  @override
  String get reorderItemToEnd => 'ଶେଷକୁ ଯାଆନ୍ତୁ';

  @override
  String get reorderItemToStart => 'ଆରମ୍ଭକୁ ଯାଆନ୍ତୁ';

  @override
  String get reorderItemUp => 'ଉପରକୁ ନିଅନ୍ତୁ';

  @override
  String get rowsPerPageTitle => 'ପୃଷ୍ଠା ପିଛା ଧାଡ଼ି:';

  @override
  String get saveButtonLabel => 'ସେଭ୍ କରନ୍ତୁ';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.tall;

  @override
  String get searchFieldLabel => 'ସନ୍ଧାନ କରନ୍ତୁ';

  @override
  String get selectAllButtonLabel => 'ସବୁ ଚୟନ କରନ୍ତୁ';

  @override
  String get selectYearSemanticsLabel => 'ବର୍ଷ ଚୟନ କରନ୍ତୁ';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1ଟି ଆଇଟମ୍ ଚୟନ କରାଯାଇଛି';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCountଟି ଆଇଟମ୍ ଚୟନ କରାଯାଇଛି';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'ଆକାଉଣ୍ଟ ଦେଖାନ୍ତୁ';

  @override
  String get showMenuTooltip => 'ମେନୁ ଦେଖାନ୍ତୁ';

  @override
  String get signedInLabel => 'ସାଇନ୍ ଇନ୍ କରାଯାଇଛି';

  @override
  String get tabLabelRaw => r'$tabCountର $tabIndex ଟାବ୍';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => 'ସମୟ ଚୟନ କରନ୍ତୁ';

  @override
  String get timePickerHourLabel => 'ଘଣ୍ଟା';

  @override
  String get timePickerHourModeAnnouncement => 'ଘଣ୍ଟା ଚୟନ କରନ୍ତୁ';

  @override
  String get timePickerInputHelpText => 'ସମୟ ଲେଖନ୍ତୁ';

  @override
  String get timePickerMinuteLabel => 'ମିନିଟ୍';

  @override
  String get timePickerMinuteModeAnnouncement => 'ମିନିଟ୍ ଚୟନ କରନ୍ତୁ';

  @override
  String get unspecifiedDate => 'ତାରିଖ';

  @override
  String get unspecifiedDateRange => 'ତାରିଖ ସୀମା';

  @override
  String get viewLicensesButtonLabel => 'ଲାଇସେନ୍ସ ଦେଖାନ୍ତୁ';
}

/// The translations for Panjabi Punjabi (`pa`).
class MaterialLocalizationPa extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Panjabi Punjabi.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationPa({
    String localeName = 'pa',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName ਬਾਰੇ';

  @override
  String get alertDialogLabel => 'ਸੁਚੇਤਨਾ';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'ਪਿੱਛੇ';

  @override
  String get calendarModeButtonLabel => "ਕੈਲੰਡਰ 'ਤੇ ਜਾਓ";

  @override
  String get cancelButtonLabel => 'ਰੱਦ ਕਰੋ';

  @override
  String get closeButtonLabel => 'ਬੰਦ ਕਰੋ';

  @override
  String get closeButtonTooltip => 'ਬੰਦ ਕਰੋ';

  @override
  String get collapsedIconTapHint => 'ਵਿਸਤਾਰ ਕਰੋ';

  @override
  String get continueButtonLabel => 'ਜਾਰੀ ਰੱਖੋ';

  @override
  String get copyButtonLabel => 'ਕਾਪੀ ਕਰੋ';

  @override
  String get cutButtonLabel => 'ਕੱਟ ਕਰੋ';

  @override
  String get dateHelpText => 'mm/dd/yyyy';

  @override
  String get dateInputLabel => 'ਤਾਰੀਖ ਦਾਖਲ ਕਰੋ';

  @override
  String get dateOutOfRangeLabel => 'ਰੇਂਜ-ਤੋਂ-ਬਾਹਰ।';

  @override
  String get datePickerHelpText => 'ਤਾਰੀਖ ਚੁਣੋ';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'ਸਮਾਪਤੀ ਦੀ ਤਾਰੀਖ $fullDate';

  @override
  String get dateRangeEndLabel => 'ਸਮਾਪਤੀ ਦੀ ਤਾਰੀਖ';

  @override
  String get dateRangePickerHelpText => 'ਰੇਂਜ ਚੁਣੋ';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'ਸ਼ੁਰੂਆਤੀ ਤਾਰੀਖ $fullDate';

  @override
  String get dateRangeStartLabel => 'ਸ਼ੁਰੂਆਤੀ ਤਾਰੀਖ';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'ਮਿਟਾਓ';

  @override
  String get dialModeButtonLabel => "ਡਾਇਲ ਚੋਣਕਾਰ ਮੋਡ 'ਤੇ ਜਾਓ";

  @override
  String get dialogLabel => 'ਵਿੰਡੋ';

  @override
  String get drawerLabel => 'ਨੈਵੀਗੇਸ਼ਨ ਮੀਨੂ';

  @override
  String get expandedIconTapHint => 'ਸਮੇਟੋ';

  @override
  String get firstPageTooltip => 'ਪਹਿਲਾ ਪੰਨਾ';

  @override
  String get hideAccountsLabel => 'ਖਾਤੇ ਲੁਕਾਓ';

  @override
  String get inputDateModeButtonLabel => "ਇਨਪੁੱਟ 'ਤੇ ਜਾਓ";

  @override
  String get inputTimeModeButtonLabel => "ਲਿਖਤ ਇਨਪੁੱਟ ਮੋਡ 'ਤੇ ਜਾਓ";

  @override
  String get invalidDateFormatLabel => 'ਅਵੈਧ ਫਾਰਮੈਟ।';

  @override
  String get invalidDateRangeLabel => 'ਅਵੈਧ ਰੇਂਜ।';

  @override
  String get invalidTimeLabel => 'ਵੈਧ ਸਮਾਂ ਦਾਖਲ ਕਰੋ';

  @override
  String get lastPageTooltip => 'ਆਖਰੀ ਪੰਨਾ';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 ਲਾਇਸੰਸ';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount ਲਾਇਸੰਸ';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'ਲਾਇਸੰਸ';

  @override
  String get modalBarrierDismissLabel => 'ਖਾਰਜ ਕਰੋ';

  @override
  String get moreButtonTooltip => 'ਹੋਰ';

  @override
  String get nextMonthTooltip => 'ਅਗਲਾ ਮਹੀਨਾ';

  @override
  String get nextPageTooltip => 'ਅਗਲਾ ਪੰਨਾ';

  @override
  String get okButtonLabel => 'ਠੀਕ ਹੈ';

  @override
  String get openAppDrawerTooltip => 'ਨੈਵੀਗੇਸ਼ਨ ਮੀਨੂ ਖੋਲ੍ਹੋ';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCount ਵਿੱਚੋਂ $firstRow–$lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'ਲਗਭਗ $rowCount ਵਿੱਚੋਂ $firstRow–$lastRow';

  @override
  String get pasteButtonLabel => 'ਪੇਸਟ ਕਰੋ';

  @override
  String get popupMenuLabel => 'ਪੌਪਅੱਪ ਮੀਨੂ';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'ਪਿਛਲਾ ਮਹੀਨਾ';

  @override
  String get previousPageTooltip => 'ਪਿਛਲਾ ਪੰਨਾ';

  @override
  String get refreshIndicatorSemanticLabel => 'ਰਿਫ੍ਰੈਸ਼ ਕਰੋ';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 ਅੱਖਰ-ਚਿੰਨ੍ਹ ਬਾਕੀ';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount ਅੱਖਰ-ਚਿੰਨ੍ਹ ਬਾਕੀ';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => 'ਹੇਠਾਂ ਲਿਜਾਓ';

  @override
  String get reorderItemLeft => 'ਖੱਬੇ ਲਿਜਾਓ';

  @override
  String get reorderItemRight => 'ਸੱਜੇ ਲਿਜਾਓ';

  @override
  String get reorderItemToEnd => 'ਅੰਤ ਵਿੱਚ ਲਿਜਾਓ';

  @override
  String get reorderItemToStart => 'ਸ਼ੁਰੂ ਵਿੱਚ ਲਿਜਾਓ';

  @override
  String get reorderItemUp => 'ਉੱਪਰ ਲਿਜਾਓ';

  @override
  String get rowsPerPageTitle => "ਹਰ ਪੰਨੇ 'ਤੇ ਕਤਾਰਾਂ:";

  @override
  String get saveButtonLabel => 'ਰੱਖਿਅਤ ਕਰੋ';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.tall;

  @override
  String get searchFieldLabel => 'ਖੋਜੋ';

  @override
  String get selectAllButtonLabel => 'ਸਭ ਚੁਣੋ';

  @override
  String get selectYearSemanticsLabel => 'ਸਾਲ ਚੁਣੋ';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 ਆਈਟਮ ਚੁਣੀ ਗਈ';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount ਆਈਟਮਾਂ ਚੁਣੀਆਂ ਗਈਆਂ';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'ਖਾਤੇ ਦਿਖਾਓ';

  @override
  String get showMenuTooltip => 'ਮੀਨੂ ਦਿਖਾਓ';

  @override
  String get signedInLabel => 'ਸਾਈਨ-ਇਨ ਕੀਤਾ ਗਿਆ';

  @override
  String get tabLabelRaw => r'$tabCount ਵਿੱਚੋਂ $tabIndex ਟੈਬ';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => 'ਸਮਾਂ ਚੁਣੋ';

  @override
  String get timePickerHourLabel => 'ਘੰਟਾ';

  @override
  String get timePickerHourModeAnnouncement => 'ਘੰਟੇ ਚੁਣੋ';

  @override
  String get timePickerInputHelpText => 'ਸਮਾਂ ਦਾਖਲ ਕਰੋ';

  @override
  String get timePickerMinuteLabel => 'ਮਿੰਟ';

  @override
  String get timePickerMinuteModeAnnouncement => 'ਮਿੰਟ ਚੁਣੋ';

  @override
  String get unspecifiedDate => 'ਤਾਰੀਖ';

  @override
  String get unspecifiedDateRange => 'ਤਾਰੀਖ ਦੀ ਰੇਂਜ';

  @override
  String get viewLicensesButtonLabel => 'ਲਾਇਸੰਸ ਦੇਖੋ';
}

/// The translations for Polish (`pl`).
class MaterialLocalizationPl extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Polish.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationPl({
    String localeName = 'pl',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName – informacje';

  @override
  String get alertDialogLabel => 'Alert';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'Wstecz';

  @override
  String get calendarModeButtonLabel => 'Przełącz na kalendarz';

  @override
  String get cancelButtonLabel => 'ANULUJ';

  @override
  String get closeButtonLabel => 'ZAMKNIJ';

  @override
  String get closeButtonTooltip => 'Zamknij';

  @override
  String get collapsedIconTapHint => 'Rozwiń';

  @override
  String get continueButtonLabel => 'DALEJ';

  @override
  String get copyButtonLabel => 'Kopiuj';

  @override
  String get cutButtonLabel => 'Wytnij';

  @override
  String get dateHelpText => 'dd.mm.rrrr';

  @override
  String get dateInputLabel => 'Wpisz datę';

  @override
  String get dateOutOfRangeLabel => 'Poza zakresem.';

  @override
  String get datePickerHelpText => 'WYBIERZ DATĘ';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Data zakończenia: $fullDate';

  @override
  String get dateRangeEndLabel => 'Data zakończenia';

  @override
  String get dateRangePickerHelpText => 'WYBIERZ ZAKRES';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Data rozpoczęcia: $fullDate';

  @override
  String get dateRangeStartLabel => 'Data rozpoczęcia';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'Usuń';

  @override
  String get dialModeButtonLabel => 'Włącz tryb selektora';

  @override
  String get dialogLabel => 'Okno dialogowe';

  @override
  String get drawerLabel => 'Menu nawigacyjne';

  @override
  String get expandedIconTapHint => 'Zwiń';

  @override
  String get firstPageTooltip => 'Pierwsza strona';

  @override
  String get hideAccountsLabel => 'Ukryj konta';

  @override
  String get inputDateModeButtonLabel => 'Przełącz na wpisywanie';

  @override
  String get inputTimeModeButtonLabel => 'Włącz tryb wprowadzania tekstu';

  @override
  String get invalidDateFormatLabel => 'Nieprawidłowy format.';

  @override
  String get invalidDateRangeLabel => 'Nieprawidłowy zakres.';

  @override
  String get invalidTimeLabel => 'Wpisz prawidłową godzinę';

  @override
  String get lastPageTooltip => 'Ostatnia strona';

  @override
  String? get licensesPackageDetailTextFew => r'$licenseCount licencje';

  @override
  String? get licensesPackageDetailTextMany => r'$licenseCount licencji';

  @override
  String? get licensesPackageDetailTextOne => '1 licencja';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licencji';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Licencje';

  @override
  String get modalBarrierDismissLabel => 'Zamknij';

  @override
  String get moreButtonTooltip => 'Więcej';

  @override
  String get nextMonthTooltip => 'Następny miesiąc';

  @override
  String get nextPageTooltip => 'Następna strona';

  @override
  String get okButtonLabel => 'OK';

  @override
  String get openAppDrawerTooltip => 'Otwórz menu nawigacyjne';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow z $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow z około $rowCount';

  @override
  String get pasteButtonLabel => 'Wklej';

  @override
  String get popupMenuLabel => 'Menu kontekstowe';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'Poprzedni miesiąc';

  @override
  String get previousPageTooltip => 'Poprzednia strona';

  @override
  String get refreshIndicatorSemanticLabel => 'Odśwież';

  @override
  String? get remainingTextFieldCharacterCountFew => r'Pozostały $remainingCount znaki';

  @override
  String? get remainingTextFieldCharacterCountMany => r'Pozostało $remainingCount znaków';

  @override
  String? get remainingTextFieldCharacterCountOne => 'Jeszcze 1 znak';

  @override
  String get remainingTextFieldCharacterCountOther => r'Pozostało $remainingCount znaków';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Przenieś w dół';

  @override
  String get reorderItemLeft => 'Przenieś w lewo';

  @override
  String get reorderItemRight => 'Przenieś w prawo';

  @override
  String get reorderItemToEnd => 'Przenieś na koniec';

  @override
  String get reorderItemToStart => 'Przenieś na początek';

  @override
  String get reorderItemUp => 'Przenieś w górę';

  @override
  String get rowsPerPageTitle => 'Wiersze na stronie:';

  @override
  String get saveButtonLabel => 'ZAPISZ';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Szukaj';

  @override
  String get selectAllButtonLabel => 'Zaznacz wszystko';

  @override
  String get selectYearSemanticsLabel => 'Wybierz rok';

  @override
  String? get selectedRowCountTitleFew => r'$selectedRowCount wybrane elementy';

  @override
  String? get selectedRowCountTitleMany => r'$selectedRowCount wybranych elementów';

  @override
  String? get selectedRowCountTitleOne => '1 wybrany element';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount wybranych elementów';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Pokaż konta';

  @override
  String get showMenuTooltip => 'Pokaż menu';

  @override
  String get signedInLabel => 'Zalogowani użytkownicy';

  @override
  String get tabLabelRaw => r'Karta $tabIndex z $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'WYBIERZ GODZINĘ';

  @override
  String get timePickerHourLabel => 'Godzina';

  @override
  String get timePickerHourModeAnnouncement => 'Wybierz godziny';

  @override
  String get timePickerInputHelpText => 'WPISZ GODZINĘ';

  @override
  String get timePickerMinuteLabel => 'Minuta';

  @override
  String get timePickerMinuteModeAnnouncement => 'Wybierz minuty';

  @override
  String get unspecifiedDate => 'Data';

  @override
  String get unspecifiedDateRange => 'Zakres dat';

  @override
  String get viewLicensesButtonLabel => 'WYŚWIETL LICENCJE';
}

/// The translations for Pushto Pashto (`ps`).
class MaterialLocalizationPs extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Pushto Pashto.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationPs({
    String localeName = 'ps',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'د $applicationName په اړه';

  @override
  String get alertDialogLabel => 'خبرتیا';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'شاته';

  @override
  String get calendarModeButtonLabel => 'Switch to calendar';

  @override
  String get cancelButtonLabel => 'لغوه کول';

  @override
  String get closeButtonLabel => 'تړل';

  @override
  String get closeButtonTooltip => 'بنده';

  @override
  String get collapsedIconTapHint => 'Expand';

  @override
  String get continueButtonLabel => 'منځپانګې';

  @override
  String get copyButtonLabel => 'کاپی';

  @override
  String get cutButtonLabel => 'کم کړئ';

  @override
  String get dateHelpText => 'mm/dd/yyyy';

  @override
  String get dateInputLabel => 'Enter Date';

  @override
  String get dateOutOfRangeLabel => 'Out of range.';

  @override
  String get datePickerHelpText => 'SELECT DATE';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'End date $fullDate';

  @override
  String get dateRangeEndLabel => 'End Date';

  @override
  String get dateRangePickerHelpText => 'SELECT RANGE';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Start date $fullDate';

  @override
  String get dateRangeStartLabel => 'Start Date';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => '';

  @override
  String get dialModeButtonLabel => 'Switch to dial picker mode';

  @override
  String get dialogLabel => 'خبرې اترې';

  @override
  String get drawerLabel => 'د نیویگیشن مینو';

  @override
  String get expandedIconTapHint => 'Collapse';

  @override
  String get firstPageTooltip => 'First page';

  @override
  String get hideAccountsLabel => 'حسابونه پټ کړئ';

  @override
  String get inputDateModeButtonLabel => 'Switch to input';

  @override
  String get inputTimeModeButtonLabel => 'Switch to text input mode';

  @override
  String get invalidDateFormatLabel => 'Invalid format.';

  @override
  String get invalidDateRangeLabel => 'Invalid range.';

  @override
  String get invalidTimeLabel => 'Enter a valid time';

  @override
  String get lastPageTooltip => 'Last page';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 license';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licenses';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'جوازونه';

  @override
  String get modalBarrierDismissLabel => 'رد کړه';

  @override
  String get moreButtonTooltip => 'More';

  @override
  String get nextMonthTooltip => 'بله میاشت';

  @override
  String get nextPageTooltip => 'بله پاڼه';

  @override
  String get okButtonLabel => 'سمه ده';

  @override
  String get openAppDrawerTooltip => 'د پرانیستی نیینګ مینو';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow د $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow څخه $rowCount د';

  @override
  String get pasteButtonLabel => 'پیټ کړئ';

  @override
  String get popupMenuLabel => 'د پاپ اپ مینو';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'تیره میاشت';

  @override
  String get previousPageTooltip => 'مخکینی مخ';

  @override
  String get refreshIndicatorSemanticLabel => 'Refresh';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 character remaining';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount characters remaining';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'No characters remaining';

  @override
  String get reorderItemDown => 'Move down';

  @override
  String get reorderItemLeft => 'Move left';

  @override
  String get reorderItemRight => 'Move right';

  @override
  String get reorderItemToEnd => 'Move to the end';

  @override
  String get reorderItemToStart => 'Move to the start';

  @override
  String get reorderItemUp => 'Move up';

  @override
  String get rowsPerPageTitle => 'د هرې پاڼې پاڼې:';

  @override
  String get saveButtonLabel => 'SAVE';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.tall;

  @override
  String get searchFieldLabel => 'لټون';

  @override
  String get selectAllButtonLabel => 'غوره کړئ';

  @override
  String get selectYearSemanticsLabel => 'Select year';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => null;

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount توکي غوره شوي';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'حسابونه ښکاره کړئ';

  @override
  String get showMenuTooltip => 'غورنۍ ښودل';

  @override
  String get signedInLabel => 'ننوتل';

  @override
  String get tabLabelRaw => r'$tabIndex د $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'SELECT TIME';

  @override
  String get timePickerHourLabel => 'Hour';

  @override
  String get timePickerHourModeAnnouncement => 'وختونه وټاکئ';

  @override
  String get timePickerInputHelpText => 'ENTER TIME';

  @override
  String get timePickerMinuteLabel => 'Minute';

  @override
  String get timePickerMinuteModeAnnouncement => 'منې غوره کړئ';

  @override
  String get unspecifiedDate => 'Date';

  @override
  String get unspecifiedDateRange => 'Date Range';

  @override
  String get viewLicensesButtonLabel => 'لیدلس وګورئ';
}

/// The translations for Portuguese (`pt`).
class MaterialLocalizationPt extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Portuguese.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationPt({
    String localeName = 'pt',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Sobre o app $applicationName';

  @override
  String get alertDialogLabel => 'Alerta';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'Voltar';

  @override
  String get calendarModeButtonLabel => 'Mudar para agenda';

  @override
  String get cancelButtonLabel => 'CANCELAR';

  @override
  String get closeButtonLabel => 'FECHAR';

  @override
  String get closeButtonTooltip => 'Fechar';

  @override
  String get collapsedIconTapHint => 'Expandir';

  @override
  String get continueButtonLabel => 'CONTINUAR';

  @override
  String get copyButtonLabel => 'Copiar';

  @override
  String get cutButtonLabel => 'Cortar';

  @override
  String get dateHelpText => 'dd/mm/aaaa';

  @override
  String get dateInputLabel => 'Inserir data';

  @override
  String get dateOutOfRangeLabel => 'Fora de alcance.';

  @override
  String get datePickerHelpText => 'SELECIONAR DATA';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Data de término $fullDate';

  @override
  String get dateRangeEndLabel => 'Data de término';

  @override
  String get dateRangePickerHelpText => 'SELECIONAR INTERVALO';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Data de início $fullDate';

  @override
  String get dateRangeStartLabel => 'Data de início';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'Excluir';

  @override
  String get dialModeButtonLabel => 'Alternar para o modo de seleção de discagem';

  @override
  String get dialogLabel => 'Caixa de diálogo';

  @override
  String get drawerLabel => 'Menu de navegação';

  @override
  String get expandedIconTapHint => 'Recolher';

  @override
  String get firstPageTooltip => 'Primeira página';

  @override
  String get hideAccountsLabel => 'Ocultar contas';

  @override
  String get inputDateModeButtonLabel => 'Mudar para modo de entrada';

  @override
  String get inputTimeModeButtonLabel => 'Alternar para o modo de entrada de texto';

  @override
  String get invalidDateFormatLabel => 'Formato inválido.';

  @override
  String get invalidDateRangeLabel => 'Intervalo inválido.';

  @override
  String get invalidTimeLabel => 'Insira um horário válido';

  @override
  String get lastPageTooltip => 'Última página';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 licença';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licenças';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Licenças';

  @override
  String get modalBarrierDismissLabel => 'Dispensar';

  @override
  String get moreButtonTooltip => 'Mais';

  @override
  String get nextMonthTooltip => 'Próximo mês';

  @override
  String get nextPageTooltip => 'Próxima página';

  @override
  String get okButtonLabel => 'Ok';

  @override
  String get openAppDrawerTooltip => 'Abrir menu de navegação';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow – $lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow – $lastRow de aproximadamente $rowCount';

  @override
  String get pasteButtonLabel => 'Colar';

  @override
  String get popupMenuLabel => 'Menu pop-up';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'Mês anterior';

  @override
  String get previousPageTooltip => 'Página anterior';

  @override
  String get refreshIndicatorSemanticLabel => 'Atualizar';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 caractere restante';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount caracteres restantes';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Mover para baixo';

  @override
  String get reorderItemLeft => 'Mover para a esquerda';

  @override
  String get reorderItemRight => 'Mover para a direita';

  @override
  String get reorderItemToEnd => 'Mover para o final';

  @override
  String get reorderItemToStart => 'Mover para o início';

  @override
  String get reorderItemUp => 'Mover para cima';

  @override
  String get rowsPerPageTitle => 'Linhas por página:';

  @override
  String get saveButtonLabel => 'SALVAR';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Pesquisa';

  @override
  String get selectAllButtonLabel => 'Selecionar tudo';

  @override
  String get selectYearSemanticsLabel => 'Selecione o ano';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 item selecionado';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount itens selecionados';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Mostrar contas';

  @override
  String get showMenuTooltip => 'Mostrar menu';

  @override
  String get signedInLabel => 'Conectado a';

  @override
  String get tabLabelRaw => r'Guia $tabIndex de $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'SELECIONAR HORÁRIO';

  @override
  String get timePickerHourLabel => 'Hora';

  @override
  String get timePickerHourModeAnnouncement => 'Selecione as horas';

  @override
  String get timePickerInputHelpText => 'INSERIR HORÁRIO';

  @override
  String get timePickerMinuteLabel => 'Minuto';

  @override
  String get timePickerMinuteModeAnnouncement => 'Selecione os minutos';

  @override
  String get unspecifiedDate => 'Data';

  @override
  String get unspecifiedDateRange => 'Período';

  @override
  String get viewLicensesButtonLabel => 'VER LICENÇAS';
}

/// The translations for Portuguese, as used in Portugal (`pt_PT`).
class MaterialLocalizationPtPt extends MaterialLocalizationPt {
  /// Create an instance of the translation bundle for Portuguese, as used in Portugal.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationPtPt({
    String localeName = 'pt_PT',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get dialModeButtonLabel => 'Mude para o modo de seletor de mostrador';

  @override
  String get timePickerDialHelpText => 'SELECIONAR HORA';

  @override
  String get timePickerInputHelpText => 'INTRODUZIR HORA';

  @override
  String get invalidTimeLabel => 'Introduza uma hora válida.';

  @override
  String get inputTimeModeButtonLabel => 'Mude para o método de introdução de texto';

  @override
  String get dateInputLabel => 'Introduzir data';

  @override
  String get calendarModeButtonLabel => 'Mude para o calendário';

  @override
  String get saveButtonLabel => 'GUARDAR';

  @override
  String get dateOutOfRangeLabel => 'Fora do intervalo.';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Data de conclusão: $fullDate';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Data de início: $fullDate';

  @override
  String get dateRangeEndLabel => 'Data de conclusão';

  @override
  String get inputDateModeButtonLabel => 'Mude para a introdução';

  @override
  String get unspecifiedDateRange => 'Intervalo de datas';

  @override
  String get selectYearSemanticsLabel => 'Selecionar ano';

  @override
  String get tabLabelRaw => r'Separador $tabIndex de $tabCount';

  @override
  String get signedInLabel => 'Com sessão iniciada';

  @override
  String get timePickerMinuteModeAnnouncement => 'Selecionar minutos';

  @override
  String get timePickerHourModeAnnouncement => 'Selecionar horas';

  @override
  String get deleteButtonTooltip => 'Eliminar';

  @override
  String get nextMonthTooltip => 'Mês seguinte';

  @override
  String get nextPageTooltip => 'Página seguinte';

  @override
  String get aboutListTileTitleRaw => r'Acerca de $applicationName';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow a $lastRow de $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow a $lastRow de cerca de $rowCount';

  @override
  String get okButtonLabel => 'OK';

  @override
  String get modalBarrierDismissLabel => 'Ignorar';

  @override
  String get searchFieldLabel => 'Pesquisar';

  @override
  String get reorderItemToEnd => 'Mover para o fim';

  @override
  String get expandedIconTapHint => 'Reduzir';

  @override
  String? get remainingTextFieldCharacterCountOne => 'Resta 1 caráter';

  @override
  String get remainingTextFieldCharacterCountOther => r'Restam $remainingCount carateres';
}

/// The translations for Romanian Moldavian Moldovan (`ro`).
class MaterialLocalizationRo extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Romanian Moldavian Moldovan.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationRo({
    String localeName = 'ro',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Despre $applicationName';

  @override
  String get alertDialogLabel => 'Alertă';

  @override
  String get anteMeridiemAbbreviation => 'a.m.';

  @override
  String get backButtonTooltip => 'Înapoi';

  @override
  String get calendarModeButtonLabel => 'Comutați la calendar';

  @override
  String get cancelButtonLabel => 'ANULAȚI';

  @override
  String get closeButtonLabel => 'ÎNCHIDEȚI';

  @override
  String get closeButtonTooltip => 'Închideți';

  @override
  String get collapsedIconTapHint => 'Extindeți';

  @override
  String get continueButtonLabel => 'CONTINUAȚI';

  @override
  String get copyButtonLabel => 'Copiați';

  @override
  String get cutButtonLabel => 'Decupați';

  @override
  String get dateHelpText => 'zz.ll.aaaa';

  @override
  String get dateInputLabel => 'Introduceți data';

  @override
  String get dateOutOfRangeLabel => 'Fără acoperire.';

  @override
  String get datePickerHelpText => 'SELECTAȚI DATA';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Data de încheiere: $fullDate';

  @override
  String get dateRangeEndLabel => 'Data de încheiere';

  @override
  String get dateRangePickerHelpText => 'SELECTAȚI UN INTERVAL';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Data de începere: $fullDate';

  @override
  String get dateRangeStartLabel => 'Data de începere';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'Ștergeți';

  @override
  String get dialModeButtonLabel => 'Comutați la modul selector cadran';

  @override
  String get dialogLabel => 'Casetă de dialog';

  @override
  String get drawerLabel => 'Meniu de navigare';

  @override
  String get expandedIconTapHint => 'Restrângeți';

  @override
  String get firstPageTooltip => 'Prima pagină';

  @override
  String get hideAccountsLabel => 'Ascundeți conturile';

  @override
  String get inputDateModeButtonLabel => 'Comutați la introducerea textului';

  @override
  String get inputTimeModeButtonLabel => 'Comutați la modul de introducere a textului';

  @override
  String get invalidDateFormatLabel => 'Format nevalid.';

  @override
  String get invalidDateRangeLabel => 'Interval nevalid.';

  @override
  String get invalidTimeLabel => 'Introduceți o oră validă';

  @override
  String get lastPageTooltip => 'Ultima pagină';

  @override
  String? get licensesPackageDetailTextFew => r'$licenseCount licențe';

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => 'O licență';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount de licențe';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Licențe';

  @override
  String get modalBarrierDismissLabel => 'Închideți';

  @override
  String get moreButtonTooltip => 'Mai multe';

  @override
  String get nextMonthTooltip => 'Luna viitoare';

  @override
  String get nextPageTooltip => 'Pagina următoare';

  @override
  String get okButtonLabel => 'OK';

  @override
  String get openAppDrawerTooltip => 'Deschideți meniul de navigare';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow din $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow din aproximativ $rowCount';

  @override
  String get pasteButtonLabel => 'Inserați';

  @override
  String get popupMenuLabel => 'Meniu pop-up';

  @override
  String get postMeridiemAbbreviation => 'p.m.';

  @override
  String get previousMonthTooltip => 'Luna trecută';

  @override
  String get previousPageTooltip => 'Pagina anterioară';

  @override
  String get refreshIndicatorSemanticLabel => 'Actualizați';

  @override
  String? get remainingTextFieldCharacterCountFew => r'$remainingCount caractere rămase';

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => 'un caracter rămas';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount de caractere rămase';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Mutați în jos';

  @override
  String get reorderItemLeft => 'Mutați la stânga';

  @override
  String get reorderItemRight => 'Mutați la dreapta';

  @override
  String get reorderItemToEnd => 'Mutați la sfârșit';

  @override
  String get reorderItemToStart => 'Mutați la început';

  @override
  String get reorderItemUp => 'Mutați în sus';

  @override
  String get rowsPerPageTitle => 'Rânduri pe pagină:';

  @override
  String get saveButtonLabel => 'SALVAȚI';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Căutați';

  @override
  String get selectAllButtonLabel => 'Selectați tot';

  @override
  String get selectYearSemanticsLabel => 'Selectați anul';

  @override
  String? get selectedRowCountTitleFew => r'$selectedRowCount articole selectate';

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => 'Un articol selectat';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount de articole selectate';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => 'Nu există elemente selectate';

  @override
  String get showAccountsLabel => 'Afișați conturile';

  @override
  String get showMenuTooltip => 'Afișați meniul';

  @override
  String get signedInLabel => 'V-ați conectat';

  @override
  String get tabLabelRaw => r'Fila $tabIndex din $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'SELECTAȚI ORA';

  @override
  String get timePickerHourLabel => 'Oră';

  @override
  String get timePickerHourModeAnnouncement => 'Selectați orele';

  @override
  String get timePickerInputHelpText => 'INTRODUCEȚI ORA';

  @override
  String get timePickerMinuteLabel => 'Minut';

  @override
  String get timePickerMinuteModeAnnouncement => 'Selectați minutele';

  @override
  String get unspecifiedDate => 'Data';

  @override
  String get unspecifiedDateRange => 'Interval de date';

  @override
  String get viewLicensesButtonLabel => 'VEDEȚI LICENȚELE';
}

/// The translations for Russian (`ru`).
class MaterialLocalizationRu extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Russian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationRu({
    String localeName = 'ru',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName: сведения';

  @override
  String get alertDialogLabel => 'Оповещение';

  @override
  String get anteMeridiemAbbreviation => 'АМ';

  @override
  String get backButtonTooltip => 'Назад';

  @override
  String get calendarModeButtonLabel => 'Переключиться на календарь';

  @override
  String get cancelButtonLabel => 'ОТМЕНА';

  @override
  String get closeButtonLabel => 'ЗАКРЫТЬ';

  @override
  String get closeButtonTooltip => 'Закрыть';

  @override
  String get collapsedIconTapHint => 'Развернуть';

  @override
  String get continueButtonLabel => 'ПРОДОЛЖИТЬ';

  @override
  String get copyButtonLabel => 'Копировать';

  @override
  String get cutButtonLabel => 'Вырезать';

  @override
  String get dateHelpText => 'дд.мм.гггг';

  @override
  String get dateInputLabel => 'Введите дату';

  @override
  String get dateOutOfRangeLabel => 'Дата находится вне допустимого диапазона.';

  @override
  String get datePickerHelpText => 'ВЫБЕРИТЕ ДАТУ';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Дата окончания: $fullDate';

  @override
  String get dateRangeEndLabel => 'Дата окончания';

  @override
  String get dateRangePickerHelpText => 'ВЫБЕРИТЕ ДИАПАЗОН ДАТ';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Дата начала: $fullDate';

  @override
  String get dateRangeStartLabel => 'Дата начала';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'Удалить';

  @override
  String get dialModeButtonLabel => 'Перейти в режим выбора времени';

  @override
  String get dialogLabel => 'Диалоговое окно';

  @override
  String get drawerLabel => 'Меню навигации';

  @override
  String get expandedIconTapHint => 'Свернуть';

  @override
  String get firstPageTooltip => 'Первая страница';

  @override
  String get hideAccountsLabel => 'Скрыть аккаунты';

  @override
  String get inputDateModeButtonLabel => 'Переключиться на ручной ввод';

  @override
  String get inputTimeModeButtonLabel => 'Перейти в режим ввода текста';

  @override
  String get invalidDateFormatLabel => 'Недопустимый формат даты.';

  @override
  String get invalidDateRangeLabel => 'Недопустимый диапазон.';

  @override
  String get invalidTimeLabel => 'Указано недопустимое время.';

  @override
  String get lastPageTooltip => 'Последняя страница';

  @override
  String? get licensesPackageDetailTextFew => r'$licenseCount лицензии';

  @override
  String? get licensesPackageDetailTextMany => r'$licenseCount лицензий';

  @override
  String? get licensesPackageDetailTextOne => '1 лицензия';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount лицензии';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Лицензии';

  @override
  String get modalBarrierDismissLabel => 'Закрыть';

  @override
  String get moreButtonTooltip => 'Ещё';

  @override
  String get nextMonthTooltip => 'Следующий месяц';

  @override
  String get nextPageTooltip => 'Следующая страница';

  @override
  String get okButtonLabel => 'ОК';

  @override
  String get openAppDrawerTooltip => 'Открыть меню навигации';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow из $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow из примерно $rowCount';

  @override
  String get pasteButtonLabel => 'Вставить';

  @override
  String get popupMenuLabel => 'Всплывающее меню';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'Предыдущий месяц';

  @override
  String get previousPageTooltip => 'Предыдущая страница';

  @override
  String get refreshIndicatorSemanticLabel => 'Обновление';

  @override
  String? get remainingTextFieldCharacterCountFew => r'Осталось $remainingCount символа';

  @override
  String? get remainingTextFieldCharacterCountMany => r'Осталось $remainingCount символов';

  @override
  String? get remainingTextFieldCharacterCountOne => 'Остался 1 символ';

  @override
  String get remainingTextFieldCharacterCountOther => r'Осталось $remainingCount символа';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Переместить вниз';

  @override
  String get reorderItemLeft => 'Переместить влево';

  @override
  String get reorderItemRight => 'Переместить вправо';

  @override
  String get reorderItemToEnd => 'Переместить в конец';

  @override
  String get reorderItemToStart => 'Переместить в начало';

  @override
  String get reorderItemUp => 'Переместить вверх';

  @override
  String get rowsPerPageTitle => 'Строк на странице:';

  @override
  String get saveButtonLabel => 'СОХРАНИТЬ';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Поиск';

  @override
  String get selectAllButtonLabel => 'Выбрать все';

  @override
  String get selectYearSemanticsLabel => 'Выберите год';

  @override
  String? get selectedRowCountTitleFew => r'Выбрано $selectedRowCount объекта';

  @override
  String? get selectedRowCountTitleMany => r'Выбрано $selectedRowCount объектов';

  @override
  String? get selectedRowCountTitleOne => 'Выбран 1 объект';

  @override
  String get selectedRowCountTitleOther => r'Выбрано $selectedRowCount объекта';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => 'Строки не выбраны';

  @override
  String get showAccountsLabel => 'Показать аккаунты';

  @override
  String get showMenuTooltip => 'Показать меню';

  @override
  String get signedInLabel => 'Вход выполнен';

  @override
  String get tabLabelRaw => r'Вкладка $tabIndex из $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => 'ВЫБЕРИТЕ ВРЕМЯ';

  @override
  String get timePickerHourLabel => 'Часы';

  @override
  String get timePickerHourModeAnnouncement => 'Выберите часы';

  @override
  String get timePickerInputHelpText => 'ВВЕДИТЕ ВРЕМЯ';

  @override
  String get timePickerMinuteLabel => 'Минуты';

  @override
  String get timePickerMinuteModeAnnouncement => 'Выберите минуты';

  @override
  String get unspecifiedDate => 'Дата';

  @override
  String get unspecifiedDateRange => 'Диапазон дат';

  @override
  String get viewLicensesButtonLabel => 'ЛИЦЕНЗИИ';
}

/// The translations for Sinhala Sinhalese (`si`).
class MaterialLocalizationSi extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Sinhala Sinhalese.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationSi({
    String localeName = 'si',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName ගැන';

  @override
  String get alertDialogLabel => 'ඇඟවීම';

  @override
  String get anteMeridiemAbbreviation => 'පෙ.ව.';

  @override
  String get backButtonTooltip => 'ආපසු';

  @override
  String get calendarModeButtonLabel => 'දින දර්ශනය වෙත මාරු වන්න';

  @override
  String get cancelButtonLabel => 'අවලංගු කරන්න';

  @override
  String get closeButtonLabel => 'වසන්න';

  @override
  String get closeButtonTooltip => 'වසන්න';

  @override
  String get collapsedIconTapHint => 'දිග හරින්න';

  @override
  String get continueButtonLabel => 'ඉදිරියට';

  @override
  String get copyButtonLabel => 'පිටපත් කරන්න';

  @override
  String get cutButtonLabel => 'කපන්න';

  @override
  String get dateHelpText => 'mm.dd.yyyy';

  @override
  String get dateInputLabel => 'දිනය ඇතුළු කරන්න';

  @override
  String get dateOutOfRangeLabel => 'පරාසයෙන් පිටත.';

  @override
  String get datePickerHelpText => 'දිනය තෝරන්න';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'අවසන් වන දිනය $fullDate';

  @override
  String get dateRangeEndLabel => 'අවසන් වන දිනය';

  @override
  String get dateRangePickerHelpText => 'පරාසය තෝරන්න';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'ආරම්භක දිනය $fullDate';

  @override
  String get dateRangeStartLabel => 'ආරම්භක දිනය';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'මකන්න';

  @override
  String get dialModeButtonLabel => 'ඩයලන තෝරක ප්‍රකාරයට මාරු කරන්න';

  @override
  String get dialogLabel => 'සංවාදය';

  @override
  String get drawerLabel => 'සංචාලන මෙනුව';

  @override
  String get expandedIconTapHint => 'හකුළන්න';

  @override
  String get firstPageTooltip => 'පළමු පිටුව';

  @override
  String get hideAccountsLabel => 'ගිණුම් සඟවන්න';

  @override
  String get inputDateModeButtonLabel => 'ආදානය වෙත මාරු වන්න';

  @override
  String get inputTimeModeButtonLabel => 'පෙළ ආදාන ප්‍රකාරයට මාරු කරන්න';

  @override
  String get invalidDateFormatLabel => 'අවලංගු ආකෘතියකි.';

  @override
  String get invalidDateRangeLabel => 'අවලංගු පරාසයකි.';

  @override
  String get invalidTimeLabel => 'වලංගු වේලාවක් ඇතුළු කරන්න';

  @override
  String get lastPageTooltip => 'අවසන් පිටුව';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => 'බලපත්‍ර 1';

  @override
  String get licensesPackageDetailTextOther => r'බලපත්‍ර $licenseCount';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'බලපත්‍ර';

  @override
  String get modalBarrierDismissLabel => 'ඉවත ලන්න';

  @override
  String get moreButtonTooltip => 'තව';

  @override
  String get nextMonthTooltip => 'ඊළඟ මාසය';

  @override
  String get nextPageTooltip => 'ඊළඟ පිටුව';

  @override
  String get okButtonLabel => 'හරි';

  @override
  String get openAppDrawerTooltip => 'සංචාලන මෙනුව විවෘත කරන්න';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCountන් $firstRow–$lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$rowCountකින් පමණ $firstRow–$lastRow';

  @override
  String get pasteButtonLabel => 'අලවන්න';

  @override
  String get popupMenuLabel => 'උත්පතන මෙනුව';

  @override
  String get postMeridiemAbbreviation => 'ප.ව.';

  @override
  String get previousMonthTooltip => 'පෙර මාසය';

  @override
  String get previousPageTooltip => 'පෙර පිටුව';

  @override
  String get refreshIndicatorSemanticLabel => 'නැවුම් කරන්න';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => 'අනුලකුණු 1ක් ඉතිරිය';

  @override
  String get remainingTextFieldCharacterCountOther => r'අනුලකුණු $remainingCountක් ඉතිරිය';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => 'පහළට ගෙන යන්න';

  @override
  String get reorderItemLeft => 'වමට ගෙන යන්න';

  @override
  String get reorderItemRight => 'දකුණට ගෙන යන්න';

  @override
  String get reorderItemToEnd => 'අවසානයට යන්න';

  @override
  String get reorderItemToStart => 'ආරම්භය වෙත යන්න';

  @override
  String get reorderItemUp => 'ඉහළට ගෙන යන්න';

  @override
  String get rowsPerPageTitle => 'පිටුවකට පේළි:';

  @override
  String get saveButtonLabel => 'සුරකින්න';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'සෙවීම';

  @override
  String get selectAllButtonLabel => 'සියල්ල තෝරන්න';

  @override
  String get selectYearSemanticsLabel => 'වර්ෂය තෝරන්න';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => 'අයිතම 1ක් තෝරන ලදී';

  @override
  String get selectedRowCountTitleOther => r'අයිතම $selectedRowCountක් තෝරන ලදී';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'ගිණුම් පෙන්වන්න';

  @override
  String get showMenuTooltip => 'මෙනුව පෙන්වන්න';

  @override
  String get signedInLabel => 'පුරන ලදී';

  @override
  String get tabLabelRaw => r'ටැබ $tabIndexකින් $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => 'වේලාව තෝරන්න';

  @override
  String get timePickerHourLabel => 'පැය';

  @override
  String get timePickerHourModeAnnouncement => 'පැය ගණන තෝරන්න';

  @override
  String get timePickerInputHelpText => 'දිනය ඇතුළු කරන්න';

  @override
  String get timePickerMinuteLabel => 'මිනිත්තු';

  @override
  String get timePickerMinuteModeAnnouncement => 'මිනිත්තු ගණන තෝරන්න';

  @override
  String get unspecifiedDate => 'දිනය';

  @override
  String get unspecifiedDateRange => 'දින පරාසය';

  @override
  String get viewLicensesButtonLabel => 'බලපත්‍ර බලන්න';
}

/// The translations for Slovak (`sk`).
class MaterialLocalizationSk extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Slovak.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationSk({
    String localeName = 'sk',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName – informácie';

  @override
  String get alertDialogLabel => 'Upozornenie';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'Späť';

  @override
  String get calendarModeButtonLabel => 'Prepnúť na kalendár';

  @override
  String get cancelButtonLabel => 'ZRUŠIŤ';

  @override
  String get closeButtonLabel => 'ZAVRIEŤ';

  @override
  String get closeButtonTooltip => 'Zavrieť';

  @override
  String get collapsedIconTapHint => 'Rozbaliť';

  @override
  String get continueButtonLabel => 'POKRAČOVAŤ';

  @override
  String get copyButtonLabel => 'Kopírovať';

  @override
  String get cutButtonLabel => 'Vystrihnúť';

  @override
  String get dateHelpText => 'mm.dd.yyyy';

  @override
  String get dateInputLabel => 'Zadajte dátum';

  @override
  String get dateOutOfRangeLabel => 'Mimo rozsahu.';

  @override
  String get datePickerHelpText => 'VYBERTE DÁTUM';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Dátum ukončenia $fullDate';

  @override
  String get dateRangeEndLabel => 'Dátum ukončenia';

  @override
  String get dateRangePickerHelpText => 'VYBERTE ROZSAH';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Dátum začatia $fullDate';

  @override
  String get dateRangeStartLabel => 'Dátum začatia';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'Odstrániť';

  @override
  String get dialModeButtonLabel => 'Prepnúť na režim výberu času';

  @override
  String get dialogLabel => 'Dialógové okno';

  @override
  String get drawerLabel => 'Navigačná ponuka';

  @override
  String get expandedIconTapHint => 'Zbaliť';

  @override
  String get firstPageTooltip => 'Prvá strana';

  @override
  String get hideAccountsLabel => 'Skryť účty';

  @override
  String get inputDateModeButtonLabel => 'Prepnúť na zadávanie';

  @override
  String get inputTimeModeButtonLabel => 'Prepnúť na textový režim vstupu';

  @override
  String get invalidDateFormatLabel => 'Neplatný formát.';

  @override
  String get invalidDateRangeLabel => 'Neplatný rozsah.';

  @override
  String get invalidTimeLabel => 'Zadajte platný čas';

  @override
  String get lastPageTooltip => 'Posledná strana';

  @override
  String? get licensesPackageDetailTextFew => r'$licenseCount licencie';

  @override
  String? get licensesPackageDetailTextMany => r'$licenseCount licenses';

  @override
  String? get licensesPackageDetailTextOne => '1 licencia';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licencií';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Licencie';

  @override
  String get modalBarrierDismissLabel => 'Odmietnuť';

  @override
  String get moreButtonTooltip => 'Viac';

  @override
  String get nextMonthTooltip => 'Budúci mesiac';

  @override
  String get nextPageTooltip => 'Ďalšia strana';

  @override
  String get okButtonLabel => 'OK';

  @override
  String get openAppDrawerTooltip => 'Otvoriť navigačnú ponuku';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow – $lastRow z $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow – $lastRow z približne $rowCount';

  @override
  String get pasteButtonLabel => 'Prilepiť';

  @override
  String get popupMenuLabel => 'Kontextová ponuka';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'Predošlý mesiac';

  @override
  String get previousPageTooltip => 'Predchádzajúca stránka';

  @override
  String get refreshIndicatorSemanticLabel => 'Obnoviť';

  @override
  String? get remainingTextFieldCharacterCountFew => r'Zostávajú $remainingCount znaky';

  @override
  String? get remainingTextFieldCharacterCountMany => r'$remainingCount characters remaining';

  @override
  String? get remainingTextFieldCharacterCountOne => 'Zostáva 1 znak';

  @override
  String get remainingTextFieldCharacterCountOther => r'Zostáva $remainingCount znakov';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Presunúť nadol';

  @override
  String get reorderItemLeft => 'Presunúť doľava';

  @override
  String get reorderItemRight => 'Presunúť doprava';

  @override
  String get reorderItemToEnd => 'Presunúť na koniec';

  @override
  String get reorderItemToStart => 'Presunúť na začiatok';

  @override
  String get reorderItemUp => 'Presunúť nahor';

  @override
  String get rowsPerPageTitle => 'Počet riadkov na stránku:';

  @override
  String get saveButtonLabel => 'ULOŽIŤ';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Hľadať';

  @override
  String get selectAllButtonLabel => 'Vybrať všetko';

  @override
  String get selectYearSemanticsLabel => 'Vyberte rok';

  @override
  String? get selectedRowCountTitleFew => r'$selectedRowCount vybraté položky';

  @override
  String? get selectedRowCountTitleMany => r'$selectedRowCount items selected';

  @override
  String? get selectedRowCountTitleOne => '1 vybratá položka';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount vybratých položiek';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Zobraziť účty';

  @override
  String get showMenuTooltip => 'Zobraziť ponuku';

  @override
  String get signedInLabel => 'Prihlásili ste sa';

  @override
  String get tabLabelRaw => r'Karta $tabIndex z $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'VYBERTE ČAS';

  @override
  String get timePickerHourLabel => 'Hodina';

  @override
  String get timePickerHourModeAnnouncement => 'Vybrať hodiny';

  @override
  String get timePickerInputHelpText => 'ZADAJTE ČAS';

  @override
  String get timePickerMinuteLabel => 'Minúta';

  @override
  String get timePickerMinuteModeAnnouncement => 'Vybrať minúty';

  @override
  String get unspecifiedDate => 'Dátum';

  @override
  String get unspecifiedDateRange => 'Obdobie';

  @override
  String get viewLicensesButtonLabel => 'ZOBRAZIŤ LICENCIE';
}

/// The translations for Slovenian (`sl`).
class MaterialLocalizationSl extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Slovenian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationSl({
    String localeName = 'sl',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'O aplikaciji $applicationName';

  @override
  String get alertDialogLabel => 'Opozorilo';

  @override
  String get anteMeridiemAbbreviation => 'DOP.';

  @override
  String get backButtonTooltip => 'Nazaj';

  @override
  String get calendarModeButtonLabel => 'Preklop na koledar';

  @override
  String get cancelButtonLabel => 'PREKLIČI';

  @override
  String get closeButtonLabel => 'ZAPRI';

  @override
  String get closeButtonTooltip => 'Zapiranje';

  @override
  String get collapsedIconTapHint => 'Razširiti';

  @override
  String get continueButtonLabel => 'NAPREJ';

  @override
  String get copyButtonLabel => 'Kopiraj';

  @override
  String get cutButtonLabel => 'Izreži';

  @override
  String get dateHelpText => 'dd. mm. llll';

  @override
  String get dateInputLabel => 'Vnesite datum';

  @override
  String get dateOutOfRangeLabel => 'Zunaj dovoljenega obdobja';

  @override
  String get datePickerHelpText => 'IZBIRA DATUMA';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Končni datum $fullDate';

  @override
  String get dateRangeEndLabel => 'Končni datum';

  @override
  String get dateRangePickerHelpText => 'IZBIRA OBDOBJA';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Začetni datum $fullDate';

  @override
  String get dateRangeStartLabel => 'Začetni datum';

  @override
  String get dateSeparator => '. ';

  @override
  String get deleteButtonTooltip => 'Brisanje';

  @override
  String get dialModeButtonLabel => 'Preklop na način izbirnika s številčnico';

  @override
  String get dialogLabel => 'Pogovorno okno';

  @override
  String get drawerLabel => 'Meni za krmarjenje';

  @override
  String get expandedIconTapHint => 'Strniti';

  @override
  String get firstPageTooltip => 'Prva stran';

  @override
  String get hideAccountsLabel => 'Skrivanje računov';

  @override
  String get inputDateModeButtonLabel => 'Preklop na vnos';

  @override
  String get inputTimeModeButtonLabel => 'Preklop na način vnosa besedila';

  @override
  String get invalidDateFormatLabel => 'Neveljavna oblika';

  @override
  String get invalidDateRangeLabel => 'Neveljavno obdobje';

  @override
  String get invalidTimeLabel => 'Vnesite veljaven čas';

  @override
  String get lastPageTooltip => 'Zadnja stran';

  @override
  String? get licensesPackageDetailTextFew => r'$licenseCount licence';

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 licenca';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licenc';

  @override
  String? get licensesPackageDetailTextTwo => r'$licenseCount licenci';

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Licence';

  @override
  String get modalBarrierDismissLabel => 'Opusti';

  @override
  String get moreButtonTooltip => 'Več';

  @override
  String get nextMonthTooltip => 'Naslednji mesec';

  @override
  String get nextPageTooltip => 'Naslednja stran';

  @override
  String get okButtonLabel => 'V REDU';

  @override
  String get openAppDrawerTooltip => 'Odpiranje menija za krmarjenje';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow od $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow od približno $rowCount';

  @override
  String get pasteButtonLabel => 'Prilepi';

  @override
  String get popupMenuLabel => 'Pojavni meni';

  @override
  String get postMeridiemAbbreviation => 'POP.';

  @override
  String get previousMonthTooltip => 'Prejšnji mesec';

  @override
  String get previousPageTooltip => 'Prejšnja stran';

  @override
  String get refreshIndicatorSemanticLabel => 'Osveži';

  @override
  String? get remainingTextFieldCharacterCountFew => r'Še $remainingCount znaki';

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => 'Še 1 znak';

  @override
  String get remainingTextFieldCharacterCountOther => r'Še $remainingCount znakov';

  @override
  String? get remainingTextFieldCharacterCountTwo => r'Še $remainingCount znaka';

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Premakni navzdol';

  @override
  String get reorderItemLeft => 'Premakni levo';

  @override
  String get reorderItemRight => 'Premakni desno';

  @override
  String get reorderItemToEnd => 'Premakni na konec';

  @override
  String get reorderItemToStart => 'Premakni na začetek';

  @override
  String get reorderItemUp => 'Premakni navzgor';

  @override
  String get rowsPerPageTitle => 'Vrstice na stran:';

  @override
  String get saveButtonLabel => 'SHRANI';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Iskanje';

  @override
  String get selectAllButtonLabel => 'Izberi vse';

  @override
  String get selectYearSemanticsLabel => 'Izberite leto';

  @override
  String? get selectedRowCountTitleFew => r'Izbrani so $selectedRowCount elementi';

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => 'Izbran je 1 element';

  @override
  String get selectedRowCountTitleOther => r'Izbranih je $selectedRowCount elementov';

  @override
  String? get selectedRowCountTitleTwo => r'Izbrana sta $selectedRowCount elementa';

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Prikaz računov';

  @override
  String get showMenuTooltip => 'Prikaz menija';

  @override
  String get signedInLabel => 'Prijavljen';

  @override
  String get tabLabelRaw => r'Zavihek $tabIndex od $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'IZBERITE ČAS';

  @override
  String get timePickerHourLabel => 'Ura';

  @override
  String get timePickerHourModeAnnouncement => 'Izberite ure';

  @override
  String get timePickerInputHelpText => 'VNESITE ČAS';

  @override
  String get timePickerMinuteLabel => 'Minuta';

  @override
  String get timePickerMinuteModeAnnouncement => 'Izberite minute';

  @override
  String get unspecifiedDate => 'Datum';

  @override
  String get unspecifiedDateRange => 'Časovno obdobje';

  @override
  String get viewLicensesButtonLabel => 'PRIKAŽI LICENCE';
}

/// The translations for Albanian (`sq`).
class MaterialLocalizationSq extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Albanian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationSq({
    String localeName = 'sq',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Rreth $applicationName';

  @override
  String get alertDialogLabel => 'Sinjalizim';

  @override
  String get anteMeridiemAbbreviation => 'paradite';

  @override
  String get backButtonTooltip => 'Prapa';

  @override
  String get calendarModeButtonLabel => 'Kalo te kalendari';

  @override
  String get cancelButtonLabel => 'ANULO';

  @override
  String get closeButtonLabel => 'MBYLL';

  @override
  String get closeButtonTooltip => 'Mbyll';

  @override
  String get collapsedIconTapHint => 'Zgjero';

  @override
  String get continueButtonLabel => 'VAZHDO';

  @override
  String get copyButtonLabel => 'Kopjo';

  @override
  String get cutButtonLabel => 'Prit';

  @override
  String get dateHelpText => 'dd.mm.yyyy';

  @override
  String get dateInputLabel => 'Vendos datën';

  @override
  String get dateOutOfRangeLabel => 'Jashtë rrezes.';

  @override
  String get datePickerHelpText => 'ZGJIDH DATËN';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Data e mbarimit: $fullDate';

  @override
  String get dateRangeEndLabel => 'Data e mbarimit';

  @override
  String get dateRangePickerHelpText => 'ZGJIDH GAMËN';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Data e fillimit: $fullDate';

  @override
  String get dateRangeStartLabel => 'Data e fillimit';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'Fshi';

  @override
  String get dialModeButtonLabel => 'Kalo te modaliteti i zgjedhësit të orës';

  @override
  String get dialogLabel => 'Dialogu';

  @override
  String get drawerLabel => 'Menyja e navigimit';

  @override
  String get expandedIconTapHint => 'Palos';

  @override
  String get firstPageTooltip => 'Faqja e parë';

  @override
  String get hideAccountsLabel => 'Fshih llogaritë';

  @override
  String get inputDateModeButtonLabel => 'Kalo te hyrja';

  @override
  String get inputTimeModeButtonLabel => 'Kalo te modaliteti i hyrjes së tekstit';

  @override
  String get invalidDateFormatLabel => 'Format i pavlefshëm.';

  @override
  String get invalidDateRangeLabel => 'Gamë e pavlefshme.';

  @override
  String get invalidTimeLabel => 'Fut një kohë të vlefshme';

  @override
  String get lastPageTooltip => 'Faqja e fundit';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 licencë';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licenca';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Licencat';

  @override
  String get modalBarrierDismissLabel => 'Hiq';

  @override
  String get moreButtonTooltip => 'Më shumë';

  @override
  String get nextMonthTooltip => 'Muaji i ardhshëm';

  @override
  String get nextPageTooltip => 'Faqja tjetër';

  @override
  String get okButtonLabel => 'Në rregull';

  @override
  String get openAppDrawerTooltip => 'Hap menynë e navigimit';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow nga $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow nga rreth $rowCount';

  @override
  String get pasteButtonLabel => 'Ngjit';

  @override
  String get popupMenuLabel => 'Menyja kërcyese';

  @override
  String get postMeridiemAbbreviation => 'pasdite';

  @override
  String get previousMonthTooltip => 'Muaji i mëparshëm';

  @override
  String get previousPageTooltip => 'Faqja e mëparshme';

  @override
  String get refreshIndicatorSemanticLabel => 'Rifresko';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 karakter i mbetur';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount karaktere të mbetura';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => 'Lëvize poshtë';

  @override
  String get reorderItemLeft => 'Lëvize majtas';

  @override
  String get reorderItemRight => 'Lëvize djathtas';

  @override
  String get reorderItemToEnd => 'Lëvize në fund';

  @override
  String get reorderItemToStart => 'Lëvize në fillim';

  @override
  String get reorderItemUp => 'Lëvize lart';

  @override
  String get rowsPerPageTitle => 'Rreshtat për faqe:';

  @override
  String get saveButtonLabel => 'RUAJ';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Kërko';

  @override
  String get selectAllButtonLabel => 'Zgjidh të gjitha';

  @override
  String get selectYearSemanticsLabel => 'Zgjidh vitin';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => 'U zgjodh 1 artikull';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount artikuj u zgjodhën';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Shfaq llogaritë';

  @override
  String get showMenuTooltip => 'Shfaq menynë';

  @override
  String get signedInLabel => 'Je identifikuar';

  @override
  String get tabLabelRaw => r'Skeda $tabIndex nga $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => 'ZGJIDH ORËN';

  @override
  String get timePickerHourLabel => 'Ora';

  @override
  String get timePickerHourModeAnnouncement => 'Zgjidh orët';

  @override
  String get timePickerInputHelpText => 'VENDOS ORËN';

  @override
  String get timePickerMinuteLabel => 'Minuta';

  @override
  String get timePickerMinuteModeAnnouncement => 'Zgjidh minutat';

  @override
  String get unspecifiedDate => 'Data';

  @override
  String get unspecifiedDateRange => 'Gama e datave';

  @override
  String get viewLicensesButtonLabel => 'SHIKO LICENCAT';
}

/// The translations for Serbian (`sr`).
class MaterialLocalizationSr extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Serbian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationSr({
    String localeName = 'sr',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'О апликацији $applicationName';

  @override
  String get alertDialogLabel => 'Обавештење';

  @override
  String get anteMeridiemAbbreviation => 'пре подне';

  @override
  String get backButtonTooltip => 'Назад';

  @override
  String get calendarModeButtonLabel => 'Пређите на календар';

  @override
  String get cancelButtonLabel => 'ОТКАЖИ';

  @override
  String get closeButtonLabel => 'ЗАТВОРИ';

  @override
  String get closeButtonTooltip => 'Затворите';

  @override
  String get collapsedIconTapHint => 'Прошири';

  @override
  String get continueButtonLabel => 'НАСТАВИ';

  @override
  String get copyButtonLabel => 'Копирај';

  @override
  String get cutButtonLabel => 'Исеци';

  @override
  String get dateHelpText => 'дд.мм.гггг.';

  @override
  String get dateInputLabel => 'Унесите датум';

  @override
  String get dateOutOfRangeLabel => 'Изван периода.';

  @override
  String get datePickerHelpText => 'ИЗАБЕРИТЕ ДАТУМ';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Датум завршетка: $fullDate';

  @override
  String get dateRangeEndLabel => 'Датум завршетка';

  @override
  String get dateRangePickerHelpText => 'ИЗАБЕРИТЕ ПЕРИОД';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Датум почетка: $fullDate';

  @override
  String get dateRangeStartLabel => 'Датум почетка';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'Избришите';

  @override
  String get dialModeButtonLabel => 'Пређите на режим бирача бројчаника';

  @override
  String get dialogLabel => 'Дијалог';

  @override
  String get drawerLabel => 'Мени за навигацију';

  @override
  String get expandedIconTapHint => 'Скупи';

  @override
  String get firstPageTooltip => 'Прва страница';

  @override
  String get hideAccountsLabel => 'Сакриј налоге';

  @override
  String get inputDateModeButtonLabel => 'Пређите на унос';

  @override
  String get inputTimeModeButtonLabel => 'Пређите на режим уноса текста';

  @override
  String get invalidDateFormatLabel => 'Формат је неважећи.';

  @override
  String get invalidDateRangeLabel => 'Период је неважећи.';

  @override
  String get invalidTimeLabel => 'Унесите важеће време';

  @override
  String get lastPageTooltip => 'Последња страница';

  @override
  String? get licensesPackageDetailTextFew => r'$licenseCount лиценце';

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 лиценца';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount лиценци';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Лиценце';

  @override
  String get modalBarrierDismissLabel => 'Одбаци';

  @override
  String get moreButtonTooltip => 'Још';

  @override
  String get nextMonthTooltip => 'Следећи месец';

  @override
  String get nextPageTooltip => 'Следећа страница';

  @override
  String get okButtonLabel => 'Потврди';

  @override
  String get openAppDrawerTooltip => 'Отворите мени за навигацију';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow – $lastRow oд $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow – $lastRow oд приближно $rowCount';

  @override
  String get pasteButtonLabel => 'Налепи';

  @override
  String get popupMenuLabel => 'Искачући мени';

  @override
  String get postMeridiemAbbreviation => 'по подне';

  @override
  String get previousMonthTooltip => 'Претходни месец';

  @override
  String get previousPageTooltip => 'Претходна страница';

  @override
  String get refreshIndicatorSemanticLabel => 'Освежи';

  @override
  String? get remainingTextFieldCharacterCountFew => r'Преостала су $remainingCount знака';

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => 'Преостао је 1 знак';

  @override
  String get remainingTextFieldCharacterCountOther => r'Преостало је $remainingCount знакова';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Померите надоле';

  @override
  String get reorderItemLeft => 'Померите улево';

  @override
  String get reorderItemRight => 'Померите удесно';

  @override
  String get reorderItemToEnd => 'Померите на крај';

  @override
  String get reorderItemToStart => 'Померите на почетак';

  @override
  String get reorderItemUp => 'Померите нагоре';

  @override
  String get rowsPerPageTitle => 'Редова по страници:';

  @override
  String get saveButtonLabel => 'САЧУВАЈ';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Претражите';

  @override
  String get selectAllButtonLabel => 'Изабери све';

  @override
  String get selectYearSemanticsLabel => 'Изаберите годину';

  @override
  String? get selectedRowCountTitleFew => r'Изабране су $selectedRowCount ставке';

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => 'Изабрана је 1 ставка';

  @override
  String get selectedRowCountTitleOther => r'Изабрано је $selectedRowCount ставки';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Прикажи налоге';

  @override
  String get showMenuTooltip => 'Прикажи мени';

  @override
  String get signedInLabel => 'Пријављени сте';

  @override
  String get tabLabelRaw => r'$tabIndex. картица од $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'ИЗАБЕРИТЕ ВРЕМЕ';

  @override
  String get timePickerHourLabel => 'Сат';

  @override
  String get timePickerHourModeAnnouncement => 'Изаберите сате';

  @override
  String get timePickerInputHelpText => 'УНЕСИТЕ ВРЕМЕ';

  @override
  String get timePickerMinuteLabel => 'Минут';

  @override
  String get timePickerMinuteModeAnnouncement => 'Изаберите минуте';

  @override
  String get unspecifiedDate => 'Датум';

  @override
  String get unspecifiedDateRange => 'Период';

  @override
  String get viewLicensesButtonLabel => 'ПРИКАЖИ ЛИЦЕНЦЕ';
}

/// The translations for Serbian, using the Cyrillic script (`sr_Cyrl`).
class MaterialLocalizationSrCyrl extends MaterialLocalizationSr {
  /// Create an instance of the translation bundle for Serbian, using the Cyrillic script.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationSrCyrl({
    String localeName = 'sr_Cyrl',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );
}

/// The translations for Serbian, using the Latin script (`sr_Latn`).
class MaterialLocalizationSrLatn extends MaterialLocalizationSr {
  /// Create an instance of the translation bundle for Serbian, using the Latin script.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationSrLatn({
    String localeName = 'sr_Latn',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'O aplikaciji $applicationName';

  @override
  String get alertDialogLabel => 'Obaveštenje';

  @override
  String get anteMeridiemAbbreviation => 'pre podne';

  @override
  String get backButtonTooltip => 'Nazad';

  @override
  String get calendarModeButtonLabel => 'Pređite na kalendar';

  @override
  String get cancelButtonLabel => 'OTKAŽI';

  @override
  String get closeButtonLabel => 'ZATVORI';

  @override
  String get closeButtonTooltip => 'Zatvorite';

  @override
  String get collapsedIconTapHint => 'Proširi';

  @override
  String get continueButtonLabel => 'NASTAVI';

  @override
  String get copyButtonLabel => 'Kopiraj';

  @override
  String get cutButtonLabel => 'Iseci';

  @override
  String get dateHelpText => 'dd.mm.gggg.';

  @override
  String get dateInputLabel => 'Unesite datum';

  @override
  String get dateOutOfRangeLabel => 'Izvan perioda.';

  @override
  String get datePickerHelpText => 'IZABERITE DATUM';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Datum završetka: $fullDate';

  @override
  String get dateRangeEndLabel => 'Datum završetka';

  @override
  String get dateRangePickerHelpText => 'IZABERITE PERIOD';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Datum početka: $fullDate';

  @override
  String get dateRangeStartLabel => 'Datum početka';

  @override
  String get deleteButtonTooltip => 'Izbrišite';

  @override
  String get dialModeButtonLabel => 'Pređite na režim birača brojčanika';

  @override
  String get dialogLabel => 'Dijalog';

  @override
  String get drawerLabel => 'Meni za navigaciju';

  @override
  String get expandedIconTapHint => 'Skupi';

  @override
  String get firstPageTooltip => 'Prva stranica';

  @override
  String get hideAccountsLabel => 'Sakrij naloge';

  @override
  String get inputDateModeButtonLabel => 'Pređite na unos';

  @override
  String get inputTimeModeButtonLabel => 'Pređite na režim unosa teksta';

  @override
  String get invalidDateFormatLabel => 'Format je nevažeći.';

  @override
  String get invalidDateRangeLabel => 'Period je nevažeći.';

  @override
  String get invalidTimeLabel => 'Unesite važeće vreme';

  @override
  String get lastPageTooltip => 'Poslednja stranica';

  @override
  String? get licensesPackageDetailTextFew => r'$licenseCount licence';

  @override
  String? get licensesPackageDetailTextOne => '1 licenca';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licenci';

  @override
  String get licensesPageTitle => 'Licence';

  @override
  String get modalBarrierDismissLabel => 'Odbaci';

  @override
  String get moreButtonTooltip => 'Još';

  @override
  String get nextMonthTooltip => 'Sledeći mesec';

  @override
  String get nextPageTooltip => 'Sledeća stranica';

  @override
  String get okButtonLabel => 'Potvrdi';

  @override
  String get openAppDrawerTooltip => 'Otvorite meni za navigaciju';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow – $lastRow od $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow – $lastRow od približno $rowCount';

  @override
  String get pasteButtonLabel => 'Nalepi';

  @override
  String get popupMenuLabel => 'Iskačući meni';

  @override
  String get postMeridiemAbbreviation => 'po podne';

  @override
  String get previousMonthTooltip => 'Prethodni mesec';

  @override
  String get previousPageTooltip => 'Prethodna stranica';

  @override
  String get refreshIndicatorSemanticLabel => 'Osveži';

  @override
  String? get remainingTextFieldCharacterCountFew => r'Preostala su $remainingCount znaka';

  @override
  String? get remainingTextFieldCharacterCountOne => 'Preostao je 1 znak';

  @override
  String get remainingTextFieldCharacterCountOther => r'Preostalo je $remainingCount znakova';

  @override
  String get reorderItemDown => 'Pomerite nadole';

  @override
  String get reorderItemLeft => 'Pomerite ulevo';

  @override
  String get reorderItemRight => 'Pomerite udesno';

  @override
  String get reorderItemToEnd => 'Pomerite na kraj';

  @override
  String get reorderItemToStart => 'Pomerite na početak';

  @override
  String get reorderItemUp => 'Pomerite nagore';

  @override
  String get rowsPerPageTitle => 'Redova po stranici:';

  @override
  String get saveButtonLabel => 'SAČUVAJ';

  @override
  String get searchFieldLabel => 'Pretražite';

  @override
  String get selectAllButtonLabel => 'Izaberi sve';

  @override
  String get selectYearSemanticsLabel => 'Izaberite godinu';

  @override
  String? get selectedRowCountTitleFew => r'Izabrane su $selectedRowCount stavke';

  @override
  String? get selectedRowCountTitleOne => 'Izabrana je 1 stavka';

  @override
  String get selectedRowCountTitleOther => r'Izabrano je $selectedRowCount stavki';

  @override
  String get showAccountsLabel => 'Prikaži naloge';

  @override
  String get showMenuTooltip => 'Prikaži meni';

  @override
  String get signedInLabel => 'Prijavljeni ste';

  @override
  String get tabLabelRaw => r'$tabIndex. kartica od $tabCount';

  @override
  String get timePickerDialHelpText => 'IZABERITE VREME';

  @override
  String get timePickerHourLabel => 'Sat';

  @override
  String get timePickerHourModeAnnouncement => 'Izaberite sate';

  @override
  String get timePickerInputHelpText => 'UNESITE VREME';

  @override
  String get timePickerMinuteLabel => 'Minut';

  @override
  String get timePickerMinuteModeAnnouncement => 'Izaberite minute';

  @override
  String get unspecifiedDate => 'Datum';

  @override
  String get unspecifiedDateRange => 'Period';

  @override
  String get viewLicensesButtonLabel => 'PRIKAŽI LICENCE';
}

/// The translations for Swedish (`sv`).
class MaterialLocalizationSv extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Swedish.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationSv({
    String localeName = 'sv',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Om $applicationName';

  @override
  String get alertDialogLabel => 'Varning';

  @override
  String get anteMeridiemAbbreviation => 'FM';

  @override
  String get backButtonTooltip => 'Tillbaka';

  @override
  String get calendarModeButtonLabel => 'Byt till kalender';

  @override
  String get cancelButtonLabel => 'AVBRYT';

  @override
  String get closeButtonLabel => 'STÄNG';

  @override
  String get closeButtonTooltip => 'Stäng';

  @override
  String get collapsedIconTapHint => 'Utöka';

  @override
  String get continueButtonLabel => 'FORTSÄTT';

  @override
  String get copyButtonLabel => 'Kopiera';

  @override
  String get cutButtonLabel => 'Klipp ut';

  @override
  String get dateHelpText => 'åååå-mm-dd';

  @override
  String get dateInputLabel => 'Ange datum';

  @override
  String get dateOutOfRangeLabel => 'Utanför intervallet.';

  @override
  String get datePickerHelpText => 'VÄLJ DATUM';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Slutdatum $fullDate';

  @override
  String get dateRangeEndLabel => 'Slutdatum';

  @override
  String get dateRangePickerHelpText => 'VÄLJ INTERVALL';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Startdatum $fullDate';

  @override
  String get dateRangeStartLabel => 'Startdatum';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'Radera';

  @override
  String get dialModeButtonLabel => 'Byt till läget urtavleväljare';

  @override
  String get dialogLabel => 'Dialogruta';

  @override
  String get drawerLabel => 'Navigeringsmeny';

  @override
  String get expandedIconTapHint => 'Dölj';

  @override
  String get firstPageTooltip => 'Första sidan';

  @override
  String get hideAccountsLabel => 'Dölj konton';

  @override
  String get inputDateModeButtonLabel => 'Byt till inmatning';

  @override
  String get inputTimeModeButtonLabel => 'Byt till text som inmatningsläge';

  @override
  String get invalidDateFormatLabel => 'Ogiltigt format.';

  @override
  String get invalidDateRangeLabel => 'Ogiltigt intervall.';

  @override
  String get invalidTimeLabel => 'Ange en giltig tid';

  @override
  String get lastPageTooltip => 'Sista sidan';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 licens';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount licenser';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Licenser';

  @override
  String get modalBarrierDismissLabel => 'Stäng';

  @override
  String get moreButtonTooltip => 'Mer';

  @override
  String get nextMonthTooltip => 'Nästa månad';

  @override
  String get nextPageTooltip => 'Nästa sida';

  @override
  String get okButtonLabel => 'OK';

  @override
  String get openAppDrawerTooltip => 'Öppna navigeringsmenyn';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow av $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow av ungefär $rowCount';

  @override
  String get pasteButtonLabel => 'Klistra in';

  @override
  String get popupMenuLabel => 'Popup-meny';

  @override
  String get postMeridiemAbbreviation => 'EM';

  @override
  String get previousMonthTooltip => 'Föregående månad';

  @override
  String get previousPageTooltip => 'Föregående sida';

  @override
  String get refreshIndicatorSemanticLabel => 'Uppdatera';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 tecken kvar';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount tecken kvar';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Flytta nedåt';

  @override
  String get reorderItemLeft => 'Flytta åt vänster';

  @override
  String get reorderItemRight => 'Flytta åt höger';

  @override
  String get reorderItemToEnd => 'Flytta till slutet';

  @override
  String get reorderItemToStart => 'Flytta till början';

  @override
  String get reorderItemUp => 'Flytta uppåt';

  @override
  String get rowsPerPageTitle => 'Rader per sida:';

  @override
  String get saveButtonLabel => 'SPARA';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Sök';

  @override
  String get selectAllButtonLabel => 'Markera allt';

  @override
  String get selectYearSemanticsLabel => 'Välj år';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 objekt har markerats';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount objekt har markerats';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Visa konton';

  @override
  String get showMenuTooltip => 'Visa meny';

  @override
  String get signedInLabel => 'Inloggad';

  @override
  String get tabLabelRaw => r'Flik $tabIndex av $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'VÄLJ TID';

  @override
  String get timePickerHourLabel => 'Timme';

  @override
  String get timePickerHourModeAnnouncement => 'Välj timmar';

  @override
  String get timePickerInputHelpText => 'ANGE TID';

  @override
  String get timePickerMinuteLabel => 'Minut';

  @override
  String get timePickerMinuteModeAnnouncement => 'Välj minuter';

  @override
  String get unspecifiedDate => 'Datum';

  @override
  String get unspecifiedDateRange => 'Datumintervall';

  @override
  String get viewLicensesButtonLabel => 'VISA LICENSER';
}

/// The translations for Swahili (`sw`).
class MaterialLocalizationSw extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Swahili.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationSw({
    String localeName = 'sw',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Kuhusu $applicationName';

  @override
  String get alertDialogLabel => 'Arifa';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'Rudi Nyuma';

  @override
  String get calendarModeButtonLabel => 'Badili utumie hali ya kalenda';

  @override
  String get cancelButtonLabel => 'GHAIRI';

  @override
  String get closeButtonLabel => 'FUNGA';

  @override
  String get closeButtonTooltip => 'Funga';

  @override
  String get collapsedIconTapHint => 'Panua';

  @override
  String get continueButtonLabel => 'ENDELEA';

  @override
  String get copyButtonLabel => 'Nakili';

  @override
  String get cutButtonLabel => 'Kata';

  @override
  String get dateHelpText => 'dd/mm/yyyy';

  @override
  String get dateInputLabel => 'Weka Tarehe';

  @override
  String get dateOutOfRangeLabel => 'Umechagua tarehe iliyo nje ya kipindi.';

  @override
  String get datePickerHelpText => 'CHAGUA TAREHE';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Tarehe ya kumalizika $fullDate';

  @override
  String get dateRangeEndLabel => 'Tarehe ya Kumalizika';

  @override
  String get dateRangePickerHelpText => 'CHAGUA KIPINDI';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Tarehe ya kuanza $fullDate';

  @override
  String get dateRangeStartLabel => 'Tarehe ya Kuanza';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'Futa';

  @override
  String get dialModeButtonLabel => 'Badilisha ili utumie hali ya kiteuzi cha kupiga simu';

  @override
  String get dialogLabel => 'Kidirisha';

  @override
  String get drawerLabel => 'Menyu ya kusogeza';

  @override
  String get expandedIconTapHint => 'Kunja';

  @override
  String get firstPageTooltip => 'Ukurasa wa kwanza';

  @override
  String get hideAccountsLabel => 'Ficha akaunti';

  @override
  String get inputDateModeButtonLabel => 'Badili utumie hali ya kuweka maandishi';

  @override
  String get inputTimeModeButtonLabel => 'Tumia programu ya kuingiza data ya maandishi';

  @override
  String get invalidDateFormatLabel => 'Muundo si sahihi.';

  @override
  String get invalidDateRangeLabel => 'Kipindi si sahihi.';

  @override
  String get invalidTimeLabel => 'Weka saa sahihi';

  @override
  String get lastPageTooltip => 'Ukurasa wa mwisho';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => 'Leseni moja';

  @override
  String get licensesPackageDetailTextOther => r'Leseni $licenseCount';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Leseni';

  @override
  String get modalBarrierDismissLabel => 'Ondoa';

  @override
  String get moreButtonTooltip => 'Zaidi';

  @override
  String get nextMonthTooltip => 'Mwezi ujao';

  @override
  String get nextPageTooltip => 'Ukurasa unaofuata';

  @override
  String get okButtonLabel => 'Sawa';

  @override
  String get openAppDrawerTooltip => 'Fungua menyu ya kusogeza';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow hadi $lastRow kati ya $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow hadi $lastRow kati ya takriban $rowCount';

  @override
  String get pasteButtonLabel => 'Bandika';

  @override
  String get popupMenuLabel => 'Menyu ibukizi';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'Mwezi uliopita';

  @override
  String get previousPageTooltip => 'Ukurasa uliotangulia';

  @override
  String get refreshIndicatorSemanticLabel => 'Onyesha upya';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => 'Imesalia herufi 1';

  @override
  String get remainingTextFieldCharacterCountOther => r'Zimesalia herufi $remainingCount';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'Hapana herufi zilizo baki';

  @override
  String get reorderItemDown => 'Sogeza chini';

  @override
  String get reorderItemLeft => 'Sogeza kushoto';

  @override
  String get reorderItemRight => 'Sogeza kulia';

  @override
  String get reorderItemToEnd => 'Sogeza hadi mwisho';

  @override
  String get reorderItemToStart => 'Sogeza hadi mwanzo';

  @override
  String get reorderItemUp => 'Sogeza juu';

  @override
  String get rowsPerPageTitle => 'Safu mlalo kwa kila ukurasa:';

  @override
  String get saveButtonLabel => 'HIFADHI';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Tafuta';

  @override
  String get selectAllButtonLabel => 'Chagua vyote';

  @override
  String get selectYearSemanticsLabel => 'Chagua mwaka';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => 'Umechagua kipengee 1';

  @override
  String get selectedRowCountTitleOther => r'Umechagua vipengee $selectedRowCount';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => 'Hamna kilicho chaguliwa';

  @override
  String get showAccountsLabel => 'Onyesha akaunti';

  @override
  String get showMenuTooltip => 'Onyesha menyu';

  @override
  String get signedInLabel => 'Umeingia katika akaunti';

  @override
  String get tabLabelRaw => r'Kichupo cha $tabIndex kati ya $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.h_colon_mm_space_a;

  @override
  String get timePickerDialHelpText => 'CHAGUA SAA';

  @override
  String get timePickerHourLabel => 'Saa';

  @override
  String get timePickerHourModeAnnouncement => 'Chagua saa';

  @override
  String get timePickerInputHelpText => 'WEKA SAA';

  @override
  String get timePickerMinuteLabel => 'Dakika';

  @override
  String get timePickerMinuteModeAnnouncement => 'Chagua dakika';

  @override
  String get unspecifiedDate => 'Tarehe';

  @override
  String get unspecifiedDateRange => 'Kipindi';

  @override
  String get viewLicensesButtonLabel => 'ANGALIA LESENI';
}

/// The translations for Tamil (`ta`).
class MaterialLocalizationTa extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Tamil.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationTa({
    String localeName = 'ta',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName பற்றி';

  @override
  String get alertDialogLabel => 'விழிப்பூட்டல்';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'முந்தைய பக்கம்';

  @override
  String get calendarModeButtonLabel => 'கேலெண்டருக்கு மாற்று';

  @override
  String get cancelButtonLabel => 'ரத்துசெய்';

  @override
  String get closeButtonLabel => 'மூடுக';

  @override
  String get closeButtonTooltip => 'மூடுக';

  @override
  String get collapsedIconTapHint => 'விரிக்கும்';

  @override
  String get continueButtonLabel => 'தொடர்க';

  @override
  String get copyButtonLabel => 'நகலெடு';

  @override
  String get cutButtonLabel => 'வெட்டு';

  @override
  String get dateHelpText => 'mm/dd/yyyy';

  @override
  String get dateInputLabel => 'தேதியை உள்ளிடுக';

  @override
  String get dateOutOfRangeLabel => 'வரம்பிற்கு வெளியே உள்ளது.';

  @override
  String get datePickerHelpText => 'தேதியைத் தேர்ந்தெடுக்கவும்';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'முடிவுத் தேதி $fullDate';

  @override
  String get dateRangeEndLabel => 'முடிவுத் தேதி';

  @override
  String get dateRangePickerHelpText => 'வரம்பைத் தேர்ந்தெடுக்கவும்';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'தொடங்கும் தேதி $fullDate';

  @override
  String get dateRangeStartLabel => 'தொடங்கும் தேதி';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'நீக்கு';

  @override
  String get dialModeButtonLabel => 'டயல் தேர்வுக் கருவி பயன்முறைக்கு மாற்றும்';

  @override
  String get dialogLabel => 'உரையாடல்';

  @override
  String get drawerLabel => 'வழிசெலுத்தல் மெனு';

  @override
  String get expandedIconTapHint => 'சுருக்கும்';

  @override
  String get firstPageTooltip => 'முதல் பக்கத்திற்குச் செல்லும்';

  @override
  String get hideAccountsLabel => 'கணக்குகளை மறைக்கும்';

  @override
  String get inputDateModeButtonLabel => 'உள்ளீட்டுக்கு மாற்று';

  @override
  String get inputTimeModeButtonLabel => 'உரை உள்ளீட்டு முறைக்கு மாற்றும்';

  @override
  String get invalidDateFormatLabel => 'தவறான வடிவம்.';

  @override
  String get invalidDateRangeLabel => 'தவறான வரம்பு.';

  @override
  String get invalidTimeLabel => 'சரியான நேரத்தை உள்ளிடவும்';

  @override
  String get lastPageTooltip => 'கடைசிப் பக்கத்திற்குச் செல்லும்';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 உரிமம்';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount உரிமங்கள்';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'உரிமங்கள்';

  @override
  String get modalBarrierDismissLabel => 'நிராகரிக்கும்';

  @override
  String get moreButtonTooltip => 'மேலும்';

  @override
  String get nextMonthTooltip => 'அடுத்த மாதம்';

  @override
  String get nextPageTooltip => 'அடுத்த பக்கம்';

  @override
  String get okButtonLabel => 'சரி';

  @override
  String get openAppDrawerTooltip => 'வழிசெலுத்தல் மெனுவைத் திற';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow / $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow / $rowCount';

  @override
  String get pasteButtonLabel => 'ஒட்டு';

  @override
  String get popupMenuLabel => 'பாப்-அப் மெனு';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'முந்தைய மாதம்';

  @override
  String get previousPageTooltip => 'முந்தைய பக்கம்';

  @override
  String get refreshIndicatorSemanticLabel => 'ரெஃப்ரெஷ் செய்யும்';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 எழுத்து மீதமுள்ளது';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount எழுத்துகள் மீதமுள்ளன';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'எழுத்துக்கள் எதுவும் இல்லை';

  @override
  String get reorderItemDown => 'கீழே நகர்த்தவும்';

  @override
  String get reorderItemLeft => 'இடப்புறம் நகர்த்தவும்';

  @override
  String get reorderItemRight => 'வலப்புறம் நகர்த்தவும்';

  @override
  String get reorderItemToEnd => 'இறுதிக்கு நகர்த்தவும்';

  @override
  String get reorderItemToStart => 'தொடக்கத்திற்கு நகர்த்தவும்';

  @override
  String get reorderItemUp => 'மேலே நகர்த்தவும்';

  @override
  String get rowsPerPageTitle => 'ஒரு பக்கத்திற்கான வரிசைகள்:';

  @override
  String get saveButtonLabel => 'சேமி';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.dense;

  @override
  String get searchFieldLabel => 'தேடல்';

  @override
  String get selectAllButtonLabel => 'அனைத்தையும் தேர்ந்தெடு';

  @override
  String get selectYearSemanticsLabel => 'ஆண்டைத் தேர்ந்தெடுக்கவும்';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 வரிசை தேர்ந்தெடுக்கப்பட்டது';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount வரிசைகள் தேர்ந்தெடுக்கப்பட்டன';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => 'எந்த வரிசையும் தேர்ந்தெடுக்கவில்லை';

  @override
  String get showAccountsLabel => 'கணக்குகளைக் காட்டும்';

  @override
  String get showMenuTooltip => 'மெனுவைக் காட்டு';

  @override
  String get signedInLabel => 'உள்நுழைந்துள்ளீர்கள்';

  @override
  String get tabLabelRaw => r'தாவல் $tabIndex / $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.a_space_h_colon_mm;

  @override
  String get timePickerDialHelpText => 'நேரத்தைத் தேர்வுசெய்க';

  @override
  String get timePickerHourLabel => 'மணிநேரம்';

  @override
  String get timePickerHourModeAnnouncement => 'மணிநேரத்தைத் தேர்ந்தெடுக்கவும்';

  @override
  String get timePickerInputHelpText => 'நேரத்தை உள்ளிடுக';

  @override
  String get timePickerMinuteLabel => 'நிமிடம்';

  @override
  String get timePickerMinuteModeAnnouncement => 'நிமிடங்களைத் தேர்ந்தெடுக்கவும்';

  @override
  String get unspecifiedDate => 'தேதி';

  @override
  String get unspecifiedDateRange => 'தேதி வரம்பு';

  @override
  String get viewLicensesButtonLabel => 'உரிமங்களைக் காட்டு';
}

/// The translations for Telugu (`te`).
class MaterialLocalizationTe extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Telugu.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationTe({
    String localeName = 'te',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName గురించి';

  @override
  String get alertDialogLabel => 'అలర్ట్';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'వెనుకకు';

  @override
  String get calendarModeButtonLabel => 'క్యాలెండర్‌కు మారండి';

  @override
  String get cancelButtonLabel => 'రద్దు చేయి';

  @override
  String get closeButtonLabel => 'మూసివేయి';

  @override
  String get closeButtonTooltip => 'మూసివేయి';

  @override
  String get collapsedIconTapHint => 'విస్తరించు';

  @override
  String get continueButtonLabel => 'కొనసాగించు';

  @override
  String get copyButtonLabel => 'కాపీ చేయి';

  @override
  String get cutButtonLabel => 'కత్తిరించు';

  @override
  String get dateHelpText => 'mm/dd/yyyy';

  @override
  String get dateInputLabel => 'తేదీని ఎంటర్ చేయండి';

  @override
  String get dateOutOfRangeLabel => 'పరిధి వెలుపల ఉంది.';

  @override
  String get datePickerHelpText => 'తేదీని ఎంచుకోండి';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'ముగింపు తేదీ $fullDate';

  @override
  String get dateRangeEndLabel => 'ముగింపు తేదీ';

  @override
  String get dateRangePickerHelpText => 'పరిధిని ఎంచుకోండి';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'ప్రారంభ తేదీ $fullDate';

  @override
  String get dateRangeStartLabel => 'ప్రారంభ తేదీ';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'తొలగించు';

  @override
  String get dialModeButtonLabel => 'డయల్ పికర్ మోడ్‌కు మారుస్తుంది';

  @override
  String get dialogLabel => 'డైలాగ్';

  @override
  String get drawerLabel => 'నావిగేషన్ మెనూ';

  @override
  String get expandedIconTapHint => 'కుదించు';

  @override
  String get firstPageTooltip => 'మొదటి పేజీ';

  @override
  String get hideAccountsLabel => 'ఖాతాలను దాచు';

  @override
  String get inputDateModeButtonLabel => 'ఇన్‌పుట్‌కు మారండి';

  @override
  String get inputTimeModeButtonLabel => 'టెక్స్ట్ ఇన్‌పుట్ మోడ్‌కు మారుస్తుంది';

  @override
  String get invalidDateFormatLabel => 'ఫార్మాట్ చెల్లదు.';

  @override
  String get invalidDateRangeLabel => 'పరిధి చెల్లదు.';

  @override
  String get invalidTimeLabel => 'చెల్లుబాటు అయ్యే సమయాన్ని ఎంటర్ చేయండి';

  @override
  String get lastPageTooltip => 'చివరి పేజీ';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 లైసెన్స్';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount లైసెన్స్‌లు';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'లైసెన్స్‌లు';

  @override
  String get modalBarrierDismissLabel => 'విస్మరించు';

  @override
  String get moreButtonTooltip => 'మరిన్ని';

  @override
  String get nextMonthTooltip => 'తర్వాత నెల';

  @override
  String get nextPageTooltip => 'తర్వాత పేజీ';

  @override
  String get okButtonLabel => 'సరే';

  @override
  String get openAppDrawerTooltip => 'నావిగేషన్ మెనూను తెరువు';

  @override
  String get pageRowsInfoTitleRaw => r'$rowCountలో $firstRow - $lastRow';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$rowCountలో $firstRow–$lastRow';

  @override
  String get pasteButtonLabel => 'అతికించు';

  @override
  String get popupMenuLabel => 'పాప్‌అప్ మెనూ';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'మునుపటి నెల';

  @override
  String get previousPageTooltip => 'మునుపటి పేజీ';

  @override
  String get refreshIndicatorSemanticLabel => 'రిఫ్రెష్ చేయి';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 అక్షరం మిగిలి ఉంది';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount అక్షరాలు మిగిలి ఉన్నాయి';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => 'కిందికు జరుపు';

  @override
  String get reorderItemLeft => 'ఎడమవైపుగా జరపండి';

  @override
  String get reorderItemRight => 'కుడివైపుగా జరపండి';

  @override
  String get reorderItemToEnd => 'చివరకు తరలించండి';

  @override
  String get reorderItemToStart => 'ప్రారంభానికి తరలించండి';

  @override
  String get reorderItemUp => 'పైకి జరపండి';

  @override
  String get rowsPerPageTitle => 'పేజీకి ఉండే అడ్డు వరుసలు:';

  @override
  String get saveButtonLabel => 'సేవ్ చేయి';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.tall;

  @override
  String get searchFieldLabel => 'వెతుకు';

  @override
  String get selectAllButtonLabel => 'అన్నింటినీ ఎంచుకోండి';

  @override
  String get selectYearSemanticsLabel => 'సంవత్సరాన్ని ఎంచుకోండి';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 అంశం ఎంచుకోబడింది';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount అంశాలు ఎంచుకోబడ్డాయి';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'ఖాతాలను చూపు';

  @override
  String get showMenuTooltip => 'మెనూను చూపు';

  @override
  String get signedInLabel => 'సైన్ ఇన్ చేశారు';

  @override
  String get tabLabelRaw => r'$tabCountలో $tabIndexవ ట్యాబ్';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => 'సమయాన్ని ఎంచుకోండి';

  @override
  String get timePickerHourLabel => 'గంట';

  @override
  String get timePickerHourModeAnnouncement => 'గంటలను ఎంచుకోండి';

  @override
  String get timePickerInputHelpText => 'సమయాన్ని ఎంటర్ చేయండి';

  @override
  String get timePickerMinuteLabel => 'నిమిషం';

  @override
  String get timePickerMinuteModeAnnouncement => 'నిమిషాలను ఎంచుకోండి';

  @override
  String get unspecifiedDate => 'తేదీ';

  @override
  String get unspecifiedDateRange => 'తేదీల పరిధి';

  @override
  String get viewLicensesButtonLabel => 'లైసెన్స్‌లను చూడండి';
}

/// The translations for Thai (`th`).
class MaterialLocalizationTh extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Thai.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationTh({
    String localeName = 'th',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'เกี่ยวกับ $applicationName';

  @override
  String get alertDialogLabel => 'การแจ้งเตือน';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'กลับ';

  @override
  String get calendarModeButtonLabel => 'เปลี่ยนเป็นปฏิทิน';

  @override
  String get cancelButtonLabel => 'ยกเลิก';

  @override
  String get closeButtonLabel => 'ปิด';

  @override
  String get closeButtonTooltip => 'ปิด';

  @override
  String get collapsedIconTapHint => 'ขยาย';

  @override
  String get continueButtonLabel => 'ต่อไป';

  @override
  String get copyButtonLabel => 'คัดลอก';

  @override
  String get cutButtonLabel => 'ตัด';

  @override
  String get dateHelpText => 'ดด/วว/ปปปป';

  @override
  String get dateInputLabel => 'ป้อนวันที่';

  @override
  String get dateOutOfRangeLabel => 'ไม่อยู่ในช่วง';

  @override
  String get datePickerHelpText => 'เลือกวันที่';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'วันที่สิ้นสุด $fullDate';

  @override
  String get dateRangeEndLabel => 'วันที่สิ้นสุด';

  @override
  String get dateRangePickerHelpText => 'เลือกช่วง';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'วันที่เริ่มต้น $fullDate';

  @override
  String get dateRangeStartLabel => 'วันที่เริ่มต้น';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'ลบ';

  @override
  String get dialModeButtonLabel => 'สลับไปใช้โหมดเครื่องมือเลือกแบบหมุน';

  @override
  String get dialogLabel => 'กล่องโต้ตอบ';

  @override
  String get drawerLabel => 'เมนูการนำทาง';

  @override
  String get expandedIconTapHint => 'ยุบ';

  @override
  String get firstPageTooltip => 'หน้าแรก';

  @override
  String get hideAccountsLabel => 'ซ่อนบัญชี';

  @override
  String get inputDateModeButtonLabel => 'เปลี่ยนเป็นโหมดป้อนข้อความ';

  @override
  String get inputTimeModeButtonLabel => 'สลับไปใช้โหมดป้อนข้อมูลข้อความ';

  @override
  String get invalidDateFormatLabel => 'รูปแบบไม่ถูกต้อง';

  @override
  String get invalidDateRangeLabel => 'ช่วงไม่ถูกต้อง';

  @override
  String get invalidTimeLabel => 'ป้อนเวลาที่ถูกต้อง';

  @override
  String get lastPageTooltip => 'หน้าสุดท้าย';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => 'ใบอนุญาต 1 ใบ';

  @override
  String get licensesPackageDetailTextOther => r'ใบอนุญาต $licenseCount ใบ';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'ใบอนุญาต';

  @override
  String get modalBarrierDismissLabel => 'ปิด';

  @override
  String get moreButtonTooltip => 'เพิ่มเติม';

  @override
  String get nextMonthTooltip => 'เดือนหน้า';

  @override
  String get nextPageTooltip => 'หน้าถัดไป';

  @override
  String get okButtonLabel => 'ตกลง';

  @override
  String get openAppDrawerTooltip => 'เปิดเมนูการนำทาง';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow-$lastRow จาก $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow จากประมาณ $rowCount';

  @override
  String get pasteButtonLabel => 'วาง';

  @override
  String get popupMenuLabel => 'เมนูป๊อปอัป';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'เดือนที่แล้ว';

  @override
  String get previousPageTooltip => 'หน้าก่อน';

  @override
  String get refreshIndicatorSemanticLabel => 'รีเฟรช';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => 'เหลือ 1 อักขระ';

  @override
  String get remainingTextFieldCharacterCountOther => r'เหลือ $remainingCount อักขระ';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'ย้ายลง';

  @override
  String get reorderItemLeft => 'ย้ายไปทางซ้าย';

  @override
  String get reorderItemRight => 'ย้ายไปทางขวา';

  @override
  String get reorderItemToEnd => 'ย้ายไปท้ายรายการ';

  @override
  String get reorderItemToStart => 'ย้ายไปต้นรายการ';

  @override
  String get reorderItemUp => 'ย้ายขึ้น';

  @override
  String get rowsPerPageTitle => 'แถวต่อหน้า:';

  @override
  String get saveButtonLabel => 'บันทึก';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.tall;

  @override
  String get searchFieldLabel => 'ค้นหา';

  @override
  String get selectAllButtonLabel => 'เลือกทั้งหมด';

  @override
  String get selectYearSemanticsLabel => 'เลือกปี';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => 'เลือกแล้ว 1 รายการ';

  @override
  String get selectedRowCountTitleOther => r'เลือกแล้ว $selectedRowCount รายการ';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'แสดงบัญชี';

  @override
  String get showMenuTooltip => 'แสดงเมนู';

  @override
  String get signedInLabel => 'ลงชื่อเข้าใช้';

  @override
  String get tabLabelRaw => r'แท็บที่ $tabIndex จาก $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.a_space_h_colon_mm;

  @override
  String get timePickerDialHelpText => 'เลือกเวลา';

  @override
  String get timePickerHourLabel => 'ชั่วโมง';

  @override
  String get timePickerHourModeAnnouncement => 'เลือกชั่วโมง';

  @override
  String get timePickerInputHelpText => 'ป้อนเวลา';

  @override
  String get timePickerMinuteLabel => 'นาที';

  @override
  String get timePickerMinuteModeAnnouncement => 'เลือกนาที';

  @override
  String get unspecifiedDate => 'วันที่';

  @override
  String get unspecifiedDateRange => 'ช่วงวันที่';

  @override
  String get viewLicensesButtonLabel => 'ดูใบอนุญาต';
}

/// The translations for Tagalog (`tl`).
class MaterialLocalizationTl extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Tagalog.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationTl({
    String localeName = 'tl',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Tungkol sa $applicationName';

  @override
  String get alertDialogLabel => 'Alerto';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'Bumalik';

  @override
  String get calendarModeButtonLabel => 'Lumipat sa kalendaryo';

  @override
  String get cancelButtonLabel => 'KANSELAHIN';

  @override
  String get closeButtonLabel => 'ISARA';

  @override
  String get closeButtonTooltip => 'Isara';

  @override
  String get collapsedIconTapHint => 'I-expand';

  @override
  String get continueButtonLabel => 'MAGPATULOY';

  @override
  String get copyButtonLabel => 'Kopyahin';

  @override
  String get cutButtonLabel => 'I-cut';

  @override
  String get dateHelpText => 'mm/dd/yyyy';

  @override
  String get dateInputLabel => 'Ilagay ang Petsa';

  @override
  String get dateOutOfRangeLabel => 'Wala sa hanay.';

  @override
  String get datePickerHelpText => 'PUMILI NG PETSA';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Petsa ng pagtatapos $fullDate';

  @override
  String get dateRangeEndLabel => 'Petsa ng Pagtatapos';

  @override
  String get dateRangePickerHelpText => 'PUMILI NG HANAY';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Petsa ng pagsisimula $fullDate';

  @override
  String get dateRangeStartLabel => 'Petsa ng Pagsisimula';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'I-delete';

  @override
  String get dialModeButtonLabel => 'Lumipat sa dial picker mode';

  @override
  String get dialogLabel => 'Dialog';

  @override
  String get drawerLabel => 'Menu ng navigation';

  @override
  String get expandedIconTapHint => 'I-collapse';

  @override
  String get firstPageTooltip => 'Unang page';

  @override
  String get hideAccountsLabel => 'Itago ang mga account';

  @override
  String get inputDateModeButtonLabel => 'Lumipat sa input';

  @override
  String get inputTimeModeButtonLabel => 'Lumipat sa text input mode';

  @override
  String get invalidDateFormatLabel => 'Invalid ang format.';

  @override
  String get invalidDateRangeLabel => 'Invalid ang hanay.';

  @override
  String get invalidTimeLabel => 'Maglagay ng valid na oras';

  @override
  String get lastPageTooltip => 'Huling page';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 lisensya';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount na lisensya';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Mga Lisensya';

  @override
  String get modalBarrierDismissLabel => 'I-dismiss';

  @override
  String get moreButtonTooltip => 'Higit Pa';

  @override
  String get nextMonthTooltip => 'Susunod na buwan';

  @override
  String get nextPageTooltip => 'Susunod na page';

  @override
  String get okButtonLabel => 'OK';

  @override
  String get openAppDrawerTooltip => 'Buksan ang menu ng navigation';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow ng $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow ng humigit kumulang $rowCount';

  @override
  String get pasteButtonLabel => 'I-paste';

  @override
  String get popupMenuLabel => 'Popup na menu';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'Nakaraang buwan';

  @override
  String get previousPageTooltip => 'Nakaraang page';

  @override
  String get refreshIndicatorSemanticLabel => 'Nagre-refresh';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 character ang natitira';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount na character ang natitira';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Ilipat pababa';

  @override
  String get reorderItemLeft => 'Ilipat pakaliwa';

  @override
  String get reorderItemRight => 'Ilipat pakanan';

  @override
  String get reorderItemToEnd => 'Ilipat sa dulo';

  @override
  String get reorderItemToStart => 'Ilipat sa simula';

  @override
  String get reorderItemUp => 'Ilipat pataas';

  @override
  String get rowsPerPageTitle => 'Mga row bawat page:';

  @override
  String get saveButtonLabel => 'I-SAVE';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Maghanap';

  @override
  String get selectAllButtonLabel => 'Piliin lahat';

  @override
  String get selectYearSemanticsLabel => 'Pumili ng taon';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 item ang napili';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount na item ang napili';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Ipakita ang mga account';

  @override
  String get showMenuTooltip => 'Ipakita ang menu';

  @override
  String get signedInLabel => 'Naka-sign in';

  @override
  String get tabLabelRaw => r'Tab $tabIndex ng $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'PUMILI NG ORAS';

  @override
  String get timePickerHourLabel => 'Oras';

  @override
  String get timePickerHourModeAnnouncement => 'Pumili ng mga oras';

  @override
  String get timePickerInputHelpText => 'MAGLAGAY NG ORAS';

  @override
  String get timePickerMinuteLabel => 'Minuto';

  @override
  String get timePickerMinuteModeAnnouncement => 'Pumili ng mga minuto';

  @override
  String get unspecifiedDate => 'Petsa';

  @override
  String get unspecifiedDateRange => 'Hanay ng Petsa';

  @override
  String get viewLicensesButtonLabel => 'TINGNAN ANG MGA LISENSYA';
}

/// The translations for Turkish (`tr`).
class MaterialLocalizationTr extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Turkish.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationTr({
    String localeName = 'tr',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName Hakkında';

  @override
  String get alertDialogLabel => 'Uyarı';

  @override
  String get anteMeridiemAbbreviation => 'ÖÖ';

  @override
  String get backButtonTooltip => 'Geri';

  @override
  String get calendarModeButtonLabel => 'Takvime geç';

  @override
  String get cancelButtonLabel => 'İPTAL';

  @override
  String get closeButtonLabel => 'KAPAT';

  @override
  String get closeButtonTooltip => 'Kapat';

  @override
  String get collapsedIconTapHint => 'Genişlet';

  @override
  String get continueButtonLabel => 'DEVAM';

  @override
  String get copyButtonLabel => 'Kopyala';

  @override
  String get cutButtonLabel => 'Kes';

  @override
  String get dateHelpText => 'gg.aa.yyyy';

  @override
  String get dateInputLabel => 'Tarih Girin';

  @override
  String get dateOutOfRangeLabel => 'Kapsama alanı dışında.';

  @override
  String get datePickerHelpText => 'TARİH SEÇİN';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Bitiş tarihi $fullDate';

  @override
  String get dateRangeEndLabel => 'Bitiş Tarihi';

  @override
  String get dateRangePickerHelpText => 'ARALIK SEÇİN';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Başlangıç tarihi $fullDate';

  @override
  String get dateRangeStartLabel => 'Başlangıç Tarihi';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'Sil';

  @override
  String get dialModeButtonLabel => 'Dairesel seçici moduna geç';

  @override
  String get dialogLabel => 'İletişim kutusu';

  @override
  String get drawerLabel => 'Gezinme menüsü';

  @override
  String get expandedIconTapHint => 'Daralt';

  @override
  String get firstPageTooltip => 'İlk sayfa';

  @override
  String get hideAccountsLabel => 'Hesapları gizle';

  @override
  String get inputDateModeButtonLabel => 'Girişe geç';

  @override
  String get inputTimeModeButtonLabel => 'Metin giriş moduna geç';

  @override
  String get invalidDateFormatLabel => 'Geçersiz biçim.';

  @override
  String get invalidDateRangeLabel => 'Geçersiz aralık.';

  @override
  String get invalidTimeLabel => 'Geçerli bir saat girin';

  @override
  String get lastPageTooltip => 'Son sayfa';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 lisans';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount lisans';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Lisanslar';

  @override
  String get modalBarrierDismissLabel => 'Kapat';

  @override
  String get moreButtonTooltip => 'Diğer';

  @override
  String get nextMonthTooltip => 'Gelecek ay';

  @override
  String get nextPageTooltip => 'Sonraki sayfa';

  @override
  String get okButtonLabel => 'Tamam';

  @override
  String get openAppDrawerTooltip => 'Gezinme menüsünü aç';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow-$lastRow / $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow-$lastRow / $rowCount';

  @override
  String get pasteButtonLabel => 'Yapıştır';

  @override
  String get popupMenuLabel => 'Popup menü';

  @override
  String get postMeridiemAbbreviation => 'ÖS';

  @override
  String get previousMonthTooltip => 'Önceki ay';

  @override
  String get previousPageTooltip => 'Önceki sayfa';

  @override
  String get refreshIndicatorSemanticLabel => 'Yenile';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 karakter kaldı';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount karakter kaldı';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Aşağı taşı';

  @override
  String get reorderItemLeft => 'Sola taşı';

  @override
  String get reorderItemRight => 'Sağa taşı';

  @override
  String get reorderItemToEnd => 'Sona taşı';

  @override
  String get reorderItemToStart => 'Başa taşı';

  @override
  String get reorderItemUp => 'Yukarı taşı';

  @override
  String get rowsPerPageTitle => 'Sayfa başına satır sayısı:';

  @override
  String get saveButtonLabel => 'KAYDET';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Ara';

  @override
  String get selectAllButtonLabel => 'Tümünü seç';

  @override
  String get selectYearSemanticsLabel => 'Yılı seçin';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 öğe seçildi';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount öğe seçildi';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Hesapları göster';

  @override
  String get showMenuTooltip => 'Menüyü göster';

  @override
  String get signedInLabel => 'Oturum açıldı';

  @override
  String get tabLabelRaw => r'Sekme $tabIndex / $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'SAATİ SEÇİN';

  @override
  String get timePickerHourLabel => 'Saat';

  @override
  String get timePickerHourModeAnnouncement => 'Saati seçin';

  @override
  String get timePickerInputHelpText => 'SAATİ GİRİN';

  @override
  String get timePickerMinuteLabel => 'Dakika';

  @override
  String get timePickerMinuteModeAnnouncement => 'Dakikayı seçin';

  @override
  String get unspecifiedDate => 'Tarih';

  @override
  String get unspecifiedDateRange => 'Tarih Aralığı';

  @override
  String get viewLicensesButtonLabel => 'LİSANSLARI GÖSTER';
}

/// The translations for Ukrainian (`uk`).
class MaterialLocalizationUk extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Ukrainian.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationUk({
    String localeName = 'uk',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Про додаток $applicationName';

  @override
  String get alertDialogLabel => 'Сповіщення';

  @override
  String get anteMeridiemAbbreviation => 'дп';

  @override
  String get backButtonTooltip => 'Назад';

  @override
  String get calendarModeButtonLabel => 'Перейти до календаря';

  @override
  String get cancelButtonLabel => 'СКАСУВАТИ';

  @override
  String get closeButtonLabel => 'ЗАКРИТИ';

  @override
  String get closeButtonTooltip => 'Закрити';

  @override
  String get collapsedIconTapHint => 'Розгорнути';

  @override
  String get continueButtonLabel => 'ПРОДОВЖИТИ';

  @override
  String get copyButtonLabel => 'Копіювати';

  @override
  String get cutButtonLabel => 'Вирізати';

  @override
  String get dateHelpText => 'дд.мм.рррр';

  @override
  String get dateInputLabel => 'Введіть дату';

  @override
  String get dateOutOfRangeLabel => 'За межами діапазону.';

  @override
  String get datePickerHelpText => 'ВИБРАТИ ДАТУ';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Дата завершення $fullDate';

  @override
  String get dateRangeEndLabel => 'Дата завершення';

  @override
  String get dateRangePickerHelpText => 'ВИБРАТИ ДІАПАЗОН';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Дата початку $fullDate';

  @override
  String get dateRangeStartLabel => 'Дата початку';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'Видалити';

  @override
  String get dialModeButtonLabel => 'Перейти в режим вибору на циферблаті';

  @override
  String get dialogLabel => 'Вікно';

  @override
  String get drawerLabel => 'Меню навігації';

  @override
  String get expandedIconTapHint => 'Згорнути';

  @override
  String get firstPageTooltip => 'Перша сторінка';

  @override
  String get hideAccountsLabel => 'Сховати облікові записи';

  @override
  String get inputDateModeButtonLabel => 'Ввести вручну';

  @override
  String get inputTimeModeButtonLabel => 'Перейти в режим введення цифр';

  @override
  String get invalidDateFormatLabel => 'Недійсний формат.';

  @override
  String get invalidDateRangeLabel => 'Недійсний діапазон.';

  @override
  String get invalidTimeLabel => 'Введіть дійсний час';

  @override
  String get lastPageTooltip => 'Остання сторінка';

  @override
  String? get licensesPackageDetailTextFew => r'$licenseCount ліцензії';

  @override
  String? get licensesPackageDetailTextMany => r'$licenseCount ліцензій';

  @override
  String? get licensesPackageDetailTextOne => '1 ліцензія';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount ліцензії';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Ліцензії';

  @override
  String get modalBarrierDismissLabel => 'Закрити';

  @override
  String get moreButtonTooltip => 'Інші';

  @override
  String get nextMonthTooltip => 'Наступний місяць';

  @override
  String get nextPageTooltip => 'Наступна сторінка';

  @override
  String get okButtonLabel => 'OK';

  @override
  String get openAppDrawerTooltip => 'Відкрити меню навігації';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow з $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow з приблизно $rowCount';

  @override
  String get pasteButtonLabel => 'Вставити';

  @override
  String get popupMenuLabel => 'Спливаюче меню';

  @override
  String get postMeridiemAbbreviation => 'пп';

  @override
  String get previousMonthTooltip => 'Попередній місяць';

  @override
  String get previousPageTooltip => 'Попередня сторінка';

  @override
  String get refreshIndicatorSemanticLabel => 'Оновити';

  @override
  String? get remainingTextFieldCharacterCountFew => r'Залишилося $remainingCount символи';

  @override
  String? get remainingTextFieldCharacterCountMany => r'Залишилося $remainingCount символів';

  @override
  String? get remainingTextFieldCharacterCountOne => 'Залишився 1 символ';

  @override
  String get remainingTextFieldCharacterCountOther => r'Залишилося $remainingCount символу';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Перемістити вниз';

  @override
  String get reorderItemLeft => 'Перемістити ліворуч';

  @override
  String get reorderItemRight => 'Перемістити праворуч';

  @override
  String get reorderItemToEnd => 'Перемістити в кінець';

  @override
  String get reorderItemToStart => 'Перемістити на початок';

  @override
  String get reorderItemUp => 'Перемістити вгору';

  @override
  String get rowsPerPageTitle => 'Рядків на сторінці:';

  @override
  String get saveButtonLabel => 'ЗБЕРЕГТИ';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Пошук';

  @override
  String get selectAllButtonLabel => 'Вибрати всі';

  @override
  String get selectYearSemanticsLabel => 'Виберіть рік';

  @override
  String? get selectedRowCountTitleFew => r'Вибрано $selectedRowCount елементи';

  @override
  String? get selectedRowCountTitleMany => r'Вибрано $selectedRowCount елементів';

  @override
  String? get selectedRowCountTitleOne => 'Вибрано 1 елемент';

  @override
  String get selectedRowCountTitleOther => r'Вибрано $selectedRowCount елемента';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Показати облікові записи';

  @override
  String get showMenuTooltip => 'Показати меню';

  @override
  String get signedInLabel => 'Ви ввійшли';

  @override
  String get tabLabelRaw => r'Вкладка $tabIndex з $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'ВИБЕРІТЬ ЧАС';

  @override
  String get timePickerHourLabel => 'Години';

  @override
  String get timePickerHourModeAnnouncement => 'Виберіть години';

  @override
  String get timePickerInputHelpText => 'ВВЕДІТЬ ЧАС';

  @override
  String get timePickerMinuteLabel => 'Хвилини';

  @override
  String get timePickerMinuteModeAnnouncement => 'Виберіть хвилини';

  @override
  String get unspecifiedDate => 'Дата';

  @override
  String get unspecifiedDateRange => 'Діапазон дат';

  @override
  String get viewLicensesButtonLabel => 'ПЕРЕГЛЯНУТИ ЛІЦЕНЗІЇ';
}

/// The translations for Urdu (`ur`).
class MaterialLocalizationUr extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Urdu.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationUr({
    String localeName = 'ur',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName کے بارے میں';

  @override
  String get alertDialogLabel => 'الرٹ';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'پیچھے';

  @override
  String get calendarModeButtonLabel => 'کیلنڈر پر سوئچ کریں';

  @override
  String get cancelButtonLabel => 'منسوخ کریں';

  @override
  String get closeButtonLabel => 'بند کریں';

  @override
  String get closeButtonTooltip => 'بند کریں';

  @override
  String get collapsedIconTapHint => 'پھیلائیں';

  @override
  String get continueButtonLabel => 'جاری رکھیں';

  @override
  String get copyButtonLabel => 'کاپی کریں';

  @override
  String get cutButtonLabel => 'کٹ کریں';

  @override
  String get dateHelpText => 'dd/mm/yyyy';

  @override
  String get dateInputLabel => 'تاریخ درج کریں';

  @override
  String get dateOutOfRangeLabel => 'حد سے باہر۔';

  @override
  String get datePickerHelpText => 'تاریخ منتخب کریں';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'تاریخ اختتام $fullDate';

  @override
  String get dateRangeEndLabel => 'تاریخ اختتام';

  @override
  String get dateRangePickerHelpText => 'حد منتخب کریں';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'تاریخ آغاز $fullDate';

  @override
  String get dateRangeStartLabel => 'تاریخ آغاز';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'حذف کریں';

  @override
  String get dialModeButtonLabel => 'ڈائل منتخب کنندہ وضع پر سوئچ کریں';

  @override
  String get dialogLabel => 'ڈائلاگ';

  @override
  String get drawerLabel => 'نیویگیشن مینو';

  @override
  String get expandedIconTapHint => 'سکیڑیں';

  @override
  String get firstPageTooltip => 'پہلا صفحہ';

  @override
  String get hideAccountsLabel => 'اکاؤنٹس چھپائیں';

  @override
  String get inputDateModeButtonLabel => 'ان پٹ پر سوئچ کریں';

  @override
  String get inputTimeModeButtonLabel => 'ٹیکسٹ ان پٹ وضع پر سوئچ کریں';

  @override
  String get invalidDateFormatLabel => 'غلط فارمیٹ۔';

  @override
  String get invalidDateRangeLabel => 'غلط رینج۔';

  @override
  String get invalidTimeLabel => 'درست وقت درج کریں';

  @override
  String get lastPageTooltip => 'آخری صفحہ';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 لائسنس';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount لائسنسز';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'لائسنسز';

  @override
  String get modalBarrierDismissLabel => 'برخاست کریں';

  @override
  String get moreButtonTooltip => 'مزید';

  @override
  String get nextMonthTooltip => 'اگلا مہینہ';

  @override
  String get nextPageTooltip => 'اگلا صفحہ';

  @override
  String get okButtonLabel => 'ٹھیک ہے';

  @override
  String get openAppDrawerTooltip => 'نیویگیشن مینو کھولیں';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow از $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow $rowCount میں سے تقریباً';

  @override
  String get pasteButtonLabel => 'پیسٹ کریں';

  @override
  String get popupMenuLabel => 'پاپ اپ مینو';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'پچھلا مہینہ';

  @override
  String get previousPageTooltip => 'گزشتہ صفحہ';

  @override
  String get refreshIndicatorSemanticLabel => 'ریفریش کریں';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 حرف باقی ہے';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount حروف باقی ہیں';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'نیچے منتقل کریں';

  @override
  String get reorderItemLeft => 'بائیں منتقل کریں';

  @override
  String get reorderItemRight => 'دائیں منتقل کریں';

  @override
  String get reorderItemToEnd => 'آخر میں منتقل کریں';

  @override
  String get reorderItemToStart => 'شروع میں منتقل کریں';

  @override
  String get reorderItemUp => 'اوپر منتقل کریں';

  @override
  String get rowsPerPageTitle => 'قطاریں فی صفحہ:';

  @override
  String get saveButtonLabel => 'محفوظ کریں';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.tall;

  @override
  String get searchFieldLabel => 'تلاش';

  @override
  String get selectAllButtonLabel => 'سبھی کو منتخب کریں';

  @override
  String get selectYearSemanticsLabel => 'سال منتخب کریں';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 آئٹم منتخب کیا گیا';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount آئٹمز منتخب کیے گئے';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'اکاؤنٹس دکھائیں';

  @override
  String get showMenuTooltip => 'مینو دکھائیں';

  @override
  String get signedInLabel => 'سائن ان کردہ ہے';

  @override
  String get tabLabelRaw => r'$tabCount میں سے $tabIndex ٹیب';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.h_colon_mm_space_a;

  @override
  String get timePickerDialHelpText => 'وقت منتخب کریں';

  @override
  String get timePickerHourLabel => 'گھنٹہ';

  @override
  String get timePickerHourModeAnnouncement => 'گھنٹے منتخب کریں';

  @override
  String get timePickerInputHelpText => 'وقت درج کریں';

  @override
  String get timePickerMinuteLabel => 'منٹ';

  @override
  String get timePickerMinuteModeAnnouncement => 'منٹ منتخب کریں';

  @override
  String get unspecifiedDate => 'تاریخ';

  @override
  String get unspecifiedDateRange => 'تاریخ کی حد';

  @override
  String get viewLicensesButtonLabel => 'لائسنسز دیکھیں';
}

/// The translations for Uzbek (`uz`).
class MaterialLocalizationUz extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Uzbek.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationUz({
    String localeName = 'uz',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'$applicationName haqida';

  @override
  String get alertDialogLabel => 'Ogohlantirish';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'Orqaga';

  @override
  String get calendarModeButtonLabel => 'Taqvimda ochish';

  @override
  String get cancelButtonLabel => 'BEKOR QILISH';

  @override
  String get closeButtonLabel => 'YOPISH';

  @override
  String get closeButtonTooltip => 'Yopish';

  @override
  String get collapsedIconTapHint => 'Yoyish';

  @override
  String get continueButtonLabel => 'DAVOM ETISH';

  @override
  String get copyButtonLabel => 'Nusxa olish';

  @override
  String get cutButtonLabel => 'Kesib olish';

  @override
  String get dateHelpText => 'mm/dd/yyyy';

  @override
  String get dateInputLabel => 'Sanani kiriting';

  @override
  String get dateOutOfRangeLabel => 'Diapazondan tashqarida.';

  @override
  String get datePickerHelpText => 'SANANI TANLANG';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Tugash sanasi: $fullDate';

  @override
  String get dateRangeEndLabel => 'Tugash sanasi';

  @override
  String get dateRangePickerHelpText => 'ORALIQNI TANLANG';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Boshlanish sanasi: $fullDate';

  @override
  String get dateRangeStartLabel => 'Boshlanish sanasi';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'Olib tashlash';

  @override
  String get dialModeButtonLabel => 'Vaqtni burab tanlash rejimi';

  @override
  String get dialogLabel => 'Muloqot oynasi';

  @override
  String get drawerLabel => 'Navigatsiya menyusi';

  @override
  String get expandedIconTapHint => 'Kichraytirish';

  @override
  String get firstPageTooltip => 'Birinchi sahifa';

  @override
  String get hideAccountsLabel => 'Hisoblarni berkitish';

  @override
  String get inputDateModeButtonLabel => 'Mustaqil kiritish';

  @override
  String get inputTimeModeButtonLabel => 'Vaqtni yozib tanlash rejimi';

  @override
  String get invalidDateFormatLabel => 'Yaroqsiz format.';

  @override
  String get invalidDateRangeLabel => 'Yaroqsiz oraliq.';

  @override
  String get invalidTimeLabel => 'Vaqt xato kiritildi';

  @override
  String get lastPageTooltip => 'Oxirgi sahifa';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 ta litsenziya';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount ta litsenziya';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Litsenziyalar';

  @override
  String get modalBarrierDismissLabel => 'Yopish';

  @override
  String get moreButtonTooltip => 'Yana';

  @override
  String get nextMonthTooltip => 'Keyingi oy';

  @override
  String get nextPageTooltip => 'Keyingi sahifa';

  @override
  String get okButtonLabel => 'OK';

  @override
  String get openAppDrawerTooltip => 'Navigatsiya menyusini ochish';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow, jami: $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow, jami: $rowCount';

  @override
  String get pasteButtonLabel => 'Joylash';

  @override
  String get popupMenuLabel => 'Pop-ap menyusi';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'Avvalgi oy';

  @override
  String get previousPageTooltip => 'Avvalgi sahifa';

  @override
  String get refreshIndicatorSemanticLabel => 'Yangilash';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 ta belgi qoldi';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount ta belgi qoldi';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => 'Pastga siljitish';

  @override
  String get reorderItemLeft => 'Chapga siljitish';

  @override
  String get reorderItemRight => 'Oʻngga siljitish';

  @override
  String get reorderItemToEnd => 'Oxiriga siljitish';

  @override
  String get reorderItemToStart => 'Boshiga siljitish';

  @override
  String get reorderItemUp => 'Tepaga siljitish';

  @override
  String get rowsPerPageTitle => 'Har bir sahifadagi qatorlar soni:';

  @override
  String get saveButtonLabel => 'SAQLASH';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Qidirish';

  @override
  String get selectAllButtonLabel => 'Hammasi';

  @override
  String get selectYearSemanticsLabel => 'Yilni tanlang';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 ta element tanlandi';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount ta element tanlandi';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Hisoblarni koʻrsatish';

  @override
  String get showMenuTooltip => 'Menyuni koʻrsatish';

  @override
  String get signedInLabel => 'Hisobingizga kirgansiz';

  @override
  String get tabLabelRaw => r'$tabCount varaqdan $tabIndex';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => 'VAQTNI TANLANG';

  @override
  String get timePickerHourLabel => 'Soat';

  @override
  String get timePickerHourModeAnnouncement => 'Soatni tanlang';

  @override
  String get timePickerInputHelpText => 'VAQTNI KIRITING';

  @override
  String get timePickerMinuteLabel => 'Daqiqa';

  @override
  String get timePickerMinuteModeAnnouncement => 'Daqiqani tanlang';

  @override
  String get unspecifiedDate => 'Sana';

  @override
  String get unspecifiedDateRange => 'Sana oraligʻi';

  @override
  String get viewLicensesButtonLabel => 'Litsenziyalarni koʻrish';
}

/// The translations for Vietnamese (`vi`).
class MaterialLocalizationVi extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Vietnamese.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationVi({
    String localeName = 'vi',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Giới thiệu về $applicationName';

  @override
  String get alertDialogLabel => 'Thông báo';

  @override
  String get anteMeridiemAbbreviation => 'SÁNG';

  @override
  String get backButtonTooltip => 'Quay lại';

  @override
  String get calendarModeButtonLabel => 'Chuyển sang lịch';

  @override
  String get cancelButtonLabel => 'HỦY';

  @override
  String get closeButtonLabel => 'ĐÓNG';

  @override
  String get closeButtonTooltip => 'Đóng';

  @override
  String get collapsedIconTapHint => 'Mở rộng';

  @override
  String get continueButtonLabel => 'TIẾP TỤC';

  @override
  String get copyButtonLabel => 'Sao chép';

  @override
  String get cutButtonLabel => 'Cắt';

  @override
  String get dateHelpText => 'mm/dd/yyyy';

  @override
  String get dateInputLabel => 'Nhập ngày';

  @override
  String get dateOutOfRangeLabel => 'Ngoài phạm vi.';

  @override
  String get datePickerHelpText => 'CHỌN NGÀY';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Ngày kết thúc $fullDate';

  @override
  String get dateRangeEndLabel => 'Ngày kết thúc';

  @override
  String get dateRangePickerHelpText => 'CHỌN PHẠM VI';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Ngày bắt đầu $fullDate';

  @override
  String get dateRangeStartLabel => 'Ngày bắt đầu';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => 'Xóa';

  @override
  String get dialModeButtonLabel => 'Chuyển sang chế độ chọn mặt đồng hồ';

  @override
  String get dialogLabel => 'Hộp thoại';

  @override
  String get drawerLabel => 'Menu di chuyển';

  @override
  String get expandedIconTapHint => 'Thu gọn';

  @override
  String get firstPageTooltip => 'Trang đầu';

  @override
  String get hideAccountsLabel => 'Ẩn tài khoản';

  @override
  String get inputDateModeButtonLabel => 'Chuyển sang chế độ nhập';

  @override
  String get inputTimeModeButtonLabel => 'Chuyển sang chế độ nhập văn bản';

  @override
  String get invalidDateFormatLabel => 'Định dạng không hợp lệ.';

  @override
  String get invalidDateRangeLabel => 'Phạm vi không hợp lệ.';

  @override
  String get invalidTimeLabel => 'Nhập thời gian hợp lệ';

  @override
  String get lastPageTooltip => 'Trang cuối';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 giấy phép';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount giấy phép';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Giấy phép';

  @override
  String get modalBarrierDismissLabel => 'Bỏ qua';

  @override
  String get moreButtonTooltip => 'Thêm';

  @override
  String get nextMonthTooltip => 'Tháng sau';

  @override
  String get nextPageTooltip => 'Trang tiếp theo';

  @override
  String get okButtonLabel => 'OK';

  @override
  String get openAppDrawerTooltip => 'Mở menu di chuyển';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow trong tổng số $rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow trong tổng số khoảng $rowCount';

  @override
  String get pasteButtonLabel => 'Dán';

  @override
  String get popupMenuLabel => 'Menu bật lên';

  @override
  String get postMeridiemAbbreviation => 'CHIỀU';

  @override
  String get previousMonthTooltip => 'Tháng trước';

  @override
  String get previousPageTooltip => 'Trang trước';

  @override
  String get refreshIndicatorSemanticLabel => 'Làm mới';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => 'Còn lại 1 ký tự';

  @override
  String get remainingTextFieldCharacterCountOther => r'Còn lại $remainingCount ký tự';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => 'Di chuyển xuống';

  @override
  String get reorderItemLeft => 'Di chuyển sang trái';

  @override
  String get reorderItemRight => 'Di chuyển sang phải';

  @override
  String get reorderItemToEnd => 'Di chuyển xuống cuối danh sách';

  @override
  String get reorderItemToStart => 'Di chuyển lên đầu danh sách';

  @override
  String get reorderItemUp => 'Di chuyển lên';

  @override
  String get rowsPerPageTitle => 'Số hàng mỗi trang:';

  @override
  String get saveButtonLabel => 'LƯU';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Tìm kiếm';

  @override
  String get selectAllButtonLabel => 'Chọn tất cả';

  @override
  String get selectYearSemanticsLabel => 'Chọn năm';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => 'Đã chọn 1 mục';

  @override
  String get selectedRowCountTitleOther => r'Đã chọn $selectedRowCount mục';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Hiển thị tài khoản';

  @override
  String get showMenuTooltip => 'Hiển thị menu';

  @override
  String get signedInLabel => 'Đã đăng nhập';

  @override
  String get tabLabelRaw => r'Tab $tabIndex trong tổng số $tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.HH_colon_mm;

  @override
  String get timePickerDialHelpText => 'CHỌN THỜI GIAN';

  @override
  String get timePickerHourLabel => 'Giờ';

  @override
  String get timePickerHourModeAnnouncement => 'Chọn giờ';

  @override
  String get timePickerInputHelpText => 'NHẬP THỜI GIAN';

  @override
  String get timePickerMinuteLabel => 'Phút';

  @override
  String get timePickerMinuteModeAnnouncement => 'Chọn phút';

  @override
  String get unspecifiedDate => 'Ngày';

  @override
  String get unspecifiedDateRange => 'Phạm vi ngày';

  @override
  String get viewLicensesButtonLabel => 'XEM GIẤY PHÉP';
}

/// The translations for Chinese (`zh`).
class MaterialLocalizationZh extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Chinese.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationZh({
    String localeName = 'zh',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'关于$applicationName';

  @override
  String get alertDialogLabel => '提醒';

  @override
  String get anteMeridiemAbbreviation => '上午';

  @override
  String get backButtonTooltip => '返回';

  @override
  String get calendarModeButtonLabel => '切换到日历模式';

  @override
  String get cancelButtonLabel => '取消';

  @override
  String get closeButtonLabel => '关闭';

  @override
  String get closeButtonTooltip => '关闭';

  @override
  String get collapsedIconTapHint => '展开';

  @override
  String get continueButtonLabel => '继续';

  @override
  String get copyButtonLabel => '复制';

  @override
  String get cutButtonLabel => '剪切';

  @override
  String get dateHelpText => 'yyyy/mm/dd';

  @override
  String get dateInputLabel => '输入日期';

  @override
  String get dateOutOfRangeLabel => '超出范围。';

  @override
  String get datePickerHelpText => '选择日期';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'结束日期为 $fullDate';

  @override
  String get dateRangeEndLabel => '结束日期';

  @override
  String get dateRangePickerHelpText => '选择范围';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'开始日期为 $fullDate';

  @override
  String get dateRangeStartLabel => '开始日期';

  @override
  String get dateSeparator => '/';

  @override
  String get deleteButtonTooltip => '删除';

  @override
  String get dialModeButtonLabel => '切换到表盘选择器模式';

  @override
  String get dialogLabel => '对话框';

  @override
  String get drawerLabel => '导航菜单';

  @override
  String get expandedIconTapHint => '收起';

  @override
  String get firstPageTooltip => '第一页';

  @override
  String get hideAccountsLabel => '隐藏帐号';

  @override
  String get inputDateModeButtonLabel => '切换到输入模式';

  @override
  String get inputTimeModeButtonLabel => '切换到文本输入模式';

  @override
  String get invalidDateFormatLabel => '格式无效。';

  @override
  String get invalidDateRangeLabel => '范围无效。';

  @override
  String get invalidTimeLabel => '请输入有效的时间';

  @override
  String get lastPageTooltip => '最后一页';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => '1 份许可';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount 份许可';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => '许可';

  @override
  String get modalBarrierDismissLabel => '关闭';

  @override
  String get moreButtonTooltip => '更多';

  @override
  String get nextMonthTooltip => '下个月';

  @override
  String get nextPageTooltip => '下一页';

  @override
  String get okButtonLabel => '确定';

  @override
  String get openAppDrawerTooltip => '打开导航菜单';

  @override
  String get pageRowsInfoTitleRaw => r'第 $firstRow-$lastRow 行（共 $rowCount 行）';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'第 $firstRow-$lastRow 行（共约 $rowCount 行）';

  @override
  String get pasteButtonLabel => '粘贴';

  @override
  String get popupMenuLabel => '弹出菜单';

  @override
  String get postMeridiemAbbreviation => '下午';

  @override
  String get previousMonthTooltip => '上个月';

  @override
  String get previousPageTooltip => '上一页';

  @override
  String get refreshIndicatorSemanticLabel => '刷新';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '还可输入 1 个字符';

  @override
  String get remainingTextFieldCharacterCountOther => r'还可输入 $remainingCount 个字符';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => 'TBD';

  @override
  String get reorderItemDown => '下移';

  @override
  String get reorderItemLeft => '左移';

  @override
  String get reorderItemRight => '右移';

  @override
  String get reorderItemToEnd => '移到末尾';

  @override
  String get reorderItemToStart => '移到开头';

  @override
  String get reorderItemUp => '上移';

  @override
  String get rowsPerPageTitle => '每页行数：';

  @override
  String get saveButtonLabel => '保存';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.dense;

  @override
  String get searchFieldLabel => '搜索';

  @override
  String get selectAllButtonLabel => '全选';

  @override
  String get selectYearSemanticsLabel => '选择年份';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '已选择 1 项内容';

  @override
  String get selectedRowCountTitleOther => r'已选择 $selectedRowCount 项内容';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => '显示帐号';

  @override
  String get showMenuTooltip => '显示菜单';

  @override
  String get signedInLabel => '已登录';

  @override
  String get tabLabelRaw => r'第 $tabIndex 个标签，共 $tabCount 个';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.a_space_h_colon_mm;

  @override
  String get timePickerDialHelpText => '选择时间';

  @override
  String get timePickerHourLabel => '小时';

  @override
  String get timePickerHourModeAnnouncement => '选择小时';

  @override
  String get timePickerInputHelpText => '输入时间';

  @override
  String get timePickerMinuteLabel => '分钟';

  @override
  String get timePickerMinuteModeAnnouncement => '选择分钟';

  @override
  String get unspecifiedDate => '日期';

  @override
  String get unspecifiedDateRange => '日期范围';

  @override
  String get viewLicensesButtonLabel => '查看许可';
}

/// The translations for Chinese, using the Han script (`zh_Hans`).
class MaterialLocalizationZhHans extends MaterialLocalizationZh {
  /// Create an instance of the translation bundle for Chinese, using the Han script.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationZhHans({
    String localeName = 'zh_Hans',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );
}

/// The translations for Chinese, using the Han script (`zh_Hant`).
class MaterialLocalizationZhHant extends MaterialLocalizationZh {
  /// Create an instance of the translation bundle for Chinese, using the Han script.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationZhHant({
    String localeName = 'zh_Hant',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'關於$applicationName';

  @override
  String get alertDialogLabel => '通知';

  @override
  String get calendarModeButtonLabel => '切換至日曆';

  @override
  String get closeButtonLabel => '關閉';

  @override
  String get closeButtonTooltip => '關閉';

  @override
  String get collapsedIconTapHint => '展開';

  @override
  String get continueButtonLabel => '繼續';

  @override
  String get copyButtonLabel => '複製';

  @override
  String get cutButtonLabel => '剪下';

  @override
  String get dateHelpText => 'dd/mm/yyyy';

  @override
  String get dateInputLabel => '輸入日期';

  @override
  String get dateOutOfRangeLabel => '超出範圍。';

  @override
  String get datePickerHelpText => '選取日期';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'結束日期係 $fullDate';

  @override
  String get dateRangeEndLabel => '結束日期';

  @override
  String get dateRangePickerHelpText => '選取範圍';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'開始日期係 $fullDate';

  @override
  String get dateRangeStartLabel => '開始日期';

  @override
  String get deleteButtonTooltip => '刪除';

  @override
  String get dialModeButtonLabel => '切換至鐘面點選器模式';

  @override
  String get dialogLabel => '對話方塊';

  @override
  String get drawerLabel => '導覽選單';

  @override
  String get expandedIconTapHint => '收合';

  @override
  String get firstPageTooltip => '第一頁';

  @override
  String get hideAccountsLabel => '隱藏帳戶';

  @override
  String get inputDateModeButtonLabel => '切換至輸入';

  @override
  String get inputTimeModeButtonLabel => '切換至文字輸入模式';

  @override
  String get invalidDateFormatLabel => '格式無效。';

  @override
  String get invalidDateRangeLabel => '範圍無效。';

  @override
  String get invalidTimeLabel => '請輸入有效的時間';

  @override
  String get lastPageTooltip => '最後一頁';

  @override
  String? get licensesPackageDetailTextOne => '1 項授權';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount 項授權';

  @override
  String get licensesPageTitle => '授權';

  @override
  String get modalBarrierDismissLabel => '拒絕';

  @override
  String get nextMonthTooltip => '下個月';

  @override
  String get nextPageTooltip => '下一頁';

  @override
  String get okButtonLabel => '確定';

  @override
  String get openAppDrawerTooltip => '開啟導覽選單';

  @override
  String get pageRowsInfoTitleRaw => r'第 $firstRow 至 $lastRow 列，共 $rowCount 列';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'第 $firstRow 至 $lastRow 列，共約 $rowCount 列';

  @override
  String get pasteButtonLabel => '貼上';

  @override
  String get popupMenuLabel => '彈出式選單';

  @override
  String get previousMonthTooltip => '上個月';

  @override
  String get previousPageTooltip => '上一頁';

  @override
  String get refreshIndicatorSemanticLabel => '重新整理';

  @override
  String? get remainingTextFieldCharacterCountOne => '尚餘 1 個字元';

  @override
  String get remainingTextFieldCharacterCountOther => r'尚餘 $remainingCount 個字元';

  @override
  String get reorderItemDown => '向下移';

  @override
  String get reorderItemLeft => '向左移';

  @override
  String get reorderItemRight => '向右移';

  @override
  String get reorderItemToEnd => '移到最後';

  @override
  String get reorderItemToStart => '移到開頭';

  @override
  String get reorderItemUp => '向上移';

  @override
  String get rowsPerPageTitle => '每頁列數：';

  @override
  String get saveButtonLabel => '儲存';

  @override
  String get searchFieldLabel => '搜尋';

  @override
  String get selectAllButtonLabel => '全部選取';

  @override
  String get selectYearSemanticsLabel => '揀年份';

  @override
  String? get selectedRowCountTitleOne => '已選取 1 個項目';

  @override
  String get selectedRowCountTitleOther => r'已選取 $selectedRowCount 個項目';

  @override
  String get showAccountsLabel => '顯示帳戶';

  @override
  String get showMenuTooltip => '顯示選單';

  @override
  String get signedInLabel => '已登入';

  @override
  String get tabLabelRaw => r'第 $tabIndex 個標籤，總共 $tabCount 個';

  @override
  String get timePickerDialHelpText => '選取時間';

  @override
  String get timePickerHourLabel => '小時';

  @override
  String get timePickerHourModeAnnouncement => '揀選小時';

  @override
  String get timePickerInputHelpText => '輸入時間';

  @override
  String get timePickerMinuteLabel => '分鐘';

  @override
  String get timePickerMinuteModeAnnouncement => '揀選分鐘';

  @override
  String get unspecifiedDateRange => '日期範圍';

  @override
  String get viewLicensesButtonLabel => '查看授權';
}

/// The translations for Chinese, as used in Hong Kong, using the Han script (`zh_Hant_HK`).
class MaterialLocalizationZhHantHk extends MaterialLocalizationZhHant {
  /// Create an instance of the translation bundle for Chinese, as used in Hong Kong, using the Han script.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationZhHantHk({
    String localeName = 'zh_Hant_HK',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );
}

/// The translations for Chinese, as used in Taiwan, using the Han script (`zh_Hant_TW`).
class MaterialLocalizationZhHantTw extends MaterialLocalizationZhHant {
  /// Create an instance of the translation bundle for Chinese, as used in Taiwan, using the Han script.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationZhHantTw({
    String localeName = 'zh_Hant_TW',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get dialModeButtonLabel => '切換至鐘面挑選器模式';

  @override
  String? get licensesPackageDetailTextOne => '1 個授權';

  @override
  String get timePickerHourLabel => '時';

  @override
  String get timePickerMinuteLabel => '分';

  @override
  String get licensesPackageDetailTextOther => r'$licenseCount 個授權';

  @override
  String get calendarModeButtonLabel => '切換到日曆模式';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'結束日期為 $fullDate';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'開始日期為 $fullDate';

  @override
  String get inputDateModeButtonLabel => '切換到輸入模式';

  @override
  String get selectYearSemanticsLabel => '選取年份';

  @override
  String get dateHelpText => 'yyyy/mm/dd';

  @override
  String get tabLabelRaw => r'第 $tabIndex 個分頁 (共 $tabCount 個)';

  @override
  String get modalBarrierDismissLabel => '關閉';

  @override
  String get signedInLabel => '已登入帳戶';

  @override
  String get aboutListTileTitleRaw => r'關於「$applicationName」';

  @override
  String get pageRowsInfoTitleRaw => r'第 $firstRow - $lastRow 列 (總共 $rowCount 列)';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'第 $firstRow - $lastRow 列 (總共約 $rowCount 列)';

  @override
  String get selectAllButtonLabel => '全選';

  @override
  String get timePickerHourModeAnnouncement => '選取小時數';

  @override
  String get timePickerMinuteModeAnnouncement => '選取分鐘數';

  @override
  String get alertDialogLabel => '快訊';

  @override
  String get reorderItemToStart => '移至開頭';

  @override
  String get reorderItemToEnd => '移至結尾';

  @override
  String? get remainingTextFieldCharacterCountOne => '還可輸入 1 個字元';

  @override
  String get remainingTextFieldCharacterCountOther => r'還可輸入 $remainingCount 個字元';
}

/// The translations for Zulu (`zu`).
class MaterialLocalizationZu extends GlobalMaterialLocalizations {
  /// Create an instance of the translation bundle for Zulu.
  ///
  /// For details on the meaning of the arguments, see [GlobalMaterialLocalizations].
  const MaterialLocalizationZu({
    String localeName = 'zu',
    required intl.DateFormat fullYearFormat,
    required intl.DateFormat compactDateFormat,
    required intl.DateFormat shortDateFormat,
    required intl.DateFormat mediumDateFormat,
    required intl.DateFormat longDateFormat,
    required intl.DateFormat yearMonthFormat,
    required intl.DateFormat shortMonthDayFormat,
    required intl.NumberFormat decimalFormat,
    required intl.NumberFormat twoDigitZeroPaddedFormat,
  }) : super(
    localeName: localeName,
    fullYearFormat: fullYearFormat,
    compactDateFormat: compactDateFormat,
    shortDateFormat: shortDateFormat,
    mediumDateFormat: mediumDateFormat,
    longDateFormat: longDateFormat,
    yearMonthFormat: yearMonthFormat,
    shortMonthDayFormat: shortMonthDayFormat,
    decimalFormat: decimalFormat,
    twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat,
  );

  @override
  String get aboutListTileTitleRaw => r'Mayelana no-$applicationName';

  @override
  String get alertDialogLabel => 'Isexwayiso';

  @override
  String get anteMeridiemAbbreviation => 'AM';

  @override
  String get backButtonTooltip => 'Emuva';

  @override
  String get calendarModeButtonLabel => 'Shintshela kukhalenda';

  @override
  String get cancelButtonLabel => 'KHANSELA';

  @override
  String get closeButtonLabel => 'VALA';

  @override
  String get closeButtonTooltip => 'Vala';

  @override
  String get collapsedIconTapHint => 'Nweba';

  @override
  String get continueButtonLabel => 'QHUBEKA';

  @override
  String get copyButtonLabel => 'Kopisha';

  @override
  String get cutButtonLabel => 'Sika';

  @override
  String get dateHelpText => 'mm/dd/yyyy';

  @override
  String get dateInputLabel => 'Faka idethi';

  @override
  String get dateOutOfRangeLabel => 'Ikude kubanga.';

  @override
  String get datePickerHelpText => 'KHETHA IDETHI';

  @override
  String get dateRangeEndDateSemanticLabelRaw => r'Idethi yokuphela umhla ka-$fullDate';

  @override
  String get dateRangeEndLabel => 'Idethi yokugcina';

  @override
  String get dateRangePickerHelpText => 'KHETHA IBANGA';

  @override
  String get dateRangeStartDateSemanticLabelRaw => r'Idethi yokuqala umhla ka-$fullDate';

  @override
  String get dateRangeStartLabel => 'Idethi yokuqala';

  @override
  String get dateSeparator => '.';

  @override
  String get deleteButtonTooltip => 'Susa';

  @override
  String get dialModeButtonLabel => 'Shintshela kwimodi yesikhi sokudayela';

  @override
  String get dialogLabel => 'Ingxoxo';

  @override
  String get drawerLabel => 'Imenyu yokuzulazula';

  @override
  String get expandedIconTapHint => 'Goqa';

  @override
  String get firstPageTooltip => 'Ikhasi lokuqala';

  @override
  String get hideAccountsLabel => 'Fihla ama-akhawunti';

  @override
  String get inputDateModeButtonLabel => 'Shintshela kokokufaka';

  @override
  String get inputTimeModeButtonLabel => 'Shintshela kwimodi yokufaka yombhalo';

  @override
  String get invalidDateFormatLabel => 'Ifomethi engavumelekile.';

  @override
  String get invalidDateRangeLabel => 'Ibanga elingavumelekile.';

  @override
  String get invalidTimeLabel => 'Faka igama elivumelekile';

  @override
  String get lastPageTooltip => 'Ikhasi lokugcina';

  @override
  String? get licensesPackageDetailTextFew => null;

  @override
  String? get licensesPackageDetailTextMany => null;

  @override
  String? get licensesPackageDetailTextOne => 'ilayisense e-1';

  @override
  String get licensesPackageDetailTextOther => r'amalayisense angu-$licenseCount';

  @override
  String? get licensesPackageDetailTextTwo => null;

  @override
  String? get licensesPackageDetailTextZero => 'No licenses';

  @override
  String get licensesPageTitle => 'Amalayisense';

  @override
  String get modalBarrierDismissLabel => 'Cashisa';

  @override
  String get moreButtonTooltip => 'Okuningi';

  @override
  String get nextMonthTooltip => 'Inyanga ezayo';

  @override
  String get nextPageTooltip => 'Ikhasi elilandelayo';

  @override
  String get okButtonLabel => 'KULUNGILE';

  @override
  String get openAppDrawerTooltip => 'Vula imenyu yokuzulazula';

  @override
  String get pageRowsInfoTitleRaw => r'$firstRow–$lastRow kokungu-$rowCount';

  @override
  String get pageRowsInfoTitleApproximateRaw => r'$firstRow–$lastRow cishe kokungu-$rowCount';

  @override
  String get pasteButtonLabel => 'Namathisela';

  @override
  String get popupMenuLabel => 'Imenyu ye-popup';

  @override
  String get postMeridiemAbbreviation => 'PM';

  @override
  String get previousMonthTooltip => 'Inyanga edlule';

  @override
  String get previousPageTooltip => 'Ikhasi elidlule';

  @override
  String get refreshIndicatorSemanticLabel => 'Vuselela';

  @override
  String? get remainingTextFieldCharacterCountFew => null;

  @override
  String? get remainingTextFieldCharacterCountMany => null;

  @override
  String? get remainingTextFieldCharacterCountOne => '1 uhlamvu olusele';

  @override
  String get remainingTextFieldCharacterCountOther => r'$remainingCount izinhlamvu ezisele';

  @override
  String? get remainingTextFieldCharacterCountTwo => null;

  @override
  String? get remainingTextFieldCharacterCountZero => null;

  @override
  String get reorderItemDown => 'Iya phansi';

  @override
  String get reorderItemLeft => 'Hambisa kwesokunxele';

  @override
  String get reorderItemRight => 'Yisa kwesokudla';

  @override
  String get reorderItemToEnd => 'Yisa ekugcineni';

  @override
  String get reorderItemToStart => 'Yisa ekuqaleni';

  @override
  String get reorderItemUp => 'Iya phezulu';

  @override
  String get rowsPerPageTitle => 'Imigqa ekhasini ngalinye:';

  @override
  String get saveButtonLabel => 'LONDOLOZA';

  @override
  ScriptCategory get scriptCategory => ScriptCategory.englishLike;

  @override
  String get searchFieldLabel => 'Sesha';

  @override
  String get selectAllButtonLabel => 'Khetha konke';

  @override
  String get selectYearSemanticsLabel => 'Khetha unyaka';

  @override
  String? get selectedRowCountTitleFew => null;

  @override
  String? get selectedRowCountTitleMany => null;

  @override
  String? get selectedRowCountTitleOne => '1 into ekhethiwe';

  @override
  String get selectedRowCountTitleOther => r'$selectedRowCount izinto ezikhethiwe';

  @override
  String? get selectedRowCountTitleTwo => null;

  @override
  String? get selectedRowCountTitleZero => null;

  @override
  String get showAccountsLabel => 'Bonisa ama-akhawunti';

  @override
  String get showMenuTooltip => 'Bonisa imenyu';

  @override
  String get signedInLabel => 'Ungene ngemvume';

  @override
  String get tabLabelRaw => r'Ithebhu $tabIndex kwangu-$tabCount';

  @override
  TimeOfDayFormat get timeOfDayFormatRaw => TimeOfDayFormat.H_colon_mm;

  @override
  String get timePickerDialHelpText => 'KHETHA ISIKHATHI';

  @override
  String get timePickerHourLabel => 'Ihora';

  @override
  String get timePickerHourModeAnnouncement => 'Khetha amahora';

  @override
  String get timePickerInputHelpText => 'FAKA ISIKHATHI';

  @override
  String get timePickerMinuteLabel => 'Iminithi';

  @override
  String get timePickerMinuteModeAnnouncement => 'Khetha amaminithi';

  @override
  String get unspecifiedDate => 'Idethi';

  @override
  String get unspecifiedDateRange => 'Ibanga ledethi';

  @override
  String get viewLicensesButtonLabel => 'Buka amalayisense';
}

/// The set of supported languages, as language code strings.
///
/// The [GlobalMaterialLocalizations.delegate] can generate localizations for
/// any [Locale] with a language code from this set, regardless of the region.
/// Some regions have specific support (e.g. `de` covers all forms of German,
/// but there is support for `de-CH` specifically to override some of the
/// translations for Switzerland).
///
/// See also:
///
///  * [getMaterialTranslation], whose documentation describes these values.
final Set<String> kMaterialSupportedLanguages = HashSet<String>.from(const <String>[
  'af', // Afrikaans
  'am', // Amharic
  'ar', // Arabic
  'as', // Assamese
  'az', // Azerbaijani
  'be', // Belarusian
  'bg', // Bulgarian
  'bn', // Bengali Bangla
  'bs', // Bosnian
  'ca', // Catalan Valencian
  'cs', // Czech
  'da', // Danish
  'de', // German
  'el', // Modern Greek
  'en', // English
  'es', // Spanish Castilian
  'et', // Estonian
  'eu', // Basque
  'fa', // Persian
  'fi', // Finnish
  'fil', // Filipino Pilipino
  'fr', // French
  'gl', // Galician
  'gsw', // Swiss German Alemannic Alsatian
  'gu', // Gujarati
  'he', // Hebrew
  'hi', // Hindi
  'hr', // Croatian
  'hu', // Hungarian
  'hy', // Armenian
  'id', // Indonesian
  'is', // Icelandic
  'it', // Italian
  'ja', // Japanese
  'ka', // Georgian
  'kk', // Kazakh
  'km', // Khmer Central Khmer
  'kn', // Kannada
  'ko', // Korean
  'ky', // Kirghiz Kyrgyz
  'lo', // Lao
  'lt', // Lithuanian
  'lv', // Latvian
  'mk', // Macedonian
  'ml', // Malayalam
  'mn', // Mongolian
  'mr', // Marathi
  'ms', // Malay
  'my', // Burmese
  'nb', // Norwegian Bokmål
  'ne', // Nepali
  'nl', // Dutch Flemish
  'no', // Norwegian
  'or', // Oriya
  'pa', // Panjabi Punjabi
  'pl', // Polish
  'ps', // Pushto Pashto
  'pt', // Portuguese
  'ro', // Romanian Moldavian Moldovan
  'ru', // Russian
  'si', // Sinhala Sinhalese
  'sk', // Slovak
  'sl', // Slovenian
  'sq', // Albanian
  'sr', // Serbian
  'sv', // Swedish
  'sw', // Swahili
  'ta', // Tamil
  'te', // Telugu
  'th', // Thai
  'tl', // Tagalog
  'tr', // Turkish
  'uk', // Ukrainian
  'ur', // Urdu
  'uz', // Uzbek
  'vi', // Vietnamese
  'zh', // Chinese
  'zu', // Zulu
]);

/// Creates a [GlobalMaterialLocalizations] instance for the given `locale`.
///
/// All of the function's arguments except `locale` will be passed to the [
/// GlobalMaterialLocalizations] constructor. (The `localeName` argument of that
/// constructor is specified by the actual subclass constructor by this
/// function.)
///
/// The following locales are supported by this package:
///
/// {@template flutter.localizations.material.languages}
///  * `af` - Afrikaans
///  * `am` - Amharic
///  * `ar` - Arabic
///  * `as` - Assamese
///  * `az` - Azerbaijani
///  * `be` - Belarusian
///  * `bg` - Bulgarian
///  * `bn` - Bengali Bangla
///  * `bs` - Bosnian
///  * `ca` - Catalan Valencian
///  * `cs` - Czech
///  * `da` - Danish
///  * `de` - German (plus one country variation)
///  * `el` - Modern Greek
///  * `en` - English (plus 8 country variations)
///  * `es` - Spanish Castilian (plus 20 country variations)
///  * `et` - Estonian
///  * `eu` - Basque
///  * `fa` - Persian
///  * `fi` - Finnish
///  * `fil` - Filipino Pilipino
///  * `fr` - French (plus one country variation)
///  * `gl` - Galician
///  * `gsw` - Swiss German Alemannic Alsatian
///  * `gu` - Gujarati
///  * `he` - Hebrew
///  * `hi` - Hindi
///  * `hr` - Croatian
///  * `hu` - Hungarian
///  * `hy` - Armenian
///  * `id` - Indonesian
///  * `is` - Icelandic
///  * `it` - Italian
///  * `ja` - Japanese
///  * `ka` - Georgian
///  * `kk` - Kazakh
///  * `km` - Khmer Central Khmer
///  * `kn` - Kannada
///  * `ko` - Korean
///  * `ky` - Kirghiz Kyrgyz
///  * `lo` - Lao
///  * `lt` - Lithuanian
///  * `lv` - Latvian
///  * `mk` - Macedonian
///  * `ml` - Malayalam
///  * `mn` - Mongolian
///  * `mr` - Marathi
///  * `ms` - Malay
///  * `my` - Burmese
///  * `nb` - Norwegian Bokmål
///  * `ne` - Nepali
///  * `nl` - Dutch Flemish
///  * `no` - Norwegian
///  * `or` - Oriya
///  * `pa` - Panjabi Punjabi
///  * `pl` - Polish
///  * `ps` - Pushto Pashto
///  * `pt` - Portuguese (plus one country variation)
///  * `ro` - Romanian Moldavian Moldovan
///  * `ru` - Russian
///  * `si` - Sinhala Sinhalese
///  * `sk` - Slovak
///  * `sl` - Slovenian
///  * `sq` - Albanian
///  * `sr` - Serbian (plus 2 scripts)
///  * `sv` - Swedish
///  * `sw` - Swahili
///  * `ta` - Tamil
///  * `te` - Telugu
///  * `th` - Thai
///  * `tl` - Tagalog
///  * `tr` - Turkish
///  * `uk` - Ukrainian
///  * `ur` - Urdu
///  * `uz` - Uzbek
///  * `vi` - Vietnamese
///  * `zh` - Chinese (plus 2 country variations and 2 scripts)
///  * `zu` - Zulu
/// {@endtemplate}
///
/// Generally speaking, this method is only intended to be used by
/// [GlobalMaterialLocalizations.delegate].
GlobalMaterialLocalizations? getMaterialTranslation(
  Locale locale,
  intl.DateFormat fullYearFormat,
  intl.DateFormat compactDateFormat,
  intl.DateFormat shortDateFormat,
  intl.DateFormat mediumDateFormat,
  intl.DateFormat longDateFormat,
  intl.DateFormat yearMonthFormat,
  intl.DateFormat shortMonthDayFormat,
  intl.NumberFormat decimalFormat,
  intl.NumberFormat twoDigitZeroPaddedFormat,
) {
  switch (locale.languageCode) {
    case 'af':
      return MaterialLocalizationAf(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'am':
      return MaterialLocalizationAm(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ar':
      return MaterialLocalizationAr(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'as':
      return MaterialLocalizationAs(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'az':
      return MaterialLocalizationAz(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'be':
      return MaterialLocalizationBe(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'bg':
      return MaterialLocalizationBg(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'bn':
      return MaterialLocalizationBn(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'bs':
      return MaterialLocalizationBs(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ca':
      return MaterialLocalizationCa(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'cs':
      return MaterialLocalizationCs(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'da':
      return MaterialLocalizationDa(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'de': {
      switch (locale.countryCode) {
        case 'CH':
          return MaterialLocalizationDeCh(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
      }
      return MaterialLocalizationDe(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    }
    case 'el':
      return MaterialLocalizationEl(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'en': {
      switch (locale.countryCode) {
        case 'AU':
          return MaterialLocalizationEnAu(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'CA':
          return MaterialLocalizationEnCa(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'GB':
          return MaterialLocalizationEnGb(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'IE':
          return MaterialLocalizationEnIe(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'IN':
          return MaterialLocalizationEnIn(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'NZ':
          return MaterialLocalizationEnNz(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'SG':
          return MaterialLocalizationEnSg(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'ZA':
          return MaterialLocalizationEnZa(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
      }
      return MaterialLocalizationEn(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    }
    case 'es': {
      switch (locale.countryCode) {
        case '419':
          return MaterialLocalizationEs419(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'AR':
          return MaterialLocalizationEsAr(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'BO':
          return MaterialLocalizationEsBo(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'CL':
          return MaterialLocalizationEsCl(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'CO':
          return MaterialLocalizationEsCo(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'CR':
          return MaterialLocalizationEsCr(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'DO':
          return MaterialLocalizationEsDo(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'EC':
          return MaterialLocalizationEsEc(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'GT':
          return MaterialLocalizationEsGt(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'HN':
          return MaterialLocalizationEsHn(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'MX':
          return MaterialLocalizationEsMx(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'NI':
          return MaterialLocalizationEsNi(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'PA':
          return MaterialLocalizationEsPa(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'PE':
          return MaterialLocalizationEsPe(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'PR':
          return MaterialLocalizationEsPr(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'PY':
          return MaterialLocalizationEsPy(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'SV':
          return MaterialLocalizationEsSv(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'US':
          return MaterialLocalizationEsUs(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'UY':
          return MaterialLocalizationEsUy(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'VE':
          return MaterialLocalizationEsVe(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
      }
      return MaterialLocalizationEs(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    }
    case 'et':
      return MaterialLocalizationEt(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'eu':
      return MaterialLocalizationEu(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'fa':
      return MaterialLocalizationFa(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'fi':
      return MaterialLocalizationFi(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'fil':
      return MaterialLocalizationFil(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'fr': {
      switch (locale.countryCode) {
        case 'CA':
          return MaterialLocalizationFrCa(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
      }
      return MaterialLocalizationFr(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    }
    case 'gl':
      return MaterialLocalizationGl(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'gsw':
      return MaterialLocalizationGsw(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'gu':
      return MaterialLocalizationGu(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'he':
      return MaterialLocalizationHe(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'hi':
      return MaterialLocalizationHi(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'hr':
      return MaterialLocalizationHr(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'hu':
      return MaterialLocalizationHu(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'hy':
      return MaterialLocalizationHy(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'id':
      return MaterialLocalizationId(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'is':
      return MaterialLocalizationIs(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'it':
      return MaterialLocalizationIt(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ja':
      return MaterialLocalizationJa(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ka':
      return MaterialLocalizationKa(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'kk':
      return MaterialLocalizationKk(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'km':
      return MaterialLocalizationKm(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'kn':
      return MaterialLocalizationKn(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ko':
      return MaterialLocalizationKo(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ky':
      return MaterialLocalizationKy(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'lo':
      return MaterialLocalizationLo(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'lt':
      return MaterialLocalizationLt(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'lv':
      return MaterialLocalizationLv(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'mk':
      return MaterialLocalizationMk(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ml':
      return MaterialLocalizationMl(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'mn':
      return MaterialLocalizationMn(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'mr':
      return MaterialLocalizationMr(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ms':
      return MaterialLocalizationMs(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'my':
      return MaterialLocalizationMy(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'nb':
      return MaterialLocalizationNb(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ne':
      return MaterialLocalizationNe(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'nl':
      return MaterialLocalizationNl(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'no':
      return MaterialLocalizationNo(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'or':
      return MaterialLocalizationOr(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'pa':
      return MaterialLocalizationPa(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'pl':
      return MaterialLocalizationPl(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ps':
      return MaterialLocalizationPs(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'pt': {
      switch (locale.countryCode) {
        case 'PT':
          return MaterialLocalizationPtPt(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
      }
      return MaterialLocalizationPt(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    }
    case 'ro':
      return MaterialLocalizationRo(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ru':
      return MaterialLocalizationRu(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'si':
      return MaterialLocalizationSi(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'sk':
      return MaterialLocalizationSk(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'sl':
      return MaterialLocalizationSl(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'sq':
      return MaterialLocalizationSq(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'sr': {
      switch (locale.scriptCode) {
        case 'Cyrl': {
          return MaterialLocalizationSrCyrl(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        }
        case 'Latn': {
          return MaterialLocalizationSrLatn(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        }
      }
      return MaterialLocalizationSr(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    }
    case 'sv':
      return MaterialLocalizationSv(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'sw':
      return MaterialLocalizationSw(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ta':
      return MaterialLocalizationTa(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'te':
      return MaterialLocalizationTe(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'th':
      return MaterialLocalizationTh(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'tl':
      return MaterialLocalizationTl(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'tr':
      return MaterialLocalizationTr(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'uk':
      return MaterialLocalizationUk(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'ur':
      return MaterialLocalizationUr(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'uz':
      return MaterialLocalizationUz(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'vi':
      return MaterialLocalizationVi(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    case 'zh': {
      switch (locale.scriptCode) {
        case 'Hans': {
          return MaterialLocalizationZhHans(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        }
        case 'Hant': {
          switch (locale.countryCode) {
            case 'HK':
              return MaterialLocalizationZhHantHk(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
            case 'TW':
              return MaterialLocalizationZhHantTw(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
          }
          return MaterialLocalizationZhHant(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        }
      }
      switch (locale.countryCode) {
        case 'HK':
          return MaterialLocalizationZhHantHk(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
        case 'TW':
          return MaterialLocalizationZhHantTw(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
      }
      return MaterialLocalizationZh(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
    }
    case 'zu':
      return MaterialLocalizationZu(fullYearFormat: fullYearFormat, compactDateFormat: compactDateFormat, shortDateFormat: shortDateFormat, mediumDateFormat: mediumDateFormat, longDateFormat: longDateFormat, yearMonthFormat: yearMonthFormat, shortMonthDayFormat: shortMonthDayFormat, decimalFormat: decimalFormat, twoDigitZeroPaddedFormat: twoDigitZeroPaddedFormat);
  }
  assert(false, 'getMaterialTranslation() called for unsupported locale "$locale"');
  return null;
}
