// Copyright 2014 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'package:flutter/foundation.dart' show defaultTargetPlatform;
import 'package:flutter/widgets.dart';

// ignore_for_file: non_constant_identifier_names

/// A set of platform-adaptive material design icons.
///
/// Use [Icons.adaptive] to access a static instance of this class.
class PlatformAdaptiveIcons implements Icons {
  const PlatformAdaptiveIcons._();

  static bool _isCupertino() {
    switch (defaultTargetPlatform) {
      case TargetPlatform.android:
      case TargetPlatform.fuchsia:
      case TargetPlatform.linux:
      case TargetPlatform.windows:
        return false;
      case TargetPlatform.iOS:
      case TargetPlatform.macOS:
        return true;
    }
  }

  // Generated code: do not hand-edit.
  // See https://github.com/flutter/flutter/wiki/Updating-Material-Design-Fonts-&-Icons

  // BEGIN GENERATED PLATFORM ADAPTIVE ICONS

  /// Platform-adaptive icon for <i class="material-icons md-36">arrow_back</i> &#x2014; material icon named "arrow back" and <i class="material-icons md-36">arrow_back_ios</i> &#x2014; material icon named "arrow back ios".;
  IconData get arrow_back => !_isCupertino() ? Icons.arrow_back : Icons.arrow_back_ios;

  /// Platform-adaptive icon for <i class="material-icons-outlined md-36">arrow_back</i> &#x2014; material icon named "arrow back" (outlined) and <i class="material-icons-outlined md-36">arrow_back_ios</i> &#x2014; material icon named "arrow back ios" (outlined).;
  IconData get arrow_back_outlined => !_isCupertino() ? Icons.arrow_back_outlined : Icons.arrow_back_ios_outlined;

  /// Platform-adaptive icon for <i class="material-icons-round md-36">arrow_back</i> &#x2014; material icon named "arrow back" (round) and <i class="material-icons-round md-36">arrow_back_ios</i> &#x2014; material icon named "arrow back ios" (round).;
  IconData get arrow_back_rounded => !_isCupertino() ? Icons.arrow_back_rounded : Icons.arrow_back_ios_rounded;

  /// Platform-adaptive icon for <i class="material-icons-sharp md-36">arrow_back</i> &#x2014; material icon named "arrow back" (sharp) and <i class="material-icons-sharp md-36">arrow_back_ios</i> &#x2014; material icon named "arrow back ios" (sharp).;
  IconData get arrow_back_sharp => !_isCupertino() ? Icons.arrow_back_sharp : Icons.arrow_back_ios_sharp;

  /// Platform-adaptive icon for <i class="material-icons md-36">arrow_forward</i> &#x2014; material icon named "arrow forward" and <i class="material-icons md-36">arrow_forward_ios</i> &#x2014; material icon named "arrow forward ios".;
  IconData get arrow_forward => !_isCupertino() ? Icons.arrow_forward : Icons.arrow_forward_ios;

  /// Platform-adaptive icon for <i class="material-icons-outlined md-36">arrow_forward</i> &#x2014; material icon named "arrow forward" (outlined) and <i class="material-icons-outlined md-36">arrow_forward_ios</i> &#x2014; material icon named "arrow forward ios" (outlined).;
  IconData get arrow_forward_outlined => !_isCupertino() ? Icons.arrow_forward_outlined : Icons.arrow_forward_ios_outlined;

  /// Platform-adaptive icon for <i class="material-icons-round md-36">arrow_forward</i> &#x2014; material icon named "arrow forward" (round) and <i class="material-icons-round md-36">arrow_forward_ios</i> &#x2014; material icon named "arrow forward ios" (round).;
  IconData get arrow_forward_rounded => !_isCupertino() ? Icons.arrow_forward_rounded : Icons.arrow_forward_ios_rounded;

  /// Platform-adaptive icon for <i class="material-icons-sharp md-36">arrow_forward</i> &#x2014; material icon named "arrow forward" (sharp) and <i class="material-icons-sharp md-36">arrow_forward_ios</i> &#x2014; material icon named "arrow forward ios" (sharp).;
  IconData get arrow_forward_sharp => !_isCupertino() ? Icons.arrow_forward_sharp : Icons.arrow_forward_ios_sharp;

  /// Platform-adaptive icon for <i class="material-icons md-36">flip_camera_android</i> &#x2014; material icon named "flip camera android" and <i class="material-icons md-36">flip_camera_ios</i> &#x2014; material icon named "flip camera ios".;
  IconData get flip_camera => !_isCupertino() ? Icons.flip_camera_android : Icons.flip_camera_ios;

  /// Platform-adaptive icon for <i class="material-icons-outlined md-36">flip_camera_android</i> &#x2014; material icon named "flip camera android" (outlined) and <i class="material-icons-outlined md-36">flip_camera_ios</i> &#x2014; material icon named "flip camera ios" (outlined).;
  IconData get flip_camera_outlined => !_isCupertino() ? Icons.flip_camera_android_outlined : Icons.flip_camera_ios_outlined;

  /// Platform-adaptive icon for <i class="material-icons-round md-36">flip_camera_android</i> &#x2014; material icon named "flip camera android" (round) and <i class="material-icons-round md-36">flip_camera_ios</i> &#x2014; material icon named "flip camera ios" (round).;
  IconData get flip_camera_rounded => !_isCupertino() ? Icons.flip_camera_android_rounded : Icons.flip_camera_ios_rounded;

  /// Platform-adaptive icon for <i class="material-icons-sharp md-36">flip_camera_android</i> &#x2014; material icon named "flip camera android" (sharp) and <i class="material-icons-sharp md-36">flip_camera_ios</i> &#x2014; material icon named "flip camera ios" (sharp).;
  IconData get flip_camera_sharp => !_isCupertino() ? Icons.flip_camera_android_sharp : Icons.flip_camera_ios_sharp;

  /// Platform-adaptive icon for <i class="material-icons md-36">more_vert</i> &#x2014; material icon named "more vert" and <i class="material-icons md-36">more_horiz</i> &#x2014; material icon named "more horiz".;
  IconData get more => !_isCupertino() ? Icons.more_vert : Icons.more_horiz;

  /// Platform-adaptive icon for <i class="material-icons-outlined md-36">more_vert</i> &#x2014; material icon named "more vert" (outlined) and <i class="material-icons-outlined md-36">more_horiz</i> &#x2014; material icon named "more horiz" (outlined).;
  IconData get more_outlined => !_isCupertino() ? Icons.more_vert_outlined : Icons.more_horiz_outlined;

  /// Platform-adaptive icon for <i class="material-icons-round md-36">more_vert</i> &#x2014; material icon named "more vert" (round) and <i class="material-icons-round md-36">more_horiz</i> &#x2014; material icon named "more horiz" (round).;
  IconData get more_rounded => !_isCupertino() ? Icons.more_vert_rounded : Icons.more_horiz_rounded;

  /// Platform-adaptive icon for <i class="material-icons-sharp md-36">more_vert</i> &#x2014; material icon named "more vert" (sharp) and <i class="material-icons-sharp md-36">more_horiz</i> &#x2014; material icon named "more horiz" (sharp).;
  IconData get more_sharp => !_isCupertino() ? Icons.more_vert_sharp : Icons.more_horiz_sharp;

  /// Platform-adaptive icon for <i class="material-icons md-36">share</i> &#x2014; material icon named "share" and <i class="material-icons md-36">ios_share</i> &#x2014; material icon named "ios share".;
  IconData get share => !_isCupertino() ? Icons.share : Icons.ios_share;

  /// Platform-adaptive icon for <i class="material-icons-outlined md-36">share</i> &#x2014; material icon named "share" (outlined) and <i class="material-icons-outlined md-36">ios_share</i> &#x2014; material icon named "ios share" (outlined).;
  IconData get share_outlined => !_isCupertino() ? Icons.share_outlined : Icons.ios_share_outlined;

  /// Platform-adaptive icon for <i class="material-icons-round md-36">share</i> &#x2014; material icon named "share" (round) and <i class="material-icons-round md-36">ios_share</i> &#x2014; material icon named "ios share" (round).;
  IconData get share_rounded => !_isCupertino() ? Icons.share_rounded : Icons.ios_share_rounded;

  /// Platform-adaptive icon for <i class="material-icons-sharp md-36">share</i> &#x2014; material icon named "share" (sharp) and <i class="material-icons-sharp md-36">ios_share</i> &#x2014; material icon named "ios share" (sharp).;
  IconData get share_sharp => !_isCupertino() ? Icons.share_sharp : Icons.ios_share_sharp;
  // END GENERATED PLATFORM ADAPTIVE ICONS
}

/// Identifiers for the supported material design icons.
///
/// Use with the [Icon] class to show specific icons.
///
/// Icons are identified by their name as listed below. **Do not use codepoints
/// directly, as they are subject to change.**
///
/// To use this class, make sure you set `uses-material-design: true` in your
/// project's `pubspec.yaml` file in the `flutter` section. This ensures that
/// the MaterialIcons font is included in your application. This font is used to
/// display the icons. For example:
///
/// ```yaml
/// name: my_awesome_application
/// flutter:
///   uses-material-design: true
/// ```
///
/// {@tool snippet}
/// This example shows how to create a [Row] of [Icon]s in different colors and
/// sizes. The first [Icon] uses a [Icon.semanticLabel] to announce in accessibility
/// modes like TalkBack and VoiceOver.
///
/// ![The following code snippet would generate a row of icons consisting of a pink heart, a green musical note, and a blue umbrella, each progressively bigger than the last.](https://flutter.github.io/assets-for-api-docs/assets/widgets/icon.png)
///
/// ```dart
/// Row(
///   mainAxisAlignment: MainAxisAlignment.spaceAround,
///   children: const <Widget>[
///     Icon(
///       Icons.favorite,
///       color: Colors.pink,
///       size: 24.0,
///       semanticLabel: 'Text to announce in accessibility modes',
///     ),
///     Icon(
///       Icons.audiotrack,
///       color: Colors.green,
///       size: 30.0,
///     ),
///     Icon(
///       Icons.beach_access,
///       color: Colors.blue,
///       size: 36.0,
///     ),
///   ],
/// )
/// ```
/// {@end-tool}
///
/// See also:
///
///  * [Icon]
///  * [IconButton]
///  * <https://material.io/resources/icons>
class Icons {
  // This class is not meant to be instantiated or extended; this constructor
  // prevents instantiation and extension.
  Icons._();

  /// A set of platform-adaptive material design icons.
  ///
  /// Provides a convenient way to show a certain set of platform-appropriate
  /// icons on Apple platforms.
  ///
  /// Use with the [Icon] class to show specific icons.
  ///
  /// {@tool snippet}
  /// This example shows how to create a share icon that uses the material icon
  /// named "share" on non-Apple platforms, and the icon named "ios share" on
  /// Apple platforms.
  ///
  /// ```dart
  /// Icon(
  ///   Icons.adaptive.share,
  /// )
  /// ```
  /// {@end-tool}
  ///
  /// See also:
  ///
  ///  * [Icon]
  ///  * [IconButton]
  ///  * <https://design.google.com/icons/>
  static PlatformAdaptiveIcons get adaptive => const PlatformAdaptiveIcons._();

  // Generated code: do not hand-edit.
  // See https://github.com/flutter/flutter/wiki/Updating-Material-Design-Fonts-&-Icons
  // BEGIN GENERATED ICONS

  /// <i class="material-icons md-36">10k</i> &#x2014; material icon named "10k".
  static const IconData ten_k = IconData(0xe000, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">10k</i> &#x2014; material icon named "10k" (sharp).
  static const IconData ten_k_sharp = IconData(0xe700, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">10k</i> &#x2014; material icon named "10k" (round).
  static const IconData ten_k_rounded = IconData(0xf4df, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">10k</i> &#x2014; material icon named "10k" (outlined).
  static const IconData ten_k_outlined = IconData(0xedf2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">10mp</i> &#x2014; material icon named "10mp".
  static const IconData ten_mp = IconData(0xe001, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">10mp</i> &#x2014; material icon named "10mp" (sharp).
  static const IconData ten_mp_sharp = IconData(0xe701, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">10mp</i> &#x2014; material icon named "10mp" (round).
  static const IconData ten_mp_rounded = IconData(0xf4e0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">10mp</i> &#x2014; material icon named "10mp" (outlined).
  static const IconData ten_mp_outlined = IconData(0xedf3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">11mp</i> &#x2014; material icon named "11mp".
  static const IconData eleven_mp = IconData(0xe002, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">11mp</i> &#x2014; material icon named "11mp" (sharp).
  static const IconData eleven_mp_sharp = IconData(0xe702, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">11mp</i> &#x2014; material icon named "11mp" (round).
  static const IconData eleven_mp_rounded = IconData(0xf4e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">11mp</i> &#x2014; material icon named "11mp" (outlined).
  static const IconData eleven_mp_outlined = IconData(0xedf4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">12mp</i> &#x2014; material icon named "12mp".
  static const IconData twelve_mp = IconData(0xe003, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">12mp</i> &#x2014; material icon named "12mp" (sharp).
  static const IconData twelve_mp_sharp = IconData(0xe703, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">12mp</i> &#x2014; material icon named "12mp" (round).
  static const IconData twelve_mp_rounded = IconData(0xf4e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">12mp</i> &#x2014; material icon named "12mp" (outlined).
  static const IconData twelve_mp_outlined = IconData(0xedf5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">13mp</i> &#x2014; material icon named "13mp".
  static const IconData thirteen_mp = IconData(0xe004, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">13mp</i> &#x2014; material icon named "13mp" (sharp).
  static const IconData thirteen_mp_sharp = IconData(0xe704, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">13mp</i> &#x2014; material icon named "13mp" (round).
  static const IconData thirteen_mp_rounded = IconData(0xf4e3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">13mp</i> &#x2014; material icon named "13mp" (outlined).
  static const IconData thirteen_mp_outlined = IconData(0xedf6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">14mp</i> &#x2014; material icon named "14mp".
  static const IconData fourteen_mp = IconData(0xe005, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">14mp</i> &#x2014; material icon named "14mp" (sharp).
  static const IconData fourteen_mp_sharp = IconData(0xe705, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">14mp</i> &#x2014; material icon named "14mp" (round).
  static const IconData fourteen_mp_rounded = IconData(0xf4e4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">14mp</i> &#x2014; material icon named "14mp" (outlined).
  static const IconData fourteen_mp_outlined = IconData(0xedf7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">15mp</i> &#x2014; material icon named "15mp".
  static const IconData fifteen_mp = IconData(0xe006, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">15mp</i> &#x2014; material icon named "15mp" (sharp).
  static const IconData fifteen_mp_sharp = IconData(0xe706, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">15mp</i> &#x2014; material icon named "15mp" (round).
  static const IconData fifteen_mp_rounded = IconData(0xf4e5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">15mp</i> &#x2014; material icon named "15mp" (outlined).
  static const IconData fifteen_mp_outlined = IconData(0xedf8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">16mp</i> &#x2014; material icon named "16mp".
  static const IconData sixteen_mp = IconData(0xe007, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">16mp</i> &#x2014; material icon named "16mp" (sharp).
  static const IconData sixteen_mp_sharp = IconData(0xe707, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">16mp</i> &#x2014; material icon named "16mp" (round).
  static const IconData sixteen_mp_rounded = IconData(0xf4e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">16mp</i> &#x2014; material icon named "16mp" (outlined).
  static const IconData sixteen_mp_outlined = IconData(0xedf9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">17mp</i> &#x2014; material icon named "17mp".
  static const IconData seventeen_mp = IconData(0xe008, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">17mp</i> &#x2014; material icon named "17mp" (sharp).
  static const IconData seventeen_mp_sharp = IconData(0xe708, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">17mp</i> &#x2014; material icon named "17mp" (round).
  static const IconData seventeen_mp_rounded = IconData(0xf4e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">17mp</i> &#x2014; material icon named "17mp" (outlined).
  static const IconData seventeen_mp_outlined = IconData(0xedfa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">18mp</i> &#x2014; material icon named "18mp".
  static const IconData eighteen_mp = IconData(0xe009, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">18mp</i> &#x2014; material icon named "18mp" (sharp).
  static const IconData eighteen_mp_sharp = IconData(0xe709, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">18mp</i> &#x2014; material icon named "18mp" (round).
  static const IconData eighteen_mp_rounded = IconData(0xf4e8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">18mp</i> &#x2014; material icon named "18mp" (outlined).
  static const IconData eighteen_mp_outlined = IconData(0xedfb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">19mp</i> &#x2014; material icon named "19mp".
  static const IconData nineteen_mp = IconData(0xe00a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">19mp</i> &#x2014; material icon named "19mp" (sharp).
  static const IconData nineteen_mp_sharp = IconData(0xe70a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">19mp</i> &#x2014; material icon named "19mp" (round).
  static const IconData nineteen_mp_rounded = IconData(0xf4e9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">19mp</i> &#x2014; material icon named "19mp" (outlined).
  static const IconData nineteen_mp_outlined = IconData(0xedfc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">1k</i> &#x2014; material icon named "1k".
  static const IconData one_k = IconData(0xe00b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">1k</i> &#x2014; material icon named "1k" (sharp).
  static const IconData one_k_sharp = IconData(0xe70c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">1k</i> &#x2014; material icon named "1k" (round).
  static const IconData one_k_rounded = IconData(0xf4eb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">1k</i> &#x2014; material icon named "1k" (outlined).
  static const IconData one_k_outlined = IconData(0xedfd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">1k_plus</i> &#x2014; material icon named "1k plus".
  static const IconData one_k_plus = IconData(0xe00c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">1k_plus</i> &#x2014; material icon named "1k plus" (sharp).
  static const IconData one_k_plus_sharp = IconData(0xe70b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">1k_plus</i> &#x2014; material icon named "1k plus" (round).
  static const IconData one_k_plus_rounded = IconData(0xf4ea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">1k_plus</i> &#x2014; material icon named "1k plus" (outlined).
  static const IconData one_k_plus_outlined = IconData(0xedfe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">1x_mobiledata</i> &#x2014; material icon named "1x mobiledata".
  static const IconData one_x_mobiledata = IconData(0xe00d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">1x_mobiledata</i> &#x2014; material icon named "1x mobiledata" (sharp).
  static const IconData one_x_mobiledata_sharp = IconData(0xe70d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">1x_mobiledata</i> &#x2014; material icon named "1x mobiledata" (round).
  static const IconData one_x_mobiledata_rounded = IconData(0xf4ec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">1x_mobiledata</i> &#x2014; material icon named "1x mobiledata" (outlined).
  static const IconData one_x_mobiledata_outlined = IconData(0xedff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">20mp</i> &#x2014; material icon named "20mp".
  static const IconData twenty_mp = IconData(0xe00e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">20mp</i> &#x2014; material icon named "20mp" (sharp).
  static const IconData twenty_mp_sharp = IconData(0xe70e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">20mp</i> &#x2014; material icon named "20mp" (round).
  static const IconData twenty_mp_rounded = IconData(0xf4ed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">20mp</i> &#x2014; material icon named "20mp" (outlined).
  static const IconData twenty_mp_outlined = IconData(0xee00, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">21mp</i> &#x2014; material icon named "21mp".
  static const IconData twenty_one_mp = IconData(0xe00f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">21mp</i> &#x2014; material icon named "21mp" (sharp).
  static const IconData twenty_one_mp_sharp = IconData(0xe70f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">21mp</i> &#x2014; material icon named "21mp" (round).
  static const IconData twenty_one_mp_rounded = IconData(0xf4ee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">21mp</i> &#x2014; material icon named "21mp" (outlined).
  static const IconData twenty_one_mp_outlined = IconData(0xee01, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">22mp</i> &#x2014; material icon named "22mp".
  static const IconData twenty_two_mp = IconData(0xe010, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">22mp</i> &#x2014; material icon named "22mp" (sharp).
  static const IconData twenty_two_mp_sharp = IconData(0xe710, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">22mp</i> &#x2014; material icon named "22mp" (round).
  static const IconData twenty_two_mp_rounded = IconData(0xf4ef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">22mp</i> &#x2014; material icon named "22mp" (outlined).
  static const IconData twenty_two_mp_outlined = IconData(0xee02, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">23mp</i> &#x2014; material icon named "23mp".
  static const IconData twenty_three_mp = IconData(0xe011, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">23mp</i> &#x2014; material icon named "23mp" (sharp).
  static const IconData twenty_three_mp_sharp = IconData(0xe711, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">23mp</i> &#x2014; material icon named "23mp" (round).
  static const IconData twenty_three_mp_rounded = IconData(0xf4f0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">23mp</i> &#x2014; material icon named "23mp" (outlined).
  static const IconData twenty_three_mp_outlined = IconData(0xee03, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">24mp</i> &#x2014; material icon named "24mp".
  static const IconData twenty_four_mp = IconData(0xe012, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">24mp</i> &#x2014; material icon named "24mp" (sharp).
  static const IconData twenty_four_mp_sharp = IconData(0xe712, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">24mp</i> &#x2014; material icon named "24mp" (round).
  static const IconData twenty_four_mp_rounded = IconData(0xf4f1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">24mp</i> &#x2014; material icon named "24mp" (outlined).
  static const IconData twenty_four_mp_outlined = IconData(0xee04, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">2k</i> &#x2014; material icon named "2k".
  static const IconData two_k = IconData(0xe013, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">2k</i> &#x2014; material icon named "2k" (sharp).
  static const IconData two_k_sharp = IconData(0xe714, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">2k</i> &#x2014; material icon named "2k" (round).
  static const IconData two_k_rounded = IconData(0xf4f3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">2k</i> &#x2014; material icon named "2k" (outlined).
  static const IconData two_k_outlined = IconData(0xee05, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">2k_plus</i> &#x2014; material icon named "2k plus".
  static const IconData two_k_plus = IconData(0xe014, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">2k_plus</i> &#x2014; material icon named "2k plus" (sharp).
  static const IconData two_k_plus_sharp = IconData(0xe713, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">2k_plus</i> &#x2014; material icon named "2k plus" (round).
  static const IconData two_k_plus_rounded = IconData(0xf4f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">2k_plus</i> &#x2014; material icon named "2k plus" (outlined).
  static const IconData two_k_plus_outlined = IconData(0xee06, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">2mp</i> &#x2014; material icon named "2mp".
  static const IconData two_mp = IconData(0xe015, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">2mp</i> &#x2014; material icon named "2mp" (sharp).
  static const IconData two_mp_sharp = IconData(0xe715, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">2mp</i> &#x2014; material icon named "2mp" (round).
  static const IconData two_mp_rounded = IconData(0xf4f4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">2mp</i> &#x2014; material icon named "2mp" (outlined).
  static const IconData two_mp_outlined = IconData(0xee07, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">30fps</i> &#x2014; material icon named "30fps".
  static const IconData thirty_fps = IconData(0xe016, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">30fps</i> &#x2014; material icon named "30fps" (sharp).
  static const IconData thirty_fps_sharp = IconData(0xe717, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">30fps</i> &#x2014; material icon named "30fps" (round).
  static const IconData thirty_fps_rounded = IconData(0xf4f5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">30fps</i> &#x2014; material icon named "30fps" (outlined).
  static const IconData thirty_fps_outlined = IconData(0xee08, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">30fps_select</i> &#x2014; material icon named "30fps select".
  static const IconData thirty_fps_select = IconData(0xe017, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">30fps_select</i> &#x2014; material icon named "30fps select" (sharp).
  static const IconData thirty_fps_select_sharp = IconData(0xe716, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">30fps_select</i> &#x2014; material icon named "30fps select" (round).
  static const IconData thirty_fps_select_rounded = IconData(0xf4f6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">30fps_select</i> &#x2014; material icon named "30fps select" (outlined).
  static const IconData thirty_fps_select_outlined = IconData(0xee09, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">360</i> &#x2014; material icon named "360".
  static const IconData threesixty = IconData(0xe018, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">360</i> &#x2014; material icon named "360" (sharp).
  static const IconData threesixty_sharp = IconData(0xe718, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">360</i> &#x2014; material icon named "360" (round).
  static const IconData threesixty_rounded = IconData(0xf4f7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">360</i> &#x2014; material icon named "360" (outlined).
  static const IconData threesixty_outlined = IconData(0xee0a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">3d_rotation</i> &#x2014; material icon named "3d rotation".
  static const IconData threed_rotation = IconData(0xe019, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">3d_rotation</i> &#x2014; material icon named "3d rotation" (sharp).
  static const IconData threed_rotation_sharp = IconData(0xe719, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">3d_rotation</i> &#x2014; material icon named "3d rotation" (round).
  static const IconData threed_rotation_rounded = IconData(0xf4f8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">3d_rotation</i> &#x2014; material icon named "3d rotation" (outlined).
  static const IconData threed_rotation_outlined = IconData(0xee0b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">3g_mobiledata</i> &#x2014; material icon named "3g mobiledata".
  static const IconData three_g_mobiledata = IconData(0xe01a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">3g_mobiledata</i> &#x2014; material icon named "3g mobiledata" (sharp).
  static const IconData three_g_mobiledata_sharp = IconData(0xe71a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">3g_mobiledata</i> &#x2014; material icon named "3g mobiledata" (round).
  static const IconData three_g_mobiledata_rounded = IconData(0xf4f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">3g_mobiledata</i> &#x2014; material icon named "3g mobiledata" (outlined).
  static const IconData three_g_mobiledata_outlined = IconData(0xee0c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">3k</i> &#x2014; material icon named "3k".
  static const IconData three_k = IconData(0xe01b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">3k</i> &#x2014; material icon named "3k" (sharp).
  static const IconData three_k_sharp = IconData(0xe71c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">3k</i> &#x2014; material icon named "3k" (round).
  static const IconData three_k_rounded = IconData(0xf4fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">3k</i> &#x2014; material icon named "3k" (outlined).
  static const IconData three_k_outlined = IconData(0xee0d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">3k_plus</i> &#x2014; material icon named "3k plus".
  static const IconData three_k_plus = IconData(0xe01c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">3k_plus</i> &#x2014; material icon named "3k plus" (sharp).
  static const IconData three_k_plus_sharp = IconData(0xe71b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">3k_plus</i> &#x2014; material icon named "3k plus" (round).
  static const IconData three_k_plus_rounded = IconData(0xf4fa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">3k_plus</i> &#x2014; material icon named "3k plus" (outlined).
  static const IconData three_k_plus_outlined = IconData(0xee0e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">3mp</i> &#x2014; material icon named "3mp".
  static const IconData three_mp = IconData(0xe01d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">3mp</i> &#x2014; material icon named "3mp" (sharp).
  static const IconData three_mp_sharp = IconData(0xe71d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">3mp</i> &#x2014; material icon named "3mp" (round).
  static const IconData three_mp_rounded = IconData(0xf4fc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">3mp</i> &#x2014; material icon named "3mp" (outlined).
  static const IconData three_mp_outlined = IconData(0xee0f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">3p</i> &#x2014; material icon named "3p".
  static const IconData three_p = IconData(0xe01e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">3p</i> &#x2014; material icon named "3p" (sharp).
  static const IconData three_p_sharp = IconData(0xe71e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">3p</i> &#x2014; material icon named "3p" (round).
  static const IconData three_p_rounded = IconData(0xf4fd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">3p</i> &#x2014; material icon named "3p" (outlined).
  static const IconData three_p_outlined = IconData(0xee10, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">4g_mobiledata</i> &#x2014; material icon named "4g mobiledata".
  static const IconData four_g_mobiledata = IconData(0xe01f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">4g_mobiledata</i> &#x2014; material icon named "4g mobiledata" (sharp).
  static const IconData four_g_mobiledata_sharp = IconData(0xe71f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">4g_mobiledata</i> &#x2014; material icon named "4g mobiledata" (round).
  static const IconData four_g_mobiledata_rounded = IconData(0xf4fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">4g_mobiledata</i> &#x2014; material icon named "4g mobiledata" (outlined).
  static const IconData four_g_mobiledata_outlined = IconData(0xee11, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">4g_plus_mobiledata</i> &#x2014; material icon named "4g plus mobiledata".
  static const IconData four_g_plus_mobiledata = IconData(0xe020, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">4g_plus_mobiledata</i> &#x2014; material icon named "4g plus mobiledata" (sharp).
  static const IconData four_g_plus_mobiledata_sharp = IconData(0xe720, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">4g_plus_mobiledata</i> &#x2014; material icon named "4g plus mobiledata" (round).
  static const IconData four_g_plus_mobiledata_rounded = IconData(0xf4ff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">4g_plus_mobiledata</i> &#x2014; material icon named "4g plus mobiledata" (outlined).
  static const IconData four_g_plus_mobiledata_outlined = IconData(0xee12, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">4k</i> &#x2014; material icon named "4k".
  static const IconData four_k = IconData(0xe021, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">4k</i> &#x2014; material icon named "4k" (sharp).
  static const IconData four_k_sharp = IconData(0xe722, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">4k</i> &#x2014; material icon named "4k" (round).
  static const IconData four_k_rounded = IconData(0xf501, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">4k</i> &#x2014; material icon named "4k" (outlined).
  static const IconData four_k_outlined = IconData(0xee13, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">4k_plus</i> &#x2014; material icon named "4k plus".
  static const IconData four_k_plus = IconData(0xe022, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">4k_plus</i> &#x2014; material icon named "4k plus" (sharp).
  static const IconData four_k_plus_sharp = IconData(0xe721, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">4k_plus</i> &#x2014; material icon named "4k plus" (round).
  static const IconData four_k_plus_rounded = IconData(0xf500, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">4k_plus</i> &#x2014; material icon named "4k plus" (outlined).
  static const IconData four_k_plus_outlined = IconData(0xee14, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">4mp</i> &#x2014; material icon named "4mp".
  static const IconData four_mp = IconData(0xe023, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">4mp</i> &#x2014; material icon named "4mp" (sharp).
  static const IconData four_mp_sharp = IconData(0xe723, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">4mp</i> &#x2014; material icon named "4mp" (round).
  static const IconData four_mp_rounded = IconData(0xf502, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">4mp</i> &#x2014; material icon named "4mp" (outlined).
  static const IconData four_mp_outlined = IconData(0xee15, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">5g</i> &#x2014; material icon named "5g".
  static const IconData five_g = IconData(0xe024, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">5g</i> &#x2014; material icon named "5g" (sharp).
  static const IconData five_g_sharp = IconData(0xe724, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">5g</i> &#x2014; material icon named "5g" (round).
  static const IconData five_g_rounded = IconData(0xf503, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">5g</i> &#x2014; material icon named "5g" (outlined).
  static const IconData five_g_outlined = IconData(0xee16, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">5k</i> &#x2014; material icon named "5k".
  static const IconData five_k = IconData(0xe025, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">5k</i> &#x2014; material icon named "5k" (sharp).
  static const IconData five_k_sharp = IconData(0xe726, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">5k</i> &#x2014; material icon named "5k" (round).
  static const IconData five_k_rounded = IconData(0xf505, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">5k</i> &#x2014; material icon named "5k" (outlined).
  static const IconData five_k_outlined = IconData(0xee17, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">5k_plus</i> &#x2014; material icon named "5k plus".
  static const IconData five_k_plus = IconData(0xe026, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">5k_plus</i> &#x2014; material icon named "5k plus" (sharp).
  static const IconData five_k_plus_sharp = IconData(0xe725, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">5k_plus</i> &#x2014; material icon named "5k plus" (round).
  static const IconData five_k_plus_rounded = IconData(0xf504, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">5k_plus</i> &#x2014; material icon named "5k plus" (outlined).
  static const IconData five_k_plus_outlined = IconData(0xee18, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">5mp</i> &#x2014; material icon named "5mp".
  static const IconData five_mp = IconData(0xe027, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">5mp</i> &#x2014; material icon named "5mp" (sharp).
  static const IconData five_mp_sharp = IconData(0xe727, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">5mp</i> &#x2014; material icon named "5mp" (round).
  static const IconData five_mp_rounded = IconData(0xf506, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">5mp</i> &#x2014; material icon named "5mp" (outlined).
  static const IconData five_mp_outlined = IconData(0xee19, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">60fps</i> &#x2014; material icon named "60fps".
  static const IconData sixty_fps = IconData(0xe028, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">60fps</i> &#x2014; material icon named "60fps" (sharp).
  static const IconData sixty_fps_sharp = IconData(0xe729, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">60fps</i> &#x2014; material icon named "60fps" (round).
  static const IconData sixty_fps_rounded = IconData(0xf507, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">60fps</i> &#x2014; material icon named "60fps" (outlined).
  static const IconData sixty_fps_outlined = IconData(0xee1a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">60fps_select</i> &#x2014; material icon named "60fps select".
  static const IconData sixty_fps_select = IconData(0xe029, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">60fps_select</i> &#x2014; material icon named "60fps select" (sharp).
  static const IconData sixty_fps_select_sharp = IconData(0xe728, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">60fps_select</i> &#x2014; material icon named "60fps select" (round).
  static const IconData sixty_fps_select_rounded = IconData(0xf508, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">60fps_select</i> &#x2014; material icon named "60fps select" (outlined).
  static const IconData sixty_fps_select_outlined = IconData(0xee1b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">6_ft_apart</i> &#x2014; material icon named "6 ft apart".
  static const IconData six__ft_apart = IconData(0xe02a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">6_ft_apart</i> &#x2014; material icon named "6 ft apart" (sharp).
  static const IconData six__ft_apart_sharp = IconData(0xe72a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">6_ft_apart</i> &#x2014; material icon named "6 ft apart" (round).
  static const IconData six__ft_apart_rounded = IconData(0xf509, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">6_ft_apart</i> &#x2014; material icon named "6 ft apart" (outlined).
  static const IconData six__ft_apart_outlined = IconData(0xee1c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">6k</i> &#x2014; material icon named "6k".
  static const IconData six_k = IconData(0xe02b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">6k</i> &#x2014; material icon named "6k" (sharp).
  static const IconData six_k_sharp = IconData(0xe72c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">6k</i> &#x2014; material icon named "6k" (round).
  static const IconData six_k_rounded = IconData(0xf50b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">6k</i> &#x2014; material icon named "6k" (outlined).
  static const IconData six_k_outlined = IconData(0xee1d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">6k_plus</i> &#x2014; material icon named "6k plus".
  static const IconData six_k_plus = IconData(0xe02c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">6k_plus</i> &#x2014; material icon named "6k plus" (sharp).
  static const IconData six_k_plus_sharp = IconData(0xe72b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">6k_plus</i> &#x2014; material icon named "6k plus" (round).
  static const IconData six_k_plus_rounded = IconData(0xf50a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">6k_plus</i> &#x2014; material icon named "6k plus" (outlined).
  static const IconData six_k_plus_outlined = IconData(0xee1e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">6mp</i> &#x2014; material icon named "6mp".
  static const IconData six_mp = IconData(0xe02d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">6mp</i> &#x2014; material icon named "6mp" (sharp).
  static const IconData six_mp_sharp = IconData(0xe72d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">6mp</i> &#x2014; material icon named "6mp" (round).
  static const IconData six_mp_rounded = IconData(0xf50c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">6mp</i> &#x2014; material icon named "6mp" (outlined).
  static const IconData six_mp_outlined = IconData(0xee1f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">7k</i> &#x2014; material icon named "7k".
  static const IconData seven_k = IconData(0xe02e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">7k</i> &#x2014; material icon named "7k" (sharp).
  static const IconData seven_k_sharp = IconData(0xe72f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">7k</i> &#x2014; material icon named "7k" (round).
  static const IconData seven_k_rounded = IconData(0xf50e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">7k</i> &#x2014; material icon named "7k" (outlined).
  static const IconData seven_k_outlined = IconData(0xee20, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">7k_plus</i> &#x2014; material icon named "7k plus".
  static const IconData seven_k_plus = IconData(0xe02f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">7k_plus</i> &#x2014; material icon named "7k plus" (sharp).
  static const IconData seven_k_plus_sharp = IconData(0xe72e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">7k_plus</i> &#x2014; material icon named "7k plus" (round).
  static const IconData seven_k_plus_rounded = IconData(0xf50d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">7k_plus</i> &#x2014; material icon named "7k plus" (outlined).
  static const IconData seven_k_plus_outlined = IconData(0xee21, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">7mp</i> &#x2014; material icon named "7mp".
  static const IconData seven_mp = IconData(0xe030, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">7mp</i> &#x2014; material icon named "7mp" (sharp).
  static const IconData seven_mp_sharp = IconData(0xe730, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">7mp</i> &#x2014; material icon named "7mp" (round).
  static const IconData seven_mp_rounded = IconData(0xf50f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">7mp</i> &#x2014; material icon named "7mp" (outlined).
  static const IconData seven_mp_outlined = IconData(0xee22, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">8k</i> &#x2014; material icon named "8k".
  static const IconData eight_k = IconData(0xe031, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">8k</i> &#x2014; material icon named "8k" (sharp).
  static const IconData eight_k_sharp = IconData(0xe732, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">8k</i> &#x2014; material icon named "8k" (round).
  static const IconData eight_k_rounded = IconData(0xf511, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">8k</i> &#x2014; material icon named "8k" (outlined).
  static const IconData eight_k_outlined = IconData(0xee23, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">8k_plus</i> &#x2014; material icon named "8k plus".
  static const IconData eight_k_plus = IconData(0xe032, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">8k_plus</i> &#x2014; material icon named "8k plus" (sharp).
  static const IconData eight_k_plus_sharp = IconData(0xe731, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">8k_plus</i> &#x2014; material icon named "8k plus" (round).
  static const IconData eight_k_plus_rounded = IconData(0xf510, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">8k_plus</i> &#x2014; material icon named "8k plus" (outlined).
  static const IconData eight_k_plus_outlined = IconData(0xee24, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">8mp</i> &#x2014; material icon named "8mp".
  static const IconData eight_mp = IconData(0xe033, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">8mp</i> &#x2014; material icon named "8mp" (sharp).
  static const IconData eight_mp_sharp = IconData(0xe733, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">8mp</i> &#x2014; material icon named "8mp" (round).
  static const IconData eight_mp_rounded = IconData(0xf512, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">8mp</i> &#x2014; material icon named "8mp" (outlined).
  static const IconData eight_mp_outlined = IconData(0xee25, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">9k</i> &#x2014; material icon named "9k".
  static const IconData nine_k = IconData(0xe034, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">9k</i> &#x2014; material icon named "9k" (sharp).
  static const IconData nine_k_sharp = IconData(0xe735, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">9k</i> &#x2014; material icon named "9k" (round).
  static const IconData nine_k_rounded = IconData(0xf514, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">9k</i> &#x2014; material icon named "9k" (outlined).
  static const IconData nine_k_outlined = IconData(0xee26, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">9k_plus</i> &#x2014; material icon named "9k plus".
  static const IconData nine_k_plus = IconData(0xe035, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">9k_plus</i> &#x2014; material icon named "9k plus" (sharp).
  static const IconData nine_k_plus_sharp = IconData(0xe734, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">9k_plus</i> &#x2014; material icon named "9k plus" (round).
  static const IconData nine_k_plus_rounded = IconData(0xf513, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">9k_plus</i> &#x2014; material icon named "9k plus" (outlined).
  static const IconData nine_k_plus_outlined = IconData(0xee27, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">9mp</i> &#x2014; material icon named "9mp".
  static const IconData nine_mp = IconData(0xe036, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">9mp</i> &#x2014; material icon named "9mp" (sharp).
  static const IconData nine_mp_sharp = IconData(0xe736, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">9mp</i> &#x2014; material icon named "9mp" (round).
  static const IconData nine_mp_rounded = IconData(0xf515, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">9mp</i> &#x2014; material icon named "9mp" (outlined).
  static const IconData nine_mp_outlined = IconData(0xee28, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">ac_unit</i> &#x2014; material icon named "ac unit".
  static const IconData ac_unit = IconData(0xe037, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">ac_unit</i> &#x2014; material icon named "ac unit" (sharp).
  static const IconData ac_unit_sharp = IconData(0xe737, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">ac_unit</i> &#x2014; material icon named "ac unit" (round).
  static const IconData ac_unit_rounded = IconData(0xf516, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">ac_unit</i> &#x2014; material icon named "ac unit" (outlined).
  static const IconData ac_unit_outlined = IconData(0xee29, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">access_alarm</i> &#x2014; material icon named "access alarm".
  static const IconData access_alarm = IconData(0xe038, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">access_alarm</i> &#x2014; material icon named "access alarm" (sharp).
  static const IconData access_alarm_sharp = IconData(0xe738, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">access_alarm</i> &#x2014; material icon named "access alarm" (round).
  static const IconData access_alarm_rounded = IconData(0xf517, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">access_alarm</i> &#x2014; material icon named "access alarm" (outlined).
  static const IconData access_alarm_outlined = IconData(0xee2a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">access_alarms</i> &#x2014; material icon named "access alarms".
  static const IconData access_alarms = IconData(0xe039, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">access_alarms</i> &#x2014; material icon named "access alarms" (sharp).
  static const IconData access_alarms_sharp = IconData(0xe739, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">access_alarms</i> &#x2014; material icon named "access alarms" (round).
  static const IconData access_alarms_rounded = IconData(0xf518, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">access_alarms</i> &#x2014; material icon named "access alarms" (outlined).
  static const IconData access_alarms_outlined = IconData(0xee2b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">access_time</i> &#x2014; material icon named "access time".
  static const IconData access_time = IconData(0xe03a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">access_time</i> &#x2014; material icon named "access time" (sharp).
  static const IconData access_time_sharp = IconData(0xe73b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">access_time</i> &#x2014; material icon named "access time" (round).
  static const IconData access_time_rounded = IconData(0xf51a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">access_time</i> &#x2014; material icon named "access time" (outlined).
  static const IconData access_time_outlined = IconData(0xee2d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">access_time_filled</i> &#x2014; material icon named "access time filled".
  static const IconData access_time_filled = IconData(0xe03b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">access_time_filled</i> &#x2014; material icon named "access time filled" (sharp).
  static const IconData access_time_filled_sharp = IconData(0xe73a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">access_time_filled</i> &#x2014; material icon named "access time filled" (round).
  static const IconData access_time_filled_rounded = IconData(0xf519, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">access_time_filled</i> &#x2014; material icon named "access time filled" (outlined).
  static const IconData access_time_filled_outlined = IconData(0xee2c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">accessibility</i> &#x2014; material icon named "accessibility".
  static const IconData accessibility = IconData(0xe03c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">accessibility</i> &#x2014; material icon named "accessibility" (sharp).
  static const IconData accessibility_sharp = IconData(0xe73d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">accessibility</i> &#x2014; material icon named "accessibility" (round).
  static const IconData accessibility_rounded = IconData(0xf51c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">accessibility</i> &#x2014; material icon named "accessibility" (outlined).
  static const IconData accessibility_outlined = IconData(0xee2f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">accessibility_new</i> &#x2014; material icon named "accessibility new".
  static const IconData accessibility_new = IconData(0xe03d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">accessibility_new</i> &#x2014; material icon named "accessibility new" (sharp).
  static const IconData accessibility_new_sharp = IconData(0xe73c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">accessibility_new</i> &#x2014; material icon named "accessibility new" (round).
  static const IconData accessibility_new_rounded = IconData(0xf51b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">accessibility_new</i> &#x2014; material icon named "accessibility new" (outlined).
  static const IconData accessibility_new_outlined = IconData(0xee2e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">accessible</i> &#x2014; material icon named "accessible".
  static const IconData accessible = IconData(0xe03e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">accessible</i> &#x2014; material icon named "accessible" (sharp).
  static const IconData accessible_sharp = IconData(0xe73f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">accessible</i> &#x2014; material icon named "accessible" (round).
  static const IconData accessible_rounded = IconData(0xf51e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">accessible</i> &#x2014; material icon named "accessible" (outlined).
  static const IconData accessible_outlined = IconData(0xee31, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">accessible_forward</i> &#x2014; material icon named "accessible forward".
  static const IconData accessible_forward = IconData(0xe03f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">accessible_forward</i> &#x2014; material icon named "accessible forward" (sharp).
  static const IconData accessible_forward_sharp = IconData(0xe73e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">accessible_forward</i> &#x2014; material icon named "accessible forward" (round).
  static const IconData accessible_forward_rounded = IconData(0xf51d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">accessible_forward</i> &#x2014; material icon named "accessible forward" (outlined).
  static const IconData accessible_forward_outlined = IconData(0xee30, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">account_balance</i> &#x2014; material icon named "account balance".
  static const IconData account_balance = IconData(0xe040, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">account_balance</i> &#x2014; material icon named "account balance" (sharp).
  static const IconData account_balance_sharp = IconData(0xe740, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">account_balance</i> &#x2014; material icon named "account balance" (round).
  static const IconData account_balance_rounded = IconData(0xf51f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">account_balance</i> &#x2014; material icon named "account balance" (outlined).
  static const IconData account_balance_outlined = IconData(0xee32, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">account_balance_wallet</i> &#x2014; material icon named "account balance wallet".
  static const IconData account_balance_wallet = IconData(0xe041, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">account_balance_wallet</i> &#x2014; material icon named "account balance wallet" (sharp).
  static const IconData account_balance_wallet_sharp = IconData(0xe741, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">account_balance_wallet</i> &#x2014; material icon named "account balance wallet" (round).
  static const IconData account_balance_wallet_rounded = IconData(0xf520, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">account_balance_wallet</i> &#x2014; material icon named "account balance wallet" (outlined).
  static const IconData account_balance_wallet_outlined = IconData(0xee33, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">account_box</i> &#x2014; material icon named "account box".
  static const IconData account_box = IconData(0xe042, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">account_box</i> &#x2014; material icon named "account box" (sharp).
  static const IconData account_box_sharp = IconData(0xe742, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">account_box</i> &#x2014; material icon named "account box" (round).
  static const IconData account_box_rounded = IconData(0xf521, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">account_box</i> &#x2014; material icon named "account box" (outlined).
  static const IconData account_box_outlined = IconData(0xee34, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">account_circle</i> &#x2014; material icon named "account circle".
  static const IconData account_circle = IconData(0xe043, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">account_circle</i> &#x2014; material icon named "account circle" (sharp).
  static const IconData account_circle_sharp = IconData(0xe743, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">account_circle</i> &#x2014; material icon named "account circle" (round).
  static const IconData account_circle_rounded = IconData(0xf522, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">account_circle</i> &#x2014; material icon named "account circle" (outlined).
  static const IconData account_circle_outlined = IconData(0xee35, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">account_tree</i> &#x2014; material icon named "account tree".
  static const IconData account_tree = IconData(0xe044, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">account_tree</i> &#x2014; material icon named "account tree" (sharp).
  static const IconData account_tree_sharp = IconData(0xe744, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">account_tree</i> &#x2014; material icon named "account tree" (round).
  static const IconData account_tree_rounded = IconData(0xf523, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">account_tree</i> &#x2014; material icon named "account tree" (outlined).
  static const IconData account_tree_outlined = IconData(0xee36, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">ad_units</i> &#x2014; material icon named "ad units".
  static const IconData ad_units = IconData(0xe045, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">ad_units</i> &#x2014; material icon named "ad units" (sharp).
  static const IconData ad_units_sharp = IconData(0xe745, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">ad_units</i> &#x2014; material icon named "ad units" (round).
  static const IconData ad_units_rounded = IconData(0xf524, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">ad_units</i> &#x2014; material icon named "ad units" (outlined).
  static const IconData ad_units_outlined = IconData(0xee37, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">adb</i> &#x2014; material icon named "adb".
  static const IconData adb = IconData(0xe046, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">adb</i> &#x2014; material icon named "adb" (sharp).
  static const IconData adb_sharp = IconData(0xe746, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">adb</i> &#x2014; material icon named "adb" (round).
  static const IconData adb_rounded = IconData(0xf525, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">adb</i> &#x2014; material icon named "adb" (outlined).
  static const IconData adb_outlined = IconData(0xee38, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add</i> &#x2014; material icon named "add".
  static const IconData add = IconData(0xe047, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add</i> &#x2014; material icon named "add" (sharp).
  static const IconData add_sharp = IconData(0xe758, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add</i> &#x2014; material icon named "add" (round).
  static const IconData add_rounded = IconData(0xf537, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add</i> &#x2014; material icon named "add" (outlined).
  static const IconData add_outlined = IconData(0xee47, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_a_photo</i> &#x2014; material icon named "add a photo".
  static const IconData add_a_photo = IconData(0xe048, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_a_photo</i> &#x2014; material icon named "add a photo" (sharp).
  static const IconData add_a_photo_sharp = IconData(0xe747, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_a_photo</i> &#x2014; material icon named "add a photo" (round).
  static const IconData add_a_photo_rounded = IconData(0xf526, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_a_photo</i> &#x2014; material icon named "add a photo" (outlined).
  static const IconData add_a_photo_outlined = IconData(0xee39, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_alarm</i> &#x2014; material icon named "add alarm".
  static const IconData add_alarm = IconData(0xe049, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_alarm</i> &#x2014; material icon named "add alarm" (sharp).
  static const IconData add_alarm_sharp = IconData(0xe748, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_alarm</i> &#x2014; material icon named "add alarm" (round).
  static const IconData add_alarm_rounded = IconData(0xf527, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_alarm</i> &#x2014; material icon named "add alarm" (outlined).
  static const IconData add_alarm_outlined = IconData(0xee3a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_alert</i> &#x2014; material icon named "add alert".
  static const IconData add_alert = IconData(0xe04a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_alert</i> &#x2014; material icon named "add alert" (sharp).
  static const IconData add_alert_sharp = IconData(0xe749, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_alert</i> &#x2014; material icon named "add alert" (round).
  static const IconData add_alert_rounded = IconData(0xf528, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_alert</i> &#x2014; material icon named "add alert" (outlined).
  static const IconData add_alert_outlined = IconData(0xee3b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_box</i> &#x2014; material icon named "add box".
  static const IconData add_box = IconData(0xe04b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_box</i> &#x2014; material icon named "add box" (sharp).
  static const IconData add_box_sharp = IconData(0xe74a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_box</i> &#x2014; material icon named "add box" (round).
  static const IconData add_box_rounded = IconData(0xf529, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_box</i> &#x2014; material icon named "add box" (outlined).
  static const IconData add_box_outlined = IconData(0xee3c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_business</i> &#x2014; material icon named "add business".
  static const IconData add_business = IconData(0xe04c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_business</i> &#x2014; material icon named "add business" (sharp).
  static const IconData add_business_sharp = IconData(0xe74b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_business</i> &#x2014; material icon named "add business" (round).
  static const IconData add_business_rounded = IconData(0xf52a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_business</i> &#x2014; material icon named "add business" (outlined).
  static const IconData add_business_outlined = IconData(0xee3d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_call</i> &#x2014; material icon named "add call".
  static const IconData add_call = IconData(0xe04d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_chart</i> &#x2014; material icon named "add chart".
  static const IconData add_chart = IconData(0xe04e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_chart</i> &#x2014; material icon named "add chart" (sharp).
  static const IconData add_chart_sharp = IconData(0xe74c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_chart</i> &#x2014; material icon named "add chart" (round).
  static const IconData add_chart_rounded = IconData(0xf52b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_chart</i> &#x2014; material icon named "add chart" (outlined).
  static const IconData add_chart_outlined = IconData(0xee3e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_circle</i> &#x2014; material icon named "add circle".
  static const IconData add_circle = IconData(0xe04f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_circle</i> &#x2014; material icon named "add circle" (sharp).
  static const IconData add_circle_sharp = IconData(0xe74e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_circle</i> &#x2014; material icon named "add circle" (round).
  static const IconData add_circle_rounded = IconData(0xf52d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_circle</i> &#x2014; material icon named "add circle" (outlined).
  static const IconData add_circle_outlined = IconData(0xee40, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_circle_outline</i> &#x2014; material icon named "add circle outline".
  static const IconData add_circle_outline = IconData(0xe050, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_circle_outline</i> &#x2014; material icon named "add circle outline" (sharp).
  static const IconData add_circle_outline_sharp = IconData(0xe74d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_circle_outline</i> &#x2014; material icon named "add circle outline" (round).
  static const IconData add_circle_outline_rounded = IconData(0xf52c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_circle_outline</i> &#x2014; material icon named "add circle outline" (outlined).
  static const IconData add_circle_outline_outlined = IconData(0xee3f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_comment</i> &#x2014; material icon named "add comment".
  static const IconData add_comment = IconData(0xe051, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_comment</i> &#x2014; material icon named "add comment" (sharp).
  static const IconData add_comment_sharp = IconData(0xe74f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_comment</i> &#x2014; material icon named "add comment" (round).
  static const IconData add_comment_rounded = IconData(0xf52e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_comment</i> &#x2014; material icon named "add comment" (outlined).
  static const IconData add_comment_outlined = IconData(0xee41, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_ic_call</i> &#x2014; material icon named "add ic call".
  static const IconData add_ic_call = IconData(0xe052, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_ic_call</i> &#x2014; material icon named "add ic call" (sharp).
  static const IconData add_ic_call_sharp = IconData(0xe750, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_ic_call</i> &#x2014; material icon named "add ic call" (round).
  static const IconData add_ic_call_rounded = IconData(0xf52f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_ic_call</i> &#x2014; material icon named "add ic call" (outlined).
  static const IconData add_ic_call_outlined = IconData(0xee42, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_link</i> &#x2014; material icon named "add link".
  static const IconData add_link = IconData(0xe053, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_link</i> &#x2014; material icon named "add link" (sharp).
  static const IconData add_link_sharp = IconData(0xe751, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_link</i> &#x2014; material icon named "add link" (round).
  static const IconData add_link_rounded = IconData(0xf530, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_link</i> &#x2014; material icon named "add link" (outlined).
  static const IconData add_link_outlined = IconData(0xee43, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_location</i> &#x2014; material icon named "add location".
  static const IconData add_location = IconData(0xe054, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_location</i> &#x2014; material icon named "add location" (sharp).
  static const IconData add_location_sharp = IconData(0xe753, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_location</i> &#x2014; material icon named "add location" (round).
  static const IconData add_location_rounded = IconData(0xf532, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_location</i> &#x2014; material icon named "add location" (outlined).
  static const IconData add_location_outlined = IconData(0xee45, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_location_alt</i> &#x2014; material icon named "add location alt".
  static const IconData add_location_alt = IconData(0xe055, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_location_alt</i> &#x2014; material icon named "add location alt" (sharp).
  static const IconData add_location_alt_sharp = IconData(0xe752, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_location_alt</i> &#x2014; material icon named "add location alt" (round).
  static const IconData add_location_alt_rounded = IconData(0xf531, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_location_alt</i> &#x2014; material icon named "add location alt" (outlined).
  static const IconData add_location_alt_outlined = IconData(0xee44, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_moderator</i> &#x2014; material icon named "add moderator".
  static const IconData add_moderator = IconData(0xe056, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_moderator</i> &#x2014; material icon named "add moderator" (sharp).
  static const IconData add_moderator_sharp = IconData(0xe754, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_moderator</i> &#x2014; material icon named "add moderator" (round).
  static const IconData add_moderator_rounded = IconData(0xf533, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_moderator</i> &#x2014; material icon named "add moderator" (outlined).
  static const IconData add_moderator_outlined = IconData(0xee46, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_photo_alternate</i> &#x2014; material icon named "add photo alternate".
  static const IconData add_photo_alternate = IconData(0xe057, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_photo_alternate</i> &#x2014; material icon named "add photo alternate" (sharp).
  static const IconData add_photo_alternate_sharp = IconData(0xe755, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_photo_alternate</i> &#x2014; material icon named "add photo alternate" (round).
  static const IconData add_photo_alternate_rounded = IconData(0xf534, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_photo_alternate</i> &#x2014; material icon named "add photo alternate" (outlined).
  static const IconData add_photo_alternate_outlined = IconData(0xee48, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_reaction</i> &#x2014; material icon named "add reaction".
  static const IconData add_reaction = IconData(0xe058, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_reaction</i> &#x2014; material icon named "add reaction" (sharp).
  static const IconData add_reaction_sharp = IconData(0xe756, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_reaction</i> &#x2014; material icon named "add reaction" (round).
  static const IconData add_reaction_rounded = IconData(0xf535, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_reaction</i> &#x2014; material icon named "add reaction" (outlined).
  static const IconData add_reaction_outlined = IconData(0xee49, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_road</i> &#x2014; material icon named "add road".
  static const IconData add_road = IconData(0xe059, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_road</i> &#x2014; material icon named "add road" (sharp).
  static const IconData add_road_sharp = IconData(0xe757, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_road</i> &#x2014; material icon named "add road" (round).
  static const IconData add_road_rounded = IconData(0xf536, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_road</i> &#x2014; material icon named "add road" (outlined).
  static const IconData add_road_outlined = IconData(0xee4a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_shopping_cart</i> &#x2014; material icon named "add shopping cart".
  static const IconData add_shopping_cart = IconData(0xe05a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_shopping_cart</i> &#x2014; material icon named "add shopping cart" (sharp).
  static const IconData add_shopping_cart_sharp = IconData(0xe759, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_shopping_cart</i> &#x2014; material icon named "add shopping cart" (round).
  static const IconData add_shopping_cart_rounded = IconData(0xf538, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_shopping_cart</i> &#x2014; material icon named "add shopping cart" (outlined).
  static const IconData add_shopping_cart_outlined = IconData(0xee4b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_task</i> &#x2014; material icon named "add task".
  static const IconData add_task = IconData(0xe05b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_task</i> &#x2014; material icon named "add task" (sharp).
  static const IconData add_task_sharp = IconData(0xe75a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_task</i> &#x2014; material icon named "add task" (round).
  static const IconData add_task_rounded = IconData(0xf539, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_task</i> &#x2014; material icon named "add task" (outlined).
  static const IconData add_task_outlined = IconData(0xee4c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_to_drive</i> &#x2014; material icon named "add to drive".
  static const IconData add_to_drive = IconData(0xe05c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_to_drive</i> &#x2014; material icon named "add to drive" (sharp).
  static const IconData add_to_drive_sharp = IconData(0xe75b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_to_drive</i> &#x2014; material icon named "add to drive" (round).
  static const IconData add_to_drive_rounded = IconData(0xf53a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_to_drive</i> &#x2014; material icon named "add to drive" (outlined).
  static const IconData add_to_drive_outlined = IconData(0xee4d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_to_home_screen</i> &#x2014; material icon named "add to home screen".
  static const IconData add_to_home_screen = IconData(0xe05d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_to_home_screen</i> &#x2014; material icon named "add to home screen" (sharp).
  static const IconData add_to_home_screen_sharp = IconData(0xe75c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_to_home_screen</i> &#x2014; material icon named "add to home screen" (round).
  static const IconData add_to_home_screen_rounded = IconData(0xf53b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_to_home_screen</i> &#x2014; material icon named "add to home screen" (outlined).
  static const IconData add_to_home_screen_outlined = IconData(0xee4e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_to_photos</i> &#x2014; material icon named "add to photos".
  static const IconData add_to_photos = IconData(0xe05e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_to_photos</i> &#x2014; material icon named "add to photos" (sharp).
  static const IconData add_to_photos_sharp = IconData(0xe75d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_to_photos</i> &#x2014; material icon named "add to photos" (round).
  static const IconData add_to_photos_rounded = IconData(0xf53c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_to_photos</i> &#x2014; material icon named "add to photos" (outlined).
  static const IconData add_to_photos_outlined = IconData(0xee4f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">add_to_queue</i> &#x2014; material icon named "add to queue".
  static const IconData add_to_queue = IconData(0xe05f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">add_to_queue</i> &#x2014; material icon named "add to queue" (sharp).
  static const IconData add_to_queue_sharp = IconData(0xe75e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">add_to_queue</i> &#x2014; material icon named "add to queue" (round).
  static const IconData add_to_queue_rounded = IconData(0xf53d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">add_to_queue</i> &#x2014; material icon named "add to queue" (outlined).
  static const IconData add_to_queue_outlined = IconData(0xee50, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">addchart</i> &#x2014; material icon named "addchart".
  static const IconData addchart = IconData(0xe060, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">addchart</i> &#x2014; material icon named "addchart" (sharp).
  static const IconData addchart_sharp = IconData(0xe75f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">addchart</i> &#x2014; material icon named "addchart" (round).
  static const IconData addchart_rounded = IconData(0xf53e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">addchart</i> &#x2014; material icon named "addchart" (outlined).
  static const IconData addchart_outlined = IconData(0xee51, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">adjust</i> &#x2014; material icon named "adjust".
  static const IconData adjust = IconData(0xe061, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">adjust</i> &#x2014; material icon named "adjust" (sharp).
  static const IconData adjust_sharp = IconData(0xe760, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">adjust</i> &#x2014; material icon named "adjust" (round).
  static const IconData adjust_rounded = IconData(0xf53f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">adjust</i> &#x2014; material icon named "adjust" (outlined).
  static const IconData adjust_outlined = IconData(0xee52, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">admin_panel_settings</i> &#x2014; material icon named "admin panel settings".
  static const IconData admin_panel_settings = IconData(0xe062, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">admin_panel_settings</i> &#x2014; material icon named "admin panel settings" (sharp).
  static const IconData admin_panel_settings_sharp = IconData(0xe761, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">admin_panel_settings</i> &#x2014; material icon named "admin panel settings" (round).
  static const IconData admin_panel_settings_rounded = IconData(0xf540, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">admin_panel_settings</i> &#x2014; material icon named "admin panel settings" (outlined).
  static const IconData admin_panel_settings_outlined = IconData(0xee53, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">agriculture</i> &#x2014; material icon named "agriculture".
  static const IconData agriculture = IconData(0xe063, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">agriculture</i> &#x2014; material icon named "agriculture" (sharp).
  static const IconData agriculture_sharp = IconData(0xe762, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">agriculture</i> &#x2014; material icon named "agriculture" (round).
  static const IconData agriculture_rounded = IconData(0xf541, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">agriculture</i> &#x2014; material icon named "agriculture" (outlined).
  static const IconData agriculture_outlined = IconData(0xee54, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">air</i> &#x2014; material icon named "air".
  static const IconData air = IconData(0xe064, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">air</i> &#x2014; material icon named "air" (sharp).
  static const IconData air_sharp = IconData(0xe763, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">air</i> &#x2014; material icon named "air" (round).
  static const IconData air_rounded = IconData(0xf542, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">air</i> &#x2014; material icon named "air" (outlined).
  static const IconData air_outlined = IconData(0xee55, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airline_seat_flat</i> &#x2014; material icon named "airline seat flat".
  static const IconData airline_seat_flat = IconData(0xe065, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">airline_seat_flat</i> &#x2014; material icon named "airline seat flat" (sharp).
  static const IconData airline_seat_flat_sharp = IconData(0xe765, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">airline_seat_flat</i> &#x2014; material icon named "airline seat flat" (round).
  static const IconData airline_seat_flat_rounded = IconData(0xf544, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">airline_seat_flat</i> &#x2014; material icon named "airline seat flat" (outlined).
  static const IconData airline_seat_flat_outlined = IconData(0xee57, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airline_seat_flat_angled</i> &#x2014; material icon named "airline seat flat angled".
  static const IconData airline_seat_flat_angled = IconData(0xe066, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">airline_seat_flat_angled</i> &#x2014; material icon named "airline seat flat angled" (sharp).
  static const IconData airline_seat_flat_angled_sharp = IconData(0xe764, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">airline_seat_flat_angled</i> &#x2014; material icon named "airline seat flat angled" (round).
  static const IconData airline_seat_flat_angled_rounded = IconData(0xf543, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">airline_seat_flat_angled</i> &#x2014; material icon named "airline seat flat angled" (outlined).
  static const IconData airline_seat_flat_angled_outlined = IconData(0xee56, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airline_seat_individual_suite</i> &#x2014; material icon named "airline seat individual suite".
  static const IconData airline_seat_individual_suite = IconData(0xe067, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">airline_seat_individual_suite</i> &#x2014; material icon named "airline seat individual suite" (sharp).
  static const IconData airline_seat_individual_suite_sharp = IconData(0xe766, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">airline_seat_individual_suite</i> &#x2014; material icon named "airline seat individual suite" (round).
  static const IconData airline_seat_individual_suite_rounded = IconData(0xf545, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">airline_seat_individual_suite</i> &#x2014; material icon named "airline seat individual suite" (outlined).
  static const IconData airline_seat_individual_suite_outlined = IconData(0xee58, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airline_seat_legroom_extra</i> &#x2014; material icon named "airline seat legroom extra".
  static const IconData airline_seat_legroom_extra = IconData(0xe068, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">airline_seat_legroom_extra</i> &#x2014; material icon named "airline seat legroom extra" (sharp).
  static const IconData airline_seat_legroom_extra_sharp = IconData(0xe767, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">airline_seat_legroom_extra</i> &#x2014; material icon named "airline seat legroom extra" (round).
  static const IconData airline_seat_legroom_extra_rounded = IconData(0xf546, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">airline_seat_legroom_extra</i> &#x2014; material icon named "airline seat legroom extra" (outlined).
  static const IconData airline_seat_legroom_extra_outlined = IconData(0xee59, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airline_seat_legroom_normal</i> &#x2014; material icon named "airline seat legroom normal".
  static const IconData airline_seat_legroom_normal = IconData(0xe069, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">airline_seat_legroom_normal</i> &#x2014; material icon named "airline seat legroom normal" (sharp).
  static const IconData airline_seat_legroom_normal_sharp = IconData(0xe768, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">airline_seat_legroom_normal</i> &#x2014; material icon named "airline seat legroom normal" (round).
  static const IconData airline_seat_legroom_normal_rounded = IconData(0xf547, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">airline_seat_legroom_normal</i> &#x2014; material icon named "airline seat legroom normal" (outlined).
  static const IconData airline_seat_legroom_normal_outlined = IconData(0xee5a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airline_seat_legroom_reduced</i> &#x2014; material icon named "airline seat legroom reduced".
  static const IconData airline_seat_legroom_reduced = IconData(0xe06a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">airline_seat_legroom_reduced</i> &#x2014; material icon named "airline seat legroom reduced" (sharp).
  static const IconData airline_seat_legroom_reduced_sharp = IconData(0xe769, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">airline_seat_legroom_reduced</i> &#x2014; material icon named "airline seat legroom reduced" (round).
  static const IconData airline_seat_legroom_reduced_rounded = IconData(0xf548, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">airline_seat_legroom_reduced</i> &#x2014; material icon named "airline seat legroom reduced" (outlined).
  static const IconData airline_seat_legroom_reduced_outlined = IconData(0xee5b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airline_seat_recline_extra</i> &#x2014; material icon named "airline seat recline extra".
  static const IconData airline_seat_recline_extra = IconData(0xe06b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">airline_seat_recline_extra</i> &#x2014; material icon named "airline seat recline extra" (sharp).
  static const IconData airline_seat_recline_extra_sharp = IconData(0xe76a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">airline_seat_recline_extra</i> &#x2014; material icon named "airline seat recline extra" (round).
  static const IconData airline_seat_recline_extra_rounded = IconData(0xf549, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">airline_seat_recline_extra</i> &#x2014; material icon named "airline seat recline extra" (outlined).
  static const IconData airline_seat_recline_extra_outlined = IconData(0xee5c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airline_seat_recline_normal</i> &#x2014; material icon named "airline seat recline normal".
  static const IconData airline_seat_recline_normal = IconData(0xe06c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">airline_seat_recline_normal</i> &#x2014; material icon named "airline seat recline normal" (sharp).
  static const IconData airline_seat_recline_normal_sharp = IconData(0xe76b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">airline_seat_recline_normal</i> &#x2014; material icon named "airline seat recline normal" (round).
  static const IconData airline_seat_recline_normal_rounded = IconData(0xf54a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">airline_seat_recline_normal</i> &#x2014; material icon named "airline seat recline normal" (outlined).
  static const IconData airline_seat_recline_normal_outlined = IconData(0xee5d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airplane_ticket</i> &#x2014; material icon named "airplane ticket".
  static const IconData airplane_ticket = IconData(0xe06d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">airplane_ticket</i> &#x2014; material icon named "airplane ticket" (sharp).
  static const IconData airplane_ticket_sharp = IconData(0xe76c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">airplane_ticket</i> &#x2014; material icon named "airplane ticket" (round).
  static const IconData airplane_ticket_rounded = IconData(0xf54b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">airplane_ticket</i> &#x2014; material icon named "airplane ticket" (outlined).
  static const IconData airplane_ticket_outlined = IconData(0xee5e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airplanemode_active</i> &#x2014; material icon named "airplanemode active".
  static const IconData airplanemode_active = IconData(0xe06e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">airplanemode_active</i> &#x2014; material icon named "airplanemode active" (sharp).
  static const IconData airplanemode_active_sharp = IconData(0xe76d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">airplanemode_active</i> &#x2014; material icon named "airplanemode active" (round).
  static const IconData airplanemode_active_rounded = IconData(0xf54c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">airplanemode_active</i> &#x2014; material icon named "airplanemode active" (outlined).
  static const IconData airplanemode_active_outlined = IconData(0xee5f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airplanemode_inactive</i> &#x2014; material icon named "airplanemode inactive".
  static const IconData airplanemode_inactive = IconData(0xe06f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">airplanemode_inactive</i> &#x2014; material icon named "airplanemode inactive" (sharp).
  static const IconData airplanemode_inactive_sharp = IconData(0xe76e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">airplanemode_inactive</i> &#x2014; material icon named "airplanemode inactive" (round).
  static const IconData airplanemode_inactive_rounded = IconData(0xf54d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">airplanemode_inactive</i> &#x2014; material icon named "airplanemode inactive" (outlined).
  static const IconData airplanemode_inactive_outlined = IconData(0xee60, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airplanemode_off</i> &#x2014; material icon named "airplanemode off".
  static const IconData airplanemode_off = IconData(0xe06f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">airplanemode_off</i> &#x2014; material icon named "airplanemode off" (sharp).
  static const IconData airplanemode_off_sharp = IconData(0xe76e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">airplanemode_off</i> &#x2014; material icon named "airplanemode off" (round).
  static const IconData airplanemode_off_rounded = IconData(0xf54d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">airplanemode_off</i> &#x2014; material icon named "airplanemode off" (outlined).
  static const IconData airplanemode_off_outlined = IconData(0xee60, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airplanemode_on</i> &#x2014; material icon named "airplanemode on".
  static const IconData airplanemode_on = IconData(0xe06e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">airplanemode_on</i> &#x2014; material icon named "airplanemode on" (sharp).
  static const IconData airplanemode_on_sharp = IconData(0xe76d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">airplanemode_on</i> &#x2014; material icon named "airplanemode on" (round).
  static const IconData airplanemode_on_rounded = IconData(0xf54c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">airplanemode_on</i> &#x2014; material icon named "airplanemode on" (outlined).
  static const IconData airplanemode_on_outlined = IconData(0xee5f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airplay</i> &#x2014; material icon named "airplay".
  static const IconData airplay = IconData(0xe070, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">airplay</i> &#x2014; material icon named "airplay" (sharp).
  static const IconData airplay_sharp = IconData(0xe76f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">airplay</i> &#x2014; material icon named "airplay" (round).
  static const IconData airplay_rounded = IconData(0xf54e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">airplay</i> &#x2014; material icon named "airplay" (outlined).
  static const IconData airplay_outlined = IconData(0xee61, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">airport_shuttle</i> &#x2014; material icon named "airport shuttle".
  static const IconData airport_shuttle = IconData(0xe071, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">airport_shuttle</i> &#x2014; material icon named "airport shuttle" (sharp).
  static const IconData airport_shuttle_sharp = IconData(0xe770, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">airport_shuttle</i> &#x2014; material icon named "airport shuttle" (round).
  static const IconData airport_shuttle_rounded = IconData(0xf54f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">airport_shuttle</i> &#x2014; material icon named "airport shuttle" (outlined).
  static const IconData airport_shuttle_outlined = IconData(0xee62, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">alarm</i> &#x2014; material icon named "alarm".
  static const IconData alarm = IconData(0xe072, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">alarm</i> &#x2014; material icon named "alarm" (sharp).
  static const IconData alarm_sharp = IconData(0xe774, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">alarm</i> &#x2014; material icon named "alarm" (round).
  static const IconData alarm_rounded = IconData(0xf553, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">alarm</i> &#x2014; material icon named "alarm" (outlined).
  static const IconData alarm_outlined = IconData(0xee66, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">alarm_add</i> &#x2014; material icon named "alarm add".
  static const IconData alarm_add = IconData(0xe073, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">alarm_add</i> &#x2014; material icon named "alarm add" (sharp).
  static const IconData alarm_add_sharp = IconData(0xe771, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">alarm_add</i> &#x2014; material icon named "alarm add" (round).
  static const IconData alarm_add_rounded = IconData(0xf550, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">alarm_add</i> &#x2014; material icon named "alarm add" (outlined).
  static const IconData alarm_add_outlined = IconData(0xee63, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">alarm_off</i> &#x2014; material icon named "alarm off".
  static const IconData alarm_off = IconData(0xe074, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">alarm_off</i> &#x2014; material icon named "alarm off" (sharp).
  static const IconData alarm_off_sharp = IconData(0xe772, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">alarm_off</i> &#x2014; material icon named "alarm off" (round).
  static const IconData alarm_off_rounded = IconData(0xf551, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">alarm_off</i> &#x2014; material icon named "alarm off" (outlined).
  static const IconData alarm_off_outlined = IconData(0xee64, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">alarm_on</i> &#x2014; material icon named "alarm on".
  static const IconData alarm_on = IconData(0xe075, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">alarm_on</i> &#x2014; material icon named "alarm on" (sharp).
  static const IconData alarm_on_sharp = IconData(0xe773, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">alarm_on</i> &#x2014; material icon named "alarm on" (round).
  static const IconData alarm_on_rounded = IconData(0xf552, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">alarm_on</i> &#x2014; material icon named "alarm on" (outlined).
  static const IconData alarm_on_outlined = IconData(0xee65, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">album</i> &#x2014; material icon named "album".
  static const IconData album = IconData(0xe076, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">album</i> &#x2014; material icon named "album" (sharp).
  static const IconData album_sharp = IconData(0xe775, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">album</i> &#x2014; material icon named "album" (round).
  static const IconData album_rounded = IconData(0xf554, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">album</i> &#x2014; material icon named "album" (outlined).
  static const IconData album_outlined = IconData(0xee67, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">align_horizontal_center</i> &#x2014; material icon named "align horizontal center".
  static const IconData align_horizontal_center = IconData(0xe077, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">align_horizontal_center</i> &#x2014; material icon named "align horizontal center" (sharp).
  static const IconData align_horizontal_center_sharp = IconData(0xe776, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">align_horizontal_center</i> &#x2014; material icon named "align horizontal center" (round).
  static const IconData align_horizontal_center_rounded = IconData(0xf555, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">align_horizontal_center</i> &#x2014; material icon named "align horizontal center" (outlined).
  static const IconData align_horizontal_center_outlined = IconData(0xee68, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">align_horizontal_left</i> &#x2014; material icon named "align horizontal left".
  static const IconData align_horizontal_left = IconData(0xe078, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">align_horizontal_left</i> &#x2014; material icon named "align horizontal left" (sharp).
  static const IconData align_horizontal_left_sharp = IconData(0xe777, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">align_horizontal_left</i> &#x2014; material icon named "align horizontal left" (round).
  static const IconData align_horizontal_left_rounded = IconData(0xf556, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">align_horizontal_left</i> &#x2014; material icon named "align horizontal left" (outlined).
  static const IconData align_horizontal_left_outlined = IconData(0xee69, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">align_horizontal_right</i> &#x2014; material icon named "align horizontal right".
  static const IconData align_horizontal_right = IconData(0xe079, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">align_horizontal_right</i> &#x2014; material icon named "align horizontal right" (sharp).
  static const IconData align_horizontal_right_sharp = IconData(0xe778, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">align_horizontal_right</i> &#x2014; material icon named "align horizontal right" (round).
  static const IconData align_horizontal_right_rounded = IconData(0xf557, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">align_horizontal_right</i> &#x2014; material icon named "align horizontal right" (outlined).
  static const IconData align_horizontal_right_outlined = IconData(0xee6a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">align_vertical_bottom</i> &#x2014; material icon named "align vertical bottom".
  static const IconData align_vertical_bottom = IconData(0xe07a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">align_vertical_bottom</i> &#x2014; material icon named "align vertical bottom" (sharp).
  static const IconData align_vertical_bottom_sharp = IconData(0xe779, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">align_vertical_bottom</i> &#x2014; material icon named "align vertical bottom" (round).
  static const IconData align_vertical_bottom_rounded = IconData(0xf558, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">align_vertical_bottom</i> &#x2014; material icon named "align vertical bottom" (outlined).
  static const IconData align_vertical_bottom_outlined = IconData(0xee6b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">align_vertical_center</i> &#x2014; material icon named "align vertical center".
  static const IconData align_vertical_center = IconData(0xe07b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">align_vertical_center</i> &#x2014; material icon named "align vertical center" (sharp).
  static const IconData align_vertical_center_sharp = IconData(0xe77a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">align_vertical_center</i> &#x2014; material icon named "align vertical center" (round).
  static const IconData align_vertical_center_rounded = IconData(0xf559, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">align_vertical_center</i> &#x2014; material icon named "align vertical center" (outlined).
  static const IconData align_vertical_center_outlined = IconData(0xee6c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">align_vertical_top</i> &#x2014; material icon named "align vertical top".
  static const IconData align_vertical_top = IconData(0xe07c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">align_vertical_top</i> &#x2014; material icon named "align vertical top" (sharp).
  static const IconData align_vertical_top_sharp = IconData(0xe77b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">align_vertical_top</i> &#x2014; material icon named "align vertical top" (round).
  static const IconData align_vertical_top_rounded = IconData(0xf55a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">align_vertical_top</i> &#x2014; material icon named "align vertical top" (outlined).
  static const IconData align_vertical_top_outlined = IconData(0xee6d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">all_inbox</i> &#x2014; material icon named "all inbox".
  static const IconData all_inbox = IconData(0xe07d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">all_inbox</i> &#x2014; material icon named "all inbox" (sharp).
  static const IconData all_inbox_sharp = IconData(0xe77c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">all_inbox</i> &#x2014; material icon named "all inbox" (round).
  static const IconData all_inbox_rounded = IconData(0xf55b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">all_inbox</i> &#x2014; material icon named "all inbox" (outlined).
  static const IconData all_inbox_outlined = IconData(0xee6e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">all_inclusive</i> &#x2014; material icon named "all inclusive".
  static const IconData all_inclusive = IconData(0xe07e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">all_inclusive</i> &#x2014; material icon named "all inclusive" (sharp).
  static const IconData all_inclusive_sharp = IconData(0xe77d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">all_inclusive</i> &#x2014; material icon named "all inclusive" (round).
  static const IconData all_inclusive_rounded = IconData(0xf55c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">all_inclusive</i> &#x2014; material icon named "all inclusive" (outlined).
  static const IconData all_inclusive_outlined = IconData(0xee6f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">all_out</i> &#x2014; material icon named "all out".
  static const IconData all_out = IconData(0xe07f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">all_out</i> &#x2014; material icon named "all out" (sharp).
  static const IconData all_out_sharp = IconData(0xe77e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">all_out</i> &#x2014; material icon named "all out" (round).
  static const IconData all_out_rounded = IconData(0xf55d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">all_out</i> &#x2014; material icon named "all out" (outlined).
  static const IconData all_out_outlined = IconData(0xee70, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">alt_route</i> &#x2014; material icon named "alt route".
  static const IconData alt_route = IconData(0xe080, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">alt_route</i> &#x2014; material icon named "alt route" (sharp).
  static const IconData alt_route_sharp = IconData(0xe77f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">alt_route</i> &#x2014; material icon named "alt route" (round).
  static const IconData alt_route_rounded = IconData(0xf55e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">alt_route</i> &#x2014; material icon named "alt route" (outlined).
  static const IconData alt_route_outlined = IconData(0xee71, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">alternate_email</i> &#x2014; material icon named "alternate email".
  static const IconData alternate_email = IconData(0xe081, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">alternate_email</i> &#x2014; material icon named "alternate email" (sharp).
  static const IconData alternate_email_sharp = IconData(0xe780, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">alternate_email</i> &#x2014; material icon named "alternate email" (round).
  static const IconData alternate_email_rounded = IconData(0xf55f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">alternate_email</i> &#x2014; material icon named "alternate email" (outlined).
  static const IconData alternate_email_outlined = IconData(0xee72, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">amp_stories</i> &#x2014; material icon named "amp stories".
  static const IconData amp_stories = IconData(0xe082, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">amp_stories</i> &#x2014; material icon named "amp stories" (sharp).
  static const IconData amp_stories_sharp = IconData(0xe781, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">amp_stories</i> &#x2014; material icon named "amp stories" (round).
  static const IconData amp_stories_rounded = IconData(0xf560, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">amp_stories</i> &#x2014; material icon named "amp stories" (outlined).
  static const IconData amp_stories_outlined = IconData(0xee73, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">analytics</i> &#x2014; material icon named "analytics".
  static const IconData analytics = IconData(0xe083, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">analytics</i> &#x2014; material icon named "analytics" (sharp).
  static const IconData analytics_sharp = IconData(0xe782, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">analytics</i> &#x2014; material icon named "analytics" (round).
  static const IconData analytics_rounded = IconData(0xf561, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">analytics</i> &#x2014; material icon named "analytics" (outlined).
  static const IconData analytics_outlined = IconData(0xee74, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">anchor</i> &#x2014; material icon named "anchor".
  static const IconData anchor = IconData(0xe084, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">anchor</i> &#x2014; material icon named "anchor" (sharp).
  static const IconData anchor_sharp = IconData(0xe783, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">anchor</i> &#x2014; material icon named "anchor" (round).
  static const IconData anchor_rounded = IconData(0xf562, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">anchor</i> &#x2014; material icon named "anchor" (outlined).
  static const IconData anchor_outlined = IconData(0xee75, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">android</i> &#x2014; material icon named "android".
  static const IconData android = IconData(0xe085, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">android</i> &#x2014; material icon named "android" (sharp).
  static const IconData android_sharp = IconData(0xe784, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">android</i> &#x2014; material icon named "android" (round).
  static const IconData android_rounded = IconData(0xf563, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">android</i> &#x2014; material icon named "android" (outlined).
  static const IconData android_outlined = IconData(0xee76, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">animation</i> &#x2014; material icon named "animation".
  static const IconData animation = IconData(0xe086, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">animation</i> &#x2014; material icon named "animation" (sharp).
  static const IconData animation_sharp = IconData(0xe785, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">animation</i> &#x2014; material icon named "animation" (round).
  static const IconData animation_rounded = IconData(0xf564, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">animation</i> &#x2014; material icon named "animation" (outlined).
  static const IconData animation_outlined = IconData(0xee77, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">announcement</i> &#x2014; material icon named "announcement".
  static const IconData announcement = IconData(0xe087, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">announcement</i> &#x2014; material icon named "announcement" (sharp).
  static const IconData announcement_sharp = IconData(0xe786, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">announcement</i> &#x2014; material icon named "announcement" (round).
  static const IconData announcement_rounded = IconData(0xf565, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">announcement</i> &#x2014; material icon named "announcement" (outlined).
  static const IconData announcement_outlined = IconData(0xee78, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">aod</i> &#x2014; material icon named "aod".
  static const IconData aod = IconData(0xe088, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">aod</i> &#x2014; material icon named "aod" (sharp).
  static const IconData aod_sharp = IconData(0xe787, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">aod</i> &#x2014; material icon named "aod" (round).
  static const IconData aod_rounded = IconData(0xf566, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">aod</i> &#x2014; material icon named "aod" (outlined).
  static const IconData aod_outlined = IconData(0xee79, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">apartment</i> &#x2014; material icon named "apartment".
  static const IconData apartment = IconData(0xe089, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">apartment</i> &#x2014; material icon named "apartment" (sharp).
  static const IconData apartment_sharp = IconData(0xe788, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">apartment</i> &#x2014; material icon named "apartment" (round).
  static const IconData apartment_rounded = IconData(0xf567, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">apartment</i> &#x2014; material icon named "apartment" (outlined).
  static const IconData apartment_outlined = IconData(0xee7a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">api</i> &#x2014; material icon named "api".
  static const IconData api = IconData(0xe08a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">api</i> &#x2014; material icon named "api" (sharp).
  static const IconData api_sharp = IconData(0xe789, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">api</i> &#x2014; material icon named "api" (round).
  static const IconData api_rounded = IconData(0xf568, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">api</i> &#x2014; material icon named "api" (outlined).
  static const IconData api_outlined = IconData(0xee7b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">app_blocking</i> &#x2014; material icon named "app blocking".
  static const IconData app_blocking = IconData(0xe08b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">app_blocking</i> &#x2014; material icon named "app blocking" (sharp).
  static const IconData app_blocking_sharp = IconData(0xe78a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">app_blocking</i> &#x2014; material icon named "app blocking" (round).
  static const IconData app_blocking_rounded = IconData(0xf569, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">app_blocking</i> &#x2014; material icon named "app blocking" (outlined).
  static const IconData app_blocking_outlined = IconData(0xee7c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">app_registration</i> &#x2014; material icon named "app registration".
  static const IconData app_registration = IconData(0xe08c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">app_registration</i> &#x2014; material icon named "app registration" (sharp).
  static const IconData app_registration_sharp = IconData(0xe78b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">app_registration</i> &#x2014; material icon named "app registration" (round).
  static const IconData app_registration_rounded = IconData(0xf56a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">app_registration</i> &#x2014; material icon named "app registration" (outlined).
  static const IconData app_registration_outlined = IconData(0xee7d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">app_settings_alt</i> &#x2014; material icon named "app settings alt".
  static const IconData app_settings_alt = IconData(0xe08d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">app_settings_alt</i> &#x2014; material icon named "app settings alt" (sharp).
  static const IconData app_settings_alt_sharp = IconData(0xe78c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">app_settings_alt</i> &#x2014; material icon named "app settings alt" (round).
  static const IconData app_settings_alt_rounded = IconData(0xf56b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">app_settings_alt</i> &#x2014; material icon named "app settings alt" (outlined).
  static const IconData app_settings_alt_outlined = IconData(0xee7e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">approval</i> &#x2014; material icon named "approval".
  static const IconData approval = IconData(0xe08e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">approval</i> &#x2014; material icon named "approval" (sharp).
  static const IconData approval_sharp = IconData(0xe78d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">approval</i> &#x2014; material icon named "approval" (round).
  static const IconData approval_rounded = IconData(0xf56c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">approval</i> &#x2014; material icon named "approval" (outlined).
  static const IconData approval_outlined = IconData(0xee7f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">apps</i> &#x2014; material icon named "apps".
  static const IconData apps = IconData(0xe08f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">apps</i> &#x2014; material icon named "apps" (sharp).
  static const IconData apps_sharp = IconData(0xe78e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">apps</i> &#x2014; material icon named "apps" (round).
  static const IconData apps_rounded = IconData(0xf56d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">apps</i> &#x2014; material icon named "apps" (outlined).
  static const IconData apps_outlined = IconData(0xee80, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">architecture</i> &#x2014; material icon named "architecture".
  static const IconData architecture = IconData(0xe090, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">architecture</i> &#x2014; material icon named "architecture" (sharp).
  static const IconData architecture_sharp = IconData(0xe78f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">architecture</i> &#x2014; material icon named "architecture" (round).
  static const IconData architecture_rounded = IconData(0xf56e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">architecture</i> &#x2014; material icon named "architecture" (outlined).
  static const IconData architecture_outlined = IconData(0xee81, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">archive</i> &#x2014; material icon named "archive".
  static const IconData archive = IconData(0xe091, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">archive</i> &#x2014; material icon named "archive" (sharp).
  static const IconData archive_sharp = IconData(0xe790, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">archive</i> &#x2014; material icon named "archive" (round).
  static const IconData archive_rounded = IconData(0xf56f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">archive</i> &#x2014; material icon named "archive" (outlined).
  static const IconData archive_outlined = IconData(0xee82, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">arrow_back</i> &#x2014; material icon named "arrow back".
  static const IconData arrow_back = IconData(0xe092, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">arrow_back</i> &#x2014; material icon named "arrow back" (sharp).
  static const IconData arrow_back_sharp = IconData(0xe793, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">arrow_back</i> &#x2014; material icon named "arrow back" (round).
  static const IconData arrow_back_rounded = IconData(0xf572, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">arrow_back</i> &#x2014; material icon named "arrow back" (outlined).
  static const IconData arrow_back_outlined = IconData(0xee85, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">arrow_back_ios</i> &#x2014; material icon named "arrow back ios".
  static const IconData arrow_back_ios = IconData(0xe093, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">arrow_back_ios</i> &#x2014; material icon named "arrow back ios" (sharp).
  static const IconData arrow_back_ios_sharp = IconData(0xe792, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">arrow_back_ios</i> &#x2014; material icon named "arrow back ios" (round).
  static const IconData arrow_back_ios_rounded = IconData(0xf571, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">arrow_back_ios</i> &#x2014; material icon named "arrow back ios" (outlined).
  static const IconData arrow_back_ios_outlined = IconData(0xee84, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">arrow_back_ios_new</i> &#x2014; material icon named "arrow back ios new".
  static const IconData arrow_back_ios_new = IconData(0xe094, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">arrow_back_ios_new</i> &#x2014; material icon named "arrow back ios new" (sharp).
  static const IconData arrow_back_ios_new_sharp = IconData(0xe791, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">arrow_back_ios_new</i> &#x2014; material icon named "arrow back ios new" (round).
  static const IconData arrow_back_ios_new_rounded = IconData(0xf570, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">arrow_back_ios_new</i> &#x2014; material icon named "arrow back ios new" (outlined).
  static const IconData arrow_back_ios_new_outlined = IconData(0xee83, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">arrow_circle_down</i> &#x2014; material icon named "arrow circle down".
  static const IconData arrow_circle_down = IconData(0xe095, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">arrow_circle_down</i> &#x2014; material icon named "arrow circle down" (sharp).
  static const IconData arrow_circle_down_sharp = IconData(0xe794, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">arrow_circle_down</i> &#x2014; material icon named "arrow circle down" (round).
  static const IconData arrow_circle_down_rounded = IconData(0xf573, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">arrow_circle_down</i> &#x2014; material icon named "arrow circle down" (outlined).
  static const IconData arrow_circle_down_outlined = IconData(0xee86, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">arrow_circle_up</i> &#x2014; material icon named "arrow circle up".
  static const IconData arrow_circle_up = IconData(0xe096, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">arrow_circle_up</i> &#x2014; material icon named "arrow circle up" (sharp).
  static const IconData arrow_circle_up_sharp = IconData(0xe795, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">arrow_circle_up</i> &#x2014; material icon named "arrow circle up" (round).
  static const IconData arrow_circle_up_rounded = IconData(0xf574, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">arrow_circle_up</i> &#x2014; material icon named "arrow circle up" (outlined).
  static const IconData arrow_circle_up_outlined = IconData(0xee87, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">arrow_downward</i> &#x2014; material icon named "arrow downward".
  static const IconData arrow_downward = IconData(0xe097, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">arrow_downward</i> &#x2014; material icon named "arrow downward" (sharp).
  static const IconData arrow_downward_sharp = IconData(0xe796, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">arrow_downward</i> &#x2014; material icon named "arrow downward" (round).
  static const IconData arrow_downward_rounded = IconData(0xf575, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">arrow_downward</i> &#x2014; material icon named "arrow downward" (outlined).
  static const IconData arrow_downward_outlined = IconData(0xee88, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">arrow_drop_down</i> &#x2014; material icon named "arrow drop down".
  static const IconData arrow_drop_down = IconData(0xe098, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">arrow_drop_down</i> &#x2014; material icon named "arrow drop down" (sharp).
  static const IconData arrow_drop_down_sharp = IconData(0xe798, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">arrow_drop_down</i> &#x2014; material icon named "arrow drop down" (round).
  static const IconData arrow_drop_down_rounded = IconData(0xf577, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">arrow_drop_down</i> &#x2014; material icon named "arrow drop down" (outlined).
  static const IconData arrow_drop_down_outlined = IconData(0xee8a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">arrow_drop_down_circle</i> &#x2014; material icon named "arrow drop down circle".
  static const IconData arrow_drop_down_circle = IconData(0xe099, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">arrow_drop_down_circle</i> &#x2014; material icon named "arrow drop down circle" (sharp).
  static const IconData arrow_drop_down_circle_sharp = IconData(0xe797, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">arrow_drop_down_circle</i> &#x2014; material icon named "arrow drop down circle" (round).
  static const IconData arrow_drop_down_circle_rounded = IconData(0xf576, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">arrow_drop_down_circle</i> &#x2014; material icon named "arrow drop down circle" (outlined).
  static const IconData arrow_drop_down_circle_outlined = IconData(0xee89, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">arrow_drop_up</i> &#x2014; material icon named "arrow drop up".
  static const IconData arrow_drop_up = IconData(0xe09a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">arrow_drop_up</i> &#x2014; material icon named "arrow drop up" (sharp).
  static const IconData arrow_drop_up_sharp = IconData(0xe799, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">arrow_drop_up</i> &#x2014; material icon named "arrow drop up" (round).
  static const IconData arrow_drop_up_rounded = IconData(0xf578, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">arrow_drop_up</i> &#x2014; material icon named "arrow drop up" (outlined).
  static const IconData arrow_drop_up_outlined = IconData(0xee8b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">arrow_forward</i> &#x2014; material icon named "arrow forward".
  static const IconData arrow_forward = IconData(0xe09b, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">arrow_forward</i> &#x2014; material icon named "arrow forward" (sharp).
  static const IconData arrow_forward_sharp = IconData(0xe79b, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">arrow_forward</i> &#x2014; material icon named "arrow forward" (round).
  static const IconData arrow_forward_rounded = IconData(0xf57a, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">arrow_forward</i> &#x2014; material icon named "arrow forward" (outlined).
  static const IconData arrow_forward_outlined = IconData(0xee8d, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">arrow_forward_ios</i> &#x2014; material icon named "arrow forward ios".
  static const IconData arrow_forward_ios = IconData(0xe09c, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">arrow_forward_ios</i> &#x2014; material icon named "arrow forward ios" (sharp).
  static const IconData arrow_forward_ios_sharp = IconData(0xe79a, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">arrow_forward_ios</i> &#x2014; material icon named "arrow forward ios" (round).
  static const IconData arrow_forward_ios_rounded = IconData(0xf579, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">arrow_forward_ios</i> &#x2014; material icon named "arrow forward ios" (outlined).
  static const IconData arrow_forward_ios_outlined = IconData(0xee8c, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">arrow_left</i> &#x2014; material icon named "arrow left".
  static const IconData arrow_left = IconData(0xe09d, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">arrow_left</i> &#x2014; material icon named "arrow left" (sharp).
  static const IconData arrow_left_sharp = IconData(0xe79c, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">arrow_left</i> &#x2014; material icon named "arrow left" (round).
  static const IconData arrow_left_rounded = IconData(0xf57b, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">arrow_left</i> &#x2014; material icon named "arrow left" (outlined).
  static const IconData arrow_left_outlined = IconData(0xee8e, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">arrow_right</i> &#x2014; material icon named "arrow right".
  static const IconData arrow_right = IconData(0xe09e, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">arrow_right</i> &#x2014; material icon named "arrow right" (sharp).
  static const IconData arrow_right_sharp = IconData(0xe79e, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">arrow_right</i> &#x2014; material icon named "arrow right" (round).
  static const IconData arrow_right_rounded = IconData(0xf57d, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">arrow_right</i> &#x2014; material icon named "arrow right" (outlined).
  static const IconData arrow_right_outlined = IconData(0xee90, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">arrow_right_alt</i> &#x2014; material icon named "arrow right alt".
  static const IconData arrow_right_alt = IconData(0xe09f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">arrow_right_alt</i> &#x2014; material icon named "arrow right alt" (sharp).
  static const IconData arrow_right_alt_sharp = IconData(0xe79d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">arrow_right_alt</i> &#x2014; material icon named "arrow right alt" (round).
  static const IconData arrow_right_alt_rounded = IconData(0xf57c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">arrow_right_alt</i> &#x2014; material icon named "arrow right alt" (outlined).
  static const IconData arrow_right_alt_outlined = IconData(0xee8f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">arrow_upward</i> &#x2014; material icon named "arrow upward".
  static const IconData arrow_upward = IconData(0xe0a0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">arrow_upward</i> &#x2014; material icon named "arrow upward" (sharp).
  static const IconData arrow_upward_sharp = IconData(0xe79f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">arrow_upward</i> &#x2014; material icon named "arrow upward" (round).
  static const IconData arrow_upward_rounded = IconData(0xf57e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">arrow_upward</i> &#x2014; material icon named "arrow upward" (outlined).
  static const IconData arrow_upward_outlined = IconData(0xee91, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">art_track</i> &#x2014; material icon named "art track".
  static const IconData art_track = IconData(0xe0a1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">art_track</i> &#x2014; material icon named "art track" (sharp).
  static const IconData art_track_sharp = IconData(0xe7a0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">art_track</i> &#x2014; material icon named "art track" (round).
  static const IconData art_track_rounded = IconData(0xf57f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">art_track</i> &#x2014; material icon named "art track" (outlined).
  static const IconData art_track_outlined = IconData(0xee92, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">article</i> &#x2014; material icon named "article".
  static const IconData article = IconData(0xe0a2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">article</i> &#x2014; material icon named "article" (sharp).
  static const IconData article_sharp = IconData(0xe7a1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">article</i> &#x2014; material icon named "article" (round).
  static const IconData article_rounded = IconData(0xf580, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">article</i> &#x2014; material icon named "article" (outlined).
  static const IconData article_outlined = IconData(0xee93, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">aspect_ratio</i> &#x2014; material icon named "aspect ratio".
  static const IconData aspect_ratio = IconData(0xe0a3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">aspect_ratio</i> &#x2014; material icon named "aspect ratio" (sharp).
  static const IconData aspect_ratio_sharp = IconData(0xe7a2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">aspect_ratio</i> &#x2014; material icon named "aspect ratio" (round).
  static const IconData aspect_ratio_rounded = IconData(0xf581, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">aspect_ratio</i> &#x2014; material icon named "aspect ratio" (outlined).
  static const IconData aspect_ratio_outlined = IconData(0xee94, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">assessment</i> &#x2014; material icon named "assessment".
  static const IconData assessment = IconData(0xe0a4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">assessment</i> &#x2014; material icon named "assessment" (sharp).
  static const IconData assessment_sharp = IconData(0xe7a3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">assessment</i> &#x2014; material icon named "assessment" (round).
  static const IconData assessment_rounded = IconData(0xf582, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">assessment</i> &#x2014; material icon named "assessment" (outlined).
  static const IconData assessment_outlined = IconData(0xee95, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">assignment</i> &#x2014; material icon named "assignment".
  static const IconData assignment = IconData(0xe0a5, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">assignment</i> &#x2014; material icon named "assignment" (sharp).
  static const IconData assignment_sharp = IconData(0xe7a8, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">assignment</i> &#x2014; material icon named "assignment" (round).
  static const IconData assignment_rounded = IconData(0xf587, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">assignment</i> &#x2014; material icon named "assignment" (outlined).
  static const IconData assignment_outlined = IconData(0xee98, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">assignment_ind</i> &#x2014; material icon named "assignment ind".
  static const IconData assignment_ind = IconData(0xe0a6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">assignment_ind</i> &#x2014; material icon named "assignment ind" (sharp).
  static const IconData assignment_ind_sharp = IconData(0xe7a4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">assignment_ind</i> &#x2014; material icon named "assignment ind" (round).
  static const IconData assignment_ind_rounded = IconData(0xf583, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">assignment_ind</i> &#x2014; material icon named "assignment ind" (outlined).
  static const IconData assignment_ind_outlined = IconData(0xee96, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">assignment_late</i> &#x2014; material icon named "assignment late".
  static const IconData assignment_late = IconData(0xe0a7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">assignment_late</i> &#x2014; material icon named "assignment late" (sharp).
  static const IconData assignment_late_sharp = IconData(0xe7a5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">assignment_late</i> &#x2014; material icon named "assignment late" (round).
  static const IconData assignment_late_rounded = IconData(0xf584, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">assignment_late</i> &#x2014; material icon named "assignment late" (outlined).
  static const IconData assignment_late_outlined = IconData(0xee97, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">assignment_return</i> &#x2014; material icon named "assignment return".
  static const IconData assignment_return = IconData(0xe0a8, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">assignment_return</i> &#x2014; material icon named "assignment return" (sharp).
  static const IconData assignment_return_sharp = IconData(0xe7a6, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">assignment_return</i> &#x2014; material icon named "assignment return" (round).
  static const IconData assignment_return_rounded = IconData(0xf585, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">assignment_return</i> &#x2014; material icon named "assignment return" (outlined).
  static const IconData assignment_return_outlined = IconData(0xee99, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">assignment_returned</i> &#x2014; material icon named "assignment returned".
  static const IconData assignment_returned = IconData(0xe0a9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">assignment_returned</i> &#x2014; material icon named "assignment returned" (sharp).
  static const IconData assignment_returned_sharp = IconData(0xe7a7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">assignment_returned</i> &#x2014; material icon named "assignment returned" (round).
  static const IconData assignment_returned_rounded = IconData(0xf586, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">assignment_returned</i> &#x2014; material icon named "assignment returned" (outlined).
  static const IconData assignment_returned_outlined = IconData(0xee9a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">assignment_turned_in</i> &#x2014; material icon named "assignment turned in".
  static const IconData assignment_turned_in = IconData(0xe0aa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">assignment_turned_in</i> &#x2014; material icon named "assignment turned in" (sharp).
  static const IconData assignment_turned_in_sharp = IconData(0xe7a9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">assignment_turned_in</i> &#x2014; material icon named "assignment turned in" (round).
  static const IconData assignment_turned_in_rounded = IconData(0xf588, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">assignment_turned_in</i> &#x2014; material icon named "assignment turned in" (outlined).
  static const IconData assignment_turned_in_outlined = IconData(0xee9b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">assistant</i> &#x2014; material icon named "assistant".
  static const IconData assistant = IconData(0xe0ab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">assistant</i> &#x2014; material icon named "assistant" (sharp).
  static const IconData assistant_sharp = IconData(0xe7ac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">assistant</i> &#x2014; material icon named "assistant" (round).
  static const IconData assistant_rounded = IconData(0xf58b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">assistant</i> &#x2014; material icon named "assistant" (outlined).
  static const IconData assistant_outlined = IconData(0xee9d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">assistant_direction</i> &#x2014; material icon named "assistant direction".
  static const IconData assistant_direction = IconData(0xe0ac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">assistant_direction</i> &#x2014; material icon named "assistant direction" (sharp).
  static const IconData assistant_direction_sharp = IconData(0xe7aa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">assistant_direction</i> &#x2014; material icon named "assistant direction" (round).
  static const IconData assistant_direction_rounded = IconData(0xf589, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">assistant_direction</i> &#x2014; material icon named "assistant direction" (outlined).
  static const IconData assistant_direction_outlined = IconData(0xee9c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">assistant_navigation</i> &#x2014; material icon named "assistant navigation".
  static const IconData assistant_navigation = IconData(0xe0ad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">assistant_photo</i> &#x2014; material icon named "assistant photo".
  static const IconData assistant_photo = IconData(0xe0ae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">assistant_photo</i> &#x2014; material icon named "assistant photo" (sharp).
  static const IconData assistant_photo_sharp = IconData(0xe7ab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">assistant_photo</i> &#x2014; material icon named "assistant photo" (round).
  static const IconData assistant_photo_rounded = IconData(0xf58a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">assistant_photo</i> &#x2014; material icon named "assistant photo" (outlined).
  static const IconData assistant_photo_outlined = IconData(0xee9e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">atm</i> &#x2014; material icon named "atm".
  static const IconData atm = IconData(0xe0af, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">atm</i> &#x2014; material icon named "atm" (sharp).
  static const IconData atm_sharp = IconData(0xe7ad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">atm</i> &#x2014; material icon named "atm" (round).
  static const IconData atm_rounded = IconData(0xf58c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">atm</i> &#x2014; material icon named "atm" (outlined).
  static const IconData atm_outlined = IconData(0xee9f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">attach_email</i> &#x2014; material icon named "attach email".
  static const IconData attach_email = IconData(0xe0b0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">attach_email</i> &#x2014; material icon named "attach email" (sharp).
  static const IconData attach_email_sharp = IconData(0xe7ae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">attach_email</i> &#x2014; material icon named "attach email" (round).
  static const IconData attach_email_rounded = IconData(0xf58d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">attach_email</i> &#x2014; material icon named "attach email" (outlined).
  static const IconData attach_email_outlined = IconData(0xeea0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">attach_file</i> &#x2014; material icon named "attach file".
  static const IconData attach_file = IconData(0xe0b1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">attach_file</i> &#x2014; material icon named "attach file" (sharp).
  static const IconData attach_file_sharp = IconData(0xe7af, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">attach_file</i> &#x2014; material icon named "attach file" (round).
  static const IconData attach_file_rounded = IconData(0xf58e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">attach_file</i> &#x2014; material icon named "attach file" (outlined).
  static const IconData attach_file_outlined = IconData(0xeea1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">attach_money</i> &#x2014; material icon named "attach money".
  static const IconData attach_money = IconData(0xe0b2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">attach_money</i> &#x2014; material icon named "attach money" (sharp).
  static const IconData attach_money_sharp = IconData(0xe7b0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">attach_money</i> &#x2014; material icon named "attach money" (round).
  static const IconData attach_money_rounded = IconData(0xf58f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">attach_money</i> &#x2014; material icon named "attach money" (outlined).
  static const IconData attach_money_outlined = IconData(0xeea2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">attachment</i> &#x2014; material icon named "attachment".
  static const IconData attachment = IconData(0xe0b3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">attachment</i> &#x2014; material icon named "attachment" (sharp).
  static const IconData attachment_sharp = IconData(0xe7b1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">attachment</i> &#x2014; material icon named "attachment" (round).
  static const IconData attachment_rounded = IconData(0xf590, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">attachment</i> &#x2014; material icon named "attachment" (outlined).
  static const IconData attachment_outlined = IconData(0xeea3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">attractions</i> &#x2014; material icon named "attractions".
  static const IconData attractions = IconData(0xe0b4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">attractions</i> &#x2014; material icon named "attractions" (sharp).
  static const IconData attractions_sharp = IconData(0xe7b2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">attractions</i> &#x2014; material icon named "attractions" (round).
  static const IconData attractions_rounded = IconData(0xf591, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">attractions</i> &#x2014; material icon named "attractions" (outlined).
  static const IconData attractions_outlined = IconData(0xeea4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">attribution</i> &#x2014; material icon named "attribution".
  static const IconData attribution = IconData(0xe0b5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">attribution</i> &#x2014; material icon named "attribution" (sharp).
  static const IconData attribution_sharp = IconData(0xe7b3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">attribution</i> &#x2014; material icon named "attribution" (round).
  static const IconData attribution_rounded = IconData(0xf592, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">attribution</i> &#x2014; material icon named "attribution" (outlined).
  static const IconData attribution_outlined = IconData(0xeea5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">audiotrack</i> &#x2014; material icon named "audiotrack".
  static const IconData audiotrack = IconData(0xe0b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">audiotrack</i> &#x2014; material icon named "audiotrack" (sharp).
  static const IconData audiotrack_sharp = IconData(0xe7b4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">audiotrack</i> &#x2014; material icon named "audiotrack" (round).
  static const IconData audiotrack_rounded = IconData(0xf593, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">audiotrack</i> &#x2014; material icon named "audiotrack" (outlined).
  static const IconData audiotrack_outlined = IconData(0xeea6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">auto_awesome</i> &#x2014; material icon named "auto awesome".
  static const IconData auto_awesome = IconData(0xe0b7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">auto_awesome</i> &#x2014; material icon named "auto awesome" (sharp).
  static const IconData auto_awesome_sharp = IconData(0xe7b7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">auto_awesome</i> &#x2014; material icon named "auto awesome" (round).
  static const IconData auto_awesome_rounded = IconData(0xf596, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">auto_awesome</i> &#x2014; material icon named "auto awesome" (outlined).
  static const IconData auto_awesome_outlined = IconData(0xeea9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">auto_awesome_mosaic</i> &#x2014; material icon named "auto awesome mosaic".
  static const IconData auto_awesome_mosaic = IconData(0xe0b8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">auto_awesome_mosaic</i> &#x2014; material icon named "auto awesome mosaic" (sharp).
  static const IconData auto_awesome_mosaic_sharp = IconData(0xe7b5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">auto_awesome_mosaic</i> &#x2014; material icon named "auto awesome mosaic" (round).
  static const IconData auto_awesome_mosaic_rounded = IconData(0xf594, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">auto_awesome_mosaic</i> &#x2014; material icon named "auto awesome mosaic" (outlined).
  static const IconData auto_awesome_mosaic_outlined = IconData(0xeea7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">auto_awesome_motion</i> &#x2014; material icon named "auto awesome motion".
  static const IconData auto_awesome_motion = IconData(0xe0b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">auto_awesome_motion</i> &#x2014; material icon named "auto awesome motion" (sharp).
  static const IconData auto_awesome_motion_sharp = IconData(0xe7b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">auto_awesome_motion</i> &#x2014; material icon named "auto awesome motion" (round).
  static const IconData auto_awesome_motion_rounded = IconData(0xf595, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">auto_awesome_motion</i> &#x2014; material icon named "auto awesome motion" (outlined).
  static const IconData auto_awesome_motion_outlined = IconData(0xeea8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">auto_delete</i> &#x2014; material icon named "auto delete".
  static const IconData auto_delete = IconData(0xe0ba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">auto_delete</i> &#x2014; material icon named "auto delete" (sharp).
  static const IconData auto_delete_sharp = IconData(0xe7b8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">auto_delete</i> &#x2014; material icon named "auto delete" (round).
  static const IconData auto_delete_rounded = IconData(0xf597, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">auto_delete</i> &#x2014; material icon named "auto delete" (outlined).
  static const IconData auto_delete_outlined = IconData(0xeeaa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">auto_fix_high</i> &#x2014; material icon named "auto fix high".
  static const IconData auto_fix_high = IconData(0xe0bb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">auto_fix_high</i> &#x2014; material icon named "auto fix high" (sharp).
  static const IconData auto_fix_high_sharp = IconData(0xe7b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">auto_fix_high</i> &#x2014; material icon named "auto fix high" (round).
  static const IconData auto_fix_high_rounded = IconData(0xf598, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">auto_fix_high</i> &#x2014; material icon named "auto fix high" (outlined).
  static const IconData auto_fix_high_outlined = IconData(0xeeab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">auto_fix_normal</i> &#x2014; material icon named "auto fix normal".
  static const IconData auto_fix_normal = IconData(0xe0bc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">auto_fix_normal</i> &#x2014; material icon named "auto fix normal" (sharp).
  static const IconData auto_fix_normal_sharp = IconData(0xe7ba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">auto_fix_normal</i> &#x2014; material icon named "auto fix normal" (round).
  static const IconData auto_fix_normal_rounded = IconData(0xf599, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">auto_fix_normal</i> &#x2014; material icon named "auto fix normal" (outlined).
  static const IconData auto_fix_normal_outlined = IconData(0xeeac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">auto_fix_off</i> &#x2014; material icon named "auto fix off".
  static const IconData auto_fix_off = IconData(0xe0bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">auto_fix_off</i> &#x2014; material icon named "auto fix off" (sharp).
  static const IconData auto_fix_off_sharp = IconData(0xe7bb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">auto_fix_off</i> &#x2014; material icon named "auto fix off" (round).
  static const IconData auto_fix_off_rounded = IconData(0xf59a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">auto_fix_off</i> &#x2014; material icon named "auto fix off" (outlined).
  static const IconData auto_fix_off_outlined = IconData(0xeead, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">auto_graph</i> &#x2014; material icon named "auto graph".
  static const IconData auto_graph = IconData(0xe0be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">auto_graph</i> &#x2014; material icon named "auto graph" (sharp).
  static const IconData auto_graph_sharp = IconData(0xe7bc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">auto_graph</i> &#x2014; material icon named "auto graph" (round).
  static const IconData auto_graph_rounded = IconData(0xf59b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">auto_graph</i> &#x2014; material icon named "auto graph" (outlined).
  static const IconData auto_graph_outlined = IconData(0xeeae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">auto_stories</i> &#x2014; material icon named "auto stories".
  static const IconData auto_stories = IconData(0xe0bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">auto_stories</i> &#x2014; material icon named "auto stories" (sharp).
  static const IconData auto_stories_sharp = IconData(0xe7bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">auto_stories</i> &#x2014; material icon named "auto stories" (round).
  static const IconData auto_stories_rounded = IconData(0xf59c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">auto_stories</i> &#x2014; material icon named "auto stories" (outlined).
  static const IconData auto_stories_outlined = IconData(0xeeaf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">autofps_select</i> &#x2014; material icon named "autofps select".
  static const IconData autofps_select = IconData(0xe0c0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">autofps_select</i> &#x2014; material icon named "autofps select" (sharp).
  static const IconData autofps_select_sharp = IconData(0xe7be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">autofps_select</i> &#x2014; material icon named "autofps select" (round).
  static const IconData autofps_select_rounded = IconData(0xf59d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">autofps_select</i> &#x2014; material icon named "autofps select" (outlined).
  static const IconData autofps_select_outlined = IconData(0xeeb0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">autorenew</i> &#x2014; material icon named "autorenew".
  static const IconData autorenew = IconData(0xe0c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">autorenew</i> &#x2014; material icon named "autorenew" (sharp).
  static const IconData autorenew_sharp = IconData(0xe7bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">autorenew</i> &#x2014; material icon named "autorenew" (round).
  static const IconData autorenew_rounded = IconData(0xf59e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">autorenew</i> &#x2014; material icon named "autorenew" (outlined).
  static const IconData autorenew_outlined = IconData(0xeeb1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">av_timer</i> &#x2014; material icon named "av timer".
  static const IconData av_timer = IconData(0xe0c2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">av_timer</i> &#x2014; material icon named "av timer" (sharp).
  static const IconData av_timer_sharp = IconData(0xe7c0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">av_timer</i> &#x2014; material icon named "av timer" (round).
  static const IconData av_timer_rounded = IconData(0xf59f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">av_timer</i> &#x2014; material icon named "av timer" (outlined).
  static const IconData av_timer_outlined = IconData(0xeeb2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">baby_changing_station</i> &#x2014; material icon named "baby changing station".
  static const IconData baby_changing_station = IconData(0xe0c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">baby_changing_station</i> &#x2014; material icon named "baby changing station" (sharp).
  static const IconData baby_changing_station_sharp = IconData(0xe7c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">baby_changing_station</i> &#x2014; material icon named "baby changing station" (round).
  static const IconData baby_changing_station_rounded = IconData(0xf5a0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">baby_changing_station</i> &#x2014; material icon named "baby changing station" (outlined).
  static const IconData baby_changing_station_outlined = IconData(0xeeb3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">backpack</i> &#x2014; material icon named "backpack".
  static const IconData backpack = IconData(0xe0c4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">backpack</i> &#x2014; material icon named "backpack" (sharp).
  static const IconData backpack_sharp = IconData(0xe7c2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">backpack</i> &#x2014; material icon named "backpack" (round).
  static const IconData backpack_rounded = IconData(0xf5a1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">backpack</i> &#x2014; material icon named "backpack" (outlined).
  static const IconData backpack_outlined = IconData(0xeeb4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">backspace</i> &#x2014; material icon named "backspace".
  static const IconData backspace = IconData(0xe0c5, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">backspace</i> &#x2014; material icon named "backspace" (sharp).
  static const IconData backspace_sharp = IconData(0xe7c3, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">backspace</i> &#x2014; material icon named "backspace" (round).
  static const IconData backspace_rounded = IconData(0xf5a2, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">backspace</i> &#x2014; material icon named "backspace" (outlined).
  static const IconData backspace_outlined = IconData(0xeeb5, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">backup</i> &#x2014; material icon named "backup".
  static const IconData backup = IconData(0xe0c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">backup</i> &#x2014; material icon named "backup" (sharp).
  static const IconData backup_sharp = IconData(0xe7c4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">backup</i> &#x2014; material icon named "backup" (round).
  static const IconData backup_rounded = IconData(0xf5a3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">backup</i> &#x2014; material icon named "backup" (outlined).
  static const IconData backup_outlined = IconData(0xeeb6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">backup_table</i> &#x2014; material icon named "backup table".
  static const IconData backup_table = IconData(0xe0c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">backup_table</i> &#x2014; material icon named "backup table" (sharp).
  static const IconData backup_table_sharp = IconData(0xe7c5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">backup_table</i> &#x2014; material icon named "backup table" (round).
  static const IconData backup_table_rounded = IconData(0xf5a4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">backup_table</i> &#x2014; material icon named "backup table" (outlined).
  static const IconData backup_table_outlined = IconData(0xeeb7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">badge</i> &#x2014; material icon named "badge".
  static const IconData badge = IconData(0xe0c8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">badge</i> &#x2014; material icon named "badge" (sharp).
  static const IconData badge_sharp = IconData(0xe7c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">badge</i> &#x2014; material icon named "badge" (round).
  static const IconData badge_rounded = IconData(0xf5a5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">badge</i> &#x2014; material icon named "badge" (outlined).
  static const IconData badge_outlined = IconData(0xeeb8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bakery_dining</i> &#x2014; material icon named "bakery dining".
  static const IconData bakery_dining = IconData(0xe0c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bakery_dining</i> &#x2014; material icon named "bakery dining" (sharp).
  static const IconData bakery_dining_sharp = IconData(0xe7c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bakery_dining</i> &#x2014; material icon named "bakery dining" (round).
  static const IconData bakery_dining_rounded = IconData(0xf5a6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bakery_dining</i> &#x2014; material icon named "bakery dining" (outlined).
  static const IconData bakery_dining_outlined = IconData(0xeeb9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">balcony</i> &#x2014; material icon named "balcony".
  static const IconData balcony = IconData(0xe0ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">balcony</i> &#x2014; material icon named "balcony" (sharp).
  static const IconData balcony_sharp = IconData(0xe7c8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">balcony</i> &#x2014; material icon named "balcony" (round).
  static const IconData balcony_rounded = IconData(0xf5a7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">balcony</i> &#x2014; material icon named "balcony" (outlined).
  static const IconData balcony_outlined = IconData(0xeeba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">ballot</i> &#x2014; material icon named "ballot".
  static const IconData ballot = IconData(0xe0cb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">ballot</i> &#x2014; material icon named "ballot" (sharp).
  static const IconData ballot_sharp = IconData(0xe7c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">ballot</i> &#x2014; material icon named "ballot" (round).
  static const IconData ballot_rounded = IconData(0xf5a8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">ballot</i> &#x2014; material icon named "ballot" (outlined).
  static const IconData ballot_outlined = IconData(0xeebb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bar_chart</i> &#x2014; material icon named "bar chart".
  static const IconData bar_chart = IconData(0xe0cc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bar_chart</i> &#x2014; material icon named "bar chart" (sharp).
  static const IconData bar_chart_sharp = IconData(0xe7ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bar_chart</i> &#x2014; material icon named "bar chart" (round).
  static const IconData bar_chart_rounded = IconData(0xf5a9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bar_chart</i> &#x2014; material icon named "bar chart" (outlined).
  static const IconData bar_chart_outlined = IconData(0xeebc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">batch_prediction</i> &#x2014; material icon named "batch prediction".
  static const IconData batch_prediction = IconData(0xe0cd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">batch_prediction</i> &#x2014; material icon named "batch prediction" (sharp).
  static const IconData batch_prediction_sharp = IconData(0xe7cb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">batch_prediction</i> &#x2014; material icon named "batch prediction" (round).
  static const IconData batch_prediction_rounded = IconData(0xf5aa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">batch_prediction</i> &#x2014; material icon named "batch prediction" (outlined).
  static const IconData batch_prediction_outlined = IconData(0xeebd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bathroom</i> &#x2014; material icon named "bathroom".
  static const IconData bathroom = IconData(0xe0ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bathroom</i> &#x2014; material icon named "bathroom" (sharp).
  static const IconData bathroom_sharp = IconData(0xe7cc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bathroom</i> &#x2014; material icon named "bathroom" (round).
  static const IconData bathroom_rounded = IconData(0xf5ab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bathroom</i> &#x2014; material icon named "bathroom" (outlined).
  static const IconData bathroom_outlined = IconData(0xeebe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bathtub</i> &#x2014; material icon named "bathtub".
  static const IconData bathtub = IconData(0xe0cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bathtub</i> &#x2014; material icon named "bathtub" (sharp).
  static const IconData bathtub_sharp = IconData(0xe7cd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bathtub</i> &#x2014; material icon named "bathtub" (round).
  static const IconData bathtub_rounded = IconData(0xf5ac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bathtub</i> &#x2014; material icon named "bathtub" (outlined).
  static const IconData bathtub_outlined = IconData(0xeebf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">battery_alert</i> &#x2014; material icon named "battery alert".
  static const IconData battery_alert = IconData(0xe0d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">battery_alert</i> &#x2014; material icon named "battery alert" (sharp).
  static const IconData battery_alert_sharp = IconData(0xe7ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">battery_alert</i> &#x2014; material icon named "battery alert" (round).
  static const IconData battery_alert_rounded = IconData(0xf5ad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">battery_alert</i> &#x2014; material icon named "battery alert" (outlined).
  static const IconData battery_alert_outlined = IconData(0xeec0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">battery_charging_full</i> &#x2014; material icon named "battery charging full".
  static const IconData battery_charging_full = IconData(0xe0d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">battery_charging_full</i> &#x2014; material icon named "battery charging full" (sharp).
  static const IconData battery_charging_full_sharp = IconData(0xe7cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">battery_charging_full</i> &#x2014; material icon named "battery charging full" (round).
  static const IconData battery_charging_full_rounded = IconData(0xf5ae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">battery_charging_full</i> &#x2014; material icon named "battery charging full" (outlined).
  static const IconData battery_charging_full_outlined = IconData(0xeec1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">battery_full</i> &#x2014; material icon named "battery full".
  static const IconData battery_full = IconData(0xe0d2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">battery_full</i> &#x2014; material icon named "battery full" (sharp).
  static const IconData battery_full_sharp = IconData(0xe7d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">battery_full</i> &#x2014; material icon named "battery full" (round).
  static const IconData battery_full_rounded = IconData(0xf5af, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">battery_full</i> &#x2014; material icon named "battery full" (outlined).
  static const IconData battery_full_outlined = IconData(0xeec2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">battery_saver</i> &#x2014; material icon named "battery saver".
  static const IconData battery_saver = IconData(0xe0d3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">battery_saver</i> &#x2014; material icon named "battery saver" (sharp).
  static const IconData battery_saver_sharp = IconData(0xe7d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">battery_saver</i> &#x2014; material icon named "battery saver" (round).
  static const IconData battery_saver_rounded = IconData(0xf5b0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">battery_saver</i> &#x2014; material icon named "battery saver" (outlined).
  static const IconData battery_saver_outlined = IconData(0xeec3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">battery_std</i> &#x2014; material icon named "battery std".
  static const IconData battery_std = IconData(0xe0d4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">battery_std</i> &#x2014; material icon named "battery std" (sharp).
  static const IconData battery_std_sharp = IconData(0xe7d2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">battery_std</i> &#x2014; material icon named "battery std" (round).
  static const IconData battery_std_rounded = IconData(0xf5b1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">battery_std</i> &#x2014; material icon named "battery std" (outlined).
  static const IconData battery_std_outlined = IconData(0xeec4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">battery_unknown</i> &#x2014; material icon named "battery unknown".
  static const IconData battery_unknown = IconData(0xe0d5, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">battery_unknown</i> &#x2014; material icon named "battery unknown" (sharp).
  static const IconData battery_unknown_sharp = IconData(0xe7d3, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">battery_unknown</i> &#x2014; material icon named "battery unknown" (round).
  static const IconData battery_unknown_rounded = IconData(0xf5b2, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">battery_unknown</i> &#x2014; material icon named "battery unknown" (outlined).
  static const IconData battery_unknown_outlined = IconData(0xeec5, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">beach_access</i> &#x2014; material icon named "beach access".
  static const IconData beach_access = IconData(0xe0d6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">beach_access</i> &#x2014; material icon named "beach access" (sharp).
  static const IconData beach_access_sharp = IconData(0xe7d4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">beach_access</i> &#x2014; material icon named "beach access" (round).
  static const IconData beach_access_rounded = IconData(0xf5b3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">beach_access</i> &#x2014; material icon named "beach access" (outlined).
  static const IconData beach_access_outlined = IconData(0xeec6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bed</i> &#x2014; material icon named "bed".
  static const IconData bed = IconData(0xe0d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bed</i> &#x2014; material icon named "bed" (sharp).
  static const IconData bed_sharp = IconData(0xe7d5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bed</i> &#x2014; material icon named "bed" (round).
  static const IconData bed_rounded = IconData(0xf5b4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bed</i> &#x2014; material icon named "bed" (outlined).
  static const IconData bed_outlined = IconData(0xeec7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bedroom_baby</i> &#x2014; material icon named "bedroom baby".
  static const IconData bedroom_baby = IconData(0xe0d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bedroom_baby</i> &#x2014; material icon named "bedroom baby" (sharp).
  static const IconData bedroom_baby_sharp = IconData(0xe7d6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bedroom_baby</i> &#x2014; material icon named "bedroom baby" (round).
  static const IconData bedroom_baby_rounded = IconData(0xf5b5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bedroom_baby</i> &#x2014; material icon named "bedroom baby" (outlined).
  static const IconData bedroom_baby_outlined = IconData(0xeec8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bedroom_child</i> &#x2014; material icon named "bedroom child".
  static const IconData bedroom_child = IconData(0xe0d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bedroom_child</i> &#x2014; material icon named "bedroom child" (sharp).
  static const IconData bedroom_child_sharp = IconData(0xe7d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bedroom_child</i> &#x2014; material icon named "bedroom child" (round).
  static const IconData bedroom_child_rounded = IconData(0xf5b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bedroom_child</i> &#x2014; material icon named "bedroom child" (outlined).
  static const IconData bedroom_child_outlined = IconData(0xeec9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bedroom_parent</i> &#x2014; material icon named "bedroom parent".
  static const IconData bedroom_parent = IconData(0xe0da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bedroom_parent</i> &#x2014; material icon named "bedroom parent" (sharp).
  static const IconData bedroom_parent_sharp = IconData(0xe7d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bedroom_parent</i> &#x2014; material icon named "bedroom parent" (round).
  static const IconData bedroom_parent_rounded = IconData(0xf5b7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bedroom_parent</i> &#x2014; material icon named "bedroom parent" (outlined).
  static const IconData bedroom_parent_outlined = IconData(0xeeca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bedtime</i> &#x2014; material icon named "bedtime".
  static const IconData bedtime = IconData(0xe0db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bedtime</i> &#x2014; material icon named "bedtime" (sharp).
  static const IconData bedtime_sharp = IconData(0xe7d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bedtime</i> &#x2014; material icon named "bedtime" (round).
  static const IconData bedtime_rounded = IconData(0xf5b8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bedtime</i> &#x2014; material icon named "bedtime" (outlined).
  static const IconData bedtime_outlined = IconData(0xeecb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">beenhere</i> &#x2014; material icon named "beenhere".
  static const IconData beenhere = IconData(0xe0dc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">beenhere</i> &#x2014; material icon named "beenhere" (sharp).
  static const IconData beenhere_sharp = IconData(0xe7da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">beenhere</i> &#x2014; material icon named "beenhere" (round).
  static const IconData beenhere_rounded = IconData(0xf5b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">beenhere</i> &#x2014; material icon named "beenhere" (outlined).
  static const IconData beenhere_outlined = IconData(0xeecc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bento</i> &#x2014; material icon named "bento".
  static const IconData bento = IconData(0xe0dd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bento</i> &#x2014; material icon named "bento" (sharp).
  static const IconData bento_sharp = IconData(0xe7db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bento</i> &#x2014; material icon named "bento" (round).
  static const IconData bento_rounded = IconData(0xf5ba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bento</i> &#x2014; material icon named "bento" (outlined).
  static const IconData bento_outlined = IconData(0xeecd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bike_scooter</i> &#x2014; material icon named "bike scooter".
  static const IconData bike_scooter = IconData(0xe0de, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bike_scooter</i> &#x2014; material icon named "bike scooter" (sharp).
  static const IconData bike_scooter_sharp = IconData(0xe7dc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bike_scooter</i> &#x2014; material icon named "bike scooter" (round).
  static const IconData bike_scooter_rounded = IconData(0xf5bb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bike_scooter</i> &#x2014; material icon named "bike scooter" (outlined).
  static const IconData bike_scooter_outlined = IconData(0xeece, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">biotech</i> &#x2014; material icon named "biotech".
  static const IconData biotech = IconData(0xe0df, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">biotech</i> &#x2014; material icon named "biotech" (sharp).
  static const IconData biotech_sharp = IconData(0xe7dd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">biotech</i> &#x2014; material icon named "biotech" (round).
  static const IconData biotech_rounded = IconData(0xf5bc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">biotech</i> &#x2014; material icon named "biotech" (outlined).
  static const IconData biotech_outlined = IconData(0xeecf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">blender</i> &#x2014; material icon named "blender".
  static const IconData blender = IconData(0xe0e0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">blender</i> &#x2014; material icon named "blender" (sharp).
  static const IconData blender_sharp = IconData(0xe7de, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">blender</i> &#x2014; material icon named "blender" (round).
  static const IconData blender_rounded = IconData(0xf5bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">blender</i> &#x2014; material icon named "blender" (outlined).
  static const IconData blender_outlined = IconData(0xeed0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">block</i> &#x2014; material icon named "block".
  static const IconData block = IconData(0xe0e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">block</i> &#x2014; material icon named "block" (sharp).
  static const IconData block_sharp = IconData(0xe7df, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">block</i> &#x2014; material icon named "block" (round).
  static const IconData block_rounded = IconData(0xf5be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">block</i> &#x2014; material icon named "block" (outlined).
  static const IconData block_outlined = IconData(0xeed1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">block_flipped</i> &#x2014; material icon named "block flipped".
  static const IconData block_flipped = IconData(0xe0e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bloodtype</i> &#x2014; material icon named "bloodtype".
  static const IconData bloodtype = IconData(0xe0e3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bloodtype</i> &#x2014; material icon named "bloodtype" (sharp).
  static const IconData bloodtype_sharp = IconData(0xe7e0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bloodtype</i> &#x2014; material icon named "bloodtype" (round).
  static const IconData bloodtype_rounded = IconData(0xf5bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bloodtype</i> &#x2014; material icon named "bloodtype" (outlined).
  static const IconData bloodtype_outlined = IconData(0xeed2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bluetooth</i> &#x2014; material icon named "bluetooth".
  static const IconData bluetooth = IconData(0xe0e4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bluetooth</i> &#x2014; material icon named "bluetooth" (sharp).
  static const IconData bluetooth_sharp = IconData(0xe7e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bluetooth</i> &#x2014; material icon named "bluetooth" (round).
  static const IconData bluetooth_rounded = IconData(0xf5c4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bluetooth</i> &#x2014; material icon named "bluetooth" (outlined).
  static const IconData bluetooth_outlined = IconData(0xeed7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bluetooth_audio</i> &#x2014; material icon named "bluetooth audio".
  static const IconData bluetooth_audio = IconData(0xe0e5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bluetooth_audio</i> &#x2014; material icon named "bluetooth audio" (sharp).
  static const IconData bluetooth_audio_sharp = IconData(0xe7e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bluetooth_audio</i> &#x2014; material icon named "bluetooth audio" (round).
  static const IconData bluetooth_audio_rounded = IconData(0xf5c0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bluetooth_audio</i> &#x2014; material icon named "bluetooth audio" (outlined).
  static const IconData bluetooth_audio_outlined = IconData(0xeed3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bluetooth_connected</i> &#x2014; material icon named "bluetooth connected".
  static const IconData bluetooth_connected = IconData(0xe0e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bluetooth_connected</i> &#x2014; material icon named "bluetooth connected" (sharp).
  static const IconData bluetooth_connected_sharp = IconData(0xe7e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bluetooth_connected</i> &#x2014; material icon named "bluetooth connected" (round).
  static const IconData bluetooth_connected_rounded = IconData(0xf5c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bluetooth_connected</i> &#x2014; material icon named "bluetooth connected" (outlined).
  static const IconData bluetooth_connected_outlined = IconData(0xeed4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bluetooth_disabled</i> &#x2014; material icon named "bluetooth disabled".
  static const IconData bluetooth_disabled = IconData(0xe0e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bluetooth_disabled</i> &#x2014; material icon named "bluetooth disabled" (sharp).
  static const IconData bluetooth_disabled_sharp = IconData(0xe7e3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bluetooth_disabled</i> &#x2014; material icon named "bluetooth disabled" (round).
  static const IconData bluetooth_disabled_rounded = IconData(0xf5c2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bluetooth_disabled</i> &#x2014; material icon named "bluetooth disabled" (outlined).
  static const IconData bluetooth_disabled_outlined = IconData(0xeed5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bluetooth_drive</i> &#x2014; material icon named "bluetooth drive".
  static const IconData bluetooth_drive = IconData(0xe0e8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bluetooth_drive</i> &#x2014; material icon named "bluetooth drive" (sharp).
  static const IconData bluetooth_drive_sharp = IconData(0xe7e4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bluetooth_drive</i> &#x2014; material icon named "bluetooth drive" (round).
  static const IconData bluetooth_drive_rounded = IconData(0xf5c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bluetooth_drive</i> &#x2014; material icon named "bluetooth drive" (outlined).
  static const IconData bluetooth_drive_outlined = IconData(0xeed6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bluetooth_searching</i> &#x2014; material icon named "bluetooth searching".
  static const IconData bluetooth_searching = IconData(0xe0e9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bluetooth_searching</i> &#x2014; material icon named "bluetooth searching" (sharp).
  static const IconData bluetooth_searching_sharp = IconData(0xe7e5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bluetooth_searching</i> &#x2014; material icon named "bluetooth searching" (round).
  static const IconData bluetooth_searching_rounded = IconData(0xf5c5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bluetooth_searching</i> &#x2014; material icon named "bluetooth searching" (outlined).
  static const IconData bluetooth_searching_outlined = IconData(0xeed8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">blur_circular</i> &#x2014; material icon named "blur circular".
  static const IconData blur_circular = IconData(0xe0ea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">blur_circular</i> &#x2014; material icon named "blur circular" (sharp).
  static const IconData blur_circular_sharp = IconData(0xe7e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">blur_circular</i> &#x2014; material icon named "blur circular" (round).
  static const IconData blur_circular_rounded = IconData(0xf5c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">blur_circular</i> &#x2014; material icon named "blur circular" (outlined).
  static const IconData blur_circular_outlined = IconData(0xeed9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">blur_linear</i> &#x2014; material icon named "blur linear".
  static const IconData blur_linear = IconData(0xe0eb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">blur_linear</i> &#x2014; material icon named "blur linear" (sharp).
  static const IconData blur_linear_sharp = IconData(0xe7e8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">blur_linear</i> &#x2014; material icon named "blur linear" (round).
  static const IconData blur_linear_rounded = IconData(0xf5c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">blur_linear</i> &#x2014; material icon named "blur linear" (outlined).
  static const IconData blur_linear_outlined = IconData(0xeeda, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">blur_off</i> &#x2014; material icon named "blur off".
  static const IconData blur_off = IconData(0xe0ec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">blur_off</i> &#x2014; material icon named "blur off" (sharp).
  static const IconData blur_off_sharp = IconData(0xe7e9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">blur_off</i> &#x2014; material icon named "blur off" (round).
  static const IconData blur_off_rounded = IconData(0xf5c8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">blur_off</i> &#x2014; material icon named "blur off" (outlined).
  static const IconData blur_off_outlined = IconData(0xeedb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">blur_on</i> &#x2014; material icon named "blur on".
  static const IconData blur_on = IconData(0xe0ed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">blur_on</i> &#x2014; material icon named "blur on" (sharp).
  static const IconData blur_on_sharp = IconData(0xe7ea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">blur_on</i> &#x2014; material icon named "blur on" (round).
  static const IconData blur_on_rounded = IconData(0xf5c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">blur_on</i> &#x2014; material icon named "blur on" (outlined).
  static const IconData blur_on_outlined = IconData(0xeedc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bolt</i> &#x2014; material icon named "bolt".
  static const IconData bolt = IconData(0xe0ee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bolt</i> &#x2014; material icon named "bolt" (sharp).
  static const IconData bolt_sharp = IconData(0xe7eb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bolt</i> &#x2014; material icon named "bolt" (round).
  static const IconData bolt_rounded = IconData(0xf5ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bolt</i> &#x2014; material icon named "bolt" (outlined).
  static const IconData bolt_outlined = IconData(0xeedd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">book</i> &#x2014; material icon named "book".
  static const IconData book = IconData(0xe0ef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">book</i> &#x2014; material icon named "book" (sharp).
  static const IconData book_sharp = IconData(0xe7ed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">book</i> &#x2014; material icon named "book" (round).
  static const IconData book_rounded = IconData(0xf5cc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">book</i> &#x2014; material icon named "book" (outlined).
  static const IconData book_outlined = IconData(0xeedf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">book_online</i> &#x2014; material icon named "book online".
  static const IconData book_online = IconData(0xe0f0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">book_online</i> &#x2014; material icon named "book online" (sharp).
  static const IconData book_online_sharp = IconData(0xe7ec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">book_online</i> &#x2014; material icon named "book online" (round).
  static const IconData book_online_rounded = IconData(0xf5cb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">book_online</i> &#x2014; material icon named "book online" (outlined).
  static const IconData book_online_outlined = IconData(0xeede, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bookmark</i> &#x2014; material icon named "bookmark".
  static const IconData bookmark = IconData(0xe0f1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bookmark</i> &#x2014; material icon named "bookmark" (sharp).
  static const IconData bookmark_sharp = IconData(0xe7f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bookmark</i> &#x2014; material icon named "bookmark" (round).
  static const IconData bookmark_rounded = IconData(0xf5d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bookmark</i> &#x2014; material icon named "bookmark" (outlined).
  static const IconData bookmark_outlined = IconData(0xeee3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bookmark_add</i> &#x2014; material icon named "bookmark add".
  static const IconData bookmark_add = IconData(0xe0f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bookmark_add</i> &#x2014; material icon named "bookmark add" (sharp).
  static const IconData bookmark_add_sharp = IconData(0xe7ee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bookmark_add</i> &#x2014; material icon named "bookmark add" (round).
  static const IconData bookmark_add_rounded = IconData(0xf5cd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bookmark_add</i> &#x2014; material icon named "bookmark add" (outlined).
  static const IconData bookmark_add_outlined = IconData(0xeee0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bookmark_added</i> &#x2014; material icon named "bookmark added".
  static const IconData bookmark_added = IconData(0xe0f3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bookmark_added</i> &#x2014; material icon named "bookmark added" (sharp).
  static const IconData bookmark_added_sharp = IconData(0xe7ef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bookmark_added</i> &#x2014; material icon named "bookmark added" (round).
  static const IconData bookmark_added_rounded = IconData(0xf5ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bookmark_added</i> &#x2014; material icon named "bookmark added" (outlined).
  static const IconData bookmark_added_outlined = IconData(0xeee1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bookmark_border</i> &#x2014; material icon named "bookmark border".
  static const IconData bookmark_border = IconData(0xe0f4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bookmark_border</i> &#x2014; material icon named "bookmark border" (sharp).
  static const IconData bookmark_border_sharp = IconData(0xe7f0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bookmark_border</i> &#x2014; material icon named "bookmark border" (round).
  static const IconData bookmark_border_rounded = IconData(0xf5cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bookmark_border</i> &#x2014; material icon named "bookmark border" (outlined).
  static const IconData bookmark_border_outlined = IconData(0xeee2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bookmark_outline</i> &#x2014; material icon named "bookmark outline".
  static const IconData bookmark_outline = IconData(0xe0f4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bookmark_outline</i> &#x2014; material icon named "bookmark outline" (sharp).
  static const IconData bookmark_outline_sharp = IconData(0xe7f0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bookmark_outline</i> &#x2014; material icon named "bookmark outline" (round).
  static const IconData bookmark_outline_rounded = IconData(0xf5cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bookmark_outline</i> &#x2014; material icon named "bookmark outline" (outlined).
  static const IconData bookmark_outline_outlined = IconData(0xeee2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bookmark_remove</i> &#x2014; material icon named "bookmark remove".
  static const IconData bookmark_remove = IconData(0xe0f5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bookmark_remove</i> &#x2014; material icon named "bookmark remove" (sharp).
  static const IconData bookmark_remove_sharp = IconData(0xe7f1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bookmark_remove</i> &#x2014; material icon named "bookmark remove" (round).
  static const IconData bookmark_remove_rounded = IconData(0xf5d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bookmark_remove</i> &#x2014; material icon named "bookmark remove" (outlined).
  static const IconData bookmark_remove_outlined = IconData(0xeee4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bookmarks</i> &#x2014; material icon named "bookmarks".
  static const IconData bookmarks = IconData(0xe0f6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bookmarks</i> &#x2014; material icon named "bookmarks" (sharp).
  static const IconData bookmarks_sharp = IconData(0xe7f3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bookmarks</i> &#x2014; material icon named "bookmarks" (round).
  static const IconData bookmarks_rounded = IconData(0xf5d2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bookmarks</i> &#x2014; material icon named "bookmarks" (outlined).
  static const IconData bookmarks_outlined = IconData(0xeee5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_all</i> &#x2014; material icon named "border all".
  static const IconData border_all = IconData(0xe0f7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">border_all</i> &#x2014; material icon named "border all" (sharp).
  static const IconData border_all_sharp = IconData(0xe7f4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">border_all</i> &#x2014; material icon named "border all" (round).
  static const IconData border_all_rounded = IconData(0xf5d3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">border_all</i> &#x2014; material icon named "border all" (outlined).
  static const IconData border_all_outlined = IconData(0xeee6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_bottom</i> &#x2014; material icon named "border bottom".
  static const IconData border_bottom = IconData(0xe0f8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">border_bottom</i> &#x2014; material icon named "border bottom" (sharp).
  static const IconData border_bottom_sharp = IconData(0xe7f5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">border_bottom</i> &#x2014; material icon named "border bottom" (round).
  static const IconData border_bottom_rounded = IconData(0xf5d4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">border_bottom</i> &#x2014; material icon named "border bottom" (outlined).
  static const IconData border_bottom_outlined = IconData(0xeee7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_clear</i> &#x2014; material icon named "border clear".
  static const IconData border_clear = IconData(0xe0f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">border_clear</i> &#x2014; material icon named "border clear" (sharp).
  static const IconData border_clear_sharp = IconData(0xe7f6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">border_clear</i> &#x2014; material icon named "border clear" (round).
  static const IconData border_clear_rounded = IconData(0xf5d5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">border_clear</i> &#x2014; material icon named "border clear" (outlined).
  static const IconData border_clear_outlined = IconData(0xeee8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_color</i> &#x2014; material icon named "border color".
  static const IconData border_color = IconData(0xe0fa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">border_color</i> &#x2014; material icon named "border color" (sharp).
  static const IconData border_color_sharp = IconData(0xe7f7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">border_color</i> &#x2014; material icon named "border color" (round).
  static const IconData border_color_rounded = IconData(0xf5d6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">border_color</i> &#x2014; material icon named "border color" (outlined).
  static const IconData border_color_outlined = IconData(0xeee9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_horizontal</i> &#x2014; material icon named "border horizontal".
  static const IconData border_horizontal = IconData(0xe0fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">border_horizontal</i> &#x2014; material icon named "border horizontal" (sharp).
  static const IconData border_horizontal_sharp = IconData(0xe7f8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">border_horizontal</i> &#x2014; material icon named "border horizontal" (round).
  static const IconData border_horizontal_rounded = IconData(0xf5d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">border_horizontal</i> &#x2014; material icon named "border horizontal" (outlined).
  static const IconData border_horizontal_outlined = IconData(0xeeea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_inner</i> &#x2014; material icon named "border inner".
  static const IconData border_inner = IconData(0xe0fc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">border_inner</i> &#x2014; material icon named "border inner" (sharp).
  static const IconData border_inner_sharp = IconData(0xe7f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">border_inner</i> &#x2014; material icon named "border inner" (round).
  static const IconData border_inner_rounded = IconData(0xf5d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">border_inner</i> &#x2014; material icon named "border inner" (outlined).
  static const IconData border_inner_outlined = IconData(0xeeeb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_left</i> &#x2014; material icon named "border left".
  static const IconData border_left = IconData(0xe0fd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">border_left</i> &#x2014; material icon named "border left" (sharp).
  static const IconData border_left_sharp = IconData(0xe7fa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">border_left</i> &#x2014; material icon named "border left" (round).
  static const IconData border_left_rounded = IconData(0xf5d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">border_left</i> &#x2014; material icon named "border left" (outlined).
  static const IconData border_left_outlined = IconData(0xeeec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_outer</i> &#x2014; material icon named "border outer".
  static const IconData border_outer = IconData(0xe0fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">border_outer</i> &#x2014; material icon named "border outer" (sharp).
  static const IconData border_outer_sharp = IconData(0xe7fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">border_outer</i> &#x2014; material icon named "border outer" (round).
  static const IconData border_outer_rounded = IconData(0xf5da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">border_outer</i> &#x2014; material icon named "border outer" (outlined).
  static const IconData border_outer_outlined = IconData(0xeeed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_right</i> &#x2014; material icon named "border right".
  static const IconData border_right = IconData(0xe0ff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">border_right</i> &#x2014; material icon named "border right" (sharp).
  static const IconData border_right_sharp = IconData(0xe7fc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">border_right</i> &#x2014; material icon named "border right" (round).
  static const IconData border_right_rounded = IconData(0xf5db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">border_right</i> &#x2014; material icon named "border right" (outlined).
  static const IconData border_right_outlined = IconData(0xeeee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_style</i> &#x2014; material icon named "border style".
  static const IconData border_style = IconData(0xe100, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">border_style</i> &#x2014; material icon named "border style" (sharp).
  static const IconData border_style_sharp = IconData(0xe7fd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">border_style</i> &#x2014; material icon named "border style" (round).
  static const IconData border_style_rounded = IconData(0xf5dc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">border_style</i> &#x2014; material icon named "border style" (outlined).
  static const IconData border_style_outlined = IconData(0xeeef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_top</i> &#x2014; material icon named "border top".
  static const IconData border_top = IconData(0xe101, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">border_top</i> &#x2014; material icon named "border top" (sharp).
  static const IconData border_top_sharp = IconData(0xe7fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">border_top</i> &#x2014; material icon named "border top" (round).
  static const IconData border_top_rounded = IconData(0xf5dd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">border_top</i> &#x2014; material icon named "border top" (outlined).
  static const IconData border_top_outlined = IconData(0xeef0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">border_vertical</i> &#x2014; material icon named "border vertical".
  static const IconData border_vertical = IconData(0xe102, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">border_vertical</i> &#x2014; material icon named "border vertical" (sharp).
  static const IconData border_vertical_sharp = IconData(0xe7ff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">border_vertical</i> &#x2014; material icon named "border vertical" (round).
  static const IconData border_vertical_rounded = IconData(0xf5de, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">border_vertical</i> &#x2014; material icon named "border vertical" (outlined).
  static const IconData border_vertical_outlined = IconData(0xeef1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">branding_watermark</i> &#x2014; material icon named "branding watermark".
  static const IconData branding_watermark = IconData(0xe103, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">branding_watermark</i> &#x2014; material icon named "branding watermark" (sharp).
  static const IconData branding_watermark_sharp = IconData(0xe800, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">branding_watermark</i> &#x2014; material icon named "branding watermark" (round).
  static const IconData branding_watermark_rounded = IconData(0xf5df, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">branding_watermark</i> &#x2014; material icon named "branding watermark" (outlined).
  static const IconData branding_watermark_outlined = IconData(0xeef2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">breakfast_dining</i> &#x2014; material icon named "breakfast dining".
  static const IconData breakfast_dining = IconData(0xe104, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">breakfast_dining</i> &#x2014; material icon named "breakfast dining" (sharp).
  static const IconData breakfast_dining_sharp = IconData(0xe801, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">breakfast_dining</i> &#x2014; material icon named "breakfast dining" (round).
  static const IconData breakfast_dining_rounded = IconData(0xf5e0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">breakfast_dining</i> &#x2014; material icon named "breakfast dining" (outlined).
  static const IconData breakfast_dining_outlined = IconData(0xeef3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_1</i> &#x2014; material icon named "brightness 1".
  static const IconData brightness_1 = IconData(0xe105, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">brightness_1</i> &#x2014; material icon named "brightness 1" (sharp).
  static const IconData brightness_1_sharp = IconData(0xe802, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">brightness_1</i> &#x2014; material icon named "brightness 1" (round).
  static const IconData brightness_1_rounded = IconData(0xf5e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">brightness_1</i> &#x2014; material icon named "brightness 1" (outlined).
  static const IconData brightness_1_outlined = IconData(0xeef4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_2</i> &#x2014; material icon named "brightness 2".
  static const IconData brightness_2 = IconData(0xe106, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">brightness_2</i> &#x2014; material icon named "brightness 2" (sharp).
  static const IconData brightness_2_sharp = IconData(0xe803, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">brightness_2</i> &#x2014; material icon named "brightness 2" (round).
  static const IconData brightness_2_rounded = IconData(0xf5e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">brightness_2</i> &#x2014; material icon named "brightness 2" (outlined).
  static const IconData brightness_2_outlined = IconData(0xeef5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_3</i> &#x2014; material icon named "brightness 3".
  static const IconData brightness_3 = IconData(0xe107, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">brightness_3</i> &#x2014; material icon named "brightness 3" (sharp).
  static const IconData brightness_3_sharp = IconData(0xe804, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">brightness_3</i> &#x2014; material icon named "brightness 3" (round).
  static const IconData brightness_3_rounded = IconData(0xf5e3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">brightness_3</i> &#x2014; material icon named "brightness 3" (outlined).
  static const IconData brightness_3_outlined = IconData(0xeef6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_4</i> &#x2014; material icon named "brightness 4".
  static const IconData brightness_4 = IconData(0xe108, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">brightness_4</i> &#x2014; material icon named "brightness 4" (sharp).
  static const IconData brightness_4_sharp = IconData(0xe805, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">brightness_4</i> &#x2014; material icon named "brightness 4" (round).
  static const IconData brightness_4_rounded = IconData(0xf5e4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">brightness_4</i> &#x2014; material icon named "brightness 4" (outlined).
  static const IconData brightness_4_outlined = IconData(0xeef7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_5</i> &#x2014; material icon named "brightness 5".
  static const IconData brightness_5 = IconData(0xe109, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">brightness_5</i> &#x2014; material icon named "brightness 5" (sharp).
  static const IconData brightness_5_sharp = IconData(0xe806, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">brightness_5</i> &#x2014; material icon named "brightness 5" (round).
  static const IconData brightness_5_rounded = IconData(0xf5e5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">brightness_5</i> &#x2014; material icon named "brightness 5" (outlined).
  static const IconData brightness_5_outlined = IconData(0xeef8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_6</i> &#x2014; material icon named "brightness 6".
  static const IconData brightness_6 = IconData(0xe10a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">brightness_6</i> &#x2014; material icon named "brightness 6" (sharp).
  static const IconData brightness_6_sharp = IconData(0xe807, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">brightness_6</i> &#x2014; material icon named "brightness 6" (round).
  static const IconData brightness_6_rounded = IconData(0xf5e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">brightness_6</i> &#x2014; material icon named "brightness 6" (outlined).
  static const IconData brightness_6_outlined = IconData(0xeef9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_7</i> &#x2014; material icon named "brightness 7".
  static const IconData brightness_7 = IconData(0xe10b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">brightness_7</i> &#x2014; material icon named "brightness 7" (sharp).
  static const IconData brightness_7_sharp = IconData(0xe808, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">brightness_7</i> &#x2014; material icon named "brightness 7" (round).
  static const IconData brightness_7_rounded = IconData(0xf5e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">brightness_7</i> &#x2014; material icon named "brightness 7" (outlined).
  static const IconData brightness_7_outlined = IconData(0xeefa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_auto</i> &#x2014; material icon named "brightness auto".
  static const IconData brightness_auto = IconData(0xe10c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">brightness_auto</i> &#x2014; material icon named "brightness auto" (sharp).
  static const IconData brightness_auto_sharp = IconData(0xe809, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">brightness_auto</i> &#x2014; material icon named "brightness auto" (round).
  static const IconData brightness_auto_rounded = IconData(0xf5e8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">brightness_auto</i> &#x2014; material icon named "brightness auto" (outlined).
  static const IconData brightness_auto_outlined = IconData(0xeefb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_high</i> &#x2014; material icon named "brightness high".
  static const IconData brightness_high = IconData(0xe10d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">brightness_high</i> &#x2014; material icon named "brightness high" (sharp).
  static const IconData brightness_high_sharp = IconData(0xe80a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">brightness_high</i> &#x2014; material icon named "brightness high" (round).
  static const IconData brightness_high_rounded = IconData(0xf5e9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">brightness_high</i> &#x2014; material icon named "brightness high" (outlined).
  static const IconData brightness_high_outlined = IconData(0xeefc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_low</i> &#x2014; material icon named "brightness low".
  static const IconData brightness_low = IconData(0xe10e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">brightness_low</i> &#x2014; material icon named "brightness low" (sharp).
  static const IconData brightness_low_sharp = IconData(0xe80b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">brightness_low</i> &#x2014; material icon named "brightness low" (round).
  static const IconData brightness_low_rounded = IconData(0xf5ea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">brightness_low</i> &#x2014; material icon named "brightness low" (outlined).
  static const IconData brightness_low_outlined = IconData(0xeefd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brightness_medium</i> &#x2014; material icon named "brightness medium".
  static const IconData brightness_medium = IconData(0xe10f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">brightness_medium</i> &#x2014; material icon named "brightness medium" (sharp).
  static const IconData brightness_medium_sharp = IconData(0xe80c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">brightness_medium</i> &#x2014; material icon named "brightness medium" (round).
  static const IconData brightness_medium_rounded = IconData(0xf5eb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">brightness_medium</i> &#x2014; material icon named "brightness medium" (outlined).
  static const IconData brightness_medium_outlined = IconData(0xeefe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">broken_image</i> &#x2014; material icon named "broken image".
  static const IconData broken_image = IconData(0xe110, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">broken_image</i> &#x2014; material icon named "broken image" (sharp).
  static const IconData broken_image_sharp = IconData(0xe80d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">broken_image</i> &#x2014; material icon named "broken image" (round).
  static const IconData broken_image_rounded = IconData(0xf5ec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">broken_image</i> &#x2014; material icon named "broken image" (outlined).
  static const IconData broken_image_outlined = IconData(0xeeff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">browser_not_supported</i> &#x2014; material icon named "browser not supported".
  static const IconData browser_not_supported = IconData(0xe111, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">browser_not_supported</i> &#x2014; material icon named "browser not supported" (sharp).
  static const IconData browser_not_supported_sharp = IconData(0xe80e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">browser_not_supported</i> &#x2014; material icon named "browser not supported" (round).
  static const IconData browser_not_supported_rounded = IconData(0xf5ed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">browser_not_supported</i> &#x2014; material icon named "browser not supported" (outlined).
  static const IconData browser_not_supported_outlined = IconData(0xef00, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brunch_dining</i> &#x2014; material icon named "brunch dining".
  static const IconData brunch_dining = IconData(0xe112, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">brunch_dining</i> &#x2014; material icon named "brunch dining" (sharp).
  static const IconData brunch_dining_sharp = IconData(0xe80f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">brunch_dining</i> &#x2014; material icon named "brunch dining" (round).
  static const IconData brunch_dining_rounded = IconData(0xf5ee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">brunch_dining</i> &#x2014; material icon named "brunch dining" (outlined).
  static const IconData brunch_dining_outlined = IconData(0xef01, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">brush</i> &#x2014; material icon named "brush".
  static const IconData brush = IconData(0xe113, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">brush</i> &#x2014; material icon named "brush" (sharp).
  static const IconData brush_sharp = IconData(0xe810, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">brush</i> &#x2014; material icon named "brush" (round).
  static const IconData brush_rounded = IconData(0xf5ef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">brush</i> &#x2014; material icon named "brush" (outlined).
  static const IconData brush_outlined = IconData(0xef02, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bubble_chart</i> &#x2014; material icon named "bubble chart".
  static const IconData bubble_chart = IconData(0xe114, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bubble_chart</i> &#x2014; material icon named "bubble chart" (sharp).
  static const IconData bubble_chart_sharp = IconData(0xe811, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bubble_chart</i> &#x2014; material icon named "bubble chart" (round).
  static const IconData bubble_chart_rounded = IconData(0xf5f0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bubble_chart</i> &#x2014; material icon named "bubble chart" (outlined).
  static const IconData bubble_chart_outlined = IconData(0xef03, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bug_report</i> &#x2014; material icon named "bug report".
  static const IconData bug_report = IconData(0xe115, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bug_report</i> &#x2014; material icon named "bug report" (sharp).
  static const IconData bug_report_sharp = IconData(0xe812, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bug_report</i> &#x2014; material icon named "bug report" (round).
  static const IconData bug_report_rounded = IconData(0xf5f1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bug_report</i> &#x2014; material icon named "bug report" (outlined).
  static const IconData bug_report_outlined = IconData(0xef04, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">build</i> &#x2014; material icon named "build".
  static const IconData build = IconData(0xe116, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">build</i> &#x2014; material icon named "build" (sharp).
  static const IconData build_sharp = IconData(0xe814, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">build</i> &#x2014; material icon named "build" (round).
  static const IconData build_rounded = IconData(0xf5f3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">build</i> &#x2014; material icon named "build" (outlined).
  static const IconData build_outlined = IconData(0xef06, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">build_circle</i> &#x2014; material icon named "build circle".
  static const IconData build_circle = IconData(0xe117, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">build_circle</i> &#x2014; material icon named "build circle" (sharp).
  static const IconData build_circle_sharp = IconData(0xe813, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">build_circle</i> &#x2014; material icon named "build circle" (round).
  static const IconData build_circle_rounded = IconData(0xf5f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">build_circle</i> &#x2014; material icon named "build circle" (outlined).
  static const IconData build_circle_outlined = IconData(0xef05, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bungalow</i> &#x2014; material icon named "bungalow".
  static const IconData bungalow = IconData(0xe118, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bungalow</i> &#x2014; material icon named "bungalow" (sharp).
  static const IconData bungalow_sharp = IconData(0xe815, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bungalow</i> &#x2014; material icon named "bungalow" (round).
  static const IconData bungalow_rounded = IconData(0xf5f4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bungalow</i> &#x2014; material icon named "bungalow" (outlined).
  static const IconData bungalow_outlined = IconData(0xef07, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">burst_mode</i> &#x2014; material icon named "burst mode".
  static const IconData burst_mode = IconData(0xe119, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">burst_mode</i> &#x2014; material icon named "burst mode" (sharp).
  static const IconData burst_mode_sharp = IconData(0xe816, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">burst_mode</i> &#x2014; material icon named "burst mode" (round).
  static const IconData burst_mode_rounded = IconData(0xf5f5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">burst_mode</i> &#x2014; material icon named "burst mode" (outlined).
  static const IconData burst_mode_outlined = IconData(0xef08, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">bus_alert</i> &#x2014; material icon named "bus alert".
  static const IconData bus_alert = IconData(0xe11a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">bus_alert</i> &#x2014; material icon named "bus alert" (sharp).
  static const IconData bus_alert_sharp = IconData(0xe817, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">bus_alert</i> &#x2014; material icon named "bus alert" (round).
  static const IconData bus_alert_rounded = IconData(0xf5f6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">bus_alert</i> &#x2014; material icon named "bus alert" (outlined).
  static const IconData bus_alert_outlined = IconData(0xef09, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">business</i> &#x2014; material icon named "business".
  static const IconData business = IconData(0xe11b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">business</i> &#x2014; material icon named "business" (sharp).
  static const IconData business_sharp = IconData(0xe819, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">business</i> &#x2014; material icon named "business" (round).
  static const IconData business_rounded = IconData(0xf5f8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">business</i> &#x2014; material icon named "business" (outlined).
  static const IconData business_outlined = IconData(0xef0b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">business_center</i> &#x2014; material icon named "business center".
  static const IconData business_center = IconData(0xe11c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">business_center</i> &#x2014; material icon named "business center" (sharp).
  static const IconData business_center_sharp = IconData(0xe818, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">business_center</i> &#x2014; material icon named "business center" (round).
  static const IconData business_center_rounded = IconData(0xf5f7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">business_center</i> &#x2014; material icon named "business center" (outlined).
  static const IconData business_center_outlined = IconData(0xef0a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cabin</i> &#x2014; material icon named "cabin".
  static const IconData cabin = IconData(0xe11d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cabin</i> &#x2014; material icon named "cabin" (sharp).
  static const IconData cabin_sharp = IconData(0xe81a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cabin</i> &#x2014; material icon named "cabin" (round).
  static const IconData cabin_rounded = IconData(0xf5f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cabin</i> &#x2014; material icon named "cabin" (outlined).
  static const IconData cabin_outlined = IconData(0xef0c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cable</i> &#x2014; material icon named "cable".
  static const IconData cable = IconData(0xe11e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cable</i> &#x2014; material icon named "cable" (sharp).
  static const IconData cable_sharp = IconData(0xe81b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cable</i> &#x2014; material icon named "cable" (round).
  static const IconData cable_rounded = IconData(0xf5fa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cable</i> &#x2014; material icon named "cable" (outlined).
  static const IconData cable_outlined = IconData(0xef0d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cached</i> &#x2014; material icon named "cached".
  static const IconData cached = IconData(0xe11f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cached</i> &#x2014; material icon named "cached" (sharp).
  static const IconData cached_sharp = IconData(0xe81c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cached</i> &#x2014; material icon named "cached" (round).
  static const IconData cached_rounded = IconData(0xf5fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cached</i> &#x2014; material icon named "cached" (outlined).
  static const IconData cached_outlined = IconData(0xef0e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cake</i> &#x2014; material icon named "cake".
  static const IconData cake = IconData(0xe120, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cake</i> &#x2014; material icon named "cake" (sharp).
  static const IconData cake_sharp = IconData(0xe81d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cake</i> &#x2014; material icon named "cake" (round).
  static const IconData cake_rounded = IconData(0xf5fc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cake</i> &#x2014; material icon named "cake" (outlined).
  static const IconData cake_outlined = IconData(0xef0f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">calculate</i> &#x2014; material icon named "calculate".
  static const IconData calculate = IconData(0xe121, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">calculate</i> &#x2014; material icon named "calculate" (sharp).
  static const IconData calculate_sharp = IconData(0xe81e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">calculate</i> &#x2014; material icon named "calculate" (round).
  static const IconData calculate_rounded = IconData(0xf5fd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">calculate</i> &#x2014; material icon named "calculate" (outlined).
  static const IconData calculate_outlined = IconData(0xef10, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">calendar_today</i> &#x2014; material icon named "calendar today".
  static const IconData calendar_today = IconData(0xe122, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">calendar_today</i> &#x2014; material icon named "calendar today" (sharp).
  static const IconData calendar_today_sharp = IconData(0xe81f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">calendar_today</i> &#x2014; material icon named "calendar today" (round).
  static const IconData calendar_today_rounded = IconData(0xf5fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">calendar_today</i> &#x2014; material icon named "calendar today" (outlined).
  static const IconData calendar_today_outlined = IconData(0xef11, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">calendar_view_day</i> &#x2014; material icon named "calendar view day".
  static const IconData calendar_view_day = IconData(0xe123, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">calendar_view_day</i> &#x2014; material icon named "calendar view day" (sharp).
  static const IconData calendar_view_day_sharp = IconData(0xe820, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">calendar_view_day</i> &#x2014; material icon named "calendar view day" (round).
  static const IconData calendar_view_day_rounded = IconData(0xf5ff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">calendar_view_day</i> &#x2014; material icon named "calendar view day" (outlined).
  static const IconData calendar_view_day_outlined = IconData(0xef12, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">calendar_view_month</i> &#x2014; material icon named "calendar view month".
  static const IconData calendar_view_month = IconData(0xe124, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">calendar_view_month</i> &#x2014; material icon named "calendar view month" (sharp).
  static const IconData calendar_view_month_sharp = IconData(0xe821, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">calendar_view_month</i> &#x2014; material icon named "calendar view month" (round).
  static const IconData calendar_view_month_rounded = IconData(0xf600, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">calendar_view_month</i> &#x2014; material icon named "calendar view month" (outlined).
  static const IconData calendar_view_month_outlined = IconData(0xef13, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">calendar_view_week</i> &#x2014; material icon named "calendar view week".
  static const IconData calendar_view_week = IconData(0xe125, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">calendar_view_week</i> &#x2014; material icon named "calendar view week" (sharp).
  static const IconData calendar_view_week_sharp = IconData(0xe822, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">calendar_view_week</i> &#x2014; material icon named "calendar view week" (round).
  static const IconData calendar_view_week_rounded = IconData(0xf601, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">calendar_view_week</i> &#x2014; material icon named "calendar view week" (outlined).
  static const IconData calendar_view_week_outlined = IconData(0xef14, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">call</i> &#x2014; material icon named "call".
  static const IconData call = IconData(0xe126, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">call</i> &#x2014; material icon named "call" (sharp).
  static const IconData call_sharp = IconData(0xe829, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">call</i> &#x2014; material icon named "call" (round).
  static const IconData call_rounded = IconData(0xf608, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">call</i> &#x2014; material icon named "call" (outlined).
  static const IconData call_outlined = IconData(0xef1a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">call_end</i> &#x2014; material icon named "call end".
  static const IconData call_end = IconData(0xe127, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">call_end</i> &#x2014; material icon named "call end" (sharp).
  static const IconData call_end_sharp = IconData(0xe823, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">call_end</i> &#x2014; material icon named "call end" (round).
  static const IconData call_end_rounded = IconData(0xf602, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">call_end</i> &#x2014; material icon named "call end" (outlined).
  static const IconData call_end_outlined = IconData(0xef15, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">call_made</i> &#x2014; material icon named "call made".
  static const IconData call_made = IconData(0xe128, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">call_made</i> &#x2014; material icon named "call made" (sharp).
  static const IconData call_made_sharp = IconData(0xe824, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">call_made</i> &#x2014; material icon named "call made" (round).
  static const IconData call_made_rounded = IconData(0xf603, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">call_made</i> &#x2014; material icon named "call made" (outlined).
  static const IconData call_made_outlined = IconData(0xef16, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">call_merge</i> &#x2014; material icon named "call merge".
  static const IconData call_merge = IconData(0xe129, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">call_merge</i> &#x2014; material icon named "call merge" (sharp).
  static const IconData call_merge_sharp = IconData(0xe825, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">call_merge</i> &#x2014; material icon named "call merge" (round).
  static const IconData call_merge_rounded = IconData(0xf604, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">call_merge</i> &#x2014; material icon named "call merge" (outlined).
  static const IconData call_merge_outlined = IconData(0xef17, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">call_missed</i> &#x2014; material icon named "call missed".
  static const IconData call_missed = IconData(0xe12a, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">call_missed</i> &#x2014; material icon named "call missed" (sharp).
  static const IconData call_missed_sharp = IconData(0xe827, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">call_missed</i> &#x2014; material icon named "call missed" (round).
  static const IconData call_missed_rounded = IconData(0xf606, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">call_missed</i> &#x2014; material icon named "call missed" (outlined).
  static const IconData call_missed_outlined = IconData(0xef19, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">call_missed_outgoing</i> &#x2014; material icon named "call missed outgoing".
  static const IconData call_missed_outgoing = IconData(0xe12b, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">call_missed_outgoing</i> &#x2014; material icon named "call missed outgoing" (sharp).
  static const IconData call_missed_outgoing_sharp = IconData(0xe826, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">call_missed_outgoing</i> &#x2014; material icon named "call missed outgoing" (round).
  static const IconData call_missed_outgoing_rounded = IconData(0xf605, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">call_missed_outgoing</i> &#x2014; material icon named "call missed outgoing" (outlined).
  static const IconData call_missed_outgoing_outlined = IconData(0xef18, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">call_received</i> &#x2014; material icon named "call received".
  static const IconData call_received = IconData(0xe12c, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">call_received</i> &#x2014; material icon named "call received" (sharp).
  static const IconData call_received_sharp = IconData(0xe828, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">call_received</i> &#x2014; material icon named "call received" (round).
  static const IconData call_received_rounded = IconData(0xf607, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">call_received</i> &#x2014; material icon named "call received" (outlined).
  static const IconData call_received_outlined = IconData(0xef1b, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">call_split</i> &#x2014; material icon named "call split".
  static const IconData call_split = IconData(0xe12d, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">call_split</i> &#x2014; material icon named "call split" (sharp).
  static const IconData call_split_sharp = IconData(0xe82a, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">call_split</i> &#x2014; material icon named "call split" (round).
  static const IconData call_split_rounded = IconData(0xf609, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">call_split</i> &#x2014; material icon named "call split" (outlined).
  static const IconData call_split_outlined = IconData(0xef1c, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">call_to_action</i> &#x2014; material icon named "call to action".
  static const IconData call_to_action = IconData(0xe12e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">call_to_action</i> &#x2014; material icon named "call to action" (sharp).
  static const IconData call_to_action_sharp = IconData(0xe82b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">call_to_action</i> &#x2014; material icon named "call to action" (round).
  static const IconData call_to_action_rounded = IconData(0xf60a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">call_to_action</i> &#x2014; material icon named "call to action" (outlined).
  static const IconData call_to_action_outlined = IconData(0xef1d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">camera</i> &#x2014; material icon named "camera".
  static const IconData camera = IconData(0xe12f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">camera</i> &#x2014; material icon named "camera" (sharp).
  static const IconData camera_sharp = IconData(0xe833, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">camera</i> &#x2014; material icon named "camera" (round).
  static const IconData camera_rounded = IconData(0xf612, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">camera</i> &#x2014; material icon named "camera" (outlined).
  static const IconData camera_outlined = IconData(0xef23, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">camera_alt</i> &#x2014; material icon named "camera alt".
  static const IconData camera_alt = IconData(0xe130, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">camera_alt</i> &#x2014; material icon named "camera alt" (sharp).
  static const IconData camera_alt_sharp = IconData(0xe82c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">camera_alt</i> &#x2014; material icon named "camera alt" (round).
  static const IconData camera_alt_rounded = IconData(0xf60b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">camera_alt</i> &#x2014; material icon named "camera alt" (outlined).
  static const IconData camera_alt_outlined = IconData(0xef1e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">camera_enhance</i> &#x2014; material icon named "camera enhance".
  static const IconData camera_enhance = IconData(0xe131, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">camera_enhance</i> &#x2014; material icon named "camera enhance" (sharp).
  static const IconData camera_enhance_sharp = IconData(0xe82d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">camera_enhance</i> &#x2014; material icon named "camera enhance" (round).
  static const IconData camera_enhance_rounded = IconData(0xf60c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">camera_enhance</i> &#x2014; material icon named "camera enhance" (outlined).
  static const IconData camera_enhance_outlined = IconData(0xef1f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">camera_front</i> &#x2014; material icon named "camera front".
  static const IconData camera_front = IconData(0xe132, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">camera_front</i> &#x2014; material icon named "camera front" (sharp).
  static const IconData camera_front_sharp = IconData(0xe82e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">camera_front</i> &#x2014; material icon named "camera front" (round).
  static const IconData camera_front_rounded = IconData(0xf60d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">camera_front</i> &#x2014; material icon named "camera front" (outlined).
  static const IconData camera_front_outlined = IconData(0xef20, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">camera_indoor</i> &#x2014; material icon named "camera indoor".
  static const IconData camera_indoor = IconData(0xe133, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">camera_indoor</i> &#x2014; material icon named "camera indoor" (sharp).
  static const IconData camera_indoor_sharp = IconData(0xe82f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">camera_indoor</i> &#x2014; material icon named "camera indoor" (round).
  static const IconData camera_indoor_rounded = IconData(0xf60e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">camera_indoor</i> &#x2014; material icon named "camera indoor" (outlined).
  static const IconData camera_indoor_outlined = IconData(0xef21, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">camera_outdoor</i> &#x2014; material icon named "camera outdoor".
  static const IconData camera_outdoor = IconData(0xe134, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">camera_outdoor</i> &#x2014; material icon named "camera outdoor" (sharp).
  static const IconData camera_outdoor_sharp = IconData(0xe830, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">camera_outdoor</i> &#x2014; material icon named "camera outdoor" (round).
  static const IconData camera_outdoor_rounded = IconData(0xf60f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">camera_outdoor</i> &#x2014; material icon named "camera outdoor" (outlined).
  static const IconData camera_outdoor_outlined = IconData(0xef22, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">camera_rear</i> &#x2014; material icon named "camera rear".
  static const IconData camera_rear = IconData(0xe135, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">camera_rear</i> &#x2014; material icon named "camera rear" (sharp).
  static const IconData camera_rear_sharp = IconData(0xe831, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">camera_rear</i> &#x2014; material icon named "camera rear" (round).
  static const IconData camera_rear_rounded = IconData(0xf610, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">camera_rear</i> &#x2014; material icon named "camera rear" (outlined).
  static const IconData camera_rear_outlined = IconData(0xef24, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">camera_roll</i> &#x2014; material icon named "camera roll".
  static const IconData camera_roll = IconData(0xe136, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">camera_roll</i> &#x2014; material icon named "camera roll" (sharp).
  static const IconData camera_roll_sharp = IconData(0xe832, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">camera_roll</i> &#x2014; material icon named "camera roll" (round).
  static const IconData camera_roll_rounded = IconData(0xf611, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">camera_roll</i> &#x2014; material icon named "camera roll" (outlined).
  static const IconData camera_roll_outlined = IconData(0xef25, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cameraswitch</i> &#x2014; material icon named "cameraswitch".
  static const IconData cameraswitch = IconData(0xe137, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cameraswitch</i> &#x2014; material icon named "cameraswitch" (sharp).
  static const IconData cameraswitch_sharp = IconData(0xe834, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cameraswitch</i> &#x2014; material icon named "cameraswitch" (round).
  static const IconData cameraswitch_rounded = IconData(0xf613, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cameraswitch</i> &#x2014; material icon named "cameraswitch" (outlined).
  static const IconData cameraswitch_outlined = IconData(0xef26, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">campaign</i> &#x2014; material icon named "campaign".
  static const IconData campaign = IconData(0xe138, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">campaign</i> &#x2014; material icon named "campaign" (sharp).
  static const IconData campaign_sharp = IconData(0xe835, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">campaign</i> &#x2014; material icon named "campaign" (round).
  static const IconData campaign_rounded = IconData(0xf614, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">campaign</i> &#x2014; material icon named "campaign" (outlined).
  static const IconData campaign_outlined = IconData(0xef27, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cancel</i> &#x2014; material icon named "cancel".
  static const IconData cancel = IconData(0xe139, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cancel</i> &#x2014; material icon named "cancel" (sharp).
  static const IconData cancel_sharp = IconData(0xe838, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cancel</i> &#x2014; material icon named "cancel" (round).
  static const IconData cancel_rounded = IconData(0xf616, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cancel</i> &#x2014; material icon named "cancel" (outlined).
  static const IconData cancel_outlined = IconData(0xef28, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cancel_presentation</i> &#x2014; material icon named "cancel presentation".
  static const IconData cancel_presentation = IconData(0xe13a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cancel_presentation</i> &#x2014; material icon named "cancel presentation" (sharp).
  static const IconData cancel_presentation_sharp = IconData(0xe836, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cancel_presentation</i> &#x2014; material icon named "cancel presentation" (round).
  static const IconData cancel_presentation_rounded = IconData(0xf615, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cancel_presentation</i> &#x2014; material icon named "cancel presentation" (outlined).
  static const IconData cancel_presentation_outlined = IconData(0xef29, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cancel_schedule_send</i> &#x2014; material icon named "cancel schedule send".
  static const IconData cancel_schedule_send = IconData(0xe13b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cancel_schedule_send</i> &#x2014; material icon named "cancel schedule send" (sharp).
  static const IconData cancel_schedule_send_sharp = IconData(0xe837, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cancel_schedule_send</i> &#x2014; material icon named "cancel schedule send" (round).
  static const IconData cancel_schedule_send_rounded = IconData(0xf617, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cancel_schedule_send</i> &#x2014; material icon named "cancel schedule send" (outlined).
  static const IconData cancel_schedule_send_outlined = IconData(0xef2a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">car_rental</i> &#x2014; material icon named "car rental".
  static const IconData car_rental = IconData(0xe13c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">car_rental</i> &#x2014; material icon named "car rental" (sharp).
  static const IconData car_rental_sharp = IconData(0xe839, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">car_rental</i> &#x2014; material icon named "car rental" (round).
  static const IconData car_rental_rounded = IconData(0xf618, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">car_rental</i> &#x2014; material icon named "car rental" (outlined).
  static const IconData car_rental_outlined = IconData(0xef2b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">car_repair</i> &#x2014; material icon named "car repair".
  static const IconData car_repair = IconData(0xe13d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">car_repair</i> &#x2014; material icon named "car repair" (sharp).
  static const IconData car_repair_sharp = IconData(0xe83a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">car_repair</i> &#x2014; material icon named "car repair" (round).
  static const IconData car_repair_rounded = IconData(0xf619, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">car_repair</i> &#x2014; material icon named "car repair" (outlined).
  static const IconData car_repair_outlined = IconData(0xef2c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">card_giftcard</i> &#x2014; material icon named "card giftcard".
  static const IconData card_giftcard = IconData(0xe13e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">card_giftcard</i> &#x2014; material icon named "card giftcard" (sharp).
  static const IconData card_giftcard_sharp = IconData(0xe83b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">card_giftcard</i> &#x2014; material icon named "card giftcard" (round).
  static const IconData card_giftcard_rounded = IconData(0xf61a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">card_giftcard</i> &#x2014; material icon named "card giftcard" (outlined).
  static const IconData card_giftcard_outlined = IconData(0xef2d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">card_membership</i> &#x2014; material icon named "card membership".
  static const IconData card_membership = IconData(0xe13f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">card_membership</i> &#x2014; material icon named "card membership" (sharp).
  static const IconData card_membership_sharp = IconData(0xe83c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">card_membership</i> &#x2014; material icon named "card membership" (round).
  static const IconData card_membership_rounded = IconData(0xf61b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">card_membership</i> &#x2014; material icon named "card membership" (outlined).
  static const IconData card_membership_outlined = IconData(0xef2e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">card_travel</i> &#x2014; material icon named "card travel".
  static const IconData card_travel = IconData(0xe140, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">card_travel</i> &#x2014; material icon named "card travel" (sharp).
  static const IconData card_travel_sharp = IconData(0xe83d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">card_travel</i> &#x2014; material icon named "card travel" (round).
  static const IconData card_travel_rounded = IconData(0xf61c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">card_travel</i> &#x2014; material icon named "card travel" (outlined).
  static const IconData card_travel_outlined = IconData(0xef2f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">carpenter</i> &#x2014; material icon named "carpenter".
  static const IconData carpenter = IconData(0xe141, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">carpenter</i> &#x2014; material icon named "carpenter" (sharp).
  static const IconData carpenter_sharp = IconData(0xe83e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">carpenter</i> &#x2014; material icon named "carpenter" (round).
  static const IconData carpenter_rounded = IconData(0xf61d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">carpenter</i> &#x2014; material icon named "carpenter" (outlined).
  static const IconData carpenter_outlined = IconData(0xef30, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cases</i> &#x2014; material icon named "cases".
  static const IconData cases = IconData(0xe142, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cases</i> &#x2014; material icon named "cases" (sharp).
  static const IconData cases_sharp = IconData(0xe83f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cases</i> &#x2014; material icon named "cases" (round).
  static const IconData cases_rounded = IconData(0xf61e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cases</i> &#x2014; material icon named "cases" (outlined).
  static const IconData cases_outlined = IconData(0xef31, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">casino</i> &#x2014; material icon named "casino".
  static const IconData casino = IconData(0xe143, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">casino</i> &#x2014; material icon named "casino" (sharp).
  static const IconData casino_sharp = IconData(0xe840, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">casino</i> &#x2014; material icon named "casino" (round).
  static const IconData casino_rounded = IconData(0xf61f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">casino</i> &#x2014; material icon named "casino" (outlined).
  static const IconData casino_outlined = IconData(0xef32, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cast</i> &#x2014; material icon named "cast".
  static const IconData cast = IconData(0xe144, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cast</i> &#x2014; material icon named "cast" (sharp).
  static const IconData cast_sharp = IconData(0xe843, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cast</i> &#x2014; material icon named "cast" (round).
  static const IconData cast_rounded = IconData(0xf622, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cast</i> &#x2014; material icon named "cast" (outlined).
  static const IconData cast_outlined = IconData(0xef35, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cast_connected</i> &#x2014; material icon named "cast connected".
  static const IconData cast_connected = IconData(0xe145, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cast_connected</i> &#x2014; material icon named "cast connected" (sharp).
  static const IconData cast_connected_sharp = IconData(0xe841, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cast_connected</i> &#x2014; material icon named "cast connected" (round).
  static const IconData cast_connected_rounded = IconData(0xf620, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cast_connected</i> &#x2014; material icon named "cast connected" (outlined).
  static const IconData cast_connected_outlined = IconData(0xef33, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cast_for_education</i> &#x2014; material icon named "cast for education".
  static const IconData cast_for_education = IconData(0xe146, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cast_for_education</i> &#x2014; material icon named "cast for education" (sharp).
  static const IconData cast_for_education_sharp = IconData(0xe842, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cast_for_education</i> &#x2014; material icon named "cast for education" (round).
  static const IconData cast_for_education_rounded = IconData(0xf621, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cast_for_education</i> &#x2014; material icon named "cast for education" (outlined).
  static const IconData cast_for_education_outlined = IconData(0xef34, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">catching_pokemon</i> &#x2014; material icon named "catching pokemon".
  static const IconData catching_pokemon = IconData(0xe147, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">catching_pokemon</i> &#x2014; material icon named "catching pokemon" (sharp).
  static const IconData catching_pokemon_sharp = IconData(0xe844, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">catching_pokemon</i> &#x2014; material icon named "catching pokemon" (round).
  static const IconData catching_pokemon_rounded = IconData(0xf623, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">catching_pokemon</i> &#x2014; material icon named "catching pokemon" (outlined).
  static const IconData catching_pokemon_outlined = IconData(0xef36, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">category</i> &#x2014; material icon named "category".
  static const IconData category = IconData(0xe148, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">category</i> &#x2014; material icon named "category" (sharp).
  static const IconData category_sharp = IconData(0xe845, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">category</i> &#x2014; material icon named "category" (round).
  static const IconData category_rounded = IconData(0xf624, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">category</i> &#x2014; material icon named "category" (outlined).
  static const IconData category_outlined = IconData(0xef37, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">celebration</i> &#x2014; material icon named "celebration".
  static const IconData celebration = IconData(0xe149, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">celebration</i> &#x2014; material icon named "celebration" (sharp).
  static const IconData celebration_sharp = IconData(0xe846, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">celebration</i> &#x2014; material icon named "celebration" (round).
  static const IconData celebration_rounded = IconData(0xf625, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">celebration</i> &#x2014; material icon named "celebration" (outlined).
  static const IconData celebration_outlined = IconData(0xef38, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cell_wifi</i> &#x2014; material icon named "cell wifi".
  static const IconData cell_wifi = IconData(0xe14a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cell_wifi</i> &#x2014; material icon named "cell wifi" (sharp).
  static const IconData cell_wifi_sharp = IconData(0xe847, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cell_wifi</i> &#x2014; material icon named "cell wifi" (round).
  static const IconData cell_wifi_rounded = IconData(0xf626, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cell_wifi</i> &#x2014; material icon named "cell wifi" (outlined).
  static const IconData cell_wifi_outlined = IconData(0xef39, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">center_focus_strong</i> &#x2014; material icon named "center focus strong".
  static const IconData center_focus_strong = IconData(0xe14b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">center_focus_strong</i> &#x2014; material icon named "center focus strong" (sharp).
  static const IconData center_focus_strong_sharp = IconData(0xe848, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">center_focus_strong</i> &#x2014; material icon named "center focus strong" (round).
  static const IconData center_focus_strong_rounded = IconData(0xf627, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">center_focus_strong</i> &#x2014; material icon named "center focus strong" (outlined).
  static const IconData center_focus_strong_outlined = IconData(0xef3a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">center_focus_weak</i> &#x2014; material icon named "center focus weak".
  static const IconData center_focus_weak = IconData(0xe14c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">center_focus_weak</i> &#x2014; material icon named "center focus weak" (sharp).
  static const IconData center_focus_weak_sharp = IconData(0xe849, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">center_focus_weak</i> &#x2014; material icon named "center focus weak" (round).
  static const IconData center_focus_weak_rounded = IconData(0xf628, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">center_focus_weak</i> &#x2014; material icon named "center focus weak" (outlined).
  static const IconData center_focus_weak_outlined = IconData(0xef3b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">chair</i> &#x2014; material icon named "chair".
  static const IconData chair = IconData(0xe14d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">chair</i> &#x2014; material icon named "chair" (sharp).
  static const IconData chair_sharp = IconData(0xe84b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">chair</i> &#x2014; material icon named "chair" (round).
  static const IconData chair_rounded = IconData(0xf62a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">chair</i> &#x2014; material icon named "chair" (outlined).
  static const IconData chair_outlined = IconData(0xef3d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">chair_alt</i> &#x2014; material icon named "chair alt".
  static const IconData chair_alt = IconData(0xe14e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">chair_alt</i> &#x2014; material icon named "chair alt" (sharp).
  static const IconData chair_alt_sharp = IconData(0xe84a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">chair_alt</i> &#x2014; material icon named "chair alt" (round).
  static const IconData chair_alt_rounded = IconData(0xf629, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">chair_alt</i> &#x2014; material icon named "chair alt" (outlined).
  static const IconData chair_alt_outlined = IconData(0xef3c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">chalet</i> &#x2014; material icon named "chalet".
  static const IconData chalet = IconData(0xe14f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">chalet</i> &#x2014; material icon named "chalet" (sharp).
  static const IconData chalet_sharp = IconData(0xe84c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">chalet</i> &#x2014; material icon named "chalet" (round).
  static const IconData chalet_rounded = IconData(0xf62b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">chalet</i> &#x2014; material icon named "chalet" (outlined).
  static const IconData chalet_outlined = IconData(0xef3e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">change_circle</i> &#x2014; material icon named "change circle".
  static const IconData change_circle = IconData(0xe150, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">change_circle</i> &#x2014; material icon named "change circle" (sharp).
  static const IconData change_circle_sharp = IconData(0xe84d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">change_circle</i> &#x2014; material icon named "change circle" (round).
  static const IconData change_circle_rounded = IconData(0xf62c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">change_circle</i> &#x2014; material icon named "change circle" (outlined).
  static const IconData change_circle_outlined = IconData(0xef3f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">change_history</i> &#x2014; material icon named "change history".
  static const IconData change_history = IconData(0xe151, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">change_history</i> &#x2014; material icon named "change history" (sharp).
  static const IconData change_history_sharp = IconData(0xe84e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">change_history</i> &#x2014; material icon named "change history" (round).
  static const IconData change_history_rounded = IconData(0xf62d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">change_history</i> &#x2014; material icon named "change history" (outlined).
  static const IconData change_history_outlined = IconData(0xef40, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">charging_station</i> &#x2014; material icon named "charging station".
  static const IconData charging_station = IconData(0xe152, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">charging_station</i> &#x2014; material icon named "charging station" (sharp).
  static const IconData charging_station_sharp = IconData(0xe84f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">charging_station</i> &#x2014; material icon named "charging station" (round).
  static const IconData charging_station_rounded = IconData(0xf62e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">charging_station</i> &#x2014; material icon named "charging station" (outlined).
  static const IconData charging_station_outlined = IconData(0xef41, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">chat</i> &#x2014; material icon named "chat".
  static const IconData chat = IconData(0xe153, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">chat</i> &#x2014; material icon named "chat" (sharp).
  static const IconData chat_sharp = IconData(0xe852, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">chat</i> &#x2014; material icon named "chat" (round).
  static const IconData chat_rounded = IconData(0xf631, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">chat</i> &#x2014; material icon named "chat" (outlined).
  static const IconData chat_outlined = IconData(0xef44, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">chat_bubble</i> &#x2014; material icon named "chat bubble".
  static const IconData chat_bubble = IconData(0xe154, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">chat_bubble</i> &#x2014; material icon named "chat bubble" (sharp).
  static const IconData chat_bubble_sharp = IconData(0xe851, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">chat_bubble</i> &#x2014; material icon named "chat bubble" (round).
  static const IconData chat_bubble_rounded = IconData(0xf630, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">chat_bubble</i> &#x2014; material icon named "chat bubble" (outlined).
  static const IconData chat_bubble_outlined = IconData(0xef43, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">chat_bubble_outline</i> &#x2014; material icon named "chat bubble outline".
  static const IconData chat_bubble_outline = IconData(0xe155, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">chat_bubble_outline</i> &#x2014; material icon named "chat bubble outline" (sharp).
  static const IconData chat_bubble_outline_sharp = IconData(0xe850, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">chat_bubble_outline</i> &#x2014; material icon named "chat bubble outline" (round).
  static const IconData chat_bubble_outline_rounded = IconData(0xf62f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">chat_bubble_outline</i> &#x2014; material icon named "chat bubble outline" (outlined).
  static const IconData chat_bubble_outline_outlined = IconData(0xef42, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">check</i> &#x2014; material icon named "check".
  static const IconData check = IconData(0xe156, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">check</i> &#x2014; material icon named "check" (sharp).
  static const IconData check_sharp = IconData(0xe857, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">check</i> &#x2014; material icon named "check" (round).
  static const IconData check_rounded = IconData(0xf636, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">check</i> &#x2014; material icon named "check" (outlined).
  static const IconData check_outlined = IconData(0xef49, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">check_box</i> &#x2014; material icon named "check box".
  static const IconData check_box = IconData(0xe157, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">check_box</i> &#x2014; material icon named "check box" (sharp).
  static const IconData check_box_sharp = IconData(0xe854, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">check_box</i> &#x2014; material icon named "check box" (round).
  static const IconData check_box_rounded = IconData(0xf633, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">check_box</i> &#x2014; material icon named "check box" (outlined).
  static const IconData check_box_outlined = IconData(0xef46, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">check_box_outline_blank</i> &#x2014; material icon named "check box outline blank".
  static const IconData check_box_outline_blank = IconData(0xe158, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">check_box_outline_blank</i> &#x2014; material icon named "check box outline blank" (sharp).
  static const IconData check_box_outline_blank_sharp = IconData(0xe853, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">check_box_outline_blank</i> &#x2014; material icon named "check box outline blank" (round).
  static const IconData check_box_outline_blank_rounded = IconData(0xf632, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">check_box_outline_blank</i> &#x2014; material icon named "check box outline blank" (outlined).
  static const IconData check_box_outline_blank_outlined = IconData(0xef45, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">check_circle</i> &#x2014; material icon named "check circle".
  static const IconData check_circle = IconData(0xe159, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">check_circle</i> &#x2014; material icon named "check circle" (sharp).
  static const IconData check_circle_sharp = IconData(0xe856, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">check_circle</i> &#x2014; material icon named "check circle" (round).
  static const IconData check_circle_rounded = IconData(0xf635, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">check_circle</i> &#x2014; material icon named "check circle" (outlined).
  static const IconData check_circle_outlined = IconData(0xef48, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">check_circle_outline</i> &#x2014; material icon named "check circle outline".
  static const IconData check_circle_outline = IconData(0xe15a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">check_circle_outline</i> &#x2014; material icon named "check circle outline" (sharp).
  static const IconData check_circle_outline_sharp = IconData(0xe855, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">check_circle_outline</i> &#x2014; material icon named "check circle outline" (round).
  static const IconData check_circle_outline_rounded = IconData(0xf634, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">check_circle_outline</i> &#x2014; material icon named "check circle outline" (outlined).
  static const IconData check_circle_outline_outlined = IconData(0xef47, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">checklist</i> &#x2014; material icon named "checklist".
  static const IconData checklist = IconData(0xe15b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">checklist</i> &#x2014; material icon named "checklist" (sharp).
  static const IconData checklist_sharp = IconData(0xe859, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">checklist</i> &#x2014; material icon named "checklist" (round).
  static const IconData checklist_rounded = IconData(0xf637, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">checklist</i> &#x2014; material icon named "checklist" (outlined).
  static const IconData checklist_outlined = IconData(0xef4a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">checklist_rtl</i> &#x2014; material icon named "checklist rtl".
  static const IconData checklist_rtl = IconData(0xe15c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">checklist_rtl</i> &#x2014; material icon named "checklist rtl" (sharp).
  static const IconData checklist_rtl_sharp = IconData(0xe858, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">checklist_rtl</i> &#x2014; material icon named "checklist rtl" (round).
  static const IconData checklist_rtl_rounded = IconData(0xf638, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">checklist_rtl</i> &#x2014; material icon named "checklist rtl" (outlined).
  static const IconData checklist_rtl_outlined = IconData(0xef4b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">checkroom</i> &#x2014; material icon named "checkroom".
  static const IconData checkroom = IconData(0xe15d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">checkroom</i> &#x2014; material icon named "checkroom" (sharp).
  static const IconData checkroom_sharp = IconData(0xe85a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">checkroom</i> &#x2014; material icon named "checkroom" (round).
  static const IconData checkroom_rounded = IconData(0xf639, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">checkroom</i> &#x2014; material icon named "checkroom" (outlined).
  static const IconData checkroom_outlined = IconData(0xef4c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">chevron_left</i> &#x2014; material icon named "chevron left".
  static const IconData chevron_left = IconData(0xe15e, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">chevron_left</i> &#x2014; material icon named "chevron left" (sharp).
  static const IconData chevron_left_sharp = IconData(0xe85b, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">chevron_left</i> &#x2014; material icon named "chevron left" (round).
  static const IconData chevron_left_rounded = IconData(0xf63a, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">chevron_left</i> &#x2014; material icon named "chevron left" (outlined).
  static const IconData chevron_left_outlined = IconData(0xef4d, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">chevron_right</i> &#x2014; material icon named "chevron right".
  static const IconData chevron_right = IconData(0xe15f, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">chevron_right</i> &#x2014; material icon named "chevron right" (sharp).
  static const IconData chevron_right_sharp = IconData(0xe85c, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">chevron_right</i> &#x2014; material icon named "chevron right" (round).
  static const IconData chevron_right_rounded = IconData(0xf63b, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">chevron_right</i> &#x2014; material icon named "chevron right" (outlined).
  static const IconData chevron_right_outlined = IconData(0xef4e, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">child_care</i> &#x2014; material icon named "child care".
  static const IconData child_care = IconData(0xe160, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">child_care</i> &#x2014; material icon named "child care" (sharp).
  static const IconData child_care_sharp = IconData(0xe85d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">child_care</i> &#x2014; material icon named "child care" (round).
  static const IconData child_care_rounded = IconData(0xf63c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">child_care</i> &#x2014; material icon named "child care" (outlined).
  static const IconData child_care_outlined = IconData(0xef4f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">child_friendly</i> &#x2014; material icon named "child friendly".
  static const IconData child_friendly = IconData(0xe161, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">child_friendly</i> &#x2014; material icon named "child friendly" (sharp).
  static const IconData child_friendly_sharp = IconData(0xe85e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">child_friendly</i> &#x2014; material icon named "child friendly" (round).
  static const IconData child_friendly_rounded = IconData(0xf63d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">child_friendly</i> &#x2014; material icon named "child friendly" (outlined).
  static const IconData child_friendly_outlined = IconData(0xef50, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">chrome_reader_mode</i> &#x2014; material icon named "chrome reader mode".
  static const IconData chrome_reader_mode = IconData(0xe162, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">chrome_reader_mode</i> &#x2014; material icon named "chrome reader mode" (sharp).
  static const IconData chrome_reader_mode_sharp = IconData(0xe85f, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">chrome_reader_mode</i> &#x2014; material icon named "chrome reader mode" (round).
  static const IconData chrome_reader_mode_rounded = IconData(0xf63e, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">chrome_reader_mode</i> &#x2014; material icon named "chrome reader mode" (outlined).
  static const IconData chrome_reader_mode_outlined = IconData(0xef51, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">circle</i> &#x2014; material icon named "circle".
  static const IconData circle = IconData(0xe163, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">circle</i> &#x2014; material icon named "circle" (sharp).
  static const IconData circle_sharp = IconData(0xe861, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">circle</i> &#x2014; material icon named "circle" (round).
  static const IconData circle_rounded = IconData(0xf640, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">circle</i> &#x2014; material icon named "circle" (outlined).
  static const IconData circle_outlined = IconData(0xef53, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">circle_notifications</i> &#x2014; material icon named "circle notifications".
  static const IconData circle_notifications = IconData(0xe164, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">circle_notifications</i> &#x2014; material icon named "circle notifications" (sharp).
  static const IconData circle_notifications_sharp = IconData(0xe860, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">circle_notifications</i> &#x2014; material icon named "circle notifications" (round).
  static const IconData circle_notifications_rounded = IconData(0xf63f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">circle_notifications</i> &#x2014; material icon named "circle notifications" (outlined).
  static const IconData circle_notifications_outlined = IconData(0xef52, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">class</i> &#x2014; material icon named "class".
  static const IconData class_ = IconData(0xe165, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">class</i> &#x2014; material icon named "class" (sharp).
  static const IconData class__sharp = IconData(0xe862, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">class</i> &#x2014; material icon named "class" (round).
  static const IconData class__rounded = IconData(0xf641, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">class</i> &#x2014; material icon named "class" (outlined).
  static const IconData class__outlined = IconData(0xef54, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">clean_hands</i> &#x2014; material icon named "clean hands".
  static const IconData clean_hands = IconData(0xe166, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">clean_hands</i> &#x2014; material icon named "clean hands" (sharp).
  static const IconData clean_hands_sharp = IconData(0xe863, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">clean_hands</i> &#x2014; material icon named "clean hands" (round).
  static const IconData clean_hands_rounded = IconData(0xf642, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">clean_hands</i> &#x2014; material icon named "clean hands" (outlined).
  static const IconData clean_hands_outlined = IconData(0xef55, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cleaning_services</i> &#x2014; material icon named "cleaning services".
  static const IconData cleaning_services = IconData(0xe167, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cleaning_services</i> &#x2014; material icon named "cleaning services" (sharp).
  static const IconData cleaning_services_sharp = IconData(0xe864, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cleaning_services</i> &#x2014; material icon named "cleaning services" (round).
  static const IconData cleaning_services_rounded = IconData(0xf643, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cleaning_services</i> &#x2014; material icon named "cleaning services" (outlined).
  static const IconData cleaning_services_outlined = IconData(0xef56, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">clear</i> &#x2014; material icon named "clear".
  static const IconData clear = IconData(0xe168, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">clear</i> &#x2014; material icon named "clear" (sharp).
  static const IconData clear_sharp = IconData(0xe866, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">clear</i> &#x2014; material icon named "clear" (round).
  static const IconData clear_rounded = IconData(0xf645, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">clear</i> &#x2014; material icon named "clear" (outlined).
  static const IconData clear_outlined = IconData(0xef58, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">clear_all</i> &#x2014; material icon named "clear all".
  static const IconData clear_all = IconData(0xe169, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">clear_all</i> &#x2014; material icon named "clear all" (sharp).
  static const IconData clear_all_sharp = IconData(0xe865, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">clear_all</i> &#x2014; material icon named "clear all" (round).
  static const IconData clear_all_rounded = IconData(0xf644, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">clear_all</i> &#x2014; material icon named "clear all" (outlined).
  static const IconData clear_all_outlined = IconData(0xef57, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">close</i> &#x2014; material icon named "close".
  static const IconData close = IconData(0xe16a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">close</i> &#x2014; material icon named "close" (sharp).
  static const IconData close_sharp = IconData(0xe868, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">close</i> &#x2014; material icon named "close" (round).
  static const IconData close_rounded = IconData(0xf647, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">close</i> &#x2014; material icon named "close" (outlined).
  static const IconData close_outlined = IconData(0xef5a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">close_fullscreen</i> &#x2014; material icon named "close fullscreen".
  static const IconData close_fullscreen = IconData(0xe16b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">close_fullscreen</i> &#x2014; material icon named "close fullscreen" (sharp).
  static const IconData close_fullscreen_sharp = IconData(0xe867, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">close_fullscreen</i> &#x2014; material icon named "close fullscreen" (round).
  static const IconData close_fullscreen_rounded = IconData(0xf646, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">close_fullscreen</i> &#x2014; material icon named "close fullscreen" (outlined).
  static const IconData close_fullscreen_outlined = IconData(0xef59, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">closed_caption</i> &#x2014; material icon named "closed caption".
  static const IconData closed_caption = IconData(0xe16c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">closed_caption</i> &#x2014; material icon named "closed caption" (sharp).
  static const IconData closed_caption_sharp = IconData(0xe86b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">closed_caption</i> &#x2014; material icon named "closed caption" (round).
  static const IconData closed_caption_rounded = IconData(0xf64a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">closed_caption</i> &#x2014; material icon named "closed caption" (outlined).
  static const IconData closed_caption_outlined = IconData(0xef5d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">closed_caption_disabled</i> &#x2014; material icon named "closed caption disabled".
  static const IconData closed_caption_disabled = IconData(0xe16d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">closed_caption_disabled</i> &#x2014; material icon named "closed caption disabled" (sharp).
  static const IconData closed_caption_disabled_sharp = IconData(0xe869, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">closed_caption_disabled</i> &#x2014; material icon named "closed caption disabled" (round).
  static const IconData closed_caption_disabled_rounded = IconData(0xf648, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">closed_caption_disabled</i> &#x2014; material icon named "closed caption disabled" (outlined).
  static const IconData closed_caption_disabled_outlined = IconData(0xef5b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">closed_caption_off</i> &#x2014; material icon named "closed caption off".
  static const IconData closed_caption_off = IconData(0xe16e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">closed_caption_off</i> &#x2014; material icon named "closed caption off" (sharp).
  static const IconData closed_caption_off_sharp = IconData(0xe86a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">closed_caption_off</i> &#x2014; material icon named "closed caption off" (round).
  static const IconData closed_caption_off_rounded = IconData(0xf649, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">closed_caption_off</i> &#x2014; material icon named "closed caption off" (outlined).
  static const IconData closed_caption_off_outlined = IconData(0xef5c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cloud</i> &#x2014; material icon named "cloud".
  static const IconData cloud = IconData(0xe16f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cloud</i> &#x2014; material icon named "cloud" (sharp).
  static const IconData cloud_sharp = IconData(0xe871, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cloud</i> &#x2014; material icon named "cloud" (round).
  static const IconData cloud_rounded = IconData(0xf650, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cloud</i> &#x2014; material icon named "cloud" (outlined).
  static const IconData cloud_outlined = IconData(0xef62, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cloud_circle</i> &#x2014; material icon named "cloud circle".
  static const IconData cloud_circle = IconData(0xe170, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cloud_circle</i> &#x2014; material icon named "cloud circle" (sharp).
  static const IconData cloud_circle_sharp = IconData(0xe86c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cloud_circle</i> &#x2014; material icon named "cloud circle" (round).
  static const IconData cloud_circle_rounded = IconData(0xf64b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cloud_circle</i> &#x2014; material icon named "cloud circle" (outlined).
  static const IconData cloud_circle_outlined = IconData(0xef5e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cloud_done</i> &#x2014; material icon named "cloud done".
  static const IconData cloud_done = IconData(0xe171, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cloud_done</i> &#x2014; material icon named "cloud done" (sharp).
  static const IconData cloud_done_sharp = IconData(0xe86d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cloud_done</i> &#x2014; material icon named "cloud done" (round).
  static const IconData cloud_done_rounded = IconData(0xf64c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cloud_done</i> &#x2014; material icon named "cloud done" (outlined).
  static const IconData cloud_done_outlined = IconData(0xef5f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cloud_download</i> &#x2014; material icon named "cloud download".
  static const IconData cloud_download = IconData(0xe172, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cloud_download</i> &#x2014; material icon named "cloud download" (sharp).
  static const IconData cloud_download_sharp = IconData(0xe86e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cloud_download</i> &#x2014; material icon named "cloud download" (round).
  static const IconData cloud_download_rounded = IconData(0xf64d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cloud_download</i> &#x2014; material icon named "cloud download" (outlined).
  static const IconData cloud_download_outlined = IconData(0xef60, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cloud_off</i> &#x2014; material icon named "cloud off".
  static const IconData cloud_off = IconData(0xe173, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cloud_off</i> &#x2014; material icon named "cloud off" (sharp).
  static const IconData cloud_off_sharp = IconData(0xe86f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cloud_off</i> &#x2014; material icon named "cloud off" (round).
  static const IconData cloud_off_rounded = IconData(0xf64e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cloud_off</i> &#x2014; material icon named "cloud off" (outlined).
  static const IconData cloud_off_outlined = IconData(0xef61, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cloud_queue</i> &#x2014; material icon named "cloud queue".
  static const IconData cloud_queue = IconData(0xe174, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cloud_queue</i> &#x2014; material icon named "cloud queue" (sharp).
  static const IconData cloud_queue_sharp = IconData(0xe870, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cloud_queue</i> &#x2014; material icon named "cloud queue" (round).
  static const IconData cloud_queue_rounded = IconData(0xf64f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cloud_queue</i> &#x2014; material icon named "cloud queue" (outlined).
  static const IconData cloud_queue_outlined = IconData(0xef63, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cloud_upload</i> &#x2014; material icon named "cloud upload".
  static const IconData cloud_upload = IconData(0xe175, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cloud_upload</i> &#x2014; material icon named "cloud upload" (sharp).
  static const IconData cloud_upload_sharp = IconData(0xe872, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cloud_upload</i> &#x2014; material icon named "cloud upload" (round).
  static const IconData cloud_upload_rounded = IconData(0xf651, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cloud_upload</i> &#x2014; material icon named "cloud upload" (outlined).
  static const IconData cloud_upload_outlined = IconData(0xef64, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">code</i> &#x2014; material icon named "code".
  static const IconData code = IconData(0xe176, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">code</i> &#x2014; material icon named "code" (sharp).
  static const IconData code_sharp = IconData(0xe874, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">code</i> &#x2014; material icon named "code" (round).
  static const IconData code_rounded = IconData(0xf653, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">code</i> &#x2014; material icon named "code" (outlined).
  static const IconData code_outlined = IconData(0xef66, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">code_off</i> &#x2014; material icon named "code off".
  static const IconData code_off = IconData(0xe177, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">code_off</i> &#x2014; material icon named "code off" (sharp).
  static const IconData code_off_sharp = IconData(0xe873, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">code_off</i> &#x2014; material icon named "code off" (round).
  static const IconData code_off_rounded = IconData(0xf652, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">code_off</i> &#x2014; material icon named "code off" (outlined).
  static const IconData code_off_outlined = IconData(0xef65, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">coffee</i> &#x2014; material icon named "coffee".
  static const IconData coffee = IconData(0xe178, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">coffee</i> &#x2014; material icon named "coffee" (sharp).
  static const IconData coffee_sharp = IconData(0xe876, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">coffee</i> &#x2014; material icon named "coffee" (round).
  static const IconData coffee_rounded = IconData(0xf655, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">coffee</i> &#x2014; material icon named "coffee" (outlined).
  static const IconData coffee_outlined = IconData(0xef68, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">coffee_maker</i> &#x2014; material icon named "coffee maker".
  static const IconData coffee_maker = IconData(0xe179, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">coffee_maker</i> &#x2014; material icon named "coffee maker" (sharp).
  static const IconData coffee_maker_sharp = IconData(0xe875, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">coffee_maker</i> &#x2014; material icon named "coffee maker" (round).
  static const IconData coffee_maker_rounded = IconData(0xf654, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">coffee_maker</i> &#x2014; material icon named "coffee maker" (outlined).
  static const IconData coffee_maker_outlined = IconData(0xef67, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">collections</i> &#x2014; material icon named "collections".
  static const IconData collections = IconData(0xe17a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">collections</i> &#x2014; material icon named "collections" (sharp).
  static const IconData collections_sharp = IconData(0xe878, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">collections</i> &#x2014; material icon named "collections" (round).
  static const IconData collections_rounded = IconData(0xf657, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">collections</i> &#x2014; material icon named "collections" (outlined).
  static const IconData collections_outlined = IconData(0xef6a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">collections_bookmark</i> &#x2014; material icon named "collections bookmark".
  static const IconData collections_bookmark = IconData(0xe17b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">collections_bookmark</i> &#x2014; material icon named "collections bookmark" (sharp).
  static const IconData collections_bookmark_sharp = IconData(0xe877, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">collections_bookmark</i> &#x2014; material icon named "collections bookmark" (round).
  static const IconData collections_bookmark_rounded = IconData(0xf656, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">collections_bookmark</i> &#x2014; material icon named "collections bookmark" (outlined).
  static const IconData collections_bookmark_outlined = IconData(0xef69, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">color_lens</i> &#x2014; material icon named "color lens".
  static const IconData color_lens = IconData(0xe17c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">color_lens</i> &#x2014; material icon named "color lens" (sharp).
  static const IconData color_lens_sharp = IconData(0xe879, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">color_lens</i> &#x2014; material icon named "color lens" (round).
  static const IconData color_lens_rounded = IconData(0xf658, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">color_lens</i> &#x2014; material icon named "color lens" (outlined).
  static const IconData color_lens_outlined = IconData(0xef6b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">colorize</i> &#x2014; material icon named "colorize".
  static const IconData colorize = IconData(0xe17d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">colorize</i> &#x2014; material icon named "colorize" (sharp).
  static const IconData colorize_sharp = IconData(0xe87a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">colorize</i> &#x2014; material icon named "colorize" (round).
  static const IconData colorize_rounded = IconData(0xf659, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">colorize</i> &#x2014; material icon named "colorize" (outlined).
  static const IconData colorize_outlined = IconData(0xef6c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">comment</i> &#x2014; material icon named "comment".
  static const IconData comment = IconData(0xe17e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">comment</i> &#x2014; material icon named "comment" (sharp).
  static const IconData comment_sharp = IconData(0xe87c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">comment</i> &#x2014; material icon named "comment" (round).
  static const IconData comment_rounded = IconData(0xf65b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">comment</i> &#x2014; material icon named "comment" (outlined).
  static const IconData comment_outlined = IconData(0xef6e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">comment_bank</i> &#x2014; material icon named "comment bank".
  static const IconData comment_bank = IconData(0xe17f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">comment_bank</i> &#x2014; material icon named "comment bank" (sharp).
  static const IconData comment_bank_sharp = IconData(0xe87b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">comment_bank</i> &#x2014; material icon named "comment bank" (round).
  static const IconData comment_bank_rounded = IconData(0xf65a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">comment_bank</i> &#x2014; material icon named "comment bank" (outlined).
  static const IconData comment_bank_outlined = IconData(0xef6d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">commute</i> &#x2014; material icon named "commute".
  static const IconData commute = IconData(0xe180, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">commute</i> &#x2014; material icon named "commute" (sharp).
  static const IconData commute_sharp = IconData(0xe87d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">commute</i> &#x2014; material icon named "commute" (round).
  static const IconData commute_rounded = IconData(0xf65c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">commute</i> &#x2014; material icon named "commute" (outlined).
  static const IconData commute_outlined = IconData(0xef6f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">compare</i> &#x2014; material icon named "compare".
  static const IconData compare = IconData(0xe181, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">compare</i> &#x2014; material icon named "compare" (sharp).
  static const IconData compare_sharp = IconData(0xe87f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">compare</i> &#x2014; material icon named "compare" (round).
  static const IconData compare_rounded = IconData(0xf65e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">compare</i> &#x2014; material icon named "compare" (outlined).
  static const IconData compare_outlined = IconData(0xef71, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">compare_arrows</i> &#x2014; material icon named "compare arrows".
  static const IconData compare_arrows = IconData(0xe182, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">compare_arrows</i> &#x2014; material icon named "compare arrows" (sharp).
  static const IconData compare_arrows_sharp = IconData(0xe87e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">compare_arrows</i> &#x2014; material icon named "compare arrows" (round).
  static const IconData compare_arrows_rounded = IconData(0xf65d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">compare_arrows</i> &#x2014; material icon named "compare arrows" (outlined).
  static const IconData compare_arrows_outlined = IconData(0xef70, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">compass_calibration</i> &#x2014; material icon named "compass calibration".
  static const IconData compass_calibration = IconData(0xe183, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">compass_calibration</i> &#x2014; material icon named "compass calibration" (sharp).
  static const IconData compass_calibration_sharp = IconData(0xe880, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">compass_calibration</i> &#x2014; material icon named "compass calibration" (round).
  static const IconData compass_calibration_rounded = IconData(0xf65f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">compass_calibration</i> &#x2014; material icon named "compass calibration" (outlined).
  static const IconData compass_calibration_outlined = IconData(0xef72, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">compress</i> &#x2014; material icon named "compress".
  static const IconData compress = IconData(0xe184, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">compress</i> &#x2014; material icon named "compress" (sharp).
  static const IconData compress_sharp = IconData(0xe881, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">compress</i> &#x2014; material icon named "compress" (round).
  static const IconData compress_rounded = IconData(0xf660, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">compress</i> &#x2014; material icon named "compress" (outlined).
  static const IconData compress_outlined = IconData(0xef73, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">computer</i> &#x2014; material icon named "computer".
  static const IconData computer = IconData(0xe185, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">computer</i> &#x2014; material icon named "computer" (sharp).
  static const IconData computer_sharp = IconData(0xe882, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">computer</i> &#x2014; material icon named "computer" (round).
  static const IconData computer_rounded = IconData(0xf661, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">computer</i> &#x2014; material icon named "computer" (outlined).
  static const IconData computer_outlined = IconData(0xef74, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">confirmation_num</i> &#x2014; material icon named "confirmation num".
  static const IconData confirmation_num = IconData(0xe186, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">confirmation_num</i> &#x2014; material icon named "confirmation num" (sharp).
  static const IconData confirmation_num_sharp = IconData(0xe883, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">confirmation_num</i> &#x2014; material icon named "confirmation num" (round).
  static const IconData confirmation_num_rounded = IconData(0xf662, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">confirmation_num</i> &#x2014; material icon named "confirmation num" (outlined).
  static const IconData confirmation_num_outlined = IconData(0xef75, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">confirmation_number</i> &#x2014; material icon named "confirmation number".
  static const IconData confirmation_number = IconData(0xe186, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">confirmation_number</i> &#x2014; material icon named "confirmation number" (sharp).
  static const IconData confirmation_number_sharp = IconData(0xe883, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">confirmation_number</i> &#x2014; material icon named "confirmation number" (round).
  static const IconData confirmation_number_rounded = IconData(0xf662, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">confirmation_number</i> &#x2014; material icon named "confirmation number" (outlined).
  static const IconData confirmation_number_outlined = IconData(0xef75, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">connect_without_contact</i> &#x2014; material icon named "connect without contact".
  static const IconData connect_without_contact = IconData(0xe187, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">connect_without_contact</i> &#x2014; material icon named "connect without contact" (sharp).
  static const IconData connect_without_contact_sharp = IconData(0xe884, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">connect_without_contact</i> &#x2014; material icon named "connect without contact" (round).
  static const IconData connect_without_contact_rounded = IconData(0xf663, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">connect_without_contact</i> &#x2014; material icon named "connect without contact" (outlined).
  static const IconData connect_without_contact_outlined = IconData(0xef76, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">connected_tv</i> &#x2014; material icon named "connected tv".
  static const IconData connected_tv = IconData(0xe188, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">connected_tv</i> &#x2014; material icon named "connected tv" (sharp).
  static const IconData connected_tv_sharp = IconData(0xe885, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">connected_tv</i> &#x2014; material icon named "connected tv" (round).
  static const IconData connected_tv_rounded = IconData(0xf664, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">connected_tv</i> &#x2014; material icon named "connected tv" (outlined).
  static const IconData connected_tv_outlined = IconData(0xef77, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">construction</i> &#x2014; material icon named "construction".
  static const IconData construction = IconData(0xe189, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">construction</i> &#x2014; material icon named "construction" (sharp).
  static const IconData construction_sharp = IconData(0xe886, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">construction</i> &#x2014; material icon named "construction" (round).
  static const IconData construction_rounded = IconData(0xf665, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">construction</i> &#x2014; material icon named "construction" (outlined).
  static const IconData construction_outlined = IconData(0xef78, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">contact_mail</i> &#x2014; material icon named "contact mail".
  static const IconData contact_mail = IconData(0xe18a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">contact_mail</i> &#x2014; material icon named "contact mail" (sharp).
  static const IconData contact_mail_sharp = IconData(0xe887, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">contact_mail</i> &#x2014; material icon named "contact mail" (round).
  static const IconData contact_mail_rounded = IconData(0xf666, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">contact_mail</i> &#x2014; material icon named "contact mail" (outlined).
  static const IconData contact_mail_outlined = IconData(0xef79, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">contact_page</i> &#x2014; material icon named "contact page".
  static const IconData contact_page = IconData(0xe18b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">contact_page</i> &#x2014; material icon named "contact page" (sharp).
  static const IconData contact_page_sharp = IconData(0xe888, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">contact_page</i> &#x2014; material icon named "contact page" (round).
  static const IconData contact_page_rounded = IconData(0xf667, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">contact_page</i> &#x2014; material icon named "contact page" (outlined).
  static const IconData contact_page_outlined = IconData(0xef7a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">contact_phone</i> &#x2014; material icon named "contact phone".
  static const IconData contact_phone = IconData(0xe18c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">contact_phone</i> &#x2014; material icon named "contact phone" (sharp).
  static const IconData contact_phone_sharp = IconData(0xe889, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">contact_phone</i> &#x2014; material icon named "contact phone" (round).
  static const IconData contact_phone_rounded = IconData(0xf668, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">contact_phone</i> &#x2014; material icon named "contact phone" (outlined).
  static const IconData contact_phone_outlined = IconData(0xef7b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">contact_support</i> &#x2014; material icon named "contact support".
  static const IconData contact_support = IconData(0xe18d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">contact_support</i> &#x2014; material icon named "contact support" (sharp).
  static const IconData contact_support_sharp = IconData(0xe88a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">contact_support</i> &#x2014; material icon named "contact support" (round).
  static const IconData contact_support_rounded = IconData(0xf669, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">contact_support</i> &#x2014; material icon named "contact support" (outlined).
  static const IconData contact_support_outlined = IconData(0xef7c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">contactless</i> &#x2014; material icon named "contactless".
  static const IconData contactless = IconData(0xe18e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">contactless</i> &#x2014; material icon named "contactless" (sharp).
  static const IconData contactless_sharp = IconData(0xe88b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">contactless</i> &#x2014; material icon named "contactless" (round).
  static const IconData contactless_rounded = IconData(0xf66a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">contactless</i> &#x2014; material icon named "contactless" (outlined).
  static const IconData contactless_outlined = IconData(0xef7d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">contacts</i> &#x2014; material icon named "contacts".
  static const IconData contacts = IconData(0xe18f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">contacts</i> &#x2014; material icon named "contacts" (sharp).
  static const IconData contacts_sharp = IconData(0xe88c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">contacts</i> &#x2014; material icon named "contacts" (round).
  static const IconData contacts_rounded = IconData(0xf66b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">contacts</i> &#x2014; material icon named "contacts" (outlined).
  static const IconData contacts_outlined = IconData(0xef7e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">content_copy</i> &#x2014; material icon named "content copy".
  static const IconData content_copy = IconData(0xe190, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">content_copy</i> &#x2014; material icon named "content copy" (sharp).
  static const IconData content_copy_sharp = IconData(0xe88d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">content_copy</i> &#x2014; material icon named "content copy" (round).
  static const IconData content_copy_rounded = IconData(0xf66c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">content_copy</i> &#x2014; material icon named "content copy" (outlined).
  static const IconData content_copy_outlined = IconData(0xef7f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">content_cut</i> &#x2014; material icon named "content cut".
  static const IconData content_cut = IconData(0xe191, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">content_cut</i> &#x2014; material icon named "content cut" (sharp).
  static const IconData content_cut_sharp = IconData(0xe88e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">content_cut</i> &#x2014; material icon named "content cut" (round).
  static const IconData content_cut_rounded = IconData(0xf66d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">content_cut</i> &#x2014; material icon named "content cut" (outlined).
  static const IconData content_cut_outlined = IconData(0xef80, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">content_paste</i> &#x2014; material icon named "content paste".
  static const IconData content_paste = IconData(0xe192, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">content_paste</i> &#x2014; material icon named "content paste" (sharp).
  static const IconData content_paste_sharp = IconData(0xe890, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">content_paste</i> &#x2014; material icon named "content paste" (round).
  static const IconData content_paste_rounded = IconData(0xf66f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">content_paste</i> &#x2014; material icon named "content paste" (outlined).
  static const IconData content_paste_outlined = IconData(0xef82, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">content_paste_off</i> &#x2014; material icon named "content paste off".
  static const IconData content_paste_off = IconData(0xe193, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">content_paste_off</i> &#x2014; material icon named "content paste off" (sharp).
  static const IconData content_paste_off_sharp = IconData(0xe88f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">content_paste_off</i> &#x2014; material icon named "content paste off" (round).
  static const IconData content_paste_off_rounded = IconData(0xf66e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">content_paste_off</i> &#x2014; material icon named "content paste off" (outlined).
  static const IconData content_paste_off_outlined = IconData(0xef81, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">control_camera</i> &#x2014; material icon named "control camera".
  static const IconData control_camera = IconData(0xe194, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">control_camera</i> &#x2014; material icon named "control camera" (sharp).
  static const IconData control_camera_sharp = IconData(0xe891, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">control_camera</i> &#x2014; material icon named "control camera" (round).
  static const IconData control_camera_rounded = IconData(0xf670, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">control_camera</i> &#x2014; material icon named "control camera" (outlined).
  static const IconData control_camera_outlined = IconData(0xef83, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">control_point</i> &#x2014; material icon named "control point".
  static const IconData control_point = IconData(0xe195, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">control_point</i> &#x2014; material icon named "control point" (sharp).
  static const IconData control_point_sharp = IconData(0xe893, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">control_point</i> &#x2014; material icon named "control point" (round).
  static const IconData control_point_rounded = IconData(0xf672, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">control_point</i> &#x2014; material icon named "control point" (outlined).
  static const IconData control_point_outlined = IconData(0xef85, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">control_point_duplicate</i> &#x2014; material icon named "control point duplicate".
  static const IconData control_point_duplicate = IconData(0xe196, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">control_point_duplicate</i> &#x2014; material icon named "control point duplicate" (sharp).
  static const IconData control_point_duplicate_sharp = IconData(0xe892, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">control_point_duplicate</i> &#x2014; material icon named "control point duplicate" (round).
  static const IconData control_point_duplicate_rounded = IconData(0xf671, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">control_point_duplicate</i> &#x2014; material icon named "control point duplicate" (outlined).
  static const IconData control_point_duplicate_outlined = IconData(0xef84, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">copy</i> &#x2014; material icon named "copy".
  static const IconData copy = IconData(0xe190, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">copy</i> &#x2014; material icon named "copy" (sharp).
  static const IconData copy_sharp = IconData(0xe88d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">copy</i> &#x2014; material icon named "copy" (round).
  static const IconData copy_rounded = IconData(0xf66c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">copy</i> &#x2014; material icon named "copy" (outlined).
  static const IconData copy_outlined = IconData(0xef7f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">copy_all</i> &#x2014; material icon named "copy all".
  static const IconData copy_all = IconData(0xe197, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">copy_all</i> &#x2014; material icon named "copy all" (sharp).
  static const IconData copy_all_sharp = IconData(0xe894, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">copy_all</i> &#x2014; material icon named "copy all" (round).
  static const IconData copy_all_rounded = IconData(0xf673, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">copy_all</i> &#x2014; material icon named "copy all" (outlined).
  static const IconData copy_all_outlined = IconData(0xef86, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">copyright</i> &#x2014; material icon named "copyright".
  static const IconData copyright = IconData(0xe198, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">copyright</i> &#x2014; material icon named "copyright" (sharp).
  static const IconData copyright_sharp = IconData(0xe895, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">copyright</i> &#x2014; material icon named "copyright" (round).
  static const IconData copyright_rounded = IconData(0xf674, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">copyright</i> &#x2014; material icon named "copyright" (outlined).
  static const IconData copyright_outlined = IconData(0xef87, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">coronavirus</i> &#x2014; material icon named "coronavirus".
  static const IconData coronavirus = IconData(0xe199, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">coronavirus</i> &#x2014; material icon named "coronavirus" (sharp).
  static const IconData coronavirus_sharp = IconData(0xe896, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">coronavirus</i> &#x2014; material icon named "coronavirus" (round).
  static const IconData coronavirus_rounded = IconData(0xf675, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">coronavirus</i> &#x2014; material icon named "coronavirus" (outlined).
  static const IconData coronavirus_outlined = IconData(0xef88, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">corporate_fare</i> &#x2014; material icon named "corporate fare".
  static const IconData corporate_fare = IconData(0xe19a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">corporate_fare</i> &#x2014; material icon named "corporate fare" (sharp).
  static const IconData corporate_fare_sharp = IconData(0xe897, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">corporate_fare</i> &#x2014; material icon named "corporate fare" (round).
  static const IconData corporate_fare_rounded = IconData(0xf676, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">corporate_fare</i> &#x2014; material icon named "corporate fare" (outlined).
  static const IconData corporate_fare_outlined = IconData(0xef89, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cottage</i> &#x2014; material icon named "cottage".
  static const IconData cottage = IconData(0xe19b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cottage</i> &#x2014; material icon named "cottage" (sharp).
  static const IconData cottage_sharp = IconData(0xe898, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cottage</i> &#x2014; material icon named "cottage" (round).
  static const IconData cottage_rounded = IconData(0xf677, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cottage</i> &#x2014; material icon named "cottage" (outlined).
  static const IconData cottage_outlined = IconData(0xef8a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">countertops</i> &#x2014; material icon named "countertops".
  static const IconData countertops = IconData(0xe19c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">countertops</i> &#x2014; material icon named "countertops" (sharp).
  static const IconData countertops_sharp = IconData(0xe899, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">countertops</i> &#x2014; material icon named "countertops" (round).
  static const IconData countertops_rounded = IconData(0xf678, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">countertops</i> &#x2014; material icon named "countertops" (outlined).
  static const IconData countertops_outlined = IconData(0xef8b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">create</i> &#x2014; material icon named "create".
  static const IconData create = IconData(0xe19d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">create</i> &#x2014; material icon named "create" (sharp).
  static const IconData create_sharp = IconData(0xe89b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">create</i> &#x2014; material icon named "create" (round).
  static const IconData create_rounded = IconData(0xf67a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">create</i> &#x2014; material icon named "create" (outlined).
  static const IconData create_outlined = IconData(0xef8d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">create_new_folder</i> &#x2014; material icon named "create new folder".
  static const IconData create_new_folder = IconData(0xe19e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">create_new_folder</i> &#x2014; material icon named "create new folder" (sharp).
  static const IconData create_new_folder_sharp = IconData(0xe89a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">create_new_folder</i> &#x2014; material icon named "create new folder" (round).
  static const IconData create_new_folder_rounded = IconData(0xf679, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">create_new_folder</i> &#x2014; material icon named "create new folder" (outlined).
  static const IconData create_new_folder_outlined = IconData(0xef8c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">credit_card</i> &#x2014; material icon named "credit card".
  static const IconData credit_card = IconData(0xe19f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">credit_card</i> &#x2014; material icon named "credit card" (sharp).
  static const IconData credit_card_sharp = IconData(0xe89d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">credit_card</i> &#x2014; material icon named "credit card" (round).
  static const IconData credit_card_rounded = IconData(0xf67c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">credit_card</i> &#x2014; material icon named "credit card" (outlined).
  static const IconData credit_card_outlined = IconData(0xef8f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">credit_card_off</i> &#x2014; material icon named "credit card off".
  static const IconData credit_card_off = IconData(0xe1a0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">credit_card_off</i> &#x2014; material icon named "credit card off" (sharp).
  static const IconData credit_card_off_sharp = IconData(0xe89c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">credit_card_off</i> &#x2014; material icon named "credit card off" (round).
  static const IconData credit_card_off_rounded = IconData(0xf67b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">credit_card_off</i> &#x2014; material icon named "credit card off" (outlined).
  static const IconData credit_card_off_outlined = IconData(0xef8e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">credit_score</i> &#x2014; material icon named "credit score".
  static const IconData credit_score = IconData(0xe1a1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">credit_score</i> &#x2014; material icon named "credit score" (sharp).
  static const IconData credit_score_sharp = IconData(0xe89e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">credit_score</i> &#x2014; material icon named "credit score" (round).
  static const IconData credit_score_rounded = IconData(0xf67d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">credit_score</i> &#x2014; material icon named "credit score" (outlined).
  static const IconData credit_score_outlined = IconData(0xef90, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crib</i> &#x2014; material icon named "crib".
  static const IconData crib = IconData(0xe1a2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">crib</i> &#x2014; material icon named "crib" (sharp).
  static const IconData crib_sharp = IconData(0xe89f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">crib</i> &#x2014; material icon named "crib" (round).
  static const IconData crib_rounded = IconData(0xf67e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">crib</i> &#x2014; material icon named "crib" (outlined).
  static const IconData crib_outlined = IconData(0xef91, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop</i> &#x2014; material icon named "crop".
  static const IconData crop = IconData(0xe1a3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">crop</i> &#x2014; material icon named "crop" (sharp).
  static const IconData crop_sharp = IconData(0xe8aa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">crop</i> &#x2014; material icon named "crop" (round).
  static const IconData crop_rounded = IconData(0xf689, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">crop</i> &#x2014; material icon named "crop" (outlined).
  static const IconData crop_outlined = IconData(0xef9a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_16_9</i> &#x2014; material icon named "crop 16 9".
  static const IconData crop_16_9 = IconData(0xe1a4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">crop_16_9</i> &#x2014; material icon named "crop 16 9" (sharp).
  static const IconData crop_16_9_sharp = IconData(0xe8a0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">crop_16_9</i> &#x2014; material icon named "crop 16 9" (round).
  static const IconData crop_16_9_rounded = IconData(0xf67f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">crop_16_9</i> &#x2014; material icon named "crop 16 9" (outlined).
  static const IconData crop_16_9_outlined = IconData(0xef92, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_3_2</i> &#x2014; material icon named "crop 3 2".
  static const IconData crop_3_2 = IconData(0xe1a5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">crop_3_2</i> &#x2014; material icon named "crop 3 2" (sharp).
  static const IconData crop_3_2_sharp = IconData(0xe8a1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">crop_3_2</i> &#x2014; material icon named "crop 3 2" (round).
  static const IconData crop_3_2_rounded = IconData(0xf680, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">crop_3_2</i> &#x2014; material icon named "crop 3 2" (outlined).
  static const IconData crop_3_2_outlined = IconData(0xef93, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_5_4</i> &#x2014; material icon named "crop 5 4".
  static const IconData crop_5_4 = IconData(0xe1a6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">crop_5_4</i> &#x2014; material icon named "crop 5 4" (sharp).
  static const IconData crop_5_4_sharp = IconData(0xe8a2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">crop_5_4</i> &#x2014; material icon named "crop 5 4" (round).
  static const IconData crop_5_4_rounded = IconData(0xf681, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">crop_5_4</i> &#x2014; material icon named "crop 5 4" (outlined).
  static const IconData crop_5_4_outlined = IconData(0xef94, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_7_5</i> &#x2014; material icon named "crop 7 5".
  static const IconData crop_7_5 = IconData(0xe1a7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">crop_7_5</i> &#x2014; material icon named "crop 7 5" (sharp).
  static const IconData crop_7_5_sharp = IconData(0xe8a3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">crop_7_5</i> &#x2014; material icon named "crop 7 5" (round).
  static const IconData crop_7_5_rounded = IconData(0xf682, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">crop_7_5</i> &#x2014; material icon named "crop 7 5" (outlined).
  static const IconData crop_7_5_outlined = IconData(0xef95, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_din</i> &#x2014; material icon named "crop din".
  static const IconData crop_din = IconData(0xe1a8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">crop_din</i> &#x2014; material icon named "crop din" (sharp).
  static const IconData crop_din_sharp = IconData(0xe8a4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">crop_din</i> &#x2014; material icon named "crop din" (round).
  static const IconData crop_din_rounded = IconData(0xf683, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">crop_din</i> &#x2014; material icon named "crop din" (outlined).
  static const IconData crop_din_outlined = IconData(0xef96, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_free</i> &#x2014; material icon named "crop free".
  static const IconData crop_free = IconData(0xe1a9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">crop_free</i> &#x2014; material icon named "crop free" (sharp).
  static const IconData crop_free_sharp = IconData(0xe8a5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">crop_free</i> &#x2014; material icon named "crop free" (round).
  static const IconData crop_free_rounded = IconData(0xf684, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">crop_free</i> &#x2014; material icon named "crop free" (outlined).
  static const IconData crop_free_outlined = IconData(0xef97, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_landscape</i> &#x2014; material icon named "crop landscape".
  static const IconData crop_landscape = IconData(0xe1aa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">crop_landscape</i> &#x2014; material icon named "crop landscape" (sharp).
  static const IconData crop_landscape_sharp = IconData(0xe8a6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">crop_landscape</i> &#x2014; material icon named "crop landscape" (round).
  static const IconData crop_landscape_rounded = IconData(0xf685, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">crop_landscape</i> &#x2014; material icon named "crop landscape" (outlined).
  static const IconData crop_landscape_outlined = IconData(0xef98, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_original</i> &#x2014; material icon named "crop original".
  static const IconData crop_original = IconData(0xe1ab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">crop_original</i> &#x2014; material icon named "crop original" (sharp).
  static const IconData crop_original_sharp = IconData(0xe8a7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">crop_original</i> &#x2014; material icon named "crop original" (round).
  static const IconData crop_original_rounded = IconData(0xf686, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">crop_original</i> &#x2014; material icon named "crop original" (outlined).
  static const IconData crop_original_outlined = IconData(0xef99, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_portrait</i> &#x2014; material icon named "crop portrait".
  static const IconData crop_portrait = IconData(0xe1ac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">crop_portrait</i> &#x2014; material icon named "crop portrait" (sharp).
  static const IconData crop_portrait_sharp = IconData(0xe8a8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">crop_portrait</i> &#x2014; material icon named "crop portrait" (round).
  static const IconData crop_portrait_rounded = IconData(0xf687, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">crop_portrait</i> &#x2014; material icon named "crop portrait" (outlined).
  static const IconData crop_portrait_outlined = IconData(0xef9b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_rotate</i> &#x2014; material icon named "crop rotate".
  static const IconData crop_rotate = IconData(0xe1ad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">crop_rotate</i> &#x2014; material icon named "crop rotate" (sharp).
  static const IconData crop_rotate_sharp = IconData(0xe8a9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">crop_rotate</i> &#x2014; material icon named "crop rotate" (round).
  static const IconData crop_rotate_rounded = IconData(0xf688, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">crop_rotate</i> &#x2014; material icon named "crop rotate" (outlined).
  static const IconData crop_rotate_outlined = IconData(0xef9c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">crop_square</i> &#x2014; material icon named "crop square".
  static const IconData crop_square = IconData(0xe1ae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">crop_square</i> &#x2014; material icon named "crop square" (sharp).
  static const IconData crop_square_sharp = IconData(0xe8ab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">crop_square</i> &#x2014; material icon named "crop square" (round).
  static const IconData crop_square_rounded = IconData(0xf68a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">crop_square</i> &#x2014; material icon named "crop square" (outlined).
  static const IconData crop_square_outlined = IconData(0xef9d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">cut</i> &#x2014; material icon named "cut".
  static const IconData cut = IconData(0xe191, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">cut</i> &#x2014; material icon named "cut" (sharp).
  static const IconData cut_sharp = IconData(0xe88e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">cut</i> &#x2014; material icon named "cut" (round).
  static const IconData cut_rounded = IconData(0xf66d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">cut</i> &#x2014; material icon named "cut" (outlined).
  static const IconData cut_outlined = IconData(0xef80, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dangerous</i> &#x2014; material icon named "dangerous".
  static const IconData dangerous = IconData(0xe1af, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">dangerous</i> &#x2014; material icon named "dangerous" (sharp).
  static const IconData dangerous_sharp = IconData(0xe8ac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">dangerous</i> &#x2014; material icon named "dangerous" (round).
  static const IconData dangerous_rounded = IconData(0xf68b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">dangerous</i> &#x2014; material icon named "dangerous" (outlined).
  static const IconData dangerous_outlined = IconData(0xef9e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dark_mode</i> &#x2014; material icon named "dark mode".
  static const IconData dark_mode = IconData(0xe1b0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">dark_mode</i> &#x2014; material icon named "dark mode" (sharp).
  static const IconData dark_mode_sharp = IconData(0xe8ad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">dark_mode</i> &#x2014; material icon named "dark mode" (round).
  static const IconData dark_mode_rounded = IconData(0xf68c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">dark_mode</i> &#x2014; material icon named "dark mode" (outlined).
  static const IconData dark_mode_outlined = IconData(0xef9f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dashboard</i> &#x2014; material icon named "dashboard".
  static const IconData dashboard = IconData(0xe1b1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">dashboard</i> &#x2014; material icon named "dashboard" (sharp).
  static const IconData dashboard_sharp = IconData(0xe8af, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">dashboard</i> &#x2014; material icon named "dashboard" (round).
  static const IconData dashboard_rounded = IconData(0xf68e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">dashboard</i> &#x2014; material icon named "dashboard" (outlined).
  static const IconData dashboard_outlined = IconData(0xefa1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dashboard_customize</i> &#x2014; material icon named "dashboard customize".
  static const IconData dashboard_customize = IconData(0xe1b2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">dashboard_customize</i> &#x2014; material icon named "dashboard customize" (sharp).
  static const IconData dashboard_customize_sharp = IconData(0xe8ae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">dashboard_customize</i> &#x2014; material icon named "dashboard customize" (round).
  static const IconData dashboard_customize_rounded = IconData(0xf68d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">dashboard_customize</i> &#x2014; material icon named "dashboard customize" (outlined).
  static const IconData dashboard_customize_outlined = IconData(0xefa0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">data_saver_off</i> &#x2014; material icon named "data saver off".
  static const IconData data_saver_off = IconData(0xe1b3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">data_saver_off</i> &#x2014; material icon named "data saver off" (sharp).
  static const IconData data_saver_off_sharp = IconData(0xe8b0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">data_saver_off</i> &#x2014; material icon named "data saver off" (round).
  static const IconData data_saver_off_rounded = IconData(0xf68f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">data_saver_off</i> &#x2014; material icon named "data saver off" (outlined).
  static const IconData data_saver_off_outlined = IconData(0xefa2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">data_saver_on</i> &#x2014; material icon named "data saver on".
  static const IconData data_saver_on = IconData(0xe1b4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">data_saver_on</i> &#x2014; material icon named "data saver on" (sharp).
  static const IconData data_saver_on_sharp = IconData(0xe8b1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">data_saver_on</i> &#x2014; material icon named "data saver on" (round).
  static const IconData data_saver_on_rounded = IconData(0xf690, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">data_saver_on</i> &#x2014; material icon named "data saver on" (outlined).
  static const IconData data_saver_on_outlined = IconData(0xefa3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">data_usage</i> &#x2014; material icon named "data usage".
  static const IconData data_usage = IconData(0xe1b5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">data_usage</i> &#x2014; material icon named "data usage" (sharp).
  static const IconData data_usage_sharp = IconData(0xe8b2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">data_usage</i> &#x2014; material icon named "data usage" (round).
  static const IconData data_usage_rounded = IconData(0xf691, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">data_usage</i> &#x2014; material icon named "data usage" (outlined).
  static const IconData data_usage_outlined = IconData(0xefa4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">date_range</i> &#x2014; material icon named "date range".
  static const IconData date_range = IconData(0xe1b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">date_range</i> &#x2014; material icon named "date range" (sharp).
  static const IconData date_range_sharp = IconData(0xe8b3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">date_range</i> &#x2014; material icon named "date range" (round).
  static const IconData date_range_rounded = IconData(0xf692, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">date_range</i> &#x2014; material icon named "date range" (outlined).
  static const IconData date_range_outlined = IconData(0xefa5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">deck</i> &#x2014; material icon named "deck".
  static const IconData deck = IconData(0xe1b7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">deck</i> &#x2014; material icon named "deck" (sharp).
  static const IconData deck_sharp = IconData(0xe8b4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">deck</i> &#x2014; material icon named "deck" (round).
  static const IconData deck_rounded = IconData(0xf693, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">deck</i> &#x2014; material icon named "deck" (outlined).
  static const IconData deck_outlined = IconData(0xefa6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dehaze</i> &#x2014; material icon named "dehaze".
  static const IconData dehaze = IconData(0xe1b8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">dehaze</i> &#x2014; material icon named "dehaze" (sharp).
  static const IconData dehaze_sharp = IconData(0xe8b5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">dehaze</i> &#x2014; material icon named "dehaze" (round).
  static const IconData dehaze_rounded = IconData(0xf694, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">dehaze</i> &#x2014; material icon named "dehaze" (outlined).
  static const IconData dehaze_outlined = IconData(0xefa7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">delete</i> &#x2014; material icon named "delete".
  static const IconData delete = IconData(0xe1b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">delete</i> &#x2014; material icon named "delete" (sharp).
  static const IconData delete_sharp = IconData(0xe8b8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">delete</i> &#x2014; material icon named "delete" (round).
  static const IconData delete_rounded = IconData(0xf697, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">delete</i> &#x2014; material icon named "delete" (outlined).
  static const IconData delete_outlined = IconData(0xefaa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">delete_forever</i> &#x2014; material icon named "delete forever".
  static const IconData delete_forever = IconData(0xe1ba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">delete_forever</i> &#x2014; material icon named "delete forever" (sharp).
  static const IconData delete_forever_sharp = IconData(0xe8b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">delete_forever</i> &#x2014; material icon named "delete forever" (round).
  static const IconData delete_forever_rounded = IconData(0xf695, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">delete_forever</i> &#x2014; material icon named "delete forever" (outlined).
  static const IconData delete_forever_outlined = IconData(0xefa8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">delete_outline</i> &#x2014; material icon named "delete outline".
  static const IconData delete_outline = IconData(0xe1bb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">delete_outline</i> &#x2014; material icon named "delete outline" (sharp).
  static const IconData delete_outline_sharp = IconData(0xe8b7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">delete_outline</i> &#x2014; material icon named "delete outline" (round).
  static const IconData delete_outline_rounded = IconData(0xf696, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">delete_outline</i> &#x2014; material icon named "delete outline" (outlined).
  static const IconData delete_outline_outlined = IconData(0xefa9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">delete_sweep</i> &#x2014; material icon named "delete sweep".
  static const IconData delete_sweep = IconData(0xe1bc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">delete_sweep</i> &#x2014; material icon named "delete sweep" (sharp).
  static const IconData delete_sweep_sharp = IconData(0xe8b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">delete_sweep</i> &#x2014; material icon named "delete sweep" (round).
  static const IconData delete_sweep_rounded = IconData(0xf698, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">delete_sweep</i> &#x2014; material icon named "delete sweep" (outlined).
  static const IconData delete_sweep_outlined = IconData(0xefab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">delivery_dining</i> &#x2014; material icon named "delivery dining".
  static const IconData delivery_dining = IconData(0xe1bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">delivery_dining</i> &#x2014; material icon named "delivery dining" (sharp).
  static const IconData delivery_dining_sharp = IconData(0xe8ba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">delivery_dining</i> &#x2014; material icon named "delivery dining" (round).
  static const IconData delivery_dining_rounded = IconData(0xf699, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">delivery_dining</i> &#x2014; material icon named "delivery dining" (outlined).
  static const IconData delivery_dining_outlined = IconData(0xefac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">departure_board</i> &#x2014; material icon named "departure board".
  static const IconData departure_board = IconData(0xe1be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">departure_board</i> &#x2014; material icon named "departure board" (sharp).
  static const IconData departure_board_sharp = IconData(0xe8bb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">departure_board</i> &#x2014; material icon named "departure board" (round).
  static const IconData departure_board_rounded = IconData(0xf69a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">departure_board</i> &#x2014; material icon named "departure board" (outlined).
  static const IconData departure_board_outlined = IconData(0xefad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">description</i> &#x2014; material icon named "description".
  static const IconData description = IconData(0xe1bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">description</i> &#x2014; material icon named "description" (sharp).
  static const IconData description_sharp = IconData(0xe8bc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">description</i> &#x2014; material icon named "description" (round).
  static const IconData description_rounded = IconData(0xf69b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">description</i> &#x2014; material icon named "description" (outlined).
  static const IconData description_outlined = IconData(0xefae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">design_services</i> &#x2014; material icon named "design services".
  static const IconData design_services = IconData(0xe1c0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">design_services</i> &#x2014; material icon named "design services" (sharp).
  static const IconData design_services_sharp = IconData(0xe8bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">design_services</i> &#x2014; material icon named "design services" (round).
  static const IconData design_services_rounded = IconData(0xf69c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">design_services</i> &#x2014; material icon named "design services" (outlined).
  static const IconData design_services_outlined = IconData(0xefaf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">desktop_access_disabled</i> &#x2014; material icon named "desktop access disabled".
  static const IconData desktop_access_disabled = IconData(0xe1c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">desktop_access_disabled</i> &#x2014; material icon named "desktop access disabled" (sharp).
  static const IconData desktop_access_disabled_sharp = IconData(0xe8be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">desktop_access_disabled</i> &#x2014; material icon named "desktop access disabled" (round).
  static const IconData desktop_access_disabled_rounded = IconData(0xf69d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">desktop_access_disabled</i> &#x2014; material icon named "desktop access disabled" (outlined).
  static const IconData desktop_access_disabled_outlined = IconData(0xefb0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">desktop_mac</i> &#x2014; material icon named "desktop mac".
  static const IconData desktop_mac = IconData(0xe1c2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">desktop_mac</i> &#x2014; material icon named "desktop mac" (sharp).
  static const IconData desktop_mac_sharp = IconData(0xe8bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">desktop_mac</i> &#x2014; material icon named "desktop mac" (round).
  static const IconData desktop_mac_rounded = IconData(0xf69e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">desktop_mac</i> &#x2014; material icon named "desktop mac" (outlined).
  static const IconData desktop_mac_outlined = IconData(0xefb1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">desktop_windows</i> &#x2014; material icon named "desktop windows".
  static const IconData desktop_windows = IconData(0xe1c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">desktop_windows</i> &#x2014; material icon named "desktop windows" (sharp).
  static const IconData desktop_windows_sharp = IconData(0xe8c0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">desktop_windows</i> &#x2014; material icon named "desktop windows" (round).
  static const IconData desktop_windows_rounded = IconData(0xf69f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">desktop_windows</i> &#x2014; material icon named "desktop windows" (outlined).
  static const IconData desktop_windows_outlined = IconData(0xefb2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">details</i> &#x2014; material icon named "details".
  static const IconData details = IconData(0xe1c4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">details</i> &#x2014; material icon named "details" (sharp).
  static const IconData details_sharp = IconData(0xe8c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">details</i> &#x2014; material icon named "details" (round).
  static const IconData details_rounded = IconData(0xf6a0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">details</i> &#x2014; material icon named "details" (outlined).
  static const IconData details_outlined = IconData(0xefb3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">developer_board</i> &#x2014; material icon named "developer board".
  static const IconData developer_board = IconData(0xe1c5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">developer_board</i> &#x2014; material icon named "developer board" (sharp).
  static const IconData developer_board_sharp = IconData(0xe8c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">developer_board</i> &#x2014; material icon named "developer board" (round).
  static const IconData developer_board_rounded = IconData(0xf6a2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">developer_board</i> &#x2014; material icon named "developer board" (outlined).
  static const IconData developer_board_outlined = IconData(0xefb5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">developer_board_off</i> &#x2014; material icon named "developer board off".
  static const IconData developer_board_off = IconData(0xe1c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">developer_board_off</i> &#x2014; material icon named "developer board off" (sharp).
  static const IconData developer_board_off_sharp = IconData(0xe8c2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">developer_board_off</i> &#x2014; material icon named "developer board off" (round).
  static const IconData developer_board_off_rounded = IconData(0xf6a1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">developer_board_off</i> &#x2014; material icon named "developer board off" (outlined).
  static const IconData developer_board_off_outlined = IconData(0xefb4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">developer_mode</i> &#x2014; material icon named "developer mode".
  static const IconData developer_mode = IconData(0xe1c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">developer_mode</i> &#x2014; material icon named "developer mode" (sharp).
  static const IconData developer_mode_sharp = IconData(0xe8c4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">developer_mode</i> &#x2014; material icon named "developer mode" (round).
  static const IconData developer_mode_rounded = IconData(0xf6a3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">developer_mode</i> &#x2014; material icon named "developer mode" (outlined).
  static const IconData developer_mode_outlined = IconData(0xefb6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">device_hub</i> &#x2014; material icon named "device hub".
  static const IconData device_hub = IconData(0xe1c8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">device_hub</i> &#x2014; material icon named "device hub" (sharp).
  static const IconData device_hub_sharp = IconData(0xe8c5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">device_hub</i> &#x2014; material icon named "device hub" (round).
  static const IconData device_hub_rounded = IconData(0xf6a4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">device_hub</i> &#x2014; material icon named "device hub" (outlined).
  static const IconData device_hub_outlined = IconData(0xefb7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">device_thermostat</i> &#x2014; material icon named "device thermostat".
  static const IconData device_thermostat = IconData(0xe1c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">device_thermostat</i> &#x2014; material icon named "device thermostat" (sharp).
  static const IconData device_thermostat_sharp = IconData(0xe8c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">device_thermostat</i> &#x2014; material icon named "device thermostat" (round).
  static const IconData device_thermostat_rounded = IconData(0xf6a5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">device_thermostat</i> &#x2014; material icon named "device thermostat" (outlined).
  static const IconData device_thermostat_outlined = IconData(0xefb8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">device_unknown</i> &#x2014; material icon named "device unknown".
  static const IconData device_unknown = IconData(0xe1ca, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">device_unknown</i> &#x2014; material icon named "device unknown" (sharp).
  static const IconData device_unknown_sharp = IconData(0xe8c7, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">device_unknown</i> &#x2014; material icon named "device unknown" (round).
  static const IconData device_unknown_rounded = IconData(0xf6a6, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">device_unknown</i> &#x2014; material icon named "device unknown" (outlined).
  static const IconData device_unknown_outlined = IconData(0xefb9, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">devices</i> &#x2014; material icon named "devices".
  static const IconData devices = IconData(0xe1cb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">devices</i> &#x2014; material icon named "devices" (sharp).
  static const IconData devices_sharp = IconData(0xe8c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">devices</i> &#x2014; material icon named "devices" (round).
  static const IconData devices_rounded = IconData(0xf6a8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">devices</i> &#x2014; material icon named "devices" (outlined).
  static const IconData devices_outlined = IconData(0xefbb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">devices_other</i> &#x2014; material icon named "devices other".
  static const IconData devices_other = IconData(0xe1cc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">devices_other</i> &#x2014; material icon named "devices other" (sharp).
  static const IconData devices_other_sharp = IconData(0xe8c8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">devices_other</i> &#x2014; material icon named "devices other" (round).
  static const IconData devices_other_rounded = IconData(0xf6a7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">devices_other</i> &#x2014; material icon named "devices other" (outlined).
  static const IconData devices_other_outlined = IconData(0xefba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dialer_sip</i> &#x2014; material icon named "dialer sip".
  static const IconData dialer_sip = IconData(0xe1cd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">dialer_sip</i> &#x2014; material icon named "dialer sip" (sharp).
  static const IconData dialer_sip_sharp = IconData(0xe8ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">dialer_sip</i> &#x2014; material icon named "dialer sip" (round).
  static const IconData dialer_sip_rounded = IconData(0xf6a9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">dialer_sip</i> &#x2014; material icon named "dialer sip" (outlined).
  static const IconData dialer_sip_outlined = IconData(0xefbc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dialpad</i> &#x2014; material icon named "dialpad".
  static const IconData dialpad = IconData(0xe1ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">dialpad</i> &#x2014; material icon named "dialpad" (sharp).
  static const IconData dialpad_sharp = IconData(0xe8cb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">dialpad</i> &#x2014; material icon named "dialpad" (round).
  static const IconData dialpad_rounded = IconData(0xf6aa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">dialpad</i> &#x2014; material icon named "dialpad" (outlined).
  static const IconData dialpad_outlined = IconData(0xefbd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dining</i> &#x2014; material icon named "dining".
  static const IconData dining = IconData(0xe1cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">dining</i> &#x2014; material icon named "dining" (sharp).
  static const IconData dining_sharp = IconData(0xe8cc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">dining</i> &#x2014; material icon named "dining" (round).
  static const IconData dining_rounded = IconData(0xf6ab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">dining</i> &#x2014; material icon named "dining" (outlined).
  static const IconData dining_outlined = IconData(0xefbe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dinner_dining</i> &#x2014; material icon named "dinner dining".
  static const IconData dinner_dining = IconData(0xe1d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">dinner_dining</i> &#x2014; material icon named "dinner dining" (sharp).
  static const IconData dinner_dining_sharp = IconData(0xe8cd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">dinner_dining</i> &#x2014; material icon named "dinner dining" (round).
  static const IconData dinner_dining_rounded = IconData(0xf6ac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">dinner_dining</i> &#x2014; material icon named "dinner dining" (outlined).
  static const IconData dinner_dining_outlined = IconData(0xefbf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions</i> &#x2014; material icon named "directions".
  static const IconData directions = IconData(0xe1d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions</i> &#x2014; material icon named "directions" (sharp).
  static const IconData directions_sharp = IconData(0xe8d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions</i> &#x2014; material icon named "directions" (round).
  static const IconData directions_rounded = IconData(0xf6b7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions</i> &#x2014; material icon named "directions" (outlined).
  static const IconData directions_outlined = IconData(0xefc8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_bike</i> &#x2014; material icon named "directions bike".
  static const IconData directions_bike = IconData(0xe1d2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions_bike</i> &#x2014; material icon named "directions bike" (sharp).
  static const IconData directions_bike_sharp = IconData(0xe8ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions_bike</i> &#x2014; material icon named "directions bike" (round).
  static const IconData directions_bike_rounded = IconData(0xf6ad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions_bike</i> &#x2014; material icon named "directions bike" (outlined).
  static const IconData directions_bike_outlined = IconData(0xefc0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_boat</i> &#x2014; material icon named "directions boat".
  static const IconData directions_boat = IconData(0xe1d3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions_boat</i> &#x2014; material icon named "directions boat" (sharp).
  static const IconData directions_boat_sharp = IconData(0xe8d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions_boat</i> &#x2014; material icon named "directions boat" (round).
  static const IconData directions_boat_rounded = IconData(0xf6af, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions_boat</i> &#x2014; material icon named "directions boat" (outlined).
  static const IconData directions_boat_outlined = IconData(0xefc2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_boat_filled</i> &#x2014; material icon named "directions boat filled".
  static const IconData directions_boat_filled = IconData(0xe1d4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions_boat_filled</i> &#x2014; material icon named "directions boat filled" (sharp).
  static const IconData directions_boat_filled_sharp = IconData(0xe8cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions_boat_filled</i> &#x2014; material icon named "directions boat filled" (round).
  static const IconData directions_boat_filled_rounded = IconData(0xf6ae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions_boat_filled</i> &#x2014; material icon named "directions boat filled" (outlined).
  static const IconData directions_boat_filled_outlined = IconData(0xefc1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_bus</i> &#x2014; material icon named "directions bus".
  static const IconData directions_bus = IconData(0xe1d5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions_bus</i> &#x2014; material icon named "directions bus" (sharp).
  static const IconData directions_bus_sharp = IconData(0xe8d2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions_bus</i> &#x2014; material icon named "directions bus" (round).
  static const IconData directions_bus_rounded = IconData(0xf6b1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions_bus</i> &#x2014; material icon named "directions bus" (outlined).
  static const IconData directions_bus_outlined = IconData(0xefc4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_bus_filled</i> &#x2014; material icon named "directions bus filled".
  static const IconData directions_bus_filled = IconData(0xe1d6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions_bus_filled</i> &#x2014; material icon named "directions bus filled" (sharp).
  static const IconData directions_bus_filled_sharp = IconData(0xe8d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions_bus_filled</i> &#x2014; material icon named "directions bus filled" (round).
  static const IconData directions_bus_filled_rounded = IconData(0xf6b0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions_bus_filled</i> &#x2014; material icon named "directions bus filled" (outlined).
  static const IconData directions_bus_filled_outlined = IconData(0xefc3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_car</i> &#x2014; material icon named "directions car".
  static const IconData directions_car = IconData(0xe1d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions_car</i> &#x2014; material icon named "directions car" (sharp).
  static const IconData directions_car_sharp = IconData(0xe8d4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions_car</i> &#x2014; material icon named "directions car" (round).
  static const IconData directions_car_rounded = IconData(0xf6b3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions_car</i> &#x2014; material icon named "directions car" (outlined).
  static const IconData directions_car_outlined = IconData(0xefc6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_car_filled</i> &#x2014; material icon named "directions car filled".
  static const IconData directions_car_filled = IconData(0xe1d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions_car_filled</i> &#x2014; material icon named "directions car filled" (sharp).
  static const IconData directions_car_filled_sharp = IconData(0xe8d3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions_car_filled</i> &#x2014; material icon named "directions car filled" (round).
  static const IconData directions_car_filled_rounded = IconData(0xf6b2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions_car_filled</i> &#x2014; material icon named "directions car filled" (outlined).
  static const IconData directions_car_filled_outlined = IconData(0xefc5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_ferry</i> &#x2014; material icon named "directions ferry".
  static const IconData directions_ferry = IconData(0xe1d3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions_ferry</i> &#x2014; material icon named "directions ferry" (sharp).
  static const IconData directions_ferry_sharp = IconData(0xe8d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions_ferry</i> &#x2014; material icon named "directions ferry" (round).
  static const IconData directions_ferry_rounded = IconData(0xf6af, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions_ferry</i> &#x2014; material icon named "directions ferry" (outlined).
  static const IconData directions_ferry_outlined = IconData(0xefc2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_off</i> &#x2014; material icon named "directions off".
  static const IconData directions_off = IconData(0xe1d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions_off</i> &#x2014; material icon named "directions off" (sharp).
  static const IconData directions_off_sharp = IconData(0xe8d5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions_off</i> &#x2014; material icon named "directions off" (round).
  static const IconData directions_off_rounded = IconData(0xf6b4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions_off</i> &#x2014; material icon named "directions off" (outlined).
  static const IconData directions_off_outlined = IconData(0xefc7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_railway</i> &#x2014; material icon named "directions railway".
  static const IconData directions_railway = IconData(0xe1da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions_railway</i> &#x2014; material icon named "directions railway" (sharp).
  static const IconData directions_railway_sharp = IconData(0xe8d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions_railway</i> &#x2014; material icon named "directions railway" (round).
  static const IconData directions_railway_rounded = IconData(0xf6b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions_railway</i> &#x2014; material icon named "directions railway" (outlined).
  static const IconData directions_railway_outlined = IconData(0xefca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_railway_filled</i> &#x2014; material icon named "directions railway filled".
  static const IconData directions_railway_filled = IconData(0xe1db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions_railway_filled</i> &#x2014; material icon named "directions railway filled" (sharp).
  static const IconData directions_railway_filled_sharp = IconData(0xe8d6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions_railway_filled</i> &#x2014; material icon named "directions railway filled" (round).
  static const IconData directions_railway_filled_rounded = IconData(0xf6b5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions_railway_filled</i> &#x2014; material icon named "directions railway filled" (outlined).
  static const IconData directions_railway_filled_outlined = IconData(0xefc9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_run</i> &#x2014; material icon named "directions run".
  static const IconData directions_run = IconData(0xe1dc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions_run</i> &#x2014; material icon named "directions run" (sharp).
  static const IconData directions_run_sharp = IconData(0xe8d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions_run</i> &#x2014; material icon named "directions run" (round).
  static const IconData directions_run_rounded = IconData(0xf6b8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions_run</i> &#x2014; material icon named "directions run" (outlined).
  static const IconData directions_run_outlined = IconData(0xefcb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_subway</i> &#x2014; material icon named "directions subway".
  static const IconData directions_subway = IconData(0xe1dd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions_subway</i> &#x2014; material icon named "directions subway" (sharp).
  static const IconData directions_subway_sharp = IconData(0xe8db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions_subway</i> &#x2014; material icon named "directions subway" (round).
  static const IconData directions_subway_rounded = IconData(0xf6ba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions_subway</i> &#x2014; material icon named "directions subway" (outlined).
  static const IconData directions_subway_outlined = IconData(0xefcd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_subway_filled</i> &#x2014; material icon named "directions subway filled".
  static const IconData directions_subway_filled = IconData(0xe1de, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions_subway_filled</i> &#x2014; material icon named "directions subway filled" (sharp).
  static const IconData directions_subway_filled_sharp = IconData(0xe8da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions_subway_filled</i> &#x2014; material icon named "directions subway filled" (round).
  static const IconData directions_subway_filled_rounded = IconData(0xf6b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions_subway_filled</i> &#x2014; material icon named "directions subway filled" (outlined).
  static const IconData directions_subway_filled_outlined = IconData(0xefcc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_train</i> &#x2014; material icon named "directions train".
  static const IconData directions_train = IconData(0xe1da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions_train</i> &#x2014; material icon named "directions train" (sharp).
  static const IconData directions_train_sharp = IconData(0xe8d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions_train</i> &#x2014; material icon named "directions train" (round).
  static const IconData directions_train_rounded = IconData(0xf6b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions_train</i> &#x2014; material icon named "directions train" (outlined).
  static const IconData directions_train_outlined = IconData(0xefca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_transit</i> &#x2014; material icon named "directions transit".
  static const IconData directions_transit = IconData(0xe1df, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions_transit</i> &#x2014; material icon named "directions transit" (sharp).
  static const IconData directions_transit_sharp = IconData(0xe8dd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions_transit</i> &#x2014; material icon named "directions transit" (round).
  static const IconData directions_transit_rounded = IconData(0xf6bc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions_transit</i> &#x2014; material icon named "directions transit" (outlined).
  static const IconData directions_transit_outlined = IconData(0xefcf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_transit_filled</i> &#x2014; material icon named "directions transit filled".
  static const IconData directions_transit_filled = IconData(0xe1e0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions_transit_filled</i> &#x2014; material icon named "directions transit filled" (sharp).
  static const IconData directions_transit_filled_sharp = IconData(0xe8dc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions_transit_filled</i> &#x2014; material icon named "directions transit filled" (round).
  static const IconData directions_transit_filled_rounded = IconData(0xf6bb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions_transit_filled</i> &#x2014; material icon named "directions transit filled" (outlined).
  static const IconData directions_transit_filled_outlined = IconData(0xefce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">directions_walk</i> &#x2014; material icon named "directions walk".
  static const IconData directions_walk = IconData(0xe1e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">directions_walk</i> &#x2014; material icon named "directions walk" (sharp).
  static const IconData directions_walk_sharp = IconData(0xe8de, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">directions_walk</i> &#x2014; material icon named "directions walk" (round).
  static const IconData directions_walk_rounded = IconData(0xf6bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">directions_walk</i> &#x2014; material icon named "directions walk" (outlined).
  static const IconData directions_walk_outlined = IconData(0xefd0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dirty_lens</i> &#x2014; material icon named "dirty lens".
  static const IconData dirty_lens = IconData(0xe1e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">dirty_lens</i> &#x2014; material icon named "dirty lens" (sharp).
  static const IconData dirty_lens_sharp = IconData(0xe8df, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">dirty_lens</i> &#x2014; material icon named "dirty lens" (round).
  static const IconData dirty_lens_rounded = IconData(0xf6be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">dirty_lens</i> &#x2014; material icon named "dirty lens" (outlined).
  static const IconData dirty_lens_outlined = IconData(0xefd1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">disabled_by_default</i> &#x2014; material icon named "disabled by default".
  static const IconData disabled_by_default = IconData(0xe1e3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">disabled_by_default</i> &#x2014; material icon named "disabled by default" (sharp).
  static const IconData disabled_by_default_sharp = IconData(0xe8e0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">disabled_by_default</i> &#x2014; material icon named "disabled by default" (round).
  static const IconData disabled_by_default_rounded = IconData(0xf6bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">disabled_by_default</i> &#x2014; material icon named "disabled by default" (outlined).
  static const IconData disabled_by_default_outlined = IconData(0xefd2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">disc_full</i> &#x2014; material icon named "disc full".
  static const IconData disc_full = IconData(0xe1e4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">disc_full</i> &#x2014; material icon named "disc full" (sharp).
  static const IconData disc_full_sharp = IconData(0xe8e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">disc_full</i> &#x2014; material icon named "disc full" (round).
  static const IconData disc_full_rounded = IconData(0xf6c0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">disc_full</i> &#x2014; material icon named "disc full" (outlined).
  static const IconData disc_full_outlined = IconData(0xefd3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dnd_forwardslash</i> &#x2014; material icon named "dnd forwardslash".
  static const IconData dnd_forwardslash = IconData(0xe1eb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">dnd_forwardslash</i> &#x2014; material icon named "dnd forwardslash" (sharp).
  static const IconData dnd_forwardslash_sharp = IconData(0xe8e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">dnd_forwardslash</i> &#x2014; material icon named "dnd forwardslash" (round).
  static const IconData dnd_forwardslash_rounded = IconData(0xf6c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">dnd_forwardslash</i> &#x2014; material icon named "dnd forwardslash" (outlined).
  static const IconData dnd_forwardslash_outlined = IconData(0xefd9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dns</i> &#x2014; material icon named "dns".
  static const IconData dns = IconData(0xe1e5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">dns</i> &#x2014; material icon named "dns" (sharp).
  static const IconData dns_sharp = IconData(0xe8e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">dns</i> &#x2014; material icon named "dns" (round).
  static const IconData dns_rounded = IconData(0xf6c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">dns</i> &#x2014; material icon named "dns" (outlined).
  static const IconData dns_outlined = IconData(0xefd4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">do_disturb</i> &#x2014; material icon named "do disturb".
  static const IconData do_disturb = IconData(0xe1e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">do_disturb</i> &#x2014; material icon named "do disturb" (sharp).
  static const IconData do_disturb_sharp = IconData(0xe8e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">do_disturb</i> &#x2014; material icon named "do disturb" (round).
  static const IconData do_disturb_rounded = IconData(0xf6c5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">do_disturb</i> &#x2014; material icon named "do disturb" (outlined).
  static const IconData do_disturb_outlined = IconData(0xefd8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">do_disturb_alt</i> &#x2014; material icon named "do disturb alt".
  static const IconData do_disturb_alt = IconData(0xe1e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">do_disturb_alt</i> &#x2014; material icon named "do disturb alt" (sharp).
  static const IconData do_disturb_alt_sharp = IconData(0xe8e3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">do_disturb_alt</i> &#x2014; material icon named "do disturb alt" (round).
  static const IconData do_disturb_alt_rounded = IconData(0xf6c2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">do_disturb_alt</i> &#x2014; material icon named "do disturb alt" (outlined).
  static const IconData do_disturb_alt_outlined = IconData(0xefd5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">do_disturb_off</i> &#x2014; material icon named "do disturb off".
  static const IconData do_disturb_off = IconData(0xe1e8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">do_disturb_off</i> &#x2014; material icon named "do disturb off" (sharp).
  static const IconData do_disturb_off_sharp = IconData(0xe8e4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">do_disturb_off</i> &#x2014; material icon named "do disturb off" (round).
  static const IconData do_disturb_off_rounded = IconData(0xf6c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">do_disturb_off</i> &#x2014; material icon named "do disturb off" (outlined).
  static const IconData do_disturb_off_outlined = IconData(0xefd6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">do_disturb_on</i> &#x2014; material icon named "do disturb on".
  static const IconData do_disturb_on = IconData(0xe1e9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">do_disturb_on</i> &#x2014; material icon named "do disturb on" (sharp).
  static const IconData do_disturb_on_sharp = IconData(0xe8e5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">do_disturb_on</i> &#x2014; material icon named "do disturb on" (round).
  static const IconData do_disturb_on_rounded = IconData(0xf6c4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">do_disturb_on</i> &#x2014; material icon named "do disturb on" (outlined).
  static const IconData do_disturb_on_outlined = IconData(0xefd7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">do_not_disturb</i> &#x2014; material icon named "do not disturb".
  static const IconData do_not_disturb = IconData(0xe1ea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">do_not_disturb</i> &#x2014; material icon named "do not disturb" (sharp).
  static const IconData do_not_disturb_sharp = IconData(0xe8eb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">do_not_disturb</i> &#x2014; material icon named "do not disturb" (round).
  static const IconData do_not_disturb_rounded = IconData(0xf6ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">do_not_disturb</i> &#x2014; material icon named "do not disturb" (outlined).
  static const IconData do_not_disturb_outlined = IconData(0xefdd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">do_not_disturb_alt</i> &#x2014; material icon named "do not disturb alt".
  static const IconData do_not_disturb_alt = IconData(0xe1eb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">do_not_disturb_alt</i> &#x2014; material icon named "do not disturb alt" (sharp).
  static const IconData do_not_disturb_alt_sharp = IconData(0xe8e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">do_not_disturb_alt</i> &#x2014; material icon named "do not disturb alt" (round).
  static const IconData do_not_disturb_alt_rounded = IconData(0xf6c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">do_not_disturb_alt</i> &#x2014; material icon named "do not disturb alt" (outlined).
  static const IconData do_not_disturb_alt_outlined = IconData(0xefd9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">do_not_disturb_off</i> &#x2014; material icon named "do not disturb off".
  static const IconData do_not_disturb_off = IconData(0xe1ec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">do_not_disturb_off</i> &#x2014; material icon named "do not disturb off" (sharp).
  static const IconData do_not_disturb_off_sharp = IconData(0xe8e8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">do_not_disturb_off</i> &#x2014; material icon named "do not disturb off" (round).
  static const IconData do_not_disturb_off_rounded = IconData(0xf6c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">do_not_disturb_off</i> &#x2014; material icon named "do not disturb off" (outlined).
  static const IconData do_not_disturb_off_outlined = IconData(0xefda, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">do_not_disturb_on</i> &#x2014; material icon named "do not disturb on".
  static const IconData do_not_disturb_on = IconData(0xe1ed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">do_not_disturb_on</i> &#x2014; material icon named "do not disturb on" (sharp).
  static const IconData do_not_disturb_on_sharp = IconData(0xe8e9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">do_not_disturb_on</i> &#x2014; material icon named "do not disturb on" (round).
  static const IconData do_not_disturb_on_rounded = IconData(0xf6c8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">do_not_disturb_on</i> &#x2014; material icon named "do not disturb on" (outlined).
  static const IconData do_not_disturb_on_outlined = IconData(0xefdb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">do_not_disturb_on_total_silence</i> &#x2014; material icon named "do not disturb on total silence".
  static const IconData do_not_disturb_on_total_silence = IconData(0xe1ee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">do_not_disturb_on_total_silence</i> &#x2014; material icon named "do not disturb on total silence" (sharp).
  static const IconData do_not_disturb_on_total_silence_sharp = IconData(0xe8ea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">do_not_disturb_on_total_silence</i> &#x2014; material icon named "do not disturb on total silence" (round).
  static const IconData do_not_disturb_on_total_silence_rounded = IconData(0xf6c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">do_not_disturb_on_total_silence</i> &#x2014; material icon named "do not disturb on total silence" (outlined).
  static const IconData do_not_disturb_on_total_silence_outlined = IconData(0xefdc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">do_not_step</i> &#x2014; material icon named "do not step".
  static const IconData do_not_step = IconData(0xe1ef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">do_not_step</i> &#x2014; material icon named "do not step" (sharp).
  static const IconData do_not_step_sharp = IconData(0xe8ec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">do_not_step</i> &#x2014; material icon named "do not step" (round).
  static const IconData do_not_step_rounded = IconData(0xf6cb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">do_not_step</i> &#x2014; material icon named "do not step" (outlined).
  static const IconData do_not_step_outlined = IconData(0xefde, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">do_not_touch</i> &#x2014; material icon named "do not touch".
  static const IconData do_not_touch = IconData(0xe1f0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">do_not_touch</i> &#x2014; material icon named "do not touch" (sharp).
  static const IconData do_not_touch_sharp = IconData(0xe8ed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">do_not_touch</i> &#x2014; material icon named "do not touch" (round).
  static const IconData do_not_touch_rounded = IconData(0xf6cc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">do_not_touch</i> &#x2014; material icon named "do not touch" (outlined).
  static const IconData do_not_touch_outlined = IconData(0xefdf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dock</i> &#x2014; material icon named "dock".
  static const IconData dock = IconData(0xe1f1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">dock</i> &#x2014; material icon named "dock" (sharp).
  static const IconData dock_sharp = IconData(0xe8ee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">dock</i> &#x2014; material icon named "dock" (round).
  static const IconData dock_rounded = IconData(0xf6cd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">dock</i> &#x2014; material icon named "dock" (outlined).
  static const IconData dock_outlined = IconData(0xefe0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">document_scanner</i> &#x2014; material icon named "document scanner".
  static const IconData document_scanner = IconData(0xe1f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">document_scanner</i> &#x2014; material icon named "document scanner" (sharp).
  static const IconData document_scanner_sharp = IconData(0xe8ef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">document_scanner</i> &#x2014; material icon named "document scanner" (round).
  static const IconData document_scanner_rounded = IconData(0xf6ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">document_scanner</i> &#x2014; material icon named "document scanner" (outlined).
  static const IconData document_scanner_outlined = IconData(0xefe1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">domain</i> &#x2014; material icon named "domain".
  static const IconData domain = IconData(0xe1f3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">domain</i> &#x2014; material icon named "domain" (sharp).
  static const IconData domain_sharp = IconData(0xe8f1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">domain</i> &#x2014; material icon named "domain" (round).
  static const IconData domain_rounded = IconData(0xf6d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">domain</i> &#x2014; material icon named "domain" (outlined).
  static const IconData domain_outlined = IconData(0xefe3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">domain_disabled</i> &#x2014; material icon named "domain disabled".
  static const IconData domain_disabled = IconData(0xe1f4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">domain_disabled</i> &#x2014; material icon named "domain disabled" (sharp).
  static const IconData domain_disabled_sharp = IconData(0xe8f0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">domain_disabled</i> &#x2014; material icon named "domain disabled" (round).
  static const IconData domain_disabled_rounded = IconData(0xf6cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">domain_disabled</i> &#x2014; material icon named "domain disabled" (outlined).
  static const IconData domain_disabled_outlined = IconData(0xefe2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">domain_verification</i> &#x2014; material icon named "domain verification".
  static const IconData domain_verification = IconData(0xe1f5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">domain_verification</i> &#x2014; material icon named "domain verification" (sharp).
  static const IconData domain_verification_sharp = IconData(0xe8f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">domain_verification</i> &#x2014; material icon named "domain verification" (round).
  static const IconData domain_verification_rounded = IconData(0xf6d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">domain_verification</i> &#x2014; material icon named "domain verification" (outlined).
  static const IconData domain_verification_outlined = IconData(0xefe4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">done</i> &#x2014; material icon named "done".
  static const IconData done = IconData(0xe1f6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">done</i> &#x2014; material icon named "done" (sharp).
  static const IconData done_sharp = IconData(0xe8f5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">done</i> &#x2014; material icon named "done" (round).
  static const IconData done_rounded = IconData(0xf6d4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">done</i> &#x2014; material icon named "done" (outlined).
  static const IconData done_outlined = IconData(0xefe7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">done_all</i> &#x2014; material icon named "done all".
  static const IconData done_all = IconData(0xe1f7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">done_all</i> &#x2014; material icon named "done all" (sharp).
  static const IconData done_all_sharp = IconData(0xe8f3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">done_all</i> &#x2014; material icon named "done all" (round).
  static const IconData done_all_rounded = IconData(0xf6d2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">done_all</i> &#x2014; material icon named "done all" (outlined).
  static const IconData done_all_outlined = IconData(0xefe5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">done_outline</i> &#x2014; material icon named "done outline".
  static const IconData done_outline = IconData(0xe1f8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">done_outline</i> &#x2014; material icon named "done outline" (sharp).
  static const IconData done_outline_sharp = IconData(0xe8f4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">done_outline</i> &#x2014; material icon named "done outline" (round).
  static const IconData done_outline_rounded = IconData(0xf6d3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">done_outline</i> &#x2014; material icon named "done outline" (outlined).
  static const IconData done_outline_outlined = IconData(0xefe6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">donut_large</i> &#x2014; material icon named "donut large".
  static const IconData donut_large = IconData(0xe1f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">donut_large</i> &#x2014; material icon named "donut large" (sharp).
  static const IconData donut_large_sharp = IconData(0xe8f6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">donut_large</i> &#x2014; material icon named "donut large" (round).
  static const IconData donut_large_rounded = IconData(0xf6d5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">donut_large</i> &#x2014; material icon named "donut large" (outlined).
  static const IconData donut_large_outlined = IconData(0xefe8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">donut_small</i> &#x2014; material icon named "donut small".
  static const IconData donut_small = IconData(0xe1fa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">donut_small</i> &#x2014; material icon named "donut small" (sharp).
  static const IconData donut_small_sharp = IconData(0xe8f7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">donut_small</i> &#x2014; material icon named "donut small" (round).
  static const IconData donut_small_rounded = IconData(0xf6d6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">donut_small</i> &#x2014; material icon named "donut small" (outlined).
  static const IconData donut_small_outlined = IconData(0xefe9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">door_back</i> &#x2014; material icon named "door back".
  static const IconData door_back_door = IconData(0xe1fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">door_back</i> &#x2014; material icon named "door back" (sharp).
  static const IconData door_back_door_sharp = IconData(0xe8f8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">door_back</i> &#x2014; material icon named "door back" (round).
  static const IconData door_back_door_rounded = IconData(0xf6d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">door_back</i> &#x2014; material icon named "door back" (outlined).
  static const IconData door_back_door_outlined = IconData(0xefea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">door_front</i> &#x2014; material icon named "door front".
  static const IconData door_front_door = IconData(0xe1fc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">door_front</i> &#x2014; material icon named "door front" (sharp).
  static const IconData door_front_door_sharp = IconData(0xe8f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">door_front</i> &#x2014; material icon named "door front" (round).
  static const IconData door_front_door_rounded = IconData(0xf6d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">door_front</i> &#x2014; material icon named "door front" (outlined).
  static const IconData door_front_door_outlined = IconData(0xefeb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">door_sliding</i> &#x2014; material icon named "door sliding".
  static const IconData door_sliding = IconData(0xe1fd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">door_sliding</i> &#x2014; material icon named "door sliding" (sharp).
  static const IconData door_sliding_sharp = IconData(0xe8fa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">door_sliding</i> &#x2014; material icon named "door sliding" (round).
  static const IconData door_sliding_rounded = IconData(0xf6d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">door_sliding</i> &#x2014; material icon named "door sliding" (outlined).
  static const IconData door_sliding_outlined = IconData(0xefec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">doorbell</i> &#x2014; material icon named "doorbell".
  static const IconData doorbell = IconData(0xe1fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">doorbell</i> &#x2014; material icon named "doorbell" (sharp).
  static const IconData doorbell_sharp = IconData(0xe8fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">doorbell</i> &#x2014; material icon named "doorbell" (round).
  static const IconData doorbell_rounded = IconData(0xf6da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">doorbell</i> &#x2014; material icon named "doorbell" (outlined).
  static const IconData doorbell_outlined = IconData(0xefed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">double_arrow</i> &#x2014; material icon named "double arrow".
  static const IconData double_arrow = IconData(0xe1ff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">double_arrow</i> &#x2014; material icon named "double arrow" (sharp).
  static const IconData double_arrow_sharp = IconData(0xe8fc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">double_arrow</i> &#x2014; material icon named "double arrow" (round).
  static const IconData double_arrow_rounded = IconData(0xf6db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">double_arrow</i> &#x2014; material icon named "double arrow" (outlined).
  static const IconData double_arrow_outlined = IconData(0xefee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">downhill_skiing</i> &#x2014; material icon named "downhill skiing".
  static const IconData downhill_skiing = IconData(0xe200, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">downhill_skiing</i> &#x2014; material icon named "downhill skiing" (sharp).
  static const IconData downhill_skiing_sharp = IconData(0xe8fd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">downhill_skiing</i> &#x2014; material icon named "downhill skiing" (round).
  static const IconData downhill_skiing_rounded = IconData(0xf6dc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">downhill_skiing</i> &#x2014; material icon named "downhill skiing" (outlined).
  static const IconData downhill_skiing_outlined = IconData(0xefef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">download</i> &#x2014; material icon named "download".
  static const IconData download = IconData(0xe201, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">download</i> &#x2014; material icon named "download" (sharp).
  static const IconData download_sharp = IconData(0xe900, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">download</i> &#x2014; material icon named "download" (round).
  static const IconData download_rounded = IconData(0xf6df, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">download</i> &#x2014; material icon named "download" (outlined).
  static const IconData download_outlined = IconData(0xeff2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">download_done</i> &#x2014; material icon named "download done".
  static const IconData download_done = IconData(0xe202, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">download_done</i> &#x2014; material icon named "download done" (sharp).
  static const IconData download_done_sharp = IconData(0xe8fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">download_done</i> &#x2014; material icon named "download done" (round).
  static const IconData download_done_rounded = IconData(0xf6dd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">download_done</i> &#x2014; material icon named "download done" (outlined).
  static const IconData download_done_outlined = IconData(0xeff0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">download_for_offline</i> &#x2014; material icon named "download for offline".
  static const IconData download_for_offline = IconData(0xe203, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">download_for_offline</i> &#x2014; material icon named "download for offline" (sharp).
  static const IconData download_for_offline_sharp = IconData(0xe8ff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">download_for_offline</i> &#x2014; material icon named "download for offline" (round).
  static const IconData download_for_offline_rounded = IconData(0xf6de, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">download_for_offline</i> &#x2014; material icon named "download for offline" (outlined).
  static const IconData download_for_offline_outlined = IconData(0xeff1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">downloading</i> &#x2014; material icon named "downloading".
  static const IconData downloading = IconData(0xe204, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">downloading</i> &#x2014; material icon named "downloading" (sharp).
  static const IconData downloading_sharp = IconData(0xe901, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">downloading</i> &#x2014; material icon named "downloading" (round).
  static const IconData downloading_rounded = IconData(0xf6e0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">downloading</i> &#x2014; material icon named "downloading" (outlined).
  static const IconData downloading_outlined = IconData(0xeff3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">drafts</i> &#x2014; material icon named "drafts".
  static const IconData drafts = IconData(0xe205, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">drafts</i> &#x2014; material icon named "drafts" (sharp).
  static const IconData drafts_sharp = IconData(0xe902, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">drafts</i> &#x2014; material icon named "drafts" (round).
  static const IconData drafts_rounded = IconData(0xf6e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">drafts</i> &#x2014; material icon named "drafts" (outlined).
  static const IconData drafts_outlined = IconData(0xeff4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">drag_handle</i> &#x2014; material icon named "drag handle".
  static const IconData drag_handle = IconData(0xe206, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">drag_handle</i> &#x2014; material icon named "drag handle" (sharp).
  static const IconData drag_handle_sharp = IconData(0xe903, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">drag_handle</i> &#x2014; material icon named "drag handle" (round).
  static const IconData drag_handle_rounded = IconData(0xf6e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">drag_handle</i> &#x2014; material icon named "drag handle" (outlined).
  static const IconData drag_handle_outlined = IconData(0xeff5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">drag_indicator</i> &#x2014; material icon named "drag indicator".
  static const IconData drag_indicator = IconData(0xe207, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">drag_indicator</i> &#x2014; material icon named "drag indicator" (sharp).
  static const IconData drag_indicator_sharp = IconData(0xe904, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">drag_indicator</i> &#x2014; material icon named "drag indicator" (round).
  static const IconData drag_indicator_rounded = IconData(0xf6e3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">drag_indicator</i> &#x2014; material icon named "drag indicator" (outlined).
  static const IconData drag_indicator_outlined = IconData(0xeff6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">drive_eta</i> &#x2014; material icon named "drive eta".
  static const IconData drive_eta = IconData(0xe208, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">drive_eta</i> &#x2014; material icon named "drive eta" (sharp).
  static const IconData drive_eta_sharp = IconData(0xe905, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">drive_eta</i> &#x2014; material icon named "drive eta" (round).
  static const IconData drive_eta_rounded = IconData(0xf6e4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">drive_eta</i> &#x2014; material icon named "drive eta" (outlined).
  static const IconData drive_eta_outlined = IconData(0xeff7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">drive_file_move</i> &#x2014; material icon named "drive file move".
  static const IconData drive_file_move = IconData(0xe209, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">drive_file_move</i> &#x2014; material icon named "drive file move" (sharp).
  static const IconData drive_file_move_sharp = IconData(0xe906, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">drive_file_move</i> &#x2014; material icon named "drive file move" (round).
  static const IconData drive_file_move_rounded = IconData(0xf6e5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">drive_file_move</i> &#x2014; material icon named "drive file move" (outlined).
  static const IconData drive_file_move_outlined = IconData(0xeff8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">drive_file_move_outline</i> &#x2014; material icon named "drive file move outline".
  static const IconData drive_file_move_outline = IconData(0xe20a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">drive_file_rename_outline</i> &#x2014; material icon named "drive file rename outline".
  static const IconData drive_file_rename_outline = IconData(0xe20b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">drive_file_rename_outline</i> &#x2014; material icon named "drive file rename outline" (sharp).
  static const IconData drive_file_rename_outline_sharp = IconData(0xe907, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">drive_file_rename_outline</i> &#x2014; material icon named "drive file rename outline" (round).
  static const IconData drive_file_rename_outline_rounded = IconData(0xf6e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">drive_file_rename_outline</i> &#x2014; material icon named "drive file rename outline" (outlined).
  static const IconData drive_file_rename_outline_outlined = IconData(0xeff9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">drive_folder_upload</i> &#x2014; material icon named "drive folder upload".
  static const IconData drive_folder_upload = IconData(0xe20c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">drive_folder_upload</i> &#x2014; material icon named "drive folder upload" (sharp).
  static const IconData drive_folder_upload_sharp = IconData(0xe908, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">drive_folder_upload</i> &#x2014; material icon named "drive folder upload" (round).
  static const IconData drive_folder_upload_rounded = IconData(0xf6e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">drive_folder_upload</i> &#x2014; material icon named "drive folder upload" (outlined).
  static const IconData drive_folder_upload_outlined = IconData(0xeffa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dry</i> &#x2014; material icon named "dry".
  static const IconData dry = IconData(0xe20d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">dry</i> &#x2014; material icon named "dry" (sharp).
  static const IconData dry_sharp = IconData(0xe90a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">dry</i> &#x2014; material icon named "dry" (round).
  static const IconData dry_rounded = IconData(0xf6e9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">dry</i> &#x2014; material icon named "dry" (outlined).
  static const IconData dry_outlined = IconData(0xeffc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dry_cleaning</i> &#x2014; material icon named "dry cleaning".
  static const IconData dry_cleaning = IconData(0xe20e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">dry_cleaning</i> &#x2014; material icon named "dry cleaning" (sharp).
  static const IconData dry_cleaning_sharp = IconData(0xe909, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">dry_cleaning</i> &#x2014; material icon named "dry cleaning" (round).
  static const IconData dry_cleaning_rounded = IconData(0xf6e8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">dry_cleaning</i> &#x2014; material icon named "dry cleaning" (outlined).
  static const IconData dry_cleaning_outlined = IconData(0xeffb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">duo</i> &#x2014; material icon named "duo".
  static const IconData duo = IconData(0xe20f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">duo</i> &#x2014; material icon named "duo" (sharp).
  static const IconData duo_sharp = IconData(0xe90b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">duo</i> &#x2014; material icon named "duo" (round).
  static const IconData duo_rounded = IconData(0xf6ea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">duo</i> &#x2014; material icon named "duo" (outlined).
  static const IconData duo_outlined = IconData(0xeffd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dvr</i> &#x2014; material icon named "dvr".
  static const IconData dvr = IconData(0xe210, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">dvr</i> &#x2014; material icon named "dvr" (sharp).
  static const IconData dvr_sharp = IconData(0xe90c, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">dvr</i> &#x2014; material icon named "dvr" (round).
  static const IconData dvr_rounded = IconData(0xf6eb, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">dvr</i> &#x2014; material icon named "dvr" (outlined).
  static const IconData dvr_outlined = IconData(0xeffe, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">dynamic_feed</i> &#x2014; material icon named "dynamic feed".
  static const IconData dynamic_feed = IconData(0xe211, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">dynamic_feed</i> &#x2014; material icon named "dynamic feed" (sharp).
  static const IconData dynamic_feed_sharp = IconData(0xe90d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">dynamic_feed</i> &#x2014; material icon named "dynamic feed" (round).
  static const IconData dynamic_feed_rounded = IconData(0xf6ec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">dynamic_feed</i> &#x2014; material icon named "dynamic feed" (outlined).
  static const IconData dynamic_feed_outlined = IconData(0xefff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">dynamic_form</i> &#x2014; material icon named "dynamic form".
  static const IconData dynamic_form = IconData(0xe212, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">dynamic_form</i> &#x2014; material icon named "dynamic form" (sharp).
  static const IconData dynamic_form_sharp = IconData(0xe90e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">dynamic_form</i> &#x2014; material icon named "dynamic form" (round).
  static const IconData dynamic_form_rounded = IconData(0xf6ed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">dynamic_form</i> &#x2014; material icon named "dynamic form" (outlined).
  static const IconData dynamic_form_outlined = IconData(0xf000, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">e_mobiledata</i> &#x2014; material icon named "e mobiledata".
  static const IconData e_mobiledata = IconData(0xe213, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">e_mobiledata</i> &#x2014; material icon named "e mobiledata" (sharp).
  static const IconData e_mobiledata_sharp = IconData(0xe90f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">e_mobiledata</i> &#x2014; material icon named "e mobiledata" (round).
  static const IconData e_mobiledata_rounded = IconData(0xf6ee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">e_mobiledata</i> &#x2014; material icon named "e mobiledata" (outlined).
  static const IconData e_mobiledata_outlined = IconData(0xf001, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">earbuds</i> &#x2014; material icon named "earbuds".
  static const IconData earbuds = IconData(0xe214, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">earbuds</i> &#x2014; material icon named "earbuds" (sharp).
  static const IconData earbuds_sharp = IconData(0xe911, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">earbuds</i> &#x2014; material icon named "earbuds" (round).
  static const IconData earbuds_rounded = IconData(0xf6f0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">earbuds</i> &#x2014; material icon named "earbuds" (outlined).
  static const IconData earbuds_outlined = IconData(0xf003, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">earbuds_battery</i> &#x2014; material icon named "earbuds battery".
  static const IconData earbuds_battery = IconData(0xe215, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">earbuds_battery</i> &#x2014; material icon named "earbuds battery" (sharp).
  static const IconData earbuds_battery_sharp = IconData(0xe910, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">earbuds_battery</i> &#x2014; material icon named "earbuds battery" (round).
  static const IconData earbuds_battery_rounded = IconData(0xf6ef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">earbuds_battery</i> &#x2014; material icon named "earbuds battery" (outlined).
  static const IconData earbuds_battery_outlined = IconData(0xf002, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">east</i> &#x2014; material icon named "east".
  static const IconData east = IconData(0xe216, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">east</i> &#x2014; material icon named "east" (sharp).
  static const IconData east_sharp = IconData(0xe912, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">east</i> &#x2014; material icon named "east" (round).
  static const IconData east_rounded = IconData(0xf6f1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">east</i> &#x2014; material icon named "east" (outlined).
  static const IconData east_outlined = IconData(0xf004, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">eco</i> &#x2014; material icon named "eco".
  static const IconData eco = IconData(0xe217, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">eco</i> &#x2014; material icon named "eco" (sharp).
  static const IconData eco_sharp = IconData(0xe913, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">eco</i> &#x2014; material icon named "eco" (round).
  static const IconData eco_rounded = IconData(0xf6f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">eco</i> &#x2014; material icon named "eco" (outlined).
  static const IconData eco_outlined = IconData(0xf005, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">edgesensor_high</i> &#x2014; material icon named "edgesensor high".
  static const IconData edgesensor_high = IconData(0xe218, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">edgesensor_high</i> &#x2014; material icon named "edgesensor high" (sharp).
  static const IconData edgesensor_high_sharp = IconData(0xe914, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">edgesensor_high</i> &#x2014; material icon named "edgesensor high" (round).
  static const IconData edgesensor_high_rounded = IconData(0xf6f3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">edgesensor_high</i> &#x2014; material icon named "edgesensor high" (outlined).
  static const IconData edgesensor_high_outlined = IconData(0xf006, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">edgesensor_low</i> &#x2014; material icon named "edgesensor low".
  static const IconData edgesensor_low = IconData(0xe219, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">edgesensor_low</i> &#x2014; material icon named "edgesensor low" (sharp).
  static const IconData edgesensor_low_sharp = IconData(0xe915, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">edgesensor_low</i> &#x2014; material icon named "edgesensor low" (round).
  static const IconData edgesensor_low_rounded = IconData(0xf6f4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">edgesensor_low</i> &#x2014; material icon named "edgesensor low" (outlined).
  static const IconData edgesensor_low_outlined = IconData(0xf007, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">edit</i> &#x2014; material icon named "edit".
  static const IconData edit = IconData(0xe21a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">edit</i> &#x2014; material icon named "edit" (sharp).
  static const IconData edit_sharp = IconData(0xe91c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">edit</i> &#x2014; material icon named "edit" (round).
  static const IconData edit_rounded = IconData(0xf6fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">edit</i> &#x2014; material icon named "edit" (outlined).
  static const IconData edit_outlined = IconData(0xf00d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">edit_attributes</i> &#x2014; material icon named "edit attributes".
  static const IconData edit_attributes = IconData(0xe21b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">edit_attributes</i> &#x2014; material icon named "edit attributes" (sharp).
  static const IconData edit_attributes_sharp = IconData(0xe916, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">edit_attributes</i> &#x2014; material icon named "edit attributes" (round).
  static const IconData edit_attributes_rounded = IconData(0xf6f5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">edit_attributes</i> &#x2014; material icon named "edit attributes" (outlined).
  static const IconData edit_attributes_outlined = IconData(0xf008, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">edit_location</i> &#x2014; material icon named "edit location".
  static const IconData edit_location = IconData(0xe21c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">edit_location</i> &#x2014; material icon named "edit location" (sharp).
  static const IconData edit_location_sharp = IconData(0xe918, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">edit_location</i> &#x2014; material icon named "edit location" (round).
  static const IconData edit_location_rounded = IconData(0xf6f7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">edit_location</i> &#x2014; material icon named "edit location" (outlined).
  static const IconData edit_location_outlined = IconData(0xf00a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">edit_location_alt</i> &#x2014; material icon named "edit location alt".
  static const IconData edit_location_alt = IconData(0xe21d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">edit_location_alt</i> &#x2014; material icon named "edit location alt" (sharp).
  static const IconData edit_location_alt_sharp = IconData(0xe917, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">edit_location_alt</i> &#x2014; material icon named "edit location alt" (round).
  static const IconData edit_location_alt_rounded = IconData(0xf6f6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">edit_location_alt</i> &#x2014; material icon named "edit location alt" (outlined).
  static const IconData edit_location_alt_outlined = IconData(0xf009, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">edit_notifications</i> &#x2014; material icon named "edit notifications".
  static const IconData edit_notifications = IconData(0xe21e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">edit_notifications</i> &#x2014; material icon named "edit notifications" (sharp).
  static const IconData edit_notifications_sharp = IconData(0xe919, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">edit_notifications</i> &#x2014; material icon named "edit notifications" (round).
  static const IconData edit_notifications_rounded = IconData(0xf6f8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">edit_notifications</i> &#x2014; material icon named "edit notifications" (outlined).
  static const IconData edit_notifications_outlined = IconData(0xf00b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">edit_off</i> &#x2014; material icon named "edit off".
  static const IconData edit_off = IconData(0xe21f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">edit_off</i> &#x2014; material icon named "edit off" (sharp).
  static const IconData edit_off_sharp = IconData(0xe91a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">edit_off</i> &#x2014; material icon named "edit off" (round).
  static const IconData edit_off_rounded = IconData(0xf6f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">edit_off</i> &#x2014; material icon named "edit off" (outlined).
  static const IconData edit_off_outlined = IconData(0xf00c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">edit_road</i> &#x2014; material icon named "edit road".
  static const IconData edit_road = IconData(0xe220, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">edit_road</i> &#x2014; material icon named "edit road" (sharp).
  static const IconData edit_road_sharp = IconData(0xe91b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">edit_road</i> &#x2014; material icon named "edit road" (round).
  static const IconData edit_road_rounded = IconData(0xf6fa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">edit_road</i> &#x2014; material icon named "edit road" (outlined).
  static const IconData edit_road_outlined = IconData(0xf00e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">eject</i> &#x2014; material icon named "eject".
  static const IconData eject = IconData(0xe221, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">eject</i> &#x2014; material icon named "eject" (sharp).
  static const IconData eject_sharp = IconData(0xe91d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">eject</i> &#x2014; material icon named "eject" (round).
  static const IconData eject_rounded = IconData(0xf6fc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">eject</i> &#x2014; material icon named "eject" (outlined).
  static const IconData eject_outlined = IconData(0xf00f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">elderly</i> &#x2014; material icon named "elderly".
  static const IconData elderly = IconData(0xe222, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">elderly</i> &#x2014; material icon named "elderly" (sharp).
  static const IconData elderly_sharp = IconData(0xe91e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">elderly</i> &#x2014; material icon named "elderly" (round).
  static const IconData elderly_rounded = IconData(0xf6fd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">elderly</i> &#x2014; material icon named "elderly" (outlined).
  static const IconData elderly_outlined = IconData(0xf010, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">electric_bike</i> &#x2014; material icon named "electric bike".
  static const IconData electric_bike = IconData(0xe223, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">electric_bike</i> &#x2014; material icon named "electric bike" (sharp).
  static const IconData electric_bike_sharp = IconData(0xe91f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">electric_bike</i> &#x2014; material icon named "electric bike" (round).
  static const IconData electric_bike_rounded = IconData(0xf6fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">electric_bike</i> &#x2014; material icon named "electric bike" (outlined).
  static const IconData electric_bike_outlined = IconData(0xf011, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">electric_car</i> &#x2014; material icon named "electric car".
  static const IconData electric_car = IconData(0xe224, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">electric_car</i> &#x2014; material icon named "electric car" (sharp).
  static const IconData electric_car_sharp = IconData(0xe920, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">electric_car</i> &#x2014; material icon named "electric car" (round).
  static const IconData electric_car_rounded = IconData(0xf6ff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">electric_car</i> &#x2014; material icon named "electric car" (outlined).
  static const IconData electric_car_outlined = IconData(0xf012, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">electric_moped</i> &#x2014; material icon named "electric moped".
  static const IconData electric_moped = IconData(0xe225, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">electric_moped</i> &#x2014; material icon named "electric moped" (sharp).
  static const IconData electric_moped_sharp = IconData(0xe921, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">electric_moped</i> &#x2014; material icon named "electric moped" (round).
  static const IconData electric_moped_rounded = IconData(0xf700, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">electric_moped</i> &#x2014; material icon named "electric moped" (outlined).
  static const IconData electric_moped_outlined = IconData(0xf013, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">electric_rickshaw</i> &#x2014; material icon named "electric rickshaw".
  static const IconData electric_rickshaw = IconData(0xe226, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">electric_rickshaw</i> &#x2014; material icon named "electric rickshaw" (sharp).
  static const IconData electric_rickshaw_sharp = IconData(0xe922, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">electric_rickshaw</i> &#x2014; material icon named "electric rickshaw" (round).
  static const IconData electric_rickshaw_rounded = IconData(0xf701, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">electric_rickshaw</i> &#x2014; material icon named "electric rickshaw" (outlined).
  static const IconData electric_rickshaw_outlined = IconData(0xf014, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">electric_scooter</i> &#x2014; material icon named "electric scooter".
  static const IconData electric_scooter = IconData(0xe227, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">electric_scooter</i> &#x2014; material icon named "electric scooter" (sharp).
  static const IconData electric_scooter_sharp = IconData(0xe923, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">electric_scooter</i> &#x2014; material icon named "electric scooter" (round).
  static const IconData electric_scooter_rounded = IconData(0xf702, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">electric_scooter</i> &#x2014; material icon named "electric scooter" (outlined).
  static const IconData electric_scooter_outlined = IconData(0xf015, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">electrical_services</i> &#x2014; material icon named "electrical services".
  static const IconData electrical_services = IconData(0xe228, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">electrical_services</i> &#x2014; material icon named "electrical services" (sharp).
  static const IconData electrical_services_sharp = IconData(0xe924, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">electrical_services</i> &#x2014; material icon named "electrical services" (round).
  static const IconData electrical_services_rounded = IconData(0xf703, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">electrical_services</i> &#x2014; material icon named "electrical services" (outlined).
  static const IconData electrical_services_outlined = IconData(0xf016, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">elevator</i> &#x2014; material icon named "elevator".
  static const IconData elevator = IconData(0xe229, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">elevator</i> &#x2014; material icon named "elevator" (sharp).
  static const IconData elevator_sharp = IconData(0xe925, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">elevator</i> &#x2014; material icon named "elevator" (round).
  static const IconData elevator_rounded = IconData(0xf704, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">elevator</i> &#x2014; material icon named "elevator" (outlined).
  static const IconData elevator_outlined = IconData(0xf017, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">email</i> &#x2014; material icon named "email".
  static const IconData email = IconData(0xe22a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">email</i> &#x2014; material icon named "email" (sharp).
  static const IconData email_sharp = IconData(0xe926, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">email</i> &#x2014; material icon named "email" (round).
  static const IconData email_rounded = IconData(0xf705, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">email</i> &#x2014; material icon named "email" (outlined).
  static const IconData email_outlined = IconData(0xf018, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">emoji_emotions</i> &#x2014; material icon named "emoji emotions".
  static const IconData emoji_emotions = IconData(0xe22b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">emoji_emotions</i> &#x2014; material icon named "emoji emotions" (sharp).
  static const IconData emoji_emotions_sharp = IconData(0xe927, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">emoji_emotions</i> &#x2014; material icon named "emoji emotions" (round).
  static const IconData emoji_emotions_rounded = IconData(0xf706, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">emoji_emotions</i> &#x2014; material icon named "emoji emotions" (outlined).
  static const IconData emoji_emotions_outlined = IconData(0xf019, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">emoji_events</i> &#x2014; material icon named "emoji events".
  static const IconData emoji_events = IconData(0xe22c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">emoji_events</i> &#x2014; material icon named "emoji events" (sharp).
  static const IconData emoji_events_sharp = IconData(0xe928, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">emoji_events</i> &#x2014; material icon named "emoji events" (round).
  static const IconData emoji_events_rounded = IconData(0xf707, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">emoji_events</i> &#x2014; material icon named "emoji events" (outlined).
  static const IconData emoji_events_outlined = IconData(0xf01a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">emoji_flags</i> &#x2014; material icon named "emoji flags".
  static const IconData emoji_flags = IconData(0xe22d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">emoji_flags</i> &#x2014; material icon named "emoji flags" (sharp).
  static const IconData emoji_flags_sharp = IconData(0xe929, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">emoji_flags</i> &#x2014; material icon named "emoji flags" (round).
  static const IconData emoji_flags_rounded = IconData(0xf708, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">emoji_flags</i> &#x2014; material icon named "emoji flags" (outlined).
  static const IconData emoji_flags_outlined = IconData(0xf01b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">emoji_food_beverage</i> &#x2014; material icon named "emoji food beverage".
  static const IconData emoji_food_beverage = IconData(0xe22e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">emoji_food_beverage</i> &#x2014; material icon named "emoji food beverage" (sharp).
  static const IconData emoji_food_beverage_sharp = IconData(0xe92a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">emoji_food_beverage</i> &#x2014; material icon named "emoji food beverage" (round).
  static const IconData emoji_food_beverage_rounded = IconData(0xf709, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">emoji_food_beverage</i> &#x2014; material icon named "emoji food beverage" (outlined).
  static const IconData emoji_food_beverage_outlined = IconData(0xf01c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">emoji_nature</i> &#x2014; material icon named "emoji nature".
  static const IconData emoji_nature = IconData(0xe22f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">emoji_nature</i> &#x2014; material icon named "emoji nature" (sharp).
  static const IconData emoji_nature_sharp = IconData(0xe92b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">emoji_nature</i> &#x2014; material icon named "emoji nature" (round).
  static const IconData emoji_nature_rounded = IconData(0xf70a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">emoji_nature</i> &#x2014; material icon named "emoji nature" (outlined).
  static const IconData emoji_nature_outlined = IconData(0xf01d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">emoji_objects</i> &#x2014; material icon named "emoji objects".
  static const IconData emoji_objects = IconData(0xe230, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">emoji_objects</i> &#x2014; material icon named "emoji objects" (sharp).
  static const IconData emoji_objects_sharp = IconData(0xe92c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">emoji_objects</i> &#x2014; material icon named "emoji objects" (round).
  static const IconData emoji_objects_rounded = IconData(0xf70b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">emoji_objects</i> &#x2014; material icon named "emoji objects" (outlined).
  static const IconData emoji_objects_outlined = IconData(0xf01e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">emoji_people</i> &#x2014; material icon named "emoji people".
  static const IconData emoji_people = IconData(0xe231, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">emoji_people</i> &#x2014; material icon named "emoji people" (sharp).
  static const IconData emoji_people_sharp = IconData(0xe92d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">emoji_people</i> &#x2014; material icon named "emoji people" (round).
  static const IconData emoji_people_rounded = IconData(0xf70c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">emoji_people</i> &#x2014; material icon named "emoji people" (outlined).
  static const IconData emoji_people_outlined = IconData(0xf01f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">emoji_symbols</i> &#x2014; material icon named "emoji symbols".
  static const IconData emoji_symbols = IconData(0xe232, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">emoji_symbols</i> &#x2014; material icon named "emoji symbols" (sharp).
  static const IconData emoji_symbols_sharp = IconData(0xe92e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">emoji_symbols</i> &#x2014; material icon named "emoji symbols" (round).
  static const IconData emoji_symbols_rounded = IconData(0xf70d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">emoji_symbols</i> &#x2014; material icon named "emoji symbols" (outlined).
  static const IconData emoji_symbols_outlined = IconData(0xf020, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">emoji_transportation</i> &#x2014; material icon named "emoji transportation".
  static const IconData emoji_transportation = IconData(0xe233, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">emoji_transportation</i> &#x2014; material icon named "emoji transportation" (sharp).
  static const IconData emoji_transportation_sharp = IconData(0xe92f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">emoji_transportation</i> &#x2014; material icon named "emoji transportation" (round).
  static const IconData emoji_transportation_rounded = IconData(0xf70e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">emoji_transportation</i> &#x2014; material icon named "emoji transportation" (outlined).
  static const IconData emoji_transportation_outlined = IconData(0xf021, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">engineering</i> &#x2014; material icon named "engineering".
  static const IconData engineering = IconData(0xe234, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">engineering</i> &#x2014; material icon named "engineering" (sharp).
  static const IconData engineering_sharp = IconData(0xe930, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">engineering</i> &#x2014; material icon named "engineering" (round).
  static const IconData engineering_rounded = IconData(0xf70f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">engineering</i> &#x2014; material icon named "engineering" (outlined).
  static const IconData engineering_outlined = IconData(0xf022, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">enhance_photo_translate</i> &#x2014; material icon named "enhance photo translate".
  static const IconData enhance_photo_translate = IconData(0xe131, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">enhance_photo_translate</i> &#x2014; material icon named "enhance photo translate" (sharp).
  static const IconData enhance_photo_translate_sharp = IconData(0xe82d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">enhance_photo_translate</i> &#x2014; material icon named "enhance photo translate" (round).
  static const IconData enhance_photo_translate_rounded = IconData(0xf60c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">enhance_photo_translate</i> &#x2014; material icon named "enhance photo translate" (outlined).
  static const IconData enhance_photo_translate_outlined = IconData(0xef1f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">enhanced_encryption</i> &#x2014; material icon named "enhanced encryption".
  static const IconData enhanced_encryption = IconData(0xe235, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">enhanced_encryption</i> &#x2014; material icon named "enhanced encryption" (sharp).
  static const IconData enhanced_encryption_sharp = IconData(0xe931, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">enhanced_encryption</i> &#x2014; material icon named "enhanced encryption" (round).
  static const IconData enhanced_encryption_rounded = IconData(0xf710, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">enhanced_encryption</i> &#x2014; material icon named "enhanced encryption" (outlined).
  static const IconData enhanced_encryption_outlined = IconData(0xf023, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">equalizer</i> &#x2014; material icon named "equalizer".
  static const IconData equalizer = IconData(0xe236, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">equalizer</i> &#x2014; material icon named "equalizer" (sharp).
  static const IconData equalizer_sharp = IconData(0xe932, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">equalizer</i> &#x2014; material icon named "equalizer" (round).
  static const IconData equalizer_rounded = IconData(0xf711, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">equalizer</i> &#x2014; material icon named "equalizer" (outlined).
  static const IconData equalizer_outlined = IconData(0xf024, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">error</i> &#x2014; material icon named "error".
  static const IconData error = IconData(0xe237, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">error</i> &#x2014; material icon named "error" (sharp).
  static const IconData error_sharp = IconData(0xe934, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">error</i> &#x2014; material icon named "error" (round).
  static const IconData error_rounded = IconData(0xf713, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">error</i> &#x2014; material icon named "error" (outlined).
  static const IconData error_outlined = IconData(0xf026, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">error_outline</i> &#x2014; material icon named "error outline".
  static const IconData error_outline = IconData(0xe238, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">error_outline</i> &#x2014; material icon named "error outline" (sharp).
  static const IconData error_outline_sharp = IconData(0xe933, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">error_outline</i> &#x2014; material icon named "error outline" (round).
  static const IconData error_outline_rounded = IconData(0xf712, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">error_outline</i> &#x2014; material icon named "error outline" (outlined).
  static const IconData error_outline_outlined = IconData(0xf025, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">escalator</i> &#x2014; material icon named "escalator".
  static const IconData escalator = IconData(0xe239, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">escalator</i> &#x2014; material icon named "escalator" (sharp).
  static const IconData escalator_sharp = IconData(0xe935, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">escalator</i> &#x2014; material icon named "escalator" (round).
  static const IconData escalator_rounded = IconData(0xf714, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">escalator</i> &#x2014; material icon named "escalator" (outlined).
  static const IconData escalator_outlined = IconData(0xf027, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">escalator_warning</i> &#x2014; material icon named "escalator warning".
  static const IconData escalator_warning = IconData(0xe23a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">escalator_warning</i> &#x2014; material icon named "escalator warning" (sharp).
  static const IconData escalator_warning_sharp = IconData(0xe936, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">escalator_warning</i> &#x2014; material icon named "escalator warning" (round).
  static const IconData escalator_warning_rounded = IconData(0xf715, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">escalator_warning</i> &#x2014; material icon named "escalator warning" (outlined).
  static const IconData escalator_warning_outlined = IconData(0xf028, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">euro</i> &#x2014; material icon named "euro".
  static const IconData euro = IconData(0xe23b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">euro</i> &#x2014; material icon named "euro" (sharp).
  static const IconData euro_sharp = IconData(0xe937, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">euro</i> &#x2014; material icon named "euro" (round).
  static const IconData euro_rounded = IconData(0xf716, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">euro</i> &#x2014; material icon named "euro" (outlined).
  static const IconData euro_outlined = IconData(0xf029, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">euro_symbol</i> &#x2014; material icon named "euro symbol".
  static const IconData euro_symbol = IconData(0xe23c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">euro_symbol</i> &#x2014; material icon named "euro symbol" (sharp).
  static const IconData euro_symbol_sharp = IconData(0xe938, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">euro_symbol</i> &#x2014; material icon named "euro symbol" (round).
  static const IconData euro_symbol_rounded = IconData(0xf717, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">euro_symbol</i> &#x2014; material icon named "euro symbol" (outlined).
  static const IconData euro_symbol_outlined = IconData(0xf02a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">ev_station</i> &#x2014; material icon named "ev station".
  static const IconData ev_station = IconData(0xe23d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">ev_station</i> &#x2014; material icon named "ev station" (sharp).
  static const IconData ev_station_sharp = IconData(0xe939, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">ev_station</i> &#x2014; material icon named "ev station" (round).
  static const IconData ev_station_rounded = IconData(0xf718, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">ev_station</i> &#x2014; material icon named "ev station" (outlined).
  static const IconData ev_station_outlined = IconData(0xf02b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">event</i> &#x2014; material icon named "event".
  static const IconData event = IconData(0xe23e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">event</i> &#x2014; material icon named "event" (sharp).
  static const IconData event_sharp = IconData(0xe93e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">event</i> &#x2014; material icon named "event" (round).
  static const IconData event_rounded = IconData(0xf71c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">event</i> &#x2014; material icon named "event" (outlined).
  static const IconData event_outlined = IconData(0xf02f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">event_available</i> &#x2014; material icon named "event available".
  static const IconData event_available = IconData(0xe23f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">event_available</i> &#x2014; material icon named "event available" (sharp).
  static const IconData event_available_sharp = IconData(0xe93a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">event_available</i> &#x2014; material icon named "event available" (round).
  static const IconData event_available_rounded = IconData(0xf719, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">event_available</i> &#x2014; material icon named "event available" (outlined).
  static const IconData event_available_outlined = IconData(0xf02c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">event_busy</i> &#x2014; material icon named "event busy".
  static const IconData event_busy = IconData(0xe240, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">event_busy</i> &#x2014; material icon named "event busy" (sharp).
  static const IconData event_busy_sharp = IconData(0xe93b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">event_busy</i> &#x2014; material icon named "event busy" (round).
  static const IconData event_busy_rounded = IconData(0xf71a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">event_busy</i> &#x2014; material icon named "event busy" (outlined).
  static const IconData event_busy_outlined = IconData(0xf02d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">event_note</i> &#x2014; material icon named "event note".
  static const IconData event_note = IconData(0xe241, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">event_note</i> &#x2014; material icon named "event note" (sharp).
  static const IconData event_note_sharp = IconData(0xe93c, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">event_note</i> &#x2014; material icon named "event note" (round).
  static const IconData event_note_rounded = IconData(0xf71b, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">event_note</i> &#x2014; material icon named "event note" (outlined).
  static const IconData event_note_outlined = IconData(0xf02e, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">event_seat</i> &#x2014; material icon named "event seat".
  static const IconData event_seat = IconData(0xe242, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">event_seat</i> &#x2014; material icon named "event seat" (sharp).
  static const IconData event_seat_sharp = IconData(0xe93d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">event_seat</i> &#x2014; material icon named "event seat" (round).
  static const IconData event_seat_rounded = IconData(0xf71d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">event_seat</i> &#x2014; material icon named "event seat" (outlined).
  static const IconData event_seat_outlined = IconData(0xf030, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">exit_to_app</i> &#x2014; material icon named "exit to app".
  static const IconData exit_to_app = IconData(0xe243, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">exit_to_app</i> &#x2014; material icon named "exit to app" (sharp).
  static const IconData exit_to_app_sharp = IconData(0xe93f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">exit_to_app</i> &#x2014; material icon named "exit to app" (round).
  static const IconData exit_to_app_rounded = IconData(0xf71e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">exit_to_app</i> &#x2014; material icon named "exit to app" (outlined).
  static const IconData exit_to_app_outlined = IconData(0xf031, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">expand</i> &#x2014; material icon named "expand".
  static const IconData expand = IconData(0xe244, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">expand</i> &#x2014; material icon named "expand" (sharp).
  static const IconData expand_sharp = IconData(0xe942, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">expand</i> &#x2014; material icon named "expand" (round).
  static const IconData expand_rounded = IconData(0xf721, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">expand</i> &#x2014; material icon named "expand" (outlined).
  static const IconData expand_outlined = IconData(0xf034, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">expand_less</i> &#x2014; material icon named "expand less".
  static const IconData expand_less = IconData(0xe245, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">expand_less</i> &#x2014; material icon named "expand less" (sharp).
  static const IconData expand_less_sharp = IconData(0xe940, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">expand_less</i> &#x2014; material icon named "expand less" (round).
  static const IconData expand_less_rounded = IconData(0xf71f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">expand_less</i> &#x2014; material icon named "expand less" (outlined).
  static const IconData expand_less_outlined = IconData(0xf032, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">expand_more</i> &#x2014; material icon named "expand more".
  static const IconData expand_more = IconData(0xe246, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">expand_more</i> &#x2014; material icon named "expand more" (sharp).
  static const IconData expand_more_sharp = IconData(0xe941, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">expand_more</i> &#x2014; material icon named "expand more" (round).
  static const IconData expand_more_rounded = IconData(0xf720, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">expand_more</i> &#x2014; material icon named "expand more" (outlined).
  static const IconData expand_more_outlined = IconData(0xf033, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">explicit</i> &#x2014; material icon named "explicit".
  static const IconData explicit = IconData(0xe247, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">explicit</i> &#x2014; material icon named "explicit" (sharp).
  static const IconData explicit_sharp = IconData(0xe943, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">explicit</i> &#x2014; material icon named "explicit" (round).
  static const IconData explicit_rounded = IconData(0xf722, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">explicit</i> &#x2014; material icon named "explicit" (outlined).
  static const IconData explicit_outlined = IconData(0xf035, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">explore</i> &#x2014; material icon named "explore".
  static const IconData explore = IconData(0xe248, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">explore</i> &#x2014; material icon named "explore" (sharp).
  static const IconData explore_sharp = IconData(0xe945, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">explore</i> &#x2014; material icon named "explore" (round).
  static const IconData explore_rounded = IconData(0xf724, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">explore</i> &#x2014; material icon named "explore" (outlined).
  static const IconData explore_outlined = IconData(0xf037, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">explore_off</i> &#x2014; material icon named "explore off".
  static const IconData explore_off = IconData(0xe249, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">explore_off</i> &#x2014; material icon named "explore off" (sharp).
  static const IconData explore_off_sharp = IconData(0xe944, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">explore_off</i> &#x2014; material icon named "explore off" (round).
  static const IconData explore_off_rounded = IconData(0xf723, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">explore_off</i> &#x2014; material icon named "explore off" (outlined).
  static const IconData explore_off_outlined = IconData(0xf036, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">exposure</i> &#x2014; material icon named "exposure".
  static const IconData exposure = IconData(0xe24a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">exposure</i> &#x2014; material icon named "exposure" (sharp).
  static const IconData exposure_sharp = IconData(0xe94a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">exposure</i> &#x2014; material icon named "exposure" (round).
  static const IconData exposure_rounded = IconData(0xf729, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">exposure</i> &#x2014; material icon named "exposure" (outlined).
  static const IconData exposure_outlined = IconData(0xf03a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">exposure_minus_1</i> &#x2014; material icon named "exposure minus 1".
  static const IconData exposure_minus_1 = IconData(0xe24b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">exposure_minus_1</i> &#x2014; material icon named "exposure minus 1" (sharp).
  static const IconData exposure_minus_1_sharp = IconData(0xe946, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">exposure_minus_1</i> &#x2014; material icon named "exposure minus 1" (round).
  static const IconData exposure_minus_1_rounded = IconData(0xf725, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">exposure_minus_1</i> &#x2014; material icon named "exposure minus 1" (outlined).
  static const IconData exposure_minus_1_outlined = IconData(0xf038, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">exposure_minus_2</i> &#x2014; material icon named "exposure minus 2".
  static const IconData exposure_minus_2 = IconData(0xe24c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">exposure_minus_2</i> &#x2014; material icon named "exposure minus 2" (sharp).
  static const IconData exposure_minus_2_sharp = IconData(0xe947, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">exposure_minus_2</i> &#x2014; material icon named "exposure minus 2" (round).
  static const IconData exposure_minus_2_rounded = IconData(0xf726, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">exposure_minus_2</i> &#x2014; material icon named "exposure minus 2" (outlined).
  static const IconData exposure_minus_2_outlined = IconData(0xf039, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">exposure_neg_1</i> &#x2014; material icon named "exposure neg 1".
  static const IconData exposure_neg_1 = IconData(0xe24b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">exposure_neg_1</i> &#x2014; material icon named "exposure neg 1" (sharp).
  static const IconData exposure_neg_1_sharp = IconData(0xe946, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">exposure_neg_1</i> &#x2014; material icon named "exposure neg 1" (round).
  static const IconData exposure_neg_1_rounded = IconData(0xf725, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">exposure_neg_1</i> &#x2014; material icon named "exposure neg 1" (outlined).
  static const IconData exposure_neg_1_outlined = IconData(0xf038, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">exposure_neg_2</i> &#x2014; material icon named "exposure neg 2".
  static const IconData exposure_neg_2 = IconData(0xe24c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">exposure_neg_2</i> &#x2014; material icon named "exposure neg 2" (sharp).
  static const IconData exposure_neg_2_sharp = IconData(0xe947, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">exposure_neg_2</i> &#x2014; material icon named "exposure neg 2" (round).
  static const IconData exposure_neg_2_rounded = IconData(0xf726, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">exposure_neg_2</i> &#x2014; material icon named "exposure neg 2" (outlined).
  static const IconData exposure_neg_2_outlined = IconData(0xf039, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">exposure_plus_1</i> &#x2014; material icon named "exposure plus 1".
  static const IconData exposure_plus_1 = IconData(0xe24d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">exposure_plus_1</i> &#x2014; material icon named "exposure plus 1" (sharp).
  static const IconData exposure_plus_1_sharp = IconData(0xe948, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">exposure_plus_1</i> &#x2014; material icon named "exposure plus 1" (round).
  static const IconData exposure_plus_1_rounded = IconData(0xf727, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">exposure_plus_1</i> &#x2014; material icon named "exposure plus 1" (outlined).
  static const IconData exposure_plus_1_outlined = IconData(0xf03b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">exposure_plus_2</i> &#x2014; material icon named "exposure plus 2".
  static const IconData exposure_plus_2 = IconData(0xe24e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">exposure_plus_2</i> &#x2014; material icon named "exposure plus 2" (sharp).
  static const IconData exposure_plus_2_sharp = IconData(0xe949, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">exposure_plus_2</i> &#x2014; material icon named "exposure plus 2" (round).
  static const IconData exposure_plus_2_rounded = IconData(0xf728, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">exposure_plus_2</i> &#x2014; material icon named "exposure plus 2" (outlined).
  static const IconData exposure_plus_2_outlined = IconData(0xf03c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">exposure_zero</i> &#x2014; material icon named "exposure zero".
  static const IconData exposure_zero = IconData(0xe24f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">exposure_zero</i> &#x2014; material icon named "exposure zero" (sharp).
  static const IconData exposure_zero_sharp = IconData(0xe94b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">exposure_zero</i> &#x2014; material icon named "exposure zero" (round).
  static const IconData exposure_zero_rounded = IconData(0xf72a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">exposure_zero</i> &#x2014; material icon named "exposure zero" (outlined).
  static const IconData exposure_zero_outlined = IconData(0xf03d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">extension</i> &#x2014; material icon named "extension".
  static const IconData extension = IconData(0xe250, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">extension</i> &#x2014; material icon named "extension" (sharp).
  static const IconData extension_sharp = IconData(0xe94d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">extension</i> &#x2014; material icon named "extension" (round).
  static const IconData extension_rounded = IconData(0xf72c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">extension</i> &#x2014; material icon named "extension" (outlined).
  static const IconData extension_outlined = IconData(0xf03f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">extension_off</i> &#x2014; material icon named "extension off".
  static const IconData extension_off = IconData(0xe251, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">extension_off</i> &#x2014; material icon named "extension off" (sharp).
  static const IconData extension_off_sharp = IconData(0xe94c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">extension_off</i> &#x2014; material icon named "extension off" (round).
  static const IconData extension_off_rounded = IconData(0xf72b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">extension_off</i> &#x2014; material icon named "extension off" (outlined).
  static const IconData extension_off_outlined = IconData(0xf03e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">face</i> &#x2014; material icon named "face".
  static const IconData face = IconData(0xe252, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">face</i> &#x2014; material icon named "face" (sharp).
  static const IconData face_sharp = IconData(0xe950, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">face</i> &#x2014; material icon named "face" (round).
  static const IconData face_rounded = IconData(0xf72f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">face</i> &#x2014; material icon named "face" (outlined).
  static const IconData face_outlined = IconData(0xf040, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">face_retouching_natural</i> &#x2014; material icon named "face retouching natural".
  static const IconData face_retouching_natural = IconData(0xe253, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">face_retouching_natural</i> &#x2014; material icon named "face retouching natural" (sharp).
  static const IconData face_retouching_natural_sharp = IconData(0xe94e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">face_retouching_natural</i> &#x2014; material icon named "face retouching natural" (round).
  static const IconData face_retouching_natural_rounded = IconData(0xf72d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">face_retouching_natural</i> &#x2014; material icon named "face retouching natural" (outlined).
  static const IconData face_retouching_natural_outlined = IconData(0xf041, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">face_retouching_off</i> &#x2014; material icon named "face retouching off".
  static const IconData face_retouching_off = IconData(0xe254, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">face_retouching_off</i> &#x2014; material icon named "face retouching off" (sharp).
  static const IconData face_retouching_off_sharp = IconData(0xe94f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">face_retouching_off</i> &#x2014; material icon named "face retouching off" (round).
  static const IconData face_retouching_off_rounded = IconData(0xf72e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">face_retouching_off</i> &#x2014; material icon named "face retouching off" (outlined).
  static const IconData face_retouching_off_outlined = IconData(0xf042, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">face_unlock</i> &#x2014; material icon named "face unlock" (sharp).
  static const IconData face_unlock_sharp = IconData(0xe951, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">face_unlock</i> &#x2014; material icon named "face unlock" (round).
  static const IconData face_unlock_rounded = IconData(0xf730, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">face_unlock</i> &#x2014; material icon named "face unlock" (outlined).
  static const IconData face_unlock_outlined = IconData(0xf043, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">facebook</i> &#x2014; material icon named "facebook".
  static const IconData facebook = IconData(0xe255, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">facebook</i> &#x2014; material icon named "facebook" (sharp).
  static const IconData facebook_sharp = IconData(0xe952, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">facebook</i> &#x2014; material icon named "facebook" (round).
  static const IconData facebook_rounded = IconData(0xf731, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">facebook</i> &#x2014; material icon named "facebook" (outlined).
  static const IconData facebook_outlined = IconData(0xf044, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fact_check</i> &#x2014; material icon named "fact check".
  static const IconData fact_check = IconData(0xe256, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fact_check</i> &#x2014; material icon named "fact check" (sharp).
  static const IconData fact_check_sharp = IconData(0xe953, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fact_check</i> &#x2014; material icon named "fact check" (round).
  static const IconData fact_check_rounded = IconData(0xf732, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fact_check</i> &#x2014; material icon named "fact check" (outlined).
  static const IconData fact_check_outlined = IconData(0xf045, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">family_restroom</i> &#x2014; material icon named "family restroom".
  static const IconData family_restroom = IconData(0xe257, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">family_restroom</i> &#x2014; material icon named "family restroom" (sharp).
  static const IconData family_restroom_sharp = IconData(0xe954, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">family_restroom</i> &#x2014; material icon named "family restroom" (round).
  static const IconData family_restroom_rounded = IconData(0xf733, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">family_restroom</i> &#x2014; material icon named "family restroom" (outlined).
  static const IconData family_restroom_outlined = IconData(0xf046, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fast_forward</i> &#x2014; material icon named "fast forward".
  static const IconData fast_forward = IconData(0xe258, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fast_forward</i> &#x2014; material icon named "fast forward" (sharp).
  static const IconData fast_forward_sharp = IconData(0xe955, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fast_forward</i> &#x2014; material icon named "fast forward" (round).
  static const IconData fast_forward_rounded = IconData(0xf734, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fast_forward</i> &#x2014; material icon named "fast forward" (outlined).
  static const IconData fast_forward_outlined = IconData(0xf047, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fast_rewind</i> &#x2014; material icon named "fast rewind".
  static const IconData fast_rewind = IconData(0xe259, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fast_rewind</i> &#x2014; material icon named "fast rewind" (sharp).
  static const IconData fast_rewind_sharp = IconData(0xe956, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fast_rewind</i> &#x2014; material icon named "fast rewind" (round).
  static const IconData fast_rewind_rounded = IconData(0xf735, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fast_rewind</i> &#x2014; material icon named "fast rewind" (outlined).
  static const IconData fast_rewind_outlined = IconData(0xf048, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fastfood</i> &#x2014; material icon named "fastfood".
  static const IconData fastfood = IconData(0xe25a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fastfood</i> &#x2014; material icon named "fastfood" (sharp).
  static const IconData fastfood_sharp = IconData(0xe957, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fastfood</i> &#x2014; material icon named "fastfood" (round).
  static const IconData fastfood_rounded = IconData(0xf736, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fastfood</i> &#x2014; material icon named "fastfood" (outlined).
  static const IconData fastfood_outlined = IconData(0xf049, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">favorite</i> &#x2014; material icon named "favorite".
  static const IconData favorite = IconData(0xe25b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">favorite</i> &#x2014; material icon named "favorite" (sharp).
  static const IconData favorite_sharp = IconData(0xe959, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">favorite</i> &#x2014; material icon named "favorite" (round).
  static const IconData favorite_rounded = IconData(0xf738, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">favorite</i> &#x2014; material icon named "favorite" (outlined).
  static const IconData favorite_outlined = IconData(0xf04b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">favorite_border</i> &#x2014; material icon named "favorite border".
  static const IconData favorite_border = IconData(0xe25c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">favorite_border</i> &#x2014; material icon named "favorite border" (sharp).
  static const IconData favorite_border_sharp = IconData(0xe958, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">favorite_border</i> &#x2014; material icon named "favorite border" (round).
  static const IconData favorite_border_rounded = IconData(0xf737, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">favorite_border</i> &#x2014; material icon named "favorite border" (outlined).
  static const IconData favorite_border_outlined = IconData(0xf04a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">favorite_outline</i> &#x2014; material icon named "favorite outline".
  static const IconData favorite_outline = IconData(0xe25c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">favorite_outline</i> &#x2014; material icon named "favorite outline" (sharp).
  static const IconData favorite_outline_sharp = IconData(0xe958, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">favorite_outline</i> &#x2014; material icon named "favorite outline" (round).
  static const IconData favorite_outline_rounded = IconData(0xf737, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">favorite_outline</i> &#x2014; material icon named "favorite outline" (outlined).
  static const IconData favorite_outline_outlined = IconData(0xf04a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">featured_play_list</i> &#x2014; material icon named "featured play list".
  static const IconData featured_play_list = IconData(0xe25d, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">featured_play_list</i> &#x2014; material icon named "featured play list" (sharp).
  static const IconData featured_play_list_sharp = IconData(0xe95a, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">featured_play_list</i> &#x2014; material icon named "featured play list" (round).
  static const IconData featured_play_list_rounded = IconData(0xf739, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">featured_play_list</i> &#x2014; material icon named "featured play list" (outlined).
  static const IconData featured_play_list_outlined = IconData(0xf04c, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">featured_video</i> &#x2014; material icon named "featured video".
  static const IconData featured_video = IconData(0xe25e, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">featured_video</i> &#x2014; material icon named "featured video" (sharp).
  static const IconData featured_video_sharp = IconData(0xe95b, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">featured_video</i> &#x2014; material icon named "featured video" (round).
  static const IconData featured_video_rounded = IconData(0xf73a, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">featured_video</i> &#x2014; material icon named "featured video" (outlined).
  static const IconData featured_video_outlined = IconData(0xf04d, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">feed</i> &#x2014; material icon named "feed".
  static const IconData feed = IconData(0xe25f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">feed</i> &#x2014; material icon named "feed" (sharp).
  static const IconData feed_sharp = IconData(0xe95c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">feed</i> &#x2014; material icon named "feed" (round).
  static const IconData feed_rounded = IconData(0xf73b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">feed</i> &#x2014; material icon named "feed" (outlined).
  static const IconData feed_outlined = IconData(0xf04e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">feedback</i> &#x2014; material icon named "feedback".
  static const IconData feedback = IconData(0xe260, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">feedback</i> &#x2014; material icon named "feedback" (sharp).
  static const IconData feedback_sharp = IconData(0xe95d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">feedback</i> &#x2014; material icon named "feedback" (round).
  static const IconData feedback_rounded = IconData(0xf73c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">feedback</i> &#x2014; material icon named "feedback" (outlined).
  static const IconData feedback_outlined = IconData(0xf04f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">female</i> &#x2014; material icon named "female".
  static const IconData female = IconData(0xe261, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">female</i> &#x2014; material icon named "female" (sharp).
  static const IconData female_sharp = IconData(0xe95e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">female</i> &#x2014; material icon named "female" (round).
  static const IconData female_rounded = IconData(0xf73d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">female</i> &#x2014; material icon named "female" (outlined).
  static const IconData female_outlined = IconData(0xf050, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fence</i> &#x2014; material icon named "fence".
  static const IconData fence = IconData(0xe262, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fence</i> &#x2014; material icon named "fence" (sharp).
  static const IconData fence_sharp = IconData(0xe95f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fence</i> &#x2014; material icon named "fence" (round).
  static const IconData fence_rounded = IconData(0xf73e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fence</i> &#x2014; material icon named "fence" (outlined).
  static const IconData fence_outlined = IconData(0xf051, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">festival</i> &#x2014; material icon named "festival".
  static const IconData festival = IconData(0xe263, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">festival</i> &#x2014; material icon named "festival" (sharp).
  static const IconData festival_sharp = IconData(0xe960, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">festival</i> &#x2014; material icon named "festival" (round).
  static const IconData festival_rounded = IconData(0xf73f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">festival</i> &#x2014; material icon named "festival" (outlined).
  static const IconData festival_outlined = IconData(0xf052, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fiber_dvr</i> &#x2014; material icon named "fiber dvr".
  static const IconData fiber_dvr = IconData(0xe264, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fiber_dvr</i> &#x2014; material icon named "fiber dvr" (sharp).
  static const IconData fiber_dvr_sharp = IconData(0xe961, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fiber_dvr</i> &#x2014; material icon named "fiber dvr" (round).
  static const IconData fiber_dvr_rounded = IconData(0xf740, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fiber_dvr</i> &#x2014; material icon named "fiber dvr" (outlined).
  static const IconData fiber_dvr_outlined = IconData(0xf053, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fiber_manual_record</i> &#x2014; material icon named "fiber manual record".
  static const IconData fiber_manual_record = IconData(0xe265, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fiber_manual_record</i> &#x2014; material icon named "fiber manual record" (sharp).
  static const IconData fiber_manual_record_sharp = IconData(0xe962, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fiber_manual_record</i> &#x2014; material icon named "fiber manual record" (round).
  static const IconData fiber_manual_record_rounded = IconData(0xf741, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fiber_manual_record</i> &#x2014; material icon named "fiber manual record" (outlined).
  static const IconData fiber_manual_record_outlined = IconData(0xf054, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fiber_new</i> &#x2014; material icon named "fiber new".
  static const IconData fiber_new = IconData(0xe266, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fiber_new</i> &#x2014; material icon named "fiber new" (sharp).
  static const IconData fiber_new_sharp = IconData(0xe963, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fiber_new</i> &#x2014; material icon named "fiber new" (round).
  static const IconData fiber_new_rounded = IconData(0xf742, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fiber_new</i> &#x2014; material icon named "fiber new" (outlined).
  static const IconData fiber_new_outlined = IconData(0xf055, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fiber_pin</i> &#x2014; material icon named "fiber pin".
  static const IconData fiber_pin = IconData(0xe267, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fiber_pin</i> &#x2014; material icon named "fiber pin" (sharp).
  static const IconData fiber_pin_sharp = IconData(0xe964, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fiber_pin</i> &#x2014; material icon named "fiber pin" (round).
  static const IconData fiber_pin_rounded = IconData(0xf743, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fiber_pin</i> &#x2014; material icon named "fiber pin" (outlined).
  static const IconData fiber_pin_outlined = IconData(0xf056, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fiber_smart_record</i> &#x2014; material icon named "fiber smart record".
  static const IconData fiber_smart_record = IconData(0xe268, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fiber_smart_record</i> &#x2014; material icon named "fiber smart record" (sharp).
  static const IconData fiber_smart_record_sharp = IconData(0xe965, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fiber_smart_record</i> &#x2014; material icon named "fiber smart record" (round).
  static const IconData fiber_smart_record_rounded = IconData(0xf744, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fiber_smart_record</i> &#x2014; material icon named "fiber smart record" (outlined).
  static const IconData fiber_smart_record_outlined = IconData(0xf057, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">file_copy</i> &#x2014; material icon named "file copy".
  static const IconData file_copy = IconData(0xe269, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">file_copy</i> &#x2014; material icon named "file copy" (sharp).
  static const IconData file_copy_sharp = IconData(0xe966, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">file_copy</i> &#x2014; material icon named "file copy" (round).
  static const IconData file_copy_rounded = IconData(0xf745, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">file_copy</i> &#x2014; material icon named "file copy" (outlined).
  static const IconData file_copy_outlined = IconData(0xf058, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">file_download</i> &#x2014; material icon named "file download".
  static const IconData file_download = IconData(0xe26a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">file_download</i> &#x2014; material icon named "file download" (sharp).
  static const IconData file_download_sharp = IconData(0xe969, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">file_download</i> &#x2014; material icon named "file download" (round).
  static const IconData file_download_rounded = IconData(0xf748, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">file_download</i> &#x2014; material icon named "file download" (outlined).
  static const IconData file_download_outlined = IconData(0xf05b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">file_download_done</i> &#x2014; material icon named "file download done".
  static const IconData file_download_done = IconData(0xe26b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">file_download_done</i> &#x2014; material icon named "file download done" (sharp).
  static const IconData file_download_done_sharp = IconData(0xe967, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">file_download_done</i> &#x2014; material icon named "file download done" (round).
  static const IconData file_download_done_rounded = IconData(0xf746, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">file_download_done</i> &#x2014; material icon named "file download done" (outlined).
  static const IconData file_download_done_outlined = IconData(0xf059, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">file_download_off</i> &#x2014; material icon named "file download off".
  static const IconData file_download_off = IconData(0xe26c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">file_download_off</i> &#x2014; material icon named "file download off" (sharp).
  static const IconData file_download_off_sharp = IconData(0xe968, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">file_download_off</i> &#x2014; material icon named "file download off" (round).
  static const IconData file_download_off_rounded = IconData(0xf747, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">file_download_off</i> &#x2014; material icon named "file download off" (outlined).
  static const IconData file_download_off_outlined = IconData(0xf05a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">file_present</i> &#x2014; material icon named "file present".
  static const IconData file_present = IconData(0xe26d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">file_present</i> &#x2014; material icon named "file present" (sharp).
  static const IconData file_present_sharp = IconData(0xe96a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">file_present</i> &#x2014; material icon named "file present" (round).
  static const IconData file_present_rounded = IconData(0xf749, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">file_present</i> &#x2014; material icon named "file present" (outlined).
  static const IconData file_present_outlined = IconData(0xf05c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">file_upload</i> &#x2014; material icon named "file upload".
  static const IconData file_upload = IconData(0xe26e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">file_upload</i> &#x2014; material icon named "file upload" (sharp).
  static const IconData file_upload_sharp = IconData(0xe96b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">file_upload</i> &#x2014; material icon named "file upload" (round).
  static const IconData file_upload_rounded = IconData(0xf74a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">file_upload</i> &#x2014; material icon named "file upload" (outlined).
  static const IconData file_upload_outlined = IconData(0xf05d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter</i> &#x2014; material icon named "filter".
  static const IconData filter = IconData(0xe26f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter</i> &#x2014; material icon named "filter" (sharp).
  static const IconData filter_sharp = IconData(0xe97e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter</i> &#x2014; material icon named "filter" (round).
  static const IconData filter_rounded = IconData(0xf75d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter</i> &#x2014; material icon named "filter" (outlined).
  static const IconData filter_outlined = IconData(0xf070, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_1</i> &#x2014; material icon named "filter 1".
  static const IconData filter_1 = IconData(0xe270, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_1</i> &#x2014; material icon named "filter 1" (sharp).
  static const IconData filter_1_sharp = IconData(0xe96c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_1</i> &#x2014; material icon named "filter 1" (round).
  static const IconData filter_1_rounded = IconData(0xf74b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_1</i> &#x2014; material icon named "filter 1" (outlined).
  static const IconData filter_1_outlined = IconData(0xf05e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_2</i> &#x2014; material icon named "filter 2".
  static const IconData filter_2 = IconData(0xe271, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_2</i> &#x2014; material icon named "filter 2" (sharp).
  static const IconData filter_2_sharp = IconData(0xe96d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_2</i> &#x2014; material icon named "filter 2" (round).
  static const IconData filter_2_rounded = IconData(0xf74c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_2</i> &#x2014; material icon named "filter 2" (outlined).
  static const IconData filter_2_outlined = IconData(0xf05f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_3</i> &#x2014; material icon named "filter 3".
  static const IconData filter_3 = IconData(0xe272, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_3</i> &#x2014; material icon named "filter 3" (sharp).
  static const IconData filter_3_sharp = IconData(0xe96e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_3</i> &#x2014; material icon named "filter 3" (round).
  static const IconData filter_3_rounded = IconData(0xf74d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_3</i> &#x2014; material icon named "filter 3" (outlined).
  static const IconData filter_3_outlined = IconData(0xf060, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_4</i> &#x2014; material icon named "filter 4".
  static const IconData filter_4 = IconData(0xe273, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_4</i> &#x2014; material icon named "filter 4" (sharp).
  static const IconData filter_4_sharp = IconData(0xe96f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_4</i> &#x2014; material icon named "filter 4" (round).
  static const IconData filter_4_rounded = IconData(0xf74e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_4</i> &#x2014; material icon named "filter 4" (outlined).
  static const IconData filter_4_outlined = IconData(0xf061, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_5</i> &#x2014; material icon named "filter 5".
  static const IconData filter_5 = IconData(0xe274, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_5</i> &#x2014; material icon named "filter 5" (sharp).
  static const IconData filter_5_sharp = IconData(0xe970, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_5</i> &#x2014; material icon named "filter 5" (round).
  static const IconData filter_5_rounded = IconData(0xf74f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_5</i> &#x2014; material icon named "filter 5" (outlined).
  static const IconData filter_5_outlined = IconData(0xf062, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_6</i> &#x2014; material icon named "filter 6".
  static const IconData filter_6 = IconData(0xe275, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_6</i> &#x2014; material icon named "filter 6" (sharp).
  static const IconData filter_6_sharp = IconData(0xe971, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_6</i> &#x2014; material icon named "filter 6" (round).
  static const IconData filter_6_rounded = IconData(0xf750, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_6</i> &#x2014; material icon named "filter 6" (outlined).
  static const IconData filter_6_outlined = IconData(0xf063, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_7</i> &#x2014; material icon named "filter 7".
  static const IconData filter_7 = IconData(0xe276, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_7</i> &#x2014; material icon named "filter 7" (sharp).
  static const IconData filter_7_sharp = IconData(0xe972, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_7</i> &#x2014; material icon named "filter 7" (round).
  static const IconData filter_7_rounded = IconData(0xf751, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_7</i> &#x2014; material icon named "filter 7" (outlined).
  static const IconData filter_7_outlined = IconData(0xf064, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_8</i> &#x2014; material icon named "filter 8".
  static const IconData filter_8 = IconData(0xe277, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_8</i> &#x2014; material icon named "filter 8" (sharp).
  static const IconData filter_8_sharp = IconData(0xe973, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_8</i> &#x2014; material icon named "filter 8" (round).
  static const IconData filter_8_rounded = IconData(0xf752, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_8</i> &#x2014; material icon named "filter 8" (outlined).
  static const IconData filter_8_outlined = IconData(0xf065, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_9</i> &#x2014; material icon named "filter 9".
  static const IconData filter_9 = IconData(0xe278, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_9</i> &#x2014; material icon named "filter 9" (sharp).
  static const IconData filter_9_sharp = IconData(0xe975, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_9</i> &#x2014; material icon named "filter 9" (round).
  static const IconData filter_9_rounded = IconData(0xf754, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_9</i> &#x2014; material icon named "filter 9" (outlined).
  static const IconData filter_9_outlined = IconData(0xf066, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_9_plus</i> &#x2014; material icon named "filter 9 plus".
  static const IconData filter_9_plus = IconData(0xe279, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_9_plus</i> &#x2014; material icon named "filter 9 plus" (sharp).
  static const IconData filter_9_plus_sharp = IconData(0xe974, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_9_plus</i> &#x2014; material icon named "filter 9 plus" (round).
  static const IconData filter_9_plus_rounded = IconData(0xf753, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_9_plus</i> &#x2014; material icon named "filter 9 plus" (outlined).
  static const IconData filter_9_plus_outlined = IconData(0xf067, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_alt</i> &#x2014; material icon named "filter alt".
  static const IconData filter_alt = IconData(0xe27a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_alt</i> &#x2014; material icon named "filter alt" (sharp).
  static const IconData filter_alt_sharp = IconData(0xe976, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_alt</i> &#x2014; material icon named "filter alt" (round).
  static const IconData filter_alt_rounded = IconData(0xf755, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_alt</i> &#x2014; material icon named "filter alt" (outlined).
  static const IconData filter_alt_outlined = IconData(0xf068, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_b_and_w</i> &#x2014; material icon named "filter b and w".
  static const IconData filter_b_and_w = IconData(0xe27b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_b_and_w</i> &#x2014; material icon named "filter b and w" (sharp).
  static const IconData filter_b_and_w_sharp = IconData(0xe977, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_b_and_w</i> &#x2014; material icon named "filter b and w" (round).
  static const IconData filter_b_and_w_rounded = IconData(0xf756, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_b_and_w</i> &#x2014; material icon named "filter b and w" (outlined).
  static const IconData filter_b_and_w_outlined = IconData(0xf069, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_center_focus</i> &#x2014; material icon named "filter center focus".
  static const IconData filter_center_focus = IconData(0xe27c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_center_focus</i> &#x2014; material icon named "filter center focus" (sharp).
  static const IconData filter_center_focus_sharp = IconData(0xe978, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_center_focus</i> &#x2014; material icon named "filter center focus" (round).
  static const IconData filter_center_focus_rounded = IconData(0xf757, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_center_focus</i> &#x2014; material icon named "filter center focus" (outlined).
  static const IconData filter_center_focus_outlined = IconData(0xf06a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_drama</i> &#x2014; material icon named "filter drama".
  static const IconData filter_drama = IconData(0xe27d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_drama</i> &#x2014; material icon named "filter drama" (sharp).
  static const IconData filter_drama_sharp = IconData(0xe979, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_drama</i> &#x2014; material icon named "filter drama" (round).
  static const IconData filter_drama_rounded = IconData(0xf758, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_drama</i> &#x2014; material icon named "filter drama" (outlined).
  static const IconData filter_drama_outlined = IconData(0xf06b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_frames</i> &#x2014; material icon named "filter frames".
  static const IconData filter_frames = IconData(0xe27e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_frames</i> &#x2014; material icon named "filter frames" (sharp).
  static const IconData filter_frames_sharp = IconData(0xe97a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_frames</i> &#x2014; material icon named "filter frames" (round).
  static const IconData filter_frames_rounded = IconData(0xf759, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_frames</i> &#x2014; material icon named "filter frames" (outlined).
  static const IconData filter_frames_outlined = IconData(0xf06c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_hdr</i> &#x2014; material icon named "filter hdr".
  static const IconData filter_hdr = IconData(0xe27f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_hdr</i> &#x2014; material icon named "filter hdr" (sharp).
  static const IconData filter_hdr_sharp = IconData(0xe97b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_hdr</i> &#x2014; material icon named "filter hdr" (round).
  static const IconData filter_hdr_rounded = IconData(0xf75a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_hdr</i> &#x2014; material icon named "filter hdr" (outlined).
  static const IconData filter_hdr_outlined = IconData(0xf06d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_list</i> &#x2014; material icon named "filter list".
  static const IconData filter_list = IconData(0xe280, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_list</i> &#x2014; material icon named "filter list" (sharp).
  static const IconData filter_list_sharp = IconData(0xe97c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_list</i> &#x2014; material icon named "filter list" (round).
  static const IconData filter_list_rounded = IconData(0xf75b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_list</i> &#x2014; material icon named "filter list" (outlined).
  static const IconData filter_list_outlined = IconData(0xf06e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_list_alt</i> &#x2014; material icon named "filter list alt".
  static const IconData filter_list_alt = IconData(0xe281, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_none</i> &#x2014; material icon named "filter none".
  static const IconData filter_none = IconData(0xe282, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_none</i> &#x2014; material icon named "filter none" (sharp).
  static const IconData filter_none_sharp = IconData(0xe97d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_none</i> &#x2014; material icon named "filter none" (round).
  static const IconData filter_none_rounded = IconData(0xf75c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_none</i> &#x2014; material icon named "filter none" (outlined).
  static const IconData filter_none_outlined = IconData(0xf06f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_tilt_shift</i> &#x2014; material icon named "filter tilt shift".
  static const IconData filter_tilt_shift = IconData(0xe283, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_tilt_shift</i> &#x2014; material icon named "filter tilt shift" (sharp).
  static const IconData filter_tilt_shift_sharp = IconData(0xe97f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_tilt_shift</i> &#x2014; material icon named "filter tilt shift" (round).
  static const IconData filter_tilt_shift_rounded = IconData(0xf75e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_tilt_shift</i> &#x2014; material icon named "filter tilt shift" (outlined).
  static const IconData filter_tilt_shift_outlined = IconData(0xf071, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">filter_vintage</i> &#x2014; material icon named "filter vintage".
  static const IconData filter_vintage = IconData(0xe284, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">filter_vintage</i> &#x2014; material icon named "filter vintage" (sharp).
  static const IconData filter_vintage_sharp = IconData(0xe980, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">filter_vintage</i> &#x2014; material icon named "filter vintage" (round).
  static const IconData filter_vintage_rounded = IconData(0xf75f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">filter_vintage</i> &#x2014; material icon named "filter vintage" (outlined).
  static const IconData filter_vintage_outlined = IconData(0xf072, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">find_in_page</i> &#x2014; material icon named "find in page".
  static const IconData find_in_page = IconData(0xe285, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">find_in_page</i> &#x2014; material icon named "find in page" (sharp).
  static const IconData find_in_page_sharp = IconData(0xe981, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">find_in_page</i> &#x2014; material icon named "find in page" (round).
  static const IconData find_in_page_rounded = IconData(0xf760, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">find_in_page</i> &#x2014; material icon named "find in page" (outlined).
  static const IconData find_in_page_outlined = IconData(0xf073, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">find_replace</i> &#x2014; material icon named "find replace".
  static const IconData find_replace = IconData(0xe286, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">find_replace</i> &#x2014; material icon named "find replace" (sharp).
  static const IconData find_replace_sharp = IconData(0xe982, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">find_replace</i> &#x2014; material icon named "find replace" (round).
  static const IconData find_replace_rounded = IconData(0xf761, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">find_replace</i> &#x2014; material icon named "find replace" (outlined).
  static const IconData find_replace_outlined = IconData(0xf074, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fingerprint</i> &#x2014; material icon named "fingerprint".
  static const IconData fingerprint = IconData(0xe287, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fingerprint</i> &#x2014; material icon named "fingerprint" (sharp).
  static const IconData fingerprint_sharp = IconData(0xe983, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fingerprint</i> &#x2014; material icon named "fingerprint" (round).
  static const IconData fingerprint_rounded = IconData(0xf762, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fingerprint</i> &#x2014; material icon named "fingerprint" (outlined).
  static const IconData fingerprint_outlined = IconData(0xf075, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fire_extinguisher</i> &#x2014; material icon named "fire extinguisher".
  static const IconData fire_extinguisher = IconData(0xe288, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fire_extinguisher</i> &#x2014; material icon named "fire extinguisher" (sharp).
  static const IconData fire_extinguisher_sharp = IconData(0xe984, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fire_extinguisher</i> &#x2014; material icon named "fire extinguisher" (round).
  static const IconData fire_extinguisher_rounded = IconData(0xf763, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fire_extinguisher</i> &#x2014; material icon named "fire extinguisher" (outlined).
  static const IconData fire_extinguisher_outlined = IconData(0xf076, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fire_hydrant</i> &#x2014; material icon named "fire hydrant".
  static const IconData fire_hydrant = IconData(0xe289, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fireplace</i> &#x2014; material icon named "fireplace".
  static const IconData fireplace = IconData(0xe28a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fireplace</i> &#x2014; material icon named "fireplace" (sharp).
  static const IconData fireplace_sharp = IconData(0xe985, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fireplace</i> &#x2014; material icon named "fireplace" (round).
  static const IconData fireplace_rounded = IconData(0xf764, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fireplace</i> &#x2014; material icon named "fireplace" (outlined).
  static const IconData fireplace_outlined = IconData(0xf077, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">first_page</i> &#x2014; material icon named "first page".
  static const IconData first_page = IconData(0xe28b, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">first_page</i> &#x2014; material icon named "first page" (sharp).
  static const IconData first_page_sharp = IconData(0xe986, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">first_page</i> &#x2014; material icon named "first page" (round).
  static const IconData first_page_rounded = IconData(0xf765, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">first_page</i> &#x2014; material icon named "first page" (outlined).
  static const IconData first_page_outlined = IconData(0xf078, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">fit_screen</i> &#x2014; material icon named "fit screen".
  static const IconData fit_screen = IconData(0xe28c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fit_screen</i> &#x2014; material icon named "fit screen" (sharp).
  static const IconData fit_screen_sharp = IconData(0xe987, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fit_screen</i> &#x2014; material icon named "fit screen" (round).
  static const IconData fit_screen_rounded = IconData(0xf766, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fit_screen</i> &#x2014; material icon named "fit screen" (outlined).
  static const IconData fit_screen_outlined = IconData(0xf079, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fitness_center</i> &#x2014; material icon named "fitness center".
  static const IconData fitness_center = IconData(0xe28d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fitness_center</i> &#x2014; material icon named "fitness center" (sharp).
  static const IconData fitness_center_sharp = IconData(0xe988, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fitness_center</i> &#x2014; material icon named "fitness center" (round).
  static const IconData fitness_center_rounded = IconData(0xf767, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fitness_center</i> &#x2014; material icon named "fitness center" (outlined).
  static const IconData fitness_center_outlined = IconData(0xf07a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flag</i> &#x2014; material icon named "flag".
  static const IconData flag = IconData(0xe28e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flag</i> &#x2014; material icon named "flag" (sharp).
  static const IconData flag_sharp = IconData(0xe989, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flag</i> &#x2014; material icon named "flag" (round).
  static const IconData flag_rounded = IconData(0xf768, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">flag</i> &#x2014; material icon named "flag" (outlined).
  static const IconData flag_outlined = IconData(0xf07b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flaky</i> &#x2014; material icon named "flaky".
  static const IconData flaky = IconData(0xe28f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flaky</i> &#x2014; material icon named "flaky" (sharp).
  static const IconData flaky_sharp = IconData(0xe98a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flaky</i> &#x2014; material icon named "flaky" (round).
  static const IconData flaky_rounded = IconData(0xf769, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">flaky</i> &#x2014; material icon named "flaky" (outlined).
  static const IconData flaky_outlined = IconData(0xf07c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flare</i> &#x2014; material icon named "flare".
  static const IconData flare = IconData(0xe290, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flare</i> &#x2014; material icon named "flare" (sharp).
  static const IconData flare_sharp = IconData(0xe98b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flare</i> &#x2014; material icon named "flare" (round).
  static const IconData flare_rounded = IconData(0xf76a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">flare</i> &#x2014; material icon named "flare" (outlined).
  static const IconData flare_outlined = IconData(0xf07d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flash_auto</i> &#x2014; material icon named "flash auto".
  static const IconData flash_auto = IconData(0xe291, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flash_auto</i> &#x2014; material icon named "flash auto" (sharp).
  static const IconData flash_auto_sharp = IconData(0xe98c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flash_auto</i> &#x2014; material icon named "flash auto" (round).
  static const IconData flash_auto_rounded = IconData(0xf76b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">flash_auto</i> &#x2014; material icon named "flash auto" (outlined).
  static const IconData flash_auto_outlined = IconData(0xf07e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flash_off</i> &#x2014; material icon named "flash off".
  static const IconData flash_off = IconData(0xe292, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flash_off</i> &#x2014; material icon named "flash off" (sharp).
  static const IconData flash_off_sharp = IconData(0xe98d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flash_off</i> &#x2014; material icon named "flash off" (round).
  static const IconData flash_off_rounded = IconData(0xf76c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">flash_off</i> &#x2014; material icon named "flash off" (outlined).
  static const IconData flash_off_outlined = IconData(0xf07f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flash_on</i> &#x2014; material icon named "flash on".
  static const IconData flash_on = IconData(0xe293, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flash_on</i> &#x2014; material icon named "flash on" (sharp).
  static const IconData flash_on_sharp = IconData(0xe98e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flash_on</i> &#x2014; material icon named "flash on" (round).
  static const IconData flash_on_rounded = IconData(0xf76d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">flash_on</i> &#x2014; material icon named "flash on" (outlined).
  static const IconData flash_on_outlined = IconData(0xf080, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flashlight_off</i> &#x2014; material icon named "flashlight off".
  static const IconData flashlight_off = IconData(0xe294, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flashlight_off</i> &#x2014; material icon named "flashlight off" (sharp).
  static const IconData flashlight_off_sharp = IconData(0xe98f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flashlight_off</i> &#x2014; material icon named "flashlight off" (round).
  static const IconData flashlight_off_rounded = IconData(0xf76e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">flashlight_off</i> &#x2014; material icon named "flashlight off" (outlined).
  static const IconData flashlight_off_outlined = IconData(0xf081, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flashlight_on</i> &#x2014; material icon named "flashlight on".
  static const IconData flashlight_on = IconData(0xe295, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flashlight_on</i> &#x2014; material icon named "flashlight on" (sharp).
  static const IconData flashlight_on_sharp = IconData(0xe990, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flashlight_on</i> &#x2014; material icon named "flashlight on" (round).
  static const IconData flashlight_on_rounded = IconData(0xf76f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">flashlight_on</i> &#x2014; material icon named "flashlight on" (outlined).
  static const IconData flashlight_on_outlined = IconData(0xf082, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flatware</i> &#x2014; material icon named "flatware".
  static const IconData flatware = IconData(0xe296, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flatware</i> &#x2014; material icon named "flatware" (sharp).
  static const IconData flatware_sharp = IconData(0xe991, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flatware</i> &#x2014; material icon named "flatware" (round).
  static const IconData flatware_rounded = IconData(0xf770, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">flatware</i> &#x2014; material icon named "flatware" (outlined).
  static const IconData flatware_outlined = IconData(0xf083, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flight</i> &#x2014; material icon named "flight".
  static const IconData flight = IconData(0xe297, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flight</i> &#x2014; material icon named "flight" (sharp).
  static const IconData flight_sharp = IconData(0xe993, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flight</i> &#x2014; material icon named "flight" (round).
  static const IconData flight_rounded = IconData(0xf772, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">flight</i> &#x2014; material icon named "flight" (outlined).
  static const IconData flight_outlined = IconData(0xf085, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flight_land</i> &#x2014; material icon named "flight land".
  static const IconData flight_land = IconData(0xe298, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">flight_land</i> &#x2014; material icon named "flight land" (sharp).
  static const IconData flight_land_sharp = IconData(0xe992, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">flight_land</i> &#x2014; material icon named "flight land" (round).
  static const IconData flight_land_rounded = IconData(0xf771, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">flight_land</i> &#x2014; material icon named "flight land" (outlined).
  static const IconData flight_land_outlined = IconData(0xf084, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">flight_takeoff</i> &#x2014; material icon named "flight takeoff".
  static const IconData flight_takeoff = IconData(0xe299, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">flight_takeoff</i> &#x2014; material icon named "flight takeoff" (sharp).
  static const IconData flight_takeoff_sharp = IconData(0xe994, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">flight_takeoff</i> &#x2014; material icon named "flight takeoff" (round).
  static const IconData flight_takeoff_rounded = IconData(0xf773, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">flight_takeoff</i> &#x2014; material icon named "flight takeoff" (outlined).
  static const IconData flight_takeoff_outlined = IconData(0xf086, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">flip</i> &#x2014; material icon named "flip".
  static const IconData flip = IconData(0xe29a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flip</i> &#x2014; material icon named "flip" (sharp).
  static const IconData flip_sharp = IconData(0xe997, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flip</i> &#x2014; material icon named "flip" (round).
  static const IconData flip_rounded = IconData(0xf776, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">flip</i> &#x2014; material icon named "flip" (outlined).
  static const IconData flip_outlined = IconData(0xf089, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flip_camera_android</i> &#x2014; material icon named "flip camera android".
  static const IconData flip_camera_android = IconData(0xe29b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flip_camera_android</i> &#x2014; material icon named "flip camera android" (sharp).
  static const IconData flip_camera_android_sharp = IconData(0xe995, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flip_camera_android</i> &#x2014; material icon named "flip camera android" (round).
  static const IconData flip_camera_android_rounded = IconData(0xf774, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">flip_camera_android</i> &#x2014; material icon named "flip camera android" (outlined).
  static const IconData flip_camera_android_outlined = IconData(0xf087, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flip_camera_ios</i> &#x2014; material icon named "flip camera ios".
  static const IconData flip_camera_ios = IconData(0xe29c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flip_camera_ios</i> &#x2014; material icon named "flip camera ios" (sharp).
  static const IconData flip_camera_ios_sharp = IconData(0xe996, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flip_camera_ios</i> &#x2014; material icon named "flip camera ios" (round).
  static const IconData flip_camera_ios_rounded = IconData(0xf775, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">flip_camera_ios</i> &#x2014; material icon named "flip camera ios" (outlined).
  static const IconData flip_camera_ios_outlined = IconData(0xf088, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flip_to_back</i> &#x2014; material icon named "flip to back".
  static const IconData flip_to_back = IconData(0xe29d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flip_to_back</i> &#x2014; material icon named "flip to back" (sharp).
  static const IconData flip_to_back_sharp = IconData(0xe998, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flip_to_back</i> &#x2014; material icon named "flip to back" (round).
  static const IconData flip_to_back_rounded = IconData(0xf777, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">flip_to_back</i> &#x2014; material icon named "flip to back" (outlined).
  static const IconData flip_to_back_outlined = IconData(0xf08a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flip_to_front</i> &#x2014; material icon named "flip to front".
  static const IconData flip_to_front = IconData(0xe29e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flip_to_front</i> &#x2014; material icon named "flip to front" (sharp).
  static const IconData flip_to_front_sharp = IconData(0xe999, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flip_to_front</i> &#x2014; material icon named "flip to front" (round).
  static const IconData flip_to_front_rounded = IconData(0xf778, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">flip_to_front</i> &#x2014; material icon named "flip to front" (outlined).
  static const IconData flip_to_front_outlined = IconData(0xf08b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flourescent</i> &#x2014; material icon named "flourescent".
  static const IconData flourescent = IconData(0xe29f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flourescent</i> &#x2014; material icon named "flourescent" (sharp).
  static const IconData flourescent_sharp = IconData(0xe99a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flourescent</i> &#x2014; material icon named "flourescent" (round).
  static const IconData flourescent_rounded = IconData(0xf779, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">flourescent</i> &#x2014; material icon named "flourescent" (outlined).
  static const IconData flourescent_outlined = IconData(0xf08c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">flutter_dash</i> &#x2014; material icon named "flutter dash".
  static const IconData flutter_dash = IconData(0xe2a0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">flutter_dash</i> &#x2014; material icon named "flutter dash" (sharp).
  static const IconData flutter_dash_sharp = IconData(0xe99b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">flutter_dash</i> &#x2014; material icon named "flutter dash" (round).
  static const IconData flutter_dash_rounded = IconData(0xf77a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">flutter_dash</i> &#x2014; material icon named "flutter dash" (outlined).
  static const IconData flutter_dash_outlined = IconData(0xf08d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fmd_bad</i> &#x2014; material icon named "fmd bad".
  static const IconData fmd_bad = IconData(0xe2a1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fmd_bad</i> &#x2014; material icon named "fmd bad" (sharp).
  static const IconData fmd_bad_sharp = IconData(0xe99c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fmd_bad</i> &#x2014; material icon named "fmd bad" (round).
  static const IconData fmd_bad_rounded = IconData(0xf77b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fmd_bad</i> &#x2014; material icon named "fmd bad" (outlined).
  static const IconData fmd_bad_outlined = IconData(0xf08e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fmd_good</i> &#x2014; material icon named "fmd good".
  static const IconData fmd_good = IconData(0xe2a2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fmd_good</i> &#x2014; material icon named "fmd good" (sharp).
  static const IconData fmd_good_sharp = IconData(0xe99d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fmd_good</i> &#x2014; material icon named "fmd good" (round).
  static const IconData fmd_good_rounded = IconData(0xf77c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fmd_good</i> &#x2014; material icon named "fmd good" (outlined).
  static const IconData fmd_good_outlined = IconData(0xf08f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">folder</i> &#x2014; material icon named "folder".
  static const IconData folder = IconData(0xe2a3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">folder</i> &#x2014; material icon named "folder" (sharp).
  static const IconData folder_sharp = IconData(0xe9a0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">folder</i> &#x2014; material icon named "folder" (round).
  static const IconData folder_rounded = IconData(0xf77e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">folder</i> &#x2014; material icon named "folder" (outlined).
  static const IconData folder_outlined = IconData(0xf091, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">folder_open</i> &#x2014; material icon named "folder open".
  static const IconData folder_open = IconData(0xe2a4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">folder_open</i> &#x2014; material icon named "folder open" (sharp).
  static const IconData folder_open_sharp = IconData(0xe99e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">folder_open</i> &#x2014; material icon named "folder open" (round).
  static const IconData folder_open_rounded = IconData(0xf77d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">folder_open</i> &#x2014; material icon named "folder open" (outlined).
  static const IconData folder_open_outlined = IconData(0xf090, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">folder_shared</i> &#x2014; material icon named "folder shared".
  static const IconData folder_shared = IconData(0xe2a5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">folder_shared</i> &#x2014; material icon named "folder shared" (sharp).
  static const IconData folder_shared_sharp = IconData(0xe99f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">folder_shared</i> &#x2014; material icon named "folder shared" (round).
  static const IconData folder_shared_rounded = IconData(0xf77f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">folder_shared</i> &#x2014; material icon named "folder shared" (outlined).
  static const IconData folder_shared_outlined = IconData(0xf092, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">folder_special</i> &#x2014; material icon named "folder special".
  static const IconData folder_special = IconData(0xe2a6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">folder_special</i> &#x2014; material icon named "folder special" (sharp).
  static const IconData folder_special_sharp = IconData(0xe9a1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">folder_special</i> &#x2014; material icon named "folder special" (round).
  static const IconData folder_special_rounded = IconData(0xf780, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">folder_special</i> &#x2014; material icon named "folder special" (outlined).
  static const IconData folder_special_outlined = IconData(0xf093, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">follow_the_signs</i> &#x2014; material icon named "follow the signs".
  static const IconData follow_the_signs = IconData(0xe2a7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">follow_the_signs</i> &#x2014; material icon named "follow the signs" (sharp).
  static const IconData follow_the_signs_sharp = IconData(0xe9a2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">follow_the_signs</i> &#x2014; material icon named "follow the signs" (round).
  static const IconData follow_the_signs_rounded = IconData(0xf781, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">follow_the_signs</i> &#x2014; material icon named "follow the signs" (outlined).
  static const IconData follow_the_signs_outlined = IconData(0xf094, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">font_download</i> &#x2014; material icon named "font download".
  static const IconData font_download = IconData(0xe2a8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">font_download</i> &#x2014; material icon named "font download" (sharp).
  static const IconData font_download_sharp = IconData(0xe9a4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">font_download</i> &#x2014; material icon named "font download" (round).
  static const IconData font_download_rounded = IconData(0xf783, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">font_download</i> &#x2014; material icon named "font download" (outlined).
  static const IconData font_download_outlined = IconData(0xf096, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">font_download_off</i> &#x2014; material icon named "font download off".
  static const IconData font_download_off = IconData(0xe2a9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">font_download_off</i> &#x2014; material icon named "font download off" (sharp).
  static const IconData font_download_off_sharp = IconData(0xe9a3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">font_download_off</i> &#x2014; material icon named "font download off" (round).
  static const IconData font_download_off_rounded = IconData(0xf782, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">font_download_off</i> &#x2014; material icon named "font download off" (outlined).
  static const IconData font_download_off_outlined = IconData(0xf095, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">food_bank</i> &#x2014; material icon named "food bank".
  static const IconData food_bank = IconData(0xe2aa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">food_bank</i> &#x2014; material icon named "food bank" (sharp).
  static const IconData food_bank_sharp = IconData(0xe9a5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">food_bank</i> &#x2014; material icon named "food bank" (round).
  static const IconData food_bank_rounded = IconData(0xf784, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">food_bank</i> &#x2014; material icon named "food bank" (outlined).
  static const IconData food_bank_outlined = IconData(0xf097, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_align_center</i> &#x2014; material icon named "format align center".
  static const IconData format_align_center = IconData(0xe2ab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_align_center</i> &#x2014; material icon named "format align center" (sharp).
  static const IconData format_align_center_sharp = IconData(0xe9a6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_align_center</i> &#x2014; material icon named "format align center" (round).
  static const IconData format_align_center_rounded = IconData(0xf785, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_align_center</i> &#x2014; material icon named "format align center" (outlined).
  static const IconData format_align_center_outlined = IconData(0xf098, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_align_justify</i> &#x2014; material icon named "format align justify".
  static const IconData format_align_justify = IconData(0xe2ac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_align_justify</i> &#x2014; material icon named "format align justify" (sharp).
  static const IconData format_align_justify_sharp = IconData(0xe9a7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_align_justify</i> &#x2014; material icon named "format align justify" (round).
  static const IconData format_align_justify_rounded = IconData(0xf786, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_align_justify</i> &#x2014; material icon named "format align justify" (outlined).
  static const IconData format_align_justify_outlined = IconData(0xf099, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_align_left</i> &#x2014; material icon named "format align left".
  static const IconData format_align_left = IconData(0xe2ad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_align_left</i> &#x2014; material icon named "format align left" (sharp).
  static const IconData format_align_left_sharp = IconData(0xe9a8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_align_left</i> &#x2014; material icon named "format align left" (round).
  static const IconData format_align_left_rounded = IconData(0xf787, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_align_left</i> &#x2014; material icon named "format align left" (outlined).
  static const IconData format_align_left_outlined = IconData(0xf09a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_align_right</i> &#x2014; material icon named "format align right".
  static const IconData format_align_right = IconData(0xe2ae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_align_right</i> &#x2014; material icon named "format align right" (sharp).
  static const IconData format_align_right_sharp = IconData(0xe9a9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_align_right</i> &#x2014; material icon named "format align right" (round).
  static const IconData format_align_right_rounded = IconData(0xf788, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_align_right</i> &#x2014; material icon named "format align right" (outlined).
  static const IconData format_align_right_outlined = IconData(0xf09b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_bold</i> &#x2014; material icon named "format bold".
  static const IconData format_bold = IconData(0xe2af, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_bold</i> &#x2014; material icon named "format bold" (sharp).
  static const IconData format_bold_sharp = IconData(0xe9aa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_bold</i> &#x2014; material icon named "format bold" (round).
  static const IconData format_bold_rounded = IconData(0xf789, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_bold</i> &#x2014; material icon named "format bold" (outlined).
  static const IconData format_bold_outlined = IconData(0xf09c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_clear</i> &#x2014; material icon named "format clear".
  static const IconData format_clear = IconData(0xe2b0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_clear</i> &#x2014; material icon named "format clear" (sharp).
  static const IconData format_clear_sharp = IconData(0xe9ab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_clear</i> &#x2014; material icon named "format clear" (round).
  static const IconData format_clear_rounded = IconData(0xf78a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_clear</i> &#x2014; material icon named "format clear" (outlined).
  static const IconData format_clear_outlined = IconData(0xf09d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_color_fill</i> &#x2014; material icon named "format color fill".
  static const IconData format_color_fill = IconData(0xe2b1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_color_fill</i> &#x2014; material icon named "format color fill" (sharp).
  static const IconData format_color_fill_sharp = IconData(0xe9ac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_color_fill</i> &#x2014; material icon named "format color fill" (round).
  static const IconData format_color_fill_rounded = IconData(0xf78b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_color_fill</i> &#x2014; material icon named "format color fill" (outlined).
  static const IconData format_color_fill_outlined = IconData(0xf09e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_color_reset</i> &#x2014; material icon named "format color reset".
  static const IconData format_color_reset = IconData(0xe2b2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_color_reset</i> &#x2014; material icon named "format color reset" (sharp).
  static const IconData format_color_reset_sharp = IconData(0xe9ad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_color_reset</i> &#x2014; material icon named "format color reset" (round).
  static const IconData format_color_reset_rounded = IconData(0xf78c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_color_reset</i> &#x2014; material icon named "format color reset" (outlined).
  static const IconData format_color_reset_outlined = IconData(0xf09f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_color_text</i> &#x2014; material icon named "format color text".
  static const IconData format_color_text = IconData(0xe2b3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_color_text</i> &#x2014; material icon named "format color text" (sharp).
  static const IconData format_color_text_sharp = IconData(0xe9ae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_color_text</i> &#x2014; material icon named "format color text" (round).
  static const IconData format_color_text_rounded = IconData(0xf78d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_color_text</i> &#x2014; material icon named "format color text" (outlined).
  static const IconData format_color_text_outlined = IconData(0xf0a0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_indent_decrease</i> &#x2014; material icon named "format indent decrease".
  static const IconData format_indent_decrease = IconData(0xe2b4, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">format_indent_decrease</i> &#x2014; material icon named "format indent decrease" (sharp).
  static const IconData format_indent_decrease_sharp = IconData(0xe9af, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">format_indent_decrease</i> &#x2014; material icon named "format indent decrease" (round).
  static const IconData format_indent_decrease_rounded = IconData(0xf78e, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">format_indent_decrease</i> &#x2014; material icon named "format indent decrease" (outlined).
  static const IconData format_indent_decrease_outlined = IconData(0xf0a1, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">format_indent_increase</i> &#x2014; material icon named "format indent increase".
  static const IconData format_indent_increase = IconData(0xe2b5, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">format_indent_increase</i> &#x2014; material icon named "format indent increase" (sharp).
  static const IconData format_indent_increase_sharp = IconData(0xe9b0, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">format_indent_increase</i> &#x2014; material icon named "format indent increase" (round).
  static const IconData format_indent_increase_rounded = IconData(0xf78f, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">format_indent_increase</i> &#x2014; material icon named "format indent increase" (outlined).
  static const IconData format_indent_increase_outlined = IconData(0xf0a2, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">format_italic</i> &#x2014; material icon named "format italic".
  static const IconData format_italic = IconData(0xe2b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_italic</i> &#x2014; material icon named "format italic" (sharp).
  static const IconData format_italic_sharp = IconData(0xe9b1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_italic</i> &#x2014; material icon named "format italic" (round).
  static const IconData format_italic_rounded = IconData(0xf790, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_italic</i> &#x2014; material icon named "format italic" (outlined).
  static const IconData format_italic_outlined = IconData(0xf0a3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_line_spacing</i> &#x2014; material icon named "format line spacing".
  static const IconData format_line_spacing = IconData(0xe2b7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_line_spacing</i> &#x2014; material icon named "format line spacing" (sharp).
  static const IconData format_line_spacing_sharp = IconData(0xe9b2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_line_spacing</i> &#x2014; material icon named "format line spacing" (round).
  static const IconData format_line_spacing_rounded = IconData(0xf791, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_line_spacing</i> &#x2014; material icon named "format line spacing" (outlined).
  static const IconData format_line_spacing_outlined = IconData(0xf0a4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_list_bulleted</i> &#x2014; material icon named "format list bulleted".
  static const IconData format_list_bulleted = IconData(0xe2b8, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">format_list_bulleted</i> &#x2014; material icon named "format list bulleted" (sharp).
  static const IconData format_list_bulleted_sharp = IconData(0xe9b3, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">format_list_bulleted</i> &#x2014; material icon named "format list bulleted" (round).
  static const IconData format_list_bulleted_rounded = IconData(0xf792, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">format_list_bulleted</i> &#x2014; material icon named "format list bulleted" (outlined).
  static const IconData format_list_bulleted_outlined = IconData(0xf0a5, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">format_list_numbered</i> &#x2014; material icon named "format list numbered".
  static const IconData format_list_numbered = IconData(0xe2b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_list_numbered</i> &#x2014; material icon named "format list numbered" (sharp).
  static const IconData format_list_numbered_sharp = IconData(0xe9b5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_list_numbered</i> &#x2014; material icon named "format list numbered" (round).
  static const IconData format_list_numbered_rounded = IconData(0xf793, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_list_numbered</i> &#x2014; material icon named "format list numbered" (outlined).
  static const IconData format_list_numbered_outlined = IconData(0xf0a6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_list_numbered_rtl</i> &#x2014; material icon named "format list numbered rtl".
  static const IconData format_list_numbered_rtl = IconData(0xe2ba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_list_numbered_rtl</i> &#x2014; material icon named "format list numbered rtl" (sharp).
  static const IconData format_list_numbered_rtl_sharp = IconData(0xe9b4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_list_numbered_rtl</i> &#x2014; material icon named "format list numbered rtl" (round).
  static const IconData format_list_numbered_rtl_rounded = IconData(0xf794, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_list_numbered_rtl</i> &#x2014; material icon named "format list numbered rtl" (outlined).
  static const IconData format_list_numbered_rtl_outlined = IconData(0xf0a7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_paint</i> &#x2014; material icon named "format paint".
  static const IconData format_paint = IconData(0xe2bb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_paint</i> &#x2014; material icon named "format paint" (sharp).
  static const IconData format_paint_sharp = IconData(0xe9b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_paint</i> &#x2014; material icon named "format paint" (round).
  static const IconData format_paint_rounded = IconData(0xf795, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_paint</i> &#x2014; material icon named "format paint" (outlined).
  static const IconData format_paint_outlined = IconData(0xf0a8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_quote</i> &#x2014; material icon named "format quote".
  static const IconData format_quote = IconData(0xe2bc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_quote</i> &#x2014; material icon named "format quote" (sharp).
  static const IconData format_quote_sharp = IconData(0xe9b7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_quote</i> &#x2014; material icon named "format quote" (round).
  static const IconData format_quote_rounded = IconData(0xf796, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_quote</i> &#x2014; material icon named "format quote" (outlined).
  static const IconData format_quote_outlined = IconData(0xf0a9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_shapes</i> &#x2014; material icon named "format shapes".
  static const IconData format_shapes = IconData(0xe2bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_shapes</i> &#x2014; material icon named "format shapes" (sharp).
  static const IconData format_shapes_sharp = IconData(0xe9b8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_shapes</i> &#x2014; material icon named "format shapes" (round).
  static const IconData format_shapes_rounded = IconData(0xf797, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_shapes</i> &#x2014; material icon named "format shapes" (outlined).
  static const IconData format_shapes_outlined = IconData(0xf0aa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_size</i> &#x2014; material icon named "format size".
  static const IconData format_size = IconData(0xe2be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_size</i> &#x2014; material icon named "format size" (sharp).
  static const IconData format_size_sharp = IconData(0xe9b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_size</i> &#x2014; material icon named "format size" (round).
  static const IconData format_size_rounded = IconData(0xf798, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_size</i> &#x2014; material icon named "format size" (outlined).
  static const IconData format_size_outlined = IconData(0xf0ab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_strikethrough</i> &#x2014; material icon named "format strikethrough".
  static const IconData format_strikethrough = IconData(0xe2bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_strikethrough</i> &#x2014; material icon named "format strikethrough" (sharp).
  static const IconData format_strikethrough_sharp = IconData(0xe9ba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_strikethrough</i> &#x2014; material icon named "format strikethrough" (round).
  static const IconData format_strikethrough_rounded = IconData(0xf799, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_strikethrough</i> &#x2014; material icon named "format strikethrough" (outlined).
  static const IconData format_strikethrough_outlined = IconData(0xf0ac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_textdirection_l_to_r</i> &#x2014; material icon named "format textdirection l to r".
  static const IconData format_textdirection_l_to_r = IconData(0xe2c0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_textdirection_l_to_r</i> &#x2014; material icon named "format textdirection l to r" (sharp).
  static const IconData format_textdirection_l_to_r_sharp = IconData(0xe9bb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_textdirection_l_to_r</i> &#x2014; material icon named "format textdirection l to r" (round).
  static const IconData format_textdirection_l_to_r_rounded = IconData(0xf79a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_textdirection_l_to_r</i> &#x2014; material icon named "format textdirection l to r" (outlined).
  static const IconData format_textdirection_l_to_r_outlined = IconData(0xf0ad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_textdirection_r_to_l</i> &#x2014; material icon named "format textdirection r to l".
  static const IconData format_textdirection_r_to_l = IconData(0xe2c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_textdirection_r_to_l</i> &#x2014; material icon named "format textdirection r to l" (sharp).
  static const IconData format_textdirection_r_to_l_sharp = IconData(0xe9bc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_textdirection_r_to_l</i> &#x2014; material icon named "format textdirection r to l" (round).
  static const IconData format_textdirection_r_to_l_rounded = IconData(0xf79b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_textdirection_r_to_l</i> &#x2014; material icon named "format textdirection r to l" (outlined).
  static const IconData format_textdirection_r_to_l_outlined = IconData(0xf0ae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_underline</i> &#x2014; material icon named "format underline".
  static const IconData format_underline = IconData(0xe2c2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_underline</i> &#x2014; material icon named "format underline" (sharp).
  static const IconData format_underline_sharp = IconData(0xe9bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_underline</i> &#x2014; material icon named "format underline" (round).
  static const IconData format_underline_rounded = IconData(0xf79c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_underline</i> &#x2014; material icon named "format underline" (outlined).
  static const IconData format_underline_outlined = IconData(0xf0af, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">format_underlined</i> &#x2014; material icon named "format underlined".
  static const IconData format_underlined = IconData(0xe2c2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">format_underlined</i> &#x2014; material icon named "format underlined" (sharp).
  static const IconData format_underlined_sharp = IconData(0xe9bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">format_underlined</i> &#x2014; material icon named "format underlined" (round).
  static const IconData format_underlined_rounded = IconData(0xf79c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">format_underlined</i> &#x2014; material icon named "format underlined" (outlined).
  static const IconData format_underlined_outlined = IconData(0xf0af, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">forum</i> &#x2014; material icon named "forum".
  static const IconData forum = IconData(0xe2c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">forum</i> &#x2014; material icon named "forum" (sharp).
  static const IconData forum_sharp = IconData(0xe9be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">forum</i> &#x2014; material icon named "forum" (round).
  static const IconData forum_rounded = IconData(0xf79d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">forum</i> &#x2014; material icon named "forum" (outlined).
  static const IconData forum_outlined = IconData(0xf0b0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">forward</i> &#x2014; material icon named "forward".
  static const IconData forward = IconData(0xe2c4, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">forward</i> &#x2014; material icon named "forward" (sharp).
  static const IconData forward_sharp = IconData(0xe9c2, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">forward</i> &#x2014; material icon named "forward" (round).
  static const IconData forward_rounded = IconData(0xf7a1, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">forward</i> &#x2014; material icon named "forward" (outlined).
  static const IconData forward_outlined = IconData(0xf0b4, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">forward_10</i> &#x2014; material icon named "forward 10".
  static const IconData forward_10 = IconData(0xe2c5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">forward_10</i> &#x2014; material icon named "forward 10" (sharp).
  static const IconData forward_10_sharp = IconData(0xe9bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">forward_10</i> &#x2014; material icon named "forward 10" (round).
  static const IconData forward_10_rounded = IconData(0xf79e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">forward_10</i> &#x2014; material icon named "forward 10" (outlined).
  static const IconData forward_10_outlined = IconData(0xf0b1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">forward_30</i> &#x2014; material icon named "forward 30".
  static const IconData forward_30 = IconData(0xe2c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">forward_30</i> &#x2014; material icon named "forward 30" (sharp).
  static const IconData forward_30_sharp = IconData(0xe9c0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">forward_30</i> &#x2014; material icon named "forward 30" (round).
  static const IconData forward_30_rounded = IconData(0xf79f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">forward_30</i> &#x2014; material icon named "forward 30" (outlined).
  static const IconData forward_30_outlined = IconData(0xf0b2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">forward_5</i> &#x2014; material icon named "forward 5".
  static const IconData forward_5 = IconData(0xe2c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">forward_5</i> &#x2014; material icon named "forward 5" (sharp).
  static const IconData forward_5_sharp = IconData(0xe9c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">forward_5</i> &#x2014; material icon named "forward 5" (round).
  static const IconData forward_5_rounded = IconData(0xf7a0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">forward_5</i> &#x2014; material icon named "forward 5" (outlined).
  static const IconData forward_5_outlined = IconData(0xf0b3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">forward_to_inbox</i> &#x2014; material icon named "forward to inbox".
  static const IconData forward_to_inbox = IconData(0xe2c8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">forward_to_inbox</i> &#x2014; material icon named "forward to inbox" (sharp).
  static const IconData forward_to_inbox_sharp = IconData(0xe9c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">forward_to_inbox</i> &#x2014; material icon named "forward to inbox" (round).
  static const IconData forward_to_inbox_rounded = IconData(0xf7a2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">forward_to_inbox</i> &#x2014; material icon named "forward to inbox" (outlined).
  static const IconData forward_to_inbox_outlined = IconData(0xf0b5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">foundation</i> &#x2014; material icon named "foundation".
  static const IconData foundation = IconData(0xe2c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">foundation</i> &#x2014; material icon named "foundation" (sharp).
  static const IconData foundation_sharp = IconData(0xe9c4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">foundation</i> &#x2014; material icon named "foundation" (round).
  static const IconData foundation_rounded = IconData(0xf7a3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">foundation</i> &#x2014; material icon named "foundation" (outlined).
  static const IconData foundation_outlined = IconData(0xf0b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">free_breakfast</i> &#x2014; material icon named "free breakfast".
  static const IconData free_breakfast = IconData(0xe2ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">free_breakfast</i> &#x2014; material icon named "free breakfast" (sharp).
  static const IconData free_breakfast_sharp = IconData(0xe9c5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">free_breakfast</i> &#x2014; material icon named "free breakfast" (round).
  static const IconData free_breakfast_rounded = IconData(0xf7a4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">free_breakfast</i> &#x2014; material icon named "free breakfast" (outlined).
  static const IconData free_breakfast_outlined = IconData(0xf0b7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fullscreen</i> &#x2014; material icon named "fullscreen".
  static const IconData fullscreen = IconData(0xe2cb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fullscreen</i> &#x2014; material icon named "fullscreen" (sharp).
  static const IconData fullscreen_sharp = IconData(0xe9c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fullscreen</i> &#x2014; material icon named "fullscreen" (round).
  static const IconData fullscreen_rounded = IconData(0xf7a6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fullscreen</i> &#x2014; material icon named "fullscreen" (outlined).
  static const IconData fullscreen_outlined = IconData(0xf0b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">fullscreen_exit</i> &#x2014; material icon named "fullscreen exit".
  static const IconData fullscreen_exit = IconData(0xe2cc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">fullscreen_exit</i> &#x2014; material icon named "fullscreen exit" (sharp).
  static const IconData fullscreen_exit_sharp = IconData(0xe9c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">fullscreen_exit</i> &#x2014; material icon named "fullscreen exit" (round).
  static const IconData fullscreen_exit_rounded = IconData(0xf7a5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">fullscreen_exit</i> &#x2014; material icon named "fullscreen exit" (outlined).
  static const IconData fullscreen_exit_outlined = IconData(0xf0b8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">functions</i> &#x2014; material icon named "functions".
  static const IconData functions = IconData(0xe2cd, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">functions</i> &#x2014; material icon named "functions" (sharp).
  static const IconData functions_sharp = IconData(0xe9c8, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">functions</i> &#x2014; material icon named "functions" (round).
  static const IconData functions_rounded = IconData(0xf7a7, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">functions</i> &#x2014; material icon named "functions" (outlined).
  static const IconData functions_outlined = IconData(0xf0ba, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">g_mobiledata</i> &#x2014; material icon named "g mobiledata".
  static const IconData g_mobiledata = IconData(0xe2ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">g_mobiledata</i> &#x2014; material icon named "g mobiledata" (sharp).
  static const IconData g_mobiledata_sharp = IconData(0xe9c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">g_mobiledata</i> &#x2014; material icon named "g mobiledata" (round).
  static const IconData g_mobiledata_rounded = IconData(0xf7a8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">g_mobiledata</i> &#x2014; material icon named "g mobiledata" (outlined).
  static const IconData g_mobiledata_outlined = IconData(0xf0bb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">g_translate</i> &#x2014; material icon named "g translate".
  static const IconData g_translate = IconData(0xe2cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">g_translate</i> &#x2014; material icon named "g translate" (sharp).
  static const IconData g_translate_sharp = IconData(0xe9ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">g_translate</i> &#x2014; material icon named "g translate" (round).
  static const IconData g_translate_rounded = IconData(0xf7a9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">g_translate</i> &#x2014; material icon named "g translate" (outlined).
  static const IconData g_translate_outlined = IconData(0xf0bc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">gamepad</i> &#x2014; material icon named "gamepad".
  static const IconData gamepad = IconData(0xe2d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">gamepad</i> &#x2014; material icon named "gamepad" (sharp).
  static const IconData gamepad_sharp = IconData(0xe9cb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">gamepad</i> &#x2014; material icon named "gamepad" (round).
  static const IconData gamepad_rounded = IconData(0xf7aa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">gamepad</i> &#x2014; material icon named "gamepad" (outlined).
  static const IconData gamepad_outlined = IconData(0xf0bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">games</i> &#x2014; material icon named "games".
  static const IconData games = IconData(0xe2d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">games</i> &#x2014; material icon named "games" (sharp).
  static const IconData games_sharp = IconData(0xe9cc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">games</i> &#x2014; material icon named "games" (round).
  static const IconData games_rounded = IconData(0xf7ab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">games</i> &#x2014; material icon named "games" (outlined).
  static const IconData games_outlined = IconData(0xf0be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">garage</i> &#x2014; material icon named "garage".
  static const IconData garage = IconData(0xe2d2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">garage</i> &#x2014; material icon named "garage" (sharp).
  static const IconData garage_sharp = IconData(0xe9cd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">garage</i> &#x2014; material icon named "garage" (round).
  static const IconData garage_rounded = IconData(0xf7ac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">garage</i> &#x2014; material icon named "garage" (outlined).
  static const IconData garage_outlined = IconData(0xf0bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">gavel</i> &#x2014; material icon named "gavel".
  static const IconData gavel = IconData(0xe2d3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">gavel</i> &#x2014; material icon named "gavel" (sharp).
  static const IconData gavel_sharp = IconData(0xe9ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">gavel</i> &#x2014; material icon named "gavel" (round).
  static const IconData gavel_rounded = IconData(0xf7ad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">gavel</i> &#x2014; material icon named "gavel" (outlined).
  static const IconData gavel_outlined = IconData(0xf0c0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">gesture</i> &#x2014; material icon named "gesture".
  static const IconData gesture = IconData(0xe2d4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">gesture</i> &#x2014; material icon named "gesture" (sharp).
  static const IconData gesture_sharp = IconData(0xe9cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">gesture</i> &#x2014; material icon named "gesture" (round).
  static const IconData gesture_rounded = IconData(0xf7ae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">gesture</i> &#x2014; material icon named "gesture" (outlined).
  static const IconData gesture_outlined = IconData(0xf0c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">get_app</i> &#x2014; material icon named "get app".
  static const IconData get_app = IconData(0xe2d5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">get_app</i> &#x2014; material icon named "get app" (sharp).
  static const IconData get_app_sharp = IconData(0xe9d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">get_app</i> &#x2014; material icon named "get app" (round).
  static const IconData get_app_rounded = IconData(0xf7af, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">get_app</i> &#x2014; material icon named "get app" (outlined).
  static const IconData get_app_outlined = IconData(0xf0c2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">gif</i> &#x2014; material icon named "gif".
  static const IconData gif = IconData(0xe2d6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">gif</i> &#x2014; material icon named "gif" (sharp).
  static const IconData gif_sharp = IconData(0xe9d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">gif</i> &#x2014; material icon named "gif" (round).
  static const IconData gif_rounded = IconData(0xf7b0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">gif</i> &#x2014; material icon named "gif" (outlined).
  static const IconData gif_outlined = IconData(0xf0c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">gite</i> &#x2014; material icon named "gite".
  static const IconData gite = IconData(0xe2d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">gite</i> &#x2014; material icon named "gite" (sharp).
  static const IconData gite_sharp = IconData(0xe9d2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">gite</i> &#x2014; material icon named "gite" (round).
  static const IconData gite_rounded = IconData(0xf7b1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">gite</i> &#x2014; material icon named "gite" (outlined).
  static const IconData gite_outlined = IconData(0xf0c4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">golf_course</i> &#x2014; material icon named "golf course".
  static const IconData golf_course = IconData(0xe2d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">golf_course</i> &#x2014; material icon named "golf course" (sharp).
  static const IconData golf_course_sharp = IconData(0xe9d3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">golf_course</i> &#x2014; material icon named "golf course" (round).
  static const IconData golf_course_rounded = IconData(0xf7b2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">golf_course</i> &#x2014; material icon named "golf course" (outlined).
  static const IconData golf_course_outlined = IconData(0xf0c5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">gpp_bad</i> &#x2014; material icon named "gpp bad".
  static const IconData gpp_bad = IconData(0xe2d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">gpp_bad</i> &#x2014; material icon named "gpp bad" (sharp).
  static const IconData gpp_bad_sharp = IconData(0xe9d4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">gpp_bad</i> &#x2014; material icon named "gpp bad" (round).
  static const IconData gpp_bad_rounded = IconData(0xf7b3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">gpp_bad</i> &#x2014; material icon named "gpp bad" (outlined).
  static const IconData gpp_bad_outlined = IconData(0xf0c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">gpp_good</i> &#x2014; material icon named "gpp good".
  static const IconData gpp_good = IconData(0xe2da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">gpp_good</i> &#x2014; material icon named "gpp good" (sharp).
  static const IconData gpp_good_sharp = IconData(0xe9d5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">gpp_good</i> &#x2014; material icon named "gpp good" (round).
  static const IconData gpp_good_rounded = IconData(0xf7b4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">gpp_good</i> &#x2014; material icon named "gpp good" (outlined).
  static const IconData gpp_good_outlined = IconData(0xf0c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">gpp_maybe</i> &#x2014; material icon named "gpp maybe".
  static const IconData gpp_maybe = IconData(0xe2db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">gpp_maybe</i> &#x2014; material icon named "gpp maybe" (sharp).
  static const IconData gpp_maybe_sharp = IconData(0xe9d6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">gpp_maybe</i> &#x2014; material icon named "gpp maybe" (round).
  static const IconData gpp_maybe_rounded = IconData(0xf7b5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">gpp_maybe</i> &#x2014; material icon named "gpp maybe" (outlined).
  static const IconData gpp_maybe_outlined = IconData(0xf0c8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">gps_fixed</i> &#x2014; material icon named "gps fixed".
  static const IconData gps_fixed = IconData(0xe2dc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">gps_fixed</i> &#x2014; material icon named "gps fixed" (sharp).
  static const IconData gps_fixed_sharp = IconData(0xe9d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">gps_fixed</i> &#x2014; material icon named "gps fixed" (round).
  static const IconData gps_fixed_rounded = IconData(0xf7b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">gps_fixed</i> &#x2014; material icon named "gps fixed" (outlined).
  static const IconData gps_fixed_outlined = IconData(0xf0c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">gps_not_fixed</i> &#x2014; material icon named "gps not fixed".
  static const IconData gps_not_fixed = IconData(0xe2dd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">gps_not_fixed</i> &#x2014; material icon named "gps not fixed" (sharp).
  static const IconData gps_not_fixed_sharp = IconData(0xe9d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">gps_not_fixed</i> &#x2014; material icon named "gps not fixed" (round).
  static const IconData gps_not_fixed_rounded = IconData(0xf7b7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">gps_not_fixed</i> &#x2014; material icon named "gps not fixed" (outlined).
  static const IconData gps_not_fixed_outlined = IconData(0xf0ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">gps_off</i> &#x2014; material icon named "gps off".
  static const IconData gps_off = IconData(0xe2de, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">gps_off</i> &#x2014; material icon named "gps off" (sharp).
  static const IconData gps_off_sharp = IconData(0xe9d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">gps_off</i> &#x2014; material icon named "gps off" (round).
  static const IconData gps_off_rounded = IconData(0xf7b8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">gps_off</i> &#x2014; material icon named "gps off" (outlined).
  static const IconData gps_off_outlined = IconData(0xf0cb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">grade</i> &#x2014; material icon named "grade".
  static const IconData grade = IconData(0xe2df, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">grade</i> &#x2014; material icon named "grade" (sharp).
  static const IconData grade_sharp = IconData(0xe9da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">grade</i> &#x2014; material icon named "grade" (round).
  static const IconData grade_rounded = IconData(0xf7b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">grade</i> &#x2014; material icon named "grade" (outlined).
  static const IconData grade_outlined = IconData(0xf0cc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">gradient</i> &#x2014; material icon named "gradient".
  static const IconData gradient = IconData(0xe2e0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">gradient</i> &#x2014; material icon named "gradient" (sharp).
  static const IconData gradient_sharp = IconData(0xe9db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">gradient</i> &#x2014; material icon named "gradient" (round).
  static const IconData gradient_rounded = IconData(0xf7ba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">gradient</i> &#x2014; material icon named "gradient" (outlined).
  static const IconData gradient_outlined = IconData(0xf0cd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">grading</i> &#x2014; material icon named "grading".
  static const IconData grading = IconData(0xe2e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">grading</i> &#x2014; material icon named "grading" (sharp).
  static const IconData grading_sharp = IconData(0xe9dc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">grading</i> &#x2014; material icon named "grading" (round).
  static const IconData grading_rounded = IconData(0xf7bb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">grading</i> &#x2014; material icon named "grading" (outlined).
  static const IconData grading_outlined = IconData(0xf0ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">grain</i> &#x2014; material icon named "grain".
  static const IconData grain = IconData(0xe2e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">grain</i> &#x2014; material icon named "grain" (sharp).
  static const IconData grain_sharp = IconData(0xe9dd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">grain</i> &#x2014; material icon named "grain" (round).
  static const IconData grain_rounded = IconData(0xf7bc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">grain</i> &#x2014; material icon named "grain" (outlined).
  static const IconData grain_outlined = IconData(0xf0cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">graphic_eq</i> &#x2014; material icon named "graphic eq".
  static const IconData graphic_eq = IconData(0xe2e3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">graphic_eq</i> &#x2014; material icon named "graphic eq" (sharp).
  static const IconData graphic_eq_sharp = IconData(0xe9de, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">graphic_eq</i> &#x2014; material icon named "graphic eq" (round).
  static const IconData graphic_eq_rounded = IconData(0xf7bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">graphic_eq</i> &#x2014; material icon named "graphic eq" (outlined).
  static const IconData graphic_eq_outlined = IconData(0xf0d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">grass</i> &#x2014; material icon named "grass".
  static const IconData grass = IconData(0xe2e4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">grass</i> &#x2014; material icon named "grass" (sharp).
  static const IconData grass_sharp = IconData(0xe9df, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">grass</i> &#x2014; material icon named "grass" (round).
  static const IconData grass_rounded = IconData(0xf7be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">grass</i> &#x2014; material icon named "grass" (outlined).
  static const IconData grass_outlined = IconData(0xf0d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">grid_3x3</i> &#x2014; material icon named "grid 3x3".
  static const IconData grid_3x3 = IconData(0xe2e5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">grid_3x3</i> &#x2014; material icon named "grid 3x3" (sharp).
  static const IconData grid_3x3_sharp = IconData(0xe9e0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">grid_3x3</i> &#x2014; material icon named "grid 3x3" (round).
  static const IconData grid_3x3_rounded = IconData(0xf7bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">grid_3x3</i> &#x2014; material icon named "grid 3x3" (outlined).
  static const IconData grid_3x3_outlined = IconData(0xf0d2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">grid_4x4</i> &#x2014; material icon named "grid 4x4".
  static const IconData grid_4x4 = IconData(0xe2e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">grid_4x4</i> &#x2014; material icon named "grid 4x4" (sharp).
  static const IconData grid_4x4_sharp = IconData(0xe9e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">grid_4x4</i> &#x2014; material icon named "grid 4x4" (round).
  static const IconData grid_4x4_rounded = IconData(0xf7c0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">grid_4x4</i> &#x2014; material icon named "grid 4x4" (outlined).
  static const IconData grid_4x4_outlined = IconData(0xf0d3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">grid_goldenratio</i> &#x2014; material icon named "grid goldenratio".
  static const IconData grid_goldenratio = IconData(0xe2e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">grid_goldenratio</i> &#x2014; material icon named "grid goldenratio" (sharp).
  static const IconData grid_goldenratio_sharp = IconData(0xe9e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">grid_goldenratio</i> &#x2014; material icon named "grid goldenratio" (round).
  static const IconData grid_goldenratio_rounded = IconData(0xf7c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">grid_goldenratio</i> &#x2014; material icon named "grid goldenratio" (outlined).
  static const IconData grid_goldenratio_outlined = IconData(0xf0d4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">grid_off</i> &#x2014; material icon named "grid off".
  static const IconData grid_off = IconData(0xe2e8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">grid_off</i> &#x2014; material icon named "grid off" (sharp).
  static const IconData grid_off_sharp = IconData(0xe9e3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">grid_off</i> &#x2014; material icon named "grid off" (round).
  static const IconData grid_off_rounded = IconData(0xf7c2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">grid_off</i> &#x2014; material icon named "grid off" (outlined).
  static const IconData grid_off_outlined = IconData(0xf0d5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">grid_on</i> &#x2014; material icon named "grid on".
  static const IconData grid_on = IconData(0xe2e9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">grid_on</i> &#x2014; material icon named "grid on" (sharp).
  static const IconData grid_on_sharp = IconData(0xe9e4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">grid_on</i> &#x2014; material icon named "grid on" (round).
  static const IconData grid_on_rounded = IconData(0xf7c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">grid_on</i> &#x2014; material icon named "grid on" (outlined).
  static const IconData grid_on_outlined = IconData(0xf0d6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">grid_view</i> &#x2014; material icon named "grid view".
  static const IconData grid_view = IconData(0xe2ea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">grid_view</i> &#x2014; material icon named "grid view" (sharp).
  static const IconData grid_view_sharp = IconData(0xe9e5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">grid_view</i> &#x2014; material icon named "grid view" (round).
  static const IconData grid_view_rounded = IconData(0xf7c4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">grid_view</i> &#x2014; material icon named "grid view" (outlined).
  static const IconData grid_view_outlined = IconData(0xf0d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">group</i> &#x2014; material icon named "group".
  static const IconData group = IconData(0xe2eb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">group</i> &#x2014; material icon named "group" (sharp).
  static const IconData group_sharp = IconData(0xe9e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">group</i> &#x2014; material icon named "group" (round).
  static const IconData group_rounded = IconData(0xf7c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">group</i> &#x2014; material icon named "group" (outlined).
  static const IconData group_outlined = IconData(0xf0d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">group_add</i> &#x2014; material icon named "group add".
  static const IconData group_add = IconData(0xe2ec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">group_add</i> &#x2014; material icon named "group add" (sharp).
  static const IconData group_add_sharp = IconData(0xe9e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">group_add</i> &#x2014; material icon named "group add" (round).
  static const IconData group_add_rounded = IconData(0xf7c5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">group_add</i> &#x2014; material icon named "group add" (outlined).
  static const IconData group_add_outlined = IconData(0xf0d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">group_work</i> &#x2014; material icon named "group work".
  static const IconData group_work = IconData(0xe2ed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">group_work</i> &#x2014; material icon named "group work" (sharp).
  static const IconData group_work_sharp = IconData(0xe9e8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">group_work</i> &#x2014; material icon named "group work" (round).
  static const IconData group_work_rounded = IconData(0xf7c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">group_work</i> &#x2014; material icon named "group work" (outlined).
  static const IconData group_work_outlined = IconData(0xf0da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">groups</i> &#x2014; material icon named "groups".
  static const IconData groups = IconData(0xe2ee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">groups</i> &#x2014; material icon named "groups" (sharp).
  static const IconData groups_sharp = IconData(0xe9e9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">groups</i> &#x2014; material icon named "groups" (round).
  static const IconData groups_rounded = IconData(0xf7c8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">groups</i> &#x2014; material icon named "groups" (outlined).
  static const IconData groups_outlined = IconData(0xf0db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">h_mobiledata</i> &#x2014; material icon named "h mobiledata".
  static const IconData h_mobiledata = IconData(0xe2ef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">h_mobiledata</i> &#x2014; material icon named "h mobiledata" (sharp).
  static const IconData h_mobiledata_sharp = IconData(0xe9ea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">h_mobiledata</i> &#x2014; material icon named "h mobiledata" (round).
  static const IconData h_mobiledata_rounded = IconData(0xf7c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">h_mobiledata</i> &#x2014; material icon named "h mobiledata" (outlined).
  static const IconData h_mobiledata_outlined = IconData(0xf0dc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">h_plus_mobiledata</i> &#x2014; material icon named "h plus mobiledata".
  static const IconData h_plus_mobiledata = IconData(0xe2f0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">h_plus_mobiledata</i> &#x2014; material icon named "h plus mobiledata" (sharp).
  static const IconData h_plus_mobiledata_sharp = IconData(0xe9eb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">h_plus_mobiledata</i> &#x2014; material icon named "h plus mobiledata" (round).
  static const IconData h_plus_mobiledata_rounded = IconData(0xf7ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">h_plus_mobiledata</i> &#x2014; material icon named "h plus mobiledata" (outlined).
  static const IconData h_plus_mobiledata_outlined = IconData(0xf0dd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hail</i> &#x2014; material icon named "hail".
  static const IconData hail = IconData(0xe2f1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hail</i> &#x2014; material icon named "hail" (sharp).
  static const IconData hail_sharp = IconData(0xe9ec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hail</i> &#x2014; material icon named "hail" (round).
  static const IconData hail_rounded = IconData(0xf7cb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hail</i> &#x2014; material icon named "hail" (outlined).
  static const IconData hail_outlined = IconData(0xf0de, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">handyman</i> &#x2014; material icon named "handyman".
  static const IconData handyman = IconData(0xe2f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">handyman</i> &#x2014; material icon named "handyman" (sharp).
  static const IconData handyman_sharp = IconData(0xe9ed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">handyman</i> &#x2014; material icon named "handyman" (round).
  static const IconData handyman_rounded = IconData(0xf7cc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">handyman</i> &#x2014; material icon named "handyman" (outlined).
  static const IconData handyman_outlined = IconData(0xf0df, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hardware</i> &#x2014; material icon named "hardware".
  static const IconData hardware = IconData(0xe2f3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hardware</i> &#x2014; material icon named "hardware" (sharp).
  static const IconData hardware_sharp = IconData(0xe9ee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hardware</i> &#x2014; material icon named "hardware" (round).
  static const IconData hardware_rounded = IconData(0xf7cd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hardware</i> &#x2014; material icon named "hardware" (outlined).
  static const IconData hardware_outlined = IconData(0xf0e0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hd</i> &#x2014; material icon named "hd".
  static const IconData hd = IconData(0xe2f4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hd</i> &#x2014; material icon named "hd" (sharp).
  static const IconData hd_sharp = IconData(0xe9ef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hd</i> &#x2014; material icon named "hd" (round).
  static const IconData hd_rounded = IconData(0xf7ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hd</i> &#x2014; material icon named "hd" (outlined).
  static const IconData hd_outlined = IconData(0xf0e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hdr_auto</i> &#x2014; material icon named "hdr auto".
  static const IconData hdr_auto = IconData(0xe2f5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hdr_auto</i> &#x2014; material icon named "hdr auto" (sharp).
  static const IconData hdr_auto_sharp = IconData(0xe9f1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hdr_auto</i> &#x2014; material icon named "hdr auto" (round).
  static const IconData hdr_auto_rounded = IconData(0xf7cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hdr_auto</i> &#x2014; material icon named "hdr auto" (outlined).
  static const IconData hdr_auto_outlined = IconData(0xf0e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hdr_auto_select</i> &#x2014; material icon named "hdr auto select".
  static const IconData hdr_auto_select = IconData(0xe2f6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hdr_auto_select</i> &#x2014; material icon named "hdr auto select" (sharp).
  static const IconData hdr_auto_select_sharp = IconData(0xe9f0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hdr_auto_select</i> &#x2014; material icon named "hdr auto select" (round).
  static const IconData hdr_auto_select_rounded = IconData(0xf7d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hdr_auto_select</i> &#x2014; material icon named "hdr auto select" (outlined).
  static const IconData hdr_auto_select_outlined = IconData(0xf0e3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hdr_enhanced_select</i> &#x2014; material icon named "hdr enhanced select".
  static const IconData hdr_enhanced_select = IconData(0xe2f7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hdr_enhanced_select</i> &#x2014; material icon named "hdr enhanced select" (sharp).
  static const IconData hdr_enhanced_select_sharp = IconData(0xe9f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hdr_enhanced_select</i> &#x2014; material icon named "hdr enhanced select" (round).
  static const IconData hdr_enhanced_select_rounded = IconData(0xf7d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hdr_enhanced_select</i> &#x2014; material icon named "hdr enhanced select" (outlined).
  static const IconData hdr_enhanced_select_outlined = IconData(0xf0e4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hdr_off</i> &#x2014; material icon named "hdr off".
  static const IconData hdr_off = IconData(0xe2f8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hdr_off</i> &#x2014; material icon named "hdr off" (sharp).
  static const IconData hdr_off_sharp = IconData(0xe9f4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hdr_off</i> &#x2014; material icon named "hdr off" (round).
  static const IconData hdr_off_rounded = IconData(0xf7d2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hdr_off</i> &#x2014; material icon named "hdr off" (outlined).
  static const IconData hdr_off_outlined = IconData(0xf0e5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hdr_off_select</i> &#x2014; material icon named "hdr off select".
  static const IconData hdr_off_select = IconData(0xe2f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hdr_off_select</i> &#x2014; material icon named "hdr off select" (sharp).
  static const IconData hdr_off_select_sharp = IconData(0xe9f3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hdr_off_select</i> &#x2014; material icon named "hdr off select" (round).
  static const IconData hdr_off_select_rounded = IconData(0xf7d3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hdr_off_select</i> &#x2014; material icon named "hdr off select" (outlined).
  static const IconData hdr_off_select_outlined = IconData(0xf0e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hdr_on</i> &#x2014; material icon named "hdr on".
  static const IconData hdr_on = IconData(0xe2fa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hdr_on</i> &#x2014; material icon named "hdr on" (sharp).
  static const IconData hdr_on_sharp = IconData(0xe9f6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hdr_on</i> &#x2014; material icon named "hdr on" (round).
  static const IconData hdr_on_rounded = IconData(0xf7d4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hdr_on</i> &#x2014; material icon named "hdr on" (outlined).
  static const IconData hdr_on_outlined = IconData(0xf0e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hdr_on_select</i> &#x2014; material icon named "hdr on select".
  static const IconData hdr_on_select = IconData(0xe2fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hdr_on_select</i> &#x2014; material icon named "hdr on select" (sharp).
  static const IconData hdr_on_select_sharp = IconData(0xe9f5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hdr_on_select</i> &#x2014; material icon named "hdr on select" (round).
  static const IconData hdr_on_select_rounded = IconData(0xf7d5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hdr_on_select</i> &#x2014; material icon named "hdr on select" (outlined).
  static const IconData hdr_on_select_outlined = IconData(0xf0e8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hdr_plus</i> &#x2014; material icon named "hdr plus".
  static const IconData hdr_plus = IconData(0xe2fc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hdr_plus</i> &#x2014; material icon named "hdr plus" (sharp).
  static const IconData hdr_plus_sharp = IconData(0xe9f7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hdr_plus</i> &#x2014; material icon named "hdr plus" (round).
  static const IconData hdr_plus_rounded = IconData(0xf7d6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hdr_plus</i> &#x2014; material icon named "hdr plus" (outlined).
  static const IconData hdr_plus_outlined = IconData(0xf0e9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hdr_strong</i> &#x2014; material icon named "hdr strong".
  static const IconData hdr_strong = IconData(0xe2fd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hdr_strong</i> &#x2014; material icon named "hdr strong" (sharp).
  static const IconData hdr_strong_sharp = IconData(0xe9f8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hdr_strong</i> &#x2014; material icon named "hdr strong" (round).
  static const IconData hdr_strong_rounded = IconData(0xf7d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hdr_strong</i> &#x2014; material icon named "hdr strong" (outlined).
  static const IconData hdr_strong_outlined = IconData(0xf0ea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hdr_weak</i> &#x2014; material icon named "hdr weak".
  static const IconData hdr_weak = IconData(0xe2fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hdr_weak</i> &#x2014; material icon named "hdr weak" (sharp).
  static const IconData hdr_weak_sharp = IconData(0xe9f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hdr_weak</i> &#x2014; material icon named "hdr weak" (round).
  static const IconData hdr_weak_rounded = IconData(0xf7d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hdr_weak</i> &#x2014; material icon named "hdr weak" (outlined).
  static const IconData hdr_weak_outlined = IconData(0xf0eb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">headphones</i> &#x2014; material icon named "headphones".
  static const IconData headphones = IconData(0xe2ff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">headphones</i> &#x2014; material icon named "headphones" (sharp).
  static const IconData headphones_sharp = IconData(0xe9fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">headphones</i> &#x2014; material icon named "headphones" (round).
  static const IconData headphones_rounded = IconData(0xf7da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">headphones</i> &#x2014; material icon named "headphones" (outlined).
  static const IconData headphones_outlined = IconData(0xf0ed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">headphones_battery</i> &#x2014; material icon named "headphones battery".
  static const IconData headphones_battery = IconData(0xe300, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">headphones_battery</i> &#x2014; material icon named "headphones battery" (sharp).
  static const IconData headphones_battery_sharp = IconData(0xe9fa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">headphones_battery</i> &#x2014; material icon named "headphones battery" (round).
  static const IconData headphones_battery_rounded = IconData(0xf7d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">headphones_battery</i> &#x2014; material icon named "headphones battery" (outlined).
  static const IconData headphones_battery_outlined = IconData(0xf0ec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">headset</i> &#x2014; material icon named "headset".
  static const IconData headset = IconData(0xe301, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">headset</i> &#x2014; material icon named "headset" (sharp).
  static const IconData headset_sharp = IconData(0xe9fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">headset</i> &#x2014; material icon named "headset" (round).
  static const IconData headset_rounded = IconData(0xf7dd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">headset</i> &#x2014; material icon named "headset" (outlined).
  static const IconData headset_outlined = IconData(0xf0f0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">headset_mic</i> &#x2014; material icon named "headset mic".
  static const IconData headset_mic = IconData(0xe302, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">headset_mic</i> &#x2014; material icon named "headset mic" (sharp).
  static const IconData headset_mic_sharp = IconData(0xe9fc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">headset_mic</i> &#x2014; material icon named "headset mic" (round).
  static const IconData headset_mic_rounded = IconData(0xf7db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">headset_mic</i> &#x2014; material icon named "headset mic" (outlined).
  static const IconData headset_mic_outlined = IconData(0xf0ee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">headset_off</i> &#x2014; material icon named "headset off".
  static const IconData headset_off = IconData(0xe303, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">headset_off</i> &#x2014; material icon named "headset off" (sharp).
  static const IconData headset_off_sharp = IconData(0xe9fd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">headset_off</i> &#x2014; material icon named "headset off" (round).
  static const IconData headset_off_rounded = IconData(0xf7dc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">headset_off</i> &#x2014; material icon named "headset off" (outlined).
  static const IconData headset_off_outlined = IconData(0xf0ef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">healing</i> &#x2014; material icon named "healing".
  static const IconData healing = IconData(0xe304, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">healing</i> &#x2014; material icon named "healing" (sharp).
  static const IconData healing_sharp = IconData(0xe9ff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">healing</i> &#x2014; material icon named "healing" (round).
  static const IconData healing_rounded = IconData(0xf7de, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">healing</i> &#x2014; material icon named "healing" (outlined).
  static const IconData healing_outlined = IconData(0xf0f1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">health_and_safety</i> &#x2014; material icon named "health and safety".
  static const IconData health_and_safety = IconData(0xe305, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">health_and_safety</i> &#x2014; material icon named "health and safety" (sharp).
  static const IconData health_and_safety_sharp = IconData(0xea00, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">health_and_safety</i> &#x2014; material icon named "health and safety" (round).
  static const IconData health_and_safety_rounded = IconData(0xf7df, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">health_and_safety</i> &#x2014; material icon named "health and safety" (outlined).
  static const IconData health_and_safety_outlined = IconData(0xf0f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hearing</i> &#x2014; material icon named "hearing".
  static const IconData hearing = IconData(0xe306, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hearing</i> &#x2014; material icon named "hearing" (sharp).
  static const IconData hearing_sharp = IconData(0xea02, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hearing</i> &#x2014; material icon named "hearing" (round).
  static const IconData hearing_rounded = IconData(0xf7e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hearing</i> &#x2014; material icon named "hearing" (outlined).
  static const IconData hearing_outlined = IconData(0xf0f4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hearing_disabled</i> &#x2014; material icon named "hearing disabled".
  static const IconData hearing_disabled = IconData(0xe307, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hearing_disabled</i> &#x2014; material icon named "hearing disabled" (sharp).
  static const IconData hearing_disabled_sharp = IconData(0xea01, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hearing_disabled</i> &#x2014; material icon named "hearing disabled" (round).
  static const IconData hearing_disabled_rounded = IconData(0xf7e0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hearing_disabled</i> &#x2014; material icon named "hearing disabled" (outlined).
  static const IconData hearing_disabled_outlined = IconData(0xf0f3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">height</i> &#x2014; material icon named "height".
  static const IconData height = IconData(0xe308, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">height</i> &#x2014; material icon named "height" (sharp).
  static const IconData height_sharp = IconData(0xea03, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">height</i> &#x2014; material icon named "height" (round).
  static const IconData height_rounded = IconData(0xf7e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">height</i> &#x2014; material icon named "height" (outlined).
  static const IconData height_outlined = IconData(0xf0f5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">help</i> &#x2014; material icon named "help".
  static const IconData help = IconData(0xe309, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">help</i> &#x2014; material icon named "help" (sharp).
  static const IconData help_sharp = IconData(0xea06, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">help</i> &#x2014; material icon named "help" (round).
  static const IconData help_rounded = IconData(0xf7e5, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">help</i> &#x2014; material icon named "help" (outlined).
  static const IconData help_outlined = IconData(0xf0f8, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">help_center</i> &#x2014; material icon named "help center".
  static const IconData help_center = IconData(0xe30a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">help_center</i> &#x2014; material icon named "help center" (sharp).
  static const IconData help_center_sharp = IconData(0xea04, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">help_center</i> &#x2014; material icon named "help center" (round).
  static const IconData help_center_rounded = IconData(0xf7e3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">help_center</i> &#x2014; material icon named "help center" (outlined).
  static const IconData help_center_outlined = IconData(0xf0f6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">help_outline</i> &#x2014; material icon named "help outline".
  static const IconData help_outline = IconData(0xe30b, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">help_outline</i> &#x2014; material icon named "help outline" (sharp).
  static const IconData help_outline_sharp = IconData(0xea05, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">help_outline</i> &#x2014; material icon named "help outline" (round).
  static const IconData help_outline_rounded = IconData(0xf7e4, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">help_outline</i> &#x2014; material icon named "help outline" (outlined).
  static const IconData help_outline_outlined = IconData(0xf0f7, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">hevc</i> &#x2014; material icon named "hevc".
  static const IconData hevc = IconData(0xe30c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hevc</i> &#x2014; material icon named "hevc" (sharp).
  static const IconData hevc_sharp = IconData(0xea07, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hevc</i> &#x2014; material icon named "hevc" (round).
  static const IconData hevc_rounded = IconData(0xf7e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hevc</i> &#x2014; material icon named "hevc" (outlined).
  static const IconData hevc_outlined = IconData(0xf0f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hide_image</i> &#x2014; material icon named "hide image".
  static const IconData hide_image = IconData(0xe30d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hide_image</i> &#x2014; material icon named "hide image" (sharp).
  static const IconData hide_image_sharp = IconData(0xea08, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hide_image</i> &#x2014; material icon named "hide image" (round).
  static const IconData hide_image_rounded = IconData(0xf7e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hide_image</i> &#x2014; material icon named "hide image" (outlined).
  static const IconData hide_image_outlined = IconData(0xf0fa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hide_source</i> &#x2014; material icon named "hide source".
  static const IconData hide_source = IconData(0xe30e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hide_source</i> &#x2014; material icon named "hide source" (sharp).
  static const IconData hide_source_sharp = IconData(0xea09, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hide_source</i> &#x2014; material icon named "hide source" (round).
  static const IconData hide_source_rounded = IconData(0xf7e8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hide_source</i> &#x2014; material icon named "hide source" (outlined).
  static const IconData hide_source_outlined = IconData(0xf0fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">high_quality</i> &#x2014; material icon named "high quality".
  static const IconData high_quality = IconData(0xe30f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">high_quality</i> &#x2014; material icon named "high quality" (sharp).
  static const IconData high_quality_sharp = IconData(0xea0a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">high_quality</i> &#x2014; material icon named "high quality" (round).
  static const IconData high_quality_rounded = IconData(0xf7e9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">high_quality</i> &#x2014; material icon named "high quality" (outlined).
  static const IconData high_quality_outlined = IconData(0xf0fc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">highlight</i> &#x2014; material icon named "highlight".
  static const IconData highlight = IconData(0xe310, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">highlight</i> &#x2014; material icon named "highlight" (sharp).
  static const IconData highlight_sharp = IconData(0xea0d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">highlight</i> &#x2014; material icon named "highlight" (round).
  static const IconData highlight_rounded = IconData(0xf7ec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">highlight</i> &#x2014; material icon named "highlight" (outlined).
  static const IconData highlight_outlined = IconData(0xf0ff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">highlight_alt</i> &#x2014; material icon named "highlight alt".
  static const IconData highlight_alt = IconData(0xe311, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">highlight_alt</i> &#x2014; material icon named "highlight alt" (sharp).
  static const IconData highlight_alt_sharp = IconData(0xea0b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">highlight_alt</i> &#x2014; material icon named "highlight alt" (round).
  static const IconData highlight_alt_rounded = IconData(0xf7ea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">highlight_alt</i> &#x2014; material icon named "highlight alt" (outlined).
  static const IconData highlight_alt_outlined = IconData(0xf0fd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">highlight_off</i> &#x2014; material icon named "highlight off".
  static const IconData highlight_off = IconData(0xe312, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">highlight_off</i> &#x2014; material icon named "highlight off" (sharp).
  static const IconData highlight_off_sharp = IconData(0xea0c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">highlight_off</i> &#x2014; material icon named "highlight off" (round).
  static const IconData highlight_off_rounded = IconData(0xf7eb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">highlight_off</i> &#x2014; material icon named "highlight off" (outlined).
  static const IconData highlight_off_outlined = IconData(0xf0fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">highlight_remove</i> &#x2014; material icon named "highlight remove".
  static const IconData highlight_remove = IconData(0xe312, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">highlight_remove</i> &#x2014; material icon named "highlight remove" (sharp).
  static const IconData highlight_remove_sharp = IconData(0xea0c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">highlight_remove</i> &#x2014; material icon named "highlight remove" (round).
  static const IconData highlight_remove_rounded = IconData(0xf7eb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">highlight_remove</i> &#x2014; material icon named "highlight remove" (outlined).
  static const IconData highlight_remove_outlined = IconData(0xf0fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hiking</i> &#x2014; material icon named "hiking".
  static const IconData hiking = IconData(0xe313, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hiking</i> &#x2014; material icon named "hiking" (sharp).
  static const IconData hiking_sharp = IconData(0xea0e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hiking</i> &#x2014; material icon named "hiking" (round).
  static const IconData hiking_rounded = IconData(0xf7ed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hiking</i> &#x2014; material icon named "hiking" (outlined).
  static const IconData hiking_outlined = IconData(0xf100, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">history</i> &#x2014; material icon named "history".
  static const IconData history = IconData(0xe314, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">history</i> &#x2014; material icon named "history" (sharp).
  static const IconData history_sharp = IconData(0xea10, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">history</i> &#x2014; material icon named "history" (round).
  static const IconData history_rounded = IconData(0xf7ef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">history</i> &#x2014; material icon named "history" (outlined).
  static const IconData history_outlined = IconData(0xf102, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">history_edu</i> &#x2014; material icon named "history edu".
  static const IconData history_edu = IconData(0xe315, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">history_edu</i> &#x2014; material icon named "history edu" (sharp).
  static const IconData history_edu_sharp = IconData(0xea0f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">history_edu</i> &#x2014; material icon named "history edu" (round).
  static const IconData history_edu_rounded = IconData(0xf7ee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">history_edu</i> &#x2014; material icon named "history edu" (outlined).
  static const IconData history_edu_outlined = IconData(0xf101, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">history_toggle_off</i> &#x2014; material icon named "history toggle off".
  static const IconData history_toggle_off = IconData(0xe316, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">history_toggle_off</i> &#x2014; material icon named "history toggle off" (sharp).
  static const IconData history_toggle_off_sharp = IconData(0xea11, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">history_toggle_off</i> &#x2014; material icon named "history toggle off" (round).
  static const IconData history_toggle_off_rounded = IconData(0xf7f0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">history_toggle_off</i> &#x2014; material icon named "history toggle off" (outlined).
  static const IconData history_toggle_off_outlined = IconData(0xf103, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">holiday_village</i> &#x2014; material icon named "holiday village".
  static const IconData holiday_village = IconData(0xe317, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">holiday_village</i> &#x2014; material icon named "holiday village" (sharp).
  static const IconData holiday_village_sharp = IconData(0xea12, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">holiday_village</i> &#x2014; material icon named "holiday village" (round).
  static const IconData holiday_village_rounded = IconData(0xf7f1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">holiday_village</i> &#x2014; material icon named "holiday village" (outlined).
  static const IconData holiday_village_outlined = IconData(0xf104, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">home</i> &#x2014; material icon named "home".
  static const IconData home = IconData(0xe318, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">home</i> &#x2014; material icon named "home" (sharp).
  static const IconData home_sharp = IconData(0xea16, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">home</i> &#x2014; material icon named "home" (round).
  static const IconData home_rounded = IconData(0xf7f5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">home</i> &#x2014; material icon named "home" (outlined).
  static const IconData home_outlined = IconData(0xf107, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">home_filled</i> &#x2014; material icon named "home filled".
  static const IconData home_filled = IconData(0xe319, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">home_max</i> &#x2014; material icon named "home max".
  static const IconData home_max = IconData(0xe31a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">home_max</i> &#x2014; material icon named "home max" (sharp).
  static const IconData home_max_sharp = IconData(0xea13, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">home_max</i> &#x2014; material icon named "home max" (round).
  static const IconData home_max_rounded = IconData(0xf7f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">home_max</i> &#x2014; material icon named "home max" (outlined).
  static const IconData home_max_outlined = IconData(0xf105, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">home_mini</i> &#x2014; material icon named "home mini".
  static const IconData home_mini = IconData(0xe31b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">home_mini</i> &#x2014; material icon named "home mini" (sharp).
  static const IconData home_mini_sharp = IconData(0xea14, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">home_mini</i> &#x2014; material icon named "home mini" (round).
  static const IconData home_mini_rounded = IconData(0xf7f3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">home_mini</i> &#x2014; material icon named "home mini" (outlined).
  static const IconData home_mini_outlined = IconData(0xf106, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">home_repair_service</i> &#x2014; material icon named "home repair service".
  static const IconData home_repair_service = IconData(0xe31c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">home_repair_service</i> &#x2014; material icon named "home repair service" (sharp).
  static const IconData home_repair_service_sharp = IconData(0xea15, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">home_repair_service</i> &#x2014; material icon named "home repair service" (round).
  static const IconData home_repair_service_rounded = IconData(0xf7f4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">home_repair_service</i> &#x2014; material icon named "home repair service" (outlined).
  static const IconData home_repair_service_outlined = IconData(0xf108, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">home_work</i> &#x2014; material icon named "home work".
  static const IconData home_work = IconData(0xe31d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">home_work</i> &#x2014; material icon named "home work" (sharp).
  static const IconData home_work_sharp = IconData(0xea17, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">home_work</i> &#x2014; material icon named "home work" (round).
  static const IconData home_work_rounded = IconData(0xf7f6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">home_work</i> &#x2014; material icon named "home work" (outlined).
  static const IconData home_work_outlined = IconData(0xf109, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">horizontal_distribute</i> &#x2014; material icon named "horizontal distribute".
  static const IconData horizontal_distribute = IconData(0xe31e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">horizontal_distribute</i> &#x2014; material icon named "horizontal distribute" (sharp).
  static const IconData horizontal_distribute_sharp = IconData(0xea18, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">horizontal_distribute</i> &#x2014; material icon named "horizontal distribute" (round).
  static const IconData horizontal_distribute_rounded = IconData(0xf7f7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">horizontal_distribute</i> &#x2014; material icon named "horizontal distribute" (outlined).
  static const IconData horizontal_distribute_outlined = IconData(0xf10a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">horizontal_rule</i> &#x2014; material icon named "horizontal rule".
  static const IconData horizontal_rule = IconData(0xe31f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">horizontal_rule</i> &#x2014; material icon named "horizontal rule" (sharp).
  static const IconData horizontal_rule_sharp = IconData(0xea19, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">horizontal_rule</i> &#x2014; material icon named "horizontal rule" (round).
  static const IconData horizontal_rule_rounded = IconData(0xf7f8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">horizontal_rule</i> &#x2014; material icon named "horizontal rule" (outlined).
  static const IconData horizontal_rule_outlined = IconData(0xf10b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">horizontal_split</i> &#x2014; material icon named "horizontal split".
  static const IconData horizontal_split = IconData(0xe320, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">horizontal_split</i> &#x2014; material icon named "horizontal split" (sharp).
  static const IconData horizontal_split_sharp = IconData(0xea1a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">horizontal_split</i> &#x2014; material icon named "horizontal split" (round).
  static const IconData horizontal_split_rounded = IconData(0xf7f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">horizontal_split</i> &#x2014; material icon named "horizontal split" (outlined).
  static const IconData horizontal_split_outlined = IconData(0xf10c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hot_tub</i> &#x2014; material icon named "hot tub".
  static const IconData hot_tub = IconData(0xe321, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hot_tub</i> &#x2014; material icon named "hot tub" (sharp).
  static const IconData hot_tub_sharp = IconData(0xea1b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hot_tub</i> &#x2014; material icon named "hot tub" (round).
  static const IconData hot_tub_rounded = IconData(0xf7fa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hot_tub</i> &#x2014; material icon named "hot tub" (outlined).
  static const IconData hot_tub_outlined = IconData(0xf10d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hotel</i> &#x2014; material icon named "hotel".
  static const IconData hotel = IconData(0xe322, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hotel</i> &#x2014; material icon named "hotel" (sharp).
  static const IconData hotel_sharp = IconData(0xea1c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hotel</i> &#x2014; material icon named "hotel" (round).
  static const IconData hotel_rounded = IconData(0xf7fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hotel</i> &#x2014; material icon named "hotel" (outlined).
  static const IconData hotel_outlined = IconData(0xf10e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hourglass_bottom</i> &#x2014; material icon named "hourglass bottom".
  static const IconData hourglass_bottom = IconData(0xe323, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hourglass_bottom</i> &#x2014; material icon named "hourglass bottom" (sharp).
  static const IconData hourglass_bottom_sharp = IconData(0xea1d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hourglass_bottom</i> &#x2014; material icon named "hourglass bottom" (round).
  static const IconData hourglass_bottom_rounded = IconData(0xf7fc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hourglass_bottom</i> &#x2014; material icon named "hourglass bottom" (outlined).
  static const IconData hourglass_bottom_outlined = IconData(0xf10f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hourglass_disabled</i> &#x2014; material icon named "hourglass disabled".
  static const IconData hourglass_disabled = IconData(0xe324, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hourglass_disabled</i> &#x2014; material icon named "hourglass disabled" (sharp).
  static const IconData hourglass_disabled_sharp = IconData(0xea1e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hourglass_disabled</i> &#x2014; material icon named "hourglass disabled" (round).
  static const IconData hourglass_disabled_rounded = IconData(0xf7fd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hourglass_disabled</i> &#x2014; material icon named "hourglass disabled" (outlined).
  static const IconData hourglass_disabled_outlined = IconData(0xf110, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hourglass_empty</i> &#x2014; material icon named "hourglass empty".
  static const IconData hourglass_empty = IconData(0xe325, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hourglass_empty</i> &#x2014; material icon named "hourglass empty" (sharp).
  static const IconData hourglass_empty_sharp = IconData(0xea1f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hourglass_empty</i> &#x2014; material icon named "hourglass empty" (round).
  static const IconData hourglass_empty_rounded = IconData(0xf7fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hourglass_empty</i> &#x2014; material icon named "hourglass empty" (outlined).
  static const IconData hourglass_empty_outlined = IconData(0xf111, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hourglass_full</i> &#x2014; material icon named "hourglass full".
  static const IconData hourglass_full = IconData(0xe326, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hourglass_full</i> &#x2014; material icon named "hourglass full" (sharp).
  static const IconData hourglass_full_sharp = IconData(0xea20, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hourglass_full</i> &#x2014; material icon named "hourglass full" (round).
  static const IconData hourglass_full_rounded = IconData(0xf7ff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hourglass_full</i> &#x2014; material icon named "hourglass full" (outlined).
  static const IconData hourglass_full_outlined = IconData(0xf112, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hourglass_top</i> &#x2014; material icon named "hourglass top".
  static const IconData hourglass_top = IconData(0xe327, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hourglass_top</i> &#x2014; material icon named "hourglass top" (sharp).
  static const IconData hourglass_top_sharp = IconData(0xea21, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hourglass_top</i> &#x2014; material icon named "hourglass top" (round).
  static const IconData hourglass_top_rounded = IconData(0xf800, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hourglass_top</i> &#x2014; material icon named "hourglass top" (outlined).
  static const IconData hourglass_top_outlined = IconData(0xf113, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">house</i> &#x2014; material icon named "house".
  static const IconData house = IconData(0xe328, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">house</i> &#x2014; material icon named "house" (sharp).
  static const IconData house_sharp = IconData(0xea22, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">house</i> &#x2014; material icon named "house" (round).
  static const IconData house_rounded = IconData(0xf801, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">house</i> &#x2014; material icon named "house" (outlined).
  static const IconData house_outlined = IconData(0xf114, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">house_siding</i> &#x2014; material icon named "house siding".
  static const IconData house_siding = IconData(0xe329, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">house_siding</i> &#x2014; material icon named "house siding" (sharp).
  static const IconData house_siding_sharp = IconData(0xea23, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">house_siding</i> &#x2014; material icon named "house siding" (round).
  static const IconData house_siding_rounded = IconData(0xf802, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">house_siding</i> &#x2014; material icon named "house siding" (outlined).
  static const IconData house_siding_outlined = IconData(0xf115, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">houseboat</i> &#x2014; material icon named "houseboat".
  static const IconData houseboat = IconData(0xe32a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">houseboat</i> &#x2014; material icon named "houseboat" (sharp).
  static const IconData houseboat_sharp = IconData(0xea24, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">houseboat</i> &#x2014; material icon named "houseboat" (round).
  static const IconData houseboat_rounded = IconData(0xf803, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">houseboat</i> &#x2014; material icon named "houseboat" (outlined).
  static const IconData houseboat_outlined = IconData(0xf116, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">how_to_reg</i> &#x2014; material icon named "how to reg".
  static const IconData how_to_reg = IconData(0xe32b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">how_to_reg</i> &#x2014; material icon named "how to reg" (sharp).
  static const IconData how_to_reg_sharp = IconData(0xea25, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">how_to_reg</i> &#x2014; material icon named "how to reg" (round).
  static const IconData how_to_reg_rounded = IconData(0xf804, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">how_to_reg</i> &#x2014; material icon named "how to reg" (outlined).
  static const IconData how_to_reg_outlined = IconData(0xf117, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">how_to_vote</i> &#x2014; material icon named "how to vote".
  static const IconData how_to_vote = IconData(0xe32c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">how_to_vote</i> &#x2014; material icon named "how to vote" (sharp).
  static const IconData how_to_vote_sharp = IconData(0xea26, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">how_to_vote</i> &#x2014; material icon named "how to vote" (round).
  static const IconData how_to_vote_rounded = IconData(0xf805, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">how_to_vote</i> &#x2014; material icon named "how to vote" (outlined).
  static const IconData how_to_vote_outlined = IconData(0xf118, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">http</i> &#x2014; material icon named "http".
  static const IconData http = IconData(0xe32d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">http</i> &#x2014; material icon named "http" (sharp).
  static const IconData http_sharp = IconData(0xea27, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">http</i> &#x2014; material icon named "http" (round).
  static const IconData http_rounded = IconData(0xf806, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">http</i> &#x2014; material icon named "http" (outlined).
  static const IconData http_outlined = IconData(0xf119, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">https</i> &#x2014; material icon named "https".
  static const IconData https = IconData(0xe32e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">https</i> &#x2014; material icon named "https" (sharp).
  static const IconData https_sharp = IconData(0xea28, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">https</i> &#x2014; material icon named "https" (round).
  static const IconData https_rounded = IconData(0xf807, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">https</i> &#x2014; material icon named "https" (outlined).
  static const IconData https_outlined = IconData(0xf11a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">hvac</i> &#x2014; material icon named "hvac".
  static const IconData hvac = IconData(0xe32f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">hvac</i> &#x2014; material icon named "hvac" (sharp).
  static const IconData hvac_sharp = IconData(0xea29, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">hvac</i> &#x2014; material icon named "hvac" (round).
  static const IconData hvac_rounded = IconData(0xf808, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">hvac</i> &#x2014; material icon named "hvac" (outlined).
  static const IconData hvac_outlined = IconData(0xf11b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">ice_skating</i> &#x2014; material icon named "ice skating".
  static const IconData ice_skating = IconData(0xe330, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">ice_skating</i> &#x2014; material icon named "ice skating" (sharp).
  static const IconData ice_skating_sharp = IconData(0xea2a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">ice_skating</i> &#x2014; material icon named "ice skating" (round).
  static const IconData ice_skating_rounded = IconData(0xf809, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">ice_skating</i> &#x2014; material icon named "ice skating" (outlined).
  static const IconData ice_skating_outlined = IconData(0xf11c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">icecream</i> &#x2014; material icon named "icecream".
  static const IconData icecream = IconData(0xe331, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">icecream</i> &#x2014; material icon named "icecream" (sharp).
  static const IconData icecream_sharp = IconData(0xea2b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">icecream</i> &#x2014; material icon named "icecream" (round).
  static const IconData icecream_rounded = IconData(0xf80a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">icecream</i> &#x2014; material icon named "icecream" (outlined).
  static const IconData icecream_outlined = IconData(0xf11d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">image</i> &#x2014; material icon named "image".
  static const IconData image = IconData(0xe332, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">image</i> &#x2014; material icon named "image" (sharp).
  static const IconData image_sharp = IconData(0xea2f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">image</i> &#x2014; material icon named "image" (round).
  static const IconData image_rounded = IconData(0xf80d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">image</i> &#x2014; material icon named "image" (outlined).
  static const IconData image_outlined = IconData(0xf120, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">image_aspect_ratio</i> &#x2014; material icon named "image aspect ratio".
  static const IconData image_aspect_ratio = IconData(0xe333, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">image_aspect_ratio</i> &#x2014; material icon named "image aspect ratio" (sharp).
  static const IconData image_aspect_ratio_sharp = IconData(0xea2c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">image_aspect_ratio</i> &#x2014; material icon named "image aspect ratio" (round).
  static const IconData image_aspect_ratio_rounded = IconData(0xf80b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">image_aspect_ratio</i> &#x2014; material icon named "image aspect ratio" (outlined).
  static const IconData image_aspect_ratio_outlined = IconData(0xf11e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">image_not_supported</i> &#x2014; material icon named "image not supported".
  static const IconData image_not_supported = IconData(0xe334, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">image_not_supported</i> &#x2014; material icon named "image not supported" (sharp).
  static const IconData image_not_supported_sharp = IconData(0xea2d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">image_not_supported</i> &#x2014; material icon named "image not supported" (round).
  static const IconData image_not_supported_rounded = IconData(0xf80c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">image_not_supported</i> &#x2014; material icon named "image not supported" (outlined).
  static const IconData image_not_supported_outlined = IconData(0xf11f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">image_search</i> &#x2014; material icon named "image search".
  static const IconData image_search = IconData(0xe335, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">image_search</i> &#x2014; material icon named "image search" (sharp).
  static const IconData image_search_sharp = IconData(0xea2e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">image_search</i> &#x2014; material icon named "image search" (round).
  static const IconData image_search_rounded = IconData(0xf80e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">image_search</i> &#x2014; material icon named "image search" (outlined).
  static const IconData image_search_outlined = IconData(0xf121, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">imagesearch_roller</i> &#x2014; material icon named "imagesearch roller".
  static const IconData imagesearch_roller = IconData(0xe336, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">imagesearch_roller</i> &#x2014; material icon named "imagesearch roller" (sharp).
  static const IconData imagesearch_roller_sharp = IconData(0xea30, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">imagesearch_roller</i> &#x2014; material icon named "imagesearch roller" (round).
  static const IconData imagesearch_roller_rounded = IconData(0xf80f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">imagesearch_roller</i> &#x2014; material icon named "imagesearch roller" (outlined).
  static const IconData imagesearch_roller_outlined = IconData(0xf122, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">import_contacts</i> &#x2014; material icon named "import contacts".
  static const IconData import_contacts = IconData(0xe337, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">import_contacts</i> &#x2014; material icon named "import contacts" (sharp).
  static const IconData import_contacts_sharp = IconData(0xea31, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">import_contacts</i> &#x2014; material icon named "import contacts" (round).
  static const IconData import_contacts_rounded = IconData(0xf810, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">import_contacts</i> &#x2014; material icon named "import contacts" (outlined).
  static const IconData import_contacts_outlined = IconData(0xf123, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">import_export</i> &#x2014; material icon named "import export".
  static const IconData import_export = IconData(0xe338, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">import_export</i> &#x2014; material icon named "import export" (sharp).
  static const IconData import_export_sharp = IconData(0xea32, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">import_export</i> &#x2014; material icon named "import export" (round).
  static const IconData import_export_rounded = IconData(0xf811, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">import_export</i> &#x2014; material icon named "import export" (outlined).
  static const IconData import_export_outlined = IconData(0xf124, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">important_devices</i> &#x2014; material icon named "important devices".
  static const IconData important_devices = IconData(0xe339, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">important_devices</i> &#x2014; material icon named "important devices" (sharp).
  static const IconData important_devices_sharp = IconData(0xea33, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">important_devices</i> &#x2014; material icon named "important devices" (round).
  static const IconData important_devices_rounded = IconData(0xf812, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">important_devices</i> &#x2014; material icon named "important devices" (outlined).
  static const IconData important_devices_outlined = IconData(0xf125, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">inbox</i> &#x2014; material icon named "inbox".
  static const IconData inbox = IconData(0xe33a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">inbox</i> &#x2014; material icon named "inbox" (sharp).
  static const IconData inbox_sharp = IconData(0xea34, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">inbox</i> &#x2014; material icon named "inbox" (round).
  static const IconData inbox_rounded = IconData(0xf813, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">inbox</i> &#x2014; material icon named "inbox" (outlined).
  static const IconData inbox_outlined = IconData(0xf126, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">indeterminate_check_box</i> &#x2014; material icon named "indeterminate check box".
  static const IconData indeterminate_check_box = IconData(0xe33b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">indeterminate_check_box</i> &#x2014; material icon named "indeterminate check box" (sharp).
  static const IconData indeterminate_check_box_sharp = IconData(0xea35, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">indeterminate_check_box</i> &#x2014; material icon named "indeterminate check box" (round).
  static const IconData indeterminate_check_box_rounded = IconData(0xf814, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">indeterminate_check_box</i> &#x2014; material icon named "indeterminate check box" (outlined).
  static const IconData indeterminate_check_box_outlined = IconData(0xf127, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">info</i> &#x2014; material icon named "info".
  static const IconData info = IconData(0xe33c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">info</i> &#x2014; material icon named "info" (sharp).
  static const IconData info_sharp = IconData(0xea37, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">info</i> &#x2014; material icon named "info" (round).
  static const IconData info_rounded = IconData(0xf816, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">info</i> &#x2014; material icon named "info" (outlined).
  static const IconData info_outlined = IconData(0xf128, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">info_outline</i> &#x2014; material icon named "info outline".
  static const IconData info_outline = IconData(0xe33d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">info_outline</i> &#x2014; material icon named "info outline" (sharp).
  static const IconData info_outline_sharp = IconData(0xea36, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">info_outline</i> &#x2014; material icon named "info outline" (round).
  static const IconData info_outline_rounded = IconData(0xf815, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">input</i> &#x2014; material icon named "input".
  static const IconData input = IconData(0xe33e, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">input</i> &#x2014; material icon named "input" (sharp).
  static const IconData input_sharp = IconData(0xea38, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">input</i> &#x2014; material icon named "input" (round).
  static const IconData input_rounded = IconData(0xf817, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">input</i> &#x2014; material icon named "input" (outlined).
  static const IconData input_outlined = IconData(0xf129, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">insert_chart</i> &#x2014; material icon named "insert chart".
  static const IconData insert_chart = IconData(0xe33f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">insert_chart</i> &#x2014; material icon named "insert chart" (sharp).
  static const IconData insert_chart_sharp = IconData(0xea3a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">insert_chart</i> &#x2014; material icon named "insert chart" (round).
  static const IconData insert_chart_rounded = IconData(0xf819, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">insert_chart_outlined</i> &#x2014; material icon named "insert chart outlined".
  static const IconData insert_chart_outlined = IconData(0xf12a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">insert_chart_outlined</i> &#x2014; material icon named "insert chart outlined" (sharp).
  static const IconData insert_chart_outlined_sharp = IconData(0xea39, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">insert_chart_outlined</i> &#x2014; material icon named "insert chart outlined" (round).
  static const IconData insert_chart_outlined_rounded = IconData(0xf818, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">insert_chart_outlined</i> &#x2014; material icon named "insert chart outlined" (outlined).
  static const IconData insert_chart_outlined_outlined = IconData(0xf12b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">insert_comment</i> &#x2014; material icon named "insert comment".
  static const IconData insert_comment = IconData(0xe341, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">insert_comment</i> &#x2014; material icon named "insert comment" (sharp).
  static const IconData insert_comment_sharp = IconData(0xea3b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">insert_comment</i> &#x2014; material icon named "insert comment" (round).
  static const IconData insert_comment_rounded = IconData(0xf81a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">insert_comment</i> &#x2014; material icon named "insert comment" (outlined).
  static const IconData insert_comment_outlined = IconData(0xf12c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">insert_drive_file</i> &#x2014; material icon named "insert drive file".
  static const IconData insert_drive_file = IconData(0xe342, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">insert_drive_file</i> &#x2014; material icon named "insert drive file" (sharp).
  static const IconData insert_drive_file_sharp = IconData(0xea3c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">insert_drive_file</i> &#x2014; material icon named "insert drive file" (round).
  static const IconData insert_drive_file_rounded = IconData(0xf81b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">insert_drive_file</i> &#x2014; material icon named "insert drive file" (outlined).
  static const IconData insert_drive_file_outlined = IconData(0xf12d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">insert_emoticon</i> &#x2014; material icon named "insert emoticon".
  static const IconData insert_emoticon = IconData(0xe343, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">insert_emoticon</i> &#x2014; material icon named "insert emoticon" (sharp).
  static const IconData insert_emoticon_sharp = IconData(0xea3d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">insert_emoticon</i> &#x2014; material icon named "insert emoticon" (round).
  static const IconData insert_emoticon_rounded = IconData(0xf81c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">insert_emoticon</i> &#x2014; material icon named "insert emoticon" (outlined).
  static const IconData insert_emoticon_outlined = IconData(0xf12e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">insert_invitation</i> &#x2014; material icon named "insert invitation".
  static const IconData insert_invitation = IconData(0xe344, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">insert_invitation</i> &#x2014; material icon named "insert invitation" (sharp).
  static const IconData insert_invitation_sharp = IconData(0xea3e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">insert_invitation</i> &#x2014; material icon named "insert invitation" (round).
  static const IconData insert_invitation_rounded = IconData(0xf81d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">insert_invitation</i> &#x2014; material icon named "insert invitation" (outlined).
  static const IconData insert_invitation_outlined = IconData(0xf12f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">insert_link</i> &#x2014; material icon named "insert link".
  static const IconData insert_link = IconData(0xe345, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">insert_link</i> &#x2014; material icon named "insert link" (sharp).
  static const IconData insert_link_sharp = IconData(0xea3f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">insert_link</i> &#x2014; material icon named "insert link" (round).
  static const IconData insert_link_rounded = IconData(0xf81e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">insert_link</i> &#x2014; material icon named "insert link" (outlined).
  static const IconData insert_link_outlined = IconData(0xf130, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">insert_photo</i> &#x2014; material icon named "insert photo".
  static const IconData insert_photo = IconData(0xe346, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">insert_photo</i> &#x2014; material icon named "insert photo" (sharp).
  static const IconData insert_photo_sharp = IconData(0xea40, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">insert_photo</i> &#x2014; material icon named "insert photo" (round).
  static const IconData insert_photo_rounded = IconData(0xf81f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">insert_photo</i> &#x2014; material icon named "insert photo" (outlined).
  static const IconData insert_photo_outlined = IconData(0xf131, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">insights</i> &#x2014; material icon named "insights".
  static const IconData insights = IconData(0xe347, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">insights</i> &#x2014; material icon named "insights" (sharp).
  static const IconData insights_sharp = IconData(0xea41, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">insights</i> &#x2014; material icon named "insights" (round).
  static const IconData insights_rounded = IconData(0xf820, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">insights</i> &#x2014; material icon named "insights" (outlined).
  static const IconData insights_outlined = IconData(0xf132, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">integration_instructions</i> &#x2014; material icon named "integration instructions".
  static const IconData integration_instructions = IconData(0xe348, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">integration_instructions</i> &#x2014; material icon named "integration instructions" (sharp).
  static const IconData integration_instructions_sharp = IconData(0xea42, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">integration_instructions</i> &#x2014; material icon named "integration instructions" (round).
  static const IconData integration_instructions_rounded = IconData(0xf821, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">integration_instructions</i> &#x2014; material icon named "integration instructions" (outlined).
  static const IconData integration_instructions_outlined = IconData(0xf133, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">inventory</i> &#x2014; material icon named "inventory".
  static const IconData inventory = IconData(0xe349, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">inventory</i> &#x2014; material icon named "inventory" (sharp).
  static const IconData inventory_sharp = IconData(0xea44, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">inventory</i> &#x2014; material icon named "inventory" (round).
  static const IconData inventory_rounded = IconData(0xf823, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">inventory</i> &#x2014; material icon named "inventory" (outlined).
  static const IconData inventory_outlined = IconData(0xf135, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">inventory_2</i> &#x2014; material icon named "inventory 2".
  static const IconData inventory_2 = IconData(0xe34a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">inventory_2</i> &#x2014; material icon named "inventory 2" (sharp).
  static const IconData inventory_2_sharp = IconData(0xea43, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">inventory_2</i> &#x2014; material icon named "inventory 2" (round).
  static const IconData inventory_2_rounded = IconData(0xf822, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">inventory_2</i> &#x2014; material icon named "inventory 2" (outlined).
  static const IconData inventory_2_outlined = IconData(0xf134, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">invert_colors</i> &#x2014; material icon named "invert colors".
  static const IconData invert_colors = IconData(0xe34b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">invert_colors</i> &#x2014; material icon named "invert colors" (sharp).
  static const IconData invert_colors_sharp = IconData(0xea46, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">invert_colors</i> &#x2014; material icon named "invert colors" (round).
  static const IconData invert_colors_rounded = IconData(0xf825, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">invert_colors</i> &#x2014; material icon named "invert colors" (outlined).
  static const IconData invert_colors_outlined = IconData(0xf137, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">invert_colors_off</i> &#x2014; material icon named "invert colors off".
  static const IconData invert_colors_off = IconData(0xe34c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">invert_colors_off</i> &#x2014; material icon named "invert colors off" (sharp).
  static const IconData invert_colors_off_sharp = IconData(0xea45, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">invert_colors_off</i> &#x2014; material icon named "invert colors off" (round).
  static const IconData invert_colors_off_rounded = IconData(0xf824, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">invert_colors_off</i> &#x2014; material icon named "invert colors off" (outlined).
  static const IconData invert_colors_off_outlined = IconData(0xf136, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">invert_colors_on</i> &#x2014; material icon named "invert colors on".
  static const IconData invert_colors_on = IconData(0xe34b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">invert_colors_on</i> &#x2014; material icon named "invert colors on" (sharp).
  static const IconData invert_colors_on_sharp = IconData(0xea46, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">invert_colors_on</i> &#x2014; material icon named "invert colors on" (round).
  static const IconData invert_colors_on_rounded = IconData(0xf825, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">invert_colors_on</i> &#x2014; material icon named "invert colors on" (outlined).
  static const IconData invert_colors_on_outlined = IconData(0xf137, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">ios_share</i> &#x2014; material icon named "ios share".
  static const IconData ios_share = IconData(0xe34d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">ios_share</i> &#x2014; material icon named "ios share" (sharp).
  static const IconData ios_share_sharp = IconData(0xea47, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">ios_share</i> &#x2014; material icon named "ios share" (round).
  static const IconData ios_share_rounded = IconData(0xf826, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">ios_share</i> &#x2014; material icon named "ios share" (outlined).
  static const IconData ios_share_outlined = IconData(0xf138, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">iron</i> &#x2014; material icon named "iron".
  static const IconData iron = IconData(0xe34e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">iron</i> &#x2014; material icon named "iron" (sharp).
  static const IconData iron_sharp = IconData(0xea48, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">iron</i> &#x2014; material icon named "iron" (round).
  static const IconData iron_rounded = IconData(0xf827, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">iron</i> &#x2014; material icon named "iron" (outlined).
  static const IconData iron_outlined = IconData(0xf139, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">iso</i> &#x2014; material icon named "iso".
  static const IconData iso = IconData(0xe34f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">iso</i> &#x2014; material icon named "iso" (sharp).
  static const IconData iso_sharp = IconData(0xea49, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">iso</i> &#x2014; material icon named "iso" (round).
  static const IconData iso_rounded = IconData(0xf828, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">iso</i> &#x2014; material icon named "iso" (outlined).
  static const IconData iso_outlined = IconData(0xf13a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">kayaking</i> &#x2014; material icon named "kayaking".
  static const IconData kayaking = IconData(0xe350, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">kayaking</i> &#x2014; material icon named "kayaking" (sharp).
  static const IconData kayaking_sharp = IconData(0xea4a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">kayaking</i> &#x2014; material icon named "kayaking" (round).
  static const IconData kayaking_rounded = IconData(0xf829, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">kayaking</i> &#x2014; material icon named "kayaking" (outlined).
  static const IconData kayaking_outlined = IconData(0xf13b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard</i> &#x2014; material icon named "keyboard".
  static const IconData keyboard = IconData(0xe351, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">keyboard</i> &#x2014; material icon named "keyboard" (sharp).
  static const IconData keyboard_sharp = IconData(0xea54, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">keyboard</i> &#x2014; material icon named "keyboard" (round).
  static const IconData keyboard_rounded = IconData(0xf833, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">keyboard</i> &#x2014; material icon named "keyboard" (outlined).
  static const IconData keyboard_outlined = IconData(0xf144, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard_alt</i> &#x2014; material icon named "keyboard alt".
  static const IconData keyboard_alt = IconData(0xe352, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">keyboard_alt</i> &#x2014; material icon named "keyboard alt" (sharp).
  static const IconData keyboard_alt_sharp = IconData(0xea4b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">keyboard_alt</i> &#x2014; material icon named "keyboard alt" (round).
  static const IconData keyboard_alt_rounded = IconData(0xf82a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">keyboard_alt</i> &#x2014; material icon named "keyboard alt" (outlined).
  static const IconData keyboard_alt_outlined = IconData(0xf13c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard_arrow_down</i> &#x2014; material icon named "keyboard arrow down".
  static const IconData keyboard_arrow_down = IconData(0xe353, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">keyboard_arrow_down</i> &#x2014; material icon named "keyboard arrow down" (sharp).
  static const IconData keyboard_arrow_down_sharp = IconData(0xea4c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">keyboard_arrow_down</i> &#x2014; material icon named "keyboard arrow down" (round).
  static const IconData keyboard_arrow_down_rounded = IconData(0xf82b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">keyboard_arrow_down</i> &#x2014; material icon named "keyboard arrow down" (outlined).
  static const IconData keyboard_arrow_down_outlined = IconData(0xf13d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard_arrow_left</i> &#x2014; material icon named "keyboard arrow left".
  static const IconData keyboard_arrow_left = IconData(0xe354, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">keyboard_arrow_left</i> &#x2014; material icon named "keyboard arrow left" (sharp).
  static const IconData keyboard_arrow_left_sharp = IconData(0xea4d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">keyboard_arrow_left</i> &#x2014; material icon named "keyboard arrow left" (round).
  static const IconData keyboard_arrow_left_rounded = IconData(0xf82c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">keyboard_arrow_left</i> &#x2014; material icon named "keyboard arrow left" (outlined).
  static const IconData keyboard_arrow_left_outlined = IconData(0xf13e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard_arrow_right</i> &#x2014; material icon named "keyboard arrow right".
  static const IconData keyboard_arrow_right = IconData(0xe355, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">keyboard_arrow_right</i> &#x2014; material icon named "keyboard arrow right" (sharp).
  static const IconData keyboard_arrow_right_sharp = IconData(0xea4e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">keyboard_arrow_right</i> &#x2014; material icon named "keyboard arrow right" (round).
  static const IconData keyboard_arrow_right_rounded = IconData(0xf82d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">keyboard_arrow_right</i> &#x2014; material icon named "keyboard arrow right" (outlined).
  static const IconData keyboard_arrow_right_outlined = IconData(0xf13f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard_arrow_up</i> &#x2014; material icon named "keyboard arrow up".
  static const IconData keyboard_arrow_up = IconData(0xe356, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">keyboard_arrow_up</i> &#x2014; material icon named "keyboard arrow up" (sharp).
  static const IconData keyboard_arrow_up_sharp = IconData(0xea4f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">keyboard_arrow_up</i> &#x2014; material icon named "keyboard arrow up" (round).
  static const IconData keyboard_arrow_up_rounded = IconData(0xf82e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">keyboard_arrow_up</i> &#x2014; material icon named "keyboard arrow up" (outlined).
  static const IconData keyboard_arrow_up_outlined = IconData(0xf140, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard_backspace</i> &#x2014; material icon named "keyboard backspace".
  static const IconData keyboard_backspace = IconData(0xe357, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">keyboard_backspace</i> &#x2014; material icon named "keyboard backspace" (sharp).
  static const IconData keyboard_backspace_sharp = IconData(0xea50, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">keyboard_backspace</i> &#x2014; material icon named "keyboard backspace" (round).
  static const IconData keyboard_backspace_rounded = IconData(0xf82f, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">keyboard_backspace</i> &#x2014; material icon named "keyboard backspace" (outlined).
  static const IconData keyboard_backspace_outlined = IconData(0xf141, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">keyboard_capslock</i> &#x2014; material icon named "keyboard capslock".
  static const IconData keyboard_capslock = IconData(0xe358, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">keyboard_capslock</i> &#x2014; material icon named "keyboard capslock" (sharp).
  static const IconData keyboard_capslock_sharp = IconData(0xea51, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">keyboard_capslock</i> &#x2014; material icon named "keyboard capslock" (round).
  static const IconData keyboard_capslock_rounded = IconData(0xf830, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">keyboard_capslock</i> &#x2014; material icon named "keyboard capslock" (outlined).
  static const IconData keyboard_capslock_outlined = IconData(0xf142, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard_control</i> &#x2014; material icon named "keyboard control".
  static const IconData keyboard_control = IconData(0xe402, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">keyboard_control</i> &#x2014; material icon named "keyboard control" (sharp).
  static const IconData keyboard_control_sharp = IconData(0xeafa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">keyboard_control</i> &#x2014; material icon named "keyboard control" (round).
  static const IconData keyboard_control_rounded = IconData(0xf8d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">keyboard_control</i> &#x2014; material icon named "keyboard control" (outlined).
  static const IconData keyboard_control_outlined = IconData(0xf1e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard_hide</i> &#x2014; material icon named "keyboard hide".
  static const IconData keyboard_hide = IconData(0xe359, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">keyboard_hide</i> &#x2014; material icon named "keyboard hide" (sharp).
  static const IconData keyboard_hide_sharp = IconData(0xea52, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">keyboard_hide</i> &#x2014; material icon named "keyboard hide" (round).
  static const IconData keyboard_hide_rounded = IconData(0xf831, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">keyboard_hide</i> &#x2014; material icon named "keyboard hide" (outlined).
  static const IconData keyboard_hide_outlined = IconData(0xf143, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard_return</i> &#x2014; material icon named "keyboard return".
  static const IconData keyboard_return = IconData(0xe35a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">keyboard_return</i> &#x2014; material icon named "keyboard return" (sharp).
  static const IconData keyboard_return_sharp = IconData(0xea53, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">keyboard_return</i> &#x2014; material icon named "keyboard return" (round).
  static const IconData keyboard_return_rounded = IconData(0xf832, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">keyboard_return</i> &#x2014; material icon named "keyboard return" (outlined).
  static const IconData keyboard_return_outlined = IconData(0xf145, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">keyboard_tab</i> &#x2014; material icon named "keyboard tab".
  static const IconData keyboard_tab = IconData(0xe35b, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">keyboard_tab</i> &#x2014; material icon named "keyboard tab" (sharp).
  static const IconData keyboard_tab_sharp = IconData(0xea55, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">keyboard_tab</i> &#x2014; material icon named "keyboard tab" (round).
  static const IconData keyboard_tab_rounded = IconData(0xf834, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">keyboard_tab</i> &#x2014; material icon named "keyboard tab" (outlined).
  static const IconData keyboard_tab_outlined = IconData(0xf146, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">keyboard_voice</i> &#x2014; material icon named "keyboard voice".
  static const IconData keyboard_voice = IconData(0xe35c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">keyboard_voice</i> &#x2014; material icon named "keyboard voice" (sharp).
  static const IconData keyboard_voice_sharp = IconData(0xea56, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">keyboard_voice</i> &#x2014; material icon named "keyboard voice" (round).
  static const IconData keyboard_voice_rounded = IconData(0xf835, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">keyboard_voice</i> &#x2014; material icon named "keyboard voice" (outlined).
  static const IconData keyboard_voice_outlined = IconData(0xf147, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">king_bed</i> &#x2014; material icon named "king bed".
  static const IconData king_bed = IconData(0xe35d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">king_bed</i> &#x2014; material icon named "king bed" (sharp).
  static const IconData king_bed_sharp = IconData(0xea57, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">king_bed</i> &#x2014; material icon named "king bed" (round).
  static const IconData king_bed_rounded = IconData(0xf836, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">king_bed</i> &#x2014; material icon named "king bed" (outlined).
  static const IconData king_bed_outlined = IconData(0xf148, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">kitchen</i> &#x2014; material icon named "kitchen".
  static const IconData kitchen = IconData(0xe35e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">kitchen</i> &#x2014; material icon named "kitchen" (sharp).
  static const IconData kitchen_sharp = IconData(0xea58, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">kitchen</i> &#x2014; material icon named "kitchen" (round).
  static const IconData kitchen_rounded = IconData(0xf837, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">kitchen</i> &#x2014; material icon named "kitchen" (outlined).
  static const IconData kitchen_outlined = IconData(0xf149, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">kitesurfing</i> &#x2014; material icon named "kitesurfing".
  static const IconData kitesurfing = IconData(0xe35f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">kitesurfing</i> &#x2014; material icon named "kitesurfing" (sharp).
  static const IconData kitesurfing_sharp = IconData(0xea59, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">kitesurfing</i> &#x2014; material icon named "kitesurfing" (round).
  static const IconData kitesurfing_rounded = IconData(0xf838, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">kitesurfing</i> &#x2014; material icon named "kitesurfing" (outlined).
  static const IconData kitesurfing_outlined = IconData(0xf14a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">label</i> &#x2014; material icon named "label".
  static const IconData label = IconData(0xe360, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">label</i> &#x2014; material icon named "label" (sharp).
  static const IconData label_sharp = IconData(0xea5e, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">label</i> &#x2014; material icon named "label" (round).
  static const IconData label_rounded = IconData(0xf83d, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">label</i> &#x2014; material icon named "label" (outlined).
  static const IconData label_outlined = IconData(0xf14d, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">label_important</i> &#x2014; material icon named "label important".
  static const IconData label_important = IconData(0xe361, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">label_important</i> &#x2014; material icon named "label important" (sharp).
  static const IconData label_important_sharp = IconData(0xea5b, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">label_important</i> &#x2014; material icon named "label important" (round).
  static const IconData label_important_rounded = IconData(0xf83a, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">label_important</i> &#x2014; material icon named "label important" (outlined).
  static const IconData label_important_outlined = IconData(0xf14b, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">label_important_outline</i> &#x2014; material icon named "label important outline".
  static const IconData label_important_outline = IconData(0xe362, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">label_important_outline</i> &#x2014; material icon named "label important outline" (sharp).
  static const IconData label_important_outline_sharp = IconData(0xea5a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">label_important_outline</i> &#x2014; material icon named "label important outline" (round).
  static const IconData label_important_outline_rounded = IconData(0xf839, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">label_off</i> &#x2014; material icon named "label off".
  static const IconData label_off = IconData(0xe363, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">label_off</i> &#x2014; material icon named "label off" (sharp).
  static const IconData label_off_sharp = IconData(0xea5c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">label_off</i> &#x2014; material icon named "label off" (round).
  static const IconData label_off_rounded = IconData(0xf83b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">label_off</i> &#x2014; material icon named "label off" (outlined).
  static const IconData label_off_outlined = IconData(0xf14c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">label_outline</i> &#x2014; material icon named "label outline".
  static const IconData label_outline = IconData(0xe364, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">label_outline</i> &#x2014; material icon named "label outline" (sharp).
  static const IconData label_outline_sharp = IconData(0xea5d, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">label_outline</i> &#x2014; material icon named "label outline" (round).
  static const IconData label_outline_rounded = IconData(0xf83c, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">landscape</i> &#x2014; material icon named "landscape".
  static const IconData landscape = IconData(0xe365, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">landscape</i> &#x2014; material icon named "landscape" (sharp).
  static const IconData landscape_sharp = IconData(0xea5f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">landscape</i> &#x2014; material icon named "landscape" (round).
  static const IconData landscape_rounded = IconData(0xf83e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">landscape</i> &#x2014; material icon named "landscape" (outlined).
  static const IconData landscape_outlined = IconData(0xf14e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">language</i> &#x2014; material icon named "language".
  static const IconData language = IconData(0xe366, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">language</i> &#x2014; material icon named "language" (sharp).
  static const IconData language_sharp = IconData(0xea60, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">language</i> &#x2014; material icon named "language" (round).
  static const IconData language_rounded = IconData(0xf83f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">language</i> &#x2014; material icon named "language" (outlined).
  static const IconData language_outlined = IconData(0xf14f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">laptop</i> &#x2014; material icon named "laptop".
  static const IconData laptop = IconData(0xe367, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">laptop</i> &#x2014; material icon named "laptop" (sharp).
  static const IconData laptop_sharp = IconData(0xea63, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">laptop</i> &#x2014; material icon named "laptop" (round).
  static const IconData laptop_rounded = IconData(0xf842, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">laptop</i> &#x2014; material icon named "laptop" (outlined).
  static const IconData laptop_outlined = IconData(0xf152, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">laptop_chromebook</i> &#x2014; material icon named "laptop chromebook".
  static const IconData laptop_chromebook = IconData(0xe368, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">laptop_chromebook</i> &#x2014; material icon named "laptop chromebook" (sharp).
  static const IconData laptop_chromebook_sharp = IconData(0xea61, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">laptop_chromebook</i> &#x2014; material icon named "laptop chromebook" (round).
  static const IconData laptop_chromebook_rounded = IconData(0xf840, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">laptop_chromebook</i> &#x2014; material icon named "laptop chromebook" (outlined).
  static const IconData laptop_chromebook_outlined = IconData(0xf150, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">laptop_mac</i> &#x2014; material icon named "laptop mac".
  static const IconData laptop_mac = IconData(0xe369, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">laptop_mac</i> &#x2014; material icon named "laptop mac" (sharp).
  static const IconData laptop_mac_sharp = IconData(0xea62, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">laptop_mac</i> &#x2014; material icon named "laptop mac" (round).
  static const IconData laptop_mac_rounded = IconData(0xf841, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">laptop_mac</i> &#x2014; material icon named "laptop mac" (outlined).
  static const IconData laptop_mac_outlined = IconData(0xf151, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">laptop_windows</i> &#x2014; material icon named "laptop windows".
  static const IconData laptop_windows = IconData(0xe36a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">laptop_windows</i> &#x2014; material icon named "laptop windows" (sharp).
  static const IconData laptop_windows_sharp = IconData(0xea64, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">laptop_windows</i> &#x2014; material icon named "laptop windows" (round).
  static const IconData laptop_windows_rounded = IconData(0xf843, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">laptop_windows</i> &#x2014; material icon named "laptop windows" (outlined).
  static const IconData laptop_windows_outlined = IconData(0xf153, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">last_page</i> &#x2014; material icon named "last page".
  static const IconData last_page = IconData(0xe36b, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">last_page</i> &#x2014; material icon named "last page" (sharp).
  static const IconData last_page_sharp = IconData(0xea65, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">last_page</i> &#x2014; material icon named "last page" (round).
  static const IconData last_page_rounded = IconData(0xf844, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">last_page</i> &#x2014; material icon named "last page" (outlined).
  static const IconData last_page_outlined = IconData(0xf154, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">launch</i> &#x2014; material icon named "launch".
  static const IconData launch = IconData(0xe36c, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">launch</i> &#x2014; material icon named "launch" (sharp).
  static const IconData launch_sharp = IconData(0xea66, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">launch</i> &#x2014; material icon named "launch" (round).
  static const IconData launch_rounded = IconData(0xf845, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">launch</i> &#x2014; material icon named "launch" (outlined).
  static const IconData launch_outlined = IconData(0xf155, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">layers</i> &#x2014; material icon named "layers".
  static const IconData layers = IconData(0xe36d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">layers</i> &#x2014; material icon named "layers" (sharp).
  static const IconData layers_sharp = IconData(0xea68, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">layers</i> &#x2014; material icon named "layers" (round).
  static const IconData layers_rounded = IconData(0xf847, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">layers</i> &#x2014; material icon named "layers" (outlined).
  static const IconData layers_outlined = IconData(0xf157, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">layers_clear</i> &#x2014; material icon named "layers clear".
  static const IconData layers_clear = IconData(0xe36e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">layers_clear</i> &#x2014; material icon named "layers clear" (sharp).
  static const IconData layers_clear_sharp = IconData(0xea67, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">layers_clear</i> &#x2014; material icon named "layers clear" (round).
  static const IconData layers_clear_rounded = IconData(0xf846, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">layers_clear</i> &#x2014; material icon named "layers clear" (outlined).
  static const IconData layers_clear_outlined = IconData(0xf156, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">leaderboard</i> &#x2014; material icon named "leaderboard".
  static const IconData leaderboard = IconData(0xe36f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">leaderboard</i> &#x2014; material icon named "leaderboard" (sharp).
  static const IconData leaderboard_sharp = IconData(0xea69, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">leaderboard</i> &#x2014; material icon named "leaderboard" (round).
  static const IconData leaderboard_rounded = IconData(0xf848, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">leaderboard</i> &#x2014; material icon named "leaderboard" (outlined).
  static const IconData leaderboard_outlined = IconData(0xf158, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">leak_add</i> &#x2014; material icon named "leak add".
  static const IconData leak_add = IconData(0xe370, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">leak_add</i> &#x2014; material icon named "leak add" (sharp).
  static const IconData leak_add_sharp = IconData(0xea6a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">leak_add</i> &#x2014; material icon named "leak add" (round).
  static const IconData leak_add_rounded = IconData(0xf849, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">leak_add</i> &#x2014; material icon named "leak add" (outlined).
  static const IconData leak_add_outlined = IconData(0xf159, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">leak_remove</i> &#x2014; material icon named "leak remove".
  static const IconData leak_remove = IconData(0xe371, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">leak_remove</i> &#x2014; material icon named "leak remove" (sharp).
  static const IconData leak_remove_sharp = IconData(0xea6b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">leak_remove</i> &#x2014; material icon named "leak remove" (round).
  static const IconData leak_remove_rounded = IconData(0xf84a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">leak_remove</i> &#x2014; material icon named "leak remove" (outlined).
  static const IconData leak_remove_outlined = IconData(0xf15a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">leave_bags_at_home</i> &#x2014; material icon named "leave bags at home".
  static const IconData leave_bags_at_home = IconData(0xe439, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">leave_bags_at_home</i> &#x2014; material icon named "leave bags at home" (sharp).
  static const IconData leave_bags_at_home_sharp = IconData(0xeb32, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">leave_bags_at_home</i> &#x2014; material icon named "leave bags at home" (round).
  static const IconData leave_bags_at_home_rounded = IconData(0xf0011, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">leave_bags_at_home</i> &#x2014; material icon named "leave bags at home" (outlined).
  static const IconData leave_bags_at_home_outlined = IconData(0xf21f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">legend_toggle</i> &#x2014; material icon named "legend toggle".
  static const IconData legend_toggle = IconData(0xe372, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">legend_toggle</i> &#x2014; material icon named "legend toggle" (sharp).
  static const IconData legend_toggle_sharp = IconData(0xea6c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">legend_toggle</i> &#x2014; material icon named "legend toggle" (round).
  static const IconData legend_toggle_rounded = IconData(0xf84b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">legend_toggle</i> &#x2014; material icon named "legend toggle" (outlined).
  static const IconData legend_toggle_outlined = IconData(0xf15b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">lens</i> &#x2014; material icon named "lens".
  static const IconData lens = IconData(0xe373, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">lens</i> &#x2014; material icon named "lens" (sharp).
  static const IconData lens_sharp = IconData(0xea6e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">lens</i> &#x2014; material icon named "lens" (round).
  static const IconData lens_rounded = IconData(0xf84d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">lens</i> &#x2014; material icon named "lens" (outlined).
  static const IconData lens_outlined = IconData(0xf15d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">lens_blur</i> &#x2014; material icon named "lens blur".
  static const IconData lens_blur = IconData(0xe374, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">lens_blur</i> &#x2014; material icon named "lens blur" (sharp).
  static const IconData lens_blur_sharp = IconData(0xea6d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">lens_blur</i> &#x2014; material icon named "lens blur" (round).
  static const IconData lens_blur_rounded = IconData(0xf84c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">lens_blur</i> &#x2014; material icon named "lens blur" (outlined).
  static const IconData lens_blur_outlined = IconData(0xf15c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">library_add</i> &#x2014; material icon named "library add".
  static const IconData library_add = IconData(0xe375, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">library_add</i> &#x2014; material icon named "library add" (sharp).
  static const IconData library_add_sharp = IconData(0xea70, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">library_add</i> &#x2014; material icon named "library add" (round).
  static const IconData library_add_rounded = IconData(0xf84f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">library_add</i> &#x2014; material icon named "library add" (outlined).
  static const IconData library_add_outlined = IconData(0xf15f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">library_add_check</i> &#x2014; material icon named "library add check".
  static const IconData library_add_check = IconData(0xe376, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">library_add_check</i> &#x2014; material icon named "library add check" (sharp).
  static const IconData library_add_check_sharp = IconData(0xea6f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">library_add_check</i> &#x2014; material icon named "library add check" (round).
  static const IconData library_add_check_rounded = IconData(0xf84e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">library_add_check</i> &#x2014; material icon named "library add check" (outlined).
  static const IconData library_add_check_outlined = IconData(0xf15e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">library_books</i> &#x2014; material icon named "library books".
  static const IconData library_books = IconData(0xe377, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">library_books</i> &#x2014; material icon named "library books" (sharp).
  static const IconData library_books_sharp = IconData(0xea71, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">library_books</i> &#x2014; material icon named "library books" (round).
  static const IconData library_books_rounded = IconData(0xf850, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">library_books</i> &#x2014; material icon named "library books" (outlined).
  static const IconData library_books_outlined = IconData(0xf160, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">library_music</i> &#x2014; material icon named "library music".
  static const IconData library_music = IconData(0xe378, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">library_music</i> &#x2014; material icon named "library music" (sharp).
  static const IconData library_music_sharp = IconData(0xea72, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">library_music</i> &#x2014; material icon named "library music" (round).
  static const IconData library_music_rounded = IconData(0xf851, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">library_music</i> &#x2014; material icon named "library music" (outlined).
  static const IconData library_music_outlined = IconData(0xf161, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">light</i> &#x2014; material icon named "light".
  static const IconData light = IconData(0xe379, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">light</i> &#x2014; material icon named "light" (sharp).
  static const IconData light_sharp = IconData(0xea74, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">light</i> &#x2014; material icon named "light" (round).
  static const IconData light_rounded = IconData(0xf853, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">light</i> &#x2014; material icon named "light" (outlined).
  static const IconData light_outlined = IconData(0xf163, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">light_mode</i> &#x2014; material icon named "light mode".
  static const IconData light_mode = IconData(0xe37a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">light_mode</i> &#x2014; material icon named "light mode" (sharp).
  static const IconData light_mode_sharp = IconData(0xea73, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">light_mode</i> &#x2014; material icon named "light mode" (round).
  static const IconData light_mode_rounded = IconData(0xf852, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">light_mode</i> &#x2014; material icon named "light mode" (outlined).
  static const IconData light_mode_outlined = IconData(0xf162, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">lightbulb</i> &#x2014; material icon named "lightbulb".
  static const IconData lightbulb = IconData(0xe37b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">lightbulb</i> &#x2014; material icon named "lightbulb" (sharp).
  static const IconData lightbulb_sharp = IconData(0xea76, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">lightbulb</i> &#x2014; material icon named "lightbulb" (round).
  static const IconData lightbulb_rounded = IconData(0xf855, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">lightbulb</i> &#x2014; material icon named "lightbulb" (outlined).
  static const IconData lightbulb_outlined = IconData(0xf164, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">lightbulb_outline</i> &#x2014; material icon named "lightbulb outline".
  static const IconData lightbulb_outline = IconData(0xe37c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">lightbulb_outline</i> &#x2014; material icon named "lightbulb outline" (sharp).
  static const IconData lightbulb_outline_sharp = IconData(0xea75, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">lightbulb_outline</i> &#x2014; material icon named "lightbulb outline" (round).
  static const IconData lightbulb_outline_rounded = IconData(0xf854, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">line_style</i> &#x2014; material icon named "line style".
  static const IconData line_style = IconData(0xe37d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">line_style</i> &#x2014; material icon named "line style" (sharp).
  static const IconData line_style_sharp = IconData(0xea77, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">line_style</i> &#x2014; material icon named "line style" (round).
  static const IconData line_style_rounded = IconData(0xf856, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">line_style</i> &#x2014; material icon named "line style" (outlined).
  static const IconData line_style_outlined = IconData(0xf165, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">line_weight</i> &#x2014; material icon named "line weight".
  static const IconData line_weight = IconData(0xe37e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">line_weight</i> &#x2014; material icon named "line weight" (sharp).
  static const IconData line_weight_sharp = IconData(0xea78, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">line_weight</i> &#x2014; material icon named "line weight" (round).
  static const IconData line_weight_rounded = IconData(0xf857, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">line_weight</i> &#x2014; material icon named "line weight" (outlined).
  static const IconData line_weight_outlined = IconData(0xf166, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">linear_scale</i> &#x2014; material icon named "linear scale".
  static const IconData linear_scale = IconData(0xe37f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">linear_scale</i> &#x2014; material icon named "linear scale" (sharp).
  static const IconData linear_scale_sharp = IconData(0xea79, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">linear_scale</i> &#x2014; material icon named "linear scale" (round).
  static const IconData linear_scale_rounded = IconData(0xf858, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">linear_scale</i> &#x2014; material icon named "linear scale" (outlined).
  static const IconData linear_scale_outlined = IconData(0xf167, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">link</i> &#x2014; material icon named "link".
  static const IconData link = IconData(0xe380, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">link</i> &#x2014; material icon named "link" (sharp).
  static const IconData link_sharp = IconData(0xea7b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">link</i> &#x2014; material icon named "link" (round).
  static const IconData link_rounded = IconData(0xf85a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">link</i> &#x2014; material icon named "link" (outlined).
  static const IconData link_outlined = IconData(0xf169, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">link_off</i> &#x2014; material icon named "link off".
  static const IconData link_off = IconData(0xe381, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">link_off</i> &#x2014; material icon named "link off" (sharp).
  static const IconData link_off_sharp = IconData(0xea7a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">link_off</i> &#x2014; material icon named "link off" (round).
  static const IconData link_off_rounded = IconData(0xf859, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">link_off</i> &#x2014; material icon named "link off" (outlined).
  static const IconData link_off_outlined = IconData(0xf168, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">linked_camera</i> &#x2014; material icon named "linked camera".
  static const IconData linked_camera = IconData(0xe382, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">linked_camera</i> &#x2014; material icon named "linked camera" (sharp).
  static const IconData linked_camera_sharp = IconData(0xea7c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">linked_camera</i> &#x2014; material icon named "linked camera" (round).
  static const IconData linked_camera_rounded = IconData(0xf85b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">linked_camera</i> &#x2014; material icon named "linked camera" (outlined).
  static const IconData linked_camera_outlined = IconData(0xf16a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">liquor</i> &#x2014; material icon named "liquor".
  static const IconData liquor = IconData(0xe383, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">liquor</i> &#x2014; material icon named "liquor" (sharp).
  static const IconData liquor_sharp = IconData(0xea7d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">liquor</i> &#x2014; material icon named "liquor" (round).
  static const IconData liquor_rounded = IconData(0xf85c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">liquor</i> &#x2014; material icon named "liquor" (outlined).
  static const IconData liquor_outlined = IconData(0xf16b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">list</i> &#x2014; material icon named "list".
  static const IconData list = IconData(0xe384, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">list</i> &#x2014; material icon named "list" (sharp).
  static const IconData list_sharp = IconData(0xea7f, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">list</i> &#x2014; material icon named "list" (round).
  static const IconData list_rounded = IconData(0xf85e, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">list</i> &#x2014; material icon named "list" (outlined).
  static const IconData list_outlined = IconData(0xf16d, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">list_alt</i> &#x2014; material icon named "list alt".
  static const IconData list_alt = IconData(0xe385, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">list_alt</i> &#x2014; material icon named "list alt" (sharp).
  static const IconData list_alt_sharp = IconData(0xea7e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">list_alt</i> &#x2014; material icon named "list alt" (round).
  static const IconData list_alt_rounded = IconData(0xf85d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">list_alt</i> &#x2014; material icon named "list alt" (outlined).
  static const IconData list_alt_outlined = IconData(0xf16c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">live_help</i> &#x2014; material icon named "live help".
  static const IconData live_help = IconData(0xe386, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">live_help</i> &#x2014; material icon named "live help" (sharp).
  static const IconData live_help_sharp = IconData(0xea80, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">live_help</i> &#x2014; material icon named "live help" (round).
  static const IconData live_help_rounded = IconData(0xf85f, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">live_help</i> &#x2014; material icon named "live help" (outlined).
  static const IconData live_help_outlined = IconData(0xf16e, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">live_tv</i> &#x2014; material icon named "live tv".
  static const IconData live_tv = IconData(0xe387, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">live_tv</i> &#x2014; material icon named "live tv" (sharp).
  static const IconData live_tv_sharp = IconData(0xea81, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">live_tv</i> &#x2014; material icon named "live tv" (round).
  static const IconData live_tv_rounded = IconData(0xf860, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">live_tv</i> &#x2014; material icon named "live tv" (outlined).
  static const IconData live_tv_outlined = IconData(0xf16f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">living</i> &#x2014; material icon named "living".
  static const IconData living = IconData(0xe388, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">living</i> &#x2014; material icon named "living" (sharp).
  static const IconData living_sharp = IconData(0xea82, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">living</i> &#x2014; material icon named "living" (round).
  static const IconData living_rounded = IconData(0xf861, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">living</i> &#x2014; material icon named "living" (outlined).
  static const IconData living_outlined = IconData(0xf170, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_activity</i> &#x2014; material icon named "local activity".
  static const IconData local_activity = IconData(0xe389, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_activity</i> &#x2014; material icon named "local activity" (sharp).
  static const IconData local_activity_sharp = IconData(0xea83, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_activity</i> &#x2014; material icon named "local activity" (round).
  static const IconData local_activity_rounded = IconData(0xf862, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_activity</i> &#x2014; material icon named "local activity" (outlined).
  static const IconData local_activity_outlined = IconData(0xf171, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_airport</i> &#x2014; material icon named "local airport".
  static const IconData local_airport = IconData(0xe38a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_airport</i> &#x2014; material icon named "local airport" (sharp).
  static const IconData local_airport_sharp = IconData(0xea84, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_airport</i> &#x2014; material icon named "local airport" (round).
  static const IconData local_airport_rounded = IconData(0xf863, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_airport</i> &#x2014; material icon named "local airport" (outlined).
  static const IconData local_airport_outlined = IconData(0xf172, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_atm</i> &#x2014; material icon named "local atm".
  static const IconData local_atm = IconData(0xe38b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_atm</i> &#x2014; material icon named "local atm" (sharp).
  static const IconData local_atm_sharp = IconData(0xea85, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_atm</i> &#x2014; material icon named "local atm" (round).
  static const IconData local_atm_rounded = IconData(0xf864, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_atm</i> &#x2014; material icon named "local atm" (outlined).
  static const IconData local_atm_outlined = IconData(0xf173, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_attraction</i> &#x2014; material icon named "local attraction".
  static const IconData local_attraction = IconData(0xe389, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_attraction</i> &#x2014; material icon named "local attraction" (sharp).
  static const IconData local_attraction_sharp = IconData(0xea83, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_attraction</i> &#x2014; material icon named "local attraction" (round).
  static const IconData local_attraction_rounded = IconData(0xf862, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_attraction</i> &#x2014; material icon named "local attraction" (outlined).
  static const IconData local_attraction_outlined = IconData(0xf171, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_bar</i> &#x2014; material icon named "local bar".
  static const IconData local_bar = IconData(0xe38c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_bar</i> &#x2014; material icon named "local bar" (sharp).
  static const IconData local_bar_sharp = IconData(0xea86, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_bar</i> &#x2014; material icon named "local bar" (round).
  static const IconData local_bar_rounded = IconData(0xf865, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_bar</i> &#x2014; material icon named "local bar" (outlined).
  static const IconData local_bar_outlined = IconData(0xf174, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_cafe</i> &#x2014; material icon named "local cafe".
  static const IconData local_cafe = IconData(0xe38d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_cafe</i> &#x2014; material icon named "local cafe" (sharp).
  static const IconData local_cafe_sharp = IconData(0xea87, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_cafe</i> &#x2014; material icon named "local cafe" (round).
  static const IconData local_cafe_rounded = IconData(0xf866, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_cafe</i> &#x2014; material icon named "local cafe" (outlined).
  static const IconData local_cafe_outlined = IconData(0xf175, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_car_wash</i> &#x2014; material icon named "local car wash".
  static const IconData local_car_wash = IconData(0xe38e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_car_wash</i> &#x2014; material icon named "local car wash" (sharp).
  static const IconData local_car_wash_sharp = IconData(0xea88, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_car_wash</i> &#x2014; material icon named "local car wash" (round).
  static const IconData local_car_wash_rounded = IconData(0xf867, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_car_wash</i> &#x2014; material icon named "local car wash" (outlined).
  static const IconData local_car_wash_outlined = IconData(0xf176, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_convenience_store</i> &#x2014; material icon named "local convenience store".
  static const IconData local_convenience_store = IconData(0xe38f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_convenience_store</i> &#x2014; material icon named "local convenience store" (sharp).
  static const IconData local_convenience_store_sharp = IconData(0xea89, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_convenience_store</i> &#x2014; material icon named "local convenience store" (round).
  static const IconData local_convenience_store_rounded = IconData(0xf868, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_convenience_store</i> &#x2014; material icon named "local convenience store" (outlined).
  static const IconData local_convenience_store_outlined = IconData(0xf177, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_dining</i> &#x2014; material icon named "local dining".
  static const IconData local_dining = IconData(0xe390, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_dining</i> &#x2014; material icon named "local dining" (sharp).
  static const IconData local_dining_sharp = IconData(0xea8a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_dining</i> &#x2014; material icon named "local dining" (round).
  static const IconData local_dining_rounded = IconData(0xf869, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_dining</i> &#x2014; material icon named "local dining" (outlined).
  static const IconData local_dining_outlined = IconData(0xf178, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_drink</i> &#x2014; material icon named "local drink".
  static const IconData local_drink = IconData(0xe391, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_drink</i> &#x2014; material icon named "local drink" (sharp).
  static const IconData local_drink_sharp = IconData(0xea8b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_drink</i> &#x2014; material icon named "local drink" (round).
  static const IconData local_drink_rounded = IconData(0xf86a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_drink</i> &#x2014; material icon named "local drink" (outlined).
  static const IconData local_drink_outlined = IconData(0xf179, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_fire_department</i> &#x2014; material icon named "local fire department".
  static const IconData local_fire_department = IconData(0xe392, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_fire_department</i> &#x2014; material icon named "local fire department" (sharp).
  static const IconData local_fire_department_sharp = IconData(0xea8c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_fire_department</i> &#x2014; material icon named "local fire department" (round).
  static const IconData local_fire_department_rounded = IconData(0xf86b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_fire_department</i> &#x2014; material icon named "local fire department" (outlined).
  static const IconData local_fire_department_outlined = IconData(0xf17a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_florist</i> &#x2014; material icon named "local florist".
  static const IconData local_florist = IconData(0xe393, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_florist</i> &#x2014; material icon named "local florist" (sharp).
  static const IconData local_florist_sharp = IconData(0xea8d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_florist</i> &#x2014; material icon named "local florist" (round).
  static const IconData local_florist_rounded = IconData(0xf86c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_florist</i> &#x2014; material icon named "local florist" (outlined).
  static const IconData local_florist_outlined = IconData(0xf17b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_gas_station</i> &#x2014; material icon named "local gas station".
  static const IconData local_gas_station = IconData(0xe394, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_gas_station</i> &#x2014; material icon named "local gas station" (sharp).
  static const IconData local_gas_station_sharp = IconData(0xea8e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_gas_station</i> &#x2014; material icon named "local gas station" (round).
  static const IconData local_gas_station_rounded = IconData(0xf86d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_gas_station</i> &#x2014; material icon named "local gas station" (outlined).
  static const IconData local_gas_station_outlined = IconData(0xf17c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_grocery_store</i> &#x2014; material icon named "local grocery store".
  static const IconData local_grocery_store = IconData(0xe395, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_grocery_store</i> &#x2014; material icon named "local grocery store" (sharp).
  static const IconData local_grocery_store_sharp = IconData(0xea8f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_grocery_store</i> &#x2014; material icon named "local grocery store" (round).
  static const IconData local_grocery_store_rounded = IconData(0xf86e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_grocery_store</i> &#x2014; material icon named "local grocery store" (outlined).
  static const IconData local_grocery_store_outlined = IconData(0xf17d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_hospital</i> &#x2014; material icon named "local hospital".
  static const IconData local_hospital = IconData(0xe396, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_hospital</i> &#x2014; material icon named "local hospital" (sharp).
  static const IconData local_hospital_sharp = IconData(0xea90, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_hospital</i> &#x2014; material icon named "local hospital" (round).
  static const IconData local_hospital_rounded = IconData(0xf86f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_hospital</i> &#x2014; material icon named "local hospital" (outlined).
  static const IconData local_hospital_outlined = IconData(0xf17e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_hotel</i> &#x2014; material icon named "local hotel".
  static const IconData local_hotel = IconData(0xe397, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_hotel</i> &#x2014; material icon named "local hotel" (sharp).
  static const IconData local_hotel_sharp = IconData(0xea91, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_hotel</i> &#x2014; material icon named "local hotel" (round).
  static const IconData local_hotel_rounded = IconData(0xf870, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_hotel</i> &#x2014; material icon named "local hotel" (outlined).
  static const IconData local_hotel_outlined = IconData(0xf17f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_laundry_service</i> &#x2014; material icon named "local laundry service".
  static const IconData local_laundry_service = IconData(0xe398, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_laundry_service</i> &#x2014; material icon named "local laundry service" (sharp).
  static const IconData local_laundry_service_sharp = IconData(0xea92, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_laundry_service</i> &#x2014; material icon named "local laundry service" (round).
  static const IconData local_laundry_service_rounded = IconData(0xf871, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_laundry_service</i> &#x2014; material icon named "local laundry service" (outlined).
  static const IconData local_laundry_service_outlined = IconData(0xf180, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_library</i> &#x2014; material icon named "local library".
  static const IconData local_library = IconData(0xe399, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_library</i> &#x2014; material icon named "local library" (sharp).
  static const IconData local_library_sharp = IconData(0xea93, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_library</i> &#x2014; material icon named "local library" (round).
  static const IconData local_library_rounded = IconData(0xf872, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_library</i> &#x2014; material icon named "local library" (outlined).
  static const IconData local_library_outlined = IconData(0xf181, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_mall</i> &#x2014; material icon named "local mall".
  static const IconData local_mall = IconData(0xe39a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_mall</i> &#x2014; material icon named "local mall" (sharp).
  static const IconData local_mall_sharp = IconData(0xea94, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_mall</i> &#x2014; material icon named "local mall" (round).
  static const IconData local_mall_rounded = IconData(0xf873, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_mall</i> &#x2014; material icon named "local mall" (outlined).
  static const IconData local_mall_outlined = IconData(0xf182, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_movies</i> &#x2014; material icon named "local movies".
  static const IconData local_movies = IconData(0xe39b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_movies</i> &#x2014; material icon named "local movies" (sharp).
  static const IconData local_movies_sharp = IconData(0xea95, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_movies</i> &#x2014; material icon named "local movies" (round).
  static const IconData local_movies_rounded = IconData(0xf874, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_movies</i> &#x2014; material icon named "local movies" (outlined).
  static const IconData local_movies_outlined = IconData(0xf183, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_offer</i> &#x2014; material icon named "local offer".
  static const IconData local_offer = IconData(0xe39c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_offer</i> &#x2014; material icon named "local offer" (sharp).
  static const IconData local_offer_sharp = IconData(0xea96, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_offer</i> &#x2014; material icon named "local offer" (round).
  static const IconData local_offer_rounded = IconData(0xf875, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_offer</i> &#x2014; material icon named "local offer" (outlined).
  static const IconData local_offer_outlined = IconData(0xf184, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_parking</i> &#x2014; material icon named "local parking".
  static const IconData local_parking = IconData(0xe39d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_parking</i> &#x2014; material icon named "local parking" (sharp).
  static const IconData local_parking_sharp = IconData(0xea97, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_parking</i> &#x2014; material icon named "local parking" (round).
  static const IconData local_parking_rounded = IconData(0xf876, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_parking</i> &#x2014; material icon named "local parking" (outlined).
  static const IconData local_parking_outlined = IconData(0xf185, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_pharmacy</i> &#x2014; material icon named "local pharmacy".
  static const IconData local_pharmacy = IconData(0xe39e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_pharmacy</i> &#x2014; material icon named "local pharmacy" (sharp).
  static const IconData local_pharmacy_sharp = IconData(0xea98, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_pharmacy</i> &#x2014; material icon named "local pharmacy" (round).
  static const IconData local_pharmacy_rounded = IconData(0xf877, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_pharmacy</i> &#x2014; material icon named "local pharmacy" (outlined).
  static const IconData local_pharmacy_outlined = IconData(0xf186, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_phone</i> &#x2014; material icon named "local phone".
  static const IconData local_phone = IconData(0xe39f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_phone</i> &#x2014; material icon named "local phone" (sharp).
  static const IconData local_phone_sharp = IconData(0xea99, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_phone</i> &#x2014; material icon named "local phone" (round).
  static const IconData local_phone_rounded = IconData(0xf878, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_phone</i> &#x2014; material icon named "local phone" (outlined).
  static const IconData local_phone_outlined = IconData(0xf187, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_pizza</i> &#x2014; material icon named "local pizza".
  static const IconData local_pizza = IconData(0xe3a0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_pizza</i> &#x2014; material icon named "local pizza" (sharp).
  static const IconData local_pizza_sharp = IconData(0xea9a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_pizza</i> &#x2014; material icon named "local pizza" (round).
  static const IconData local_pizza_rounded = IconData(0xf879, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_pizza</i> &#x2014; material icon named "local pizza" (outlined).
  static const IconData local_pizza_outlined = IconData(0xf188, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_play</i> &#x2014; material icon named "local play".
  static const IconData local_play = IconData(0xe3a1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_play</i> &#x2014; material icon named "local play" (sharp).
  static const IconData local_play_sharp = IconData(0xea9b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_play</i> &#x2014; material icon named "local play" (round).
  static const IconData local_play_rounded = IconData(0xf87a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_play</i> &#x2014; material icon named "local play" (outlined).
  static const IconData local_play_outlined = IconData(0xf189, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_police</i> &#x2014; material icon named "local police".
  static const IconData local_police = IconData(0xe3a2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_police</i> &#x2014; material icon named "local police" (sharp).
  static const IconData local_police_sharp = IconData(0xea9c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_police</i> &#x2014; material icon named "local police" (round).
  static const IconData local_police_rounded = IconData(0xf87b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_police</i> &#x2014; material icon named "local police" (outlined).
  static const IconData local_police_outlined = IconData(0xf18a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_post_office</i> &#x2014; material icon named "local post office".
  static const IconData local_post_office = IconData(0xe3a3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_post_office</i> &#x2014; material icon named "local post office" (sharp).
  static const IconData local_post_office_sharp = IconData(0xea9d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_post_office</i> &#x2014; material icon named "local post office" (round).
  static const IconData local_post_office_rounded = IconData(0xf87c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_post_office</i> &#x2014; material icon named "local post office" (outlined).
  static const IconData local_post_office_outlined = IconData(0xf18b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_print_shop</i> &#x2014; material icon named "local print shop".
  static const IconData local_print_shop = IconData(0xe3a4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_print_shop</i> &#x2014; material icon named "local print shop" (sharp).
  static const IconData local_print_shop_sharp = IconData(0xea9e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_print_shop</i> &#x2014; material icon named "local print shop" (round).
  static const IconData local_print_shop_rounded = IconData(0xf87d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_print_shop</i> &#x2014; material icon named "local print shop" (outlined).
  static const IconData local_print_shop_outlined = IconData(0xf18c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_printshop</i> &#x2014; material icon named "local printshop".
  static const IconData local_printshop = IconData(0xe3a4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_printshop</i> &#x2014; material icon named "local printshop" (sharp).
  static const IconData local_printshop_sharp = IconData(0xea9e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_printshop</i> &#x2014; material icon named "local printshop" (round).
  static const IconData local_printshop_rounded = IconData(0xf87d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_printshop</i> &#x2014; material icon named "local printshop" (outlined).
  static const IconData local_printshop_outlined = IconData(0xf18c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_restaurant</i> &#x2014; material icon named "local restaurant".
  static const IconData local_restaurant = IconData(0xe390, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_restaurant</i> &#x2014; material icon named "local restaurant" (sharp).
  static const IconData local_restaurant_sharp = IconData(0xea8a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_restaurant</i> &#x2014; material icon named "local restaurant" (round).
  static const IconData local_restaurant_rounded = IconData(0xf869, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_restaurant</i> &#x2014; material icon named "local restaurant" (outlined).
  static const IconData local_restaurant_outlined = IconData(0xf178, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_see</i> &#x2014; material icon named "local see".
  static const IconData local_see = IconData(0xe3a5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_see</i> &#x2014; material icon named "local see" (sharp).
  static const IconData local_see_sharp = IconData(0xea9f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_see</i> &#x2014; material icon named "local see" (round).
  static const IconData local_see_rounded = IconData(0xf87e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_see</i> &#x2014; material icon named "local see" (outlined).
  static const IconData local_see_outlined = IconData(0xf18d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_shipping</i> &#x2014; material icon named "local shipping".
  static const IconData local_shipping = IconData(0xe3a6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_shipping</i> &#x2014; material icon named "local shipping" (sharp).
  static const IconData local_shipping_sharp = IconData(0xeaa0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_shipping</i> &#x2014; material icon named "local shipping" (round).
  static const IconData local_shipping_rounded = IconData(0xf87f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_shipping</i> &#x2014; material icon named "local shipping" (outlined).
  static const IconData local_shipping_outlined = IconData(0xf18e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">local_taxi</i> &#x2014; material icon named "local taxi".
  static const IconData local_taxi = IconData(0xe3a7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">local_taxi</i> &#x2014; material icon named "local taxi" (sharp).
  static const IconData local_taxi_sharp = IconData(0xeaa1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">local_taxi</i> &#x2014; material icon named "local taxi" (round).
  static const IconData local_taxi_rounded = IconData(0xf880, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">local_taxi</i> &#x2014; material icon named "local taxi" (outlined).
  static const IconData local_taxi_outlined = IconData(0xf18f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">location_city</i> &#x2014; material icon named "location city".
  static const IconData location_city = IconData(0xe3a8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">location_city</i> &#x2014; material icon named "location city" (sharp).
  static const IconData location_city_sharp = IconData(0xeaa2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">location_city</i> &#x2014; material icon named "location city" (round).
  static const IconData location_city_rounded = IconData(0xf881, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">location_city</i> &#x2014; material icon named "location city" (outlined).
  static const IconData location_city_outlined = IconData(0xf190, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">location_disabled</i> &#x2014; material icon named "location disabled".
  static const IconData location_disabled = IconData(0xe3a9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">location_disabled</i> &#x2014; material icon named "location disabled" (sharp).
  static const IconData location_disabled_sharp = IconData(0xeaa3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">location_disabled</i> &#x2014; material icon named "location disabled" (round).
  static const IconData location_disabled_rounded = IconData(0xf882, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">location_disabled</i> &#x2014; material icon named "location disabled" (outlined).
  static const IconData location_disabled_outlined = IconData(0xf191, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">location_history</i> &#x2014; material icon named "location history".
  static const IconData location_history = IconData(0xe498, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">location_history</i> &#x2014; material icon named "location history" (sharp).
  static const IconData location_history_sharp = IconData(0xeb8f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">location_history</i> &#x2014; material icon named "location history" (round).
  static const IconData location_history_rounded = IconData(0xf006e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">location_history</i> &#x2014; material icon named "location history" (outlined).
  static const IconData location_history_outlined = IconData(0xf27d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">location_off</i> &#x2014; material icon named "location off".
  static const IconData location_off = IconData(0xe3aa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">location_off</i> &#x2014; material icon named "location off" (sharp).
  static const IconData location_off_sharp = IconData(0xeaa4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">location_off</i> &#x2014; material icon named "location off" (round).
  static const IconData location_off_rounded = IconData(0xf883, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">location_off</i> &#x2014; material icon named "location off" (outlined).
  static const IconData location_off_outlined = IconData(0xf192, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">location_on</i> &#x2014; material icon named "location on".
  static const IconData location_on = IconData(0xe3ab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">location_on</i> &#x2014; material icon named "location on" (sharp).
  static const IconData location_on_sharp = IconData(0xeaa5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">location_on</i> &#x2014; material icon named "location on" (round).
  static const IconData location_on_rounded = IconData(0xf884, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">location_on</i> &#x2014; material icon named "location on" (outlined).
  static const IconData location_on_outlined = IconData(0xf193, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">location_pin</i> &#x2014; material icon named "location pin".
  static const IconData location_pin = IconData(0xe3ac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">location_searching</i> &#x2014; material icon named "location searching".
  static const IconData location_searching = IconData(0xe3ad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">location_searching</i> &#x2014; material icon named "location searching" (sharp).
  static const IconData location_searching_sharp = IconData(0xeaa6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">location_searching</i> &#x2014; material icon named "location searching" (round).
  static const IconData location_searching_rounded = IconData(0xf885, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">location_searching</i> &#x2014; material icon named "location searching" (outlined).
  static const IconData location_searching_outlined = IconData(0xf194, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">lock</i> &#x2014; material icon named "lock".
  static const IconData lock = IconData(0xe3ae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">lock</i> &#x2014; material icon named "lock" (sharp).
  static const IconData lock_sharp = IconData(0xeaaa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">lock</i> &#x2014; material icon named "lock" (round).
  static const IconData lock_rounded = IconData(0xf889, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">lock</i> &#x2014; material icon named "lock" (outlined).
  static const IconData lock_outlined = IconData(0xf197, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">lock_clock</i> &#x2014; material icon named "lock clock".
  static const IconData lock_clock = IconData(0xe3af, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">lock_clock</i> &#x2014; material icon named "lock clock" (sharp).
  static const IconData lock_clock_sharp = IconData(0xeaa7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">lock_clock</i> &#x2014; material icon named "lock clock" (round).
  static const IconData lock_clock_rounded = IconData(0xf886, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">lock_clock</i> &#x2014; material icon named "lock clock" (outlined).
  static const IconData lock_clock_outlined = IconData(0xf195, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">lock_open</i> &#x2014; material icon named "lock open".
  static const IconData lock_open = IconData(0xe3b0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">lock_open</i> &#x2014; material icon named "lock open" (sharp).
  static const IconData lock_open_sharp = IconData(0xeaa8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">lock_open</i> &#x2014; material icon named "lock open" (round).
  static const IconData lock_open_rounded = IconData(0xf887, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">lock_open</i> &#x2014; material icon named "lock open" (outlined).
  static const IconData lock_open_outlined = IconData(0xf196, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">lock_outline</i> &#x2014; material icon named "lock outline".
  static const IconData lock_outline = IconData(0xe3b1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">lock_outline</i> &#x2014; material icon named "lock outline" (sharp).
  static const IconData lock_outline_sharp = IconData(0xeaa9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">lock_outline</i> &#x2014; material icon named "lock outline" (round).
  static const IconData lock_outline_rounded = IconData(0xf888, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">login</i> &#x2014; material icon named "login".
  static const IconData login = IconData(0xe3b2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">login</i> &#x2014; material icon named "login" (sharp).
  static const IconData login_sharp = IconData(0xeaab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">login</i> &#x2014; material icon named "login" (round).
  static const IconData login_rounded = IconData(0xf88a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">login</i> &#x2014; material icon named "login" (outlined).
  static const IconData login_outlined = IconData(0xf198, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">logout</i> &#x2014; material icon named "logout".
  static const IconData logout = IconData(0xe3b3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">logout</i> &#x2014; material icon named "logout" (sharp).
  static const IconData logout_sharp = IconData(0xeaac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">logout</i> &#x2014; material icon named "logout" (round).
  static const IconData logout_rounded = IconData(0xf88b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">logout</i> &#x2014; material icon named "logout" (outlined).
  static const IconData logout_outlined = IconData(0xf199, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">looks</i> &#x2014; material icon named "looks".
  static const IconData looks = IconData(0xe3b4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">looks</i> &#x2014; material icon named "looks" (sharp).
  static const IconData looks_sharp = IconData(0xeab2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">looks</i> &#x2014; material icon named "looks" (round).
  static const IconData looks_rounded = IconData(0xf891, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">looks</i> &#x2014; material icon named "looks" (outlined).
  static const IconData looks_outlined = IconData(0xf19f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">looks_3</i> &#x2014; material icon named "looks 3".
  static const IconData looks_3 = IconData(0xe3b5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">looks_3</i> &#x2014; material icon named "looks 3" (sharp).
  static const IconData looks_3_sharp = IconData(0xeaad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">looks_3</i> &#x2014; material icon named "looks 3" (round).
  static const IconData looks_3_rounded = IconData(0xf88c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">looks_3</i> &#x2014; material icon named "looks 3" (outlined).
  static const IconData looks_3_outlined = IconData(0xf19a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">looks_4</i> &#x2014; material icon named "looks 4".
  static const IconData looks_4 = IconData(0xe3b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">looks_4</i> &#x2014; material icon named "looks 4" (sharp).
  static const IconData looks_4_sharp = IconData(0xeaae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">looks_4</i> &#x2014; material icon named "looks 4" (round).
  static const IconData looks_4_rounded = IconData(0xf88d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">looks_4</i> &#x2014; material icon named "looks 4" (outlined).
  static const IconData looks_4_outlined = IconData(0xf19b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">looks_5</i> &#x2014; material icon named "looks 5".
  static const IconData looks_5 = IconData(0xe3b7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">looks_5</i> &#x2014; material icon named "looks 5" (sharp).
  static const IconData looks_5_sharp = IconData(0xeaaf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">looks_5</i> &#x2014; material icon named "looks 5" (round).
  static const IconData looks_5_rounded = IconData(0xf88e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">looks_5</i> &#x2014; material icon named "looks 5" (outlined).
  static const IconData looks_5_outlined = IconData(0xf19c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">looks_6</i> &#x2014; material icon named "looks 6".
  static const IconData looks_6 = IconData(0xe3b8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">looks_6</i> &#x2014; material icon named "looks 6" (sharp).
  static const IconData looks_6_sharp = IconData(0xeab0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">looks_6</i> &#x2014; material icon named "looks 6" (round).
  static const IconData looks_6_rounded = IconData(0xf88f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">looks_6</i> &#x2014; material icon named "looks 6" (outlined).
  static const IconData looks_6_outlined = IconData(0xf19d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">looks_one</i> &#x2014; material icon named "looks one".
  static const IconData looks_one = IconData(0xe3b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">looks_one</i> &#x2014; material icon named "looks one" (sharp).
  static const IconData looks_one_sharp = IconData(0xeab1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">looks_one</i> &#x2014; material icon named "looks one" (round).
  static const IconData looks_one_rounded = IconData(0xf890, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">looks_one</i> &#x2014; material icon named "looks one" (outlined).
  static const IconData looks_one_outlined = IconData(0xf19e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">looks_two</i> &#x2014; material icon named "looks two".
  static const IconData looks_two = IconData(0xe3ba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">looks_two</i> &#x2014; material icon named "looks two" (sharp).
  static const IconData looks_two_sharp = IconData(0xeab3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">looks_two</i> &#x2014; material icon named "looks two" (round).
  static const IconData looks_two_rounded = IconData(0xf892, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">looks_two</i> &#x2014; material icon named "looks two" (outlined).
  static const IconData looks_two_outlined = IconData(0xf1a0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">loop</i> &#x2014; material icon named "loop".
  static const IconData loop = IconData(0xe3bb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">loop</i> &#x2014; material icon named "loop" (sharp).
  static const IconData loop_sharp = IconData(0xeab4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">loop</i> &#x2014; material icon named "loop" (round).
  static const IconData loop_rounded = IconData(0xf893, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">loop</i> &#x2014; material icon named "loop" (outlined).
  static const IconData loop_outlined = IconData(0xf1a1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">loupe</i> &#x2014; material icon named "loupe".
  static const IconData loupe = IconData(0xe3bc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">loupe</i> &#x2014; material icon named "loupe" (sharp).
  static const IconData loupe_sharp = IconData(0xeab5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">loupe</i> &#x2014; material icon named "loupe" (round).
  static const IconData loupe_rounded = IconData(0xf894, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">loupe</i> &#x2014; material icon named "loupe" (outlined).
  static const IconData loupe_outlined = IconData(0xf1a2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">low_priority</i> &#x2014; material icon named "low priority".
  static const IconData low_priority = IconData(0xe3bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">low_priority</i> &#x2014; material icon named "low priority" (sharp).
  static const IconData low_priority_sharp = IconData(0xeab6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">low_priority</i> &#x2014; material icon named "low priority" (round).
  static const IconData low_priority_rounded = IconData(0xf895, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">low_priority</i> &#x2014; material icon named "low priority" (outlined).
  static const IconData low_priority_outlined = IconData(0xf1a3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">loyalty</i> &#x2014; material icon named "loyalty".
  static const IconData loyalty = IconData(0xe3be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">loyalty</i> &#x2014; material icon named "loyalty" (sharp).
  static const IconData loyalty_sharp = IconData(0xeab7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">loyalty</i> &#x2014; material icon named "loyalty" (round).
  static const IconData loyalty_rounded = IconData(0xf896, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">loyalty</i> &#x2014; material icon named "loyalty" (outlined).
  static const IconData loyalty_outlined = IconData(0xf1a4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">lte_mobiledata</i> &#x2014; material icon named "lte mobiledata".
  static const IconData lte_mobiledata = IconData(0xe3bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">lte_mobiledata</i> &#x2014; material icon named "lte mobiledata" (sharp).
  static const IconData lte_mobiledata_sharp = IconData(0xeab8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">lte_mobiledata</i> &#x2014; material icon named "lte mobiledata" (round).
  static const IconData lte_mobiledata_rounded = IconData(0xf897, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">lte_mobiledata</i> &#x2014; material icon named "lte mobiledata" (outlined).
  static const IconData lte_mobiledata_outlined = IconData(0xf1a5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">lte_plus_mobiledata</i> &#x2014; material icon named "lte plus mobiledata".
  static const IconData lte_plus_mobiledata = IconData(0xe3c0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">lte_plus_mobiledata</i> &#x2014; material icon named "lte plus mobiledata" (sharp).
  static const IconData lte_plus_mobiledata_sharp = IconData(0xeab9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">lte_plus_mobiledata</i> &#x2014; material icon named "lte plus mobiledata" (round).
  static const IconData lte_plus_mobiledata_rounded = IconData(0xf898, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">lte_plus_mobiledata</i> &#x2014; material icon named "lte plus mobiledata" (outlined).
  static const IconData lte_plus_mobiledata_outlined = IconData(0xf1a6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">luggage</i> &#x2014; material icon named "luggage".
  static const IconData luggage = IconData(0xe3c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">luggage</i> &#x2014; material icon named "luggage" (sharp).
  static const IconData luggage_sharp = IconData(0xeaba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">luggage</i> &#x2014; material icon named "luggage" (round).
  static const IconData luggage_rounded = IconData(0xf899, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">luggage</i> &#x2014; material icon named "luggage" (outlined).
  static const IconData luggage_outlined = IconData(0xf1a7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">lunch_dining</i> &#x2014; material icon named "lunch dining".
  static const IconData lunch_dining = IconData(0xe3c2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">lunch_dining</i> &#x2014; material icon named "lunch dining" (sharp).
  static const IconData lunch_dining_sharp = IconData(0xeabb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">lunch_dining</i> &#x2014; material icon named "lunch dining" (round).
  static const IconData lunch_dining_rounded = IconData(0xf89a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">lunch_dining</i> &#x2014; material icon named "lunch dining" (outlined).
  static const IconData lunch_dining_outlined = IconData(0xf1a8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mail</i> &#x2014; material icon named "mail".
  static const IconData mail = IconData(0xe3c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mail</i> &#x2014; material icon named "mail" (sharp).
  static const IconData mail_sharp = IconData(0xeabd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mail</i> &#x2014; material icon named "mail" (round).
  static const IconData mail_rounded = IconData(0xf89c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mail</i> &#x2014; material icon named "mail" (outlined).
  static const IconData mail_outlined = IconData(0xf1aa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mail_outline</i> &#x2014; material icon named "mail outline".
  static const IconData mail_outline = IconData(0xe3c4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mail_outline</i> &#x2014; material icon named "mail outline" (sharp).
  static const IconData mail_outline_sharp = IconData(0xeabc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mail_outline</i> &#x2014; material icon named "mail outline" (round).
  static const IconData mail_outline_rounded = IconData(0xf89b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mail_outline</i> &#x2014; material icon named "mail outline" (outlined).
  static const IconData mail_outline_outlined = IconData(0xf1a9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">male</i> &#x2014; material icon named "male".
  static const IconData male = IconData(0xe3c5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">male</i> &#x2014; material icon named "male" (sharp).
  static const IconData male_sharp = IconData(0xeabe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">male</i> &#x2014; material icon named "male" (round).
  static const IconData male_rounded = IconData(0xf89d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">male</i> &#x2014; material icon named "male" (outlined).
  static const IconData male_outlined = IconData(0xf1ab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">manage_accounts</i> &#x2014; material icon named "manage accounts".
  static const IconData manage_accounts = IconData(0xe3c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">manage_accounts</i> &#x2014; material icon named "manage accounts" (sharp).
  static const IconData manage_accounts_sharp = IconData(0xeabf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">manage_accounts</i> &#x2014; material icon named "manage accounts" (round).
  static const IconData manage_accounts_rounded = IconData(0xf89e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">manage_accounts</i> &#x2014; material icon named "manage accounts" (outlined).
  static const IconData manage_accounts_outlined = IconData(0xf1ac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">manage_search</i> &#x2014; material icon named "manage search".
  static const IconData manage_search = IconData(0xe3c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">manage_search</i> &#x2014; material icon named "manage search" (sharp).
  static const IconData manage_search_sharp = IconData(0xeac0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">manage_search</i> &#x2014; material icon named "manage search" (round).
  static const IconData manage_search_rounded = IconData(0xf89f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">manage_search</i> &#x2014; material icon named "manage search" (outlined).
  static const IconData manage_search_outlined = IconData(0xf1ad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">map</i> &#x2014; material icon named "map".
  static const IconData map = IconData(0xe3c8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">map</i> &#x2014; material icon named "map" (sharp).
  static const IconData map_sharp = IconData(0xeac1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">map</i> &#x2014; material icon named "map" (round).
  static const IconData map_rounded = IconData(0xf8a0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">map</i> &#x2014; material icon named "map" (outlined).
  static const IconData map_outlined = IconData(0xf1ae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">maps_home_work</i> &#x2014; material icon named "maps home work".
  static const IconData maps_home_work = IconData(0xe3c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">maps_home_work</i> &#x2014; material icon named "maps home work" (sharp).
  static const IconData maps_home_work_sharp = IconData(0xeac2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">maps_home_work</i> &#x2014; material icon named "maps home work" (round).
  static const IconData maps_home_work_rounded = IconData(0xf8a1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">maps_home_work</i> &#x2014; material icon named "maps home work" (outlined).
  static const IconData maps_home_work_outlined = IconData(0xf1af, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">maps_ugc</i> &#x2014; material icon named "maps ugc".
  static const IconData maps_ugc = IconData(0xe3ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">maps_ugc</i> &#x2014; material icon named "maps ugc" (sharp).
  static const IconData maps_ugc_sharp = IconData(0xeac3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">maps_ugc</i> &#x2014; material icon named "maps ugc" (round).
  static const IconData maps_ugc_rounded = IconData(0xf8a2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">maps_ugc</i> &#x2014; material icon named "maps ugc" (outlined).
  static const IconData maps_ugc_outlined = IconData(0xf1b0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">margin</i> &#x2014; material icon named "margin".
  static const IconData margin = IconData(0xe3cb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">margin</i> &#x2014; material icon named "margin" (sharp).
  static const IconData margin_sharp = IconData(0xeac4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">margin</i> &#x2014; material icon named "margin" (round).
  static const IconData margin_rounded = IconData(0xf8a3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">margin</i> &#x2014; material icon named "margin" (outlined).
  static const IconData margin_outlined = IconData(0xf1b1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mark_as_unread</i> &#x2014; material icon named "mark as unread".
  static const IconData mark_as_unread = IconData(0xe3cc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mark_as_unread</i> &#x2014; material icon named "mark as unread" (sharp).
  static const IconData mark_as_unread_sharp = IconData(0xeac5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mark_as_unread</i> &#x2014; material icon named "mark as unread" (round).
  static const IconData mark_as_unread_rounded = IconData(0xf8a4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mark_as_unread</i> &#x2014; material icon named "mark as unread" (outlined).
  static const IconData mark_as_unread_outlined = IconData(0xf1b2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mark_chat_read</i> &#x2014; material icon named "mark chat read".
  static const IconData mark_chat_read = IconData(0xe3cd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mark_chat_read</i> &#x2014; material icon named "mark chat read" (sharp).
  static const IconData mark_chat_read_sharp = IconData(0xeac6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mark_chat_read</i> &#x2014; material icon named "mark chat read" (round).
  static const IconData mark_chat_read_rounded = IconData(0xf8a5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mark_chat_read</i> &#x2014; material icon named "mark chat read" (outlined).
  static const IconData mark_chat_read_outlined = IconData(0xf1b3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mark_chat_unread</i> &#x2014; material icon named "mark chat unread".
  static const IconData mark_chat_unread = IconData(0xe3ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mark_chat_unread</i> &#x2014; material icon named "mark chat unread" (sharp).
  static const IconData mark_chat_unread_sharp = IconData(0xeac7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mark_chat_unread</i> &#x2014; material icon named "mark chat unread" (round).
  static const IconData mark_chat_unread_rounded = IconData(0xf8a6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mark_chat_unread</i> &#x2014; material icon named "mark chat unread" (outlined).
  static const IconData mark_chat_unread_outlined = IconData(0xf1b4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mark_email_read</i> &#x2014; material icon named "mark email read".
  static const IconData mark_email_read = IconData(0xe3cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mark_email_read</i> &#x2014; material icon named "mark email read" (sharp).
  static const IconData mark_email_read_sharp = IconData(0xeac8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mark_email_read</i> &#x2014; material icon named "mark email read" (round).
  static const IconData mark_email_read_rounded = IconData(0xf8a7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mark_email_read</i> &#x2014; material icon named "mark email read" (outlined).
  static const IconData mark_email_read_outlined = IconData(0xf1b5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mark_email_unread</i> &#x2014; material icon named "mark email unread".
  static const IconData mark_email_unread = IconData(0xe3d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mark_email_unread</i> &#x2014; material icon named "mark email unread" (sharp).
  static const IconData mark_email_unread_sharp = IconData(0xeac9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mark_email_unread</i> &#x2014; material icon named "mark email unread" (round).
  static const IconData mark_email_unread_rounded = IconData(0xf8a8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mark_email_unread</i> &#x2014; material icon named "mark email unread" (outlined).
  static const IconData mark_email_unread_outlined = IconData(0xf1b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">markunread</i> &#x2014; material icon named "markunread".
  static const IconData markunread = IconData(0xe3d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">markunread</i> &#x2014; material icon named "markunread" (sharp).
  static const IconData markunread_sharp = IconData(0xeacb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">markunread</i> &#x2014; material icon named "markunread" (round).
  static const IconData markunread_rounded = IconData(0xf8aa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">markunread</i> &#x2014; material icon named "markunread" (outlined).
  static const IconData markunread_outlined = IconData(0xf1b8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">markunread_mailbox</i> &#x2014; material icon named "markunread mailbox".
  static const IconData markunread_mailbox = IconData(0xe3d2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">markunread_mailbox</i> &#x2014; material icon named "markunread mailbox" (sharp).
  static const IconData markunread_mailbox_sharp = IconData(0xeaca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">markunread_mailbox</i> &#x2014; material icon named "markunread mailbox" (round).
  static const IconData markunread_mailbox_rounded = IconData(0xf8a9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">markunread_mailbox</i> &#x2014; material icon named "markunread mailbox" (outlined).
  static const IconData markunread_mailbox_outlined = IconData(0xf1b7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">masks</i> &#x2014; material icon named "masks".
  static const IconData masks = IconData(0xe3d3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">masks</i> &#x2014; material icon named "masks" (sharp).
  static const IconData masks_sharp = IconData(0xeacc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">masks</i> &#x2014; material icon named "masks" (round).
  static const IconData masks_rounded = IconData(0xf8ab, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">masks</i> &#x2014; material icon named "masks" (outlined).
  static const IconData masks_outlined = IconData(0xf1b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">maximize</i> &#x2014; material icon named "maximize".
  static const IconData maximize = IconData(0xe3d4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">maximize</i> &#x2014; material icon named "maximize" (sharp).
  static const IconData maximize_sharp = IconData(0xeacd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">maximize</i> &#x2014; material icon named "maximize" (round).
  static const IconData maximize_rounded = IconData(0xf8ac, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">maximize</i> &#x2014; material icon named "maximize" (outlined).
  static const IconData maximize_outlined = IconData(0xf1ba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">media_bluetooth_off</i> &#x2014; material icon named "media bluetooth off".
  static const IconData media_bluetooth_off = IconData(0xe3d5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">media_bluetooth_off</i> &#x2014; material icon named "media bluetooth off" (sharp).
  static const IconData media_bluetooth_off_sharp = IconData(0xeace, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">media_bluetooth_off</i> &#x2014; material icon named "media bluetooth off" (round).
  static const IconData media_bluetooth_off_rounded = IconData(0xf8ad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">media_bluetooth_off</i> &#x2014; material icon named "media bluetooth off" (outlined).
  static const IconData media_bluetooth_off_outlined = IconData(0xf1bb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">media_bluetooth_on</i> &#x2014; material icon named "media bluetooth on".
  static const IconData media_bluetooth_on = IconData(0xe3d6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">media_bluetooth_on</i> &#x2014; material icon named "media bluetooth on" (sharp).
  static const IconData media_bluetooth_on_sharp = IconData(0xeacf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">media_bluetooth_on</i> &#x2014; material icon named "media bluetooth on" (round).
  static const IconData media_bluetooth_on_rounded = IconData(0xf8ae, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">media_bluetooth_on</i> &#x2014; material icon named "media bluetooth on" (outlined).
  static const IconData media_bluetooth_on_outlined = IconData(0xf1bc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mediation</i> &#x2014; material icon named "mediation".
  static const IconData mediation = IconData(0xe3d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mediation</i> &#x2014; material icon named "mediation" (sharp).
  static const IconData mediation_sharp = IconData(0xead0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mediation</i> &#x2014; material icon named "mediation" (round).
  static const IconData mediation_rounded = IconData(0xf8af, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mediation</i> &#x2014; material icon named "mediation" (outlined).
  static const IconData mediation_outlined = IconData(0xf1bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">medical_services</i> &#x2014; material icon named "medical services".
  static const IconData medical_services = IconData(0xe3d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">medical_services</i> &#x2014; material icon named "medical services" (sharp).
  static const IconData medical_services_sharp = IconData(0xead1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">medical_services</i> &#x2014; material icon named "medical services" (round).
  static const IconData medical_services_rounded = IconData(0xf8b0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">medical_services</i> &#x2014; material icon named "medical services" (outlined).
  static const IconData medical_services_outlined = IconData(0xf1be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">medication</i> &#x2014; material icon named "medication".
  static const IconData medication = IconData(0xe3d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">medication</i> &#x2014; material icon named "medication" (sharp).
  static const IconData medication_sharp = IconData(0xead2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">medication</i> &#x2014; material icon named "medication" (round).
  static const IconData medication_rounded = IconData(0xf8b1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">medication</i> &#x2014; material icon named "medication" (outlined).
  static const IconData medication_outlined = IconData(0xf1bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">meeting_room</i> &#x2014; material icon named "meeting room".
  static const IconData meeting_room = IconData(0xe3da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">meeting_room</i> &#x2014; material icon named "meeting room" (sharp).
  static const IconData meeting_room_sharp = IconData(0xead3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">meeting_room</i> &#x2014; material icon named "meeting room" (round).
  static const IconData meeting_room_rounded = IconData(0xf8b2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">meeting_room</i> &#x2014; material icon named "meeting room" (outlined).
  static const IconData meeting_room_outlined = IconData(0xf1c0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">memory</i> &#x2014; material icon named "memory".
  static const IconData memory = IconData(0xe3db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">memory</i> &#x2014; material icon named "memory" (sharp).
  static const IconData memory_sharp = IconData(0xead4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">memory</i> &#x2014; material icon named "memory" (round).
  static const IconData memory_rounded = IconData(0xf8b3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">memory</i> &#x2014; material icon named "memory" (outlined).
  static const IconData memory_outlined = IconData(0xf1c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">menu</i> &#x2014; material icon named "menu".
  static const IconData menu = IconData(0xe3dc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">menu</i> &#x2014; material icon named "menu" (sharp).
  static const IconData menu_sharp = IconData(0xead7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">menu</i> &#x2014; material icon named "menu" (round).
  static const IconData menu_rounded = IconData(0xf8b6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">menu</i> &#x2014; material icon named "menu" (outlined).
  static const IconData menu_outlined = IconData(0xf1c4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">menu_book</i> &#x2014; material icon named "menu book".
  static const IconData menu_book = IconData(0xe3dd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">menu_book</i> &#x2014; material icon named "menu book" (sharp).
  static const IconData menu_book_sharp = IconData(0xead5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">menu_book</i> &#x2014; material icon named "menu book" (round).
  static const IconData menu_book_rounded = IconData(0xf8b4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">menu_book</i> &#x2014; material icon named "menu book" (outlined).
  static const IconData menu_book_outlined = IconData(0xf1c2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">menu_open</i> &#x2014; material icon named "menu open".
  static const IconData menu_open = IconData(0xe3de, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">menu_open</i> &#x2014; material icon named "menu open" (sharp).
  static const IconData menu_open_sharp = IconData(0xead6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">menu_open</i> &#x2014; material icon named "menu open" (round).
  static const IconData menu_open_rounded = IconData(0xf8b5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">menu_open</i> &#x2014; material icon named "menu open" (outlined).
  static const IconData menu_open_outlined = IconData(0xf1c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">merge_type</i> &#x2014; material icon named "merge type".
  static const IconData merge_type = IconData(0xe3df, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">merge_type</i> &#x2014; material icon named "merge type" (sharp).
  static const IconData merge_type_sharp = IconData(0xead8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">merge_type</i> &#x2014; material icon named "merge type" (round).
  static const IconData merge_type_rounded = IconData(0xf8b7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">merge_type</i> &#x2014; material icon named "merge type" (outlined).
  static const IconData merge_type_outlined = IconData(0xf1c5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">message</i> &#x2014; material icon named "message".
  static const IconData message = IconData(0xe3e0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">message</i> &#x2014; material icon named "message" (sharp).
  static const IconData message_sharp = IconData(0xead9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">message</i> &#x2014; material icon named "message" (round).
  static const IconData message_rounded = IconData(0xf8b8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">message</i> &#x2014; material icon named "message" (outlined).
  static const IconData message_outlined = IconData(0xf1c6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">messenger</i> &#x2014; material icon named "messenger".
  static const IconData messenger = IconData(0xe154, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">messenger</i> &#x2014; material icon named "messenger" (sharp).
  static const IconData messenger_sharp = IconData(0xe851, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">messenger</i> &#x2014; material icon named "messenger" (round).
  static const IconData messenger_rounded = IconData(0xf630, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">messenger</i> &#x2014; material icon named "messenger" (outlined).
  static const IconData messenger_outlined = IconData(0xef43, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">messenger_outline</i> &#x2014; material icon named "messenger outline".
  static const IconData messenger_outline = IconData(0xe155, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">messenger_outline</i> &#x2014; material icon named "messenger outline" (sharp).
  static const IconData messenger_outline_sharp = IconData(0xe850, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">messenger_outline</i> &#x2014; material icon named "messenger outline" (round).
  static const IconData messenger_outline_rounded = IconData(0xf62f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">messenger_outline</i> &#x2014; material icon named "messenger outline" (outlined).
  static const IconData messenger_outline_outlined = IconData(0xef42, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mic</i> &#x2014; material icon named "mic".
  static const IconData mic = IconData(0xe3e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mic</i> &#x2014; material icon named "mic" (sharp).
  static const IconData mic_sharp = IconData(0xeade, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mic</i> &#x2014; material icon named "mic" (round).
  static const IconData mic_rounded = IconData(0xf8bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mic</i> &#x2014; material icon named "mic" (outlined).
  static const IconData mic_outlined = IconData(0xf1cb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mic_external_off</i> &#x2014; material icon named "mic external off".
  static const IconData mic_external_off = IconData(0xe3e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mic_external_off</i> &#x2014; material icon named "mic external off" (sharp).
  static const IconData mic_external_off_sharp = IconData(0xeada, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mic_external_off</i> &#x2014; material icon named "mic external off" (round).
  static const IconData mic_external_off_rounded = IconData(0xf8b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mic_external_off</i> &#x2014; material icon named "mic external off" (outlined).
  static const IconData mic_external_off_outlined = IconData(0xf1c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mic_external_on</i> &#x2014; material icon named "mic external on".
  static const IconData mic_external_on = IconData(0xe3e3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mic_external_on</i> &#x2014; material icon named "mic external on" (sharp).
  static const IconData mic_external_on_sharp = IconData(0xeadb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mic_external_on</i> &#x2014; material icon named "mic external on" (round).
  static const IconData mic_external_on_rounded = IconData(0xf8ba, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mic_external_on</i> &#x2014; material icon named "mic external on" (outlined).
  static const IconData mic_external_on_outlined = IconData(0xf1c8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mic_none</i> &#x2014; material icon named "mic none".
  static const IconData mic_none = IconData(0xe3e4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mic_none</i> &#x2014; material icon named "mic none" (sharp).
  static const IconData mic_none_sharp = IconData(0xeadc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mic_none</i> &#x2014; material icon named "mic none" (round).
  static const IconData mic_none_rounded = IconData(0xf8bb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mic_none</i> &#x2014; material icon named "mic none" (outlined).
  static const IconData mic_none_outlined = IconData(0xf1c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mic_off</i> &#x2014; material icon named "mic off".
  static const IconData mic_off = IconData(0xe3e5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mic_off</i> &#x2014; material icon named "mic off" (sharp).
  static const IconData mic_off_sharp = IconData(0xeadd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mic_off</i> &#x2014; material icon named "mic off" (round).
  static const IconData mic_off_rounded = IconData(0xf8bc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mic_off</i> &#x2014; material icon named "mic off" (outlined).
  static const IconData mic_off_outlined = IconData(0xf1ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">microwave</i> &#x2014; material icon named "microwave".
  static const IconData microwave = IconData(0xe3e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">microwave</i> &#x2014; material icon named "microwave" (sharp).
  static const IconData microwave_sharp = IconData(0xeadf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">microwave</i> &#x2014; material icon named "microwave" (round).
  static const IconData microwave_rounded = IconData(0xf8be, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">microwave</i> &#x2014; material icon named "microwave" (outlined).
  static const IconData microwave_outlined = IconData(0xf1cc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">military_tech</i> &#x2014; material icon named "military tech".
  static const IconData military_tech = IconData(0xe3e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">military_tech</i> &#x2014; material icon named "military tech" (sharp).
  static const IconData military_tech_sharp = IconData(0xeae0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">military_tech</i> &#x2014; material icon named "military tech" (round).
  static const IconData military_tech_rounded = IconData(0xf8bf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">military_tech</i> &#x2014; material icon named "military tech" (outlined).
  static const IconData military_tech_outlined = IconData(0xf1cd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">minimize</i> &#x2014; material icon named "minimize".
  static const IconData minimize = IconData(0xe3e8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">minimize</i> &#x2014; material icon named "minimize" (sharp).
  static const IconData minimize_sharp = IconData(0xeae1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">minimize</i> &#x2014; material icon named "minimize" (round).
  static const IconData minimize_rounded = IconData(0xf8c0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">minimize</i> &#x2014; material icon named "minimize" (outlined).
  static const IconData minimize_outlined = IconData(0xf1ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">miscellaneous_services</i> &#x2014; material icon named "miscellaneous services".
  static const IconData miscellaneous_services = IconData(0xe3e9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">miscellaneous_services</i> &#x2014; material icon named "miscellaneous services" (sharp).
  static const IconData miscellaneous_services_sharp = IconData(0xeae2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">miscellaneous_services</i> &#x2014; material icon named "miscellaneous services" (round).
  static const IconData miscellaneous_services_rounded = IconData(0xf8c1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">miscellaneous_services</i> &#x2014; material icon named "miscellaneous services" (outlined).
  static const IconData miscellaneous_services_outlined = IconData(0xf1cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">missed_video_call</i> &#x2014; material icon named "missed video call".
  static const IconData missed_video_call = IconData(0xe3ea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">missed_video_call</i> &#x2014; material icon named "missed video call" (sharp).
  static const IconData missed_video_call_sharp = IconData(0xeae3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">missed_video_call</i> &#x2014; material icon named "missed video call" (round).
  static const IconData missed_video_call_rounded = IconData(0xf8c2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">missed_video_call</i> &#x2014; material icon named "missed video call" (outlined).
  static const IconData missed_video_call_outlined = IconData(0xf1d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mms</i> &#x2014; material icon named "mms".
  static const IconData mms = IconData(0xe3eb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mms</i> &#x2014; material icon named "mms" (sharp).
  static const IconData mms_sharp = IconData(0xeae4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mms</i> &#x2014; material icon named "mms" (round).
  static const IconData mms_rounded = IconData(0xf8c3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mms</i> &#x2014; material icon named "mms" (outlined).
  static const IconData mms_outlined = IconData(0xf1d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mobile_friendly</i> &#x2014; material icon named "mobile friendly".
  static const IconData mobile_friendly = IconData(0xe3ec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mobile_friendly</i> &#x2014; material icon named "mobile friendly" (sharp).
  static const IconData mobile_friendly_sharp = IconData(0xeae5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mobile_friendly</i> &#x2014; material icon named "mobile friendly" (round).
  static const IconData mobile_friendly_rounded = IconData(0xf8c4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mobile_friendly</i> &#x2014; material icon named "mobile friendly" (outlined).
  static const IconData mobile_friendly_outlined = IconData(0xf1d2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mobile_off</i> &#x2014; material icon named "mobile off".
  static const IconData mobile_off = IconData(0xe3ed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mobile_off</i> &#x2014; material icon named "mobile off" (sharp).
  static const IconData mobile_off_sharp = IconData(0xeae6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mobile_off</i> &#x2014; material icon named "mobile off" (round).
  static const IconData mobile_off_rounded = IconData(0xf8c5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mobile_off</i> &#x2014; material icon named "mobile off" (outlined).
  static const IconData mobile_off_outlined = IconData(0xf1d3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mobile_screen_share</i> &#x2014; material icon named "mobile screen share".
  static const IconData mobile_screen_share = IconData(0xe3ee, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">mobile_screen_share</i> &#x2014; material icon named "mobile screen share" (sharp).
  static const IconData mobile_screen_share_sharp = IconData(0xeae7, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">mobile_screen_share</i> &#x2014; material icon named "mobile screen share" (round).
  static const IconData mobile_screen_share_rounded = IconData(0xf8c6, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">mobile_screen_share</i> &#x2014; material icon named "mobile screen share" (outlined).
  static const IconData mobile_screen_share_outlined = IconData(0xf1d4, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">mobiledata_off</i> &#x2014; material icon named "mobiledata off".
  static const IconData mobiledata_off = IconData(0xe3ef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mobiledata_off</i> &#x2014; material icon named "mobiledata off" (sharp).
  static const IconData mobiledata_off_sharp = IconData(0xeae8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mobiledata_off</i> &#x2014; material icon named "mobiledata off" (round).
  static const IconData mobiledata_off_rounded = IconData(0xf8c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mobiledata_off</i> &#x2014; material icon named "mobiledata off" (outlined).
  static const IconData mobiledata_off_outlined = IconData(0xf1d5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mode</i> &#x2014; material icon named "mode".
  static const IconData mode = IconData(0xe3f0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mode</i> &#x2014; material icon named "mode" (sharp).
  static const IconData mode_sharp = IconData(0xeaed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mode</i> &#x2014; material icon named "mode" (round).
  static const IconData mode_rounded = IconData(0xf8cc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mode</i> &#x2014; material icon named "mode" (outlined).
  static const IconData mode_outlined = IconData(0xf1da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mode_comment</i> &#x2014; material icon named "mode comment".
  static const IconData mode_comment = IconData(0xe3f1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mode_comment</i> &#x2014; material icon named "mode comment" (sharp).
  static const IconData mode_comment_sharp = IconData(0xeae9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mode_comment</i> &#x2014; material icon named "mode comment" (round).
  static const IconData mode_comment_rounded = IconData(0xf8c8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mode_comment</i> &#x2014; material icon named "mode comment" (outlined).
  static const IconData mode_comment_outlined = IconData(0xf1d6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mode_edit</i> &#x2014; material icon named "mode edit".
  static const IconData mode_edit = IconData(0xe3f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mode_edit</i> &#x2014; material icon named "mode edit" (sharp).
  static const IconData mode_edit_sharp = IconData(0xeaeb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mode_edit</i> &#x2014; material icon named "mode edit" (round).
  static const IconData mode_edit_rounded = IconData(0xf8ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mode_edit</i> &#x2014; material icon named "mode edit" (outlined).
  static const IconData mode_edit_outlined = IconData(0xf1d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mode_edit_outline</i> &#x2014; material icon named "mode edit outline".
  static const IconData mode_edit_outline = IconData(0xe3f3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mode_edit_outline</i> &#x2014; material icon named "mode edit outline" (sharp).
  static const IconData mode_edit_outline_sharp = IconData(0xeaea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mode_edit_outline</i> &#x2014; material icon named "mode edit outline" (round).
  static const IconData mode_edit_outline_rounded = IconData(0xf8c9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mode_edit_outline</i> &#x2014; material icon named "mode edit outline" (outlined).
  static const IconData mode_edit_outline_outlined = IconData(0xf1d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mode_night</i> &#x2014; material icon named "mode night".
  static const IconData mode_night = IconData(0xe3f4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mode_night</i> &#x2014; material icon named "mode night" (sharp).
  static const IconData mode_night_sharp = IconData(0xeaec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mode_night</i> &#x2014; material icon named "mode night" (round).
  static const IconData mode_night_rounded = IconData(0xf8cb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mode_night</i> &#x2014; material icon named "mode night" (outlined).
  static const IconData mode_night_outlined = IconData(0xf1d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mode_standby</i> &#x2014; material icon named "mode standby".
  static const IconData mode_standby = IconData(0xe3f5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mode_standby</i> &#x2014; material icon named "mode standby" (sharp).
  static const IconData mode_standby_sharp = IconData(0xeaee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mode_standby</i> &#x2014; material icon named "mode standby" (round).
  static const IconData mode_standby_rounded = IconData(0xf8cd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mode_standby</i> &#x2014; material icon named "mode standby" (outlined).
  static const IconData mode_standby_outlined = IconData(0xf1db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">model_training</i> &#x2014; material icon named "model training".
  static const IconData model_training = IconData(0xe3f6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">model_training</i> &#x2014; material icon named "model training" (sharp).
  static const IconData model_training_sharp = IconData(0xeaef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">model_training</i> &#x2014; material icon named "model training" (round).
  static const IconData model_training_rounded = IconData(0xf8ce, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">model_training</i> &#x2014; material icon named "model training" (outlined).
  static const IconData model_training_outlined = IconData(0xf1dc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">monetization_on</i> &#x2014; material icon named "monetization on".
  static const IconData monetization_on = IconData(0xe3f7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">monetization_on</i> &#x2014; material icon named "monetization on" (sharp).
  static const IconData monetization_on_sharp = IconData(0xeaf0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">monetization_on</i> &#x2014; material icon named "monetization on" (round).
  static const IconData monetization_on_rounded = IconData(0xf8cf, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">monetization_on</i> &#x2014; material icon named "monetization on" (outlined).
  static const IconData monetization_on_outlined = IconData(0xf1dd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">money</i> &#x2014; material icon named "money".
  static const IconData money = IconData(0xe3f8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">money</i> &#x2014; material icon named "money" (sharp).
  static const IconData money_sharp = IconData(0xeaf3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">money</i> &#x2014; material icon named "money" (round).
  static const IconData money_rounded = IconData(0xf8d2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">money</i> &#x2014; material icon named "money" (outlined).
  static const IconData money_outlined = IconData(0xf1e0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">money_off</i> &#x2014; material icon named "money off".
  static const IconData money_off = IconData(0xe3f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">money_off</i> &#x2014; material icon named "money off" (sharp).
  static const IconData money_off_sharp = IconData(0xeaf2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">money_off</i> &#x2014; material icon named "money off" (round).
  static const IconData money_off_rounded = IconData(0xf8d1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">money_off</i> &#x2014; material icon named "money off" (outlined).
  static const IconData money_off_outlined = IconData(0xf1df, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">money_off_csred</i> &#x2014; material icon named "money off csred".
  static const IconData money_off_csred = IconData(0xe3fa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">money_off_csred</i> &#x2014; material icon named "money off csred" (sharp).
  static const IconData money_off_csred_sharp = IconData(0xeaf1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">money_off_csred</i> &#x2014; material icon named "money off csred" (round).
  static const IconData money_off_csred_rounded = IconData(0xf8d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">money_off_csred</i> &#x2014; material icon named "money off csred" (outlined).
  static const IconData money_off_csred_outlined = IconData(0xf1de, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">monitor</i> &#x2014; material icon named "monitor".
  static const IconData monitor = IconData(0xe3fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">monitor</i> &#x2014; material icon named "monitor" (sharp).
  static const IconData monitor_sharp = IconData(0xeaf4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">monitor</i> &#x2014; material icon named "monitor" (round).
  static const IconData monitor_rounded = IconData(0xf8d3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">monitor</i> &#x2014; material icon named "monitor" (outlined).
  static const IconData monitor_outlined = IconData(0xf1e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">monitor_weight</i> &#x2014; material icon named "monitor weight".
  static const IconData monitor_weight = IconData(0xe3fc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">monitor_weight</i> &#x2014; material icon named "monitor weight" (sharp).
  static const IconData monitor_weight_sharp = IconData(0xeaf5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">monitor_weight</i> &#x2014; material icon named "monitor weight" (round).
  static const IconData monitor_weight_rounded = IconData(0xf8d4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">monitor_weight</i> &#x2014; material icon named "monitor weight" (outlined).
  static const IconData monitor_weight_outlined = IconData(0xf1e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">monochrome_photos</i> &#x2014; material icon named "monochrome photos".
  static const IconData monochrome_photos = IconData(0xe3fd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">monochrome_photos</i> &#x2014; material icon named "monochrome photos" (sharp).
  static const IconData monochrome_photos_sharp = IconData(0xeaf6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">monochrome_photos</i> &#x2014; material icon named "monochrome photos" (round).
  static const IconData monochrome_photos_rounded = IconData(0xf8d5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">monochrome_photos</i> &#x2014; material icon named "monochrome photos" (outlined).
  static const IconData monochrome_photos_outlined = IconData(0xf1e3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mood</i> &#x2014; material icon named "mood".
  static const IconData mood = IconData(0xe3fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mood</i> &#x2014; material icon named "mood" (sharp).
  static const IconData mood_sharp = IconData(0xeaf8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mood</i> &#x2014; material icon named "mood" (round).
  static const IconData mood_rounded = IconData(0xf8d7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mood</i> &#x2014; material icon named "mood" (outlined).
  static const IconData mood_outlined = IconData(0xf1e5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mood_bad</i> &#x2014; material icon named "mood bad".
  static const IconData mood_bad = IconData(0xe3ff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mood_bad</i> &#x2014; material icon named "mood bad" (sharp).
  static const IconData mood_bad_sharp = IconData(0xeaf7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mood_bad</i> &#x2014; material icon named "mood bad" (round).
  static const IconData mood_bad_rounded = IconData(0xf8d6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mood_bad</i> &#x2014; material icon named "mood bad" (outlined).
  static const IconData mood_bad_outlined = IconData(0xf1e4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">moped</i> &#x2014; material icon named "moped".
  static const IconData moped = IconData(0xe400, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">moped</i> &#x2014; material icon named "moped" (sharp).
  static const IconData moped_sharp = IconData(0xeaf9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">moped</i> &#x2014; material icon named "moped" (round).
  static const IconData moped_rounded = IconData(0xf8d8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">moped</i> &#x2014; material icon named "moped" (outlined).
  static const IconData moped_outlined = IconData(0xf1e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">more</i> &#x2014; material icon named "more".
  static const IconData more = IconData(0xe401, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">more</i> &#x2014; material icon named "more" (sharp).
  static const IconData more_sharp = IconData(0xeafb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">more</i> &#x2014; material icon named "more" (round).
  static const IconData more_rounded = IconData(0xf8da, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">more</i> &#x2014; material icon named "more" (outlined).
  static const IconData more_outlined = IconData(0xf1e8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">more_horiz</i> &#x2014; material icon named "more horiz".
  static const IconData more_horiz = IconData(0xe402, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">more_horiz</i> &#x2014; material icon named "more horiz" (sharp).
  static const IconData more_horiz_sharp = IconData(0xeafa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">more_horiz</i> &#x2014; material icon named "more horiz" (round).
  static const IconData more_horiz_rounded = IconData(0xf8d9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">more_horiz</i> &#x2014; material icon named "more horiz" (outlined).
  static const IconData more_horiz_outlined = IconData(0xf1e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">more_time</i> &#x2014; material icon named "more time".
  static const IconData more_time = IconData(0xe403, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">more_time</i> &#x2014; material icon named "more time" (sharp).
  static const IconData more_time_sharp = IconData(0xeafc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">more_time</i> &#x2014; material icon named "more time" (round).
  static const IconData more_time_rounded = IconData(0xf8db, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">more_time</i> &#x2014; material icon named "more time" (outlined).
  static const IconData more_time_outlined = IconData(0xf1e9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">more_vert</i> &#x2014; material icon named "more vert".
  static const IconData more_vert = IconData(0xe404, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">more_vert</i> &#x2014; material icon named "more vert" (sharp).
  static const IconData more_vert_sharp = IconData(0xeafd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">more_vert</i> &#x2014; material icon named "more vert" (round).
  static const IconData more_vert_rounded = IconData(0xf8dc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">more_vert</i> &#x2014; material icon named "more vert" (outlined).
  static const IconData more_vert_outlined = IconData(0xf1ea, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">motion_photos_auto</i> &#x2014; material icon named "motion photos auto".
  static const IconData motion_photos_auto = IconData(0xe405, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">motion_photos_auto</i> &#x2014; material icon named "motion photos auto" (sharp).
  static const IconData motion_photos_auto_sharp = IconData(0xeafe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">motion_photos_auto</i> &#x2014; material icon named "motion photos auto" (round).
  static const IconData motion_photos_auto_rounded = IconData(0xf8dd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">motion_photos_auto</i> &#x2014; material icon named "motion photos auto" (outlined).
  static const IconData motion_photos_auto_outlined = IconData(0xf1eb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">motion_photos_off</i> &#x2014; material icon named "motion photos off".
  static const IconData motion_photos_off = IconData(0xe406, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">motion_photos_off</i> &#x2014; material icon named "motion photos off" (sharp).
  static const IconData motion_photos_off_sharp = IconData(0xeaff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">motion_photos_off</i> &#x2014; material icon named "motion photos off" (round).
  static const IconData motion_photos_off_rounded = IconData(0xf8de, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">motion_photos_off</i> &#x2014; material icon named "motion photos off" (outlined).
  static const IconData motion_photos_off_outlined = IconData(0xf1ec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">motion_photos_on</i> &#x2014; material icon named "motion photos on".
  static const IconData motion_photos_on = IconData(0xe407, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">motion_photos_on</i> &#x2014; material icon named "motion photos on" (sharp).
  static const IconData motion_photos_on_sharp = IconData(0xeb00, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">motion_photos_on</i> &#x2014; material icon named "motion photos on" (round).
  static const IconData motion_photos_on_rounded = IconData(0xf8df, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">motion_photos_on</i> &#x2014; material icon named "motion photos on" (outlined).
  static const IconData motion_photos_on_outlined = IconData(0xf1ed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">motion_photos_pause</i> &#x2014; material icon named "motion photos pause".
  static const IconData motion_photos_pause = IconData(0xe408, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">motion_photos_pause</i> &#x2014; material icon named "motion photos pause" (sharp).
  static const IconData motion_photos_pause_sharp = IconData(0xeb01, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">motion_photos_pause</i> &#x2014; material icon named "motion photos pause" (round).
  static const IconData motion_photos_pause_rounded = IconData(0xf8e0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">motion_photos_pause</i> &#x2014; material icon named "motion photos pause" (outlined).
  static const IconData motion_photos_pause_outlined = IconData(0xf1ee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">motion_photos_paused</i> &#x2014; material icon named "motion photos paused".
  static const IconData motion_photos_paused = IconData(0xe409, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">motion_photos_paused</i> &#x2014; material icon named "motion photos paused" (sharp).
  static const IconData motion_photos_paused_sharp = IconData(0xeb02, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">motion_photos_paused</i> &#x2014; material icon named "motion photos paused" (round).
  static const IconData motion_photos_paused_rounded = IconData(0xf8e1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">motion_photos_paused</i> &#x2014; material icon named "motion photos paused" (outlined).
  static const IconData motion_photos_paused_outlined = IconData(0xf1ef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">motorcycle</i> &#x2014; material icon named "motorcycle".
  static const IconData motorcycle = IconData(0xe40a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">motorcycle</i> &#x2014; material icon named "motorcycle" (sharp).
  static const IconData motorcycle_sharp = IconData(0xeb03, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">motorcycle</i> &#x2014; material icon named "motorcycle" (round).
  static const IconData motorcycle_rounded = IconData(0xf8e2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">motorcycle</i> &#x2014; material icon named "motorcycle" (outlined).
  static const IconData motorcycle_outlined = IconData(0xf1f0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mouse</i> &#x2014; material icon named "mouse".
  static const IconData mouse = IconData(0xe40b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mouse</i> &#x2014; material icon named "mouse" (sharp).
  static const IconData mouse_sharp = IconData(0xeb04, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mouse</i> &#x2014; material icon named "mouse" (round).
  static const IconData mouse_rounded = IconData(0xf8e3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mouse</i> &#x2014; material icon named "mouse" (outlined).
  static const IconData mouse_outlined = IconData(0xf1f1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">move_to_inbox</i> &#x2014; material icon named "move to inbox".
  static const IconData move_to_inbox = IconData(0xe40c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">move_to_inbox</i> &#x2014; material icon named "move to inbox" (sharp).
  static const IconData move_to_inbox_sharp = IconData(0xeb05, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">move_to_inbox</i> &#x2014; material icon named "move to inbox" (round).
  static const IconData move_to_inbox_rounded = IconData(0xf8e4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">move_to_inbox</i> &#x2014; material icon named "move to inbox" (outlined).
  static const IconData move_to_inbox_outlined = IconData(0xf1f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">movie</i> &#x2014; material icon named "movie".
  static const IconData movie = IconData(0xe40d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">movie</i> &#x2014; material icon named "movie" (sharp).
  static const IconData movie_sharp = IconData(0xeb08, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">movie</i> &#x2014; material icon named "movie" (round).
  static const IconData movie_rounded = IconData(0xf8e7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">movie</i> &#x2014; material icon named "movie" (outlined).
  static const IconData movie_outlined = IconData(0xf1f5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">movie_creation</i> &#x2014; material icon named "movie creation".
  static const IconData movie_creation = IconData(0xe40e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">movie_creation</i> &#x2014; material icon named "movie creation" (sharp).
  static const IconData movie_creation_sharp = IconData(0xeb06, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">movie_creation</i> &#x2014; material icon named "movie creation" (round).
  static const IconData movie_creation_rounded = IconData(0xf8e5, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">movie_creation</i> &#x2014; material icon named "movie creation" (outlined).
  static const IconData movie_creation_outlined = IconData(0xf1f3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">movie_filter</i> &#x2014; material icon named "movie filter".
  static const IconData movie_filter = IconData(0xe40f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">movie_filter</i> &#x2014; material icon named "movie filter" (sharp).
  static const IconData movie_filter_sharp = IconData(0xeb07, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">movie_filter</i> &#x2014; material icon named "movie filter" (round).
  static const IconData movie_filter_rounded = IconData(0xf8e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">movie_filter</i> &#x2014; material icon named "movie filter" (outlined).
  static const IconData movie_filter_outlined = IconData(0xf1f4, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">moving</i> &#x2014; material icon named "moving".
  static const IconData moving = IconData(0xe410, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">moving</i> &#x2014; material icon named "moving" (sharp).
  static const IconData moving_sharp = IconData(0xeb09, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">moving</i> &#x2014; material icon named "moving" (round).
  static const IconData moving_rounded = IconData(0xf8e8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">moving</i> &#x2014; material icon named "moving" (outlined).
  static const IconData moving_outlined = IconData(0xf1f6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">mp</i> &#x2014; material icon named "mp".
  static const IconData mp = IconData(0xe411, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">mp</i> &#x2014; material icon named "mp" (sharp).
  static const IconData mp_sharp = IconData(0xeb0a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">mp</i> &#x2014; material icon named "mp" (round).
  static const IconData mp_rounded = IconData(0xf8e9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">mp</i> &#x2014; material icon named "mp" (outlined).
  static const IconData mp_outlined = IconData(0xf1f7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">multiline_chart</i> &#x2014; material icon named "multiline chart".
  static const IconData multiline_chart = IconData(0xe412, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">multiline_chart</i> &#x2014; material icon named "multiline chart" (sharp).
  static const IconData multiline_chart_sharp = IconData(0xeb0b, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">multiline_chart</i> &#x2014; material icon named "multiline chart" (round).
  static const IconData multiline_chart_rounded = IconData(0xf8ea, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">multiline_chart</i> &#x2014; material icon named "multiline chart" (outlined).
  static const IconData multiline_chart_outlined = IconData(0xf1f8, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">multiple_stop</i> &#x2014; material icon named "multiple stop".
  static const IconData multiple_stop = IconData(0xe413, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">multiple_stop</i> &#x2014; material icon named "multiple stop" (sharp).
  static const IconData multiple_stop_sharp = IconData(0xeb0c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">multiple_stop</i> &#x2014; material icon named "multiple stop" (round).
  static const IconData multiple_stop_rounded = IconData(0xf8eb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">multiple_stop</i> &#x2014; material icon named "multiple stop" (outlined).
  static const IconData multiple_stop_outlined = IconData(0xf1f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">multitrack_audio</i> &#x2014; material icon named "multitrack audio".
  static const IconData multitrack_audio = IconData(0xe2e3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">multitrack_audio</i> &#x2014; material icon named "multitrack audio" (sharp).
  static const IconData multitrack_audio_sharp = IconData(0xe9de, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">multitrack_audio</i> &#x2014; material icon named "multitrack audio" (round).
  static const IconData multitrack_audio_rounded = IconData(0xf7bd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">multitrack_audio</i> &#x2014; material icon named "multitrack audio" (outlined).
  static const IconData multitrack_audio_outlined = IconData(0xf0d0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">museum</i> &#x2014; material icon named "museum".
  static const IconData museum = IconData(0xe414, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">museum</i> &#x2014; material icon named "museum" (sharp).
  static const IconData museum_sharp = IconData(0xeb0d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">museum</i> &#x2014; material icon named "museum" (round).
  static const IconData museum_rounded = IconData(0xf8ec, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">museum</i> &#x2014; material icon named "museum" (outlined).
  static const IconData museum_outlined = IconData(0xf1fa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">music_note</i> &#x2014; material icon named "music note".
  static const IconData music_note = IconData(0xe415, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">music_note</i> &#x2014; material icon named "music note" (sharp).
  static const IconData music_note_sharp = IconData(0xeb0e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">music_note</i> &#x2014; material icon named "music note" (round).
  static const IconData music_note_rounded = IconData(0xf8ed, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">music_note</i> &#x2014; material icon named "music note" (outlined).
  static const IconData music_note_outlined = IconData(0xf1fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">music_off</i> &#x2014; material icon named "music off".
  static const IconData music_off = IconData(0xe416, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">music_off</i> &#x2014; material icon named "music off" (sharp).
  static const IconData music_off_sharp = IconData(0xeb0f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">music_off</i> &#x2014; material icon named "music off" (round).
  static const IconData music_off_rounded = IconData(0xf8ee, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">music_off</i> &#x2014; material icon named "music off" (outlined).
  static const IconData music_off_outlined = IconData(0xf1fc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">music_video</i> &#x2014; material icon named "music video".
  static const IconData music_video = IconData(0xe417, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">music_video</i> &#x2014; material icon named "music video" (sharp).
  static const IconData music_video_sharp = IconData(0xeb10, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">music_video</i> &#x2014; material icon named "music video" (round).
  static const IconData music_video_rounded = IconData(0xf8ef, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">music_video</i> &#x2014; material icon named "music video" (outlined).
  static const IconData music_video_outlined = IconData(0xf1fd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">my_library_add</i> &#x2014; material icon named "my library add".
  static const IconData my_library_add = IconData(0xe375, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">my_library_add</i> &#x2014; material icon named "my library add" (sharp).
  static const IconData my_library_add_sharp = IconData(0xea70, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">my_library_add</i> &#x2014; material icon named "my library add" (round).
  static const IconData my_library_add_rounded = IconData(0xf84f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">my_library_add</i> &#x2014; material icon named "my library add" (outlined).
  static const IconData my_library_add_outlined = IconData(0xf15f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">my_library_books</i> &#x2014; material icon named "my library books".
  static const IconData my_library_books = IconData(0xe377, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">my_library_books</i> &#x2014; material icon named "my library books" (sharp).
  static const IconData my_library_books_sharp = IconData(0xea71, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">my_library_books</i> &#x2014; material icon named "my library books" (round).
  static const IconData my_library_books_rounded = IconData(0xf850, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">my_library_books</i> &#x2014; material icon named "my library books" (outlined).
  static const IconData my_library_books_outlined = IconData(0xf160, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">my_library_music</i> &#x2014; material icon named "my library music".
  static const IconData my_library_music = IconData(0xe378, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">my_library_music</i> &#x2014; material icon named "my library music" (sharp).
  static const IconData my_library_music_sharp = IconData(0xea72, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">my_library_music</i> &#x2014; material icon named "my library music" (round).
  static const IconData my_library_music_rounded = IconData(0xf851, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">my_library_music</i> &#x2014; material icon named "my library music" (outlined).
  static const IconData my_library_music_outlined = IconData(0xf161, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">my_location</i> &#x2014; material icon named "my location".
  static const IconData my_location = IconData(0xe418, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">my_location</i> &#x2014; material icon named "my location" (sharp).
  static const IconData my_location_sharp = IconData(0xeb11, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">my_location</i> &#x2014; material icon named "my location" (round).
  static const IconData my_location_rounded = IconData(0xf8f0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">my_location</i> &#x2014; material icon named "my location" (outlined).
  static const IconData my_location_outlined = IconData(0xf1fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">nat</i> &#x2014; material icon named "nat".
  static const IconData nat = IconData(0xe419, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">nat</i> &#x2014; material icon named "nat" (sharp).
  static const IconData nat_sharp = IconData(0xeb12, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">nat</i> &#x2014; material icon named "nat" (round).
  static const IconData nat_rounded = IconData(0xf8f1, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">nat</i> &#x2014; material icon named "nat" (outlined).
  static const IconData nat_outlined = IconData(0xf1ff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">nature</i> &#x2014; material icon named "nature".
  static const IconData nature = IconData(0xe41a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">nature</i> &#x2014; material icon named "nature" (sharp).
  static const IconData nature_sharp = IconData(0xeb14, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">nature</i> &#x2014; material icon named "nature" (round).
  static const IconData nature_rounded = IconData(0xf8f3, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">nature</i> &#x2014; material icon named "nature" (outlined).
  static const IconData nature_outlined = IconData(0xf200, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">nature_people</i> &#x2014; material icon named "nature people".
  static const IconData nature_people = IconData(0xe41b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">nature_people</i> &#x2014; material icon named "nature people" (sharp).
  static const IconData nature_people_sharp = IconData(0xeb13, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">nature_people</i> &#x2014; material icon named "nature people" (round).
  static const IconData nature_people_rounded = IconData(0xf8f2, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">nature_people</i> &#x2014; material icon named "nature people" (outlined).
  static const IconData nature_people_outlined = IconData(0xf201, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">navigate_before</i> &#x2014; material icon named "navigate before".
  static const IconData navigate_before = IconData(0xe41c, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">navigate_before</i> &#x2014; material icon named "navigate before" (sharp).
  static const IconData navigate_before_sharp = IconData(0xeb15, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">navigate_before</i> &#x2014; material icon named "navigate before" (round).
  static const IconData navigate_before_rounded = IconData(0xf8f4, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">navigate_before</i> &#x2014; material icon named "navigate before" (outlined).
  static const IconData navigate_before_outlined = IconData(0xf202, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">navigate_next</i> &#x2014; material icon named "navigate next".
  static const IconData navigate_next = IconData(0xe41d, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">navigate_next</i> &#x2014; material icon named "navigate next" (sharp).
  static const IconData navigate_next_sharp = IconData(0xeb16, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">navigate_next</i> &#x2014; material icon named "navigate next" (round).
  static const IconData navigate_next_rounded = IconData(0xf8f5, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">navigate_next</i> &#x2014; material icon named "navigate next" (outlined).
  static const IconData navigate_next_outlined = IconData(0xf203, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">navigation</i> &#x2014; material icon named "navigation".
  static const IconData navigation = IconData(0xe41e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">navigation</i> &#x2014; material icon named "navigation" (sharp).
  static const IconData navigation_sharp = IconData(0xeb17, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">navigation</i> &#x2014; material icon named "navigation" (round).
  static const IconData navigation_rounded = IconData(0xf8f6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">navigation</i> &#x2014; material icon named "navigation" (outlined).
  static const IconData navigation_outlined = IconData(0xf204, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">near_me</i> &#x2014; material icon named "near me".
  static const IconData near_me = IconData(0xe41f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">near_me</i> &#x2014; material icon named "near me" (sharp).
  static const IconData near_me_sharp = IconData(0xeb19, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">near_me</i> &#x2014; material icon named "near me" (round).
  static const IconData near_me_rounded = IconData(0xf8f8, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">near_me</i> &#x2014; material icon named "near me" (outlined).
  static const IconData near_me_outlined = IconData(0xf206, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">near_me_disabled</i> &#x2014; material icon named "near me disabled".
  static const IconData near_me_disabled = IconData(0xe420, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">near_me_disabled</i> &#x2014; material icon named "near me disabled" (sharp).
  static const IconData near_me_disabled_sharp = IconData(0xeb18, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">near_me_disabled</i> &#x2014; material icon named "near me disabled" (round).
  static const IconData near_me_disabled_rounded = IconData(0xf8f7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">near_me_disabled</i> &#x2014; material icon named "near me disabled" (outlined).
  static const IconData near_me_disabled_outlined = IconData(0xf205, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">nearby_error</i> &#x2014; material icon named "nearby error".
  static const IconData nearby_error = IconData(0xe421, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">nearby_error</i> &#x2014; material icon named "nearby error" (sharp).
  static const IconData nearby_error_sharp = IconData(0xeb1a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">nearby_error</i> &#x2014; material icon named "nearby error" (round).
  static const IconData nearby_error_rounded = IconData(0xf8f9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">nearby_error</i> &#x2014; material icon named "nearby error" (outlined).
  static const IconData nearby_error_outlined = IconData(0xf207, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">nearby_off</i> &#x2014; material icon named "nearby off".
  static const IconData nearby_off = IconData(0xe422, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">nearby_off</i> &#x2014; material icon named "nearby off" (sharp).
  static const IconData nearby_off_sharp = IconData(0xeb1b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">nearby_off</i> &#x2014; material icon named "nearby off" (round).
  static const IconData nearby_off_rounded = IconData(0xf8fa, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">nearby_off</i> &#x2014; material icon named "nearby off" (outlined).
  static const IconData nearby_off_outlined = IconData(0xf208, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">network_cell</i> &#x2014; material icon named "network cell".
  static const IconData network_cell = IconData(0xe423, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">network_cell</i> &#x2014; material icon named "network cell" (sharp).
  static const IconData network_cell_sharp = IconData(0xeb1c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">network_cell</i> &#x2014; material icon named "network cell" (round).
  static const IconData network_cell_rounded = IconData(0xf8fb, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">network_cell</i> &#x2014; material icon named "network cell" (outlined).
  static const IconData network_cell_outlined = IconData(0xf209, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">network_check</i> &#x2014; material icon named "network check".
  static const IconData network_check = IconData(0xe424, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">network_check</i> &#x2014; material icon named "network check" (sharp).
  static const IconData network_check_sharp = IconData(0xeb1d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">network_check</i> &#x2014; material icon named "network check" (round).
  static const IconData network_check_rounded = IconData(0xf8fc, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">network_check</i> &#x2014; material icon named "network check" (outlined).
  static const IconData network_check_outlined = IconData(0xf20a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">network_locked</i> &#x2014; material icon named "network locked".
  static const IconData network_locked = IconData(0xe425, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">network_locked</i> &#x2014; material icon named "network locked" (sharp).
  static const IconData network_locked_sharp = IconData(0xeb1e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">network_locked</i> &#x2014; material icon named "network locked" (round).
  static const IconData network_locked_rounded = IconData(0xf8fd, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">network_locked</i> &#x2014; material icon named "network locked" (outlined).
  static const IconData network_locked_outlined = IconData(0xf20b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">network_wifi</i> &#x2014; material icon named "network wifi".
  static const IconData network_wifi = IconData(0xe426, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">network_wifi</i> &#x2014; material icon named "network wifi" (sharp).
  static const IconData network_wifi_sharp = IconData(0xeb1f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">network_wifi</i> &#x2014; material icon named "network wifi" (round).
  static const IconData network_wifi_rounded = IconData(0xf8fe, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">network_wifi</i> &#x2014; material icon named "network wifi" (outlined).
  static const IconData network_wifi_outlined = IconData(0xf20c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">new_label</i> &#x2014; material icon named "new label".
  static const IconData new_label = IconData(0xe427, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">new_label</i> &#x2014; material icon named "new label" (sharp).
  static const IconData new_label_sharp = IconData(0xeb20, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">new_label</i> &#x2014; material icon named "new label" (round).
  static const IconData new_label_rounded = IconData(0xf8ff, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">new_label</i> &#x2014; material icon named "new label" (outlined).
  static const IconData new_label_outlined = IconData(0xf20d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">new_releases</i> &#x2014; material icon named "new releases".
  static const IconData new_releases = IconData(0xe428, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">new_releases</i> &#x2014; material icon named "new releases" (sharp).
  static const IconData new_releases_sharp = IconData(0xeb21, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">new_releases</i> &#x2014; material icon named "new releases" (round).
  static const IconData new_releases_rounded = IconData(0xf0000, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">new_releases</i> &#x2014; material icon named "new releases" (outlined).
  static const IconData new_releases_outlined = IconData(0xf20e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">next_plan</i> &#x2014; material icon named "next plan".
  static const IconData next_plan = IconData(0xe429, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">next_plan</i> &#x2014; material icon named "next plan" (sharp).
  static const IconData next_plan_sharp = IconData(0xeb22, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">next_plan</i> &#x2014; material icon named "next plan" (round).
  static const IconData next_plan_rounded = IconData(0xf0001, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">next_plan</i> &#x2014; material icon named "next plan" (outlined).
  static const IconData next_plan_outlined = IconData(0xf20f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">next_week</i> &#x2014; material icon named "next week".
  static const IconData next_week = IconData(0xe42a, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">next_week</i> &#x2014; material icon named "next week" (sharp).
  static const IconData next_week_sharp = IconData(0xeb23, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">next_week</i> &#x2014; material icon named "next week" (round).
  static const IconData next_week_rounded = IconData(0xf0002, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">next_week</i> &#x2014; material icon named "next week" (outlined).
  static const IconData next_week_outlined = IconData(0xf210, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">nfc</i> &#x2014; material icon named "nfc".
  static const IconData nfc = IconData(0xe42b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">nfc</i> &#x2014; material icon named "nfc" (sharp).
  static const IconData nfc_sharp = IconData(0xeb24, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">nfc</i> &#x2014; material icon named "nfc" (round).
  static const IconData nfc_rounded = IconData(0xf0003, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">nfc</i> &#x2014; material icon named "nfc" (outlined).
  static const IconData nfc_outlined = IconData(0xf211, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">night_shelter</i> &#x2014; material icon named "night shelter".
  static const IconData night_shelter = IconData(0xe42c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">night_shelter</i> &#x2014; material icon named "night shelter" (sharp).
  static const IconData night_shelter_sharp = IconData(0xeb25, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">night_shelter</i> &#x2014; material icon named "night shelter" (round).
  static const IconData night_shelter_rounded = IconData(0xf0004, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">night_shelter</i> &#x2014; material icon named "night shelter" (outlined).
  static const IconData night_shelter_outlined = IconData(0xf212, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">nightlife</i> &#x2014; material icon named "nightlife".
  static const IconData nightlife = IconData(0xe42d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">nightlife</i> &#x2014; material icon named "nightlife" (sharp).
  static const IconData nightlife_sharp = IconData(0xeb26, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">nightlife</i> &#x2014; material icon named "nightlife" (round).
  static const IconData nightlife_rounded = IconData(0xf0005, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">nightlife</i> &#x2014; material icon named "nightlife" (outlined).
  static const IconData nightlife_outlined = IconData(0xf213, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">nightlight</i> &#x2014; material icon named "nightlight".
  static const IconData nightlight = IconData(0xe42e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">nightlight</i> &#x2014; material icon named "nightlight" (sharp).
  static const IconData nightlight_sharp = IconData(0xeb28, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">nightlight</i> &#x2014; material icon named "nightlight" (round).
  static const IconData nightlight_rounded = IconData(0xf0007, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">nightlight</i> &#x2014; material icon named "nightlight" (outlined).
  static const IconData nightlight_outlined = IconData(0xf214, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">nightlight_round</i> &#x2014; material icon named "nightlight round".
  static const IconData nightlight_round = IconData(0xe42f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">nightlight_round</i> &#x2014; material icon named "nightlight round" (sharp).
  static const IconData nightlight_round_sharp = IconData(0xeb27, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">nightlight_round</i> &#x2014; material icon named "nightlight round" (round).
  static const IconData nightlight_round_rounded = IconData(0xf0006, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">nightlight_round</i> &#x2014; material icon named "nightlight round" (outlined).
  static const IconData nightlight_round_outlined = IconData(0xf215, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">nights_stay</i> &#x2014; material icon named "nights stay".
  static const IconData nights_stay = IconData(0xe430, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">nights_stay</i> &#x2014; material icon named "nights stay" (sharp).
  static const IconData nights_stay_sharp = IconData(0xeb29, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">nights_stay</i> &#x2014; material icon named "nights stay" (round).
  static const IconData nights_stay_rounded = IconData(0xf0008, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">nights_stay</i> &#x2014; material icon named "nights stay" (outlined).
  static const IconData nights_stay_outlined = IconData(0xf216, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">no_accounts</i> &#x2014; material icon named "no accounts".
  static const IconData no_accounts = IconData(0xe431, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">no_accounts</i> &#x2014; material icon named "no accounts" (sharp).
  static const IconData no_accounts_sharp = IconData(0xeb2a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">no_accounts</i> &#x2014; material icon named "no accounts" (round).
  static const IconData no_accounts_rounded = IconData(0xf0009, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">no_accounts</i> &#x2014; material icon named "no accounts" (outlined).
  static const IconData no_accounts_outlined = IconData(0xf217, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">no_backpack</i> &#x2014; material icon named "no backpack".
  static const IconData no_backpack = IconData(0xe432, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">no_backpack</i> &#x2014; material icon named "no backpack" (sharp).
  static const IconData no_backpack_sharp = IconData(0xeb2b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">no_backpack</i> &#x2014; material icon named "no backpack" (round).
  static const IconData no_backpack_rounded = IconData(0xf000a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">no_backpack</i> &#x2014; material icon named "no backpack" (outlined).
  static const IconData no_backpack_outlined = IconData(0xf218, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">no_cell</i> &#x2014; material icon named "no cell".
  static const IconData no_cell = IconData(0xe433, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">no_cell</i> &#x2014; material icon named "no cell" (sharp).
  static const IconData no_cell_sharp = IconData(0xeb2c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">no_cell</i> &#x2014; material icon named "no cell" (round).
  static const IconData no_cell_rounded = IconData(0xf000b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">no_cell</i> &#x2014; material icon named "no cell" (outlined).
  static const IconData no_cell_outlined = IconData(0xf219, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">no_drinks</i> &#x2014; material icon named "no drinks".
  static const IconData no_drinks = IconData(0xe434, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">no_drinks</i> &#x2014; material icon named "no drinks" (sharp).
  static const IconData no_drinks_sharp = IconData(0xeb2d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">no_drinks</i> &#x2014; material icon named "no drinks" (round).
  static const IconData no_drinks_rounded = IconData(0xf000c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">no_drinks</i> &#x2014; material icon named "no drinks" (outlined).
  static const IconData no_drinks_outlined = IconData(0xf21a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">no_encryption</i> &#x2014; material icon named "no encryption".
  static const IconData no_encryption = IconData(0xe435, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">no_encryption</i> &#x2014; material icon named "no encryption" (sharp).
  static const IconData no_encryption_sharp = IconData(0xeb2f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">no_encryption</i> &#x2014; material icon named "no encryption" (round).
  static const IconData no_encryption_rounded = IconData(0xf000e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">no_encryption</i> &#x2014; material icon named "no encryption" (outlined).
  static const IconData no_encryption_outlined = IconData(0xf21c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">no_encryption_gmailerrorred</i> &#x2014; material icon named "no encryption gmailerrorred".
  static const IconData no_encryption_gmailerrorred = IconData(0xe436, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">no_encryption_gmailerrorred</i> &#x2014; material icon named "no encryption gmailerrorred" (sharp).
  static const IconData no_encryption_gmailerrorred_sharp = IconData(0xeb2e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">no_encryption_gmailerrorred</i> &#x2014; material icon named "no encryption gmailerrorred" (round).
  static const IconData no_encryption_gmailerrorred_rounded = IconData(0xf000d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">no_encryption_gmailerrorred</i> &#x2014; material icon named "no encryption gmailerrorred" (outlined).
  static const IconData no_encryption_gmailerrorred_outlined = IconData(0xf21b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">no_flash</i> &#x2014; material icon named "no flash".
  static const IconData no_flash = IconData(0xe437, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">no_flash</i> &#x2014; material icon named "no flash" (sharp).
  static const IconData no_flash_sharp = IconData(0xeb30, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">no_flash</i> &#x2014; material icon named "no flash" (round).
  static const IconData no_flash_rounded = IconData(0xf000f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">no_flash</i> &#x2014; material icon named "no flash" (outlined).
  static const IconData no_flash_outlined = IconData(0xf21d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">no_food</i> &#x2014; material icon named "no food".
  static const IconData no_food = IconData(0xe438, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">no_food</i> &#x2014; material icon named "no food" (sharp).
  static const IconData no_food_sharp = IconData(0xeb31, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">no_food</i> &#x2014; material icon named "no food" (round).
  static const IconData no_food_rounded = IconData(0xf0010, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">no_food</i> &#x2014; material icon named "no food" (outlined).
  static const IconData no_food_outlined = IconData(0xf21e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">no_luggage</i> &#x2014; material icon named "no luggage".
  static const IconData no_luggage = IconData(0xe439, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">no_luggage</i> &#x2014; material icon named "no luggage" (sharp).
  static const IconData no_luggage_sharp = IconData(0xeb32, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">no_luggage</i> &#x2014; material icon named "no luggage" (round).
  static const IconData no_luggage_rounded = IconData(0xf0011, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">no_luggage</i> &#x2014; material icon named "no luggage" (outlined).
  static const IconData no_luggage_outlined = IconData(0xf21f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">no_meals</i> &#x2014; material icon named "no meals".
  static const IconData no_meals = IconData(0xe43a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">no_meals</i> &#x2014; material icon named "no meals" (sharp).
  static const IconData no_meals_sharp = IconData(0xeb33, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">no_meals</i> &#x2014; material icon named "no meals" (round).
  static const IconData no_meals_rounded = IconData(0xf0012, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">no_meals</i> &#x2014; material icon named "no meals" (outlined).
  static const IconData no_meals_outlined = IconData(0xf220, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">no_meals_ouline</i> &#x2014; material icon named "no meals ouline".
  static const IconData no_meals_ouline = IconData(0xe43b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">no_meeting_room</i> &#x2014; material icon named "no meeting room".
  static const IconData no_meeting_room = IconData(0xe43c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">no_meeting_room</i> &#x2014; material icon named "no meeting room" (sharp).
  static const IconData no_meeting_room_sharp = IconData(0xeb34, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">no_meeting_room</i> &#x2014; material icon named "no meeting room" (round).
  static const IconData no_meeting_room_rounded = IconData(0xf0013, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">no_meeting_room</i> &#x2014; material icon named "no meeting room" (outlined).
  static const IconData no_meeting_room_outlined = IconData(0xf221, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">no_photography</i> &#x2014; material icon named "no photography".
  static const IconData no_photography = IconData(0xe43d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">no_photography</i> &#x2014; material icon named "no photography" (sharp).
  static const IconData no_photography_sharp = IconData(0xeb35, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">no_photography</i> &#x2014; material icon named "no photography" (round).
  static const IconData no_photography_rounded = IconData(0xf0014, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">no_photography</i> &#x2014; material icon named "no photography" (outlined).
  static const IconData no_photography_outlined = IconData(0xf222, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">no_sim</i> &#x2014; material icon named "no sim".
  static const IconData no_sim = IconData(0xe43e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">no_sim</i> &#x2014; material icon named "no sim" (sharp).
  static const IconData no_sim_sharp = IconData(0xeb36, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">no_sim</i> &#x2014; material icon named "no sim" (round).
  static const IconData no_sim_rounded = IconData(0xf0015, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">no_sim</i> &#x2014; material icon named "no sim" (outlined).
  static const IconData no_sim_outlined = IconData(0xf223, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">no_stroller</i> &#x2014; material icon named "no stroller".
  static const IconData no_stroller = IconData(0xe43f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">no_stroller</i> &#x2014; material icon named "no stroller" (sharp).
  static const IconData no_stroller_sharp = IconData(0xeb37, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">no_stroller</i> &#x2014; material icon named "no stroller" (round).
  static const IconData no_stroller_rounded = IconData(0xf0016, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">no_stroller</i> &#x2014; material icon named "no stroller" (outlined).
  static const IconData no_stroller_outlined = IconData(0xf224, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">no_transfer</i> &#x2014; material icon named "no transfer".
  static const IconData no_transfer = IconData(0xe440, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">no_transfer</i> &#x2014; material icon named "no transfer" (sharp).
  static const IconData no_transfer_sharp = IconData(0xeb38, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">no_transfer</i> &#x2014; material icon named "no transfer" (round).
  static const IconData no_transfer_rounded = IconData(0xf0017, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">no_transfer</i> &#x2014; material icon named "no transfer" (outlined).
  static const IconData no_transfer_outlined = IconData(0xf225, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">nordic_walking</i> &#x2014; material icon named "nordic walking".
  static const IconData nordic_walking = IconData(0xe441, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">nordic_walking</i> &#x2014; material icon named "nordic walking" (sharp).
  static const IconData nordic_walking_sharp = IconData(0xeb39, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">nordic_walking</i> &#x2014; material icon named "nordic walking" (round).
  static const IconData nordic_walking_rounded = IconData(0xf0018, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">nordic_walking</i> &#x2014; material icon named "nordic walking" (outlined).
  static const IconData nordic_walking_outlined = IconData(0xf226, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">north</i> &#x2014; material icon named "north".
  static const IconData north = IconData(0xe442, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">north</i> &#x2014; material icon named "north" (sharp).
  static const IconData north_sharp = IconData(0xeb3b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">north</i> &#x2014; material icon named "north" (round).
  static const IconData north_rounded = IconData(0xf001a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">north</i> &#x2014; material icon named "north" (outlined).
  static const IconData north_outlined = IconData(0xf228, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">north_east</i> &#x2014; material icon named "north east".
  static const IconData north_east = IconData(0xe443, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">north_east</i> &#x2014; material icon named "north east" (sharp).
  static const IconData north_east_sharp = IconData(0xeb3a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">north_east</i> &#x2014; material icon named "north east" (round).
  static const IconData north_east_rounded = IconData(0xf0019, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">north_east</i> &#x2014; material icon named "north east" (outlined).
  static const IconData north_east_outlined = IconData(0xf227, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">north_west</i> &#x2014; material icon named "north west".
  static const IconData north_west = IconData(0xe444, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">north_west</i> &#x2014; material icon named "north west" (sharp).
  static const IconData north_west_sharp = IconData(0xeb3c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">north_west</i> &#x2014; material icon named "north west" (round).
  static const IconData north_west_rounded = IconData(0xf001b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">north_west</i> &#x2014; material icon named "north west" (outlined).
  static const IconData north_west_outlined = IconData(0xf229, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">not_accessible</i> &#x2014; material icon named "not accessible".
  static const IconData not_accessible = IconData(0xe445, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">not_accessible</i> &#x2014; material icon named "not accessible" (sharp).
  static const IconData not_accessible_sharp = IconData(0xeb3d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">not_accessible</i> &#x2014; material icon named "not accessible" (round).
  static const IconData not_accessible_rounded = IconData(0xf001c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">not_accessible</i> &#x2014; material icon named "not accessible" (outlined).
  static const IconData not_accessible_outlined = IconData(0xf22a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">not_interested</i> &#x2014; material icon named "not interested".
  static const IconData not_interested = IconData(0xe446, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">not_interested</i> &#x2014; material icon named "not interested" (sharp).
  static const IconData not_interested_sharp = IconData(0xeb3e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">not_interested</i> &#x2014; material icon named "not interested" (round).
  static const IconData not_interested_rounded = IconData(0xf001d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">not_interested</i> &#x2014; material icon named "not interested" (outlined).
  static const IconData not_interested_outlined = IconData(0xf22b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">not_listed_location</i> &#x2014; material icon named "not listed location".
  static const IconData not_listed_location = IconData(0xe447, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">not_listed_location</i> &#x2014; material icon named "not listed location" (sharp).
  static const IconData not_listed_location_sharp = IconData(0xeb3f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">not_listed_location</i> &#x2014; material icon named "not listed location" (round).
  static const IconData not_listed_location_rounded = IconData(0xf001e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">not_listed_location</i> &#x2014; material icon named "not listed location" (outlined).
  static const IconData not_listed_location_outlined = IconData(0xf22c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">not_started</i> &#x2014; material icon named "not started".
  static const IconData not_started = IconData(0xe448, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">not_started</i> &#x2014; material icon named "not started" (sharp).
  static const IconData not_started_sharp = IconData(0xeb40, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">not_started</i> &#x2014; material icon named "not started" (round).
  static const IconData not_started_rounded = IconData(0xf001f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">not_started</i> &#x2014; material icon named "not started" (outlined).
  static const IconData not_started_outlined = IconData(0xf22d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">note</i> &#x2014; material icon named "note".
  static const IconData note = IconData(0xe449, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">note</i> &#x2014; material icon named "note" (sharp).
  static const IconData note_sharp = IconData(0xeb43, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">note</i> &#x2014; material icon named "note" (round).
  static const IconData note_rounded = IconData(0xf0022, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">note</i> &#x2014; material icon named "note" (outlined).
  static const IconData note_outlined = IconData(0xf230, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">note_add</i> &#x2014; material icon named "note add".
  static const IconData note_add = IconData(0xe44a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">note_add</i> &#x2014; material icon named "note add" (sharp).
  static const IconData note_add_sharp = IconData(0xeb41, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">note_add</i> &#x2014; material icon named "note add" (round).
  static const IconData note_add_rounded = IconData(0xf0020, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">note_add</i> &#x2014; material icon named "note add" (outlined).
  static const IconData note_add_outlined = IconData(0xf22e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">note_alt</i> &#x2014; material icon named "note alt".
  static const IconData note_alt = IconData(0xe44b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">note_alt</i> &#x2014; material icon named "note alt" (sharp).
  static const IconData note_alt_sharp = IconData(0xeb42, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">note_alt</i> &#x2014; material icon named "note alt" (round).
  static const IconData note_alt_rounded = IconData(0xf0021, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">note_alt</i> &#x2014; material icon named "note alt" (outlined).
  static const IconData note_alt_outlined = IconData(0xf22f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">notes</i> &#x2014; material icon named "notes".
  static const IconData notes = IconData(0xe44c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">notes</i> &#x2014; material icon named "notes" (sharp).
  static const IconData notes_sharp = IconData(0xeb44, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">notes</i> &#x2014; material icon named "notes" (round).
  static const IconData notes_rounded = IconData(0xf0023, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">notes</i> &#x2014; material icon named "notes" (outlined).
  static const IconData notes_outlined = IconData(0xf231, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">notification_add</i> &#x2014; material icon named "notification add".
  static const IconData notification_add = IconData(0xe44d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">notification_add</i> &#x2014; material icon named "notification add" (sharp).
  static const IconData notification_add_sharp = IconData(0xeb45, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">notification_add</i> &#x2014; material icon named "notification add" (round).
  static const IconData notification_add_rounded = IconData(0xf0024, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">notification_add</i> &#x2014; material icon named "notification add" (outlined).
  static const IconData notification_add_outlined = IconData(0xf232, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">notification_important</i> &#x2014; material icon named "notification important".
  static const IconData notification_important = IconData(0xe44e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">notification_important</i> &#x2014; material icon named "notification important" (sharp).
  static const IconData notification_important_sharp = IconData(0xeb46, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">notification_important</i> &#x2014; material icon named "notification important" (round).
  static const IconData notification_important_rounded = IconData(0xf0025, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">notification_important</i> &#x2014; material icon named "notification important" (outlined).
  static const IconData notification_important_outlined = IconData(0xf233, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">notifications</i> &#x2014; material icon named "notifications".
  static const IconData notifications = IconData(0xe44f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">notifications</i> &#x2014; material icon named "notifications" (sharp).
  static const IconData notifications_sharp = IconData(0xeb4b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">notifications</i> &#x2014; material icon named "notifications" (round).
  static const IconData notifications_rounded = IconData(0xf002a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">notifications</i> &#x2014; material icon named "notifications" (outlined).
  static const IconData notifications_outlined = IconData(0xf237, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">notifications_active</i> &#x2014; material icon named "notifications active".
  static const IconData notifications_active = IconData(0xe450, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">notifications_active</i> &#x2014; material icon named "notifications active" (sharp).
  static const IconData notifications_active_sharp = IconData(0xeb47, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">notifications_active</i> &#x2014; material icon named "notifications active" (round).
  static const IconData notifications_active_rounded = IconData(0xf0026, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">notifications_active</i> &#x2014; material icon named "notifications active" (outlined).
  static const IconData notifications_active_outlined = IconData(0xf234, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">notifications_none</i> &#x2014; material icon named "notifications none".
  static const IconData notifications_none = IconData(0xe451, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">notifications_none</i> &#x2014; material icon named "notifications none" (sharp).
  static const IconData notifications_none_sharp = IconData(0xeb48, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">notifications_none</i> &#x2014; material icon named "notifications none" (round).
  static const IconData notifications_none_rounded = IconData(0xf0027, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">notifications_none</i> &#x2014; material icon named "notifications none" (outlined).
  static const IconData notifications_none_outlined = IconData(0xf235, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">notifications_off</i> &#x2014; material icon named "notifications off".
  static const IconData notifications_off = IconData(0xe452, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">notifications_off</i> &#x2014; material icon named "notifications off" (sharp).
  static const IconData notifications_off_sharp = IconData(0xeb49, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">notifications_off</i> &#x2014; material icon named "notifications off" (round).
  static const IconData notifications_off_rounded = IconData(0xf0028, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">notifications_off</i> &#x2014; material icon named "notifications off" (outlined).
  static const IconData notifications_off_outlined = IconData(0xf236, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">notifications_on</i> &#x2014; material icon named "notifications on".
  static const IconData notifications_on = IconData(0xe450, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">notifications_on</i> &#x2014; material icon named "notifications on" (sharp).
  static const IconData notifications_on_sharp = IconData(0xeb47, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">notifications_on</i> &#x2014; material icon named "notifications on" (round).
  static const IconData notifications_on_rounded = IconData(0xf0026, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">notifications_on</i> &#x2014; material icon named "notifications on" (outlined).
  static const IconData notifications_on_outlined = IconData(0xf234, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">notifications_paused</i> &#x2014; material icon named "notifications paused".
  static const IconData notifications_paused = IconData(0xe453, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">notifications_paused</i> &#x2014; material icon named "notifications paused" (sharp).
  static const IconData notifications_paused_sharp = IconData(0xeb4a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">notifications_paused</i> &#x2014; material icon named "notifications paused" (round).
  static const IconData notifications_paused_rounded = IconData(0xf0029, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">notifications_paused</i> &#x2014; material icon named "notifications paused" (outlined).
  static const IconData notifications_paused_outlined = IconData(0xf238, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">now_wallpaper</i> &#x2014; material icon named "now wallpaper".
  static const IconData now_wallpaper = IconData(0xe6ca, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">now_wallpaper</i> &#x2014; material icon named "now wallpaper" (sharp).
  static const IconData now_wallpaper_sharp = IconData(0xedc0, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">now_wallpaper</i> &#x2014; material icon named "now wallpaper" (round).
  static const IconData now_wallpaper_rounded = IconData(0xf029f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">now_wallpaper</i> &#x2014; material icon named "now wallpaper" (outlined).
  static const IconData now_wallpaper_outlined = IconData(0xf4ad, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">now_widgets</i> &#x2014; material icon named "now widgets".
  static const IconData now_widgets = IconData(0xe6e6, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">now_widgets</i> &#x2014; material icon named "now widgets" (sharp).
  static const IconData now_widgets_sharp = IconData(0xedda, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">now_widgets</i> &#x2014; material icon named "now widgets" (round).
  static const IconData now_widgets_rounded = IconData(0xf02b9, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">now_widgets</i> &#x2014; material icon named "now widgets" (outlined).
  static const IconData now_widgets_outlined = IconData(0xf4c7, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">offline_bolt</i> &#x2014; material icon named "offline bolt".
  static const IconData offline_bolt = IconData(0xe454, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">offline_bolt</i> &#x2014; material icon named "offline bolt" (sharp).
  static const IconData offline_bolt_sharp = IconData(0xeb4c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">offline_bolt</i> &#x2014; material icon named "offline bolt" (round).
  static const IconData offline_bolt_rounded = IconData(0xf002b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">offline_bolt</i> &#x2014; material icon named "offline bolt" (outlined).
  static const IconData offline_bolt_outlined = IconData(0xf239, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">offline_pin</i> &#x2014; material icon named "offline pin".
  static const IconData offline_pin = IconData(0xe455, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">offline_pin</i> &#x2014; material icon named "offline pin" (sharp).
  static const IconData offline_pin_sharp = IconData(0xeb4d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">offline_pin</i> &#x2014; material icon named "offline pin" (round).
  static const IconData offline_pin_rounded = IconData(0xf002c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">offline_pin</i> &#x2014; material icon named "offline pin" (outlined).
  static const IconData offline_pin_outlined = IconData(0xf23a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">offline_share</i> &#x2014; material icon named "offline share".
  static const IconData offline_share = IconData(0xe456, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">offline_share</i> &#x2014; material icon named "offline share" (sharp).
  static const IconData offline_share_sharp = IconData(0xeb4e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">offline_share</i> &#x2014; material icon named "offline share" (round).
  static const IconData offline_share_rounded = IconData(0xf002d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">offline_share</i> &#x2014; material icon named "offline share" (outlined).
  static const IconData offline_share_outlined = IconData(0xf23b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">ondemand_video</i> &#x2014; material icon named "ondemand video".
  static const IconData ondemand_video = IconData(0xe457, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">ondemand_video</i> &#x2014; material icon named "ondemand video" (sharp).
  static const IconData ondemand_video_sharp = IconData(0xeb4f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">ondemand_video</i> &#x2014; material icon named "ondemand video" (round).
  static const IconData ondemand_video_rounded = IconData(0xf002e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">ondemand_video</i> &#x2014; material icon named "ondemand video" (outlined).
  static const IconData ondemand_video_outlined = IconData(0xf23c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">online_prediction</i> &#x2014; material icon named "online prediction".
  static const IconData online_prediction = IconData(0xe458, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">online_prediction</i> &#x2014; material icon named "online prediction" (sharp).
  static const IconData online_prediction_sharp = IconData(0xeb50, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">online_prediction</i> &#x2014; material icon named "online prediction" (round).
  static const IconData online_prediction_rounded = IconData(0xf002f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">online_prediction</i> &#x2014; material icon named "online prediction" (outlined).
  static const IconData online_prediction_outlined = IconData(0xf23d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">opacity</i> &#x2014; material icon named "opacity".
  static const IconData opacity = IconData(0xe459, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">opacity</i> &#x2014; material icon named "opacity" (sharp).
  static const IconData opacity_sharp = IconData(0xeb51, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">opacity</i> &#x2014; material icon named "opacity" (round).
  static const IconData opacity_rounded = IconData(0xf0030, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">opacity</i> &#x2014; material icon named "opacity" (outlined).
  static const IconData opacity_outlined = IconData(0xf23e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">open_in_browser</i> &#x2014; material icon named "open in browser".
  static const IconData open_in_browser = IconData(0xe45a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">open_in_browser</i> &#x2014; material icon named "open in browser" (sharp).
  static const IconData open_in_browser_sharp = IconData(0xeb52, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">open_in_browser</i> &#x2014; material icon named "open in browser" (round).
  static const IconData open_in_browser_rounded = IconData(0xf0031, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">open_in_browser</i> &#x2014; material icon named "open in browser" (outlined).
  static const IconData open_in_browser_outlined = IconData(0xf23f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">open_in_full</i> &#x2014; material icon named "open in full".
  static const IconData open_in_full = IconData(0xe45b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">open_in_full</i> &#x2014; material icon named "open in full" (sharp).
  static const IconData open_in_full_sharp = IconData(0xeb53, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">open_in_full</i> &#x2014; material icon named "open in full" (round).
  static const IconData open_in_full_rounded = IconData(0xf0032, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">open_in_full</i> &#x2014; material icon named "open in full" (outlined).
  static const IconData open_in_full_outlined = IconData(0xf240, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">open_in_new</i> &#x2014; material icon named "open in new".
  static const IconData open_in_new = IconData(0xe45c, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-sharp md-36">open_in_new</i> &#x2014; material icon named "open in new" (sharp).
  static const IconData open_in_new_sharp = IconData(0xeb55, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-round md-36">open_in_new</i> &#x2014; material icon named "open in new" (round).
  static const IconData open_in_new_rounded = IconData(0xf0034, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons-outlined md-36">open_in_new</i> &#x2014; material icon named "open in new" (outlined).
  static const IconData open_in_new_outlined = IconData(0xf242, fontFamily: 'MaterialIcons', matchTextDirection: true);

  /// <i class="material-icons md-36">open_in_new_off</i> &#x2014; material icon named "open in new off".
  static const IconData open_in_new_off = IconData(0xe45d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">open_in_new_off</i> &#x2014; material icon named "open in new off" (sharp).
  static const IconData open_in_new_off_sharp = IconData(0xeb54, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">open_in_new_off</i> &#x2014; material icon named "open in new off" (round).
  static const IconData open_in_new_off_rounded = IconData(0xf0033, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">open_in_new_off</i> &#x2014; material icon named "open in new off" (outlined).
  static const IconData open_in_new_off_outlined = IconData(0xf241, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">open_with</i> &#x2014; material icon named "open with".
  static const IconData open_with = IconData(0xe45e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">open_with</i> &#x2014; material icon named "open with" (sharp).
  static const IconData open_with_sharp = IconData(0xeb56, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">open_with</i> &#x2014; material icon named "open with" (round).
  static const IconData open_with_rounded = IconData(0xf0035, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">open_with</i> &#x2014; material icon named "open with" (outlined).
  static const IconData open_with_outlined = IconData(0xf243, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">other_houses</i> &#x2014; material icon named "other houses".
  static const IconData other_houses = IconData(0xe45f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">other_houses</i> &#x2014; material icon named "other houses" (sharp).
  static const IconData other_houses_sharp = IconData(0xeb57, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">other_houses</i> &#x2014; material icon named "other houses" (round).
  static const IconData other_houses_rounded = IconData(0xf0036, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">other_houses</i> &#x2014; material icon named "other houses" (outlined).
  static const IconData other_houses_outlined = IconData(0xf244, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">outbond</i> &#x2014; material icon named "outbond".
  static const IconData outbond = IconData(0xe460, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">outbond</i> &#x2014; material icon named "outbond" (sharp).
  static const IconData outbond_sharp = IconData(0xeb58, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">outbond</i> &#x2014; material icon named "outbond" (round).
  static const IconData outbond_rounded = IconData(0xf0037, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">outbond</i> &#x2014; material icon named "outbond" (outlined).
  static const IconData outbond_outlined = IconData(0xf245, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">outbound</i> &#x2014; material icon named "outbound".
  static const IconData outbound = IconData(0xe461, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">outbound</i> &#x2014; material icon named "outbound" (sharp).
  static const IconData outbound_sharp = IconData(0xeb59, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">outbound</i> &#x2014; material icon named "outbound" (round).
  static const IconData outbound_rounded = IconData(0xf0038, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">outbound</i> &#x2014; material icon named "outbound" (outlined).
  static const IconData outbound_outlined = IconData(0xf246, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">outbox</i> &#x2014; material icon named "outbox".
  static const IconData outbox = IconData(0xe462, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">outbox</i> &#x2014; material icon named "outbox" (sharp).
  static const IconData outbox_sharp = IconData(0xeb5a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">outbox</i> &#x2014; material icon named "outbox" (round).
  static const IconData outbox_rounded = IconData(0xf0039, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">outbox</i> &#x2014; material icon named "outbox" (outlined).
  static const IconData outbox_outlined = IconData(0xf247, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">outdoor_grill</i> &#x2014; material icon named "outdoor grill".
  static const IconData outdoor_grill = IconData(0xe463, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">outdoor_grill</i> &#x2014; material icon named "outdoor grill" (sharp).
  static const IconData outdoor_grill_sharp = IconData(0xeb5b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">outdoor_grill</i> &#x2014; material icon named "outdoor grill" (round).
  static const IconData outdoor_grill_rounded = IconData(0xf003a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">outdoor_grill</i> &#x2014; material icon named "outdoor grill" (outlined).
  static const IconData outdoor_grill_outlined = IconData(0xf248, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">outgoing_mail</i> &#x2014; material icon named "outgoing mail".
  static const IconData outgoing_mail = IconData(0xe464, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">outlet</i> &#x2014; material icon named "outlet".
  static const IconData outlet = IconData(0xe465, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">outlet</i> &#x2014; material icon named "outlet" (sharp).
  static const IconData outlet_sharp = IconData(0xeb5c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">outlet</i> &#x2014; material icon named "outlet" (round).
  static const IconData outlet_rounded = IconData(0xf003b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">outlet</i> &#x2014; material icon named "outlet" (outlined).
  static const IconData outlet_outlined = IconData(0xf249, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">outlined_flag</i> &#x2014; material icon named "outlined flag".
  static const IconData outlined_flag = IconData(0xe466, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">outlined_flag</i> &#x2014; material icon named "outlined flag" (sharp).
  static const IconData outlined_flag_sharp = IconData(0xeb5d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">outlined_flag</i> &#x2014; material icon named "outlined flag" (round).
  static const IconData outlined_flag_rounded = IconData(0xf003c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">outlined_flag</i> &#x2014; material icon named "outlined flag" (outlined).
  static const IconData outlined_flag_outlined = IconData(0xf24a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">padding</i> &#x2014; material icon named "padding".
  static const IconData padding = IconData(0xe467, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">padding</i> &#x2014; material icon named "padding" (sharp).
  static const IconData padding_sharp = IconData(0xeb5e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">padding</i> &#x2014; material icon named "padding" (round).
  static const IconData padding_rounded = IconData(0xf003d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">padding</i> &#x2014; material icon named "padding" (outlined).
  static const IconData padding_outlined = IconData(0xf24b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pages</i> &#x2014; material icon named "pages".
  static const IconData pages = IconData(0xe468, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">pages</i> &#x2014; material icon named "pages" (sharp).
  static const IconData pages_sharp = IconData(0xeb5f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">pages</i> &#x2014; material icon named "pages" (round).
  static const IconData pages_rounded = IconData(0xf003e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">pages</i> &#x2014; material icon named "pages" (outlined).
  static const IconData pages_outlined = IconData(0xf24c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pageview</i> &#x2014; material icon named "pageview".
  static const IconData pageview = IconData(0xe469, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">pageview</i> &#x2014; material icon named "pageview" (sharp).
  static const IconData pageview_sharp = IconData(0xeb60, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">pageview</i> &#x2014; material icon named "pageview" (round).
  static const IconData pageview_rounded = IconData(0xf003f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">pageview</i> &#x2014; material icon named "pageview" (outlined).
  static const IconData pageview_outlined = IconData(0xf24d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">paid</i> &#x2014; material icon named "paid".
  static const IconData paid = IconData(0xe46a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">paid</i> &#x2014; material icon named "paid" (sharp).
  static const IconData paid_sharp = IconData(0xeb61, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">paid</i> &#x2014; material icon named "paid" (round).
  static const IconData paid_rounded = IconData(0xf0040, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">paid</i> &#x2014; material icon named "paid" (outlined).
  static const IconData paid_outlined = IconData(0xf24e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">palette</i> &#x2014; material icon named "palette".
  static const IconData palette = IconData(0xe46b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">palette</i> &#x2014; material icon named "palette" (sharp).
  static const IconData palette_sharp = IconData(0xeb62, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">palette</i> &#x2014; material icon named "palette" (round).
  static const IconData palette_rounded = IconData(0xf0041, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">palette</i> &#x2014; material icon named "palette" (outlined).
  static const IconData palette_outlined = IconData(0xf24f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pan_tool</i> &#x2014; material icon named "pan tool".
  static const IconData pan_tool = IconData(0xe46c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">pan_tool</i> &#x2014; material icon named "pan tool" (sharp).
  static const IconData pan_tool_sharp = IconData(0xeb63, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">pan_tool</i> &#x2014; material icon named "pan tool" (round).
  static const IconData pan_tool_rounded = IconData(0xf0042, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">pan_tool</i> &#x2014; material icon named "pan tool" (outlined).
  static const IconData pan_tool_outlined = IconData(0xf250, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">panorama</i> &#x2014; material icon named "panorama".
  static const IconData panorama = IconData(0xe46d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">panorama</i> &#x2014; material icon named "panorama" (sharp).
  static const IconData panorama_sharp = IconData(0xeb69, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">panorama</i> &#x2014; material icon named "panorama" (round).
  static const IconData panorama_rounded = IconData(0xf0048, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">panorama</i> &#x2014; material icon named "panorama" (outlined).
  static const IconData panorama_outlined = IconData(0xf254, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">panorama_fish_eye</i> &#x2014; material icon named "panorama fish eye".
  static const IconData panorama_fish_eye = IconData(0xe46e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">panorama_fish_eye</i> &#x2014; material icon named "panorama fish eye" (sharp).
  static const IconData panorama_fish_eye_sharp = IconData(0xeb64, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">panorama_fish_eye</i> &#x2014; material icon named "panorama fish eye" (round).
  static const IconData panorama_fish_eye_rounded = IconData(0xf0043, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">panorama_fish_eye</i> &#x2014; material icon named "panorama fish eye" (outlined).
  static const IconData panorama_fish_eye_outlined = IconData(0xf251, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">panorama_fisheye</i> &#x2014; material icon named "panorama fisheye".
  static const IconData panorama_fisheye = IconData(0xe46e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">panorama_fisheye</i> &#x2014; material icon named "panorama fisheye" (sharp).
  static const IconData panorama_fisheye_sharp = IconData(0xeb64, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">panorama_fisheye</i> &#x2014; material icon named "panorama fisheye" (round).
  static const IconData panorama_fisheye_rounded = IconData(0xf0043, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">panorama_fisheye</i> &#x2014; material icon named "panorama fisheye" (outlined).
  static const IconData panorama_fisheye_outlined = IconData(0xf251, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">panorama_horizontal</i> &#x2014; material icon named "panorama horizontal".
  static const IconData panorama_horizontal = IconData(0xe46f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">panorama_horizontal</i> &#x2014; material icon named "panorama horizontal" (sharp).
  static const IconData panorama_horizontal_sharp = IconData(0xeb66, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">panorama_horizontal</i> &#x2014; material icon named "panorama horizontal" (round).
  static const IconData panorama_horizontal_rounded = IconData(0xf0044, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">panorama_horizontal</i> &#x2014; material icon named "panorama horizontal" (outlined).
  static const IconData panorama_horizontal_outlined = IconData(0xf252, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">panorama_horizontal_select</i> &#x2014; material icon named "panorama horizontal select".
  static const IconData panorama_horizontal_select = IconData(0xe470, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">panorama_horizontal_select</i> &#x2014; material icon named "panorama horizontal select" (sharp).
  static const IconData panorama_horizontal_select_sharp = IconData(0xeb65, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">panorama_horizontal_select</i> &#x2014; material icon named "panorama horizontal select" (round).
  static const IconData panorama_horizontal_select_rounded = IconData(0xf0045, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">panorama_horizontal_select</i> &#x2014; material icon named "panorama horizontal select" (outlined).
  static const IconData panorama_horizontal_select_outlined = IconData(0xf253, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">panorama_photosphere</i> &#x2014; material icon named "panorama photosphere".
  static const IconData panorama_photosphere = IconData(0xe471, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">panorama_photosphere</i> &#x2014; material icon named "panorama photosphere" (sharp).
  static const IconData panorama_photosphere_sharp = IconData(0xeb68, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">panorama_photosphere</i> &#x2014; material icon named "panorama photosphere" (round).
  static const IconData panorama_photosphere_rounded = IconData(0xf0046, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">panorama_photosphere</i> &#x2014; material icon named "panorama photosphere" (outlined).
  static const IconData panorama_photosphere_outlined = IconData(0xf255, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">panorama_photosphere_select</i> &#x2014; material icon named "panorama photosphere select".
  static const IconData panorama_photosphere_select = IconData(0xe472, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">panorama_photosphere_select</i> &#x2014; material icon named "panorama photosphere select" (sharp).
  static const IconData panorama_photosphere_select_sharp = IconData(0xeb67, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">panorama_photosphere_select</i> &#x2014; material icon named "panorama photosphere select" (round).
  static const IconData panorama_photosphere_select_rounded = IconData(0xf0047, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">panorama_photosphere_select</i> &#x2014; material icon named "panorama photosphere select" (outlined).
  static const IconData panorama_photosphere_select_outlined = IconData(0xf256, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">panorama_vertical</i> &#x2014; material icon named "panorama vertical".
  static const IconData panorama_vertical = IconData(0xe473, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">panorama_vertical</i> &#x2014; material icon named "panorama vertical" (sharp).
  static const IconData panorama_vertical_sharp = IconData(0xeb6b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">panorama_vertical</i> &#x2014; material icon named "panorama vertical" (round).
  static const IconData panorama_vertical_rounded = IconData(0xf0049, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">panorama_vertical</i> &#x2014; material icon named "panorama vertical" (outlined).
  static const IconData panorama_vertical_outlined = IconData(0xf257, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">panorama_vertical_select</i> &#x2014; material icon named "panorama vertical select".
  static const IconData panorama_vertical_select = IconData(0xe474, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">panorama_vertical_select</i> &#x2014; material icon named "panorama vertical select" (sharp).
  static const IconData panorama_vertical_select_sharp = IconData(0xeb6a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">panorama_vertical_select</i> &#x2014; material icon named "panorama vertical select" (round).
  static const IconData panorama_vertical_select_rounded = IconData(0xf004a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">panorama_vertical_select</i> &#x2014; material icon named "panorama vertical select" (outlined).
  static const IconData panorama_vertical_select_outlined = IconData(0xf258, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">panorama_wide_angle</i> &#x2014; material icon named "panorama wide angle".
  static const IconData panorama_wide_angle = IconData(0xe475, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">panorama_wide_angle</i> &#x2014; material icon named "panorama wide angle" (sharp).
  static const IconData panorama_wide_angle_sharp = IconData(0xeb6d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">panorama_wide_angle</i> &#x2014; material icon named "panorama wide angle" (round).
  static const IconData panorama_wide_angle_rounded = IconData(0xf004b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">panorama_wide_angle</i> &#x2014; material icon named "panorama wide angle" (outlined).
  static const IconData panorama_wide_angle_outlined = IconData(0xf259, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">panorama_wide_angle_select</i> &#x2014; material icon named "panorama wide angle select".
  static const IconData panorama_wide_angle_select = IconData(0xe476, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">panorama_wide_angle_select</i> &#x2014; material icon named "panorama wide angle select" (sharp).
  static const IconData panorama_wide_angle_select_sharp = IconData(0xeb6c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">panorama_wide_angle_select</i> &#x2014; material icon named "panorama wide angle select" (round).
  static const IconData panorama_wide_angle_select_rounded = IconData(0xf004c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">panorama_wide_angle_select</i> &#x2014; material icon named "panorama wide angle select" (outlined).
  static const IconData panorama_wide_angle_select_outlined = IconData(0xf25a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">paragliding</i> &#x2014; material icon named "paragliding".
  static const IconData paragliding = IconData(0xe477, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">paragliding</i> &#x2014; material icon named "paragliding" (sharp).
  static const IconData paragliding_sharp = IconData(0xeb6e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">paragliding</i> &#x2014; material icon named "paragliding" (round).
  static const IconData paragliding_rounded = IconData(0xf004d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">paragliding</i> &#x2014; material icon named "paragliding" (outlined).
  static const IconData paragliding_outlined = IconData(0xf25b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">park</i> &#x2014; material icon named "park".
  static const IconData park = IconData(0xe478, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">park</i> &#x2014; material icon named "park" (sharp).
  static const IconData park_sharp = IconData(0xeb6f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">park</i> &#x2014; material icon named "park" (round).
  static const IconData park_rounded = IconData(0xf004e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">park</i> &#x2014; material icon named "park" (outlined).
  static const IconData park_outlined = IconData(0xf25c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">party_mode</i> &#x2014; material icon named "party mode".
  static const IconData party_mode = IconData(0xe479, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">party_mode</i> &#x2014; material icon named "party mode" (sharp).
  static const IconData party_mode_sharp = IconData(0xeb70, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">party_mode</i> &#x2014; material icon named "party mode" (round).
  static const IconData party_mode_rounded = IconData(0xf004f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">party_mode</i> &#x2014; material icon named "party mode" (outlined).
  static const IconData party_mode_outlined = IconData(0xf25d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">password</i> &#x2014; material icon named "password".
  static const IconData password = IconData(0xe47a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">password</i> &#x2014; material icon named "password" (sharp).
  static const IconData password_sharp = IconData(0xeb71, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">password</i> &#x2014; material icon named "password" (round).
  static const IconData password_rounded = IconData(0xf0050, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">password</i> &#x2014; material icon named "password" (outlined).
  static const IconData password_outlined = IconData(0xf25e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">paste</i> &#x2014; material icon named "paste".
  static const IconData paste = IconData(0xe192, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">paste</i> &#x2014; material icon named "paste" (sharp).
  static const IconData paste_sharp = IconData(0xe890, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">paste</i> &#x2014; material icon named "paste" (round).
  static const IconData paste_rounded = IconData(0xf66f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">paste</i> &#x2014; material icon named "paste" (outlined).
  static const IconData paste_outlined = IconData(0xef82, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pattern</i> &#x2014; material icon named "pattern".
  static const IconData pattern = IconData(0xe47b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">pattern</i> &#x2014; material icon named "pattern" (sharp).
  static const IconData pattern_sharp = IconData(0xeb72, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">pattern</i> &#x2014; material icon named "pattern" (round).
  static const IconData pattern_rounded = IconData(0xf0051, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">pattern</i> &#x2014; material icon named "pattern" (outlined).
  static const IconData pattern_outlined = IconData(0xf25f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pause</i> &#x2014; material icon named "pause".
  static const IconData pause = IconData(0xe47c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">pause</i> &#x2014; material icon named "pause" (sharp).
  static const IconData pause_sharp = IconData(0xeb77, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">pause</i> &#x2014; material icon named "pause" (round).
  static const IconData pause_rounded = IconData(0xf0056, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">pause</i> &#x2014; material icon named "pause" (outlined).
  static const IconData pause_outlined = IconData(0xf263, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pause_circle</i> &#x2014; material icon named "pause circle".
  static const IconData pause_circle = IconData(0xe47d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">pause_circle</i> &#x2014; material icon named "pause circle" (sharp).
  static const IconData pause_circle_sharp = IconData(0xeb75, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">pause_circle</i> &#x2014; material icon named "pause circle" (round).
  static const IconData pause_circle_rounded = IconData(0xf0054, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">pause_circle</i> &#x2014; material icon named "pause circle" (outlined).
  static const IconData pause_circle_outlined = IconData(0xf262, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pause_circle_filled</i> &#x2014; material icon named "pause circle filled".
  static const IconData pause_circle_filled = IconData(0xe47e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">pause_circle_filled</i> &#x2014; material icon named "pause circle filled" (sharp).
  static const IconData pause_circle_filled_sharp = IconData(0xeb73, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">pause_circle_filled</i> &#x2014; material icon named "pause circle filled" (round).
  static const IconData pause_circle_filled_rounded = IconData(0xf0052, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">pause_circle_filled</i> &#x2014; material icon named "pause circle filled" (outlined).
  static const IconData pause_circle_filled_outlined = IconData(0xf260, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pause_circle_outline</i> &#x2014; material icon named "pause circle outline".
  static const IconData pause_circle_outline = IconData(0xe47f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">pause_circle_outline</i> &#x2014; material icon named "pause circle outline" (sharp).
  static const IconData pause_circle_outline_sharp = IconData(0xeb74, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">pause_circle_outline</i> &#x2014; material icon named "pause circle outline" (round).
  static const IconData pause_circle_outline_rounded = IconData(0xf0053, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">pause_circle_outline</i> &#x2014; material icon named "pause circle outline" (outlined).
  static const IconData pause_circle_outline_outlined = IconData(0xf261, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pause_presentation</i> &#x2014; material icon named "pause presentation".
  static const IconData pause_presentation = IconData(0xe480, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">pause_presentation</i> &#x2014; material icon named "pause presentation" (sharp).
  static const IconData pause_presentation_sharp = IconData(0xeb76, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">pause_presentation</i> &#x2014; material icon named "pause presentation" (round).
  static const IconData pause_presentation_rounded = IconData(0xf0055, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">pause_presentation</i> &#x2014; material icon named "pause presentation" (outlined).
  static const IconData pause_presentation_outlined = IconData(0xf264, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">payment</i> &#x2014; material icon named "payment".
  static const IconData payment = IconData(0xe481, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">payment</i> &#x2014; material icon named "payment" (sharp).
  static const IconData payment_sharp = IconData(0xeb78, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">payment</i> &#x2014; material icon named "payment" (round).
  static const IconData payment_rounded = IconData(0xf0057, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">payment</i> &#x2014; material icon named "payment" (outlined).
  static const IconData payment_outlined = IconData(0xf265, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">payments</i> &#x2014; material icon named "payments".
  static const IconData payments = IconData(0xe482, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">payments</i> &#x2014; material icon named "payments" (sharp).
  static const IconData payments_sharp = IconData(0xeb79, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">payments</i> &#x2014; material icon named "payments" (round).
  static const IconData payments_rounded = IconData(0xf0058, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">payments</i> &#x2014; material icon named "payments" (outlined).
  static const IconData payments_outlined = IconData(0xf266, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pedal_bike</i> &#x2014; material icon named "pedal bike".
  static const IconData pedal_bike = IconData(0xe483, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">pedal_bike</i> &#x2014; material icon named "pedal bike" (sharp).
  static const IconData pedal_bike_sharp = IconData(0xeb7a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">pedal_bike</i> &#x2014; material icon named "pedal bike" (round).
  static const IconData pedal_bike_rounded = IconData(0xf0059, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">pedal_bike</i> &#x2014; material icon named "pedal bike" (outlined).
  static const IconData pedal_bike_outlined = IconData(0xf267, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pending</i> &#x2014; material icon named "pending".
  static const IconData pending = IconData(0xe484, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">pending</i> &#x2014; material icon named "pending" (sharp).
  static const IconData pending_sharp = IconData(0xeb7c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">pending</i> &#x2014; material icon named "pending" (round).
  static const IconData pending_rounded = IconData(0xf005b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">pending</i> &#x2014; material icon named "pending" (outlined).
  static const IconData pending_outlined = IconData(0xf269, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">pending_actions</i> &#x2014; material icon named "pending actions".
  static const IconData pending_actions = IconData(0xe485, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">pending_actions</i> &#x2014; material icon named "pending actions" (sharp).
  static const IconData pending_actions_sharp = IconData(0xeb7b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">pending_actions</i> &#x2014; material icon named "pending actions" (round).
  static const IconData pending_actions_rounded = IconData(0xf005a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">pending_actions</i> &#x2014; material icon named "pending actions" (outlined).
  static const IconData pending_actions_outlined = IconData(0xf268, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">people</i> &#x2014; material icon named "people".
  static const IconData people = IconData(0xe486, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">people</i> &#x2014; material icon named "people" (sharp).
  static const IconData people_sharp = IconData(0xeb7f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">people</i> &#x2014; material icon named "people" (round).
  static const IconData people_rounded = IconData(0xf005e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">people</i> &#x2014; material icon named "people" (outlined).
  static const IconData people_outlined = IconData(0xf26c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">people_alt</i> &#x2014; material icon named "people alt".
  static const IconData people_alt = IconData(0xe487, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">people_alt</i> &#x2014; material icon named "people alt" (sharp).
  static const IconData people_alt_sharp = IconData(0xeb7d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">people_alt</i> &#x2014; material icon named "people alt" (round).
  static const IconData people_alt_rounded = IconData(0xf005c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">people_alt</i> &#x2014; material icon named "people alt" (outlined).
  static const IconData people_alt_outlined = IconData(0xf26a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">people_outline</i> &#x2014; material icon named "people outline".
  static const IconData people_outline = IconData(0xe488, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">people_outline</i> &#x2014; material icon named "people outline" (sharp).
  static const IconData people_outline_sharp = IconData(0xeb7e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">people_outline</i> &#x2014; material icon named "people outline" (round).
  static const IconData people_outline_rounded = IconData(0xf005d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">people_outline</i> &#x2014; material icon named "people outline" (outlined).
  static const IconData people_outline_outlined = IconData(0xf26b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">perm_camera_mic</i> &#x2014; material icon named "perm camera mic".
  static const IconData perm_camera_mic = IconData(0xe489, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">perm_camera_mic</i> &#x2014; material icon named "perm camera mic" (sharp).
  static const IconData perm_camera_mic_sharp = IconData(0xeb80, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">perm_camera_mic</i> &#x2014; material icon named "perm camera mic" (round).
  static const IconData perm_camera_mic_rounded = IconData(0xf005f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">perm_camera_mic</i> &#x2014; material icon named "perm camera mic" (outlined).
  static const IconData perm_camera_mic_outlined = IconData(0xf26d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">perm_contact_cal</i> &#x2014; material icon named "perm contact cal".
  static const IconData perm_contact_cal = IconData(0xe48a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">perm_contact_cal</i> &#x2014; material icon named "perm contact cal" (sharp).
  static const IconData perm_contact_cal_sharp = IconData(0xeb81, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">perm_contact_cal</i> &#x2014; material icon named "perm contact cal" (round).
  static const IconData perm_contact_cal_rounded = IconData(0xf0060, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">perm_contact_cal</i> &#x2014; material icon named "perm contact cal" (outlined).
  static const IconData perm_contact_cal_outlined = IconData(0xf26e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">perm_contact_calendar</i> &#x2014; material icon named "perm contact calendar".
  static const IconData perm_contact_calendar = IconData(0xe48a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">perm_contact_calendar</i> &#x2014; material icon named "perm contact calendar" (sharp).
  static const IconData perm_contact_calendar_sharp = IconData(0xeb81, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">perm_contact_calendar</i> &#x2014; material icon named "perm contact calendar" (round).
  static const IconData perm_contact_calendar_rounded = IconData(0xf0060, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">perm_contact_calendar</i> &#x2014; material icon named "perm contact calendar" (outlined).
  static const IconData perm_contact_calendar_outlined = IconData(0xf26e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">perm_data_setting</i> &#x2014; material icon named "perm data setting".
  static const IconData perm_data_setting = IconData(0xe48b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">perm_data_setting</i> &#x2014; material icon named "perm data setting" (sharp).
  static const IconData perm_data_setting_sharp = IconData(0xeb82, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">perm_data_setting</i> &#x2014; material icon named "perm data setting" (round).
  static const IconData perm_data_setting_rounded = IconData(0xf0061, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">perm_data_setting</i> &#x2014; material icon named "perm data setting" (outlined).
  static const IconData perm_data_setting_outlined = IconData(0xf26f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">perm_device_info</i> &#x2014; material icon named "perm device info".
  static const IconData perm_device_info = IconData(0xe48c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">perm_device_info</i> &#x2014; material icon named "perm device info" (sharp).
  static const IconData perm_device_info_sharp = IconData(0xeb83, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">perm_device_info</i> &#x2014; material icon named "perm device info" (round).
  static const IconData perm_device_info_rounded = IconData(0xf0062, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">perm_device_info</i> &#x2014; material icon named "perm device info" (outlined).
  static const IconData perm_device_info_outlined = IconData(0xf270, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">perm_device_information</i> &#x2014; material icon named "perm device information".
  static const IconData perm_device_information = IconData(0xe48c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">perm_device_information</i> &#x2014; material icon named "perm device information" (sharp).
  static const IconData perm_device_information_sharp = IconData(0xeb83, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">perm_device_information</i> &#x2014; material icon named "perm device information" (round).
  static const IconData perm_device_information_rounded = IconData(0xf0062, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">perm_device_information</i> &#x2014; material icon named "perm device information" (outlined).
  static const IconData perm_device_information_outlined = IconData(0xf270, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">perm_identity</i> &#x2014; material icon named "perm identity".
  static const IconData perm_identity = IconData(0xe48d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">perm_identity</i> &#x2014; material icon named "perm identity" (sharp).
  static const IconData perm_identity_sharp = IconData(0xeb84, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">perm_identity</i> &#x2014; material icon named "perm identity" (round).
  static const IconData perm_identity_rounded = IconData(0xf0063, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">perm_identity</i> &#x2014; material icon named "perm identity" (outlined).
  static const IconData perm_identity_outlined = IconData(0xf271, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">perm_media</i> &#x2014; material icon named "perm media".
  static const IconData perm_media = IconData(0xe48e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">perm_media</i> &#x2014; material icon named "perm media" (sharp).
  static const IconData perm_media_sharp = IconData(0xeb85, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">perm_media</i> &#x2014; material icon named "perm media" (round).
  static const IconData perm_media_rounded = IconData(0xf0064, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">perm_media</i> &#x2014; material icon named "perm media" (outlined).
  static const IconData perm_media_outlined = IconData(0xf272, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">perm_phone_msg</i> &#x2014; material icon named "perm phone msg".
  static const IconData perm_phone_msg = IconData(0xe48f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">perm_phone_msg</i> &#x2014; material icon named "perm phone msg" (sharp).
  static const IconData perm_phone_msg_sharp = IconData(0xeb86, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">perm_phone_msg</i> &#x2014; material icon named "perm phone msg" (round).
  static const IconData perm_phone_msg_rounded = IconData(0xf0065, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">perm_phone_msg</i> &#x2014; material icon named "perm phone msg" (outlined).
  static const IconData perm_phone_msg_outlined = IconData(0xf273, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">perm_scan_wifi</i> &#x2014; material icon named "perm scan wifi".
  static const IconData perm_scan_wifi = IconData(0xe490, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">perm_scan_wifi</i> &#x2014; material icon named "perm scan wifi" (sharp).
  static const IconData perm_scan_wifi_sharp = IconData(0xeb87, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">perm_scan_wifi</i> &#x2014; material icon named "perm scan wifi" (round).
  static const IconData perm_scan_wifi_rounded = IconData(0xf0066, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">perm_scan_wifi</i> &#x2014; material icon named "perm scan wifi" (outlined).
  static const IconData perm_scan_wifi_outlined = IconData(0xf274, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">person</i> &#x2014; material icon named "person".
  static const IconData person = IconData(0xe491, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">person</i> &#x2014; material icon named "person" (sharp).
  static const IconData person_sharp = IconData(0xeb93, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">person</i> &#x2014; material icon named "person" (round).
  static const IconData person_rounded = IconData(0xf0071, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">person</i> &#x2014; material icon named "person" (outlined).
  static const IconData person_outlined = IconData(0xf27b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">person_add</i> &#x2014; material icon named "person add".
  static const IconData person_add = IconData(0xe492, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">person_add</i> &#x2014; material icon named "person add" (sharp).
  static const IconData person_add_sharp = IconData(0xeb8b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">person_add</i> &#x2014; material icon named "person add" (round).
  static const IconData person_add_rounded = IconData(0xf006a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">person_add</i> &#x2014; material icon named "person add" (outlined).
  static const IconData person_add_outlined = IconData(0xf278, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">person_add_alt</i> &#x2014; material icon named "person add alt".
  static const IconData person_add_alt = IconData(0xe493, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">person_add_alt</i> &#x2014; material icon named "person add alt" (sharp).
  static const IconData person_add_alt_sharp = IconData(0xeb89, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">person_add_alt</i> &#x2014; material icon named "person add alt" (round).
  static const IconData person_add_alt_rounded = IconData(0xf0068, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">person_add_alt</i> &#x2014; material icon named "person add alt" (outlined).
  static const IconData person_add_alt_outlined = IconData(0xf276, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">person_add_alt_1</i> &#x2014; material icon named "person add alt 1".
  static const IconData person_add_alt_1 = IconData(0xe494, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">person_add_alt_1</i> &#x2014; material icon named "person add alt 1" (sharp).
  static const IconData person_add_alt_1_sharp = IconData(0xeb88, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">person_add_alt_1</i> &#x2014; material icon named "person add alt 1" (round).
  static const IconData person_add_alt_1_rounded = IconData(0xf0067, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">person_add_alt_1</i> &#x2014; material icon named "person add alt 1" (outlined).
  static const IconData person_add_alt_1_outlined = IconData(0xf275, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">person_add_disabled</i> &#x2014; material icon named "person add disabled".
  static const IconData person_add_disabled = IconData(0xe495, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">person_add_disabled</i> &#x2014; material icon named "person add disabled" (sharp).
  static const IconData person_add_disabled_sharp = IconData(0xeb8a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">person_add_disabled</i> &#x2014; material icon named "person add disabled" (round).
  static const IconData person_add_disabled_rounded = IconData(0xf0069, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">person_add_disabled</i> &#x2014; material icon named "person add disabled" (outlined).
  static const IconData person_add_disabled_outlined = IconData(0xf277, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">person_off</i> &#x2014; material icon named "person off".
  static const IconData person_off = IconData(0xe496, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">person_off</i> &#x2014; material icon named "person off" (sharp).
  static const IconData person_off_sharp = IconData(0xeb8c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">person_off</i> &#x2014; material icon named "person off" (round).
  static const IconData person_off_rounded = IconData(0xf006b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">person_off</i> &#x2014; material icon named "person off" (outlined).
  static const IconData person_off_outlined = IconData(0xf279, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">person_outline</i> &#x2014; material icon named "person outline".
  static const IconData person_outline = IconData(0xe497, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">person_outline</i> &#x2014; material icon named "person outline" (sharp).
  static const IconData person_outline_sharp = IconData(0xeb8d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">person_outline</i> &#x2014; material icon named "person outline" (round).
  static const IconData person_outline_rounded = IconData(0xf006c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">person_outline</i> &#x2014; material icon named "person outline" (outlined).
  static const IconData person_outline_outlined = IconData(0xf27a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">person_pin</i> &#x2014; material icon named "person pin".
  static const IconData person_pin = IconData(0xe498, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">person_pin</i> &#x2014; material icon named "person pin" (sharp).
  static const IconData person_pin_sharp = IconData(0xeb8f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">person_pin</i> &#x2014; material icon named "person pin" (round).
  static const IconData person_pin_rounded = IconData(0xf006e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">person_pin</i> &#x2014; material icon named "person pin" (outlined).
  static const IconData person_pin_outlined = IconData(0xf27d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">person_pin_circle</i> &#x2014; material icon named "person pin circle".
  static const IconData person_pin_circle = IconData(0xe499, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">person_pin_circle</i> &#x2014; material icon named "person pin circle" (sharp).
  static const IconData person_pin_circle_sharp = IconData(0xeb8e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">person_pin_circle</i> &#x2014; material icon named "person pin circle" (round).
  static const IconData person_pin_circle_rounded = IconData(0xf006d, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">person_pin_circle</i> &#x2014; material icon named "person pin circle" (outlined).
  static const IconData person_pin_circle_outlined = IconData(0xf27c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">person_remove</i> &#x2014; material icon named "person remove".
  static const IconData person_remove = IconData(0xe49a, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">person_remove</i> &#x2014; material icon named "person remove" (sharp).
  static const IconData person_remove_sharp = IconData(0xeb91, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">person_remove</i> &#x2014; material icon named "person remove" (round).
  static const IconData person_remove_rounded = IconData(0xf0070, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">person_remove</i> &#x2014; material icon named "person remove" (outlined).
  static const IconData person_remove_outlined = IconData(0xf27f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">person_remove_alt_1</i> &#x2014; material icon named "person remove alt 1".
  static const IconData person_remove_alt_1 = IconData(0xe49b, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">person_remove_alt_1</i> &#x2014; material icon named "person remove alt 1" (sharp).
  static const IconData person_remove_alt_1_sharp = IconData(0xeb90, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">person_remove_alt_1</i> &#x2014; material icon named "person remove alt 1" (round).
  static const IconData person_remove_alt_1_rounded = IconData(0xf006f, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-outlined md-36">person_remove_alt_1</i> &#x2014; material icon named "person remove alt 1" (outlined).
  static const IconData person_remove_alt_1_outlined = IconData(0xf27e, fontFamily: 'MaterialIcons');

  /// <i class="material-icons md-36">person_search</i> &#x2014; material icon named "person search".
  static const IconData person_search = IconData(0xe49c, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-sharp md-36">person_search</i> &#x2014; material icon named "person search" (sharp).
  static const IconData person_search_sharp = IconData(0xeb92, fontFamily: 'MaterialIcons');

  /// <i class="material-icons-round md-36">p