// Copyright (c) 2021, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'dart:async';
import 'dart:io';

import 'package:dds/dds.dart';
import 'package:test/test.dart';
import 'package:vm_service/vm_service.dart';
import 'package:vm_service/vm_service_io.dart';
import 'common/test_helper.dart';

void main() {
  late Process process;
  DartDevelopmentService? dds;

  setUp(() async {
    process = await spawnDartProcess(
      'get_cached_cpu_samples_script.dart',
      disableServiceAuthCodes: true,
    );
  });

  tearDown(() async {
    await dds?.shutdown();
    process.kill();
  });

  test(
    'DDS returns local paths with a converter',
    () async {
      Uri serviceUri = remoteVmServiceUri;
      dds = await DartDevelopmentService.startDartDevelopmentService(
        remoteVmServiceUri,
        logRequests: true,
      );
      serviceUri = dds!.wsUri!;
      expect(dds!.isRunning, true);
      final service = await vmServiceConnectUri(serviceUri.toString());

      var result = await service.callMethod('startDebugAdapter');
      print(result);
    },
    timeout: Timeout.none,
  );
}
