/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.editing;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.graphics.Insets;
import android.view.View;
import android.view.WindowInsets;
import android.view.WindowInsetsAnimation;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import java.util.List;

@VisibleForTesting(otherwise=3)
@TargetApi(value=30)
@RequiresApi(value=30)
@SuppressLint(value={"NewApi", "Override"})
@Keep
class ImeSyncDeferringInsetsCallback {
    private final int deferredInsetTypes = WindowInsets.Type.ime();
    private View view;
    private WindowInsets lastWindowInsets;
    private AnimationCallback animationCallback;
    private InsetsListener insetsListener;
    private ImeVisibleListener imeVisibleListener;
    private boolean animating = false;
    private boolean needsSave = false;

    ImeSyncDeferringInsetsCallback(@NonNull View view) {
        this.view = view;
        this.animationCallback = new AnimationCallback();
        this.insetsListener = new InsetsListener();
    }

    void install() {
        this.view.setWindowInsetsAnimationCallback((WindowInsetsAnimation.Callback)this.animationCallback);
        this.view.setOnApplyWindowInsetsListener((View.OnApplyWindowInsetsListener)this.insetsListener);
    }

    void remove() {
        this.view.setWindowInsetsAnimationCallback(null);
        this.view.setOnApplyWindowInsetsListener(null);
    }

    void setImeVisibleListener(ImeVisibleListener imeVisibleListener) {
        this.imeVisibleListener = imeVisibleListener;
    }

    @VisibleForTesting
    View.OnApplyWindowInsetsListener getInsetsListener() {
        return this.insetsListener;
    }

    @VisibleForTesting
    WindowInsetsAnimation.Callback getAnimationCallback() {
        return this.animationCallback;
    }

    @VisibleForTesting
    ImeVisibleListener getImeVisibleListener() {
        return this.imeVisibleListener;
    }

    public static interface ImeVisibleListener {
        public void onImeVisibleChanged(boolean var1);
    }

    private class InsetsListener
    implements View.OnApplyWindowInsetsListener {
        private InsetsListener() {
        }

        public WindowInsets onApplyWindowInsets(View view, WindowInsets windowInsets) {
            ImeSyncDeferringInsetsCallback.this.view = view;
            if (ImeSyncDeferringInsetsCallback.this.needsSave) {
                ImeSyncDeferringInsetsCallback.this.lastWindowInsets = windowInsets;
                ImeSyncDeferringInsetsCallback.this.needsSave = false;
            }
            if (ImeSyncDeferringInsetsCallback.this.animating) {
                return WindowInsets.CONSUMED;
            }
            return view.onApplyWindowInsets(windowInsets);
        }
    }

    @Keep
    private class AnimationCallback
    extends WindowInsetsAnimation.Callback {
        AnimationCallback() {
            super(1);
        }

        public void onPrepare(WindowInsetsAnimation animation) {
            if ((animation.getTypeMask() & ImeSyncDeferringInsetsCallback.this.deferredInsetTypes) != 0) {
                ImeSyncDeferringInsetsCallback.this.animating = true;
                ImeSyncDeferringInsetsCallback.this.needsSave = true;
            }
        }

        @NonNull
        public WindowInsetsAnimation.Bounds onStart(@NonNull WindowInsetsAnimation animation, @NonNull WindowInsetsAnimation.Bounds bounds) {
            WindowInsetsCompat insets = ViewCompat.getRootWindowInsets((View)ImeSyncDeferringInsetsCallback.this.view);
            if (insets != null && ImeSyncDeferringInsetsCallback.this.imeVisibleListener != null) {
                boolean imeVisible = insets.isVisible(WindowInsetsCompat.Type.ime());
                ImeSyncDeferringInsetsCallback.this.imeVisibleListener.onImeVisibleChanged(imeVisible);
            }
            return super.onStart(animation, bounds);
        }

        public WindowInsets onProgress(WindowInsets insets, List<WindowInsetsAnimation> runningAnimations) {
            if (!ImeSyncDeferringInsetsCallback.this.animating || ImeSyncDeferringInsetsCallback.this.needsSave) {
                return insets;
            }
            boolean matching = false;
            for (WindowInsetsAnimation animation : runningAnimations) {
                if ((animation.getTypeMask() & ImeSyncDeferringInsetsCallback.this.deferredInsetTypes) == 0) continue;
                matching = true;
            }
            if (!matching) {
                return insets;
            }
            int excludedInsets = 0;
            int systemUiFlags = ImeSyncDeferringInsetsCallback.this.view.getWindowSystemUiVisibility();
            if ((systemUiFlags & 0x200) == 0 && (systemUiFlags & 2) == 0) {
                excludedInsets = insets.getInsets((int)WindowInsets.Type.navigationBars()).bottom;
            }
            WindowInsets.Builder builder = new WindowInsets.Builder(ImeSyncDeferringInsetsCallback.this.lastWindowInsets);
            Insets newImeInsets = Insets.of((int)0, (int)0, (int)0, (int)Math.max(insets.getInsets((int)((ImeSyncDeferringInsetsCallback)ImeSyncDeferringInsetsCallback.this).deferredInsetTypes).bottom - excludedInsets, 0));
            builder.setInsets(ImeSyncDeferringInsetsCallback.this.deferredInsetTypes, newImeInsets);
            ImeSyncDeferringInsetsCallback.this.view.onApplyWindowInsets(builder.build());
            return insets;
        }

        public void onEnd(WindowInsetsAnimation animation) {
            if (ImeSyncDeferringInsetsCallback.this.animating && (animation.getTypeMask() & ImeSyncDeferringInsetsCallback.this.deferredInsetTypes) != 0) {
                ImeSyncDeferringInsetsCallback.this.animating = false;
                if (ImeSyncDeferringInsetsCallback.this.lastWindowInsets != null && ImeSyncDeferringInsetsCallback.this.view != null) {
                    ImeSyncDeferringInsetsCallback.this.view.dispatchApplyWindowInsets(ImeSyncDeferringInsetsCallback.this.lastWindowInsets);
                }
            }
        }
    }
}

