/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.platform;

import android.annotation.TargetApi;
import android.graphics.Canvas;
import android.media.Image;
import android.media.ImageReader;
import android.os.Build;
import android.os.Handler;
import android.view.Surface;
import io.flutter.plugin.platform.PlatformViewRenderTarget;
import io.flutter.view.TextureRegistry;

@TargetApi(value=26)
public class ImageReaderPlatformViewRenderTarget
implements PlatformViewRenderTarget {
    private TextureRegistry.ImageTextureEntry textureEntry;
    private boolean mustRecreateImageReader = false;
    private ImageReader reader;
    private int bufferWidth = 0;
    private int bufferHeight = 0;
    private static final String TAG = "ImageReaderPlatformViewRenderTarget";
    private final Handler onImageAvailableHandler = new Handler();
    private final ImageReader.OnImageAvailableListener onImageAvailableListener = new ImageReader.OnImageAvailableListener(){

        public void onImageAvailable(ImageReader reader) {
            Image image = reader.acquireLatestImage();
            if (image == null) {
                return;
            }
            ImageReaderPlatformViewRenderTarget.this.textureEntry.pushImage(image);
        }
    };

    private void closeReader() {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    private void recreateImageReaderIfNeeded() {
        if (!this.mustRecreateImageReader) {
            return;
        }
        this.mustRecreateImageReader = false;
        this.closeReader();
        this.reader = this.createImageReader();
    }

    @TargetApi(value=33)
    protected ImageReader createImageReader33() {
        ImageReader.Builder builder = new ImageReader.Builder(this.bufferWidth, this.bufferHeight);
        builder.setMaxImages(2);
        builder.setDefaultHardwareBufferFormat(1);
        builder.setUsage(256L);
        ImageReader reader = builder.build();
        reader.setOnImageAvailableListener(this.onImageAvailableListener, this.onImageAvailableHandler);
        return reader;
    }

    @TargetApi(value=29)
    protected ImageReader createImageReader29() {
        return ImageReader.newInstance((int)this.bufferWidth, (int)this.bufferHeight, (int)0, (int)2, (long)256L);
    }

    @TargetApi(value=26)
    protected ImageReader createImageReader26() {
        return ImageReader.newInstance((int)this.bufferWidth, (int)this.bufferHeight, (int)0, (int)2);
    }

    protected ImageReader createImageReader() {
        if (Build.VERSION.SDK_INT >= 33) {
            return this.createImageReader33();
        }
        if (Build.VERSION.SDK_INT >= 29) {
            return this.createImageReader29();
        }
        return this.createImageReader26();
    }

    public ImageReaderPlatformViewRenderTarget(TextureRegistry.ImageTextureEntry textureEntry) {
        if (Build.VERSION.SDK_INT < 26) {
            throw new UnsupportedOperationException("ImageReaderPlatformViewRenderTarget requires API version 26+");
        }
        this.textureEntry = textureEntry;
    }

    @Override
    public void resize(int width, int height) {
        if (this.reader != null && this.bufferWidth == width && this.bufferHeight == height) {
            return;
        }
        this.closeReader();
        this.bufferWidth = width;
        this.bufferHeight = height;
        this.reader = this.createImageReader();
    }

    @Override
    public int getWidth() {
        return this.bufferWidth;
    }

    @Override
    public int getHeight() {
        return this.bufferHeight;
    }

    @Override
    public Canvas lockHardwareCanvas() {
        return this.getSurface().lockHardwareCanvas();
    }

    @Override
    public void unlockCanvasAndPost(Canvas canvas) {
        this.getSurface().unlockCanvasAndPost(canvas);
    }

    @Override
    public long getId() {
        return this.textureEntry.id();
    }

    @Override
    public void release() {
        this.textureEntry = null;
        this.closeReader();
    }

    @Override
    public boolean isReleased() {
        return this.textureEntry == null;
    }

    @Override
    public Surface getSurface() {
        this.recreateImageReaderIfNeeded();
        return this.reader.getSurface();
    }
}

