// Copyright 2014 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'package:flutter/material.dart';
import 'package:flutter_api_samples/material/dropdown_menu/dropdown_menu.0.dart' as example;
import 'package:flutter_test/flutter_test.dart';

void main() {
  testWidgets('DropdownMenu', (WidgetTester tester) async {
    await tester.pumpWidget(
      const example.DropdownMenuExample(),
    );

    expect(find.text('You selected a Blue Smile'), findsNothing);

    final Finder colorMenu = find.byType(DropdownMenu<example.ColorLabel>);
    final Finder iconMenu = find.byType(DropdownMenu<example.IconLabel>);
    expect(colorMenu, findsOneWidget);
    expect(iconMenu, findsOneWidget);

    Finder findMenuItem(String label) {
      return find.widgetWithText(MenuItemButton, label).last;
    }

    await tester.tap(colorMenu);
    await tester.pumpAndSettle();
    expect(findMenuItem('Blue'), findsOneWidget);
    expect(findMenuItem('Pink'), findsOneWidget);
    expect(findMenuItem('Green'), findsOneWidget);
    expect(findMenuItem('Orange'), findsOneWidget);
    expect(findMenuItem('Grey'), findsOneWidget);

    await tester.tap(findMenuItem('Blue'));

    // The DropdownMenu's onSelected callback is delayed
    // with SchedulerBinding.instance.addPostFrameCallback
    // to give the focus a chance to return to where it was
    // before the menu appeared. The pumpAndSettle()
    // give the callback a chance to run.
    await tester.pumpAndSettle();

    await tester.tap(iconMenu);
    await tester.pumpAndSettle();
    expect(findMenuItem('Smile'), findsOneWidget);
    expect(findMenuItem('Cloud'), findsOneWidget);
    expect(findMenuItem('Brush'), findsOneWidget);
    expect(findMenuItem('Heart'), findsOneWidget);

    await tester.tap(findMenuItem('Smile'));
    await tester.pumpAndSettle();

    expect(find.text('You selected a Blue Smile'), findsOneWidget);
  });
}
