/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.text;

import android.annotation.TargetApi;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.embedding.engine.plugins.activity.ActivityAware;
import io.flutter.embedding.engine.plugins.activity.ActivityPluginBinding;
import io.flutter.embedding.engine.systemchannels.ProcessTextChannel;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.PluginRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProcessTextPlugin
implements FlutterPlugin,
ActivityAware,
PluginRegistry.ActivityResultListener,
ProcessTextChannel.ProcessTextMethodHandler {
    private static final String TAG = "ProcessTextPlugin";
    @NonNull
    private final ProcessTextChannel processTextChannel;
    @NonNull
    private final PackageManager packageManager;
    @Nullable
    private ActivityPluginBinding activityBinding;
    private Map<String, ResolveInfo> resolveInfosById;
    @NonNull
    private Map<Integer, MethodChannel.Result> requestsByCode = new HashMap<Integer, MethodChannel.Result>();

    public ProcessTextPlugin(@NonNull ProcessTextChannel processTextChannel) {
        this.processTextChannel = processTextChannel;
        this.packageManager = processTextChannel.packageManager;
        processTextChannel.setMethodHandler(this);
    }

    @Override
    public Map<String, String> queryTextActions() {
        if (this.resolveInfosById == null) {
            this.cacheResolveInfos();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String id2 : this.resolveInfosById.keySet()) {
            ResolveInfo info = this.resolveInfosById.get(id2);
            result.put(id2, info.loadLabel(this.packageManager).toString());
        }
        return result;
    }

    @Override
    public void processTextAction(@NonNull String id2, @NonNull String text, @NonNull boolean readOnly, @NonNull MethodChannel.Result result) {
        if (this.activityBinding == null) {
            result.error("error", "Plugin not bound to an Activity", null);
            return;
        }
        if (Build.VERSION.SDK_INT < 23) {
            result.error("error", "Android version not supported", null);
            return;
        }
        if (this.resolveInfosById == null) {
            result.error("error", "Can not process text actions before calling queryTextActions", null);
            return;
        }
        ResolveInfo info = this.resolveInfosById.get(id2);
        if (info == null) {
            result.error("error", "Text processing activity not found", null);
            return;
        }
        Integer requestCode = result.hashCode();
        this.requestsByCode.put(requestCode, result);
        Intent intent = new Intent();
        intent.setClassName(info.activityInfo.packageName, info.activityInfo.name);
        intent.setAction("android.intent.action.PROCESS_TEXT");
        intent.setType("text/plain");
        intent.putExtra("android.intent.extra.PROCESS_TEXT", text);
        intent.putExtra("android.intent.extra.PROCESS_TEXT_READONLY", readOnly);
        this.activityBinding.getActivity().startActivityForResult(intent, requestCode.intValue());
    }

    private void cacheResolveInfos() {
        this.resolveInfosById = new HashMap<String, ResolveInfo>();
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        Intent intent = new Intent().setAction("android.intent.action.PROCESS_TEXT").setType("text/plain");
        List infos = Build.VERSION.SDK_INT >= 33 ? this.packageManager.queryIntentActivities(intent, PackageManager.ResolveInfoFlags.of((long)0L)) : this.packageManager.queryIntentActivities(intent, 0);
        for (ResolveInfo info : infos) {
            String id2 = info.activityInfo.name;
            String label = info.loadLabel(this.packageManager).toString();
            this.resolveInfosById.put(id2, info);
        }
    }

    @Override
    @TargetApi(value=23)
    @RequiresApi(value=23)
    public boolean onActivityResult(int requestCode, int resultCode, @Nullable Intent intent) {
        if (!this.requestsByCode.containsKey(requestCode)) {
            return false;
        }
        String result = null;
        if (resultCode == -1) {
            result = intent.getStringExtra("android.intent.extra.PROCESS_TEXT");
        }
        this.requestsByCode.remove(requestCode).success(result);
        return true;
    }

    public void destroy() {
        this.processTextChannel.setMethodHandler(null);
    }

    @Override
    public void onAttachedToEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
    }

    @Override
    public void onDetachedFromEngine(@NonNull FlutterPlugin.FlutterPluginBinding binding) {
    }

    @Override
    public void onAttachedToActivity(@NonNull ActivityPluginBinding binding) {
        this.activityBinding = binding;
        this.activityBinding.addActivityResultListener(this);
    }

    @Override
    public void onDetachedFromActivityForConfigChanges() {
        this.activityBinding.removeActivityResultListener(this);
        this.activityBinding = null;
    }

    @Override
    public void onReattachedToActivityForConfigChanges(@NonNull ActivityPluginBinding binding) {
        this.activityBinding = binding;
        this.activityBinding.addActivityResultListener(this);
    }

    @Override
    public void onDetachedFromActivity() {
        this.activityBinding.removeActivityResultListener(this);
        this.activityBinding = null;
    }
}

