/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.loader;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.FlutterInjector;
import io.flutter.Log;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.loader.ApplicationInfoLoader;
import io.flutter.embedding.engine.loader.FlutterApplicationInfo;
import io.flutter.embedding.engine.loader.ResourceExtractor;
import io.flutter.util.HandlerCompat;
import io.flutter.util.PathUtils;
import io.flutter.util.TraceSection;
import io.flutter.view.VsyncWaiter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class FlutterLoader {
    private static final String TAG = "FlutterLoader";
    private static final String OLD_GEN_HEAP_SIZE_META_DATA_KEY = "io.flutter.embedding.android.OldGenHeapSize";
    private static final String ENABLE_IMPELLER_META_DATA_KEY = "io.flutter.embedding.android.EnableImpeller";
    private static final String ENABLE_VULKAN_VALIDATION_META_DATA_KEY = "io.flutter.embedding.android.EnableVulkanValidation";
    private static final String IMPELLER_BACKEND_META_DATA_KEY = "io.flutter.embedding.android.ImpellerBackend";
    private static final String IMPELLER_OPENGL_GPU_TRACING_DATA_KEY = "io.flutter.embedding.android.EnableOpenGLGPUTracing";
    private static final String DISABLE_IMAGE_READER_PLATFORM_VIEWS_KEY = "io.flutter.embedding.android.DisableImageReaderPlatformViews";
    private static final String LEAK_VM_META_DATA_KEY = "io.flutter.embedding.android.LeakVM";
    static final String AOT_SHARED_LIBRARY_NAME = "aot-shared-library-name";
    static final String AOT_VMSERVICE_SHARED_LIBRARY_NAME = "aot-vmservice-shared-library-name";
    static final String SNAPSHOT_ASSET_PATH_KEY = "snapshot-asset-path";
    static final String VM_SNAPSHOT_DATA_KEY = "vm-snapshot-data";
    static final String ISOLATE_SNAPSHOT_DATA_KEY = "isolate-snapshot-data";
    static final String FLUTTER_ASSETS_DIR_KEY = "flutter-assets-dir";
    static final String AUTOMATICALLY_REGISTER_PLUGINS_KEY = "automatically-register-plugins";
    private static final String DEFAULT_LIBRARY = "libflutter.so";
    private static final String DEFAULT_KERNEL_BLOB = "kernel_blob.bin";
    private static final String VMSERVICE_SNAPSHOT_LIBRARY = "libvmservice_snapshot.so";
    private static FlutterLoader instance;
    private boolean initialized = false;
    @Nullable
    private Settings settings;
    private long initStartTimestampMillis;
    private FlutterApplicationInfo flutterApplicationInfo;
    private FlutterJNI flutterJNI;
    private ExecutorService executorService;
    @Nullable
    Future<InitResult> initResultFuture;

    public FlutterLoader() {
        this(FlutterInjector.instance().getFlutterJNIFactory().provideFlutterJNI());
    }

    public FlutterLoader(@NonNull FlutterJNI flutterJNI) {
        this(flutterJNI, FlutterInjector.instance().executorService());
    }

    public FlutterLoader(@NonNull FlutterJNI flutterJNI, @NonNull ExecutorService executorService) {
        this.flutterJNI = flutterJNI;
        this.executorService = executorService;
    }

    public void startInitialization(@NonNull Context applicationContext) {
        this.startInitialization(applicationContext, new Settings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startInitialization(@NonNull Context applicationContext, @NonNull Settings settings) {
        if (this.settings != null) {
            return;
        }
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("startInitialization must be called on the main thread");
        }
        TraceSection.begin("FlutterLoader#startInitialization");
        try {
            VsyncWaiter waiter;
            final Context appContext = applicationContext.getApplicationContext();
            this.settings = settings;
            this.initStartTimestampMillis = SystemClock.uptimeMillis();
            this.flutterApplicationInfo = ApplicationInfoLoader.load(appContext);
            if (Build.VERSION.SDK_INT >= 17) {
                DisplayManager dm = (DisplayManager)appContext.getSystemService("display");
                waiter = VsyncWaiter.getInstance(dm, this.flutterJNI);
            } else {
                float fps = ((WindowManager)appContext.getSystemService("window")).getDefaultDisplay().getRefreshRate();
                waiter = VsyncWaiter.getInstance(fps, this.flutterJNI);
            }
            waiter.init();
            Callable<InitResult> initTask = new Callable<InitResult>(){

                @Override
                public InitResult call() {
                    TraceSection.begin("FlutterLoader initTask");
                    try {
                        ResourceExtractor resourceExtractor = FlutterLoader.this.initResources(appContext);
                        FlutterLoader.this.flutterJNI.loadLibrary();
                        FlutterLoader.this.flutterJNI.updateRefreshRate();
                        FlutterLoader.this.executorService.execute(() -> FlutterLoader.this.flutterJNI.prefetchDefaultFontManager());
                        if (resourceExtractor != null) {
                            resourceExtractor.waitForCompletion();
                        }
                        InitResult initResult = new InitResult(PathUtils.getFilesDir(appContext), PathUtils.getCacheDirectory(appContext), PathUtils.getDataDirectory(appContext));
                        return initResult;
                    }
                    finally {
                        TraceSection.end();
                    }
                }
            };
            this.initResultFuture = this.executorService.submit(initTask);
        }
        finally {
            TraceSection.end();
        }
    }

    private static boolean areValidationLayersOnByDefault() {
        return false;
    }

    public void ensureInitializationComplete(@NonNull Context applicationContext, @Nullable String[] args) {
        if (this.initialized) {
            return;
        }
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("ensureInitializationComplete must be called on the main thread");
        }
        if (this.settings == null) {
            throw new IllegalStateException("ensureInitializationComplete must be called after startInitialization");
        }
        TraceSection.begin("FlutterLoader#ensureInitializationComplete");
        try {
            int oldGenHeapSizeMegaBytes;
            InitResult result = this.initResultFuture.get();
            ArrayList<String> shellArgs = new ArrayList<String>();
            shellArgs.add("--icu-symbol-prefix=_binary_icudtl_dat");
            shellArgs.add("--icu-native-lib-path=" + this.flutterApplicationInfo.nativeLibraryDir + File.separator + DEFAULT_LIBRARY);
            if (args != null) {
                Collections.addAll(shellArgs, args);
            }
            String kernelPath = null;
            shellArgs.add("--aot-shared-library-name=" + this.flutterApplicationInfo.aotSharedLibraryName);
            shellArgs.add("--aot-shared-library-name=" + this.flutterApplicationInfo.nativeLibraryDir + File.separator + this.flutterApplicationInfo.aotSharedLibraryName);
            shellArgs.add("--aot-vmservice-shared-library-name=libvmservice_snapshot.so");
            shellArgs.add("--cache-dir-path=" + result.engineCachesPath);
            if (this.flutterApplicationInfo.domainNetworkPolicy != null) {
                shellArgs.add("--domain-network-policy=" + this.flutterApplicationInfo.domainNetworkPolicy);
            }
            if (this.settings.getLogTag() != null) {
                shellArgs.add("--log-tag=" + this.settings.getLogTag());
            }
            ApplicationInfo applicationInfo = applicationContext.getPackageManager().getApplicationInfo(applicationContext.getPackageName(), 128);
            Bundle metaData = applicationInfo.metaData;
            int n = oldGenHeapSizeMegaBytes = metaData != null ? metaData.getInt(OLD_GEN_HEAP_SIZE_META_DATA_KEY) : 0;
            if (oldGenHeapSizeMegaBytes == 0) {
                ActivityManager activityManager = (ActivityManager)applicationContext.getSystemService("activity");
                ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
                activityManager.getMemoryInfo(memInfo);
                oldGenHeapSizeMegaBytes = (int)((double)memInfo.totalMem / 1000000.0 / 2.0);
            }
            shellArgs.add("--old-gen-heap-size=" + oldGenHeapSizeMegaBytes);
            DisplayMetrics displayMetrics = applicationContext.getResources().getDisplayMetrics();
            int screenWidth = displayMetrics.widthPixels;
            int screenHeight = displayMetrics.heightPixels;
            int resourceCacheMaxBytesThreshold = screenWidth * screenHeight * 12 * 4;
            shellArgs.add("--resource-cache-max-bytes-threshold=" + resourceCacheMaxBytesThreshold);
            shellArgs.add("--prefetched-default-font-manager");
            if (metaData != null) {
                String backend;
                if (metaData.getBoolean(ENABLE_IMPELLER_META_DATA_KEY, false)) {
                    shellArgs.add("--enable-impeller");
                }
                if (metaData.getBoolean(DISABLE_IMAGE_READER_PLATFORM_VIEWS_KEY, false)) {
                    shellArgs.add("--disable-image-reader-platform-views");
                }
                if (metaData.getBoolean(ENABLE_VULKAN_VALIDATION_META_DATA_KEY, FlutterLoader.areValidationLayersOnByDefault())) {
                    shellArgs.add("--enable-vulkan-validation");
                }
                if (metaData.getBoolean(IMPELLER_OPENGL_GPU_TRACING_DATA_KEY, false)) {
                    shellArgs.add("--enable-opengl-gpu-tracing");
                }
                if ((backend = metaData.getString(IMPELLER_BACKEND_META_DATA_KEY)) != null) {
                    shellArgs.add("--impeller-backend=" + backend);
                }
            }
            String leakVM = FlutterLoader.isLeakVM(metaData) ? "true" : "false";
            shellArgs.add("--leak-vm=" + leakVM);
            long initTimeMillis = SystemClock.uptimeMillis() - this.initStartTimestampMillis;
            this.flutterJNI.init(applicationContext, shellArgs.toArray(new String[0]), kernelPath, result.appStoragePath, result.engineCachesPath, initTimeMillis);
            this.initialized = true;
        }
        catch (Exception e) {
            Log.e(TAG, "Flutter initialization failed.", e);
            throw new RuntimeException(e);
        }
        finally {
            TraceSection.end();
        }
    }

    private static boolean isLeakVM(@Nullable Bundle metaData) {
        boolean leakVMDefaultValue = true;
        if (metaData == null) {
            return true;
        }
        return metaData.getBoolean(LEAK_VM_META_DATA_KEY, true);
    }

    public void ensureInitializationCompleteAsync(@NonNull Context applicationContext, @Nullable String[] args, @NonNull Handler callbackHandler, @NonNull Runnable callback) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("ensureInitializationComplete must be called on the main thread");
        }
        if (this.settings == null) {
            throw new IllegalStateException("ensureInitializationComplete must be called after startInitialization");
        }
        if (this.initialized) {
            callbackHandler.post(callback);
            return;
        }
        this.executorService.execute(() -> {
            try {
                InitResult result = this.initResultFuture.get();
            }
            catch (Exception e) {
                Log.e(TAG, "Flutter initialization failed.", e);
                throw new RuntimeException(e);
            }
            HandlerCompat.createAsyncHandler(Looper.getMainLooper()).post(() -> {
                this.ensureInitializationComplete(applicationContext.getApplicationContext(), args);
                callbackHandler.post(callback);
            });
        });
    }

    public boolean initialized() {
        return this.initialized;
    }

    private ResourceExtractor initResources(@NonNull Context applicationContext) {
        ResourceExtractor resourceExtractor = null;
        return resourceExtractor;
    }

    @NonNull
    public String findAppBundlePath() {
        return this.flutterApplicationInfo.flutterAssetsDir;
    }

    @NonNull
    public String getLookupKeyForAsset(@NonNull String asset) {
        return this.fullAssetPathFrom(asset);
    }

    @NonNull
    public String getLookupKeyForAsset(@NonNull String asset, @NonNull String packageName) {
        return this.getLookupKeyForAsset("packages" + File.separator + packageName + File.separator + asset);
    }

    @NonNull
    public boolean automaticallyRegisterPlugins() {
        return this.flutterApplicationInfo.automaticallyRegisterPlugins;
    }

    @NonNull
    private String fullAssetPathFrom(@NonNull String filePath) {
        return this.flutterApplicationInfo.flutterAssetsDir + File.separator + filePath;
    }

    public static class Settings {
        private String logTag;

        @Nullable
        public String getLogTag() {
            return this.logTag;
        }

        public void setLogTag(String tag) {
            this.logTag = tag;
        }
    }

    private static class InitResult {
        final String appStoragePath;
        final String engineCachesPath;
        final String dataDirPath;

        private InitResult(String appStoragePath, String engineCachesPath, String dataDirPath) {
            this.appStoragePath = appStoragePath;
            this.engineCachesPath = engineCachesPath;
            this.dataDirPath = dataDirPath;
        }
    }
}

