// Copyright (c) 2022, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

/// Result of [identityHashCode].
typedef IdentityHashCode = int;

/// Finilizer builder to mock standard [identityHashCode].
typedef IdentityHashCoder = IdentityHashCode Function(Object object);

int standardIdentityHashCoder(Object object) => identityHashCode(object);

/// Fragment to detect leak tracker invocation in callstack.
const leakTrackerStackTraceFragment = '(package:leak_tracker/';

String fullClassName({
  required String library,
  required String shortClassName,
}) =>
    '$library/$shortClassName';

class ObjectRef<T> {
  ObjectRef(this.value);
  T value;
}

final leakTrackerYamlHeader = '''
# The text is generated by leak_tracker.
# For leak troubleshooting tips open:
# ${Links.gitHubTroubleshooting.value}
''';

/// Some links used in the package.
///
/// The enum is test covered to catch broken links.
enum Links {
  gitHubTroubleshooting(
    'https://github.com/dart-lang/leak_tracker/blob/main/doc/TROUBLESHOOT.md',
    null,
  ),
  ;

  const Links(this.url, this.hash);

  final String url;
  final String? hash;
  String get value {
    if (hash == null) return url;
    return '$url#$hash';
  }
}
