/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.util;

import android.annotation.TargetApi;
import androidx.annotation.NonNull;
import androidx.tracing.Trace;

@TargetApi(value=19)
public final class TraceSection
implements AutoCloseable {
    public static TraceSection scoped(String name) {
        return new TraceSection(name);
    }

    private TraceSection(String name) {
        TraceSection.begin(name);
    }

    @Override
    public void close() {
        TraceSection.end();
    }

    private static String cropSectionName(@NonNull String sectionName) {
        return sectionName.length() < 124 ? sectionName : sectionName.substring(0, 124) + "...";
    }

    public static void begin(@NonNull String sectionName) {
        Trace.beginSection((String)TraceSection.cropSectionName(sectionName));
    }

    public static void end() throws RuntimeException {
        Trace.endSection();
    }

    public static void beginAsyncSection(String sectionName, int cookie) {
        Trace.beginAsyncSection((String)TraceSection.cropSectionName(sectionName), (int)cookie);
    }

    public static void endAsyncSection(String sectionName, int cookie) {
        Trace.endAsyncSection((String)TraceSection.cropSectionName(sectionName), (int)cookie);
    }
}

