/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import android.graphics.SurfaceTexture;
import android.media.Image;
import android.view.Surface;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public interface TextureRegistry {
    @NonNull
    public SurfaceProducer createSurfaceProducer();

    @NonNull
    public SurfaceTextureEntry createSurfaceTexture();

    @NonNull
    public SurfaceTextureEntry registerSurfaceTexture(@NonNull SurfaceTexture var1);

    @NonNull
    public ImageTextureEntry createImageTexture();

    default public void onTrimMemory(int level) {
    }

    @Keep
    public static interface GLTextureConsumer
    extends TextureEntry {
        @NonNull
        public SurfaceTexture getSurfaceTexture();
    }

    @Keep
    public static interface ImageConsumer
    extends TextureEntry {
        @Nullable
        public Image acquireLatestImage();
    }

    public static interface OnTrimMemoryListener {
        public void onTrimMemory(int var1);
    }

    public static interface OnFrameConsumedListener {
        public void onFrameConsumed();
    }

    @Keep
    public static interface ImageTextureEntry
    extends TextureEntry {
        @Override
        public long id();

        @Override
        public void release();

        public void pushImage(Image var1);
    }

    @Keep
    public static interface SurfaceTextureEntry
    extends TextureEntry {
        @Override
        public long id();

        @Override
        public void release();

        @NonNull
        public SurfaceTexture surfaceTexture();

        default public void setOnFrameConsumedListener(@Nullable OnFrameConsumedListener listener) {
        }

        default public void setOnTrimMemoryListener(@Nullable OnTrimMemoryListener listener) {
        }
    }

    @Keep
    public static interface SurfaceProducer
    extends TextureEntry {
        @Override
        public long id();

        @Override
        public void release();

        public void setSize(int var1, int var2);

        public int getWidth();

        public int getHeight();

        public Surface getSurface();

        public void scheduleFrame();
    }

    public static interface TextureEntry {
        public long id();

        public void release();
    }
}

