/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.renderer;

import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.renderer.FlutterRenderer;
import io.flutter.view.TextureRegistry;

final class SurfaceTextureSurfaceProducer
implements TextureRegistry.SurfaceProducer,
TextureRegistry.GLTextureConsumer {
    private final long id;
    private int requestBufferWidth;
    private int requestedBufferHeight;
    private boolean released;
    @Nullable
    private Surface surface;
    @NonNull
    private final SurfaceTexture texture;
    @NonNull
    private final Handler handler;
    @NonNull
    private final FlutterJNI flutterJNI;

    SurfaceTextureSurfaceProducer(long id, @NonNull Handler handler, @NonNull FlutterJNI flutterJNI) {
        this.id = id;
        this.handler = handler;
        this.flutterJNI = flutterJNI;
        this.texture = new SurfaceTexture(0);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.released) {
                return;
            }
            this.release();
            this.handler.post((Runnable)new FlutterRenderer.TextureFinalizerRunnable(this.id, this.flutterJNI));
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public void release() {
        this.texture.release();
        this.released = true;
    }

    @Override
    @NonNull
    public SurfaceTexture getSurfaceTexture() {
        return this.texture;
    }

    @Override
    public void setSize(int width, int height) {
        this.requestBufferWidth = width;
        this.requestedBufferHeight = height;
        this.getSurfaceTexture().setDefaultBufferSize(width, height);
    }

    @Override
    public int getWidth() {
        return this.requestBufferWidth;
    }

    @Override
    public int getHeight() {
        return this.requestedBufferHeight;
    }

    @Override
    public Surface getSurface() {
        if (this.surface == null) {
            this.surface = new Surface(this.texture);
        }
        return this.surface;
    }

    @Override
    public void scheduleFrame() {
        this.flutterJNI.markTextureFrameAvailable(this.id);
    }
}

