// Copyright (c) 2023, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart <test.dart>
//
const LINE_A = 19;
// AUTOGENERATED END

const file = 'step_through_function_expression_test.dart';

int codeXYZ(int i) /* LINE_A */ {
  int innerOne() {
    return i * i;
  }

  return innerOne();
}

void code() {
  codeXYZ(42);
}

final stops = <String>[];
const expected = <String>[
  '$file:${LINE_A + 0}:17', // on 'i' in 'codeXYZ(int i)'
  '$file:${LINE_A + 1}:3', // on 'int'
  '$file:${LINE_A + 5}:10', // on 'innerOne()' call
  '$file:${LINE_A + 5}:3', // on 'return'
];

final tests = <IsolateTest>[
  hasPausedAtStart,
  setBreakpointAtLine(LINE_A),
  runStepThroughProgramRecordingStops(stops),
  checkRecordedStops(stops, expected),
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'step_through_function_expression_test.dart',
      testeeConcurrent: code,
      pauseOnStart: true,
      pauseOnExit: true,
    );
