/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.editing;

import android.annotation.SuppressLint;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.text.Editable;
import android.util.SparseArray;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewStructure;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillManager;
import android.view.autofill.AutofillValue;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.view.inputmethod.EditorInfoCompat;
import io.flutter.Log;
import io.flutter.embedding.android.KeyboardManager;
import io.flutter.embedding.engine.systemchannels.TextInputChannel;
import io.flutter.plugin.editing.ImeSyncDeferringInsetsCallback;
import io.flutter.plugin.editing.InputConnectionAdaptor;
import io.flutter.plugin.editing.ListenableEditingState;
import io.flutter.plugin.editing.TextEditingDelta;
import io.flutter.plugin.platform.PlatformViewsController;
import java.util.ArrayList;
import java.util.HashMap;

public class TextInputPlugin
implements ListenableEditingState.EditingStateWatcher {
    private static final String TAG = "TextInputPlugin";
    @NonNull
    private final View mView;
    @NonNull
    private final InputMethodManager mImm;
    @NonNull
    private final AutofillManager afm;
    @NonNull
    private final TextInputChannel textInputChannel;
    @NonNull
    private InputTarget inputTarget = new InputTarget(InputTarget.Type.NO_TARGET, 0);
    @Nullable
    private TextInputChannel.Configuration configuration;
    @Nullable
    private SparseArray<TextInputChannel.Configuration> autofillConfiguration;
    @NonNull
    private ListenableEditingState mEditable;
    private boolean mRestartInputPending;
    @Nullable
    private InputConnection lastInputConnection;
    @NonNull
    private PlatformViewsController platformViewsController;
    @Nullable
    private Rect lastClientRect;
    private ImeSyncDeferringInsetsCallback imeSyncCallback;
    private TextInputChannel.TextEditState mLastKnownFrameworkTextEditingState;
    private boolean isInputConnectionLocked;

    @SuppressLint(value={"NewApi"})
    public TextInputPlugin(@NonNull View view, @NonNull TextInputChannel textInputChannel, @NonNull PlatformViewsController platformViewsController) {
        this.mView = view;
        this.mEditable = new ListenableEditingState(null, this.mView);
        this.mImm = (InputMethodManager)view.getContext().getSystemService("input_method");
        this.afm = Build.VERSION.SDK_INT >= 26 ? (AutofillManager)view.getContext().getSystemService(AutofillManager.class) : null;
        if (Build.VERSION.SDK_INT >= 30) {
            this.imeSyncCallback = new ImeSyncDeferringInsetsCallback(view);
            this.imeSyncCallback.install();
        }
        this.textInputChannel = textInputChannel;
        textInputChannel.setTextInputMethodHandler(new TextInputChannel.TextInputMethodHandler(){

            @Override
            public void show() {
                TextInputPlugin.this.showTextInput(TextInputPlugin.this.mView);
            }

            @Override
            public void hide() {
                if (((TextInputPlugin)TextInputPlugin.this).inputTarget.type == InputTarget.Type.PHYSICAL_DISPLAY_PLATFORM_VIEW) {
                    TextInputPlugin.this.notifyViewExited();
                } else {
                    TextInputPlugin.this.hideTextInput(TextInputPlugin.this.mView);
                }
            }

            @Override
            public void requestAutofill() {
                TextInputPlugin.this.notifyViewEntered();
            }

            @Override
            public void finishAutofillContext(boolean shouldSave) {
                if (Build.VERSION.SDK_INT < 26 || TextInputPlugin.this.afm == null) {
                    return;
                }
                if (shouldSave) {
                    TextInputPlugin.this.afm.commit();
                } else {
                    TextInputPlugin.this.afm.cancel();
                }
            }

            @Override
            public void setClient(int textInputClientId, TextInputChannel.Configuration configuration) {
                TextInputPlugin.this.setTextInputClient(textInputClientId, configuration);
            }

            @Override
            public void setPlatformViewClient(int platformViewId, boolean usesVirtualDisplay) {
                TextInputPlugin.this.setPlatformViewTextInputClient(platformViewId, usesVirtualDisplay);
            }

            @Override
            public void setEditingState(TextInputChannel.TextEditState editingState) {
                TextInputPlugin.this.setTextInputEditingState(TextInputPlugin.this.mView, editingState);
            }

            @Override
            public void setEditableSizeAndTransform(double width, double height, double[] transform) {
                TextInputPlugin.this.saveEditableSizeAndTransform(width, height, transform);
            }

            @Override
            public void clearClient() {
                TextInputPlugin.this.clearTextInputClient();
            }

            @Override
            public void sendAppPrivateCommand(String action, Bundle data) {
                TextInputPlugin.this.sendTextInputAppPrivateCommand(action, data);
            }
        });
        textInputChannel.requestExistingInputState();
        this.platformViewsController = platformViewsController;
        this.platformViewsController.attachTextInputPlugin(this);
    }

    @NonNull
    public InputMethodManager getInputMethodManager() {
        return this.mImm;
    }

    @VisibleForTesting
    Editable getEditable() {
        return this.mEditable;
    }

    @VisibleForTesting
    ImeSyncDeferringInsetsCallback getImeSyncCallback() {
        return this.imeSyncCallback;
    }

    public void lockPlatformViewInputConnection() {
        if (this.inputTarget.type == InputTarget.Type.VIRTUAL_DISPLAY_PLATFORM_VIEW) {
            this.isInputConnectionLocked = true;
        }
    }

    public void unlockPlatformViewInputConnection() {
        if (this.inputTarget.type == InputTarget.Type.VIRTUAL_DISPLAY_PLATFORM_VIEW) {
            this.isInputConnectionLocked = false;
        }
    }

    @SuppressLint(value={"NewApi"})
    public void destroy() {
        this.platformViewsController.detachTextInputPlugin();
        this.textInputChannel.setTextInputMethodHandler(null);
        this.notifyViewExited();
        this.mEditable.removeEditingStateListener(this);
        if (this.imeSyncCallback != null) {
            this.imeSyncCallback.remove();
        }
    }

    private static int inputTypeFromTextInputType(TextInputChannel.InputType type, boolean obscureText, boolean autocorrect, boolean enableSuggestions, boolean enableIMEPersonalizedLearning, TextInputChannel.TextCapitalization textCapitalization) {
        if (type.type == TextInputChannel.TextInputType.DATETIME) {
            return 4;
        }
        if (type.type == TextInputChannel.TextInputType.NUMBER) {
            int textType = 2;
            if (type.isSigned) {
                textType |= 0x1000;
            }
            if (type.isDecimal) {
                textType |= 0x2000;
            }
            return textType;
        }
        if (type.type == TextInputChannel.TextInputType.PHONE) {
            return 3;
        }
        if (type.type == TextInputChannel.TextInputType.NONE) {
            return 0;
        }
        int textType = 1;
        if (type.type == TextInputChannel.TextInputType.MULTILINE) {
            textType |= 0x20000;
        } else if (type.type == TextInputChannel.TextInputType.EMAIL_ADDRESS) {
            textType |= 0x20;
        } else if (type.type == TextInputChannel.TextInputType.URL) {
            textType |= 0x10;
        } else if (type.type == TextInputChannel.TextInputType.VISIBLE_PASSWORD) {
            textType |= 0x90;
        } else if (type.type == TextInputChannel.TextInputType.NAME) {
            textType |= 0x60;
        } else if (type.type == TextInputChannel.TextInputType.POSTAL_ADDRESS) {
            textType |= 0x70;
        }
        if (obscureText) {
            textType |= 0x80000;
            textType |= 0x80;
        } else {
            if (autocorrect) {
                textType |= 0x8000;
            }
            if (!enableSuggestions) {
                textType |= 0x80000;
                textType |= 0x90;
            }
        }
        if (textCapitalization == TextInputChannel.TextCapitalization.CHARACTERS) {
            textType |= 0x1000;
        } else if (textCapitalization == TextInputChannel.TextCapitalization.WORDS) {
            textType |= 0x2000;
        } else if (textCapitalization == TextInputChannel.TextCapitalization.SENTENCES) {
            textType |= 0x4000;
        }
        return textType;
    }

    @Nullable
    public InputConnection createInputConnection(@NonNull View view, @NonNull KeyboardManager keyboardManager, @NonNull EditorInfo outAttrs) {
        if (this.inputTarget.type == InputTarget.Type.NO_TARGET) {
            this.lastInputConnection = null;
            return null;
        }
        if (this.inputTarget.type == InputTarget.Type.PHYSICAL_DISPLAY_PLATFORM_VIEW) {
            return null;
        }
        if (this.inputTarget.type == InputTarget.Type.VIRTUAL_DISPLAY_PLATFORM_VIEW) {
            if (this.isInputConnectionLocked) {
                return this.lastInputConnection;
            }
            this.lastInputConnection = this.platformViewsController.getPlatformViewById(this.inputTarget.id).onCreateInputConnection(outAttrs);
            return this.lastInputConnection;
        }
        outAttrs.inputType = TextInputPlugin.inputTypeFromTextInputType(this.configuration.inputType, this.configuration.obscureText, this.configuration.autocorrect, this.configuration.enableSuggestions, this.configuration.enableIMEPersonalizedLearning, this.configuration.textCapitalization);
        outAttrs.imeOptions = 0x2000000;
        if (Build.VERSION.SDK_INT >= 26 && !this.configuration.enableIMEPersonalizedLearning) {
            outAttrs.imeOptions |= 0x1000000;
        }
        int enterAction = this.configuration.inputAction == null ? ((0x20000 & outAttrs.inputType) != 0 ? 1 : 6) : this.configuration.inputAction;
        if (this.configuration.actionLabel != null) {
            outAttrs.actionLabel = this.configuration.actionLabel;
            outAttrs.actionId = enterAction;
        }
        outAttrs.imeOptions |= enterAction;
        if (this.configuration.contentCommitMimeTypes != null) {
            String[] imgTypeString = this.configuration.contentCommitMimeTypes;
            EditorInfoCompat.setContentMimeTypes((EditorInfo)outAttrs, (String[])imgTypeString);
        }
        InputConnectionAdaptor connection = new InputConnectionAdaptor(view, this.inputTarget.id, this.textInputChannel, keyboardManager, this.mEditable, outAttrs);
        outAttrs.initialSelStart = this.mEditable.getSelectionStart();
        outAttrs.initialSelEnd = this.mEditable.getSelectionEnd();
        this.lastInputConnection = connection;
        return this.lastInputConnection;
    }

    @Nullable
    public InputConnection getLastInputConnection() {
        return this.lastInputConnection;
    }

    public void clearPlatformViewClient(int platformViewId) {
        if ((this.inputTarget.type == InputTarget.Type.VIRTUAL_DISPLAY_PLATFORM_VIEW || this.inputTarget.type == InputTarget.Type.PHYSICAL_DISPLAY_PLATFORM_VIEW) && this.inputTarget.id == platformViewId) {
            this.inputTarget = new InputTarget(InputTarget.Type.NO_TARGET, 0);
            this.notifyViewExited();
            this.mImm.hideSoftInputFromWindow(this.mView.getApplicationWindowToken(), 0);
            this.mImm.restartInput(this.mView);
            this.mRestartInputPending = false;
        }
    }

    public void sendTextInputAppPrivateCommand(@NonNull String action, @NonNull Bundle data) {
        this.mImm.sendAppPrivateCommand(this.mView, action, data);
    }

    @VisibleForTesting
    void showTextInput(View view) {
        if (this.configuration == null || this.configuration.inputType == null || this.configuration.inputType.type != TextInputChannel.TextInputType.NONE) {
            view.requestFocus();
            this.mImm.showSoftInput(view, 0);
        } else {
            this.hideTextInput(view);
        }
    }

    private void hideTextInput(View view) {
        this.notifyViewExited();
        this.mImm.hideSoftInputFromWindow(view.getApplicationWindowToken(), 0);
    }

    @VisibleForTesting
    void setTextInputClient(int client, TextInputChannel.Configuration configuration) {
        this.notifyViewExited();
        this.configuration = configuration;
        this.inputTarget = new InputTarget(InputTarget.Type.FRAMEWORK_CLIENT, client);
        this.mEditable.removeEditingStateListener(this);
        this.mEditable = new ListenableEditingState(configuration.autofill != null ? configuration.autofill.editState : null, this.mView);
        this.updateAutofillConfigurationIfNeeded(configuration);
        this.mRestartInputPending = true;
        this.unlockPlatformViewInputConnection();
        this.lastClientRect = null;
        this.mEditable.addEditingStateListener(this);
    }

    private void setPlatformViewTextInputClient(int platformViewId, boolean usesVirtualDisplay) {
        if (usesVirtualDisplay) {
            this.mView.requestFocus();
            this.inputTarget = new InputTarget(InputTarget.Type.VIRTUAL_DISPLAY_PLATFORM_VIEW, platformViewId);
            this.mImm.restartInput(this.mView);
            this.mRestartInputPending = false;
        } else {
            this.inputTarget = new InputTarget(InputTarget.Type.PHYSICAL_DISPLAY_PLATFORM_VIEW, platformViewId);
            this.lastInputConnection = null;
        }
    }

    private static boolean composingChanged(TextInputChannel.TextEditState before, TextInputChannel.TextEditState after) {
        int composingRegionLength = before.composingEnd - before.composingStart;
        if (composingRegionLength != after.composingEnd - after.composingStart) {
            return true;
        }
        for (int index = 0; index < composingRegionLength; ++index) {
            if (before.text.charAt(index + before.composingStart) == after.text.charAt(index + after.composingStart)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    void setTextInputEditingState(View view, TextInputChannel.TextEditState state) {
        if (!this.mRestartInputPending && this.mLastKnownFrameworkTextEditingState != null && this.mLastKnownFrameworkTextEditingState.hasComposing()) {
            this.mRestartInputPending = TextInputPlugin.composingChanged(this.mLastKnownFrameworkTextEditingState, state);
            if (this.mRestartInputPending) {
                Log.i(TAG, "Composing region changed by the framework. Restarting the input method.");
            }
        }
        this.mLastKnownFrameworkTextEditingState = state;
        this.mEditable.setEditingState(state);
        if (this.mRestartInputPending) {
            this.mImm.restartInput(view);
            this.mRestartInputPending = false;
        }
    }

    private void saveEditableSizeAndTransform(double width, double height, final double[] matrix) {
        final double[] minMax = new double[4];
        final boolean isAffine = matrix[3] == 0.0 && matrix[7] == 0.0 && matrix[15] == 1.0;
        minMax[0] = minMax[1] = matrix[12] / matrix[15];
        minMax[2] = minMax[3] = matrix[13] / matrix[15];
        MinMax finder = new MinMax(){

            @Override
            public void inspect(double x, double y) {
                double w = isAffine ? 1.0 : 1.0 / (matrix[3] * x + matrix[7] * y + matrix[15]);
                double tx = (matrix[0] * x + matrix[4] * y + matrix[12]) * w;
                double ty = (matrix[1] * x + matrix[5] * y + matrix[13]) * w;
                if (tx < minMax[0]) {
                    minMax[0] = tx;
                } else if (tx > minMax[1]) {
                    minMax[1] = tx;
                }
                if (ty < minMax[2]) {
                    minMax[2] = ty;
                } else if (ty > minMax[3]) {
                    minMax[3] = ty;
                }
            }
        };
        finder.inspect(width, 0.0);
        finder.inspect(width, height);
        finder.inspect(0.0, height);
        Float density = Float.valueOf(this.mView.getContext().getResources().getDisplayMetrics().density);
        this.lastClientRect = new Rect((int)(minMax[0] * (double)density.floatValue()), (int)(minMax[2] * (double)density.floatValue()), (int)Math.ceil(minMax[1] * (double)density.floatValue()), (int)Math.ceil(minMax[3] * (double)density.floatValue()));
    }

    @VisibleForTesting
    void clearTextInputClient() {
        if (this.inputTarget.type == InputTarget.Type.VIRTUAL_DISPLAY_PLATFORM_VIEW) {
            return;
        }
        this.mEditable.removeEditingStateListener(this);
        this.notifyViewExited();
        this.configuration = null;
        this.updateAutofillConfigurationIfNeeded(null);
        this.inputTarget = new InputTarget(InputTarget.Type.NO_TARGET, 0);
        this.unlockPlatformViewInputConnection();
        this.lastClientRect = null;
        this.mImm.restartInput(this.mView);
    }

    public boolean handleKeyEvent(@NonNull KeyEvent keyEvent) {
        if (!this.getInputMethodManager().isAcceptingText() || this.lastInputConnection == null) {
            return false;
        }
        return this.lastInputConnection instanceof InputConnectionAdaptor ? ((InputConnectionAdaptor)this.lastInputConnection).handleKeyEvent(keyEvent) : this.lastInputConnection.sendKeyEvent(keyEvent);
    }

    @Override
    public void didChangeEditingState(boolean textChanged, boolean selectionChanged, boolean composingRegionChanged) {
        boolean skipFrameworkUpdate;
        if (textChanged) {
            this.notifyValueChanged(this.mEditable.toString());
        }
        int selectionStart = this.mEditable.getSelectionStart();
        int selectionEnd = this.mEditable.getSelectionEnd();
        int composingStart = this.mEditable.getComposingStart();
        int composingEnd = this.mEditable.getComposingEnd();
        ArrayList<TextEditingDelta> batchTextEditingDeltas = this.mEditable.extractBatchTextEditingDeltas();
        boolean bl = skipFrameworkUpdate = this.mLastKnownFrameworkTextEditingState == null || this.mEditable.toString().equals(this.mLastKnownFrameworkTextEditingState.text) && selectionStart == this.mLastKnownFrameworkTextEditingState.selectionStart && selectionEnd == this.mLastKnownFrameworkTextEditingState.selectionEnd && composingStart == this.mLastKnownFrameworkTextEditingState.composingStart && composingEnd == this.mLastKnownFrameworkTextEditingState.composingEnd;
        if (!skipFrameworkUpdate) {
            Log.v(TAG, "send EditingState to flutter: " + this.mEditable.toString());
            if (this.configuration.enableDeltaModel) {
                this.textInputChannel.updateEditingStateWithDeltas(this.inputTarget.id, batchTextEditingDeltas);
                this.mEditable.clearBatchDeltas();
            } else {
                this.textInputChannel.updateEditingState(this.inputTarget.id, this.mEditable.toString(), selectionStart, selectionEnd, composingStart, composingEnd);
            }
            this.mLastKnownFrameworkTextEditingState = new TextInputChannel.TextEditState(this.mEditable.toString(), selectionStart, selectionEnd, composingStart, composingEnd);
        } else {
            this.mEditable.clearBatchDeltas();
        }
    }

    private boolean needsAutofill() {
        return this.autofillConfiguration != null;
    }

    private void notifyViewEntered() {
        if (Build.VERSION.SDK_INT < 26 || this.afm == null || !this.needsAutofill()) {
            return;
        }
        String triggerIdentifier = this.configuration.autofill.uniqueIdentifier;
        int[] offset = new int[2];
        this.mView.getLocationOnScreen(offset);
        Rect rect = new Rect(this.lastClientRect);
        rect.offset(offset[0], offset[1]);
        this.afm.notifyViewEntered(this.mView, triggerIdentifier.hashCode(), rect);
    }

    private void notifyViewExited() {
        if (Build.VERSION.SDK_INT < 26 || this.afm == null || this.configuration == null || this.configuration.autofill == null || !this.needsAutofill()) {
            return;
        }
        String triggerIdentifier = this.configuration.autofill.uniqueIdentifier;
        this.afm.notifyViewExited(this.mView, triggerIdentifier.hashCode());
    }

    private void notifyValueChanged(String newValue) {
        if (Build.VERSION.SDK_INT < 26 || this.afm == null || !this.needsAutofill()) {
            return;
        }
        String triggerIdentifier = this.configuration.autofill.uniqueIdentifier;
        this.afm.notifyValueChanged(this.mView, triggerIdentifier.hashCode(), AutofillValue.forText((CharSequence)newValue));
    }

    private void updateAutofillConfigurationIfNeeded(TextInputChannel.Configuration configuration) {
        if (Build.VERSION.SDK_INT < 26) {
            return;
        }
        if (configuration == null || configuration.autofill == null) {
            this.autofillConfiguration = null;
            return;
        }
        TextInputChannel.Configuration[] configurations = configuration.fields;
        this.autofillConfiguration = new SparseArray();
        if (configurations == null) {
            this.autofillConfiguration.put(configuration.autofill.uniqueIdentifier.hashCode(), (Object)configuration);
        } else {
            for (TextInputChannel.Configuration config : configurations) {
                TextInputChannel.Configuration.Autofill autofill = config.autofill;
                if (autofill == null) continue;
                this.autofillConfiguration.put(autofill.uniqueIdentifier.hashCode(), (Object)config);
                this.afm.notifyValueChanged(this.mView, autofill.uniqueIdentifier.hashCode(), AutofillValue.forText((CharSequence)autofill.editState.text));
            }
        }
    }

    public void onProvideAutofillVirtualStructure(@NonNull ViewStructure structure, int flags) {
        if (Build.VERSION.SDK_INT < 26 || !this.needsAutofill()) {
            return;
        }
        String triggerIdentifier = this.configuration.autofill.uniqueIdentifier;
        AutofillId parentId = structure.getAutofillId();
        for (int i = 0; i < this.autofillConfiguration.size(); ++i) {
            int autofillId = this.autofillConfiguration.keyAt(i);
            TextInputChannel.Configuration config = (TextInputChannel.Configuration)this.autofillConfiguration.valueAt(i);
            TextInputChannel.Configuration.Autofill autofill = config.autofill;
            if (autofill == null) continue;
            structure.addChildCount(1);
            ViewStructure child = structure.newChild(i);
            child.setAutofillId(parentId, autofillId);
            if (autofill.hints.length > 0) {
                child.setAutofillHints(autofill.hints);
            }
            child.setAutofillType(1);
            child.setVisibility(0);
            if (autofill.hintText != null) {
                child.setHint((CharSequence)autofill.hintText);
            }
            if (triggerIdentifier.hashCode() == autofillId && this.lastClientRect != null) {
                child.setDimens(this.lastClientRect.left, this.lastClientRect.top, 0, 0, this.lastClientRect.width(), this.lastClientRect.height());
                child.setAutofillValue(AutofillValue.forText((CharSequence)((Object)this.mEditable)));
                continue;
            }
            child.setDimens(0, 0, 0, 0, 1, 1);
            child.setAutofillValue(AutofillValue.forText((CharSequence)autofill.editState.text));
        }
    }

    public void autofill(@NonNull SparseArray<AutofillValue> values) {
        if (Build.VERSION.SDK_INT < 26) {
            return;
        }
        if (this.configuration == null || this.autofillConfiguration == null || this.configuration.autofill == null) {
            return;
        }
        TextInputChannel.Configuration.Autofill currentAutofill = this.configuration.autofill;
        HashMap<String, TextInputChannel.TextEditState> editingValues = new HashMap<String, TextInputChannel.TextEditState>();
        for (int i = 0; i < values.size(); ++i) {
            int virtualId = values.keyAt(i);
            TextInputChannel.Configuration config = (TextInputChannel.Configuration)this.autofillConfiguration.get(virtualId);
            if (config == null || config.autofill == null) continue;
            TextInputChannel.Configuration.Autofill autofill = config.autofill;
            String value = ((AutofillValue)values.valueAt(i)).getTextValue().toString();
            TextInputChannel.TextEditState newState = new TextInputChannel.TextEditState(value, value.length(), value.length(), -1, -1);
            if (autofill.uniqueIdentifier.equals(currentAutofill.uniqueIdentifier)) {
                this.mEditable.setEditingState(newState);
                continue;
            }
            editingValues.put(autofill.uniqueIdentifier, newState);
        }
        this.textInputChannel.updateEditingStateWithTag(this.inputTarget.id, editingValues);
    }

    private static class InputTarget {
        @NonNull
        Type type;
        int id;

        public InputTarget(@NonNull Type type, int id2) {
            this.type = type;
            this.id = id2;
        }

        static enum Type {
            NO_TARGET,
            FRAMEWORK_CLIENT,
            VIRTUAL_DISPLAY_PLATFORM_VIEW,
            PHYSICAL_DISPLAY_PLATFORM_VIEW;

        }
    }

    private static interface MinMax {
        public void inspect(double var1, double var3);
    }
}

