/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.platform;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.accessibility.AccessibilityEvent;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.Log;
import io.flutter.embedding.android.AndroidTouchProcessor;
import io.flutter.plugin.platform.PlatformViewRenderTarget;
import io.flutter.util.ViewUtils;

@TargetApi(value=23)
public class PlatformViewWrapper
extends FrameLayout {
    private static final String TAG = "PlatformViewWrapper";
    private int prevLeft;
    private int prevTop;
    private int left;
    private int top;
    private AndroidTouchProcessor touchProcessor;
    private PlatformViewRenderTarget renderTarget;
    private ViewTreeObserver.OnGlobalFocusChangeListener activeFocusListener;

    public PlatformViewWrapper(@NonNull Context context) {
        super(context);
        this.setWillNotDraw(false);
    }

    public PlatformViewWrapper(@NonNull Context context, @NonNull PlatformViewRenderTarget renderTarget) {
        this(context);
        this.renderTarget = renderTarget;
    }

    public void setTouchProcessor(@Nullable AndroidTouchProcessor newTouchProcessor) {
        this.touchProcessor = newTouchProcessor;
    }

    public void setLayoutParams(@NonNull FrameLayout.LayoutParams params) {
        super.setLayoutParams((ViewGroup.LayoutParams)params);
        this.left = params.leftMargin;
        this.top = params.topMargin;
    }

    public void resizeRenderTarget(int width, int height) {
        if (this.renderTarget != null) {
            this.renderTarget.resize(width, height);
        }
    }

    public int getRenderTargetWidth() {
        if (this.renderTarget != null) {
            return this.renderTarget.getWidth();
        }
        return 0;
    }

    public int getRenderTargetHeight() {
        if (this.renderTarget != null) {
            return this.renderTarget.getHeight();
        }
        return 0;
    }

    public void release() {
        if (this.renderTarget != null) {
            this.renderTarget.release();
            this.renderTarget = null;
        }
    }

    public boolean onInterceptTouchEvent(@NonNull MotionEvent event) {
        return true;
    }

    public boolean requestSendAccessibilityEvent(View child, AccessibilityEvent event) {
        View embeddedView = this.getChildAt(0);
        if (embeddedView != null && embeddedView.getImportantForAccessibility() == 4) {
            return false;
        }
        return super.requestSendAccessibilityEvent(child, event);
    }

    @SuppressLint(value={"NewApi"})
    public void onDescendantInvalidated(@NonNull View child, @NonNull View target) {
        super.onDescendantInvalidated(child, target);
        this.invalidate();
    }

    public ViewParent invalidateChildInParent(int[] location, Rect dirty) {
        this.invalidate();
        return super.invalidateChildInParent(location, dirty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    public void draw(Canvas canvas) {
        if (this.renderTarget == null) {
            super.draw(canvas);
            Log.e(TAG, "Platform view cannot be composed without a RenderTarget.");
            return;
        }
        Surface targetSurface = this.renderTarget.getSurface();
        Canvas targetCanvas = targetSurface.lockHardwareCanvas();
        if (targetCanvas == null) {
            this.invalidate();
            return;
        }
        try {
            targetCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
            super.draw(targetCanvas);
        }
        finally {
            this.renderTarget.scheduleFrame();
            targetSurface.unlockCanvasAndPost(targetCanvas);
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (this.touchProcessor == null) {
            return super.onTouchEvent(event);
        }
        Matrix screenMatrix = new Matrix();
        switch (event.getAction()) {
            case 0: {
                this.prevLeft = this.left;
                this.prevTop = this.top;
                screenMatrix.postTranslate((float)this.left, (float)this.top);
                break;
            }
            case 2: {
                screenMatrix.postTranslate((float)this.prevLeft, (float)this.prevTop);
                this.prevLeft = this.left;
                this.prevTop = this.top;
                break;
            }
            default: {
                screenMatrix.postTranslate((float)this.left, (float)this.top);
            }
        }
        return this.touchProcessor.onTouchEvent(event, screenMatrix);
    }

    @VisibleForTesting
    public ViewTreeObserver.OnGlobalFocusChangeListener getActiveFocusListener() {
        return this.activeFocusListener;
    }

    public void setOnDescendantFocusChangeListener(final @NonNull View.OnFocusChangeListener userFocusListener) {
        this.unsetOnDescendantFocusChangeListener();
        ViewTreeObserver observer = this.getViewTreeObserver();
        if (observer.isAlive() && this.activeFocusListener == null) {
            this.activeFocusListener = new ViewTreeObserver.OnGlobalFocusChangeListener(){

                public void onGlobalFocusChanged(View oldFocus, View newFocus) {
                    userFocusListener.onFocusChange((View)PlatformViewWrapper.this, ViewUtils.childHasFocus((View)PlatformViewWrapper.this));
                }
            };
            observer.addOnGlobalFocusChangeListener(this.activeFocusListener);
        }
    }

    public void unsetOnDescendantFocusChangeListener() {
        ViewTreeObserver observer = this.getViewTreeObserver();
        if (observer.isAlive() && this.activeFocusListener != null) {
            ViewTreeObserver.OnGlobalFocusChangeListener currFocusListener = this.activeFocusListener;
            this.activeFocusListener = null;
            observer.removeOnGlobalFocusChangeListener(currFocusListener);
        }
    }
}

