/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.platform;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.view.Surface;
import io.flutter.plugin.platform.PlatformViewRenderTarget;
import io.flutter.view.TextureRegistry;

@TargetApi(value=26)
public class SurfaceTexturePlatformViewRenderTarget
implements PlatformViewRenderTarget {
    private static final String TAG = "SurfaceTexturePlatformViewRenderTarget";
    private final TextureRegistry.SurfaceTextureEntry surfaceTextureEntry;
    private SurfaceTexture surfaceTexture;
    private Surface surface;
    private int bufferWidth = 0;
    private int bufferHeight = 0;
    private boolean shouldRecreateSurfaceForLowMemory = false;
    private final TextureRegistry.OnTrimMemoryListener trimMemoryListener = new TextureRegistry.OnTrimMemoryListener(){

        @Override
        public void onTrimMemory(int level) {
            if (level == 80 && Build.VERSION.SDK_INT >= 29) {
                SurfaceTexturePlatformViewRenderTarget.this.shouldRecreateSurfaceForLowMemory = true;
            }
        }
    };

    private void recreateSurfaceIfNeeded() {
        if (this.surface != null && !this.shouldRecreateSurfaceForLowMemory) {
            return;
        }
        if (this.surface != null) {
            this.surface.release();
            this.surface = null;
        }
        this.surface = this.createSurface();
        this.shouldRecreateSurfaceForLowMemory = false;
    }

    protected Surface createSurface() {
        return new Surface(this.surfaceTexture);
    }

    public SurfaceTexturePlatformViewRenderTarget(TextureRegistry.SurfaceTextureEntry surfaceTextureEntry) {
        if (Build.VERSION.SDK_INT < 23) {
            throw new UnsupportedOperationException("Platform views cannot be displayed below API level 23You can prevent this issue by setting `minSdkVersion: 23` in build.gradle.");
        }
        this.surfaceTextureEntry = surfaceTextureEntry;
        this.surfaceTexture = surfaceTextureEntry.surfaceTexture();
        surfaceTextureEntry.setOnTrimMemoryListener(this.trimMemoryListener);
    }

    @Override
    public void resize(int width, int height) {
        this.bufferWidth = width;
        this.bufferHeight = height;
        if (this.surfaceTexture != null) {
            this.surfaceTexture.setDefaultBufferSize(this.bufferWidth, this.bufferHeight);
        }
    }

    @Override
    public int getWidth() {
        return this.bufferWidth;
    }

    @Override
    public int getHeight() {
        return this.bufferHeight;
    }

    @Override
    public long getId() {
        return this.surfaceTextureEntry.id();
    }

    @Override
    public boolean isReleased() {
        return this.surfaceTexture == null;
    }

    @Override
    public void release() {
        this.surfaceTexture = null;
        if (this.surface != null) {
            this.surface.release();
            this.surface = null;
        }
    }

    @Override
    public Surface getSurface() {
        this.recreateSurfaceIfNeeded();
        if (this.surfaceTexture == null || this.surfaceTexture.isReleased()) {
            return null;
        }
        return this.surface;
    }
}

