## 2021-12-31

### Notable issues

- [iOS] Flutter 2.8, fine frame drop detected in native listView on iOS [#95838](https://github.com/flutter/flutter/issues/95838)
- [Webview_flutter][Regression]: Navigating from webview using SurfaceAndroidView composition shows a flash on screen [#95545](https://github.com/flutter/flutter/issues/95545)
- [Android]: AutofillHints are not showing up (ex: for [AutofillHints.email]) [#95522](https://github.com/flutter/flutter/issues/95522)
- [MacOS Desktop] Process Class Freezes app after multiple calls [#95805](https://github.com/flutter/flutter/issues/95805)
- [Google Maps - Web] TypeError: Cannot read properties of null (reading 'Ye') while resizing browser window [#95771](https://github.com/flutter/flutter/issues/95771)
- [Add to App] shared_preferences Package doesn't work in the multiple_flutters_android in release mode.[#95662](https://github.com/flutter/flutter/issues/95662)
- [Windows] WINUWP app fails to build with Exception: Unable to generate build files [#95597](https://github.com/flutter/flutter/issues/95597)

### Issue counts

#### Flutter

New Flutter issues triaged 153, closed 56 (36.6%).

In total closed 87 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 32.18% |
| Fixed | 8.05% |
| Invalid | 43.68%  |
| Solved | 16.09% |

#### Flutter/website

New Flutter website issues triaged 6 closed 0 (0%).

In total closed 1 issues during the week.

| Reason for closing  |  |
| -- | -- |
| fixed | 100% |

#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 1, closed 1 (100%).

In total closed 3 issues during the week.

| Reason for closing  |  |
| -- | -- |
| invalid | 100% |

#### Flutterfire

New Flutterfire issues triaged 37, closed 14 (37.84%).

In total closed 28 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 17.86%  |
| fixed | 10.71%  |
| invalid | 25.00% |
| no-response | 7.14% |
| solution-provided | 17.86% |
| user | 10.71% |
| wontfix | 10.71% |


## 2021-12-23

### Notable issues

- [web] TextField doesn't accept input after it is submitted even though it retains focus. [#95553](https://github.com/flutter/flutter/issues/95553)
- [Camera][iOS]: App flash bursts while taking picture even though `FlashMode` is set to OFF. [#95679](https://github.com/flutter/flutter/issues/95679)
- [Windows] WINUWP app fails to build with Exception: Unable to generate build files. [#95597](https://github.com/flutter/flutter/issues/95597)
- [Add to App] shared_preferences Package doesn't work in the multiple_flutters_android in release mode. [#95662](https://github.com/flutter/flutter/issues/95662)

### Issue counts

#### Flutter

New Flutter issues triaged 141, closed 67 (47.52%).

In total closed 97 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 34.0% |
| Fixed | 11.3% |
| Invalid | 42.3%  |
| Solved | 12.4% |

#### Flutter/website

New Flutter website issues triaged 7 closed 3 (42.86%).

In total closed 3 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 33.3% |
| invalid | 66.7% |

#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 5, closed 4 (80%).

In total closed 5 issues during the week.

| Reason for closing  |  |
| -- | -- |
| invalid | 100% |

#### Flutterfire

New Flutterfire issues triaged 18, closed 7 (38.89%).

In total closed 15 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 20.00%  |
| fixed | 6.67%  |
| invalid | 26.67% |
| no-response | 20.00% |
| solution-provided | 13.33% |
| user | 13.33% |


## 2021-12-17

### Notable issues

- [animation] PageTransitionSwitcher doesn’t animate smoothly if `reverse` is true on Flutter 2.8.0. [#95270](https://github.com/flutter/flutter/issues/95270)
- [Web] [CanvasKit] Platform Views (including Video_player fullscreen) blanking other widgets on exit - regression [#95259](https://github.com/flutter/flutter/issues/95259)
- [Android] PageView animateTo and nextPage do not work when PageView.index is 0 [#95461](https://github.com/flutter/flutter/issues/95461)
- Textfield dismisses keyboard after text submission even if focus is still in the text field [#95154](https://github.com/flutter/flutter/issues/95154)
- Regression: AutofillGroup not working on iOS for credentials [#95362](https://github.com/flutter/flutter/issues/95362)
- Regression: Setting addRepaintBoundaries to true or false shows blinking horizontal line while scrolling [#95199](https://github.com/flutter/flutter/issues/95199)

### Issue counts

#### Flutter

New Flutter issues triaged 216, closed 71 (32.87%).

In total closed 150 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 32.667% |
| Fixed | 27.333% |
| Invalid | 28.000%  |
| Solved | 11.333% |
| Timeout | 0.667% |

#### Flutter/website

New Flutter website issues triaged 7 closed 0 (0%).

In total closed 1 issues during the week.

| Reason for closing  |  |
| -- | -- |
| fixed | 100% |


#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 6, closed 1 (16.67%).

In total closed 2 issues during the week.

| Reason for closing  |  |
| -- | -- |
| invalid | 100% |

#### Flutterfire

New Flutterfire issues triaged 35, closed 9 (25.71%).

In total closed 27 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 7.41%  |
| fixed | 40.74%  |
| invalid | 22.22% |
| no-response | 11.11% |
| user | 18.52% |


## 2021-12-10

### Notable issues

- [pointer_interceptor][canvaskit] Using pointer_interceptor with Canvaskit throws `The following TypeErrorImpl was thrown during a scheduler callback: Unexpected null value.` [#94945](https://github.com/flutter/flutter/issues/94945)
- Trying to input Korean adds extra text. [#94845](https://github.com/flutter/flutter/issues/94845)
- Old issue starting to gain some traction: Australian MaterialLocalizations has incorrect mm/dd/yyyy dateHelpText. [#70341](https://github.com/flutter/flutter/issues/70341)
- Delete key does not work when shift is pressed (android and Desktop). [#94880](https://github.com/flutter/flutter/issues/94880)
- [test] Some lines are skipped by coverage test after upgrading to 2.8.0 . [#95008](https://github.com/flutter/flutter/issues/95008)

### Issue counts

#### Flutter

New Flutter issues triaged 192, closed 57 (29.69%).

In total closed 148 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 18.24% |
| Fixed | 12.84% |
| Invalid | 32.43%  |
| Solved | 9.46% |
| Timeout | 27.03% |

#### Flutter/website

New Flutter website issues triaged 8 closed 2 (25%).

In total closed 3 issues during the week.

| Reason for closing  |  |
| -- | -- |
| invalid| 33.3% |
| duplicate | 33.3% |
| fixed | 33.3% |


#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 12, closed 2 (16.67%).

In total closed 5 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 20% |
| fixed | 20% |
| invalid | 40% |
| wont fix - infeasible | 20% |

#### Flutterfire

New Flutterfire issues triaged 20, closed 2 (10%).

In total closed 11 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 9.09%  |
| fixed | 36.36%  |
| invalid | 9.09% |
| no-response | 9.09% |
| solution-provided | 9.09% |
| user | 27.27% |


## 2021-12-03

### Notable issues

- [Web] Text doesn't render with Image on screen unless an activity (such as hover) is detected on page [#94318](https://github.com/flutter/flutter/issues/94318), regression identified as per [this comment](https://github.com/flutter/flutter/issues/94318#issuecomment-981810404)
- TextInputAction.next doesn't work in lists with IconButton [#94414](https://github.com/flutter/flutter/issues/94414)
- [Android] App shows black screen after being in the background [#93276](https://github.com/flutter/flutter/issues/93276), appears to affect a certain group of devices.

### Issue counts

#### Flutter

New Flutter issues triaged 181, closed 57 (31.49%).

In total closed 132 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 17.42% |
| Fixed | 13.64% |
| Invalid | 43.18%  |
| Solved | 8.33% |
| Timeout | 17.42% |

#### Flutter/website

New Flutter website issues triaged 3 closed 1 (33.3%).

In total closed 2 issues during the week.

| Reason for closing  |  |
| -- | -- |
| invalid| 50% |
| duplicate | 50% |


#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 2, closed 0 (0%).

In total closed 2 issues during the week.

| Reason for closing  |  |
| -- | -- |
| fixed | 100% |


#### Flutterfire

New Flutterfire issues triaged 23, closed 4 (17.39%).

In total closed 17 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate | 11.8%  |
| Invalid | 17.6%  |
| no-response | 35.3% |
| solution-provided | 11.8% |
| user | 23.5% |

## 2021-11-26

### Notable issues

No notable issues to report this week.

### Issue counts

#### Flutter

New Flutter issues triaged 151, closed 48 (31.79%).

In total closed 83 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 22.9% |
| Fixed | 16.9% |
| Invalid | 41.0%  |
| Solved | 18.1% |
| Timeout | 1.2% |

#### Flutter/website

New Flutter website issues triaged 8 closed 1 (12.5%).

In total closed 1 issue during the week.

| Reason for closing  |  |
| -- | -- |
| invalid| 100% |


#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 8, closed 3 (37.5%).

In total closed 3 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate | 66.7% |
| Invalid | 33.3% |

#### Flutterfire

New Flutterfire issues triaged 14, closed 7 (50%).

In total closed 7 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate | 14.3%  |
| Invalid | 28.6%  |
| user | 57.1% |


## 2021-11-19

### Notable issues

No notable issues to report this week.

### Issue counts

#### Flutter

New Flutter issues triaged 165, closed 50 (30.3%).

In total closed 140 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 16.4% |
| Fixed | 10.7% |
| Invalid | 28.6%  |
| Solved | 14.3% |
| Timeout | 30.0% |

#### Flutter/website

New Flutter website issues triaged 16, closed 2 (12.5%).

In total closed 2 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 50% |
| invalid| 50% |


#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 6, closed 1 (16.67%).

In total closed 4 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate | 25% |
| Invalid | 25% |
| Fixed | 50% |

#### Flutterfire

New Flutterfire issues triaged 12, closed 3 (25%).

In total closed 19 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate | 15.79%  |
| Invalid | 15.79%  |
| no-response | 36.84%  |
| solution-provided | 5.26% |
| user | 26.32% |


## 2021-11-12

### Notable issues

No notable issues to report this week.

### Issue counts

#### Flutter

New Flutter issues triaged 175, closed 55 (31.43%).

In total closed 124 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 15.3% |
| Fixed | 16.9% |
| Invalid | 40.3%  |
| Solved | 12.9% |
| Timeout | 14.5% |

#### Flutter/website

New Flutter website issues triaged 6, closed 2 (33.33%).

In total closed 3 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 33.3% |
| invalid| 66.7% |


#### dart-lang/site-www

New Dart site issues triaged 1, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 1, closed 0 (0%).

In total closed 2 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate | 50% |
| Invalid | 50% |

#### Flutterfire

New Flutterfire issues triaged 25, closed 4 (16%).

In total closed 12 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate | 16.67%  |
| fixed | 16.67% |
| Invalid | 8.33%  |
| no-response | 25.00%  |
| solution-provided | 8.33% |
| user | 25.00% |



## 2021-11-05

### Notable issues

* [iOS Simulator] Cannot input text into TextField using hardware keyboard [#92796](https://github.com/flutter/flutter/issues/92796)
* [Add to App] Physical keyboard doesn't work on iOS simulator [#92997](https://github.com/flutter/flutter/issues/92997)

### Issue counts

#### Flutter

New Flutter issues triaged 159, closed 38 (23.9%).

In total closed 120 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 17.50% |
| Fixed | 8.33% |
| Invalid | 19.17%  |
| Solved | 15.00% |
| Timeout | 40.00% |

#### Flutter/website

New Flutter website issues triaged 6, closed 1 (16.67%).

In total closed 1 issue during the week.

| Reason for closing  |  |
| -- | -- |
| invalid| 100.0% |

#### dart-lang/site-www

New Dart site issues triaged 1, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 4, closed 2 (50%).

In total closed 3 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate | 66.7% |
| Invalid | 33.3% |

#### Flutterfire

New Flutterfire issues triaged 22, closed 7 (31.82%).

In total closed 12 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate | 16.67%  |
| Invalid | 41.67%  |
| no-response | 8.33%  |
| user | 25.00% |
| wontfix | 8.33% |


## 2021-10-29

### Notable issues

* Layout broken in Chrome on iOS when navigation to flutter website through external hyperlink. [#92655](https://github.com/flutter/flutter/issues/92655)
* [Android] Severe jank with custom paint. [#92366](https://github.com/flutter/flutter/issues/92366), regression identified as per [this comment](https://github.com/flutter/flutter/issues/92366#issuecomment-954771995)

### Issue counts

#### Flutter

New Flutter issues triaged 198, closed 62 (31.31%).

In total closed 115 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 26.96% |
| Fixed | 13.04% |
| Invalid | 36.52%  |
| Solved | 6.96% |
| Timeout | 16.52% |

#### Flutter/website

New Flutter website issues triaged 12, closed 2 (16.67%).

In total closed 7 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate | 14.3% |
| Fixed | 57.1% |
| invalid| 28.6% |

#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 3, closed 0 (0%).

In total closed 3 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate | 66.7% |
| Invalid | 33.3% |

#### Flutterfire

New Flutterfire issues triaged 23, closed 5 (21.74%).

In total closed 9 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate | 22.2%  |
| Invalid | 22.2%  |
| Solution provided | 11.1%  |
| User | 33.3%  |
| wontfix | 11.1% |


## 2021-10-22

### Notable issues

* TextField in CupertinoTabScaffold is not focusable after back swipe, iOS (only on master channel). [#92053](https://github.com/flutter/flutter/issues/92053)
* MaterialBanner causes RenderFlex overflow when navigating from a screen with an appbar to one without. [#92157](https://github.com/flutter/flutter/issues/92157)
* framework throws Rect argument contained a NaN value exception. There have been similar exceptions related to different classes in the past. [#92262](https://github.com/flutter/flutter/issues/92262)
* ResizeImage method makes image blurry and decreases image quality. [#92010](https://github.com/flutter/flutter/issues/92010)


### Issue counts

#### Flutter

New Flutter issues triaged 176, closed 52 (29.55%).

In total closed 148 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 15.5% |
| Fixed | 16.2% |
| Invalid | 26.4%  |
| Solved | 10.8% |
| Timeout | 31.1% |

#### Flutter/website

New Flutter website issues triaged 4, closed 0 (0%).

In total closed 2 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate | 50% |
| Fixed | 50% |

#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 6, closed 2 (33.33%).

In total closed 7 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Invalid | 100% |

#### Flutterfire

New Flutterfire issues triaged 21, closed 7 (33.33%).

In total closed 8 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate | 12.5%  |
| Fixed | 25.0%  |
| Invalid | 50%  |
| Solution provided | 12.5%  |

## 2021-10-15

### Notable issues

* FittedBox component is causing parent constraints to lose in Flutter 2.5.1 [#91670](https://github.com/flutter/flutter/issues/91670)
* [Linux] Build failure with uppercased flavor configuration [#91582](https://github.com/flutter/flutter/issues/91582)
* [animations] Pressing Android back button and the widget simultaneously causes the widget to disappear [#91598](https://github.com/flutter/flutter/issues/91598)
* [Camera] Build failure with compileSdkVersion 31 [#91412](https://github.com/flutter/flutter/issues/91412)
* [web][canvaskit] Images Disappear after leaving Fullscreen [#91881](https://github.com/flutter/flutter/issues/91881)
* `HEIC` images are not rendered in release mode, throws `Exception: Invalid Image Data` [#91421](https://github.com/flutter/flutter/issues/91421)

### Issue counts

#### Flutter

New Flutter issues triaged 198, closed 56 (28.28%).

In total closed 141 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Invalid | 34.04%  |
| Duplicate  | 15.60% |
| Fixed | 9.22% |
| Solved | 14.18% |
| Timeout | 26.95% |

#### Flutter/website

New Flutter website issues triaged 4, closed 1 (25%).

In total closed 1 issue during the week.

| Reason for closing  |  |
| -- | -- |
| Invalid | 100% |

#### dart-lang/site-www

New Dart site issues triaged 1, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 5, closed 0 (0%)

#### Flutterfire

New Flutterfire issues triaged 10, closed 1 (10%).

In total closed 5 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Solution provided | 80%  |
| User issue | 20%  |

## 2021-10-08

### Notable issues

* Accessibility Screen Reader: Control Focus API [#91290](https://github.com/flutter/flutter/issues/91290).

### Issue counts

#### Flutter

New Flutter issues triaged 173, closed 69 (39.88%)

In total closed 137 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 32.8%  |
| Duplicate  | 29.2% |
| Fixed | 10.9% |
| Solved | 13.1% |
| Timeout | 13.9% |

#### Flutter/website

New Flutter website issues triaged 8, closed 1 (12.5%)

In total closed 4 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 50% |
| Fixed | 50% |

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 3, closed 0 (0%)

In total closed 2 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 50% |
| Fixed | 50% |

#### Flutterfire

New Flutterfire issues triaged 23, closed 13 (56.52%)

In total closed 13 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 46.15%  |
| Duplicate | 38.46%  |
| Solution provided | 7.69%  |
| Won't fix | 7.69%  |

## 2021-10-01

### Notable issues

* [web] Chrome crashes when starting Flutter Web app in debug mode with breakpoints set [#90844](https://github.com/flutter/flutter/issues/90844).
* [web][devtools] App get stuck `Compiling lib\main.dart for the Web...` and devtools doesn't work in profile mode [#90596](https://github.com/flutter/flutter/issues/90596).
* [web] Navigating out of the app and returning crash the debug session [#90822](https://github.com/flutter/flutter/issues/90822).
* [web] App won't start, throws `GET /main_module.bootstrap.js AbsoluteImportUriError` [#90782](https://github.com/flutter/flutter/issues/90782).
* Translucent FloatingActionButton get's a persistent highlight when clicked/touched [#90753](https://github.com/flutter/flutter/issues/90753).
* [web] setSemanticsEnabled(true) makes TextField with obscureText:true print out obscured text [#90794](https://github.com/flutter/flutter/issues/90794).

### Issue counts

#### Flutter

New Flutter issues triaged 223, closed 77 (34.53%)

In total closed 176 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 31.3%  |
| Duplicate  | 20.5% |
| Fixed | 17.0% |
| Solved | 11.4% |
| Timeout | 19.9% |

#### Flutter/website

New Flutter website issues triaged 6, closed 2 (33.33%)

In total closed 6 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 33.3% |
| Duplicate | 33.3% |
| Fixed | 33.3% |

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 6, closed 1 (16.67%)

In total closed 5 issues during the week

| Reason for closing  |  |
| -- | -- |
| Fixed | 60%  |
| Invalid | 40%  |

#### Flutterfire

New Flutterfire issues triaged 27, closed 10 (37.04%)

In total closed 10 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 30%  |
| User issue | 10%  |
| Duplicate | 60.0%  |

## 2021-09-24

### Notable issues

* [Windows] Ctrl + Backspace does not work properly in text fields [#90427](https://github.com/flutter/flutter/issues/90427).
* [in_app_purchase][android] `introductoryPriceMicros` is empty. [#90244](https://github.com/flutter/flutter/issues/90244).
* CircularNotchedRectangle in BottomAppBar in BottomSheet not working as expected [#90276](https://github.com/flutter/flutter/issues/90276).

### Issue counts

#### Flutter

New Flutter issues triaged 206, closed 79 (38.35%)

In total closed 190 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 35.79%  |
| Duplicate  | 21.05% |
| Fixed | 16.84% |
| Solved | 6.84% |
| Timeout | 19.47% |

#### Flutter/website

New Flutter website issues triaged 5, closed 2 (40%)

In total closed 2 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 100% |

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 2, closed 1 (50%)

In total closed 6 issues during the week

| Reason for closing  |  |
| -- | -- |
| Duplicate | 16.7%  |
| Fixed | 33.3%  |
| Invalid | 50.0%  |

#### Flutterfire

New Flutterfire issues triaged 16, closed 5 (31.25%)

In total closed 6 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 16.7%  |
| Solution provided | 33.3%  |
| User issue | 50.0%  |

## 2021-09-17

### Notable issues

* [Web] [HTML][Safari] svg image not rendering per color [#90105](https://github.com/flutter/flutter/issues/90105)
* Flutter 2.5 floatingActionButton centerDocked notch problem [#90024](https://github.com/flutter/flutter/issues/90024)
* Opening Drawer with ListView throws: The provided ScrollController is currently attached to more than one ScrollPosition. [#89992](https://github.com/flutter/flutter/issues/89992)
* [Android] Backspace stops working when entering text mix of uppercase/lowercase in a TextField with obscureText: true [#89742](https://github.com/flutter/flutter/issues/89742)
* Dots appear under FAB with elevation without a background color [#90254](https://github.com/flutter/flutter/issues/90254)
* [web] browser back button throws `Error: Assertion failed: org-dartlang-sdk:///flutter_web_sdk/lib/_engine/engine/navigation/history.dart:311:14` [#90031](https://github.com/flutter/flutter/issues/90031)

### Issue counts

#### Flutter

New Flutter issues triaged 244, closed 75 (30.74%)

In total closed 182 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 30.22%  |
| Duplicate  | 20.33%  |
| Fixed | 12.64%  |
| Solved | 9.89%  |
| Timeout | 26.92%  |

#### Flutter/website

New Flutter website issues triaged 12, closed 3 (25%)

In total closed 3 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 66.7% |
| Duplicate | 33.3% |

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 5, closed 3 (60%)

In total closed 9 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 44.4%  |
| Duplicate | 33.3% |
| Fixed | 22.2% |

#### Flutterfire

New Flutterfire issues triaged 14, closed 7 (50%)

In total closed 8 issues during the week

| Reason for closing  |  |
| -- | -- |
| Duplicate | 25.00%  |
| Invalid | 37.5%  |
| User issue | 25.0%  |
| Won't fix | 12.5%  |

## 2021-09-10

### Notable issues

* ThemeData.primaryColor is broken in 2.5.0 [#89839](https://github.com/flutter/flutter/issues/89839)
* Draggable Scrollable sheet throws error logs in 2.5.0 [#89681](https://github.com/flutter/flutter/issues/89681)
* A regression in appbar in 2.5.0 [#89808](https://github.com/flutter/flutter/issues/89808)

### Issue counts

#### Flutter

New Flutter issues triaged 218, closed 85 (39%).

In total closed 160 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Invalid | 38%  |
| Duplicate  | 28%  |
| Fixed | 15%  |
| Solved | 6%  |
| Timeout | 13%  |

#### Flutter/website

New Flutter website issues triaged 6, closed 2 (33%).

In total closed 3 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Invalid | 33% |
| Duplicate | 67% |

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 5, closed 1 (20%).

In total closed 7 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Invalid | 72%  |
| Duplicate | 14% |
| Fixed | 14% |

#### dart-lang/site-www

No new Dart site issues were triaged this week.

#### Flutterfire

New Flutterfire issues triaged 22, closed 12 (55%).

In total closed 14 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate | 43%  |
| Invalid | 21%  |
| Fixed | 7%  |
| Solution provided | 7%  |
| User issue | 22%  |

## 2021-09-03

### Notable issues

* [camera][regression] App fatally crashes when quickly switching cameras only on Android [#89431](https://github.com/flutter/flutter/issues/89431)
* java.lang.SecurityException: Permission Denial crash at launch [#88767](https://github.com/flutter/flutter/issues/88767)
* [iOS][iPad simulator]: Trying to toggle software keyboard throws unhandled exception on latest master and beta [#89378](https://github.com/flutter/flutter/issues/89378)
* [Web] [Video_Player] Rendering regression [#88688](https://github.com/flutter/flutter/issues/88688)

### Issue counts

#### Flutter

New Flutter issues triaged 176, closed 55 (31%)

In total closed 150 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 36.0%  |
| Duplicate  | 20.0%  |
| Fixed | 25.3%  |
| Solved | 4.0%  |
| Timeout | 14.7%  |

We've finished the rework on the `p: camera` filter for Android & `p: flutter_markdown` filter.

#### Flutter/website

New Flutter website issues triaged 3, closed 1 (33.33%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 100% |

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 45, closed 11 (24.44%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 53.3%  |
| Duplicate | 33.3% |
| Fixed | 13.3% |

#### dart-lang/site-www

New Dart site issues triaged 1, closed 1 (100%)

| Reason for closing  |  |
| -- | -- |
| Duplicate | 100% |

#### Flutterfire

New Flutterfire issues triaged 24, closed 9 (37.5%)

In total closed 11 issues during the week

| Reason for closing  |  |
| -- | -- |
| Duplicate | 18.18%  |
| Invalid | 27.27%  |
| No response | 18.18%  |
| Solution provided | 27.27%  |
| User issue | 9.09%  |

## 2021-08-27

### Notable issues

* [desktop] `'!_debugDuringDeviceUpdate': is not true` exception thrown [#84241](https://github.com/flutter/flutter/issues/84241)
* Glitch when switching between text fields with autofillHints and autocorrect [#89022](https://github.com/flutter/flutter/issues/89022)
* ☔ Update all interactive samples/snippets for lint issues [#6155](https://github.com/flutter/website/issues/6155)

### Issue counts

#### Flutter

New Flutter issues triaged 251, closed 80 (32%)

In total closed 179 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 32.40%  |
| Duplicate  | 20.11%  |
| Fixed | 13.41%  |
| Solved | 3.91%  |
| Timeout | 30.17%  |

We're continuing to rework the `p: camera` filter.

#### Flutter/website

New Flutter website issues triaged 20, closed 9 (45%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 33.3% |
| Fixed | 22.2% |
| Duplicate | 44.4% |

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 23, closed 3 (13.04%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 66.7%  |
| Duplicate | 33.33% |

#### Flutterfire

New Flutterfire issues triaged 31, closed 12 (39%)

In total closed 20 issues during the week

| Reason for closing  |  |
| -- | -- |
| Duplicate | 15%  |
| Fixed | 10%  |
| Invalid | 40%  |
| No response | 15%  |
| Solution provided | 10%  |
| User issue | 5%  |
| Won't fix | 5%  |

## 2021-08-19

### Notable issues

* `Null check operator used on a null _rawKeyboard.lookUpLayout(physicalKey)!` [#88236](https://github.com/flutter/flutter/issues/88236)
* [Web][Url_launcher]: Several links on a page throws rendering error [#88449](https://github.com/flutter/flutter/issues/88449)
* App gets stuck at blank screen - `Could not launch engine with configuration` [#88407](https://github.com/flutter/flutter/issues/88407)
* SystemChrome.setSystemUIOverlayStyle doesn't change colors [#88431](https://github.com/flutter/flutter/issues/88431)

### Issue counts

#### Flutter

New Flutter issues triaged 151, closed 71 (47%)

In total closed 153 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 35.95%  |
| Duplicate  | 22.22%  |
| Fixed | 15.03%  |
| Solved | 2.61%  |
| Timeout | 24.18%  |

Finished checking the [p: webview issues](https://github.com/flutter/flutter/issues?q=is%3Aopen+label%3A%22p%3A+webview%22+sort%3Acreated-asc+-label%3A%22found+in+release%3A+2.0%22+-label%3A%22found+in+release%3A+2.1%22+-label%3A%22found+in+release%3A+2.2%22+-label%3A%22found+in+release%3A+2.3%22+-label%3A%22waiting+for+customer+response%22++-label%3A%22severe%3A+new+feature%22+-label%3A%22proposal%22+-label%3A%22passed+first+triage%22).

p: webview issues triaged 16, closed 3 (18.75%)

| Reason for closing  |  |
| -- | -- |
| Fixed | 18.75%  |

#### Flutter/website

New Flutter website issues triaged 19, closed 10 (52.63%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 10.52% |
| Fixed | 10.52% |
| Duplicate | 31.57% |

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 12, closed 4 (33.33%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 16.66%  |
| Duplicate | 16.66% |

#### Flutterfire

New Flutterfire issues triaged 12, closed 4 (33.33%)

In total closed 7 issues during the week

| Reason for closing  |  |
| -- | -- |
| Duplicate | 42.9%  |
| Solution provided | 28.6%  |
| Fixed | 28.6%  |

## 2021-08-13

### Notable issues

* [camera] Camera viewer is over exposed as a result images taken w/ flash mode come out washed out on Samsung devices with Android 11 [#88070](https://github.com/flutter/flutter/issues/88070)

### Issue counts

#### Flutter

New Flutter issues triaged 184, closed 64 (35%)

In total closed 99 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 49.49%  |
| Duplicate  | 25.25%  |
| Fixed | 22.22%  |
| Solved | 3.03%  |

We're continuing to rework the [p: webview issues](https://github.com/flutter/flutter/issues?q=is%3Aopen+label%3A%22p%3A+webview%22+sort%3Acreated-asc+-label%3A%22found+in+release%3A+2.0%22+-label%3A%22found+in+release%3A+2.1%22+-label%3A%22found+in+release%3A+2.2%22+-label%3A%22found+in+release%3A+2.3%22+-label%3A%22waiting+for+customer+response%22++-label%3A%22severe%3A+new+feature%22+-label%3A%22proposal%22+-label%3A%22passed+first+triage%22).

p: webview issues triaged 46, closed 9 (19.56%)

| Reason for closing  |  |
| -- | -- |
| Fixed | 19.56%  |

#### Flutter/website

New Flutter website issues triaged 11, closed 1 (9.09%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 9.09%  |

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 11, closed 0 (0.0%)

#### Flutterfire

New Flutterfire issues triaged 25, closed 11 (44%)

In total closed 15 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 20.00%  |
| Duplicate | 13.33%  |
| Solution provided | 46.67%  |
| User issue | 13.33%  |
| No response | 6.67%  |

## 2021-08-06

### Notable issues

* DartVM: dart::Object::InitNullAndBool Crash [#87796](https://github.com/flutter/flutter/issues/87796)

### Issue counts

#### Flutter

New Flutter issues triaged 195, closed 73 (37%)

In total closed 138 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 41.30%  |
| Duplicate  | 23.18%  |
| Fixed | 13.76%  |
| Solved | 0.72%  |
| Timeout | 21.01%  |

We're continuing to rework the [p: webview issues](https://github.com/flutter/flutter/issues?q=is%3Aopen+label%3A%22p%3A+webview%22+sort%3Acreated-asc+-label%3A%22found+in+release%3A+2.0%22+-label%3A%22found+in+release%3A+2.1%22+-label%3A%22found+in+release%3A+2.2%22+-label%3A%22found+in+release%3A+2.3%22+-label%3A%22waiting+for+customer+response%22++-label%3A%22severe%3A+new+feature%22+-label%3A%22proposal%22+-label%3A%22passed+first+triage%22).

p: webview issues triaged 18, closed 4 (22.2%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 16.66%  |
| Fixed | 5.55%  |

#### Flutter/website

New Flutter website issues triaged 8, closed 3 (37.5%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 25%  |
| Fixed | 12.5%  |

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 18, closed 6 (33.33%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 11.11%  |
| Duplicate | 22.22%  |

#### Flutterfire

New Flutterfire issues triaged 21, closed 4 (19%)

In total closed 5 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 40%  |
| Duplicate | 20%  |
| Solution provided | 40%  |

## 2021-07-30

### Notable issues

* [web] Severe memory leak on the latest dev and master [#87100](https://github.com/flutter/flutter/issues/87100)

### Issue counts

#### Flutter

New Flutter issues triaged 157, closed 58 (37%)

In total closed 149 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 29.53%  |
| Duplicate  | 22.15%  |
| Fixed | 16.11%  |
| Solved | 8.72%  |
| Timeout | 23.49%  |

#### Flutter/website

New Flutter website issues triaged 28, closed 6 (21.43%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 17.86%  |
| Duplicate | 3.57%  |

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 10, closed 2 (20%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 20%  |

#### Flutterfire

New Flutterfire issues triaged 19, closed 10 (53%)

In total closed 13 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 38.46%  |
| User issue | 7.69%  |
| Duplicate | 23.08%  |
| Solution provided | 15.38%  |
| Fixed | 7.69%  |
| No response | 7.69%  |

## 2021-07-23

### Notable issues

* [web] Incorrect Text rendering in Instagram webview [#86776](https://github.com/flutter/flutter/issues/86776)

### Issue counts

New Flutter issues triaged 170, closed 66 (39%)

In total closed 147 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 36.1%  |
| Duplicate  | 17.7%  |
| Fixed | 10.9%  |
| Solved | 3.4%  |
| Timeout | 32.0%  |

New Flutterfire issues triaged 32, closed 16 (50%)

In total closed 16 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 56.25%  |
| User issue | 6.25%  |
| Duplicate | 12.50%  |
| Solution provided | 25.00%  |

## 2021-07-16

### Notable issues

* [web][regression] text autofill doesn't work [#86497](https://github.com/flutter/flutter/issues/86497)
* [Crowd][Android] Native EditText with TYPE_CLASS_NUMBER has focus issues [#86480](https://github.com/flutter/flutter/issues/86480)

### Issue counts

New Flutter issues triaged 179, closed 66 (37%)

In total closed 155 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 40.00%  |
| Duplicate  | 14.84%  |
| Fixed | 13.55%  |
| Solved | 8.39%  |
| Timeout | 23.23%  |

New Flutterfire issues triaged 26, closed 18 (69%)

In total closed 19 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 57.89%  |
| User issue | 5.26%  |
| Duplicate | 15.79%  |
| Solution provided | 15.79%  |
| Fixed | 5.26%  |

## 2021-07-09

### Notable issues

* [crowd][image_picker][iOS] Exception is thrown when picking image on simulator [#70436](https://github.com/flutter/flutter/issues/70436)
* [crowd][web/desktop] TextField vertical alignment is broken with isDense: true [#86093](https://github.com/flutter/flutter/issues/86093)
* [desktop/web] TextField loses focus when calling _controller.clear [#86154](https://github.com/flutter/flutter/issues/86154)

### Issue counts

New Flutter issues triaged 199, closed 70 (35%)

In total closed 242 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 29.34%  |
| Duplicate  | 12.81%  |
| Fixed | 11.57%  |
| Solved | 6.61%  |
| Timeout | 39.67%  |

New Flutterfire issues triaged 17, closed 8 (47%)

In total closed 12 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 58.33%  |
| User issue | 16.67%  |
| Duplicate | 16.67%  |
| Solution provided | 8.33%  |

## 2021-07-02

### Notable issues

* [crowd][google_sign_in] version 5 and later crashes and terminate on iOS with 'NSInvalidArgumentException', reason: 'You must specify |clientID| for |GIDSignIn| [#85738](https://github.com/flutter/flutter/issues/85738)
* [web] IFrame is choppy when resizing window horizontally [#85522](https://github.com/flutter/flutter/issues/85522)
* [web] autofillHints on TextFormField causes soft keyboard in iOS browsers to re-appear unexpectedly [#85759](https://github.com/flutter/flutter/issues/85759)
* Check failed: gl_version_string. The GL proc resolver's glGetString(GL_VERSION) failed on Linux with Nvidia Graphics Card [#85460](https://github.com/flutter/flutter/issues/85460)

### Issue counts

New Flutter issues triaged 203, closed 70 (34%)

In total closed 137 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 43.07%  |
| Duplicate  | 24.82%  |
| Fixed | 21.17%  |
| Solved | 8.76%  |
| Timeout | 2.19%  |

New Flutterfire issues triaged 29, closed 13 (45%)

In total closed 15 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 20.0%  |
| User issue | 20.0%  |
| Duplicate | 33.3%  |
| Solution provided | 20.0%  |
| Won't fix | 6.67%  |

## 2021-06-25

### Notable issues

* A StackOverFlowError thrown on iOS simulator specifically, otherwise a white screen on physical device [#85026](https://github.com/flutter/flutter/issues/85026)
* Running web in profile/release mode throws NoSuchMethod error, while same code works in debug mode [#85136](https://github.com/flutter/flutter/issues/85136)

### Issue counts

New Flutter issues triaged 166, closed 61 (37%)

In total closed 90 issues during the week

Finished checking the [p: maps](https://github.com/flutter/flutter/issues?q=is%3Aopen+label%3A%22p%3A+maps%22+sort%3Acreated-asc+-label%3A%22found+in+release%3A+2.0%22+-label%3A%22found+in+release%3A+2.1%22+-label%3A%22found+in+release%3A+2.2%22+-label%3A%22found+in+release%3A+2.3%22+-label%3A%22waiting+for+customer+response%22+) issues and started reworking the [p: video_player](https://github.com/flutter/flutter/issues?q=is%3Aopen+label%3A%22p%3A+video_player%22+sort%3Acreated-asc+-label%3A%22found+in+release%3A+2.0%22+-label%3A%22found+in+release%3A+2.1%22+-label%3A%22found+in+release%3A+2.2%22+-label%3A%22found+in+release%3A+2.3%22+-label%3A%22waiting+for+customer+response%22++-label%3A%22severe%3A+new+feature%22+-label%3A%22proposal%22+-label%3A%22passed+first+triage%22) issues.

| Reason for closing  |  |
| -- | -- |
| Invalid | 46.67%  |
| Duplicate  | 25.56%  |
| Fixed | 7.78%  |
| Solved | 7.78%  |
| Timeout | 12.22%  |

New Flutterfire issues triaged 28, closed 6 (21%)

In total closed 6 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 66.7%  |
| User issue | 33.3%  |

## 2021-06-18

### Notable issues

* Bug in TextFormField introduced in V2.2.0 causes input to freeze and needs an app restart [#84620](https://github.com/flutter/flutter/issues/84620)
* [web] Cannot type in the TextField with `autofillHints` on `dev` and `master` channels on iOS [#84817](https://github.com/flutter/flutter/issues/84817)

### Issue counts

New Flutter issues triaged 204, closed 71 (35%)

In total closed 143 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 41.9%  |
| Duplicate  | 16.0%  |
| Fixed | 13.2%  |
| Solved | 6.2%  |
| Timeout | 22.3%  |

New Flutterfire issues triaged 28, closed 17 (61%)

In total closed 18 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 50.0%  |
| Duplicate | 22.3%  |
| User issue | 27.8% |

## 2021-06-11

### Notable issues

* [web] CanvasKit crash after many TextPainter.layout() calls [#84320](https://github.com/flutter/flutter/issues/84320)
* ListView layout error when using ListView and ExpansionTile widget [#84201](https://github.com/flutter/flutter/issues/84201)

### Issue counts

New Flutter issues triaged 192, closed 67 (35%)

In total closed 180 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 37.2%  |
| Duplicate  | 21.6%  |
| Fixed | 15%  |
| Solved | 5.5%  |
| Timeout | 20.5%  |

New Flutterfire issues triaged 32, closed 19 (59%)

In total closed 21 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 42.8%  |
| Duplicate | 9.5%  |
| User issue | 33.3% |
| Solution provided | 9.5% |
| Needs reproduction | 4.7% |

## 2021-06-04

### Notable issues

* [web, html] If a row has image followed by text, then ellipsis is not rendered. Works well using canvaskit [#83957](https://github.com/flutter/flutter/issues/83957)
* [web] hot restart throws assertion failure if using nested MaterialApp [#83864](https://github.com/flutter/flutter/issues/83864)
* [crowd] Text and SelectableText align differently [#83784](https://github.com/flutter/flutter/issues/83784)

### Issue counts

New Flutter issues triaged 233, closed 87 (37%)

In total closed 162 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 35%  |
| Duplicate  | 23%  |
| Fixed | 13%  |
| Solved | 6%  |
| Timeout | 23%  |

New Flutterfire issues triaged 22, closed 11 (50%)

In total closed 17 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 47%  |
| Duplicate | 18%  |
| User issue | 29%  |
| Fixed | 6% |

## 2021-05-28

### Notable issues

* TextFormField not responding to inputs on Android when typing on Microsoft SwiftKey [#83213](https://github.com/flutter/flutter/issues/83213)
* [Flutter 2.2] ListTile ignores tileColor/selectedTileColor if parent Container has color [#83108](https://github.com/flutter/flutter/issues/83108)
* Generated l10n file is missing 'intl' import with Flutter 2.2.0 [#83102](https://github.com/flutter/flutter/issues/83102)
* ReorderableListView throws RenderFlex exception while dragging on latest stable and master [#83224](https://github.com/flutter/flutter/issues/83224)

### Issue counts

New Flutter issues triaged 220, closed 83 (38%)

In total closed 186 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 39.7%  |
| Duplicate  | 20.4%  |
| Fixed | 12.9%  |
| Solved | 5.3%  |
| Timeout | 21.5%  |

New Flutterfire issues triaged 25, closed 8 (32%)

In total closed 14 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 21.4%  |
| Duplicate | 14.3%  |
| User issue | 35.7%  |
| Solution provided | 21.4% |
| Won't fix | 7.15% |

## 2021-05-21

### Notable issues

* 2.2: TextFormField's Suffix , Prefix, Icon and Label don't respond to Primary Color's Change [#83002](https://github.com/flutter/flutter/issues/83002)
* PopupMenuButton is broken after upgrade to Flutter `2.2.0` [#82874](https://github.com/flutter/flutter/issues/82874) - fixed
* TextOverflow not visible on the web on mobile [#82639](https://github.com/flutter/flutter/issues/82639)
* [web] Images pixelated on the canvaskit renderer [#82919](https://github.com/flutter/flutter/issues/82919)

### Issue counts

New Flutter issues triaged 215, closed 61 (28%)

We're continuing to rework the [p: maps issues](https://github.com/flutter/flutter/issues?q=is%3Aopen+label%3A%22p%3A+maps%22+sort%3Acreated-asc+-label%3A%22found+in+release%3A+2.0%22+-label%3A%22found+in+release%3A+2.1%22+-label%3A%22found+in+release%3A+2.2%22+-label%3A%22found+in+release%3A+2.3%22+-label%3A%22waiting+for+customer+response%22+)

In total closed 158 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 33.5%  |
| Duplicate  | 14.6%  |
| Fixed | 14.6%  |
| Solved | 3.8%  |
| Timeout | 33.5%  |

New Flutterfire issues triaged 36, closed 12 (33%)

In total closed 14 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 5  |
| Duplicate | 2  |
| User issue | 5  |
| Solution provided | 2  |

## 2021-05-14

### Notable issues

* [fixed] Flutter Doctor cannot find Android Studio 4.2 [#82345](https://github.com/flutter/flutter/issues/82345)
* [crowd][web][flutter 2.0] Certain font sizes render a greyish bar on top of the text in mobile browsers when inside ExpansionTile Widgets
[#82176](https://github.com/flutter/flutter/issues/82176) (the issue is only web when using `html` renderer)
* Text wrapping on top of itself on iOS/macOS on stable, blank on other channels and web html [#82023](https://github.com/flutter/flutter/issues/82023) (this particular issue is causing multiple issues on iOS/Mac and Web using `html` renderer)
* [camera] In Android take photo, unlockAutoFocus error Fatal Exception: java.lang.NullPointerException is thrown [#82031](https://github.com/flutter/flutter/issues/82031) (camera has production crash on many Android devices)

### Issue counts

New Flutter issues triaged 216, closed 72 (33%)

We're continuing to rework the [p: maps issues](https://github.com/flutter/flutter/issues?q=is%3Aopen+label%3A%22p%3A+maps%22+sort%3Acreated-asc+-label%3A%22found+in+release%3A+2.0%22+-label%3A%22found+in+release%3A+2.1%22+-label%3A%22found+in+release%3A+2.2%22+-label%3A%22found+in+release%3A+2.3%22+-label%3A%22waiting+for+customer+response%22+)

In total closed 171 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 28.65%  |
| Duplicate  | 21.64%  |
| Fixed | 15.79%  |
| Solved | 9.94%  |
| Timeout | 23.98%  |

New Flutterfire issues triaged 25, closed 11 (44%)

In total closed 13 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 8  |
| Duplicate | 3  |
| User issue | 2  |

## 2021-05-07

### Notable issues

* Portrait images with EXIF metadata distorted on flutter web with canvasKit renderer [#81679](https://github.com/flutter/flutter/issues/81679)
* "flutter build bundle --release" fails with IconTreeShakerException [#81954](https://github.com/flutter/flutter/issues/81954)
* Allow inner scrollables to surrender in gesture arena [#81648](https://github.com/flutter/flutter/issues/81648)
* Allow platform specific dependencies [#81650](https://github.com/flutter/flutter/issues/81650)
* [crowd] Error while trying flutter doctor --android-licenses [#80273](https://github.com/flutter/flutter/issues/80273) - this is still getting lots of duplicates
* [tool_crash] ArgumentError: Invalid argument(s): Cannot find executable [#60880](https://github.com/flutter/flutter/issues/60880) - still getting duplicates

### Issue counts

New Flutter issues triaged 202, closed 59 (29%)

We're also reworking the [p: maps issues](https://github.com/flutter/flutter/issues?q=is%3Aopen+label%3A%22p%3A+maps%22+sort%3Acreated-asc+-label%3A%22found+in+release%3A+2.0%22+-label%3A%22found+in+release%3A+2.1%22+-label%3A%22found+in+release%3A+2.2%22+-label%3A%22found+in+release%3A+2.3%22+-label%3A%22waiting+for+customer+response%22+)

In total closed 168 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 36.31%  |
| Duplicate  | 16.67%  |
| Fixed | 6.55%  |
| Solved | 6.55%  |
| Timeout | 33.93%  |

New Flutterfire issues triaged 33, closed 14 (42%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 5  |
| Duplicate | 7  |
| User issue | 3  |

## 2021-04-30

### Notable issues

* [web] Password manager icon overlaps the text in TextField [#81201](https://github.com/flutter/flutter/issues/81201)
* [Add2App] Release app doesn't display the flutter view [#81350](https://github.com/flutter/flutter/issues/81350)
* Waiting for observatory port to be available... stuck forever [#81415](https://github.com/flutter/flutter/issues/81415)
* Add HoverGestureRecognizer so TextSpan can detect hover events [#81159](https://github.com/flutter/flutter/issues/81159)

### Issue counts

New Flutter issues triaged 214, closed 58 (27%)

In total closed 126 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 46.8%  |
| Duplicate  | 14.2%  |
| Fixed | 11.9%  |
| Solved | 8.7%  |
| Timeout | 18.2%  |

New Flutterfire issues triaged 40, closed 21 (53%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 19  |
| Duplicate | 2  |

## 2021-04-23

### Notable issues

* [Android] App gets stuck upon performing hot reload [#80704](https://github.com/flutter/flutter/issues/80704)
* [Android][Samsung Keyboard] Backspace does not delete the text/characters containing spaces in TextFormField [#80938](https://github.com/flutter/flutter/issues/80938)
* [crowd] Keyboard doesn't pop up when focusing on Android Platform view that includes text fields [#80961](https://github.com/flutter/flutter/issues/80961)
* ScrollBar renders incorrectly [#81027](https://github.com/flutter/flutter/issues/81027)
* Null check operator used on a null value - BottomAppBar's shape [#80878](https://github.com/flutter/flutter/issues/80878)
* Scrollbar thumbs aren't selectable when semi-transparent [#81015](https://github.com/flutter/flutter/issues/81015)
* TextField with TextDirection.rtl has misplaced cursor on Web [#78550](https://github.com/flutter/flutter/issues/78550) (issue is still active)

### Issue counts

New Flutter issues triaged 216, closed 60 (28%)

In total closed 179 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 34.6%  |
| Duplicate  | 14.5%  |
| Fixed | 12.8%  |
| Solved | 10.6%  |
| Timeout | 27.4%  |

New Flutterfire issues triaged 32, closed 14 (44%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 7  |
| Duplicate | 3  |
| Solved | 4  |

## 2021-04-16

### Notable issues

* Janky scrolling on iOS when resuming from background/presenting an Add2App ViewController [#80367](https://github.com/flutter/flutter/issues/80367)
* [image_picker] Image picker is incompatible with Google Play's new storage requirement [#80502](https://github.com/flutter/flutter/issues/80502)
* MediaQuery.of(context).viewInsets.bottom has unexpected value when keyboard is opened/closed [#80253](https://github.com/flutter/flutter/issues/80253)
* BackButton is not displayed when there is a endDrawer [#80256](https://github.com/flutter/flutter/issues/80256)
* [image_picker] Image rotates 90 degrees on iOS 14 with "Select Photos" access [#80428](https://github.com/flutter/flutter/issues/80428)
* [crowd, reopened] integration_test file not found [#72876](https://github.com/flutter/flutter/issues/72876)

### Issue counts

New Flutter issues triaged 238, closed 70 (29%)

In total closed 192 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 35.42%  |
| Duplicate  | 14.58%  |
| Fixed | 11.46%  |
| Solved | 9.38%  |
| Timeout | 29.17%  |

New Flutterfire issues triaged 33, closed 19 (58%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 17  |
| Fixed | 1  |
| Solved | 1  |

## 2021-04-09

### Notable issues

* [crowd][web][canvaskit] Scrollable emoji freezes the app and locks the scroll [#79882](https://github.com/flutter/flutter/issues/79882)
* [null safety] “Reload not performed Analysis issues found” on IntelliJ / Android Studio [#80040](https://github.com/flutter/flutter/issues/80040)
* [crowd] Gradient -> LinearGradient -> GradientRotation not working [#79980](https://github.com/flutter/flutter/issues/79980)
* TextField with inputFormatters and keyboardType onChange infinite loop on iOS [#79844](https://github.com/flutter/flutter/issues/79844)

### Issue counts

New Flutter issues triaged 236, closed 80 (34%)

In total closed 214 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 30.84%  |
| Duplicate  | 17.29%  |
| Fixed | 8.88%  |
| Solved | 5.14%  |
| Timeout | 37.85%  |

New Flutterfire issues triaged 35, closed 9 (26%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 3  |
| Duplicate | 5  |
| Fixed | 1  |

## 2021-04-01

### Notable issues

* App crashes when TextField setObscure is true [#79447](https://github.com/flutter/flutter/issues/79447)
* Up and down arrow keys miscalculate the cursor position in a TextField [#79305](https://github.com/flutter/flutter/issues/79305)
* SelectableText background overlays the selection [#79168](https://github.com/flutter/flutter/issues/79168)
* Some official examples do not work with null safety or without null safety, e.g [#79395](https://github.com/flutter/flutter/issues/79395), [#79376](https://github.com/flutter/flutter/issues/79376)

### Issue counts

New Flutter issues triaged 214, closed 65 (30%)

In total closed 158 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 36.08%  |
| Duplicate  | 21.52%  |
| Fixed | 8.86%  |
| Solved | 8.86%  |
| Timeout | 24.68%  |

New Flutterfire issues triaged 25, closed 7 (28%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 5  |
| Duplicate | 1  |
| Solved  | 1  |

## 2021-03-26

### Notable issues

* Web app crashes after selecting text that has emojis in it [#79105](https://github.com/flutter/flutter/issues/79105)
* Web canvaskit: App rebuilds while resizing the window [#79065](https://github.com/flutter/flutter/issues/79065)
* [image_picker] Issue with iOS simulator: Not able to select image on Mac M1 [#78391](https://github.com/flutter/flutter/issues/78391)
* TextField onChanged method gets invoked twice on API 26 and 27 [#78762](https://github.com/flutter/flutter/issues/78762)
* Flutter iOS is not generating GeneratedPluginRegistrant on Flutter 2.1.0-12.2.pre [#78785](https://github.com/flutter/flutter/issues/78785)
* MultiFlutterEngine on iOS consumes a lot of memory [#79023](https://github.com/flutter/flutter/issues/79023)

### Issue counts

New Flutter issues triaged 278, closed 92 (33%)

In total closed 188 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 40.43%  |
| Duplicate  | 22.34%  |
| Fixed | 9.04%  |
| Solved | 9.04%  |
| Timeout | 19.15%  |

New Flutterfire issues triaged 33, closed 17 (52%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 6  |
| Duplicate | 4  |
| Fixed  | 1  |
| Solved  | 6  |


## 2021-03-19

### Notable issues

* App crashes upon launch using Xcode on simulator on dev [#78418](https://github.com/flutter/flutter/issues/78418)
* Hot restart takes time to update in release mode after making changes to file [#78239](https://github.com/flutter/flutter/issues/78239)
* Can't build web apps with CanvasKit without internet [#78235](https://github.com/flutter/flutter/issues/78235)
* FlutterError.onError is not called when framework throws an error [#78503](https://github.com/flutter/flutter/issues/78503)
* [webview_flutter] webview hides behind other widgets in a column when scrolling down on iOS [#78383](https://github.com/flutter/flutter/issues/78383)

### Issue counts

New Flutter issues triaged 317, closed 95 (30%)

In total closed 189 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 36.5%  |
| Duplicate  | 23.3%  |
| Fixed | 10.6%  |
| Solved | 12.2%  |
| Timeout | 17.5%  |

New Flutterfire issues triaged 43, closed 29 (67%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 13  |
| Duplicate | 10  |
| Fixed  | 1  |
| Solved  | 5  |

## 2021-03-12

### Notable issues

* Web app gets stuck on Performing Hot Restart on latest stable, but works on latest master [#77818](https://github.com/flutter/flutter/issues/77818)
* PopupMenu Overlay misplaces when resizing window (web, desktop) [#77915](https://github.com/flutter/flutter/issues/77915)
* setSystemUIOverlayStyle() documentation sample does not work on iOS [#77904](https://github.com/flutter/flutter/issues/77904)
* Unable to run with --no-sound-null-safety on iOS [#77912](https://github.com/flutter/flutter/issues/77912)
* [web] Flutter app on web-server doesn’t respond on iOS 13.1, doesn’t load on 13.4 on stable channel and doesn’t load on both versions on dev and master channel [#77792](https://github.com/flutter/flutter/issues/77792)
* http request crashes on iOS 10 with Flutter 2 [#77808](https://github.com/flutter/flutter/issues/77808)
* Proposal: Custom (non gregorian) calendar in showDatePicker [#77531](https://github.com/flutter/flutter/issues/77531)
* TextField cursor gets stuck on web [#77929](https://github.com/flutter/flutter/issues/77929)

### Issue counts

New Flutter issues triaged 339, closed 124 (37%)

In total closed 229 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 42.36%  |
| Duplicate  | 20.96%  |
| Fixed | 7.42%  |
| Solved | 10.4%  |
| Timeout | 19.21%  |

New Flutterfire issues triaged 60, closed 39 (65%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 19  |
| Duplicate | 15  |
| Fixed  | 1  |
| Solved  | 4  |

## 2021-03-05

### Notable issues

* [image_picker] GIF doesn't work on iOS 14 when user chooses "Select Photos" [#77281](https://github.com/flutter/flutter/issues/77281)
* Talkback doesn’t read hyperlinked text when used with SelectableText.rich widget [#77219](https://github.com/flutter/flutter/issues/77219)
* Flutter 2.0 web can not show some Chinese characters properly using canvaskit renderer [#77212](https://github.com/flutter/flutter/issues/77212)
* [web] wrong image filter on web app built with HTML renderer [#76966](https://github.com/flutter/flutter/issues/76966)
* Unable to run flutter 2 in mac desktop for a completely new project [#77325](https://github.com/flutter/flutter/issues/77325)

### Issue counts

New Flutter issues triaged 259, closed 93 (36%)

In total closed 166 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 45.18%  |
| Duplicate  | 26.51%  |
| Fixed | 7.83%  |
| Solved | 9.64%  |
| Timeout | 10.84%  |

New Flutterfire issues triaged 37, closed 25 (68%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 14  |
| Duplicate | 7  |
| Solved  | 4  |


## 2021-02-26

### Notable issues

* RenderRepaintBoundary.toImage throws operation failed exception on Stable, but shows NoSuchMethodError on Master [#76591](https://github.com/flutter/flutter/issues/76591)
* Clearing a textfield shows Snapshot warning log on iOS using physical device [#76798](https://github.com/flutter/flutter/issues/76798)
* integration_test throws TickerException while trying to open modalBottomSheet [#76786](https://github.com/flutter/flutter/issues/76786)
* [canvaskit] font renders missing glyph when text overflow is ellipsis [#76473](https://github.com/flutter/flutter/issues/76473)
* Need better, clearer image filter quality controls [#76737](https://github.com/flutter/flutter/issues/76737)
* [web] Debug mode is paused when launched from IntelliJ/Android Studio [#76680](https://github.com/flutter/flutter/issues/76680)
* EXC_BAD_ACCESS KERN_INVALID_ADDRESS - CRASH [#76694](https://github.com/flutter/flutter/issues/76694)
* Painter slowing down initially [#76859](https://github.com/flutter/flutter/issues/76859)

### Issue counts

New Flutter issues triaged 231, closed 84 (36%)

In total closed 181 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 37.02%  |
| Duplicate  | 16.02%  |
| Fixed | 7.73%  |
| Solved | 9.39%  |
| Timeout | 29.83%  |

New Flutterfire issues triaged 32, closed 19 (59%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 11  |
| Duplicate | 7  |
| Solved  | 1  |

## 2021-02-19

### Notable issues

* iOS Metal jank example [#76180](https://github.com/flutter/flutter/issues/76180)
* Camera Plugin Stream is rotated 90 degree CCW on iPhone since 0.7.0 [#76210](https://github.com/flutter/flutter/issues/76210)
* [file_selector_web] cannot read files larger than ~500MB [#76036](https://github.com/flutter/flutter/issues/76036)
* [web] make initial load of canvaskit faster [#76009](https://github.com/flutter/flutter/issues/76009)

### Issue counts

New Flutter issues triaged 251, closed 91 (36%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 52.7%  |
| Duplicate  | 30.8%  |
| Fixed | 3.3%  |
| Solved | 13.2%  |

Issues closed from iterations 77

| Reason for closing  |  |
| -- | -- |
| Invalid | 14.3%  |
| Duplicate  | 14.3%  |
| Fixed | 18.2%  |
| Solved | 16.9%  |
| Timeout | 36.4%  |

Stale issues

Checking labeled issues without the `has reproducible steps` label. Total checked 34, closed 5 (15%)

| Reason for closing  |  |
| -- | -- |
| Invalid| 3 |
| Duplicate | 2  |

New Flutterfire issues triaged 23, closed 10 (43%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 5  |
| Duplicate | 4  |
| Solved  | 1  |

## 2021-02-12

### Notable issues

* Specific to latest update on Samsung devices (One UI 3): screen flickers while opening and closing keyboard [#75520](https://github.com/flutter/flutter/issues/75520)
* Text not rendering on web. Specific to Win 7 + FireFox + graphics card setup. [#75327](https://github.com/flutter/flutter/issues/75327)
* TextInputType.phone keyboard doesn't delete typed text when the keyboard is switched to extra symbols on Android [#75616](https://github.com/flutter/flutter/issues/75616)
* Crowd: Crashing on launch when updating Android Gradle Plugin to 4.0.0 using app bundle [#58479](https://github.com/flutter/flutter/issues/58479)
* Reopened: [google_maps_flutter] App crashes when using maps in release mode [#69820](https://github.com/flutter/flutter/issues/69820)

### Issue counts

New Flutter issues triaged 253, closed 79 (31%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 53.2%  |
| Duplicate  | 36.7%  |
| Fixed | 7.6%  |
| Solved | 2.5%  |

Issues closed from iterations 89

| Reason for closing  |  |
| -- | -- |
| Invalid | 15.9%  |
| Duplicate  | 1.1%  |
| Fixed | 25.0%  |
| Solved | 10.2%  |
| Timeout | 47.7%  |

Stale issues

Checking [image_picker](https://github.com/flutter/flutter/issues?q=is%3Aissue+is%3Aopen+label%3A%22p%3A+image_picker%22) issues. Total checked 64, closed 24 (38%)

| Reason for closing  |  |
| -- | -- |
| Invalid| 1  |
| Duplicate | 6  |
| Fixed | 16  |
| Solved  | 1  |

New Flutterfire issues triaged 31, closed 14 (45%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 5  |
| Duplicate | 6  |
| Solved  | 3  |

## 2021-02-05

### Notable issues

* Reopened: Flutter Application freezes when Maximized or Restored from Minimized window mode [#74797](https://github.com/flutter/flutter/issues/74797)
* [windows] Hot reload from terminal throws an exception on dev channel [#75419](https://github.com/flutter/flutter/issues/75419)
* [web] UnimplementedError when using SliderTheme [#75495](https://github.com/flutter/flutter/issues/75495)
* [web] Dragging the "draggable" widget causes widget to freeze in the overlay layer [#75280](https://github.com/flutter/flutter/issues/75280)
* Scrolling using Scrollbar widget with ListView.builder is significantly slower [#75399](https://github.com/flutter/flutter/issues/75399)
* Proposal: [integration_test] - Support tags in integration test package [#75496](https://github.com/flutter/flutter/issues/75496)

### Issue counts

New Flutter issues triaged 300, closed 89 (30%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 58.6%  |
| Duplicate  | 33.3%  |
| Fixed | 2.3%  |
| Solved | 5.7%  |

Issues closed from iterations 63

| Reason for closing  |  |
| -- | -- |
| Invalid | 23.8%  |
| Duplicate  | 9.5%  |
| Fixed | 30.2%  |
| Solved | 22.2%  |
| Timeout | 14.3%  |

Stale issues

Finished with ([issues found to occur in releases 1.12 and 1.17](https://github.com/flutter/flutter/issues?q=is%3Aissue+is%3Aopen+label%3A%22has+reproducible+steps%22+-label%3A%22found+in+release%3A+1.22%22+-label%3A%22found+in+release%3A+1.23%22+-label%3A%22found+in+release%3A+1.24%22+-label%3A%22found+in+release%3A+1.25%22+-label%3A%22passed+first+triage%22+-label%3A%22severe%3A+new+feature%22+-label%3Aproposal+-label%3A%22found+in+release%3A+1.21%22+-label%3A%22found+in+release%3A+1.20%22+-label%3A%22found+in+release%3A+1.26%22+)) and started with [image_picker](https://github.com/flutter/flutter/issues?q=is%3Aissue+is%3Aopen+label%3A%22p%3A+image_picker%22) issues. Total checked 40, closed 8 (20%)

| Reason for closing  |  |
| -- | -- |
| Fixed | 7  |
| Solved  | 1  |

New Flutterfire issues triaged 51, closed 16 (31%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 7  |
| Duplicate | 8  |
| Solved  | 1  |

## 2021-01-29

### Notable issues

* Camera throws TimeoutException when flash is turned ON: [#74645](https://github.com/flutter/flutter/issues/74645)
* Null safety checks occur while running flutter test on beta: [#74898](https://github.com/flutter/flutter/issues/74898)
* App goes black when there is a system dialog and locking/unlocking on Android: [#74801](https://github.com/flutter/flutter/issues/74801)
* Text selection from right to left inside text fields is broken on Web: [#74504](https://github.com/flutter/flutter/issues/74504)
* Auto scroll not working with textField when showCursor is false: [#74566](https://github.com/flutter/flutter/issues/74566)

### Issue counts

New Flutter issues triaged 261, closed 90 (34%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 53.9%  |
| Duplicate  | 30.3%  |
| Fixed | 9.0%  |
| Solved | 6.7%  |

Issues closed from iterations 81

| Reason for closing  |  |
| -- | -- |
| Invalid | 13.6%  |
| Duplicate  | 8.6%  |
| Fixed | 16.0%  |
| Solved | 11.1%  |
| Timeout | 50.6%  |

Stale issues ([found to occur in releases 1.12 and 1.17](https://github.com/flutter/flutter/issues?q=is%3Aissue+is%3Aopen+label%3A%22has+reproducible+steps%22+-label%3A%22found+in+release%3A+1.22%22+-label%3A%22found+in+release%3A+1.23%22+-label%3A%22found+in+release%3A+1.24%22+-label%3A%22found+in+release%3A+1.25%22+-label%3A%22passed+first+triage%22+-label%3A%22severe%3A+new+feature%22+-label%3Aproposal+-label%3A%22found+in+release%3A+1.21%22+-label%3A%22found+in+release%3A+1.20%22+-label%3A%22found+in+release%3A+1.26%22+)) checked 55, closed 11 (20%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 2 |
| Fixed | 6 |
| Solved | 3 |

New Flutterfire issues triaged 34, closed 15 (44%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 5  |
| Duplicate  | 5  |
| Solved  | 5  |

## 2021-01-22

### Notable issues

* Decoding image data is failing on web: [#74489](https://github.com/flutter/flutter/issues/74489)
* [webview_flutter] Simulator keyboard isn’t showing and hardware keyboard isn’t working: [#74044](https://github.com/flutter/flutter/issues/74044)
* Enter/return key on a TextField with InkWell doesn’t work on the Samsung keyboard: [#74041](https://github.com/flutter/flutter/issues/74041)
* Avoid reading clipboard without authorization when using textfield on Xiaomi MIUI 12: [#74139](https://github.com/flutter/flutter/issues/74139)
* Some users are experiencing issues with third-party packages that rely on `flutter_localizations` and `intl` on beta and above channels, they are forced to use `stable` channel to avoid package conflicts. This is caused by premature `flutter_localizations` dependency on the null-safety version of the `intl`. E.g. [#74421](https://github.com/flutter/flutter/issues/74421), [#74419](https://github.com/flutter/flutter/issues/74419), [#73861](https://github.com/flutter/flutter/issues/73861)

### Issue counts

New Flutter issues triaged 274, closed 85 (31%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 58.8%  |
| Duplicate  | 35.3%  |
| Fixed | 2.4%  |
| Solved | 3.5%  |

Issues closed from iterations 93

| Reason for closing  |  |
| -- | -- |
| Invalid | 16.1%  |
| Duplicate  | 7.5%  |
| Fixed | 32.3%  |
| Solved | 10.8%  |
| Timeout | 33.3%  |

Stale issues ([found to occur in releases 1.12 and 1.17](https://github.com/flutter/flutter/issues?q=is%3Aissue+is%3Aopen+label%3A%22has+reproducible+steps%22+-label%3A%22found+in+release%3A+1.22%22+-label%3A%22found+in+release%3A+1.23%22+-label%3A%22found+in+release%3A+1.24%22+-label%3A%22found+in+release%3A+1.25%22+-label%3A%22passed+first+triage%22+-label%3A%22severe%3A+new+feature%22+-label%3Aproposal+-label%3A%22found+in+release%3A+1.21%22+-label%3A%22found+in+release%3A+1.20%22+-label%3A%22found+in+release%3A+1.26%22+)) checked 70, closed 11 (16%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 3 |
| Duplicate | 3 |
| Fixed | 4 |
| Solved | 1 |

New Flutterfire issues triaged 41, closed 13 (32%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 6  |
| Duplicate  | 4  |
| Solved  | 3  |

## 2021-01-15

### Notable issues

* Disable analytics by default - Respect EU/ECC laws (GDPR): [#73657](https://github.com/flutter/flutter/issues/73657)
* Flutter Slider Label showing strange numbers: [#73787](https://github.com/flutter/flutter/issues/73787)
* Flutter doctor warnings about flutter plugin not found still cause confusion among users (related to [[flutter_tools] IDE plugin validators should be deprecated](https://github.com/flutter/flutter/issues/61246))
* There have been several issues related to Windows 7 recently

### Issue counts

New Flutter issues triaged 269, closed 86 (32%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 62.8%  |
| Duplicate  | 26.7%  |
| Fixed | 4.7%  |
| Solved | 5.8%  |

Issues closed from iterations 80

| Reason for closing  |  |
| -- | -- |
| Invalid | 21.3%  |
| Duplicate  | 10.0%  |
| Fixed | 37.5%  |
| Solved | 8.8%  |
| Timeout | 22.5%  |

Stale issues ([found to occur in releases 1.12 and 1.17](https://github.com/flutter/flutter/issues?q=is%3Aissue+is%3Aopen+label%3A%22has+reproducible+steps%22+-label%3A%22found+in+release%3A+1.22%22+-label%3A%22found+in+release%3A+1.23%22+-label%3A%22found+in+release%3A+1.24%22+-label%3A%22found+in+release%3A+1.25%22+-label%3A%22passed+first+triage%22+-label%3A%22severe%3A+new+feature%22+-label%3Aproposal+-label%3A%22found+in+release%3A+1.21%22+-label%3A%22found+in+release%3A+1.20%22+-label%3A%22found+in+release%3A+1.26%22+)) checked 39, closed 5 (13%) --- most issues are still reproducible with the latest versions

| Reason for closing  |  |
| -- | -- |
| Duplicate | 2 |
| Fixed | 3 |

New Flutterfire issues triaged 29, closed 6 (21%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 3  |
| Duplicate  | 3  |

## 2021-01-08

### Notable issues

* Holding backspace in textfield stops sporadically on Samsung devices: [#73433](https://github.com/flutter/flutter/issues/73433)
* Play Console Crash - abort / signal 11 (SIGSEGV), code 1 (SEGV_MAPERR): [#73342](https://github.com/flutter/flutter/issues/73342)
* [web] DateTime.microsecondsSinceEpoch on Flutter web is different compared to Flutter mobile: [#73334](https://github.com/flutter/flutter/issues/73334)
* [Image_Picker] does not load images in release mode and throws PlatformException on second tentative: [#72759](https://github.com/flutter/flutter/issues/72759)

### Issue counts

New Flutter issues triaged 237, closed 78 (33%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 53.8%  |
| Duplicate  | 33.3%  |
| Fixed | 3.8%  |
| Solved | 9.0%  |

Issues closed from iterations 116

| Reason for closing  |  |
| -- | -- |
| Invalid | 18.3%  |
| Duplicate  | 5.2%  |
| Fixed | 13.9%  |
| Solved | 9.6%  |
| Timeout | 53.0%  |

Stale issues ([found to occur in releases 1.12 and 1.17](https://github.com/flutter/flutter/issues?q=is%3Aissue+is%3Aopen+label%3A%22has+reproducible+steps%22+-label%3A%22found+in+release%3A+1.22%22+-label%3A%22found+in+release%3A+1.23%22+-label%3A%22found+in+release%3A+1.24%22+-label%3A%22found+in+release%3A+1.25%22+-label%3A%22passed+first+triage%22+-label%3A%22severe%3A+new+feature%22+-label%3Aproposal+-label%3A%22found+in+release%3A+1.21%22+-label%3A%22found+in+release%3A+1.20%22+-label%3A%22found+in+release%3A+1.26%22+)) checked 33, closed 8 (24%)

| Reason for closing  |  |
| -- | -- |
| Duplicate | 1 |
| Fixed | 7 |

New Flutterfire issues triaged 27, closed 6 (22%)

| Reason for closing  |  |
| -- | -- |
| Invalid | 4  |
| Duplicate  | 1  |
| Solved | 1 |