## 2022-12-30

### Notable issues

- [go_router] location does not update properly when .go() is called for more than two depth [#117671](https://github.com/flutter/flutter/issues/117671)

### Old Issues receiving attention lately

No issues to report this week

### Issue counts

#### Flutter

New Flutter issues triaged 113, closed 37 (32.74%).

In total closed 78 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 19.2% |
| Fixed | 30.8% |
| Invalid | 43.6% |
| Solved | 6.41% |

Issues closed due to inactivity:  21

#### Flutter/website

New website issues triaged 8, closed 0 (0%)

In total closed 7 issue during the week

| Reason for closing  |  |
| -- | -- |
| Fixed | 100% |


#### dart-lang/site-www

No issues triaged during the week

#### Googleads-mobile-flutter

No issues triaged during the week

#### Flutterfire

New Flutterfire issues triaged 12, closed 3 (25%).

In total closed 25 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 10.5% |
| fixed | 31.6% |
| invalid | 10.5% |
| no-response | 26.3% |
| solution-provided | 15.8% |
| user issue | 5.3% |


## 2022-12-23

### Notable issues

No notable issues this week

### Old Issues receiving attention lately

No notable issues this week

### Issue counts

#### Flutter

New Flutter issues triaged 143, closed 42 (29.37%).

In total closed 85 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 21.2% |
| Fixed | 37.6% |
| Invalid | 32.9% |
| Solved | 8.2% |

Issues closed due to inactivity:  34

#### Flutter/website

New website issues triaged 2, closed 1 (50%)

In total closed 1 issue during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 100% |


#### dart-lang/site-www

New dart website issues triaged 0, closed 0 (0%)

No issues closed during the week

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 3, closed 1 (33.33%).

In total closed 1 issue during the week

| Reason for closing | |
| -- | -- |
| Invalid | 100% |


#### Flutterfire

New Flutterfire issues triaged 19, closed 3 (15.79%).

In total closed 18 issues during the week.

| Reason for closing  |  |
| -- | -- |
| fixed | 5.56% |
| invalid | 27.78% |
| no-response | 38.89% |
| solution-provided | 16.67% |
| user issue | 11.11% |

## 2022-12-16

### Notable issues

No notable issues this week

### Old Issues receiving attention lately

- Android crash: Fatal Exception: java.lang.RuntimeException java.util.concurrent.ExecutionException: java.lang.UnsatisfiedLinkError: dalvik.system.PathClassLoader[DexPathList[[zip file "/system/framework/android.test.runner.jar", zip file "/system/framework/org.apache.http.legacy.boot.jar"........ [#83596](https://github.com/flutter/flutter/issues/83596)

### Issue counts

#### Flutter

New Flutter issues triaged 157, closed 49 (31.21%).

In total closed 108 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 22.2% |
| Fixed | 35.2% |
| Invalid | 32.4% |
| Solved | 10.2% |

Issues closed due to inactivity:  22

#### Flutter/website

New website issues triaged 7, closed 2 (28.57%)

In total closed 2 issues during the week

| Reason for closing  |  |
| -- | -- |
| Duplicate | 50% |
| Invalid | 50% |


#### dart-lang/site-www

New dart website issues triaged 0, closed 0 (0%)

No issues closed during the week

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 0, closed 0 (0.0%).

In total closed 2 issues during the week

| Reason for closing | |
| -- | -- |
| Duplicate | 50% |
| Solved | 50% |


#### Flutterfire

New Flutterfire issues triaged 23, closed 4 (17.39%).

In total closed 11 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 27.27% |
| fixed | 18.18% |
| invalid | 9.09% |
| no-response | 36.36% |
| user issue | 9.09% |


## 2022-12-09

### Notable issues

- Access violation in flutter_windows.dll when calling `FlutterEngine::Run` [#116753](https://github.com/flutter/flutter/issues/116753)

### Old Issues receiving attention lately

- [camera] Android 13 crash when initializing camera - This issue has been getting a bit of traction recently and as per Play Store guidelines, apps should target API 33 by August 2023. This issue prevents apps using `camera` to update their targetSdk to 33 [#109769](https://github.com/flutter/flutter/issues/109769)

### Issue counts

#### Flutter

New Flutter issues triaged 157, closed 55 (35.03%).

In total closed 114 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 23.7% |
| Fixed | 29.8% |
| Invalid | 33.3% |
| Solved | 13.2% |

Issues closed due to inactivity:  28

#### Flutter/website

New website issues triaged 4, closed 0 (0.00%)

In total closed 17 issues during the week

| Reason for closing  |  |
| -- | -- |
| Fixed | 100% |


#### dart-lang/site-www

New dart website issues triaged 0, closed 0 (0%)

No issues closed during the week

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 6, closed 1 (16.67%).

In total closed 1 issue during the week

| Reason for closing | |
| -- | -- |
| Invalid | 100% |


#### Flutterfire

New Flutterfire issues triaged 18, closed 3 (16.67%).

In total closed 16 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 6.25% |
| fixed | 37.50% |
| invalid | 12.50% |
| no-response | 31.25% |
| solution-provided | 12.50% |

## 2022-12-02

### Notable issues

No major issues to report this week.

### Old Issues receiving attention lately

No issues to report this week

### Issue counts

#### Flutter

New Flutter issues triaged 146, closed 63 (43.15%).

In total closed 120 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 32.50% |
| Fixed | 30.83% |
| Invalid | 30.83% |
| Solved | 5.83% |

Issues closed due to inactivity:  42

#### Flutter/website

New website issues triaged 7, closed 1 (14.29%)

In total closed 2 issue during the week

| Reason for closing  |  |
| -- | -- |
| Fixed | 50% |
| Duplicate | 50% |


#### dart-lang/site-www

New dart website issues triaged 1, closed 0 (0%)

No issues closed during the week

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 4, closed 1 (25%).

In total closed 1 issues during the week

| Reason for closing | |
| -- | -- |
| Invalid | 100% |


#### Flutterfire

New Flutterfire issues triaged 21, closed 4 (19.05%).

In total closed 25 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 8% |
| fixed | 44% |
| invalid | 8% |
| no-response | 20% |
| solution-provided | 16% |
| user issue | 4% |


## 2022-11-25

### Notable issues

- [go_router] Navigating back does not update router location since go_router 5.2.0 [#115832](https://github.com/flutter/flutter/issues/115832)
- [go_router] 5.2.0 `push` doesn't update the URL anymore. [#115962](https://github.com/flutter/flutter/issues/115962)
- Flutter 3.4.0+ regression in code coverage computation [#115719](https://github.com/flutter/flutter/issues/115719)

### Old Issues receiving attention lately

No issues to report this week

### Issue counts

#### Flutter

New Flutter issues triaged 170, closed 66 (38.24%).

In total closed 124 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 23.4% |
| Fixed | 32.3% |
| Invalid | 33.9% |
| Solved | 10.5% |

Issues closed due to inactivity:  34

#### Flutter/website

No issues triaged during the week

In total closed 1 issue during the week

| Reason for closing  |  |
| -- | -- |
| Fixed | 100% |


#### dart-lang/site-www

No issues triaged during the week

No issues closed during the week

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 5, closed 1 (20%).

In total closed 4 issues during the week

| Reason for closing | |
| -- | -- |
| Invalid | 75% |
| Solved | 25% |

#### Flutterfire

New Flutterfire issues triaged 17, closed 7 (41.18%).

In total closed 21 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 14.29% |
| fixed | 23.81% |
| invalid | 28.57% |
| no-response | 4.76% |
| solution-provided | 23.81% |
| user issue | 4.76% |


## 2022-11-18

### Notable issues

No issues to report for this week

### Old Issues receiving attention lately

No issues to report this week

### Issue counts

#### Flutter

New Flutter issues triaged 176, closed 66 (37.5%).

In total closed 121 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 17.36% |
| Fixed | 34.71% |
| Invalid | 40.50% |
| Solved | 7.44% |

Issues closed due to inactivity:  27

#### Flutter/website

New Flutter website issues triaged 2, closed 0 (0%).

In total closed 6 issues during the week

| Reason for closing  |  |
| -- | -- |
| Duplicate | 66.7% |
| Invalid | 33.3% |

#### dart-lang/site-www

No issues triaged during the week

No issues closed during the week

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 2, closed 0 (0%).

No issues closed during the week

#### Flutterfire

New Flutterfire issues triaged 22, closed 7 (31.82%).

In total closed 25 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 16% |
| fixed | 36% |
| invalid | 12% |
| no-response | 8% |
| solution-provided | 16% |
| user issue | 12% |


## 2022-11-11

### Notable issues

- `flutter upgrade` fails on Windows/ARM because of locked cache folder [#114753](https://github.com/flutter/flutter/issues/114753)

### Old Issues receiving attention lately

- The following assertion was thrown running a test: `'package:flutter_test/src/binding.dart': Failed assertion: line 567 pos 14: '_pendingExceptionDetails != null'` [#34499](https://github.com/flutter/flutter/issues/34499)

### Issue counts

#### Flutter

New Flutter issues triaged 184, closed 81 (44.02%).

In total closed 145 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 27.6% |
| Fixed | 25.5% |
| Invalid | 35.9% |
| Solved | 11.0% |

Issues closed due to inactivity:  28

#### Flutter/website

New Flutter website issues triaged 11, closed 1 (9.09%).

In total closed 2 issues during the week

| Reason for closing  |  |
| -- | -- |
| Duplicate | 50% |
| Invalid | 50% |



#### dart-lang/site-www

No issues triaged during the week

In total 1 issue closed during the week

| Reason for closing| |
| -- | -- |
| Duplicate | 100% |


#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 1, closed 0 (0%).

No issues closed during the week

#### Flutterfire

New Flutterfire issues triaged 27, closed 5 (18.52%).

In total closed 22 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 27.27% |
| fixed | 18.18% |
| invalid | 9.09% |
| no-response | 9.09% |
| solution-provided | 18.18% |
| user issue | 18.18% |



## 2022-11-04

### Notable issues

- [iOS] There is an error when typing Korean using the Chunjiin(Korean 10 key) keyboard [#112369](https://github.com/flutter/flutter/issues/112369)

### Old Issues receiving attention lately

-  [web][regression] text autofill doesn't work [#86497](https://github.com/flutter/flutter/issues/86497)

### Issue counts

#### Flutter

New Flutter issues triaged 177, closed 62 (35.03%).

In total closed 115 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 27.7% |
| Fixed | 18.3% |
| Invalid | 47.0% |
| Solved | 13.0% |

Issues closed due to inactivity:  31

#### Flutter/website

New Flutter website issues triaged 8, closed 1 (12.5%).

In total closed 1 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 100% |


#### dart-lang/site-www

No issues triaged during the week

No issues closed during the week


#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 5, closed 1  (20%).

In total closed 2 issues during the week

| Reason for closing | |
| -- | -- |
| solved | 100% |

#### Flutterfire

New Flutterfire issues triaged 29, closed 10 (34.48%).

In total closed 27 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 18.52% |
| fixed | 22.22% |
| invalid | 25.93% |
| no-response | 7.41% |
| solution-provided | 11.11% |
| user issue | 11.11% |
| wontfix | 3.70% |



## 2022-10-28

### Notable issues

No major issues to report for this week

### Old Issues receiving attention lately

No major issues to report this week

### Issue counts

#### Flutter

New Flutter issues triaged 146, closed 55 (37.67%).

In total closed 92 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 27.17% |
| Fixed | 28.26% |
| Invalid | 38.04% |
| Solved | 6.52% |


#### Flutter/website

New Flutter website issues triaged 3, closed 0 (%).

In total closed 1 issues during the week

| Reason for closing  |  |
| -- | -- |
| Fixed | 100% |


#### dart-lang/site-www

New Dart Websites Issues triage 1, closed 0 (0%)

No issues closed during the week


#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 5, closed 2 (40%).

In total closed 2 issues during the week

| Reason for closing | |
| -- | -- |
| duplicate | 100% |

#### Flutterfire

New Flutterfire issues triaged 25, closed 6 (24%).

In total closed 10 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 10% |
| invalid | 30% |
| solution-provided | 30% |
| user issue | 30% |


## 2022-10-21

### Notable issues

No major issues to report for this week

### Old Issues receiving attention lately

- [video_player] Better exception message on iOS devices if the video fails to play. [#56665](https://github.com/flutter/flutter/issues/56665)
- [Android][Samsung]: Tapping on special characters button from virtual keyboard triggers `CastError` [#97634](https://github.com/flutter/flutter/issues/97634)

### Issue counts

#### Flutter

New Flutter issues triaged 160, closed 67 (41.88%).

In total closed 137 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 21.2% |
| Fixed | 24.1% |
| Invalid | 29.2% |
| Solved | 10.9% |
| Timeout | 14.6% |

#### Flutter/website

New Flutter website issues triaged 8, closed 1 (12.5%).

In total closed 1 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 100% |


#### dart-lang/site-www

New Dart Websites Issues triaged 1, closed 0 (0%)

No issues closed during the week


#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 4, closed 0 (0%).

In total closed 2 issues during the week

| Reason for closing | |
| -- | -- |
| invalid | 100% |

#### Flutterfire

New Flutterfire issues triaged 20, closed 8 (40%).

In total closed 39 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 2.56% |
| fixed | 61.54% |
| invalid | 15.38%|
| no-response | 12.82% |
| solution-provided | 2.56% |
| user issue | 5.13% |


## 2022-10-14

### Notable issues

Graphical glitches during scrolling on weak Android TV devices [#113314](https://github.com/flutter/flutter/issues/113314)

### Old Issues receiving attention lately

No issues to report this week

### Issue counts

#### Flutter

New Flutter issues triaged 161, closed 52 (32.3%).

In total closed 126 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 20.6% |
| Fixed | 14.3% |
| Invalid | 40.5% |
| Solved | 11.1% |
| Timeout | 13.5% |

#### Flutter/website

New Flutter website issues triaged 3, closed 0 (0%).

In total closed 2 issues during the week

| Reason for closing  |  |
| -- | -- |
| Fixed | 100% |


#### dart-lang/site-www

No issues triaged during the week

No issues closed during the week


#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 1, closed 1 (100%).

In total closed 2 issues during the week

| Reason for closing | |
| -- | -- |
| duplicate | 50% |
| solved | 50% |

#### Flutterfire

New Flutterfire issues triaged 15, closed 4 (26.67%).

In total closed 14 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 7.14% |
| fixed | 14.29% |
| invalid | 21.43%|
| no-response | 35.71% |
| solution-provided | 14.29% |
| user issue | 7.14% |


## 2022-10-07

### Notable issues

No major issues to report this week

### Old Issues receiving attention lately

No issues to report this week

### Issue counts

#### Flutter

New Flutter issues triaged 156, closed 56 (35.9%).

In total closed 156 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 22.44% |
| Fixed | 19.23% |
| Invalid | 32.05% |
| Solved | 9.62% |
| Timeout | 16.67% |

#### Flutter/website

New Flutter website issues triaged 5, closed 0 (0%).

In total closed 1 issues during the week

| Reason for closing  |  |
| -- | -- |
| Fixed | 100% |


#### dart-lang/site-www

No issues triaged during the week

No issues closed during the week


#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 4, closed 2 (50%).

In total closed 2 issues during the week

| Reason for closing | |
| -- | -- |
| duplicate | 100% |

#### Flutterfire

New Flutterfire issues triaged 21, closed 7 (33.33%).

In total closed 16 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 12.5% |
| fixed | 18.8% |
| invalid | 25.0%|
| no-response | 18.8% |
| solution-provided | 12.5% |
| user issue | 12.5% |


## 2022-09-30

### Notable issues

No major issues to report this week

### Old Issues receiving attention lately

No issues to report this week

### Issue counts

#### Flutter

New Flutter issues triaged 170, closed 68 (40%).

In total closed 138 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 24.6% |
| Fixed | 15.2% |
| Invalid | 31.9% |
| Solved | 10.1% |
| Timeout | 18.1% |

#### Flutter/website

New Flutter website issues triaged 4, closed 1 (25%).

In total closed 7 issues during the week

| Reason for closing  |  |
| -- | -- |
| Fixed | 71.4% |
| Invalid | 28.6% |


#### dart-lang/site-www

New Dart Website issues triaged 1, closed 0 (0%).

No issues closed during the week


#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 1, closed 1 (100%).

In total closed 2 issues during the week

| Reason for closing | |
| -- | -- |
| solved | 100% |

#### Flutterfire

New Flutterfire issues triaged 19, closed 7 (36.84%).

In total closed 34 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 2.94% |
| fixed | 17.65% |
| invalid | 14.71%|
| no-response | 17,65% |
| solution-provided | 20.59% |
| user issue | 26.47% |


## 2022-09-23

### Notable issues

-  [Stable 3.3+] Rendering issues (Artefacting / Half-rendered widgets) [#111376](https://github.com/flutter/flutter/issues/111376)

### Old Issues receiving attention lately

No issues to report this week

### Issue counts

#### Flutter

New Flutter issues triaged 195, closed 77 (39.49%).

In total closed 148 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 25.7% |
| Fixed | 23.0% |
| Invalid | 29.1% |
| Solved | 11.5% |
| Timeout | 10.8% |

#### Flutter/website

New Flutter website issues triaged 6, closed 0 (0%).

In total closed 9 issues during the week

| Reason for closing  |  |
| -- | -- |
| Fixed | 88.9% |
| WontFix | 11.1% |


#### dart-lang/site-www

No issues triaged during the week

No issues closed during the week


#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 4, closed 1 (25%).

In total closed 3 issues during the week

| Reason for closing | |
| -- | -- |
| solved | 100% |

#### Flutterfire

New Flutterfire issues triaged 22, closed 6 (27.27%).

In total closed 17 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 17.65% |
| fixed | 35.29% |
| invalid | 11.76%|
| no-response | 23.53% |
| solution-provided | 5.88% |
| user issue | 5.88% |


## 2022-09-16

### Notable issues

- Signing errors on iOS Pods in XCode 14 [#111475](https://github.com/flutter/flutter/issues/111475)
- [iOS 16][video_player] Some videos only play audio with no video [#111457](https://github.com/flutter/flutter/issues/111457)
- [iOS 16] Flutter apps crash when text and emoji are combined [#111494](https://github.com/flutter/flutter/issues/111494)

### Old Issues receiving attention lately

No issues to report this week

### Issue counts

#### Flutter

New Flutter issues triaged 175, closed 77 (44%).

In total closed 142 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 23.94% |
| Fixed | 21.13% |
| Invalid | 33.10% |
| Solved | 8.45% |
| Timeout | 13.38% |

#### Flutter/website

New Flutter website issues triaged 2, closed 0 (0%).

In total closed 7 issues during the week

| Reason for closing  |  |
| -- | -- |
| Fixed | 71.4% |
| Invalid | 14.3% |
| WontFix | 14.3% |


#### dart-lang/site-www

New Dart site issues triaged 2, closed 1 (50%).

In total closed 1 issue during the week

| Reason for closing | |
| -- | -- |
| duplicate | 100% |

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 5, closed 0 (0%).

No issues closed during the week

#### Flutterfire

New Flutterfire issues triaged 31, closed 9 (29.03%).

In total closed 19 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 26.32% |
| fixed | 26.32% |
| invalid | 15.79%|
| no-response | 15.79% |
| solution-provided | 10.53% |
| user issue | 5.26% |


## 2022-09-09

### Notable issues

- Flutter 3.3.0 Fatal Exception: java.lang.AssertionError: Unexpected masked action [#111068](https://github.com/flutter/flutter/issues/111068)
- [camera] Android 13 crash when initializing camera [#109769](https://github.com/flutter/flutter/issues/109769)

### Old Issues receiving attention lately

No issues to report this week.

### Issue counts

#### Flutter

New Flutter issues triaged 169, closed 60 (35.5%).

In total closed 124 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 21.0% |
| Fixed | 19.4% |
| Invalid | 33.9% |
| Solved | 10.5% |
| Timeout | 15.3% |

#### Flutter/website

New Flutter website issues triaged 13, closed 4 (30.77%).

In total closed 21 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate | 4.76% |
| Fixed | 76.19% |
| Invalid | 19.05% |


#### dart-lang/site-www

New Dart website issues triaged 1, closed 0.

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 5, closed 2 (40%).

In total closed 3 issues during the week.

| Reason for closing | |
| -- | -- |
| Duplicate | 33.3% |
| Invalid | 33.3% |
| Solved | 33.3% |

#### Flutterfire

New Flutterfire issues triaged 24, closed 10 (41.67%).

In total closed 27 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate | 3.7%|
| Fixed | 22.2% |
| Invalid | 22.2% |
| No response | 25.9% |
| Solution provided | 22.2% |
| User issue | 3.7% |

## 2022-09-02

### Notable issues

- Text anti-aliasing broken in Flutter 3.3.0 [#110738](https://github.com/flutter/flutter/issues/110738)
- [Flutter 3.3+] App crashes when using CachedNetworkImage [#110715](https://github.com/flutter/flutter/issues/110715)
- App crashes on latest versions when `AnimatedContainer / Container`height is set to 0 and throws `uncaught exception 'NSInternalInconsistencyException', reason: 'Transformed points can't form a rect'` [#110671](https://github.com/flutter/flutter/issues/110671)

### Old issues receiving attention lately

No issues to report this week.

### Issue counts

#### Flutter

New Flutter issues triaged 186, closed 71 (38.17%).

In total closed 115 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 33.91% |
| Fixed | 21.74% |
| Invalid | 25.22% |
| Solved | 9.57% |
| Timeout | 9.57% |

#### Flutter/website

New Flutter website issues triaged 5, closed 0 (0%).

In total closed 1 issues during the week

| Reason for closing  |  |
| -- | -- |
| Fixed | 100% |


#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 3, closed 1 (33.33%).

Closed 1 issue during the week

| Reason for closing | |
| -- | -- |
| duplicate | 100% |

#### Flutterfire

New Flutterfire issues triaged 17, closed 3 (17.65%).

In total closed 8 issues during the week.

| Reason for closing  |  |
| -- | -- |
| invalid | 25%|
| no-response | 25% |
| solution-provided | 25% |
| user issue | 25% |


## 2022-08-26

### Notable issues

No issues to report this week

### Old Issues receiving attention lately

No issues to report this week

### Issue counts

#### Flutter

New Flutter issues triaged 195, closed 81 (41.54%).

In total closed 113 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 33.63% |
| Fixed | 13.27% |
| Invalid | 38.05% |
| Solved | 9.73% |
| Timeout | 5.31% |

#### Flutter/website

New Flutter website issues triaged 2, closed 0 (0%).

In total closed 1 issues during the week

| Reason for closing  |  |
| -- | -- |
| Fixed | 100% |


#### dart-lang/site-www

New Dart site issues triaged 1, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 4, closed 1 (25%).

Closed 1 issue during the week

| Reason for closing | |
| -- | -- |
| solved | 100% |

#### Flutterfire

New Flutterfire issues triaged 26, closed 9 (34.62%).

In total closed 57 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 8.77% |
| fixed | 7.02% |
| invalid | 5.26%|
| no-response | 43.86% |
| solution-provided | 19.30% |
| user issue | 15.79% |

## 2022-08-19

### Notable issues

- [Flutter 3] TextStyle foreground doesn’t render properly [#109595](https://github.com/flutter/flutter/issues/109595)
- `FilterQuality` is not working as expected for Hi-res images [#109637](https://github.com/flutter/flutter/issues/109637)

### Old Issues receiving attention lately
-  [webview_flutter][android] webview crashes when embedded in a scrollview [#104889](https://github.com/flutter/flutter/issues/104889)

### Issue counts

#### Flutter

New Flutter issues triaged 151, closed 53 (35.1%).

In total closed 116 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 22.4% |
| Fixed | 19.0% |
| Invalid | 29.3% |
| Solved | 11.2% |
| Timeout | 18.1% |

#### Flutter/website

New Flutter website issues triaged 5, closed 0 (0%).

In total closed 5 issues during the week

| Reason for closing  |  |
| -- | -- |
| Duplicate | 20% |
| Fixed | 60% |
| WontFix | 20% |


#### dart-lang/site-www

New Dart site issues triaged 1, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 2, closed 0 (0%).

No issues closed during the week

#### Flutterfire

New Flutterfire issues triaged 15, closed 4 (26.67%).

In total closed 15 issues during the week.

| Reason for closing  |  |
| -- | -- |
| fixed | 6.67% |
| invalid | 33.33%|
| no-response | 26.67% |
| solution-provided | 13.33% |
| user issue | 20.00% |


## 2022-08-12

### Notable issues

- [Android]Crash on background isolate in release mode [#109248](https://github.com/flutter/flutter/issues/109248)
- Flutter web cannot render high-resolution images which are resolution aware [#109109](https://github.com/flutter/flutter/issues/109109)
- FlutterEngineConnectionRegistry `getIntent().getBooleanExtra()` throws NullPointerException (NPE) [#109364](https://github.com/flutter/flutter/issues/109364)

### Old Issues receiving attention lately
- Nothing to report here

### Issue counts

#### Flutter

New Flutter issues triaged 126, closed 42 (33.33%).

In total closed 106 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 11.23% |
| Fixed | 24.53% |
| Invalid | 36.79% |
| Solved | 7.55% |
| Timeout | 19.81% |

#### Flutter/website

New Flutter website issues triaged 4, closed 0 (0%).

In total closed 13 issues during the week

| Reason for closing  |  |
| -- | -- |
| Duplicate | 7.69% |
| Fixed | 84.62% |
| WontFix | 7.69% |


#### dart-lang/site-www

New Dart site issues triaged 2, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 3, closed 1 (33.33%).

In total closed 1 issues during the week

| Reason for closing | |
| -- | -- |
| Duplicate | 100% |


#### Flutterfire

New Flutterfire issues triaged 23, closed 7 (30.43%).

In total closed 23 issues during the week.

| Reason for closing  |  |
| -- | -- |
| fixed | 17.4% |
| invalid | 34.8%|
| no-response | 21.7% |
| solution-provided | 8.7% |
| user issue | 17.4% |


## 2022-08-05

### Notable issues

- [Add-to-App] Flutter gradle plugin (flutter.gradle) fails the build when using AGP 7.2 [#108818](https://github.com/flutter/flutter/issues/108818)

### Old Issues receiving attention lately
- Nothing to report here

### Issue counts

#### Flutter

New Flutter issues triaged 155, closed 58 (37.42%).

In total closed 116 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 19.83% |
| Fixed | 25.86% |
| Invalid | 32.76% |
| Solved | 6.03% |
| Timeout | 15.52% |

#### Flutter/website

New Flutter website issues triaged 8, closed 1 (12.5%).

In total closed 2 issues during the week

| Reason for closing  |  |
| -- | -- |
| Invalid | 100% |


#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 6, closed 4 (66.67%).

In total closed 7 issues during the week

| Reason for closing | |
| -- | -- |
| Duplicate | 14.3% |
| Fixed | 14.3% |
| Invalid | 42.9% |
| Solved | 28.6% |


#### Flutterfire

New Flutterfire issues triaged 15, closed 6 (40%).

In total closed 11 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 27.27% |
| fixed | 9.09% |
| invalid | 9.09%|
| no-response | 18.18% |
| solution-provided | 27.27% |
| user issue | 9.09% |


## 2022-07-29

### Notable issues

- Nothing major to report this week

### Old Issues receiving attention lately

- [tool_crash] FileSystemException: Failed to decode data using encoding 'utf-8', null (Multiple duplicates have been filed in recent months)  [#65021](https://github.com/flutter/flutter/issues/65021)

### Issue counts

#### Flutter

New Flutter issues triaged 156, closed 69 (44.23%).

In total closed 128 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 27.34% |
| Fixed | 20.31% |
| Invalid | 35.94% |
| Solved | 7.03% |
| Timeout | 9.38% |

#### Flutter/website

New Flutter website issues triaged 6, closed 3 (50%).

In total closed 7 issues during the week

| Reason for closing  |  |
| -- | -- |
| Duplicate | 14.3% |
| Fixed  | 57.1% |
| Invalid | 28.6% |


#### dart-lang/site-www

New Dart site issues triaged 1, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 6, closed 1 (16.67%).

In total closed 2 issues during the week

| Reason for closing | |
| -- | -- |
| Fixed | 50% |
| Solved | 50% |


#### Flutterfire

New Flutterfire issues triaged 35, closed 10 (28.57%).

In total closed 48 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 16.67% |
| fixed | 22.92% |
| invalid | 22.92%|
| no-response | 16.67% |
| solution-provided | 18.75% |
| user issue | 2.08% |


## 2022-07-22

### Notable issues

-  [tool][add-2-app] Debug and Profile modules are generated when passing `--no-debug` and `--no-profile` flags [#108000](https://github.com/flutter/flutter/issues/108000)

### Old Issues receiving attention lately

Nothing major to report this week

### Issue counts

#### Flutter

New Flutter issues triaged 171, closed 71 (41.52%).

In total closed 142 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 21.83% |
| Fixed | 26.06% |
| Invalid | 31.69% |
| Solved | 11.97% |
| Timeout | 8.45% |

#### Flutter/website

New Flutter website issues triaged 4, closed 0 (0%).

In total closed 2 issues during the week

| Reason for closing  |  |
| -- | -- |
| Fixed  | 50% |
| Invalid | 50% |


#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 0, closed 0 (0%).

In total closed 1 issues during the week

| Reason for closing | |
| -- | -- |
| Solved | 100% |


#### Flutterfire

New Flutterfire issues triaged 43, closed 22 (51.16%).

In total closed 47 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 23.40% |
| fixed | 10.64% |
| invalid | 25.53%|
| no-response | 8.51% |
| solution-provided | 29.79% |
| user issue | 2.13% |


## 2022-07-15

### Notable issues

-  App crashes when rendering emoji text [#107509](https://github.com/flutter/flutter/issues/107509)

### Old Issues receiving attention lately

Nothing major to report this week

### Issue counts

#### Flutter

New Flutter issues triaged 165, closed 63 (38.18%).

In total closed 122 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 27.87% |
| Fixed | 26.23% |
| Invalid | 30.33% |
| Solved | 5.74% |
| Timeout | 9.84% |

#### Flutter/website

New Flutter website issues triaged 4, closed 0 (0%).

In total closed 7 issues during the week

| Reason for closing  |  |
| -- | -- |
| Fixed  | 100% |


#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 4, closed 1 (25%).

In total closed 5 issues during the week

| Reason for closing | |
| -- | -- |
| Fixed | 20% |
|Invalid  | 80% |


#### Flutterfire

New Flutterfire issues triaged 31, closed 9 (29.03%).

In total closed 24 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 12.50% |
| fixed | 4.71% |
| invalid | 45.83%|
| no-response | 20.33% |
| solution-provided | 8.33% |
| user issue | 8.33% |


## 2022-07-08

### Notable issues

Nothing major to report this week

### Old Issues receiving attention lately

Nothing major to report this week

### Issue counts

#### Flutter

New Flutter issues triaged 169, closed 72 (42.6%).

In total closed 110 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 20.00% |
| Fixed | 23.64% |
| Invalid | 40.91% |
| Solved | 7.27% |
| Timeout | 8.18% |

#### Flutter/website

New Flutter website issues triaged 5, closed 1 (20%).

In total closed 6 issues during the week

| Reason for closing  |  |
| -- | -- |
| Fixed  | 83.3% |
| Invalid | 16.7% |


#### dart-lang/site-www

New Dart site issues triaged 1, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 11, closed 2 (18.18%).

In total closed 2 issues during the week

| Reason for closing | |
| -- | -- |
| Duplicate | 100% |

#### Flutterfire

New Flutterfire issues triaged 22, closed 5 (22.73%).

In total closed 15 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 13.3% |
| fixed | 13.3% |
| invalid | 20.0%|
| solution-provided | 33.3% |
| user issue | 20.0% |


## 2022-07-01

### Notable issues

- [IOS]Image.toByteData() is super slow on Flutter 3 [#106773](https://github.com/flutter/flutter/issues/106773)

### Old Issues receiving attention lately

Nothing major to report this week

### Issue counts

#### Flutter

New Flutter issues triaged 171, closed 69 (40.35%).

In total closed 121 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 17.36% |
| Fixed | 24.79% |
| Invalid | 37.19% |
| Solved | 11.57% |
| Timeout | 9.09% |

#### Flutter/website

New Flutter website issues triaged 4, closed 2 (50%).

In total closed 6 issues during the week

| Reason for closing  |  |
| -- | -- |
| Fixed  | 66.7% |
| Invalid | 33.3% |


#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 2, closed 0 (0%).

No issues closed during the week.

#### Flutterfire

New Flutterfire issues triaged 32, closed 7 (21.88%).

In total closed 18 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 33.3% |
| fixed | 22.22% |
| invalid | 5.56%|
| no-response | 16.67% |
| solution-provided | 22.22% |

## 2022-06-17

### Notable issues

Nothing major to report this week

### Old Issues receiving attention lately

Nothing major to report this week

### Issue counts

#### Flutter

New Flutter issues triaged 177, closed 70 (39.55%).

In total closed 108 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 25.00% |
| Fixed | 12.96% |
| Invalid | 40.74% |
| Solved | 13.89% |
| Timeout | 7.41% |

#### Flutter/website

New Flutter website issues triaged 10, closed 2 (20%).

In total closed 11 issues during the week

| Reason for closing  |  |
| -- | -- |
| Fixed  | 81.8% |
| Invalid | 18.2% |


#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 4, closed 1 (25%).

In total closed 1 issue during the week.

| Reason for closing  |  |
| -- | -- |
| Solved | 100% |

#### Flutterfire

New Flutterfire issues triaged 23, closed 2 (8.7%).

In total closed 4 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 25% |
| fixed | 25% |
| invalid | 50%|


## 2022-06-10

### Notable issues
- CupertinoPageRoute affecting color of Scaffold beneath transparent Widget
 [#105738](https://github.com/flutter/flutter/issues/105738)
- Text Shadows are not working after upgrading to flutter 3 [#105546](https://github.com/flutter/flutter/issues/105546)
- [ios] Multiple Rebuild issue on opening a keyboard [#105184](https://github.com/flutter/flutter/issues/105184)
- Broken or Corrupted image cause runtime error [#105184](https://github.com/flutter/flutter/issues/105184)

### Old Issues receiving attention lately
- [Web] No autofill suggestions for new or existing save passwords and selected suggested password is not filled [#87735](https://github.com/flutter/flutter/issues/87735)

### Issue counts

#### Flutter

New Flutter issues triaged 197, closed 85 (43.15%).

In total closed 138 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 27.54% |
| Fixed | 13.77% |
| Invalid | 42.03% |
| Solved | 12.23% |
| Timeout | 4.35% |

#### Flutter/website

New Flutter website issues triaged 6, closed 1 (16.67%).

In total closed 2 issues during the week

| Reason for closing  |  |
| -- | -- |
| Fixed  | 50% |
| Invalid | 50% |


#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 6, closed 1 (16.67%).

In total closed 1 issue during the week.

| Reason for closing  |  |
| -- | -- |
| Invalid | 100% |

#### Flutterfire

New Flutterfire issues triaged 25, closed 9 (36%).

In total closed 16 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 31.25% |
| fixed | 12.50% |
| invalid | 12.50%|
| no response | 18.75% |
| solution provided | 6.25% |
| user issue | 18.75% |


## 2022-06-03

### Notable issues
- There have been several reports on this issue on various community channels. Platform views are drawn at the wrong position and don't fill the parent [#103630](https://github.com/flutter/flutter/issues/103630)

### Issue counts

#### Flutter

New Flutter issues triaged 198, closed 85 (42.93%).

In total closed 152 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 30.92% |
| Fixed | 20.39% |
| Invalid | 32.24% |
| Solved | 10.53% |
| Timeout | 5.92% |

#### Flutter/website

New Flutter website issues triaged 6, closed 0 (0%).

No issues closed during the week

#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 3, closed 1 (33.33%).

In total closed 1 issue during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate | 100% |

#### Flutterfire

New Flutterfire issues triaged 15, closed 5 (33.33%).

In total closed 18 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 22.2% |
| fixed | 16.7% |
| invalid | 11.1%|
| no response | 33.3% |
| solution provided | 16.7% |


## 2022-05-27

### Notable issues
- [android] Platform views obstruct other views on android 5.1  [#104444](https://github.com/flutter/flutter/issues/104444)

### Issue counts

#### Flutter

New Flutter issues triaged 221, closed 99 (44.8%).

In total closed 173 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 40.46% |
| Fixed | 17.34% |
| Invalid | 23.12% |
| Solved | 15.61% |
| Timeout | 3.47% |

#### Flutter/website

New Flutter website issues triaged 11, closed 5 (45.45%).

In total, closed 13 issues during the week.

| Reason for closing| |
| -- | -- |
| Duplicate| 15.38% |
| Fixed | 53.85% |
| Invalid | 23.08% |
| Wont Fix | 7.69% |

#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 5, closed 1 (20%).

In total closed 2 issue during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate | 50% |
| Fixed | 50% |

#### Flutterfire

New Flutterfire issues triaged 27, closed 5 (18.52%).

In total closed 10 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 20% |
| fixed | 20% |
| invalid | 20%|
| no response | 10% |
| solution provided | 20% |
| user issue| 10% |

## 2022-05-20

### Notable issues
- [Flutter 3.0 Web] Image.toByteData fails with error: Uncaught (in promise) Error: Failed to encode the image into bytes [#104197](https://github.com/flutter/flutter/issues/104197)
- [Flutter 3]TextPainter does not respect the height factor of text style [#104153](https://github.com/flutter/flutter/issues/104153)
- [Flutter 3] Arabic text renders incorrectly in TextSpan [#104092](https://github.com/flutter/flutter/issues/104092)
- Spellcheck on Flutter Web [#40682](https://github.com/flutter/flutter/issues/40682)
  - This is an old issue, but it has been getting some attention recently
- Dart 2.17's enums are causing issues on the web when the `name` variable is added as a property.
  - Dart-lang issue [#49021](https://github.com/dart-lang/sdk/issues/49021)
  - Reports in flutter [#104189](https://github.com/flutter/flutter/issues/104189),[#103874](https://github.com/flutter/flutter/issues/103874)


### Issue counts

#### Flutter

New Flutter issues triaged 236, closed 98 (41.53%).

In total closed 165 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 30.9% |
| Fixed | 21.8% |
| Invalid | 33.9% |
| Solved | 13.3% |

#### Flutter/website

New Flutter website issues triaged 9, closed 1 (11.11%).

In total, closed 2 issues during the week.

| Reason for closing| |
| -- | -- |
| fixed | 50% |
| invalid | 50% |

#### dart-lang/site-www

New Dart site issues triaged 1, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 2, closed 0 (0%).

In total closed 1 issue during the week.

| Reason for closing  |  |
| -- | -- |
| fixed | 100% |

#### Flutterfire

New Flutterfire issues triaged 19, closed 9 (47.37%).

In total closed 17 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 35.3% |
| fixed | 17.6% |
| invalid | 23.5%|
| no response | 11.8% |
| user issue| 11.8% |

## 2022-05-13

### Notable issues

- 'WidgetsBinding' runtime warnings using 3.0.0 stable release [#103561](https://github.com/flutter/flutter/issues/103561)
  - Other similar issues that seem to have the same root cause: [#103648](https://github.com/flutter/flutter/issues/103648), [#103614](https://github.com/flutter/flutter/issues/103614), [#103571](https://github.com/flutter/flutter/issues/103571)

### Issue counts

#### Flutter

New Flutter issues triaged 201, closed 77 (38.31%).

In total closed 110 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 38.18% |
| Fixed | 14.55% |
| Invalid | 39.09% |
| Solved | 8.18% |

#### Flutter/website

New Flutter website issues triaged 8, closed none.

#### dart-lang/site-www

No new New Dart site issues triaged. No issues closed.

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 1, closed 1 (100%).

In total closed 1 issue during the week.

| Reason for closing  |  |
| -- | -- |
| invalid | 100% |

#### Flutterfire

New Flutterfire issues triaged 31, closed 6 (19.35%).

In total closed 12 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 25.00% |
| fixed | 25.00% |
| invalid | 16.67%|
| no response | 16.67% |
| solution provided | 8.33% |
| user issue| 8.33% |

## 2022-05-06

### Notable issues

- [windows] Camera Plugin Fails to show preview with Error `Could not create external texture` [#102925](https://github.com/flutter/flutter/issues/102925)

### Issue counts

#### Flutter

New Flutter issues triaged 113, closed 42 (37.17%).

In total closed 90 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 28.3% |
| Fixed | 23.9% |
| Invalid | 39.1% |
| Solved | 8.7% |

#### Flutter/website

New Flutter website issues triaged 5, closed 2 (40%).

In total closed 3 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate | 66.7% |
| Invalid | 33.3% |

#### dart-lang/site-www

New Dart site issues triaged 1, closed 1 (100%).

In total closed 1 issue during the week

| Reason for closing  |  |
| -- | -- |
| duplicate | 100% |

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 2, closed 1 (50%).

In total closed 2 issues during the week

| Reason for closing  |  |
| -- | -- |
| invalid | 50% |
| solved | 50% |

#### Flutterfire

New Flutterfire issues triaged 22, closed 5 (22.73%).

In total closed 11 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 27.27% |
| fixed | 36.36% |
| invalid | 18.18%|
| no-response | 9.09% |
| solution-provided | 9.09% |

## 2022-04-22

### Notable issues

- [image_picker][M1 simulator] PlatformException(multiple_request, Cancelled by a second request, null, null) when picking the first default image from the ios simulator [#82602](https://github.com/flutter/flutter/issues/82602) This is an old issue that has been getting quite a bit of attention recently

### Issue counts

#### Flutter

New Flutter issues triaged 177, closed 59 (33.33%).

In total closed 108 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 20.370% |
| Fixed | 19.444% |
| Invalid | 45.370% |
| Solved | 13.889% |
| Timeout | 0.926% |

#### Flutter/website

New Flutter website issues triaged 3, closed 1 (33.33%).

In total closed 7 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate | 14.3% |
| Fixed | 71.4% |
| Invalid | 14.3% |

#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 5, closed 1 (20%).


#### Flutterfire

New Flutterfire issues triaged 14, closed 4 (28.57%).

In total closed 10 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 20% |
| invalid | 20%|
| no-response | 20% |
| solution-provided | 40% |

## 2022-04-22

### Notable issues

- [Regression][iOS]: os.activity library is broken in Flutter 2.13 [#102330](https://github.com/flutter/flutter/issues/102330)
- Can't paste into TextField when copying from Samsung Notes, MS Word, and MS Excel on Android
[#74320](https://github.com/flutter/flutter/issues/74320)
- [WEB] TextField actions are not triggered on Android [#89384](https://github.com/flutter/flutter/issues/89384)

### Issue counts

#### Flutter

New Flutter issues triaged 179, closed 61 (34.08%).

In total closed 126 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 26.2% |
| Fixed | 24.6% |
| Invalid | 34.9% |
| Solved | 14.3% |

#### Flutter/website

New Flutter website issues triaged 7, closed 1 (14.29%).

In total closed 3 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Fixed | 66.7% |
| Invalid | 33.3% |

#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 1, closed 0 (0%).


#### Flutterfire

New Flutterfire issues triaged 21, closed 8 (38.1%).

In total closed 21 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 9.52% |
| fixed  | 14.29% |
| invalid | 19.05%|
| no-response | 23.81% |
| solution-provided | 19.05% |
| user | 14.29% |

## 2022-04-14

### Notable issues

No issues to report for this week

### Issue counts

#### Flutter

New Flutter issues triaged 143, closed 58 (40.56%).

In total closed 87 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 29.89% |
| Fixed | 17.24% |
| Invalid | 47.13% |
| Solved | 5.75% |

#### Flutter/website

New Flutter website issues triaged 3, closed 1 (33.33%).

In total closed 3 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Fixed | 66.7% |
| Invalid | 33.3% |

#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 2, closed 1 (50%).

In total closed 3 issues during the week.


| Reason for closing | |
| -- | -- |
| duplicate | 33.3% |
| fixed | 33.3% |
| solved | 33.3% |

#### Flutterfire

New Flutterfire issues triaged 16, closed 4 (25%).

In total closed 13 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 23.08% |
| invalid | 23.08%|
| no-response | 38.46% |
| solution-provided | 7.69% |
| user | 7.69% |

## 2022-04-08

### Notable issues

- [WEB] Rendering issue after opening keyboard on IOS [#101288](https://github.com/flutter/flutter/issues/101288)
- Modal bottom sheets created using showModalBottomSheet get cut off by the system navigation [#101247](https://github.com/flutter/flutter/issues/101247) (This is a regression in `beta` which has been fixed on `master`)

### Issue counts

#### Flutter

New Flutter issues triaged 204, closed 86 (42.16%).

In total closed 138 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 28.261% |
| Fixed | 15.942% |
| Invalid | 41.304% |
| Solved | 13.768% |
| Timeout | 0.725% |

#### Flutter/website

New Flutter website issues triaged 5, closed 0 (0%).

In total closed 3 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Fixed | 100% |

#### dart-lang/site-www

New Dart site issues triaged 1, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 1, closed 0 (0%).

#### Flutterfire

New Flutterfire issues triaged 22, closed 5 (22.73%).

In total closed 29 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 6.90% |
| fixed | 31.03% |
| invalid | 24.14%|
| no-response | 10.34% |
| solution-provided | 24.14% |
| user | 3.45% |

## 2022-04-01

### Notable issues

- Opacity clips SingleChildScrollView content [#101110](https://github.com/flutter/flutter/issues/101110)

### Issue counts

#### Flutter

New Flutter issues triaged 193, closed 71 (36.79%).

In total closed 118 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 27.12% |
| Fixed | 21.19% |
| Invalid | 43.22% |
| Solved | 8.47% |

#### Flutter/website

New Flutter website issues triaged 6, closed 2 (33.33%).

In total closed 4 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 50% |
| Fixed | 50% |

#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 2, closed 0 (0%).

#### Flutterfire

New Flutterfire issues triaged 17, closed 4 (23.53%).

In total closed 26 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 3.85% |
| fixed | 26.92% |
| invalid | 7.69%|
| no-response | 34.62% |
| solution-provided | 15.38% |
| user | 11.54% |


## 2022-03-25

### Notable issues

- [Regression]: Scrolling through the list shows spike in performance on latest beta and master. [#100523](https://github.com/flutter/flutter/issues/100523)
- Flutter Module might not compile if they depend on a plugin which uses old kotlin version [#100613](https://github.com/flutter/flutter/issues/100613)


### Issue counts

#### Flutter

New Flutter issues triaged 179, closed 69 (38.55%).

In total closed 122 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 24.6% |
| Fixed | 21.3% |
| Invalid | 40.2% |
| Solved | 13.9% |

#### Flutter/website

New Flutter website issues triaged 8, closed 2 (25%).

In total closed 3 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 66.7% |
| Fixed | 33.3% |

#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 3, closed 2 (66.67%).

In total closed 3 issue during the week.

| Reason for closing  |  |
| -- | -- |
| fixed | 33.3% |
| invalid | 33.3% |
| solved | 33.3% |

#### Flutterfire

New Flutterfire issues triaged 16, closed 3 (18.75%).

In total closed 18 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 22.2% |
| fixed | 11.1% |
| invalid | 16.7%|
| no-response | 27.8% |
| solution-provided | 11.1% |
| user | 11.1% |


## 2022-03-18

### Notable issues

- [macOS][m1] App crashes in release mode upon app launch [#100348](https://github.com/flutter/flutter/issues/100348)
- [Windows]: Null Safety Migration tool 404 error [#100134](https://github.com/flutter/flutter/issues/100134)


### Issue counts

#### Flutter

New Flutter issues triaged 205, closed 73 (35.61%).

In total closed 114 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 21.1% |
| Fixed | 14.9% |
| Invalid | 47.4% |
| Solved | 16.7% |

#### Flutter/website

New Flutter website issues triaged 12, closed 1 (8.33%).

In total closed 9 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 11.1% |
| Fixed | 88.9% |

#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 3, closed 1 (33.33%).

In total closed 1 issue during the week.

| Reason for closing  |  |
| -- | -- |
| invalid | 100% |

#### Flutterfire

New Flutterfire issues triaged 25, closed 8 (32%).

In total closed 25 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 8% |
| fixed | 16% |
| invalid | 24%|
| no-response | 40% |
| solution-provided | 8% |
| user | 4% |



## 2022-03-11

### Notable issues

- Displaying a Material icon from a Text widget with MaterialIcons fontFamily is not working in hotfix 2.10.3 [#99808](https://github.com/flutter/flutter/issues/99808)
- TextField hint and input text go outside of given constraints. [#99914](https://github.com/flutter/flutter/issues/99914)
- [Windows][Desktop]: debug build of template app not working using VS2019. Throwing Error `waiting for a debug connection: The log reader stopped unexpectedly, or never started` [#99915](https://github.com/flutter/flutter/issues/99915)
- [Web][iOS]: Text field selection with obscuredText: true has grey selection [#99918](https://github.com/flutter/flutter/issues/99918)
- [Web]: A multiline TextFormField doesn't trigger onFieldSubmitted [#99900](https://github.com/flutter/flutter/issues/99900)


### Issue counts

#### Flutter

New Flutter issues triaged 190, closed 52 (27.37%).

In total closed 101 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 26.7% |
| Fixed | 20.8% |
| Invalid | 29.7% |
| Solved | 22.8% |

#### Flutter/website

New Flutter website issues triaged 10, closed 2 (20%).

In total closed 4 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 50% |
| Fixed | 50% |

#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 1, closed 1 (100%).

In total close 4 issue during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 50% |
| fixed | 50% |

#### Flutterfire

New Flutterfire issues triaged 24, closed 7 (29.17%).

In total closed 25 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 8% |
| fixed | 20% |
| invalid | 36%|
| no-response | 16% |
| solution-provided | 16% |
| user | 4% |



## 2022-03-04

### Notable issues

- Flutter App freezes after animating for a few seconds [#99288](https://github.com/flutter/flutter/issues/99288)


### Issue counts

#### Flutter

New Flutter issues triaged 199, closed 68 (34.17%).

In total closed 127 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 23.6% |
| Fixed | 22.8% |
| Invalid | 40.2% |
| Solved | 13.4% |

#### Flutter/website

New Flutter website issues triaged 8, closed 4 (50%).

In total closed 7 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 28.6% |
| Fixed | 42.9% |
| Invalid | 28.6% |

#### dart-lang/site-www

New Dart site issues triaged 1, closed 1 (100%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 5, closed 1 (20%).

In total close 1 issue during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 100% |

#### Flutterfire

New Flutterfire issues triaged 26, closed 8 (30.77%).

In total closed 24 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 4.17% |
| fixed | 25.00% |
| invalid | 20.83%|
| no-response | 33.33% |
| solution-provided | 16.67% |


## 2022-02-25

### Notable issues

- Using SystemChrome.setEnabledSystemUIMode in profile/release mode leads to blank screen (This only reproduces on `stable`) [#98973](https://github.com/flutter/flutter/issues/98973)
- [Android] App crashes when rotating screen with drawer open (Profile & Release) (This only reproduces on `stable`) [#98955](https://github.com/flutter/flutter/issues/98955)
- Ternary expression behaviour differs in debug mode from profile mode or release mode. A fix is in flight per [this comment](https://github.com/flutter/flutter/issues/98967#issuecomment-1050155558) [#98967](https://github.com/flutter/flutter/issues/98967)


### Issue counts

#### Flutter

New Flutter issues triaged 162, closed 70 (43.21%).

In total closed 110 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 28.2% |
| Fixed | 16.4% |
| Invalid | 42.7% |
| Solved | 12.7% |

#### Flutter/website

New Flutter website issues triaged 9, closed 2 (22.22%).

In total closed 2 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Invalid  | 100% |

#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 1, closed 0 (0%).

In total close 2 issues during the week.

| Reason for closing  |  |
| -- | -- |
| fixed | 50% |
| solved | 50% |

#### Flutterfire

New Flutterfire issues triaged 21, closed 7 (33.33%).

In total closed 10 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 20% |
| fixed | 10% |
| invalid | 40%|
| no-response | 10% |
| solution-provided | 20% |

## 2022-02-18

### Notable issues

- [ios][regression] Visual glitch when scrolling a list in a Scaffold that has a Material and Container as bottomNavigationBar  [#98739](https://github.com/flutter/flutter/issues/98739)
- Failing EditableText vertical caret movement tests [#98592](https://github.com/flutter/flutter/issues/98592)
- [android][platform_views] Views are not properly updated on Android Q [#98722](https://github.com/flutter/flutter/issues/98722)
- [windows] Crash: Can't locate continuation PC for deoptid 6 within package:flutter/src/widgets/framework.dart_StatefulElement_get__state@31042623 [#98682](https://github.com/flutter/flutter/issues/98682)
- Issue with background isolate when obfuscating Android APK / AppBundle [#98475](https://github.com/flutter/flutter/issues/98475)

### Issue counts

#### Flutter

New Flutter issues triaged 223, closed 90 (40.36%).

In total closed 146 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 33.6% |
| Fixed | 15.1% |
| Invalid | 37.7% |
| Solved | 13.7% |

#### Flutter/website

New Flutter website issues triaged 5, closed 0 (0%).

In total closed 2 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Fixed  | 100% |

#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 5, closed 0 (0%).

#### Flutterfire

New Flutterfire issues triaged 31, closed 8 (25.81%).

In total closed 14 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 21.43% |
| fixed | 7.14% |
| invalid | 35.71%|
| no-response | 14.29% |
| solution-provided | 21.43% |

## 2022-02-11

### Notable issues

- [stable 2.10] Snackbar with a BackdropFilter blurs entire screen [#98205](https://github.com/flutter/flutter/issues/98205)
- TabController does not consistently update TabBarViews when same controller is used [#98087](https://github.com/flutter/flutter/issues/98087)


### Issue counts

#### Flutter

New Flutter issues triaged 232, closed 84 (36.21%).

In total closed 136 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 30.9% |
| Fixed | 19.9% |
| Invalid | 31.6% |
| Solved | 17.6% |

#### Flutter/website

New Flutter website issues triaged 9, closed 4 (44.44%).

In total closed 4 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 25% |
| Fixed | 25% |
| Invalid | 50% |

#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 3, closed 1 (33.33%).

In total closed 2 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 50% |
| invalid | 50% |

#### Flutterfire

New Flutterfire issues triaged 25, closed 10 (40%).

In total closed 26 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 19.23% |
| fixed | 7.69% |
| invalid | 15.38%|
| no-response | 34.62% |
| solution-provided | 11.54% |
| user | 11.54% |


## 2022-02-04

### Notable issues

- [image_picker] Android application crashes with google_mobile_ads [#97267](https://github.com/flutter/flutter/issues/97267)
- [stable 2.10] New material icons are not properly rendered [#97767](https://github.com/flutter/flutter/issues/97767)
- [camera] Android 12 - camera plugin fails to take a photo, loads indefinitely [#92973](https://github.com/flutter/flutter/issues/92973)


### Issue counts

#### Flutter

New Flutter issues triaged 162, closed 70 (43.21%).

In total closed 104 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 40.4% |
| Fixed | 13.5% |
| Invalid | 35.6% |
| Solved | 10.6% |

#### Flutter/website

New Flutter website issues triaged 10, closed 3 (30%).

In total closed 2 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 33.3% |
| Invalid | 66.7% |

#### dart-lang/site-www

New Dart site issues triaged 1, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 4, closed 2 (50%).

In total closed 2 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 50% |
| invalid | 50% |

#### Flutterfire

New Flutterfire issues triaged 22, closed 8 (36.36%).

In total closed 16 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 12.5% |
| fixed | 12.5% |
| invalid | 25.0%|
| no-response | 18.8% |
| solution-provided | 18.8% |
| user | 12.5% |


## 2022-01-28

### Notable issues

- [Android] App becomes unresponsive after switching back from background [#97346](https://github.com/flutter/flutter/issues/97346)
- [video_player][IOS] VideoPlayerController.network is blocking the UI while loading [#97356](https://github.com/flutter/flutter/issues/97356)
- [Android Studio BumbleBee 2021.1.1]: flutter doctor shows `CocoaPods not installed. Skipping pod install` [#97251](https://github.com/flutter/flutter/issues/97251)


### Issue counts

#### Flutter

New Flutter issues triaged 194, closed 64 (32.99%).

In total closed 110 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 34.5% |
| Fixed | 20.0% |
| Invalid | 33.6% |
| Solved | 11.8% |

#### Flutter/website

New Flutter website issues triaged 11, closed 1 (9.09%).

In total closed 2 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 50% |
| Fixed | 50% |

#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 4, closed 1 (25%).

In total closed 2 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 100% |

#### Flutterfire

New Flutterfire issues triaged 25, closed 10 (40%).

In total closed 28 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 14.29% |
| fixed | 25.00% |
| invalid | 14.29%|
| no-response | 14.29% |
| solution-provided | 10.71% |
| user | 17.86% |
| wontfix | 3.57% |

## 2022-01-21

### Notable issues

- Invalid TextField scroll offset change on paste from toolbar [#96658](https://github.com/flutter/flutter/issues/96658)


### Issue counts

#### Flutter

New Flutter issues triaged 161, closed 58 (36.02%).

In total closed 102 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 31.4% |
| Fixed | 26.5% |
| Invalid | 29.4% |
| Solved | 12.7% |

#### Flutter/website

New Flutter website issues triaged 8, closed 4 (50%).

In total closed 5 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 80% |
| Invalid | 20% |

#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 4, closed 2 (50%).

In total closed 2 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 50% |
| solved | 50% |

#### Flutterfire

New Flutterfire issues triaged 31, closed 15 (48.39%).

In total closed 22 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 22.73% |
| fixed | 4.55% |
| invalid | 50.00%|
| no-response | 18.18% |
| user | 4.55% |


## 2022-01-14

### Notable issues

- Programmatically selecting text in unfocused textfield is not working [#96339](https://github.com/flutter/flutter/issues/96339)
- [Android] Removing Deprecated Manifest Splash results in blank screen and prevents the app from starting [#93668](https://github.com/flutter/flutter/issues/93668)

### Issue counts

#### Flutter

New Flutter issues triaged 181, closed 56 (30.94%).

In total closed 109 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 26.67% |
| Fixed | 23.9% |
| Invalid | 31.2% |
| Solved | 18.3% |

#### Flutter/website

New Flutter website issues triaged 13, closed 2 (15.38%).

In total closed 3 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 66.67% |
| Invalid | 33.3% |

#### dart-lang/site-www

New Dart site issues triaged 0, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 6, closed 3 (50%).

In total closed 5 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 80% |
| solved | 20% |

#### Flutterfire

New Flutterfire issues triaged 21, closed 2 (9.52%).

In total closed 18 issues during the week.

| Reason for closing  |  |
| -- | -- |
| duplicate | 11.1% |
| fixed | 27.8% |
| invalid | 11.1%|
| no-response | 11.1% |
| solution-provided | 11.1% |
| user | 27.8% |

## 2022-01-07

### Notable issues

- [TextField]`backgroundColor` covers/hides cursor and text selection [#96112](https://github.com/flutter/flutter/issues/96112)
- image_picker on iOS: With `Select Photos` access, selecting a different GIF than the one selected earlier won’t animate [#96263](https://github.com/flutter/flutter/issues/96263)

### Issue counts

#### Flutter

New Flutter issues triaged 152, closed 48 (31.58%).

In total closed 95 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 34.7% |
| Fixed | 15.8% |
| Invalid | 32.6% |
| Solved | 16.8% |

#### Flutter/website

New Flutter website issues triaged 7, closed 4 (57.14%).

In total closed 7 issues during the week.

| Reason for closing  |  |
| -- | -- |
| Duplicate  | 28.6% |
| Fixed | 42.9% |
| Invalid | 28.6% |

#### dart-lang/site-www

New Dart site issues triaged 1, closed 0 (0%).

#### Googleads-mobile-flutter

New Google Ads Flutter issues triaged 2, closed 1 (50%).

In total closed 1 issue during the week.

| Reason for closing  |  |
| -- | -- |
| Invalid | 100% |

#### Flutterfire

New Flutterfire issues triaged 28, closed 5 (17.86%).

In total closed 24 issues during the week.

| Reason for closing  |  |
| -- | -- |
| fixed | 41.7% |
| invalid | 12.5%|
| no-response | 12.5% |
| solution-provided | 16.7% |
| user | 16.7% |